*-----------------------------------------------------------------------
*     BASIC TEXT PRIMITIVE ON VC
*-----------------------------------------------------------------------
      SUBROUTINE SZTXWV(VX,VY,CHARS)

      CHARACTER CHARS*(*)

      PARAMETER (NCHAR=256,LEN=6000)
      PARAMETER (WIDE=24,HIGH=24)

      INTEGER   IPOSX(NCHAR)
      CHARACTER CKX(LEN)*1,CKY(LEN)*1,CBUF*80,COBJ*80

      COMMON    /SZBTX1/ IFONT,QSIZE,CT,ST,ICENTZ
      COMMON    /SZBTX2/ LCNTL,JSUP,JSUB,JRST,SMALL,SHIFT
      LOGICAL   LCNTL

      EXTERNAL  LENC,ISGC

      SAVE

      DATA      IFONTZ/0/


*     / INQUIRE FONT NUMBER /

      IF (IFONT.NE.IFONTZ) THEN

*       / THIS IS THE FIRST CALL OR FONT NUMBER WAS CHANGED /

        CALL SZFONT(IFONT,IPOSX,NCHAR,CKX,CKY,LEN)
        IFONTZ=IFONT

      END IF

*     / CHECK CHARACTER WIDTH AND HEIGHT /

      NCZ=LENC(CHARS)
      CALL SZQTXW(CHARS,NC,WXCH,WYCH)

*     / WRITE INFORMATION FOR PS DRIVER /

      CALL STFWTR(VX,VY,WX,WY)
      CBUF=' '
      NP=0
      DO 5 N=1,NCZ
        ICZ=ISGC(CHARS(N:N))
        NP=NP+1
        IF (32.LE.ICZ .AND. ICZ.LE.127 .AND. ICZ.NE.37) THEN
          CBUF(NP:NP)=CHARS(N:N)
        ELSE
          WRITE(CBUF(NP:NP+3),'(A,I3.3)') '%',ICZ
          NP=NP+3
        END IF
    5 CONTINUE
      WRITE(COBJ,'(2I8)') INT(WX),INT(WY)
      CALL CDBLK(COBJ)
      WRITE(COBJ(LENC(COBJ)+1:80),'(A)') ' "'//CBUF(1:NP)//'"'
      CALL SWOOPN('SZTXZ',COBJ)

*     / CALCULATE OFFSET VALUES /

      OFFX=-0.5*WXCH*WIDE*(ICENTZ+1)-WIDE/2
      OFFY=0.0
      XC=VX+OFFX*CT-OFFY*ST
      YC=VY+OFFX*ST+OFFY*CT

*     / INITIALIZATION /

      MODE0=0
      MODE=0
      FACTZ=1.0

*     / PROCESS EACH CHARACTER /

      DO 20 K=1,NCZ

*       / CHARACTER CONVERSION /

        IDX=ISGC(CHARS(K:K))+1
        IPS=IPOSX(IDX)+1

*       / CHECK CONTROL CHARACTERS /

        IF (LCNTL .AND.
     +    (IDX.EQ.JSUB .OR. IDX.EQ.JSUP .OR. IDX.EQ.JRST)) THEN
          IF (IDX.EQ.JSUB) THEN
            MODE=-1
            FACTZ=SMALL
          ELSE IF (IDX.EQ.JSUP) THEN
            MODE=+1
            FACTZ=SMALL
          ELSE IF (IDX.EQ.JRST) THEN
            MODE=0
            FACTZ=1.0
          END IF
          GO TO 20
        END IF

        IF (MODE0.EQ.MODE) THEN
          IF (MODE.EQ.0) THEN
            FNX=WIDE
          ELSE
            FNX=WIDE*SMALL
          END IF
          FNY=0
        ELSE
          IF (MODE0*MODE.EQ.0) THEN
            FNX=WIDE*(1+SMALL)/2
          ELSE
            FNX=WIDE*SMALL
          END IF
          FNY=HIGH*SHIFT*(MODE-MODE0)
        END IF
        MODE0=MODE

        XC=XC+FNX*CT-FNY*ST
        YC=YC+FNX*ST+FNY*CT

        CALL SZOPSV

        IP=0

   10   CONTINUE

          NX=ICHAR(CKX(IPS))-64
          FNX=NX*FACTZ
          NY=ICHAR(CKY(IPS))-64
          FNY=-NY*WIDE/HIGH*FACTZ

          IF (NX.NE.-64) THEN
            XP=XC+FNX*CT-FNY*ST
            YP=YC+FNX*ST+FNY*CT
            IF (IP.EQ.0) THEN
              CALL SZMVSV(XP,YP)
            ELSE IF (IP.EQ.1) THEN
              CALL SZPLSV(XP,YP)
            END IF
            IP=1
          ELSE
            IP=0
          END IF

          IPS=IPS+1

        IF (.NOT.(NX.EQ.-64 .AND. NY.EQ.-64)) GO TO 10

        CALL SZCLSV

   20 CONTINUE

      CALL SWOCLS('SZTXZ')

      END
