*-----------------------------------------------------------------------
*     USPACK REAL TO CHARACTER                       S. Sakai  90/03/16
*-----------------------------------------------------------------------

      SUBROUTINE USCHVL(X, CHX)

      CHARACTER CHX*(*), CFMT*16, CVAL*16, CEXP*8, CEXP2*8, CSGI*1
      REAL X
      LOGICAL LEXP, LCNTL

      CALL SGLGET('LCNTL', LCNTL)
      CALL GLRGET('REPSL', PREC)
      NPREC = -LOG10(PREC)
      IF(NPREC.GT.8) NPREC = 8

      CFMT = '(E16.xE3)'
      WRITE(CFMT(6:6), '(I1)') NPREC
      WRITE(CVAL, CFMT) X

      CFMT = '(F11.x, TR1, I4)'
      WRITE(CFMT(6:6), '(I1)') NPREC
      READ (CVAL, CFMT) XX, NEXP

*------------------------ effective digits -----------------------------

      DO 10 N=11, 4, -1
        NDIG=N
        IF(CVAL(N:N).NE.'0') GOTO 20
   10 CONTINUE
   20 CONTINUE
      NDIG = NDIG - INDEX(CVAL, '.')

*----------------------------- mantissa --------------------------------

      NLOW = NEXP - NDIG + 1
      LEXP = NEXP.LE.-3 .OR. NLOW.GE.5

      IF(LEXP) THEN
        XX = XX*10
        NPREC = NDIG - 1
      ELSE
        XX = XX*1.D1**NEXP
        NPREC = -NLOW + 1
      ENDIF

      IF(NPREC.GE.1) THEN
        CFMT = '(SP, F16.x)'
        WRITE(CFMT(10:10), '(I1)')  NPREC
        WRITE(CVAL, CFMT) XX
      ELSE
        CFMT = '(SP, I16)'
        IX = NINT(XX)
        WRITE(CVAL, CFMT) IX
      ENDIF

      CALL CLADJ(CVAL)

*-------------------------- characteristic -----------------------------

      IF(LEXP) THEN
        NEXP = NEXP - 1
        WRITE(CEXP2, '(I3)') NEXP
        CALL CLADJ(CEXP2)
        IF(LCNTL) THEN
          CEXP = CSGI(194)//'10|'//CEXP2(1:LENC(CEXP2))//'"'
        ELSE
          CEXP = 'E'//CEXP2(1:LENC(CEXP2))
        ENDIF
      ELSE
        CEXP = ' '
      ENDIF

*-----------------------------------------------------------------------

      IF(LCNTL .AND. CVAL(2:3).EQ.'1 ' .AND. CEXP.NE.'  ') THEN
        CHX = CVAL(1:1) // CEXP(2:8)
      ELSE
        CHX = CVAL(1:LENC(CVAL)) // CEXP
      ENDIF

      RETURN
      END
