*-----------------------------------------------------------------------
*   TEST PROGRAM FOR MAP PROJECTION  (LATITUDE, LONGITUDE MESH)
*-----------------------------------------------------------------------
*     TEST FOR PLOTTING VECTORS
*
      CALL GLPSET('LEPSL', .TRUE.)

      CALL SUPWSN(6)
      READ (5,*) IWS
      CALL SGOPN(IWS)

      write(*,*) 'iarlen (1 or 2 or 3)?'
      read(*,*) iarlen

      call setarl(iarlen)

      CALL SGPSET('STLAT1D',45.0)
      CALL SGPSET('STLAT2D',30.0)

      CALL TSTMAP( 10, 3.2, 'LON-LAT')

      CALL TSTMAP( 11, 3.2, 'MERCATOR')
      CALL TSTMAP( 12, 3.0, 'MOLLWEIDE')
      CALL TSTMAP( 13, 3.0, 'HAMMER')
      CALL TSTMAP( 14, 3.0, 'ECKERT 6')
      CALL TSTMAP( 15, 3.0, 'KITADA')
      CALL TSTMAP( 16, 1.1, 'ORTHOGRAPHIC')
      CALL TSTMAP( 17, 3.2, 'POLAR STEREO')
      CALL TSTMAP( 18, 3.2, 'AZIMUTHAL EQUIDISTANT')
      CALL TSTMAP( 19, 2.2, 'AZIMUTHAL EQUAL-AREA')
      CALL TSTMAP( 20, 3.2, 'CONICAL')
      CALL TSTMAP( 21, 2.4, 'CONICAL LAMBERT 1')
      CALL TSTMAP( 22, 3.2, 'CONICAL LAMBERT 2')
      CALL TSTMAP( 23, 2.0, 'BONNE (HEART)')

      CALL SGCLS
      STOP
      END
*------------------------------------------------------------------------
      SUBROUTINE TSTMAP(ITR, FAC, CTITLE)
      CHARACTER CTITLE*(*)

      RADI = 0.4/FAC 

      CALL SGSCLP(0)
      CALL SGFRM
      CALL SGSVPT( 0.1, 0.9, 0.1, 0.9)
      CALL SGSMAP(RADI, 0., 0., 130., 30., 60.)
      CALL SGSTRN(ITR)
      CALL SUPVPR(1)
      CALL SGTXZV(0.5, 0.92, CTITLE(1:LENC(CTITLE)), 0.028, 0, 0, 3)
      CALL SGSCLP(1)
      CALL SGPSET('LLNINT',.TRUE.)
      CALL SGPSET('LGCINT',.TRUE.)

c      CALL Dmesh ( -180.0, 180.0, -90.0, 90.0, 12, 6 )

      CALL DVECT ( 12, 18, 1.0 )
c      CALL DVECT ( 12, 18, 0.0 )

      return
      END

*======================================================================
      SUBROUTINE DVECT ( ndx, ndy, rleng )
      PARAMETER ( PI = 3.1415926, CP = PI/180)
      parameter ( mx = 100, my = 100 )
*------------------------------------------------------
*
      save
*
      dimension x(1000), y(1000)
      dimension vectx(mx,my)
      dimension vecty(mx,my)
*
*
      DO 100 i=1, NDx
      DO 100 j=1, NDy+1
         X(i) = (i-1)*360./NDx -180. 
         Y(j) = (j-1)*180./NDy - 90.
 100  CONTINUE
*
c     call uwsgxa( x, ndx )
c     call uwsgya( y, ndy+1 )
*
      call uwsgxb( -180.0, 150.0, ndx )
      ndy1 = ndy + 1
      call uwsgyb( -90.0, 90.0, ndy1 )

      DO 200 i=1, NDx
      DO 200 j=1, NDy+1
         vectx(i,j) = rleng 
         vecty(i,j) = rleng
 200  CONTINUE

      vectx(10,10) = 999.0
      vecty(10,10) = 999.0

      vectx(11,11) = rleng / 1000.0
      vecty(11,11) = rleng / 1000.0
*
      call glpset ( 'LMISS', .true. )
      call uvpset ( 'LUNIT', .true. )
      call uvpset ( 'lnrmal', .true. )
      call uvpset ( 'LMSG', .false. )
      call uvpset ( 'LUMSG', .true. )

      call uvpset ( 'lmissp', .true. )
      call uvpset ( 'lsmall', .true. )
      call uvpset ( 'llarge', .true. )

      call uvsut ( 'X', 'uu' )
      call uvsut ( 'Y', 'vv' )

      call uvpset ( 'UXUNIT', 0.5 )
      call uvpset ( 'UYUNIT', 1.0 )

      call uvpset ( 'INDEX', 1 )
      call uvpset ( 'IARLEN',iarlen )
      call uvpset ( 'icent', -1 )

      CALL uvVECT( VECTX, mx, VECTY, mx, ndx, ndy+1 )
*
      RETURN
*
      entry setarl(ii)
      iarlen = ii
      return
      END

