#!/bin/sh
#
#= Setup a directory for a experiment
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: setup.sh,v 1.4 2009-03-03 10:16:07 morikawa Exp $
# Tag Name::  $Name:  $
# Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
# License::   See COPYRIGHT[link:../COPYRIGHT]
#
######################################################################
#
#== Settings

DEFAULT_DIRNAME=${DEFAULT_DIRNAME:-}
DEFAULT_DIRNAME_PRE="test"
DEFAULT_UPDATE="N"
DCPAMDIR=${DCPAMDIR:-..}
DEFAULT_EXECDIR=${DEFAULT_EXECDIR:-${DCPAMDIR}/src/main}
DEFAULT_NMLDIR=${DEFAULT_NMLDIR:-${DEFAULT_EXECDIR}}
DEFAULT_SRCDIR=${DEFAULT_SRCDIR:-${DCPAMDIR}/src}
DEFAULT_CONFIGMK=${DEFAULT_CONFIGMK:-${DCPAMDIR}/Config.mk}

NMLFILE_SUFFIX="nml"
DEFAULT_SAVESRC="N"
SRCFILE_FIND="*.[fF]9[05] Makefile depend"
SRCFILE_BACKUPDIR="src_backup"

INSTALL=${INSTALL:-cp}
INSTALLBIN=${INSTALLBIN:-cp}
INSTALLDIR=${INSTALLDIR:-"mkdir -p"}

VERBOSE=${VERBOSE:-}

NONINTERACTIVE=${NONINTERACTIVE:-}

# End Settings
######################################################################

######################################################################
#== Functions

print_msg() {
    if [ -n "$VERBOSE" ]; then
	echo $*
    else
	echo $ECHO_N ".$ECHO_C"
    fi
}

backup_oldfile() {
    local suf='.bak.'
    local num=00
    local pathname=$1
    if [ ! -e "${pathname}" ]; then
	echo ""
	echo "  Error: \"${pathname}\" is not found."
	echo ""
    fi
    while [ -e "${pathname}${suf}${num}" ]; do
	num=`expr $num + 1`
	if [ $num -lt 10 ]; then
	    num=0${num}
	fi
    done
    mv ${pathname} ${pathname}${suf}${num}
}

update_file() {
    local srcpath=$1
    local dstdir=$2
    local exec=$3
    if [ -n "${exec}" ]; then
	local install=${INSTALLBIN}
    else
	local install=${INSTALL}
    fi
    srcfile=`basename ${srcpath}`
    if [ -f "${dstdir}/${srcfile}" ]; then
	if [ "${srcpath}" -nt "${dstdir}/${srcfile}" ]; then
	    echo "    Updating \"${dstdir}/${srcfile}\""
	    backup_oldfile "${dstdir}/${srcfile}"
	    ${install} ${srcpath} ${dstdir}
	fi
    else
	print_msg "    Copying ${srcpath} -> ${dstdir}/${srcfile}"
	${install} ${srcpath} ${dstdir}
    fi
}

create_mk(){
    local mkfile=$1
    local dirname=$2
    test -n $mkfile || return
    test -n $dirname || return
    cat > $mkfile <<EOF
#= Makefile for dcpam/practice/$dirname
######################################################################
#== Rules
#
all:
	@echo ""
	@echo "  Command \"make update\" in order to update"
	@echo "  executable files, NAMELIST files, etc. "
	@echo ""

update:
	cd .. ; \\
	NONINTERACTIVE="y" \\
	DEFAULT_DIRNAME="$dirname" \\
	SH="$SH" \\
	DCPAMDIR="$DCPAMDIR" \\
	DEFAULT_EXECDIR="$DEFAULT_EXECDIR" \\
	DEFAULT_NMLDIR="$DEFAULT_NMLDIR" \\
	DEFAULT_SRCDIR="$DEFAULT_SRCDIR" \\
	DEFAULT_CONFIGMK="$DEFAULT_CONFIGMK" \\
	INSTALL="$INSTALL" \\
	INSTALLBIN="$INSTALLBIN" \\
	INSTALLDIR="$INSTALLDIR" \\
		$SH setup.sh

clean:
	rm *.bak.*

EOF
}

# End Functions
######################################################################

set -e

######################################################################
#== Check echo options
case `echo "testing\c"; echo 1,2,3`,`echo -n testing; echo 1,2,3` in
  *c*,-n*) ECHO_N= ECHO_C='
' ECHO_T='      ' ;;
  *c*,*  ) ECHO_N=-n ECHO_C= ECHO_T= ;;
  *)       ECHO_N= ECHO_C='\c' ECHO_T= ;;
esac

######################################################################
#== Start
echo ""
echo "****** Setup a directory for a experiment ******"
echo ""

######################################################################
#== Specify directory for a experiment
if [ -z "${DEFAULT_DIRNAME}" ]; then
    num=00
    dirname_auto=${DEFAULT_DIRNAME_PRE}${num}
    while [ -e "$dirname_auto" ]; do
	num=`expr $num + 1`
	if [ $num -lt 10 ]; then
	    num=0${num}
	fi
	dirname_auto=${DEFAULT_DIRNAME_PRE}${num}
    done
else
    dirname_auto=${DEFAULT_DIRNAME}
fi

dirname=''
if [ -z "${NONINTERACTIVE}" ]; then
    echo $ECHO_N "  Enter directory name [${dirname_auto}]: $ECHO_C"
    read dirname
    test -n "$dirname" || dirname=$dirname_auto
    dirnum=0
    for dn in $dirname; do
	dirnum=`expr $dirnum + 1`
    done
    if [ $dirnum -gt 1 ]; then
	echo ""
	echo "  Error: \"${dirname}\" is irrelevant for directory name."
	echo ""
	exit 1
    fi
else
    dirname=$dirname_auto
fi
#echo $dirname

if [ -e "$dirname" ] && [ -d "$dirname" ]; then
    echo ""
    echo "*** \"${dirname}\" is already exist ***"
    echo ""

    echo $ECHO_N "  Update directory \"$dirname\" ? [y/N]: $ECHO_C"
    read update
    test -n "$update" || update=$DEFAULT_UPDATE
    case $update in
	y*|Y*) ;;
	n*|N*)
	    echo ""
	    echo "*** Existing update of \"${dirname}\" ***"
	    echo ""
	    exit 0
	    ;;
	*)
	    update=''
	    echo "  Enter yes or no"
	    ;;
    esac

elif [ -e "$dirname" ]; then
    echo ""
    echo "  Error: \"${dirname}\" is not directory."
    echo ""
    exit 1
fi


######################################################################
#== Search executable files
execdir=''
if [ -z "${NONINTERACTIVE}" ]; then
    echo "  Directory in which executable files are prepared"
    echo $ECHO_N "    [${DEFAULT_EXECDIR}]: $ECHO_C"
    read execdir
    test -n "$execdir" || execdir=$DEFAULT_EXECDIR
else
    execdir=$DEFAULT_EXECDIR
fi
ls "$execdir" > /dev/null
#echo $execdir

execpathlist=''
execfilelist=''
for execfile in `ls "$execdir"`; do
    test -f "${execdir}/${execfile}" || continue
    test -x "${execdir}/${execfile}" || continue
    execpathlist=${execpathlist}' '${execdir}/${execfile}
    execfilelist=${execfilelist}' '${execfile}
done
#echo $execpathlist
if [ -z "$execpathlist" ]; then
    echo ""
    echo "  Error: executable files are not found in \"$execdir\"."
    echo "         Build executable files on ahead."
    echo ""
    exit 1
fi

######################################################################
#== Search NAMELIST files
nmldir=''
if [ -z "${NONINTERACTIVE}" ]; then
    echo "  Directory in which NAMELIST files are prepared"
    echo $ECHO_N "    [${DEFAULT_NMLDIR}]: $ECHO_C"
    read nmldir
    test -n "$nmldir" || nmldir=$DEFAULT_NMLDIR
else
    nmldir=$DEFAULT_NMLDIR
fi
ls "$nmldir" > /dev/null
#echo $nmldir

nmlpathlist=''
#for execfile in $execfilelist; do
for nmlfiles in `ls "$nmldir"/*."${NMLFILE_SUFFIX}" 2> /dev/null`; do
    #nmlfiles=`ls "$nmldir"/"${execfile}"*."${NMLFILE_SUFFIX}" 2> /dev/null`
    if [ -n "$nmlfiles" ]; then
	for nmlpath in $nmlfiles; do
	    test -f "${nmlpath}" || continue
	    nmlpathlist=${nmlpathlist}' '${nmlpath}
	done
    fi
done
#echo $nmlpathlist

######################################################################
#== Search source files
savef90=''
while [ -z "$savef90" ]; do
    if [ -z "${NONINTERACTIVE}" ]; then
	echo $ECHO_N "  Save F90/95 source code files? [y/N]: $ECHO_C"
	read savef90
	test -n "$savef90" || savef90=$DEFAULT_SAVESRC
	case $savef90 in
	    y*|Y*|n*|N*) ;;
	    *)
		savef90=''
		echo "  Enter yes or no"
		;;
	esac
    else
	savef90=$DEFAULT_SAVESRC
    fi
done

srcfilelist=''
case $savef90 in
    y*|Y*)
	configmkpath=''
	if [ -z "${NONINTERACTIVE}" ]; then
	    echo "  \"Config.mk\" file"
	    echo $ECHO_N "    [${DEFAULT_CONFIGMK}]: $ECHO_C"
	    read configmkpath
	    test -n "$configmkpath" || configmkpath=$DEFAULT_CONFIGMK
	else
	    configmkpath=$DEFAULT_CONFIGMK
	fi
	ls "$configmkpath" > /dev/null
	#echo $configmkpath
	
	srcdir=''
	if [ -z "${NONINTERACTIVE}" ]; then
	    echo "  Directory in which source code files are prepared"
	    echo $ECHO_N "    [${DEFAULT_SRCDIR}]: $ECHO_C"
	    read srcdir
	    test -n "$srcdir" || srcdir=$DEFAULT_SRCDIR
	else
	    srcdir=$DEFAULT_SRCDIR
	fi
	ls "$srcdir" > /dev/null
	#echo $srcdir
	for findfile in ${SRCFILE_FIND}; do
	    for srcfile in `find "$srcdir" -name "${findfile}"`; do
		test -f "${srcfile}" || continue
		srcfilelist=${srcfilelist}' '`echo ${srcfile} | sed -e "s|${srcdir}/||g"`
	    done
	done
	#echo $srcfilelist
	
	;;
esac

######################################################################
#== Create directory and copy some files
if [ ! -d "$dirname" ]; then
    echo $ECHO_N "  Creating \"${dirname}\" ... $ECHO_C"
    $INSTALLDIR $dirname
    echo "  done. "
fi

if [ -f "$dirname/Makefile" ]; then
    backup_oldfile "$dirname/Makefile"
    echo $ECHO_N "  Updating \"$dirname/Makefile\" ... $ECHO_C"
else
    echo $ECHO_N "  Creating \"$dirname/Makefile\" ... $ECHO_C"
fi
create_mk "$dirname/Makefile" "$dirname"
echo "  done. "

echo ""
echo ""
echo "  Copying executable files to \"${dirname}\" ... "
for execpath in $execpathlist ; do
    update_file "${execpath}" "${dirname}" "exec"
#    execfile=`basename ${execpath}`
#    if [ -f "${dirname}/${execfile}" ]; then
#	if [ "${execpath}" -nt "${dirname}/${execfile}" ]; then
#	    echo "    Updating \"${dirname}/${execfile}\""
#	    backup_oldfile "${dirname}/${execfile}"
#	    ${INSTALLBIN} ${execpath} ${dirname}
#	fi
#    else
#	print_msg ${execpath}
#	${INSTALLBIN} ${execpath} ${dirname}
#    fi
done
echo "  done. "

echo "  Copying NAMELIST files to \"${dirname}\" ... "
for nmlpath in $nmlpathlist ; do
    update_file "${nmlpath}" "${dirname}"
#    nmlfile=`basename ${nmlpath}`
#    if [ -f "${dirname}/${nmlfile}" ]; then
#	if [ "${nmlpath}" -nt "${dirname}/${nmlfile}" ]; then
#	    echo "    Updating \"${dirname}/${nmlfile}\""
#	    backup_oldfile "${dirname}/${nmlfile}"
#	    ${INSTALL} ${nmlpath} ${dirname}
#	fi
#    else
#	print_msg ${nmlpath}
#	${INSTALL} ${nmlpath} ${dirname}
#    fi
done
echo "  done. "

case $savef90 in
    y*|Y*)
	dirname_src=$dirname/$SRCFILE_BACKUPDIR
	echo "  Copying source code files to \"${dirname_src}\" ... "

	test -z "$srcfilelist" || $INSTALLDIR $dirname_src

	update_file "${configmkpath}" "${dirname_src}"

#	configmkfile=`basename ${configmkpath}`
#	if [ -f "${dirname_src}/${configmkfile}" ]; then
#	    if [ "${configmkpath}" -nt "${dirname_src}/${configmkfile}" ]; then
#		echo "    Updating \"${dirname_src}/${configmkfile}\""
#		backup_oldfile "${dirname_src}/${configmkfile}"
#		${INSTALL} ${configmkpath} ${dirname_src}
#	    fi
#	else
#	    print_msg ${configmkpath}
#	    ${INSTALL} ${configmkpath} ${dirname_src}
#	fi

	for srcfile in $srcfilelist ; do
	    if [ ! -d "$dirname_src/`dirname ${srcfile}`" ]; then
		print_msg "    Create $dirname_src/`dirname ${srcfile}`"
		${INSTALLDIR} $dirname_src/`dirname ${srcfile}`
	    fi
	    update_file "${srcdir}/${srcfile}" "$dirname_src/`dirname ${srcfile}`"

#	    print_msg "    ${srcdir}/${srcfile} -> $dirname_src/`dirname ${srcfile}`/"
#	    ${INSTALL} ${srcdir}/${srcfile} $dirname_src/`dirname ${srcfile}`/
	done
	echo "  done. "
	;;
esac


echo ""
echo "*** Setup of \"${dirname}\" is complete ***"
echo ""
exit 0
