!= ɽ̥ǡ
!
!= Ground data input
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: read_time_series.f90,v 1.2 2009-07-30 14:50:33 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module read_time_series
  !
  != ɽ̥ǡ
  !
  != Ground data input
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ̲٤ɽ̤̽˴ؤǡ NetCDF ե, 
  ! ⤷ surface_data ⥸塼뤫Ϥޤ. 
  !
  ! Data about sea surface temperature (SST) or various values on surface
  ! are input from a NetCDF file or "surface_data" module. 
  !
  !== Procedures List
  ! GroundFileGet    :: ɽ̥ǡե
  !--
  ! GroundFileOpen   :: ɽ̥ǡեΥץ
  ! GroundFileOutput :: ɽ̥ǡեؤΥǡ
  ! GroundFileClose  :: ɽ̥ǡեΥ
  !++
  ! ------------     :: ------------
  ! GroundFileGet    :: Input ground data file
  !--
  ! GroundFileOpen   :: Open ground data file
  ! GroundFileOutput :: Data output to ground data file
  ! GroundFileClose  :: Close ground data file
  !++
  !
  !== NAMELIST
  !
  ! NAMELIST#ground_file_io_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

!!$#ifdef LIB_MPI
!!$  ! MPI 饤֥
!!$  ! MPI library
!!$  !
!!$  use mpi
!!$#endif

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetValuesFromTimeSeriesWrapper
!!$  public:: SetValuesFromTimeSeries

  ! ѿ
  ! Public variables
  !
  logical, save, public:: read_time_series_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  type time_series_data
    character(STRING):: FileName
                              ! ե̾. 
                              ! File name
    character(STRING):: VarName
                              ! ѿ̾. 
                              ! Variable name
    integer          :: NDims
    integer          :: tmax
    real(DP), pointer:: a_time(:)
    integer , pointer:: a_tindex(:)
    real(DP), pointer:: aaaa_SavedData(:,:,:,:)
  end type time_series_data


  type(time_series_data), save :: TSDataInfoSST
  type(time_series_data), save :: TSDataInfoSIC


  ! ѿ
  ! Private variables
  !


  character(*), parameter:: module_name = 'read_time_series_from_file'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: read_time_series.f90,v 1.2 2009-07-30 14:50:33 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
!!$  interface GroundFileGet
!!$    module procedure GroundFileGet
!!$  end interface

contains

  subroutine SetValuesFromTimeSeriesWrapper( &
    & FileName, VarName, &
    & xy_Var,            &               ! (inout)
    & keyword            &
    & )


    ! ʸ ; Declaration statements
    !
    implicit none

    character(*), intent(in   ):: FileName
                              ! ե̾. 
                              ! File name
    character(*), intent(in   ):: VarName
                              ! ѿ̾. 
                              ! Variable name
    real(DP)    , intent(inout):: xy_Var(0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    character(*), intent(in   ):: keyword


    if ( keyword == 'SST' ) then
      call SetValuesFromTimeSeries( &
        & TSDataInfoSST,     &
        & FileName, VarName, &
        & xy_Var             &               ! (inout)
        & )
    else if ( keyword == 'SIC' ) then
      call SetValuesFromTimeSeries( &
        & TSDataInfoSIC,     &
        & FileName, VarName, &
        & xy_Var             &               ! (inout)
        & )
    else
      stop 'Unsupported keyword'
    end if


  end subroutine SetValuesFromTimeSeriesWrapper

  !-------------------------------------------------------------------

  subroutine SetValuesFromTimeSeries( &
    & TSDataInfo,        &
    & FileName, VarName, &
    & xy_Var             &               ! (inout)
    & )
    !
    ! ɽ̤νΥǡꤷޤ. 
    ! xy_SurfTemp ʳϰܤ˸ƤФ줿Τꤵޤ. 
    !
    ! Get various data on ground. 
    ! Arguments excluding "xy_SurfTemp" are configured at first only. 
    !

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: DC_DIFFTIME, EvalDay, EvalSec

    use dc_date_types, only: DAY_SECONDS, YEAR_DAYS

    ! 
    ! Time control
    !
    use timeset, only: TimeN

    ! ʸ ; Declaration statements
    !
    implicit none

    type(time_series_data), intent(inout):: TSDataInfo
    character(*)          , intent(in   ):: FileName
                              ! ե̾. 
                              ! File name
    character(*)          , intent(in   ):: VarName
                              ! ѿ̾. 
                              ! Variable name
    real(DP)              , intent(inout):: xy_Var(0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature

    ! ѿ
    ! Work variables
    !
    real(DP):: SecOFYear
    integer :: tindex
    integer :: t

!!$    logical:: flag_mpi_init
!!$#ifdef LIB_MPI
!!$    integer:: err_mpi
!!$#endif

    ! ¹ʸ ; Executable statement
    !
    if ( .not. associated( TSDataInfo % a_time ) ) then
      call StructureInit( &
        & FileName, VarName, &
        & TSDataInfo         &
        )
    end if

    if ( TSDataInfo % tmax >= 2 ) then

      SecOfYear = mod( EvalSec( TimeN ), YEAR_DAYS * DAY_SECONDS )
      if ( SecOfYear > YEAR_DAYS * DAY_SECONDS ) SecOfYear = YEAR_DAYS * DAY_SECONDS

!!$      write( 6, * ) TSDataInfo%a_time(TSDataInfo%a_tindex(1)), &
!!$        & SecOfYear, TSDataInfo%a_time(TSDataInfo%a_tindex(2))

      if ( ( SecOfYear <   TSDataInfo%a_time(TSDataInfo%a_tindex(1)) ) .or. &
        &  ( SecOfYear >=  TSDataInfo%a_time(TSDataInfo%a_tindex(2)) ) ) then

        TSDataInfo % a_tindex(1) = 0
        TSDataInfo % a_tindex(2) = 1
        do t = 1, TSDataInfo%tmax
          if ( TSDataInfo % a_time(t) <= SecOfYear ) then
            TSDataInfo % a_tindex(1) = t
            TSDataInfo % a_tindex(2) = t+1
          end if
        end do

!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) 'in if', TSDataInfo % a_tindex(1), TSDataInfo % a_tindex(2)
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'
!!$        write( 6, * ) '##############################################'

        tindex = TSDataInfo % a_tindex(1)
        if ( tindex == 0 ) then
          tindex = TSDataInfo % tmax
        else if ( tindex == TSDataInfo % tmax + 1 ) then
          tindex = 1
        else
          tindex = tindex
        end if

        call HistoryGet(                                       &
          & TSDataInfo%FileName,                               &
          & TSDataInfo%VarName,                                &
          & TSDataInfo%aaaa_SavedData(:,:,1,1),                &
          & range = 'time=^'//toChar(tindex) &
          )

        tindex = TSDataInfo % a_tindex(2)
        if ( tindex == 0 ) then
          tindex = TSDataInfo % tmax
        else if ( tindex == TSDataInfo % tmax + 1 ) then
          tindex = 1
        else
          tindex = tindex
        end if

        call HistoryGet(                                       &
          & TSDataInfo%FileName,                               &
          & TSDataInfo%VarName,                                &
          & TSDataInfo%aaaa_SavedData(:,:,1,2),                &
          & range = 'time=^'//toChar(tindex) &
          )

      end if

      xy_Var =                                                                          &
        &   ( TSDataInfo%aaaa_SavedData(:,:,1,2) - TSDataInfo%aaaa_SavedData(:,:,1,1) ) &
        & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2)) &
        &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))                               ) &
        & * ( SecOfYear                          &
        &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))                              ) &
        & + TSDataInfo%aaaa_SavedData(:,:,1,1)

    else

      xy_Var = TSDataInfo%aaaa_SavedData(:,:,1,1)

    end if


  end subroutine SetValuesFromTimeSeries

  !-------------------------------------------------------------------

  subroutine StructureInit( &
    & FileName, VarName, &
    & TSDataInfo         &
    )

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet, HistoryGetPointer

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: EvalDay, EvalSec

    use dc_date_types, only: DAY_SECONDS, YEAR_DAYS

    ! 
    ! Time control
    !
    use timeset, only: TimeN

    ! ʸ ; Declaration statements
    !
    implicit none

    character(*)          , intent(in   ):: FileName
                              ! ե̾. 
                              ! File name
    character(*)          , intent(in   ):: VarName
                              ! ѿ̾. 
                              ! Variable name
    type(time_series_data), intent(inout):: TSDataInfo


    ! ѿ
    ! Work variables
    !
    real(DP)         :: SecOfYear
    real(DP), pointer:: a_time(:)
    integer          :: tindex
    integer          :: t


    ! ¹ʸ ; Executable statement
    !

    nullify( a_time )


    TSDataInfo % FileName = FileName
    TSDataInfo % VarName  = VarName

    TSDataInfo % NDims = 2

    call HistoryGetPointer( &
      & TSDataInfo%FileName, &
      & 'time',   &
      & a_time    &
      )

    a_time = a_time * DAY_SECONDS

    TSDataInfo % tmax = size( a_time )

    if ( TSDataInfo % tmax >= 2 ) then

      SecOfYear = mod( EvalSec( TimeN ), YEAR_DAYS * DAY_SECONDS )

      allocate( TSDataInfo % a_time(0:TSDataInfo%tmax+1) )
      TSDataInfo % a_time(0) = - ( YEAR_DAYS * DAY_SECONDS - a_time(TSDataInfo%tmax) )
      do t = 1, TSDataInfo%tmax
        TSDataInfo % a_time(t) = a_time(t)
      end do
      TSDataInfo % a_time(TSDataInfo%tmax+1) = YEAR_DAYS * DAY_SECONDS + a_time(1)
      deallocate( a_time )

      allocate( TSDataInfo % a_tindex(1:2) )
      allocate( TSDataInfo % aaaa_SavedData(0:imax-1,1:jmax,1:1,1:2) )

      TSDataInfo % a_tindex(1) = 0
      TSDataInfo % a_tindex(2) = 1
      do t = 1, TSDataInfo%tmax
        if ( TSDataInfo % a_time(t) <= SecOfYear ) then
          TSDataInfo % a_tindex(1) = t
          TSDataInfo % a_tindex(2) = t+1
        end if
      end do

      tindex = TSDataInfo % a_tindex(1)
      if ( tindex == 0 ) then
        tindex = TSDataInfo % tmax
      else if ( tindex == TSDataInfo % tmax + 1 ) then
        tindex = 1
      else
        tindex = tindex
      end if

      call HistoryGet(                                       &
        & TSDataInfo%FileName,                               &
        & TSDataInfo%VarName,                                &
        & TSDataInfo%aaaa_SavedData(:,:,1,1),                &
        & range = 'time=^'//toChar(tindex) &
        )

      tindex = TSDataInfo % a_tindex(2)
      if ( tindex == 0 ) then
        tindex = TSDataInfo % tmax
      else if ( tindex == TSDataInfo % tmax + 1 ) then
        tindex = 1
      else
        tindex = tindex
      end if

      call HistoryGet(                                       &
        & TSDataInfo%FileName,                               &
        & TSDataInfo%VarName,                                &
        & TSDataInfo%aaaa_SavedData(:,:,1,2),                &
        & range = 'time=^'//toChar(tindex) &
        )

    else

      allocate( TSDataInfo % a_time(TSDataInfo%tmax) )
      do t = 1, TSDataInfo%tmax
        TSDataInfo % a_time(t) = a_time(t)
      end do

      allocate( TSDataInfo % a_tindex(1:1) )
      allocate( TSDataInfo % aaaa_SavedData(0:imax-1,1:jmax,1:1,1:1) )

      TSDataInfo % a_tindex(1) = 1

      call HistoryGet(                                       &
        & TSDataInfo%FileName,                               &
        & TSDataInfo%VarName,                                &
        & TSDataInfo%aaaa_SavedData(:,:,1,1),                &
        & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)) &
        )

    end if


  end subroutine StructureInit

end module read_time_series
