!= ɽ̥ǡץ
!
!= dcpam main program for generation of surface data
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: sst_data.F90,v 1.5 2009-03-18 09:24:41 morikawa Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program sst_data
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɽ̥ǡեޤ. 
  !
  ! Surface data file is created. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ɽ̥ǡ
  ! Prepare surface data
  !
  use surface_data, only: SurfDataGet

  ! ɽ̲٥ꥹȥǡ
  ! Restart data of surface temperature input/output
  !
  use restart_surftemp_io, only: RestartSurfTempOutput

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

#ifdef LIB_MPI
  ! MPI 饤֥
  ! MPI library
  !
  use mpi
#endif

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ѿ
  ! Variables
  !
  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲. 
                              ! Surface temperature

  ! ѿ
  ! Work variables
  !

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! ɽ̥ǡκ
  ! Generate surface data
  !
  call SurfDataGet( xy_SurfTemp = xy_SurfTemp )  ! (out) optional

  ! ɽ̲٥ꥹȥǡ
  ! Restart data of surface temperature output
  !
  call RestartSurfTempOutput( &
    & xy_SurfTemp  )             ! (in)

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate

contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

#ifdef LIB_MPI
    ! å
    ! Message output
    !
    use dc_message, only: MessageSuppressMPI
#endif
    use dc_message, only: MessageNotify

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit
                              ! ƥå $ t $ λ. Time of step $ t $. 

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax    ! ٳʻ. 
                               ! Number of grid points in latitude

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempOpen, RestartSurfTempGet

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), parameter:: prog_name = 'sst_data'
                              ! ץ̾. 
                              ! Main program name
    character(*), parameter:: version = &
      & '$Name:  $' // &
      & '$Id: sst_data.F90,v 1.5 2009-03-18 09:24:41 morikawa Exp $'
                              ! ץΥС
                              ! Main program version
    character(STRING):: brief
                              ! ¹ԥեδʷ
                              ! Brief account of executable file

#ifdef LIB_MPI
    integer :: myrank_mpi, nprocs_mpi, err_mpi
                              ! MPI νκݤ˻Ѥѿ. 
                              ! Variables used for initialization of MPI. 
#endif


    ! ¹ʸ ; Executable statement
    !

#ifdef LIB_MPI
    ! MPI 
    ! Initialization of MPI
    !
    CALL MPI_Init(err_mpi)
    CALL MPI_Comm_Rank(mpi_comm_world, myrank_mpi, err_mpi)
    CALL MPI_Comm_Size(mpi_comm_world, nprocs_mpi, err_mpi)
#endif

#ifdef LIB_MPI
    ! å
    ! Message output
    !
    call MessageSuppressMPI( rank = 0 )
#endif
    brief = 'SST data generation'
    call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
    call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit(prog_name, brief)

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ɽ̲ѿγ
    ! Allocation of a variable of surface temperature
    !
    allocate( xy_SurfTemp (0:imax-1, 1:jmax) )

    ! ɽ̲٥ꥹȥǡեν
    ! Initialization of restart data file of surface temperature
    !
    call RestartSurfTempOpen( flag_init_data = .true. ) ! (in) optional

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ʸ ; Declaration statements
    !
    implicit none
#ifdef LIB_MPI
    integer :: err_mpi
                              ! MPI νλκݤ˻Ѥѿ. 
                              ! Variable used for termination of MPI. 
#endif

    ! ¹ʸ ; Executable statement
    !

    ! ɽ̲٥ꥹȥǡե륯
    ! Close restart data file of surface temperature
    !
    call RestartSurfTempClose

    ! λ
    ! Termination of time control
    !
    call TimesetClose

    ! ɽ̲ѿγղ
    ! Deallocation of a variable of surface temperature
    !
    deallocate( xy_SurfTemp )

#ifdef LIB_MPI
    ! MPI λ
    ! Termination of MPI
    !
    call MPI_Finalize(err_mpi)
#endif

  end subroutine MainTerminate

end program sst_data
