!= ϲˤǮαľȻ
!
!= Vertical diffusion of heat under the ground
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: subsurface_diffusion_heat.f90,v 1.3 2009-08-04 09:42:36 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module subsurface_diffusion_heat
  !
  != ϲαľȻ
  !
  != Vertical diffusion under the ground
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  ! PhyImplTendency      :: ѲΨη׻
  ! ------------         :: ------------
  ! PhyImplTendency      :: Calculate tendency
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#phy_implicit_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only:   imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
    &                  jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
    &                  kmax, & ! ľؿ. 
                               ! Number of vertical level
    &                  kslmax  ! ϲαľؿ. 
                               ! Number of subsurface vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SubsurfaceDiffusion

  ! ѿ
  ! Public variables
  !
  logical, save, public:: subsurface_diffusion_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'subsurface_diffusion_heat'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: subsurface_diffusion_heat.f90,v 1.3 2009-08-04 09:42:36 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  real(DP), allocatable, save, public:: xy_SoilSpecHeat    (:,:)
                              ! Specific heat of soil (J K-1 kg-1)
  real(DP), allocatable, save, public:: xy_SoilRho         (:,:)
                              ! Density of soil (kg m-3)
  real(DP), allocatable, save, public:: xy_SoilHeatCap     (:,:)
                              ! Volumetric heat capacity of soil (J m-3 K-1)
  real(DP), allocatable, save, public:: xy_SoilHeatDiffCoef(:,:)
                              ! Heat conduction coefficient of soil (J K-1 m-1 s-1)


  ! INTERFACE ʸ ; INTERFACE statements
  !
!!$  interface PhyImplTendency
!!$    module procedure PhyImplTendency
!!$  end interface

contains

  subroutine SubsurfaceDiffusion(              &
    & xy_GroundTempFlux,                       &          ! (in )
    & xy_SurfTemp, xyz_SoilTemp,               &          ! (in )
    & xyr_SoilTempTransCoef, xyr_SoilTempFlux  &          ! (out)
    & )
    !
    ! ѲΨη׻Ԥޤ. 
    !
    ! Calculate tendencies. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      r_SSDepth, & ! subsurface grid on interface of layer
      z_SSDepth    ! subsurface grid at midpoint of layer


    ! 
    ! Time control
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xy_GroundTempFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! Ground temperature flux
    real(DP), intent(in ):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in ):: xyz_SoilTemp (0:imax-1, 1:jmax, 1:kslmax)
                              ! ھ (K)
                              ! Soil temperature (K)
    real(DP), intent(out):: xyr_SoilTempTransCoef (0:imax-1, 1:jmax, 0:kslmax)
                              ! ͢ھ.
                              ! Transfer coefficient: soil temperature
    real(DP), intent(out):: xyr_SoilTempFlux (0:imax-1, 1:jmax, 0:kslmax)
                              ! ھǮեå. 
                              ! Heat flux in sub-surface soil



    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. subsurface_diffusion_inited ) call SubsurfaceDiffusionInit


    ! ھٷ׻Ѥ͢η׻
    ! Calculate transfer coefficient for heat diffusion in the soil
    !
    k = 0
    if ( kslmax == 0 ) then
      ! This line is used when kslmax == 0, because z_SSDepth(k+1) does not exist. 
      xyr_SoilTempTransCoef(:,:,k) = 0.0d0
    else
      xyr_SoilTempTransCoef(:,:,k) = &
        & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - 0.0d0 )
    end if
    do k = 1, kslmax-1
      xyr_SoilTempTransCoef(:,:,k) = &
        & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - z_SSDepth(k) )
    end do
    k = kslmax
    xyr_SoilTempTransCoef(:,:,k) = 0.0d0


    ! ھǮեåη׻
    ! Calculate heat flux in sub-surface soil
    !
    k = 0
    if ( kslmax == 0 ) then
      ! This line is used when kslmax == 0, because xyz_SoilTemp(:,:,k+1) does not exist. 
      xyr_SoilTempFlux(:,:,k) = 0.0d0
    else
      xyr_SoilTempFlux(:,:,k) = &
        & - xyr_SoilTempTransCoef(:,:,k) * ( xyz_SoilTemp(:,:,1) - xy_SurfTemp(:,:) )
    end if
    do k = 1, kslmax-1
      xyr_SoilTempFlux(:,:,k) =                               &
        & - xyr_SoilTempTransCoef(:,:,k)                      &
        &   * ( xyz_SoilTemp(:,:,k+1) - xyz_SoilTemp(:,:,k) )
    end do
    k = kslmax
    xyr_SoilTempFlux(:,:,k) = xy_GroundTempFlux


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine SubsurfaceDiffusion

  !-------------------------------------------------------------------

  subroutine SubsurfaceDiffusionInit
    !
    ! subsurface_diffusion_heat ⥸塼νԤޤ. 
    ! NAMELIST#subsurface_diffusion_heat_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "subsurface_diffusion_heat" module is initialized. 
    ! "NAMELIST#subsurface_diffusion_heat_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /phy_implicit_nml/
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "phy_implicit#PhyImplInit" 
!!$          ! Υɤ򻲾ȤΤ. 
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "phy_implicit#PhyImplInit" for the default values. 
!!$          !

    ! ¹ʸ ; Executable statement
    !

    if ( subsurface_diffusion_inited ) return
!!$    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = phy_implicit_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if



    allocate( xy_SoilSpecHeat    ( 0:imax-1, 1:jmax ) )
    allocate( xy_SoilRho         ( 0:imax-1, 1:jmax ) )
    allocate( xy_SoilHeatCap     ( 0:imax-1, 1:jmax ) )
    allocate( xy_SoilHeatDiffCoef( 0:imax-1, 1:jmax ) )


    xy_SoilSpecHeat     = 1.0d100     ! This variable is not used.
    xy_SoilRho          = 1.0d100     ! This variable is not used.

    xy_SoilHeatCap      = 2.1d6
    ! J m-3 K-1
    ! Value of Clay for porosity f=0.4, volumetric wetness theta=0.2 in Table 12.3 by 
    ! Hillel (2004). 
    ! Note that the unit of Table 12.3 of Hillel (2004) would be wrong. Although the 
    ! unit in the Table is wrong, the volumetric heat capacity of 2.1d6 J m-3 K-1 is 
    ! within the range of typical value of it. 

    xy_SoilHeatDiffCoef = 1.2d0
    ! W m-1 K-1
    ! Value of Clay for porosity f=0.4, volumetric wetness theta=0.2 in Table 12.3 by 
    ! Hillel (2004). 

    ! Reference
    !
    ! Hillet, D., 
    !   Introduction to Environmental Soil Physics, 
    !   Elsevier Academic Press, pp494, 2004.


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    subsurface_diffusion_inited = .true.

  end subroutine SubsurfaceDiffusionInit

  !-------------------------------------------------------------------
!!$
!!$  subroutine InitCheck
!!$    !
!!$    ! ¸⥸塼νå
!!$    !
!!$    ! Check initialization of dependency modules
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_util_inited
!!$
!!$    ! ʻ
!!$    ! Grid points settings
!!$    !
!!$    use gridset, only: gridset_inited
!!$
!!$    ! ʪ
!!$    ! Physical constants settings
!!$    !
!!$    use constants, only: constants_inited
!!$
!!$    ! ɸǡ
!!$    ! Axes data settings
!!$    !
!!$    use axesset, only: axesset_inited
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: timeset_inited
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    if ( .not. namelist_util_inited ) &
!!$      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
!!$
!!$    if ( .not. gridset_inited ) &
!!$      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )
!!$
!!$    if ( .not. constants_inited ) &
!!$      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )
!!$
!!$    if ( .not. axesset_inited ) &
!!$      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )
!!$
!!$    if ( .not. timeset_inited ) &
!!$      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )
!!$
!!$  end subroutine InitCheck
!!$
end module subsurface_diffusion_heat
