!= 絬϶ŷ (ήŷ) (Manabe et al., 1965)
!
!= Large scale condensation (non-convective condensation) (Manabe et al., 1965)
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA, Yoshiyuki O. Takahashi
! Version::   $Id: lscond.f90,v 1.20 2014/05/07 09:58:44 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module lscond
  !
  != 絬϶ŷ (ήŷ)
  !
  != Large scale condensation (non-convective condensation)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 絬϶ŷˤäƲ٤漾Ĵᤷޤ. 
  !
  ! Adjust temperature and specific humidity by 
  ! a large scale condensation process.
  !
  !== References
  !
  !  Manabe, S., J. Smagorinsky, R. F. Strickler,
  !    Simulated climatology of a general circulation model with a hydrologic cycle,
  !    Mon. Wea. Rev., 93, 769-798, 1965.
  !
  !== Procedures List
  ! 
  ! LScaleCond    :: ٤漾Ĵ
  ! ------------  :: ------------
  ! LScaleCond    :: Adjust temperature and specific humidity
  !
  !== NAMELIST
  !
  ! NAMELIST#lscond_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: LScaleCond
  public:: LScaleCond1D3DWrapper
  public:: LScaleCondInit

  ! ѿ
  ! Public variables
  !
  logical, save :: lscond_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), save:: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
  integer, save:: ItrtMax
                              ! ƥ졼. 
                              ! Number of iteration
  logical, save:: FlagSublimation
                              ! 
                              ! flag for treating sublimation
  logical, save:: FlagSatAdj
                              ! 
                              ! flag for saturation adjustment

  character(*), parameter:: module_name = 'lscond'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: lscond.f90,v 1.20 2014/05/07 09:58:44 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine LScaleCond(        &
    & xyz_Temp, xyz_QVap,       &  ! (inout)
    & xyz_Press, xyr_Press,     &  ! (in)
    & xyz_DQH2OLiqDt,           &  ! (out)
    & FlagOutput                &  ! (in) optional
    & )
    !
    ! 絬϶ŷ륹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! Adjust temperature and specific humidity by 
    ! large scale condensation scheme. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
                              !
                              ! Tendency of H2O liquid mixing ratio
    logical , intent(in ), optional :: FlagOutput
                              !
                              ! Flag for output


    ! ѿ
    ! Work variables
    !
    real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
                              ! ߿. 
                              ! Precipitation
    real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency

    real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
                              !
    real(DP):: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
                              ! ˰漾. 
                              ! Saturation specific humidity. 
    real(DP):: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DD{q_{\rm{sat}}}{T} $
    real(DP):: DelTemp
                              ! Ĵˤ벹Ѳ. 
                              ! Temperature variation by adjustment

    real(DP):: LatentHeatLocal
                              ! 
                              ! Latent heat used in this routine

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction

    real(DP):: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)

    real(DP):: TempBefAdj
    real(DP):: QVapBefAdj

    logical:: xyz_FlagSaturated(0:imax-1, 1:jmax, 1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. lscond_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! Ĵ "QVap", "Temp" ¸
    ! Store "QVap", "Temp" before adjustment
    !
    xyz_QVapB  = xyz_QVap
    xyz_TempB  = xyz_Temp


    ! Ĵ
    ! Adjustment
    !

    ! ˰漾׻
    ! Calculate saturation specific humidity 
    !
    xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )

    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1

          if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) ) >= CrtlRH ) then
            xyz_FlagSaturated(i,j,k) = .true.
          else
            xyz_FlagSaturated(i,j,k) = .false.
          end if

        end do
      end do
    end do

    ! Set a value for latent heat
    if ( FlagSublimation ) then
      LatentHeatLocal = LatentHeat + LatentHeatFusion
    else
      LatentHeatLocal = LatentHeat
    end if

    do itr = 1, ItrtMax

      ! ˰漾׻
      ! Calculate saturation specific humidity
      !
      xyz_QVapSat       = xyz_CalcQVapSat      ( xyz_Temp, xyz_Press   )
      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )


      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax-1

            ! ˰¤Ƥ, ٤漾Ѳ׻
            ! Calculate tendency of temperature and humidity 
            ! if moist is saturation. 
            !
            if ( xyz_FlagSaturated(i,j,k) ) then

              ! ٤Ѳʬ˥塼ȥˡǵ
              ! Calculate variation of temperature
              !
              DelTemp =                                                 &
                & LatentHeatLocal                                       &
                &   * ( xyz_QVap(i,j,k) - CrtlRH * xyz_QVapSat(i,j,k) ) &
                &   / ( CpDry + LatentHeatLocal * CrtlRH * xyz_DQVapSatDTemp(i,j,k) )


              !=========
              ! check routine
              !---------
!!$              TempBefAdj = xyz_Temp(i,j,k)
!!$              QVapBefAdj = xyz_QVap(i,j,k)
              !=========

              ! ٤漾Ĵ
              ! Adjust temperature and specific humidity
              !
              xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
!!$              xyz_QVap(i,j,k) = xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp
              xyz_QVap(i,j,k) = &
                & CrtlRH * ( xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp )

              !=========
              ! check routine
              !---------
!!$              write( 6, * ) '====='
!!$              write( 6, * ) 'Energy difference before and after adjustment and each energy'
!!$              write( 6, * ) &
!!$                &     CpDry * TempBefAdj      + LatentHeatLocal * QVapBefAdj            &
!!$                & - ( CpDry * xyz_Temp(i,j,k) + LatentHeatLocal * xyz_QVap(i,j,k) ),    &
!!$                &     CpDry * TempBefAdj      + LatentHeatLocal * QVapBefAdj,           &
!!$                &   ( CpDry * xyz_Temp(i,j,k) + LatentHeatLocal * xyz_QVap(i,j,k) )
              !=========


            end if

          end do
        end do
      end do

    end do

    ! 漾ѲΨ, ѲΨ, ߿̤λ
    ! Calculate specific humidity tendency, temperature tendency, 
    ! precipitation
    !
    xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
    xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )

    xyz_DQH2OLiqDt = - xyz_DQVapDtLsc


    ! calculation for output
    xy_RainLsc     = 0.0_DP
    do k = kmax, 1, -1
      xy_RainLsc = xy_RainLsc                                     &
        & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do


    ! ҥȥǡ
    ! History data output
    !
    if ( .not. present( FlagOutput ) ) then
      call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc     )
      call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
      call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
    else
      if ( FlagOutput ) then
        call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc     )
        call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
        call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
      end if
    end if


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine LScaleCond

  !--------------------------------------------------------------------------------------

  subroutine LScaleCond1D3DWrapper(                 &
    & xyz_Temp, xyz_QVap, xyz_QH2OLiq, xyz_QH2OSol, &  ! (inout)
    & xyz_Press, xyr_Press,                         &  ! (in)
    & xyz_DQH2OLiqDt, xyz_DQH2OSolDt,               &  ! (out)
    & FlagOutput                                    &  ! (in) optional
    & )
    !
    ! 絬϶ŷ륹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! Adjust temperature and specific humidity by 
    ! large scale condensation scheme. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(inout):: xyz_QH2OLiq(0:imax-1, 1:jmax, 1:kmax)
                              ! Specific liquid water content
    real(DP), intent(inout):: xyz_QH2OSol(0:imax-1, 1:jmax, 1:kmax)
                              ! Specific ice content
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
                              !
                              ! Tendency of H2O liquid mixing ratio
    real(DP), intent(out) :: xyz_DQH2OSolDt(0:imax-1,1:jmax,1:kmax)
                              !
                              ! Tendency of H2O ice mixing ratio
    logical , intent(in ), optional :: FlagOutput
                              !
                              ! Flag for output


    ! ѿ
    ! Work variables
    !
    real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
                              ! ߿. 
                              ! Precipitation

    real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency

    real(DP) :: z_Temp (1:kmax)
                              ! $ T $ .     . Temperature
    real(DP) :: z_QVap (1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP) :: z_QH2OLiq(1:kmax)
                              ! Specic liquid water content
    real(DP) :: z_QH2OSol(1:kmax)
                              ! Specic ice content
    real(DP) :: z_Press (1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP) :: r_Press (0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP) :: z_DQH2OLiqDt(1:kmax)
                              !
                              ! Tendency of H2O liquid mixing ratio
    real(DP) :: z_DQH2OSolDt(1:kmax)
                              !
                              ! Tendency of H2O ice mixing ratio


    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. lscond_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )



    do j = 1, jmax
      do i = 0, imax-1

        do k = 1, kmax
          z_Temp   (k) = xyz_Temp   (i,j,k)
          z_QVap   (k) = xyz_QVap   (i,j,k)
          z_QH2OLiq(k) = xyz_QH2OLiq(i,j,k)
          z_QH2OSol(k) = xyz_QH2OSol(i,j,k)
          z_Press  (k) = xyz_Press  (i,j,k)
        end do
        do k = 0, kmax
          r_Press  (k) = xyr_Press  (i,j,k)
        end do

        call LScaleCond1D(                        &
          & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
          & z_Press, r_Press,                     &  ! (in)
          & z_DQH2OLiqDt, z_DQH2OSolDt            &  ! (out)
          & )

        do k = 1, kmax
          xyz_Temp      (i,j,k) = z_Temp      (k)
          xyz_QVap      (i,j,k) = z_QVap      (k)
          xyz_QH2OLiq   (i,j,k) = z_QH2OLiq   (k)
          xyz_QH2OSol   (i,j,k) = z_QH2OSol   (k)
          xyz_DQH2OLiqDt(i,j,k) = z_DQH2OLiqDt(k)
          xyz_DQH2OSolDt(i,j,k) = z_DQH2OSolDt(k)
        end do

      end do
    end do


    ! calculation for output
    xy_RainLsc     = 0.0_DP
    do k = kmax, 1, -1
      xy_RainLsc = xy_RainLsc                                     &
        & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do


    ! ҥȥǡ
    ! History data output
    !
    if ( .not. present( FlagOutput ) ) then
      call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc     )
      call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
      call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
    else
      if ( FlagOutput ) then
        call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc     )
        call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
        call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
      end if
    end if


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine LScaleCond1D3DWrapper

  !--------------------------------------------------------------------------------------

  subroutine LScaleCond1D(  &
    & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
    & z_Press, r_Press,                     &  ! (in)
    & z_DQH2OLiqDt, z_DQH2OSolDt            &  ! (out)
    & )
    !
    ! 絬϶ŷ륹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! Adjust temperature and specific humidity by 
    ! large scale condensation scheme. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: a_CalcQVapSat, a_CalcDQVapSatDTemp

    ! طϥ롼
    ! Cloud-related routines
    !
    use cloud_utils, only : CloudUtilsWatFraction


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: z_Temp (1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: z_QVap (1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(inout):: z_QH2OLiq(1:kmax)
                              ! Specific liquid water content
    real(DP), intent(inout):: z_QH2OSol(1:kmax)
                              ! Specific ice content
    real(DP), intent(in   ):: z_Press (1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in   ):: r_Press (0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out  ):: z_DQH2OLiqDt(1:kmax)
                              !
                              ! Tendency of H2O liquid mixing ratio
    real(DP), intent(out  ):: z_DQH2OSolDt(1:kmax)
                              !
                              ! Tendency of H2O ice mixing ratio


    ! ѿ
    ! Work variables
    !
    real(DP):: z_DTempDtLsc (1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: z_DQVapDtLsc (1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency

    real(DP):: z_QH2OVap0 (1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: z_QH2OLiq0 (1:kmax)
                              ! 
                              ! Specific liquid water content before adjust. 
    real(DP):: z_QH2OSol0 (1:kmax)
                              ! 
                              ! Specific liquid water content before adjust. 
    real(DP):: z_Temp0    (1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
                              !
    real(DP):: z_QH2OVapB (1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: z_QH2OLiqB (1:kmax)
                              ! 
                              ! Specific liquid water content before adjust. 
    real(DP):: z_QH2OSolB (1:kmax)
                              ! 
                              ! Specific liquid water content before adjust. 
    real(DP):: z_TempB    (1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
                              !
    real(DP):: z_QVapSat      (1:kmax)
                              ! ˰漾. 
                              ! Saturation specific humidity. 
    real(DP):: z_DQVapSatDTemp(1:kmax)
                              ! $ \DD{q_{\rm{sat}}}{T} $
    real(DP):: DelTemp
                              ! Ĵˤ벹Ѳ. 
                              ! Temperature variation by adjustment

    real(DP) :: WatFrac
    real(DP) :: IceFrac


    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction
    logical:: z_FlagProcess(1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. lscond_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


!!$    ! ׻ַ¬
!!$    ! Start measurement of computation time
!!$    !
!!$    call TimesetClockStart( module_name )


    ! Ĵ "QVap", "Temp" ¸
    ! Store "QVap", "Temp" before adjustment
    !
    z_QH2OVap0 = z_QVap
    z_QH2OLiq0 = z_QH2OLiq
    z_QH2OSol0 = z_QH2OSol
    z_Temp0    = z_Temp


    ! Ĵ
    ! Adjustment
    !

    ! ˰漾׻
    ! Calculate saturation specific humidity 
    !

    if ( FlagSatAdj ) then
      z_Temp = z_Temp &
        & + ( LatentHeat * z_QH2OLiq + ( LatentHeat + LatentHeatFusion ) * z_QH2OSol ) / CpDry
      z_QVap = z_QVap + z_QH2OLiq + z_QH2OSol
      z_QH2OLiq = 0.0_DP
      z_QH2OSol = 0.0_DP
    else
      ! Pre-existing cloud water and ice are removed, since those are not 
      ! responsible with condensation (assumption).
      z_QH2OLiq = 0.0_DP
      z_QH2OSol = 0.0_DP
    end if
    !
    z_QVapSat = a_CalcQVapSat( z_Temp, z_Press )
    !
    do k = 1, kmax
      if ( ( z_QVap(k) / z_QVapSat(k) ) >= CrtlRH ) then
        z_FlagProcess(k) = .true.
      else
        z_FlagProcess(k) = .false.
      end if
    end do


    do itr = 1, ItrtMax

      z_QH2OVapB = z_QVap
      z_QH2OLiqB = z_QH2OLiq
      z_QH2OSolB = z_QH2OSol
      z_TempB    = z_Temp

      ! ˰漾׻
      ! Calculate saturation specific humidity
      !
      z_QVapSat       = a_CalcQVapSat      ( z_Temp, z_Press   )
      z_DQVapSatDTemp = a_CalcDQVapSatDTemp( z_Temp, z_QVapSat )


      do k = 1, kmax

        ! ˰¤Ƥ, ٤漾Ѳ׻
        ! Calculate tendency of temperature and humidity 
        ! if moist is saturation. 
        !
        if ( z_FlagProcess(k) ) then

          ! Liquid water and ice fractions
          call CloudUtilsWatFraction(   &
            & z_Temp(k),                & ! (in )
            & WatFrac                   & ! (out)
            & )
          IceFrac = 1.0_DP - WatFrac

          ! ٤Ѳʬ˥塼ȥˡǵ
          ! Calculate variation of temperature
          !
!!$          DelTemp =                                                 &
!!$            & LatentHeatLocal                                       &
!!$            &   * ( z_QVap(k) - CrtlRH * z_QVapSat(k) )             &
!!$            &   / ( CpDry + LatentHeatLocal * CrtlRH * z_DQVapSatDTemp(k) )
          DelTemp =                                                         &
            &   (   LatentHeat * z_QVap(k)                                  &
            &     - LatentHeatFusion * z_QH2OSol(k)                         &
            &     + LatentHeatFusion                                        &
            &       * IceFrac * ( z_QVap(k) + z_QH2OLiq(k) + z_QH2OSol(k) ) &
            &     - ( LatentHeat + LatentHeatFusion * IceFrac )             &
            &       * CrtlRH * z_QVapSat(k) )                               &
            & / (   CpDry &
            &     + ( LatentHeat + LatentHeatFusion * IceFrac ) &
            &       * CrtlRH * z_DQVapSatDTemp(k) )


          ! ٤漾Ĵ
          ! Adjust temperature and specific humidity
          !
          z_Temp(k) = z_Temp(k) + DelTemp
          z_QVap(k) = &
            & CrtlRH * ( z_QVapSat(k) + z_DQVapSatDTemp(k) * DelTemp )
          z_QH2OLiq(k) = &
            & WatFrac &
            & * ( z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k) - z_QVap(k) )
          z_QH2OSol(k) = &
            & IceFrac &
            & * ( z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k) - z_QVap(k) )

        end if

      end do

    end do


    if ( FlagSatAdj ) then
    else
      ! Pre-existing cloud water and ice amount are restored. 
      z_QH2OLiq = z_QH2OLiq + z_QH2OLiq0
      z_QH2OSol = z_QH2OSol + z_QH2OSol0
    end if


    ! 漾ѲΨ, ѲΨ, ߿̤λ
    ! Calculate specific humidity tendency, temperature tendency, 
    ! precipitation
    !
    z_DTempDtLsc = ( z_Temp    - z_Temp0    ) / ( 2.0_DP * DelTime )
    z_DQVapDtLsc = ( z_QVap    - z_QH2OVap0 ) / ( 2.0_DP * DelTime )
    z_DQH2OLiqDt = ( z_QH2OLiq - z_QH2OLiq0 ) / ( 2.0_DP * DelTime )
    z_DQH2OSolDt = ( z_QH2OSol - z_QH2OSol0 ) / ( 2.0_DP * DelTime )


    call LScaleCond1DConsChk(                        &
      & z_Temp0, z_QH2OVap0, z_QH2OLiq0, z_QH2OSol0, &
      & z_Temp , z_QVap    , z_QH2OLiq , z_QH2OSol   &
      & )


!!$    ! ׻ַ¬
!!$    ! Pause measurement of computation time
!!$    !
!!$    call TimesetClockStop( module_name )

  end subroutine LScaleCond1D

  !--------------------------------------------------------------------------------------

  subroutine LScaleCond1DConsChk(                  &
    & z_TempB, z_QH2OVapB, z_QH2OLiqB, z_QH2OSolB, &
    & z_Temp , z_QH2OVap , z_QH2OLiq , z_QH2OSol   &
    & )

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion

    real(DP), intent(in) :: z_TempB   (1:kmax)
    real(DP), intent(in) :: z_QH2OVapB(1:kmax)
    real(DP), intent(in) :: z_QH2OLiqB(1:kmax)
    real(DP), intent(in) :: z_QH2OSolB(1:kmax)
    real(DP), intent(in) :: z_Temp    (1:kmax)
    real(DP), intent(in) :: z_QH2OVap (1:kmax)
    real(DP), intent(in) :: z_QH2OLiq (1:kmax)
    real(DP), intent(in) :: z_QH2OSol (1:kmax)

    ! Local variables
    !
    real(DP) :: ValB
    real(DP) :: Val
    real(DP) :: Ratio
    integer  :: k


    do k = kmax, 1, -1
      Val =   CpDry * z_TempB(k)               &
        &   + LatentHeat * z_QH2OVapB(k)       &
        &   - LatentHeatFusion * z_QH2OSolB(k)
      ValB = Val

      Val =   CpDry * z_Temp(k)               &
        &   + LatentHeat * z_QH2OVap(k)       &
        &   - LatentHeatFusion * z_QH2OSol(k)

      Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
      if ( abs( Ratio ) > 1.0d-10 ) then
        call MessageNotify( 'M', module_name, 'Simplified condensate static energy is not conserved, %f.', d = (/ Ratio /) )
      end if
    end do



    do k = kmax, 1, -1
      Val = z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k)
      ValB = Val

      Val = z_QH2OVap (k) + z_QH2OLiq (k) + z_QH2OSol (k)

      Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
      if ( abs( Ratio ) > 1.0d-10 ) then
        call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ Ratio /) )
      end if
    end do


  end subroutine LScaleCond1DConsChk

  !--------------------------------------------------------------------------------------

  subroutine LScaleCondInit( &
    & FlagSnow &
    & )
    !
    ! lscond ⥸塼νԤޤ. 
    ! NAMELIST#lscond_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "lscond" module is initialized. 
    ! "NAMELIST#lscond_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: SaturateInit

    ! طϥ롼
    ! Cloud-related routines
    !
    use cloud_utils, only : CloudUtilsInit

    ! ʸ ; Declaration statements
    !
    implicit none

    logical, intent(in) :: FlagSnow


    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /lscond_nml/ &
      & CrtlRH, ItrtMax, FlagSublimation, FlagSatAdj
          !
          ! ǥեͤˤĤƤϽ³ "lscond#LSCondInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "lscond#LSCondInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( lscond_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    CrtlRH          = 1.0_DP
    ItrtMax         = 3
    FlagSublimation = .false.
    FlagSatAdj      = .false.

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = lscond_nml, &   ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = lscond_nml )
    end if

    ! Initialization of modules used in this module
    !

    ! Initialization of modules used in this module
    !
    call SaturateInit

    ! طϥ롼
    ! Cloud-related routines
    !
    call CloudUtilsInit( &
      & FlagSnow         &
      & )


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'RainLsc', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'precipitation by large scale condensation', 'kg m-2 s-1' )
    call HistoryAutoAddVariable( 'DTempDtLsc', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'large-scale condensation heating', 'K s-1' )
    call HistoryAutoAddVariable( 'DQVapDtLsc', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'large-scale condensation moistening', 'kg kg-1 s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  CrtlRH          = %f', d = (/ CrtlRH /) )
    call MessageNotify( 'M', module_name, '  ItrtMax         = %d', i = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
    call MessageNotify( 'M', module_name, '  FlagSatAdj      = %b', l = (/ FlagSatAdj /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    lscond_inited = .true.

  end subroutine LScaleCondInit

  !--------------------------------------------------------------------------------------

end module lscond
