!= dcpam ץ
!
!= dcpam main program
!
! Authors::   Yasuhiro Morikawa, Satoshi Noda, Yoshiyuki O. Takahashi
! Version::   $Id: dcpam_main.f90,v 1.61 2014/06/29 07:23:28 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2010. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_main
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ǥλȤˤĤƤ {塼ȥꥢ}[link:../../../doc/tutorial/rakuraku/] 
  ! ȤƤ.
  !
  ! See {Tutorial}[link:../../../doc/tutorial/rakuraku/index.htm.en] for usage of the 
  ! model. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
  ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
  !
  use dynamics_hspl_vas83, only: DynamicsHsplVAS83

  ! ʪΤߤη׻Τϳز
  ! A dynamics for calculation with physical processes only
  !
  use dynamics_physicsonly, only: DynamicsPhysicsOnly

  ! Held and Suarez (1994) ˤ붯Ȼ
  ! Forcing and dissipation suggested by Held and Suarez (1994)
  !
  use held_suarez_1994, only: HS94Forcing

  ! ñ׻Τζ
  ! forcing for simple Venus calculation
  !
  use yt2003_forcing, only: YT2003Forcing

  ! Schneider and Liu (2009) ˤľ
  ! Vertical diffusion by Schneider and Liu (2009)
  !
  use sl09_diffusion, only : SL09Diffusion

  ! ͥեå (GFD Ǿȯͥǥ)
  ! Radiation flux (radiation model developed by GFD Dennou Club)
  !
  use rad_DennouAGCM, only: RadDennouAGCMFlux

  ! ʹϢ롼
  ! Routines for radiation calculation
  !
  use rad_utils, only : RadDTempDt, RadFluxOutput

  ! ϵ絤ͥǥ Ver. 2
  ! radiation model for the Earth's atmosphere Ver. 2
  !
  use rad_Earth_V2, only: RadEarthV2Flux

  ! 絤ͥǥ Ver. 1
  ! radiation model for the Mars' atmosphere Ver. 1
  !
  use rad_Mars_V1, only: RadMarsV1Flux

!!$  ! (絤) Non-LTE ͥǥ
!!$  ! Non-NLTE radiation model (for the Mars' atmosphere)
!!$  !
!!$  use rad_15m_NLTE, only: rad15mNLTEMergeHR

  ! ׻ѶֳǮΨ׻
  ! Calculation of near infrared heating rate in the case of Mars
  !
  use rad_Mars_NIR, only : RadMarsNIRINOUT

  ! Schneider and Liu (2009) ͥǥ
  ! Radiation model by Schneider and Liu (2009)
  !
  use rad_SL09, only : RadSL09Flux

  ! ñͥǥ
  ! Simple radiation model
  !
  use rad_simple, only : RadSimpleFlux

  ! ľȻեå
  ! Vertical diffusion flux
  !
  use vdiffusion_my, only: VDiffusionMY25, VDiffusion, VDiffusionOutput
  use vdiffusion_my, only: VDiffusionMY251DWrapper3D
  use vdiffusion_my, only: VDiffusionMY25GBT94

  ! ϲˤǮαľȻ
  ! Vertical diffusion of heat under the ground
  !
  use subsurface_diffusion_heat, only: SubsurfaceDiffusion

  ! Gravity wave drag by McFarlane (1987)
  ! Gravity wave drag by McFarlane (1987)
  !
  use gwd_m1987, only : GWDM1987

  ! ѱѥ᥿ꥼ (ήĴ)
  ! Cumulus parameterization (convection adjust)
  !
  use moist_conv_adjust, only: MoistConvAdjust

  ! Relaxed Arakawa-Schubert scheme
  ! Relaxed Arakawa-Schubert scheme
  !
  use relaxed_arakawa_schubert, only : RAS
  use relaxed_arakawa_schubert, only : RAS1DWrapper3D
  use relaxed_arakawa_schubert, only : RASWithIce1DWrapper3DWrapper

  ! 絬϶ŷ (ήŷ)
  ! Large scale condensation
  !
  use lscond, only: LScaleCond
  use lscond, only: LScaleCond1D3DWrapper

  ! 絬϶ŷ (ήŷ) (Le Treut and Li, 1991)
  ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
  !
!!$  use lscond_LL91, only : LScaleCondLL91

  !
  != Saturation adjustment
  !
  use saturation_adjust, only : SaturationAdjust

  ! ɽ̥եå
  ! Surface flux
  use surface_flux_bulk, only: SurfaceFlux, SurfaceFluxOutput

  !
  ! set dust flux
  !
!!$  use set_dust_flux, only : SetDustFlux

  ! եå
  ! Lower boundary flux
  !
  use lb_flux_simple, only : LBFluxSimple

  ! ήĴ
  ! Dry convective adjustment
  !
  use dry_conv_adjust, only: DryConvAdjust

  ! ̤
  ! Mass fixer
  !
  use mass_fixer, only: MassFixerColumn

  ! ٤Ⱦҥ٥, ȹ٤λ
  ! Interpolate temperature on half sigma level, 
  ! and calculate pressure and height
  !
  use auxiliary, only: AuxVars

  ! ˡˤʬΤΥ롼
  ! Routines for time integration with implicit scheme
  !
  use phy_implicit_utils, only : PhyImplEvalRadLFluxA

  ! ˡΤι (ʪ)
  ! Matrices handling for implicit scheme (for a part of physical processes)
  !
  use phy_implicit, only: PhyImplTendency

  ! ˡΤι (ʪ)
  ! Matrices handling for implicit scheme (for a part of physical processes)
  !
!!$  use phy_implicit_sdh, only:              &
!!$    & PhyImplSDHSetMethodFromMatthews,     &
!!$    & PhyImplSDHTendency,                  &
!!$    & PhyImplSDHCorSOTempBySnowMelt

  ! ˡΤι (ʪ)
  ! Matrices handling for implicit scheme (for a part of physical processes)
  !
  use phy_implicit_sdh_V2, only:       &
    & PhyImplSDHV2SetMethodMatthews,   &
    & PhyImplSDHV2Tendency,            &
    & PhyImplSDHV2CorSOTempBySnowMelt

  ! ˡˤʬ (絤Τ / ɽ̲١ھٷ׻ʤ)
  ! Time integration by using implicit scheme in case without calculation of surface and soil temperature
  !
  use phy_implicit_atmonly, only : PhyImplAtmOnlyTendency

  ! ̲٤λʬɽ
  ! Time integration of surface temperature, correction of flux on surface
  !
  use intg_surftemp, only: IntegralSurfTemp

  ! Хĥǥ
  ! Bucket model
  !
  use Bucket_Model, only :            &
    & BucketSetFlagOceanFromMatthews, &
    & BucketModEvapAndLatentHeatFlux, &
    & BucketIntegration,              &
    & BucketPRCPAdjust

  ! ե륿 (Asselin, 1972)
  ! Time filter (Asselin, 1972)
  !
  use timefilter_asselin1972, only: TimeFilter, TimeFilterSurfVars

  ! ֥ե륿 (Williams, 2009)
  ! Time filter (Williams, 2009)
  !
  use timefilter_williams2009, only: &
    & TimeFilterWilliams2009, TimeFilterWilliams2009SurfVars

  ! 
  ! Time control
  !
  use timeset, only: TimesetProgress, &
    & TimeB, &                ! ƥå $ t - \Delta t $ λ. 
                              ! Time of step $ t - \Delta t $. 
    & TimeN, &                ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
    & TimeA, &                ! ƥå $ t + \Delta t $ λ. 
                              ! Time of step $ t + \Delta t $. 
    & EndTime, &              ! ׻λ. 
                              ! End time of calculation
    & DelTime                 ! $ \Delta t $ [s]

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: RestartFileOutPut

  ! ɽ̲٥ꥹȥǡ
  ! Restart data of surface temperature input/output
  !
  use restart_surftemp_io, only: RestartSurfTempOutPut

  ! ɽ
  ! Setting of surface properties
  !
  use surface_properties, only: SetSurfaceProperties

  ! ҥȥǡ
  ! History data output
  !
  use gtool_historyauto, only: HistoryAutoPut, HistoryAutoAllVarFix

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    &                    ncmax, &
                              ! ʬο
                              ! Number of composition
    &                    a_QMixName, &
                              ! ʬѿ̾
                              ! Name of variables for composition
    &                    a_QMixLongName, &
                              ! ʬĹѿ̾
                              ! Long name of variables for composition
    &                    IndexH2OVap, &
    &                    CompositionInqIndex


  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, &  ! ٳʻ. 
                              ! Number of grid points in longitude
    &                jmax, &  ! ٳʻ. 
                              ! Number of grid points in latitude
    &                kmax     ! ľؿ. 
                              ! Number of vertical level

  ! ʪ
  ! Physical constants settings
  !
  use constants, only:  &
    & LatentHeat      , &
    & LatentHeatFusion, &
    & Grav
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration

  !
  !
  use dc_message, only: MessageNotify

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ñǥ
  ! Simple cloud
  !
  use cloud_simple, only:               &
    & CloudSimple,                      &
    & CloudSimpleWithIce,               &
    & CloudSimpleCalcCloudCover,        &
    & CloudSimpleDivideWatAndIce,       &
    & CloudSimpleCalcPRCPKeyLLTemp3D

  !  H2O ǥ
  ! Mars H2O cloud model
  !
  use cloud_mars_h2o, only : CloudMarsH2O

  ! ߲
  ! Gravitational sedimentation process
  !
  use grav_sed, only : GravSed

  ! ʬѲ
  ! Phase change of atmospheric major component
  !
  use major_comp_phase_change, only : MajorCompPhaseChangeInAtm

  ! ͽѿͤγǧ
  ! Check values of prognostic variables
  !
  use check_prog_vars, only: CheckProgVars

  ! Output frequently used variables
  ! Output frequently used variables
  !
  use output_freq_used_vars, only : OutputFreqUsedVars


  ! ʸ ; Declaration statements
  !
  implicit none

  character(*), parameter:: prog_name = 'dcpam_main'
                            ! ץ̾. 
                            ! Main program name

  ! ͽѿ (ƥå $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  !
  real(DP), allocatable:: xyz_UB (:,:,:)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind (m s-1)
  real(DP), allocatable:: xyz_VB (:,:,:)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind (m s-1)
  real(DP), allocatable:: xyz_TempB (:,:,:)
                              ! $ T (t-\Delta t) $ .   . Temperature (K)
  real(DP), allocatable:: xyzf_QMixB(:,:,:,:)
                              ! $ q (t-\Delta t) $ .   . Mass mixing ratio of constituents (1)
  real(DP), allocatable:: xy_PsB (:,:)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure (Pa)
  real(DP), allocatable:: xyz_UN (:,:,:)
                              ! $ u (t) $ .     ®. Eastward wind (m s-1)
  real(DP), allocatable:: xyz_VN (:,:,:)
                              ! $ v (t) $ .     ®. Northward wind (m s-1)
  real(DP), allocatable:: xyz_TempN (:,:,:)
                              ! $ T (t) $ .     . Temperature (K)
  real(DP), allocatable:: xyzf_QMixN(:,:,:,:)
                              ! $ q (t) $ .     . Mass mixing ratio of constituents (1)
  real(DP), allocatable:: xy_PsN (:,:)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure (Pa)
  real(DP), allocatable:: xyz_UA (:,:,:)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind (m s-1)
  real(DP), allocatable:: xyz_VA (:,:,:)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind (m s-1)
  real(DP), allocatable:: xyz_TempA (:,:,:)
                              ! $ T (t+\Delta t) $ .   . Temperature (K)
  real(DP), allocatable:: xyzf_QMixA(:,:,:,:)
                              ! $ q (t+\Delta t) $ .   . Mass mixing ratio of constituents (1)
  real(DP), allocatable:: xy_PsA (:,:)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure (Pa)

  real(DP), allocatable:: xy_SurfMajCompIceB (:,:)
                              ! $ M_mcs (t-\Delta t) $ . (kg m-2)
                              ! Surface major component ice amount (kg m-2)
  real(DP), allocatable:: xy_SoilMoistB (:,:)
                              ! $ M_ws (t-\Delta t) $ . ھʬ (kg m-2)
                              ! Soil moisture (kg m-2)
  real(DP), allocatable:: xy_SurfSnowB (:,:)
                              ! $ M_ss (t-\Delta t) $ .  (kg m-2)
                              ! Surface snow amount (kg m-2)
  real(DP), allocatable:: xy_SurfMajCompIceN (:,:)
                              ! $ M_mcs (t) $ . (kg m-2)
                              ! Surface major component ice amount (kg m-2)
  real(DP), allocatable:: xy_SoilMoistN (:,:)
                              ! $ M_ws (t) $          . ھʬ (kg m-2)
                              ! Soil moisture (kg m-2)
  real(DP), allocatable:: xy_SurfSnowN (:,:)
                              ! $ M_ss (t) $ .  (kg m-2)
                              ! Surface snow amount (kg m-2)
  real(DP), allocatable:: xy_SurfMajCompIceA (:,:)
                              ! $ M_mcs (t+\Delta t) $ . (kg m-2)
                              ! Surface major component ice amount (kg m-2)
  real(DP), allocatable:: xy_SoilMoistA (:,:)
                              ! $ M_ws (t+\Delta t) $ . ھʬ (kg m-2)
                              ! Soil moisture (kg m-2)
  real(DP), allocatable:: xy_SurfSnowA (:,:)
                              ! $ M_ss (t+\Delta t) $ .  (kg m-2)
                              ! Surface snow amount (kg m-2)


  ! ѿ, ¾
  ! Diagnostic variables, etc.
  !
  real(DP), allocatable:: xyz_DUDt (:,:,:)
                              ! $ \DP{u}{t} $ . ®Ѳ (m s-2)
                              ! Eastward wind tendency (m s-2)
  real(DP), allocatable:: xyz_DVDt (:,:,:)
                              ! $ \DP{v}{t} $ . ®Ѳ (m s-2)
                              ! Northward wind tendency (m s-2)
  real(DP), allocatable:: xyz_DTempDt (:,:,:)
                              ! $ \DP{T}{t} $ . Ѳ (K s-1)
                              ! Temperature tendency (K s-1)
  real(DP), allocatable:: xyzf_DQMixDt(:,:,:,:)
                              ! $ \DP{q}{t} $ . Ѳ (s-1)
                              ! Mass mixing ratio tendency (s-1)

  real(DP), allocatable:: xyz_DTurKinEneDt(:,:,:)
                              ! 
                              ! Turbulent kinetic energy tendency (m2 s-3)

  real(DP), allocatable:: xy_SurfHeight (:,:)
                              ! $ z_s $ . ɽ̹ (m)
                              ! Surface height (m)
  real(DP), allocatable:: xy_SurfHeightStd (:,:)
                              ! 
                              ! Surface height standard deviation(m)

  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲ (K)
                              ! Surface temperature (K)
  real(DP), allocatable:: xyz_SoilTemp(:,:,:)
                              ! ھ (K)
                              ! Soil temperature (K)


  real(DP), allocatable:: xy_SurfAlbedo (:,:)
                              ! ɽ٥ (1)
                              ! Surface albedo (1)
  real(DP), allocatable:: xy_SurfHumidCoef (:,:)
                              ! ɽ (1)
                              ! Surface humidity coefficient (1)
  real(DP), allocatable:: xy_SurfRoughLength (:,:)
                              ! ɽĹ (m)
                              ! Surface rough length (m)
  real(DP), allocatable:: xy_SurfHeatCapacity (:,:)
                              ! ɽǮ (J m-2 K-1)
                              ! Surface heat capacity (J m-2 K-1)
  real(DP), allocatable:: xy_SeaIceConc(:,:)
                              ! ɹ̩ (0 <= xy_SeaIceConc <= 1) (1)
                              ! Sea ice concentration (0 <= xy_SeaIceConc <= 1) (1)
  integer , allocatable:: xy_SurfCond (:,:)
                              ! ɽ̾ (0: , 1: ) (1)
                              ! Surface condition (0: fixed, 1: variable) (1)
  integer , allocatable:: xy_SurfType (:,:)
                              ! ɽ̥ (, Matthews ʬ) (1)
                              ! Surface type (land use type classified by Matthews) (1)
  real(DP), allocatable:: xy_DeepSubSurfHeatFlux (:,:)
                              ! Ǯեå (W m-2)
                              ! "Deep subsurface heat flux" (W m-2)
                              ! Heat flux at the bottom of surface/soil layer.
  real(DP), allocatable:: xy_SoilHeatCap (:,:)
                              ! ھǮ (J K-1 kg-1)
                              ! Specific heat of soil (J K-1 kg-1)
  real(DP), allocatable:: xy_SoilHeatDiffCoef (:,:)
                              ! ھǮƳ (J m-3 K-1)
                              ! Heat conduction coefficient of soil (J m-3 K-1)

  integer , allocatable:: xy_PhyImplSDHIndexCalcMethod(:,:)
                              !
                              ! Index for calculation method used in PhyImplSDHTendency
  logical , allocatable:: xy_BucketFlagOceanGrid(:,:)
                              !
                              ! Flag for ocean grid point used in bucket model

  real(DP), allocatable:: xyr_Temp (:,:,:)
                              ! $ \hat{T} $ .  (Ⱦ٥) (K)
                              ! Temperature (half level) (K)
  real(DP), allocatable:: xyz_VirTemp (:,:,:)
                              ! $ T_v $ .  (K)
                              ! Virtual temperature (K)
  real(DP), allocatable:: xyr_VirTemp (:,:,:)
                              ! $ \hat{T}_v $ .  (Ⱦ٥) (K)
                              ! Virtual temperature (half level) (K)
  real(DP), allocatable:: xy_SurfVirTemp (:,:)
                              ! $ \hat{T}_{v,s} $ .  (ɽ) (K)
                              ! Virtual temperature (surface) (K)
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ p $ .  (٥) (Pa)
                              ! Air pressure (full level) (Pa)
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ \hat{p} $ .  (Ⱦ٥) (Pa)
                              ! Air pressure (half level) (Pa)
  real(DP), allocatable:: xyz_Height (:,:,:)
                              !  (٥) (m)
                              ! Height (full level) (m)
  real(DP), allocatable:: xyr_Height (:,:,:)
                              !  (Ⱦ٥) (m)
                              ! Height (half level) (m)
  real(DP), allocatable:: xyz_Exner (:,:,:)
                              ! Exner ؿ (٥) (1)
                              ! Exner function (full level) (1)
  real(DP), allocatable:: xyr_Exner (:,:,:)
                              ! Exner ؿ (Ⱦ٥) (1)
                              ! Exner function (half level) (1)

  real(DP), allocatable:: xyr_RadLUwFlux (:,:,:)
                              ! Ĺȥեå (W m-2)
                              ! Upward longwave flux (W m-2)
  real(DP), allocatable:: xyr_RadLDwFlux (:,:,:)
                              ! Ĺȥեå (W m-2)
                              ! Downward longwave flux (W m-2)
  real(DP), allocatable:: xyr_RadLFlux  (:,:,:)
  real(DP), allocatable:: xyr_RadLFluxA (:,:,:)
                              ! ˡǲ򤤤ɽǮ٤Ū $ t+\Delta t $ 
                              ! Ĺȥեåη׻
                              !   * Ƿ׻줿ͤľܼΥƥå $ t $ ˤ
                              !     ĹȥեåȤѤ櫓ǤϤʤ
                              !   * ߤλ֥ƥåפˤĹͲǮΨη׻˻
                              !     
                              !
                              ! Evaluate longwave flux at $ t+\Delta t $ consistent 
                              ! with surface energy balance solved with implicit method
                              !   * The evaluated value is not used directly as Longwave
                              !     flux at next step $ t $.
                              !   * The evaluated value is used to calculate long wave 
                              !     radiative heating rate in the current time step.
  real(DP), allocatable:: xyr_RadSFlux (:,:,:)
  real(DP), allocatable:: xyr_RadSUwFlux (:,:,:)
                              ! û () եå (W m-2)
                              ! Upward shortwave flux (W m-2)
  real(DP), allocatable:: xyr_RadSDwFlux (:,:,:)
                              ! û () եå (W m-2)
                              ! Downward shortwave flux (W m-2)
  real(DP), allocatable:: xyra_DelRadLFlux   (:,:,:,:)
                              ! ĹɽѲ (W m-2)
  real(DP), allocatable:: xyra_DelRadLUwFlux (:,:,:,:)
                              ! ĹɽѲ (W m-2)
                              ! 
  real(DP), allocatable:: xyra_DelRadLDwFlux (:,:,:,:)
                              ! ĹɽѲ (W m-2)
                              ! 

  real(DP), allocatable:: xyr_MomFluxX (:,:,:)
                              ! ư̥եå
                              ! Eastward momentum flux
  real(DP), allocatable:: xyr_MomFluxY (:,:,:)
                              ! ư̥եå. 
                              ! Northward momentum flux
  real(DP), allocatable:: xyr_HeatFlux (:,:,:)
                              ! Ǯեå. 
                              ! Heat flux
  real(DP), allocatable:: xyrf_QMixFlux(:,:,:,:)
                              ! ʬ̥եå. 
                              ! Mass flux of compositions

  real(DP), allocatable:: xy_SurfMomFluxX (:,:)
                              ! ɽư̥եå
                              ! Eastward momentum flux at surface
  real(DP), allocatable:: xy_SurfMomFluxY (:,:)
                              ! ɽư̥եå. 
                              ! Northward momentum flux at surface
  real(DP), allocatable:: xy_SurfHeatFlux (:,:)
                              ! ɽǮեå. 
                              ! Heat flux at surface
  real(DP), allocatable:: xyf_SurfQMixFlux(:,:,:)
                              ! ɽʬ̥եå. 
                              ! Mass flux of compositions at surface

  real(DP), allocatable:: xy_SurfH2OVapFluxA(:,:)
                              ! ɽ̿եå.
                              ! Water vapor flux at the surface
  real(DP), allocatable:: xy_SurfLatentHeatFluxA(:,:)
                              ! ɽǮեå.
                              ! Latent heat flux at the surface
        ! NOTE:
        ! Only if the evaporation of liquid water is considered, a variable, 
        ! xy_SurfLatentHeatFlux is not required, since a latent heat flux
        ! at the surface is equal to water mass flux times latent heat. 
        ! But, if the evaporation of snow is considered, that is not the case 
        ! and a variable for the latent heat flux is required in addition to 
        ! that for the water mass flux.
        !

  real(DP), allocatable:: xyr_SoilHeatFlux (:,:,:)
                              ! ھǮեå (W m-2)
                              ! Heat flux in sub-surface soil (W m-2)

  real(DP), allocatable:: xyr_VelDiffCoef (:,:,:)
                              ! Ȼư. 
                              ! Diffusion coefficient: velocity
  real(DP), allocatable:: xyr_TempDiffCoef (:,:,:)
                              ! Ȼ. 
                              ! Transfer coefficient: temperature
  real(DP), allocatable:: xyr_QMixDiffCoef (:,:,:)
                              ! Ȼ漾. 
                              ! Diffusion coefficient: specific humidity


  real(DP), allocatable:: xy_SurfVelTransCoef (:,:)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
  real(DP), allocatable:: xy_SurfTempTransCoef (:,:)
                              ! ͢. 
                              ! Transfer coefficient: temperature
  real(DP), allocatable:: xy_SurfQVapTransCoef (:,:)
                              ! ͢
                              ! Transfer coefficient: water vapor
  real(DP), allocatable:: xyr_SoilTempTransCoef (:,:,:)
                              ! ͢ھ.
                              ! Transfer coefficient: soil temperature

  real(DP), allocatable:: xy_DSurfTempDt (:,:)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency
  real(DP), allocatable:: xyz_DSoilTempDt (:,:,:)
                              ! $ \DP{Tg}{t} $ . ھѲ (K s-1)
                              ! Temperature tendency (K s-1)

  real(DP), allocatable:: xy_DPsDt (:,:)
                              !  (Pa s-1)
                              ! Surface pressure tendency (Pa s-1)

  real(DP), allocatable:: xy_DSurfMajCompIceDt (:,:)
                              !  (kg m-2 s-1)
                              ! Surface major component ice tendency (kg m-2 s-1)
  real(DP), allocatable:: xy_DSoilMoistDt (:,:)
                              ! ھʬѲΨ (kg m-2 s-1)
                              ! Soil temperature tendency (kg m-2 s-1)
  real(DP), allocatable:: xy_DSurfSnowDt (:,:)
                              ! ѲΨ (kg m-2 s-1)
                              ! Surface snow amount tendency (kg m-2 s-1)

  real(DP), allocatable:: xyz_DTempDtVDiff(:,:,:)
                              ! ľȻˤǮΨ (K s-1)
                              ! Temperature tendency due to vertical diffusion (K s-1)

  real(DP), allocatable:: xyz_DTempDtRadL (:,:,:)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
  real(DP), allocatable:: xyz_DTempDtRadS (:,:,:)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

  real(DP), allocatable:: xyz_DUDtGWD (:,:,:)
                              ! $ \DP{u}{t} $ . ®Ѳ (m s-2)
                              ! Eastward wind tendency by gravity wave drag (m s-2)
  real(DP), allocatable:: xyz_DVDtGWD (:,:,:)
                              ! $ \DP{v}{t} $ . ®Ѳ (m s-2)
                              ! Northward wind tendency by gravity wave drag (m s-2)

  real(DP), allocatable:: xy_Rain (:,:)
                              ! ߿. 
                              ! Precipitation
  real(DP), allocatable:: xy_RainCumulus  (:,:)
                              ! 
                              ! Rain due to moist convection
  real(DP), allocatable:: xy_RainLsc      (:,:)
                              ! 
                              ! Rain due to non-convective condensation

  real(DP), allocatable:: xy_Snow (:,:)
                              ! 
                              ! Snow fall
  real(DP), allocatable:: xy_SnowCumulus  (:,:)
                              ! 
                              ! Snow fall due to moist convection
  real(DP), allocatable:: xy_SnowLsc      (:,:)
                              ! 
                              ! Snow fall due to non-convective condensation

  real(DP), allocatable:: xyz_DQH2OLiqDtCum(:,:,:)
                              ! Production rate of cloud water in the layer 
                              ! due to condensation in cumulus convection 
                              ! parameterization (kg kg-1)
  real(DP), allocatable:: xyz_DQH2OSolDtCum(:,:,:)
                              ! Production rate of cloud ice in the layer 
                              ! due to condensation in cumulus convection 
                              ! parameterization (kg kg-1)
  real(DP), allocatable:: xyz_DQH2OLiqDtLSC(:,:,:)
                              ! Production rate of cloud water in the layer 
                              ! due to condensation in large scale condensation 
                              ! (kg kg-1)
  real(DP), allocatable:: xyz_DQH2OSolDtLSC(:,:,:)
                              ! Production rate of cloud ice in the layer 
                              ! due to condensation in large scale condensation 
                              ! (kg kg-1)

  real(DP), allocatable:: xyz_QH2OLiqforRad(:,:,:)
                              ! Array for liquid water for radiation calculation
                              ! (kg kg-1)
  real(DP), allocatable:: xyz_QH2OSolforRad(:,:,:)
                              ! Array for solid water (ice) for radiation calculation
                              ! (kg kg-1)
  real(DP), allocatable:: xyz_CloudCoverforRad(:,:,:)
                              ! Cloud cover (cloud fraction)

  real(DP), allocatable:: xy_SurfDustGravSedFlux(:,:)


  ! ѿ
  ! Work variables
  !
  integer           :: IDDynMode                 ! Ѥϳز
                                                 ! Dynamics used for an experiment
  !
  integer, parameter:: IDDynModeHSPLVAS83       = 0
  integer, parameter:: IDDynModeNoHorAdv        = 1

  integer           :: IDPhysMode                 ! Ѥʪ
                                                 ! Physics used for an experiment
  !
  integer, parameter:: IDPhysModeNoPhysics       = 0
  integer, parameter:: IDPhysModeFullPhysics     = 1
  integer, parameter:: IDPhysModeHS94            = 2
  integer, parameter:: IDPhysModeVenusSimple     = 3
  integer, parameter:: IDPhysModeJupiterSimple   = 4
  integer, parameter:: IDPhysModeJupiterSimpleV2 = 5

  integer           :: IDPhyTendMethod           ! ʪˤѲΨη׻ˡ
                                                 ! Method calculating physics tendency
  !
  integer, parameter:: IDPhyTendMethodImp1LayModel = 10
  integer, parameter:: IDPhyTendMethodImpSoilModel = 11
  integer, parameter:: IDPhyTendMethodImpAtmOnly   = 12

  integer           :: IDRadMethod               ! Ͳη׻ˡ
                                                 ! Method for radiation
  !
  integer, parameter:: IDRadMethodDennouAGCM  = 20
  integer, parameter:: IDRadMethodEarthV2     = 21
  integer, parameter:: IDRadMethodMarsV1      = 22
  integer, parameter:: IDRadMethodSL09        = 23
!!$  integer, parameter:: IDRadMethodVenusSimple = 24
  integer, parameter:: IDRadMethodSimple      = 25


  integer           :: IDSfcFluxMethod          ! 
                                                ! Method for surface flux evaluation
  !
  integer, parameter:: IDSfcFluxMethodL82     = 90
  integer, parameter:: IDSfcFluxMethodBH91B94 = 91


  integer           :: IDVDiffMethod            ! 
                                                ! Method for vertical diffusion
  !
  integer, parameter:: IDVDiffMethodMY2   = 80
  integer, parameter:: IDVDiffMethodMY25  = 81


  integer           :: IDMCMethod                ! ήη׻ˡ
                                                 ! Method for moist convection

  integer, parameter:: IDMCMethodNone        = 30
  integer, parameter:: IDMCMethodMCA         = 31
  integer, parameter:: IDMCMethodRAS         = 32
  integer, parameter:: IDMCMethodRASWithIce  = 33

  integer           :: IDLSCMethod               ! 絬϶ŷ (ήŷ) η׻ˡ
                                                 ! Method for large scale condensation
                                                 ! (non-convective condensation)
  !
  integer, parameter:: IDLSCMethodNone       = 40
  integer, parameter:: IDLSCMethodM65        = 41
  integer, parameter:: IDLSCMethodLL91       = 42
  integer, parameter:: IDLSCMethodSatAdjM65  = 43
  integer, parameter:: IDLSCMethodM65WithIce = 44

  integer           :: IDCloudMethod             ! η׻ˡ
                                                 ! Method for cloud
  !
  integer, parameter:: IDCloudMethodNone          = 50
  integer, parameter:: IDCloudMethodSimple        = 51
  integer, parameter:: IDCloudMethodSimpleWithIce = 52
  integer, parameter:: IDCloudMethodMarsH2OCloud  = 53

  integer           :: IDSfcMoistMethod          ! ɽ̿ʬη׻ˡ
                                                 ! Method for surface moisture calculation
  !
  integer, parameter:: IDSfcMoistMethodNone   = 60
  integer, parameter:: IDSfcMoistMethodBucket = 61

  integer           :: IDDCMethod                ! ήη׻ˡ
                                                 ! Method for dry convection
  !
  integer, parameter:: IDDCMethodNone = 70
  integer, parameter:: IDDCMethodDCA  = 71

  integer           :: IDGWDMethod               ! 
                                                 ! Method for gravity wave drag
  !
  integer, parameter:: IDGWDMethodNone  = 80
  integer, parameter:: IDGWDMethodM1987 = 81


  logical:: firstloop = .true.
                              ! Υ롼פǤ뤳Ȥ򼨤ե饰. 
                              ! Flag implying first loop

  logical:: flag_initial
                              ! ֥롼 MainInit ꤵޤ. 
                              ! ꥹȥǡɤ߹ˤ, 
                              ! .false. , ͥǡɤ߹ˤ
                              ! .true. ꤵޤ. 
                              ! 
                              ! This variable is set in an internal 
                              ! subroutine "MainInit". 
                              ! If restart data is loaded, .false. is set. 
                              ! On the other hand, if initial data is loaded, 
                              ! .true. is set.

  integer:: n                 ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents



  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit


  ! ʬ
  ! Time integration
  !
  loop_time : do while ( TimeB < EndTime )

    ! ɽ̹٤
    ! Set surface height
    !
    call SetSurfaceProperties( &
      & xy_SurfHeight = xy_SurfHeight  & ! (inout) optional
      & )


    select case ( IDPhysMode )
    case ( IDPhysModeNoPhysics )

      xyz_DUDt     = 0.0_DP
      xyz_DVDt     = 0.0_DP
      xyz_DTempDt  = 0.0_DP
      xy_DPsDt     = 0.0_DP
      xyzf_DQMixDt = 0.0_DP

    case ( IDPhysModeHS94 )

      ! Held and Suarez (1994) ˤ붯Ȼ
      ! Forcing and dissipation suggested by Held and Suarez (1994)
      !
      call HS94Forcing( &
        & xyz_UB, xyz_VB, xyz_TempB, xy_PsB, & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt )    ! (out)
      xy_DPsDt     = 0.0_DP
      xyzf_DQMixDt = 0.0_DP

    case ( IDPhysModeVenusSimple )

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level,
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsB, xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap),    & ! (in )
        & xyr_Temp, xyz_VirTemp, xyr_VirTemp,                  & ! (out) optional
        & xyr_Press     = xyr_Press,                           & ! (out) optional
        & xyz_Press     = xyz_Press,                           & ! (out) optional
        & xy_SurfHeight = xy_SurfHeight,                       & ! (in ) optional
        & xyz_Height    = xyz_Height,                          & ! (out) optional
        & xyr_Height    = xyr_Height,                          & ! (out) optional
        & xyz_Exner     = xyz_Exner,  xyr_Exner  = xyr_Exner   & ! (out) optional
        & )

      ! ñ׻Τζ
      ! forcing for simple Venus calculation
      !
      call YT2003Forcing(                                      &
        & xy_SurfHeight,                                       & ! (in )
        & xyz_UB, xyz_VB, xyz_TempB, xyz_VirTemp, xyr_VirTemp, & ! (in )
        & xy_PsB, xyz_Press, xyr_Press, xyr_Temp,              & ! (in )
        & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,        & ! (in )
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt                      & ! (out)
        & )

      xy_DPsDt     = 0.0_DP
      xyzf_DQMixDt = 0.0_DP


    case ( IDPhysModeJupiterSimple )

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level,
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsB, xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap),  & ! (in )
        & xyr_VirTemp   = xyr_VirTemp,                       & ! (out) optional
        & xyr_Press     = xyr_Press,                         & ! (out) optional
        & xyz_Press     = xyz_Press,                         & ! (out) optional
        & xyz_Exner     = xyz_Exner,                         & ! (out) optional
        & xy_SurfHeight = xy_SurfHeight,                     & ! (out) optional
        & xyz_Height    = xyz_Height                         & ! (out) optional
        & )


      ! Schneider and Liu (2009) ˤľ
      ! Vertical diffusion by Schneider and Liu (2009)
      !
      call SL09Diffusion(                                     &
        & xy_SurfHeight, xyz_Height,                          &
        & xyz_UB, xyz_VB, xyzf_QMixB, xyr_Press, xyr_VirTemp, & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt  & ! (out)
        & )

      ! Schneider and Liu (2009) ͥǥ
      ! Radiation model by Schneider and Liu (2009)
      !
      call RadSL09Flux(                           &
        & xyr_Press, xyz_Press, xyz_TempB,        & ! (in)
        & xyr_RadSUwFlux, xyr_RadSDwFlux,         & ! (out)
        & xyr_RadLUwFlux, xyr_RadLDwFlux,         & ! (out)
        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
        & )

      ! Net flux is calculated.
      !
      xyr_RadSFlux     = xyr_RadSUwFlux     - xyr_RadSDwFlux
      xyr_RadLFlux     = xyr_RadLUwFlux     - xyr_RadLDwFlux
      xyra_DelRadLFlux = xyra_DelRadLUwFlux - xyra_DelRadLDwFlux


      ! ͤˤ벹ѲΨ
      ! Temperature tendency with radiation
      !
      call RadDTempDt(                           &
        & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, &   ! (in)
        & xyz_DTempDtRadL, xyz_DTempDtRadS )          ! (out)
      xyr_RadLDwFlux     = 0.0_DP
      xyra_DelRadLDwFlux = 0.0_DP

      ! ǮǮΨ¤η׻
      ! Sum all diabatic heating rates
      !
      xyz_DTempDt = xyz_DTempDtVDiff + xyz_DTempDtRadL + xyz_DTempDtRadS

      xy_DPsDt     = 0.0_DP


    case ( IDPhysModeJupiterSimpleV2 )

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level,
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsB, xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap),  & ! (in )
        & xyr_VirTemp   = xyr_VirTemp,                       & ! (out) optional
        & xyr_Press     = xyr_Press,                         & ! (out) optional
        & xyz_Press     = xyz_Press,                         & ! (out) optional
        & xy_SurfHeight = xy_SurfHeight,                     & ! (out) optional
        & xyz_Height    = xyz_Height,                        & ! (out) optional
        & xyz_Exner     = xyz_Exner,  xyr_Exner  = xyr_Exner & ! (out) optional
        & )


      xyr_MomFluxX (:,:,1:kmax)   = 0.0_DP
      xyr_MomFluxY (:,:,1:kmax)   = 0.0_DP
      xyr_HeatFlux (:,:,1:kmax)   = 0.0_DP
      xyrf_QMixFlux(:,:,1:kmax,:) = 0.0_DP

      xyr_VelDiffCoef  = 0.0_DP
      xyr_TempDiffCoef = 0.0_DP
      xyr_QMixDiffCoef = 0.0_DP

      ! եå
      ! Lower boundary flux
      !
      call LBFluxSimple( &
        & xyz_UB, xyz_VB, xyz_TempB, xyr_VirTemp, xyzf_QMixB,         & ! (in)
        & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner, & ! (in)
        & xyr_MomFluxX(:,:,0:0), xyr_MomFluxY(:,:,0:0), xyr_HeatFlux(:,:,0:0), xyrf_QMixFlux(:,:,0:0,:),    & ! (out)
        & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                  & ! (out)
        & xy_SurfQVapTransCoef                                        & ! (out)
        & )

      call PhyImplAtmOnlyTendency(                                 &
        & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
        & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
        & xyr_VirTemp, xyz_Height,                                 & ! (in)
        & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,     & ! (in)
        & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
        & xy_SurfQVapTransCoef,                                    & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt       & ! (out)
        & )

      xy_DPsDt             = 0.0_DP

      ! Schneider and Liu (2009) ͥǥ
      ! Radiation model by Schneider and Liu (2009)
      !
      call RadSL09Flux(                           &
        & xyr_Press, xyz_Press, xyz_TempB,        & ! (in)
        & xyr_RadSUwFlux, xyr_RadSDwFlux,         & ! (out)
        & xyr_RadLUwFlux, xyr_RadLDwFlux,         & ! (out)
        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
        & )

      ! Net flux is calculated.
      !
      xyr_RadSFlux     = xyr_RadSUwFlux     - xyr_RadSDwFlux
      xyr_RadLFlux     = xyr_RadLUwFlux     - xyr_RadLDwFlux
      xyra_DelRadLFlux = xyra_DelRadLUwFlux - xyra_DelRadLDwFlux


      ! ͤˤ벹ѲΨ
      ! Temperature tendency with radiation
      !
      call RadDTempDt(                           &
        & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, &   ! (in)
        & xyz_DTempDtRadL, xyz_DTempDtRadS )          ! (out)
      xyr_RadLDwFlux     = 0.0_DP
      xyra_DelRadLDwFlux = 0.0_DP

      ! ǮǮΨ¤η׻
      ! Sum all diabatic heating rates
      !
      xyz_DTempDt = xyz_DTempDtVDiff + xyz_DTempDtRadL + xyz_DTempDtRadS


    case ( IDPhysModeFullPhysics )

      ! ɽ̾
      ! Configure surface conditions
      !
      call SetSurfaceProperties(                           &
        & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in)    optional
        & xy_SurfTemp            = xy_SurfTemp,            & ! (inout) optional
        & xy_SurfAlbedo          = xy_SurfAlbedo,          & ! (inout) optional
        & xy_SurfHumidCoef       = xy_SurfHumidCoef,       & ! (inout) optional
        & xy_SurfRoughLength     = xy_SurfRoughLength,     & ! (inout) optional
        & xy_SurfHeatCapacity    = xy_SurfHeatCapacity,    & ! (inout) optional
        & xy_DeepSubSurfHeatFlux = xy_DeepSubSurfHeatFlux, & ! (inout) optional
        & xy_SurfCond            = xy_SurfCond,            & ! (inout) optional
        & xy_SurfType            = xy_SurfType,            & ! (inout) optional
        & xy_SeaIceConc          = xy_SeaIceConc,          & ! (inout) optional
        & xy_SoilHeatCap         = xy_SoilHeatCap,         & ! (inout) optional
        & xy_SoilHeatDiffCoef    = xy_SoilHeatDiffCoef,    & ! (inout) optional
        & xy_SurfHeightStd       = xy_SurfHeightStd        & ! (inout) optional
        & )

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsB, xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap),    & ! (in )
        & xyr_Temp, xyz_VirTemp, xyr_VirTemp, xy_SurfVirTemp,  & ! (out) optional
        & xyr_Press     = xyr_Press,                           & ! (out) optional
        & xyz_Press     = xyz_Press,                           & ! (out) optional
        & xy_SurfHeight = xy_SurfHeight, xy_SurfTemp = xy_SurfTemp, & ! (in ) optional
        & xyz_Height    = xyz_Height, xyr_Height = xyr_Height, & ! (out) optional
        & xyz_Exner     = xyz_Exner,  xyr_Exner  = xyr_Exner   & ! (out) optional
        & )


      select case ( IDRadMethod )
      case ( IDRadMethodDennouAGCM )

        ! ͥեå (GFD Ǿȯͥǥ)
        ! Radiation flux (radiation model developed by GFD Dennou Club)
        !
        call RadDennouAGCMFlux(                                  &
          & xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap), xyr_Press, &   ! (in)
          & xy_SurfTemp, xy_SurfAlbedo,      &   ! (in)
          & xyr_RadSUwFlux, xyr_RadSDwFlux,            & ! (out)
          & xyr_RadLUwFlux, xyr_RadLDwFlux,            & ! (out)
          & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux     & ! (out)
          & )


      case ( IDRadMethodEarthV2 )

        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if

        ! 
        ! Cloud model
        !
        select case ( IDCloudMethod )
        case ( IDCloudMethodNone )
          xyz_QH2OLiqforRad = xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OLiq' ))
          xyz_QH2OSolforRad = 0.0_DP
        case ( IDCloudMethodSimple )
          xyz_QH2OLiqforRad = xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OLiq' ))
          xyz_QH2OSolforRad = 0.0_DP
        case ( IDCloudMethodSimpleWithIce )
          if ( CompositionInqIndex( 'H2OSol' ) <= 0 ) then
            call MessageNotify( 'E', prog_name, 'H2OSol is not found.' )
          end if
          xyz_QH2OLiqforRad = xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OLiq' ))
          xyz_QH2OSolforRad = xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OSol' ))
        end select

!!$        call CloudSimpleDivideWatAndIce(                           &
!!$          & xyz_TempB,                                             & ! (in )
!!$          & xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OLiq' )),     & ! (in )
!!$          & xyz_QH2OLiqforRad, xyz_QH2OSolforRad                   & ! (out)
!!$          & )

        ! Cloud cover is calculated.
        !
        select case ( IDCloudMethod )
        case ( IDCloudMethodNone )
          xyz_CloudCoverforRad = 1.0_DP
        case ( IDCloudMethodSimple )
          call CloudSimpleCalcCloudCover(                            &
            & xyz_Press, xyz_TempB,                                  & ! (in )
            & xyzf_QMixB(:,:,:,IndexH2OVap)                          &
            & + xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OLiq' )),   & ! (in )
            & xyz_CloudCoverforRad                                   & ! (out)
            & )
        case ( IDCloudMethodSimpleWithIce )
          call CloudSimpleCalcCloudCover(                            &
            & xyz_Press, xyz_TempB,                                  & ! (in )
            & xyzf_QMixB(:,:,:,IndexH2OVap)                          &
            & + xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OLiq' ))    & ! (in )
            & + xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OSol' )),   & ! (in )
            & xyz_CloudCoverforRad                                   & ! (out)
            & )
        end select

        call RadEarthV2Flux(                              &
          & xy_SurfAlbedo,                                &
          & xyz_Press, xyr_Press, xyz_TempB,              &
          & xyzf_QMixB(:,:,:,IndexH2OVap),                &
          & xyz_QH2OLiqforRad, xyz_QH2OSolforRad,         &
          & xyz_CloudCoverforRad,                         &
          & xy_SurfTemp,                                  &
          & xyr_RadSUwFlux, xyr_RadSDwFlux,               &
          & xyr_RadLUwFlux, xyr_RadLDwFlux,               & ! (out)
          & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux        & ! (out)
          & )

      case ( IDRadMethodMarsV1 )

        if ( CompositionInqIndex( 'Dust' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'Dust is not found.' )
        end if

        call RadMarsV1Flux(                                          &
          & xy_SurfType, xy_SurfMajCompIceB,                         &
          & xy_SurfAlbedo,                                           &
          & xyz_Press, xyr_Press, xyz_TempB, xyr_Temp, xy_SurfTemp,  &
          & xyzf_QMixB(:,:,:,CompositionInqIndex( 'Dust' )),         & ! (in )
          & xyr_RadSUwFlux, xyr_RadSDwFlux,                          &
          & xyr_RadLUwFlux, xyr_RadLDwFlux,                          &
          & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   &
          & )

      case ( IDRadMethodSL09 )

        ! Schneider and Liu (2009) ͥǥ
        ! Radiation model by Schneider and Liu (2009)
        !
        call RadSL09Flux(                           &
          & xyr_Press, xyz_Press, xyz_TempB,        & ! (in)
          & xyr_RadSUwFlux, xyr_RadSDwFlux,         & ! (out)
          & xyr_RadLUwFlux, xyr_RadLDwFlux,         & ! (out)
          & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
          & )

      case ( IDRadMethodSimple )

        ! ñͥǥ
        ! Simple radiation model
        !
        call RadSimpleFlux(                                              &
          & xy_SurfAlbedo, xy_SurfTemp, xyr_Press, xyz_Press, xyz_TempB, &
          & xyzf_QMixB(:,:,:,IndexH2OVap),                               &
          & xyr_RadSUwFlux, xyr_RadSDwFlux,                              &
          & xyr_RadLUwFlux, xyr_RadLDwFlux,                              &
          & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                       &
          & )

      end select

      ! Net flux is calculated.
      !
      xyr_RadSFlux     = xyr_RadSUwFlux     - xyr_RadSDwFlux
      xyr_RadLFlux     = xyr_RadLUwFlux     - xyr_RadLDwFlux
      xyra_DelRadLFlux = xyra_DelRadLUwFlux - xyra_DelRadLDwFlux


      ! ɽ̥եå
      ! Surface flux
      !
      select case ( IDSfcFluxMethod )
      case ( IDSfcFluxMethodL82 )

        call SurfaceFlux(                                                  &
          & 'L82',                                                         & ! (in)
          & xyz_UB, xyz_VB,                                                & ! (in)
          & xyz_TempB, xyr_Temp, xyz_VirTemp, xyr_VirTemp, xy_SurfVirTemp, & ! (in)
          & xyzf_QMixB,                                                    & ! (in)
          & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner,   & ! (in)
          & xy_SurfTemp, xy_SurfHumidCoef,                                & ! (in)
          & xy_SurfRoughLength, xy_SurfRoughLength,                       & ! (in)
          & xy_SurfMomFluxX, xy_SurfMomFluxY, xy_SurfHeatFlux, xyf_SurfQMixFlux, & ! (out)
          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                    & ! (out)
          & xy_SurfQVapTransCoef                                          & ! (out)
          & )

      case ( IDSfcFluxMethodBH91B94 )

        call SurfaceFlux(                                                 &
          & 'BH91B94',                                                    & ! (in)
          & xyz_UB, xyz_VB,                                               & ! (in)
          & xyz_TempB, xyr_Temp, xyz_VirTemp, xyr_VirTemp, xy_SurfVirTemp, & ! (in)
          & xyzf_QMixB,                                                    & ! (in)
          & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner,   & ! (in)
          & xy_SurfTemp, xy_SurfHumidCoef,                                & ! (in)
          & xy_SurfRoughLength, xy_SurfRoughLength,                       & ! (in)
          & xy_SurfMomFluxX, xy_SurfMomFluxY, xy_SurfHeatFlux, xyf_SurfQMixFlux, & ! (out)
          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                    & ! (out)
          & xy_SurfQVapTransCoef                                          & ! (out)
          & )

      end select
      !
      ! set dust flux
      !   This is ad hoc treatment now (yot, 2013/09/28)
      !
!!$      if ( CompositionInqIndex('Dust') > 0 ) then
!!$        call SetDustFlux(                                       &
!!$          & xyf_SurfQMixFlux(:,:,CompositionInqIndex('Dust'))   & ! (out)
!!$          & )
!!$      end if


      ! ľȻեå
      ! Vertical diffusion flux
      !
      select case ( IDVDiffMethod )
      case ( IDVDiffMethodMY2 )

        call VDiffusion(                                              &
          & xyz_UB,     xyz_VB,     xyzf_QMixB,                       & ! (in)
          & xyz_TempB, xyr_Temp, xyz_VirTemp, xyr_VirTemp, xyr_Press, & ! (in)
          & xy_SurfHeight,                                            & ! (in)
          & xyz_Height, xyr_Height, xyz_Exner,    xyr_Exner,          & ! (in)
          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,  & ! (out)
          & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef       & ! (out)
          & )

      case ( IDVDiffMethodMY25 )

        if ( CompositionInqIndex( 'TKE' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'TKE is not found.' )
        end if

        call VDiffusionMY25(                                          &
!!$        call VDiffusionMY251DWrapper3D(                               &
!!$        call VDiffusionMY25GBT94(                                     &
          & xyz_UB,     xyz_VB,     xyzf_QMixB,                       & ! (in)
          & xyz_TempB, xyr_Temp, xyz_VirTemp, xyr_VirTemp, xyr_Press, & ! (in)
          & xy_SurfHeight,                                            & ! (in)
          & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,             & ! (in)
          & xyzf_QMixB(:,:,:,CompositionInqIndex( 'TKE' )),           & ! (in )
          & xy_SurfMomFluxX, xy_SurfMomFluxY,                         & ! (in)
          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,  & ! (out)
          & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,      & ! (in)
          & xyz_DTurKinEneDt                                          & ! (out)
          & )

      end select

      xyr_MomFluxX (:,:,0)   = xy_SurfMomFluxX
      xyr_MomFluxY (:,:,0)   = xy_SurfMomFluxY
      xyr_HeatFlux (:,:,0)   = xy_SurfHeatFlux
      xyrf_QMixFlux(:,:,0,:) = xyf_SurfQMixFlux


      ! ʪλѲΨη׻ (ˡ)
      ! Calculate tendency by a part of physical processes (implicit)
      !
      select case ( IDPhyTendMethod )
      case ( IDPhyTendMethodImp1LayModel )

        call PhyImplTendency(                                        &
          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
          & xyr_RadSFlux, xyr_RadLFlux,                              & ! (in)
          & xy_DeepSubSurfHeatFlux,                                  & ! (in)
          & xy_SurfTemp, xy_SurfHumidCoef, xy_SurfCond,              & ! (in)
          & xy_SurfHeatCapacity,                                     & ! (in)
          & xyra_DelRadLFlux,                                        & ! (in)
          & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
          & xyr_VirTemp, xyz_Height,                                 & ! (in)
          & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,     & ! (in)
          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
          & xy_SurfQVapTransCoef,                                    & ! (in)
          & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt,      & ! (out)
          & xy_DSurfTempDt                                           & ! (out)
          & )

        xy_SurfH2OVapFluxA     = 0.0_DP
        xy_SurfLatentHeatFluxA = 0.0_DP

        xyz_DSoilTempDt      = 0.0_DP
        xy_DPsDt             = 0.0_DP
        xy_DSurfMajCompIceDt = 0.0_DP
        xy_DSoilMoistDt      = 0.0_DP
        xy_DSurfSnowDt       = 0.0_DP

      case ( IDPhyTendMethodImpSoilModel )


        ! ϲˤǮαľȻ
        ! Vertical diffusion of heat under the ground
        !
        call SubsurfaceDiffusion(                    &
          & xy_DeepSubSurfHeatFlux,                  &          ! (in)
          & xy_SoilHeatCap, xy_SoilHeatDiffCoef,     &          ! (in )
          & xy_SurfTemp, xyz_SoilTemp,               &          ! (in)
          & xyr_SoilTempTransCoef, xyr_SoilHeatFlux  &          ! (out)
          & )


        ! This value is not correct, if snow evaporates. 
        ! If a bucket model is used, this surface latent heat flux is 
        ! corrected in BucketModEvapAndLatentHeatFlux by the use of surface 
        ! moisture and surface snow amount. 
        !
!!$        xy_SurfLatentHeatFluxA = LatentHeat * xyrf_QMixFlux(:,:,0,IndexH2OVap)


!!$        select case ( IDSfcMoistMethod )
!!$        case ( IDSfcMoistMethodBucket )
!!$          ! ХĥǥΤɽ̥եå
!!$          ! Modification of surface flux for bucket model
!!$          !
!!$          call BucketSetFlagOceanFromMatthews( &
!!$            & xy_SurfType,                     & ! (in)
!!$            & xy_BucketFlagOceanGrid           & ! (out)
!!$            & )
!!$          call BucketModEvapAndLatentHeatFlux(                         &
!!$            & xy_BucketFlagOceanGrid, xy_SoilMoistB, xy_SurfSnowB,     & ! (in   )
!!$            & xyrf_QMixFlux(:,:,0,IndexH2OVap), xy_SurfLatentHeatFluxA & ! (inout)
!!$            & )
!!$        end select



!!$        call PhyImplSDHSetMethodFromMatthews(  &
!!$          & xy_SurfType, xy_SeaIceConc,        & ! (in)
!!$          & xy_PhyImplSDHIndexCalcMethod       & ! (out)
!!$          & )
!!$        call PhyImplSDHTendency(                                      &
!!$          & xy_PhyImplSDHIndexCalcMethod,                             & ! (in)
!!$          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,  & ! (in)
!!$          & xy_SurfLatentHeatFluxA,                                   & ! (in)
!!$          & xyr_SoilHeatFlux,                                         & ! (in)
!!$          & xyr_RadSFlux, xyr_RadLFlux,                               & ! (in)
!!$          & xy_DeepSubSurfHeatFlux,                                   & ! (in)
!!$          & xy_SurfTemp, xyz_SoilTemp,                                & ! (in)
!!$          & xy_SurfHumidCoef,                                         & ! (in)
!!$          & xy_SurfHeatCapacity,                                      & ! (in)
!!$          & xy_SoilHeatCap, xy_SoilHeatDiffCoef,                      & ! (in)
!!$          & xyra_DelRadLFlux,                                         & ! (in)
!!$          & xyr_Press, xyz_Exner, xyr_Exner,                          & ! (in)
!!$          & xyr_VelTransCoef, xyr_TempTransCoef,                      & ! (in)
!!$          & xyr_QMixTransCoef,                                        & ! (in)
!!$          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                & ! (in)
!!$          & xy_SurfQVapTransCoef,                                     & ! (in)
!!$          & xyr_SoilTempTransCoef,                                    & ! (in)
!!$          & xy_SurfMajCompIceB,                                       & ! (in)
!!$          & xy_SurfSnowB,                                             & ! (in)
!!$          & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt,       & ! (out)
!!$          & xy_DSurfTempDt,                                           & ! (out)
!!$          & xyz_DSoilTempDt,                                          & ! (out)
!!$          & xy_DPsDt, xy_DSurfMajCompIceDt,                           & ! (out)
!!$          & xy_DSoilMoistDt,                                          & ! (out)
!!$          & xy_DSurfSnowDt                                            & ! (out)
!!$          & )

!!$        ! This is temporal treatment.
!!$        xy_SurfH2OVapFluxA = xyrf_QMixFlux(:,:,0,IndexH2OVap)

        call PhyImplSDHV2SetMethodMatthews(  &
          & xy_SurfType, xy_SeaIceConc,      & ! (in)
          & xy_PhyImplSDHIndexCalcMethod     & ! (out)
          & )
        select case ( IDSfcMoistMethod )
        case ( IDSfcMoistMethodBucket )
          call BucketSetFlagOceanFromMatthews( &
            & xy_SurfType,                     & ! (in)
            & xy_BucketFlagOceanGrid           & ! (out)
            & )
        case default
          xy_BucketFlagOceanGrid = .true.
        end select
        call PhyImplSDHV2Tendency(                                   &
          & xy_PhyImplSDHIndexCalcMethod, xy_BucketFlagOceanGrid,    & ! (in)
          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
          & xy_SurfH2OVapFluxA, xy_SurfLatentHeatFluxA,              & ! (out)
          & xyr_SoilHeatFlux,                                        & ! (in)
          & xyr_RadSFlux, xyr_RadLFlux,                              & ! (in)
          & xy_DeepSubSurfHeatFlux,                                  & ! (in)
          & xyz_TempB, xy_SurfTemp, xyz_SoilTemp,                    & ! (in)
          & xyzf_QMixB,                                              & ! (in)
          & xy_SurfHumidCoef,                                        & ! (in)
          & xy_SurfHeatCapacity,                                     & ! (in)
          & xy_SoilHeatCap, xy_SoilHeatDiffCoef,                     & ! (in)
          & xyra_DelRadLFlux,                                        & ! (in)
          & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
          & xyr_VirTemp, xyz_Height,                                 & ! (in)
          & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,     & ! (in)
          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
          & xy_SurfQVapTransCoef,                                    & ! (in)
          & xyr_SoilTempTransCoef,                                   & ! (in)
          & xy_SurfMajCompIceB,                                      & ! (in)
          & xy_SoilMoistB, xy_SurfSnowB,                             & ! (in)
          & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt,      & ! (out)
          & xy_DSurfTempDt,                                          & ! (out)
          & xyz_DSoilTempDt,                                         & ! (out)
          & xy_DPsDt, xy_DSurfMajCompIceDt,                          & ! (out)
          & xy_DSoilMoistDt,                                         & ! (out)
          & xy_DSurfSnowDt                                           & ! (out)
          & )

      case ( IDPhyTendMethodImpAtmOnly )

        call PhyImplAtmOnlyTendency(                           &
          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
          & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
          & xyr_VirTemp, xyz_Height,                                 & ! (in)
          & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,     & ! (in)
          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
          & xy_SurfQVapTransCoef,                                    & ! (in)
          & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt       & ! (out)
          & )

        xy_DSurfTempDt       = 0.0_DP
        xyz_DSoilTempDt      = 0.0_DP
        xy_DPsDt             = 0.0_DP
        xy_DSurfMajCompIceDt = 0.0_DP
        xy_DSoilMoistDt      = 0.0_DP
        xy_DSurfSnowDt       = 0.0_DP

        xy_SurfH2OVapFluxA     = 0.0_DP
        xy_SurfLatentHeatFluxA = 0.0_DP

      end select


      ! Overwrite tendency of turbulent kinetic energy
      !
      select case ( IDVDiffMethod )
      case ( IDVDiffMethodMY25 )
        if ( CompositionInqIndex( 'TKE' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'TKE is not found.' )
        end if
        xyzf_DQMixDt(:,:,:,CompositionInqIndex( 'TKE' )) = &
          & xyz_DTurKinEneDt
      end select


      ! Gravity wave drag
      ! Gravity wave drag
      !
      select case ( IDGWDMethod )
      case ( IDGWDMethodNone )

        xyz_DUDtGWD = 0.0_DP
        xyz_DVDtGWD = 0.0_DP

      case ( IDGWDMethodM1987 )

        ! Gravity wave drag by McFarlane (1987)
        ! Gravity wave drag by McFarlane (1987)
        !
        call GWDM1987(                                       &
          & xyz_UB, xyz_VB, xyz_TempB,                       & ! (in)
          & xyz_Press, xyr_Press, xyz_Exner, xyz_Height,     & ! (in)
          & xy_SurfHeightStd,                                & ! (in)
          & xyz_DUDtGWD, xyz_DVDtGWD                         & ! (out)
          & )
        xyz_DUDt = xyz_DUDt + xyz_DUDtGWD
        xyz_DVDt = xyz_DVDt + xyz_DVDtGWD

      end select


      ! ˡǲ򤤤ɽǮ٤Ū $ t+\Delta t $ ˤĹ
      ! եåη׻
      !   * Ƿ׻줿ͤľܼΥƥå $ t $ ˤĹȥեå
      !     Ȥ
      !   * Ѥ櫓ǤϤʤ
      !   * ߤλ֥ƥåפˤĹͲǮΨη׻˻Ȥ
      !
      ! Evaluate longwave flux at $ t+\Delta t $ consistent with surface 
      ! energy balance solved with implicit method
      !   * The evaluated value is not used directly as Longwave flux at next 
      !     step $t$.
      !   * The evaluated value is used to calculate long wave radiative 
      !     heating rate 
      !     in the current time step.
      !
      call PhyImplEvalRadLFluxA( &
        & xyr_RadLFlux, &                                  ! (in)
        & xyz_DTempDtVDiff, xy_DSurfTempDt, xyra_DelRadLFlux, & ! (in)
        & xyr_RadLFluxA )                                  ! (out)

      ! ͤˤ벹ѲΨ
      ! Temperature tendency with radiation
      !
      call RadDTempDt(                            &
        & xyr_RadLFluxA, xyr_RadSFlux, xyr_Press, &   ! (in)
        & xyz_DTempDtRadL, xyz_DTempDtRadS )          ! (out)

!!$      select case ( IDRadMethod )
!!$      case ( IDRadMethodMarsV1 )
!!$        ! (絤) Non-LTE ͥǥ
!!$        ! Non-NLTE radiation model (for the Mars' atmosphere)
!!$        !
!!$        call rad15mNLTEMergeHR(                &
!!$          & xyz_Press, xyz_TempB, xyz_VirTemp, &
!!$          & xyz_DTempDtRadL                    &
!!$          & )
!!$      end select

      ! ǮǮΨ¤η׻
      ! Sum all diabatic heating rates
      !
      xyz_DTempDt = xyz_DTempDtVDiff + xyz_DTempDtRadL + xyz_DTempDtRadS


      select case ( IDRadMethod )
      case ( IDRadMethodMarsV1 )
        ! ׻ѶֳǮΨ׻
        ! Calculation of near infrared heating rate in the case of Mars
        !
        call RadMarsNIRINOUT(     &
          & xyz_Press,            &  ! (in)
          & xyz_DTempDt           &  ! (inout)
          & )
      end select


      ! ľȻեåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output Vertical diffusion fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call VDiffusionOutput(                                       &
        & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
        & xyz_DUDt,  xyz_DVDt,  xyz_DTempDtVDiff,  xyzf_DQMixDt,   & ! (in)
        & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
        & xyr_VirTemp, xyz_Height,                                 & ! (in)
        & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef      & ! (in)
        & )

      ! ɽ̥եåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output surface fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call SurfaceFluxOutput(                                       &
        & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,  & ! (in)
        & xy_SurfH2OVapFluxA, xy_SurfLatentHeatFluxA,               & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt,       & ! (in)
        & xy_SurfTemp, xy_DSurfTempDt,                              & ! (in)
        & xyr_Press, xyz_Exner, xyr_Exner, xy_SurfHumidCoef,        & ! (in)
        & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                & ! (in)
        & xy_SurfQVapTransCoef                                      & ! (in)
        & )

      ! ͥեåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output radiation fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call RadFluxOutput(                                &
        & xyr_RadSUwFlux, xyr_RadSDwFlux,                & ! (in)
        & xyr_RadLUwFlux, xyr_RadLDwFlux,                & ! (in)
        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux,        & ! (in)
        & xy_DSurfTempDt, xyz_DTempDtVDiff               & ! (in)
        & )

    end select


    ! ̲١ھ١ھʬ̤ʬ
    ! Time integration of surface temperature, soil temperature, soil 
    ! moisture, and surface snow amount
    !
    select case ( IDPhysMode )
    case ( IDPhysModeFullPhysics )

      ! ̲١ھ٤λʬ
      ! Time integration of surface temperature and soil temperature
      !
      call IntegralSurfTemp( &
        & xy_DSurfTempDt, xyz_DSoilTempDt, &     ! (in)
        & xy_SurfTemp   , xyz_SoilTemp     &     ! (inout)
        & )

      select case ( IDSfcMoistMethod )
      case ( IDSfcMoistMethodNone )
        xy_SoilMoistA = xy_SoilMoistB
        xy_SurfSnowA  = xy_SurfSnowB
      case ( IDSfcMoistMethodBucket )
        ! ھʬ̤λʬ
        ! Time integration of soil moisture and snow amount
        !
        call BucketSetFlagOceanFromMatthews( &
          & xy_SurfType,                     & ! (in)
          & xy_BucketFlagOceanGrid           & ! (out)
          & )
        call BucketIntegration(              &
          & xy_BucketFlagOceanGrid,          & ! (in )
          & xy_DSoilMoistDt, xy_DSurfSnowDt, & ! (in )
          & xy_SoilMoistB, xy_SurfSnowB,     & ! (in )
          & xy_SoilMoistA, xy_SurfSnowA      & ! (out)
          & )
      end select

      xy_SurfMajCompIceA = xy_SurfMajCompIceB + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )

    end select


    ! ϳز
    ! Dynamical core
    !
    select case ( IDDynMode )
    case ( IDDynModeHSPLVAS83 )
      call DynamicsHSplVAS83( &
        & xyz_UB,   xyz_VB,   xyz_TempB,   xyzf_QMixB,   xy_PsB, &   ! (in)
        & xyz_UN,   xyz_VN,   xyz_TempN,   xyzf_QMixN,   xy_PsN, &   ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt, &           ! (in)
        & xy_SurfHeight, &                                             ! (in)
        & xyz_UA,   xyz_VA,   xyz_TempA,   xyzf_QMixA,   xy_PsA  &   ! (out)
        & )
    case ( IDDynModeNoHorAdv )
      call DynamicsPhysicsOnly(                          &
        & xyz_Exner, xy_SurfHeight, xyz_Height,          & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt, & ! (in)
        & xy_PsB, xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, & ! (in)
        & xy_PsN, xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, & ! (in)
        & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA  & ! (out)
        & )
    end select


    ! Surface pressure is temporarily adjusted, here.
    !
    xy_PsA = xy_PsA + xy_DPsDt * ( 2.0_DP * DelTime )




    select case ( IDPhysMode )
    case ( IDPhysModeJupiterSimple )
      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsA, xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),  & ! (in)
        & xyz_Press = xyz_Press,                             & ! (out) optional
        & xyr_Press = xyr_Press                              & ! (out) optional
        & )

      select case ( IDDCMethod )
      case ( IDDCMethodDCA )
        ! ήĴ
        ! Dry convective adjustment
        !
        call DryConvAdjust(                        &
          & xyz_TempA, xyz_UA, xyz_VA, xyzf_QMixA, &  ! (inout)
          & xyz_Press, xyr_Press                   &  ! (in)
          & )
      end select

    case ( IDPhysModeJupiterSimpleV2 )
      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsA, xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),  & ! (in)
        & xyz_Press = xyz_Press,                             & ! (out) optional
        & xyr_Press = xyr_Press                              & ! (out) optional
        & )

      ! ήĴ
      ! Moist convective adjustment
      !
      call MoistConvAdjust( &
        & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),      & ! (inout)
        & xyz_Press, xyr_Press,                          & ! (in)
        & xyz_DQH2OLiqDtCum                              & ! (out)
        & )

      ! 絬϶ŷ (ήŷ) (Manabe, 1965)
      ! Large scale condensation (non-convective condensation) 
      ! (Manabe, 1965)
      !
      call LScaleCond( &
        & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),        & ! (inout)
        & xyz_Press, xyr_Press,                            & ! (in)
        & xyz_DQH2OLiqDtLSC                                & ! (out)
        & )

      call CloudSimpleCalcPRCPKeyLLTemp3D(           &
        & xyr_Press, xyz_Press, xyz_DQH2OLiqDtCum,   &  ! (in )
        & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),  &  ! (in )
        & xy_RainCumulus, xy_SnowCumulus             &  ! (out)
        & )
      call CloudSimpleCalcPRCPKeyLLTemp3D(           &
        & xyr_Press, xyz_Press, xyz_DQH2OLiqDtLsc,   &  ! (in )
        & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),  &  ! (in )
        & xy_RainLsc, xy_SnowLsc                     &  ! (out)
        & )

      xy_Rain = xy_RainCumulus + xy_RainLsc
      xy_Snow = xy_SnowCumulus + xy_SnowLsc

      select case ( IDDCMethod )
      case ( IDDCMethodDCA )
        ! ήĴ
        ! Dry convective adjustment
        !
        call DryConvAdjust(                        &
          & xyz_TempA, xyz_UA, xyz_VA, xyzf_QMixA, &  ! (inout)
          & xyz_Press, xyr_Press                   &  ! (in)
          & )
      end select

      ! ʬμ̤
      ! Fix masses of constituents
      !
      call MassFixerColumn( &
        & xyr_Press,  & ! (in)
        & xyzf_QMixA  & ! (inout)
        & )

    case ( IDPhysModeFullPhysics )

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsA, xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap), & ! (in )
        & xyr_Press     = xyr_Press,                        & ! (out) optional
        & xyz_Press     = xyz_Press,                        & ! (out) optional
        & xyz_Exner     = xyz_Exner, xyr_Exner = xyr_Exner, & ! (out) optional
        & xy_SurfHeight = xy_SurfHeight,                    & ! (in ) optional
        & xyr_Height    = xyr_Height,                       & ! (out) optional
        & xyz_Height    = xyz_Height                        & ! (out) optional
        & )

!!$      ! Gravity wave drag
!!$      ! Gravity wave drag
!!$      !
!!$      select case ( IDGWDMethod )
!!$      case ( IDGWDMethodNone )
!!$
!!$        xyz_DUDtGWD = 0.0_DP
!!$        xyz_DVDtGWD = 0.0_DP
!!$
!!$      case ( IDGWDMethodM1987 )
!!$
!!$        ! Gravity wave drag by McFarlane (1987)
!!$        ! Gravity wave drag by McFarlane (1987)
!!$        !
!!$        call GWDM1987(                                       &
!!$          & xyz_UA, xyz_VA, xyz_TempA,                       & ! (in)
!!$          & xyz_Press, xyr_Press, xyz_Exner, xyz_Height,     & ! (in)
!!$          & xy_SurfHeightStd,                                & ! (in)
!!$          & xyz_DUDtGWD, xyz_DVDtGWD                         & ! (out)
!!$          & )
!!$        xyz_UA = xyz_UA + xyz_DUDtGWD * ( 2.0_DP * DelTime )
!!$        xyz_VA = xyz_VA + xyz_DVDtGWD * ( 2.0_DP * DelTime )
!!$
!!$      end select


      ! ѱѥ᥿ꥼ
      ! Cumulus parameterization
      !
      select case ( IDMCMethod )
      case ( IDMCMethodNone )

        xyz_DQH2OLiqDtCum = 0.0_DP

      case ( IDMCMethodMCA )

        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if

        ! ήĴ
        ! Moist convective adjustment
        !
        call MoistConvAdjust( &
          & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),      & ! (inout)
          & xyz_Press, xyr_Press,                          & ! (in)
          & xyz_DQH2OLiqDtCum                              & ! (out)
          & )

        ! It would be better that lines below are included in 
        ! RelaxedArakawaSchubert subroutine.
        xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )) = &
          &   xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )) &
          & + xyz_DQH2OLiqDtCum * 2.0_DP * DelTime
        xyz_DQH2OLiqDtCum = 0.0_DP

      case ( IDMCMethodRAS )

        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if

        ! Relaxed Arakawa-Schubert scheme
        ! Relaxed Arakawa-Schubert scheme
        !
        call RAS( &
          & xy_SurfTemp,                                 &  ! (in)
          & xyz_Press, xyr_Press, xyz_Exner, xyr_Exner,  &  ! (in)
          & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),    &  ! (inout)
          & xyz_DQH2OLiqDtCum                            &  ! (out) optional
          & )

        ! It would be better that lines below are included in 
        ! RelaxedArakawaSchubert subroutine.
        xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )) = &
          &   xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )) &
          & + xyz_DQH2OLiqDtCum * 2.0_DP * DelTime
        xyz_DQH2OLiqDtCum = 0.0_DP
        xyz_DQH2OSolDtCum = 0.0_DP

      case ( IDMCMethodRASWithIce )
        ! Relaxed Arakawa-Schubert scheme
        ! Relaxed Arakawa-Schubert scheme
        !
        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if
        if ( CompositionInqIndex( 'H2OSol' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OSol is not found.' )
        end if

        ! It should be noted that H2OLiq and H2OSol have updated. 
        ! But, DQH2OLiqDtCum and DQH2OSolDtCum are not zero, so those
        ! will be set zero below.
        call RASWithIce1DWrapper3DWrapper( &
          & xy_SurfTemp,                                 &  ! (in)
          & xyz_Press, xyr_Press, xyz_Exner, xyr_Exner,  &  ! (in)
          & xyz_TempA,                                   &  ! (inout)
          & xyzf_QMixA(:,:,:,IndexH2OVap),               &  ! (inout)
          & xyzf_QMixA(:,:,:,CompositionInqIndex('H2OLiq')), &  ! (inout)
          & xyzf_QMixA(:,:,:,CompositionInqIndex('H2OSol')), &  ! (inout)
          & xyz_UA, xyz_VA,                              &  ! (inout)
          & xyz_DQH2OLiqDtCum, xyz_DQH2OSolDtCum         &  ! (out) optional
          & )

        xyz_DQH2OLiqDtCum = 0.0_DP
        xyz_DQH2OSolDtCum = 0.0_DP

!!$        xyzf_QMixA(:,:,:,CompositionInqIndex('H2OLiq')) = &
!!$          &   xyzf_QMixA(:,:,:,CompositionInqIndex('H2OLiq')) &
!!$          & + xyzf_QMixA(:,:,:,CompositionInqIndex('H2OSol'))
!!$        xyzf_QMixA(:,:,:,CompositionInqIndex('H2OSol')) = 0.0_DP

!!$        xyz_DQH2OLiqDtCum =     &
!!$          &   xyz_DQH2OLiqDtCum &
!!$          & + xyz_DQH2OSolDtCum
!!$        xyz_DQH2OSolDtCum = 0.0_DP

      end select


      ! 絬϶ŷ (ήŷ)
      ! Large scale condensation
      !
      select case ( IDLSCMethod )
      case ( IDLSCMethodNone )

        xyz_DQH2OLiqDtLSC = 0.0_DP

      case ( IDLSCMethodM65 )
        ! 絬϶ŷ (ήŷ) (Manabe, 1965)
        ! Large scale condensation (non-convective condensation) 
        ! (Manabe, 1965)
        !
        call LScaleCond( &
!!$        call LScaleCond1D3DWrapper( &
          & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),        & ! (inout)
          & xyz_Press, xyr_Press,                            & ! (in)
          & xyz_DQH2OLiqDtLSC                                & ! (out)
          & )

        ! It would be better that lines below are included in LScaleCond
        ! subroutine.
        xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )) = &
          &   xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )) &
          & + xyz_DQH2OLiqDtLSC * 2.0_DP * DelTime
        xyz_DQH2OLiqDtLSC = 0.0_DP
        xyz_DQH2OSolDtLSC = 0.0_DP

!!$        case ( IDLSCMethodLL91 )
!!$          ! 絬϶ŷ (ήŷ) (Le Treut and Li, 1991)
!!$          ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
!!$          !
!!$          call LScaleCondLL91(                                 &
!!$            & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),        &  ! (inout)
!!$            & xyz_DTempDtCond, xyz_DQVapDtCond,                &  ! (inout)
!!$            & xyz_Press, xyr_Press,                            &  ! (in)
!!$            & xyz_DQH2OLiqDtLSC                                &  ! (out)
!!$            & )
      case ( IDLSCMethodSatAdjM65 )
        !
        != Saturation adjustment
        !
        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if
        call SaturationAdjust(                                 &
          & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),          & ! (inout)
          & xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )), & ! (in)
          & xyz_Press, xyr_Press,                              & ! (in)
          & xyz_DQH2OLiqDtLSC                                  & ! (out)
          & )

      case ( IDLSCMethodM65WithIce )
        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if
        if ( CompositionInqIndex( 'H2OSol' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if

        ! 絬϶ŷ (ήŷ) (Manabe, 1965)
        ! Large scale condensation (non-convective condensation) 
        ! (Manabe, 1965)
        !
        ! It should be noted that H2OLiq and H2OSol have updated in above 
        ! subroutine.

        call LScaleCond1D3DWrapper(                            &
          & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),          & ! (inout)
          & xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )), & ! (inout)
          & xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OSol' )), & ! (inout)
          & xyz_Press, xyr_Press,                              & ! (in)
          & xyz_DQH2OLiqDtLSC, xyz_DQH2OSolDtLSC               & ! (out)
          & )

        ! Temporal treatment
        xyz_DQH2OLiqDtLSC = 0.0_DP
        xyz_DQH2OSolDtLSC = 0.0_DP

      end select


      ! 
      ! Cloud model
      !
      select case ( IDCloudMethod )
      case ( IDCloudMethodNone )


!!$        call CloudSimpleCalcPRCPKeyLLTemp3D(           &
!!$          & xyr_Press, xyz_Press, xyz_DQH2OLiqDtCum,   &  ! (in )
!!$          & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),  &  ! (in )
!!$          & xy_RainCumulus, xy_SnowCumulus             &  ! (out)
!!$          & )
!!$        call CloudSimpleCalcPRCPKeyLLTemp3D(           &
!!$          & xyr_Press, xyz_Press, xyz_DQH2OLiqDtLsc,   &  ! (in )
!!$          & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),  &  ! (in )
!!$          & xy_RainLsc, xy_SnowLsc                     &  ! (out)
!!$          & )
        call CloudSimpleCalcPRCPKeyLLTemp3D(           &
          & xyr_Press, xyz_Press,                      & ! (in )
          & xyzf_QMixA(:,:,:,CompositionInqIndex( 'H2OLiq' )) / ( 2.0_DP * DelTime ), & ! (in )
          & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),  & ! (in )
          & xy_RainCumulus, xy_SnowCumulus             & ! (out)
          & )

        xy_Rain = xy_RainCumulus + xy_RainLsc
        xy_Snow = xy_SnowCumulus + xy_SnowLsc

      case ( IDCloudMethodSimple )

        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if
        if ( IDMCMethod == IDMCMethodMCA ) then
          call MessageNotify( 'E', prog_name, &
            & 'If the moist convective adjustment is used, H2OLiq cannot be included.' )
        end if

        ! Update cloud water
        !
        call CloudSimple(                                    &
          & xyr_Press, xyz_Press,                            & ! (in)
          & xyz_TempA,                                       & ! (inout)
          & xyzf_QMixA(:,:,:,IndexH2OVap),                   & ! (inout)
          & xyzf_QMixA(:,:,:,CompositionInqIndex('H2OLiq')), & ! (inout)
          & xy_RainCumulus, xy_SnowCumulus,                  & ! (out)
          & xy_RainLsc, xy_SnowLsc                           & ! (out)
          & )

        xy_Rain = xy_RainCumulus + xy_RainLsc
        xy_Snow = xy_SnowCumulus + xy_SnowLsc

      case ( IDCloudMethodSimpleWithIce )

        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if
        if ( CompositionInqIndex( 'H2OSol' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OSol is not found.' )
        end if
        if ( IDMCMethod == IDMCMethodMCA ) then
          call MessageNotify( 'E', prog_name, &
            & 'If the moist convective adjustment is used, H2OLiq cannot be included.' )
        end if

        ! Update cloud water
        !
        call CloudSimpleWithIce(                             &
          & xyr_Press, xyz_Press,                            & ! (in)
          & xyz_TempA,                                       & ! (inout)
          & xyzf_QMixA(:,:,:,IndexH2OVap)                  , & ! (inout)
          & xyzf_QMixA(:,:,:,CompositionInqIndex('H2OLiq')), & ! (inout)
          & xyzf_QMixA(:,:,:,CompositionInqIndex('H2OSol')), & ! (inout)
          & xy_RainCumulus, xy_SnowCumulus,                  & ! (out)
          & xy_RainLsc, xy_SnowLsc                           & ! (out)
          & )

        xy_Rain = xy_RainCumulus + xy_RainLsc
        xy_Snow = xy_SnowCumulus + xy_SnowLsc

!!$        call PhyImplSDHV2SetMethodMatthews(  &
!!$          & xy_SurfType, xy_SeaIceConc,      & ! (in)
!!$          & xy_PhyImplSDHIndexCalcMethod     & ! (out)
!!$          & )
!!$        call PhyImplSDHV2CorSOTempBySnowMelt(  &
!!$          & xy_PhyImplSDHIndexCalcMethod,    & ! (in   )
!!$          & xy_Snow,                         & ! (in   )
!!$          & xy_SurfTemp                      & ! (inout)
!!$          & )

      case ( IDCloudMethodMarsH2OCloud )

        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if

        ! ٤Ⱦҥ٥, ȹ٤λ
        ! Interpolate temperature on half sigma level, 
        ! and calculate pressure and height
        !
        call AuxVars( &
          & xy_PsB, xyz_TempB, xyzf_QMixA(:,:,:,IndexH2OVap),& ! (in )
          & xyz_VirTemp = xyz_VirTemp,                       & ! (out) optional
          & xyr_Press     = xyr_Press,                       & ! (out) optional
          & xy_SurfHeight = xy_SurfHeight,                   & ! (in ) optional
          & xyr_Height = xyr_Height                          & ! (out) optional
          & )

        !  H2O ǥ
        ! Mars H2O cloud model
        !
        call CloudMarsH2O(                                   &
          & xyr_Press, xyz_VirTemp, xyr_Height,              & ! (in)
          & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,            & ! (in)
          & xyzf_QMixA(:,:,:,CompositionInqIndex('H2OLiq')), & ! (inout)
          & xy_RainCumulus, xy_SnowCumulus,                  & ! (out)
          & xy_RainLsc, xy_SnowLsc                           & ! (out)
          & )

        xy_Rain = xy_RainCumulus + xy_RainLsc
        xy_Snow = xy_SnowCumulus + xy_SnowLsc

      end select


      select case ( IDSfcMoistMethod )
      case ( IDSfcMoistMethodBucket )
        ! Хĥǥ, ߿ȼɽѲη׻
        ! bucket model, calculation of change of surface water due to 
        ! precipitation
        !
        call BucketSetFlagOceanFromMatthews( &
          & xy_SurfType,                     & ! (in)
          & xy_BucketFlagOceanGrid           & ! (out)
          & )
        call BucketPRCPAdjust(                  &
          & xy_BucketFlagOceanGrid, xy_Rain, xy_Snow, &  ! (in )
          & xy_SoilMoistA, xy_SurfSnowA         &  ! (inout)
          & )
      end select


      select case ( IDDCMethod )
      case ( IDDCMethodDCA )
        ! ήĴ
        ! Dry convective adjustment
        !
        call DryConvAdjust(                        &
          & xyz_TempA, xyz_UA, xyz_VA, xyzf_QMixA, &  ! (inout)
          & xyz_Press, xyr_Press                   &  ! (in)
          & )
      end select


      ! ߲
      ! Gravitational sedimentation process
      !
      if ( CompositionInqIndex('Dust') > 0 ) then
        call GravSed(                                       &
          & 'MarsDust',                                     & ! (in )
          & xyr_Press, xyz_VirTemp, xyr_Height,             & ! (in )
          & xyzf_QMixA(:,:,:,CompositionInqIndex('Dust')),  & ! (out)
          & xy_SurfDustGravSedFlux                          & ! (out) optional
          & )
      end if

!!$      if ( IDPhysMode == IDPhysModeFullPhysics ) then

        ! ʬѲ
        ! Phase change of atmospheric major component
        !
        call MajorCompPhaseChangeInAtm(            &
          & xyr_Press, xyz_Press,                  &  ! (in)
          & xy_PsA, xyz_TempA, xy_SurfMajCompIceA  &  ! (inout)
          & )

!!$      end if

      ! ʬμ̤
      ! Fix masses of constituents
      !
      call MassFixerColumn( &
        & xyr_Press,  & ! (in)
        & xyzf_QMixA  & ! (inout)
        & )

    end select


    ! ֥ե륿 (Asselin, 1972)
    ! Time filter (Asselin, 1972)
    !
!!$    if ( .not. flag_initial .or. .not. firstloop ) then
!!$      call TimeFilter( &
!!$        & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
!!$        & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
!!$        & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  )   ! (in)
!!$
!!$      select case ( IDPhysMode )
!!$      case ( IDPhysModeFullPhysics )
!!$        call TimeFilterSurfVars(                             &
!!$          & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, &   ! (in)
!!$          & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN, &   ! (inout)
!!$          & xy_SurfMajCompIceA, xy_SoilMoistA, xy_SurfSnowA  &   ! (in)
!!$          & )
!!$      end select
!!$    end if

    ! ֥ե륿 (Williams, 2009)
    ! Time filter (Williams, 2009)
    !
    if ( .not. flag_initial .or. .not. firstloop ) then
      call TimeFilterWilliams2009(                 &
        & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
        & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
        & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  &   ! (inout)
        & )

      select case ( IDPhysMode )
      case ( IDPhysModeFullPhysics )
        call TimeFilterWilliams2009SurfVars(           &
          & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in)
          & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN, & ! (inout)
          & xy_SurfMajCompIceA, xy_SoilMoistA, xy_SurfSnowA, & ! (inout)
          & xy_PsA                                           & ! (inout)
          & )
      end select
    end if


    ! Messages for debug run
    !
!!$    select case ( IDPhysMode )
!!$    case ( IDPhysModeFullPhysics )
!!$      write( 6, * ) xyz_TempA(0,jmax/2+1,1), &
!!$        & xyz_VirTemp(0,jmax/2+1,1) - xyz_TempB(0,jmax/2+1,1), &
!!$        & xyr_VirTemp(0,jmax/2+1,1) - xyr_Temp (0,jmax/2+1,1)
!!$    case default
!!$      write( 6, * ) xyz_TempA(0,jmax/2+1,1)
!!$    end select


    ! ͽѿͤγǧ
    ! Check values of prognostic variables
    !
    call CheckProgVars( &
      & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA   & ! (in)
      & )

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeA, 'U',    xyz_UA )
    call HistoryAutoPut( TimeA, 'V',    xyz_VA )
    call HistoryAutoPut( TimeA, 'Temp', xyz_TempA )
    do n = 1, ncmax
      call HistoryAutoPut( TimeA, a_QMixName(n), xyzf_QMixA(:,:,:,n) )
    end do
    call HistoryAutoPut( TimeA, 'Ps',   xy_PsA )

    ! Output frequently used variables
    ! Output frequently used variables
    !
    call OutputFreqUsedVars(           &
      & xy_PsA, xyz_TempA, xyzf_QMixA, & ! (in)
      & xy_SurfHeight                  & ! (in)
      & )

    select case ( IDPhysMode )
    case ( IDPhysModeJupiterSimpleV2 )
      call HistoryAutoPut( TimeN, 'Rain', xy_Rain )
      call HistoryAutoPut( TimeN, 'Snow', xy_Snow )
      call HistoryAutoPut( TimeN, 'PRCP', xy_Rain + xy_Snow )

    case ( IDPhysModeFullPhysics )
      call HistoryAutoPut( TimeN, 'SurfTemp', xy_SurfTemp )
      if ( size( xyz_SoilTemp ) /= 0 ) then
        call HistoryAutoPut( TimeN, 'SoilTemp', xyz_SoilTemp )
      end if

      call HistoryAutoPut( TimeA, 'SurfMajCompIce', xy_SurfMajCompIceA )
      call HistoryAutoPut( TimeA, 'SoilMoist'     , xy_SoilMoistA      )
      call HistoryAutoPut( TimeA, 'SurfSnow'      , xy_SurfSnowA       )

!!$      call HistoryAutoPut( TimeN, 'Rain', xy_Rain * LatentHeat )
!!$      call HistoryAutoPut( TimeN, 'Rain', ( xy_Rain + xy_Snow ) * LatentHeat )
      call HistoryAutoPut( TimeN, 'Rain', xy_Rain )
      call HistoryAutoPut( TimeN, 'Snow', xy_Snow )
      call HistoryAutoPut( TimeN, 'PRCP', xy_Rain + xy_Snow )

      call HistoryAutoPut( TimeN, 'SeaIceConc'     , xy_SeaIceConc      )
      call HistoryAutoPut( TimeN, 'SurfAlbedo'     , xy_SurfAlbedo      )
      call HistoryAutoPut( TimeN, 'SurfRoughLength', xy_SurfRoughLength )

      if ( CompositionInqIndex('Dust') > 0 ) then
        call HistoryAutoPut( TimeN, 'SurfDustGravSedFlux', xy_SurfDustGravSedFlux )
      end if
    end select

    ! λ֥ƥåפ˸ͽѿؤ
    ! Exchange prediction variables for the next time step
    !
    xyz_UB     = xyz_UN     ; xyz_UN     = xyz_UA     ; xyz_UA     = 0.
    xyz_VB     = xyz_VN     ; xyz_VN     = xyz_VA     ; xyz_VA     = 0.
    xyz_TempB  = xyz_TempN  ; xyz_TempN  = xyz_TempA  ; xyz_TempA  = 0.
    xyzf_QMixB = xyzf_QMixN ; xyzf_QMixN = xyzf_QMixA ; xyzf_QMixA = 0.
    xy_PsB     = xy_PsN     ; xy_PsN     = xy_PsA     ; xy_PsA     = 0.


    select case ( IDPhysMode )
    case ( IDPhysModeFullPhysics )
      xy_SurfMajCompIceB = xy_SurfMajCompIceN
      xy_SurfMajCompIceN = xy_SurfMajCompIceA
      xy_SurfMajCompIceA = 0.0_DP

      xy_SoilMoistB = xy_SoilMoistN
      xy_SoilMoistN = xy_SoilMoistA
      xy_SoilMoistA = 0.0_DP

      xy_SurfSnowB  = xy_SurfSnowN
      xy_SurfSnowN  = xy_SurfSnowA
      xy_SurfSnowA  = 0.0_DP
    end select

    ! οʹ
    ! Progress time
    !
    call TimesetProgress

    ! NAMELIST ɤ߹ѿ̵̾ʤΤ¸ߤɤå
    ! HistoryAutoAddVariable Ͽѿ̾
    !
    ! Check that invalid variable names are loaded from NAMELIST or not
    ! Print registered variable names by "HistoryAutoAddVariable"
    !
    !!! if ( firstloop ) call HistoryAutoAllVarFix

    ! ꥹȥǡ
    ! Restart data output
    !
    call RestartFileOutput(                            &
      & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &  ! (in)
      & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN  &  ! (in)
      & )

    select case ( IDPhysMode )
    case ( IDPhysModeFullPhysics )
      ! ɽ̲٥ꥹȥǡ
      ! Restart data of surface temperature output
      !
      call RestartSurfTempOutput(                             &
        & xy_SurfTemp, xyz_SoilTemp,                          & ! (in)
        & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB,    & ! (in) optional
        & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN     & ! (in) optional
        & )
    end select

    firstloop = .false.

  ! ʬλ
  ! Time integration is finished
  !
  end do loop_time

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate



contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperInit

    use dc_message, only: MessageNotify

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit, NmlutilMsg

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit, TimesetDelTimeHalf, &
      & TimeN                 ! ƥå $ t $ λ. Time of step $ t $. 

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                  imax, & ! ٳʻ. 
                                 ! Number of grid points in longitude
      &                  jmax, & ! ٳʻ. 
                                 ! Number of grid points in latitude
      &                  kmax, & ! ľؿ. 
                                 ! Number of vertical level
      &                kslmax    ! ϲαľؿ. 
                                 ! Number of subsurface vertical level

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    use composition, only: CompositionInit

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: ConstantsSnowSeaIceInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileInit, RestartFileOpen, RestartFileGet

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempInit, RestartSurfTempOpen, RestartSurfTempGet

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen
    use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: &
      & STDOUT               ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ǡɤ߹
    ! Reading time series
    !
    use read_time_series, only : ReadTimeSeriesInit

    ! ɽ̥ǡ
    ! Prepare surface data
    !
    use surface_data, only : SurfDataInit

    ! ե뤫 1 ץեɤꤹ. 
    ! read 1-D profile from a file and set it 
    !
    use set_1d_profile, only : Set1DProfileInit


    ! Ūѿ׻륵֥롼󡦴ؿ
    ! Subroutines and functions for calculating auxiliary variables
    !
    use auxiliary, only : AuxVarsInit, AuxVars

    ! Held and Suarez (1994) ˤ붯Ȼ
    ! Forcing and dissipation suggested by Held and Suarez (1994)
    !
    use held_suarez_1994, only : HS94Init

    ! Yamamoto and Takahashi (2003) ˽äñ׻Τζ
    ! forcing for simple Venus calculation following Yamamoto and Takahashi (2003)
    !
    use yt2003_forcing, only : YT2003ForcingInit

    ! ɽ̥ǡ
    ! Setting planetary surface properties
    !
    use surface_properties, only : SurfacePropertiesInit

    ! ϲˤǮαľȻ
    ! Vertical diffusion of heat under the ground
    !
    use subsurface_diffusion_heat, only : SubsurfaceDiffusionInit

    ! ˡˤʬ
    ! Time integration with implicit scheme
    !
    use phy_implicit, only : PhyImplInit

    ! ϲǮƳǥѤαˡˤʬ
    !
    ! Time integration by using implicit scheme in case using subsurface thermal diffusion model
    use phy_implicit_sdh, only : PhyImplSDHInit

    ! ϲǮƳǥѤαˡˤʬ
    !
    ! Time integration by using implicit scheme in case using subsurface thermal diffusion model
    use phy_implicit_sdh_V2, only : PhyImplSDHV2Init

    ! ˡˤʬ (絤Τ / ɽ̲١ھٷ׻ʤ)
    ! Time integration by using implicit scheme in case without calculation of surface and soil temperature
    !
    use phy_implicit_atmonly, only : PhyImplAtmOnlyInit

    ! ˡˤʬΤΥ롼
    ! Routines for time integration with implicit scheme
    !
    use phy_implicit_utils, only : PhyImplUtilsInit

    ! Хĥǥ
    ! Bucket model
    !
    use Bucket_Model, only : BucketModelInit

    ! ͥեå (GFD Ǿȯͥǥ)
    ! Radiation flux (radiation model developed by GFD Dennou Club)
    !
    use rad_DennouAGCM, only : RadDennouAGCMInit

    ! ϵ絤ͥǥ Ver. 2
    ! radiation model for the Earth's atmosphere Ver. 2
    !
    use rad_Earth_V2, only : RadEarthV2Init


    ! 絤ͥǥ Ver. 1
    ! radiation model for the Mars' atmosphere Ver. 1
    !
    use rad_Mars_V1, only : RadMarsV1Init

!!$    ! (絤) Non-LTE ͥǥ
!!$    ! Non-NLTE radiation model (for the Mars' atmosphere)
!!$    !
!!$    use rad_15m_NLTE, only: Rad15mNLTEInit

    ! ׻ѶֳǮΨ׻
    ! Calculation of near infrared heating rate in the case of Mars
    !
    use rad_Mars_NIR, only : RadMarsNIRInit

    ! Schneider and Liu (2009) ͥǥ
    ! Radiation model by Schneider and Liu (2009)
    !
    use rad_SL09, only : RadSL09Init

    ! ñͥǥ
    ! Simple radiation model
    !
    use rad_simple, only : RadSimpleInit

    ! ʹϢ롼
    ! Routines for radiation calculation
    !
    use rad_utils, only : RadUtilsInit

    ! ľȻեå
    ! Vertical diffusion flux
    !
    use vdiffusion_my, only : VDiffusionInit

    ! Schneider and Liu (2009) ˤľ
    ! Vertical diffusion by Schneider and Liu (2009)
    !
    use sl09_diffusion, only : SL09DiffusionInit

    ! Gravity wave drag by McFarlane (1987)
    ! Gravity wave drag by McFarlane (1987)
    !
    use gwd_m1987, only : GWDM1987Init

    ! ñǥ
    ! Simple cloud
    !
    use cloud_simple, only: CloudSimpleInit

    !  H2O ǥ
    ! Mars H2O cloud model
    !
    use cloud_mars_h2o, only : CloudMarsH2OInit

    ! ɽ̥եå (Х륯ˡ)
    ! Surface flux (Bulk method)
    !
    use surface_flux_bulk, only : SurfaceFluxInit

    !
    ! set dust flux
    !
!!$    use set_dust_flux, only : SetDustFluxInit

    ! եå
    ! Lower boundary flux
    !
    use lb_flux_simple, only : LBFluxSimpleInit

    ! ̲, ھ٤λʬ
    ! Time integration of surface temperature and soil temperature
    !
    use intg_surftemp, only : IntgSurfTempInit

    ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
    ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
    !
    use dynamics_hspl_vas83, only : DynamicsHSplVAS83Init

    ! ʪΤߤη׻Τϳز
    ! A dynamics for calculation with physical processes only
    !
    use dynamics_physicsonly, only : DynamicsPhysicsOnlyInit

    ! ήĴ
    ! Moist convective adjustment
    !
    use moist_conv_adjust, only : MoistConvAdjustInit

    ! Relaxed Arakawa-Schubert scheme
    ! Relaxed Arakawa-Schubert scheme
    !
    use relaxed_arakawa_schubert, only : RASInit

    ! 絬϶ŷ (ήŷ)
    ! Large scale condensation (non-convective condensation)
    !
    use lscond, only : LScaleCondInit

    ! 絬϶ŷ (ήŷ) (Le Treut and Li, 1991)
    ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
    !
!!$    use lscond_LL91, only : LScaleCondLL91Init

    !
    != Saturation adjustment
    !
    use saturation_adjust, only : SaturationAdjustInit

    ! ήĴ
    ! Dry convective adjustment
    !
    use dry_conv_adjust, only : DryConvAdjustInit

    ! ߲
    ! Gravitational sedimentation process
    !
    use grav_sed, only : GravSedInit

    ! ʬѲ
    ! Phase change of atmospheric major component
    !
    use major_comp_phase_change, only : MajorCompPhaseChangeInit

    ! ե륿 (Asselin, 1972)
    ! Time filter (Asselin, 1972)
    !
    use timefilter_asselin1972, only : TimeFiltInit

    ! ֥ե륿 (Williams, 2009)
    ! Time filter (Williams, 2009)
    !
    use timefilter_williams2009, only: TimeFilterWilliams2009Init

    ! ͽѿͤγǧ
    ! Check values of prognostic variables
    !
    use check_prog_vars, only : CheckProgVarsInit

    ! ̤
    ! Mass fixer
    !
    use mass_fixer, only : MassFixerInit

    ! Output frequently used variables
    ! Output frequently used variables
    !
    use output_freq_used_vars, only : OutputFreqUsedVarsInit

    ! ʸ ; Declaration statements
    !
    implicit none

    character(*), parameter:: version = &
      & '$Name:  $' // &
      & '$Id: dcpam_main.f90,v 1.61 2014/06/29 07:23:28 yot Exp $'
                              ! ץΥС
                              ! Main program version

    character(STRING)      :: namelist_filename
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name

    character(STRING)      :: DynMode
                                ! Dynamics used in calculation
    character(STRING)      :: PhysMode
                                ! Physics used in calculation
    character(STRING)      :: RadModel
                                ! Radiation model used in calculation
    character(STRING)      :: SfcFluxMethod
                                ! Method for surface flux evaluation used in calculation
    character(STRING)      :: VDiffMethod
                                ! Method for vertical diffusion evaluation used in calculation
    character(STRING)      :: PhysImpMode
                                ! Mode for implicit method used in calculation
    character(STRING)      :: MCMethod
                                ! Moist convection parameterization
    character(STRING)      :: LSCMethod
                                ! Large scale condensation parameterization
    character(STRING)      :: CloudMethod
                                ! Cloud model
    character(STRING)      :: SfcMoistMethod
                                ! Surface moist model
    character(STRING)      :: GWDMethod
                                ! Gravity wave drag
    character(STRING)      :: DCMethod
                                ! Dry convection

    logical                :: FlagPhysImpSoilModelSO
                                ! flag for use of slab ocean
    logical                :: FlagSnow
                                ! flag for treating snow
    logical                :: FlagMajCompPhaseChange
                                ! flag for use of major component phase change

    character(STRING):: CondMajCompName
                                ! name of condensable major component

    character(STRING):: briefexpldyn
                              ! ¹ԥեδʷ (ϳز)
                              ! Brief account of executable file (dynamics)
    character(STRING):: briefexplphy
                              ! ¹ԥեδʷ (ʪ)
                              ! Brief account of executable file (physics)
    character(STRING):: briefexplrad
                              ! ¹ԥեδʷ (Ͳ)
                              ! Brief account of executable file (radiation)
    character(STRING):: briefexplsfcflux
                              ! ¹ԥեδʷ (ɽ̥եå)
                              ! Brief account of executable file (surface flux)
    character(STRING):: briefexplvdiff
                              ! ¹ԥեδʷ (ľȻ)
                              ! Brief account of executable file (vertical diffusion)
    character(STRING):: briefexplimp
                              ! ¹ԥեδʷ (ˡˡ)
                              ! Brief account of executable file (implicit method)

    logical:: FlagBucketModel

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dcpam_main_nml/                                                 &
      & DynMode, PhysMode, RadModel, SfcFluxMethod, VDiffMethod, PhysImpMode, &
      & MCMethod, LSCMethod, CloudMethod, SfcMoistMethod, GWDMethod, DCMethod,&
      & FlagSnow, FlagMajCompPhaseChange, CondMajCompName
          !
          ! ǥեͤˤĤƤϽ³ "main/dcpam_main.F90#MainInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "main/dcpam_main.F90#MainInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    ! Initialize MPI
    !
    call MPIWrapperInit

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit(       &
      & namelist_filename,    & ! (out)
      & prog_name            & ! (in )
      & )

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit( &
      & namelist_filename  & ! (in)
      & )

    ! ǥեͤ
    ! Default values settings
    !
    DynMode                 = 'HSPLVAS83'
!!$    DynMode                 = 'NoHorAdv'

    PhysMode                = 'FullPhysics'
!!$    PhysMode                = 'HS94'
!!$    PhysMode                = 'VenusSimple'
!!$    PhysMode                = 'JupiterSimple'
!!$    PhysMode                = 'NoPhysics'

    RadModel                = 'DennouAGCM'
!!$    RadModel                = 'Earth'
!!$    RadModel                = 'Mars'
!!$    RadModel                = 'SL09'

    SfcFluxMethod           = 'L82'
!!$    SfcFluxMethod           = 'BH91B94'

    VDiffMethod             = 'MY2'
!!$    VDiffMethod             = 'MY2.5'

    PhysImpMode             = '1LayModel'
!!$    PhysImpMode             = 'SoilModel'
!!$    PhysImpMode             = 'SoilModelSO'
!!$    PhysImpMode             = 'AtmOnly'

!!$    MCMethod                = 'None'
    MCMethod                = 'MCA'
!!$    MCMethod                = 'RAS'

!!$    LSCMethod               = 'None'
    LSCMethod               = 'M65'
!!$    LSCMethod               = 'LL91'

    CloudMethod             = 'None'
!!$    CloudMethod             = 'Simple'

    SfcMoistMethod          = 'None'
!!$    SfcMoistMethod          = 'Bucket'

    GWDMethod               = 'None'
!!$    GWDMethod               = 'M1987'

!!$    DCMethod                = 'None'
    DCMethod                = 'DCA'


    FlagSnow                = .false.

    FlagMajCompPhaseChange  = .false.

    CondMajCompName         = ''
!!$    CondMajCompName         = 'CO2'


    ! ׻⡼ɤ
    ! Configure calculation mode
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &            ! (in)
        & nml = dcpam_main_nml, &  ! (out)
        & iostat = iostat_nml )    ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, prog_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = dcpam_main_nml )
    end if


    ! Identification of calculation method for dynamics
    !
    call MessageNotify( 'M', prog_name, &
      & 'DynMode=<%c>.', &
      & c1 = trim(DynMode) )
    !
    select case ( DynMode )
    case ( 'HSPLVAS83' )
      IDDynMode = IDDynModeHSPLVAS83
    case ( 'NoHorAdv' )
      IDDynMode = IDDynModeNoHorAdv
    case default
      call MessageNotify( 'E', prog_name, &
        & 'DynMode=<%c> is not supported.', &
        & c1 = trim(DynMode) )
    end select


    ! Identification of calculation method for physics
    !
    call MessageNotify( 'M', prog_name, &
      & 'PhysMode=<%c>.', &
      & c1 = trim(PhysMode) )
    !
    select case ( PhysMode )
    case ( 'FullPhysics' )
      IDPhysMode = IDPhysModeFullPhysics
    case ( 'HS94' )
      IDPhysMode = IDPhysModeHS94
    case ( 'VenusSimple' )
      IDPhysMode = IDPhysModeVenusSimple
    case ( 'JupiterSimple' )
      IDPhysMode = IDPhysModeJupiterSimple
    case ( 'JupiterSimpleV2' )
      IDPhysMode = IDPhysModeJupiterSimpleV2
    case ( 'NoPhysics' )
      IDPhysMode = IDPhysModeNoPhysics
    case default
      call MessageNotify( 'E', prog_name, &
        & 'PhysMode=<%c> is not supported.', &
        & c1 = trim(PhysMode) )
    end select


    ! Identification of calculation method for radiation
    !
    call MessageNotify( 'M', prog_name, &
      & 'RadModel=<%c>.', &
      & c1 = trim(RadModel) )
    !
    select case ( RadModel )
    case ( 'DennouAGCM' )
      IDRadMethod = IDRadMethodDennouAGCM
    case ( 'Earth' )
      IDRadMethod = IDRadMethodEarthV2
    case ( 'Mars' )
      IDRadMethod = IDRadMethodMarsV1
    case ( 'SL09' )
      IDRadMethod = IDRadMethodSL09
!!$    case ( 'VenusSimple' )
!!$      IDRadMethod = IDRadMethodVenusSimple
    case ( 'Simple' )
      IDRadMethod = IDRadMethodSimple
    case default
      call MessageNotify( 'E', prog_name, &
        & 'RadModel=<%c> is not supported.', &
        & c1 = trim(RadModel) )
    end select

    ! Identification of calculation method for surface flux
    !
    call MessageNotify( 'M', prog_name, &
      & 'SfcFluxMethod=<%c>.', &
      & c1 = trim(SfcFluxMethod) )
    !
    select case ( SfcFluxMethod )
    case ( 'L82' )
      IDSfcFluxMethod = IDSfcFluxMethodL82
    case ( 'BH91B94' )
      IDSfcFluxMethod = IDSfcFluxMethodBH91B94
    case default
      call MessageNotify( 'E', prog_name, &
        & 'SfcFluxMethod=<%c> is not supported.', &
        & c1 = trim(SfcFluxMethod) )
    end select

    ! Identification of calculation method for vertical diffusion
    !
    call MessageNotify( 'M', prog_name, &
      & 'VDiffMethod=<%c>.', &
      & c1 = trim(VDiffMethod) )
    !
    select case ( VDiffMethod )
    case ( 'MY2' )
      IDVDiffMethod = IDVDiffMethodMY2
    case ( 'MY2.5' )
      IDVDiffMethod = IDVDiffMethodMY25
    case default
      call MessageNotify( 'E', prog_name, &
        & 'VDiffMethod=<%c> is not supported.', &
        & c1 = trim(VDiffMethod) )
    end select

    ! Identification of calculation method for solving simultaneous linear equations 
    ! of physics
    !
    call MessageNotify( 'M', prog_name, &
      & 'PhysImpMode=<%c>.', &
      & c1 = trim(PhysImpMode) )
    !
    select case ( PhysImpMode )
    case ( '1LayModel' )
      IDPhyTendMethod = IDPhyTendMethodImp1LayModel
      FlagPhysImpSoilModelSO = .false.
    case ( 'SoilModel' )
      IDPhyTendMethod = IDPhyTendMethodImpSoilModel
      FlagPhysImpSoilModelSO = .false.
    case ( 'SoilModelSO' )
      IDPhyTendMethod = IDPhyTendMethodImpSoilModel
      FlagPhysImpSoilModelSO = .true.
    case ( 'AtmOnly' )
      IDPhyTendMethod = IDPhyTendMethodImpAtmOnly
      FlagPhysImpSoilModelSO = .false.
    case default
      call MessageNotify( 'E', prog_name, &
        & 'PhysImpMode=<%c> is not supported.', &
        & c1 = trim(PhysImpMode) )
    end select
    !
    !   Check for value of FlagFullPhysics
    !
    if ( ( IDPhysMode /= IDPhysModeFullPhysics ) .and. &
      &  ( IDPhyTendMethod == IDPhyTendMethodImpSoilModel ) ) then
      call MessageNotify( 'E', prog_name, &
        & 'PhysMode has to be "FullPhysics" true, when PhyImpMode is "SoilModel" or "SoilModelSO".' )
    end if
    if ( ( IDPhysMode /= IDPhysModeFullPhysics ) .and. &
      &  ( IDPhyTendMethod == IDPhyTendMethodImpAtmOnly ) ) then
      call MessageNotify( 'E', prog_name, &
        & 'PhysMode has to be "FullPhysics" true, when PhyImpMode is "AtmOnly".' )
    end if


    ! Identification of calculation method for moist convection
    !
    call MessageNotify( 'M', prog_name, 'MCMethod=<%c>.', c1 = trim(MCMethod) )
    !
    select case ( MCMethod )
    case ( 'None' )
      IDMCMethod = IDMCMethodNone
    case ( 'MCA' )
      IDMCMethod = IDMCMethodMCA
    case ( 'RAS' )
      IDMCMethod = IDMCMethodRAS
    case ( 'RASWithIce' )
      IDMCMethod = IDMCMethodRASWithIce
    case default
      call MessageNotify( 'E', prog_name, 'MCMethod=<%c> is not supported.', &
        & c1 = trim(MCMethod) )
    end select


    ! Identification of calculation method for large scale condensation
    !
    call MessageNotify( 'M', prog_name, 'LSCMethod=<%c>.', &
      & c1 = trim(LSCMethod) )
    !
    select case ( LSCMethod )
    case ( 'None' )
      IDLSCMethod = IDLSCMethodNone
    case ( 'M65' )
      IDLSCMethod = IDLSCMethodM65
!!$    case ( 'LL91' )
!!$      IDLSCMethod = IDLSCMethodLL91
    case ( 'SatAdjM65' )
      IDLSCMethod = IDLSCMethodSatAdjM65
    case ( 'M65WithIce' )
      IDLSCMethod = IDLSCMethodM65WithIce
    case default
      call MessageNotify( 'E', prog_name, 'LSCMethod=<%c> is not supported.', &
        & c1 = trim(LSCMethod) )
    end select


    ! Identification of calculation method for cloud
    !
    call MessageNotify( 'M', prog_name, 'CloudMethod=<%c>.', &
      & c1 = trim(CloudMethod) )
    !
    select case ( CloudMethod )
    case ( 'None' )
      IDCloudMethod = IDCloudMethodNone
    case ( 'Simple' )
      IDCloudMethod = IDCloudMethodSimple
    case ( 'SimpleWithIce' )
      IDCloudMethod = IDCloudMethodSimpleWithIce
    case ( 'MarsH2OCloud' )
      IDCloudMethod = IDCloudMethodMarsH2OCloud
    case default
      call MessageNotify( 'E', prog_name, 'LSCloudMethod=<%c> is not supported.', &
        & c1 = trim(CloudMethod) )
    end select


    ! Identification of calculation method for surface moisture
    !
    call MessageNotify( 'M', prog_name, 'SfcMoistMethod=<%c>.', &
      & c1 = trim(SfcMoistMethod) )
    !
    select case ( SfcMoistMethod )
    case ( 'None' )
      IDSfcMoistMethod = IDSfcMoistMethodNone
      FlagBucketModel  = .false.
    case ( 'Bucket' )
      IDSfcMoistMethod = IDSfcMoistMethodBucket
      FlagBucketModel  = .true.
    case default
      call MessageNotify( 'E', prog_name, 'SfcMoistMethod=<%c> is not supported.', &
        & c1 = trim(SfcMoistMethod) )
    end select


    ! Identification of calculation method for gravity wave drag
    !
    call MessageNotify( 'M', prog_name, 'GWDMethod=<%c>.', c1 = trim(GWDMethod) )
    !
    select case ( GWDMethod )
    case ( 'None' )
      IDGWDMethod = IDGWDMethodNone
    case ( 'M1987' )
      IDGWDMethod = IDGWDMethodM1987
    case default
      call MessageNotify( 'E', prog_name, 'GWDMethod=<%c> is not supported.', &
        & c1 = trim(GWDMethod) )
    end select


    ! Identification of calculation method for dry convection
    !
    call MessageNotify( 'M', prog_name, 'DCMethod=<%c>.', &
      & c1 = trim(DCMethod) )
    !
    select case ( DCMethod )
    case ( 'None' )
      IDDCMethod = IDDCMethodNone
    case ( 'DCA' )
      IDDCMethod = IDDCMethodDCA
    case default
      call MessageNotify( 'E', prog_name, 'DCMethod=<%c> is not supported.', &
        & c1 = trim(DCMethod) )
    end select



    ! ׻⡼ɤɽ
    ! Display calculation mode
    !
    select case ( IDDynMode )
    case ( IDDynModeHSPLVAS83 )
      briefexpldyn = 'used'
    case ( IDDynModeNoHorAdv )
      briefexpldyn = 'not used'
    end select

    select case ( IDPhysMode )
    case ( IDPhysModeFullPhysics )
      briefexplphy = 'parameterization suite is used'
    case ( IDPhysModeHS94 )
      briefexplphy = 'forcing for Held and Suarez (1994) dynamical core test'
    case ( IDPhysModeVenusSimple )
      briefexplphy = 'simple forcing for a Venus-like planet'
    case ( IDPhysModeJupiterSimple )
      briefexplphy = 'simple forcing for a Jupiter-like planet'
    case ( IDPhysModeJupiterSimpleV2 )
      briefexplphy = 'simple forcing for a Jupiter-like planet Ver. 2'
    case ( IDPhysModeNoPhysics )
      briefexplphy = 'not used'
    end select

    if ( IDPhysMode == IDPhysModeFullPhysics ) then
      select case ( IDRadMethod )
      case ( IDRadMethodDennouAGCM )
        briefexplrad = 'dennou AGCM5 default'
      case ( IDRadMethodEarthV2 )
        briefexplrad = 'Earth'
      case ( IDRadMethodMarsV1 )
        briefexplrad = 'Mars'
      case ( IDRadMethodSL09 )
        briefexplrad = 'Schneider and Liu (2009) (Jupiter-like planet)'
!!$      case ( IDRadMethodVenusSimple )
!!$        briefexplrad = 'Venus simple radiation model (tentative)'
      case ( IDRadMethodSimple )
        briefexplrad = 'Simple radiation model (tentative)'
      case default
        call MessageNotify( 'E', 'Unexpected error in setting briefexplrad', '' )
      end select

      select case ( IDSfcFluxMethod )
      case ( IDSfcFluxMethodL82 )
        briefexplsfcflux = 'surface flux by the method of Louis et al. (1982)'
      case ( IDSfcFluxMethodBH91B94 )
        briefexplsfcflux = 'surface flux by the method of Beljaars and Holtslag (1991), Beljaars (1994)'
      case default
        call MessageNotify( 'E', 'Unexpected error in setting briefexplsfcflux', '' )
      end select

      select case ( IDVDiffMethod )
      case ( IDVDiffMethodMY2 )
        briefexplvdiff = 'vertical diffusion with the method of Mellor and Yamada level 2'
      case ( IDVDiffMethodMY25 )
        briefexplvdiff = 'vertical diffusion with the method of Mellor and Yamada level 2.5'
      case default
        call MessageNotify( 'E', 'Unexpected error in setting briefexplvdiff', '' )
      end select

      select case ( IDPhyTendMethod )
      case ( IDPhyTendMethodImp1LayModel )
        briefexplimp = 'system with surface 1 layer model'
      case ( IDPhyTendMethodImpSoilModel )
        briefexplimp = 'system with thermal diffusion soil model'
      case ( IDPhyTendMethodImpAtmOnly )
        briefexplimp = 'system only with atmosphere'
      case default
        call MessageNotify( 'E', 'Unexpected error in setting briefexplimp', '' )
      end select
    else
      briefexplrad = ''
    end if

    call MessageNotify( 'M', prog_name, '' )
    call MessageNotify( 'M', prog_name,   '+-------------------------------------' )
    call MessageNotify( 'M', prog_name,   '|  Dynamics: %c', c1 = trim(briefexpldyn) )
    call MessageNotify( 'M', prog_name,   '|  Physics : %c', c1 = trim(briefexplphy) )
    if ( IDPhysMode == IDPhysModeFullPhysics ) then
      call MessageNotify( 'M', prog_name, '|    Radiation model : %c', c1 = trim(briefexplrad) )
      call MessageNotify( 'M', prog_name, '|    Surface flux method : %c', c1 = trim(briefexplsfcflux) )
      call MessageNotify( 'M', prog_name, '|    Vertical diffusion method : %c', c1 = trim(briefexplvdiff) )
      call MessageNotify( 'M', prog_name, '|    Implicit method : %c', c1 = trim(briefexplimp) )
      call MessageNotify( 'M', prog_name, '|    Major component phase change : %b', l = (/ FlagMajCompPhaseChange /) )
    end if
    call MessageNotify( 'M', prog_name,   '|  -- version = %c', c1 = trim(version) )
    call MessageNotify( 'M', prog_name,   '+-------------------------------------' )
    call MessageNotify( 'M', prog_name, '' )


    ! Initialization of modules used in this module
    !


    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    call CompositionInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    call ConstantsSnowSeaIceInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit



    ! ǡɤ߹
    ! Reading time series
    !
    call ReadTimeSeriesInit

    ! ɽ̥ǡ
    ! Prepare surface data
    !
    call SurfDataInit

    ! ե뤫 1 ץեɤꤹ. 
    ! read 1-D profile from a file and set it 
    !
    call Set1DProfileInit





    ! ͽѿγ
    ! Allocation of prediction variables
    !
    allocate( xyz_UB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempB (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
    allocate( xy_PsB    (0:imax-1, 1:jmax) )

    allocate( xyz_UN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempN (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_QMixN(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
    allocate( xy_PsN    (0:imax-1, 1:jmax) )

    allocate( xyz_UA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempA (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
    allocate( xy_PsA    (0:imax-1, 1:jmax) )


    ! ꥹȥǡ
    ! Restart data input
    !
    call RestartFileInit
    call RestartFileGet( &
      & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, & ! (out)
      & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, & ! (out)
      & flag_initial )                                   ! (out) optional


    select case ( IDPhysMode )
    case ( IDPhysModeFullPhysics )

      ! ɽ̲, ھ٤γ
      ! Allocation of surface temperature and soil temperature
      !
      allocate( xy_SurfTemp (0:imax-1, 1:jmax) )
      allocate( xyz_SoilTemp(0:imax-1, 1:jmax, 1:kslmax) )

      allocate( xy_SurfMajCompIceB(0:imax-1, 1:jmax) )
      allocate( xy_SoilMoistB     (0:imax-1, 1:jmax) )
      allocate( xy_SurfSnowB      (0:imax-1, 1:jmax) )

      allocate( xy_SurfMajCompIceN(0:imax-1, 1:jmax) )
      allocate( xy_SoilMoistN     (0:imax-1, 1:jmax) )
      allocate( xy_SurfSnowN      (0:imax-1, 1:jmax) )

      allocate( xy_SurfMajCompIceA(0:imax-1, 1:jmax) )
      allocate( xy_SoilMoistA     (0:imax-1, 1:jmax) )
      allocate( xy_SurfSnowA      (0:imax-1, 1:jmax) )


      ! ɽ̲٥ꥹȥǡ
      ! Restart data of surface temperature input
      !
!!$      call RestartSurfTempGet( &
!!$        & xy_SurfTemp  )          ! (out)
      call RestartSurfTempInit
      call RestartSurfTempGet(                                      &
        & xy_SurfTemp,                                              & ! (out)
        & xyz_SoilTemp,                                             & ! (out)
        & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB,          & ! (out)
        & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN           & ! (out)
        & )

!!$      xy_SurfSnowN = 1.0d1
!!$      xy_SurfSnowB = xy_SurfSnowN

      ! THIS IS A TEMPORARY LINE.
!!$      ! ھ, ..., ν, ꥹȥե뤫ɤ褦ˤ
!!$      ! Setting of initial values of soil temperature, ..., these values are input from restart file in near future
!!$      !
!!$      do k = 1, kslmax
!!$        xyz_SoilTemp(:,:,k) = xy_SurfTemp
!!$      end do
!!$
!!$      xy_SoilMoistN = 0.0_DP
!!$      xy_SurfSnowN  = 0.0_DP
!!$
!!$      xy_SoilMoistB = xy_SoilMoistN
!!$      xy_SurfSnowB  = xy_SurfSnowN
!!$
!!$      xy_SoilMoistA = 0.0_DP
!!$      xy_SurfSnowA  = 0.0_DP

!!$      xy_SurfMajCompIceN = 0.0_DP
!!$      xy_SurfMajCompIceB = xy_SurfMajCompIceN

    end select

    ! ꥹȥǡեν
    ! Initialization of restart data file
    !
    call RestartFileOpen

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'U' , &         ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'eastward wind', 'm s-1' )               ! (in)

    call HistoryAutoAddVariable( 'V' , &         ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'northward wind', 'm s-1' )              ! (in)

    call HistoryAutoAddVariable( 'Temp' , &      ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'temperature', 'K' )                     ! (in)

    do n = 1, ncmax
      call HistoryAutoAddVariable( a_QMixName(n) , & ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /),    & ! (in)
        & a_QMixLongName(n), 'kg kg-1' )             ! (in)
    end do

    call HistoryAutoAddVariable( 'Ps' , &        ! (in)
      & (/ 'lon ', 'lat ', 'time' /), &          ! (in)
      & 'surface pressure', 'Pa' )               ! (in)


    ! ҥȥǡ (Ȼ)
    ! History data output (Start time)
    !
    call HistoryAutoPut( TimeN, 'U', xyz_UN )
    call HistoryAutoPut( TimeN, 'V', xyz_VN )
    call HistoryAutoPut( TimeN, 'Temp', xyz_TempN )
    do n = 1, ncmax
      call HistoryAutoPut( TimeN, a_QMixName(n), xyzf_QMixN(:,:,:,n) )
    end do
    call HistoryAutoPut( TimeN, 'Ps', xy_PsN )

    ! Output frequently used variables
    ! Output frequently used variables
    !
    call OutputFreqUsedVarsInit


    select case ( IDPhysMode )
    case ( IDPhysModeJupiterSimpleV2 )

      ! ҥȥǡϤΤΤؤѿϿ
      ! Register of variables for history data output
      !
      call HistoryAutoAddVariable( 'Rain', &
        & (/ 'lon ', 'lat ', 'time' /), &
!!$        & 'precipitation (rain)', 'W m-2' )
        & 'precipitation (rain)', 'kg m-2 s-1' )

      call HistoryAutoAddVariable( 'Snow', &
        & (/ 'lon ', 'lat ', 'time' /), &
!!$        & 'precipitation (snow)', 'W m-2' )
        & 'precipitation (snow)', 'kg m-2 s-1' )

      call HistoryAutoAddVariable( 'PRCP', &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'precipitation', 'kg m-2 s-1' )

    case ( IDPhysModeFullPhysics )

      ! ɽ̲٥ꥹȥǡեν
      ! Initialization of restart data file of surface temperature
      !
      call RestartSurfTempOpen

      ! ҥȥǡϤΤΤؤѿϿ
      ! Register of variables for history data output
      !
      call HistoryAutoAddVariable( 'SurfTemp' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'surface temperature', 'K' )

      call HistoryAutoAddVariable( 'SoilTemp', &
        & (/ 'lon ', 'lat ', 'ssz ', 'time' /), &
        & 'soil temperature', 'K' )

      call HistoryAutoAddVariable( 'SurfMajCompIce' , & ! (in)
        & (/ 'lon ', 'lat ', 'time' /),               & ! (in)
        & 'surface major component ice', 'kg m-2' )     ! (in)

      call HistoryAutoAddVariable( 'SoilMoist' , & ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &          ! (in)
        & 'soil moisture', 'kg m-2' )              ! (in)

      call HistoryAutoAddVariable( 'SurfSnow'  , & ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &          ! (in)
        & 'surface snow amount', 'kg m-2' )        ! (in)

      call HistoryAutoAddVariable( 'Rain', &
        & (/ 'lon ', 'lat ', 'time' /), &
!!$        & 'precipitation (rain)', 'W m-2' )
        & 'precipitation (rain)', 'kg m-2 s-1' )

      call HistoryAutoAddVariable( 'Snow', &
        & (/ 'lon ', 'lat ', 'time' /), &
!!$        & 'precipitation (snow)', 'W m-2' )
        & 'precipitation (snow)', 'kg m-2 s-1' )

      call HistoryAutoAddVariable( 'PRCP', &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'precipitation', 'kg m-2 s-1' )

      ! ҥȥǡ (Ȼ)
      ! History data output (Start time)
      !
      call HistoryAutoPut( TimeN, 'SurfMajCompIce', xy_SurfMajCompIceN )
      call HistoryAutoPut( TimeN, 'SoilMoist'     , xy_SoilMoistN      )
      call HistoryAutoPut( TimeN, 'SurfSnow'      , xy_SurfSnowN       )
    end select


    ! ѿγ
    ! Allocation of diagnostic variables
    !
    allocate( xyz_DUDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DVDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_DPsDt    (0:imax-1, 1:jmax) )
    allocate( xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )

    allocate( xyz_DTurKinEneDt(0:imax-1, 1:jmax, 1:kmax) )

    allocate( xy_SurfHeight(0:imax-1, 1:jmax) )
    allocate( xyz_Height   (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_Exner    (0:imax-1, 1:jmax, 1:kmax) )

    select case ( IDPhysMode )
    case ( IDPhysModeFullPhysics )
      allocate( xy_SurfAlbedo         (0:imax-1, 1:jmax) )
      allocate( xy_SurfHumidCoef      (0:imax-1, 1:jmax) )
      allocate( xy_SurfRoughLength    (0:imax-1, 1:jmax) )
      allocate( xy_SurfHeatCapacity   (0:imax-1, 1:jmax) )
      allocate( xy_SeaIceConc         (0:imax-1, 1:jmax) )
      allocate( xy_SurfCond           (0:imax-1, 1:jmax) )
      allocate( xy_SurfType           (0:imax-1, 1:jmax) )
      allocate( xy_DeepSubSurfHeatFlux(0:imax-1, 1:jmax) )
      allocate( xy_SoilHeatCap        (0:imax-1, 1:jmax) )
      allocate( xy_SoilHeatDiffCoef   (0:imax-1, 1:jmax) )
      allocate( xy_SurfHeightStd      (0:imax-1, 1:jmax) )

      allocate( xy_PhyImplSDHIndexCalcMethod(0:imax-1, 1:jmax) )
      allocate( xy_BucketFlagOceanGrid      (0:imax-1, 1:jmax) )

      allocate( xyr_Temp   (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_VirTemp   (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_VirTemp   (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xy_SurfVirTemp(0:imax-1, 1:jmax) )
      allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_Height (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_Exner  (0:imax-1, 1:jmax, 0:kmax) )

      allocate( xyr_RadLFlux      (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLFluxA     (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSFlux      (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyra_DelRadLFlux  (0:imax-1, 1:jmax, 0:kmax,  0:1) )
      allocate( xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax,  0:1) )
      allocate( xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax,  0:1) )

      allocate( xyr_MomFluxX  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_MomFluxY  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_HeatFlux  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax) )

      allocate( xy_SurfMomFluxX  (0:imax-1, 1:jmax) )
      allocate( xy_SurfMomFluxY  (0:imax-1, 1:jmax) )
      allocate( xy_SurfHeatFlux  (0:imax-1, 1:jmax) )
      allocate( xyf_SurfQMixFlux (0:imax-1, 1:jmax, 1:ncmax) )

      allocate( xy_SurfH2OVapFluxA    (0:imax-1, 1:jmax) )
      allocate( xy_SurfLatentHeatFluxA(0:imax-1, 1:jmax) )

      allocate( xyr_SoilHeatFlux(0:imax-1, 1:jmax, 0:kslmax) )

      allocate( xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_TempDiffCoef(0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_QMixDiffCoef(0:imax-1, 1:jmax, 0:kmax) )

      allocate( xy_SurfVelTransCoef (0:imax-1, 1:jmax) )
      allocate( xy_SurfTempTransCoef(0:imax-1, 1:jmax) )
      allocate( xy_SurfQVapTransCoef(0:imax-1, 1:jmax) )

      allocate( xyr_SoilTempTransCoef (0:imax-1, 1:jmax, 0:kslmax) )

      allocate( xy_DSurfTempDt (0:imax-1, 1:jmax) )
      allocate( xyz_DSoilTempDt(0:imax-1, 1:jmax, 1:kslmax) )

      allocate( xy_DSurfMajCompIceDt(0:imax-1, 1:jmax) )
      allocate( xy_DSoilMoistDt     (0:imax-1, 1:jmax) )
      allocate( xy_DSurfSnowDt      (0:imax-1, 1:jmax) )

      allocate( xyz_DTempDtVDiff(0:imax-1, 1:jmax, 1:kmax) )

      allocate( xyz_DUDtGWD(0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DVDtGWD(0:imax-1, 1:jmax, 1:kmax) )

      allocate( xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax) )


      allocate( xy_Rain         (0:imax-1, 1:jmax) )
      allocate( xy_RainCumulus  (0:imax-1, 1:jmax) )
      allocate( xy_RainLsc      (0:imax-1, 1:jmax) )
      allocate( xy_Snow         (0:imax-1, 1:jmax) )
      allocate( xy_SnowCumulus  (0:imax-1, 1:jmax) )
      allocate( xy_SnowLsc      (0:imax-1, 1:jmax) )

      allocate( xyz_DQH2OLiqDtCum (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_DQH2OSolDtCum (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_DQH2OLiqDtLSC (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_DQH2OSolDtLSC (0:imax-1,1:jmax,1:kmax) )

      allocate( xyz_QH2OLiqforRad   (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_QH2OSolforRad   (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_CloudCoverforRad(0:imax-1,1:jmax,1:kmax) )

      allocate( xy_SurfDustGravSedFlux(0:imax-1,1:jmax) )

      ! ҥȥǡϤΤΤؤѿϿ
      ! Register of variables for history data output
      !
      call HistoryAutoAddVariable( 'SeaIceConc' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'sea ice concentration', '1' )

      call HistoryAutoAddVariable( 'SurfAlbedo' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'surface albedo', '1' )

      call HistoryAutoAddVariable( 'SurfRoughLength' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'surface roughness length', 'm' )

      call HistoryAutoAddVariable( 'SurfDustGravSedFlux' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'surface roughness length', 'm' )

    case ( IDPhysModeVenusSimple )

      allocate( xyr_Temp   (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_VirTemp   (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_VirTemp   (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_Height (0:imax-1, 1:jmax, 0:kmax) )
!!$      allocate( xyz_Exner  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Exner  (0:imax-1, 1:jmax, 0:kmax) )

    case ( IDPhysModeJupiterSimple )

      allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_VirTemp(0:imax-1, 1:jmax, 0:kmax) )

      allocate( xyz_DTempDtVDiff(0:imax-1, 1:jmax, 1:kmax) )

      allocate( xyr_HeatFlux      (0:imax-1, 1:jmax, 0:kmax) )

      allocate( xyr_RadLFlux      (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSFlux      (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_DTempDtRadL   (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DTempDtRadS   (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyra_DelRadLFlux  (0:imax-1, 1:jmax, 0:kmax,  0:1) )
      allocate( xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax,  0:1) )
      allocate( xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax,  0:1) )


    case ( IDPhysModeJupiterSimpleV2 )

      allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_VirTemp(0:imax-1, 1:jmax, 0:kmax) )
!!$      allocate( xyz_Exner  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Exner  (0:imax-1, 1:jmax, 0:kmax) )

      allocate( xyz_DTempDtVDiff(0:imax-1, 1:jmax, 1:kmax) )

      allocate( xyr_MomFluxX  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_MomFluxY  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_HeatFlux  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax) )

      allocate( xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_TempDiffCoef(0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_QMixDiffCoef(0:imax-1, 1:jmax, 0:kmax) )

      allocate( xy_SurfVelTransCoef (0:imax-1, 1:jmax) )
      allocate( xy_SurfTempTransCoef(0:imax-1, 1:jmax) )
      allocate( xy_SurfQVapTransCoef(0:imax-1, 1:jmax) )

      allocate( xyr_RadLFlux      (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSFlux      (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_DTempDtRadL   (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DTempDtRadS   (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyra_DelRadLFlux  (0:imax-1, 1:jmax, 0:kmax,  0:1) )
      allocate( xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax,  0:1) )
      allocate( xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax,  0:1) )

      allocate( xy_Rain         (0:imax-1, 1:jmax) )
      allocate( xy_RainCumulus  (0:imax-1, 1:jmax) )
      allocate( xy_RainLsc      (0:imax-1, 1:jmax) )
      allocate( xy_Snow         (0:imax-1, 1:jmax) )
      allocate( xy_SnowCumulus  (0:imax-1, 1:jmax) )
      allocate( xy_SnowLsc      (0:imax-1, 1:jmax) )

      allocate( xyz_DQH2OLiqDtCum (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_DQH2OSolDtCum (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_DQH2OLiqDtLSC (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_DQH2OSolDtLSC (0:imax-1,1:jmax,1:kmax) )

    end select







    ! ɽ̥ǡ
    ! Setting planetary surface properties
    !
    select case ( IDSfcMoistMethod )
    case ( IDSfcMoistMethodNone )
      call SurfacePropertiesInit(                    &
        & FlagPhysImpSoilModelSO, .false., FlagSnow  & ! (in)
        & )
    case ( IDSfcMoistMethodBucket )
      call SurfacePropertiesInit(                    &
        & FlagPhysImpSoilModelSO, .true. , FlagSnow  & ! (in)
        & )
    end select


    select case ( IDPhysMode )
    case ( IDPhysModeNoPhysics )

      ! Nothing to do

    case ( IDPhysModeHS94 )

      ! Held and Suarez (1994) ˤ붯Ȼ
      ! Forcing and dissipation suggested by Held and Suarez (1994)
      !
      call HS94Init

    case ( IDPhysModeVenusSimple )

      ! Ūѿ׻륵֥롼󡦴ؿ
      ! Subroutines and functions for calculating auxiliary variables
      !
      call AuxVarsInit

      ! Yamamoto and Takahashi (2003) ˽äñ׻Τζ
      ! forcing for simple Venus calculation following Yamamoto and Takahashi (2003)
      !
      call YT2003ForcingInit

    case ( IDPhysModeJupiterSimple )

      ! Ūѿ׻륵֥롼󡦴ؿ
      ! Subroutines and functions for calculating auxiliary variables
      !
      call AuxVarsInit

      ! Schneider and Liu (2009) ˤľ
      ! Vertical diffusion by Schneider and Liu (2009)
      !
      call SL09DiffusionInit

      ! Schneider and Liu (2009) ͥǥ
      ! Radiation model by Schneider and Liu (2009)
      !
      call RadSL09Init

      ! ʹϢ롼
      ! Routines for radiation calculation
      !
      call RadUtilsInit

    case ( IDPhysModeJupiterSimpleV2 )

      ! Ūѿ׻륵֥롼󡦴ؿ
      ! Subroutines and functions for calculating auxiliary variables
      !
      call AuxVarsInit

      ! եå
      ! Lower boundary flux
      !
      call LBFluxSimpleInit

      ! ˡˤʬ (絤Τ / ɽ̲١ھٷ׻ʤ)
      ! Time integration by using implicit scheme in case without calculation of surface and soil temperature
      !
      call PhyImplAtmOnlyInit

      ! Schneider and Liu (2009) ͥǥ
      ! Radiation model by Schneider and Liu (2009)
      !
      call RadSL09Init

      ! ʹϢ롼
      ! Routines for radiation calculation
      !
      call RadUtilsInit

    case ( IDPhysModeFullPhysics )

      ! ɽ̥ǡ
      ! Setting planetary surface properties
      !
      select case ( IDSfcMoistMethod )
      case ( IDSfcMoistMethodNone )
        call SurfacePropertiesInit(                    &
          & FlagPhysImpSoilModelSO, .false., FlagSnow  & ! (in)
          & )
      case ( IDSfcMoistMethodBucket )
        call SurfacePropertiesInit(                    &
          & FlagPhysImpSoilModelSO, .true. , FlagSnow  & ! (in)
          & )
      end select


      ! Ūѿ׻륵֥롼󡦴ؿ
      ! Subroutines and functions for calculating auxiliary variables
      !
      call AuxVarsInit

      select case ( IDRadMethod )
      case ( IDRadMethodDennouAGCM )

        ! ͥեå (GFD Ǿȯͥǥ)
        ! Radiation flux (radiation model developed by GFD Dennou Club)
        !
        call RadDennouAGCMInit( flag_rst = .not. flag_initial )

      case ( IDRadMethodEarthV2 )

        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if

        select case ( IDCloudMethod )
        case ( IDCloudMethodNone )
        case ( IDCloudMethodSimple )
          ! ñǥ
          ! Simple cloud
          !
          call CloudSimpleInit( &
            & FlagSnow          &
            & )
        case ( IDCloudMethodSimpleWithIce )
          ! ñǥ
          ! Simple cloud
          !
          call CloudSimpleInit( &
            & FlagSnow          &
            & )
        end select

        ! ϵ絤ͥǥ Ver. 2
        ! radiation model for the Earth's atmosphere Ver. 2
        !
        call RadEarthV2Init( &
          & FlagSnow         &
          & )

      case ( IDRadMethodMarsV1 )

        ! 絤ͥǥ Ver. 1
        ! radiation model for the Mars' atmosphere Ver. 1
        !
        call RadMarsV1Init

      case ( IDRadMethodSL09 )

        ! Schneider and Liu (2009) ͥǥ
        ! Radiation model by Schneider and Liu (2009)
        !
        call RadSL09Init

      case ( IDRadMethodSimple )

        ! ñͥǥ
        ! Simple radiation model
        !
        call RadSimpleInit

      end select


      ! ľȻեå (Mellor and Yamada, 1974)
      ! Vertical diffusion flux (Mellor and Yamada, 1974)
      !
      call VDiffusionInit

      ! ɽ̥եå (Х륯ˡ)
      ! Surface flux (Bulk method)
      !
      call SurfaceFluxInit

      !
      ! set dust flux
      !
!!$      call SetDustFluxInit

      ! ʪλѲΨη׻ (ˡ)
      ! Calculate tendency by a part of physical processes (implicit)
      !
      select case ( IDPhyTendMethod )
      case ( IDPhyTendMethodImp1LayModel )

        ! ˡˤʬ
        ! Time integration with implicit scheme
        !
        call PhyImplInit(             &
          & FlagBucketModel, FlagSnow &
          & )

      case ( IDPhyTendMethodImpSoilModel )

        select case ( IDSfcMoistMethod )
        case ( IDSfcMoistMethodBucket )
          ! Хĥǥ
          ! Bucket model
          !
          call BucketModelInit( &
            & FlagSnow          & ! (in)
            & )

        end select

        ! ϲˤǮαľȻ
        ! Vertical diffusion of heat under the ground
        !
        call SubsurfaceDiffusionInit

        ! ϲǮƳǥѤαˡˤʬ
        !
        ! Time integration by using implicit scheme in case using subsurface thermal diffusion model
!!$        call PhyImplSDHInit(                                                 &
!!$          & FlagBucketModel, FlagSnow,                                       &
!!$          & FlagPhysImpSoilModelSO, FlagMajCompPhaseChange, CondMajCompName  &
!!$          & )

        call PhyImplSDHV2Init(                                                &
          & FlagBucketModel, FlagSnow,                                       &
          & FlagPhysImpSoilModelSO, FlagMajCompPhaseChange, CondMajCompName  &
          & )

      case ( IDPhyTendMethodImpAtmOnly )

        ! ˡˤʬ (絤Τ / ɽ̲١ھٷ׻ʤ)
        ! Time integration by using implicit scheme in case without calculation of surface and soil temperature
        !
        call PhyImplAtmOnlyInit

      end select


      ! Gravity wave drag by McFarlane (1987)
      ! Gravity wave drag by McFarlane (1987)
      !
      call GWDM1987Init

      ! ˡˤʬΤΥ롼
      ! Routines for time integration with implicit scheme
      !
      call PhyImplUtilsInit

      ! ʹϢ롼
      ! Routines for radiation calculation
      !
      call RadUtilsInit


!!$      select case ( IDRadMethod )
!!$      case ( IDRadMethodMarsV1 )
!!$        ! (絤) Non-LTE ͥǥ
!!$        ! Non-NLTE radiation model (for the Mars' atmosphere)
!!$        !
!!$        call Rad15mNLTEInit
!!$      end select

      select case ( IDRadMethod )
      case ( IDRadMethodMarsV1 )
        ! ׻ѶֳǮΨ׻
        ! Calculation of near infrared heating rate in the case of Mars
        !
        call RadMarsNIRInit
      end select


      ! ľȻեå (Mellor and Yamada, 1974)
      ! Vertical diffusion flux (Mellor and Yamada, 1974)
      !
      call VDiffusionInit

      ! ɽ̥եå (Х륯ˡ)
      ! Surface flux (Bulk method)
      !
      call SurfaceFluxInit

      ! ʹϢ롼
      ! Routines for radiation calculation
      !
      call RadUtilsInit

    end select



    ! ̲١ھ١ھʬ̤ʬ
    ! Time integration of surface temperature, soil temperature, soil moisture, 
    ! and surface snow amount
    !
    select case ( IDPhysMode )
    case ( IDPhysModeFullPhysics )

      ! ̲, ھ٤λʬ
      ! Time integration of surface temperature and soil temperature
      !
      call IntgSurfTempInit

      select case ( IDSfcMoistMethod )
      case ( IDSfcMoistMethodBucket )
        ! Хĥǥ
        ! Bucket model
        !
        call BucketModelInit( &
          & FlagSnow          & ! (in)
          & )
      end select

    end select




    ! ϳز
    ! Dynamical core
    !
    select case ( IDDynMode )
    case ( IDDynModeHSPLVAS83 )
      ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
      ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
      !
      call DynamicsHSplVAS83Init
    case ( IDDynModeNoHorAdv )
      ! ʪΤߤη׻Τϳز
      ! A dynamics for calculation with physical processes only
      !
      call DynamicsPhysicsOnlyInit
    end select


    select case ( IDPhysMode )
    case ( IDPhysModeJupiterSimple )

      ! Ūѿ׻륵֥롼󡦴ؿ
      ! Subroutines and functions for calculating auxiliary variables
      !
      call AuxVarsInit

      select case ( IDDCMethod )
      case ( IDDCMethodDCA )
        ! ήĴ
        ! Dry convective adjustment
        !
        call DryConvAdjustInit
      end select

    case ( IDPhysModeJupiterSimpleV2 )

      ! Ūѿ׻륵֥롼󡦴ؿ
      ! Subroutines and functions for calculating auxiliary variables
      !
      call AuxVarsInit

      ! ήĴ
      ! Moist convective adjustment
      !
      call MoistConvAdjustInit

      ! 絬϶ŷ (ήŷ) (Manabe, 1965)
      ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
      !
      call LScaleCondInit( &
        & FlagSnow &
        & )

      ! ñǥ
      ! Simple cloud
      !
      call CloudSimpleInit( &
        & FlagSnow          &
        & )

      select case ( IDDCMethod )
      case ( IDDCMethodDCA )
        ! ήĴ
        ! Dry convective adjustment
        !
        call DryConvAdjustInit
      end select

      ! ̤
      ! Mass fixer
      !
      call MassFixerInit

    case ( IDPhysModeFullPhysics )

      ! Ūѿ׻륵֥롼󡦴ؿ
      ! Subroutines and functions for calculating auxiliary variables
      !
      call AuxVarsInit

      select case ( IDMCMethod )
      case ( IDMCMethodMCA )
        ! ήĴ
        ! Moist convective adjustment
        !
        call MoistConvAdjustInit
      case ( IDMCMethodRAS )
        ! Relaxed Arakawa-Schubert scheme
        ! Relaxed Arakawa-Schubert scheme
        !
        call RASInit
      case ( IDMCMethodRASWithIce )
        ! Relaxed Arakawa-Schubert scheme
        ! Relaxed Arakawa-Schubert scheme
        !
        call RASInit
      end select

      select case ( IDLSCMethod )
      case ( IDLSCMethodM65 )
        ! 絬϶ŷ (ήŷ) (Manabe, 1965)
        ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
        !
        call LScaleCondInit( &
          & FlagSnow &
          & )
!!$      case ( IDLSCMethodLL91 )
!!$        ! 絬϶ŷ (ήŷ) (Le Treut and Li, 1991)
!!$        ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
!!$        !
!!$        call LScaleCondLL91Init
      case ( IDLSCMethodSatAdjM65 )
        !
        != Saturation adjustment
        !
        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if
        call SaturationAdjustInit( FlagSnow )
      case ( IDLSCMethodM65WithIce )
        ! 絬϶ŷ (ήŷ) (Manabe, 1965)
        ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
        !
        call LScaleCondInit( &
          & FlagSnow &
          & )
      end select


      ! 
      ! Cloud model
      !
      select case ( IDCloudMethod )
      case ( IDCloudMethodNone )
        ! ñǥ
        ! Simple cloud
        !
        call CloudSimpleInit( &
          & FlagSnow          &
          & )
      case ( IDCloudMethodSimple )
        ! ñǥ
        ! Simple cloud
        !
        call CloudSimpleInit( &
          & FlagSnow          &
          & )
      case ( IDCloudMethodSimpleWithIce )
        ! ñǥ
        ! Simple cloud
        !
        call CloudSimpleInit( &
          & FlagSnow          &
          & )
        case ( IDCloudMethodMarsH2OCloud )
          !  H2O ǥ
          ! Mars H2O cloud model
          !
          call CloudMarsH2OInit
      end select


      select case ( IDSfcMoistMethod )
      case ( IDSfcMoistMethodBucket )
        ! Хĥǥ
        ! Bucket model
        !
        call BucketModelInit( &
          & FlagSnow          & ! (in)
          & )
      end select

      select case ( IDDCMethod )
      case ( IDDCMethodDCA )
        ! ήĴ
        ! Dry convective adjustment
        !
        call DryConvAdjustInit
      end select

      ! ߲
      ! Gravitational sedimentation process
      !
      call GravSedInit

      ! ʬѲ
      ! Phase change of atmospheric major component
      !
      call MajorCompPhaseChangeInit(                &
        & FlagMajCompPhaseChange, CondMajCompName   & ! (in)
        & )

      ! ̤
      ! Mass fixer
      !
      call MassFixerInit

    end select


    ! ե륿 (Asselin, 1972)
    ! Time filter (Asselin, 1972)
    !
!!$    call TimeFiltInit

    ! ֥ե륿 (Williams, 2009)
    ! Time filter (Williams, 2009)
    !
    call TimeFilterWilliams2009Init

    ! ͽѿͤγǧ
    ! Check values of prognostic variables
    !
    call CheckProgVarsInit

    ! Ūѿ׻륵֥롼󡦴ؿ
    ! Subroutines and functions for calculating auxiliary variables
    !
    call AuxVarsInit

    !
    ! End of initialization
    !


    ! ϥ顼ˡѤ뤿, t Ⱦʬ
    ! Delta t is reduced to half in order to use Euler method at initial step
    !
    if ( flag_initial ) then
      call TimesetDelTimeHalf
    end if

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! ⥸塼 ; USE statements
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperFinalize

    ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
    ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
    !
    use dynamics_hspl_vas83, only : DynamicsHSplVAS83Finalize

    ! Held and Suarez (1994) ˤ붯Ȼ
    ! Forcing and dissipation suggested by Held and Suarez (1994)
    !
    use held_suarez_1994, only: Hs94Finalize

    ! ͥեå (Хɥǥ)
    ! Radiation flux (band model)
    !
    use rad_DennouAGCM, only: RadDennouAGCMFinalize

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetFinalize

    ! ٤Ⱦҥ٥, ȹ٤λ
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure and height
    !
    use auxiliary, only: AuxVarsFinalize

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    ! ꥹȥǡե륯
    ! Close restart data file
    !
    call RestartFileClose

    if ( IDPhysMode == IDPhysModeFullPhysics ) then
      ! ɽ̲٥ꥹȥǡե륯
      ! Close restart data file of surface temperature
      !
      call RestartSurfTempClose
    end if

    ! ҥȥǡե륯
    ! Close history data files
    !
    call HistoryFileClose

    ! ͽѿγղ
    ! Deallocation of prediction variables
    !
    deallocate( xyz_UB     )
    deallocate( xyz_VB     )
    deallocate( xyz_TempB  )
    deallocate( xyzf_QMixB )
    deallocate( xy_PsB     )

    deallocate( xyz_UN     )
    deallocate( xyz_VN     )
    deallocate( xyz_TempN  )
    deallocate( xyzf_QMixN )
    deallocate( xy_PsN     )

    deallocate( xyz_UA     )
    deallocate( xyz_VA     )
    deallocate( xyz_TempA  )
    deallocate( xyzf_QMixA )
    deallocate( xy_PsA     )

    ! ѿγղ
    ! Dellocation of diagnostic variables
    !
    deallocate( xyz_DUDt     )
    deallocate( xyz_DVDt     )
    deallocate( xyz_DTempDt  )
    deallocate( xyzf_DQMixDt )

    deallocate( xyz_DTurKinEneDt )

    deallocate( xy_SurfHeight )
    deallocate( xyz_Height )

    if ( IDPhysMode == IDPhysModeFullPhysics ) then
      deallocate( xy_SurfAlbedo          )
      deallocate( xy_SurfHumidCoef       )
      deallocate( xy_SurfRoughLength     )
      deallocate( xy_SurfHeatCapacity    )
      deallocate( xy_SeaIceConc          )
      deallocate( xy_SurfCond            )
      deallocate( xy_SurfType            )
      deallocate( xy_DeepSubSurfHeatFlux )
      deallocate( xy_SoilHeatCap         )
      deallocate( xy_SoilHeatDiffCoef    )
      deallocate( xy_SurfHeightStd       )

      deallocate( xy_PhyImplSDHIndexCalcMethod )
      deallocate( xy_BucketFlagOceanGrid       )

      deallocate( xyr_Temp   )
      deallocate( xyz_VirTemp )
      deallocate( xyr_VirTemp )
      deallocate( xy_SurfVirTemp )
      deallocate( xyz_Press  )
      deallocate( xyr_Press  )
      deallocate( xyr_Height )
      deallocate( xyz_Exner  )
      deallocate( xyr_Exner  )

      deallocate( xyr_RadLFlux     )
      deallocate( xyr_RadLFluxA    )
      deallocate( xyr_RadLUwFlux   )
      deallocate( xyr_RadLDwFlux   )
      deallocate( xyr_RadSFlux     )
      deallocate( xyr_RadSUwFlux     )
      deallocate( xyr_RadSDwFlux     )
      deallocate( xyra_DelRadLUwFlux )
      deallocate( xyra_DelRadLDwFlux )

      deallocate( xyr_MomFluxX  )
      deallocate( xyr_MomFluxY  )
      deallocate( xyr_HeatFlux  )
      deallocate( xyrf_QMixFlux )

      deallocate( xy_SurfMomFluxX  )
      deallocate( xy_SurfMomFluxY  )
      deallocate( xy_SurfHeatFlux  )
      deallocate( xyf_SurfQMixFlux )

      deallocate( xy_SurfH2OVapFluxA     )
      deallocate( xy_SurfLatentHeatFluxA )

      deallocate( xyr_SoilHeatFlux )

      deallocate( xyr_VelDiffCoef  )
      deallocate( xyr_TempDiffCoef )
      deallocate( xyr_QMixDiffCoef )

      deallocate( xy_SurfVelTransCoef  )
      deallocate( xy_SurfTempTransCoef )
      deallocate( xy_SurfQVapTransCoef )

      deallocate( xy_DSurfTempDt )
      deallocate( xyz_DSoilTempDt )

      deallocate( xy_DPsDt )

      deallocate( xy_DSurfMajCompIceDt )
      deallocate( xy_DSoilMoistDt      )
      deallocate( xy_DSurfSnowDt       )

      deallocate( xyz_DTempDtVDiff )

      deallocate( xyz_DUDtGWD )
      deallocate( xyz_DVDtGWD )

      deallocate( xyz_DTempDtRadL )
      deallocate( xyz_DTempDtRadS )


      deallocate( xy_Rain          )
      deallocate( xy_RainCumulus   )
      deallocate( xy_RainLsc       )
      deallocate( xy_SnowCumulus   )
      deallocate( xy_SnowLsc       )

      deallocate( xyz_DQH2OLiqDtCum  )
      deallocate( xyz_DQH2OSolDtCum  )
      deallocate( xyz_DQH2OLiqDtLSC  )
      deallocate( xyz_DQH2OSolDtLSC  )

      deallocate( xyz_QH2OLiqforRad    )
      deallocate( xyz_QH2OSolforRad    )
      deallocate( xyz_CloudCoverforRad )
    end if ! FlagFullPhysics



    ! ƥ⥸塼ѿγղ
    ! Dellocation of variables in modules
    !
    call DynamicsHSplVAS83Finalize

    call AuxVarsFinalize

    select case ( IDPhysMode )
    case ( IDPhysModeHS94 )
      call Hs94Finalize
    end select

    select case ( IDPhysMode )
    case ( IDPhysModeFullPhysics )
      ! ղȥꥹȥեνλ
      ! Dellocation and close a restart file
      !
      call RadDennouAGCMFinalize
    end select

    call AxessetFinalize

    ! λ
    ! Termination of time control
    !
    call TimesetClose

    ! Finalize MPI
    !
    call MPIWrapperFinalize


  end subroutine MainTerminate

end program dcpam_main
