! The development of this module stops, because the calculation is almost the 
! same as Ver. 2.1.

!= ϵ絤ûͥǥ Ver. 2.5
!
!= short wave radiation model for the Earth's atmosphere Ver. 2.1
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: rad_Earth_SW_V2_1.f90,v 1.6 2013-01-18 02:40:46 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module rad_Earth_SW_V2_5

  !
  != ϵ絤ûͥǥ Ver. 2.5
  !
  != short wave radiation model for the Earth's atmosphere Ver. 2.5
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϵ絤ûͥǥ.
  !
  ! This is a short wave radiation model for the Earth's atmospehre.
  ! This radiation model is based on Chou and Suarez (1999).
  !
  ! NOTE: This file is based on Ver. 2.1 routine, not Ver. 2.4.
  !
  !
  ! The wavenumber range of shortwave radiation treated by this routine is 
  ! from 1000 to 57140 cm-1 (0.175 to 10 micrometer). 
  !
!!$  ! From 1000 to 57143 cm-1, the following effects are considered. 
!!$  ! * 44440 to 57140 cm-1 ( 0.175- 0.225 micrometer): 
!!$  !   * absorption by O3
!!$  !   * Rayleigh scattering
!!$  !   * scattering and absorption by cloud droplets
!!$  ! *  1000 to  4400 cm-1 ( 2.270-10.000 micrometer): 
!!$  !   * absorption by H2O, 
  !
  !== References
  !
  !  Chou, M.-D., and M. J. Suarez, 
  !    A solar radiation parameterization for atmospheric studies, 
  !    Technical Report Series on Global Modeling and Data Assimilation, 
  !    NASA/TM-1999-104606, Vol. 15.
  !
  !== Procedures List
  !
  ! RadEarthSWV25Flux   :: ͥեåη׻
  ! ------------        :: ------------
  ! RadEarthSWV25Flux   :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_Earth_SW_V2_5_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify


  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  ! 
  ! Time control
  !
  use timeset, only: &
    & TimesetClockStart, TimesetClockStop

  implicit none

  private

  logical , save      :: FlagRayleighScattering

  integer, parameter :: NBands1 =  8 ! Bands  1- 8
  integer, parameter :: NBands2 =  3 ! Bands  9-11
  integer, parameter :: NKDBin  = 10

  real(DP), save :: a_FracSolarFlux    (1:NBands1+NBands2)
  real(DP), save :: a_O3AbsCoefBand1   (1:NBands1)
  real(DP), save :: a_H2OAbsCoefBand1  (1:NBands1)
  real(DP), save :: a_RayScatCoef      (1:NBands1+NBands2)
  real(DP), save :: a_H2OAbsCoefBand2  (1:NKDBin)
  real(DP), save :: aa_H2OAbsWeightBand2(NBands1+1:NBands1+NBands2, 1:NKDBin)


  real(DP), save      :: CloudWatREff
  real(DP), save      :: CloudIceREff


  ! ѿ
  ! Public variables
  !
  logical, save :: rad_Earth_SW_V2_5_inited = .false.
                              ! ե饰.
                              ! Initialization flag


  ! Table 3. of Chou and Suarez (1999)
  !   S/S_0 (1)
  data a_FracSolarFlux &
    & / &
    & 0.00057_DP, 0.00367_DP, 0.00083_DP, 0.00417_DP, 0.00600_DP, 0.00556_DP, &
    & 0.05913_DP, 0.39081_DP, 0.32055_DP, 0.16536_DP, 0.04335_DP &
    & /
  ! Table 3. of Chou and Suarez (1999)
  !   O3 absorption coefficient ((cm-atm)-1)
  data a_O3AbsCoefBand1 &
    & / &
    &  30.47_DP  , 187.24_DP  , 301.92_DP,  42.83_DP,   7.09_DP,   1.25_DP, &
    &   0.0345_DP,   0.0572_DP &
    & /
  ! Table 3. of Chou and Suarez (1999)
  !   H2O absorption coefficient (g-1 cm2)
  data a_H2OAbsCoefBand1 &
    & / &
    &  0.0_DP, 0.0_DP, 0.0_DP, 0.0_DP, 0.0_DP, 0.0_DP, 0.0_DP, 0.00075_DP &
    & /
  ! Table 3. of Chou and Suarez (1999)
  !   Rayleigh scattering coefficient (hPa-1)
  data a_RayScatCoef &
    & / &
    &  0.00604_DP, 0.00170_DP, 0.00222_DP, 0.00132_DP, 0.00107_DP, 0.00091_DP,&
    &  0.00055_DP, 0.00012_DP, 0.0000156_DP, 0.0000018_DP, 0.0_DP &
    & /

  ! Table 2. of Chou and Suarez (1999)
  !   Absorption coefficient (g-1 cm2)
  data a_H2OAbsCoefBand2 &
    & / &
    & 0.0010_DP, 0.0133_DP,  0.0422_DP,   0.1334_DP,      0.4217_DP, &
    & 1.3340_DP, 5.6230_DP, 31.620_DP , 177.80_DP  , 1000.0_DP       &
    & / 
  ! Table 2. of Chou and Suarez (1999)
  !   h (1)
  data aa_H2OAbsWeightBand2 &
    & / &
    & 0.20673_DP, 0.03497_DP, 0.03011_DP, 0.02260_DP, 0.01336_DP, &
    & 0.00696_DP, 0.00441_DP, 0.00115_DP, 0.00026_DP, 0.00000_DP, & ! Band  9
    & 0.08236_DP, 0.01157_DP, 0.01133_DP, 0.01143_DP, 0.01240_DP, &
    & 0.01258_DP, 0.01381_DP, 0.00650_DP, 0.00244_DP, 0.00094_DP, & ! Band 10
    & 0.01074_DP, 0.00360_DP, 0.00411_DP, 0.00421_DP, 0.00389_DP, &
    & 0.00326_DP, 0.00499_DP, 0.00465_DP, 0.00245_DP, 0.00145_DP  & ! Band 11
    & / 


  public :: RadEarthSWV25Flux
  public :: RadEarthSWV25Init

  character(*), parameter:: module_name = 'rad_Earth_SW_V2_5'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: rad_Earth_SW_V2_5.f90,v 1.6 2013-01-18 02:40:46 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine RadEarthSWV25Flux(                                &
    & xy_SurfAlbedo,                                           &
    & xyz_DelAtmMass,                                          &
    & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
    & xyz_DelO3Mass,                                           &
    & xyz_Press, xyz_Temp,                                     &
    & xyz_CloudCover,                                          &
    & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
    & )

    ! USE statements
    !

    ! ͥեå
    ! Set solar constant
    !
    use set_solarconst, only : SetSolarConst

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncome

    !
    ! Solve radiative transfer equation in two stream approximation
    !
    use rad_rte_two_stream_app, only: RadRTETwoStreamAppSW

    ! Chou et al (1998) ˤûѱǥ
    ! Cloud model for short wave radiation model described by Chou et al (1998)
    !
    use rad_C1998, only : RadC1998CalcCloudOptProp


    real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_CloudCover   (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)


    real(DP) :: SolarConst

    real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
                              ! sec (ͳ).
                              ! sec (angle of incidence)
    real(DP) :: DistFromStarScld
                               ! Distance between the central star and the planet
    real(DP) :: DiurnalMeanFactor


    real(DP) :: SolarFluxTOA


    real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)


    real(DP), parameter :: RayScatSinScatAlb = 1.0d0 - 1.0d-10
    real(DP), parameter :: RayScatAsymFact   = 0.0d0

    real(DP)            :: xyz_DelH2OVapMassScaled( 0:imax-1, 1:jmax, 1:kmax )

    real(DP)            :: xyz_DelCloudWatOptDep( 0:imax-1, 1:jmax, 1:kmax )
    real(DP)            :: xyz_DelCloudIceOptDep( 0:imax-1, 1:jmax, 1:kmax )

    real(DP)            :: xyz_RayScatDelOptDep( 0:imax-1, 1:jmax, 1:kmax )

    real(DP)            :: xyz_H2OAbsDelOptDep ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP)            :: xyz_O3AbsDelOptDep  ( 0:imax-1, 1:jmax, 1:kmax )

    real(DP)            :: xyz_DelTotOptDep( 0:imax-1, 1:jmax, 1:kmax )
    real(DP)            :: xyr_TotOptDep   ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP)            :: xyr_RadFlux     ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP)            :: xyr_RadUwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP)            :: xyr_RadDwFlux   ( 0:imax-1, 1:jmax, 0:kmax )

    integer  :: iKDBin
    real(DP) :: KDAbsCoef
    real(DP) :: KDWeight
    real(DP) :: xyz_H2ODelOptDep( 0:imax-1, 1:jmax, 1:kmax )


    real(DP) :: xyz_CloudREff   (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudExtCoef(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudCoAlb  (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudWatSSA (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudWatAF  (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudIceSSA (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudIceAF  (0:imax-1, 1:jmax, 1:kmax)


    real(DP) :: FracSolarFlux
    real(DP) :: O3AbsCoef
    real(DP) :: H2OAbsCoef
    real(DP) :: RayScatCoef

    integer  :: i
    integer  :: j
    integer  :: k
    integer  :: l


    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_Earth_SW_V2_5_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! ͥեå
    ! Set solar constant
    !
    call SetSolarConst( &
      & SolarConst      & ! (out)
      & )

    ! ûͤη׻
    ! Calculate short wave (insolation) incoming radiation
    !
    call RadShortIncome(                       &
      & xy_InAngle        = xy_InAngle,        & ! (out) optional
      & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
      & DiurnalMeanFactor = DiurnalMeanFactor  &
      & )


    call RadEarthSWV25ScaleH2OVapMass(          &
      & xyz_Temp, xyz_DelH2OVapMass, xyz_Press, & ! (in )
      & xyz_DelH2OVapMassScaled                 & ! (out)
      & )


    ! Initialization
    !
    xyr_RadSUwFlux = 0.0_DP
    xyr_RadSDwFlux = 0.0_DP


    ! * 14280 to 57140 cm-1 (0.175 to 0.700 micrometer): 
    !   * Rayleigh scattering, 
    !   * scattering and absorption by cloud droplets. 
    !   * O3 absorption
    !
    do l = 1, NBands1

      ! Water cloud optical properties
      !
      xyz_CloudREff = CloudWatREff
!!$      call RadC1998CalcCloudOptProp(                        &
!!$        & 'Liquid', l, xyz_CloudREff,                       & ! (in )
!!$        & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
!!$        & )
      xyz_CloudExtCoef = 0.0_DP
      xyz_CloudCoAlb   = 0.0_DP
      xyz_CloudWatAF   = 0.0_DP
      xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
      xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb

      ! Ice cloud optical properties
      !
      xyz_CloudREff = CloudIceREff
!!$      call RadC1998CalcCloudOptProp(                        &
!!$        & 'Ice', l, xyz_CloudREff,                          & ! (in )
!!$        & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
!!$        & )
      xyz_CloudExtCoef = 0.0_DP
      xyz_CloudCoAlb   = 0.0_DP
      xyz_CloudIceAF   = 0.0_DP
      xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
      xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb


      FracSolarFlux = a_FracSolarFlux  (l)
      O3AbsCoef     = a_O3AbsCoefBand1 (l)
      H2OAbsCoef    = a_H2OAbsCoefBand1(l)
      RayScatCoef   = a_RayScatCoef    (l)


      SolarFluxTOA = FracSolarFlux * SolarConst / DistFromStarScld**2 &
        & * DiurnalMeanFactor


      ! Rayleigh scattering
      !
      if ( FlagRayleighScattering ) then
        xyz_RayScatDelOptDep = RayScatCoef * xyz_DelAtmMass
      else
        xyz_RayScatDelOptDep = 0.0_DP
      end if

      ! H2O absorption
      !
      xyz_H2OAbsDelOptDep = H2OAbsCoef * xyz_DelH2OVapMassScaled

      ! O3 absorption
      !
      xyz_O3AbsDelOptDep = O3AbsCoef * xyz_DelO3Mass


      ! Total optical parameter
      !
      xyz_DelTotOptDep =            &
        &   xyz_DelCloudWatOptDep   &
        & + xyz_DelCloudIceOptDep   &
        & + xyz_RayScatDelOptDep    &
        & + xyz_H2OAbsDelOptDep     &
        & + xyz_O3AbsDelOptDep
      !
      xyr_TotOptDep(:,:,kmax) = 0.0d0
      do k = kmax-1, 0, -1
        xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
      end do
      !
      xyz_SSA =                                           &
        &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
        &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
        &   + RayScatSinScatAlb * xyz_RayScatDelOptDep    &
        &   + 0.0_DP            * xyz_H2OAbsDelOptDep     &
        &   + 0.0_DP            * xyz_O3AbsDelOptDep   )  &
        & / ( xyz_DelTotOptDep + 1.0e-100_DP )
      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax-1
            if ( xyz_SSA(i,j,k) >= 1.0_DP ) then
              xyz_SSA(i,j,k) = 1.0_DP - 1.0e-10_DP
            end if
          end do
        end do
      end do
      xyz_AF  =                                                               &
        &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
        &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
        &   + RayScatAsymFact   * RayScatSinScatAlb * xyz_RayScatDelOptDep    &
        &   + 0.0_DP            * 0.0_DP            * xyz_H2OAbsDelOptDep     &
        &   + 0.0_DP            * 0.0_DP            * xyz_O3AbsDelOptDep   )  &
        & / ( xyz_SSA * xyz_DelTotOptDep + 1.0e-100_DP )


      call RadRTETwoStreamAppSW(        &
        & xyz_SSA, xyz_AF,              & ! (in)
        & xyr_TotOptDep,                & ! (in)
        & xy_SurfAlbedo,                & ! (in)
        & SolarFluxTOA, xy_InAngle,     & ! (in)
        & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
        & )

      xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
      xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux

    end do


    ! * 1000 to 14280 cm-1 (0.70-10 micrometer): 
    !   * absorption by H2O, 
    !   * scattering and absorption by cloud droplets.
    !

    SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor

    do l = NBands1+1, NBands1+NBands2

      ! Water cloud optical properties
      !
      xyz_CloudREff = CloudWatREff
!!$      call RadC1998CalcCloudOptProp(                        &
!!$        & 'Liquid', l, xyz_CloudREff,                       & ! (in )
!!$        & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
!!$        & )
      xyz_CloudExtCoef = 0.0_DP
      xyz_CloudCoAlb   = 0.0_DP
      xyz_CloudWatAF   = 0.0_DP
      xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
      xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb

      ! Ice cloud optical properties
      !
      xyz_CloudREff = CloudIceREff
!!$      call RadC1998CalcCloudOptProp(                        &
!!$        & 'Ice', l, xyz_CloudREff,                          & ! (in )
!!$        & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
!!$        & )
      xyz_CloudExtCoef = 0.0_DP
      xyz_CloudCoAlb   = 0.0_DP
      xyz_CloudIceAF   = 0.0_DP
      xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
      xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb


      ! Rayleigh scattering
      !
      RayScatCoef = a_RayScatCoef    (l)
      if ( FlagRayleighScattering ) then
        xyz_RayScatDelOptDep = RayScatCoef * xyz_DelAtmMass
      else
        xyz_RayScatDelOptDep = 0.0_DP
      end if


      do iKDBin = 1, NKDBin

        KDAbsCoef = a_H2OAbsCoefBand2(l)
        KDWeight  = aa_H2OAbsWeightBand2(l,iKDBin)

        xyz_H2ODelOptDep = KDAbsCoef * xyz_DelH2OVapMassScaled


        ! Total optical parameter
        !
        xyz_DelTotOptDep =          &
          &   xyz_DelCloudWatOptDep &
          & + xyz_DelCloudIceOptDep &
          & + xyz_RayScatDelOptDep  &
          & + xyz_H2ODelOptDep

        xyr_TotOptDep(:,:,kmax) = 0.0d0
        do k = kmax-1, 0, -1
          xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
        end do

        xyz_SSA =                                            &
          &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep    &
          &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep    &
          &   + RayScatSinScatAlb * xyz_RayScatDelOptDep     &
          &   + 0.0d0             * xyz_H2ODelOptDep      )  &
          & / ( xyz_DelTotOptDep + 1.0d-100 )
        do k = 1, kmax
          do j = 1, jmax
            do i = 0, imax-1
              if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
                xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
              end if
            end do
          end do
        end do
        xyz_AF  =                                                               &
          &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
          &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
          &   + RayScatAsymFact   * RayScatSinScatAlb * xyz_RayScatDelOptDep    &
          &   + 0.0d0             * 0.0d0             * xyz_H2ODelOptDep     )  &
          & / ( xyz_ssa * xyz_DelTotOptDep + 1.0d-100 )


        call RadRTETwoStreamAppSW(        &
          & xyz_SSA, xyz_AF,              & ! (in)
          & xyr_TotOptDep,                & ! (in)
          & xy_SurfAlbedo,                & ! (in)
          & SolarFluxTOA, xy_InAngle,     & ! (in)
          & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
          & )


        xyr_RadUwFlux = xyr_RadUwFlux * KDWeight
        xyr_RadDwFlux = xyr_RadDwFlux * KDWeight

        xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
        xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux

      end do

    end do



!!$    i = 0
!!$    j = jmax / 2 + 1
!!$    do k = 1, kmax
!!$      write( 73, * ) xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), &
!!$        & xyz_Press(i,j,k)
!!$    end do
!!$    call flush( 73 )
!!$
!!$    i = 0
!!$    j = jmax / 2 + 1
!!$    do k = 1, kmax
!!$      write( 83, * ) &
!!$        & + (     xyr_RadSFlux(i,j,k-1) - xyr_RadSFlux(i,j,k) )  &
!!$        &     / ( xyr_Press(i,j,k-1)    - xyr_Press(i,j,k) )     &
!!$        &     / 1004.6 * Grav, &
!!$        & xyz_Press(i,j,k)
!!$    end do
!!$    call flush( 83 )
!!$
!!$!    write( 6, * ) '########## ', acos( 1.0d0 / xy_InAngle(i,j) ) * 180.0d0 / 3.141592d0
!!$
!!$
!!$    i = 0
!!$    j = jmax / 2 + 1
!!$    write( 93, * ) '# ', xy_SurfAlbedo(i,j)
!!$    write( 93, * ) '# ', 1.0_DP / xy_InAngle(i,j)
!!$    do k = 0, kmax
!!$      write( 93, * ) xyr_RadSFlux(i,j,k), xyr_Press(i,j,k)
!!$    end do
!!$    call flush( 93 )
!!$    stop


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )


  end subroutine RadEarthSWV25Flux

  !----------------------------------------------------------------------------

  subroutine RadEarthSWV25ScaleH2OVapMass(    &
    & xyz_Temp, xyz_DelH2OVapMass, xyz_Press, & ! (in )
    & xyz_DelH2OVapMassScaled                 & ! (out)
    & )


    ! USE statements
    !

    real(DP), intent(in ):: xyz_Temp               (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ):: xyz_DelH2OVapMass      (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ):: xyz_Press              (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out):: xyz_DelH2OVapMassScaled(0:imax-1, 1:jmax, 1:kmax)


    !
    ! Work variables
    !
    real(DP), parameter :: H2OScaleIndex = 0.8_DP
    real(DP), parameter :: RefPress      = 300.0e2_DP
    real(DP), parameter :: RefTemp       = 240.0_DP


    ! ǧ
    ! Initialization check
    !
    if ( rad_Earth_SW_V2_5_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_DelH2OVapMassScaled =                                         &
      &   xyz_DelH2OVapMass                                           &
      & * ( xyz_Press / RefPress )**H2OScaleIndex                     &
      & * ( 1.0_DP + 0.00135_DP * ( xyz_Temp - RefTemp ) )


  end subroutine RadEarthSWV25ScaleH2OVapMass

  !----------------------------------------------------------------------------

  subroutine RadEarthSWV25Init

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ͥեå
    ! Set solar constant
    !
    use set_solarconst, only : SetSolarConstInit

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncomeInit

    !
    ! Solve radiative transfer equation in two stream approximation
    !
    use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit

    ! Chou et al (1998) ˤûѱǥ
    ! Cloud model for short wave radiation model described by Chou et al (1998)
    !
    use rad_C1998, only : RadC1998Init


    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /rad_Earth_SW_V2_5_nml/ &
      & FlagRayleighScattering, &
      & CloudWatREff, CloudIceREff
          !
          ! ǥեͤˤĤƤϽ³ "rad_Earth_SW_V2_5#RadEarthSWV25Init"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_Earth_SW_V2_5#RadEarthSWEV25Init" for the default values.
          !

    if ( rad_Earth_SW_V2_5_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    FlagRayleighScattering = .true.

    CloudWatREff           = 10.0d-6
    CloudIceREff           = 50.0d-6

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                          & ! (in)
        & nml = rad_Earth_SW_V2_5_nml,         & ! (out)
        & iostat = iostat_nml )                  ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! Unit conversion

    !   O3 absorption coefficient from (cm-atm)-1 to (kg m-2)-1
    !     In order to convert unit from cm-1 atm-1 to m2 kg-1, multiply by
    !       1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0.
    !
    !     MEMO: In a calculation below, GasRUniv variable in constants module 
    !           can be used.
    !           But, I do not use it, since unit of value is just converted by
    !           multiplying a factor. Of course, non-use of GasRUniv must not 
    !           cause significant effect on result.
    !
    a_O3AbsCoefBand1 = a_O3AbsCoefBand1 &
      & * 1.0e2_DP / 101325.0_DP * 8.31432_DP / ( 16.0_DP * 3 ) * 273.15_DP

    !   H2O absorption coefficient from g-1 cm2 to (kg m-2)-1
    !
    a_H2OAbsCoefBand1 = a_H2OAbsCoefBand1 * 1.0e3_DP * (1.0e-2_DP)**2

    !   Rayleigh scattering coefficient from hPa-1 to (kg m-2)-1
    !     MEMO:
    !       1    hPa = 1e2 Pa
    !       1e-2 hPa = 1   Pa
    !
    !     In order to convert unit from (hPa)^{-1} to (kg m-2)^{-1}, scattering
    !     coefficient is multiplied by 1.0d-1 * g, where g is the gravitational
    !     acceleration. 
    !     The value of gravitational acceleration is set to a constant value, 
    !     9.8_DP. 
    !     This is because the value of Grav in constants module may be changed 
    !     to a value which is different from the Earth's value. (Of course, 
    !     the scattering coefficient in unit of (kg m-2)^{-1} is independent 
    !     on gravitational acceleration.)
    !
    a_RayScatCoef = a_RayScatCoef * 1.0e-2_DP * 9.8_DP

    !   Absorption coefficient from g-1 cm2 to kg-1 m2
    a_H2OAbsCoefBand2 = a_H2OAbsCoefBand2 * 1.0e3_DP * (1.0e-2_DP)**2


    ! Initialization of modules used in this module
    !

    ! ͥեå
    ! Set solar constant
    !
    call SetSolarConstInit

    ! û ()
    ! Short wave (insolation) incoming
    !
    call RadShortIncomeInit

    !
    ! Solve radiative transfer equation in two stream approximation
    !
    call RadRTETwoStreamAppInit

    ! Chou et al (1998) ˤûѱǥ
    ! Cloud model for short wave radiation model described by Chou et al (1998)
    !
    call RadC1998Init


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'FlagRayleighScattering = %b', l = (/ FlagRayleighScattering /) )
    call MessageNotify( 'M', module_name, 'CloudWatREff           = %f', &
      & d = (/ CloudWatREff /) )
    call MessageNotify( 'M', module_name, 'CloudIceREff           = %f', &
      & d = (/ CloudIceREff /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    rad_Earth_SW_V2_5_inited = .true.

  end subroutine RadEarthSWV25Init

  !--------------------------------------------------------------------------------------

end module rad_Earth_SW_V2_5
