!= ʪή (ߥ饰󥸥ˡ)
!
!= Semi-Lagrangian Tracer Transport scheme
!
! Authors::   Hiroki KASHIMURA, Yoshiyuki O. TAKAHASHI
! Version::   
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module sltt
  !
  != ʪή (ߥ饰󥸥ˡ, Enomoto (2008) modified)
  !
  != Tracer Transport (Semi-Lagrangian method, Enomoto (2008) modified)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʪή¸Υߥ饰󥸥ˡǱ黻⥸塼Ǥ. 
  ! ήõˤ Williamson and Rasch (1989, MWR) 
  ! ֤ˤ Enomoto (2008) ѤˡѤƤޤ
  ! ʤڥȥ뤫᤿ʬͤѤ٤§ߡ֤Ǥ
  ! ݾڤ뤿 arcsine Ѵե륿ѤƤޤ
  ! ڥȥѴ֤ͳ褹͹ŪûȤ뤿 Sun et al. (1996) 
  ! ñĴե륿ѤΤʬŪѤƤ롣 
  !
  ! This is a tracer transport module. Semi-Lagrangian method (Enomoto 2008 modified)
  ! Arcsine transformation filter is used to avoid negative values.
  ! Monotonicity filter (Sun et al 1996) is partly used.
  !
  !== Procedures List
  !
  ! SLTTMain     :: ή׻
  ! SLTTInit     :: 
  ! SLTTTest     :: ήƥ
  ! ---------------------     :: ------------
  ! SLTTMain     :: Main subroutine for SLTT
  ! SLTTInit     :: Initialization for SLTT
  ! SLTTTest     :: Generate velocity for SLTT Test 
  !
  !== NAMELIST
  !
  ! NAMELIST#
  !
  !== References
  !
  ! * Kashimura, H., T. Enomoto, Y. O. Takahashi, 2013: 
  !   Non-negative filter using arcsine transformation for tracer advection with semi-Lagrangian scheme.
  !   <i>NCTAM</i>, <b>62</b>.
  !
  ! * Enomoto, T., 2008: 
  !   Bicubic Interpolation with Spectral Derivatives. 
  !   <i>SOLA</i>, <b>4</b>, 5-8. doi:10.2151/sola.2008-002
  !
  ! * Williamson, D. L., and Rasch, P. J., 1989:
  !   Two-dimensional semi-Lagrangian transport with shape-preserving interpolation.
  !   <i> Mon. Wea. Rev.</i>, <b>117</b>, 102-129.
  !
  ! * Sun, W.-Y., Yeh, K.-S., and Sun, R.-Y., 1996: 
  !   A simple semi-Lagrangian scheme for advection equations. 
  !   <i>Quarterly Journal of the Royal Meteorological Society</i>, 
  !   <b>122(533)</b>, 1211-1226. doi:10.1002/qj.49712253310
  
  ! ⥸塼 ; USE statements
  !
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP,  & ! ټ¿. Double precision.
    &                 TOKEN  ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  !
  ! MPI
  !
  use mpi_wrapper, only : MPIWrapperFindMaxVal

  ! 
  ! Time control
  !
  use timeset, only: &
    & DelTime

  ! ʻ
  ! Grid points settings
  !
  use gridset, only:       &
    &                imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax, & ! ľؿ.
                             ! Number of vertical level
    &                lmax    ! ڥȥǡ󥵥
                             ! Size of array for spectral data

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only:                              &
    &                    ncmax,                       &
                             ! ʬο
                             ! Number of composition
    &                    CompositionInqFlagAdv

  ! ̤
  ! Mass fixer
  !
  use mass_fixer, only: MassFixer, MassFixerR95, MassFixerWO94, MassFixerColumn!, MassFixerLayer


  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: SLTTInit
  public :: SLTTMain



  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: sltt_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  real(DP)    , save, allocatable :: x_LonS   (:)
                              ! $\lambda_S$ Ⱦη١
                              ! longitude in SH.
  real(DP)    , save, allocatable :: x_SinLonS(:)
                              ! $\sin\lambda_S$
  real(DP)    , save, allocatable :: x_CosLonS(:)
                              ! $\cos\lambda_S$
  real(DP)    , save, allocatable :: y_LatS   (:)
                              ! $\varphi_S$ Ⱦΰ١
                              ! latitude in SH.
  real(DP)    , save, allocatable :: y_SinLatS(:)
                              ! $\sin\varphai_S$
  real(DP)    , save, allocatable :: y_CosLatS(:)
                              ! $\cos\varphai_S$
  real(DP)    , save, allocatable :: x_ExtLonS(:)
                              ! $ x_LonSγĥ
                              !Extended array of x_LonS.
  real(DP)    , save, allocatable :: y_ExtLatS(:)
                              ! $ x_LatSγĥ
                              !Extended array of x_LatS.

  real(DP)    , save, allocatable :: x_LonN   (:)
                              ! $\lambda_N$ Ⱦη١
                              ! longitude in NH.
  real(DP)    , save, allocatable :: x_SinLonN(:)
                              ! $\sin\lambda_N$
  real(DP)    , save, allocatable :: x_CosLonN(:)
                              ! $\cos\lambda_N$
  real(DP)    , save, allocatable :: y_LatN   (:)
                              ! $\varphi_N$ Ⱦΰ١
                              ! latitude in NH.
  real(DP)    , save, allocatable :: y_SinLatN(:)
                              ! $\sin\varphai_N$
  real(DP)    , save, allocatable :: y_CosLatN(:)
                              ! $\cos\varphai_N$
  real(DP)    , save, allocatable :: x_ExtLonN(:)
                              ! $ x_LonNγĥ
                              !Extended array of x_LonN.
  real(DP)    , save, allocatable :: y_ExtLatN(:)
                              ! $ x_LatNγĥ
                              !Extended array of x_LatN.
  logical, save                   :: FlagSLTTArcsine
                             ! ArcsineѴե륿ե饰
                             ! Flag for non-negative filter using arcsine trasformation
  character(TOKEN), save          :: SLTTIntHor
                             ! ʿˡꤹ륭
                             ! Keyword for Interpolation Method for Horizontal direction
  character(TOKEN), save          :: SLTTIntVer
                             ! ľˡꤹ륭
                             ! Keyword for Interpolation Method for Vertical direction


  character(*), parameter:: module_name = 'sltt'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: sltt.F90,v 1.8 2014/06/29 07:21:28 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine SLTTMain(             &
    & xyr_PressB, xyr_PressA,      & !(in )
    & xyz_UN, xyz_VN, xyr_SigDotN, & !(in )
    & xyzf_DQMixDtPhy,             & !(in )
    & xyzf_QMixB,                  & !(in )
    & xyzf_QMixA                   & !(out)
    & )
    ! ߥ饰󥸥ˡˤʪή׻Ԥ
    ! Calculates tracer transports by Semi-Lagrangian method


!!$    ! ɸǡ
!!$    ! Axes data settings
!!$    !
!!$    use axesset, only: &
!!$      & z_DelSigma            ! $ \Delta \sigma $ ().
!!$                              ! $ \Delta \sigma $ (Full)

    real(DP), intent(in ) :: xyr_PressB(0:imax-1, 1:jmax, 0:kmax)
                              !
                              ! Pressure at current time step
    real(DP), intent(in ) :: xyr_PressA(0:imax-1, 1:jmax, 0:kmax)
                              !
                              ! Pressure at next time step
    real(DP), intent(in ) :: xyz_UN    (0:imax-1, 1:jmax, 1:kmax)
                              ! ®
                              ! Zonal Wind
    real(DP), intent(in ) :: xyz_VN    (0:imax-1, 1:jmax, 1:kmax)
                              ! ®
                              ! Meridional Wind
    real(DP), intent(in ) :: xyr_SigDotN(0:imax-1, 1:jmax, 0:kmax)
                              ! ľή®SigmaDot
    real(DP), intent(in ):: xyzf_DQMixDtPhy(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \left(\DP{q}{t}\right)^{phy} $ . 
                              ! Ϲ (ʪ) ˤ漾Ѳ. 
                              ! Temperature tendency by external force terms (physical processes)
    real(DP), intent(in ) :: xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ʪ
                              ! Mix ratio of the tracers
    real(DP), intent(out) :: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ʪ
                              ! Mix ratio of the tracers

    ! ѿ
    ! Work variables
    !
    real(DP) :: f_QMixMax(1:ncmax)
                              ! ʪκ
                              ! Maximum of each mix ratio of the tracers
    real(DP) :: f_QMixProcMax(1:ncmax)
                              ! ʪΥץ
                              ! Maximum of each mix ratio of the tracers in each process

    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    real(DP) :: xyz_UTest    (0:imax-1, 1:jmax, 1:kmax)
                              ! ®ʥƥѡ
                              ! Zonal Wind (for test)  
    real(DP) :: xyz_VTest    (0:imax-1, 1:jmax, 1:kmax)
                              ! ®ʥƥѡ
                              ! Meridional Wind (for test) 
    real(DP) :: xyr_SigDotTest(0:imax-1, 1:jmax, 0:kmax)
                              ! ľή®ʥƥѡ;SigmaDot (for test) 
    real(DP) :: xyzf_QMixSave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)

!!$    real(DP) :: xyrf_QMixA(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
!!$
!!$    integer :: k


    ! ߥ饰󥸥ˡˤʪή׻
    ! Semi-Lagrangian method for tracer transport      
!!$!      xyzf_QMixA = xyzf_QMixB !ƥ
!!$      xyzf_QMixA = xyzf_QMixB + xyzf_DQMixDtPhy * DelTime
    xyzf_QMixA = xyzf_QMixB + xyzf_DQMixDtPhy * 2.0_DP * DelTime


    ! Save a variable for mass fixer
    xyzf_QMixSave = xyzf_QMixA


    ! Mass fixer
    !   Constituents
    !
!!$!        call MassFixer(                  &
!!$    call MassFixerColumn(                  &
!!$!          & xyr_PressA,                  & ! (in)
!!$      & xyr_PressB,                  & ! (in)
!!$      & xyzf_QMixA,                  & ! (inout)
!!$      & xyr_PressRef = xyr_PressB,   & ! (in) optional
!!$!          & xyzf_QMixRef = ( xyzf_QMixB+xyzf_DQMixDtPhy*DelTime ) & ! (in) optional
!!$!      & xyzf_QMixRef = ( xyzf_QMixB+xyzf_DQMixDtPhy*2.0_DP*DelTime ) & ! (in) optional
!!$      & xyzf_QMixRef = xyzf_QMixSave & ! (in) optional
!!$      & )
    !
!!$      call MassFixer(                   &
      call MassFixerColumn(             &
        & xyr_PressB,                   & ! (in)
        & xyzf_QMixA,                   & ! (inout)
        & xyr_PressRef = xyr_PressB,    & ! (in) optional
        & xyzf_QMixRef = xyzf_QMixSave  & ! (in) optional
        & )


    ! Save a variable for mass fixer
    xyzf_QMixSave = xyzf_QMixA


    if (FlagSLTTArcsine) then
      ! ݾڤ뤿 arcsineѴե륿
      ! Arcsine transformation for non-negative filter 

      do n = 1, ncmax
        f_QMixProcMax(n) = maxval( xyzf_QMixA(:,:,:,n) )
      end do
      call MPIWrapperFindMaxVal( &
        & ncmax, f_QMixProcMax,  & ! (in)
        & f_QMixMax              & ! (out)
        & )
      f_QMixMax = f_QMixMax * (1.05_DP) + 1.0e-14_DP
      do n = 1, ncmax
        xyzf_QMixA(:,:,:,n) = &
          & 0.5_DP*(asin(2.0_DP*xyzf_QMixA(:,:,:,n)/f_QMixMax(n) - 1.0_DP))
      end do
    end if

    xyzf_QMixA = SLTTHorAdv( xyzf_QMixA, xyz_UN, xyz_VN )           ! ʿߥ饰
                                                                    ! Horizontal

!!$    if (FlagSLTTArcsine) then
!!$      ! ݾڤ뤿 arcsineѴե륿ʵѴ
!!$      ! Arcsine transformation for non-negative filter
!!$      do n = 1, ncmax
!!$        xyzf_QMixA(:,:,:,n) = &
!!$          & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixA(:,:,:,n))+1.0_DP) 
!!$      enddo
!!$    endif
!!$
!!$
!!$    call MassFixerLayer(             &
!!$      & xyr_PressA,                  & ! (in)
!!$      & xyzf_QMixA,                  & ! (inout)
!!$!      & xyr_PressRef = xyr_PressA,   & ! (in) optional
!!$      & xyr_PressRef = xyr_PressB,   & ! (in) optional
!!$      & xyzf_QMixRef = xyzf_QMixSave & ! (in) optional
!!$      & )
!!$
!!$
!!$    ! Save a variable for mass fixer
!!$    xyzf_QMixSave = xyzf_QMixA
!!$
!!$
!!$    if (FlagSLTTArcsine) then
!!$      ! ݾڤ뤿 arcsineѴե륿
!!$      ! Arcsine transformation for non-negative filter
!!$
!!$      do n = 1, ncmax
!!$        f_QMixProcMax(n) = maxval( xyzf_QMixA(:,:,:,n) )
!!$      end do
!!$      call MPIWrapperFindMaxVal( &
!!$        & ncmax, f_QMixProcMax,  & ! (in)
!!$        & f_QMixMax              & ! (out)
!!$        & )
!!$      f_QMixMax = f_QMixMax * (1.05_DP) + 1.0e-14_DP
!!$      do n = 1, ncmax
!!$        xyzf_QMixA(:,:,:,n) = &
!!$          & 0.5_DP*(asin(2.0_DP*xyzf_QMixA(:,:,:,n)/f_QMixMax(n) - 1.0_DP))
!!$      end do
!!$    end if


    xyzf_QMixA = SLTTVerAdv( xyr_SigDotN, xyzf_QMixA )              ! ľߥ饰
                                                                    ! Vertical 

    ! Vertical advection by finite difference method
    !
!!$    do n = 1, ncmax
!!$      k = 1
!!$      xyrf_QMixA(:,:,k,n) = 1.0e100_DP
!!$      do k = 1, kmax-1
!!$        xyrf_QMixA(:,:,k,n) = &
!!$          & ( xyzf_QMixA(:,:,k,n) + xyzf_QMixA(:,:,k+1,n) ) / 2.0_DP
!!$      end do
!!$      k = kmax
!!$      xyrf_QMixA(:,:,k,n) = 1.0e100_DP
!!$    end do
!!$    do n = 1, ncmax
!!$      do k = 1, kmax
!!$        xyzf_QMixA(:,:,k,n) = xyzf_QMixA(:,:,k,n)                     &
!!$          & + (                                                       &
!!$          &     - (   xyr_SigDotN(:,:,k-1) * xyrf_QMixA(:,:,k-1,n)    &
!!$          &         - xyr_SigDotN(:,:,k  ) * xyrf_QMixA(:,:,k  ,n) )  &
!!$          &       / z_DelSigma(k)                                     &
!!$          &     + xyzf_QMixA(:,:,k,n)                                 &
!!$          &       * ( xyr_SigDotN(:,:,k-1) - xyr_SigDotN(:,:,k  ) )   &
!!$          &       / z_DelSigma(k)                                     &
!!$          &   ) * 2.0_DP * DelTime
!!$      end do
!!$    end do


    ! ήƥ
!    call SLTTTest(xyz_UTest, xyz_VTest, xyr_SigDotTest)
!    xyzf_QMixA = SLTTHorAdv( xyzf_QMixA, xyz_UTest, xyz_VTest )           ! ʿߥ饰
!    xyzf_QMixA = SLTTVerAdv( xyr_SigDotTest, xyzf_QMixA )              ! ľߥ饰

    if (FlagSLTTArcsine) then
      ! ݾڤ뤿 arcsineѴե륿ʵѴ
      ! Arcsine transformation for non-negative filter
      do n = 1, ncmax
        xyzf_QMixA(:,:,:,n) = &
          & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixA(:,:,:,n))+1.0_DP) 
      enddo
    endif


!!$!      xyzf_QMixA = xyzf_QMixB !ƥ
!!$      xyzf_QMixA = xyzf_QMixA + xyzf_DQMixDtPhy * DelTime


    ! Mass fixer
!!$    call MassFixerColumn(               &
!!$      & xyr_PressA,                     & ! (in)
!!$      & xyzf_QMixA,                     & ! (inout)
!!$!      & xyr_PressRef = xyr_PressB,  & ! (in) optional
!!$      & xyr_PressRef = xyr_PressA,      & ! (in) optional
!!$      & xyzf_QMixRef = xyzf_QMixSave    & ! (in) optional
!!$      & )
    call MassFixer(                   &
!!$    call MassFixerWO94(               &
!!$    call MassFixerR95(                &
      & xyr_PressA,                   & ! (in)
      & xyzf_QMixA,                   & ! (inout)
      & xyr_PressRef = xyr_PressB,    & ! (in) optional
      & xyzf_QMixRef = xyzf_QMixSave  & ! (in) optional
      & )


  end subroutine SLTTMain

  !----------------------------------------------------------------------------

  function SLTTHorAdv( xyzf_QMix, xyz_U, xyz_V ) result( xyzf_QMixA )
    ! ߥ饰󥸥ˡˤʿήη׻
    ! Calculates tracer transports by Semi-Lagrangian method for horizontal direction

    use timeset    , only : DelTime
                              ! $\Delta t$
    use axesset    , only : x_Lon, y_Lat
                              ! $\lambda, \varphai$ lon and lat
    use sltt_const , only : dtjw, iexmin, iexmax, jexmins, jexmaxs, jexminn, jexmaxn
    use sltt_extarr, only : SLTTExtArrExt, SLTTExtArrExt2
                              ! ĥ롼
                              ! Expansion of arrays
    use sltt_dp    , only : SLTTDPHor
                              ! ʿήõ
                              ! Finding departure point in horizontal
    use sltt_lagint, only : SLTTIrrHerIntK13
                              ! ʿ
                              ! 2D Interpolation in horizontal 

    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
#ifdef LIB_MPI
#ifdef SJPACK
    use wa_mpi_module_sjpack, only:              &
      & wa_xya            => wa_xva,             &
      & xya_wa            => xva_wa, &
      & wa_DLon_wa, &
      & xya_GradLat_wa => xva_GradLat_wa
#else
    use wa_mpi_module, only:                     &
      & wa_xya            => wa_xva,             &
      & xya_wa            => xva_wa, &
      & wa_DLon_wa, &
      & xya_GradLat_wa => xva_GradLat_wa
#endif
#elif AXISYMMETRY
    use wa_zonal_module, only:   &
      & wa_xya, xya_wa, &
      & wa_DLon_wa, xya_GradLat_wa
#elif SJPACK
    use wa_module_sjpack, only:   &
      & wa_xya, xya_wa, &
      & wa_DLon_wa, xya_GradLat_wa 
#elif AXISYMMETRY_SJPACK
    use wa_zonal_module_sjpack, only:   &
      & wa_xya, xya_wa, &
      & wa_DLon_wa, xya_GradLat_wa
#else
    use wa_module, only:   &
      & wa_xya, xya_wa , &
      & wa_DLon_wa, xya_GradLat_wa
#endif


    real(DP), intent(in ) :: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ߻ʪ
                              ! Present mix ratio of the tracers
    real(DP), intent(in ) :: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
                              ! ®
                              ! Zonal Wind    
    real(DP), intent(in ) :: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
                              ! ®
                              ! Meridional Wind    

    real(DP) :: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ƥåפʪ
                              ! Next mix ratio of the tracers
    !
    ! local variables
    !
    real(DP) :: xyzf_ExtQMixS(iexmin:iexmax, jexmins:jexmaxs, 1:kmax, 1:ncmax)
                              ! ߻ʪγĥȾ
                              ! Extended array (SH) of present mix ratio of the tracers.
    real(DP) :: xyzf_ExtQMixN(iexmin:iexmax, jexminn:jexmaxn, 1:kmax, 1:ncmax)
                              ! ߻ʪγĥȾ
                              ! Extended array (NH) of present mix ratio of the tracers.
    real(DP) :: xyz_ExtUS    (iexmin:iexmax, jexmins:jexmaxs, 1:kmax)
                              ! ®γĥȾ
                              ! Extended array (SH) of Zonal Wind        
    real(DP) :: xyz_ExtUN    (iexmin:iexmax, jexminn:jexmaxn, 1:kmax)
                              ! ®γĥȾ
                              ! Extended array (NH) of Zonal Wind        
    real(DP) :: xyz_ExtVS    (iexmin:iexmax, jexmins:jexmaxs, 1:kmax)
                              ! ®γĥȾ
                              ! Extended array (SH) of Meridional Wind
    real(DP) :: xyz_ExtVN    (iexmin:iexmax, jexminn:jexmaxn, 1:kmax)
                              ! ®γĥȾ
                              ! Extended array (NH) of Meridional Wind

    integer:: i, ii           ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in zonal direction
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in meridional direction
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    real(DP) :: xyz_DPLonS(0:imax-1, 1:jmax/2, 1:kmax)
                              ! ή١Ⱦ
                              ! Lon of the departure point (SH)
    real(DP) :: xyz_DPLonN(0:imax-1, 1:jmax/2, 1:kmax)
                              ! ή١Ⱦ
                              ! Lon of the departure point (NH)    
    real(DP) :: xyz_DPLatS(0:imax-1, 1:jmax/2, 1:kmax)
                              ! ή١Ⱦ
                              ! Lat of the departure point (SH)    
    real(DP) :: xyz_DPLatN(0:imax-1, 1:jmax/2, 1:kmax)
                              ! ή١Ⱦ
                              ! Lat of the departure point (NH)    

    real(DP) :: xyzf_QMixAS(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
                              ! ƥåפʪȾ
                              ! Next mix ratio of the tracers (SH)
    real(DP) :: xyzf_QMixAN(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
                              ! ƥåפʪȾ
                              ! Next mix ratio of the tracers (NH)

!---fx, fy, fxy
    real(DP) :: xyzf_QMix_dlon(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ʪηʬʥåɡ
                              ! Zonal derivative of the mix ratio (on grid)
    real(DP) :: xyzf_QMix_dlat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ʪΰʬʥåɡ
                              ! Meridional derivative of the mix ratio (on grid)
    real(DP) :: xyzf_QMix_dlonlat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ʪΰٷʬʥåɡ
                              ! Zonal and meridional derivative of the mix ratio (on grid)    
    real(DP) :: xyzf_ExtQMixS_dlon(iexmin:iexmax, jexmins:jexmaxs, 1:kmax, 1:ncmax)
                              ! ʪηʬγĥȾ
                              ! Extended array (SH) of zonal derivative of the mix ratio
    real(DP) :: xyzf_ExtQMixN_dlon(iexmin:iexmax, jexminn:jexmaxn, 1:kmax, 1:ncmax)
                              ! ʪηʬγĥȾ
                              ! Extended array (NH) of zonal derivative of the mix ratio
    real(DP) :: xyzf_ExtQMixS_dlat(iexmin:iexmax, jexmins:jexmaxs, 1:kmax, 1:ncmax)
                              ! ʪΰʬγĥȾ
                              ! Extended array (SH) of meridional derivative of the mix ratio
    real(DP) :: xyzf_ExtQMixN_dlat(iexmin:iexmax, jexminn:jexmaxn, 1:kmax, 1:ncmax)                              
                              ! ʪΰʬγĥȾ
                              ! Extended array (NH) of meridional derivative of the mix ratio
    real(DP) :: xyzf_ExtQMixS_dlonlat(iexmin:iexmax, jexmins:jexmaxs, 1:kmax, 1:ncmax)
                              ! ʪΰٷʬγĥȾ
                              ! Extended array (SH) of zonal and meridional derivative of the mix ratio
    real(DP) :: xyzf_ExtQMixN_dlonlat(iexmin:iexmax, jexminn:jexmaxn, 1:kmax, 1:ncmax)
                              ! ʪΰٷʬγĥȾ
                              ! Extended array (NH) of zonal and meridional derivative of the mix ratio
    real(DP) :: wzf_QMix(1:lmax, 1:kmax, 1:ncmax)
                              ! ʪηʬʥڥȥ
                              ! Zonal derivative of the mix ratio (on grid)    
    real(DP) :: wzf_QMix_dlon(1:lmax, 1:kmax, 1:ncmax)        
                              ! ʪηʬʥڥȥ
                              ! Zonal derivative of the mix ratio (on grid)
    real(DP) :: pm            ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                              ! Sign change flag for array extension; -1.0 for sign change over the pole, 1.0 for no sign change

!---fxx, fyy, fxxyy
!    real(DP) :: xyzf_QMix_dlon2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_QMix_dlat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_QMix_dlon2lat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixS_dlon2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixN_dlon2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixS_dlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixN_dlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixS_dlon2lat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixN_dlon2lat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!----fxxy
!    real(DP) :: xyzf_QMix_dlon2lat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixS_dlon2lat(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixN_dlon2lat(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!----fxyy
!    real(DP) :: xyzf_QMix_dlonlat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixS_dlonlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!    real(DP) :: xyzf_ExtQMixN_dlonlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
!----
!    real(DP) :: wzf_QMix_dlon2(1:lmax, 1:kmax, 1:ncmax)        



    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. sltt_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! QMixʬ׻ʥڥȥѴѡ
    ! Derivatives of QMix
    do n = 1, ncmax
        wzf_QMix(:,:,n) = wa_xya(xyzf_QMix(:,:,:,n))                     ! åɢڥȥ
                                                                         ! grid -> spectrum
        xyzf_QMix_dlat(:,:,:,n) = xya_GradLat_wa(wzf_QMix(:,:,n))        ! ڥȥ뢪åɰʬ
                                                                         ! spectrum -> grid (dQ/dlat)
        wzf_QMix_dlon(:,:,n) = wa_Dlon_wa(wzf_QMix(:,:,n))               ! ڥȥ뢪ڥȥʬ
                                                                         ! spectrum -> spectrum (dQ/dlon)        
        xyzf_QMix_dlon(:,:,:,n) = xya_wa(wzf_QMix_dlon(:,:,n))           ! ڥȥʬåɷʬ
                                                                         ! spectrum (dQ/dlon) -> grid (dQ/dlon)
        xyzf_QMix_dlonlat(:,:,:,n) = xya_GradLat_wa(wzf_QMix_dlon(:,:,n))! ڥȥʬåɰٷʬ
                                                                         ! spectrum (dQ/dlon) -> grid (d^2Q/dlon dlat)        

        !---fxx, fyy, fxxy, fxyy, fxxyy ׻
        !xyzf_QMix_dlon2(:,:,:,n) = xya_wa(wa_Dlon_wa(wzf_QMix_dlon(:,:,n)))
        !xyzf_QMix_dlat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlat(:,:,:,n)))
        !xyzf_QMix_dlon2lat(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlon2(:,:,:,n)))
        !xyzf_QMix_dlonlat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlonlat(:,:,:,n)))
        !xyzf_QMix_dlon2lat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlon2lat(:,:,:,n)))
    enddo


    ! ʬȳĥ
    ! Division and extension of arrays
    !
    ! ʬȳĥ
    ! Division and extension of arrays

    pm = -1.0_DP ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                 ! -1.0 if the sign of value changes over the poles; if not 1.0. 
!!$    call SLTTExtArrExt2(                             &
!!$      & xyzf_QMix_dlon,  pm,                         & ! (in)
!!$      & xyzf_ExtQMixS_dlon, xyzf_ExtQMixN_dlon       & ! (out)
!!$      & )
    call SLTTExtArrExt2(                            &
      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
      & xyzf_QMix_dlon,  pm,                        & ! (in)
      & xyzf_ExtQMixS_dlon, xyzf_ExtQMixN_dlon,     & ! (out)
      & "Wave1"                                     & ! (in)
      & )

    pm = -1.0_DP ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                 ! -1.0 if the sign of value changes over the poles; if not 1.0.
!!$    call SLTTExtArrExt2(                             &
!!$      & xyzf_QMix_dlat,  pm,                         & ! (in)
!!$      & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat       & ! (out)
!!$      & )
    call SLTTExtArrExt2(                            &
      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
      & xyzf_QMix_dlat,  pm,                        & ! (in)
      & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat,     & ! (out)
      & "Wave1"                                     & ! (in)
      & )

    pm = +1.0_DP ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                 ! -1.0 if the sign of value changes over the poles; if not 1.0.
!!$    call SLTTExtArrExt2(                             &
!!$      & xyzf_QMix_dlonlat, pm,                       & ! (in)
!!$      & xyzf_ExtQMixS_dlonlat, xyzf_ExtQMixN_dlonlat & ! (out)
!!$      & )
    call SLTTExtArrExt2(                              &
      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN,   & ! (in)
      & xyzf_QMix_dlonlat, pm,                        & ! (in)
      & xyzf_ExtQMixS_dlonlat, xyzf_ExtQMixN_dlonlat, & ! (out)
      & "Wave1"                                       & ! (in)
      & )

!-----fxx, fyy, fxxy, fxyy, fxxyy ĥ
!    pm = +1.0_DP ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                  ! -1.0 if the sign of value changes over the poles; if not 1.0. 
!    call SLTTExtArrExt2(                             &
!      & xyzf_QMix_dlon2,  pm,                        & ! (in)
!      & xyzf_ExtQMixS_dlon2, xyzf_ExtQMixN_dlon2     & ! (out)
!      & )
!    pm = +1.0_DP ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                  ! -1.0 if the sign of value changes over the poles; if not 1.0. 
!    call SLTTExtArrExt2(                             &
!      & xyzf_QMix_dlat2,  pm,                        & ! (in)
!      & xyzf_ExtQMixS_dlat2, xyzf_ExtQMixN_dlat2     & ! (out)
!      & )      
!    pm = -1.0_DP ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                  ! -1.0 if the sign of value changes over the poles; if not 1.0. 
!    call SLTTExtArrExt2(                               &
!      & xyzf_QMix_dlon2lat,  pm,                       & ! (in)
!      & xyzf_ExtQMixS_dlon2lat, xyzf_ExtQMixN_dlon2lat & ! (out)
!      & )      
!    pm = -1.0_DP ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                  ! -1.0 if the sign of value changes over the poles; if not 1.0. 
!    call SLTTExtArrExt2(                               &
!      & xyzf_QMix_dlonlat2,  pm,                       & ! (in)
!      & xyzf_ExtQMixS_dlonlat2, xyzf_ExtQMixN_dlonlat2 & ! (out)
!      & )
!    pm = +1.0_DP ! ĥݡˤ椬Ѥ -1.0Ϳ롣Ǥʤ1.0Ϳ롣
                  ! -1.0 if the sign of value changes over the poles; if not 1.0. 
!    call SLTTExtArrExt2(                                 &
!      & xyzf_QMix_dlon2lat2,  pm,                        & ! (in)
!      & xyzf_ExtQMixS_dlon2lat2, xyzf_ExtQMixN_dlon2lat2 & ! (out)
!      & )


!!$    call SLTTExtArrExt(                             &
!!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
!!$      & xyzf_QMix, xyz_U, xyz_V,                    & ! (in)
!!$      & xyzf_ExtQMixS, xyzf_ExtQMixN,               & ! (out)
!!$      & xyz_ExtUS, xyz_ExtUN,                       & ! (out)
!!$      & xyz_ExtVS, xyz_ExtVN                        & ! (out)
!!$      & )
    call SLTTExtArrExt(                             &
      & y_ExtLatS, y_ExtLatN,                       & ! (in)
      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
      & xyzf_QMix, xyz_U, xyz_V,                    & ! (in)
!      & xyzf_ExtDQMixDLatS, xyzf_ExtDQMixDLatN,     & ! (in)
      & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat,     & ! (in)
      & xyzf_ExtQMixS, xyzf_ExtQMixN,               & ! (out)
      & xyz_ExtUS, xyz_ExtUN,                       & ! (out)
      & xyz_ExtVS, xyz_ExtVN                        & ! (out)
      & )



    ! ήη׻
    ! estimation of departure point
    ! Ⱦ
    ! south array
    call SLTTDPHor(                                     &
      & DelTime, x_LonS, y_LatS, y_SinLatS, y_CosLatS,  & ! (in)
      & iexmin, iexmax, jexmins, jexmaxs,               & ! (in)
      & x_ExtLonS, y_ExtLatS, xyz_ExtUS, xyz_ExtVS,     & ! (in)
      & xyz_DPLonS, xyz_DPLatS                          & ! (out)
      & )
    ! Ⱦ
    ! north array
    call SLTTDPHor(                                     &
      & DelTime, x_LonN, y_LatN, y_SinLatN, y_CosLatN,  & ! (in)
      & iexmin, iexmax, jexminn, jexmaxn,               & ! (in)
      & x_ExtLonN, y_ExtLatN, xyz_ExtUN, xyz_ExtVN,     & ! (in)
      & xyz_DPLonN, xyz_DPLatN                          & ! (out)
      & )



    ! 
    ! Interpolation
!    do n = 1, ncmax
    call SLTTIrrHerIntK13(                                                &
      & iexmin, iexmax, jexmins, jexmaxs,                                   & ! (in)
       & x_ExtLonS, y_ExtLatS, xyz_DPLonS, xyz_DPLatS,                      & ! (in)
       & xyzf_ExtQMixS(:,:,:,:), xyzf_ExtQMixS_dlon(:,:,:,:),               & ! (in)
       & xyzf_ExtQMixS_dlat(:,:,:,:), xyzf_ExtQMixS_dlonlat(:,:,:,:),       & ! (in)
!      & xyzf_ExtQMixS_dlon2(:,:,:,n), xyzf_ExtQMixS_dlat2(:,:,:,n),        & ! (in) fxx, fyy
!      & xyzf_ExtQMixS_dlon2lat(:,:,:,n), xyzf_ExtQMixS_dlonlat2(:,:,:,n),  & ! (in) fxxy, fxyy
!      & xyzf_ExtQMixS_dlon2lat2(:,:,:,n),                                  & ! (in) fxxyy 
       & SLTTIntHor,                                                        & ! (in)       
       & xyzf_QMixAS(:,:,:,:)                                               & ! (out)
       & )

    call SLTTIrrHerIntK13(                                                &
      & iexmin, iexmax, jexminn, jexmaxn,                                   & ! (in)
       & x_ExtLonN, y_ExtLatN, xyz_DPLonN, xyz_DPLatN,                      & ! (in)
       & xyzf_ExtQMixN(:,:,:,:), xyzf_ExtQMixN_dlon(:,:,:,:),               & ! (in)
       & xyzf_ExtQMixN_dlat(:,:,:,:), xyzf_ExtQMixN_dlonlat(:,:,:,:),       & ! (in)
!      & xyzf_ExtQMixN_dlon2(:,:,:,n), xyzf_ExtQMixN_dlat2(:,:,:,n),        & ! (in) fxx, fyy
!      & xyzf_ExtQMixN_dlon2lat(:,:,:,n), xyzf_ExtQMixN_dlonlat2(:,:,:,n),  & ! (in) fxxy, fxyy
!      & xyzf_ExtQMixN_dlon2lat2(:,:,:,n),                                  & ! (in) fxxyy
       & SLTTIntHor,                                                        & ! (in) 
       & xyzf_QMixAN(:,:,:,:)                                               & ! (out)
       & )
!    enddo

    ! Ⱦη
    ! joint of each array
     xyzf_QMixA(:,1:jmax/2,:,:) = xyzf_QMixAS(:,1:jmax/2,:,:)
     xyzf_QMixA(:,jmax/2+1:jmax,:,:) = xyzf_QMixAN(:,1:jmax/2,:,:)


  end function SLTTHorAdv

  !--------------------------------------------------------------------------------------

  function SLTTVerAdv( xyr_SigmaDot, xyzf_QMix ) result( xyzf_QMixA )
    ! ߥ饰󥸥ˡˤľήη׻
    ! Calculates tracer transports by Semi-Lagrangian method for vertical direction

    use axesset, only : z_Sigma           ! ľɸ; Sigma coordinate
    use timeset, only : DelTime           ! $\Delta t$
    use sltt_dp, only : SLTTDPVer         ! ľήõ; Finding departure point in vertical 
    use sltt_lagint, only : & 
      & SLTTIrrHerIntQui1DNonUni, &       ! ֳֳʻҤθ޼; Quintic Interpolation for non-uniform grids
      & SLTTHerIntCub1D                                  

    real(DP), intent(in) :: xyr_SigmaDot(0:imax-1, 1:jmax, 0:kmax)
                              ! ľή®SigmaDot
    real(DP), intent(in) :: xyzf_QMix   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ߻ʪ
                              ! Present mix ratio of the tracers
    real(DP)             :: xyzf_QMixA  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ƥåפʪ
                              ! Next mix ratio of the tracers    

    !
    ! local variables
    !
    real(DP) :: xyz_DPSigma(0:imax-1, 1:jmax, 1:kmax)
                              ! ή
                              ! Sigma of the departure point
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in zonal direction
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in meridional direction
    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents
    integer:: xy_kk(0:imax-1, 1:jmax)
                              ! ήξ岼Υåɤõ뤿κѿ
                              ! Work variable for finding the grid just above the departure point
                              
    
    real(DP) :: xyzf_QMix_dz(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! ʪαľʬ
                              ! Vertical derivative of the mix ratio    
    real(DP) :: xyzf_ExtQMix(0:imax-1, 1:jmax, 1-2:kmax+2, 1:ncmax)
                              ! ʪγĥ
                              ! Extended array of the mix ratio    
    real(DP) :: z_ExtSigma(1-2:kmax+2)
                              ! Һɸγĥ
                              ! Extended array of the sigma coordinate            
    real(DP) :: xyf_F11(0:imax-1, 1:jmax, 1:ncmax)
                              ! ʬ׻Ѥѿ
                              ! work variable for the derivative calculation
    real(DP) :: xyf_F22(0:imax-1, 1:jmax, 1:ncmax)
                              ! ʬ׻Ѥѿ
                              ! work variable for the derivative calculation
    real(DP) :: xyf_F12(0:imax-1, 1:jmax, 1:ncmax)
                              ! ʬ׻Ѥѿ
                              ! work variable for the derivative calculation
    real(DP) :: xyf_F21(0:imax-1, 1:jmax, 1:ncmax)
                              ! ʬ׻Ѥѿ
                              ! work variable for the derivative calculation
    real(DP) :: s1, t1, s2, t2, r1, r2
                              ! ʬ׻Ѥѿ
                              ! work variable for the derivative calculation
    





    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. sltt_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! ήõ
    ! estimation of departure point
    !
    call SLTTDPVer(            &
      & DelTime, xyr_SigmaDot, & ! (in )
      & xyz_DPSigma            & ! (out)
      & )

     
     ! ĥz_Sigma
     ! Array extension for z_Sigma
     z_ExtSigma(-1) = 2.0_DP - z_Sigma(2)
     z_ExtSigma(0) = 2.0_DP - z_Sigma(1)     
     z_ExtSigma(1:kmax) = z_Sigma(1:kmax)
     z_ExtSigma(kmax+1) = -z_Sigma(kmax)     
     z_ExtSigma(kmax+2) = -z_Sigma(kmax-1)     
          
     ! ĥxyzf_QMix
     ! Array extension for Q_Mix
     xyzf_ExtQMix(:,:,-1,:) = xyzf_QMix(:,:,2,:)
     xyzf_ExtQMix(:,:,0,:) = xyzf_QMix(:,:,1,:)
     xyzf_ExtQMix(:,:,1:kmax,:) = xyzf_QMix(:,:,1:kmax,:)
     xyzf_ExtQMix(:,:,kmax+1,:) = xyzf_QMix(:,:,kmax,:)
     xyzf_ExtQMix(:,:,kmax+2,:) = xyzf_QMix(:,:,kmax-1,:)

     ! xyzf_QMix_dzʬˤ 
     ! calculate xyzf_QMix_dz
     do k = 1 , kmax
        s1 = z_ExtSigma(k) - z_ExtSigma(k-1)
        t1 = z_ExtSigma(k+1) - z_ExtSigma(k)
        s2 = z_ExtSigma(k) - z_ExtSigma(k-2)
        t2 = z_ExtSigma(k+2) - z_ExtSigma(k)
        
        if (s1 == t1 .and. s2 == t2 .and. s1 + s1 == s2) then 
          ! ʻҤֳ֤ξ
          ! Uniform depth
          ! 4
          ! 4th order

          xyzf_QMix_dz(:,:,k,:) = ( 8.0_DP*( xyzf_ExtQMix(:,:,k+1,:) - xyzf_ExtQMix(:,:,k-1,:)) &
          &                         - ( xyzf_ExtQMix(:,:,k+2,:) - xyzf_ExtQMix(:,:,k-2,:) ) )/12.0_DP
        else
          ! ʻҤֳ֤ξ
          ! Non-uniform depth
          xyf_F11 = (s1*s1*xyzf_ExtQMix(:,:,k+1,:) +(t1*t1 - s1*s1)*xyzf_ExtQMix(:,:,k,:) - t1*t1*xyzf_ExtQMix(:,:,k-1,:))&
          &         /(s1*t1*(s1+t1))
          xyf_F22 = (s2*s2*xyzf_ExtQMix(:,:,k+2,:) +(t2*t2 - s2*s2)*xyzf_ExtQMix(:,:,k,:) - t2*t2*xyzf_ExtQMix(:,:,k-2,:))&
          &         /(s2*t2*(s2+t2))
          xyf_F21 = (s2*s2*xyzf_ExtQMix(:,:,k+1,:) +(t1*t1 - s2*s2)*xyzf_ExtQMix(:,:,k,:) - t1*t1*xyzf_ExtQMix(:,:,k-2,:))&
          &         /(s2*t1*(s2+t1))
          xyf_F12 = (s1*s1*xyzf_ExtQMix(:,:,k+2,:) +(t2*t2 - s1*s1)*xyzf_ExtQMix(:,:,k,:) - t2*t2*xyzf_ExtQMix(:,:,k-1,:))&
          &         /(s1*t2*(s1+t2))
          
          r1 = t1 - s1 - t2 + s2
          r2 = t1 - s2 - t2 + s1
          !
          ! 4th order
          xyzf_QMix_dz(:,:,k,:) = ( (xyf_F11*s2*t2 - xyf_F22*s1*t1)*r2 - (xyf_F21*s1*t2 - xyf_F12*s2*t1)*r1 ) &
          &                       / ( (s2*t2-s1*t1)*r2 - (s1*t2-s2*t1)*r1 )
  
          !3
          ! 3rd order
  !        xyzf_QMix_dz(:,:,k,:) = (xyf_F11*s2*t2 - xyf_F22(:,:,:)*s1*t1)/(s2*t2 - s1*t1) 
          
          !2
          ! 2nd order
  !        xyzf_QMix_dz(:,:,k,:) = xyf_F11
        endif





    enddo


    xy_kk = 2
    do k = 1, kmax
    do j = 1, jmax
    do i = 0, imax-1
        if ( xyz_DPSigma(i,j,k) >= z_Sigma(1) ) then     ! DP z_Sigma(1)  ɽ(sigma = 1.0)δ֤ξ
                                                         ! if DP is between z_Sigma(1) and the ground (sigma = 1.0)
            xyzf_QMixA(i,j,k,:) = xyzf_QMix(i,j,1,:)     ! Q_1ǰȤ롣
                                                         ! use Q_1 for interpolated value
                                                                 
        elseif (xyz_DPSigma(i,j,k) <= z_Sigma(kmax)) then! DP z_Sigma(kmax)  絤ü(sigma = 0.0)δ
                                                         ! if DP is between z_Sigma(kmax) and the upper boundary (sigma = 0.0)        
            xyzf_QMixA(i,j,k,:) = xyzf_QMix(i,j,kmax,:)  ! Q_kmaxǰȤ롣
                                                         ! use Q_kmax for interpolated value            
        else
            do kk = xy_kk(i,j), kmax 
                if ( xyz_DPSigma(i,j,k) > z_Sigma(kk) ) then 
                  select case (SLTTIntVer)
                    case("HQ")    ! §ߡȣ; Irregular Hermite Quintic interpolation
                      do n = 1, ncmax 
                          xyzf_QMixA(i,j,k,n) = SLTTIrrHerIntQui1DNonUni(xyzf_ExtQMix(i,j,kk-2,n), xyzf_ExtQMix(i,j,kk-1,n), & 
                          &                               xyzf_ExtQMix(i,j,kk,n),   xyzf_ExtQMix(i,j,kk+1,n), & 
                          &                               xyzf_QMix_dz(i,j,kk-1,n), xyzf_QMix_dz(i,j,kk,n),   &
                          &                               z_ExtSigma(kk-2)-z_ExtSigma(kk-1), z_ExtSigma(kk)-z_ExtSigma(kk-1), & 
                          &                               z_ExtSigma(kk+1)-z_ExtSigma(kk-1), xyz_DPSigma(i,j,k)-z_ExtSigma(kk-1))
                      enddo

                    case("HC")    ! ߡȣ; Hermitian Cubic interpolation
                      do n = 1, ncmax 
                          xyzf_QMixA(i,j,k,n) = SLTTHerIntCub1D( xyzf_ExtQMix(i,j,kk-1,n), xyzf_ExtQMix(i,j,kk,n),&
                          &                                      xyzf_QMix_dz(i,j,kk-1,n), xyzf_QMix_dz(i,j,kk,n),&
                          &                                      z_ExtSigma(kk)-z_ExtSigma(kk-1),                 &
                          &                                      xyz_DPSigma(i,j,k)-z_ExtSigma(kk-1))
                      enddo

                    case default
                      write( 6, * ) "ERROR : GIVE CORRECT KEYWORD FOR <SLTTIntVer> IN NAMELIST"
                      stop
                  end select
                    xy_kk(i,j) = kk
                    exit    
                endif
            enddo 
        endif
    enddo
    enddo
    enddo

  end function SLTTVerAdv

  !-------------------------------------------------

  subroutine SLTTInit
    ! ߥ饰󥸥ˡν
    ! Initialization for Semi-Lagrangian method


    use axesset, only : x_Lon, y_Lat


    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ).
                              ! Half $ \sigma $ level
      & z_Sigma               ! $ \sigma $ ٥ ().
                              ! Full $ \sigma $ level

    use sltt_const , only : SLTTConstInit
    use sltt_extarr, only : SLTTExtArrInit


    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: &
      & STDOUT, &             ! ɸϤֹ. Unit number of standard output
      & STRING                ! ʸ.       Strings. 
    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    use sltt_const , only : iexmin, iexmax, jexmins, jexmaxs, jexminn, jexmaxn

    !
    ! local variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in zonal direction
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in meridional direction
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /sltt_nml/                                        &
      & FlagSLTTArcsine, SLTTIntHor, SLTTIntVer

    ! ¹ʸ ; Executable statement
    !

    if ( sltt_inited ) return

    if ( mod( jmax, 2 ) /= 0 ) then
      stop 'jmax cannot be divided by 2.'
    end if

    call SLTTConstInit


    ! ǥեͤ
    ! Default values settings
    !
    FlagSLTTArcsine             = .true.
    SLTTIntHor                  = "HQ"
    SLTTIntVer                  = "HQ"


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = sltt_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = sltt_nml )
    end if



    allocate( x_LonS   (0:imax-1) )
    allocate( x_SinLonS(0:imax-1) )
    allocate( x_CosLonS(0:imax-1) )
    allocate( y_latS   (1:jmax/2) )
    allocate( y_SinLatS(1:jmax/2) )
    allocate( y_CosLatS(1:jmax/2) )
    do i = 0, imax-1
      x_LonS   (i) = x_Lon(i)
      x_SinLonS(i) = sin( x_LonS(i) )
      x_CosLonS(i) = cos( x_LonS(i) )
    end do
    do j = 1, jmax/2
      y_LatS   (j) = y_Lat(j)
      y_SinLatS(j) = sin( y_LatS(j) )
      y_CosLatS(j) = cos( y_LatS(j) )
    end do

    allocate( x_LonN   (0:imax-1) )
    allocate( x_SinLonN(0:imax-1) )
    allocate( x_CosLonN(0:imax-1) )
    allocate( y_latN   (1:jmax/2) )
    allocate( y_SinLatN(1:jmax/2) )
    allocate( y_CosLatN(1:jmax/2) )
    do i = 0, imax-1
      x_LonN   (i) = x_Lon(i)
      x_SinLonN(i) = sin( x_LonN(i) )
      x_CosLonN(i) = cos( x_LonN(i) )
    end do
    do j = 1, jmax/2
      y_LatN   (j) = y_Lat(j+jmax/2)
      y_SinLatN(j) = sin( y_LatN(j) )
      y_CosLatN(j) = cos( y_LatN(j) )
    end do

    allocate( x_ExtLonS( iexmin:iexmax ) )
    allocate( x_ExtLonN( iexmin:iexmax ) )

    allocate( y_ExtLatS( jexmins:jexmaxs ) )
    allocate( y_ExtLatN( jexminn:jexmaxn ) )


    call SLTTExtArrInit(                            &
      & x_LonS, y_LatS, x_LonN, y_LatN,             & ! (in )
      & x_ExtLonS, y_ExtLatS, x_ExtLonN, y_ExtLatN  & ! (out)
      & )


    sltt_inited = .true.

  end subroutine SLTTInit

  !--------------------------------------------------------------------------------------
  
  subroutine SLTTTest(&
    & xyz_UTest, xyz_VTest, xyr_SigDotTest &! (out)
    &)
    !-------ߥ饰ΥƥѤή®ʬۤͿ--------
    !Gives a velocity for Test. Only used for debug.
    
    
    use constants0, only : PI
    use axesset   , only : x_Lon, y_Lat, r_Sigma
    use constants, only: RPlanet 
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN                 ! ƥå $ t $ λ. Time of step $ t $. 

    real(DP), intent(out) :: xyz_UTest    (0:imax-1, 1:jmax, 1:kmax)
                              ! ®
                              ! Zonal Wind    
    real(DP), intent(out) :: xyz_VTest    (0:imax-1, 1:jmax, 1:kmax)
                              ! ®
                              ! Meridional Wind    
    real(DP), intent(out) :: xyr_SigDotTest(0:imax-1, 1:jmax, 0:kmax)
                              ! ľή®SigmaDot

    ! ѿ
    ! Work variables
    !
    real(DP) :: u0, t, shape
    real(DP), parameter :: lat0 = 0.5_8*PI, lon0 = 0.0_8*PI
    real(DP), parameter :: tau = 345600.0_DP, p0 = 100000.0_DP
    real(DP), parameter :: omega0 = PI*30000.0_DP/tau

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in zonal direction
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in meridional direction
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction



    ! ʿή®ʬۤͿ
    u0 = 2.0_DP*PI*RPlanet/(86400.0_DP*12.0_DP)
    do k = 1, kmax
      do j=1, jmax
        do i=0, imax-1
          xyz_UTest(i,j,k) = u0*(cos(y_Lat(j)) * cos(lat0) + cos(x_Lon(i)) * sin(y_Lat(j)) * sin(lat0))
          xyz_VTest(i,j,k) = -u0*(sin(x_Lon(i))*sin(lat0))
        end do
      end do
    end do
    !ľή®ʬۤͿ
    t = TimeN
    do k = 0, kmax
      shape = min(1.0_DP, 0.5_DP*(sin((r_Sigma(k)-r_Sigma(kmax))/(1.0_DP - r_Sigma(kmax))*PI)) )
        do j = 1, jmax
          do i = 0, imax-1
            xyr_SigDotTest(i,j,k) = -omega0/p0*cos(2.0_DP*PI/tau*t)*sin(shape*PI*0.5_DP)
          enddo
        enddo
    enddo

    end subroutine SLTTTest


end module sltt
