!= ȳɹˤ륢٥Ѳ
!
!= modification of surface albedo on the snow covered ground and on the sea ice
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: modify_albedo_snowseaice.f90,v 1.5 2013-11-17 03:13:49 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module modify_albedo_snowseaice

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING     ! ʸ.       Strings.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: ModAlbedoDueToSnowSeaIce
  public :: ModAlbedoSnowSeaIceInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: modify_albedo_snowseaice_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  character(*), parameter:: module_name = 'modify_albedo_snowseaice'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: modify_albedo_snowseaice.f90,v 1.5 2013-11-17 03:13:49 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine ModAlbedoDueToSnowSeaIce(                &
    & xy_SurfType,                                    &
    & xy_SurfMajCompIce, xy_SurfSnow, xy_SeaIceConc,  & ! (in   ) optional
    & xy_SurfAlbedo                                   & ! (inout)
    )

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: y_Lat

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only:            &
      & SnowThreshold => ThresholdSurfSnow,    &
      & SnowAlbedo,                            &
      & SeaIceThreshold,                       &
      & SeaIceAlbedo,                          &
      & CO2IceThreshold,                       &
      & CO2IceAlbedoS,                         &
      & CO2IceAlbedoN


    integer , intent(in   )           :: xy_SurfType      ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ), optional :: xy_SurfMajCompIce( 0:imax-1, 1:jmax )
    real(DP), intent(in   ), optional :: xy_SurfSnow      ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ), optional :: xy_SeaIceConc    ( 0:imax-1, 1:jmax )
    real(DP), intent(inout)           :: xy_SurfAlbedo    ( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    real(DP):: MajCompIceThreshold
    real(DP):: MajCompIceAlbedo
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ǧ
    ! Initialization check
    !
    if ( .not. modify_albedo_snowseaice_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if



    if ( present( xy_SurfMajCompIce ) ) then
      ! modify surface albedo on the major component ice covered ground
      !
      MajCompIceThreshold = CO2IceThreshold
      do j = 1, jmax
        if ( y_Lat(j) < 0.0_DP ) then
          MajCompIceAlbedo = CO2IceAlbedoS
        else
          MajCompIceAlbedo = CO2IceAlbedoN
        end if
        do i = 0, imax-1

!!$          if ( xy_SurfCond(i,j) > 0 .and. xy_SurfMajCompIce(i,j) > MajCompIceThreshold ) then
!!$            xy_SurfAlbedo(i,j) = MajCompIceAlbedo
!!$          end if

          if ( xy_SurfType(i,j) > 0 ) then
            if ( xy_SurfMajCompIce(i,j) > MajCompIceThreshold ) then
              xy_SurfAlbedo(i,j) = MajCompIceAlbedo
            else if ( xy_SurfMajCompIce(i,j) < 0.0_DP ) then
              xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
            else
              xy_SurfAlbedo(i,j) =                                                  &
                & ( MajCompIceAlbedo - xy_SurfAlbedo(i,j) ) / ( MajCompIceThreshold - 0.0_DP )  &
                & * ( xy_SurfMajCompIce(i,j) - 0.0_DP )                                   &
                & + xy_SurfAlbedo(i,j)
            end if
          end if

        end do
      end do

    end if


    if ( present( xy_SurfSnow ) ) then
      ! modify surface albedo on the snow covered ground
      !
      do j = 1, jmax
        do i = 0, imax-1

!!$          if ( xy_SurfType(i,j) > 0 .and. xy_SurfSnow(i,j) > SnowThreshold ) then
!!$            xy_SurfAlbedo(i,j) = SnowAlbedo
!!$          end if
!!$
          if ( xy_SurfType(i,j) > 0 ) then
            if ( xy_SurfSnow(i,j) > SnowThreshold ) then
              xy_SurfAlbedo(i,j) = SnowAlbedo
            else if ( xy_SurfSnow(i,j) < 0.0_DP ) then
              xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
            else
              xy_SurfAlbedo(i,j) =                                                  &
                & ( SnowAlbedo - xy_SurfAlbedo(i,j) ) / ( SnowThreshold - 0.0_DP )  &
                & * ( xy_SurfSnow(i,j) - 0.0_DP )                                   &
                & + xy_SurfAlbedo(i,j)
            end if
          end if

        end do
      end do

    end if

    if ( present( xy_SeaIceConc ) ) then
      ! modify surface albedo on the sea ice
      !
      do j = 1, jmax
        do i = 0, imax-1

          if ( xy_SurfType(i,j) == 0 .and. xy_SeaIceConc(i,j) > SeaIceThreshold ) then
            xy_SurfAlbedo(i,j) = SeaIceAlbedo
          end if

!!$          if ( xy_SurfType(i,j) == 0 ) then
!!$            if ( xy_SeaIceConc(i,j) > 1.0_DP ) then
!!$!              call MessageNotify( 'E', module_name,                &
!!$!                & 'The value of SeaIceConc is inappropriate, %f.', &
!!$!                & d = (/ xy_SeaIceConc(i,j) / ) )
!!$              xy_SurfAlbedo(i,j) = SeaIceAlbedo
!!$            else if ( xy_SeaIceConc(i,j) < 0.0_DP ) then
!!$!              call MessageNotify( 'E', module_name,                &
!!$!                & 'The value of SeaIceConc is inappropriate, %f.', &
!!$!                & d = (/ xy_SeaIceConc(i,j) / ) )
!!$              xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
!!$            else
!!$              xy_SurfAlbedo(i,j) =                                             &
!!$                & ( SeaIceAlbedo - xy_SurfAlbedo(i,j) ) / ( 1.0_DP - 0.0_DP )  &
!!$                & * ( xy_SeaIceConc(i,j) - 0.0_DP )                            &
!!$                & + xy_SurfAlbedo(i,j)
!!$            end if
!!$          end if

        end do
      end do
    end if


  end subroutine ModAlbedoDueToSnowSeaIce

  !--------------------------------------------------------------------------------------

  subroutine ModAlbedoSnowSeaIceInit

    if ( modify_albedo_snowseaice_inited ) return


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    modify_albedo_snowseaice_inited = .true.

  end subroutine ModAlbedoSnowSeaIceInit

  !--------------------------------------------------------------------------------------

end module modify_albedo_snowseaice
