!=  H2O ǥ
!
!= Mars H2O cloud model
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: cloud_mars_h2o.f90,v 1.1 2013-09-30 03:04:39 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module cloud_mars_h2o
  !
  !=  H2O ǥ
  !
  != Mars H2O cloud model
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! In this module, H2O cloud on Mars is calculated by use of a simple
  ! cloud model.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#cloud_simple_nml
  !

  ! ⥸塼 ; USE statements

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! ³
  ! Public procedure
  !
  public :: CloudMarsH2O
  public :: CloudMarsH2OInit


  ! ѿ
  ! Public variables
  !


  ! ѿ
  ! Private variables
  !

  logical, save :: cloud_mars_h2o_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  character(*), parameter:: module_name = 'cloud_mars_h2o'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: cloud_mars_h2o.f90,v 1.1 2013-09-30 03:04:39 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine CloudMarsH2O(                            &
    & xyr_Press, xyz_VirTemp, xyr_Height,             & ! (in)
    & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,           & ! (in)
    & xyz_QH2OLiq,                                    & ! (inout)
    & xy_RainCum, xy_SnowCum, xy_RainLsc, xy_SnowLsc  & ! (out)
    & )

    ! USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime            ! $ \Delta t $ [s]

    ! ߲
    ! Gravitational sedimentation process
    !
    use grav_sed, only : GravSed


    real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in   ) :: xyz_VirTemp      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in   ) :: xyr_Height       ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in   ) :: xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in   ) :: xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OLiq      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out  ) :: xy_RainCum       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SnowCum       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_RainLsc       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SnowLsc       ( 0:imax-1, 1:jmax )



    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_mars_h2o_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_QH2OLiq = xyz_QH2OLiq &
      & + ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) * 2.0_DP * DelTime


    xy_RainCum = 0.0_DP
    xy_SnowCum = 0.0_DP
    xy_RainLsc = 0.0_DP
    xy_SnowLsc = 0.0_DP

    ! ߲
    ! Gravitational sedimentation process
    !
    call GravSed(                            &
      & 'MarsH2OCloud',                      & ! (in )
      & xyr_Press, xyz_VirTemp, xyr_Height,  & ! (in )
      & xyz_QH2OLiq,                         & ! (out)
      & xy_SnowLsc                           & ! (out) optional
      & )
    xy_SnowLsc = - xy_SnowLsc


  end subroutine CloudMarsH2O

  !--------------------------------------------------------------------------------------

  subroutine CloudMarsH2OInit

!!$    ! ե
!!$    ! File I/O support
!!$    !
!!$    use dc_iounit, only: FileOpen
!!$
!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ߲
    ! Gravitational sedimentation process
    !
    use grav_sed, only : GravSedInit

    ! ʸ ; Declaration statements
    !

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /cloud_simple_nml/ &
!!$      & CloudLifeTime,       &
!!$      & CloudWatLifeTime,    &
!!$      & CloudIceLifeTime,    &
!!$      & CloudCoverMethod,    &
!!$      & RHCrtl,              &
!!$      & CloudCover
          !
          ! ǥեͤˤĤƤϽ³ "cloud_mars_h2o#CloudMarsH2OInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "cloud_mars_h2o#CloudMarsH2OInit" for the default values.
          !

    ! ¹ʸ ; Executable statement
    !

    if ( cloud_mars_h2o_inited ) return


    ! ǥեͤ
    ! Default values settings
    !


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = cloud_mars_h2o_nml,       & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if



    ! Initialization of modules used in this module
    !

    ! ߲
    ! Gravitational sedimentation process
    !
    call GravSedInit


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'EffCloudCover', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'effective cloud cover', '1' )



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    cloud_mars_h2o_inited = .true.

  end subroutine CloudMarsH2OInit

  !--------------------------------------------------------------------------------------

end module cloud_mars_h2o
