!= ñͥǥ
!
!= Venus simple radiation model
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: rad_simple.f90,v 1.4 2012-09-17 10:59:31 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_Venus_simple
  !
  != ñͥǥ
  !
  != Venus simple radiation model
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! This is a simple radiation model.
  !
  !== References
  !
  !
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_Venus_simple_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! Private variables
  !
!!$  real(DP), save :: SWOptDepAtRefPress
!!$  real(DP), save :: SWRefPress
!!$  real(DP), save :: SWOrd
!!$  real(DP), save :: LWOptDepAtRefPress
!!$  real(DP), save :: LWRefPress
!!$  real(DP), save :: LWOrd
!!$  real(DP), save :: SolarConst

  ! Data are from Tomasko et al. (1980).
  ! Data from the surface to 64.3 km are from Table 8. 
  ! Data above 64.3 km are from Figure 17.
  ! MEMO:
  !   Net flux value at 64.3 km in Table 8 is discarded. This is because
  !   net flux at 64.3 km is 60.3 Wm-2 in Table 8 while it looks lower than
  !   values shown in Figure 17. So, the value around 65 km shown in Figure
  !   17 is used below.
  !   Further, net flux values near the surface is modified not to increase
  !   with decreasing altitude.
  integer , parameter :: NumTomaskoData = 17
  real(DP), save :: a_TomaskoDataHeight ( NumTomaskoData )
  real(DP), save :: a_TomaskoDataPress  ( NumTomaskoData )
  real(DP), save :: a_TomaskoDataNetFlux( NumTomaskoData )

  data a_TomaskoDataHeight &
    & /  90.0d3,  80.0d3,  77.0d3,  69.0d3,  65.0d3,  61.3d3, &
    &    57.5d3,  49.7d3,  47.9d3,  39.9d3,  31.4d3,  24.0d3, &
    &    16.2d3,  10.1d3,   5.0d3,   2.5d3,   0.1d3 /
  data a_TomaskoDataPress &
    & /     37.36,     447.60,     870.57,    4483.24,    9598.60,   18759.71,&
    &    35865.93,  110812.38,  139210.95,  353926.23,  840440.35, 1625000.00,&
    &  3020042.76, 4705664.33, 6665000.00, 7850892.24, 9151876.84 /
  data a_TomaskoDataNetFlux &
    & / 145.0  , 140.0  , 133.0  , 115.0  ,  90.0  ,  57.9  , &
    &    41.6  ,  33.5  ,  32.7  ,  32.4  ,  26.5  ,  22.7  , &
    &    18.4  ,  16.5  ,  16.3  ,  16.3  ,  16.3 /
!!$    &    18.4  ,  16.5  ,  16.3  ,  16.5  ,  16.7 /


  integer, save      :: IDSWMode
  integer, parameter :: IDSWModeGMNoAtmHeating = 1
  integer, parameter :: IDSWModeNoAtmHeating   = 2
  integer, parameter :: IDSWModeObsHeating     = 3


  ! ѿ
  ! Public variables
  !
  logical, save, public:: rad_Venus_simple_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  public :: RadVenusSimpleFlux
  public :: RadVenusSimpleInit

  character(*), parameter:: module_name = 'rad_Venus_simple'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: rad_simple.f90,v 1.4 2012-09-17 10:59:31 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine RadVenusSimpleFlux(                               &
    & xy_SurfTemp, xyr_Press, xyz_Press, xyz_Temp, xyr_Height, &
    & xyr_RadSUwFlux, xyr_RadSDwFlux,                          &
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                          &
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   &
    & )


    ! USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI,               &   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant
      & StB                   ! $ \sigma_{SB} $ .
                              ! ƥեܥĥޥ.
                              ! Stefan-Boltzmann constant

    !
    ! Physical constants settings
    !
    use constants, only: Grav     ! $ g $ [m s-2].
                                  !
                                  ! Gravitational acceleration

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only : y_Lat

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncome

!!$    !
!!$    ! Solve radiative transfer equation in two stream approximation
!!$    !
!!$    use rad_rte_two_stream_app, only: RadRTETwoStreamAppSW


    ! Ĺȥեåη׻
    ! Calculate long wave flux
    !
    use rad_simple_LW, only : RadSimpleLWFlux


    real(DP), intent(in ) :: xy_SurfTemp  (0:imax-1, 1:jmax)
    real(DP), intent(in ) :: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in ) :: xyz_Press    (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_Temp     (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyr_Height   (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
    real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)


    ! Work variables
    !
    real(DP) :: xyz_QH2OVap(0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: DistFromStarScld
                               ! Distance between the central star and the planet
    real(DP) :: DiurnalMeanFactor

!!$    real(DP) :: SolarFluxTOA
!!$    real(DP) :: QeRatio
!!$    real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
    real(DP) :: xy_CosZet     (0:imax-1, 1:jmax)
    real(DP) :: xyz_DelAtmMass(0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyr_OptDep    (0:imax-1, 1:jmax, 0:kmax)

    real(DP) :: xy_SurfEmis  (0:imax-1, 1:jmax)
    real(DP) :: xy_SurfAlbedo(0:imax-1, 1:jmax)

    real(DP) :: GMRadSUwFluxTOA

    integer  :: k


    ! 
    ! Initialization
    !
    if ( .not. rad_Venus_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Short wave radiation
    !

    ! ûͤη׻
    ! Calculate short wave (insolation) incoming radiation
    !
    call RadShortIncome(                       &
      & xy_InAngle        = xy_InAngle,        & ! (out) optional
      & xy_CosZet         = xy_CosZet,         & ! (out) optional
      & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
      & DiurnalMeanFactor = DiurnalMeanFactor  &
      & )

!!$    SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor

!!$    xyz_SSA    = 1.0_DP - 1.0d-10
!!$    xyz_AF     = 0.0_DP
!!$    xyr_OptDep = 0.0_DP
!!$
!!$    call RadRTETwoStreamAppSW(            &
!!$      & xyz_SSA, xyz_AF,                  & ! (in)
!!$      & xyr_OptDep,                       & ! (in)
!!$      & xy_SurfAlbedo,                    & ! (in)
!!$      & SolarFluxTOA, xy_InAngle,         & ! (in)
!!$      & xyr_RadSUwFlux, xyr_RadSDwFlux    & ! (out)
!!$      & )

    GMRadSUwFluxTOA = 1366.0_DP / (0.72_DP)**2 / 4.0_DP &
      & - a_TomaskoDataNetFlux(1)


    select case ( IDSWMode )
    case ( IDSWModeGMNoAtmHeating )
      xyr_RadSUwFlux = GMRadSUwFluxTOA
      xyr_RadSDwFlux = GMRadSUwFluxTOA + a_TomaskoDataNetFlux( NumTomaskoData )
    case ( IDSWModeNoAtmHeating )
      xyr_RadSUwFlux = GMRadSUwFluxTOA
      xyr_RadSDwFlux = GMRadSUwFluxTOA + a_TomaskoDataNetFlux( NumTomaskoData )
      xyr_RadSUwFlux = xyr_RadSUwFlux * 4.0_DP
      xyr_RadSDwFlux = xyr_RadSDwFlux * 4.0_DP
      do k = 0, kmax
        xyr_RadSUwFlux(:,:,k) = xyr_RadSUwFlux(:,:,k) &
          & * max( xy_CosZet, 0.0_DP ) * DiurnalMeanFactor
        xyr_RadSDwFlux(:,:,k) = xyr_RadSDwFlux(:,:,k) &
          & * max( xy_CosZet, 0.0_DP ) * DiurnalMeanFactor
      end do
    case ( IDSWModeObsHeating )
      xyr_RadSUwFlux = GMRadSUwFluxTOA
      xyr_RadSDwFlux = GMRadSUwFluxTOA + xyr_TomaskoNetFlux( xyr_Height, xyr_Press )
      xyr_RadSUwFlux = xyr_RadSUwFlux * 4.0_DP
      xyr_RadSDwFlux = xyr_RadSDwFlux * 4.0_DP
      do k = 0, kmax
        xyr_RadSUwFlux(:,:,k) = xyr_RadSUwFlux(:,:,k) &
          & * max( xy_CosZet, 0.0_DP ) * DiurnalMeanFactor
        xyr_RadSDwFlux(:,:,k) = xyr_RadSDwFlux(:,:,k) &
          & * max( xy_CosZet, 0.0_DP ) * DiurnalMeanFactor
      end do
    end select


    ! Long wave radiation
    !

    do k = 1, kmax
      xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
    end do
    !
    xy_SurfAlbedo = 0.0_DP
    xy_SurfEmis   = 1.0_DP
    !
    xyz_QH2OVap = 0.0_DP
    !
    call RadSimpleLWFlux(                                         &
      & xy_SurfAlbedo, xy_SurfEmis,                               & ! (in)
      & xyr_Press, xyz_Press, xyz_Temp, xy_SurfTemp,              & ! (in)
      & xyz_DelAtmMass, xyz_QH2OVap,                              & ! (in)
      & xyr_RadLUwFlux, xyr_RadLDwFlux,                           & ! (out)
      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                    & ! (out)
      & )


  end subroutine RadVenusSimpleFlux

  !--------------------------------------------------------------------------------------

  function xyr_TomaskoNetFlux( xyr_Height, xyr_Press )

    real(DP), intent(in) :: xyr_Height        (0:imax-1, 1:jmax, 0:kmax)         ! (m)
    real(DP), intent(in) :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
    real(DP)             :: xyr_TomaskoNetFlux(0:imax-1, 1:jmax, 0:kmax)

    !
    ! local variables
    !
    integer  :: i
    integer  :: j
    integer  :: k
    integer  :: kk


    do k = 0, kmax
      do j = 1, jmax
        do i = 0, imax-1

!!$          if ( xyr_Height(i,j,k) > a_TomaskoDataHeight(1) ) then
!!$            xyr_TomaskoNetFlux(i,j,k) = a_TomaskoDataNetFlux(1)
!!$          else if ( xyr_Height(i,j,k) <= a_TomaskoDataHeight(NumTomaskoData) ) then
!!$            xyr_TomaskoNetFlux(i,j,k) = a_TomaskoDataNetFlux(NumTomaskoData)
!!$          else
!!$            do kk = 2, NumTomaskoData
!!$              if ( ( a_TomaskoDataHeight(kk  ) <  xyr_Height(i,j,k)         ) .and. &
!!$                &  ( xyr_Height(i,j,k)         <= a_TomaskoDataHeight(kk-1) ) ) then
!!$                xyr_TomaskoNetFlux(i,j,k) =                    &
!!$                  &   ( a_TomaskoDataNetFlux(kk) - a_TomaskoDataNetFlux(kk-1) ) &
!!$                  & / ( a_TomaskoDataHeight (kk) - a_TomaskoDataHeight (kk-1) ) &
!!$                  & * ( xyr_Height(i,j,k)        - a_TomaskoDataHeight (kk-1) ) &
!!$                  & + a_TomaskoDataNetFlux(kk-1)
!!$              endif
!!$            end do
!!$          end if

        end do
      end do
    end do


    do k = 0, kmax
      do j = 1, jmax
        do i = 0, imax-1

          if ( xyr_Press(i,j,k) < a_TomaskoDataPress(1) ) then
            xyr_TomaskoNetFlux(i,j,k) = a_TomaskoDataNetFlux(1)
          else if ( xyr_Press(i,j,k) >= a_TomaskoDataPress(NumTomaskoData) ) then
            xyr_TomaskoNetFlux(i,j,k) = a_TomaskoDataNetFlux(NumTomaskoData)
          else
            do kk = 2, NumTomaskoData
              if ( ( a_TomaskoDataPress(kk-1) <= xyr_Press(i,j,k)         ) .and. &
                &  ( xyr_Press(i,j,k)         <  a_TomaskoDataPress(kk  ) ) ) then
                xyr_TomaskoNetFlux(i,j,k) =                    &
                  &   ( a_TomaskoDataNetFlux(kk) - a_TomaskoDataNetFlux(kk-1) ) &
                  & / log( a_TomaskoDataPress(kk) / a_TomaskoDataPress(kk-1) ) &
                  & * log( xyr_Press(i,j,k) / a_TomaskoDataPress(kk-1) ) &
                  & + a_TomaskoDataNetFlux(kk-1)
              endif
            end do
          end if

        end do
      end do
    end do


  end function xyr_TomaskoNetFlux

  !--------------------------------------------------------------------------------------

  subroutine RadVenusSimpleInit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncomeInit

!!$    !
!!$    ! Solve radiative transfer equation in two stream approximation
!!$    !
!!$    use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit

    ! ͥեå (ñĹȥХɥǥ)
    ! Radiation flux (simple longwave band model)
    !
    use rad_simple_LW, only : RadSimpleLWInit


    ! ʸ ; Declaration statements
    !
    character(STRING) :: SWMode

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /rad_Venus_simple_nml/ &
!!$      & SWOptDepAtRefPress, SWRefPress, SWOrd, &
!!$      & LWOptDepAtRefPress, LWRefPress, LWOrd, &
!!$      & SolarConst
!!$      & LWAbsCoef, LWRefPress, LWPressScaleInd
      & SWMode
          !
          ! ǥեͤˤĤƤϽ³ "rad_Simple#RadSimpleInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_Simple#RadSimpleInit" for the default values.
          !

    if ( rad_Venus_simple_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
!!$    SWOptDepAtRefPress =  3.0_DP
!!$    SWRefPress         =  3.0d5
!!$    SWOrd              =  1.0_DP
!!$
!!$    LWOptDepAtRefPress = 80.0_DP
!!$    LWRefPress         =  3.0d5
!!$    LWOrd              =  2.0_DP

!!$    SolarConst         = 1366.0_DP

    SWMode = 'GMNoAtmHeating'
!!$    SWMode = 'NoAtmHeating'
!!$    SWMode = 'AtmHeating'


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = rad_Venus_simple_nml,     & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    select case ( SWMode )
    case ( 'GMNoAtmHeating' )
      IDSWMode = IDSWModeGMNoAtmHeating
    case ( 'NoAtmHeating' )
      IDSWMode = IDSWModeNoAtmHeating
    case ( 'ObsHeating' )
      IDSWMode = IDSWModeObsHeating
    case default
      call MessageNotify( 'E', module_name, &
        & 'SWMode=<%c> is not supported.', &
        & c1 = trim(SWMode) )
    end select


    ! Initialization of modules used in this module
    !

    ! û ()
    ! Short wave (insolation) incoming
    !
    call RadShortIncomeInit

!!$    !
!!$    ! Solve radiative transfer equation in two stream approximation
!!$    !
!!$    call RadRTETwoStreamAppInit

    ! ͥեå (ñĹȥХɥǥ)
    ! Radiation flux (simple longwave band model)
    !
    call RadSimpleLWInit


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'SWOptDepAtRefPress = %f', d = (/ SWOptDepAtRefPress /) )
!!$    call MessageNotify( 'M', module_name, 'SWRefPress         = %f', d = (/ SWRefPress /) )
!!$    call MessageNotify( 'M', module_name, 'SWOrd              = %f', d = (/ SWOrd /) )
!!$    call MessageNotify( 'M', module_name, 'LWOptDepAtRefPress = %f', d = (/ LWOptDepAtRefPress /) )
!!$    call MessageNotify( 'M', module_name, 'LWRefPress         = %f', d = (/ LWRefPress /) )
!!$    call MessageNotify( 'M', module_name, 'LWOrd              = %f', d = (/ LWOrd /) )
!!$    call MessageNotify( 'M', module_name, 'SolarConst         = %f', d = (/ SolarConst /) )
    call MessageNotify( 'M', module_name, 'SWMode = %c', c1 = trim(SWMode) )
    call MessageNotify( 'M', module_name, '  IDSWMode = %d', i = (/ IDSWMode /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    rad_Venus_simple_inited = .true.

  end subroutine RadVenusSimpleInit

  !--------------------------------------------------------------------------------------

end module rad_Venus_simple
