!= Dennou AGCM μѤ˰漾λ
!
!= Evaluate saturation specific humidity with method used by Dennou AGCM
!
! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. Takahashi
! Version::   $Id: saturate_DennouAGCMOnIce.f90,v 1.1 2014/06/29 07:26:30 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_DennouAGCMOnIce
  !
  != Dennou AGCM μѤ˰漾λ
  !
  != Evaluate saturation specific humidity with method used by Dennou AGCM
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Dennou AGCM ѤƤѤ˰¾׻ޤ. 
  ! μ,  ¸ (1992) ˰ͤäƤޤ.
  ! , Ǯˤ, ŷǮǮ¤Ѥޤ.
  !
  ! Saturation specific humidity and temperature derivative of it 
  ! are calculated with a formula used in Dennou AGCM. 
  ! This formula is originaly obtained from Numaguti (1992).
  ! However, the value of latent heat is estimated as sum of vaporization 
  ! and melting.
  !
  !== References
  !
  ! * Numaguti, 1992: 
  !   <title in Japanese>, 
  !   Doctor thesis, University of Tokyo.
  !
  !== Procedures List
  !
  ! CalcQVapSat            :: ˰漾η׻
  ! CalcDQVapSatDTemp      :: ˰漾βʬη׻
  ! ------------  :: ------------
  ! CalcQVapSat            :: Calculate saturation specific humidity
  ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#saturate_t1930_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  logical, save      :: FlagSublimation
                              !
                              ! flag for treating sublimation

  ! ³
  ! Public procedure
  !
  public:: xyz_CalcQVapSat
  public:: xyz_CalcDQVapSatDTemp
  public:: SaturateInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_DennouAGCMOnIce_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), parameter:: Es0 = 611.0_DP
                              ! 0 ˰¾ [Pa]. 
                              ! Saturation water vapor pressure at 0 deg C [Pa]

  character(*), parameter:: module_name = 'saturate_DennouAGCMOnIce'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: saturate_DennouAGCMOnIce.f90,v 1.1 2014/06/29 07:26:30 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  function xyz_CalcQVapSat( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion, &
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp (:,:,:)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_Press(:,:,:)
                              ! $ p $ . . Air pressure

    real(DP):: xyz_QVapSat(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    real(DP):: LatentHeatLocal
                              !
                              ! Latent heat used in this routine


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !

    if ( .not. saturate_DennouAGCMOnIce_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! Set a value for latent heat
    LatentHeatLocal = LatentHeat + LatentHeatFusion

    xyz_QVapSat = &
      & EpsV * Es0 * exp( LatentHeatLocal / GasRWet * ( 1./273. - 1./xyz_Temp ) ) &
      & / xyz_Press


  end function xyz_CalcQVapSat

  !--------------------------------------------------------------------------------------

  function xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion, &
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp   (:,:,:)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_QVapSat(:,:,:)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !
    real(DP):: LatentHeatLocal
                              !
                              ! Latent heat used in this routine


    ! ¹ʸ ; Executable statement
    !

    if ( .not. saturate_DennouAGCMOnIce_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! Set a value for latent heat
    LatentHeatLocal = LatentHeat + LatentHeatFusion

    xyz_DQVapSatDTemp = LatentHeatLocal * xyz_QVapSat / ( GasRWet * xyz_Temp**2 )


  end function xyz_CalcDQVapSatDTemp

  !--------------------------------------------------------------------------------------

  subroutine SaturateInit
    !
    ! saturate_DennouAGCM ⥸塼νԤޤ. 
    !--
    ! NAMELIST#saturate_DennouAGCM_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "saturate_DennouAGCM" module is initialized. 
    !--
    ! "NAMELIST#saturate_DennouAGCM_nml" is loaded in this procedure. 
    !++

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /saturate_DennouAGCMOnIce_nml/ &
!!$      & FlagSublimation
          !
          ! ǥեͤˤĤƤϽ³ "saturate_DennouAGCM#SaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate_DennouAGCM#SaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_DennouAGCMOnIce_inited ) return


    ! ǥեͤ
    ! Default values settings
    !


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = saturate_DennouAGCM_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    saturate_DennouAGCMOnIce_inited = .true.

  end subroutine SaturateInit

  !--------------------------------------------------------------------------------------

end module saturate_DennouAGCMOnIce
