!= ̲, ھ٤λʬ
! 
!= Time integration of surface temperature and soil temperature
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: intg_surftemp.f90,v 1.10 2011-07-08 03:55:20 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module intg_surftemp
  !
  != ̲, ھ٤λʬ
  ! 
  != Time integration of surface temperature and soil temperature
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ̲٤ھ٤λʬԤޤ. 
  ! 
  ! Time integration of surface temperature and soiltemperature
  !
  !== Procedures List
  !
  ! IntegralSurfTemp   :: ̲, ھ٤λʬ
  ! ---------------    :: ---------------
  ! IntegralSurfTemp   :: Time integration of surface temperature and soil temperature
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#intg_surftemp_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only:   imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
    &                  jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
    &                  kmax, & ! ľؿ. 
                               ! Number of vertical level
    &                kslmax    ! ϲαľؿ. 
                               ! Number of subsurface vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: IntegralSurfTemp
  public :: IntgSurfTempInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: intg_surftemp_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(*), parameter:: module_name = 'intg_surftemp'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: intg_surftemp.f90,v 1.10 2011-07-08 03:55:20 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine IntegralSurfTemp(         &
    & xy_DSurfTempDt, xyz_DSoilTempDt, &          ! (in)
    & xy_SurfTemp   , xyz_SoilTemp     &          ! (inout)
    & )
    !
    ! ̲, ھ٤λʬԤޤ. 
    !
    ! Time integration of surface temperature and soil temperature
    !
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ (K s-1)
                              ! Surface temperature tendency (K s-1)
    real(DP), intent(in):: xyz_DSoilTempDt (0:imax-1, 1:jmax, 1:kslmax)
                              ! $ \DP{Tg}{t} $ . ھѲ (K s-1)
                              ! Temperature tendency (K s-1)
    real(DP), intent(inout):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(inout):: xyz_SoilTemp(0:imax-1, 1:jmax, 1:kslmax)
                              ! ھ (K)
                              ! Soil temperature (K)


    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. intg_surftemp_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! ɽ̲ٻʬ
    ! Time integration of surface temperature
    !
    xy_SurfTemp = xy_SurfTemp + xy_DSurfTempDt * DelTime

    ! ھٻʬ
    ! Time integration of subsurface temperature
    !
    xyz_SoilTemp = xyz_SoilTemp + xyz_DSoilTempDt * DelTime

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine IntegralSurfTemp

  !--------------------------------------------------------------------------------------

  subroutine IntgSurfTempInit
    !
    ! intg_surftemp ⥸塼νԤޤ. 
    ! NAMELIST#intg_surftemp_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "intg_surftemp" module is initialized. 
    ! "NAMELIST#intg_surftemp_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /intg_surftemp_nml/
          !
          ! ǥեͤˤĤƤϽ³ "intg_surftemp#IntgSurfTempInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "intg_surftemp#IntgSurfTempInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( intg_surftemp_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = intg_surftemp_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    intg_surftemp_inited = .true.

  end subroutine IntgSurfTempInit

  !--------------------------------------------------------------------------------------

end module intg_surftemp
