=begin JA

= 水惑星実験

# * 森川 靖大 (morikawa), 納多 哲史 (noda), 高橋 芳幸 (yot), 竹広 真一 (takepiro)
#   * $Id: exp-ape.rd,v 1.15 2014/07/07 14:50:00 yot Exp $

=end JA
=begin EN

= Aqua planet experiment

# * Yasuhiro MORIKAWA (morikawa), Satoshi NODA (noda), Yoshiyuki * O. Takahashi (yot), Shin-ichi Takehiro (takepiro)
#   * $Id: exp-ape.rd,v 1.15 2014/07/07 14:50:00 yot Exp $

=end EN


=begin JA

惑星表面が全て水であるような条件 (水惑星) 
で実験を行う方法を説明します. 

この計算には以下の物理過程を用いています. 

  * 放射 (AGCM5 デフォルト)
    * 長波放射 (水蒸気 3 領域, 乾燥大気 1 領域) 
    * 短波放射 (水蒸気 1 領域) 
  * 鉛直拡散 (Mellor and Yamada, 1974, レベル 2) 
  * 積雲パラメタリゼーション: 湿潤対流調節 (Manabe et al., 1965) 
  * 診断型大規模凝結 
  * 乾燥対流調節 

=end JA
=begin EN

A method to perform an aqua planet experiment
(planetary surface is covered by watar) is described. 

Following physical processes are used in this experiment.

  * Radiation (Band model) 
    * Longwave radiation (moisture 3 band, dry air 1 band) 
    * Shortwave radiation (moisture 1 band) 
  * Vertical diffusion (Mellor and Yamada, 1974, level 2) 
  * Cumulus parameterization: Convective adjustment scheme (Manabe et al., 1965) 
  * Large scale condensation
  * Dry convective adjustment

=end EN


=begin JA
== 概要

本実験では, 海表面温度のデータが必要です. したがって, 
実験の実行は以下の 4 つのステップで行います.

  * 実験ディレクトリの準備
  * 初期値の準備
  * 実験用データ (海表面温度分布) の準備
  * 実験の実行

=end JA
=begin EN
== Overview

This experiment requires data of distribution of sea surface temperature. 
So, the experiment is performed with the following 4 steps:

  * Preparation of directory for experiments
  * Preparation of initial condition
  * Preparation of additional data (sea surface temperature) for experiments
  * Execution of experiments

=end EN

=begin JA

== 実験用ディレクトリ準備

DCPAM5 の数値実験はソースツリー内部では行わず
ソースツリーとは別の外部ディレクトリにて行うことを推奨いたします. 

まず DCPAM5 ソースのトップディレクトリ(以下の例では dcpam5-YYYYMMDD とする)に移動してください. 
以下では DCPAM5 ソースディレクトリの隣に ../dcpma5-exp/ape-exp ディレクトリを作成し, そこで実験を行うことにします. 
次のように  ../dcpam5-exp/ape-exp ディレクトリを作成し, 
移動してください. 

  $ mkdir -p ../dcpam5-exp/ape-exp
  $ cd ../dcpam5-exp/ape-exp

次に, このディレクトリに実行ファイルと設定ファイル置き場を作成します. 

  $ mkdir bin
  $ mkdir conf

最後に作成したディレクトリに実行ファイルと設定ファイルをコピーします. 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data_surface   bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

#practice ディレクトリに移動してください. 
#
#  $ cd practice
#
#そのディレクトリ内で, make コマンドを実行してください.
#自動的に実行ファイルや NAMELIST ファイルがコピーされます. 
#make コマンド入力後, まずディレクトリ名を適宜入力してください.
#(下記の例では ape-exp としています). 
#それ以降の質問はとりあえずそのまま Enter キーを入力してください. 
#
#  $ make
#
#  ****** Setup a directory for a experiment ******
#
#    Enter directory name [testXX]: ape-exp
#    Directory in which executable files are prepared
#      [../src/main]: 
#            :
#
#そしてそのディレクトリに移動します. 
#
#  $ cd ape-exp

なお, 実行ファイルと設定ファイル (NAMELIST ファイル) があれば, どのディレクトリにおいても計算を行うことができます. 

== 初期値データファイルの作成

dcpam_init_data と init_data_T21L16.conf
を用いて初期値ファイル init_T21L16.nc を作成します. 

  $ ./bin/dcpam_init_data -N=./conf/init_data_T21L16.conf

                         : 
   *** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
   *** MESSAGE [restart_file_io] ***  Input::
   *** MESSAGE [restart_file_io] ***    InputFile  =
   *** MESSAGE [restart_file_io] ***  Output::
   *** MESSAGE [restart_file_io] ***    OutputFile = init_T21L16.nc
   *** MESSAGE [restart_file_io] ***    IntTime    = 1. [day]
   
   *** MESSAGE [HistoryCreate3] ***  "init_T21L16.nc" is created (origin=0. [day])
   *** MESSAGE [initial_data] ***  NAMELIST group "initial_data_nml" is loaded from "./conf/init_data_T21L16.conf".
   *** MESSAGE [initial_data] ***  NAMELIST group "initial_data_nml" is loaded from "./conf/init_data_T21L16.conf".
   *** MESSAGE [initial_data] ***  ----- Initialization Messages -----
   *** MESSAGE [initial_data] ***    Pattern = Small Disturbance of Temperature
   *** MESSAGE [initial_data] ***    TempAvr = 280.
   *** MESSAGE [initial_data] ***    PsAvr   = 100000.
   *** MESSAGE [initial_data] ***    QVapAvr = 0.1E-09

   *** MESSAGE [HistoryClose] ***  "init_T21L16.nc" is closed

== SST データファイルの作成

次に, dcpam_init_data_surface と sst_data_T21.conf を用いて, 海水面データ
sst_T21.nc を作成します. 

  $ ./bin/dcpam_init_data_surface -N=./conf/sst_data_T21.conf

                         :
   *** MESSAGE [restart_surftemp_io] ***  ----- Initialization Messages -----
   *** MESSAGE [restart_surftemp_io] ***  Input::
   *** MESSAGE [restart_surftemp_io] ***    InputFile  =
   *** MESSAGE [restart_surftemp_io] ***    InputName  = SurfTemp
   *** MESSAGE [restart_surftemp_io] ***  Output::
   *** MESSAGE [restart_surftemp_io] ***    OutputFile = sst_T21.nc
   *** MESSAGE [restart_surftemp_io] ***    IntTime    = 1. [day]
   
   *** MESSAGE [HistoryCreate3] ***  "sst_T21.nc" is created (origin=0. [day])
   *** MESSAGE [surface_data] ***  NAMELIST group "surface_data_nml" is loaded from "./conf/sst_data_T21.conf".
   *** MESSAGE [surface_data] ***  NAMELIST group "surface_data_nml" is loaded from "./conf/sst_data_T21.conf".
   *** MESSAGE [surface_data] ***  ----- Initialization Messages -----
   *** MESSAGE [surface_data] ***    Pattern = Hosaka et al. (1998)
   *** MESSAGE [surface_data] ***    SurfTemp     = 302.
   *** MESSAGE [surface_data] ***    Albedo       = 0.15
   *** MESSAGE [surface_data] ***    HumidCoeff   = 1.
   *** MESSAGE [surface_data] ***    RoughLength  = 0.1E-03
   *** MESSAGE [surface_data] ***    HeatCapacity = 0.
   *** MESSAGE [surface_data] ***    TempFlux     = 0.
   *** MESSAGE [surface_data] ***    SurfCond     = 0
   
   *** MESSAGE [HistoryClose] ***  "sst_T21.nc" is closed

== 実験の実行

最後に dcpam_main, dcpam_ape_T21L16.conf を用いて実験を実施します. 
解像度 T21L16, 時間ステップ 20 分で 10 日分計算を行います. 
リスタートデータ, 地表面リスタートデータといくつかのヒストリデータ
ファイルが出力されます. 

  $ ./bin/dcpam_main -N=./conf/dcpam_ape_T21L16.conf | tee ape.log

初期値データ, 地表面データ, 実験設定を変更する場合には,
上記の実行に際して, init_data_T21L16.conf, sst_data_T21.conf, 
dcpam_ape_T21L16.conf を変更してください. 


== リスタートデータからの実行

上記の初期値データを元に, 1000 日分の計算を行った際のリスタートデータを 
以下に用意してあります. このデータを用いてリスタートを行ってみましょう. 

  * ((<サンプルリスタートデータ|URL:http://www.gfd-dennou.org/library/dcpam/sample/2009-03-19_tutorial/ape-T21L16>))

上記のページから "ape-T21L16-rst.nc" と "ape-T21L16-rst-rad.nc" をダウンロードしてください.
そして, "./conf/dcpam_ape_T21L16.conf" の &timeset_nml, &restart_file_io, &radiation_band_nml
を以下のように変更してください.

  &timeset_nml
    RestartTimeValue  = 1000.0,
                                ! 計算開始時刻.
                                ! Start time of calculation
    RestartTimeUnit   = 'day',
                                ! 計算開始時刻の単位.
                                ! Unit of start time of calculation
    IntegPeriodValue  = 10.0, 
                                ! 計算終了時刻.
                                ! End time of calculation
    IntegPeriodUnit   = 'day',
                                ! 計算開始時刻の単位.
                                ! Unit of end time of calculation
                       :
  &restart_file_io_nml
    InputFile = 'ape-T21L16-rst.nc',
                              ! 入力するリスタートデータのファイル名
                              ! filename of input restart data
                       :

  &radiation_band_nml
    RstInputFile = 'ape-T21L16-rst-rad.nc', 
                              ! 入力するリスタートデータのファイル名
                              ! Filename of input restart data

以下のコマンドで実行を行ってください.

  $ ./bin/dcpam_main -N=./conf/dcpam_ape_T21L16.nml | tee ape.log

#この結果得られる Vor.nc の変数 Vor を GAVE で開くと
#以下のような渦度の分布が表示されます.
#
#((<"IMG:images/gave_ape_vor.png">))

計算結果の解析・可視化の方法については((<こちら|URL:./visualization.htm>))を参照してください. 

=end JA

=begin EN

== Preparation of a directory for an experiment

Let us move to the top directory of DCPAM5 src tree
(assuming dcpam5-YYYYMMDD in the following example). 
Here, we perform an experiment in ../dcpam5-exp/ape-exp directory. 
Please create the directory and enter there as follows: 

  $ mkdir -p ../dcpam5-exp/ape-exp
  $ cd ../dcpam5-exp/ape-exp

Then, pleaase create the directories for executable files and configuration
files as follows:

  $ mkdir bin
  $ mkdir conf

Finally, executable files and configuration files are copied as follows: 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data_surface   bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

#Move "practice" directory:
#
#  $ cd practice
#
#In the directory, execute 'make' command. 
#The execution files and the NAMELIST files will be automatically copied. 
#Input directory name first of all after inputting 'make' command. 
#(It is assumed "ape-exp" in the following example). 
#Input 'Enter' to the question after that. 
#
#  $ make
#
#  ****** Setup a directory for a experiment ******
#
#    Enter directory name [testXX]: ape-exp
#    Directory in which executable files are prepared
#      [../src/main]: 
#            :
#
#Move the directory
#
#  $ cd ape-exp


Note that you can perform an experiment in any directory by using executable files and configuration (NAMELIST) files.


== Create initial data file

Create initial data file "init_T21L16.nc"
using "dcpam_init_data" and "init_data_T21L16.conf" 
  
  $ ./bin/dcpam_init_data -N=./conf/init_data_T21L16.nml

                         : 
   *** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
   *** MESSAGE [restart_file_io] ***  Input::
   *** MESSAGE [restart_file_io] ***    InputFile  =
   *** MESSAGE [restart_file_io] ***  Output::
   *** MESSAGE [restart_file_io] ***    OutputFile = init_T21L16.nc
   *** MESSAGE [restart_file_io] ***    IntTime    = 1. [day]
   
   *** MESSAGE [HistoryCreate3] ***  "init_T21L16.nc" is created (origin=0. [day])
   *** MESSAGE [initial_data] ***  NAMELIST group "initial_data_nml" is loaded from "./conf/init_data_T21L16.conf".
   *** MESSAGE [initial_data] ***  NAMELIST group "initial_data_nml" is loaded from "./conf/init_data_T21L16.conf".
   *** MESSAGE [initial_data] ***  ----- Initialization Messages -----
   *** MESSAGE [initial_data] ***    Pattern = Small Disturbance of Temperature
   *** MESSAGE [initial_data] ***    TempAvr = 280.
   *** MESSAGE [initial_data] ***    PsAvr   = 100000.
   *** MESSAGE [initial_data] ***    QVapAvr = 0.1E-09

   *** MESSAGE [HistoryClose] ***  "init_T21L16.nc" is closed

== Create SST data file

Next, create SST data "sst_T21.nc" using
"dcpam_init_data_surface" and "sst_data_T21.conf". 

  $ ./bin/dcpam_init_data_surface -N=./conf/sst_data_T21.conf

                         :
   *** MESSAGE [restart_surftemp_io] ***  ----- Initialization Messages -----
   *** MESSAGE [restart_surftemp_io] ***  Input::
   *** MESSAGE [restart_surftemp_io] ***    InputFile  =
   *** MESSAGE [restart_surftemp_io] ***    InputName  = SurfTemp
   *** MESSAGE [restart_surftemp_io] ***  Output::
   *** MESSAGE [restart_surftemp_io] ***    OutputFile = sst_T21.nc
   *** MESSAGE [restart_surftemp_io] ***    IntTime    = 1. [day]
   
   *** MESSAGE [HistoryCreate3] ***  "sst_T21.nc" is created (origin=0. [day])
   *** MESSAGE [surface_data] ***  NAMELIST group "surface_data_nml" is loaded from "sst_data_T21.nml".
   *** MESSAGE [surface_data] ***  NAMELIST group "surface_data_nml" is loaded from "sst_data_T21.nml".
   *** MESSAGE [surface_data] ***  ----- Initialization Messages -----
   *** MESSAGE [surface_data] ***    Pattern = Hosaka et al. (1998)
   *** MESSAGE [surface_data] ***    SurfTemp     = 302.
   *** MESSAGE [surface_data] ***    Albedo       = 0.15
   *** MESSAGE [surface_data] ***    HumidCoeff   = 1.
   *** MESSAGE [surface_data] ***    RoughLength  = 0.1E-03
   *** MESSAGE [surface_data] ***    HeatCapacity = 0.
   *** MESSAGE [surface_data] ***    TempFlux     = 0.
   *** MESSAGE [surface_data] ***    SurfCond     = 0
   
   *** MESSAGE [HistoryClose] ***  "sst_T21.nc" is closed

== Run the experiment

At the last, run a experiment using 
"dcpam_main" and "dcpam_ape_T21L16.conf". 
Resolution is T21L16, time step is 20 minutes.
Integration time is 7 days. 
A restart data file, a restart data file of surface data,
and some history data files are output. 

  $ ./bin/dcpam_main -N=./conf/dcpam_ape_T21L16.conf | tee ape.log

If initial data, surface data, settings of experiments want to be
changed, edit "init_data_T21L16.conf", "sst_data_T21.conf", 
"dcpam_ape_T21L16.conf". 

=end EN

=begin JA
== 最後に
実験ディレクトリに作成された計算結果を保存しておきたい場合には
データ用ディレクトリ(例えば data01)を作成し, 
ファイルを移動させて整理しておきましょう. 

  $ mkdir data01
  $ mv *.nc *.log data01/

なお, 計算結果を計算実行時にサブディレクトリへ出力することも可能です. 
((<実験設定の変更|URL:./changesetup.htm>))の出力設定の変更を参照し, 
NAMELIST "&gtool_historyauto_nml" の変数 "FilePrefix" による設定を試してみて下さい. 
=end JA

=begin EN
== Final remark
If you would like to keep the results of the numerical experiment, 
please create a sub directory ("data01" for example), move the files, 
and keep the current directory neatly. 

  $ mkdir data01
  $ mv *.nc *.log data01/

You can output the results of the numerical experimet concurrently with the
execution. Please refer to "Change output settings" 
in ((<Change experimental setup|URL:./changesetup.htm.en>)) 
and try to configure "FilePrefix" variable in NAMELIST "&gtool_historyauto_nml". 

=end EN


=begin JA
== 参考文献
=end JA

=begin EN
== References
=end EN

=begin

* ((<Manabe, S., J. Smagorinsky, and R. F. Strickler, 1965: 
  Simulated climatology of a general circulation model with a
  hydrologic cycle,
  ((|Mon. Wea. Rev.|)), ((*93*)), 769--798.
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/1520-0493%281965%29093%3C0769%3ASCOAGC%3E2.3.CO%3B2>))

* ((<Mellor, G. L., and T. Yamada, 1974: 
  A hierarchy of turbulence closure models for planetary
  boundary layers,
  ((|J. Atmos. Sci.|)), ((*31*)), 1791--1806.
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/1520-0469%281974%29031%3C1791%3AAHOTCM%3E2.0.CO%3B2>))

=end

=begin HTML
<hr />
<small>
  $Id: exp-ape.rd,v 1.15 2014/07/07 14:50:00 yot Exp $
</small>
=end HTML

