Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: arakawa_schubert_L1982.f90
PROGRAM NAME: arakawa_schubert_l1982
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   179  vec  (   1): Vectorized loop.
   179  vec  (  29): ADB is used for array.: a_tbl1press
   189  opt  (1593): Loop nest collapsed into one loop.
   189  vec  (   1): Vectorized loop.
   189  vec  (  29): ADB is used for array.: xyz_presscldtop
   189  vec  (  29): ADB is used for array.: a_tbl1press
   189  vec  (  29): ADB is used for array.: a_tbl1cwf
   203  vec  (   3): Unvectorized loop.
   203  vec  (  13): Overhead of loop division is too large.
   204  opt  (1593): Loop nest collapsed into one loop.
   204  vec  (   4): Vectorized array expression.
   204  vec  (  29): ADB is used for array.: xyz_cwfcrtl
   204  vec  (  29): ADB is used for array.: xyz_presscldtop
   204  vec  (  29): ADB is used for array.: xy_presscldbase
   264  vec  (   1): Vectorized loop.
   264  vec  (  29): ADB is used for array.: a_tbl1press
   271  vec  (   1): Vectorized loop.
   271  vec  (  29): ADB is used for array.: z_cwfcrtl
   271  vec  (  29): ADB is used for array.: z_presscldtop
   271  vec  (  29): ADB is used for array.: a_tbl1press
   271  vec  (  29): ADB is used for array.: a_tbl1cwf
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: arakawa_schubert_L1982.f90
PROGRAM NAME: arakawa_schubert_l1982
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Arakawa-Schubert scheme by Lord et al. (1982)
     2  !
     3  != Arakawa-Schubert scheme by Lord et al. (1982)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: arakawa_schubert_L1982.f90,v 1.2 2014/02/04 10:24:42 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module arakawa_schubert_L1982
    13    !
    14    != Arakawa-Schubert scheme by Lord et al. (1982)
    15    !
    16    != Arakawa-Schubert scheme by Lord et al. (1982)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! Lord et al. (1982) による Arakawa-Schubert scheme の実装.
    21    !
    22    ! Implementation of Arakawa-Schubert scheme by Lord et al. (1982).
    23    !
    24    !
    25    !== References
    26    !
    27    !  Lord, S. J., W. C. Chao, and A. Arakawa,
    28    !    Interaction of a cumulus cloud ensemble with the large-scale environment.
    29    !    Part IV: The discrete model,
    30    !    J. Atmos. Sci., 39, 104-113, 1982.
    31    !
    32    !== Procedures List
    33    !
    34    ! ArakawaSchubertL1982CalcCWFCrtl ::
    35    ! ------------------------------- :: ------------
    36    ! ArakawaSchubertL1982CalcCWFCrtl :: Set critical value of cloud work function
    37    !                                    presented by Lord et al. (1982)
    38    !
    39    !== NAMELIST
    40    !
    41    ! NAMELIST#moist_conv_adjust_nml
    42    !
    43  
    44    ! モジュール引用 ; USE statements
    45    !
    46  
    47    ! 格子点設定
    48    ! Grid points settings
    49    !
    50    use gridset, only: imax, & ! 経度格子点数.
    51                               ! Number of grid points in longitude
    52      &                jmax, & ! 緯度格子点数.
    53                               ! Number of grid points in latitude
    54      &                kmax    ! 鉛直層数.
    55                               ! Number of vertical level
    56  
    57    ! 種別型パラメタ
    58    ! Kind type parameter
    59    !
    60    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    61      &                 STRING     ! 文字列.       Strings.
    62  
    63  
    64    ! メッセージ出力
    65    ! Message output
    66    !
    67    use dc_message, only: MessageNotify
    68  
    69    ! 宣言文 ; Declaration statements
    70    !
    71    implicit none
    72    private
    73  
    74  
    75    ! 公開手続き
    76    ! Public procedure
    77    !
    78    public :: ArakawaSchubertL1982CalcCWFCrtl
    79    public :: ASL1982CalcCWFCrtl1D
    80    public :: ArakawaSchubertL1982Init
    81  
    82    ! 公開変数
    83    ! Public variables
    84    !
    85  
    86    ! 非公開変数
    87    ! Private variables
    88    !
    89    logical, save :: arakawa_schubert_L1982_inited = .false.
    90                                ! 初期設定フラグ.
    91                                ! Initialization flag
    92  
    93    ! Values in Table 1 in Lord et al. (1982)
    94    !
    95    integer , parameter :: nTbl1 = 15
    96    real(DP), save      :: a_Tbl1Press( nTbl1 )  ! Pressure (Pa)
    97    real(DP), save      :: a_Tbl1CWF  ( nTbl1 )  ! Cloud work function (J kg-1 Pa-1)
    98  
    99    data a_Tbl1Press &
   100      & / 150.0d2  , 200.0d2  , 250.0d2  , 300.0d2  , 350.0d2  , 400.0d2  , 450.0d2  , &
   101      &   500.0d2  , 550.0d2  , 600.0d2  , 650.0d2  , 700.0d2  , 750.0d2  , 800.0d2  , &
   102      &   850.0d2   /
   103  
   104    data a_Tbl1CWF   &
   105      & / 1.6851d-2, 1.1686d-2, 0.7663d-2, 0.5255d-2, 0.4100d-2, 0.3677d-2, 0.3151d-2, &
   106      &   0.2216d-2, 0.1521d-2, 0.1082d-2, 0.0750d-2, 0.0664d-2, 0.0553d-2, 0.0445d-2, &
   107      &   0.0633d-2 /
   108  
   109  
   110    character(*), parameter:: module_name = 'arakawa_schubert_L1982'
   111                                ! モジュールの名称.
   112                                ! Module name
   113    character(*), parameter:: version = &
   114      & '$Name:  $' // &
   115      & '$Id: arakawa_schubert_L1982.f90,v 1.2 2014/02/04 10:24:42 yot Exp $'
   116                                ! モジュールのバージョン
   117                                ! Module version
   118  
   119  contains
   120  
   121    subroutine ArakawaSchubertL1982CalcCWFCrtl( &
   122      & xy_PressCldBase, xyz_PressCldTop,  &  ! (in)
   123      & xyz_CWFCrtl                        &  ! (out)
   124      & )
   125      !
   126      !
   127      !
   128      ! Calculate critical cloud work function by using interpolation of Table 1
   129      ! by Lord et al. (1982)
   130      !
   131  
   132      ! モジュール引用 ; USE statements
   133      !
   134  
   135  
   136  
   137      ! 宣言文 ; Declaration statements
   138      !
   139      implicit none
   140  
   141      real(DP), intent(in ) :: xy_PressCldBase (0:imax-1, 1:jmax)
   142                                ! pressure at cloud base
   143      real(DP), intent(in ) :: xyz_PressCldTop (0:imax-1, 1:jmax, 1:kmax)
   144                                ! pressure at cloud top
   145      real(DP), intent(out) :: xyz_CWFCrtl     (0:imax-1, 1:jmax, 1:kmax)
   146                                ! critical cloud work function
   147  
   148      ! 作業変数
   149      ! Work variables
   150      !
   151      integer  :: xyz_Index     (0:imax-1, 1:jmax, 1:kmax)
   152      real(DP) :: xyz_CWFIntpled(0:imax-1, 1:jmax, 1:kmax)
   153  
   154      integer :: i               ! 経度方向に回る DO ループ用作業変数
   155                                 ! Work variables for DO loop in longitude
   156      integer :: j               ! 緯度方向に回る DO ループ用作業変数
   157                                 ! Work variables for DO loop in latitude
   158      integer :: k               ! 鉛直方向に回る DO ループ用作業変数
   159                                 ! Work variables for DO loop in vertical direction
   160      integer :: l
   161  
   162  
   163      ! 実行文 ; Executable statement
   164      !
   165  
   166      ! 初期化確認
   167      ! Initialization check
   168      !
   169      if ( .not. arakawa_schubert_L1982_inited ) then
   170        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   171      end if
   172  
   173  
   174      do k = 1, kmax
   175        do j = 1, jmax
   176          do i = 0, imax-1
   177  
   178            xyz_Index(i,j,k) = 1
   179            loop_search : do l = 2, nTbl1-1
   180              if ( a_Tbl1Press(l) < xyz_PressCldTop(i,j,k) ) then
   181                xyz_Index(i,j,k) = l
   182              end if
   183            end do loop_search
     .        xyz_index1 = xyz_index(i,j,k)                                     
     .  !cdir nodep                                                             
     .  !cdir on_adb(a_tbl1press)                                               
     .        do l = 1, 13                                                      
     .           if (a_tbl1press(1+l) .lt. xyz_presscldtop(i,j,k)) then         
     .              xyz_index1 = 1 + l                                          
     .           endif                                                          
     .        enddo                                                             
     .        xyz_index(i,j,k) = xyz_index1                                     
   184  
   185          end do
   186        end do
   187      end do
   188  
   189      do k = 1, kmax
   190        do j = 1, jmax
   191          do i = 0, imax-1
   192  
   193            xyz_CWFIntpled(i,j,k) =                                                   &
   194              &   ( a_Tbl1CWF  (xyz_Index(i,j,k)+1) - a_Tbl1CWF  (xyz_Index(i,j,k)) ) &
   195              & / ( a_Tbl1Press(xyz_Index(i,j,k)+1) - a_Tbl1Press(xyz_Index(i,j,k)) ) &
   196              & * ( xyz_PressCldTop(i,j,k)          - a_Tbl1Press(xyz_Index(i,j,k)) ) &
   197              & + a_Tbl1CWF(xyz_Index(i,j,k))
   198  
   199          end do
   200        end do
   201      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(a_tbl1press)                                               
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_cwfintpled(k-1,1,1) = (a_tbl1cwf(xyz_index(k-1,1,1)+1)-(   
     .       1      a_tbl1cwf(xyz_index(k-1,1,1))))/(a_tbl1press(xyz_index(k-1,1
     .       2      ,1)+1)-(a_tbl1press(xyz_index(k-1,1,1))))*(xyz_presscldtop(k
     .       3      -1,1,1)-(a_tbl1press(xyz_index(k-1,1,1)))) + (a_tbl1cwf(    
     .       4      xyz_index(k-1,1,1)))                                        
     .        enddo                                                             
   202  
   203      do k = 1, kmax
   204        xyz_CWFCrtl(:,:,k) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_presscldbase)                                           
     .        do t225 = 1, xyz_cwfintpled.DSC.U2*xyz_cwfintpled.DSC.U1 +        
     .       1   xyz_cwfintpled.DSC.U2                                          
     .           xyz_cwfcrtl(t225-1,1,k) = xyz_cwfintpled(t225-1,1,k)*(         
     .       1      xy_presscldbase(t225-1,1)-xyz_presscldtop(t225-1,1,k))      
     .        enddo                                                             
   205          & xyz_CWFIntpled(:,:,k) * ( xy_PressCldBase - xyz_PressCldTop(:,:,k) )
   206      end do
   207  
   208  
   209    end subroutine ArakawaSchubertL1982CalcCWFCrtl
   210  
   211    !-------------------------------------------------------------------
   212  
   213    subroutine ASL1982CalcCWFCrtl1D( &
   214      & PressCldBase, z_PressCldTop,  &  ! (in)
   215      & z_CWFCrtl                        &  ! (out)
   216      & )
   217      !
   218      !
   219      !
   220      ! Calculate critical cloud work function by using interpolation of Table 1
   221      ! by Lord et al. (1982)
   222      !
   223  
   224      ! モジュール引用 ; USE statements
   225      !
   226  
   227  
   228  
   229      ! 宣言文 ; Declaration statements
   230      !
   231      implicit none
   232  
   233      real(DP), intent(in ) :: PressCldBase
   234                                ! pressure at cloud base
   235      real(DP), intent(in ) :: z_PressCldTop (1:kmax)
   236                                ! pressure at cloud top
   237      real(DP), intent(out) :: z_CWFCrtl     (1:kmax)
   238                                ! critical cloud work function
   239  
   240      ! 作業変数
   241      ! Work variables
   242      !
   243      integer  :: z_Index     (1:kmax)
   244      real(DP) :: z_CWFIntpled(1:kmax)
   245  
   246      integer :: k               ! 鉛直方向に回る DO ループ用作業変数
   247                                 ! Work variables for DO loop in vertical direction
   248      integer :: l
   249  
   250  
   251      ! 実行文 ; Executable statement
   252      !
   253  
   254      ! 初期化確認
   255      ! Initialization check
   256      !
   257      if ( .not. arakawa_schubert_L1982_inited ) then
   258        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   259      end if
   260  
   261  
   262      do k = 1, kmax
   263        z_Index(k) = 1
   264        loop_search : do l = 2, nTbl1-1
   265          if ( a_Tbl1Press(l) < z_PressCldTop(k) ) then
   266            z_Index(k) = l
   267          end if
   268        end do loop_search
     .        z_index1 = z_index(k)                                             
     .  !cdir nodep                                                             
     .  !cdir on_adb(a_tbl1press)                                               
     .        do l = 1, 13                                                      
     .           if (a_tbl1press(1+l) .lt. z_presscldtop(k)) then               
     .              z_index1 = 1 + l                                            
     .           endif                                                          
     .        enddo                                                             
     .        z_index(k) = z_index1                                             
   269      end do
   270  
   271      do k = 1, kmax
   272        z_CWFIntpled(k) =                                                   &
   273          &   ( a_Tbl1CWF  (z_Index(k)+1) - a_Tbl1CWF  (z_Index(k)) ) &
   274          & / ( a_Tbl1Press(z_Index(k)+1) - a_Tbl1Press(z_Index(k)) ) &
   275          & * ( z_PressCldTop(k)          - a_Tbl1Press(z_Index(k)) ) &
   276          & + a_Tbl1CWF(z_Index(k))
   277      end do
   278  
   279      do k = 1, kmax
   280        z_CWFCrtl(k) = &
   281          & z_CWFIntpled(k) * ( PressCldBase - z_PressCldTop(k) )
   282      end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(a_tbl1press)                                               
     .        do k = 1, kmax                                                    
     .           z_cwfintpled1 = (a_tbl1cwf(z_index(k)+1)-(a_tbl1cwf(z_index(k))
     .       1      ))/(a_tbl1press(z_index(k)+1)-(a_tbl1press(z_index(k))))*(  
     .       2      z_presscldtop(k)-(a_tbl1press(z_index(k)))) + (a_tbl1cwf(   
     .       3      z_index(k)))                                                
     .           z_cwfcrtl(k) = z_cwfintpled1*(presscldbase - z_presscldtop(k)) 
     .        enddo                                                             
   283  
   284  
   285    end subroutine ASL1982CalcCWFCrtl1D
   286  
   287    !-------------------------------------------------------------------
   288  
   289    subroutine ArakawaSchubertL1982Init
   290      !
   291      ! arakawa_schubert_L1982 モジュールの初期化を行います.
   292      ! NAMELIST#arakawa_schubert_L1982_nml の読み込みはこの手続きで行われます.
   293      !
   294      ! "arakawa_schubert_L1982" module is initialized.
   295      ! "NAMELIST#arakawa_schubert_L1982_nml" is loaded in this procedure.
   296      !
   297  
   298      ! モジュール引用 ; USE statements
   299      !
   300  
   301      ! NAMELIST ファイル入力に関するユーティリティ
   302      ! Utilities for NAMELIST file input
   303      !
   304      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   305  
   306      ! ファイル入出力補助
   307      ! File I/O support
   308      !
   309      use dc_iounit, only: FileOpen
   310  
   311  
   312      ! 宣言文 ; Declaration statements
   313      !
   314      implicit none
   315  
   316  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   317  !!$                              ! Unit number for NAMELIST file open
   318  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   319  !!$                              ! IOSTAT of NAMELIST read
   320  
   321      ! NAMELIST 変数群
   322      ! NAMELIST group name
   323      !
   324  !!$    namelist /arakawa_schubert_L1982_nml/ &
   325  !!$      &
   326  
   327            ! デフォルト値については初期化手続 "arakawa_schubert_L1982#CumAdjInit"
   328            ! のソースコードを参照のこと.
   329            !
   330            ! Refer to source codes in the initialization procedure
   331            ! "arakawa_schubert_L1982#ArakawaSchubertL1982Init" for the default values.
   332            !
   333  
   334      ! 実行文 ; Executable statement
   335      !
   336  
   337      if ( arakawa_schubert_L1982_inited ) return
   338  
   339      ! デフォルト値の設定
   340      ! Default values settings
   341      !
   342  
   343      ! NAMELIST の読み込み
   344      ! NAMELIST is input
   345      !
   346  !!$    if ( trim(namelist_filename) /= '' ) then
   347  !!$      call FileOpen( unit_nml, &          ! (out)
   348  !!$        & namelist_filename, mode = 'r' ) ! (in)
   349  !!$
   350  !!$      rewind( unit_nml )
   351  !!$      read( unit_nml,                  &  ! (in)
   352  !!$        & nml = moist_conv_adjust_nml, &  ! (out)
   353  !!$        & iostat = iostat_nml )           ! (out)
   354  !!$      close( unit_nml )
   355  !!$
   356  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   357  !!$    end if
   358  
   359  
   360  
   361      ! 印字 ; Print
   362      !
   363      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   364      call MessageNotify( 'M', module_name, '' )
   365      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   366  
   367      arakawa_schubert_L1982_inited = .true.
   368  
   369    end subroutine ArakawaSchubertL1982Init
   370  
   371    !-------------------------------------------------------------------
   372  
   373  end module arakawa_schubert_L1982
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: arakawa_schubert_L1982.f90
PROGRAM NAME: arakawa_schubert_l1982
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Arakawa-Schubert scheme by Lord et al. (1982)
     2:             !
     3:             != Arakawa-Schubert scheme by Lord et al. (1982)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: arakawa_schubert_L1982.f90,v 1.2 2014/02/04 10:24:42 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module arakawa_schubert_L1982
    13:               !
    14:               != Arakawa-Schubert scheme by Lord et al. (1982)
    15:               !
    16:               != Arakawa-Schubert scheme by Lord et al. (1982)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! Lord et al. (1982) による Arakawa-Schubert scheme の実装.
    21:               !
    22:               ! Implementation of Arakawa-Schubert scheme by Lord et al. (1982).
    23:               !
    24:               !
    25:               !== References
    26:               !
    27:               !  Lord, S. J., W. C. Chao, and A. Arakawa,
    28:               !    Interaction of a cumulus cloud ensemble with the large-scale environment.
    29:               !    Part IV: The discrete model, 
    30:               !    J. Atmos. Sci., 39, 104-113, 1982.
    31:               !
    32:               !== Procedures List
    33:               !
    34:               ! ArakawaSchubertL1982CalcCWFCrtl :: 
    35:               ! ------------------------------- :: ------------
    36:               ! ArakawaSchubertL1982CalcCWFCrtl :: Set critical value of cloud work function 
    37:               !                                    presented by Lord et al. (1982)
    38:               !
    39:               !== NAMELIST
    40:               !
    41:               ! NAMELIST#moist_conv_adjust_nml
    42:               !
    43:             
    44:               ! モジュール引用 ; USE statements
    45:               !
    46:             
    47:               ! 格子点設定
    48:               ! Grid points settings
    49:               !
    50:               use gridset, only: imax, & ! 経度格子点数. 
    51:                                          ! Number of grid points in longitude
    52:                 &                jmax, & ! 緯度格子点数. 
    53:                                          ! Number of grid points in latitude
    54:                 &                kmax    ! 鉛直層数. 
    55:                                          ! Number of vertical level
    56:             
    57:               ! 種別型パラメタ
    58:               ! Kind type parameter
    59:               !
    60:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    61:                 &                 STRING     ! 文字列.       Strings. 
    62:             
    63:             
    64:               ! メッセージ出力
    65:               ! Message output
    66:               !
    67:               use dc_message, only: MessageNotify
    68:             
    69:               ! 宣言文 ; Declaration statements
    70:               !
    71:               implicit none
    72:               private
    73:             
    74:             
    75:               ! 公開手続き
    76:               ! Public procedure
    77:               !
    78:               public :: ArakawaSchubertL1982CalcCWFCrtl
    79:               public :: ASL1982CalcCWFCrtl1D
    80:               public :: ArakawaSchubertL1982Init
    81:             
    82:               ! 公開変数
    83:               ! Public variables
    84:               !
    85:             
    86:               ! 非公開変数
    87:               ! Private variables
    88:               !
    89:               logical, save :: arakawa_schubert_L1982_inited = .false.
    90:                                           ! 初期設定フラグ. 
    91:                                           ! Initialization flag
    92:             
    93:               ! Values in Table 1 in Lord et al. (1982)
    94:               !
    95:               integer , parameter :: nTbl1 = 15
    96:               real(DP), save      :: a_Tbl1Press( nTbl1 )  ! Pressure (Pa)
    97:               real(DP), save      :: a_Tbl1CWF  ( nTbl1 )  ! Cloud work function (J kg-1 Pa-1)
    98:             
    99:               data a_Tbl1Press &
   100:                 & / 150.0d2  , 200.0d2  , 250.0d2  , 300.0d2  , 350.0d2  , 400.0d2  , 450.0d2  , &
   101:                 &   500.0d2  , 550.0d2  , 600.0d2  , 650.0d2  , 700.0d2  , 750.0d2  , 800.0d2  , &
   102:                 &   850.0d2   /
   103:             
   104:               data a_Tbl1CWF   &
   105:                 & / 1.6851d-2, 1.1686d-2, 0.7663d-2, 0.5255d-2, 0.4100d-2, 0.3677d-2, 0.3151d-2, &
   106:                 &   0.2216d-2, 0.1521d-2, 0.1082d-2, 0.0750d-2, 0.0664d-2, 0.0553d-2, 0.0445d-2, &
   107:                 &   0.0633d-2 /
   108:             
   109:             
   110:               character(*), parameter:: module_name = 'arakawa_schubert_L1982'
   111:                                           ! モジュールの名称. 
   112:                                           ! Module name
   113:               character(*), parameter:: version = &
   114:                 & '$Name:  $' // &
   115:                 & '$Id: arakawa_schubert_L1982.f90,v 1.2 2014/02/04 10:24:42 yot Exp $'
   116:                                           ! モジュールのバージョン
   117:                                           ! Module version
   118:             
   119:             contains
   120:             
   121:               subroutine ArakawaSchubertL1982CalcCWFCrtl( &
   122:                 & xy_PressCldBase, xyz_PressCldTop,  &  ! (in)
   123:                 & xyz_CWFCrtl                        &  ! (out)
   124:                 & )
   125:                 !
   126:                 ! 
   127:                 !
   128:                 ! Calculate critical cloud work function by using interpolation of Table 1 
   129:                 ! by Lord et al. (1982)
   130:                 !
   131:             
   132:                 ! モジュール引用 ; USE statements
   133:                 !
   134:             
   135:             
   136:             
   137:                 ! 宣言文 ; Declaration statements
   138:                 !
   139:                 implicit none
   140:             
   141:                 real(DP), intent(in ) :: xy_PressCldBase (0:imax-1, 1:jmax)
   142:                                           ! pressure at cloud base
   143:                 real(DP), intent(in ) :: xyz_PressCldTop (0:imax-1, 1:jmax, 1:kmax)
   144:                                           ! pressure at cloud top
   145:                 real(DP), intent(out) :: xyz_CWFCrtl     (0:imax-1, 1:jmax, 1:kmax)
   146:                                           ! critical cloud work function
   147:             
   148:                 ! 作業変数
   149:                 ! Work variables
   150:                 !
   151:                 integer  :: xyz_Index     (0:imax-1, 1:jmax, 1:kmax)
   152:                 real(DP) :: xyz_CWFIntpled(0:imax-1, 1:jmax, 1:kmax)
   153:             
   154:                 integer :: i               ! 経度方向に回る DO ループ用作業変数
   155:                                            ! Work variables for DO loop in longitude
   156:                 integer :: j               ! 緯度方向に回る DO ループ用作業変数
   157:                                            ! Work variables for DO loop in latitude
   158:                 integer :: k               ! 鉛直方向に回る DO ループ用作業変数
   159:                                            ! Work variables for DO loop in vertical direction
   160:                 integer :: l
   161:             
   162:             
   163:                 ! 実行文 ; Executable statement
   164:                 !
   165:             
   166:                 ! 初期化確認
   167:                 ! Initialization check
   168:                 !
   169:                 if ( .not. arakawa_schubert_L1982_inited ) then
   170:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   171:                 end if
   172:             
   173:             
   174: +------>        do k = 1, kmax
   175: |+----->          do j = 1, jmax
   176: ||+---->            do i = 0, imax-1
   177: |||         
   178: |||                   xyz_Index(i,j,k) = 1
   179: |||V--->              loop_search : do l = 2, nTbl1-1
   180: ||||    A               if ( a_Tbl1Press(l) < xyz_PressCldTop(i,j,k) ) then
   181: ||||                      xyz_Index(i,j,k) = l
   182: ||||                    end if
   183: |||V---               end do loop_search
   184: |||         
   185: ||+----             end do
   186: |+-----           end do
   187: +------         end do
   188:             
   189: W------>        do k = 1, kmax
   190: |*----->          do j = 1, jmax
   191: ||*---->            do i = 0, imax-1
   192: |||         
   193: |||     A             xyz_CWFIntpled(i,j,k) =                                                   &
   194: |||                     &   ( a_Tbl1CWF  (xyz_Index(i,j,k)+1) - a_Tbl1CWF  (xyz_Index(i,j,k)) ) &
   195: |||                     & / ( a_Tbl1Press(xyz_Index(i,j,k)+1) - a_Tbl1Press(xyz_Index(i,j,k)) ) &
   196: |||                     & * ( xyz_PressCldTop(i,j,k)          - a_Tbl1Press(xyz_Index(i,j,k)) ) &
   197: |||                     & + a_Tbl1CWF(xyz_Index(i,j,k))
   198: |||         
   199: ||*----             end do
   200: |*-----           end do
   201: W------         end do
   202:             
   203: +------>        do k = 1, kmax
   204: |W*==== A         xyz_CWFCrtl(:,:,k) = &
   205: |                   & xyz_CWFIntpled(:,:,k) * ( xy_PressCldBase - xyz_PressCldTop(:,:,k) )
   206: +------         end do
   207:             
   208:             
   209:               end subroutine ArakawaSchubertL1982CalcCWFCrtl
   210:             
   211:               !-------------------------------------------------------------------
   212:             
   213:               subroutine ASL1982CalcCWFCrtl1D( &
   214:                 & PressCldBase, z_PressCldTop,  &  ! (in)
   215:                 & z_CWFCrtl                        &  ! (out)
   216:                 & )
   217:                 !
   218:                 ! 
   219:                 !
   220:                 ! Calculate critical cloud work function by using interpolation of Table 1 
   221:                 ! by Lord et al. (1982)
   222:                 !
   223:             
   224:                 ! モジュール引用 ; USE statements
   225:                 !
   226:             
   227:             
   228:             
   229:                 ! 宣言文 ; Declaration statements
   230:                 !
   231:                 implicit none
   232:             
   233:                 real(DP), intent(in ) :: PressCldBase
   234:                                           ! pressure at cloud base
   235:                 real(DP), intent(in ) :: z_PressCldTop (1:kmax)
   236:                                           ! pressure at cloud top
   237:                 real(DP), intent(out) :: z_CWFCrtl     (1:kmax)
   238:                                           ! critical cloud work function
   239:             
   240:                 ! 作業変数
   241:                 ! Work variables
   242:                 !
   243:                 integer  :: z_Index     (1:kmax)
   244:                 real(DP) :: z_CWFIntpled(1:kmax)
   245:             
   246:                 integer :: k               ! 鉛直方向に回る DO ループ用作業変数
   247:                                            ! Work variables for DO loop in vertical direction
   248:                 integer :: l
   249:             
   250:             
   251:                 ! 実行文 ; Executable statement
   252:                 !
   253:             
   254:                 ! 初期化確認
   255:                 ! Initialization check
   256:                 !
   257:                 if ( .not. arakawa_schubert_L1982_inited ) then
   258:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   259:                 end if
   260:             
   261:             
   262: +------>        do k = 1, kmax
   263: |                 z_Index(k) = 1
   264: |V----->          loop_search : do l = 2, nTbl1-1
   265: ||      A           if ( a_Tbl1Press(l) < z_PressCldTop(k) ) then
   266: ||                    z_Index(k) = l
   267: ||                  end if
   268: |V-----           end do loop_search
   269: +------         end do
   270:             
   271: V------>        do k = 1, kmax
   272: |       A         z_CWFIntpled(k) =                                                   &
   273: |                   &   ( a_Tbl1CWF  (z_Index(k)+1) - a_Tbl1CWF  (z_Index(k)) ) &
   274: |                   & / ( a_Tbl1Press(z_Index(k)+1) - a_Tbl1Press(z_Index(k)) ) &
   275: |                   & * ( z_PressCldTop(k)          - a_Tbl1Press(z_Index(k)) ) &
   276: |                   & + a_Tbl1CWF(z_Index(k))
   277: |               end do
   278: |           
   279: |               do k = 1, kmax
   280: |                 z_CWFCrtl(k) = &
   281: |                   & z_CWFIntpled(k) * ( PressCldBase - z_PressCldTop(k) )
   282: V------         end do
   283:             
   284:             
   285:               end subroutine ASL1982CalcCWFCrtl1D
   286:             
   287:               !-------------------------------------------------------------------
   288:             
   289:               subroutine ArakawaSchubertL1982Init
   290:                 !
   291:                 ! arakawa_schubert_L1982 モジュールの初期化を行います. 
   292:                 ! NAMELIST#arakawa_schubert_L1982_nml の読み込みはこの手続きで行われます. 
   293:                 !
   294:                 ! "arakawa_schubert_L1982" module is initialized. 
   295:                 ! "NAMELIST#arakawa_schubert_L1982_nml" is loaded in this procedure. 
   296:                 !
   297:             
   298:                 ! モジュール引用 ; USE statements
   299:                 !
   300:             
   301:                 ! NAMELIST ファイル入力に関するユーティリティ
   302:                 ! Utilities for NAMELIST file input
   303:                 !
   304:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   305:             
   306:                 ! ファイル入出力補助
   307:                 ! File I/O support
   308:                 !
   309:                 use dc_iounit, only: FileOpen
   310:             
   311:             
   312:                 ! 宣言文 ; Declaration statements
   313:                 !
   314:                 implicit none
   315:             
   316:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   317:             !!$                              ! Unit number for NAMELIST file open
   318:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   319:             !!$                              ! IOSTAT of NAMELIST read
   320:             
   321:                 ! NAMELIST 変数群
   322:                 ! NAMELIST group name
   323:                 !
   324:             !!$    namelist /arakawa_schubert_L1982_nml/ &
   325:             !!$      & 
   326:             
   327:                       ! デフォルト値については初期化手続 "arakawa_schubert_L1982#CumAdjInit" 
   328:                       ! のソースコードを参照のこと. 
   329:                       !
   330:                       ! Refer to source codes in the initialization procedure
   331:                       ! "arakawa_schubert_L1982#ArakawaSchubertL1982Init" for the default values. 
   332:                       !
   333:             
   334:                 ! 実行文 ; Executable statement
   335:                 !
   336:             
   337:                 if ( arakawa_schubert_L1982_inited ) return
   338:             
   339:                 ! デフォルト値の設定
   340:                 ! Default values settings
   341:                 !
   342:             
   343:                 ! NAMELIST の読み込み
   344:                 ! NAMELIST is input
   345:                 !
   346:             !!$    if ( trim(namelist_filename) /= '' ) then
   347:             !!$      call FileOpen( unit_nml, &          ! (out)
   348:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   349:             !!$
   350:             !!$      rewind( unit_nml )
   351:             !!$      read( unit_nml,                  &  ! (in)
   352:             !!$        & nml = moist_conv_adjust_nml, &  ! (out)
   353:             !!$        & iostat = iostat_nml )           ! (out)
   354:             !!$      close( unit_nml )
   355:             !!$
   356:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   357:             !!$    end if
   358:             
   359:             
   360:             
   361:                 ! 印字 ; Print
   362:                 !
   363:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   364:                 call MessageNotify( 'M', module_name, '' )
   365:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   366:             
   367:                 arakawa_schubert_L1982_inited = .true.
   368:             
   369:               end subroutine ArakawaSchubertL1982Init
   370:             
   371:               !-------------------------------------------------------------------
   372:             
   373:             end module arakawa_schubert_L1982
