Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: moist_conv_adjust.f90
PROGRAM NAME: moist_conv_adjust
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   329  opt  (  11): Fused array assignments. :line 329 - 335
   329  vec  (   4): Vectorized array expression.
   329  vec  (  29): ADB is used for array.: xyz_qvapsat
   329  vec  (  29): ADB is used for array.: xyz_tempb
   329  vec  (  29): ADB is used for array.: xyz_temp
   329  vec  (  29): ADB is used for array.: xyz_qvapb
   329  vec  (  29): ADB is used for array.: xyz_qvap
   340  opt  (1593): Loop nest collapsed into one loop.
   340  vec  (   1): Vectorized loop.
   340  vec  (  29): ADB is used for array.: xyr_press
   343  opt  (1593): Loop nest collapsed into one loop.
   343  vec  (   4): Vectorized array expression.
   343  vec  (  29): ADB is used for array.: xyz_delmass
   349  opt  (1593): Loop nest collapsed into one loop.
   349  vec  (   4): Vectorized array expression.
   351  vec  (   3): Unvectorized loop.
   351  vec  (  13): Overhead of loop division is too large.
   352  opt  (1592): Outer loop unrolled inside inner loop.
   352  vec  (   4): Vectorized array expression.
   352  vec  (  29): ADB is used for array.: xyr_press
   352  vec  (  29): ADB is used for array.: xyz_press
   352  vec  (   4): Vectorized array expression.
   352  vec  (  29): ADB is used for array.: xyr_press
   352  vec  (  29): ADB is used for array.: xyz_press
   359  opt  (1593): Loop nest collapsed into one loop.
   359  vec  (   4): Vectorized array expression.
   365  opt  (1593): Loop nest collapsed into one loop.
   365  vec  (   4): Vectorized array expression.
   365  vec  (  29): ADB is used for array.: xyz_delqvapcond
   370  opt  (1593): Loop nest collapsed into one loop.
   370  vec  (   4): Vectorized array expression.
   376  opt  (1593): Loop nest collapsed into one loop.
   376  vec  (   4): Vectorized array expression.
   380  opt  (1017): Subroutine call prevents optimization.
   386  vec  (   1): Vectorized loop.
   386  vec  (  29): ADB is used for array.: xyz_qvapsat
   386  vec  (  29): ADB is used for array.: xyz_qvap
   386  vec  (  29): ADB is used for array.: xyz_delqvapcond
   386  vec  (  29): ADB is used for array.: xyz_delmass
   386  vec  (  29): ADB is used for array.: xyz_press
   386  vec  (  29): ADB is used for array.: xyr_press
   386  vec  (  29): ADB is used for array.: xyz_temp
   386  vec  (  29): ADB is used for array.: xy_dqvapsatdtemplowlev
   386  vec  (  29): ADB is used for array.: xy_dqvapsatdtempupplev
   597  vec  (   3): Unvectorized loop.
   597  vec  (  13): Overhead of loop division is too large.
   599  opt  (1019): Feedback of scalar value from one loop pass to another.
   599  opt  (1019): Feedback of scalar value from one loop pass to another.
   599  vec  (  21): Unvectorizable dependency.
   618  opt  (  11): Fused array assignments. :line 618 - 649
   618  opt  (1593): Loop nest collapsed into one loop.
   618  vec  (   4): Vectorized array expression.
   618  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   618  vec  (  29): ADB is used for array.: xyz_delqvapcond
   618  vec  (  29): ADB is used for array.: xyz_dtempdtcumulus
   618  vec  (  29): ADB is used for array.: xyz_tempb
   618  vec  (  29): ADB is used for array.: xyz_temp
   618  vec  (  29): ADB is used for array.: xyz_dqvapdtcumulus
   618  vec  (  29): ADB is used for array.: xyz_qvapb
   618  vec  (  29): ADB is used for array.: xyz_qvap
   650  opt  (1593): Loop nest collapsed into one loop.
   650  vec  (   4): Vectorized array expression.
   651  vec  (   3): Unvectorized loop.
   651  vec  (  13): Overhead of loop division is too large.
   652  opt  (1593): Loop nest collapsed into one loop.
   652  vec  (   4): Vectorized array expression.
   652  vec  (  29): ADB is used for array.: xy_raincumulus
   659  opt  (1592): Outer loop unrolled inside inner loop.
   659  vec  (   4): Vectorized array expression.
   659  vec  (  29): ADB is used for array.: xy_raincumulus
   659  vec  (   4): Vectorized array expression.
   659  vec  (  29): ADB is used for array.: xy_raincumulus
   696  warn (  82): Name "xyz_ddellwdtccplv" is not used.
   696  warn (  82): Name "xy_negddellwdt" is not used.
   775  opt  (  11): Fused array assignments. :line 775 - 776
   775  opt  (1593): Loop nest collapsed into one loop.
   775  vec  (   4): Vectorized array expression.
   777  vec  (   3): Unvectorized loop.
   777  vec  (  13): Overhead of loop division is too large.
   778  opt  (  11): Fused array assignments. :line 778 - 780
   778  opt  (1593): Loop nest collapsed into one loop.
   778  vec  (   4): Vectorized array expression.
   778  vec  (  29): ADB is used for array.: xy_suma
   778  vec  (  29): ADB is used for array.: xyz_delqvapcond
   778  vec  (  29): ADB is used for array.: xyz_qvapa
   778  vec  (  29): ADB is used for array.: xy_sumb
   778  vec  (  29): ADB is used for array.: xyz_delmass
   778  vec  (  29): ADB is used for array.: xyz_qvapb
   783  opt  (1593): Loop nest collapsed into one loop.
   783  vec  (   4): Vectorized array expression.
   783  vec  (  29): ADB is used for array.: xy_sumb
   783  vec  (  29): ADB is used for array.: xy_suma
   785  vec  (   3): Unvectorized loop.
   787  opt  (1017): Subroutine call prevents optimization.
   787  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   793  warn (  83): Dummy argument "xyz_tempa" is not used.
   793  warn (  83): Dummy argument "xyz_tempb" is not used.
   880  vec  (   4): Vectorized array expression.
   880  vec  (  29): ADB is used for array.: adjustcriterion
   934  vec  (   4): Vectorized array expression.
   934  vec  (  24): Iteration count is assumed. Iteration count=256
   934  vec  (  29): ADB is used for array.: adjustcriterion
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: moist_conv_adjust.f90
PROGRAM NAME: moist_conv_adjust
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 湿潤対流調節
     2  !
     3  != Moist convective adjustment
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6  ! Version::   $Id: moist_conv_adjust.f90,v 1.10 2015/01/29 12:00:21 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module moist_conv_adjust
    13    !
    14    != 湿潤対流調節
    15    !
    16    != Moist convective adjustment
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 湿潤対流調節スキームにより, 温度と比湿を調節.
    21    !
    22    ! Moist convective adjustment was originally proposed by Manabe et al. (1965).
    23    ! But, the algorithm used in this routine seems to be different from that described by
    24    ! Manabe et al. (1965).
    25    !
    26    ! Adjust temperature and specific humidity by
    27    ! convective adjustment scheme.
    28    !
    29    !== Procedures List
    30    !
    31    ! MoistConvAdjust :: 温度と比湿の調節
    32    ! --------------- :: ------------
    33    ! MoistConvAdjust :: Adjust temperature and specific humidity
    34    !
    35    !== NAMELIST
    36    !
    37    ! NAMELIST#moist_conv_adjust_nml
    38    !
    39  
    40    ! モジュール引用 ; USE statements
    41    !
    42  
    43    ! 格子点設定
    44    ! Grid points settings
    45    !
    46    use gridset, only: imax, & ! 経度格子点数.
    47                               ! Number of grid points in longitude
    48      &                jmax, & ! 緯度格子点数.
    49                               ! Number of grid points in latitude
    50      &                kmax    ! 鉛直層数.
    51                               ! Number of vertical level
    52  
    53    ! 種別型パラメタ
    54    ! Kind type parameter
    55    !
    56    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    57      &                 STRING     ! 文字列.       Strings.
    58  
    59    ! NAMELIST ファイル入力に関するユーティリティ
    60    ! Utilities for NAMELIST file input
    61    !
    62    use namelist_util, only: MaxNmlArySize
    63                                ! NAMELIST から読み込む配列の最大サイズ.
    64                                ! Maximum size of arrays loaded from NAMELIST
    65  
    66    ! メッセージ出力
    67    ! Message output
    68    !
    69    use dc_message, only: MessageNotify
    70  
    71    ! 宣言文 ; Declaration statements
    72    !
    73    implicit none
    74    private
    75  
    76  !!$  logical, save:: FlagUse
    77  !!$                              ! 使用フラグ
    78  !!$                              ! flag for use of this scheme
    79  
    80    ! 公開手続き
    81    ! Public procedure
    82    !
    83    public:: MoistConvAdjust
    84    public:: MoistConvAdjustInit
    85  
    86    ! 公開変数
    87    ! Public variables
    88    !
    89    logical, save :: moist_conv_adjust_inited = .false.
    90                                ! 初期設定フラグ.
    91                                ! Initialization flag
    92  
    93    ! 非公開変数
    94    ! Private variables
    95    !
    96    real(DP), save:: CrtlRH
    97                                ! 臨界相対湿度.
    98                                ! Critical relative humidity
    99    integer, save:: ItrtMax
   100                                ! イテレーション回数.
   101                                ! Number of iteration
   102  
   103    real(DP), save:: AdjustCriterion(1:MaxNmlArySize)
   104                                ! 調節を行う基準 (湿潤静的エネルギーの差の温度換算値)
   105                                ! Criterion of adjustment (temperature difference
   106                                ! equivalent to difference of moist static energy)
   107  
   108    character(*), parameter:: module_name = 'moist_conv_adjust'
   109                                ! モジュールの名称.
   110                                ! Module name
   111    character(*), parameter:: version = &
   112      & '$Name:  $' // &
   113      & '$Id: moist_conv_adjust.f90,v 1.10 2015/01/29 12:00:21 yot Exp $'
   114                                ! モジュールのバージョン
   115                                ! Module version
   116  
   117  contains
   118  
   119    !--------------------------------------------------------------------------------------
   120  
   121  !!$  subroutine MoistConvAdjust( &
   122  !!$    & xyz_Temp, xyz_QVap, xy_Rain, &  ! (inout)
   123  !!$    & xyz_DTempDt, xyz_DQVapDt, &     ! (inout)
   124  !!$    & xyz_Press, xyr_Press, &         ! (in)
   125  !!$    & xyz_DQH2OLiqDt &                ! (out)
   126  !!$    & )
   127    subroutine MoistConvAdjust(   &
   128      & xyz_Temp, xyz_QVap,       & ! (inout)
   129      & xyz_Press, xyr_Press,     & ! (in)
   130      & xyz_DQH2OLiqDt            & ! (out)
   131      & )
   132      !
   133      ! 湿潤対流調節スキームにより, 温度と比湿を調節.
   134      !
   135      ! Adjust temperature and specific humidity by moist convective adjustment
   136      !
   137  
   138      ! モジュール引用 ; USE statements
   139      !
   140  
   141      ! 物理定数設定
   142      ! Physical constants settings
   143      !
   144      use constants, only: &
   145        & Grav, &
   146                                ! $ g $ [m s-2].
   147                                ! 重力加速度.
   148                                ! Gravitational acceleration
   149        & GasRDry, &
   150                                ! $ R $ [J kg-1 K-1].
   151                                ! 乾燥大気の気体定数.
   152                                ! Gas constant of air
   153        & CpDry, &
   154                                ! $ C_p $ [J kg-1 K-1].
   155                                ! 乾燥大気の定圧比熱.
   156                                ! Specific heat of air at constant pressure
   157        & LatentHeat
   158                                ! $ L $ [J kg-1] .
   159                                ! 凝結の潜熱.
   160                                ! Latent heat of condensation
   161  
   162      ! 時刻管理
   163      ! Time control
   164      !
   165      use timeset, only: &
   166        & DelTime, &            ! $ \Delta t $
   167        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   168        & TimesetClockStart, TimesetClockStop
   169  
   170      ! ヒストリデータ出力
   171      ! History data output
   172      !
   173      use gtool_historyauto, only: HistoryAutoPut
   174  
   175      ! 飽和比湿の算出
   176      ! Evaluate saturation specific humidity
   177      !
   178      use saturate, only: xyz_CalcQVapSat, xy_CalcDQVapSatDTemp
   179  
   180  
   181      ! 宣言文 ; Declaration statements
   182      !
   183      implicit none
   184  
   185      real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   186                                ! $ T $ .     温度. Temperature
   187      real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   188                                ! $ q $ .     比湿. Specific humidity
   189  !!$    real(DP), intent(inout):: xy_Rain (0:imax-1, 1:jmax)
   190  !!$                              ! 降水量.
   191  !!$                              ! Precipitation
   192  
   193      real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   194                                ! $ p $ . 気圧 (整数レベル).
   195                                ! Air pressure (full level)
   196      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   197                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   198                                ! Air pressure (half level)
   199      real(DP), intent(out):: xyz_DQH2OLiqDt(0:imax-1, 1:jmax, 1:kmax)
   200  
   201      ! 作業変数
   202      ! Work variables
   203      !
   204      real(DP):: xy_RainCumulus (0:imax-1, 1:jmax)
   205                                ! 降水量.
   206                                ! Precipitation
   207      real(DP):: xyz_DTempDtCumulus (0:imax-1, 1:jmax, 1:kmax)
   208                                ! 温度変化率.
   209                                ! Temperature tendency
   210      real(DP):: xyz_DQVapDtCumulus (0:imax-1, 1:jmax, 1:kmax)
   211                                ! 比湿変化率.
   212                                ! Specific humidity tendency
   213  
   214      real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   215                                ! 調節前の比湿.
   216                                ! Specific humidity before adjustment
   217      real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   218                                ! 調節前の温度.
   219                                ! Temperature before adjustment
   220      logical:: xy_Adjust (0:imax-1, 1:jmax)
   221                                ! 今回調節されたか否か?.
   222                                ! Whether it was adjusted this time or not?
   223      logical:: xy_AdjustB (0:imax-1, 1:jmax)
   224                                ! 前回調節されたか否か?.
   225                                ! Whether it was adjusted last time or not?
   226      real(DP):: xyz_DelPress(0:imax-1, 1:jmax, 1:kmax)
   227                                ! $ \Delta p $
   228                                !
   229      real(DP):: xyz_DelMass  (0:imax-1, 1:jmax, 1:kmax)
   230                                ! $ \Delta m $
   231                                !
   232      real(DP):: xyz_QVapSat (0:imax-1, 1:jmax, 1:kmax)
   233                                ! 飽和比湿.
   234                                ! Saturation specific humidity.
   235      real(DP):: xyr_ConvAdjustFactor(0:imax-1, 1:jmax, 0:kmax)
   236                                ! $ \frac{1}{2} \frac{ R }{Cp}
   237                                !   \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} } $
   238  
   239      real(DP):: TempEquivToExcEne
   240                                ! Temperature equivalent to the excess moist static energy
   241                                ! (Moist static energy difference devided by specific heat)
   242  
   243      real(DP):: DelQ
   244      real(DP):: DelTempUppLev
   245                                ! k+1 番目の層における調節による温度の変化量.
   246                                ! Temperature variation by adjustment at k+1 level
   247      real(DP):: DelTempLowLev
   248                                ! k 番目の層における調節による温度の変化量.
   249                                ! Temperature variation by adjustment at k level
   250      real(DP):: DQVapSatDTempUppLev
   251                                ! $ \DD{q^{*}} (k+1)}{T} $
   252      real(DP):: DQVapSatDTempLowLev
   253                                ! $ \DD{q^{*}} (k)}{T} $
   254      real(DP):: GamUppLev
   255                                ! $ \gamma_{k+1} = \frac{L}{C_p} \DP{q^{*}}{T}_{k+1} $
   256      real(DP):: GamLowLev
   257                                ! $ \gamma_{k}   = \frac{L}{C_p} \DP{q^{*}}{T}_{k} $
   258      logical:: Adjust
   259                                ! 今回全領域において一度でも調節されたか否か?.
   260                                ! Whether it was adjusted even once in global
   261                                ! this time or not?
   262  
   263      real(DP):: TempLowLevBefAdj ! Variables for check routine
   264      real(DP):: TempUppLevBefAdj
   265      real(DP):: QVapLowLevBefAdj
   266      real(DP):: QVapUppLevBefAdj
   267  
   268      integer:: i               ! 経度方向に回る DO ループ用作業変数
   269                                ! Work variables for DO loop in longitude
   270      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   271                                ! Work variables for DO loop in latitude
   272      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   273                                ! Work variables for DO loop in vertical direction
   274      integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
   275                                ! Work variables for DO loop in iteration direction
   276  
   277      real(DP):: xy_DQVapSatDTempUppLev(0:imax-1, 1:jmax)
   278      real(DP):: xy_DQVapSatDTempLowLev(0:imax-1, 1:jmax)
   279  
   280      real(DP):: ExchangeMass
   281                                !
   282                                ! Mass transport
   283      real(DP):: ExchangeMassDenom
   284                                !
   285                                ! Variable for mass transport calculation
   286      real(DP):: ExchangeMassLowLim
   287                                !
   288                                ! Lower limit of mass transport calculation
   289      real(DP), parameter :: ExchangeMassLowLimTempDiff = 1.0d-5
   290                                !
   291                                ! Lower limit of temperature difference
   292                                ! between two layers for mass transport
   293                                ! calculation
   294  
   295      real(DP):: xyz_DelQVapCond(0:imax-1, 1:jmax, 1:kmax)
   296      real(DP):: DelQVapCondLowLev
   297      real(DP):: DelQVapCondUppLev
   298      real(DP):: DelQVapCond2Levs
   299      real(DP):: MassCor
   300  
   301      real(DP):: xyz_RainCumulus (0:imax-1, 1:jmax, 1:kmax)
   302  
   303      real(DP) :: xy_NegDDelLWDt   (0:imax-1, 1:jmax)
   304      real(DP) :: xyz_DDelLWDtCCPLV(0:imax-1, 1:jmax, 1:kmax)
   305  
   306  
   307      ! 実行文 ; Executable statement
   308      !
   309  
   310      ! 初期化確認
   311      ! Initialization check
   312      !
   313      if ( .not. moist_conv_adjust_inited ) then
   314        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   315      end if
   316  
   317  !!$    if ( .not. FlagUse ) return
   318  
   319  
   320      ! 計算時間計測開始
   321      ! Start measurement of computation time
   322      !
   323      call TimesetClockStart( module_name )
   324  
   325  
   326      ! 調節前 "QVap", "Temp" の保存
   327      ! Store "QVap", "Temp" before adjustment
   328      !
   329      xyz_QVapB = xyz_QVap
   330      xyz_TempB = xyz_Temp
   331  
   332      ! 飽和比湿計算
   333      ! Calculate saturation specific humidity
   334      !
   335      xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   336  
   337      ! Calculate some values used for moist convective adjustment
   338      !
   339  
   340      do k = 1, kmax
   341        xyz_DelPress(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
   342      end do
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delpress(k-1,1,1) = xyr_press(k-1,1,0) - xyr_press(k-1,1,1)
     .        enddo                                                             
   343      xyz_DelMass = xyz_DelPress / Grav
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1097 = 1, xyz_delpress.DSC.U3*(xyz_delpress.DSC.U2*           
     .       1   xyz_delpress.DSC.U1 + xyz_delpress.DSC.U2)                     
     .           xyz_delmass(t1097-1,1,1) = xyz_delpress(t1097-1,1,1)*d1        
     .        enddo                                                             
   344  
   345      ! \frac{1}{2} \frac{ R }{Cp} \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} }
   346      !
   347      !   The value at k = 0 is not used.
   348      k = 0
   349      xyr_ConvAdjustFactor(:,:,k) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1109 = 1, xyr_convadjustfactor.DSC.U2*                        
     .       1   xyr_convadjustfactor.DSC.U1 + xyr_convadjustfactor.DSC.U2      
     .           xyr_convadjustfactor(t1109-1,1,0) = 0.0000000000000000e+000    
     .        enddo                                                             
   350      !
   351      do k = 1, kmax-1
   352        xyr_ConvAdjustFactor(:,:,k) =                     &
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j1 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t1115 = 1, j1                                               
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_press)                                           
     .              do t1117 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyr_convadjustfactor(t1117-1,t1115,k) = gasrdry/cpdry*(  
     .       1            xyz_press(t1117-1,t1115,k)-xyz_press(t1117-1,t1115,k+1
     .       2            ))/(xyr_press(t1117-1,t1115,k)*2.00000000000000e+000) 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1115 = j1 + 1, xyz_press.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_press)                                           
     .              do t1117 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyr_convadjustfactor(t1117-1,t1115,k) = (gasrdry/cpdry)*(
     .       1            xyz_press(t1117-1,t1115,k)-xyz_press(t1117-1,t1115,k+1
     .       2            ))/(xyr_press(t1117-1,t1115,k)*2.00000000000000e+000) 
     .                 xyr_convadjustfactor(t1117-1,t1115+1,k) = (gasrdry/cpdry)
     .       1            *(xyz_press(t1117-1,t1115+1,k)-xyz_press(t1117-1,t1115
     .       2            +1,k+1))/(xyr_press(t1117-1,t1115+1,k)*               
     .       3            2.00000000000000e+000)                                
     .                 xyr_convadjustfactor(t1117-1,t1115+2,k) = (gasrdry/cpdry)
     .       1            *(xyz_press(t1117-1,t1115+2,k)-xyz_press(t1117-1,t1115
     .       2            +2,k+1))/(xyr_press(t1117-1,t1115+2,k)*               
     .       3            2.00000000000000e+000)                                
     .                 xyr_convadjustfactor(t1117-1,t1115+3,k) = (gasrdry/cpdry)
     .       1            *(xyz_press(t1117-1,t1115+3,k)-xyz_press(t1117-1,t1115
     .       2            +3,k+1))/(xyr_press(t1117-1,t1115+3,k)*               
     .       3            2.00000000000000e+000)                                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   353          & GasRDry / CpDry                               &
   354          &   * ( xyz_Press(:,:,k) - xyz_Press(:,:,k+1) ) &
   355          &   / xyr_Press(:,:,k) / 2.0_DP
   356      end do
   357      !   The value at k = kmax is not used.
   358      k = kmax
   359      xyr_ConvAdjustFactor(:,:,k) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1127 = 1, xyr_convadjustfactor.DSC.U2*                        
     .       1   xyr_convadjustfactor.DSC.U1 + xyr_convadjustfactor.DSC.U2      
     .           xyr_convadjustfactor(t1127-1,1,k) = 0.0000000000000000e+000    
     .        enddo                                                             
   360  
   361  
   362      !
   363      ! Initialization
   364      !
   365      xyz_DelQVapCond = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1133 = 1, xyz_delqvapcond.DSC.U3*(xyz_delqvapcond.DSC.U2*     
     .       1   xyz_delqvapcond.DSC.U1 + xyz_delqvapcond.DSC.U2)               
     .           xyz_delqvapcond(t1133-1,1,1) = 0.0000000000000000e+000         
     .        enddo                                                             
   366  
   367      ! 調節
   368      ! Adjustment
   369      !
   370      xy_AdjustB = .true.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1142 = 1, xy_adjustb.DSC.U2*xy_adjustb.DSC.U1 +               
     .       1   xy_adjustb.DSC.U2                                              
     .           xy_adjustb(t1142-1,1) = 1                                      
     .        enddo                                                             
   371  
   372      ! 繰り返し
   373      ! Iteration
   374      !
   375      do itr = 1, ItrtMax
   376        xy_Adjust = .false.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1148 = 1, xy_adjust.DSC.U2*xy_adjust.DSC.U1 + xy_adjust.DSC.U2
     .           xy_adjust(t1148-1,1) = 0                                       
     .        enddo                                                             
   377  
   378        do k = 1, kmax-1
   379  
   380          xy_DQVapSatDTempUppLev = &
   381            & xy_CalcDQVapSatDTemp( xyz_Temp(:,:,k+1), xyz_QVapSat(:,:,k+1) )
   382          xy_DQVapSatDTempLowLev = &
   383            & xy_CalcDQVapSatDTemp( xyz_Temp(:,:,k  ), xyz_QVapSat(:,:,k  ) )
   384  
   385          do j = 1, jmax
   386            do i = 0, imax-1
   387              if ( xy_AdjustB(i,j) ) then
   388  
   389                ! Temperature equivalent to the excess moist static energy
   390                ! (Moist static energy difference devided by specific heat)
   391                !
   392                TempEquivToExcEne = &
   393                  &   xyz_Temp(i,j,k) - xyz_Temp(i,j,k+1)                                &
   394                  & + LatentHeat / CpDry * ( xyz_QVapSat(i,j,k) - xyz_QVapSat(i,j,k+1) ) &
   395                  & - xyr_ConvAdjustFactor(i,j,k) * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
   396  
   397                ! Check vertical gradient of moist static energy
   398                !
   399                if ( TempEquivToExcEne > AdjustCriterion(itr) ) then
   400  
   401                  ! Check relative humidity
   402                  !
   403                  if ( ( xyz_QVap(i,j,k+1) / xyz_QVapSat(i,j,k+1) >= CrtlRH ) &
   404                    &  .and.                                                  &
   405                    &  ( xyz_QVap(i,j,k  ) / xyz_QVapSat(i,j,k  ) >= CrtlRH ) &
   406                    &) then
   407  
   408                    DelQ =                                                 &
   409                      &   xyz_DelPress(i,j,k  )                            &
   410                      &     * ( xyz_QVap(i,j,k  ) - xyz_QVapSat(i,j,k  ) ) &
   411                      & + xyz_DelPress(i,j,k+1)                            &
   412                      &     * ( xyz_QVap(i,j,k+1) - xyz_QVapSat(i,j,k+1) )
   413  
   414                    DQVapSatDTempUppLev = xy_DQVapSatDTempUppLev(i,j)
   415                    DQVapSatDTempLowLev = xy_DQVapSatDTempLowLev(i,j)
   416  
   417                    GamUppLev = LatentHeat / CpDry * DQVapSatDTempUppLev
   418                    GamLowLev = LatentHeat / CpDry * DQVapSatDTempLowLev
   419  
   420                    DelTempUppLev =                                                       &
   421                      & (                                                                 &
   422                      &     xyz_DelPress(i,j,k) * ( 1.0_DP + GamLowLev )                   &
   423                      &       * TempEquivToExcEne                                         &
   424                      &   + ( 1.0_DP + GamLowLev - xyr_ConvAdjustFactor(i,j,k) )           &
   425                      &       * LatentHeat / CpDry * DelQ                                 &
   426                      & )                                                                 &
   427                      & / ( xyr_ConvAdjustFactor(i,j,k)                                   &
   428                      &       * ( xyz_DelPress(i,j,k  ) * ( 1.0_DP + GamLowLev )           &
   429                      &         - xyz_DelPress(i,j,k+1) * ( 1.0_DP + GamUppLev ) )         &
   430                      &     + ( 1.0_DP + GamLowLev ) * ( 1.0_DP + GamUppLev )               &
   431                      &       * ( xyz_DelPress(i,j,k) + xyz_DelPress(i,j,k+1) ) )
   432  
   433                    DelTempLowLev =                                                       &
   434                      &   ( LatentHeat / CpDry * DelQ                                     &
   435                      &     - xyz_DelPress(i,j,k+1)                                       &
   436                      &         * ( 1.0_DP + GamUppLev ) * DelTempUppLev )                 &
   437                      & / ( ( 1.0_DP + GamLowLev ) * xyz_DelPress(i,j,k) )
   438  
   439  
   440                    !=========
   441                    TempLowLevBefAdj = xyz_Temp(i,j,k  )
   442                    TempUppLevBefAdj = xyz_Temp(i,j,k+1)
   443                    QVapLowLevBefAdj = xyz_QVap(i,j,k  )
   444                    QVapUppLevBefAdj = xyz_QVap(i,j,k+1)
   445                    !=========
   446  
   447  
   448                    ! 温度の調節
   449                    ! Adjust temperature
   450                    !
   451                    xyz_Temp(i,j,k  ) = xyz_Temp(i,j,k  ) + DelTempLowLev
   452                    xyz_Temp(i,j,k+1) = xyz_Temp(i,j,k+1) + DelTempUppLev
   453  
   454                    ! 比湿の調節
   455                    ! Adjust specific humidity
   456                    !
   457                    xyz_QVap(i,j,k  ) = &
   458                      &   xyz_QVapSat(i,j,k  ) + DQVapSatDTempLowLev * DelTempLowLev
   459                    xyz_QVap(i,j,k+1) = &
   460                      &   xyz_QVapSat(i,j,k+1) + DQVapSatDTempUppLev * DelTempUppLev
   461  
   462  
   463                    !
   464                    ! Mass exchange
   465                    !   Denominator
   466                    ExchangeMassDenom =                                      &
   467                      &   CpDry * ( TempLowLevBefAdj - TempUppLevBefAdj )    &
   468                      & - GasRDry                                            &
   469                      &   * ( TempLowLevBefAdj + TempUppLevBefAdj ) / 2.0_DP &
   470                      &   / xyr_Press(i,j,k)                                 &
   471                      &   * ( xyz_Press(i,j,k) - xyz_Press(i,j,k+1) )        &
   472                      & + LatentHeat * ( QVapLowLevBefAdj - QVapUppLevBefAdj )
   473                    ExchangeMassLowLim = CpDry * ExchangeMassLowLimTempDiff
   474                    ! If a static energy difference between two layers is smaller
   475                    ! than a specified lower limit, momentum and mixing ratio are
   476                    ! not mixed to ensure numerical stability.
   477                    ! If the lower limit is zero, some calculations are unstable.
   478                    ! (yot, 2013/10/02)
   479                    if ( ExchangeMassDenom > ExchangeMassLowLim ) then
   480                      ExchangeMass =                                     &
   481                        & - (   CpDry * DelTempLowLev                    &
   482                        &     + LatentHeat * ( xyz_QVap(i,j,k) - QVapLowLevBefAdj ) ) &
   483                        &   / ExchangeMassDenom  &
   484                        &     * xyz_DelMass(i,j,k)
   485                    else
   486                      ExchangeMass = 0.0_DP
   487                    end if
   488                    !   Limitation of amount of mass exchange not to
   489                    !   reverse a gradient
   490                    ExchangeMass = &
   491                      & min( ExchangeMass,                                      &
   492                      &      xyz_DelMass(i,j,k) * xyz_DelMass(i,j,k+1)          &
   493                      &        / ( xyz_DelMass(i,j,k) + xyz_DelMass(i,j,k+1) )  &
   494                      &    )
   495  
   496                    DelQVapCondLowLev =                           &
   497                      &   ( QVapUppLevBefAdj - QVapLowLevBefAdj ) &
   498                      &   * ExchangeMass / xyz_DelMass(i,j,k  )   &
   499                      & - ( xyz_QVap(i,j,k  ) - QVapLowLevBefAdj )
   500                    DelQVapCondUppLev =                           &
   501                      & - ( QVapUppLevBefAdj - QVapLowLevBefAdj ) &
   502                      &   * ExchangeMass / xyz_DelMass(i,j,k+1)   &
   503                      & - ( xyz_QVap(i,j,k+1) - QVapUppLevBefAdj )
   504  
   505                    ! Check
   506                    DelQVapCond2Levs = &
   507                      &   DelQVapCondLowLev * xyz_DelMass(i,j,k  ) &
   508                      & + DelQVapCondUppLev * xyz_DelMass(i,j,k+1)
   509                    if ( DelQVapCond2Levs < 0.0_DP ) then
   510  !!$                    call MessageNotify( 'M', module_name, &
   511  !!$                      & 'Condensation amount is negative, %f.', &
   512  !!$                      & d = (/ DelQVapCond2Levs /) )
   513                    else
   514                      if ( DelQVapCondLowLev < 0.0_DP ) then
   515                        MassCor = - DelQVapCondLowLev * xyz_DelMass(i,j,k  )
   516                        DelQVapCondLowLev = 0.0_DP
   517                        DelQVapCondUppLev =                                       &
   518                          & ( DelQVapCondUppLev * xyz_DelMass(i,j,k+1) - MassCor )&
   519                          & / xyz_DelMass(i,j,k+1)
   520                      end if
   521                      if ( DelQVapCondUppLev < 0.0_DP ) then
   522                        MassCor = - DelQVapCondUppLev * xyz_DelMass(i,j,k+1)
   523                        DelQVapCondLowLev =                                       &
   524                          & ( DelQVapCondLowLev * xyz_DelMass(i,j,k  ) - MassCor )&
   525                          & / xyz_DelMass(i,j,k  )
   526                        DelQVapCondUppLev = 0.0_DP
   527                      end if
   528                    end if
   529  
   530                    xyz_DelQVapCond(i,j,k  ) = xyz_DelQVapCond(i,j,k  ) &
   531                      & + DelQVapCondLowLev
   532                    xyz_DelQVapCond(i,j,k+1) = xyz_DelQVapCond(i,j,k+1) &
   533                      & + DelQVapCondUppLev
   534  
   535  
   536                    !=========
   537                    ! check routine
   538                    !---------
   539  !!$                  write( 6, * ) '====='
   540  !!$                  write( 6, * ) xyz_Temp(i,j,k), xyz_Temp(i,j,k+1), xyz_QVap(i,j,k), xyz_QVap(i,j,k+1)
   541  !!$                  write( 6, * ) DelTempLowLev, DelTempUppLev
   542  !!$                  write( 6, * ) 'Energy difference before and after adjustment and each energy'
   543  !!$                  write( 6, * ) &
   544  !!$                    &   ( CpDry * TempLowLevBefAdj  + LatentHeat * QVapLowLevBefAdj )  &
   545  !!$                    &     * xyz_DelPress(i,j,k  ) / Grav                               &
   546  !!$                    & + ( CpDry * TempUppLevBefAdj  + LatentHeat * QVapUppLevBefAdj )  &
   547  !!$                    &     * xyz_DelPress(i,j,k+1) / Grav                               &
   548  !!$                    & - ( CpDry * xyz_Temp(i,j,k  ) + LatentHeat * xyz_QVap(i,j,k  ) ) &
   549  !!$                    &     * xyz_DelPress(i,j,k  ) / Grav                               &
   550  !!$                    & - ( CpDry * xyz_Temp(i,j,k+1) + LatentHeat * xyz_QVap(i,j,k+1) ) &
   551  !!$                    &     * xyz_DelPress(i,j,k+1) / Grav,                              &
   552  !!$                    &   ( CpDry * TempLowLevBefAdj  + LatentHeat * QVapLowLevBefAdj )  &
   553  !!$                    &     * xyz_DelPress(i,j,k  ) / Grav,                              &
   554  !!$                    &   ( CpDry * TempUppLevBefAdj  + LatentHeat * QVapUppLevBefAdj )  &
   555  !!$                    &     * xyz_DelPress(i,j,k+1) / Grav,                              &
   556  !!$                    &   ( CpDry * xyz_Temp(i,j,k  ) + LatentHeat * xyz_QVap(i,j,k  ) ) &
   557  !!$                    &     * xyz_DelPress(i,j,k  ) / Grav,                              &
   558  !!$                    &   ( CpDry * xyz_Temp(i,j,k+1) + LatentHeat * xyz_QVap(i,j,k+1) ) &
   559  !!$                    &     * xyz_DelPress(i,j,k+1) / Grav
   560  !!$                  write( 6, * ) 'Difference of moist static energy after adjustment'
   561  !!$                  write( 6, * ) &
   562  !!$                    &   ( CpDry * xyz_Temp(i,j,k  ) + LatentHeat * xyz_QVap(i,j,k  ) )  &
   563  !!$                    & - ( CpDry * xyz_Temp(i,j,k+1) + LatentHeat * xyz_QVap(i,j,k+1) )  &
   564  !!$                    & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
   565  !!$                    &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) ),                      &
   566  !!$                    &   ( CpDry * xyz_Temp(i,j,k  ) + LatentHeat * xyz_QVap(i,j,k  ) ), &
   567  !!$                    &   ( CpDry * xyz_Temp(i,j,k+1) + LatentHeat * xyz_QVap(i,j,k+1) ), &
   568  !!$                    & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
   569  !!$                    &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
   570  !!$                  write( 6, * ) 'Difference of water vapor amount before and after adjustment'
   571  !!$                  write( 6, * ) &
   572  !!$                    & - LatentHeat * ( xyz_QVap(i,j,k  ) - QVapLowLevBefAdj ) &
   573  !!$                    & * xyz_DelPress(i,j,k  ) / Grav,                       &
   574  !!$                    & - LatentHeat * ( xyz_QVap(i,j,k+1) - QVapUppLevBefAdj ) &
   575  !!$                    & * xyz_DelPress(i,j,k+1) / Grav
   576                    !=========
   577  
   578  
   579                    xyz_QVapSat(i,j,k  ) = xyz_QVap(i,j,k  )
   580                    xyz_QVapSat(i,j,k+1) = xyz_QVap(i,j,k+1)
   581  
   582                    ! 調節したか否か?
   583                    ! Whether it was adjusted or not?
   584                    !
   585                    xy_Adjust(i,j) = .true.
   586                  end if
   587  
   588                end if
   589  
   590              end if
   591            end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(xyz_press)                                                 
     .        do i = 1, imax                                                    
     .           if (xy_adjustb(i-1,j) .ne. 0) then                             
     .              tempequivtoexcene = xyz_temp(i-1,j,k) - xyz_temp(i-1,j,k+1) 
     .       1          + latentheat/cpdry*(xyz_qvapsat(i-1,j,k)-xyz_qvapsat(i-1
     .       2         ,j,k+1)) - xyr_convadjustfactor(i-1,j,k)*(xyz_temp(i-1,j,
     .       3         k)+xyz_temp(i-1,j,k+1))                                  
     .              if (tempequivtoexcene .gt. adjustcriterion(itr)) then       
     .                 if (xyz_qvap(i-1,j,k+1)/xyz_qvapsat(i-1,j,k+1).ge.crtlrh 
     .       1            .and. xyz_qvap(i-1,j,k)/xyz_qvapsat(i-1,j,k).ge.crtlrh
     .       2            ) then                                                
     .                    delq = xyz_delpress(i-1,j,k)*(xyz_qvap(i-1,j,k)-      
     .       1               xyz_qvapsat(i-1,j,k)) + xyz_delpress(i-1,j,k+1)*(  
     .       2               xyz_qvap(i-1,j,k+1)-xyz_qvapsat(i-1,j,k+1))        
     .                    gamupplev = (latentheat/cpdry)*xy_dqvapsatdtempupplev(
     .       1               i-1,j)                                             
     .                    gamlowlev = (latentheat/cpdry)*xy_dqvapsatdtemplowlev(
     .       1               i-1,j)                                             
     .                    deltempupplev = ((xyz_delpress(i-1,j,k)*(             
     .       1               1.00000000000000e+000+gamlowlev))*tempequivtoexcene
     .       2               +((1.00000000000000e+000+gamlowlev)-               
     .       3               xyr_convadjustfactor(i-1,j,k))*latentheat/cpdry*   
     .       4               delq)/(xyr_convadjustfactor(i-1,j,k)*((xyz_delpress
     .       5               (i-1,j,k)*(1.00000000000000e+000+gamlowlev))-(     
     .       6               xyz_delpress(i-1,j,k+1)*(1.00000000000000e+000+    
     .       7               gamupplev)))+(1.00000000000000e+000+gamlowlev)*(   
     .       8               1.00000000000000e+000+gamupplev)*(xyz_delpress(i-1,
     .       9               j,k)+xyz_delpress(i-1,j,k+1)))                     
     .                    deltemplowlev = ((latentheat/cpdry)*delq - (          
     .       1               xyz_delpress(i-1,j,k+1)*(1.00000000000000e+000+    
     .       2               gamupplev))*deltempupplev)/(xyz_delpress(i-1,j,k)*(
     .       3               1.00000000000000e+000+gamlowlev))                  
     .                    templowlevbefadj = xyz_temp(i-1,j,k)                  
     .                    tempupplevbefadj = xyz_temp(i-1,j,k+1)                
     .                    qvaplowlevbefadj = xyz_qvap(i-1,j,k)                  
     .                    qvapupplevbefadj = xyz_qvap(i-1,j,k+1)                
     .                    xyz_temp(i-1,j,k) = xyz_temp(i-1,j,k) + deltemplowlev 
     .                    xyz_temp(i-1,j,k+1) = xyz_temp(i-1,j,k+1) +           
     .       1               deltempupplev                                      
     .                    xyz_qvap(i-1,j,k) = xyz_qvapsat(i-1,j,k) +            
     .       1               xy_dqvapsatdtemplowlev(i-1,j)*deltemplowlev        
     .                    xyz_qvap(i-1,j,k+1) = xyz_qvapsat(i-1,j,k+1) +        
     .       1               xy_dqvapsatdtempupplev(i-1,j)*deltempupplev        
     .                    exchangemassdenom = cpdry*(templowlevbefadj -         
     .       1               tempupplevbefadj) - gasrdry*(templowlevbefadj +    
     .       2               tempupplevbefadj)/2.00000000000000e+000/xyr_press(i
     .       3               -1,j,k)*(xyz_press(i-1,j,k)-xyz_press(i-1,j,k+1))  
     .       4                + latentheat*(qvaplowlevbefadj - qvapupplevbefadj)
     .                    if (exchangemassdenom .gt. cpdry*1.00000000000000e-005
     .       1               ) then                                             
     .                       exchangemass = -(cpdry*deltemplowlev + latentheat*(
     .       1                  xyz_qvap(i-1,j,k)-qvaplowlevbefadj))/           
     .       2                  exchangemassdenom*xyz_delmass(i-1,j,k)          
     .                    else                                                  
     .                       exchangemass = 0.0000000000000000e+000             
     .                    endif                                                 
     .                    exchangemass = min(exchangemass,xyz_delmass(i-1,j,k)* 
     .       1               xyz_delmass(i-1,j,k+1)/(xyz_delmass(i-1,j,k)+      
     .       2               xyz_delmass(i-1,j,k+1)))                           
     .                    delqvapcondlowlev = ((qvapupplevbefadj -              
     .       1               qvaplowlevbefadj)*exchangemass)/xyz_delmass(i-1,j,k
     .       2               ) - (xyz_qvap(i-1,j,k)-qvaplowlevbefadj)           
     .                    delqvapcondupplev = (-((qvapupplevbefadj -            
     .       1               qvaplowlevbefadj)*exchangemass)/xyz_delmass(i-1,j,k
     .       2               +1)) - (xyz_qvap(i-1,j,k+1)-qvapupplevbefadj)      
     .                    if (delqvapcondlowlev*xyz_delmass(i-1,j,k) +          
     .       1               delqvapcondupplev*xyz_delmass(i-1,j,k+1) .ge.      
     .       2               0.0000000000000000e+000) then                      
     .                       if (delqvapcondlowlev .lt. 0.0000000000000000e+000 
     .       1                  ) then                                          
     .                          masscor=-delqvapcondlowlev*xyz_delmass(i-1,j,k) 
     .                          delqvapcondlowlev = 0.0000000000000000e+000     
     .                          delqvapcondupplev = (delqvapcondupplev*         
     .       1                     xyz_delmass(i-1,j,k+1)-masscor)/xyz_delmass(i
     .       2                     -1,j,k+1)                                    
     .                       endif                                              
     .                       if (delqvapcondupplev .lt. 0.0000000000000000e+000 
     .       1                  ) then                                          
     .                          masscor = -delqvapcondupplev*xyz_delmass(i-1,j,k
     .       1                     +1)                                          
     .                          delqvapcondlowlev = (delqvapcondlowlev*         
     .       1                     xyz_delmass(i-1,j,k)-masscor)/xyz_delmass(i-1
     .       2                     ,j,k)                                        
     .                          delqvapcondupplev = 0.0000000000000000e+000     
     .                       endif                                              
     .                    endif                                                 
     .                    xyz_delqvapcond(i-1,j,k) = xyz_delqvapcond(i-1,j,k) + 
     .       1               delqvapcondlowlev                                  
     .                    xyz_delqvapcond(i-1,j,k+1) = xyz_delqvapcond(i-1,j,k+1
     .       1               ) + delqvapcondupplev                              
     .                    xyz_qvapsat(i-1,j,k) = xyz_qvap(i-1,j,k)              
     .                    xyz_qvapsat(i-1,j,k+1) = xyz_qvap(i-1,j,k+1)          
     .                    xy_adjust(i-1,j) = 1                                  
     .                 endif                                                    
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   592          end do
   593        end do
   594  
   595        Adjust = .false.
   596        do i = 0, imax-1
   597          do j = 1, jmax
   598            xy_AdjustB(i,j) = xy_Adjust(i,j)
   599            Adjust          = Adjust .or. xy_Adjust(i,j)
   600          end do
   601        end do
   602  
   603        if ( .not. Adjust ) exit
   604  
   605      end do
   606  
   607  
   608      call MoistConvAdjustChkCons(              &
   609        & xyz_TempB, xyz_Temp,                  & ! (in)
   610        & xyz_QVapB, xyz_QVap, xyz_DelQVapCond, & ! (in)
   611        & xyz_DelMass                           & ! (in)
   612        & )
   613  
   614  
   615      ! 比湿変化率, 温度変化率, 降水量の算出
   616      ! Calculate specific humidity tendency, temperature tendency, precipitation
   617      !
   618      xyz_DQVapDtCumulus = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
     .        d3 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d4 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d5 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d6 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1154 = 1, kmax*jmax*imax                                      
     .           xyz_dqvapdtcumulus(t1154-1,1,1) = (xyz_qvap(t1154-1,1,1)-      
     .       1      xyz_qvapb(t1154-1,1,1))*d3                                  
     .           xyz_dtempdtcumulus(t1154-1,1,1) = (xyz_temp(t1154-1,1,1)-      
     .       1      xyz_tempb(t1154-1,1,1))*d4                                  
     .           xyz_dqh2oliqdt1 = xyz_delqvapcond(t1154-1,1,1)*d5              
     .           xyz_dqh2oliqdt1 = max(xyz_dqh2oliqdt1,0.0000000000000000e+000) 
     .           xyz_raincumulus(t1154-1,1,1) = xyz_dqh2oliqdt1*xyz_delpress(   
     .       1      t1154-1,1,1)*d6                                             
     .           xyz_dqh2oliqdt(t1154-1,1,1) = xyz_dqh2oliqdt1                  
     .        enddo                                                             
   619  
   620      xyz_DTempDtCumulus = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   621  
   622      ! old
   623  !!$    xyz_DQH2OLiqDt = ( xyz_QVapB - xyz_QVap ) / ( 2.0_DP * DelTime )
   624      ! new (2014/12/04)
   625      xyz_DQH2OLiqDt = xyz_DelQVapCond / ( 2.0_DP * DelTime )
   626      !   avoid negative cloud amount
   627      xyz_DQH2OLiqDt = max( xyz_DQH2OLiqDt, 0.0_DP )
   628  
   629  !!$    xyz_RainCumulus = xyz_DQH2OLiqDt * xyz_DelPress / Grav
   630  !!$    xy_RainCumulus = 0.0d0
   631  !!$    do k = kmax, 1, -1
   632  !!$      xy_RainCumulus = xy_RainCumulus + xyz_RainCumulus(:,:,k)
   633  !!$    end do
   634  
   635  
   636  !!$    j = jmax/2+1
   637  !!$    do i = 0, imax-1
   638  !!$      if ( xy_RainCumulus(i,j) /= 0.0d0 ) then
   639  !!$        write( 6, * ) xy_RainCumulus(i,j)
   640  !!$      end if
   641  !!$    end do
   642  !!$    write( 6, * ) '---'
   643  
   644  
   645  !!$    xy_Rain     = xy_Rain     + xy_RainCumulus
   646  
   647  
   648      ! calculation for output (tentative)
   649      xyz_RainCumulus = xyz_DQH2OLiqDt * xyz_DelPress / Grav
   650      xy_RainCumulus = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1199 = 1, xy_raincumulus.DSC.U2*xy_raincumulus.DSC.U1 +       
     .       1   xy_raincumulus.DSC.U2                                          
     .           xy_raincumulus(t1199-1,1) = 0.0000000000000000e+000            
     .        enddo                                                             
   651      do k = kmax, 1, -1
   652        xy_RainCumulus = xy_RainCumulus + xyz_RainCumulus(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_raincumulus)                                            
     .        do t1205 = 1, xy_raincumulus.DSC.U2*xy_raincumulus.DSC.U1 +       
     .       1   xy_raincumulus.DSC.U2                                          
     .           xy_raincumulus(t1205-1,1) = xy_raincumulus(t1205-1,1) +        
     .       1      xyz_raincumulus(t1205-1,1,k)                                
     .        enddo                                                             
   653      end do
   654  
   655  
   656      ! ヒストリデータ出力
   657      ! History data output
   658      !
   659      call HistoryAutoPut( TimeN, 'RainCumulus',    xy_RainCumulus * LatentHeat )
     .        if (xy_raincumulus.DSC.U2 .gt. 0) then                            
     .           j2 = and(xy_raincumulus.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t1215 = 1, j2                                               
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_raincumulus)                                      
     .              do t1217 = 1, xy_raincumulus.DSC.U1 + 1                     
     .                 %IG0(t1217,t1215) = xy_raincumulus(t1217-1,t1215)*       
     .       1            latentheat                                            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1215 = j2 + 1, xy_raincumulus.DSC.U2, 4                    
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_raincumulus)                                      
     .              do t1217 = 1, xy_raincumulus.DSC.U1 + 1                     
     .                 %IG0(t1217,t1215) = xy_raincumulus(t1217-1,t1215)*       
     .       1            latentheat                                            
     .                 %IG0(t1217,t1215+1) = xy_raincumulus(t1217-1,t1215+1)*   
     .       1            latentheat                                            
     .                 %IG0(t1217,t1215+2) = xy_raincumulus(t1217-1,t1215+2)*   
     .       1            latentheat                                            
     .                 %IG0(t1217,t1215+3) = xy_raincumulus(t1217-1,t1215+3)*   
     .       1            latentheat                                            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   660      call HistoryAutoPut( TimeN, 'DTempDtCumulus', xyz_DTempDtCumulus )
   661      call HistoryAutoPut( TimeN, 'DQVapDtCumulus', xyz_DQVapDtCumulus )
   662  
   663  
   664  
   665  !!$    if ( present( xyz_DQH2OLiqDt ) ) then
   666  !!$
   667  !!$      xyz_DDelLWDtCCPLV = &
   668  !!$        & + ( xyz_QVapB - xyz_QVap ) &
   669  !!$        &       * xyz_DelPress / Grav / ( 2.0d0 * DelTime )
   670  !!$
   671  !!$      ! Negative cloud production rate is filled with values in lower layers.
   672  !!$      !
   673  !!$      xy_NegDDelLWDt = 0.0d0
   674  !!$      do k = kmax, 1, -1
   675  !!$        do j = 1, jmax
   676  !!$          do i = 0, imax-1
   677  !!$            xyz_DDelLWDtCCPLV(i,j,k) = xyz_DDelLWDtCCPLV(i,j,k) + xy_NegDDelLWDt(i,j)
   678  !!$            if ( xyz_DDelLWDtCCPLV(i,j,k) < 0.0d0 ) then
   679  !!$              xy_NegDDelLWDt(i,j) = xyz_DDelLWDtCCPLV(i,j,k)
   680  !!$              xyz_DDelLWDtCCPLV(i,j,k) = 0.0d0
   681  !!$            end if
   682  !!$          end do
   683  !!$        end do
   684  !!$      end do
   685  !!$
   686  !!$      xyz_DQH2OLiqDt = xyz_DDelLWDtCCPLV / ( xyz_DelPress / Grav )
   687  !!$
   688  !!$    end if
   689  
   690  
   691      ! 計算時間計測一時停止
   692      ! Pause measurement of computation time
   693      !
   694      call TimesetClockStop( module_name )
   695  
   696    end subroutine MoistConvAdjust
   697  
   698    !--------------------------------------------------------------------------------------
   699  
   700    subroutine MoistConvAdjustChkCons(         &
   701      & xyz_TempB, xyz_TempA,                  & ! (in)
   702      & xyz_QVapB, xyz_QVapA, xyz_DelQVapCond, & ! (in)
   703      & xyz_DelMass                            & ! (in)
   704      & )
   705      !
   706      !
   707      !
   708      !
   709      !
   710  
   711      ! モジュール引用 ; USE statements
   712      !
   713  
   714      ! 物理定数設定
   715      ! Physical constants settings
   716      !
   717      use constants, only: &
   718        & CpDry, &
   719                                ! $ C_p $ [J kg-1 K-1].
   720                                ! 乾燥大気の定圧比熱.
   721                                ! Specific heat of air at constant pressure
   722        & LatentHeat
   723                                ! $ L $ [J kg-1] .
   724                                ! 凝結の潜熱.
   725                                ! Latent heat of condensation
   726  
   727      ! 宣言文 ; Declaration statements
   728      !
   729      implicit none
   730  
   731      real(DP), intent(in):: xyz_TempB(0:imax-1, 1:jmax, 1:kmax)
   732      real(DP), intent(in):: xyz_TempA(0:imax-1, 1:jmax, 1:kmax)
   733      real(DP), intent(in):: xyz_QVapB(0:imax-1, 1:jmax, 1:kmax)
   734      real(DP), intent(in):: xyz_QVapA(0:imax-1, 1:jmax, 1:kmax)
   735      real(DP), intent(in):: xyz_DelQVapCond(0:imax-1, 1:jmax, 1:kmax)
   736      real(DP), intent(in):: xyz_DelMass    (0:imax-1, 1:jmax, 1:kmax)
   737  
   738      ! 作業変数
   739      ! Work variables
   740      !
   741      real(DP) :: xy_SumB (0:imax-1, 1:jmax)
   742      real(DP) :: xy_SumA (0:imax-1, 1:jmax)
   743      real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
   744  
   745      integer:: i               ! 経度方向に回る DO ループ用作業変数
   746                                ! Work variables for DO loop in longitude
   747      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   748                                ! Work variables for DO loop in latitude
   749      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   750                                ! Work variables for DO loop in vertical direction
   751  
   752      ! 実行文 ; Executable statement
   753      !
   754  
   755      ! 初期化確認
   756      ! Initialization check
   757      !
   758      if ( .not. moist_conv_adjust_inited ) then
   759        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   760      end if
   761  
   762  
   763      ! Check conservation of moist static energy
   764      !
   765  !!$    xy_SumB = 0.0_DP
   766  !!$    xy_SumA = 0.0_DP
   767  !!$    do k = kmax, 1, -1
   768  !!$      xy_SumB = xy_SumB + CpDry * xyz_TempB(:,:,k) * xyz_DelMass(:,:,k)
   769  !!$      xy_SumA = xy_SumA + CpDry * xyz_TempA(:,:,k) * xyz_DelMass(:,:,k)
   770  !!$    end do
   771  
   772  
   773      ! Check conservation of water
   774      !
   775      xy_SumB = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t201 = 1, xy_sumb.DSC.U2*xy_sumb.DSC.U1 + xy_sumb.DSC.U2       
     .           xy_sumb(t201-1,1) = 0.0000000000000000e+000                    
     .           xy_suma(t201-1,1) = 0.0000000000000000e+000                    
     .        enddo                                                             
   776      xy_SumA = 0.0_DP
   777      do k = kmax, 1, -1
   778        xy_SumB = xy_SumB + xyz_QVapB(:,:,k) * xyz_DelMass(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sumb,xy_suma)                                           
     .        do t209 = 1, xy_sumb.DSC.U2*xy_sumb.DSC.U1 + xy_sumb.DSC.U2       
     .           xy_sumb(t209-1,1) = xy_sumb(t209-1,1) + xyz_qvapb(t209-1,1,k)* 
     .       1      xyz_delmass(t209-1,1,k)                                     
     .           xy_suma(t209-1,1) = xy_suma(t209-1,1) + xyz_qvapa(t209-1,1,k)* 
     .       1      xyz_delmass(t209-1,1,k)                                     
     .           xy_suma(t209-1,1) = xy_suma(t209-1,1) + xyz_delqvapcond(t209-1,
     .       1      1,k)*xyz_delmass(t209-1,1,k)                                
     .        enddo                                                             
   779        xy_SumA = xy_SumA + xyz_QVapA(:,:,k) * xyz_DelMass(:,:,k)
   780        xy_SumA = xy_SumA + xyz_DelQVapCond(:,:,k) * xyz_DelMass(:,:,k)
   781      end do
   782      !
   783      xy_Ratio = ( xy_SumA - xy_SumB ) / ( xy_SumA + 1.0e-100_DP )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sumb,xy_suma)                                           
     .        do t237 = 1, xy_suma.DSC.U2*xy_suma.DSC.U1 + xy_suma.DSC.U2       
     .           xy_ratio(t237-1,1) = (xy_suma(t237-1,1)-xy_sumb(t237-1,1))/(   
     .       1      xy_suma(t237-1,1)+1.00000000000000e-100)                    
     .        enddo                                                             
   784      do j = 1, jmax
   785        do i = 0, imax-1
   786          if ( abs( xy_Ratio(i,j) ) > 1.0e-10_DP ) then
   787            call MessageNotify( 'M', module_name, 'Water is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
   788          end if
   789        end do
   790      end do
   791  
   792  
   793    end subroutine MoistConvAdjustChkCons
   794  
   795    !--------------------------------------------------------------------------------------
   796  
   797    subroutine MoistConvAdjustInit
   798      !
   799      ! moist_conv_adjust モジュールの初期化を行います.
   800      ! NAMELIST#moist_conv_adjust_nml の読み込みはこの手続きで行われます.
   801      !
   802      ! "moist_conv_adjust" module is initialized.
   803      ! "NAMELIST#moist_conv_adjust_nml" is loaded in this procedure.
   804      !
   805  
   806      ! モジュール引用 ; USE statements
   807      !
   808  
   809      ! NAMELIST ファイル入力に関するユーティリティ
   810      ! Utilities for NAMELIST file input
   811      !
   812      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   813  
   814      ! ファイル入出力補助
   815      ! File I/O support
   816      !
   817      use dc_iounit, only: FileOpen
   818  
   819      ! 種別型パラメタ
   820      ! Kind type parameter
   821      !
   822      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   823  
   824      ! 文字列操作
   825      ! Character handling
   826      !
   827      use dc_string, only: StoA
   828  
   829      ! ヒストリデータ出力
   830      ! History data output
   831      !
   832      use gtool_historyauto, only: HistoryAutoAddVariable
   833  
   834      ! 飽和比湿の算出
   835      ! Evaluate saturation specific humidity
   836      !
   837      use saturate, only: SaturateInit
   838  
   839  
   840      ! 宣言文 ; Declaration statements
   841      !
   842      implicit none
   843  
   844      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   845                                ! Unit number for NAMELIST file open
   846      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   847                                ! IOSTAT of NAMELIST read
   848  
   849      ! NAMELIST 変数群
   850      ! NAMELIST group name
   851      !
   852      namelist /moist_conv_adjust_nml/ &
   853        & CrtlRH, ItrtMax, AdjustCriterion !, FlagUse
   854  
   855            ! デフォルト値については初期化手続 "moist_conv_adjust#CumAdjInit"
   856            ! のソースコードを参照のこと.
   857            !
   858            ! Refer to source codes in the initialization procedure
   859            ! "moist_conv_adjust#MoistConvAdjustInit" for the default values.
   860            !
   861  
   862      ! 実行文 ; Executable statement
   863      !
   864  
   865      if ( moist_conv_adjust_inited ) return
   866  
   867  
   868      ! デフォルト値の設定
   869      ! Default values settings
   870      !
   871      ! default values used in AGCM5
   872  !!$    CrtlRH  = 0.990_DP
   873  !!$    ItrtMax = 10
   874  !!$    AdjustCriterion(1:ItrtMax) = &
   875  !!$      & (/ 0.01_DP, 0.02_DP, 0.02_DP, 0.05_DP, 0.05_DP, &
   876  !!$      &    0.10_DP, 0.10_DP, 0.20_DP, 0.20_DP, 0.40_DP  /)
   877      !
   878      CrtlRH  = 1.0_DP
   879      ItrtMax = 10
   880      AdjustCriterion(1:ItrtMax) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir on_adb(adjustcriterion)                                           
     .        do t147 = 0, itrtmax - 1                                          
   881      !
   882  !!$    FlagUse = .true.
   883  
   884      ! NAMELIST の読み込み
   885      ! NAMELIST is input
   886      !
   887      if ( trim(namelist_filename) /= '' ) then
   888        call FileOpen( unit_nml, &          ! (out)
   889          & namelist_filename, mode = 'r' ) ! (in)
   890  
   891        rewind( unit_nml )
   892        read( unit_nml,                  &  ! (in)
   893          & nml = moist_conv_adjust_nml, &  ! (out)
   894          & iostat = iostat_nml )           ! (out)
   895        close( unit_nml )
   896  
   897        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   898  !!$      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
   899      end if
   900  
   901      ! イテレーション回数, 不安定の許容誤差のチェック
   902      ! Check number of iteration, admissible error of unstability
   903      !
   904      call NmlutilAryValid( module_name, & ! (in)
   905        & AdjustCriterion, 'AdjustCriterion', &      ! (in)
   906        & ItrtMax,    'ItrtMax' )          ! (in)
   907  
   908  
   909      ! ヒストリデータ出力のためのへの変数登録
   910      ! Register of variables for history data output
   911      !
   912      call HistoryAutoAddVariable( 'RainCumulus', &
   913        & (/ 'lon ', 'lat ', 'time' /), &
   914        & 'precipitation by cumulus scheme', 'W m-2' )
   915      call HistoryAutoAddVariable( 'DTempDtCumulus', &
   916        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   917        & 'cumulus condensation heating', 'K s-1' )
   918      call HistoryAutoAddVariable( 'DQVapDtCumulus', &
   919        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   920        & 'cumulus condensation moistening', 'kg kg-1 s-1' )
   921  
   922  
   923      ! Initialization of modules used in this module
   924      !
   925      call SaturateInit
   926  
   927  
   928      ! 印字 ; Print
   929      !
   930      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   931  !!$    call MessageNotify( 'M', module_name, '  FlagUse              = %b', l = (/ FlagUse /) )
   932      call MessageNotify( 'M', module_name, '  CrtlRH               = %f', d = (/ CrtlRH /) )
   933      call MessageNotify( 'M', module_name, '  ItrtMax              = %d', i = (/ ItrtMax /) )
   934      call MessageNotify( 'M', module_name, '  AdjustCriterion      = (/ %*r /)', &
     .  !cdir    nodep                                                          
     .  !cdir on_adb(adjustcriterion)                                           
     .        do t150 = 0, itrtmax - 1                                          
   935        & r = real( AdjustCriterion(1:ItrtMax) ), n = (/ ItrtMax /) )
   936      call MessageNotify( 'M', module_name, '' )
   937      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   938  
   939      moist_conv_adjust_inited = .true.
   940  
   941    end subroutine MoistConvAdjustInit
   942  
   943    !--------------------------------------------------------------------------------------
   944  
   945  end module moist_conv_adjust
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: moist_conv_adjust.f90
PROGRAM NAME: moist_conv_adjust
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 湿潤対流調節
     2:             !
     3:             != Moist convective adjustment
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6:             ! Version::   $Id: moist_conv_adjust.f90,v 1.10 2015/01/29 12:00:21 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module moist_conv_adjust
    13:               !
    14:               != 湿潤対流調節
    15:               !
    16:               != Moist convective adjustment
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 湿潤対流調節スキームにより, 温度と比湿を調節. 
    21:               !
    22:               ! Moist convective adjustment was originally proposed by Manabe et al. (1965).
    23:               ! But, the algorithm used in this routine seems to be different from that described by 
    24:               ! Manabe et al. (1965). 
    25:               !
    26:               ! Adjust temperature and specific humidity by 
    27:               ! convective adjustment scheme. 
    28:               !
    29:               !== Procedures List
    30:               ! 
    31:               ! MoistConvAdjust :: 温度と比湿の調節
    32:               ! --------------- :: ------------
    33:               ! MoistConvAdjust :: Adjust temperature and specific humidity
    34:               !
    35:               !== NAMELIST
    36:               !
    37:               ! NAMELIST#moist_conv_adjust_nml
    38:               !
    39:             
    40:               ! モジュール引用 ; USE statements
    41:               !
    42:             
    43:               ! 格子点設定
    44:               ! Grid points settings
    45:               !
    46:               use gridset, only: imax, & ! 経度格子点数. 
    47:                                          ! Number of grid points in longitude
    48:                 &                jmax, & ! 緯度格子点数. 
    49:                                          ! Number of grid points in latitude
    50:                 &                kmax    ! 鉛直層数. 
    51:                                          ! Number of vertical level
    52:             
    53:               ! 種別型パラメタ
    54:               ! Kind type parameter
    55:               !
    56:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    57:                 &                 STRING     ! 文字列.       Strings. 
    58:             
    59:               ! NAMELIST ファイル入力に関するユーティリティ
    60:               ! Utilities for NAMELIST file input
    61:               !
    62:               use namelist_util, only: MaxNmlArySize
    63:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    64:                                           ! Maximum size of arrays loaded from NAMELIST
    65:             
    66:               ! メッセージ出力
    67:               ! Message output
    68:               !
    69:               use dc_message, only: MessageNotify
    70:             
    71:               ! 宣言文 ; Declaration statements
    72:               !
    73:               implicit none
    74:               private
    75:             
    76:             !!$  logical, save:: FlagUse
    77:             !!$                              ! 使用フラグ
    78:             !!$                              ! flag for use of this scheme
    79:             
    80:               ! 公開手続き
    81:               ! Public procedure
    82:               !
    83:               public:: MoistConvAdjust
    84:               public:: MoistConvAdjustInit
    85:             
    86:               ! 公開変数
    87:               ! Public variables
    88:               !
    89:               logical, save :: moist_conv_adjust_inited = .false.
    90:                                           ! 初期設定フラグ. 
    91:                                           ! Initialization flag
    92:             
    93:               ! 非公開変数
    94:               ! Private variables
    95:               !
    96:               real(DP), save:: CrtlRH
    97:                                           ! 臨界相対湿度. 
    98:                                           ! Critical relative humidity
    99:               integer, save:: ItrtMax
   100:                                           ! イテレーション回数. 
   101:                                           ! Number of iteration
   102:             
   103:               real(DP), save:: AdjustCriterion(1:MaxNmlArySize)
   104:                                           ! 調節を行う基準 (湿潤静的エネルギーの差の温度換算値)
   105:                                           ! Criterion of adjustment (temperature difference 
   106:                                           ! equivalent to difference of moist static energy)
   107:             
   108:               character(*), parameter:: module_name = 'moist_conv_adjust'
   109:                                           ! モジュールの名称. 
   110:                                           ! Module name
   111:               character(*), parameter:: version = &
   112:                 & '$Name:  $' // &
   113:                 & '$Id: moist_conv_adjust.f90,v 1.10 2015/01/29 12:00:21 yot Exp $'
   114:                                           ! モジュールのバージョン
   115:                                           ! Module version
   116:             
   117:             contains
   118:             
   119:               !--------------------------------------------------------------------------------------
   120:             
   121:             !!$  subroutine MoistConvAdjust( &
   122:             !!$    & xyz_Temp, xyz_QVap, xy_Rain, &  ! (inout)
   123:             !!$    & xyz_DTempDt, xyz_DQVapDt, &     ! (inout)
   124:             !!$    & xyz_Press, xyr_Press, &         ! (in)
   125:             !!$    & xyz_DQH2OLiqDt &                ! (out)
   126:             !!$    & )
   127:               subroutine MoistConvAdjust(   &
   128:                 & xyz_Temp, xyz_QVap,       & ! (inout)
   129:                 & xyz_Press, xyr_Press,     & ! (in)
   130:                 & xyz_DQH2OLiqDt            & ! (out)
   131:                 & )
   132:                 !
   133:                 ! 湿潤対流調節スキームにより, 温度と比湿を調節. 
   134:                 !
   135:                 ! Adjust temperature and specific humidity by moist convective adjustment
   136:                 !
   137:             
   138:                 ! モジュール引用 ; USE statements
   139:                 !
   140:             
   141:                 ! 物理定数設定
   142:                 ! Physical constants settings
   143:                 !
   144:                 use constants, only: &
   145:                   & Grav, & 
   146:                                           ! $ g $ [m s-2]. 
   147:                                           ! 重力加速度. 
   148:                                           ! Gravitational acceleration
   149:                   & GasRDry, &
   150:                                           ! $ R $ [J kg-1 K-1]. 
   151:                                           ! 乾燥大気の気体定数. 
   152:                                           ! Gas constant of air
   153:                   & CpDry, &
   154:                                           ! $ C_p $ [J kg-1 K-1]. 
   155:                                           ! 乾燥大気の定圧比熱. 
   156:                                           ! Specific heat of air at constant pressure
   157:                   & LatentHeat
   158:                                           ! $ L $ [J kg-1] . 
   159:                                           ! 凝結の潜熱. 
   160:                                           ! Latent heat of condensation
   161:             
   162:                 ! 時刻管理
   163:                 ! Time control
   164:                 !
   165:                 use timeset, only: &
   166:                   & DelTime, &            ! $ \Delta t $
   167:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   168:                   & TimesetClockStart, TimesetClockStop
   169:             
   170:                 ! ヒストリデータ出力
   171:                 ! History data output
   172:                 !
   173:                 use gtool_historyauto, only: HistoryAutoPut
   174:             
   175:                 ! 飽和比湿の算出
   176:                 ! Evaluate saturation specific humidity
   177:                 !
   178:                 use saturate, only: xyz_CalcQVapSat, xy_CalcDQVapSatDTemp
   179:             
   180:             
   181:                 ! 宣言文 ; Declaration statements
   182:                 !
   183:                 implicit none
   184:             
   185:                 real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   186:                                           ! $ T $ .     温度. Temperature
   187:                 real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   188:                                           ! $ q $ .     比湿. Specific humidity
   189:             !!$    real(DP), intent(inout):: xy_Rain (0:imax-1, 1:jmax)
   190:             !!$                              ! 降水量. 
   191:             !!$                              ! Precipitation
   192:             
   193:                 real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   194:                                           ! $ p $ . 気圧 (整数レベル). 
   195:                                           ! Air pressure (full level)
   196:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   197:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   198:                                           ! Air pressure (half level)
   199:                 real(DP), intent(out):: xyz_DQH2OLiqDt(0:imax-1, 1:jmax, 1:kmax)
   200:             
   201:                 ! 作業変数
   202:                 ! Work variables
   203:                 !
   204:                 real(DP):: xy_RainCumulus (0:imax-1, 1:jmax)
   205:                                           ! 降水量. 
   206:                                           ! Precipitation
   207:                 real(DP):: xyz_DTempDtCumulus (0:imax-1, 1:jmax, 1:kmax)
   208:                                           ! 温度変化率. 
   209:                                           ! Temperature tendency
   210:                 real(DP):: xyz_DQVapDtCumulus (0:imax-1, 1:jmax, 1:kmax)
   211:                                           ! 比湿変化率. 
   212:                                           ! Specific humidity tendency
   213:             
   214:                 real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   215:                                           ! 調節前の比湿. 
   216:                                           ! Specific humidity before adjustment
   217:                 real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   218:                                           ! 調節前の温度. 
   219:                                           ! Temperature before adjustment
   220:                 logical:: xy_Adjust (0:imax-1, 1:jmax)
   221:                                           ! 今回調節されたか否か?. 
   222:                                           ! Whether it was adjusted this time or not?
   223:                 logical:: xy_AdjustB (0:imax-1, 1:jmax)
   224:                                           ! 前回調節されたか否か?. 
   225:                                           ! Whether it was adjusted last time or not?
   226:                 real(DP):: xyz_DelPress(0:imax-1, 1:jmax, 1:kmax)
   227:                                           ! $ \Delta p $
   228:                                           !
   229:                 real(DP):: xyz_DelMass  (0:imax-1, 1:jmax, 1:kmax)
   230:                                           ! $ \Delta m $
   231:                                           !
   232:                 real(DP):: xyz_QVapSat (0:imax-1, 1:jmax, 1:kmax)
   233:                                           ! 飽和比湿. 
   234:                                           ! Saturation specific humidity. 
   235:                 real(DP):: xyr_ConvAdjustFactor(0:imax-1, 1:jmax, 0:kmax)
   236:                                           ! $ \frac{1}{2} \frac{ R }{Cp} 
   237:                                           !   \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} } $
   238:             
   239:                 real(DP):: TempEquivToExcEne
   240:                                           ! Temperature equivalent to the excess moist static energy
   241:                                           ! (Moist static energy difference devided by specific heat)
   242:             
   243:                 real(DP):: DelQ
   244:                 real(DP):: DelTempUppLev
   245:                                           ! k+1 番目の層における調節による温度の変化量. 
   246:                                           ! Temperature variation by adjustment at k+1 level
   247:                 real(DP):: DelTempLowLev
   248:                                           ! k 番目の層における調節による温度の変化量. 
   249:                                           ! Temperature variation by adjustment at k level
   250:                 real(DP):: DQVapSatDTempUppLev
   251:                                           ! $ \DD{q^{*}} (k+1)}{T} $
   252:                 real(DP):: DQVapSatDTempLowLev
   253:                                           ! $ \DD{q^{*}} (k)}{T} $
   254:                 real(DP):: GamUppLev
   255:                                           ! $ \gamma_{k+1} = \frac{L}{C_p} \DP{q^{*}}{T}_{k+1} $
   256:                 real(DP):: GamLowLev
   257:                                           ! $ \gamma_{k}   = \frac{L}{C_p} \DP{q^{*}}{T}_{k} $
   258:                 logical:: Adjust
   259:                                           ! 今回全領域において一度でも調節されたか否か?. 
   260:                                           ! Whether it was adjusted even once in global 
   261:                                           ! this time or not?
   262:             
   263:                 real(DP):: TempLowLevBefAdj ! Variables for check routine
   264:                 real(DP):: TempUppLevBefAdj
   265:                 real(DP):: QVapLowLevBefAdj
   266:                 real(DP):: QVapUppLevBefAdj
   267:             
   268:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   269:                                           ! Work variables for DO loop in longitude
   270:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   271:                                           ! Work variables for DO loop in latitude
   272:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   273:                                           ! Work variables for DO loop in vertical direction
   274:                 integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
   275:                                           ! Work variables for DO loop in iteration direction
   276:             
   277:                 real(DP):: xy_DQVapSatDTempUppLev(0:imax-1, 1:jmax)
   278:                 real(DP):: xy_DQVapSatDTempLowLev(0:imax-1, 1:jmax)
   279:             
   280:                 real(DP):: ExchangeMass
   281:                                           !
   282:                                           ! Mass transport
   283:                 real(DP):: ExchangeMassDenom
   284:                                           !
   285:                                           ! Variable for mass transport calculation
   286:                 real(DP):: ExchangeMassLowLim
   287:                                           !
   288:                                           ! Lower limit of mass transport calculation
   289:                 real(DP), parameter :: ExchangeMassLowLimTempDiff = 1.0d-5
   290:                                           !
   291:                                           ! Lower limit of temperature difference
   292:                                           ! between two layers for mass transport
   293:                                           ! calculation
   294:             
   295:                 real(DP):: xyz_DelQVapCond(0:imax-1, 1:jmax, 1:kmax)
   296:                 real(DP):: DelQVapCondLowLev
   297:                 real(DP):: DelQVapCondUppLev
   298:                 real(DP):: DelQVapCond2Levs
   299:                 real(DP):: MassCor
   300:             
   301:                 real(DP):: xyz_RainCumulus (0:imax-1, 1:jmax, 1:kmax)
   302:             
   303:                 real(DP) :: xy_NegDDelLWDt   (0:imax-1, 1:jmax)
   304:                 real(DP) :: xyz_DDelLWDtCCPLV(0:imax-1, 1:jmax, 1:kmax)
   305:             
   306:             
   307:                 ! 実行文 ; Executable statement
   308:                 !
   309:             
   310:                 ! 初期化確認
   311:                 ! Initialization check
   312:                 !
   313:                 if ( .not. moist_conv_adjust_inited ) then
   314:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   315:                 end if
   316:             
   317:             !!$    if ( .not. FlagUse ) return
   318:             
   319:             
   320:                 ! 計算時間計測開始
   321:                 ! Start measurement of computation time
   322:                 !
   323:                 call TimesetClockStart( module_name )
   324:             
   325:             
   326:                 ! 調節前 "QVap", "Temp" の保存
   327:                 ! Store "QVap", "Temp" before adjustment
   328:                 !
   329: **V---->A       xyz_QVapB = xyz_QVap
   330: |||     A       xyz_TempB = xyz_Temp
   331: |||         
   332: |||             ! 飽和比湿計算
   333: |||             ! Calculate saturation specific humidity
   334: |||             !
   335: **V---- A       xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   336:             
   337:                 ! Calculate some values used for moist convective adjustment
   338:                 !
   339:             
   340: W------>        do k = 1, kmax
   341: |**==== A         xyz_DelPress(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
   342: W------         end do
   343: W**==== A       xyz_DelMass = xyz_DelPress / Grav
   344:             
   345:                 ! \frac{1}{2} \frac{ R }{Cp} \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} }
   346:                 !
   347:                 !   The value at k = 0 is not used.
   348:                 k = 0
   349: W*=====         xyr_ConvAdjustFactor(:,:,k) = 0.0_DP
   350:                 !
   351: +------>        do k = 1, kmax-1
   352: |+V==== A         xyr_ConvAdjustFactor(:,:,k) =                     &
   353: |                   & GasRDry / CpDry                               &
   354: |                   &   * ( xyz_Press(:,:,k) - xyz_Press(:,:,k+1) ) &
   355: |                   &   / xyr_Press(:,:,k) / 2.0_DP
   356: +------         end do
   357:                 !   The value at k = kmax is not used.
   358:                 k = kmax
   359: W*=====         xyr_ConvAdjustFactor(:,:,k) = 0.0_DP
   360:             
   361:             
   362:                 !
   363:                 ! Initialization
   364:                 !
   365: W**==== A       xyz_DelQVapCond = 0.0_DP
   366:             
   367:                 ! 調節
   368:                 ! Adjustment
   369:                 !
   370: W*=====         xy_AdjustB = .true.
   371:             
   372:                 ! 繰り返し
   373:                 ! Iteration
   374:                 !
   375: +------>        do itr = 1, ItrtMax
   376: |W*====           xy_Adjust = .false.
   377: |           
   378: |+----->          do k = 1, kmax-1
   379: ||          
   380: ||                  xy_DQVapSatDTempUppLev = &
   381: ||                    & xy_CalcDQVapSatDTemp( xyz_Temp(:,:,k+1), xyz_QVapSat(:,:,k+1) )
   382: ||                  xy_DQVapSatDTempLowLev = &
   383: ||                    & xy_CalcDQVapSatDTemp( xyz_Temp(:,:,k  ), xyz_QVapSat(:,:,k  ) )
   384: ||          
   385: ||+---->            do j = 1, jmax
   386: |||V--->              do i = 0, imax-1
   387: ||||                    if ( xy_AdjustB(i,j) ) then
   388: ||||        
   389: ||||                      ! Temperature equivalent to the excess moist static energy
   390: ||||                      ! (Moist static energy difference devided by specific heat)
   391: ||||                      !
   392: ||||    A                 TempEquivToExcEne = &
   393: ||||                        &   xyz_Temp(i,j,k) - xyz_Temp(i,j,k+1)                                &
   394: ||||                        & + LatentHeat / CpDry * ( xyz_QVapSat(i,j,k) - xyz_QVapSat(i,j,k+1) ) &
   395: ||||                        & - xyr_ConvAdjustFactor(i,j,k) * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
   396: ||||        
   397: ||||                      ! Check vertical gradient of moist static energy
   398: ||||                      !
   399: ||||                      if ( TempEquivToExcEne > AdjustCriterion(itr) ) then
   400: ||||        
   401: ||||                        ! Check relative humidity
   402: ||||                        !
   403: ||||    A                   if ( ( xyz_QVap(i,j,k+1) / xyz_QVapSat(i,j,k+1) >= CrtlRH ) &
   404: ||||                          &  .and.                                                  &
   405: ||||                          &  ( xyz_QVap(i,j,k  ) / xyz_QVapSat(i,j,k  ) >= CrtlRH ) &
   406: ||||                          &) then
   407: ||||        
   408: ||||                          DelQ =                                                 &
   409: ||||                            &   xyz_DelPress(i,j,k  )                            &
   410: ||||                            &     * ( xyz_QVap(i,j,k  ) - xyz_QVapSat(i,j,k  ) ) &
   411: ||||                            & + xyz_DelPress(i,j,k+1)                            &
   412: ||||                            &     * ( xyz_QVap(i,j,k+1) - xyz_QVapSat(i,j,k+1) )
   413: ||||        
   414: ||||                          DQVapSatDTempUppLev = xy_DQVapSatDTempUppLev(i,j)
   415: ||||                          DQVapSatDTempLowLev = xy_DQVapSatDTempLowLev(i,j)
   416: ||||        
   417: ||||    A                     GamUppLev = LatentHeat / CpDry * DQVapSatDTempUppLev
   418: ||||    A                     GamLowLev = LatentHeat / CpDry * DQVapSatDTempLowLev
   419: ||||        
   420: ||||                          DelTempUppLev =                                                       &
   421: ||||                            & (                                                                 &
   422: ||||                            &     xyz_DelPress(i,j,k) * ( 1.0_DP + GamLowLev )                   &
   423: ||||                            &       * TempEquivToExcEne                                         &
   424: ||||                            &   + ( 1.0_DP + GamLowLev - xyr_ConvAdjustFactor(i,j,k) )           &
   425: ||||                            &       * LatentHeat / CpDry * DelQ                                 &
   426: ||||                            & )                                                                 &
   427: ||||                            & / ( xyr_ConvAdjustFactor(i,j,k)                                   &
   428: ||||                            &       * ( xyz_DelPress(i,j,k  ) * ( 1.0_DP + GamLowLev )           &
   429: ||||                            &         - xyz_DelPress(i,j,k+1) * ( 1.0_DP + GamUppLev ) )         &
   430: ||||                            &     + ( 1.0_DP + GamLowLev ) * ( 1.0_DP + GamUppLev )               &
   431: ||||                            &       * ( xyz_DelPress(i,j,k) + xyz_DelPress(i,j,k+1) ) )
   432: ||||        
   433: ||||                          DelTempLowLev =                                                       &
   434: ||||                            &   ( LatentHeat / CpDry * DelQ                                     &
   435: ||||                            &     - xyz_DelPress(i,j,k+1)                                       &
   436: ||||                            &         * ( 1.0_DP + GamUppLev ) * DelTempUppLev )                 &
   437: ||||                            & / ( ( 1.0_DP + GamLowLev ) * xyz_DelPress(i,j,k) )
   438: ||||        
   439: ||||        
   440: ||||                          !=========
   441: ||||                          TempLowLevBefAdj = xyz_Temp(i,j,k  )
   442: ||||                          TempUppLevBefAdj = xyz_Temp(i,j,k+1)
   443: ||||                          QVapLowLevBefAdj = xyz_QVap(i,j,k  )
   444: ||||                          QVapUppLevBefAdj = xyz_QVap(i,j,k+1)
   445: ||||                          !=========
   446: ||||        
   447: ||||        
   448: ||||                          ! 温度の調節
   449: ||||                          ! Adjust temperature
   450: ||||                          !
   451: ||||    A                     xyz_Temp(i,j,k  ) = xyz_Temp(i,j,k  ) + DelTempLowLev
   452: ||||    A                     xyz_Temp(i,j,k+1) = xyz_Temp(i,j,k+1) + DelTempUppLev
   453: ||||    A   
   454: ||||    A                     ! 比湿の調節
   455: ||||    A                     ! Adjust specific humidity
   456: ||||    A                     !
   457: ||||    A                     xyz_QVap(i,j,k  ) = &
   458: ||||                            &   xyz_QVapSat(i,j,k  ) + DQVapSatDTempLowLev * DelTempLowLev
   459: ||||    A                     xyz_QVap(i,j,k+1) = &
   460: ||||                            &   xyz_QVapSat(i,j,k+1) + DQVapSatDTempUppLev * DelTempUppLev
   461: ||||        
   462: ||||        
   463: ||||                          !
   464: ||||                          ! Mass exchange
   465: ||||                          !   Denominator
   466: ||||    A                     ExchangeMassDenom =                                      &
   467: ||||                            &   CpDry * ( TempLowLevBefAdj - TempUppLevBefAdj )    &
   468: ||||                            & - GasRDry                                            &
   469: ||||                            &   * ( TempLowLevBefAdj + TempUppLevBefAdj ) / 2.0_DP &
   470: ||||                            &   / xyr_Press(i,j,k)                                 &
   471: ||||                            &   * ( xyz_Press(i,j,k) - xyz_Press(i,j,k+1) )        &
   472: ||||                            & + LatentHeat * ( QVapLowLevBefAdj - QVapUppLevBefAdj )
   473: ||||                          ExchangeMassLowLim = CpDry * ExchangeMassLowLimTempDiff
   474: ||||                          ! If a static energy difference between two layers is smaller
   475: ||||                          ! than a specified lower limit, momentum and mixing ratio are
   476: ||||                          ! not mixed to ensure numerical stability.
   477: ||||                          ! If the lower limit is zero, some calculations are unstable.
   478: ||||                          ! (yot, 2013/10/02)
   479: ||||                          if ( ExchangeMassDenom > ExchangeMassLowLim ) then
   480: ||||    A                       ExchangeMass =                                     &
   481: ||||                              & - (   CpDry * DelTempLowLev                    &
   482: ||||                              &     + LatentHeat * ( xyz_QVap(i,j,k) - QVapLowLevBefAdj ) ) &
   483: ||||                              &   / ExchangeMassDenom  &
   484: ||||                              &     * xyz_DelMass(i,j,k)
   485: ||||                          else
   486: ||||                            ExchangeMass = 0.0_DP
   487: ||||                          end if
   488: ||||                          !   Limitation of amount of mass exchange not to
   489: ||||                          !   reverse a gradient
   490: ||||    A                     ExchangeMass = &
   491: ||||                            & min( ExchangeMass,                                      &
   492: ||||                            &      xyz_DelMass(i,j,k) * xyz_DelMass(i,j,k+1)          &
   493: ||||                            &        / ( xyz_DelMass(i,j,k) + xyz_DelMass(i,j,k+1) )  &
   494: ||||                            &    )
   495: ||||        
   496: ||||    A                     DelQVapCondLowLev =                           &
   497: ||||                            &   ( QVapUppLevBefAdj - QVapLowLevBefAdj ) &
   498: ||||                            &   * ExchangeMass / xyz_DelMass(i,j,k  )   &
   499: ||||                            & - ( xyz_QVap(i,j,k  ) - QVapLowLevBefAdj )
   500: ||||    A                     DelQVapCondUppLev =                           &
   501: ||||                            & - ( QVapUppLevBefAdj - QVapLowLevBefAdj ) &
   502: ||||                            &   * ExchangeMass / xyz_DelMass(i,j,k+1)   &
   503: ||||                            & - ( xyz_QVap(i,j,k+1) - QVapUppLevBefAdj )
   504: ||||        
   505: ||||                          ! Check
   506: ||||                          DelQVapCond2Levs = &
   507: ||||                            &   DelQVapCondLowLev * xyz_DelMass(i,j,k  ) &
   508: ||||                            & + DelQVapCondUppLev * xyz_DelMass(i,j,k+1)
   509: ||||                          if ( DelQVapCond2Levs < 0.0_DP ) then
   510: ||||        !!$                    call MessageNotify( 'M', module_name, &
   511: ||||        !!$                      & 'Condensation amount is negative, %f.', &
   512: ||||        !!$                      & d = (/ DelQVapCond2Levs /) )
   513: ||||                          else
   514: ||||                            if ( DelQVapCondLowLev < 0.0_DP ) then
   515: ||||                              MassCor = - DelQVapCondLowLev * xyz_DelMass(i,j,k  )
   516: ||||                              DelQVapCondLowLev = 0.0_DP
   517: ||||                              DelQVapCondUppLev =                                       &
   518: ||||                                & ( DelQVapCondUppLev * xyz_DelMass(i,j,k+1) - MassCor )&
   519: ||||                                & / xyz_DelMass(i,j,k+1)
   520: ||||                            end if
   521: ||||                            if ( DelQVapCondUppLev < 0.0_DP ) then
   522: ||||    A                         MassCor = - DelQVapCondUppLev * xyz_DelMass(i,j,k+1)
   523: ||||    A                         DelQVapCondLowLev =                                       &
   524: ||||                                & ( DelQVapCondLowLev * xyz_DelMass(i,j,k  ) - MassCor )&
   525: ||||                                & / xyz_DelMass(i,j,k  )
   526: ||||                              DelQVapCondUppLev = 0.0_DP
   527: ||||                            end if
   528: ||||                          end if
   529: ||||        
   530: ||||    A                     xyz_DelQVapCond(i,j,k  ) = xyz_DelQVapCond(i,j,k  ) &
   531: ||||                            & + DelQVapCondLowLev
   532: ||||    A                     xyz_DelQVapCond(i,j,k+1) = xyz_DelQVapCond(i,j,k+1) &
   533: ||||                            & + DelQVapCondUppLev
   534: ||||        
   535: ||||        
   536: ||||                          !=========
   537: ||||                          ! check routine
   538: ||||                          !---------
   539: ||||        !!$                  write( 6, * ) '====='
   540: ||||        !!$                  write( 6, * ) xyz_Temp(i,j,k), xyz_Temp(i,j,k+1), xyz_QVap(i,j,k), xyz_QVap(i,j,k+1)
   541: ||||        !!$                  write( 6, * ) DelTempLowLev, DelTempUppLev
   542: ||||        !!$                  write( 6, * ) 'Energy difference before and after adjustment and each energy'
   543: ||||        !!$                  write( 6, * ) &
   544: ||||        !!$                    &   ( CpDry * TempLowLevBefAdj  + LatentHeat * QVapLowLevBefAdj )  &
   545: ||||        !!$                    &     * xyz_DelPress(i,j,k  ) / Grav                               &
   546: ||||        !!$                    & + ( CpDry * TempUppLevBefAdj  + LatentHeat * QVapUppLevBefAdj )  &
   547: ||||        !!$                    &     * xyz_DelPress(i,j,k+1) / Grav                               &
   548: ||||        !!$                    & - ( CpDry * xyz_Temp(i,j,k  ) + LatentHeat * xyz_QVap(i,j,k  ) ) &
   549: ||||        !!$                    &     * xyz_DelPress(i,j,k  ) / Grav                               &
   550: ||||        !!$                    & - ( CpDry * xyz_Temp(i,j,k+1) + LatentHeat * xyz_QVap(i,j,k+1) ) &
   551: ||||        !!$                    &     * xyz_DelPress(i,j,k+1) / Grav,                              &
   552: ||||        !!$                    &   ( CpDry * TempLowLevBefAdj  + LatentHeat * QVapLowLevBefAdj )  &
   553: ||||        !!$                    &     * xyz_DelPress(i,j,k  ) / Grav,                              &
   554: ||||        !!$                    &   ( CpDry * TempUppLevBefAdj  + LatentHeat * QVapUppLevBefAdj )  &
   555: ||||        !!$                    &     * xyz_DelPress(i,j,k+1) / Grav,                              &
   556: ||||        !!$                    &   ( CpDry * xyz_Temp(i,j,k  ) + LatentHeat * xyz_QVap(i,j,k  ) ) &
   557: ||||        !!$                    &     * xyz_DelPress(i,j,k  ) / Grav,                              &
   558: ||||        !!$                    &   ( CpDry * xyz_Temp(i,j,k+1) + LatentHeat * xyz_QVap(i,j,k+1) ) &
   559: ||||        !!$                    &     * xyz_DelPress(i,j,k+1) / Grav
   560: ||||        !!$                  write( 6, * ) 'Difference of moist static energy after adjustment'
   561: ||||        !!$                  write( 6, * ) &
   562: ||||        !!$                    &   ( CpDry * xyz_Temp(i,j,k  ) + LatentHeat * xyz_QVap(i,j,k  ) )  &
   563: ||||        !!$                    & - ( CpDry * xyz_Temp(i,j,k+1) + LatentHeat * xyz_QVap(i,j,k+1) )  &
   564: ||||        !!$                    & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
   565: ||||        !!$                    &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) ),                      &
   566: ||||        !!$                    &   ( CpDry * xyz_Temp(i,j,k  ) + LatentHeat * xyz_QVap(i,j,k  ) ), &
   567: ||||        !!$                    &   ( CpDry * xyz_Temp(i,j,k+1) + LatentHeat * xyz_QVap(i,j,k+1) ), &
   568: ||||        !!$                    & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
   569: ||||        !!$                    &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
   570: ||||        !!$                  write( 6, * ) 'Difference of water vapor amount before and after adjustment'
   571: ||||        !!$                  write( 6, * ) &
   572: ||||        !!$                    & - LatentHeat * ( xyz_QVap(i,j,k  ) - QVapLowLevBefAdj ) &
   573: ||||        !!$                    & * xyz_DelPress(i,j,k  ) / Grav,                       &
   574: ||||        !!$                    & - LatentHeat * ( xyz_QVap(i,j,k+1) - QVapUppLevBefAdj ) &
   575: ||||        !!$                    & * xyz_DelPress(i,j,k+1) / Grav
   576: ||||                          !=========
   577: ||||        
   578: ||||        
   579: ||||    A                     xyz_QVapSat(i,j,k  ) = xyz_QVap(i,j,k  )
   580: ||||    A                     xyz_QVapSat(i,j,k+1) = xyz_QVap(i,j,k+1)
   581: ||||        
   582: ||||                          ! 調節したか否か?
   583: ||||                          ! Whether it was adjusted or not?
   584: ||||                          !
   585: ||||                          xy_Adjust(i,j) = .true.
   586: ||||                        end if
   587: ||||        
   588: ||||                      end if
   589: ||||        
   590: ||||                    end if
   591: |||V---               end do
   592: ||+----             end do
   593: |+-----           end do
   594: |           
   595: |                 Adjust = .false.
   596: |+----->          do i = 0, imax-1
   597: ||+---->            do j = 1, jmax
   598: |||                   xy_AdjustB(i,j) = xy_Adjust(i,j)
   599: |||                   Adjust          = Adjust .or. xy_Adjust(i,j)
   600: ||+----             end do
   601: |+-----           end do
   602: |           
   603: |                 if ( .not. Adjust ) exit
   604: |           
   605: +------         end do
   606:             
   607:             
   608:                 call MoistConvAdjustChkCons(              &
   609:                   & xyz_TempB, xyz_Temp,                  & ! (in)
   610:                   & xyz_QVapB, xyz_QVap, xyz_DelQVapCond, & ! (in)
   611:                   & xyz_DelMass                           & ! (in)
   612:                   & )
   613:             
   614:             
   615:                 ! 比湿変化率, 温度変化率, 降水量の算出
   616:                 ! Calculate specific humidity tendency, temperature tendency, precipitation
   617:                 !
   618: **W---->A       xyz_DQVapDtCumulus = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
   619: |||         
   620: |||     A       xyz_DTempDtCumulus = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   621: |||         
   622: |||             ! old
   623: |||         !!$    xyz_DQH2OLiqDt = ( xyz_QVapB - xyz_QVap ) / ( 2.0_DP * DelTime )
   624: |||             ! new (2014/12/04)
   625: |||     A       xyz_DQH2OLiqDt = xyz_DelQVapCond / ( 2.0_DP * DelTime )
   626: |||             !   avoid negative cloud amount
   627: |||             xyz_DQH2OLiqDt = max( xyz_DQH2OLiqDt, 0.0_DP )
   628: |||         
   629: |||         !!$    xyz_RainCumulus = xyz_DQH2OLiqDt * xyz_DelPress / Grav
   630: |||         !!$    xy_RainCumulus = 0.0d0
   631: |||         !!$    do k = kmax, 1, -1
   632: |||         !!$      xy_RainCumulus = xy_RainCumulus + xyz_RainCumulus(:,:,k)
   633: |||         !!$    end do
   634: |||         
   635: |||         
   636: |||         !!$    j = jmax/2+1
   637: |||         !!$    do i = 0, imax-1
   638: |||         !!$      if ( xy_RainCumulus(i,j) /= 0.0d0 ) then
   639: |||         !!$        write( 6, * ) xy_RainCumulus(i,j)
   640: |||         !!$      end if
   641: |||         !!$    end do
   642: |||         !!$    write( 6, * ) '---'
   643: |||         
   644: |||         
   645: |||         !!$    xy_Rain     = xy_Rain     + xy_RainCumulus
   646: |||         
   647: |||         
   648: |||             ! calculation for output (tentative)
   649: **W----         xyz_RainCumulus = xyz_DQH2OLiqDt * xyz_DelPress / Grav
   650: W*=====         xy_RainCumulus = 0.0_DP
   651: +------>        do k = kmax, 1, -1
   652: |W*==== A         xy_RainCumulus = xy_RainCumulus + xyz_RainCumulus(:,:,k)
   653: +------         end do
   654:             
   655:             
   656:                 ! ヒストリデータ出力
   657:                 ! History data output
   658:                 !
   659: +V===== A       call HistoryAutoPut( TimeN, 'RainCumulus',    xy_RainCumulus * LatentHeat )
   660:                 call HistoryAutoPut( TimeN, 'DTempDtCumulus', xyz_DTempDtCumulus )
   661:                 call HistoryAutoPut( TimeN, 'DQVapDtCumulus', xyz_DQVapDtCumulus )
   662:             
   663:             
   664:             
   665:             !!$    if ( present( xyz_DQH2OLiqDt ) ) then
   666:             !!$
   667:             !!$      xyz_DDelLWDtCCPLV = &
   668:             !!$        & + ( xyz_QVapB - xyz_QVap ) &
   669:             !!$        &       * xyz_DelPress / Grav / ( 2.0d0 * DelTime )
   670:             !!$
   671:             !!$      ! Negative cloud production rate is filled with values in lower layers.
   672:             !!$      !
   673:             !!$      xy_NegDDelLWDt = 0.0d0
   674:             !!$      do k = kmax, 1, -1
   675:             !!$        do j = 1, jmax
   676:             !!$          do i = 0, imax-1
   677:             !!$            xyz_DDelLWDtCCPLV(i,j,k) = xyz_DDelLWDtCCPLV(i,j,k) + xy_NegDDelLWDt(i,j)
   678:             !!$            if ( xyz_DDelLWDtCCPLV(i,j,k) < 0.0d0 ) then
   679:             !!$              xy_NegDDelLWDt(i,j) = xyz_DDelLWDtCCPLV(i,j,k) 
   680:             !!$              xyz_DDelLWDtCCPLV(i,j,k) = 0.0d0
   681:             !!$            end if
   682:             !!$          end do
   683:             !!$        end do
   684:             !!$      end do
   685:             !!$
   686:             !!$      xyz_DQH2OLiqDt = xyz_DDelLWDtCCPLV / ( xyz_DelPress / Grav )
   687:             !!$
   688:             !!$    end if
   689:             
   690:             
   691:                 ! 計算時間計測一時停止
   692:                 ! Pause measurement of computation time
   693:                 !
   694:                 call TimesetClockStop( module_name )
   695:             
   696:               end subroutine MoistConvAdjust
   697:             
   698:               !--------------------------------------------------------------------------------------
   699:             
   700:               subroutine MoistConvAdjustChkCons(         &
   701:                 & xyz_TempB, xyz_TempA,                  & ! (in)
   702:                 & xyz_QVapB, xyz_QVapA, xyz_DelQVapCond, & ! (in)
   703:                 & xyz_DelMass                            & ! (in)
   704:                 & )
   705:                 !
   706:                 !
   707:                 !
   708:                 !
   709:                 !
   710:             
   711:                 ! モジュール引用 ; USE statements
   712:                 !
   713:             
   714:                 ! 物理定数設定
   715:                 ! Physical constants settings
   716:                 !
   717:                 use constants, only: &
   718:                   & CpDry, &
   719:                                           ! $ C_p $ [J kg-1 K-1]. 
   720:                                           ! 乾燥大気の定圧比熱. 
   721:                                           ! Specific heat of air at constant pressure
   722:                   & LatentHeat
   723:                                           ! $ L $ [J kg-1] . 
   724:                                           ! 凝結の潜熱. 
   725:                                           ! Latent heat of condensation
   726:             
   727:                 ! 宣言文 ; Declaration statements
   728:                 !
   729:                 implicit none
   730:             
   731:                 real(DP), intent(in):: xyz_TempB(0:imax-1, 1:jmax, 1:kmax)
   732:                 real(DP), intent(in):: xyz_TempA(0:imax-1, 1:jmax, 1:kmax)
   733:                 real(DP), intent(in):: xyz_QVapB(0:imax-1, 1:jmax, 1:kmax)
   734:                 real(DP), intent(in):: xyz_QVapA(0:imax-1, 1:jmax, 1:kmax)
   735:                 real(DP), intent(in):: xyz_DelQVapCond(0:imax-1, 1:jmax, 1:kmax)
   736:                 real(DP), intent(in):: xyz_DelMass    (0:imax-1, 1:jmax, 1:kmax)
   737:             
   738:                 ! 作業変数
   739:                 ! Work variables
   740:                 !
   741:                 real(DP) :: xy_SumB (0:imax-1, 1:jmax)
   742:                 real(DP) :: xy_SumA (0:imax-1, 1:jmax)
   743:                 real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
   744:             
   745:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   746:                                           ! Work variables for DO loop in longitude
   747:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   748:                                           ! Work variables for DO loop in latitude
   749:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   750:                                           ! Work variables for DO loop in vertical direction
   751:             
   752:                 ! 実行文 ; Executable statement
   753:                 !
   754:             
   755:                 ! 初期化確認
   756:                 ! Initialization check
   757:                 !
   758:                 if ( .not. moist_conv_adjust_inited ) then
   759:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   760:                 end if
   761:             
   762:             
   763:                 ! Check conservation of moist static energy
   764:                 !
   765:             !!$    xy_SumB = 0.0_DP
   766:             !!$    xy_SumA = 0.0_DP
   767:             !!$    do k = kmax, 1, -1
   768:             !!$      xy_SumB = xy_SumB + CpDry * xyz_TempB(:,:,k) * xyz_DelMass(:,:,k)
   769:             !!$      xy_SumA = xy_SumA + CpDry * xyz_TempA(:,:,k) * xyz_DelMass(:,:,k)
   770:             !!$    end do
   771:             
   772:             
   773:                 ! Check conservation of water
   774:                 !
   775: *W----->        xy_SumB = 0.0_DP
   776: *W-----         xy_SumA = 0.0_DP
   777: +------>        do k = kmax, 1, -1
   778: |*W---->A         xy_SumB = xy_SumB + xyz_QVapB(:,:,k) * xyz_DelMass(:,:,k)
   779: |||     A         xy_SumA = xy_SumA + xyz_QVapA(:,:,k) * xyz_DelMass(:,:,k)
   780: |*W---- A         xy_SumA = xy_SumA + xyz_DelQVapCond(:,:,k) * xyz_DelMass(:,:,k)
   781: +------         end do
   782:                 !
   783: W*===== A       xy_Ratio = ( xy_SumA - xy_SumB ) / ( xy_SumA + 1.0e-100_DP )
   784: +------>        do j = 1, jmax
   785: |+----->          do i = 0, imax-1
   786: ||                  if ( abs( xy_Ratio(i,j) ) > 1.0e-10_DP ) then
   787: ||                    call MessageNotify( 'M', module_name, 'Water is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
   788: ||                  end if
   789: |+-----           end do
   790: +------         end do
   791:             
   792:             
   793:               end subroutine MoistConvAdjustChkCons
   794:             
   795:               !--------------------------------------------------------------------------------------
   796:             
   797:               subroutine MoistConvAdjustInit
   798:                 !
   799:                 ! moist_conv_adjust モジュールの初期化を行います. 
   800:                 ! NAMELIST#moist_conv_adjust_nml の読み込みはこの手続きで行われます. 
   801:                 !
   802:                 ! "moist_conv_adjust" module is initialized. 
   803:                 ! "NAMELIST#moist_conv_adjust_nml" is loaded in this procedure. 
   804:                 !
   805:             
   806:                 ! モジュール引用 ; USE statements
   807:                 !
   808:             
   809:                 ! NAMELIST ファイル入力に関するユーティリティ
   810:                 ! Utilities for NAMELIST file input
   811:                 !
   812:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   813:             
   814:                 ! ファイル入出力補助
   815:                 ! File I/O support
   816:                 !
   817:                 use dc_iounit, only: FileOpen
   818:             
   819:                 ! 種別型パラメタ
   820:                 ! Kind type parameter
   821:                 !
   822:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   823:             
   824:                 ! 文字列操作
   825:                 ! Character handling
   826:                 !
   827:                 use dc_string, only: StoA
   828:             
   829:                 ! ヒストリデータ出力
   830:                 ! History data output
   831:                 !
   832:                 use gtool_historyauto, only: HistoryAutoAddVariable
   833:             
   834:                 ! 飽和比湿の算出
   835:                 ! Evaluate saturation specific humidity
   836:                 !
   837:                 use saturate, only: SaturateInit
   838:             
   839:             
   840:                 ! 宣言文 ; Declaration statements
   841:                 !
   842:                 implicit none
   843:             
   844:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   845:                                           ! Unit number for NAMELIST file open
   846:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   847:                                           ! IOSTAT of NAMELIST read
   848:             
   849:                 ! NAMELIST 変数群
   850:                 ! NAMELIST group name
   851:                 !
   852:                 namelist /moist_conv_adjust_nml/ &
   853:                   & CrtlRH, ItrtMax, AdjustCriterion !, FlagUse
   854:             
   855:                       ! デフォルト値については初期化手続 "moist_conv_adjust#CumAdjInit" 
   856:                       ! のソースコードを参照のこと. 
   857:                       !
   858:                       ! Refer to source codes in the initialization procedure
   859:                       ! "moist_conv_adjust#MoistConvAdjustInit" for the default values. 
   860:                       !
   861:             
   862:                 ! 実行文 ; Executable statement
   863:                 !
   864:             
   865:                 if ( moist_conv_adjust_inited ) return
   866:             
   867:             
   868:                 ! デフォルト値の設定
   869:                 ! Default values settings
   870:                 !
   871:                 ! default values used in AGCM5
   872:             !!$    CrtlRH  = 0.990_DP
   873:             !!$    ItrtMax = 10
   874:             !!$    AdjustCriterion(1:ItrtMax) = &
   875:             !!$      & (/ 0.01_DP, 0.02_DP, 0.02_DP, 0.05_DP, 0.05_DP, &
   876:             !!$      &    0.10_DP, 0.10_DP, 0.20_DP, 0.20_DP, 0.40_DP  /)
   877:                 !
   878:                 CrtlRH  = 1.0_DP
   879:                 ItrtMax = 10
   880: V====== A       AdjustCriterion(1:ItrtMax) = 0.0_DP
   881:                 !
   882:             !!$    FlagUse = .true.
   883:             
   884:                 ! NAMELIST の読み込み
   885:                 ! NAMELIST is input
   886:                 !
   887:                 if ( trim(namelist_filename) /= '' ) then
   888:                   call FileOpen( unit_nml, &          ! (out)
   889:                     & namelist_filename, mode = 'r' ) ! (in)
   890:             
   891:                   rewind( unit_nml )
   892:                   read( unit_nml,                  &  ! (in)
   893:                     & nml = moist_conv_adjust_nml, &  ! (out)
   894:                     & iostat = iostat_nml )           ! (out)
   895:                   close( unit_nml )
   896:             
   897:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   898:             !!$      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
   899:                 end if
   900:             
   901:                 ! イテレーション回数, 不安定の許容誤差のチェック
   902:                 ! Check number of iteration, admissible error of unstability
   903:                 !
   904:                 call NmlutilAryValid( module_name, & ! (in)
   905:                   & AdjustCriterion, 'AdjustCriterion', &      ! (in)
   906:                   & ItrtMax,    'ItrtMax' )          ! (in)
   907:             
   908:             
   909:                 ! ヒストリデータ出力のためのへの変数登録
   910:                 ! Register of variables for history data output
   911:                 !
   912:                 call HistoryAutoAddVariable( 'RainCumulus', &
   913:                   & (/ 'lon ', 'lat ', 'time' /), &
   914:                   & 'precipitation by cumulus scheme', 'W m-2' )
   915:                 call HistoryAutoAddVariable( 'DTempDtCumulus', &
   916:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   917:                   & 'cumulus condensation heating', 'K s-1' )
   918:                 call HistoryAutoAddVariable( 'DQVapDtCumulus', &
   919:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   920:                   & 'cumulus condensation moistening', 'kg kg-1 s-1' )
   921:             
   922:             
   923:                 ! Initialization of modules used in this module
   924:                 !
   925:                 call SaturateInit
   926:             
   927:             
   928:                 ! 印字 ; Print
   929:                 !
   930:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   931:             !!$    call MessageNotify( 'M', module_name, '  FlagUse              = %b', l = (/ FlagUse /) )
   932:                 call MessageNotify( 'M', module_name, '  CrtlRH               = %f', d = (/ CrtlRH /) )
   933:                 call MessageNotify( 'M', module_name, '  ItrtMax              = %d', i = (/ ItrtMax /) )
   934: V====== A       call MessageNotify( 'M', module_name, '  AdjustCriterion      = (/ %*r /)', &
   935:                   & r = real( AdjustCriterion(1:ItrtMax) ), n = (/ ItrtMax /) )
   936:                 call MessageNotify( 'M', module_name, '' )
   937:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   938:             
   939:                 moist_conv_adjust_inited = .true.
   940:             
   941:               end subroutine MoistConvAdjustInit
   942:             
   943:               !--------------------------------------------------------------------------------------
   944:             
   945:             end module moist_conv_adjust
