Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:46 2016
FILE NAME: dry_conv_adjust.f90
PROGRAM NAME: dry_conv_adjust
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   297  opt  (1593): Loop nest collapsed into one loop.
   297  vec  (   4): Vectorized array expression.
   297  vec  (  29): ADB is used for array.: xyz_temp
   302  opt  (1593): Loop nest collapsed into one loop.
   302  vec  (   1): Vectorized loop.
   302  vec  (  29): ADB is used for array.: xyr_press
   305  opt  (1593): Loop nest collapsed into one loop.
   305  vec  (   4): Vectorized array expression.
   311  opt  (1593): Loop nest collapsed into one loop.
   311  vec  (   4): Vectorized array expression.
   313  opt  (1593): Loop nest collapsed into one loop.
   313  vec  (   1): Vectorized loop.
   313  vec  (  29): ADB is used for array.: xyr_press
   313  vec  (  29): ADB is used for array.: xyz_press
   321  opt  (1593): Loop nest collapsed into one loop.
   321  vec  (   4): Vectorized array expression.
   327  opt  (1593): Loop nest collapsed into one loop.
   327  vec  (   4): Vectorized array expression.
   333  opt  (1593): Loop nest collapsed into one loop.
   333  vec  (   4): Vectorized array expression.
   337  vec  (   3): Unvectorized loop.
   337  vec  (  13): Overhead of loop division is too large.
   467  opt  (  11): Fused array assignments. :line 467 - 477
   467  vec  (   4): Vectorized array expression.
   467  vec  (  29): ADB is used for array.: xyzf_qmix
   483  opt  (1059): Unable to determine last value of scalar temporary.
   494  vec  (   3): Unvectorized loop.
   494  vec  (  13): Overhead of loop division is too large.
   496  opt  (1019): Feedback of scalar value from one loop pass to another.
   496  opt  (1019): Feedback of scalar value from one loop pass to another.
   496  vec  (  21): Unvectorizable dependency.
   507  opt  (1593): Loop nest collapsed into one loop.
   507  vec  (   4): Vectorized array expression.
   507  vec  (  29): ADB is used for array.: xyz_dtempdt
   507  vec  (  29): ADB is used for array.: xyz_temp
   602  vec  (   4): Vectorized array expression.
   602  vec  (  29): ADB is used for array.: adjustcriterion
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:46 2016
FILE NAME: dry_conv_adjust.f90
PROGRAM NAME: dry_conv_adjust
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 乾燥対流調節
     2  !
     3  != Dry convective adjustment
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6  ! Version::   $Id: dry_conv_adjust.f90,v 1.9 2014/05/07 09:39:17 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module dry_conv_adjust
    13    !
    14    != 乾燥対流調節スキーム
    15    !
    16    != Dry convective adjustment
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22    ! DryConvAdjust :: 乾燥対流調節
    23    ! ------------  :: ------------
    24    ! DryConvAdjust :: Dry convective adjustment
    25    !
    26    !== NAMELIST
    27    !
    28    ! NAMELIST#dry_conv_adjust_nml
    29    !
    30  
    31    ! モジュール引用 ; USE statements
    32    !
    33  
    34    ! 格子点設定
    35    ! Grid points settings
    36    !
    37    use gridset, only: imax, & ! 経度格子点数.
    38                               ! Number of grid points in longitude
    39      &                jmax, & ! 緯度格子点数.
    40                               ! Number of grid points in latitude
    41      &                kmax    ! 鉛直層数.
    42                               ! Number of vertical level
    43  
    44    ! 組成に関わる配列の設定
    45    ! Settings of array for atmospheric composition
    46    !
    47    use composition, only: &
    48      &                    ncmax
    49                                ! 成分の数
    50                                ! Number of composition
    51    ! 種別型パラメタ
    52    ! Kind type parameter
    53    !
    54    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    55      &                 STRING     ! 文字列.       Strings.
    56  
    57    ! NAMELIST ファイル入力に関するユーティリティ
    58    ! Utilities for NAMELIST file input
    59    !
    60    use namelist_util, only: MaxNmlArySize
    61                                ! NAMELIST から読み込む配列の最大サイズ.
    62                                ! Maximum size of arrays loaded from NAMELIST
    63  
    64    ! メッセージ出力
    65    ! Message output
    66    !
    67    use dc_message, only: MessageNotify
    68  
    69    ! 宣言文 ; Declaration statements
    70    !
    71    implicit none
    72    private
    73  
    74  
    75    ! 公開手続き
    76    ! Public procedure
    77    !
    78    public:: DryConvAdjust
    79    public:: DryConvAdjustInit
    80  
    81    ! 公開変数
    82    ! Public variables
    83    !
    84    logical, save :: dry_conv_adjust_inited = .false.
    85                                ! 初期設定フラグ.
    86                                ! Initialization flag
    87  
    88    ! 非公開変数
    89    ! Private variables
    90    !
    91    real(DP), save:: CrtlRH
    92                                ! 臨界相対湿度.
    93                                ! Critical relative humidity
    94    integer, save:: ItrtMax
    95                                ! イテレーション回数.
    96                                ! Number of iteration
    97  
    98    real(DP), save:: AdjustCriterion(1:MaxNmlArySize)
    99                                ! 調節を行う基準 (湿潤静的エネルギーの差の温度換算値)
   100                                ! Criterion of adjustment (temperature difference
   101                                ! equivalent to difference of dry static energy)
   102  
   103    logical, save :: FlagAdjustMom
   104                                ! Flag for adjusting momentum
   105    logical, save :: FlagAdjustMR
   106                                ! Flag for adjusting mixing ratio
   107  
   108    character(*), parameter:: module_name = 'dry_conv_adjust'
   109                                ! モジュールの名称.
   110                                ! Module name
   111    character(*), parameter:: version = &
   112      & '$Name:  $' // &
   113      & '$Id: dry_conv_adjust.f90,v 1.9 2014/05/07 09:39:17 murashin Exp $'
   114                                ! モジュールのバージョン
   115                                ! Module version
   116  
   117  contains
   118  
   119    !--------------------------------------------------------------------------------------
   120  
   121    subroutine DryConvAdjust(                &
   122      & xyz_Temp, xyz_U, xyz_V, xyzf_QMix,   &  ! (inout)
   123      & xyz_Press, xyr_Press                 &  ! (in)
   124      & )
   125      !
   126      ! 乾燥対流調節スキームにより, 温度を調節.
   127      !
   128      ! Adjust temperature by dry convective adjustment
   129      !
   130  
   131      ! モジュール引用 ; USE statements
   132      !
   133  
   134      ! 物理・数学定数設定
   135      ! Physical and mathematical constants settings
   136      !
   137      use constants0, only: &
   138        & GasRUniv
   139                                ! $ R^{*} $ [J K-1 mol-1].
   140                                ! 普遍気体定数.  Universal gas constant
   141  
   142      ! 物理定数設定
   143      ! Physical constants settings
   144      !
   145      use constants, only: &
   146        & Grav, &
   147                                ! $ g $ [m s-2].
   148                                ! 重力加速度.
   149                                ! Gravitational acceleration
   150        & GasRDry, &
   151                                ! $ R $ [J kg-1 K-1].
   152                                ! 乾燥大気の気体定数.
   153                                ! Gas constant of air
   154        & CpDry
   155                                ! $ C_p $ [J kg-1 K-1].
   156                                ! 乾燥大気の定圧比熱.
   157                                ! Specific heat of air at constant pressure
   158  
   159      ! 時刻管理
   160      ! Time control
   161      !
   162      use timeset, only: &
   163        & DelTime, &            ! $ \Delta t $
   164        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   165        & TimesetClockStart, TimesetClockStop
   166  
   167      ! ヒストリデータ出力
   168      ! History data output
   169      !
   170      use gtool_historyauto, only: HistoryAutoPut
   171  
   172  
   173      ! 宣言文 ; Declaration statements
   174      !
   175      implicit none
   176  
   177      real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   178                                ! $ T $ .     温度. Temperature
   179      real(DP), intent(inout):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   180                                ! $ U $ .           Eastward wind velocity
   181      real(DP), intent(inout):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   182                                ! $ V $ .           Northward wind velocity
   183      real(DP), intent(inout):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   184                                ! $ q $ .           Mixing ratio
   185      real(DP), intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   186                                ! $ p $ . 気圧 (整数レベル).
   187                                ! Air pressure (full level)
   188      real(DP), intent(in   ):: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
   189                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   190                                ! Air pressure (half level)
   191  
   192      ! 作業変数
   193      ! Work variables
   194      !
   195      real(DP):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
   196                                ! 温度変化率.
   197                                ! Temperature tendency
   198      real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   199                                ! 調節前の温度.
   200                                ! Temperature before adjustment
   201      logical:: xy_Adjust (0:imax-1, 1:jmax)
   202                                ! 今回調節されたか否か?.
   203                                ! Whether it was adjusted this time or not?
   204      logical:: xy_AdjustB (0:imax-1, 1:jmax)
   205                                ! 前回調節されたか否か?.
   206                                ! Whether it was adjusted last time or not?
   207      real(DP):: xyz_DelPress(0:imax-1, 1:jmax, 1:kmax)
   208                                ! $ \Delta p $
   209                                !
   210      real(DP):: xyz_DelMass (0:imax-1, 1:jmax, 1:kmax)
   211                                ! $ \Delta p / g $
   212                                !
   213      real(DP):: xyr_ConvAdjustFactor(0:imax-1, 1:jmax, 0:kmax)
   214                                ! $ \frac{1}{2} \frac{ R }{Cp}
   215                                !   \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} } $
   216  
   217      real(DP):: TempEquivToExcEne
   218                                ! Temperature equivalent to the excess dry static energy
   219                                ! (Dry static energy difference devided by specific heat)
   220  
   221      real(DP):: DelTempUppLev
   222                                ! k+1 番目の層における調節による温度の変化量.
   223                                ! Temperature variation by adjustment at k+1 level
   224      real(DP):: DelTempLowLev
   225                                ! k 番目の層における調節による温度の変化量.
   226                                ! Temperature variation by adjustment at k level
   227      logical:: Adjust
   228                                ! 今回全領域において一度でも調節されたか否か?.
   229                                ! Whether it was adjusted even once in global
   230                                ! this time or not?
   231  
   232      real(DP):: TempLowLevBefAdj ! Variables for check routine
   233      real(DP):: TempUppLevBefAdj
   234  
   235      real(DP):: ExchangeMass
   236                                !
   237                                ! Mass transport
   238      real(DP):: ExchangeMassDenom
   239                                !
   240                                ! Variable for mass transport calculation
   241      real(DP):: ExchangeMassLowLim
   242                                !
   243                                ! Lower limit of mass transport calculation
   244      real(DP), parameter :: ExchangeMassLowLimTempDiff = 1.0d-5
   245                                !
   246                                ! Lower limit of temperature difference
   247                                ! between two layers for mass transport
   248                                ! calculation
   249      real(DP):: DelULowLev
   250                                !
   251                                ! Eastward wind velocity change
   252      real(DP):: DelUUppLev
   253                                !
   254                                ! Eastward wind velocity change
   255      real(DP):: DelVLowLev
   256                                !
   257                                ! Eastward wind velocity change
   258      real(DP):: DelVUppLev
   259                                !
   260                                ! Eastward wind velocity change
   261      real(DP):: f_DelQMixLowLev(1:ncmax)
   262                                !
   263                                ! Mixing ratio change
   264      real(DP):: f_DelQMixUppLev(1:ncmax)
   265                                !
   266                                ! Mixing ratio change
   267  
   268      integer:: i               ! 経度方向に回る DO ループ用作業変数
   269                                ! Work variables for DO loop in longitude
   270      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   271                                ! Work variables for DO loop in latitude
   272      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   273                                ! Work variables for DO loop in vertical direction
   274      integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
   275                                ! Work variables for DO loop in iteration direction
   276  
   277  
   278      ! 実行文 ; Executable statement
   279      !
   280  
   281      ! 初期化確認
   282      ! Initialization check
   283      !
   284      if ( .not. dry_conv_adjust_inited ) then
   285        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   286      end if
   287  
   288  
   289      ! 計算時間計測開始
   290      ! Start measurement of computation time
   291      !
   292      call TimesetClockStart( module_name )
   293  
   294      ! 調節前 "Temp" の保存
   295      ! Store "Temp" before adjustment
   296      !
   297      xyz_TempB = xyz_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t690 = 1, xyz_tempb.DSC.U3*(xyz_tempb.DSC.U2*xyz_tempb.DSC.U1  
     .       1    + xyz_tempb.DSC.U2)                                           
     .           xyz_tempb(t690-1,1,1) = xyz_temp(t690-1,1,1)                   
     .        enddo                                                             
   298  
   299      ! Calculate some values used for dry convective adjustment
   300      !
   301  
   302      do k = 1, kmax
   303        xyz_DelPress(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
   304      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delpress(k-1,1,1) = xyr_press(k-1,1,0) - xyr_press(k-1,1,1)
     .        enddo                                                             
   305      xyz_DelMass = xyz_DelPress / Grav
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t712 = 1, xyz_delpress.DSC.U3*(xyz_delpress.DSC.U2*            
     .       1   xyz_delpress.DSC.U1 + xyz_delpress.DSC.U2)                     
     .           xyz_delmass(t712-1,1,1) = xyz_delpress(t712-1,1,1)*d1          
     .        enddo                                                             
   306  
   307      ! \frac{1}{2} \frac{ R }{Cp} \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} }
   308      !
   309      !   The value at k = 0 is not used.
   310      k = 0
   311      xyr_ConvAdjustFactor(:,:,k) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t724 = 1, xyr_convadjustfactor.DSC.U2*                         
     .       1   xyr_convadjustfactor.DSC.U1 + xyr_convadjustfactor.DSC.U2      
     .           xyr_convadjustfactor(t724-1,1,0) = 0.0000000000000000e+000     
     .        enddo                                                             
   312      !
   313      do k = 1, kmax-1
   314        xyr_ConvAdjustFactor(:,:,k) =                     &
   315          & GasRDry / CpDry                               &
   316          &   * ( xyz_Press(:,:,k) - xyz_Press(:,:,k+1) ) &
   317          &   / xyr_Press(:,:,k) / 2.0_DP
   318      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyr_convadjustfactor(k-1,1,1) = gasrdry/cpdry*(xyz_press(k-1,1,
     .       1      1)-xyz_press(k-1,1,2))/(xyr_press(k-1,1,1)*                 
     .       2      2.00000000000000e+000)                                      
     .        enddo                                                             
   319      !   The value at k = kmax is not used.
   320      k = kmax
   321      xyr_ConvAdjustFactor(:,:,k) = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t742 = 1, xyr_convadjustfactor.DSC.U2*                         
     .       1   xyr_convadjustfactor.DSC.U1 + xyr_convadjustfactor.DSC.U2      
     .           xyr_convadjustfactor(t742-1,1,k) = 0.0000000000000000e+000     
     .        enddo                                                             
   322  
   323  
   324      ! 調節
   325      ! Adjustment
   326      !
   327      xy_AdjustB = .true.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t748 = 1, xy_adjustb.DSC.U2*xy_adjustb.DSC.U1 +                
     .       1   xy_adjustb.DSC.U2                                              
     .           xy_adjustb(t748-1,1) = 1                                       
     .        enddo                                                             
   328  
   329      ! 繰り返し
   330      ! Iteration
   331      !
   332      do itr = 1, ItrtMax
   333        xy_Adjust = .false.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t754 = 1, xy_adjust.DSC.U2*xy_adjust.DSC.U1 + xy_adjust.DSC.U2 
     .           xy_adjust(t754-1,1) = 0                                        
     .        enddo                                                             
   334  
   335        do k = 1, kmax-1
   336          do j = 1, jmax
   337            do i = 0, imax-1
   338              if ( xy_AdjustB(i,j) ) then
   339  
   340                ! Temperature equivalent to the excess dry static energy
   341                ! (Dry static energy difference devided by specific heat)
   342                !
   343                TempEquivToExcEne = &
   344                  &   xyz_Temp(i,j,k) - xyz_Temp(i,j,k+1)                                &
   345                  & - xyr_ConvAdjustFactor(i,j,k) * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
   346  
   347                ! Check vertical gradient of dry static energy
   348                !
   349                if ( TempEquivToExcEne > AdjustCriterion(itr) ) then
   350  
   351                  DelTempUppLev =                                                       &
   352                    &   xyz_DelPress(i,j,k) * TempEquivToExcEne                         &
   353                    & / ( xyr_ConvAdjustFactor(i,j,k)                                   &
   354                    &       * ( xyz_DelPress(i,j,k  )                                   &
   355                    &         - xyz_DelPress(i,j,k+1) )                                 &
   356                    &     + xyz_DelPress(i,j,k) + xyz_DelPress(i,j,k+1) )
   357  
   358                  DelTempLowLev =                                                       &
   359                    & - xyz_DelPress(i,j,k+1) * DelTempUppLev                           &
   360                    & / xyz_DelPress(i,j,k)
   361  
   362  
   363                  !=========
   364                  ! save temperature before adjustment
   365                  !---------
   366                  TempLowLevBefAdj = xyz_Temp(i,j,k  )
   367                  TempUppLevBefAdj = xyz_Temp(i,j,k+1)
   368  
   369  
   370                  ! 温度の調節
   371                  ! Adjust temperature
   372                  !
   373                  xyz_Temp(i,j,k  ) = xyz_Temp(i,j,k  ) + DelTempLowLev
   374                  xyz_Temp(i,j,k+1) = xyz_Temp(i,j,k+1) + DelTempUppLev
   375  
   376  
   377                  !=========
   378                  ! check routine
   379                  !---------
   380  !!$                write( 6, * ) '====='
   381  !!$                write( 6, * ) 'Energy difference before and after adjustment and each energy'
   382  !!$                write( 6, * )                                                        &
   383  !!$                  &   ( CpDry * TempLowLevBefAdj  )                                  &
   384  !!$                  &     * xyz_DelPress(i,j,k  ) / Grav                               &
   385  !!$                  & + ( CpDry * TempUppLevBefAdj  )                                  &
   386  !!$                  &     * xyz_DelPress(i,j,k+1) / Grav                               &
   387  !!$                  & - ( CpDry * xyz_Temp(i,j,k  ) )                                  &
   388  !!$                  &     * xyz_DelPress(i,j,k  ) / Grav                               &
   389  !!$                  & - ( CpDry * xyz_Temp(i,j,k+1) )                                  &
   390  !!$                  &     * xyz_DelPress(i,j,k+1) / Grav,                              &
   391  !!$                  &   ( CpDry * TempLowLevBefAdj  )                                  &
   392  !!$                  &     * xyz_DelPress(i,j,k  ) / Grav,                              &
   393  !!$                  &   ( CpDry * TempUppLevBefAdj  )                                  &
   394  !!$                  &     * xyz_DelPress(i,j,k+1) / Grav,                              &
   395  !!$                  &   ( CpDry * xyz_Temp(i,j,k  ) )                                  &
   396  !!$                  &     * xyz_DelPress(i,j,k  ) / Grav,                              &
   397  !!$                  &   ( CpDry * xyz_Temp(i,j,k+1) )                                  &
   398  !!$                  &     * xyz_DelPress(i,j,k+1) / Grav
   399  !!$                write( 6, * ) 'Difference of dry static energy after adjustment'
   400  !!$                write( 6, * )                                                         &
   401  !!$                  &   ( CpDry * xyz_Temp(i,j,k  ) )                                   &
   402  !!$                  & - ( CpDry * xyz_Temp(i,j,k+1) )                                   &
   403  !!$                  & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
   404  !!$                  &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) ),                      &
   405  !!$                  &   ( CpDry * xyz_Temp(i,j,k  ) ),                                  &
   406  !!$                  &   ( CpDry * xyz_Temp(i,j,k+1) ),                                  &
   407  !!$                  & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
   408  !!$                  &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
   409                  !=========
   410  
   411  
   412                  !
   413                  ! Mass exchange
   414                  !   Denominator
   415                  ExchangeMassDenom =                                      &
   416                    &   CpDry * ( TempLowLevBefAdj - TempUppLevBefAdj )    &
   417                    & - GasRDry                                            &
   418                    &   * ( TempLowLevBefAdj + TempUppLevBefAdj ) / 2.0_DP &
   419                    &   / xyr_Press(i,j,k)                                 &
   420                    &   * ( xyz_Press(i,j,k) - xyz_Press(i,j,k+1) )
   421                  ExchangeMassLowLim = CpDry * ExchangeMassLowLimTempDiff
   422                  ! If a static energy difference between two layers is smaller
   423                  ! than a specified lower limit, momentum and mixing ratio are
   424                  ! not mixed to ensure numerical stability.
   425                  ! If the lower limit is zero, some calculations are unstable.
   426                  ! (yot, 2013/10/02)
   427                  if ( ExchangeMassDenom > ExchangeMassLowLim ) then
   428                    ExchangeMass =                                   &
   429                      & - CpDry * DelTempLowLev / ExchangeMassDenom  &
   430                      &     * xyz_DelMass(i,j,k)
   431                  else
   432                    ExchangeMass = 0.0_DP
   433                  end if
   434                  !   Limitation of amount of mass exchange not to
   435                  !   reverse a gradient
   436                  ExchangeMass = &
   437                    & min( ExchangeMass,                                      &
   438                    &      xyz_DelMass(i,j,k) * xyz_DelMass(i,j,k+1)          &
   439                    &        / ( xyz_DelMass(i,j,k) + xyz_DelMass(i,j,k+1) )  &
   440                    &    )
   441  
   442                  if ( FlagAdjustMom ) then
   443                    DelULowLev =                            &
   444                      &   ( xyz_U(i,j,k+1) - xyz_U(i,j,k) ) &
   445                      & * ExchangeMass                      &
   446                      & / xyz_DelMass(i,j,k  )
   447                    DelUUppLev =                            &
   448                      & - ( xyz_U(i,j,k+1) - xyz_U(i,j,k) ) &
   449                      & * ExchangeMass                      &
   450                      & / xyz_DelMass(i,j,k+1)
   451                    DelVLowLev =                            &
   452                      &   ( xyz_V(i,j,k+1) - xyz_V(i,j,k) ) &
   453                      & * ExchangeMass                      &
   454                      & / xyz_DelMass(i,j,k  )
   455                    DelVUppLev =                            &
   456                      & - ( xyz_V(i,j,k+1) - xyz_V(i,j,k) ) &
   457                      & * ExchangeMass                      &
   458                      & / xyz_DelMass(i,j,k+1)
   459  
   460                    xyz_U(i,j,k  ) = xyz_U(i,j,k  ) + DelULowLev
   461                    xyz_U(i,j,k+1) = xyz_U(i,j,k+1) + DelUUppLev
   462                    xyz_V(i,j,k  ) = xyz_V(i,j,k  ) + DelVLowLev
   463                    xyz_V(i,j,k+1) = xyz_V(i,j,k+1) + DelVUppLev
   464                  end if
   465  
   466                  if ( FlagAdjustMR ) then
   467                    f_DelQMixLowLev =                                   &
     .        d4 = 1.D0/xyz_delmass(i,j,k)                                      
     .        d5 = 1.D0/xyz_delmass(i,j,k+1)                                    
     .  !cdir nodep                                                             
     .  !cdir on_adb(f_delqmixlowlev,f_delqmixupplev)                           
     .        do t775 = 1, ncmax                                                
     .           f_delqmixlowlev1 = ((xyzf_qmix(i,j,k+1,t775)-xyzf_qmix(i,j,k,  
     .       1      t775))*exchangemass)*d4                                     
     .           f_delqmixupplev1 = -((xyzf_qmix(i,j,k+1,t775)-xyzf_qmix(i,j,k, 
     .       1      t775))*exchangemass)*d5                                     
     .           xyzf_qmix(i,j,k,t775) = xyzf_qmix(i,j,k,t775) +                
     .       1      f_delqmixlowlev1                                            
     .           xyzf_qmix(i,j,k+1,t775) = xyzf_qmix(i,j,k+1,t775) +            
     .       1      f_delqmixupplev1                                            
     .        enddo                                                             
   468                      &   ( xyzf_QMix(i,j,k+1,:) - xyzf_QMix(i,j,k,:) ) &
   469                      & * ExchangeMass                                  &
   470                      & / xyz_DelMass(i,j,k  )
   471                    f_DelQMixUppLev =                                   &
   472                      & - ( xyzf_QMix(i,j,k+1,:) - xyzf_QMix(i,j,k,:) ) &
   473                      & * ExchangeMass                                  &
   474                      & / xyz_DelMass(i,j,k+1)
   475  
   476                    xyzf_QMix(i,j,k  ,:) = xyzf_QMix(i,j,k  ,:) + f_DelQMixLowLev
   477                    xyzf_QMix(i,j,k+1,:) = xyzf_QMix(i,j,k+1,:) + f_DelQMixUppLev
   478                  end if
   479  
   480                  ! 調節したか否か?
   481                  ! Whether it was adjusted or not?
   482                  !
   483                  xy_Adjust(i,j) = .true.
   484                end if
   485  
   486              end if
   487  
   488            end do
   489          end do
   490        end do
   491  
   492        Adjust = .false.
   493        do i = 0, imax-1
   494          do j = 1, jmax
   495            xy_AdjustB(i,j) = xy_Adjust(i,j)
   496            Adjust          = Adjust .or. xy_Adjust(i,j)
   497          end do
   498        end do
   499  
   500        if ( .not. Adjust ) exit
   501  
   502      end do
   503  
   504      ! 温度変化率
   505      ! Calculate temperature tendency
   506      !
   507      xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
     .        d6 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t760 = 1, kmax*jmax*imax                                       
     .           xyz_dtempdt(t760-1,1,1) = (xyz_temp(t760-1,1,1)-xyz_tempb(t760-
     .       1      1,1,1))*d6                                                  
     .        enddo                                                             
   508  
   509  
   510      ! ヒストリデータ出力
   511      ! History data output
   512      !
   513      call HistoryAutoPut( TimeN, 'DTempDtDryConv', xyz_DTempDt )
   514  
   515  
   516      ! 計算時間計測一時停止
   517      ! Pause measurement of computation time
   518      !
   519      call TimesetClockStop( module_name )
   520  
   521    end subroutine DryConvAdjust
   522  
   523    !--------------------------------------------------------------------------------------
   524  
   525    subroutine DryConvAdjustInit
   526      !
   527      ! dry_conv_adjust モジュールの初期化を行います.
   528      ! NAMELIST#dry_conv_adjust_nml の読み込みはこの手続きで行われます.
   529      !
   530      ! "dyr_conv_adjust" module is initialized.
   531      ! "NAMELIST#dry_conv_adjust_nml" is loaded in this procedure.
   532      !
   533  
   534      ! モジュール引用 ; USE statements
   535      !
   536  
   537      ! NAMELIST ファイル入力に関するユーティリティ
   538      ! Utilities for NAMELIST file input
   539      !
   540      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   541  
   542      ! ファイル入出力補助
   543      ! File I/O support
   544      !
   545      use dc_iounit, only: FileOpen
   546  
   547      ! 種別型パラメタ
   548      ! Kind type parameter
   549      !
   550      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   551  
   552      ! 文字列操作
   553      ! Character handling
   554      !
   555      use dc_string, only: StoA
   556  
   557      ! ヒストリデータ出力
   558      ! History data output
   559      !
   560      use gtool_historyauto, only: HistoryAutoAddVariable
   561  
   562      ! 宣言文 ; Declaration statements
   563      !
   564      implicit none
   565  
   566      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   567                                ! Unit number for NAMELIST file open
   568      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   569                                ! IOSTAT of NAMELIST read
   570  
   571      ! NAMELIST 変数群
   572      ! NAMELIST group name
   573      !
   574      namelist /dry_conv_adjust_nml/ &
   575        & CrtlRH, ItrtMax, AdjustCriterion, &
   576        & FlagAdjustMom, FlagAdjustMR
   577            ! デフォルト値については初期化手続 "dry_conv_adjust#DryConvAdjustInit"
   578            ! のソースコードを参照のこと.
   579            !
   580            ! Refer to source codes in the initialization procedure
   581            ! "dry_conv_adjust#DryConvAdjustInit" for the default values.
   582            !
   583  
   584      ! 実行文 ; Executable statement
   585      !
   586  
   587      if ( dry_conv_adjust_inited ) return
   588  
   589  
   590      ! デフォルト値の設定
   591      ! Default values settings
   592      !
   593      ! default values used in AGCM5
   594  !!$    CrtlRH  = 0.990_DP
   595  !!$    ItrtMax = 10
   596  !!$    AdjustCriterion(1:ItrtMax) = &
   597  !!$      & (/ 0.01_DP, 0.02_DP, 0.02_DP, 0.05_DP, 0.05_DP, &
   598  !!$      &    0.10_DP, 0.10_DP, 0.20_DP, 0.20_DP, 0.40_DP  /)
   599      !
   600      CrtlRH  = 1.0_DP
   601      ItrtMax = 10
   602      AdjustCriterion(1:ItrtMax) = 0.0_DP
   603  
   604      FlagAdjustMom = .false.
   605      FlagAdjustMR  = .false.
   606  
   607  
   608      ! NAMELIST の読み込み
   609      ! NAMELIST is input
   610      !
   611      if ( trim(namelist_filename) /= '' ) then
   612        call FileOpen( unit_nml, &          ! (out)
   613          & namelist_filename, mode = 'r' ) ! (in)
   614  
   615        rewind( unit_nml )
   616        read( unit_nml,                &  ! (in)
   617          & nml = dry_conv_adjust_nml, &  ! (out)
   618          & iostat = iostat_nml )         ! (out)
   619        close( unit_nml )
   620  
   621        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   622  !!$      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
   623      end if
   624  
   625      ! イテレーション回数, 不安定の許容誤差のチェック
   626      ! Check number of iteration, admissible error of unstability
   627      !
   628      call NmlutilAryValid( module_name, & ! (in)
   629        & AdjustCriterion, 'AdjustCriterion', &      ! (in)
   630        & ItrtMax,    'ItrtMax' )          ! (in)
   631  
   632  
   633      ! ヒストリデータ出力のためのへの変数登録
   634      ! Register of variables for history data output
   635      !
   636      call HistoryAutoAddVariable( 'DTempDtDryConv', &
   637        & (/ 'lon ', 'lat ', 'sig ', 'time' /),      &
   638        & 'dry convective adjustment heating', 'K s-1' )
   639  
   640      ! 印字 ; Print
   641      !
   642      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   643      call MessageNotify( 'M', module_name, '  CrtlRH               = %f', d = (/ CrtlRH /) )
   644      call MessageNotify( 'M', module_name, '  ItrtMax              = %d', i = (/ ItrtMax /) )
   645      call MessageNotify( 'M', module_name, '  AdjustCriterion      = (/ %f /)', &
   646        & d = AdjustCriterion(1:ItrtMax), n = (/ ItrtMax /) )
   647      call MessageNotify( 'M', module_name, '  FlagAdjustMom        = %b', l = (/ FlagAdjustMom /) )
   648      call MessageNotify( 'M', module_name, '  FlagAdjustMR         = %b', l = (/ FlagAdjustMR  /) )
   649      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   650  
   651      dry_conv_adjust_inited = .true.
   652  
   653    end subroutine DryConvAdjustInit
   654  
   655    !--------------------------------------------------------------------------------------
   656  
   657  end module dry_conv_adjust
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:46 2016
FILE NAME: dry_conv_adjust.f90
PROGRAM NAME: dry_conv_adjust
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 乾燥対流調節
     2:             !
     3:             != Dry convective adjustment
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6:             ! Version::   $Id: dry_conv_adjust.f90,v 1.9 2014/05/07 09:39:17 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module dry_conv_adjust
    13:               !
    14:               != 乾燥対流調節スキーム
    15:               !
    16:               != Dry convective adjustment
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               ! 
    22:               ! DryConvAdjust :: 乾燥対流調節
    23:               ! ------------  :: ------------
    24:               ! DryConvAdjust :: Dry convective adjustment
    25:               !
    26:               !== NAMELIST
    27:               !
    28:               ! NAMELIST#dry_conv_adjust_nml
    29:               !
    30:             
    31:               ! モジュール引用 ; USE statements
    32:               !
    33:             
    34:               ! 格子点設定
    35:               ! Grid points settings
    36:               !
    37:               use gridset, only: imax, & ! 経度格子点数. 
    38:                                          ! Number of grid points in longitude
    39:                 &                jmax, & ! 緯度格子点数. 
    40:                                          ! Number of grid points in latitude
    41:                 &                kmax    ! 鉛直層数. 
    42:                                          ! Number of vertical level
    43:             
    44:               ! 組成に関わる配列の設定
    45:               ! Settings of array for atmospheric composition
    46:               !
    47:               use composition, only: &
    48:                 &                    ncmax
    49:                                           ! 成分の数
    50:                                           ! Number of composition
    51:               ! 種別型パラメタ
    52:               ! Kind type parameter
    53:               !
    54:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    55:                 &                 STRING     ! 文字列.       Strings. 
    56:             
    57:               ! NAMELIST ファイル入力に関するユーティリティ
    58:               ! Utilities for NAMELIST file input
    59:               !
    60:               use namelist_util, only: MaxNmlArySize
    61:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    62:                                           ! Maximum size of arrays loaded from NAMELIST
    63:             
    64:               ! メッセージ出力
    65:               ! Message output
    66:               !
    67:               use dc_message, only: MessageNotify
    68:             
    69:               ! 宣言文 ; Declaration statements
    70:               !
    71:               implicit none
    72:               private
    73:             
    74:             
    75:               ! 公開手続き
    76:               ! Public procedure
    77:               !
    78:               public:: DryConvAdjust
    79:               public:: DryConvAdjustInit
    80:             
    81:               ! 公開変数
    82:               ! Public variables
    83:               !
    84:               logical, save :: dry_conv_adjust_inited = .false.
    85:                                           ! 初期設定フラグ. 
    86:                                           ! Initialization flag
    87:             
    88:               ! 非公開変数
    89:               ! Private variables
    90:               !
    91:               real(DP), save:: CrtlRH
    92:                                           ! 臨界相対湿度. 
    93:                                           ! Critical relative humidity
    94:               integer, save:: ItrtMax
    95:                                           ! イテレーション回数. 
    96:                                           ! Number of iteration
    97:             
    98:               real(DP), save:: AdjustCriterion(1:MaxNmlArySize)
    99:                                           ! 調節を行う基準 (湿潤静的エネルギーの差の温度換算値)
   100:                                           ! Criterion of adjustment (temperature difference 
   101:                                           ! equivalent to difference of dry static energy)
   102:             
   103:               logical, save :: FlagAdjustMom
   104:                                           ! Flag for adjusting momentum
   105:               logical, save :: FlagAdjustMR
   106:                                           ! Flag for adjusting mixing ratio
   107:             
   108:               character(*), parameter:: module_name = 'dry_conv_adjust'
   109:                                           ! モジュールの名称. 
   110:                                           ! Module name
   111:               character(*), parameter:: version = &
   112:                 & '$Name:  $' // &
   113:                 & '$Id: dry_conv_adjust.f90,v 1.9 2014/05/07 09:39:17 murashin Exp $'
   114:                                           ! モジュールのバージョン
   115:                                           ! Module version
   116:             
   117:             contains
   118:             
   119:               !--------------------------------------------------------------------------------------
   120:             
   121:               subroutine DryConvAdjust(                &
   122:                 & xyz_Temp, xyz_U, xyz_V, xyzf_QMix,   &  ! (inout)
   123:                 & xyz_Press, xyr_Press                 &  ! (in)
   124:                 & )
   125:                 !
   126:                 ! 乾燥対流調節スキームにより, 温度を調節. 
   127:                 !
   128:                 ! Adjust temperature by dry convective adjustment
   129:                 !
   130:             
   131:                 ! モジュール引用 ; USE statements
   132:                 !
   133:             
   134:                 ! 物理・数学定数設定
   135:                 ! Physical and mathematical constants settings
   136:                 !
   137:                 use constants0, only: &
   138:                   & GasRUniv
   139:                                           ! $ R^{*} $ [J K-1 mol-1]. 
   140:                                           ! 普遍気体定数.  Universal gas constant
   141:             
   142:                 ! 物理定数設定
   143:                 ! Physical constants settings
   144:                 !
   145:                 use constants, only: &
   146:                   & Grav, & 
   147:                                           ! $ g $ [m s-2]. 
   148:                                           ! 重力加速度. 
   149:                                           ! Gravitational acceleration
   150:                   & GasRDry, &
   151:                                           ! $ R $ [J kg-1 K-1]. 
   152:                                           ! 乾燥大気の気体定数. 
   153:                                           ! Gas constant of air
   154:                   & CpDry
   155:                                           ! $ C_p $ [J kg-1 K-1]. 
   156:                                           ! 乾燥大気の定圧比熱. 
   157:                                           ! Specific heat of air at constant pressure
   158:             
   159:                 ! 時刻管理
   160:                 ! Time control
   161:                 !
   162:                 use timeset, only: &
   163:                   & DelTime, &            ! $ \Delta t $
   164:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   165:                   & TimesetClockStart, TimesetClockStop
   166:             
   167:                 ! ヒストリデータ出力
   168:                 ! History data output
   169:                 !
   170:                 use gtool_historyauto, only: HistoryAutoPut
   171:             
   172:             
   173:                 ! 宣言文 ; Declaration statements
   174:                 !
   175:                 implicit none
   176:             
   177:                 real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   178:                                           ! $ T $ .     温度. Temperature
   179:                 real(DP), intent(inout):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   180:                                           ! $ U $ .           Eastward wind velocity
   181:                 real(DP), intent(inout):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   182:                                           ! $ V $ .           Northward wind velocity
   183:                 real(DP), intent(inout):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   184:                                           ! $ q $ .           Mixing ratio
   185:                 real(DP), intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   186:                                           ! $ p $ . 気圧 (整数レベル). 
   187:                                           ! Air pressure (full level)
   188:                 real(DP), intent(in   ):: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
   189:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   190:                                           ! Air pressure (half level)
   191:             
   192:                 ! 作業変数
   193:                 ! Work variables
   194:                 !
   195:                 real(DP):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
   196:                                           ! 温度変化率. 
   197:                                           ! Temperature tendency
   198:                 real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   199:                                           ! 調節前の温度. 
   200:                                           ! Temperature before adjustment
   201:                 logical:: xy_Adjust (0:imax-1, 1:jmax)
   202:                                           ! 今回調節されたか否か?. 
   203:                                           ! Whether it was adjusted this time or not?
   204:                 logical:: xy_AdjustB (0:imax-1, 1:jmax)
   205:                                           ! 前回調節されたか否か?. 
   206:                                           ! Whether it was adjusted last time or not?
   207:                 real(DP):: xyz_DelPress(0:imax-1, 1:jmax, 1:kmax)
   208:                                           ! $ \Delta p $
   209:                                           !
   210:                 real(DP):: xyz_DelMass (0:imax-1, 1:jmax, 1:kmax)
   211:                                           ! $ \Delta p / g $
   212:                                           !
   213:                 real(DP):: xyr_ConvAdjustFactor(0:imax-1, 1:jmax, 0:kmax)
   214:                                           ! $ \frac{1}{2} \frac{ R }{Cp} 
   215:                                           !   \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} } $
   216:             
   217:                 real(DP):: TempEquivToExcEne
   218:                                           ! Temperature equivalent to the excess dry static energy
   219:                                           ! (Dry static energy difference devided by specific heat)
   220:             
   221:                 real(DP):: DelTempUppLev
   222:                                           ! k+1 番目の層における調節による温度の変化量. 
   223:                                           ! Temperature variation by adjustment at k+1 level
   224:                 real(DP):: DelTempLowLev
   225:                                           ! k 番目の層における調節による温度の変化量. 
   226:                                           ! Temperature variation by adjustment at k level
   227:                 logical:: Adjust
   228:                                           ! 今回全領域において一度でも調節されたか否か?. 
   229:                                           ! Whether it was adjusted even once in global 
   230:                                           ! this time or not?
   231:             
   232:                 real(DP):: TempLowLevBefAdj ! Variables for check routine
   233:                 real(DP):: TempUppLevBefAdj
   234:             
   235:                 real(DP):: ExchangeMass
   236:                                           ! 
   237:                                           ! Mass transport
   238:                 real(DP):: ExchangeMassDenom
   239:                                           ! 
   240:                                           ! Variable for mass transport calculation
   241:                 real(DP):: ExchangeMassLowLim
   242:                                           ! 
   243:                                           ! Lower limit of mass transport calculation
   244:                 real(DP), parameter :: ExchangeMassLowLimTempDiff = 1.0d-5
   245:                                           ! 
   246:                                           ! Lower limit of temperature difference 
   247:                                           ! between two layers for mass transport 
   248:                                           ! calculation
   249:                 real(DP):: DelULowLev
   250:                                           ! 
   251:                                           ! Eastward wind velocity change
   252:                 real(DP):: DelUUppLev
   253:                                           ! 
   254:                                           ! Eastward wind velocity change
   255:                 real(DP):: DelVLowLev
   256:                                           ! 
   257:                                           ! Eastward wind velocity change
   258:                 real(DP):: DelVUppLev
   259:                                           ! 
   260:                                           ! Eastward wind velocity change
   261:                 real(DP):: f_DelQMixLowLev(1:ncmax)
   262:                                           ! 
   263:                                           ! Mixing ratio change
   264:                 real(DP):: f_DelQMixUppLev(1:ncmax)
   265:                                           ! 
   266:                                           ! Mixing ratio change
   267:             
   268:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   269:                                           ! Work variables for DO loop in longitude
   270:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   271:                                           ! Work variables for DO loop in latitude
   272:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   273:                                           ! Work variables for DO loop in vertical direction
   274:                 integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
   275:                                           ! Work variables for DO loop in iteration direction
   276:             
   277:             
   278:                 ! 実行文 ; Executable statement
   279:                 !
   280:             
   281:                 ! 初期化確認
   282:                 ! Initialization check
   283:                 !
   284:                 if ( .not. dry_conv_adjust_inited ) then
   285:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   286:                 end if
   287:             
   288:             
   289:                 ! 計算時間計測開始
   290:                 ! Start measurement of computation time
   291:                 !
   292:                 call TimesetClockStart( module_name )
   293:             
   294:                 ! 調節前 "Temp" の保存
   295:                 ! Store "Temp" before adjustment
   296:                 !
   297: W**==== A       xyz_TempB = xyz_Temp
   298:             
   299:                 ! Calculate some values used for dry convective adjustment
   300:                 !
   301:             
   302: W------>        do k = 1, kmax
   303: |**==== A         xyz_DelPress(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
   304: W------         end do
   305: W**====         xyz_DelMass = xyz_DelPress / Grav
   306:             
   307:                 ! \frac{1}{2} \frac{ R }{Cp} \frac{ p_{k} - p_{k+1} }{ p_{k+1/2} }
   308:                 !
   309:                 !   The value at k = 0 is not used.
   310:                 k = 0
   311: W*=====         xyr_ConvAdjustFactor(:,:,k) = 0.0_DP
   312:                 !
   313: W------>        do k = 1, kmax-1
   314: |**==== A         xyr_ConvAdjustFactor(:,:,k) =                     &
   315: |                   & GasRDry / CpDry                               &
   316: |                   &   * ( xyz_Press(:,:,k) - xyz_Press(:,:,k+1) ) &
   317: |                   &   / xyr_Press(:,:,k) / 2.0_DP
   318: W------         end do
   319:                 !   The value at k = kmax is not used.
   320:                 k = kmax
   321: W*=====         xyr_ConvAdjustFactor(:,:,k) = 0.0d0
   322:             
   323:             
   324:                 ! 調節
   325:                 ! Adjustment
   326:                 !
   327: W*=====         xy_AdjustB = .true.
   328:             
   329:                 ! 繰り返し
   330:                 ! Iteration
   331:                 !
   332: +------>        do itr = 1, ItrtMax
   333: |W*====           xy_Adjust = .false.
   334: |           
   335: |+----->          do k = 1, kmax-1
   336: ||+---->            do j = 1, jmax
   337: |||+--->              do i = 0, imax-1
   338: ||||                    if ( xy_AdjustB(i,j) ) then
   339: ||||        
   340: ||||                      ! Temperature equivalent to the excess dry static energy
   341: ||||                      ! (Dry static energy difference devided by specific heat)
   342: ||||                      !
   343: ||||                      TempEquivToExcEne = &
   344: ||||                        &   xyz_Temp(i,j,k) - xyz_Temp(i,j,k+1)                                &
   345: ||||                        & - xyr_ConvAdjustFactor(i,j,k) * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
   346: ||||        
   347: ||||                      ! Check vertical gradient of dry static energy
   348: ||||                      !
   349: ||||                      if ( TempEquivToExcEne > AdjustCriterion(itr) ) then
   350: ||||        
   351: ||||                        DelTempUppLev =                                                       &
   352: ||||                          &   xyz_DelPress(i,j,k) * TempEquivToExcEne                         &
   353: ||||                          & / ( xyr_ConvAdjustFactor(i,j,k)                                   &
   354: ||||                          &       * ( xyz_DelPress(i,j,k  )                                   &
   355: ||||                          &         - xyz_DelPress(i,j,k+1) )                                 &
   356: ||||                          &     + xyz_DelPress(i,j,k) + xyz_DelPress(i,j,k+1) )
   357: ||||        
   358: ||||                        DelTempLowLev =                                                       &
   359: ||||                          & - xyz_DelPress(i,j,k+1) * DelTempUppLev                           &
   360: ||||                          & / xyz_DelPress(i,j,k)
   361: ||||        
   362: ||||        
   363: ||||                        !=========
   364: ||||                        ! save temperature before adjustment
   365: ||||                        !---------
   366: ||||                        TempLowLevBefAdj = xyz_Temp(i,j,k  )
   367: ||||                        TempUppLevBefAdj = xyz_Temp(i,j,k+1)
   368: ||||        
   369: ||||        
   370: ||||                        ! 温度の調節
   371: ||||                        ! Adjust temperature
   372: ||||                        !
   373: ||||                        xyz_Temp(i,j,k  ) = xyz_Temp(i,j,k  ) + DelTempLowLev
   374: ||||                        xyz_Temp(i,j,k+1) = xyz_Temp(i,j,k+1) + DelTempUppLev
   375: ||||        
   376: ||||        
   377: ||||                        !=========
   378: ||||                        ! check routine
   379: ||||                        !---------
   380: ||||        !!$                write( 6, * ) '====='
   381: ||||        !!$                write( 6, * ) 'Energy difference before and after adjustment and each energy'
   382: ||||        !!$                write( 6, * )                                                        &
   383: ||||        !!$                  &   ( CpDry * TempLowLevBefAdj  )                                  &
   384: ||||        !!$                  &     * xyz_DelPress(i,j,k  ) / Grav                               &
   385: ||||        !!$                  & + ( CpDry * TempUppLevBefAdj  )                                  &
   386: ||||        !!$                  &     * xyz_DelPress(i,j,k+1) / Grav                               &
   387: ||||        !!$                  & - ( CpDry * xyz_Temp(i,j,k  ) )                                  &
   388: ||||        !!$                  &     * xyz_DelPress(i,j,k  ) / Grav                               &
   389: ||||        !!$                  & - ( CpDry * xyz_Temp(i,j,k+1) )                                  &
   390: ||||        !!$                  &     * xyz_DelPress(i,j,k+1) / Grav,                              &
   391: ||||        !!$                  &   ( CpDry * TempLowLevBefAdj  )                                  &
   392: ||||        !!$                  &     * xyz_DelPress(i,j,k  ) / Grav,                              &
   393: ||||        !!$                  &   ( CpDry * TempUppLevBefAdj  )                                  &
   394: ||||        !!$                  &     * xyz_DelPress(i,j,k+1) / Grav,                              &
   395: ||||        !!$                  &   ( CpDry * xyz_Temp(i,j,k  ) )                                  &
   396: ||||        !!$                  &     * xyz_DelPress(i,j,k  ) / Grav,                              &
   397: ||||        !!$                  &   ( CpDry * xyz_Temp(i,j,k+1) )                                  &
   398: ||||        !!$                  &     * xyz_DelPress(i,j,k+1) / Grav
   399: ||||        !!$                write( 6, * ) 'Difference of dry static energy after adjustment'
   400: ||||        !!$                write( 6, * )                                                         &
   401: ||||        !!$                  &   ( CpDry * xyz_Temp(i,j,k  ) )                                   &
   402: ||||        !!$                  & - ( CpDry * xyz_Temp(i,j,k+1) )                                   &
   403: ||||        !!$                  & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
   404: ||||        !!$                  &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) ),                      &
   405: ||||        !!$                  &   ( CpDry * xyz_Temp(i,j,k  ) ),                                  &
   406: ||||        !!$                  &   ( CpDry * xyz_Temp(i,j,k+1) ),                                  &
   407: ||||        !!$                  & - CpDry * xyr_ConvAdjustFactor(i,j,k)                             &
   408: ||||        !!$                  &   * ( xyz_Temp(i,j,k) + xyz_Temp(i,j,k+1) )
   409: ||||                        !=========
   410: ||||        
   411: ||||        
   412: ||||                        ! 
   413: ||||                        ! Mass exchange
   414: ||||                        !   Denominator
   415: ||||                        ExchangeMassDenom =                                      &
   416: ||||                          &   CpDry * ( TempLowLevBefAdj - TempUppLevBefAdj )    &
   417: ||||                          & - GasRDry                                            &
   418: ||||                          &   * ( TempLowLevBefAdj + TempUppLevBefAdj ) / 2.0_DP &
   419: ||||                          &   / xyr_Press(i,j,k)                                 &
   420: ||||                          &   * ( xyz_Press(i,j,k) - xyz_Press(i,j,k+1) )
   421: ||||                        ExchangeMassLowLim = CpDry * ExchangeMassLowLimTempDiff
   422: ||||                        ! If a static energy difference between two layers is smaller 
   423: ||||                        ! than a specified lower limit, momentum and mixing ratio are 
   424: ||||                        ! not mixed to ensure numerical stability.
   425: ||||                        ! If the lower limit is zero, some calculations are unstable.
   426: ||||                        ! (yot, 2013/10/02)
   427: ||||                        if ( ExchangeMassDenom > ExchangeMassLowLim ) then
   428: ||||                          ExchangeMass =                                   &
   429: ||||                            & - CpDry * DelTempLowLev / ExchangeMassDenom  &
   430: ||||                            &     * xyz_DelMass(i,j,k)
   431: ||||                        else
   432: ||||                          ExchangeMass = 0.0_DP
   433: ||||                        end if
   434: ||||                        !   Limitation of amount of mass exchange not to 
   435: ||||                        !   reverse a gradient
   436: ||||                        ExchangeMass = &
   437: ||||                          & min( ExchangeMass,                                      &
   438: ||||                          &      xyz_DelMass(i,j,k) * xyz_DelMass(i,j,k+1)          &
   439: ||||                          &        / ( xyz_DelMass(i,j,k) + xyz_DelMass(i,j,k+1) )  &
   440: ||||                          &    )
   441: ||||        
   442: ||||                        if ( FlagAdjustMom ) then
   443: ||||                          DelULowLev =                            &
   444: ||||                            &   ( xyz_U(i,j,k+1) - xyz_U(i,j,k) ) &
   445: ||||                            & * ExchangeMass                      &
   446: ||||                            & / xyz_DelMass(i,j,k  )
   447: ||||                          DelUUppLev =                            &
   448: ||||                            & - ( xyz_U(i,j,k+1) - xyz_U(i,j,k) ) &
   449: ||||                            & * ExchangeMass                      &
   450: ||||                            & / xyz_DelMass(i,j,k+1)
   451: ||||                          DelVLowLev =                            &
   452: ||||                            &   ( xyz_V(i,j,k+1) - xyz_V(i,j,k) ) &
   453: ||||                            & * ExchangeMass                      &
   454: ||||                            & / xyz_DelMass(i,j,k  )
   455: ||||                          DelVUppLev =                            &
   456: ||||                            & - ( xyz_V(i,j,k+1) - xyz_V(i,j,k) ) &
   457: ||||                            & * ExchangeMass                      &
   458: ||||                            & / xyz_DelMass(i,j,k+1)
   459: ||||        
   460: ||||                          xyz_U(i,j,k  ) = xyz_U(i,j,k  ) + DelULowLev
   461: ||||                          xyz_U(i,j,k+1) = xyz_U(i,j,k+1) + DelUUppLev
   462: ||||                          xyz_V(i,j,k  ) = xyz_V(i,j,k  ) + DelVLowLev
   463: ||||                          xyz_V(i,j,k+1) = xyz_V(i,j,k+1) + DelVUppLev
   464: ||||                        end if
   465: ||||        
   466: ||||                        if ( FlagAdjustMR ) then
   467: ||||V-->A                     f_DelQMixLowLev =                                   &
   468: |||||                           &   ( xyzf_QMix(i,j,k+1,:) - xyzf_QMix(i,j,k,:) ) &
   469: |||||                           & * ExchangeMass                                  &
   470: |||||                           & / xyz_DelMass(i,j,k  )
   471: |||||                         f_DelQMixUppLev =                                   &
   472: |||||                           & - ( xyzf_QMix(i,j,k+1,:) - xyzf_QMix(i,j,k,:) ) &
   473: |||||                           & * ExchangeMass                                  &
   474: |||||                           & / xyz_DelMass(i,j,k+1)
   475: |||||       
   476: |||||   A                     xyzf_QMix(i,j,k  ,:) = xyzf_QMix(i,j,k  ,:) + f_DelQMixLowLev
   477: ||||V-- A                     xyzf_QMix(i,j,k+1,:) = xyzf_QMix(i,j,k+1,:) + f_DelQMixUppLev
   478: ||||                        end if
   479: ||||        
   480: ||||                        ! 調節したか否か?
   481: ||||                        ! Whether it was adjusted or not?
   482: ||||                        !
   483: ||||                        xy_Adjust(i,j) = .true.
   484: ||||                      end if
   485: ||||        
   486: ||||                    end if
   487: ||||        
   488: |||+---               end do
   489: ||+----             end do
   490: |+-----           end do
   491: |           
   492: |                 Adjust = .false.
   493: |+----->          do i = 0, imax-1
   494: ||+---->            do j = 1, jmax
   495: |||                   xy_AdjustB(i,j) = xy_Adjust(i,j)
   496: |||                   Adjust          = Adjust .or. xy_Adjust(i,j)
   497: ||+----             end do
   498: |+-----           end do
   499: |           
   500: |                 if ( .not. Adjust ) exit
   501: |           
   502: +------         end do
   503:             
   504:                 ! 温度変化率
   505:                 ! Calculate temperature tendency
   506:                 !
   507: W**==== A       xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   508:             
   509:             
   510:                 ! ヒストリデータ出力
   511:                 ! History data output
   512:                 !
   513:                 call HistoryAutoPut( TimeN, 'DTempDtDryConv', xyz_DTempDt )
   514:             
   515:             
   516:                 ! 計算時間計測一時停止
   517:                 ! Pause measurement of computation time
   518:                 !
   519:                 call TimesetClockStop( module_name )
   520:             
   521:               end subroutine DryConvAdjust
   522:             
   523:               !--------------------------------------------------------------------------------------
   524:             
   525:               subroutine DryConvAdjustInit
   526:                 !
   527:                 ! dry_conv_adjust モジュールの初期化を行います. 
   528:                 ! NAMELIST#dry_conv_adjust_nml の読み込みはこの手続きで行われます. 
   529:                 !
   530:                 ! "dyr_conv_adjust" module is initialized. 
   531:                 ! "NAMELIST#dry_conv_adjust_nml" is loaded in this procedure. 
   532:                 !
   533:             
   534:                 ! モジュール引用 ; USE statements
   535:                 !
   536:             
   537:                 ! NAMELIST ファイル入力に関するユーティリティ
   538:                 ! Utilities for NAMELIST file input
   539:                 !
   540:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   541:             
   542:                 ! ファイル入出力補助
   543:                 ! File I/O support
   544:                 !
   545:                 use dc_iounit, only: FileOpen
   546:             
   547:                 ! 種別型パラメタ
   548:                 ! Kind type parameter
   549:                 !
   550:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   551:             
   552:                 ! 文字列操作
   553:                 ! Character handling
   554:                 !
   555:                 use dc_string, only: StoA
   556:             
   557:                 ! ヒストリデータ出力
   558:                 ! History data output
   559:                 !
   560:                 use gtool_historyauto, only: HistoryAutoAddVariable
   561:             
   562:                 ! 宣言文 ; Declaration statements
   563:                 !
   564:                 implicit none
   565:             
   566:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   567:                                           ! Unit number for NAMELIST file open
   568:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   569:                                           ! IOSTAT of NAMELIST read
   570:             
   571:                 ! NAMELIST 変数群
   572:                 ! NAMELIST group name
   573:                 !
   574:                 namelist /dry_conv_adjust_nml/ &
   575:                   & CrtlRH, ItrtMax, AdjustCriterion, &
   576:                   & FlagAdjustMom, FlagAdjustMR
   577:                       ! デフォルト値については初期化手続 "dry_conv_adjust#DryConvAdjustInit" 
   578:                       ! のソースコードを参照のこと. 
   579:                       !
   580:                       ! Refer to source codes in the initialization procedure
   581:                       ! "dry_conv_adjust#DryConvAdjustInit" for the default values. 
   582:                       !
   583:             
   584:                 ! 実行文 ; Executable statement
   585:                 !
   586:             
   587:                 if ( dry_conv_adjust_inited ) return
   588:             
   589:             
   590:                 ! デフォルト値の設定
   591:                 ! Default values settings
   592:                 !
   593:                 ! default values used in AGCM5
   594:             !!$    CrtlRH  = 0.990_DP
   595:             !!$    ItrtMax = 10
   596:             !!$    AdjustCriterion(1:ItrtMax) = &
   597:             !!$      & (/ 0.01_DP, 0.02_DP, 0.02_DP, 0.05_DP, 0.05_DP, &
   598:             !!$      &    0.10_DP, 0.10_DP, 0.20_DP, 0.20_DP, 0.40_DP  /)
   599:                 !
   600:                 CrtlRH  = 1.0_DP
   601:                 ItrtMax = 10
   602: V====== A       AdjustCriterion(1:ItrtMax) = 0.0_DP
   603:             
   604:                 FlagAdjustMom = .false.
   605:                 FlagAdjustMR  = .false.
   606:             
   607:             
   608:                 ! NAMELIST の読み込み
   609:                 ! NAMELIST is input
   610:                 !
   611:                 if ( trim(namelist_filename) /= '' ) then
   612:                   call FileOpen( unit_nml, &          ! (out)
   613:                     & namelist_filename, mode = 'r' ) ! (in)
   614:             
   615:                   rewind( unit_nml )
   616:                   read( unit_nml,                &  ! (in)
   617:                     & nml = dry_conv_adjust_nml, &  ! (out)
   618:                     & iostat = iostat_nml )         ! (out)
   619:                   close( unit_nml )
   620:             
   621:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   622:             !!$      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
   623:                 end if
   624:             
   625:                 ! イテレーション回数, 不安定の許容誤差のチェック
   626:                 ! Check number of iteration, admissible error of unstability
   627:                 !
   628:                 call NmlutilAryValid( module_name, & ! (in)
   629:                   & AdjustCriterion, 'AdjustCriterion', &      ! (in)
   630:                   & ItrtMax,    'ItrtMax' )          ! (in)
   631:             
   632:             
   633:                 ! ヒストリデータ出力のためのへの変数登録
   634:                 ! Register of variables for history data output
   635:                 !
   636:                 call HistoryAutoAddVariable( 'DTempDtDryConv', &
   637:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /),      &
   638:                   & 'dry convective adjustment heating', 'K s-1' )
   639:             
   640:                 ! 印字 ; Print
   641:                 !
   642:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   643:                 call MessageNotify( 'M', module_name, '  CrtlRH               = %f', d = (/ CrtlRH /) )
   644:                 call MessageNotify( 'M', module_name, '  ItrtMax              = %d', i = (/ ItrtMax /) )
   645:                 call MessageNotify( 'M', module_name, '  AdjustCriterion      = (/ %f /)', &
   646:                   & d = AdjustCriterion(1:ItrtMax), n = (/ ItrtMax /) )
   647:                 call MessageNotify( 'M', module_name, '  FlagAdjustMom        = %b', l = (/ FlagAdjustMom /) )
   648:                 call MessageNotify( 'M', module_name, '  FlagAdjustMR         = %b', l = (/ FlagAdjustMR  /) )
   649:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   650:             
   651:                 dry_conv_adjust_inited = .true.
   652:             
   653:               end subroutine DryConvAdjustInit
   654:             
   655:               !--------------------------------------------------------------------------------------
   656:             
   657:             end module dry_conv_adjust
