Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:44 2016
FILE NAME: dynamics_1d_utils.f90
PROGRAM NAME: dynamics_1d_utils
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   135  vec  (   1): Vectorized loop.
   135  vec  (  29): ADB is used for array.: xyz_vadv
   135  vec  (  29): ADB is used for array.: xyz_w
   135  vec  (  29): ADB is used for array.: xyz_height
   135  vec  (  29): ADB is used for array.: xyz_array
   190  vec  (   1): Vectorized loop.
   190  vec  (  29): ADB is used for array.: z_press
   191  opt  (1084): Branch out of the loop inhibits optimization.
   191  vec  (  26): Macro operation Search.
   203  vec  (   3): Unvectorized loop.
   204  opt  (1097): This statement prevents loop optimization.
   204  opt  (1592): Outer loop unrolled inside inner loop.
   204  opt  (1592): Outer loop unrolled inside inner loop.
   204  vec  (   4): Vectorized array expression.
   204  vec  (   4): Vectorized array expression.
   204  vec  (   4): Vectorized array expression.
   204  vec  (  29): ADB is used for array.: xyz_array
   204  vec  (   4): Vectorized array expression.
   204  vec  (  29): ADB is used for array.: xyz_array
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:44 2016
FILE NAME: dynamics_1d_utils.f90
PROGRAM NAME: dynamics_1d_utils
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 1 次元計算用力学過程ユーティリティモジュール
     2  !
     3  != Utility module for dynamics for 1-D calculation
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module dynamics_1d_utils
    13    !
    14    != 1 次元計算用力学過程ユーティリティモジュール
    15    !
    16    != Utility module for dynamics for 1-D calculation
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20  
    21    !== References
    22    !
    23  !!$  !  Chou, M.-D.,
    24  !!$  !    Atmospheric solar heating rate in the water vapor bands,
    25  !!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
    26    !
    27    !== Procedures List
    28    !
    29  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    30  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    31  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    32  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    33  !!$  ! ------------            :: ------------
    34  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    35  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    36  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    37  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    38    !
    39    !== NAMELIST
    40    !
    41    ! NAMELIST#set_1d_profile_nml
    42    !
    43  
    44    ! USE statements
    45    !
    46  
    47    !
    48    ! Kind type parameter
    49    !
    50    use dc_types, only: DP, &      ! Double precision.
    51      &                 STRING, &  ! Strings.
    52      &                 TOKEN      ! Keywords.
    53  
    54    ! 格子点設定
    55    ! Grid points settings
    56    !
    57    use gridset, only: imax, & ! 経度格子点数.
    58                               ! Number of grid points in longitude
    59      &                jmax, & ! 緯度格子点数.
    60                               ! Number of grid points in latitude
    61      &                kmax    ! 鉛直層数.
    62                               ! Number of vertical level
    63  
    64    ! メッセージ出力
    65    ! Message output
    66    !
    67    use dc_message, only: MessageNotify
    68  
    69    implicit none
    70  
    71    private
    72  
    73    ! 公開変数
    74    ! Public variables
    75    !
    76    logical, save, public:: dynamics_1d_utils_inited = .false.
    77                                ! 初期設定フラグ.
    78                                ! Initialization flag
    79  
    80    public :: Dynamics1DUtilsVerAdv
    81    public :: Dynamics1DUtilsVerInterp
    82    public :: Dynamics1DUtilsInit
    83  
    84    character(*), parameter:: module_name = 'dynamics_1d_utils'
    85                                ! モジュールの名称.
    86                                ! Module name
    87    character(*), parameter:: version = &
    88      & '$Name:  $' // &
    89      & '$Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $'
    90                                ! モジュールのバージョン
    91                                ! Module version
    92  
    93  
    94    !--------------------------------------------------------------------------------------
    95  
    96  contains
    97  
    98    !--------------------------------------------------------------------------------------
    99  
   100    subroutine Dynamics1DUtilsVerAdv(  &
   101      & xyz_W, xyz_Height, xyz_Array,  &
   102      & xyz_VAdv                       &
   103      & )
   104  
   105      ! モジュール引用 ; USE statements
   106      !
   107  
   108      real(DP), intent(in ) :: xyz_W     (0:imax-1,1:jmax,1:kmax)
   109      real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
   110      real(DP), intent(in ) :: xyz_Array (0:imax-1,1:jmax,1:kmax)
   111      real(DP), intent(out) :: xyz_VAdv  (0:imax-1,1:jmax,1:kmax)
   112  
   113  
   114      !
   115      ! local variables
   116      !
   117      integer :: i
   118      integer :: j
   119      integer :: k
   120      integer :: kp
   121      integer :: kn
   122  
   123  
   124      ! 初期化確認
   125      ! Initialization check
   126      !
   127      if ( .not. dynamics_1d_utils_inited ) then
   128        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   129      end if
   130  
   131  
   132      do k = 1, kmax
   133  
   134        do j = 1, jmax
   135          do i = 0, imax-1
   136  
   137  !!$          kp = max( k - 1, 1    )
   138  !!$          kn = min( k + 1, kmax )
   139            if ( xyz_W(i,j,k) >= 0.0_DP ) then
   140              kp = max( k - 1, 1    )
   141              kn = kp + 1
   142            else
   143              kn = min( k + 1, kmax )
   144              kp = kn - 1
   145            end if
   146            xyz_VAdv(i,j,k) =                                                &
   147              & - xyz_W(i,j,k) * ( xyz_Array (i,j,kn) - xyz_Array (i,j,kp) ) &
   148              &                / ( xyz_Height(i,j,kn) - xyz_Height(i,j,kp) )
   149          end do
   150        end do
   151  
   152      end do
   153  
   154    end subroutine Dynamics1DUtilsVerAdv
   155  
   156    !--------------------------------------------------------------------------------------
   157  
   158    subroutine Dynamics1DUtilsVerInterp( &
   159      & NLev, z_Press, z_Array,          &
   160      & xyz_Press,                       &
   161      & xyz_Array                        &
   162      & )
   163  
   164      integer , intent(in ) :: NLev
   165      real(DP), intent(in ) :: z_Press  (1:NLev)
   166      real(DP), intent(in ) :: z_Array  (1:NLev)
   167      real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   168      real(DP), intent(out) :: xyz_Array(0:imax-1,1:jmax,1:kmax)
   169  
   170  
   171      !
   172      ! local variables
   173      !
   174      integer  :: k
   175      integer  :: kk
   176  
   177  
   178      ! 初期化確認
   179      ! Initiarization check
   180      !
   181      if ( .not. dynamics_1d_utils_inited ) then
   182        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   183      end if
   184  
   185  
   186      do k = 1, kmax
   187        if( xyz_Press(0,1,k) <= z_Press(NLev) ) then
   188          xyz_Array(0,1,k) = z_Array(NLev)
   189        else
   190          search_loop : do kk = 2, NLev
   191            if( z_Press( kk ) < xyz_Press(0,1,k) ) exit search_loop
   192          end do search_loop
   193          if( kk > NLev ) &
   194            stop 'Unexpected error in setting vertical profile'
   195          xyz_Array(0,1,k) =                                  &
   196            &   ( z_Array( kk ) - z_Array( kk-1 ) )   &
   197            & / ( log( z_Press( kk )    / z_Press( kk-1 ) ) ) &
   198            & * ( log( xyz_Press(0,1,k) / z_Press( kk-1 ) ) ) &
   199            & + z_Array( kk-1 )
   200        end if
   201      end do
   202  
   203      do k = 1, kmax
   204        xyz_Array(:,:,k) = xyz_Array(0,1,k)
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j1 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t127 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t129 = 1, 1 + imax - min0(1,imax)                        
     .                 %IG0(t129,t127) = xyz_array(0,1,k)                       
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t127 = j1 + 1, 1 + jmax - min0(1,jmax), 4                   
     .  !cdir       nodep                                                       
     .              do t129 = 1, 1 + imax - min0(1,imax)                        
     .                 d1 = xyz_array(0,1,k)                                    
     .                 %IG0(t129,t127) = d1                                     
     .                 %IG0(t129,t127+1) = d1                                   
     .                 %IG0(t129,t127+2) = d1                                   
     .                 %IG0(t129,t127+3) = d1                                   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j2 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t133 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t135 = 1, 1 + imax - min0(1,imax)                        
     .                 xyz_array(t135-1,t133,k) = %IG0(t135,t133)               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t133 = j2 + 1, 1 + jmax - min0(1,jmax), 4                   
     .  !cdir       nodep                                                       
     .              do t135 = 1, 1 + imax - min0(1,imax)                        
     .                 xyz_array(t135-1,t133,k) = %IG0(t135,t133)               
     .                 xyz_array(t135-1,t133+1,k) = %IG0(t135,t133+1)           
     .                 xyz_array(t135-1,t133+2,k) = %IG0(t135,t133+2)           
     .                 xyz_array(t135-1,t133+3,k) = %IG0(t135,t133+3)           
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   205      end do
   206  
   207  
   208    end subroutine Dynamics1DUtilsVerInterp
   209  
   210    !--------------------------------------------------------------------------------------
   211  
   212    subroutine Dynamics1DUtilsInit
   213  
   214      ! 文字列操作
   215      ! Character handling
   216      !
   217  !!$    use dc_string, only: toChar
   218  
   219      ! NAMELIST ファイル入力に関するユーティリティ
   220      ! Utilities for NAMELIST file input
   221      !
   222  !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   223  
   224      ! ファイル入出力補助
   225      ! File I/O support
   226      !
   227  !!$    use dc_iounit, only: FileOpen
   228  
   229  
   230      ! 宣言文 ; Declaration statements
   231      !
   232  
   233  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   234  !!$                              ! Unit number for NAMELIST file open
   235  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   236  !!$                              ! IOSTAT of NAMELIST read
   237  
   238  
   239      ! NAMELIST 変数群
   240      ! NAMELIST group name
   241      !
   242  !!$    namelist /set_TWPICE_profile_nml/ &
   243  !!$      & InFileNameSounding, &
   244  !!$      & InFileNameForcing
   245            !
   246            ! デフォルト値については初期化手続 "set_GATE_profile#SetGATEProfileInit"
   247            ! のソースコードを参照のこと.
   248            !
   249            ! Refer to source codes in the initialization procedure
   250            ! "set_GATE_profile#SetGATEProfileInit" for the default values.
   251            !
   252  
   253      ! デフォルト値の設定
   254      ! Default values settings
   255      !
   256  
   257  
   258      ! NAMELIST の読み込み
   259      ! NAMELIST is input
   260      !
   261  !!$    if ( trim(namelist_filename) /= '' ) then
   262  !!$      call FileOpen( unit_nml, &          ! (out)
   263  !!$        & namelist_filename, mode = 'r' ) ! (in)
   264  !!$
   265  !!$      rewind( unit_nml )
   266  !!$      read( unit_nml,                     & ! (in)
   267  !!$        & nml = set_TWPICE_profile_nml,   & ! (out)
   268  !!$        & iostat = iostat_nml )             ! (out)
   269  !!$      close( unit_nml )
   270  !!$
   271  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   272  !!$    end if
   273  
   274  
   275  
   276      ! 印字 ; Print
   277      !
   278      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   279  !!$    call MessageNotify( 'M', module_name, 'InFileNameSounding = %c', c1 = trim(InFileNameSounding) )
   280  !!$    call MessageNotify( 'M', module_name, 'InFileNameForcing  = %c', c1 = trim(InFileNameForcing ) )
   281      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   282  
   283  
   284      dynamics_1d_utils_inited = .true.
   285  
   286  
   287    end subroutine Dynamics1DUtilsInit
   288  
   289    !--------------------------------------------------------------------------------------
   290  
   291    subroutine Dynamics1DUtilsFinalize
   292  
   293  
   294      ! 宣言文 ; Declaration statements
   295      !
   296  
   297  
   298  
   299      dynamics_1d_utils_inited = .false.
   300  
   301  
   302    end subroutine Dynamics1DUtilsFinalize
   303  
   304    !--------------------------------------------------------------------------------------
   305  
   306  end module dynamics_1d_utils
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:44 2016
FILE NAME: dynamics_1d_utils.f90
PROGRAM NAME: dynamics_1d_utils
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 1 次元計算用力学過程ユーティリティモジュール
     2:             !
     3:             != Utility module for dynamics for 1-D calculation
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module dynamics_1d_utils
    13:               !
    14:               != 1 次元計算用力学過程ユーティリティモジュール
    15:               !
    16:               != Utility module for dynamics for 1-D calculation
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:             
    21:               !== References
    22:               !
    23:             !!$  !  Chou, M.-D.,
    24:             !!$  !    Atmospheric solar heating rate in the water vapor bands,
    25:             !!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
    26:               !
    27:               !== Procedures List
    28:               !
    29:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    30:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    31:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    32:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    33:             !!$  ! ------------            :: ------------
    34:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    35:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    36:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    37:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    38:               !
    39:               !== NAMELIST
    40:               !
    41:               ! NAMELIST#set_1d_profile_nml
    42:               !
    43:             
    44:               ! USE statements
    45:               !
    46:             
    47:               !
    48:               ! Kind type parameter
    49:               !
    50:               use dc_types, only: DP, &      ! Double precision.
    51:                 &                 STRING, &  ! Strings.
    52:                 &                 TOKEN      ! Keywords.
    53:             
    54:               ! 格子点設定
    55:               ! Grid points settings
    56:               !
    57:               use gridset, only: imax, & ! 経度格子点数.
    58:                                          ! Number of grid points in longitude
    59:                 &                jmax, & ! 緯度格子点数.
    60:                                          ! Number of grid points in latitude
    61:                 &                kmax    ! 鉛直層数.
    62:                                          ! Number of vertical level
    63:             
    64:               ! メッセージ出力
    65:               ! Message output
    66:               !
    67:               use dc_message, only: MessageNotify
    68:             
    69:               implicit none
    70:             
    71:               private
    72:             
    73:               ! 公開変数
    74:               ! Public variables
    75:               !
    76:               logical, save, public:: dynamics_1d_utils_inited = .false.
    77:                                           ! 初期設定フラグ.
    78:                                           ! Initialization flag
    79:             
    80:               public :: Dynamics1DUtilsVerAdv
    81:               public :: Dynamics1DUtilsVerInterp
    82:               public :: Dynamics1DUtilsInit
    83:             
    84:               character(*), parameter:: module_name = 'dynamics_1d_utils'
    85:                                           ! モジュールの名称.
    86:                                           ! Module name
    87:               character(*), parameter:: version = &
    88:                 & '$Name:  $' // &
    89:                 & '$Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $'
    90:                                           ! モジュールのバージョン
    91:                                           ! Module version
    92:             
    93:             
    94:               !--------------------------------------------------------------------------------------
    95:             
    96:             contains
    97:             
    98:               !--------------------------------------------------------------------------------------
    99:             
   100:               subroutine Dynamics1DUtilsVerAdv(  &
   101:                 & xyz_W, xyz_Height, xyz_Array,  &
   102:                 & xyz_VAdv                       &
   103:                 & )
   104:             
   105:                 ! モジュール引用 ; USE statements
   106:                 !
   107:             
   108:                 real(DP), intent(in ) :: xyz_W     (0:imax-1,1:jmax,1:kmax)
   109:                 real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
   110:                 real(DP), intent(in ) :: xyz_Array (0:imax-1,1:jmax,1:kmax)
   111:                 real(DP), intent(out) :: xyz_VAdv  (0:imax-1,1:jmax,1:kmax)
   112:             
   113:             
   114:                 !
   115:                 ! local variables
   116:                 !
   117:                 integer :: i
   118:                 integer :: j
   119:                 integer :: k
   120:                 integer :: kp
   121:                 integer :: kn
   122:             
   123:             
   124:                 ! 初期化確認
   125:                 ! Initialization check
   126:                 !
   127:                 if ( .not. dynamics_1d_utils_inited ) then
   128:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   129:                 end if
   130:             
   131:             
   132: +------>        do k = 1, kmax
   133: |           
   134: |+----->          do j = 1, jmax
   135: ||V---->            do i = 0, imax-1
   136: |||         
   137: |||         !!$          kp = max( k - 1, 1    )
   138: |||         !!$          kn = min( k + 1, kmax )
   139: |||     A             if ( xyz_W(i,j,k) >= 0.0_DP ) then
   140: |||                     kp = max( k - 1, 1    )
   141: |||                     kn = kp + 1
   142: |||                   else
   143: |||                     kn = min( k + 1, kmax )
   144: |||                     kp = kn - 1
   145: |||                   end if
   146: |||     A             xyz_VAdv(i,j,k) =                                                &
   147: |||                     & - xyz_W(i,j,k) * ( xyz_Array (i,j,kn) - xyz_Array (i,j,kp) ) &
   148: |||                     &                / ( xyz_Height(i,j,kn) - xyz_Height(i,j,kp) )
   149: ||V----             end do
   150: |+-----           end do
   151: |           
   152: +------         end do
   153:             
   154:               end subroutine Dynamics1DUtilsVerAdv
   155:             
   156:               !--------------------------------------------------------------------------------------
   157:             
   158:               subroutine Dynamics1DUtilsVerInterp( &
   159:                 & NLev, z_Press, z_Array,          &
   160:                 & xyz_Press,                       &
   161:                 & xyz_Array                        &
   162:                 & )
   163:             
   164:                 integer , intent(in ) :: NLev
   165:                 real(DP), intent(in ) :: z_Press  (1:NLev)
   166:                 real(DP), intent(in ) :: z_Array  (1:NLev)
   167:                 real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   168:                 real(DP), intent(out) :: xyz_Array(0:imax-1,1:jmax,1:kmax)
   169:             
   170:             
   171:                 !
   172:                 ! local variables
   173:                 !
   174:                 integer  :: k
   175:                 integer  :: kk
   176:             
   177:             
   178:                 ! 初期化確認
   179:                 ! Initiarization check
   180:                 !
   181:                 if ( .not. dynamics_1d_utils_inited ) then
   182:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   183:                 end if
   184:             
   185:             
   186: +------>        do k = 1, kmax
   187: |                 if( xyz_Press(0,1,k) <= z_Press(NLev) ) then
   188: |                   xyz_Array(0,1,k) = z_Array(NLev)
   189: |                 else
   190: |V----->            search_loop : do kk = 2, NLev
   191: ||      A             if( z_Press( kk ) < xyz_Press(0,1,k) ) exit search_loop
   192: |V-----             end do search_loop
   193: |                   if( kk > NLev ) &
   194: |                     stop 'Unexpected error in setting vertical profile'
   195: |                   xyz_Array(0,1,k) =                                  &
   196: |                     &   ( z_Array( kk ) - z_Array( kk-1 ) )   &
   197: |                     & / ( log( z_Press( kk )    / z_Press( kk-1 ) ) ) &
   198: |                     & * ( log( xyz_Press(0,1,k) / z_Press( kk-1 ) ) ) &
   199: |                     & + z_Array( kk-1 )
   200: |                 end if
   201: +------         end do
   202:             
   203: +------>        do k = 1, kmax
   204: |+V==== A         xyz_Array(:,:,k) = xyz_Array(0,1,k)
   205: +------         end do
   206:             
   207:             
   208:               end subroutine Dynamics1DUtilsVerInterp
   209:             
   210:               !--------------------------------------------------------------------------------------
   211:             
   212:               subroutine Dynamics1DUtilsInit
   213:             
   214:                 ! 文字列操作
   215:                 ! Character handling
   216:                 !
   217:             !!$    use dc_string, only: toChar
   218:             
   219:                 ! NAMELIST ファイル入力に関するユーティリティ
   220:                 ! Utilities for NAMELIST file input
   221:                 !
   222:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   223:             
   224:                 ! ファイル入出力補助
   225:                 ! File I/O support
   226:                 !
   227:             !!$    use dc_iounit, only: FileOpen
   228:             
   229:             
   230:                 ! 宣言文 ; Declaration statements
   231:                 !
   232:             
   233:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   234:             !!$                              ! Unit number for NAMELIST file open
   235:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   236:             !!$                              ! IOSTAT of NAMELIST read
   237:             
   238:             
   239:                 ! NAMELIST 変数群
   240:                 ! NAMELIST group name
   241:                 !
   242:             !!$    namelist /set_TWPICE_profile_nml/ &
   243:             !!$      & InFileNameSounding, &
   244:             !!$      & InFileNameForcing
   245:                       !
   246:                       ! デフォルト値については初期化手続 "set_GATE_profile#SetGATEProfileInit"
   247:                       ! のソースコードを参照のこと.
   248:                       !
   249:                       ! Refer to source codes in the initialization procedure
   250:                       ! "set_GATE_profile#SetGATEProfileInit" for the default values.
   251:                       !
   252:             
   253:                 ! デフォルト値の設定
   254:                 ! Default values settings
   255:                 !
   256:             
   257:             
   258:                 ! NAMELIST の読み込み
   259:                 ! NAMELIST is input
   260:                 !
   261:             !!$    if ( trim(namelist_filename) /= '' ) then
   262:             !!$      call FileOpen( unit_nml, &          ! (out)
   263:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   264:             !!$
   265:             !!$      rewind( unit_nml )
   266:             !!$      read( unit_nml,                     & ! (in)
   267:             !!$        & nml = set_TWPICE_profile_nml,   & ! (out)
   268:             !!$        & iostat = iostat_nml )             ! (out)
   269:             !!$      close( unit_nml )
   270:             !!$
   271:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   272:             !!$    end if
   273:             
   274:             
   275:             
   276:                 ! 印字 ; Print
   277:                 !
   278:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   279:             !!$    call MessageNotify( 'M', module_name, 'InFileNameSounding = %c', c1 = trim(InFileNameSounding) )
   280:             !!$    call MessageNotify( 'M', module_name, 'InFileNameForcing  = %c', c1 = trim(InFileNameForcing ) )
   281:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   282:             
   283:             
   284:                 dynamics_1d_utils_inited = .true.
   285:             
   286:             
   287:               end subroutine Dynamics1DUtilsInit
   288:             
   289:               !--------------------------------------------------------------------------------------
   290:             
   291:               subroutine Dynamics1DUtilsFinalize
   292:             
   293:             
   294:                 ! 宣言文 ; Declaration statements
   295:                 !
   296:             
   297:             
   298:             
   299:                 dynamics_1d_utils_inited = .false.
   300:             
   301:             
   302:               end subroutine Dynamics1DUtilsFinalize
   303:             
   304:               !--------------------------------------------------------------------------------------
   305:             
   306:             end module dynamics_1d_utils
