Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:44 2016
FILE NAME: dynamics_physicsonly.f90
PROGRAM NAME: dynamics_physicsonly
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   246  opt  (1593): Loop nest collapsed into one loop.
   246  vec  (   4): Vectorized array expression.
   246  vec  (  29): ADB is used for array.: xyz_pottempb
   246  vec  (  29): ADB is used for array.: xyz_exner
   246  vec  (  29): ADB is used for array.: xyz_tempb
   250  vec  (   3): Unvectorized loop.
   250  vec  (  13): Overhead of loop division is too large.
   251  opt  (1593): Loop nest collapsed into one loop.
   251  vec  (   4): Vectorized array expression.
   251  vec  (  29): ADB is used for array.: xyz_w
   251  vec  (  29): ADB is used for array.: xy_surfheight
   251  vec  (  29): ADB is used for array.: xyz_height
   256  opt  (1592): Outer loop unrolled inside inner loop.
   256  vec  (   4): Vectorized array expression.
   256  vec  (  29): ADB is used for array.: xyz_w
   256  vec  (   4): Vectorized array expression.
   256  vec  (  29): ADB is used for array.: xyz_w
   259  opt  (1593): Loop nest collapsed into one loop.
   259  vec  (   4): Vectorized array expression.
   259  vec  (  29): ADB is used for array.: xyz_w
   277  vec  (   3): Unvectorized loop.
   279  opt  (1017): Subroutine call prevents optimization.
   284  opt  (1593): Loop nest collapsed into one loop.
   284  vec  (   4): Vectorized array expression.
   284  vec  (  29): ADB is used for array.: xyzf_dqmixdtadv
   288  opt  (1593): Loop nest collapsed into one loop.
   288  vec  (   4): Vectorized array expression.
   288  vec  (  29): ADB is used for array.: xy_psa
   288  vec  (  29): ADB is used for array.: xy_psb
   291  opt  (  11): Fused array assignments. :line 291 - 294
   291  vec  (   4): Vectorized array expression.
   291  vec  (  29): ADB is used for array.: xyz_va
   291  vec  (  29): ADB is used for array.: xyz_vb
   291  vec  (  29): ADB is used for array.: xyz_dvdtphy
   291  vec  (  29): ADB is used for array.: xyz_dvdtadv
   291  vec  (  29): ADB is used for array.: xyz_ub
   291  vec  (  29): ADB is used for array.: xyz_corpar
   291  vec  (  29): ADB is used for array.: xyz_ua
   291  vec  (  29): ADB is used for array.: xyz_dudtphy
   291  vec  (  29): ADB is used for array.: xyz_dudtadv
   298  opt  (  11): Fused array assignments. :line 298 - 305
   298  opt  (1592): Outer loop unrolled inside inner loop.
   298  vec  (   4): Vectorized array expression.
   298  vec  (  29): ADB is used for array.: xyz_va
   298  vec  (  29): ADB is used for array.: xyz_ua
   298  vec  (  29): ADB is used for array.: xyz_corpar
   298  vec  (  29): ADB is used for array.: xyz_dvdtphy
   298  vec  (  29): ADB is used for array.: xyz_dvdtadv
   298  vec  (  29): ADB is used for array.: xyz_vb
   298  vec  (  29): ADB is used for array.: xyz_dudtphy
   298  vec  (  29): ADB is used for array.: xyz_dudtadv
   298  vec  (  29): ADB is used for array.: xyz_ub
   298  vec  (   4): Vectorized array expression.
   298  vec  (  29): ADB is used for array.: xyz_va
   298  vec  (  29): ADB is used for array.: xyz_ua
   298  vec  (  29): ADB is used for array.: xyz_corpar
   298  vec  (  29): ADB is used for array.: xyz_dvdtphy
   298  vec  (  29): ADB is used for array.: xyz_dvdtadv
   298  vec  (  29): ADB is used for array.: xyz_vb
   298  vec  (  29): ADB is used for array.: xyz_dudtphy
   298  vec  (  29): ADB is used for array.: xyz_dudtadv
   298  vec  (  29): ADB is used for array.: xyz_ub
   313  opt  (  11): Fused array assignments. :line 313 - 315
   313  opt  (1593): Loop nest collapsed into one loop.
   313  vec  (   4): Vectorized array expression.
   313  vec  (  29): ADB is used for array.: xyz_tempa
   313  vec  (  29): ADB is used for array.: xyz_exner
   313  vec  (  29): ADB is used for array.: xyz_dtempdtphy
   313  vec  (  29): ADB is used for array.: xyz_dpottempdtadv
   313  vec  (  29): ADB is used for array.: xyz_pottempb
   317  opt  (  11): Fused array assignments. :line 317 - 319
   317  opt  (1593): Loop nest collapsed into one loop.
   317  vec  (   4): Vectorized array expression.
   317  vec  (  29): ADB is used for array.: xyzf_qmixa
   317  vec  (  29): ADB is used for array.: xyzf_dqmixdtphy
   317  vec  (  29): ADB is used for array.: xyzf_dqmixdtadv
   317  vec  (  29): ADB is used for array.: xyzf_qmixb
   322  warn (  83): Dummy argument "xy_psn" is not used.
   322  warn (  83): Dummy argument "xyzf_qmixn" is not used.
   322  warn (  83): Dummy argument "xyz_tempn" is not used.
   322  warn (  83): Dummy argument "xyz_vn" is not used.
   322  warn (  83): Dummy argument "xyz_un" is not used.
   432  opt  (1592): Outer loop unrolled inside inner loop.
   432  vec  (   3): Unvectorized loop.
   432  vec  (  13): Overhead of loop division is too large.
   432  vec  (   3): Unvectorized loop.
   432  vec  (  13): Overhead of loop division is too large.
   433  vec  (   4): Vectorized array expression.
   433  vec  (  29): ADB is used for array.: xyz_corpar
   433  vec  (   4): Vectorized array expression.
   433  vec  (  29): ADB is used for array.: xyz_corpar
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:44 2016
FILE NAME: dynamics_physicsonly.f90
PROGRAM NAME: dynamics_physicsonly
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 物理過程のみの計算のための力学過程
     2  !
     3  != A dynamics for calculation with physical processes only
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: dynamics_physicsonly.f90,v 1.7 2015/01/31 06:16:26 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module dynamics_physicsonly
    13    !
    14    != 物理過程のみの計算のための力学過程
    15    !
    16    != A dynamics for calculation with physical processes only
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22    !== NAMELIST
    23    !
    24    !
    25  
    26    ! モジュール引用 ; USE statements
    27    !
    28  
    29    ! 格子点設定
    30    ! Grid points settings
    31    !
    32    use gridset, only: imax, & ! 経度格子点数.
    33                               ! Number of grid points in longitude
    34      &                jmax, & ! 緯度格子点数.
    35                               ! Number of grid points in latitude
    36      &                kmax    ! 鉛直層数.
    37                               ! Number of vertical level
    38    ! 組成に関わる配列の設定
    39    ! Settings of array for atmospheric composition
    40    !
    41    use composition, only: &
    42      &                    ncmax
    43                                ! 成分の数
    44                                ! Number of composition
    45  
    46    ! 種別型パラメタ
    47    ! Kind type parameter
    48    !
    49    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    50      &                 STRING     ! 文字列.       Strings.
    51  
    52    ! メッセージ出力
    53    ! Message output
    54    !
    55    use dc_message, only: MessageNotify
    56  
    57    ! 宣言文 ; Declaration statements
    58    !
    59    implicit none
    60    private
    61  
    62    ! 公開手続き
    63    ! Public procedure
    64    !
    65    public :: DynamicsPhysicsOnly
    66    public :: DynamicsPhysicsOnlyInit
    67  
    68    ! 公開変数
    69    ! Public variables
    70    !
    71  
    72    ! 非公開変数
    73    ! Private variables
    74    !
    75    real(DP), allocatable, save :: xyz_CorPar(:,:,:)
    76    real(DP)             , save :: UGeo
    77    real(DP)             , save :: VGeo
    78    real(DP)             , save :: WMagnitude
    79    real(DP)             , save :: WHeight
    80    real(DP)             , save :: WTimeInit
    81  
    82    logical              , save :: FlagDynExp
    83  
    84    logical, save :: dynamics_physicsonly_inited = .false.
    85                                ! 初期設定フラグ.
    86                                ! Initialization flag
    87  
    88  
    89    character(*), parameter:: module_name = 'dynamics_physicsonly'
    90                                ! モジュールの名称.
    91                                ! Module name
    92    character(*), parameter:: version = &
    93      & '$Name:  $' // &
    94      & '$Id: dynamics_physicsonly.f90,v 1.7 2015/01/31 06:16:26 yot Exp $'
    95                                ! モジュールのバージョン
    96                                ! Module version
    97  
    98    ! INTERFACE 文 ; INTERFACE statements
    99    !
   100  
   101  contains
   102  
   103    subroutine DynamicsPhysicsOnly(                                &
   104      & xyz_Exner, xy_SurfHeight, xyz_Height,                      & ! (in)
   105      & xyz_DUDtPhy, xyz_DVDtPhy, xyz_DTempDtPhy, xyzf_DQMixDtPhy, & ! (in)
   106      & xy_PsB, xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB,             & ! (in)
   107      & xy_PsN, xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN,             & ! (in)
   108      & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA              & ! (out)
   109      & )
   110  
   111      ! モジュール引用 ; USE statements
   112      !
   113  
   114      ! 時刻管理
   115      ! Time control
   116      !
   117      use timeset, only: &
   118        & DelTime, &            ! $ \Delta t $ [s]
   119        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   120        & TimesetClockStart, TimesetClockStop
   121  
   122      ! デバッグ用ユーティリティ
   123      ! Utilities for debug
   124      !
   125      use dc_trace, only: DbgMessage, BeginSub, EndSub
   126  
   127      ! 組成に関わる配列の設定
   128      ! Settings of array for atmospheric composition
   129      !
   130      use composition, only:                              &
   131        &                    ncmax,                       &
   132                                 ! 成分の数
   133                                 ! Number of composition
   134        &                    CompositionInqFlagAdv
   135  
   136      ! 1 次元計算用力学過程ユーティリティモジュール
   137      ! Utility module for dynamics for 1-D calculation
   138      !
   139      use dynamics_1d_utils, only : Dynamics1DUtilsVerAdv
   140  
   141  !!$    ! 質量の補正
   142  !!$    ! Mass fixer
   143  !!$    !
   144  !!$    use mass_fixer, only: MassFixerColumn
   145  
   146  
   147      ! 宣言文 ; Declaration statements
   148      !
   149  
   150      real(DP), intent(in):: xyz_Exner      (0:imax-1, 1:jmax, 1:kmax)
   151      real(DP), intent(in):: xy_SurfHeight  (0:imax-1, 1:jmax)
   152      real(DP), intent(in):: xyz_Height     (0:imax-1, 1:jmax, 1:kmax)
   153  
   154      real(DP), intent(in):: xyz_DUDtPhy    (0:imax-1, 1:jmax, 1:kmax)
   155                                ! $ \left(\DP{u}{t}\right)^{phy} $ .
   156                                ! 外力項 (物理過程) による東西風速変化.
   157                                ! Eastward wind tendency by external force terms (physical processes)
   158      real(DP), intent(in):: xyz_DVDtPhy    (0:imax-1, 1:jmax, 1:kmax)
   159                                ! $ \left(\DP{v}{t}\right)^{phy} $ .
   160                                ! 外力項 (物理過程) による南北風速変化.
   161                                ! Northward wind tendency by external force terms (physicalprocesses)
   162      real(DP), intent(in):: xyz_DTempDtPhy (0:imax-1, 1:jmax, 1:kmax)
   163                                ! $ \left(\DP{T}{t}\right)^{phy} $ .
   164                                ! 外力項 (物理過程) による温度変化.
   165                                ! Temperature tendency by external force terms (physical processes)
   166      real(DP), intent(in):: xyzf_DQMixDtPhy (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   167                                ! $ \left(\DP{q}{t}\right)^{phy} $ .
   168                                ! 外力項 (物理過程) による比湿変化.
   169                                ! Temperature tendency by external force terms (physical processes)
   170      real(DP), intent(in ):: xy_PsB(0:imax-1, 1:jmax)
   171                                ! $ p_s $ . 地表面気圧 (半整数レベル).
   172                                ! Surface pressure (half level)
   173      real(DP), intent(in ):: xyz_UB(0:imax-1, 1:jmax, 1:kmax)
   174                                ! $ u $ . 東西風速. Eastward wind
   175      real(DP), intent(in ):: xyz_VB(0:imax-1, 1:jmax, 1:kmax)
   176                                ! $ v $ . 南北風速. Northward wind
   177      real(DP), intent(in ):: xyz_TempB(0:imax-1, 1:jmax, 1:kmax)
   178                                ! $ T $ . 温度 (整数レベル).
   179                                ! Temperature (full level)
   180      real(DP), intent(in ):: xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   181                                ! $ q $ .     比湿. Specific humidity
   182      real(DP), intent(in):: xy_PsN    (0:imax-1, 1:jmax)
   183                                ! $ p_s (t) $ .   地表面気圧. Surface pressure
   184      real(DP), intent(in):: xyz_UN   (0:imax-1, 1:jmax, 1:kmax)
   185                                ! $ u (t) $ .     東西風速. Eastward wind
   186      real(DP), intent(in):: xyz_VN   (0:imax-1, 1:jmax, 1:kmax)
   187                                ! $ v (t) $ .     南北風速. Northward wind
   188      real(DP), intent(in):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
   189                                ! $ T (t) $ .     温度. Temperature
   190      real(DP), intent(in):: xyzf_QMixN(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   191                                ! $ q (t) $ .     比湿. Specific humidity
   192      real(DP), intent(out):: xy_PsA(0:imax-1, 1:jmax)
   193                                ! $ p_s $ . 地表面気圧 (半整数レベル).
   194                                ! Surface pressure (half level)
   195      real(DP), intent(out):: xyz_UA(0:imax-1, 1:jmax, 1:kmax)
   196                                ! $ u $ . 東西風速. Eastward wind
   197      real(DP), intent(out):: xyz_VA(0:imax-1, 1:jmax, 1:kmax)
   198                                ! $ v $ . 南北風速. Northward wind
   199      real(DP), intent(out):: xyz_TempA(0:imax-1, 1:jmax, 1:kmax)
   200                                ! $ T $ . 温度 (整数レベル).
   201                                ! Temperature (full level)
   202      real(DP), intent(out):: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   203                                ! $ q $ .     比湿. Specific humidity
   204  
   205  
   206      ! 作業変数
   207      ! Work variables
   208      !
   209      real(DP) :: xyz_PotTempB     (0:imax-1, 1:jmax, 1:kmax)
   210  
   211      real(DP) :: xyz_W            (0:imax-1, 1:jmax, 1:kmax)
   212  
   213      real(DP) :: xyz_DUDtAdv      (0:imax-1, 1:jmax, 1:kmax)
   214      real(DP) :: xyz_DVDtAdv      (0:imax-1, 1:jmax, 1:kmax)
   215      real(DP) :: xyz_DPotTempDtAdv(0:imax-1, 1:jmax, 1:kmax)
   216      real(DP) :: xyzf_DQMixDtAdv  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   217  
   218      real(DP) :: xyz_UT           (0:imax-1, 1:jmax, 1:kmax)
   219      real(DP) :: xyz_VT           (0:imax-1, 1:jmax, 1:kmax)
   220  
   221      real(DP) :: DelTimeX2
   222  
   223      integer:: k
   224      integer:: n
   225  
   226      ! 実行文 ; Executable statement
   227      !
   228  
   229      ! 初期化確認
   230      ! Initialization check
   231      !
   232      if ( .not. dynamics_physicsonly_inited ) then
   233        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   234      end if
   235  
   236  
   237      ! 計算時間計測開始
   238      ! Start measurement of computation time
   239      !
   240      call TimesetClockStart( module_name )
   241  
   242  
   243      DelTimeX2 = 2.0_DP * DelTime
   244  
   245  
   246      xyz_PotTempB = xyz_TempB / xyz_Exner
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t639 = 1, kmax*jmax*imax                                       
     .           xyz_pottempb(t639-1,1,1) = xyz_tempb(t639-1,1,1)/xyz_exner(t639
     .       1      -1,1,1)                                                     
     .        enddo                                                             
   247  
   248      if ( TimeN >= WTimeInit ) then
   249        if ( WHeight > 0.0_DP ) then
   250          do k = 1, kmax
   251            xyz_W(:,:,k) =                                                     &
     .        d1 = wmagnitude/wheight                                           
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surfheight)                                             
     .        do t859 = 1, jmax*imax                                            
     .           xyz_w(t859-1,1,k) = min(xyz_height(t859-1,1,k)-xy_surfheight(  
     .       1      t859-1,1),wheight)*d1                                       
     .        enddo                                                             
   252              & WMagnitude * min( xyz_Height(:,:,k) - xy_SurfHeight, WHeight ) &
   253              &            / WHeight
   254          end do
   255        else
   256          xyz_W = 0.0_DP
     .        if (1 + xyz_w.DSC.U2 - min0(1,xyz_w.DSC.U2) .gt. 0) then          
     .           j1 = and(1 + xyz_w.DSC.U2 - min0(1,xyz_w.DSC.U2),3)            
     .  !cdir    nodep                                                          
     .           do t852 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t854 = 1, xyz_w.DSC.U1 + 2 - min0(1,xyz_w.DSC.U1 + 1)    
     .                 xyz_w(t854-1,t852,t850+1) = 0.0000000000000000e+000      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t852 = j1 + 1, 1 + xyz_w.DSC.U2 - min0(1,xyz_w.DSC.U2), 4   
     .  !cdir       nodep                                                       
     .              do t854 = 1, xyz_w.DSC.U1 + 2 - min0(1,xyz_w.DSC.U1 + 1)    
     .                 xyz_w(t854-1,t852,t850+1) = 0.0000000000000000e+000      
     .                 xyz_w(t854-1,t852+1,t850+1) = 0.0000000000000000e+000    
     .                 xyz_w(t854-1,t852+2,t850+1) = 0.0000000000000000e+000    
     .                 xyz_w(t854-1,t852+3,t850+1) = 0.0000000000000000e+000    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   257        end if
   258      else
   259        xyz_W = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t654 = 1, xyz_w.DSC.U3*(xyz_w.DSC.U2*xyz_w.DSC.U1 +            
     .       1   xyz_w.DSC.U2)                                                  
     .           xyz_w(t654-1,1,1) = 0.0000000000000000e+000                    
     .        enddo                                                             
   260      end if
   261  
   262      ! 1 次元計算用力学過程ユーティリティモジュール
   263      ! Utility module for dynamics for 1-D calculation
   264      !
   265      call Dynamics1DUtilsVerAdv(    &
   266        & xyz_W, xyz_Height, xyz_UB, &
   267        & xyz_DUDtAdv                &
   268        & )
   269      call Dynamics1DUtilsVerAdv(    &
   270        & xyz_W, xyz_Height, xyz_VB, &
   271        & xyz_DVDtAdv                &
   272        & )
   273      call Dynamics1DUtilsVerAdv(          &
   274        & xyz_W, xyz_Height, xyz_PotTempB, &
   275        & xyz_DPotTempDtAdv                &
   276        & )
   277      do n = 1, ncmax
   278        if ( CompositionInqFlagAdv( n ) ) then
   279          call Dynamics1DUtilsVerAdv(          &
   280            & xyz_W, xyz_Height, xyzf_QMixB(:,:,:,n), &
   281            & xyzf_DQMixDtAdv(:,:,:,n)                &
   282            & )
   283        else
   284          xyzf_DQMixDtAdv(:,:,:,n) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t663 = 1, xyzf_dqmixdtadv.DSC.U3*(xyzf_dqmixdtadv.DSC.U2*      
     .       1   xyzf_dqmixdtadv.DSC.U1 + xyzf_dqmixdtadv.DSC.U2)               
     .           xyzf_dqmixdtadv(t663-1,1,1,n) = 0.0000000000000000e+000        
     .        enddo                                                             
   285        end if
   286      end do
   287  
   288      xy_PsA = xy_PsB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t672 = 1, jmax*imax                                            
     .           xy_psa(t672-1,1) = xy_psb(t672-1,1)                            
     .        enddo                                                             
   289  
   290      if ( FlagDynExp ) then
   291        xyz_UA = xyz_UB &
   292          & + ( xyz_DUDtAdv + xyz_CorPar * xyz_VB + xyz_DUDtPhy ) &
   293          &     * DelTimeX2
   294        xyz_VA = xyz_VB &
   295          & + ( xyz_DVDtAdv - xyz_CorPar * xyz_UB + xyz_DVDtPhy ) &
   296          &     * DelTimeX2
   297      else
   298        xyz_UT = xyz_UB + ( xyz_DUDtAdv + xyz_DUDtPhy ) * DelTimeX2
     .           if (jmax .gt. 0) then                                          
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t682 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t684 = 1, imax                                           
     .                 xyz_ut1 = xyz_ub(t684-1,t682,t680+1) + (xyz_dudtadv(t684-
     .       1            1,t682,t680+1)+xyz_dudtphy(t684-1,t682,t680+1))*      
     .       2            deltimex2                                             
     .                 xyz_vt1 = xyz_vb(t684-1,t682,t680+1) + (xyz_dvdtadv(t684-
     .       1            1,t682,t680+1)+xyz_dvdtphy(t684-1,t682,t680+1))*      
     .       2            deltimex2                                             
     .                 xyz_ua(t684-1,t682,t680+1) = (xyz_ut1 + (deltimex2*      
     .       1            xyz_corpar(t1+t684-1,t682-1+t3,t680+t5))*(xyz_vt1-vgeo
     .       2            +(deltimex2*xyz_corpar(t1+t684-1,t682-1+t3,t680+t5))* 
     .       3            ugeo))/(1.00000000000000e+000 + ((deltimex2*xyz_corpar
     .       4            (t1+t684-1,t682-1+t3,t680+t5))**2))                   
     .                 xyz_va(t684-1,t682,t680+1) = (xyz_vt1 - (deltimex2*      
     .       1            xyz_corpar(t1+t684-1,t682-1+t3,t680+t5))*(xyz_ut1-ugeo
     .       2            -(deltimex2*xyz_corpar(t1+t684-1,t682-1+t3,t680+t5))* 
     .       3            vgeo))/(1.00000000000000e+000 + ((deltimex2*xyz_corpar
     .       4            (t1+t684-1,t682-1+t3,t680+t5))**2))                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t682 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t684 = 1, imax                                           
     .                 xyz_ut(t684-1,t682,t680+1) = xyz_ub(t684-1,t682,t680+1)  
     .       1             + (xyz_dudtadv(t684-1,t682,t680+1)+xyz_dudtphy(t684-1
     .       2            ,t682,t680+1))*deltimex2                              
     .                 xyz_ut(t684-1,t682+1,t680+1) = xyz_ub(t684-1,t682+1,t680+
     .       1            1) + (xyz_dudtadv(t684-1,t682+1,t680+1)+xyz_dudtphy(  
     .       2            t684-1,t682+1,t680+1))*deltimex2                      
     .                 xyz_ut(t684-1,t682+2,t680+1) = xyz_ub(t684-1,t682+2,t680+
     .       1            1) + (xyz_dudtadv(t684-1,t682+2,t680+1)+xyz_dudtphy(  
     .       2            t684-1,t682+2,t680+1))*deltimex2                      
     .                 xyz_ut(t684-1,t682+3,t680+1) = xyz_ub(t684-1,t682+3,t680+
     .       1            1) + (xyz_dudtadv(t684-1,t682+3,t680+1)+xyz_dudtphy(  
     .       2            t684-1,t682+3,t680+1))*deltimex2                      
     .                 xyz_vt(t684-1,t682,t680+1) = xyz_vb(t684-1,t682,t680+1)  
     .       1             + (xyz_dvdtadv(t684-1,t682,t680+1)+xyz_dvdtphy(t684-1
     .       2            ,t682,t680+1))*deltimex2                              
     .                 xyz_vt(t684-1,t682+1,t680+1) = xyz_vb(t684-1,t682+1,t680+
     .       1            1) + (xyz_dvdtadv(t684-1,t682+1,t680+1)+xyz_dvdtphy(  
     .       2            t684-1,t682+1,t680+1))*deltimex2                      
     .                 xyz_vt(t684-1,t682+2,t680+1) = xyz_vb(t684-1,t682+2,t680+
     .       1            1) + (xyz_dvdtadv(t684-1,t682+2,t680+1)+xyz_dvdtphy(  
     .       2            t684-1,t682+2,t680+1))*deltimex2                      
     .                 xyz_vt(t684-1,t682+3,t680+1) = xyz_vb(t684-1,t682+3,t680+
     .       1            1) + (xyz_dvdtadv(t684-1,t682+3,t680+1)+xyz_dvdtphy(  
     .       2            t684-1,t682+3,t680+1))*deltimex2                      
     .                 xyz_ua(t684-1,t682,t680+1) = (xyz_ut(t684-1,t682,t680+1)+
     .       1            (deltimex2*xyz_corpar(t1+t684-1,t682-1+t3,t680+t5))*( 
     .       2            xyz_vt(t684-1,t682,t680+1)-vgeo+(deltimex2*xyz_corpar(
     .       3            t1+t684-1,t682-1+t3,t680+t5))*ugeo))/(                
     .       4            1.00000000000000e+000 + ((deltimex2*xyz_corpar(t1+t684
     .       5            -1,t682-1+t3,t680+t5))**2))                           
     .                 xyz_ua(t684-1,t682+1,t680+1) = (xyz_ut(t684-1,t682+1,t680
     .       1            +1)+(deltimex2*xyz_corpar(t1+t684-1,t682+t3,t680+t5))*
     .       2            (xyz_vt(t684-1,t682+1,t680+1)-vgeo+(deltimex2*        
     .       3            xyz_corpar(t1+t684-1,t682+t3,t680+t5))*ugeo))/(       
     .       4            1.00000000000000e+000 + ((deltimex2*xyz_corpar(t1+t684
     .       5            -1,t682+t3,t680+t5))**2))                             
     .                 xyz_ua(t684-1,t682+2,t680+1) = (xyz_ut(t684-1,t682+2,t680
     .       1            +1)+(deltimex2*xyz_corpar(t1+t684-1,t682+1+t3,t680+t5)
     .       2            )*(xyz_vt(t684-1,t682+2,t680+1)-vgeo+(deltimex2*      
     .       3            xyz_corpar(t1+t684-1,t682+1+t3,t680+t5))*ugeo))/(     
     .       4            1.00000000000000e+000 + ((deltimex2*xyz_corpar(t1+t684
     .       5            -1,t682+1+t3,t680+t5))**2))                           
     .                 xyz_ua(t684-1,t682+3,t680+1) = (xyz_ut(t684-1,t682+3,t680
     .       1            +1)+(deltimex2*xyz_corpar(t1+t684-1,t682+2+t3,t680+t5)
     .       2            )*(xyz_vt(t684-1,t682+3,t680+1)-vgeo+(deltimex2*      
     .       3            xyz_corpar(t1+t684-1,t682+2+t3,t680+t5))*ugeo))/(     
     .       4            1.00000000000000e+000 + ((deltimex2*xyz_corpar(t1+t684
     .       5            -1,t682+2+t3,t680+t5))**2))                           
     .                 xyz_va(t684-1,t682,t680+1) = (xyz_vt(t684-1,t682,t680+1)-
     .       1            (deltimex2*xyz_corpar(t1+t684-1,t682-1+t3,t680+t5))*( 
     .       2            xyz_ut(t684-1,t682,t680+1)-ugeo-(deltimex2*xyz_corpar(
     .       3            t1+t684-1,t682-1+t3,t680+t5))*vgeo))/(                
     .       4            1.00000000000000e+000 + ((deltimex2*xyz_corpar(t1+t684
     .       5            -1,t682-1+t3,t680+t5))**2))                           
     .                 xyz_va(t684-1,t682+1,t680+1) = (xyz_vt(t684-1,t682+1,t680
     .       1            +1)-(deltimex2*xyz_corpar(t1+t684-1,t682+t3,t680+t5))*
     .       2            (xyz_ut(t684-1,t682+1,t680+1)-ugeo-(deltimex2*        
     .       3            xyz_corpar(t1+t684-1,t682+t3,t680+t5))*vgeo))/(       
     .       4            1.00000000000000e+000 + ((deltimex2*xyz_corpar(t1+t684
     .       5            -1,t682+t3,t680+t5))**2))                             
     .                 xyz_va(t684-1,t682+2,t680+1) = (xyz_vt(t684-1,t682+2,t680
     .       1            +1)-(deltimex2*xyz_corpar(t1+t684-1,t682+1+t3,t680+t5)
     .       2            )*(xyz_ut(t684-1,t682+2,t680+1)-ugeo-(deltimex2*      
     .       3            xyz_corpar(t1+t684-1,t682+1+t3,t680+t5))*vgeo))/(     
     .       4            1.00000000000000e+000 + ((deltimex2*xyz_corpar(t1+t684
     .       5            -1,t682+1+t3,t680+t5))**2))                           
     .                 xyz_va(t684-1,t682+3,t680+1) = (xyz_vt(t684-1,t682+3,t680
     .       1            +1)-(deltimex2*xyz_corpar(t1+t684-1,t682+2+t3,t680+t5)
     .       2            )*(xyz_ut(t684-1,t682+3,t680+1)-ugeo-(deltimex2*      
     .       3            xyz_corpar(t1+t684-1,t682+2+t3,t680+t5))*vgeo))/(     
     .       4            1.00000000000000e+000 + ((deltimex2*xyz_corpar(t1+t684
     .       5            -1,t682+2+t3,t680+t5))**2))                           
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   299        xyz_VT = xyz_VB + ( xyz_DVDtAdv + xyz_DVDtPhy ) * DelTimeX2
   300        xyz_UA = &
   301          &   (   xyz_UT                                                  &
   302          &     + DelTimeX2 * xyz_CorPar                                  &
   303          &         * ( xyz_VT - VGeo + DelTimeX2 * xyz_CorPar * UGeo ) ) &
   304          & / ( 1.0_DP + ( DelTimeX2 * xyz_CorPar )**2 )
   305        xyz_VA = &
   306          &   (   xyz_VT                                                  &
   307          &     - DelTimeX2 * xyz_CorPar                                  &
   308          &         * ( xyz_UT - UGeo - DelTimeX2 * xyz_CorPar * VGeo ) ) &
   309          & / ( 1.0_DP + ( DelTimeX2 * xyz_CorPar )**2 )
   310      end if
   311  
   312  !!$    xyz_TempA  = xyz_TempB  + xyz_DTempDtPhy  * 2.0d0 * DelTime
   313      xyz_TempA = xyz_PotTempB &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t746 = 1, xyz_pottempb.DSC.U3*(xyz_pottempb.DSC.U2*            
     .       1   xyz_pottempb.DSC.U1 + xyz_pottempb.DSC.U2)                     
     .           xyz_tempa1 = xyz_pottempb(t746-1,1,1) + (xyz_dpottempdtadv(t746
     .       1      -1,1,1)+xyz_dtempdtphy(t746-1,1,1)/xyz_exner(t746-1,1,1))*  
     .       2      deltimex2                                                   
     .           xyz_tempa(t746-1,1,1) = xyz_tempa1*xyz_exner(t746-1,1,1)       
     .        enddo                                                             
   314        & + ( xyz_DPotTempDtAdv + xyz_DTempDtPhy / xyz_Exner ) * DelTimeX2
   315      xyz_TempA = xyz_TempA * xyz_Exner
   316  
   317      xyzf_QMixA = xyzf_QMixB &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t776 = 1, ncmax*kmax*jmax*imax                                 
     .           xyzf_qmixa1 = xyzf_qmixb(t776-1,1,1,1) + (xyzf_dqmixdtadv(t776-
     .       1      1,1,1,1)+xyzf_dqmixdtphy(t776-1,1,1,1))*deltimex2           
     .           xyzf_qmixa(t776-1,1,1,1) = max(xyzf_qmixa1,                    
     .       1      0.0000000000000000e+000)                                    
     .        enddo                                                             
   318        & + ( xyzf_DQMixDtAdv + xyzf_DQMixDtPhy ) * DelTimeX2
   319      xyzf_QMixA = max( xyzf_QMixA, 0.0_DP )
   320  
   321  
   322    end subroutine DynamicsPhysicsOnly
   323  
   324    !-------------------------------------------------------------------
   325  
   326    subroutine DynamicsPhysicsOnlyInit
   327  
   328      ! モジュール引用 ; USE statements
   329      !
   330  
   331      ! 物理定数設定
   332      ! Physical constants settings
   333      !
   334      use constants, only: &
   335        & Omega
   336                                ! $ \Omega $ [s-1].
   337                                ! 回転角速度.
   338                                ! Angular velocity
   339  
   340      ! 座標データ設定
   341      ! Axes data settings
   342      !
   343      use axesset, only : y_Lat
   344  
   345      ! NAMELIST ファイル入力に関するユーティリティ
   346      ! Utilities for NAMELIST file input
   347      !
   348      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   349  
   350      ! ファイル入出力補助
   351      ! File I/O support
   352      !
   353      use dc_iounit, only: FileOpen
   354  
   355      ! 1 次元計算用力学過程ユーティリティモジュール
   356      ! Utility module for dynamics for 1-D calculation
   357      !
   358      use dynamics_1d_utils, only : Dynamics1DUtilsInit
   359  
   360  
   361      ! 宣言文 ; Declaration statements
   362      !
   363  
   364      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   365                                ! Unit number for NAMELIST file open
   366      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   367                                ! IOSTAT of NAMELIST read
   368  
   369  !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   370  !!$                              ! Work variables for DO loop in longitude
   371      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   372                                ! Work variables for DO loop in latitude
   373      integer:: k
   374  
   375  
   376      ! NAMELIST 変数群
   377      ! NAMELIST group name
   378      !
   379      namelist /dynamics_physicsonly_nml/ &
   380        & FlagDynExp,                     &
   381        & UGeo, VGeo,                     &
   382        & WMagnitude, WHeight, WTimeInit
   383            !
   384            ! デフォルト値については初期化手続 "surface_flux_bulk#SurfFluxInit"
   385            ! のソースコードを参照のこと.
   386            !
   387            ! Refer to source codes in the initialization procedure
   388            ! "surface_flux_bulk#SurfFluxInit" for the default values.
   389            !
   390  
   391      ! 実行文 ; Executable statement
   392      !
   393  
   394  
   395      if ( dynamics_physicsonly_inited ) return
   396  
   397  
   398      ! デフォルト値の設定
   399      ! Default values settings
   400      !
   401      FlagDynExp = .false.
   402  
   403      UGeo = 0.0_DP
   404      VGeo = 0.0_DP
   405  
   406      WMagnitude = 0.0_DP
   407      WHeight    = 0.0_DP
   408  !!$    WMagnitude = - 0.005_DP
   409  !!$    WHeight    =   1000.0_DP
   410      WTimeInit  = 0.0_DP
   411  
   412      ! NAMELIST の読み込み
   413      ! NAMELIST is input
   414      !
   415      if ( trim(namelist_filename) /= '' ) then
   416        call FileOpen( unit_nml, &          ! (out)
   417          & namelist_filename, mode = 'r' ) ! (in)
   418  
   419        rewind( unit_nml )
   420        read( unit_nml, &                      ! (in)
   421          & nml = dynamics_physicsonly_nml, &  ! (out)
   422          & iostat = iostat_nml )              ! (out)
   423        close( unit_nml )
   424  
   425        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   426      end if
   427  
   428  
   429      allocate( xyz_CorPar(0:imax-1, 1:jmax, 1:kmax) )
   430  
   431      do k = 1, kmax
   432        do j = 1, jmax
   433          xyz_CorPar(:,j,k) = 2.0_DP * Omega * sin( y_Lat(j) )
   434        end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do t143 = 1, xyz_corpar.DSC.U1 + 1 - xyz_corpar.DSC.L1      
     .                 xyz_corpar(xyz_corpar.DSC.L1+t143-1,j,k) =               
     .       1            2.00000000000000e+000*omega*dsin(y_lat(j))            
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do t143 = 1, xyz_corpar.DSC.U1 + 1 - xyz_corpar.DSC.L1      
     .                 xyz_corpar(xyz_corpar.DSC.L1+t143-1,j,k) = (             
     .       1            2.00000000000000e+000*omega)*dsin(y_lat(j))           
     .                 xyz_corpar(xyz_corpar.DSC.L1+t143-1,j+1,k) = (           
     .       1            2.00000000000000e+000*omega)*dsin(y_lat(j+1))         
     .                 xyz_corpar(xyz_corpar.DSC.L1+t143-1,j+2,k) = (           
     .       1            2.00000000000000e+000*omega)*dsin(y_lat(j+2))         
     .                 xyz_corpar(xyz_corpar.DSC.L1+t143-1,j+3,k) = (           
     .       1            2.00000000000000e+000*omega)*dsin(y_lat(j+3))         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   435      end do
   436  
   437      ! 1 次元計算用力学過程ユーティリティモジュール
   438      ! Utility module for dynamics for 1-D calculation
   439      !
   440      call Dynamics1DUtilsInit
   441  
   442  
   443  !!$    ! ヒストリデータ出力のためのへの変数登録
   444  !!$    ! Register of variables for history data output
   445  !!$    !
   446  !!$    call HistoryAutoAddVariable( 'TauX', &
   447  !!$      & (/ 'lon ', 'lat ', 'time' /), &
   448  !!$      & 'surface stress(x)  ', 'N m-2' )
   449  !!$
   450  !!$    call HistoryAutoAddVariable( 'TauY', &
   451  !!$      & (/ 'lon ', 'lat ', 'time' /), &
   452  !!$      & 'surface stress(y)  ', 'N m-2' )
   453  !!$
   454  !!$    call HistoryAutoAddVariable( 'Sens', &
   455  !!$      & (/ 'lon ', 'lat ', 'time' /), &
   456  !!$      & 'sensible heat flux', 'W m-2' )
   457  !!$
   458  !!$    call HistoryAutoAddVariable( 'EVap', &
   459  !!$      & (/ 'lon ', 'lat ', 'time' /), &
   460  !!$      & 'latent heat flux  ', 'W m-2' )
   461  
   462      ! 印字 ; Print
   463      !
   464      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   465      call MessageNotify( 'M', module_name, '  FlagDynExp = %b', l = (/ FlagDynExp /) )
   466      call MessageNotify( 'M', module_name, '  UGeo = %f', d = (/ UGeo /) )
   467      call MessageNotify( 'M', module_name, '  VGeo = %f', d = (/ VGeo /) )
   468      call MessageNotify( 'M', module_name, '  WMagnitude = %f', d = (/ WMagnitude /) )
   469      call MessageNotify( 'M', module_name, '  WHeight    = %f', d = (/ WHeight    /) )
   470      call MessageNotify( 'M', module_name, '  WTimeInit  = %f', d = (/ WTimeInit  /) )
   471      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   472  
   473      dynamics_physicsonly_inited = .true.
   474  
   475    end subroutine DynamicsPhysicsOnlyInit
   476  
   477    !--------------------------------------------------------------------------------------
   478  
   479  end module dynamics_physicsonly
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:44 2016
FILE NAME: dynamics_physicsonly.f90
PROGRAM NAME: dynamics_physicsonly
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 物理過程のみの計算のための力学過程
     2:             !
     3:             != A dynamics for calculation with physical processes only
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: dynamics_physicsonly.f90,v 1.7 2015/01/31 06:16:26 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module dynamics_physicsonly
    13:               !
    14:               != 物理過程のみの計算のための力学過程
    15:               !
    16:               != A dynamics for calculation with physical processes only
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               !
    22:               !== NAMELIST
    23:               !
    24:               !
    25:             
    26:               ! モジュール引用 ; USE statements
    27:               !
    28:             
    29:               ! 格子点設定
    30:               ! Grid points settings
    31:               !
    32:               use gridset, only: imax, & ! 経度格子点数. 
    33:                                          ! Number of grid points in longitude
    34:                 &                jmax, & ! 緯度格子点数. 
    35:                                          ! Number of grid points in latitude
    36:                 &                kmax    ! 鉛直層数. 
    37:                                          ! Number of vertical level
    38:               ! 組成に関わる配列の設定
    39:               ! Settings of array for atmospheric composition
    40:               !
    41:               use composition, only: &
    42:                 &                    ncmax
    43:                                           ! 成分の数
    44:                                           ! Number of composition
    45:             
    46:               ! 種別型パラメタ
    47:               ! Kind type parameter
    48:               !
    49:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    50:                 &                 STRING     ! 文字列.       Strings. 
    51:             
    52:               ! メッセージ出力
    53:               ! Message output
    54:               !
    55:               use dc_message, only: MessageNotify
    56:             
    57:               ! 宣言文 ; Declaration statements
    58:               !
    59:               implicit none
    60:               private
    61:             
    62:               ! 公開手続き
    63:               ! Public procedure
    64:               !
    65:               public :: DynamicsPhysicsOnly
    66:               public :: DynamicsPhysicsOnlyInit
    67:             
    68:               ! 公開変数
    69:               ! Public variables
    70:               !
    71:             
    72:               ! 非公開変数
    73:               ! Private variables
    74:               !
    75:               real(DP), allocatable, save :: xyz_CorPar(:,:,:)
    76:               real(DP)             , save :: UGeo
    77:               real(DP)             , save :: VGeo
    78:               real(DP)             , save :: WMagnitude
    79:               real(DP)             , save :: WHeight
    80:               real(DP)             , save :: WTimeInit
    81:             
    82:               logical              , save :: FlagDynExp
    83:             
    84:               logical, save :: dynamics_physicsonly_inited = .false.
    85:                                           ! 初期設定フラグ. 
    86:                                           ! Initialization flag
    87:             
    88:             
    89:               character(*), parameter:: module_name = 'dynamics_physicsonly'
    90:                                           ! モジュールの名称. 
    91:                                           ! Module name
    92:               character(*), parameter:: version = &
    93:                 & '$Name:  $' // &
    94:                 & '$Id: dynamics_physicsonly.f90,v 1.7 2015/01/31 06:16:26 yot Exp $'
    95:                                           ! モジュールのバージョン
    96:                                           ! Module version
    97:             
    98:               ! INTERFACE 文 ; INTERFACE statements
    99:               !
   100:             
   101:             contains
   102:             
   103:               subroutine DynamicsPhysicsOnly(                                &
   104:                 & xyz_Exner, xy_SurfHeight, xyz_Height,                      & ! (in)
   105:                 & xyz_DUDtPhy, xyz_DVDtPhy, xyz_DTempDtPhy, xyzf_DQMixDtPhy, & ! (in)
   106:                 & xy_PsB, xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB,             & ! (in)
   107:                 & xy_PsN, xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN,             & ! (in)
   108:                 & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA              & ! (out)
   109:                 & )
   110:             
   111:                 ! モジュール引用 ; USE statements
   112:                 !
   113:             
   114:                 ! 時刻管理
   115:                 ! Time control
   116:                 !
   117:                 use timeset, only: &
   118:                   & DelTime, &            ! $ \Delta t $ [s]
   119:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   120:                   & TimesetClockStart, TimesetClockStop
   121:             
   122:                 ! デバッグ用ユーティリティ
   123:                 ! Utilities for debug
   124:                 !
   125:                 use dc_trace, only: DbgMessage, BeginSub, EndSub
   126:             
   127:                 ! 組成に関わる配列の設定
   128:                 ! Settings of array for atmospheric composition
   129:                 !
   130:                 use composition, only:                              &
   131:                   &                    ncmax,                       &
   132:                                            ! 成分の数
   133:                                            ! Number of composition
   134:                   &                    CompositionInqFlagAdv
   135:             
   136:                 ! 1 次元計算用力学過程ユーティリティモジュール
   137:                 ! Utility module for dynamics for 1-D calculation
   138:                 !
   139:                 use dynamics_1d_utils, only : Dynamics1DUtilsVerAdv
   140:             
   141:             !!$    ! 質量の補正
   142:             !!$    ! Mass fixer
   143:             !!$    !
   144:             !!$    use mass_fixer, only: MassFixerColumn
   145:             
   146:             
   147:                 ! 宣言文 ; Declaration statements
   148:                 !
   149:             
   150:                 real(DP), intent(in):: xyz_Exner      (0:imax-1, 1:jmax, 1:kmax)
   151:                 real(DP), intent(in):: xy_SurfHeight  (0:imax-1, 1:jmax)
   152:                 real(DP), intent(in):: xyz_Height     (0:imax-1, 1:jmax, 1:kmax)
   153:             
   154:                 real(DP), intent(in):: xyz_DUDtPhy    (0:imax-1, 1:jmax, 1:kmax)
   155:                                           ! $ \left(\DP{u}{t}\right)^{phy} $ .
   156:                                           ! 外力項 (物理過程) による東西風速変化.
   157:                                           ! Eastward wind tendency by external force terms (physical processes)
   158:                 real(DP), intent(in):: xyz_DVDtPhy    (0:imax-1, 1:jmax, 1:kmax)
   159:                                           ! $ \left(\DP{v}{t}\right)^{phy} $ .
   160:                                           ! 外力項 (物理過程) による南北風速変化.
   161:                                           ! Northward wind tendency by external force terms (physicalprocesses)
   162:                 real(DP), intent(in):: xyz_DTempDtPhy (0:imax-1, 1:jmax, 1:kmax)
   163:                                           ! $ \left(\DP{T}{t}\right)^{phy} $ .
   164:                                           ! 外力項 (物理過程) による温度変化.
   165:                                           ! Temperature tendency by external force terms (physical processes)
   166:                 real(DP), intent(in):: xyzf_DQMixDtPhy (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   167:                                           ! $ \left(\DP{q}{t}\right)^{phy} $ .
   168:                                           ! 外力項 (物理過程) による比湿変化.
   169:                                           ! Temperature tendency by external force terms (physical processes)
   170:                 real(DP), intent(in ):: xy_PsB(0:imax-1, 1:jmax)
   171:                                           ! $ p_s $ . 地表面気圧 (半整数レベル). 
   172:                                           ! Surface pressure (half level)
   173:                 real(DP), intent(in ):: xyz_UB(0:imax-1, 1:jmax, 1:kmax)
   174:                                           ! $ u $ . 東西風速. Eastward wind
   175:                 real(DP), intent(in ):: xyz_VB(0:imax-1, 1:jmax, 1:kmax)
   176:                                           ! $ v $ . 南北風速. Northward wind
   177:                 real(DP), intent(in ):: xyz_TempB(0:imax-1, 1:jmax, 1:kmax)
   178:                                           ! $ T $ . 温度 (整数レベル). 
   179:                                           ! Temperature (full level)
   180:                 real(DP), intent(in ):: xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   181:                                           ! $ q $ .     比湿. Specific humidity
   182:                 real(DP), intent(in):: xy_PsN    (0:imax-1, 1:jmax)
   183:                                           ! $ p_s (t) $ .   地表面気圧. Surface pressure
   184:                 real(DP), intent(in):: xyz_UN   (0:imax-1, 1:jmax, 1:kmax)
   185:                                           ! $ u (t) $ .     東西風速. Eastward wind
   186:                 real(DP), intent(in):: xyz_VN   (0:imax-1, 1:jmax, 1:kmax)
   187:                                           ! $ v (t) $ .     南北風速. Northward wind
   188:                 real(DP), intent(in):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
   189:                                           ! $ T (t) $ .     温度. Temperature
   190:                 real(DP), intent(in):: xyzf_QMixN(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   191:                                           ! $ q (t) $ .     比湿. Specific humidity
   192:                 real(DP), intent(out):: xy_PsA(0:imax-1, 1:jmax)
   193:                                           ! $ p_s $ . 地表面気圧 (半整数レベル). 
   194:                                           ! Surface pressure (half level)
   195:                 real(DP), intent(out):: xyz_UA(0:imax-1, 1:jmax, 1:kmax)
   196:                                           ! $ u $ . 東西風速. Eastward wind
   197:                 real(DP), intent(out):: xyz_VA(0:imax-1, 1:jmax, 1:kmax)
   198:                                           ! $ v $ . 南北風速. Northward wind
   199:                 real(DP), intent(out):: xyz_TempA(0:imax-1, 1:jmax, 1:kmax)
   200:                                           ! $ T $ . 温度 (整数レベル). 
   201:                                           ! Temperature (full level)
   202:                 real(DP), intent(out):: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   203:                                           ! $ q $ .     比湿. Specific humidity
   204:             
   205:             
   206:                 ! 作業変数
   207:                 ! Work variables
   208:                 !
   209:                 real(DP) :: xyz_PotTempB     (0:imax-1, 1:jmax, 1:kmax)
   210:             
   211:                 real(DP) :: xyz_W            (0:imax-1, 1:jmax, 1:kmax)
   212:             
   213:                 real(DP) :: xyz_DUDtAdv      (0:imax-1, 1:jmax, 1:kmax)
   214:                 real(DP) :: xyz_DVDtAdv      (0:imax-1, 1:jmax, 1:kmax)
   215:                 real(DP) :: xyz_DPotTempDtAdv(0:imax-1, 1:jmax, 1:kmax)
   216:                 real(DP) :: xyzf_DQMixDtAdv  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   217:             
   218:                 real(DP) :: xyz_UT           (0:imax-1, 1:jmax, 1:kmax)
   219:                 real(DP) :: xyz_VT           (0:imax-1, 1:jmax, 1:kmax)
   220:             
   221:                 real(DP) :: DelTimeX2
   222:             
   223:                 integer:: k
   224:                 integer:: n
   225:             
   226:                 ! 実行文 ; Executable statement
   227:                 !
   228:             
   229:                 ! 初期化確認
   230:                 ! Initialization check
   231:                 !
   232:                 if ( .not. dynamics_physicsonly_inited ) then
   233:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   234:                 end if
   235:             
   236:             
   237:                 ! 計算時間計測開始
   238:                 ! Start measurement of computation time
   239:                 !
   240:                 call TimesetClockStart( module_name )
   241:             
   242:             
   243:                 DelTimeX2 = 2.0_DP * DelTime
   244:             
   245:             
   246: W**==== A       xyz_PotTempB = xyz_TempB / xyz_Exner
   247:             
   248:                 if ( TimeN >= WTimeInit ) then
   249:                   if ( WHeight > 0.0_DP ) then
   250: +------>            do k = 1, kmax
   251: |W*==== A             xyz_W(:,:,k) =                                                     &
   252: |                       & WMagnitude * min( xyz_Height(:,:,k) - xy_SurfHeight, WHeight ) &
   253: |                       &            / WHeight
   254: +------             end do
   255:                   else
   256: ++V==== A           xyz_W = 0.0_DP
   257:                   end if
   258:                 else
   259: W**==== A         xyz_W = 0.0_DP
   260:                 end if
   261:             
   262:                 ! 1 次元計算用力学過程ユーティリティモジュール
   263:                 ! Utility module for dynamics for 1-D calculation
   264:                 !
   265:                 call Dynamics1DUtilsVerAdv(    &
   266:                   & xyz_W, xyz_Height, xyz_UB, &
   267:                   & xyz_DUDtAdv                &
   268:                   & )
   269:                 call Dynamics1DUtilsVerAdv(    &
   270:                   & xyz_W, xyz_Height, xyz_VB, &
   271:                   & xyz_DVDtAdv                &
   272:                   & )
   273:                 call Dynamics1DUtilsVerAdv(          &
   274:                   & xyz_W, xyz_Height, xyz_PotTempB, &
   275:                   & xyz_DPotTempDtAdv                &
   276:                   & )
   277: +------>        do n = 1, ncmax
   278: |                 if ( CompositionInqFlagAdv( n ) ) then
   279: |                   call Dynamics1DUtilsVerAdv(          &
   280: |                     & xyz_W, xyz_Height, xyzf_QMixB(:,:,:,n), &
   281: |                     & xyzf_DQMixDtAdv(:,:,:,n)                &
   282: |                     & )
   283: |                 else
   284: |W**=== A           xyzf_DQMixDtAdv(:,:,:,n) = 0.0_DP
   285: |                 end if
   286: +------         end do
   287:             
   288: W*===== A       xy_PsA = xy_PsB
   289:             
   290:                 if ( FlagDynExp ) then
   291: **V---->A         xyz_UA = xyz_UB &
   292: |||                 & + ( xyz_DUDtAdv + xyz_CorPar * xyz_VB + xyz_DUDtPhy ) &
   293: |||                 &     * DelTimeX2
   294: **V---- A         xyz_VA = xyz_VB &
   295:                     & + ( xyz_DVDtAdv - xyz_CorPar * xyz_UB + xyz_DVDtPhy ) &
   296:                     &     * DelTimeX2
   297:                 else
   298: **V---->A         xyz_UT = xyz_UB + ( xyz_DUDtAdv + xyz_DUDtPhy ) * DelTimeX2
   299: |||     A         xyz_VT = xyz_VB + ( xyz_DVDtAdv + xyz_DVDtPhy ) * DelTimeX2
   300: |||     A         xyz_UA = &
   301: |||                 &   (   xyz_UT                                                  &
   302: |||                 &     + DelTimeX2 * xyz_CorPar                                  &
   303: |||                 &         * ( xyz_VT - VGeo + DelTimeX2 * xyz_CorPar * UGeo ) ) &
   304: |||                 & / ( 1.0_DP + ( DelTimeX2 * xyz_CorPar )**2 )
   305: **V---- A         xyz_VA = &
   306:                     &   (   xyz_VT                                                  &
   307:                     &     - DelTimeX2 * xyz_CorPar                                  &
   308:                     &         * ( xyz_UT - UGeo - DelTimeX2 * xyz_CorPar * VGeo ) ) &
   309:                     & / ( 1.0_DP + ( DelTimeX2 * xyz_CorPar )**2 )
   310:                 end if
   311:             
   312:             !!$    xyz_TempA  = xyz_TempB  + xyz_DTempDtPhy  * 2.0d0 * DelTime
   313: **W---->A       xyz_TempA = xyz_PotTempB &
   314: |||               & + ( xyz_DPotTempDtAdv + xyz_DTempDtPhy / xyz_Exner ) * DelTimeX2
   315: **W---- A       xyz_TempA = xyz_TempA * xyz_Exner
   316:             
   317: ***W--->A       xyzf_QMixA = xyzf_QMixB &
   318: ||||              & + ( xyzf_DQMixDtAdv + xyzf_DQMixDtPhy ) * DelTimeX2
   319: ***W--- A       xyzf_QMixA = max( xyzf_QMixA, 0.0_DP )
   320:             
   321:             
   322:               end subroutine DynamicsPhysicsOnly
   323:             
   324:               !-------------------------------------------------------------------
   325:             
   326:               subroutine DynamicsPhysicsOnlyInit
   327:             
   328:                 ! モジュール引用 ; USE statements
   329:                 !
   330:             
   331:                 ! 物理定数設定
   332:                 ! Physical constants settings
   333:                 !
   334:                 use constants, only: &
   335:                   & Omega
   336:                                           ! $ \Omega $ [s-1].
   337:                                           ! 回転角速度.
   338:                                           ! Angular velocity
   339:             
   340:                 ! 座標データ設定
   341:                 ! Axes data settings
   342:                 !
   343:                 use axesset, only : y_Lat
   344:             
   345:                 ! NAMELIST ファイル入力に関するユーティリティ
   346:                 ! Utilities for NAMELIST file input
   347:                 !
   348:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   349:             
   350:                 ! ファイル入出力補助
   351:                 ! File I/O support
   352:                 !
   353:                 use dc_iounit, only: FileOpen
   354:             
   355:                 ! 1 次元計算用力学過程ユーティリティモジュール
   356:                 ! Utility module for dynamics for 1-D calculation
   357:                 !
   358:                 use dynamics_1d_utils, only : Dynamics1DUtilsInit
   359:             
   360:             
   361:                 ! 宣言文 ; Declaration statements
   362:                 !
   363:             
   364:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   365:                                           ! Unit number for NAMELIST file open
   366:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   367:                                           ! IOSTAT of NAMELIST read
   368:             
   369:             !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   370:             !!$                              ! Work variables for DO loop in longitude
   371:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   372:                                           ! Work variables for DO loop in latitude
   373:                 integer:: k
   374:             
   375:             
   376:                 ! NAMELIST 変数群
   377:                 ! NAMELIST group name
   378:                 !
   379:                 namelist /dynamics_physicsonly_nml/ &
   380:                   & FlagDynExp,                     &
   381:                   & UGeo, VGeo,                     &
   382:                   & WMagnitude, WHeight, WTimeInit
   383:                       !
   384:                       ! デフォルト値については初期化手続 "surface_flux_bulk#SurfFluxInit" 
   385:                       ! のソースコードを参照のこと. 
   386:                       !
   387:                       ! Refer to source codes in the initialization procedure
   388:                       ! "surface_flux_bulk#SurfFluxInit" for the default values. 
   389:                       !
   390:             
   391:                 ! 実行文 ; Executable statement
   392:                 !
   393:             
   394:             
   395:                 if ( dynamics_physicsonly_inited ) return
   396:             
   397:             
   398:                 ! デフォルト値の設定
   399:                 ! Default values settings
   400:                 !
   401:                 FlagDynExp = .false.
   402:             
   403:                 UGeo = 0.0_DP
   404:                 VGeo = 0.0_DP
   405:             
   406:                 WMagnitude = 0.0_DP
   407:                 WHeight    = 0.0_DP
   408:             !!$    WMagnitude = - 0.005_DP
   409:             !!$    WHeight    =   1000.0_DP
   410:                 WTimeInit  = 0.0_DP
   411:             
   412:                 ! NAMELIST の読み込み
   413:                 ! NAMELIST is input
   414:                 !
   415:                 if ( trim(namelist_filename) /= '' ) then
   416:                   call FileOpen( unit_nml, &          ! (out)
   417:                     & namelist_filename, mode = 'r' ) ! (in)
   418:             
   419:                   rewind( unit_nml )
   420:                   read( unit_nml, &                      ! (in)
   421:                     & nml = dynamics_physicsonly_nml, &  ! (out)
   422:                     & iostat = iostat_nml )              ! (out)
   423:                   close( unit_nml )
   424:             
   425:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   426:                 end if
   427:             
   428:             
   429:                 allocate( xyz_CorPar(0:imax-1, 1:jmax, 1:kmax) )
   430:             
   431: +------>        do k = 1, kmax
   432: |+----->          do j = 1, jmax
   433: ||V==== A           xyz_CorPar(:,j,k) = 2.0_DP * Omega * sin( y_Lat(j) )
   434: |+-----           end do
   435: +------         end do
   436:             
   437:                 ! 1 次元計算用力学過程ユーティリティモジュール
   438:                 ! Utility module for dynamics for 1-D calculation
   439:                 !
   440:                 call Dynamics1DUtilsInit
   441:             
   442:             
   443:             !!$    ! ヒストリデータ出力のためのへの変数登録
   444:             !!$    ! Register of variables for history data output
   445:             !!$    !
   446:             !!$    call HistoryAutoAddVariable( 'TauX', &
   447:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
   448:             !!$      & 'surface stress(x)  ', 'N m-2' )
   449:             !!$
   450:             !!$    call HistoryAutoAddVariable( 'TauY', &
   451:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
   452:             !!$      & 'surface stress(y)  ', 'N m-2' )
   453:             !!$
   454:             !!$    call HistoryAutoAddVariable( 'Sens', &
   455:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
   456:             !!$      & 'sensible heat flux', 'W m-2' )
   457:             !!$
   458:             !!$    call HistoryAutoAddVariable( 'EVap', &
   459:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
   460:             !!$      & 'latent heat flux  ', 'W m-2' )
   461:             
   462:                 ! 印字 ; Print
   463:                 !
   464:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   465:                 call MessageNotify( 'M', module_name, '  FlagDynExp = %b', l = (/ FlagDynExp /) )
   466:                 call MessageNotify( 'M', module_name, '  UGeo = %f', d = (/ UGeo /) )
   467:                 call MessageNotify( 'M', module_name, '  VGeo = %f', d = (/ VGeo /) )
   468:                 call MessageNotify( 'M', module_name, '  WMagnitude = %f', d = (/ WMagnitude /) )
   469:                 call MessageNotify( 'M', module_name, '  WHeight    = %f', d = (/ WHeight    /) )
   470:                 call MessageNotify( 'M', module_name, '  WTimeInit  = %f', d = (/ WTimeInit  /) )
   471:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   472:             
   473:                 dynamics_physicsonly_inited = .true.
   474:             
   475:               end subroutine DynamicsPhysicsOnlyInit
   476:             
   477:               !--------------------------------------------------------------------------------------
   478:             
   479:             end module dynamics_physicsonly
