Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: dynamics_twpice_scm_exp.f90
PROGRAM NAME: dynamics_twpice_scm_exp
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   253  opt  (1592): Outer loop unrolled inside inner loop.
   253  vec  (   3): Unvectorized loop.
   253  vec  (  13): Overhead of loop division is too large.
   254  vec  (   4): Vectorized array expression.
   306  opt  (1593): Loop nest collapsed into one loop.
   306  vec  (   4): Vectorized array expression.
   306  vec  (  29): ADB is used for array.: xyz_ptempb
   306  vec  (  29): ADB is used for array.: xyz_exner
   306  vec  (  29): ADB is used for array.: xyz_tempb
   324  opt  (  11): Fused array assignments. :line 324 - 328
   324  vec  (   4): Vectorized array expression.
   324  vec  (  29): ADB is used for array.: xyz_va
   324  vec  (  29): ADB is used for array.: xyz_vb
   324  vec  (  29): ADB is used for array.: xyz_ua
   324  vec  (  29): ADB is used for array.: xyz_ub
   324  vec  (  29): ADB is used for array.: xyz_vobs
   324  vec  (  29): ADB is used for array.: xyz_uobs
   349  opt  (  11): Fused array assignments. :line 349 - 352
   349  opt  (1593): Loop nest collapsed into one loop.
   349  vec  (   4): Vectorized array expression.
   349  vec  (  29): ADB is used for array.: xyz_va
   349  vec  (  29): ADB is used for array.: xyz_vobs
   349  vec  (  29): ADB is used for array.: xyz_vb
   349  vec  (  29): ADB is used for array.: xyz_ua
   349  vec  (  29): ADB is used for array.: xyz_uobs
   349  vec  (  29): ADB is used for array.: xyz_ub
   359  opt  (  11): Fused array assignments. :line 359 - 361
   359  opt  (1593): Loop nest collapsed into one loop.
   359  vec  (   4): Vectorized array expression.
   359  vec  (  29): ADB is used for array.: xyzf_dqmixdtphy
   359  vec  (  29): ADB is used for array.: xyz_dqvapdtvadv
   359  vec  (  29): ADB is used for array.: xyz_dqvapdthadv
   359  vec  (  29): ADB is used for array.: xyz_exner
   359  vec  (  29): ADB is used for array.: xyz_dtempdtphy
   359  vec  (  29): ADB is used for array.: xyz_dptempdtvadv
   359  vec  (  29): ADB is used for array.: xyz_dptempdthadv
   369  opt  (1593): Loop nest collapsed into one loop.
   369  vec  (   4): Vectorized array expression.
   369  vec  (  29): ADB is used for array.: xyz_ptempb
   370  opt  (1593): Loop nest collapsed into one loop.
   370  vec  (   1): Vectorized loop.
   370  vec  (  29): ADB is used for array.: xyzf_qmixa
   370  vec  (  29): ADB is used for array.: xyzf_dqmixdtphy
   370  vec  (  29): ADB is used for array.: xyzf_qmixb
   375  opt  (1593): Loop nest collapsed into one loop.
   375  vec  (   4): Vectorized array expression.
   375  vec  (  29): ADB is used for array.: xyzf_qmixa
   375  vec  (  29): ADB is used for array.: xyzf_qmixb
   377  opt  (1593): Loop nest collapsed into one loop.
   377  vec  (   1): Vectorized loop.
   377  vec  (  29): ADB is used for array.: xyzf_qmixa
   377  vec  (  29): ADB is used for array.: xyzf_dqmixdtphy
   377  vec  (  29): ADB is used for array.: xyzf_qmixb
   381  opt  (1593): Loop nest collapsed into one loop.
   381  vec  (   4): Vectorized array expression.
   381  vec  (  29): ADB is used for array.: xyzf_qmixa
   384  warn (  80): Dummy argument "xyz_tempa" with INTENT(OUT) attribute may be referenced before it is defined.
   388  opt  (1593): Loop nest collapsed into one loop.
   388  vec  (   4): Vectorized array expression.
   388  vec  (  29): ADB is used for array.: xyz_tempa
   388  vec  (  29): ADB is used for array.: xyz_exnera
   396  opt  (1593): Loop nest collapsed into one loop.
   396  vec  (   4): Vectorized array expression.
   396  vec  (  29): ADB is used for array.: xyz_exner
   396  vec  (  29): ADB is used for array.: xyz_dtempdtphy
   401  warn (  82): Name "xyz_ut" is not used.
   401  warn (  82): Name "xyz_vt" is not used.
   401  warn (  83): Dummy argument "xyz_dudtphy" is not used.
   401  warn (  83): Dummy argument "xyz_dvdtphy" is not used.
   401  warn (  83): Dummy argument "xy_psb" is not used.
   466  vec  (   1): Vectorized loop.
   466  vec  (  29): ADB is used for array.: a_intime
   467  opt  (1084): Branch out of the loop inhibits optimization.
   467  vec  (  26): Macro operation Search.
   481  vec  (   1): Vectorized loop.
   481  vec  (  29): ADB is used for array.: xyz_array
   493  vec  (   1): Vectorized loop.
   493  vec  (  29): ADB is used for array.: xyz_array
   498  opt  (1593): Loop nest collapsed into one loop.
   498  vec  (   4): Vectorized array expression.
   498  vec  (  29): ADB is used for array.: xy_ps
   504  warn (  81): Name "flag_mpi_init" is referenced but not defined.
   580  vec  (   1): Vectorized loop.
   580  vec  (  29): ADB is used for array.: a_intime
   581  opt  (1084): Branch out of the loop inhibits optimization.
   581  vec  (  26): Macro operation Search.
   592  vec  (   1): Vectorized loop.
   592  vec  (  29): ADB is used for array.: z_inarray
   592  vec  (  29): ADB is used for array.: xyz_inarray
   608  vec  (   1): Vectorized loop.
   608  vec  (  29): ADB is used for array.: z_inarray
   608  vec  (  29): ADB is used for array.: xyz_inarray
   617  opt  (1593): Loop nest collapsed into one loop.
   617  vec  (   4): Vectorized array expression.
   617  vec  (  29): ADB is used for array.: xyz_array
   617  vec  (  29): ADB is used for array.: xyz_array1
   617  vec  (  29): ADB is used for array.: xyz_array2
   623  warn (  81): Name "flag_mpi_init" is referenced but not defined.
   783  vec  (   4): Vectorized array expression.
   783  vec  (  29): ADB is used for array.: a_intime
   804  vec  (   4): Vectorized array expression.
   804  vec  (  29): ADB is used for array.: a_intime
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: dynamics_twpice_scm_exp.f90
PROGRAM NAME: dynamics_twpice_scm_exp
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != TWP-ICE SCM 実験用力学過程
     2  !
     3  != dynamical process for TWP-ICE SCM Experiment
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: dynamics_twpice_scm_exp.f90,v 1.1 2015/02/11 11:53:16 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module dynamics_twpice_scm_exp
    13  
    14    !
    15    != dcpam 地球大気向け短波放射モデル Ver. 2
    16    !
    17    != dcpam short wave radiation model for the Earth's atmosphere Ver. 1
    18    !
    19    ! <b>Note that Japanese and English are described in parallel.</b>
    20    !
    21  
    22    !== References
    23    !
    24  !!$  !  Chou, M.-D.,
    25  !!$  !    Atmospheric solar heating rate in the water vapor bands,
    26  !!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
    27    !
    28    !== Procedures List
    29    !
    30  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    31  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    32  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    33  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    34  !!$  ! ------------            :: ------------
    35  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    36  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    37  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    38  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    39    !
    40    !== NAMELIST
    41    !
    42    ! NAMELIST#set_1d_profile_nml
    43    !
    44  
    45    ! USE statements
    46    !
    47  
    48    !
    49    ! Kind type parameter
    50    !
    51    use dc_types, only: DP, &      ! Double precision.
    52      &                 STRING, &  ! Strings.
    53      &                 TOKEN      ! Keywords.
    54  
    55    ! メッセージ出力
    56    ! Message output
    57    !
    58    use dc_message, only: MessageNotify
    59  
    60    implicit none
    61  
    62    private
    63  
    64  
    65    character(len=STRING), save :: InFileNameSounding
    66    character(len=STRING), save :: InFileNameForcing
    67  
    68    integer              , save :: Inimax
    69    integer              , save :: Injmax
    70    integer              , save :: Inkmax
    71    integer              , save :: Intmax
    72    real(DP), allocatable, save :: z_InPress(:)
    73    real(DP), allocatable, save :: a_InTime (:)
    74  
    75    real(DP), save :: TimeAtDataStart
    76  
    77    logical              , save :: FlagDynExp
    78  
    79    ! 公開変数
    80    ! Public variables
    81    !
    82    logical, save, public:: dynamics_twpice_scm_exp_inited = .false.
    83                                ! 初期設定フラグ.
    84                                ! Initialization flag
    85  
    86    public :: DynamicsTWPICESCMExp
    87    public :: DynamicsTWPICESCMExpInit
    88    public :: DynamicsTWPICESCMExpFinalize
    89  
    90    character(*), parameter:: module_name = 'dynamics_twpice_scm_exp'
    91                                ! モジュールの名称.
    92                                ! Module name
    93    character(*), parameter:: version = &
    94      & '$Name:  $' // &
    95      & '$Id: dynamics_twpice_scm_exp.f90,v 1.1 2015/02/11 11:53:16 yot Exp $'
    96                                ! モジュールのバージョン
    97                                ! Module version
    98  
    99  
   100    !--------------------------------------------------------------------------------------
   101  
   102  contains
   103  
   104    !--------------------------------------------------------------------------------------
   105  
   106    subroutine DynamicsTWPICESCMExp( &
   107      & Time,                                                      &
   108      & xyz_Press, xyz_Exner, xyz_Height,                          &
   109      & xyz_DUDtPhy, xyz_DVDtPhy, xyz_DTempDtPhy, xyzf_DQMixDtPhy, &
   110      & xy_PsB, xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB,             &
   111      & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA              &
   112      & )
   113  
   114      ! モジュール引用 ; USE statements
   115      !
   116  
   117      ! ヒストリデータ出力
   118      ! History data output
   119      !
   120      use gtool_historyauto, only: HistoryAutoPut
   121  
   122      ! 物理定数設定
   123      ! Physical constants settings
   124      !
   125      use constants, only: &
   126        & Omega
   127                                ! $ \Omega $ [s-1].
   128                                ! 回転角速度.
   129                                ! Angular velocity
   130  
   131      ! 組成に関わる配列の設定
   132      ! Settings of array for atmospheric composition
   133      !
   134      use composition, only: &
   135        &                    ncmax, &
   136                                ! 成分の数
   137                                ! Number of composition
   138        &                    IndexH2OVap
   139  
   140      ! 座標データ設定
   141      ! Axes data settings
   142      !
   143      use axesset, only : y_Lat
   144  
   145      ! 格子点設定
   146      ! Grid points settings
   147      !
   148      use gridset, only: imax, & ! 経度格子点数.
   149                                 ! Number of grid points in longitude
   150        &                jmax, & ! 緯度格子点数.
   151                                 ! Number of grid points in latitude
   152        &                kmax    ! 鉛直層数.
   153                                 ! Number of vertical level
   154  
   155      ! 組成に関わる配列の設定
   156      ! Settings of array for atmospheric composition
   157      !
   158      use composition, only: &
   159        &                    ncmax, &
   160                                ! 成分の数
   161                                ! Number of composition
   162        &                    IndexH2OVap
   163  
   164      ! 時刻管理
   165      ! Time control
   166      !
   167      use timeset, only: &
   168        & DelTime            ! $ \Delta t $ [s]
   169  
   170      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   171      ! Interpolate temperature on half sigma level,
   172      ! and calculate pressure and height
   173      !
   174      use auxiliary, only: AuxVars
   175  
   176      ! 1 次元計算用力学過程ユーティリティモジュール
   177      ! Utility module for dynamics for 1-D calculation
   178      !
   179      use dynamics_1d_utils, only : Dynamics1DUtilsVerAdv
   180  
   181      real(DP), intent(in ) :: Time
   182      real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   183      real(DP), intent(in ) :: xyz_Exner(0:imax-1,1:jmax,1:kmax)
   184      real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
   185      real(DP), intent(in ) :: xyz_DUDtPhy(0:imax-1,1:jmax,1:kmax)
   186      real(DP), intent(in ) :: xyz_DVDtPhy(0:imax-1,1:jmax,1:kmax)
   187      real(DP), intent(in ) :: xyz_DTempDtPhy (0:imax-1,1:jmax,1:kmax)
   188      real(DP), intent(in ) :: xyzf_DQMixDtPhy(0:imax-1,1:jmax,1:kmax,1:ncmax)
   189      real(DP), intent(in ) :: xy_PsB    (0:imax-1,1:jmax)
   190      real(DP), intent(in ) :: xyz_UB    (0:imax-1,1:jmax,1:kmax)
   191      real(DP), intent(in ) :: xyz_VB    (0:imax-1,1:jmax,1:kmax)
   192      real(DP), intent(in ) :: xyz_TempB (0:imax-1,1:jmax,1:kmax)
   193      real(DP), intent(in ) :: xyzf_QMixB(0:imax-1,1:jmax,1:kmax,1:ncmax)
   194      real(DP), intent(out) :: xy_PsA    (0:imax-1,1:jmax)
   195      real(DP), intent(out) :: xyz_UA    (0:imax-1,1:jmax,1:kmax)
   196      real(DP), intent(out) :: xyz_VA    (0:imax-1,1:jmax,1:kmax)
   197      real(DP), intent(out) :: xyz_TempA (0:imax-1,1:jmax,1:kmax)
   198      real(DP), intent(out) :: xyzf_QMixA(0:imax-1,1:jmax,1:kmax,1:ncmax)
   199  
   200  
   201      !
   202      ! local variables
   203      !
   204      character(len=STRING) :: InFileName
   205      character(len=STRING) :: InVarName
   206  
   207      real(DP) :: xyz_UT      (0:imax-1,1:jmax,1:kmax)
   208      real(DP) :: xyz_VT      (0:imax-1,1:jmax,1:kmax)
   209  
   210      real(DP) :: xyz_CorPar  (0:imax-1,1:jmax,1:kmax)
   211  
   212      real(DP) :: xyz_PTempB  (0:imax-1,1:jmax,1:kmax)
   213      real(DP) :: xyz_PTempA  (0:imax-1,1:jmax,1:kmax)
   214  
   215      real(DP) :: xyz_ExnerA  (0:imax-1,1:jmax,1:kmax)
   216  
   217      real(DP) :: xyz_UObs    (0:imax-1,1:jmax,1:kmax)
   218      real(DP) :: xyz_VObs    (0:imax-1,1:jmax,1:kmax)
   219      real(DP) :: xyz_WObs    (0:imax-1,1:jmax,1:kmax)
   220      real(DP) :: xyz_DUDtVAdv(0:imax-1,1:jmax,1:kmax)
   221      real(DP) :: xyz_DVDtVAdv(0:imax-1,1:jmax,1:kmax)
   222      real(DP) :: xyz_DPTempDtHAdv(0:imax-1,1:jmax,1:kmax)
   223      real(DP) :: xyz_DQVapDtHAdv (0:imax-1,1:jmax,1:kmax)
   224      real(DP) :: xyz_DPTempDtVAdv(0:imax-1,1:jmax,1:kmax)
   225      real(DP) :: xyz_DQVapDtVAdv (0:imax-1,1:jmax,1:kmax)
   226  
   227      real(DP) :: xyz_DUDt    (0:imax-1,1:jmax,1:kmax)
   228      real(DP) :: xyz_DVDt    (0:imax-1,1:jmax,1:kmax)
   229      real(DP) :: xyz_DPTempDt(0:imax-1,1:jmax,1:kmax)
   230      real(DP) :: xyz_DQVapDt (0:imax-1,1:jmax,1:kmax)
   231  
   232      real(DP), parameter :: UVTimeConst = 2.0_DP * 60.0_DP * 60.0_DP
   233  
   234      real(DP) :: DelTimeX2
   235  
   236      integer :: j
   237      integer :: k
   238      integer :: n
   239  
   240  
   241      ! 初期化確認
   242      ! Initialization check
   243      !
   244      if ( .not. dynamics_twpice_scm_exp_inited ) then
   245        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   246      end if
   247  
   248  
   249      DelTimeX2 = 2.0_DP * DelTime
   250  
   251  
   252      do k = 1, kmax
   253        do j = 1, jmax
   254          xyz_CorPar(:,j,k) = 2.0_DP * Omega * sin( y_Lat(j) )
   255        end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do t786 = 1, xyz_corpar.DSC.U1 + 1                          
     .                 xyz_corpar(t786-1,j,k) = (2.00000000000000e+000*omega)*  
     .       1            dsin(y_lat(j))                                        
     .                 xyz_corpar(t786-1,j+1,k) = (2.00000000000000e+000*omega)*
     .       1            dsin(y_lat(j+1))                                      
     .                 xyz_corpar(t786-1,j+2,k) = (2.00000000000000e+000*omega)*
     .       1            dsin(y_lat(j+2))                                      
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   256      end do
   257  
   258  
   259      InFileName = InFileNameSounding
   260      !
   261      InVarName  = 'u'
   262      call DynamicsTWPICESCMExpPTInterp( &
   263        & InFileName, InVarName, Time,         &
   264        & xyz_Press,                           &
   265        & xyz_UObs                             &
   266        & )
   267      InVarName  = 'v'
   268      call DynamicsTWPICESCMExpPTInterp( &
   269        & InFileName, InVarName, Time,         &
   270        & xyz_Press,                           &
   271        & xyz_VObs                             &
   272        & )
   273  
   274      InFileName = InFileNameForcing
   275      !
   276      InVarName  = 'w'
   277      call DynamicsTWPICESCMExpPTInterp( &
   278        & InFileName, InVarName, Time,         &
   279        & xyz_Press,                           &
   280        & xyz_WObs                             &
   281        & )
   282      InVarName  = 'dptdtadvh'
   283      call DynamicsTWPICESCMExpPTInterp( &
   284        & InFileName, InVarName, Time,         &
   285        & xyz_Press,                           &
   286        & xyz_DPTempDtHAdv                     &
   287        & )
   288      InVarName  = 'dqdtadvh'
   289      call DynamicsTWPICESCMExpPTInterp( &
   290        & InFileName, InVarName, Time,         &
   291        & xyz_Press,                           &
   292        & xyz_DQVapDtHAdv                      &
   293        & )
   294  
   295      ! 1 次元計算用力学過程ユーティリティモジュール
   296      ! Utility module for dynamics for 1-D calculation
   297      !
   298      call Dynamics1DUtilsVerAdv(  &
   299        & xyz_WObs, xyz_Height, xyz_UB,  &
   300        & xyz_DUDtVAdv                   &
   301        & )
   302      call Dynamics1DUtilsVerAdv(  &
   303        & xyz_WObs, xyz_Height, xyz_VB,  &
   304        & xyz_DVDtVAdv                   &
   305        & )
   306      xyz_PTempB = xyz_TempB / xyz_Exner
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t789 = 1, kmax*jmax*imax                                       
     .           xyz_ptempb(t789-1,1,1) = xyz_tempb(t789-1,1,1)/xyz_exner(t789-1
     .       1      ,1,1)                                                       
     .        enddo                                                             
   307      call Dynamics1DUtilsVerAdv(  &
   308        & xyz_WObs, xyz_Height, xyz_PTempB,  &
   309        & xyz_DPTempDtVAdv                   &
   310        & )
   311      call Dynamics1DUtilsVerAdv(  &
   312        & xyz_WObs, xyz_Height, xyzf_QMixB(:,:,:,IndexH2OVap), &
   313        & xyz_DQVapDtVAdv                                      &
   314        & )
   315  
   316  
   317      if ( FlagDynExp ) then
   318  !!$      xyz_DUDt = xyz_DUDtVAdv + xyz_CorPar * xyz_VB &
   319  !!$        & + xyz_DUDtPhy - ( xyz_UB - xyz_UObs ) / UVTimeConst
   320  !!$      xyz_DVDt = xyz_DVDtVAdv - xyz_CorPar * xyz_UB &
   321  !!$        & + xyz_DVDtPhy - ( xyz_VB - xyz_VObs ) / UVTimeConst
   322  
   323        ! Horizontal wind velocities are relaxed to observed ones.
   324        xyz_DUDt = - ( xyz_UB - xyz_UObs ) / UVTimeConst
     .  10133 continue                                                          
     .        d1 = 1.D0/7.20000000000000e+003                                   
     .        d2 = 1.D0/7.20000000000000e+003                                   
     .  !cdir nodep                                                             
     .        do t971 = 1, 1 + imax - min0(1,imax)                              
     .           xyz_dudt(t971-1,t979,t978) = -(xyz_ub(t971-1,t973,t972)-       
     .       1      xyz_uobs(t971-1,t976,t975))*d1                              
     .           xyz_dvdt(t971-1,t988,t987) = -(xyz_vb(t971-1,t982,t981)-       
     .       1      xyz_vobs(t971-1,t985,t984))*d2                              
     .           xyz_ua(t971-1,t997,t996) = xyz_ub(t971-1,t994,t993) + xyz_dudt(
     .       1      t971-1,t991,t990)*deltimex2                                 
     .           xyz_va(t971-1,t1006,t1005) = xyz_vb(t971-1,t1003,t1002) +      
     .       1      xyz_dvdt(t971-1,t1000,t999)*deltimex2                       
     .        enddo                                                             
   325        xyz_DVDt = - ( xyz_VB - xyz_VObs ) / UVTimeConst
   326  
   327        xyz_UA = xyz_UB + xyz_DUDt * DelTimeX2
   328        xyz_VA = xyz_VB + xyz_DVDt * DelTimeX2
   329  
   330      else
   331  !!$      xyz_UT = xyz_UB + ( xyz_DUDtVAdv + xyz_DUDtPhy ) * DelTimeX2
   332  !!$      xyz_VT = xyz_VB + ( xyz_DVDtVAdv + xyz_DVDtPhy ) * DelTimeX2
   333  !!$      !
   334  !!$      xyz_UA = &
   335  !!$        &   (   ( 1.0_DP + DelTimeX2 / UVTimeConst )                  &
   336  !!$        &         * ( xyz_UT + DelTimeX2 / UVTimeConst * xyz_UObs )   &
   337  !!$        &     + ( xyz_CorPar * DelTimeX2 )                            &
   338  !!$        &         * ( xyz_VT + DelTimeX2 / UVTimeConst * xyz_VObs ) ) &
   339  !!$        & / (   ( 1.0_DP + DelTimeX2 / UVTimeConst )**2               &
   340  !!$        &     + ( xyz_CorPar * DelTimeX2 )**2                       )
   341  !!$      xyz_VA = &
   342  !!$        & - (   ( xyz_CorPar * DelTimeX2 )                            &
   343  !!$        &         * ( xyz_UT + DelTimeX2 / UVTimeConst * xyz_UObs )   &
   344  !!$        &     - ( 1.0_DP + DelTimeX2 / UVTimeConst )                  &
   345  !!$        &         * ( xyz_VT + DelTimeX2 / UVTimeConst * xyz_VObs ) ) &
   346  !!$        & / (   ( 1.0_DP + DelTimeX2 / UVTimeConst )**2               &
   347  !!$        &     + ( DelTimeX2 * xyz_CorPar )**2                       )
   348  
   349        xyz_UA = &
     .        d3 = deltimex2/7.20000000000000e+003                              
     .        d4 = 1.D0/(1.00000000000000e+000 + (deltimex2/                    
     .       1   7.20000000000000e+003))                                        
     .        d5 = deltimex2/7.20000000000000e+003                              
     .        d6 = 1.D0/(1.00000000000000e+000 + (deltimex2/                    
     .       1   7.20000000000000e+003))                                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t804 = 1, kmax*jmax*imax                                       
     .           xyz_ua(t804-1,1,1) = (xyz_ub(t804-1,1,1)+xyz_uobs(t804-1,1,1)* 
     .       1      d3)*d4                                                      
     .           xyz_va(t804-1,1,1) = (xyz_vb(t804-1,1,1)+xyz_vobs(t804-1,1,1)* 
     .       1      d5)*d6                                                      
     .        enddo                                                             
   350          &   ( xyz_UB + xyz_UObs * DelTimeX2 / UVTimeConst ) &
   351          & / ( 1.0_DP + DelTimeX2 / UVTimeConst )
   352        xyz_VA = &
   353          &   ( xyz_VB + xyz_VObs * DelTimeX2 / UVTimeConst ) &
   354          & / ( 1.0_DP + DelTimeX2 / UVTimeConst )
   355      end if
   356  
   357  
   358  
   359      xyz_DPTempDt = xyz_DPTempDtHAdv + xyz_DPTempDtVAdv &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t828 = 1, xyz_dptempdthadv.DSC.U3*(xyz_dptempdthadv.DSC.U2*    
     .       1   xyz_dptempdthadv.DSC.U1 + xyz_dptempdthadv.DSC.U2)             
     .           xyz_dptempdt(t828-1,1,1) = xyz_dptempdthadv(t828-1,1,1) +      
     .       1      xyz_dptempdtvadv(t828-1,1,1) + xyz_dtempdtphy(t828-1,1,1)/  
     .       2      xyz_exner(t828-1,1,1)                                       
     .           xyz_dqvapdt(t828-1,1,1) = xyz_dqvapdthadv(t828-1,1,1) +        
     .       1      xyz_dqvapdtvadv(t828-1,1,1) + xyzf_dqmixdtphy(t828-1,1,1,   
     .       2      indexh2ovap)                                                
     .        enddo                                                             
   360        & + xyz_DTempDtPhy / xyz_Exner
   361      xyz_DQVapDt  = xyz_DQVapDtHAdv  + xyz_DQVapDtVAdv  &
   362        & + xyzf_DQMixDtPhy(:,:,:,IndexH2OVap)
   363  
   364      call DynamicsTWPICESCMExpPsTInterp( &
   365        & Time,                               &
   366        & xy_PsA                              &
   367        & )
   368  
   369      xyz_PTempA = xyz_PTempB + xyz_DPTempDt * DelTimeX2
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t861 = 1, xyz_ptempb.DSC.U3*(xyz_ptempb.DSC.U2*                
     .       1   xyz_ptempb.DSC.U1 + xyz_ptempb.DSC.U2)                         
     .           xyz_ptempa(t861-1,1,1) = xyz_ptempb(t861-1,1,1) + xyz_dptempdt(
     .       1      t861-1,1,1)*deltimex2                                       
     .        enddo                                                             
   370      do n = 1, IndexH2OVap-1
   371        xyzf_QMixA(:,:,:,n) = xyzf_QMixB(:,:,:,n) &
   372          & + xyzf_DQMixDtPhy(:,:,:,n) * DelTimeX2
   373      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do n = 1, (indexh2ovap - 1)*kmax*jmax*imax                        
     .           xyzf_qmixa(n-1,1,1,1) = xyzf_qmixb(n-1,1,1,1) + xyzf_dqmixdtphy
     .       1      (n-1,1,1,1)*deltimex2                                       
     .        enddo                                                             
   374      n = IndexH2OVap
   375      xyzf_QMixA(:,:,:,n) = xyzf_QMixB(:,:,:,n) &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t891 = 1, kmax*jmax*imax                                       
     .           xyzf_qmixa(t891-1,1,1,n) = xyzf_qmixb(t891-1,1,1,n) +          
     .       1      xyz_dqvapdt(t891-1,1,1)*deltimex2                           
     .        enddo                                                             
   376        & + xyz_DQVapDt * DelTimeX2
   377      do n = IndexH2OVap+1, ncmax
   378        xyzf_QMixA(:,:,:,n) = xyzf_QMixB(:,:,:,n) &
   379          & + xyzf_DQMixDtPhy(:,:,:,n) * DelTimeX2
   380      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do n = 1, (ncmax - indexh2ovap)*kmax*jmax*imax                    
     .           xyzf_qmixa(n-1,1,1,1+indexh2ovap) = xyzf_qmixb(n-1,1,1,1+      
     .       1      indexh2ovap) + xyzf_dqmixdtphy(n-1,1,1,1+indexh2ovap)*      
     .       2      deltimex2                                                   
     .        enddo                                                             
   381      xyzf_QMixA = max( xyzf_QMixA, 0.0_DP )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t921 = 1, ncmax*kmax*jmax*imax                                 
     .           xyzf_qmixa(t921-1,1,1,1) = max(xyzf_qmixa(t921-1,1,1,1),       
     .       1      0.0000000000000000e+000)                                    
     .        enddo                                                             
   382  
   383      n = IndexH2OVap
   384      call AuxVars(                               &
   385        & xy_PsA, xyz_TempA, xyzf_QMixA(:,:,:,n), &  ! (in )
   386        & xyz_Exner = xyz_ExnerA                  &  ! (out) optional
   387        & )
   388      xyz_TempA = xyz_PTempA * xyz_ExnerA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t937 = 1, xyz_ptempa.DSC.U3*(xyz_ptempa.DSC.U2*                
     .       1   xyz_ptempa.DSC.U1 + xyz_ptempa.DSC.U2)                         
     .           xyz_tempa(t937-1,1,1) = xyz_ptempa(t937-1,1,1)*xyz_exnera(t937-
     .       1      1,1,1)                                                      
     .        enddo                                                             
   389  
   390  
   391      call HistoryAutoPut( Time, 'TWPICEWObs' , xyz_WObs )
   392      call HistoryAutoPut( Time, 'TWPICEDUDtVAdv' , xyz_DUDtVAdv )
   393      call HistoryAutoPut( Time, 'TWPICEDVDtVAdv' , xyz_DVDtVAdv )
   394      call HistoryAutoPut( Time, 'TWPICEDPTempDtVAdv' , xyz_DPTempDtVAdv )
   395      call HistoryAutoPut( Time, 'TWPICEDPTempDtHAdv' , xyz_DPTempDtHAdv )
   396      call HistoryAutoPut( Time, 'TWPICEDPTempDtPhy' , xyz_DTempDtPhy / xyz_Exner )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t952 = 1, kmax*jmax*imax                                       
     .           %IG0(t952,1,1) = xyz_dtempdtphy(t952-1,1,1)/xyz_exner(t952-1,1,
     .       1      1)                                                          
     .        enddo                                                             
   397      call HistoryAutoPut( Time, 'TWPICEDQVapDtVAdv' , xyz_DQVapDtVAdv )
   398      call HistoryAutoPut( Time, 'TWPICEDQVapDtHAdv' , xyz_DQVapDtHAdv )
   399      call HistoryAutoPut( Time, 'TWPICEDQVapDtPhy' , xyzf_DQMixDtPhy(:,:,:,IndexH2OVap) )
   400  
   401    end subroutine DynamicsTWPICESCMExp
   402  
   403    !--------------------------------------------------------------------------------------
   404  
   405    subroutine DynamicsTWPICESCMExpPsTInterp( &
   406      & Time,                                     &
   407      & xy_Ps                                     &
   408      & )
   409  
   410      ! gtool データ入力
   411      ! Gtool data input
   412      !
   413      use gtool_history, only: HistoryGet
   414  
   415      ! 格子点設定
   416      ! Grid points settings
   417      !
   418      use gridset, only: imax, & ! 経度格子点数.
   419                                 ! Number of grid points in longitude
   420        &                jmax, & ! 緯度格子点数.
   421                                 ! Number of grid points in latitude
   422        &                kmax    ! 鉛直層数.
   423                                 ! Number of vertical level
   424  
   425      ! 文字列操作
   426      ! Character handling
   427      !
   428      use dc_string, only: toChar
   429  
   430  !!$    character(*), intent(in ) :: InFileName
   431  !!$    character(*), intent(in ) :: InVarName
   432      real(DP)    , intent(in ) :: Time
   433      real(DP)    , intent(out) :: xy_Ps(0:imax-1,1:jmax)
   434  
   435  
   436      !
   437      ! local variables
   438      !
   439      real(DP) :: xyz_Array(0:imax-1,1:jmax,1:Inkmax)
   440      real(DP) :: z_InArray(1:Inkmax)
   441      character(len=STRING) :: InFileName
   442      character(len=STRING) :: InVarName
   443      real(DP) :: Ps1
   444      real(DP) :: Ps2
   445      integer :: k
   446      integer :: t
   447      integer :: TIndex
   448  
   449      logical :: flag_mpi_init
   450  
   451  
   452      ! 初期化確認
   453      ! Initialization check
   454      !
   455      if ( .not. dynamics_twpice_scm_exp_inited ) then
   456        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   457      end if
   458  
   459  
   460      if ( ( Time < a_InTime(1) ) .or. ( Time > a_InTime(Intmax) ) ) then
   461        call MessageNotify( 'E', module_name, &
   462          & 'Time of %f is out of range, %f < Time < %f.', &
   463          & d = (/Time, a_InTime(1), a_InTime(Intmax)/) )
   464      end if
   465  
   466      do t = 2, Intmax
   467        if ( Time <= a_InTime(t) ) exit
   468      end do
   469  
   470  
   471      InFileName = InFileNameSounding
   472      InVarName  = "plev"
   473  
   474      TIndex = t-1
   475      call HistoryGet(                   &
   476        & InFileName, InVarName,         & ! (in)
   477        & xyz_Array,                     & ! (out)
   478        & range = 'time=^'//toChar(t-1), & ! (in)
   479        & flag_mpi_split = flag_mpi_init & ! (in) optional
   480        & )
   481      do k = 1, Inkmax
   482        z_InArray(k) = xyz_Array(0,1,k)
   483      end do
   484      Ps1 = z_InArray(1)
   485  
   486      TIndex = t
   487      call HistoryGet(                   &
   488        & InFileName, InVarName,         & ! (in)
   489        & xyz_Array,                     & ! (out)
   490        & range = 'time=^'//toChar(t-1), & ! (in)
   491        & flag_mpi_split = flag_mpi_init & ! (in) optional
   492        & )
   493      do k = 1, Inkmax
   494        z_InArray(k) = xyz_Array(0,1,k)
   495      end do
   496      Ps2 = z_InArray(1)
   497  
   498      xy_Ps = ( Ps2 - Ps1 ) &
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t189 = 1, jmax*imax                                            
     .           xy_ps(t189-1,1) = (ps2 - ps1)/(a_intime(t)-a_intime(t-1))*(time
     .       1       - a_intime(t-1)) + ps1                                     
     .        enddo                                                             
   499        & / ( a_InTime(t) - a_InTime(t-1) ) &
   500        & * ( Time        - a_InTime(t-1) ) &
   501        & + Ps1
   502  
   503  
   504    end subroutine DynamicsTWPICESCMExpPsTInterp
   505  
   506    !--------------------------------------------------------------------------------------
   507  
   508    subroutine DynamicsTWPICESCMExpPTInterp( &
   509      & InFileName, InVarName, Time,               &
   510      & xyz_Press,                                 &
   511      & xyz_Array                                  &
   512      & )
   513  
   514      ! gtool データ入力
   515      ! Gtool data input
   516      !
   517      use gtool_history, only: HistoryGet
   518  
   519      ! 文字列操作
   520      ! Character handling
   521      !
   522      use dc_string, only: toChar
   523  
   524      ! 文字列操作
   525      ! Character handling
   526      !
   527      use dc_string, only: toChar
   528  
   529      ! 格子点設定
   530      ! Grid points settings
   531      !
   532      use gridset, only: imax, & ! 経度格子点数.
   533                                 ! Number of grid points in longitude
   534        &                jmax, & ! 緯度格子点数.
   535                                 ! Number of grid points in latitude
   536        &                kmax    ! 鉛直層数.
   537                                 ! Number of vertical level
   538  
   539      ! 1 次元計算用力学過程ユーティリティモジュール
   540      ! Utility module for dynamics for 1-D calculation
   541      !
   542      use dynamics_1d_utils, only : Dynamics1DUtilsVerInterp
   543  
   544  
   545      character(*), intent(in ) :: InFileName
   546      character(*), intent(in ) :: InVarName
   547      real(DP)    , intent(in ) :: Time
   548      real(DP)    , intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   549      real(DP)    , intent(out) :: xyz_Array(0:imax-1,1:jmax,1:kmax)
   550  
   551  
   552      !
   553      ! local variables
   554      !
   555      real(DP) :: xyz_InArray(0:imax-1,1:jmax,1:Inkmax)
   556      real(DP) :: z_InArray(1:Inkmax)
   557      real(DP) :: xyz_Array1(0:imax-1,1:jmax,1:kmax)
   558      real(DP) :: xyz_Array2(0:imax-1,1:jmax,1:kmax)
   559      integer :: k
   560      integer :: t
   561      integer :: TIndex
   562  
   563      logical :: flag_mpi_init
   564  
   565  
   566      ! 初期化確認
   567      ! Initialization check
   568      !
   569      if ( .not. dynamics_twpice_scm_exp_inited ) then
   570        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   571      end if
   572  
   573  
   574      if ( ( Time < a_InTime(1) ) .or. ( Time > a_InTime(Intmax) ) ) then
   575        call MessageNotify( 'E', module_name, &
   576          & 'Time of %f is out of range, %f < Time < %f.', &
   577          & d = (/Time, a_InTime(1), a_InTime(Intmax)/) )
   578      end if
   579  
   580      do t = 2, Intmax
   581        if ( Time <= a_InTime(t) ) exit
   582      end do
   583  
   584  
   585      TIndex = t-1
   586      call HistoryGet(                   &
   587        & InFileName, InVarName,         & ! (in)
   588        & xyz_InArray,                   & ! (out)
   589        & range = 'time=^'//toChar(t-1), & ! (in)
   590        & flag_mpi_split = flag_mpi_init & ! (in) optional
   591        & )
   592      do k = 1, Inkmax
   593        z_InArray(k) = xyz_InArray(0,1,k)
   594      end do
   595      call Dynamics1DUtilsVerInterp( &
   596        & Inkmax, z_InPress, z_InArray,    &
   597        & xyz_Press,                       &
   598        & xyz_Array1                       &
   599        & )
   600  
   601      TIndex = t
   602      call HistoryGet(                   &
   603        & InFileName, InVarName,         & ! (in)
   604        & xyz_InArray,                   & ! (out)
   605        & range = 'time=^'//toChar(t),   & ! (in)
   606        & flag_mpi_split = flag_mpi_init & ! (in) optional
   607        & )
   608      do k = 1, Inkmax
   609        z_InArray(k) = xyz_InArray(0,1,k)
   610      end do
   611      call Dynamics1DUtilsVerInterp( &
   612        & Inkmax, z_InPress, z_InArray,    &
   613        & xyz_Press,                       &
   614        & xyz_Array2                       &
   615        & )
   616  
   617      xyz_Array = ( xyz_Array2 - xyz_Array1 ) &
     .           d1 = 1.D0/(a_intime(t)-a_intime(t-1))                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t241 = 1, xyz_array2.DSC.U3*(xyz_array2.DSC.U2*                
     .       1   xyz_array2.DSC.U1 + xyz_array2.DSC.U2)                         
     .           xyz_array(t241-1,1,1) = (xyz_array2(t241-1,1,1)-xyz_array1(t241
     .       1      -1,1,1))*d1*(time - a_intime(t-1)) + xyz_array1(t241-1,1,1) 
     .        enddo                                                             
   618        & / ( a_InTime(t) - a_InTime(t-1) ) &
   619        & * ( Time        - a_InTime(t-1) ) &
   620        & + xyz_Array1
   621  
   622  
   623    end subroutine DynamicsTWPICESCMExpPTInterp
   624  
   625    !--------------------------------------------------------------------------------------
   626  
   627    subroutine DynamicsTWPICESCMExpInit
   628  
   629      ! 文字列操作
   630      ! Character handling
   631      !
   632      use dc_string, only: toChar
   633  
   634      ! gtool データ入力
   635      ! Gtool data input
   636      !
   637      use gtool_history, only: HistoryGet, HistoryGetAttr
   638  
   639      ! ヒストリデータ出力
   640      ! History data output
   641      !
   642      use gtool_historyauto, only: HistoryAutoAddVariable
   643  
   644      ! NetCDF のラッパープログラム
   645      ! NetCDF wrapper
   646      !
   647      use netcdf_wrapper, only : NWInqDimLen, NWGetAtt
   648  
   649      ! NAMELIST ファイル入力に関するユーティリティ
   650      ! Utilities for NAMELIST file input
   651      !
   652      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   653  
   654      ! ファイル入出力補助
   655      ! File I/O support
   656      !
   657      use dc_iounit, only: FileOpen
   658  
   659      ! 時刻管理
   660      ! Time control
   661      !
   662      use timeset, only: &
   663        & InitialDate             ! 計算開始日時.
   664                                  ! Start date of calculation
   665  
   666      ! 暦と日時の取り扱い
   667      ! Calendar and Date handler
   668      !
   669      use dc_calendar, only: &
   670        & DC_CAL_DATE, &          ! 日時を表現するデータ型.
   671                                  ! Data type for date and time
   672        & DCCalDateCreate, DCCalDateDifference
   673  
   674      ! 1 次元計算用力学過程ユーティリティモジュール
   675      ! Utility module for dynamics for 1-D calculation
   676      !
   677      use dynamics_1d_utils, only : Dynamics1DUtilsInit
   678  
   679  
   680      ! 宣言文 ; Declaration statements
   681      !
   682      character(len=STRING) :: InFileName
   683  
   684      character(len=STRING) :: Units
   685  
   686      integer  :: TWPICEDataStartYear
   687      integer  :: TWPICEDataStartMonth
   688      integer  :: TWPICEDataStartDay
   689      integer  :: TWPICEDataStartHour
   690      integer  :: TWPICEDataStartMin
   691      real(DP) :: TWPICEDataStartSec
   692  
   693      type(DC_CAL_DATE):: TWPICEDataStartDate
   694  
   695      logical :: flag_mpi_init
   696  
   697      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   698                                ! Unit number for NAMELIST file open
   699      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   700                                ! IOSTAT of NAMELIST read
   701  
   702  
   703      ! NAMELIST 変数群
   704      ! NAMELIST group name
   705      !
   706      namelist /dynamics_twpice_scm_exp_nml/ &
   707        & InFileNameSounding, &
   708        & InFileNameForcing,  &
   709        & FlagDynExp
   710            !
   711            ! デフォルト値については初期化手続 "set_GATE_profile#SetGATEProfileInit"
   712            ! のソースコードを参照のこと.
   713            !
   714            ! Refer to source codes in the initialization procedure
   715            ! "set_GATE_profile#SetGATEProfileInit" for the default values.
   716            !
   717  
   718      ! デフォルト値の設定
   719      ! Default values settings
   720      !
   721      InFileNameSounding = 'sounding.nc'
   722      InFileNameForcing  = 'forcing.nc'
   723  
   724      FlagDynExp = .false.
   725  
   726      ! NAMELIST の読み込み
   727      ! NAMELIST is input
   728      !
   729      if ( trim(namelist_filename) /= '' ) then
   730        call FileOpen( unit_nml, &          ! (out)
   731          & namelist_filename, mode = 'r' ) ! (in)
   732  
   733        rewind( unit_nml )
   734        read( unit_nml,                        & ! (in)
   735          & nml = dynamics_twpice_scm_exp_nml, & ! (out)
   736          & iostat = iostat_nml )                ! (out)
   737        close( unit_nml )
   738  
   739        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   740      end if
   741  
   742  
   743      InFileName = InFileNameSounding
   744  
   745      call NWInqDimLen( &
   746        & InFileName,   & ! (in )
   747        & 'levelnum',   & ! (in )
   748        & Inkmax        & ! (out)
   749        & )
   750      call NWInqDimLen( &
   751        & InFileName,   & ! (in )
   752        & 'time',       & ! (in )
   753        & Intmax        & ! (out)
   754        & )
   755  
   756      allocate( z_InPress( Inkmax ) )
   757      allocate( a_InTime ( Intmax ) )
   758  
   759      flag_mpi_init = .true.
   760  
   761      call HistoryGet(                   &
   762        & InFileName, 'plev',            & ! (in)
   763        & z_InPress,                     & ! (out)
   764        & flag_mpi_split = flag_mpi_init & ! (in) optional
   765        & )
   766      call HistoryGet(                   &
   767        & InFileName, 'time',            & ! (in)
   768        & a_InTime,                      & ! (out)
   769        & flag_mpi_split = flag_mpi_init & ! (in) optional
   770        & )
   771  
   772      ! Check unit
   773      call NWGetAtt(  &
   774        & InFileName, 'time', 'units', & ! (in )
   775        & Units       & ! (out)
   776        & )
   777      if ( ( Units(1:4) /= "hour" ) .and. &
   778        &  ( Units(1:4) /= "Hour" ) .and. &
   779        &  ( Units(1:4) /= "HOUR" ) ) then
   780        call MessageNotify( 'E', module_name, 'Unit of time, %c is inappropriate.', c1 = trim(Units) )
   781      end if
   782      ! Unit conversion from hour to second
   783      a_InTime = a_InTime * ( 60.0_DP * 60.0_DP )
   784  
   785      ! Offset
   786      TWPICEDataStartYear  = 2006
   787      TWPICEDataStartMonth =    1
   788      TWPICEDataStartDay   =   18
   789      TWPICEDataStartHour  =    0
   790      TWPICEDataStartMin   =    0
   791      TWPICEDataStartSec   =    0.0_DP
   792      call DCCalDateCreate(    &
   793        & year  = TWPICEDataStartYear,   & ! (in)
   794        & month = TWPICEDataStartMonth,  & ! (in)
   795        & day   = TWPICEDataStartDay,    & ! (in)
   796        & hour  = TWPICEDataStartHour,   & ! (in)
   797        & min   = TWPICEDataStartMin,    & ! (in)
   798        & sec   = TWPICEDataStartSec,    & ! (in)
   799        & date  = TWPICEDataStartDate )    ! (out) optional
   800      TimeAtDataStart = DCCalDateDifference( &
   801        &                 start_date = InitialDate,        & ! (in)
   802        &                 end_date   = TWPICEDataStartDate & ! (in)
   803        &                 )
   804      a_InTime = a_InTime + TimeAtDataStart
   805  
   806  
   807      ! 1 次元計算用力学過程ユーティリティモジュール
   808      ! Utility module for dynamics for 1-D calculation
   809      !
   810      call Dynamics1DUtilsInit
   811  
   812  
   813      ! ヒストリデータ出力のためのへの変数登録
   814      ! Register of variables for history data output
   815      !
   816      call HistoryAutoAddVariable( 'TWPICEWObs', &
   817        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   818        & 'vertical wind for TWP-ICE experiment', 'm s-1' )
   819      call HistoryAutoAddVariable( 'TWPICEDUDtVAdv', &
   820        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   821        & 'zonal wind tendency due to vertical advection', 'm s-2' )
   822      call HistoryAutoAddVariable( 'TWPICEDVDtVAdv', &
   823        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   824        & 'meridional wind tendency due to vertical advection', 'm s-2' )
   825      call HistoryAutoAddVariable( 'TWPICEDPTempDtVAdv', &
   826        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   827        & 'potential temperature tendency due to vertical advection', 'K s-1' )
   828      call HistoryAutoAddVariable( 'TWPICEDPTempDtHAdv', &
   829        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   830        & 'potential temperature tendency due to horizontal advection', 'K s-1' )
   831      call HistoryAutoAddVariable( 'TWPICEDPTempDtPhy', &
   832        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   833        & 'potential temperature tendency due to physical processes', 'K s-1' )
   834      call HistoryAutoAddVariable( 'TWPICEDQVapDtVAdv', &
   835        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   836        & 'specific humidity tendency due to vertical advection', 's-1' )
   837      call HistoryAutoAddVariable( 'TWPICEDQVapDtHAdv', &
   838        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   839        & 'specific humidity tendency due to horizontal advection', 's-1' )
   840      call HistoryAutoAddVariable( 'TWPICEDQVapDtPhy', &
   841        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   842        & 'specific humidity tendency due to physical processes', 's-1' )
   843  
   844  
   845      ! 印字 ; Print
   846      !
   847      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   848      call MessageNotify( 'M', module_name, 'InFileNameSounding = %c', c1 = trim(InFileNameSounding) )
   849      call MessageNotify( 'M', module_name, 'InFileNameForcing  = %c', c1 = trim(InFileNameForcing ) )
   850      call MessageNotify( 'M', module_name, 'FlagDynExp         = %b', l = (/ FlagDynExp /) )
   851      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   852  
   853  
   854      dynamics_twpice_scm_exp_inited = .true.
   855  
   856  
   857    end subroutine DynamicsTWPICESCMExpInit
   858  
   859    !--------------------------------------------------------------------------------------
   860  
   861    subroutine DynamicsTWPICESCMExpFinalize
   862  
   863  
   864      ! 宣言文 ; Declaration statements
   865      !
   866  
   867  
   868      deallocate( z_InPress )
   869      deallocate( a_InTime  )
   870  
   871  
   872      dynamics_twpice_scm_exp_inited = .false.
   873  
   874  
   875    end subroutine DynamicsTWPICESCMExpFinalize
   876  
   877    !--------------------------------------------------------------------------------------
   878  
   879  end module dynamics_TWPICE_SCM_exp
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: dynamics_twpice_scm_exp.f90
PROGRAM NAME: dynamics_twpice_scm_exp
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != TWP-ICE SCM 実験用力学過程
     2:             !
     3:             != dynamical process for TWP-ICE SCM Experiment
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: dynamics_twpice_scm_exp.f90,v 1.1 2015/02/11 11:53:16 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module dynamics_twpice_scm_exp
    13:             
    14:               !
    15:               != dcpam 地球大気向け短波放射モデル Ver. 2
    16:               !
    17:               != dcpam short wave radiation model for the Earth's atmosphere Ver. 1
    18:               !
    19:               ! <b>Note that Japanese and English are described in parallel.</b>
    20:               !
    21:             
    22:               !== References
    23:               !
    24:             !!$  !  Chou, M.-D.,
    25:             !!$  !    Atmospheric solar heating rate in the water vapor bands,
    26:             !!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
    27:               !
    28:               !== Procedures List
    29:               !
    30:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    31:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    32:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    33:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    34:             !!$  ! ------------            :: ------------
    35:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    36:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    37:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    38:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    39:               !
    40:               !== NAMELIST
    41:               !
    42:               ! NAMELIST#set_1d_profile_nml
    43:               !
    44:             
    45:               ! USE statements
    46:               !
    47:             
    48:               !
    49:               ! Kind type parameter
    50:               !
    51:               use dc_types, only: DP, &      ! Double precision.
    52:                 &                 STRING, &  ! Strings.
    53:                 &                 TOKEN      ! Keywords.
    54:             
    55:               ! メッセージ出力
    56:               ! Message output
    57:               !
    58:               use dc_message, only: MessageNotify
    59:             
    60:               implicit none
    61:             
    62:               private
    63:             
    64:             
    65:               character(len=STRING), save :: InFileNameSounding
    66:               character(len=STRING), save :: InFileNameForcing
    67:             
    68:               integer              , save :: Inimax
    69:               integer              , save :: Injmax
    70:               integer              , save :: Inkmax
    71:               integer              , save :: Intmax
    72:               real(DP), allocatable, save :: z_InPress(:)
    73:               real(DP), allocatable, save :: a_InTime (:)
    74:             
    75:               real(DP), save :: TimeAtDataStart
    76:             
    77:               logical              , save :: FlagDynExp
    78:             
    79:               ! 公開変数
    80:               ! Public variables
    81:               !
    82:               logical, save, public:: dynamics_twpice_scm_exp_inited = .false.
    83:                                           ! 初期設定フラグ.
    84:                                           ! Initialization flag
    85:             
    86:               public :: DynamicsTWPICESCMExp
    87:               public :: DynamicsTWPICESCMExpInit
    88:               public :: DynamicsTWPICESCMExpFinalize
    89:             
    90:               character(*), parameter:: module_name = 'dynamics_twpice_scm_exp'
    91:                                           ! モジュールの名称.
    92:                                           ! Module name
    93:               character(*), parameter:: version = &
    94:                 & '$Name:  $' // &
    95:                 & '$Id: dynamics_twpice_scm_exp.f90,v 1.1 2015/02/11 11:53:16 yot Exp $'
    96:                                           ! モジュールのバージョン
    97:                                           ! Module version
    98:             
    99:             
   100:               !--------------------------------------------------------------------------------------
   101:             
   102:             contains
   103:             
   104:               !--------------------------------------------------------------------------------------
   105:             
   106:               subroutine DynamicsTWPICESCMExp( &
   107:                 & Time,                                                      &
   108:                 & xyz_Press, xyz_Exner, xyz_Height,                          &
   109:                 & xyz_DUDtPhy, xyz_DVDtPhy, xyz_DTempDtPhy, xyzf_DQMixDtPhy, &
   110:                 & xy_PsB, xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB,             &
   111:                 & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA              &
   112:                 & )
   113:             
   114:                 ! モジュール引用 ; USE statements
   115:                 !
   116:             
   117:                 ! ヒストリデータ出力
   118:                 ! History data output
   119:                 !
   120:                 use gtool_historyauto, only: HistoryAutoPut
   121:             
   122:                 ! 物理定数設定
   123:                 ! Physical constants settings
   124:                 !
   125:                 use constants, only: &
   126:                   & Omega
   127:                                           ! $ \Omega $ [s-1].
   128:                                           ! 回転角速度.
   129:                                           ! Angular velocity
   130:             
   131:                 ! 組成に関わる配列の設定
   132:                 ! Settings of array for atmospheric composition
   133:                 !
   134:                 use composition, only: &
   135:                   &                    ncmax, &
   136:                                           ! 成分の数
   137:                                           ! Number of composition
   138:                   &                    IndexH2OVap
   139:             
   140:                 ! 座標データ設定
   141:                 ! Axes data settings
   142:                 !
   143:                 use axesset, only : y_Lat
   144:             
   145:                 ! 格子点設定
   146:                 ! Grid points settings
   147:                 !
   148:                 use gridset, only: imax, & ! 経度格子点数.
   149:                                            ! Number of grid points in longitude
   150:                   &                jmax, & ! 緯度格子点数.
   151:                                            ! Number of grid points in latitude
   152:                   &                kmax    ! 鉛直層数.
   153:                                            ! Number of vertical level
   154:             
   155:                 ! 組成に関わる配列の設定
   156:                 ! Settings of array for atmospheric composition
   157:                 !
   158:                 use composition, only: &
   159:                   &                    ncmax, &
   160:                                           ! 成分の数
   161:                                           ! Number of composition
   162:                   &                    IndexH2OVap
   163:             
   164:                 ! 時刻管理
   165:                 ! Time control
   166:                 !
   167:                 use timeset, only: &
   168:                   & DelTime            ! $ \Delta t $ [s]
   169:             
   170:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   171:                 ! Interpolate temperature on half sigma level,
   172:                 ! and calculate pressure and height
   173:                 !
   174:                 use auxiliary, only: AuxVars
   175:             
   176:                 ! 1 次元計算用力学過程ユーティリティモジュール
   177:                 ! Utility module for dynamics for 1-D calculation
   178:                 !
   179:                 use dynamics_1d_utils, only : Dynamics1DUtilsVerAdv
   180:             
   181:                 real(DP), intent(in ) :: Time
   182:                 real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   183:                 real(DP), intent(in ) :: xyz_Exner(0:imax-1,1:jmax,1:kmax)
   184:                 real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
   185:                 real(DP), intent(in ) :: xyz_DUDtPhy(0:imax-1,1:jmax,1:kmax)
   186:                 real(DP), intent(in ) :: xyz_DVDtPhy(0:imax-1,1:jmax,1:kmax)
   187:                 real(DP), intent(in ) :: xyz_DTempDtPhy (0:imax-1,1:jmax,1:kmax)
   188:                 real(DP), intent(in ) :: xyzf_DQMixDtPhy(0:imax-1,1:jmax,1:kmax,1:ncmax)
   189:                 real(DP), intent(in ) :: xy_PsB    (0:imax-1,1:jmax)
   190:                 real(DP), intent(in ) :: xyz_UB    (0:imax-1,1:jmax,1:kmax)
   191:                 real(DP), intent(in ) :: xyz_VB    (0:imax-1,1:jmax,1:kmax)
   192:                 real(DP), intent(in ) :: xyz_TempB (0:imax-1,1:jmax,1:kmax)
   193:                 real(DP), intent(in ) :: xyzf_QMixB(0:imax-1,1:jmax,1:kmax,1:ncmax)
   194:                 real(DP), intent(out) :: xy_PsA    (0:imax-1,1:jmax)
   195:                 real(DP), intent(out) :: xyz_UA    (0:imax-1,1:jmax,1:kmax)
   196:                 real(DP), intent(out) :: xyz_VA    (0:imax-1,1:jmax,1:kmax)
   197:                 real(DP), intent(out) :: xyz_TempA (0:imax-1,1:jmax,1:kmax)
   198:                 real(DP), intent(out) :: xyzf_QMixA(0:imax-1,1:jmax,1:kmax,1:ncmax)
   199:             
   200:             
   201:                 !
   202:                 ! local variables
   203:                 !
   204:                 character(len=STRING) :: InFileName
   205:                 character(len=STRING) :: InVarName
   206:             
   207:                 real(DP) :: xyz_UT      (0:imax-1,1:jmax,1:kmax)
   208:                 real(DP) :: xyz_VT      (0:imax-1,1:jmax,1:kmax)
   209:             
   210:                 real(DP) :: xyz_CorPar  (0:imax-1,1:jmax,1:kmax)
   211:             
   212:                 real(DP) :: xyz_PTempB  (0:imax-1,1:jmax,1:kmax)
   213:                 real(DP) :: xyz_PTempA  (0:imax-1,1:jmax,1:kmax)
   214:             
   215:                 real(DP) :: xyz_ExnerA  (0:imax-1,1:jmax,1:kmax)
   216:             
   217:                 real(DP) :: xyz_UObs    (0:imax-1,1:jmax,1:kmax)
   218:                 real(DP) :: xyz_VObs    (0:imax-1,1:jmax,1:kmax)
   219:                 real(DP) :: xyz_WObs    (0:imax-1,1:jmax,1:kmax)
   220:                 real(DP) :: xyz_DUDtVAdv(0:imax-1,1:jmax,1:kmax)
   221:                 real(DP) :: xyz_DVDtVAdv(0:imax-1,1:jmax,1:kmax)
   222:                 real(DP) :: xyz_DPTempDtHAdv(0:imax-1,1:jmax,1:kmax)
   223:                 real(DP) :: xyz_DQVapDtHAdv (0:imax-1,1:jmax,1:kmax)
   224:                 real(DP) :: xyz_DPTempDtVAdv(0:imax-1,1:jmax,1:kmax)
   225:                 real(DP) :: xyz_DQVapDtVAdv (0:imax-1,1:jmax,1:kmax)
   226:             
   227:                 real(DP) :: xyz_DUDt    (0:imax-1,1:jmax,1:kmax)
   228:                 real(DP) :: xyz_DVDt    (0:imax-1,1:jmax,1:kmax)
   229:                 real(DP) :: xyz_DPTempDt(0:imax-1,1:jmax,1:kmax)
   230:                 real(DP) :: xyz_DQVapDt (0:imax-1,1:jmax,1:kmax)
   231:             
   232:                 real(DP), parameter :: UVTimeConst = 2.0_DP * 60.0_DP * 60.0_DP
   233:             
   234:                 real(DP) :: DelTimeX2
   235:             
   236:                 integer :: j
   237:                 integer :: k
   238:                 integer :: n
   239:             
   240:             
   241:                 ! 初期化確認
   242:                 ! Initialization check
   243:                 !
   244:                 if ( .not. dynamics_twpice_scm_exp_inited ) then
   245:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   246:                 end if
   247:             
   248:             
   249:                 DelTimeX2 = 2.0_DP * DelTime
   250:             
   251:             
   252: +------>        do k = 1, kmax
   253: |+----->          do j = 1, jmax
   254: ||V====             xyz_CorPar(:,j,k) = 2.0_DP * Omega * sin( y_Lat(j) )
   255: |+-----           end do
   256: +------         end do
   257:             
   258:             
   259:                 InFileName = InFileNameSounding
   260:                 !
   261:                 InVarName  = 'u'
   262:                 call DynamicsTWPICESCMExpPTInterp( &
   263:                   & InFileName, InVarName, Time,         &
   264:                   & xyz_Press,                           &
   265:                   & xyz_UObs                             &
   266:                   & )
   267:                 InVarName  = 'v'
   268:                 call DynamicsTWPICESCMExpPTInterp( &
   269:                   & InFileName, InVarName, Time,         &
   270:                   & xyz_Press,                           &
   271:                   & xyz_VObs                             &
   272:                   & )
   273:             
   274:                 InFileName = InFileNameForcing
   275:                 !
   276:                 InVarName  = 'w'
   277:                 call DynamicsTWPICESCMExpPTInterp( &
   278:                   & InFileName, InVarName, Time,         &
   279:                   & xyz_Press,                           &
   280:                   & xyz_WObs                             &
   281:                   & )
   282:                 InVarName  = 'dptdtadvh'
   283:                 call DynamicsTWPICESCMExpPTInterp( &
   284:                   & InFileName, InVarName, Time,         &
   285:                   & xyz_Press,                           &
   286:                   & xyz_DPTempDtHAdv                     &
   287:                   & )
   288:                 InVarName  = 'dqdtadvh'
   289:                 call DynamicsTWPICESCMExpPTInterp( &
   290:                   & InFileName, InVarName, Time,         &
   291:                   & xyz_Press,                           &
   292:                   & xyz_DQVapDtHAdv                      &
   293:                   & )
   294:             
   295:                 ! 1 次元計算用力学過程ユーティリティモジュール
   296:                 ! Utility module for dynamics for 1-D calculation
   297:                 !
   298:                 call Dynamics1DUtilsVerAdv(  &
   299:                   & xyz_WObs, xyz_Height, xyz_UB,  &
   300:                   & xyz_DUDtVAdv                   &
   301:                   & )
   302:                 call Dynamics1DUtilsVerAdv(  &
   303:                   & xyz_WObs, xyz_Height, xyz_VB,  &
   304:                   & xyz_DVDtVAdv                   &
   305:                   & )
   306: W**==== A       xyz_PTempB = xyz_TempB / xyz_Exner
   307:                 call Dynamics1DUtilsVerAdv(  &
   308:                   & xyz_WObs, xyz_Height, xyz_PTempB,  &
   309:                   & xyz_DPTempDtVAdv                   &
   310:                   & )
   311:                 call Dynamics1DUtilsVerAdv(  &
   312:                   & xyz_WObs, xyz_Height, xyzf_QMixB(:,:,:,IndexH2OVap), &
   313:                   & xyz_DQVapDtVAdv                                      &
   314:                   & )
   315:             
   316:             
   317:                 if ( FlagDynExp ) then
   318:             !!$      xyz_DUDt = xyz_DUDtVAdv + xyz_CorPar * xyz_VB &
   319:             !!$        & + xyz_DUDtPhy - ( xyz_UB - xyz_UObs ) / UVTimeConst
   320:             !!$      xyz_DVDt = xyz_DVDtVAdv - xyz_CorPar * xyz_UB &
   321:             !!$        & + xyz_DVDtPhy - ( xyz_VB - xyz_VObs ) / UVTimeConst
   322:             
   323:                   ! Horizontal wind velocities are relaxed to observed ones. 
   324: **V---->A         xyz_DUDt = - ( xyz_UB - xyz_UObs ) / UVTimeConst
   325: |||     A         xyz_DVDt = - ( xyz_VB - xyz_VObs ) / UVTimeConst
   326: |||         
   327: |||     A         xyz_UA = xyz_UB + xyz_DUDt * DelTimeX2
   328: **V---- A         xyz_VA = xyz_VB + xyz_DVDt * DelTimeX2
   329:             
   330:                 else
   331:             !!$      xyz_UT = xyz_UB + ( xyz_DUDtVAdv + xyz_DUDtPhy ) * DelTimeX2
   332:             !!$      xyz_VT = xyz_VB + ( xyz_DVDtVAdv + xyz_DVDtPhy ) * DelTimeX2
   333:             !!$      !
   334:             !!$      xyz_UA = &
   335:             !!$        &   (   ( 1.0_DP + DelTimeX2 / UVTimeConst )                  &
   336:             !!$        &         * ( xyz_UT + DelTimeX2 / UVTimeConst * xyz_UObs )   &
   337:             !!$        &     + ( xyz_CorPar * DelTimeX2 )                            &
   338:             !!$        &         * ( xyz_VT + DelTimeX2 / UVTimeConst * xyz_VObs ) ) &
   339:             !!$        & / (   ( 1.0_DP + DelTimeX2 / UVTimeConst )**2               &
   340:             !!$        &     + ( xyz_CorPar * DelTimeX2 )**2                       )
   341:             !!$      xyz_VA = &
   342:             !!$        & - (   ( xyz_CorPar * DelTimeX2 )                            &
   343:             !!$        &         * ( xyz_UT + DelTimeX2 / UVTimeConst * xyz_UObs )   &
   344:             !!$        &     - ( 1.0_DP + DelTimeX2 / UVTimeConst )                  &
   345:             !!$        &         * ( xyz_VT + DelTimeX2 / UVTimeConst * xyz_VObs ) ) &
   346:             !!$        & / (   ( 1.0_DP + DelTimeX2 / UVTimeConst )**2               &
   347:             !!$        &     + ( DelTimeX2 * xyz_CorPar )**2                       )
   348:             
   349: **W---->A         xyz_UA = &
   350: |||                 &   ( xyz_UB + xyz_UObs * DelTimeX2 / UVTimeConst ) &
   351: |||                 & / ( 1.0_DP + DelTimeX2 / UVTimeConst )
   352: **W---- A         xyz_VA = &
   353:                     &   ( xyz_VB + xyz_VObs * DelTimeX2 / UVTimeConst ) &
   354:                     & / ( 1.0_DP + DelTimeX2 / UVTimeConst )
   355:                 end if
   356:             
   357:             
   358:             
   359: **W---->A       xyz_DPTempDt = xyz_DPTempDtHAdv + xyz_DPTempDtVAdv &
   360: |||               & + xyz_DTempDtPhy / xyz_Exner
   361: **W---- A       xyz_DQVapDt  = xyz_DQVapDtHAdv  + xyz_DQVapDtVAdv  &
   362:                   & + xyzf_DQMixDtPhy(:,:,:,IndexH2OVap)
   363:             
   364:                 call DynamicsTWPICESCMExpPsTInterp( &
   365:                   & Time,                               &
   366:                   & xy_PsA                              &
   367:                   & )
   368:             
   369: W**==== A       xyz_PTempA = xyz_PTempB + xyz_DPTempDt * DelTimeX2
   370: W------>        do n = 1, IndexH2OVap-1
   371: |***=== A         xyzf_QMixA(:,:,:,n) = xyzf_QMixB(:,:,:,n) &
   372: |                   & + xyzf_DQMixDtPhy(:,:,:,n) * DelTimeX2
   373: W------         end do
   374:                 n = IndexH2OVap
   375: W**==== A       xyzf_QMixA(:,:,:,n) = xyzf_QMixB(:,:,:,n) &
   376:                   & + xyz_DQVapDt * DelTimeX2
   377: W------>        do n = IndexH2OVap+1, ncmax
   378: |***=== A         xyzf_QMixA(:,:,:,n) = xyzf_QMixB(:,:,:,n) &
   379: |                   & + xyzf_DQMixDtPhy(:,:,:,n) * DelTimeX2
   380: W------         end do
   381: W***=== A       xyzf_QMixA = max( xyzf_QMixA, 0.0_DP )
   382:             
   383:                 n = IndexH2OVap
   384:                 call AuxVars(                               &
   385:                   & xy_PsA, xyz_TempA, xyzf_QMixA(:,:,:,n), &  ! (in )
   386:                   & xyz_Exner = xyz_ExnerA                  &  ! (out) optional
   387:                   & )
   388: W**==== A       xyz_TempA = xyz_PTempA * xyz_ExnerA
   389:             
   390:             
   391:                 call HistoryAutoPut( Time, 'TWPICEWObs' , xyz_WObs )
   392:                 call HistoryAutoPut( Time, 'TWPICEDUDtVAdv' , xyz_DUDtVAdv )
   393:                 call HistoryAutoPut( Time, 'TWPICEDVDtVAdv' , xyz_DVDtVAdv )
   394:                 call HistoryAutoPut( Time, 'TWPICEDPTempDtVAdv' , xyz_DPTempDtVAdv )
   395:                 call HistoryAutoPut( Time, 'TWPICEDPTempDtHAdv' , xyz_DPTempDtHAdv )
   396: W**==== A       call HistoryAutoPut( Time, 'TWPICEDPTempDtPhy' , xyz_DTempDtPhy / xyz_Exner )
   397:                 call HistoryAutoPut( Time, 'TWPICEDQVapDtVAdv' , xyz_DQVapDtVAdv )
   398:                 call HistoryAutoPut( Time, 'TWPICEDQVapDtHAdv' , xyz_DQVapDtHAdv )
   399:                 call HistoryAutoPut( Time, 'TWPICEDQVapDtPhy' , xyzf_DQMixDtPhy(:,:,:,IndexH2OVap) )
   400:             
   401:               end subroutine DynamicsTWPICESCMExp
   402:             
   403:               !--------------------------------------------------------------------------------------
   404:             
   405:               subroutine DynamicsTWPICESCMExpPsTInterp( &
   406:                 & Time,                                     &
   407:                 & xy_Ps                                     &
   408:                 & )
   409:             
   410:                 ! gtool データ入力
   411:                 ! Gtool data input
   412:                 !
   413:                 use gtool_history, only: HistoryGet
   414:             
   415:                 ! 格子点設定
   416:                 ! Grid points settings
   417:                 !
   418:                 use gridset, only: imax, & ! 経度格子点数.
   419:                                            ! Number of grid points in longitude
   420:                   &                jmax, & ! 緯度格子点数.
   421:                                            ! Number of grid points in latitude
   422:                   &                kmax    ! 鉛直層数.
   423:                                            ! Number of vertical level
   424:             
   425:                 ! 文字列操作
   426:                 ! Character handling
   427:                 !
   428:                 use dc_string, only: toChar
   429:             
   430:             !!$    character(*), intent(in ) :: InFileName
   431:             !!$    character(*), intent(in ) :: InVarName
   432:                 real(DP)    , intent(in ) :: Time
   433:                 real(DP)    , intent(out) :: xy_Ps(0:imax-1,1:jmax)
   434:             
   435:             
   436:                 !
   437:                 ! local variables
   438:                 !
   439:                 real(DP) :: xyz_Array(0:imax-1,1:jmax,1:Inkmax)
   440:                 real(DP) :: z_InArray(1:Inkmax)
   441:                 character(len=STRING) :: InFileName
   442:                 character(len=STRING) :: InVarName
   443:                 real(DP) :: Ps1
   444:                 real(DP) :: Ps2
   445:                 integer :: k
   446:                 integer :: t
   447:                 integer :: TIndex
   448:             
   449:                 logical :: flag_mpi_init
   450:             
   451:             
   452:                 ! 初期化確認
   453:                 ! Initialization check
   454:                 !
   455:                 if ( .not. dynamics_twpice_scm_exp_inited ) then
   456:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   457:                 end if
   458:             
   459:             
   460:                 if ( ( Time < a_InTime(1) ) .or. ( Time > a_InTime(Intmax) ) ) then
   461:                   call MessageNotify( 'E', module_name, &
   462:                     & 'Time of %f is out of range, %f < Time < %f.', &
   463:                     & d = (/Time, a_InTime(1), a_InTime(Intmax)/) )
   464:                 end if
   465:             
   466: V------>        do t = 2, Intmax
   467: |       A         if ( Time <= a_InTime(t) ) exit
   468: V------         end do
   469:             
   470:             
   471:                 InFileName = InFileNameSounding
   472:                 InVarName  = "plev"
   473:             
   474:                 TIndex = t-1
   475:                 call HistoryGet(                   &
   476:                   & InFileName, InVarName,         & ! (in)
   477:                   & xyz_Array,                     & ! (out)
   478:                   & range = 'time=^'//toChar(t-1), & ! (in)
   479:                   & flag_mpi_split = flag_mpi_init & ! (in) optional
   480:                   & )
   481: V------>        do k = 1, Inkmax
   482: |       A         z_InArray(k) = xyz_Array(0,1,k)
   483: V------         end do
   484:                 Ps1 = z_InArray(1)
   485:             
   486:                 TIndex = t
   487:                 call HistoryGet(                   &
   488:                   & InFileName, InVarName,         & ! (in)
   489:                   & xyz_Array,                     & ! (out)
   490:                   & range = 'time=^'//toChar(t-1), & ! (in)
   491:                   & flag_mpi_split = flag_mpi_init & ! (in) optional
   492:                   & )
   493: V------>        do k = 1, Inkmax
   494: |       A         z_InArray(k) = xyz_Array(0,1,k)
   495: V------         end do
   496:                 Ps2 = z_InArray(1)
   497:             
   498: W*===== A       xy_Ps = ( Ps2 - Ps1 ) &
   499:                   & / ( a_InTime(t) - a_InTime(t-1) ) &
   500:                   & * ( Time        - a_InTime(t-1) ) &
   501:                   & + Ps1
   502:             
   503:             
   504:               end subroutine DynamicsTWPICESCMExpPsTInterp
   505:             
   506:               !--------------------------------------------------------------------------------------
   507:             
   508:               subroutine DynamicsTWPICESCMExpPTInterp( &
   509:                 & InFileName, InVarName, Time,               &
   510:                 & xyz_Press,                                 &
   511:                 & xyz_Array                                  &
   512:                 & )
   513:             
   514:                 ! gtool データ入力
   515:                 ! Gtool data input
   516:                 !
   517:                 use gtool_history, only: HistoryGet
   518:             
   519:                 ! 文字列操作
   520:                 ! Character handling
   521:                 !
   522:                 use dc_string, only: toChar
   523:             
   524:                 ! 文字列操作
   525:                 ! Character handling
   526:                 !
   527:                 use dc_string, only: toChar
   528:             
   529:                 ! 格子点設定
   530:                 ! Grid points settings
   531:                 !
   532:                 use gridset, only: imax, & ! 経度格子点数.
   533:                                            ! Number of grid points in longitude
   534:                   &                jmax, & ! 緯度格子点数.
   535:                                            ! Number of grid points in latitude
   536:                   &                kmax    ! 鉛直層数.
   537:                                            ! Number of vertical level
   538:             
   539:                 ! 1 次元計算用力学過程ユーティリティモジュール
   540:                 ! Utility module for dynamics for 1-D calculation
   541:                 !
   542:                 use dynamics_1d_utils, only : Dynamics1DUtilsVerInterp
   543:             
   544:             
   545:                 character(*), intent(in ) :: InFileName
   546:                 character(*), intent(in ) :: InVarName
   547:                 real(DP)    , intent(in ) :: Time
   548:                 real(DP)    , intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   549:                 real(DP)    , intent(out) :: xyz_Array(0:imax-1,1:jmax,1:kmax)
   550:             
   551:             
   552:                 !
   553:                 ! local variables
   554:                 !
   555:                 real(DP) :: xyz_InArray(0:imax-1,1:jmax,1:Inkmax)
   556:                 real(DP) :: z_InArray(1:Inkmax)
   557:                 real(DP) :: xyz_Array1(0:imax-1,1:jmax,1:kmax)
   558:                 real(DP) :: xyz_Array2(0:imax-1,1:jmax,1:kmax)
   559:                 integer :: k
   560:                 integer :: t
   561:                 integer :: TIndex
   562:             
   563:                 logical :: flag_mpi_init
   564:             
   565:             
   566:                 ! 初期化確認
   567:                 ! Initialization check
   568:                 !
   569:                 if ( .not. dynamics_twpice_scm_exp_inited ) then
   570:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   571:                 end if
   572:             
   573:             
   574:                 if ( ( Time < a_InTime(1) ) .or. ( Time > a_InTime(Intmax) ) ) then
   575:                   call MessageNotify( 'E', module_name, &
   576:                     & 'Time of %f is out of range, %f < Time < %f.', &
   577:                     & d = (/Time, a_InTime(1), a_InTime(Intmax)/) )
   578:                 end if
   579:             
   580: V------>        do t = 2, Intmax
   581: |       A         if ( Time <= a_InTime(t) ) exit
   582: V------         end do
   583:             
   584:             
   585:                 TIndex = t-1
   586:                 call HistoryGet(                   &
   587:                   & InFileName, InVarName,         & ! (in)
   588:                   & xyz_InArray,                   & ! (out)
   589:                   & range = 'time=^'//toChar(t-1), & ! (in)
   590:                   & flag_mpi_split = flag_mpi_init & ! (in) optional
   591:                   & )
   592: V------>        do k = 1, Inkmax
   593: |       A         z_InArray(k) = xyz_InArray(0,1,k)
   594: V------         end do
   595:                 call Dynamics1DUtilsVerInterp( &
   596:                   & Inkmax, z_InPress, z_InArray,    &
   597:                   & xyz_Press,                       &
   598:                   & xyz_Array1                       &
   599:                   & )
   600:             
   601:                 TIndex = t
   602:                 call HistoryGet(                   &
   603:                   & InFileName, InVarName,         & ! (in)
   604:                   & xyz_InArray,                   & ! (out)
   605:                   & range = 'time=^'//toChar(t),   & ! (in)
   606:                   & flag_mpi_split = flag_mpi_init & ! (in) optional
   607:                   & )
   608: V------>        do k = 1, Inkmax
   609: |       A         z_InArray(k) = xyz_InArray(0,1,k)
   610: V------         end do
   611:                 call Dynamics1DUtilsVerInterp( &
   612:                   & Inkmax, z_InPress, z_InArray,    &
   613:                   & xyz_Press,                       &
   614:                   & xyz_Array2                       &
   615:                   & )
   616:             
   617: W**==== A       xyz_Array = ( xyz_Array2 - xyz_Array1 ) &
   618:                   & / ( a_InTime(t) - a_InTime(t-1) ) &
   619:                   & * ( Time        - a_InTime(t-1) ) &
   620:                   & + xyz_Array1
   621:             
   622:             
   623:               end subroutine DynamicsTWPICESCMExpPTInterp
   624:             
   625:               !--------------------------------------------------------------------------------------
   626:             
   627:               subroutine DynamicsTWPICESCMExpInit
   628:             
   629:                 ! 文字列操作
   630:                 ! Character handling
   631:                 !
   632:                 use dc_string, only: toChar
   633:             
   634:                 ! gtool データ入力
   635:                 ! Gtool data input
   636:                 !
   637:                 use gtool_history, only: HistoryGet, HistoryGetAttr
   638:             
   639:                 ! ヒストリデータ出力
   640:                 ! History data output
   641:                 !
   642:                 use gtool_historyauto, only: HistoryAutoAddVariable
   643:             
   644:                 ! NetCDF のラッパープログラム
   645:                 ! NetCDF wrapper
   646:                 !
   647:                 use netcdf_wrapper, only : NWInqDimLen, NWGetAtt
   648:             
   649:                 ! NAMELIST ファイル入力に関するユーティリティ
   650:                 ! Utilities for NAMELIST file input
   651:                 !
   652:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   653:             
   654:                 ! ファイル入出力補助
   655:                 ! File I/O support
   656:                 !
   657:                 use dc_iounit, only: FileOpen
   658:             
   659:                 ! 時刻管理
   660:                 ! Time control
   661:                 !
   662:                 use timeset, only: &
   663:                   & InitialDate             ! 計算開始日時.
   664:                                             ! Start date of calculation
   665:             
   666:                 ! 暦と日時の取り扱い
   667:                 ! Calendar and Date handler
   668:                 !
   669:                 use dc_calendar, only: &
   670:                   & DC_CAL_DATE, &          ! 日時を表現するデータ型.
   671:                                             ! Data type for date and time
   672:                   & DCCalDateCreate, DCCalDateDifference
   673:             
   674:                 ! 1 次元計算用力学過程ユーティリティモジュール
   675:                 ! Utility module for dynamics for 1-D calculation
   676:                 !
   677:                 use dynamics_1d_utils, only : Dynamics1DUtilsInit
   678:             
   679:             
   680:                 ! 宣言文 ; Declaration statements
   681:                 !
   682:                 character(len=STRING) :: InFileName
   683:             
   684:                 character(len=STRING) :: Units
   685:             
   686:                 integer  :: TWPICEDataStartYear
   687:                 integer  :: TWPICEDataStartMonth
   688:                 integer  :: TWPICEDataStartDay
   689:                 integer  :: TWPICEDataStartHour
   690:                 integer  :: TWPICEDataStartMin
   691:                 real(DP) :: TWPICEDataStartSec
   692:             
   693:                 type(DC_CAL_DATE):: TWPICEDataStartDate
   694:             
   695:                 logical :: flag_mpi_init
   696:             
   697:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   698:                                           ! Unit number for NAMELIST file open
   699:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   700:                                           ! IOSTAT of NAMELIST read
   701:             
   702:             
   703:                 ! NAMELIST 変数群
   704:                 ! NAMELIST group name
   705:                 !
   706:                 namelist /dynamics_twpice_scm_exp_nml/ &
   707:                   & InFileNameSounding, &
   708:                   & InFileNameForcing,  &
   709:                   & FlagDynExp
   710:                       !
   711:                       ! デフォルト値については初期化手続 "set_GATE_profile#SetGATEProfileInit"
   712:                       ! のソースコードを参照のこと.
   713:                       !
   714:                       ! Refer to source codes in the initialization procedure
   715:                       ! "set_GATE_profile#SetGATEProfileInit" for the default values.
   716:                       !
   717:             
   718:                 ! デフォルト値の設定
   719:                 ! Default values settings
   720:                 !
   721:                 InFileNameSounding = 'sounding.nc'
   722:                 InFileNameForcing  = 'forcing.nc'
   723:             
   724:                 FlagDynExp = .false.
   725:             
   726:                 ! NAMELIST の読み込み
   727:                 ! NAMELIST is input
   728:                 !
   729:                 if ( trim(namelist_filename) /= '' ) then
   730:                   call FileOpen( unit_nml, &          ! (out)
   731:                     & namelist_filename, mode = 'r' ) ! (in)
   732:             
   733:                   rewind( unit_nml )
   734:                   read( unit_nml,                        & ! (in)
   735:                     & nml = dynamics_twpice_scm_exp_nml, & ! (out)
   736:                     & iostat = iostat_nml )                ! (out)
   737:                   close( unit_nml )
   738:             
   739:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   740:                 end if
   741:             
   742:             
   743:                 InFileName = InFileNameSounding
   744:             
   745:                 call NWInqDimLen( &
   746:                   & InFileName,   & ! (in )
   747:                   & 'levelnum',   & ! (in )
   748:                   & Inkmax        & ! (out)
   749:                   & )
   750:                 call NWInqDimLen( &
   751:                   & InFileName,   & ! (in )
   752:                   & 'time',       & ! (in )
   753:                   & Intmax        & ! (out)
   754:                   & )
   755:             
   756:                 allocate( z_InPress( Inkmax ) )
   757:                 allocate( a_InTime ( Intmax ) )
   758:             
   759:                 flag_mpi_init = .true.
   760:             
   761:                 call HistoryGet(                   &
   762:                   & InFileName, 'plev',            & ! (in)
   763:                   & z_InPress,                     & ! (out)
   764:                   & flag_mpi_split = flag_mpi_init & ! (in) optional
   765:                   & )
   766:                 call HistoryGet(                   &
   767:                   & InFileName, 'time',            & ! (in)
   768:                   & a_InTime,                      & ! (out)
   769:                   & flag_mpi_split = flag_mpi_init & ! (in) optional
   770:                   & )
   771:             
   772:                 ! Check unit
   773:                 call NWGetAtt(  &
   774:                   & InFileName, 'time', 'units', & ! (in )
   775:                   & Units       & ! (out)
   776:                   & )
   777:                 if ( ( Units(1:4) /= "hour" ) .and. &
   778:                   &  ( Units(1:4) /= "Hour" ) .and. &
   779:                   &  ( Units(1:4) /= "HOUR" ) ) then
   780:                   call MessageNotify( 'E', module_name, 'Unit of time, %c is inappropriate.', c1 = trim(Units) )
   781:                 end if
   782:                 ! Unit conversion from hour to second
   783: V====== A       a_InTime = a_InTime * ( 60.0_DP * 60.0_DP )
   784:             
   785:                 ! Offset
   786:                 TWPICEDataStartYear  = 2006
   787:                 TWPICEDataStartMonth =    1
   788:                 TWPICEDataStartDay   =   18
   789:                 TWPICEDataStartHour  =    0
   790:                 TWPICEDataStartMin   =    0
   791:                 TWPICEDataStartSec   =    0.0_DP
   792:                 call DCCalDateCreate(    &
   793:                   & year  = TWPICEDataStartYear,   & ! (in)
   794:                   & month = TWPICEDataStartMonth,  & ! (in)
   795:                   & day   = TWPICEDataStartDay,    & ! (in)
   796:                   & hour  = TWPICEDataStartHour,   & ! (in)
   797:                   & min   = TWPICEDataStartMin,    & ! (in)
   798:                   & sec   = TWPICEDataStartSec,    & ! (in)
   799:                   & date  = TWPICEDataStartDate )    ! (out) optional
   800:                 TimeAtDataStart = DCCalDateDifference( &
   801:                   &                 start_date = InitialDate,        & ! (in)
   802:                   &                 end_date   = TWPICEDataStartDate & ! (in)
   803:                   &                 )
   804: V====== A       a_InTime = a_InTime + TimeAtDataStart
   805:             
   806:             
   807:                 ! 1 次元計算用力学過程ユーティリティモジュール
   808:                 ! Utility module for dynamics for 1-D calculation
   809:                 !
   810:                 call Dynamics1DUtilsInit
   811:             
   812:             
   813:                 ! ヒストリデータ出力のためのへの変数登録
   814:                 ! Register of variables for history data output
   815:                 !
   816:                 call HistoryAutoAddVariable( 'TWPICEWObs', &
   817:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   818:                   & 'vertical wind for TWP-ICE experiment', 'm s-1' )
   819:                 call HistoryAutoAddVariable( 'TWPICEDUDtVAdv', &
   820:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   821:                   & 'zonal wind tendency due to vertical advection', 'm s-2' )
   822:                 call HistoryAutoAddVariable( 'TWPICEDVDtVAdv', &
   823:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   824:                   & 'meridional wind tendency due to vertical advection', 'm s-2' )
   825:                 call HistoryAutoAddVariable( 'TWPICEDPTempDtVAdv', &
   826:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   827:                   & 'potential temperature tendency due to vertical advection', 'K s-1' )
   828:                 call HistoryAutoAddVariable( 'TWPICEDPTempDtHAdv', &
   829:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   830:                   & 'potential temperature tendency due to horizontal advection', 'K s-1' )
   831:                 call HistoryAutoAddVariable( 'TWPICEDPTempDtPhy', &
   832:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   833:                   & 'potential temperature tendency due to physical processes', 'K s-1' )
   834:                 call HistoryAutoAddVariable( 'TWPICEDQVapDtVAdv', &
   835:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   836:                   & 'specific humidity tendency due to vertical advection', 's-1' )
   837:                 call HistoryAutoAddVariable( 'TWPICEDQVapDtHAdv', &
   838:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   839:                   & 'specific humidity tendency due to horizontal advection', 's-1' )
   840:                 call HistoryAutoAddVariable( 'TWPICEDQVapDtPhy', &
   841:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   842:                   & 'specific humidity tendency due to physical processes', 's-1' )
   843:             
   844:             
   845:                 ! 印字 ; Print
   846:                 !
   847:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   848:                 call MessageNotify( 'M', module_name, 'InFileNameSounding = %c', c1 = trim(InFileNameSounding) )
   849:                 call MessageNotify( 'M', module_name, 'InFileNameForcing  = %c', c1 = trim(InFileNameForcing ) )
   850:                 call MessageNotify( 'M', module_name, 'FlagDynExp         = %b', l = (/ FlagDynExp /) )
   851:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   852:             
   853:             
   854:                 dynamics_twpice_scm_exp_inited = .true.
   855:             
   856:             
   857:               end subroutine DynamicsTWPICESCMExpInit
   858:             
   859:               !--------------------------------------------------------------------------------------
   860:             
   861:               subroutine DynamicsTWPICESCMExpFinalize
   862:             
   863:             
   864:                 ! 宣言文 ; Declaration statements
   865:                 !
   866:             
   867:             
   868:                 deallocate( z_InPress )
   869:                 deallocate( a_InTime  )
   870:             
   871:             
   872:                 dynamics_twpice_scm_exp_inited = .false.
   873:             
   874:             
   875:               end subroutine DynamicsTWPICESCMExpFinalize
   876:             
   877:               !--------------------------------------------------------------------------------------
   878:             
   879:             end module dynamics_TWPICE_SCM_exp
