Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:48 2016
FILE NAME: gwd_m1987.f90
PROGRAM NAME: gwd_m1987
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   279  opt  (1593): Loop nest collapsed into one loop.
   279  vec  (   4): Vectorized array expression.
   279  vec  (  29): ADB is used for array.: xy_surfheightstd
   281  opt  (1593): Loop nest collapsed into one loop.
   281  vec  (   1): Vectorized loop.
   281  vec  (  29): ADB is used for array.: xyr_press
   288  opt  (1593): Loop nest collapsed into one loop.
   288  vec  (   4): Vectorized array expression.
   290  opt  (1593): Loop nest collapsed into one loop.
   290  vec  (   1): Vectorized loop.
   290  vec  (  29): ADB is used for array.: xy_kindexref
   290  vec  (  29): ADB is used for array.: xy_orogeffheight
   290  vec  (  29): ADB is used for array.: xy_surfheight
   290  vec  (  29): ADB is used for array.: xyz_height
   293  opt  (1059): Unable to determine last value of scalar temporary.
   299  opt  (1593): Loop nest collapsed into one loop.
   299  vec  (   4): Vectorized array expression.
   301  opt  (1593): Loop nest collapsed into one loop.
   301  vec  (   1): Vectorized loop.
   301  vec  (  29): ADB is used for array.: xy_kindexref
   301  vec  (  29): ADB is used for array.: xyr_press
   301  vec  (  29): ADB is used for array.: xyz_press
   304  opt  (1059): Unable to determine last value of scalar temporary.
   315  vec  (   3): Unvectorized loop.
   315  vec  (  13): Overhead of loop division is too large.
   316  opt  (  11): Fused array assignments. :line 316 - 317
   316  opt  (1593): Loop nest collapsed into one loop.
   316  vec  (   4): Vectorized array expression.
   316  vec  (  29): ADB is used for array.: xy_vref
   316  vec  (  29): ADB is used for array.: xy_uref
   320  opt  (1593): Loop nest collapsed into one loop.
   320  vec  (   4): Vectorized array expression.
   320  vec  (  29): ADB is used for array.: xy_vref
   320  vec  (  29): ADB is used for array.: xy_uref
   324  opt  (1593): Loop nest collapsed into one loop.
   324  vec  (   4): Vectorized array expression.
   324  vec  (  29): ADB is used for array.: xyz_temp
   324  vec  (  29): ADB is used for array.: xyz_press
   326  vec  (   3): Unvectorized loop.
   326  vec  (  13): Overhead of loop division is too large.
   327  opt  (1593): Loop nest collapsed into one loop.
   327  vec  (   4): Vectorized array expression.
   327  vec  (  29): ADB is used for array.: xy_rhoref
   331  opt  (1593): Loop nest collapsed into one loop.
   331  vec  (   4): Vectorized array expression.
   331  vec  (  29): ADB is used for array.: xyz_exner
   331  vec  (  29): ADB is used for array.: xyz_temp
   333  vec  (   3): Unvectorized loop.
   333  vec  (  13): Overhead of loop division is too large.
   336  opt  (1593): Loop nest collapsed into one loop.
   336  vec  (   4): Vectorized array expression.
   336  vec  (  29): ADB is used for array.: xyz_height
   342  opt  (  11): Fused array assignments. :line 342 - 343
   342  opt  (1593): Loop nest collapsed into one loop.
   342  vec  (   4): Vectorized array expression.
   345  vec  (   3): Unvectorized loop.
   345  vec  (  13): Overhead of loop division is too large.
   346  opt  (1593): Loop nest collapsed into one loop.
   346  vec  (   4): Vectorized array expression.
   346  vec  (  29): ADB is used for array.: xy_nref
   351  opt  (1593): Loop nest collapsed into one loop.
   351  vec  (   1): Vectorized loop.
   351  vec  (  29): ADB is used for array.: xy_abswindspeedref
   351  vec  (  29): ADB is used for array.: xy_vref
   351  vec  (  29): ADB is used for array.: xyz_v
   351  vec  (  29): ADB is used for array.: xy_uref
   351  vec  (  29): ADB is used for array.: xyz_u
   364  opt  (1593): Loop nest collapsed into one loop.
   364  vec  (   4): Vectorized array expression.
   371  opt  (1593): Loop nest collapsed into one loop.
   371  vec  (   4): Vectorized array expression.
   371  vec  (  29): ADB is used for array.: xy_abswindspeedref
   371  vec  (  29): ADB is used for array.: xy_nref
   371  vec  (  29): ADB is used for array.: xy_rhoref
   371  vec  (  29): ADB is used for array.: xy_orogeffheight
   380  vec  (   1): Vectorized loop.
   380  vec  (  29): ADB is used for array.: xyz_zeroone
   380  vec  (  29): ADB is used for array.: xyz_momflux
   385  vec  (   3): Unvectorized loop.
   385  vec  (  13): Overhead of loop division is too large.
   387  opt  (1037): Feedback of array elements.
   387  vec  (  20): Unvectorizable dependency.:xyz_momflux
   403  vec  (  20): Unvectorizable dependency.:xyz_momflux
   425  opt  (1593): Loop nest collapsed into one loop.
   425  vec  (   1): Vectorized loop.
   450  vec  (   3): Unvectorized loop.
   450  vec  (  13): Overhead of loop division is too large.
   451  opt  (1037): Feedback of array elements.
   451  opt  (1037): Feedback of array elements.
   451  vec  (  20): Unvectorizable dependency.:xyz_dwindspeeddt
   468  vec  (  20): Unvectorizable dependency.:xyz_dwindspeeddt
   470  vec  (  20): Unvectorizable dependency.:xyz_momflux
   480  vec  (  20): Unvectorizable dependency.:xyz_dwindspeeddt
   481  vec  (  20): Unvectorizable dependency.:xyz_momflux
   585  opt  (1593): Loop nest collapsed into one loop.
   585  vec  (   1): Vectorized loop.
   585  vec  (  29): ADB is used for array.: xyz_dudt
   585  vec  (  29): ADB is used for array.: xyz_dvdt
   585  vec  (  29): ADB is used for array.: xy_vref
   585  vec  (  29): ADB is used for array.: xy_abswindspeedref
   585  vec  (  29): ADB is used for array.: xy_uref
   585  vec  (  29): ADB is used for array.: xyz_dwindspeeddt
   612  opt  (1593): Loop nest collapsed into one loop.
   612  vec  (   1): Vectorized loop.
   612  vec  (  29): ADB is used for array.: xyr_momfluxa
   612  vec  (  29): ADB is used for array.: xyz_dwindspeeddt
   627  opt  (1593): Loop nest collapsed into one loop.
   627  vec  (   4): Vectorized array expression.
   627  vec  (  29): ADB is used for array.: xyr_momfluxa
   629  opt  (1593): Loop nest collapsed into one loop.
   629  vec  (   4): Vectorized array expression.
   629  vec  (  29): ADB is used for array.: xyr_momfluxa
   633  opt  (1593): Loop nest collapsed into one loop.
   633  vec  (   1): Vectorized loop.
   633  vec  (  29): ADB is used for array.: xyr_momfluxxa
   633  vec  (  29): ADB is used for array.: xyr_momfluxya
   633  vec  (  29): ADB is used for array.: xy_vref
   633  vec  (  29): ADB is used for array.: xy_abswindspeedref
   633  vec  (  29): ADB is used for array.: xy_uref
   633  vec  (  29): ADB is used for array.: xyr_momfluxa
   700  warn (  82): Name "az_d" is not used.
   700  warn (  82): Name "az_a" is not used.
   700  warn (  82): Name "az_b" is not used.
   700  warn (  82): Name "az_c" is not used.
   700  warn (  82): Name "me" is not used.
   700  warn (  82): Name "xyz_amp" is not used.
   700  warn (  82): Name "mmax" is not used.
   700  warn (  82): Name "ms" is not used.
   737  vec  (   1): Vectorized loop.
   737  vec  (  29): ADB is used for array.: f
   737  vec  (  29): ADB is used for array.: b
   737  vec  (  29): ADB is used for array.: c
   743  vec  (   1): Vectorized loop.
   743  vec  (  29): ADB is used for array.: f
   743  vec  (  29): ADB is used for array.: c
   743  vec  (  29): ADB is used for array.: a
   743  vec  (  29): ADB is used for array.: b
   744  opt  (1037): Feedback of array elements.
   746  opt  (1037): Feedback of array elements.
   753  vec  (   1): Vectorized loop.
   753  vec  (  29): ADB is used for array.: f
   754  opt  (1037): Feedback of array elements.
   949  warn (  82): Name "k" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:48 2016
FILE NAME: gwd_m1987.f90
PROGRAM NAME: gwd_m1987
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Gravity wave drag by McFarlane (1987)
     2  !
     3  != Gravity wave drag by McFarlane (1987)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: gwd_m1987.f90,v 1.2 2015/03/11 04:54:29 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module gwd_m1987
    13    !
    14    != Gravity wave drag by McFarlane (1987)
    15    !
    16    != Gravity wave drag by McFarlane (1987)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! Calculate tendency by gravity wave drag
    21    !
    22    !== References
    23    !
    24    !  McFarlane, N. A.,
    25    !    The effect of orographically excited gravity wave drag on the general
    26    !    circulation of the lower stratosphere and troposphsere,
    27    !    J. Atmos. Sci., 44, 1775-1800, 1987.
    28    !
    29    !== Procedures List
    30    !
    31    ! GWDM1987     :: Calculation of gravity wave drag tendency
    32    ! GWDM1987Init :: Initialization
    33    ! ------------ :: ------------
    34    ! GWDM1987     :: Calculation of gravity wave drag tendency
    35    ! GWDM1987Init :: Initialization
    36    !
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#gwd_m1987_nml
    40    !
    41  
    42    ! モジュール引用 ; USE statements
    43    !
    44  
    45    ! 格子点設定
    46    ! Grid points settings
    47    !
    48    use gridset, only: imax, & ! 経度格子点数.
    49                               ! Number of grid points in longitude
    50      &                jmax, & ! 緯度格子点数.
    51                               ! Number of grid points in latitude
    52      &                kmax    ! 鉛直層数.
    53                               ! Number of vertical level
    54  
    55    ! 種別型パラメタ
    56    ! Kind type parameter
    57    !
    58    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    59      &                 STRING     ! 文字列.       Strings.
    60  
    61    ! NAMELIST ファイル入力に関するユーティリティ
    62    ! Utilities for NAMELIST file input
    63    !
    64    use namelist_util, only: MaxNmlArySize
    65                                ! NAMELIST から読み込む配列の最大サイズ.
    66                                ! Maximum size of arrays loaded from NAMELIST
    67  
    68    ! メッセージ出力
    69    ! Message output
    70    !
    71    use dc_message, only: MessageNotify
    72  
    73    ! 物理・数学定数設定
    74    ! Physical and mathematical constants settings
    75    !
    76    use constants0, only: &
    77      & PI                    ! $ \pi $.
    78                              ! 円周率. Circular constant
    79  
    80  
    81    ! 宣言文 ; Declaration statements
    82    !
    83    implicit none
    84    private
    85  
    86  !!$  logical , save :: FlagUse
    87  !!$                              ! 使用フラグ
    88  !!$                              ! flag for use of this scheme
    89  
    90    logical , save :: FlagDetermineRefLevByStd
    91    real(DP), save :: SigmaRef
    92                                ! Sigma at reference level
    93    real(DP), save :: Efficiency
    94                                ! "Efficiency"
    95    real(DP), save :: OrogEffWaveLength
    96                                ! Orography effective wave length
    97    real(DP), save :: CrtlFNumSq
    98                                ! Critical Froude number squared
    99    real(DP), save :: MomFluxFactor
   100                                ! Factor for momentum flux
   101  
   102  !!$  logical, save  :: FlagGWDDamp
   103  !!$  real(DP), save :: GWDDampPeriod
   104  
   105    ! 公開手続き
   106    ! Public procedure
   107    !
   108    public :: GWDM1987
   109    public :: GWDM1987Init
   110  
   111    ! 公開変数
   112    ! Public variables
   113    !
   114  
   115    ! 非公開変数
   116    ! Private variables
   117    !
   118    logical, save :: gwd_m1987_inited = .false.
   119                                ! 初期設定フラグ.
   120                                ! Initialization flag
   121  
   122    character(*), parameter:: module_name = 'gwd_m1987'
   123                                ! モジュールの名称.
   124                                ! Module name
   125    character(*), parameter:: version = &
   126      & '$Name:  $' // &
   127      & '$Id: gwd_m1987.f90,v 1.2 2015/03/11 04:54:29 yot Exp $'
   128                                ! モジュールのバージョン
   129                                ! Module version
   130  
   131  contains
   132  
   133    subroutine GWDM1987(                                 &
   134      & xyz_U, xyz_V, xyz_Temp,                          & ! (in)
   135      & xyz_Press, xyr_Press, xyz_Exner, xyz_Height,     & ! (in)
   136      & xy_SurfHeight, xy_SurfHeightStd,                 & ! (in)
   137      & xyz_DUDt, xyz_DVDt                               & ! (out)
   138      & )
   139      !
   140      !
   141      !
   142      ! Tendency of gravity wave drag based on McFarlane (1987)
   143      !
   144  
   145      ! モジュール引用 ; USE statements
   146      !
   147  
   148      ! 物理定数設定
   149      ! Physical constants settings
   150      !
   151      use constants, only: &
   152        & Grav, &
   153                                ! $ g $ [m s-2].
   154                                ! 重力加速度.
   155                                ! Gravitational acceleration
   156        & GasRDry
   157                                ! $ R $ [J kg-1 K-1].
   158                                ! 乾燥大気の気体定数.
   159                                ! Gas constant of air
   160  
   161      ! 時刻管理
   162      ! Time control
   163      !
   164      use timeset, only: &
   165        & DelTime, &            ! $ \Delta t $
   166        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   167        & TimesetClockStart, TimesetClockStop
   168  
   169      ! ヒストリデータ出力
   170      ! History data output
   171      !
   172      use gtool_historyauto, only: HistoryAutoPut
   173  
   174  
   175      ! 宣言文 ; Declaration statements
   176      !
   177  
   178      real(DP), intent(in ) :: xyz_U       (0:imax-1, 1:jmax, 1:kmax)
   179                                ! Zonal wind
   180      real(DP), intent(in ) :: xyz_V       (0:imax-1, 1:jmax, 1:kmax)
   181                                ! Meridional wind
   182      real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   183                                ! Temperature
   184      real(DP), intent(in ) :: xyz_Press   (0:imax-1, 1:jmax, 1:kmax)
   185                                ! Pressure
   186      real(DP), intent(in ) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
   187                                ! Pressure
   188      real(DP), intent(in ) :: xyz_Exner   (0:imax-1, 1:jmax, 1:kmax)
   189                                ! Exner function
   190      real(DP), intent(in ) :: xyz_Height   (0:imax-1, 1:jmax, 1:kmax)
   191                                ! Height
   192      real(DP), intent(in ) :: xy_SurfHeight   (0:imax-1, 1:jmax)
   193      real(DP), intent(in ) :: xy_SurfHeightStd(0:imax-1, 1:jmax)
   194      real(DP), intent(out) :: xyz_DUDt    (0:imax-1, 1:jmax, 1:kmax)
   195                                ! 東西風変化率.
   196                                ! Zonal wind tendency
   197      real(DP), intent(out) :: xyz_DVDt    (0:imax-1, 1:jmax, 1:kmax)
   198                                ! 南北風変化率.
   199                                ! Meridional wind tendency
   200  
   201  
   202      ! 作業変数
   203      ! Work variables
   204      !
   205      real(DP) :: xy_OrogEffHeight(0:imax-1, 1:jmax)
   206  
   207      real(DP) :: xyz_DelPress   (0:imax-1, 1:jmax, 1:kmax)
   208  
   209      integer  :: xy_KIndexRef   (0:imax-1, 1:jmax)
   210      real(DP) :: xy_URef        (0:imax-1, 1:jmax)
   211      real(DP) :: xy_VRef        (0:imax-1, 1:jmax)
   212      real(DP) :: xyz_WindSpeed  (0:imax-1, 1:jmax, 1:kmax)
   213  
   214      real(DP) :: xy_AbsWindSpeedRef(0:imax-1, 1:jmax)
   215      real(DP) :: xy_RhoRef         (0:imax-1, 1:jmax)
   216      real(DP) :: xy_NRef           (0:imax-1, 1:jmax)
   217  
   218      real(DP) :: xyz_Rho       (0:imax-1, 1:jmax, 1:kmax)
   219      real(DP) :: xyz_PotTemp   (0:imax-1, 1:jmax, 1:kmax)
   220      real(DP) :: xyz_N         (0:imax-1, 1:jmax, 1:kmax)
   221      real(DP) :: xyz_Amp       (0:imax-1, 1:jmax, 1:kmax)
   222      real(DP) :: xyz_ZeroOne   (0:imax-1, 1:jmax, 1:kmax)
   223      real(DP) :: xy_MomFluxRef (0:imax-1, 1:jmax)
   224      real(DP) :: xyz_MomFlux   (0:imax-1, 1:jmax, 1:kmax)
   225      real(DP) :: MomFluxSaturated
   226      real(DP) :: xyz_DMomFluxDU(0:imax-1, 1:jmax, 1:kmax)
   227  
   228      real(DP) :: xyz_DWindSpeedDt(0:imax-1, 1:jmax, 1:kmax)
   229      real(DP) :: xyr_MomFluxA (0:imax-1, 1:jmax, 0:kmax)
   230      real(DP) :: xyr_MomFluxXA(0:imax-1, 1:jmax, 0:kmax)
   231      real(DP) :: xyr_MomFluxYA(0:imax-1, 1:jmax, 0:kmax)
   232  
   233      real(DP) :: WindSpeedTentative
   234  
   235  !!$    real(DP) :: MomFluxTentative
   236  
   237  
   238      integer :: mmax
   239      integer :: ms
   240      integer :: me
   241      real(DP) :: az_A(0:imax*jmax-1, 1:kmax)
   242      real(DP) :: az_B(0:imax*jmax-1, 1:kmax)
   243      real(DP) :: az_C(0:imax*jmax-1, 1:kmax)
   244      real(DP) :: az_D(0:imax*jmax-1, 1:kmax)
   245  
   246  
   247  
   248      integer :: i               ! 経度方向に回る DO ループ用作業変数
   249                                 ! Work variables for DO loop in longitude
   250      integer :: j               ! 緯度方向に回る DO ループ用作業変数
   251                                 ! Work variables for DO loop in latitude
   252      integer :: k               ! 鉛直方向に回る DO ループ用作業変数
   253                                 ! Work variables for DO loop in vertical direction
   254      integer :: kp
   255      integer :: kn
   256  
   257  !!$    real(DP) :: xyz_WindSpeedTentative(0:imax-1, 1:jmax, 1:kmax)
   258  !!$    integer :: itr
   259  
   260  
   261      ! 実行文 ; Executable statement
   262      !
   263  
   264      ! 初期化確認
   265      ! Initialization check
   266      !
   267      if ( .not. gwd_m1987_inited ) then
   268        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   269      end if
   270  
   271      ! 計算時間計測開始
   272      ! Start measurement of computation time
   273      !
   274      call TimesetClockStart( module_name )
   275  
   276  
   277      ! Calculation of additional variables
   278      !
   279      xy_OrogEffHeight = 2.0_DP * xy_SurfHeightStd
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1432 = 1, jmax*imax                                           
     .           xy_orogeffheight(t1432-1,1) = 2.00000000000000e+000*           
     .       1      xy_surfheightstd(t1432-1,1)                                 
     .        enddo                                                             
   280      !
   281      do k = 1, kmax
   282        xyz_DelPress(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
   283      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delpress(k-1,1,1) = xyr_press(k-1,1,0) - xyr_press(k-1,1,1)
     .        enddo                                                             
   284      !
   285      !   Determine reference level
   286      !
   287      if ( FlagDetermineRefLevByStd ) then
   288        xy_KIndexRef = 2
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1606 = 1, xy_kindexref.DSC.U2*xy_kindexref.DSC.U1 +           
     .       1   xy_kindexref.DSC.U2                                            
     .           xy_kindexref(t1606-1,1) = 2                                    
     .        enddo                                                             
   289        do k = 1+1, kmax
   290          do j = 1, jmax
   291            do i = 0, imax-1
   292              if ( ( xyz_Height(i,j,k) - xy_SurfHeight(i,j) ) < xy_OrogEffHeight(i,j) ) then
   293                xy_KIndexRef(i,j) = k
   294              end if
   295            end do
   296          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surfheight,xy_orogeffheight,xy_kindexref)               
     .        do j = 1, jmax*imax                                               
     .           if (xyz_height(j-1,1,k) - xy_surfheight(j-1,1) .lt.            
     .       1      xy_orogeffheight(j-1,1)) then                               
     .              xy_kindexref(j-1,1) = k                                     
     .           endif                                                          
     .        enddo                                                             
   297        end do
   298      else
   299        xy_KIndexRef = 2
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1450 = 1, xy_kindexref.DSC.U2*xy_kindexref.DSC.U1 +           
     .       1   xy_kindexref.DSC.U2                                            
     .           xy_kindexref(t1450-1,1) = 2                                    
     .        enddo                                                             
   300        do k = 1+1, kmax
   301          do j = 1, jmax
   302            do i = 0, imax-1
   303              if ( xyz_Press(i,j,k) / xyr_Press(i,j,0) > SigmaRef ) then
   304                xy_KIndexRef(i,j) = k
   305              end if
   306            end do
   307          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_press,xy_kindexref)                                    
     .        do j = 1, jmax*imax                                               
     .           if (xyz_press(j-1,1,k)/xyr_press(j-1,1,0) .gt. sigmaref) then  
     .              xy_kindexref(j-1,1) = k                                     
     .           endif                                                          
     .        enddo                                                             
   308        end do
   309      end if
   310  
   311      !
   312      !   Set reference level wind velocity
   313      !
   314      do j = 1, jmax
   315        do i = 0, imax-1
   316          xy_URef = xyz_U(i,j,xy_KIndexRef(i,j))
     .        xy_kindexref1 = xy_kindexref(i,j)                                 
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_uref,xy_vref)                                           
     .        do t1456 = 1, xy_uref.DSC.U2*xy_uref.DSC.U1 + xy_uref.DSC.U2      
     .           xy_uref(t1456-1,1) = xyz_u(i,j,xy_kindexref1)                  
     .           xy_vref(t1456-1,1) = xyz_v(i,j,xy_kindexref1)                  
     .        enddo                                                             
   317          xy_VRef = xyz_V(i,j,xy_KIndexRef(i,j))
   318        end do
   319      end do
   320      xy_AbsWindSpeedRef = sqrt( xy_URef**2 + xy_VRef**2 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_uref,xy_vref)                                           
     .        do t1464 = 1, xy_uref.DSC.U2*xy_uref.DSC.U1 + xy_uref.DSC.U2      
     .           xy_abswindspeedref(t1464-1,1) = dsqrt(xy_uref(t1464-1,1)**2+   
     .       1      xy_vref(t1464-1,1)**2)                                      
     .        enddo                                                             
   321  
   322      ! Calculation of additional variables
   323      !
   324      xyz_Rho = xyz_Press / ( GasRDry * xyz_Temp )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1474 = 1, kmax*jmax*imax                                      
     .           xyz_rho(t1474-1,1,1) = xyz_press(t1474-1,1,1)/(gasrdry*xyz_temp
     .       1      (t1474-1,1,1))                                              
     .        enddo                                                             
   325      do j = 1, jmax
   326        do i = 0, imax-1
   327          xy_RhoRef = xyz_Rho(i,j,xy_KIndexRef(i,j))
     .        xy_kindexref2 = xy_kindexref(i,j)                                 
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_rhoref)                                                 
     .        do t1489 = 1, xy_rhoref.DSC.U2*xy_rhoref.DSC.U1 + xy_rhoref.DSC.U2
     .           xy_rhoref(t1489-1,1) = xyz_rho(i,j,xy_kindexref2)              
     .        enddo                                                             
   328        end do
   329      end do
   330      !
   331      xyz_PotTemp = xyz_Temp / xyz_Exner
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1495 = 1, kmax*jmax*imax                                      
     .           xyz_pottemp(t1495-1,1,1) = xyz_temp(t1495-1,1,1)/xyz_exner(    
     .       1      t1495-1,1,1)                                                
     .        enddo                                                             
   332      !
   333      do k = 1, kmax
   334        kp = max( k - 1, 1    )
   335        kn = min( k + 1, kmax )
   336        xyz_N(:,:,k) =                                      &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1510 = 1, xyz_pottemp.DSC.U2*xyz_pottemp.DSC.U1 +             
     .       1   xyz_pottemp.DSC.U2                                             
     .           xyz_n(t1510-1,1,k) = grav/xyz_pottemp(t1510-1,1,k)*(xyz_pottemp
     .       1      (t1510-1,1,kn)-xyz_pottemp(t1510-1,1,kp))/(xyz_height(t1510-
     .       2      1,1,kn)-xyz_height(t1510-1,1,kp))                           
     .        enddo                                                             
   337          & Grav / xyz_PotTemp(:,:,k)                       &
   338          & * ( xyz_PotTemp(:,:,kn) - xyz_PotTemp(:,:,kp) ) &
   339          & / ( xyz_Height (:,:,kn) - xyz_Height (:,:,kp) )
   340      end do
   341  !!$    xyz_N = max( xyz_N, 1.0e-6_DP )
   342      xyz_N = max( xyz_N, 0.0_DP )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1526 = 1, xyz_n.DSC.U3*(xyz_n.DSC.U2*xyz_n.DSC.U1 +           
     .       1   xyz_n.DSC.U2)                                                  
     .           xyz_n(t1526-1,1,1) = max(xyz_n(t1526-1,1,1),                   
     .       1      0.0000000000000000e+000)                                    
     .           xyz_n(t1526-1,1,1) = dsqrt(xyz_n(t1526-1,1,1))                 
     .        enddo                                                             
   343      xyz_N = sqrt( xyz_N )
   344      do j = 1, jmax
   345        do i = 0, imax-1
   346          xy_NRef = xyz_N(i,j,xy_KIndexRef(i,j))
     .        xy_kindexref3 = xy_kindexref(i,j)                                 
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_nref)                                                   
     .        do t1544 = 1, xy_nref.DSC.U2*xy_nref.DSC.U1 + xy_nref.DSC.U2      
     .           xy_nref(t1544-1,1) = xyz_n(i,j,xy_kindexref3)                  
     .        enddo                                                             
   347        end do
   348      end do
   349      !
   350      do k = 1, kmax
   351        do j = 1, jmax
   352          do i = 0, imax-1
   353            if ( xy_AbsWindSpeedRef(i,j) /= 0.0_DP ) then
   354              xyz_WindSpeed(i,j,k) = &
   355                & ( xyz_U(i,j,k) * xy_URef(i,j) + xyz_V(i,j,k) * xy_VRef(i,j) ) &
   356                & / xy_AbsWindSpeedRef(i,j)
   357            else
   358              xyz_WindSpeed(i,j,k) = 0.0_DP
   359            end if
   360          end do
   361        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_uref,xy_vref,xy_abswindspeedref)                        
     .        do j = 1, jmax*imax                                               
     .           if (xy_abswindspeedref(j-1,1) .ne. 0.0000000000000000e+000)    
     .       1      then                                                        
     .              xyz_windspeed1 = (xyz_u(j-1,1,k)*xy_uref(j-1,1)+xyz_v(j-1,1,
     .       1         k)*xy_vref(j-1,1))/xy_abswindspeedref(j-1,1)             
     .           else                                                           
     .              xyz_windspeed1 = 0.0000000000000000e+000                    
     .           endif                                                          
     .           xyz_windspeed(j-1,1,k) = xyz_windspeed1                        
     .        enddo                                                             
   362      end do
   363      ! Negative wind speed is inrelevant in the current formulation.
   364      xyz_WindSpeed = max( xyz_WindSpeed, 0.0_DP )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1550 = 1, xyz_windspeed.DSC.U3*(xyz_windspeed.DSC.U2*         
     .       1   xyz_windspeed.DSC.U1 + xyz_windspeed.DSC.U2)                   
     .           xyz_windspeed(t1550-1,1,1) = max(xyz_windspeed(t1550-1,1,1),   
     .       1      0.0000000000000000e+000)                                    
     .        enddo                                                             
   365  
   366  
   367      ! Wave amplitude
   368      !
   369      ! Momentum flux parallel to the reference level flow at reference level
   370      !
   371      xy_MomFluxRef = - MomFluxFactor * xy_OrogEffHeight**2 &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_orogeffheight,xy_rhoref,xy_nref,xy_abswindspeedref)     
     .        do t1562 = 1, xy_orogeffheight.DSC.U2*xy_orogeffheight.DSC.U1 +   
     .       1   xy_orogeffheight.DSC.U2                                        
     .           xy_momfluxref(t1562-1,1) = -momfluxfactor*xy_orogeffheight(    
     .       1      t1562-1,1)**2*xy_rhoref(t1562-1,1)*xy_nref(t1562-1,1)*      
     .       2      xy_abswindspeedref(t1562-1,1)                               
     .        enddo                                                             
   372        & * xy_RhoRef * xy_NRef * xy_AbsWindSpeedRef
   373  
   374      !
   375      ! Momentum flux parallel to the reference level flow
   376      !
   377      do j = 1, jmax
   378        do i = 0, imax-1
   379          ! Region at and below the reference level
   380          do k = 1, xy_KIndexRef(i,j)
   381            xyz_MomFlux(i,j,k) = xy_MomFluxRef(i,j)
   382            xyz_ZeroOne(i,j,k) = 0.0_DP
   383          end do
   384          ! Region above the reference level and below the highest model level
   385          do k = xy_KIndexRef(i,j)+1, kmax-1
   386            ! momentum flux is same as that in lower level tentatively
   387            xyz_MomFlux(i,j,k) = xyz_MomFlux(i,j,k-1)
   388            ! calculate momentum flux in the case of saturation
   389            if ( xyz_N(i,j,k) > 0.0_DP ) then
   390              MomFluxSaturated = &
   391                & - MomFluxFactor * CrtlFNumSq &
   392                &   * xyz_Rho(i,j,k) / xyz_N(i,j,k) * xyz_WindSpeed(i,j,k)**3
   393            else
   394              MomFluxSaturated = 0.0_DP
   395            end if
   396            ! comparison of momentum flux
   397            ! check whether saturationed or not
   398            ! It should be noted that momentum flux here is negative, since
   399            ! a direction of the momentum flux is parallel to reference level
   400            ! flow.
   401            if ( MomFluxSaturated > xyz_MomFlux(i,j,k) ) then
   402              ! saturation region
   403              xyz_MomFlux(i,j,k) = MomFluxSaturated
   404              xyz_ZeroOne(i,j,k) = 1.0_DP
   405            else
   406              ! non-saturation region
   407              xyz_ZeroOne(i,j,k) = 0.0_DP
   408            end if
   409          end do
   410          ! highest model level
   411          do k = kmax, kmax
   412            ! momentum flux is same as that in lower level
   413            xyz_MomFlux(i,j,k) = xyz_MomFlux(i,j,k-1)
   414            xyz_ZeroOne(i,j,k) = 0.0_DP
   415          end do
     .           xyz_momflux(i,j,kmax) = xyz_momflux(i,j,kmax-1)                
     .        xyz_zeroone(i,j,kmax) = 0.0000000000000000e+000                   
   416        end do
   417      end do
   418      !
   419      ! Momentum flux derivative with reference level flow
   420      !
   421  !!$    xyz_DMomFluxDU =                                            &
   422  !!$      & - 3.0_DP * MomFluxFactor * CrtlFNumSq * xyz_Rho / xyz_N &
   423  !!$      &   * xyz_WindSpeed**2                                    &
   424  !!$      &   * xyz_ZeroOne
   425      do k = 1, kmax
   426        do j = 1, jmax
   427          do i = 0, imax-1
   428            if ( xyz_N(i,j,k) > 0.0_DP ) then
   429              xyz_DMomFluxDU(i,j,k) =                   &
   430                & - 3.0_DP * MomFluxFactor * CrtlFNumSq &
   431                &   * xyz_Rho(i,j,k) / xyz_N(i,j,k)     &
   432                &   * xyz_WindSpeed(i,j,k)**2           &
   433                &   * xyz_ZeroOne(i,j,k)
   434            else
   435              xyz_DMomFluxDU(i,j,k) = 0.0_DP
   436            end if
   437          end do
   438        end do
   439      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_n(k-1,1,1) .gt. 0.0000000000000000e+000) then          
     .              xyz_dmomfluxdu2 = -3.00000000000000e+000*momfluxfactor*     
     .       1         crtlfnumsq*xyz_rho(k-1,1,1)/xyz_n(k-1,1,1)*xyz_windspeed(
     .       2         k-1,1,1)**2*xyz_zeroone(k-1,1,1)                         
     .           else                                                           
     .              xyz_dmomfluxdu2 = 0.0000000000000000e+000                   
     .           endif                                                          
     .           xyz_dmomfluxdu(k-1,1,1) = xyz_dmomfluxdu2                      
     .        enddo                                                             
   440  
   441  
   442      !
   443      ! calculation of wind velocity tendency
   444      !
   445      do j = 1, jmax
   446        do i = 0, imax-1
   447          ! No deceleration is assumed in the highest level
   448          k = kmax
   449          xyz_DWindSpeedDt(i,j,k) = 0.0_DP
   450          do k = kmax-1, 1+1, -1
   451            xyz_DWindSpeedDt(i,j,k) = &
   452              & Grav / xyz_DelPress(i,j,k) / 2.0_DP                         &
   453              & * (   xyz_MomFlux(i,j,k-1)                                  &
   454              &     - xyz_MomFlux(i,j,k+1)                                  &
   455              &     - xyz_DMomFluxDU(i,j,k+1) * xyz_DWindSpeedDt(i,j,k+1)   &
   456              &       * ( 2.0_DP * DelTime )                              ) &
   457              & / ( 1.0_DP - Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   458              &              * xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )
   459  
   460            ! Wind speed tendency at k level and momentum flux at k-1 level
   461            ! are estimated again.
   462            if ( k >= xy_KIndexRef(i,j) ) then
   463              ! Region above reference level
   464              WindSpeedTentative =       &
   465                &   xyz_WindSpeed(i,j,k) &
   466                & + xyz_DWindSpeedDt(i,j,k) * ( 2.0_DP * DelTime )
   467              if ( WindSpeedTentative < 0.0_DP ) then
   468                xyz_DWindSpeedDt(i,j,k) = &
   469                  & ( 0.0_DP - xyz_WindSpeed(i,j,k) ) / ( 2.0_DP * DelTime )
   470                xyz_MomFlux(i,j,k-1) = &
   471                  &   (   2.0_DP * xyz_DelPress(i,j,k) / Grav                   &
   472                  &     - xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )        &
   473                  &   * xyz_DWindSpeedDt(i,j,k)                                 &
   474                  & + xyz_MomFlux(i,j,k+1)                                      &
   475                  & + xyz_DMomFluxDU(i,j,k+1) * xyz_DWindSpeedDt(i,j,k+1)       &
   476                  &       * ( 2.0_DP * DelTime )
   477              end if
   478            else
   479              ! below the reference level
   480              xyz_DWindSpeedDt(i,j,k) = 0.0_DP
   481              xyz_MomFlux(i,j,k-1) = &
   482                &   (   2.0_DP * xyz_DelPress(i,j,k) / Grav                   &
   483                &     - xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )        &
   484                &   * xyz_DWindSpeedDt(i,j,k)                                 &
   485                & + xyz_MomFlux(i,j,k+1)                                      &
   486                & + xyz_DMomFluxDU(i,j,k+1) * xyz_DWindSpeedDt(i,j,k+1)       &
   487                &       * ( 2.0_DP * DelTime )
   488            end if
   489  
   490          end do
   491          ! No deceleration is assumed in the lowest level
   492          k = 1
   493          xyz_DWindSpeedDt(i,j,k) = 0.0_DP
   494        end do
   495      end do
   496  
   497  
   498  
   499  !!$    ! No deceleration is assumed in the lowest level
   500  !!$    k = 1
   501  !!$    xyz_DWindSpeedDt(:,:,k) = 0.0_DP
   502  !!$    do k = 1+1, kmax-1
   503  !!$      do j = 1, jmax
   504  !!$        do i = 0, imax-1
   505  !!$          !
   506  !!$          ! calculation of wind velocity tendency
   507  !!$          !
   508  !!$          xyz_DWindSpeedDt(i,j,k) = &
   509  !!$            & Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   510  !!$            & * (   xyz_MomFlux(i,j,k-1) &
   511  !!$            &     + xyz_DMomFluxDU(i,j,k-1) * xyz_DWindSpeedDt(i,j,k-1) &
   512  !!$            &       * ( 2.0_DP * DelTime ) &
   513  !!$            &     - xyz_MomFlux(i,j,k+1) ) &
   514  !!$            & / ( 1.0_DP + Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   515  !!$            &              * xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )
   516  
   517  
   518  
   519  !!$          xyz_DWindSpeedDt(i,j,k) = 0.0_DP
   520  !!$
   521  !!$          do itr = 1, 10
   522  !!$
   523  !!$            xyz_WindSpeedTentative(i,j,k) = &
   524  !!$              & xyz_WindSpeed(i,j,k) + xyz_DWindSpeedDt(i,j,k) * ( 2.0_DP * DelTime )
   525  !!$
   526  !!$            if ( xyz_N(i,j,k) > 0.0_DP ) then
   527  !!$              xyz_DMomFluxDU(i,j,k) =                   &
   528  !!$                & - 3.0_DP * MomFluxFactor * CrtlFNumSq &
   529  !!$                &   * xyz_Rho(i,j,k) / xyz_N(i,j,k)     &
   530  !!$                &   * xyz_WindSpeedTentative(i,j,k)**2           &
   531  !!$                &   * xyz_ZeroOne(i,j,k)
   532  !!$            else
   533  !!$              xyz_DMomFluxDU(i,j,k) = 0.0_DP
   534  !!$            end if
   535  !!$
   536  !!$            xyz_DWindSpeedDt(i,j,k) = &
   537  !!$              & Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   538  !!$              & * (   xyz_MomFlux(i,j,k-1) &
   539  !!$              &     + xyz_DMomFluxDU(i,j,k-1) * xyz_DWindSpeedDt(i,j,k-1) &
   540  !!$              &       * ( 2.0_DP * DelTime ) &
   541  !!$              &     - xyz_MomFlux(i,j,k+1) ) &
   542  !!$              & / ( 1.0_DP + Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   543  !!$              &              * xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )
   544  !!$
   545  !!$          end do
   546  
   547  
   548  !!$          !
   549  !!$          ! preparation for next level
   550  !!$          !
   551  !!$          !   estimated momentum flux at k and next time step
   552  !!$          MomFluxTentative =                                    &
   553  !!$            &   xyz_MomFlux(i,j,k)                              &
   554  !!$            & + xyz_DMomFluxDU(i,j,k) * xyz_DWindSpeedDt(i,j,k) &
   555  !!$            &   * ( 2.0_DP * DelTime )
   556  !!$          xyz_MomFlux(i,j,k+1) = MomFluxTentative
   557  !!$          !   calculate momentum flux at k+1 in the case of saturation
   558  !!$          MomFluxSaturated = &
   559  !!$            & - MomFluxFactor * CrtlFNumSq &
   560  !!$            &   * xyz_Rho(i,j,k+1) / xyz_N(i,j,k+1) * xyz_WindSpeed(i,j,k+1)**3
   561  !!$          !   comparison of momentum flux
   562  !!$          !   check whether saturationed or not
   563  !!$          if ( abs( MomFluxSaturated ) < abs( xyz_MomFlux(i,j,k+1) ) ) then
   564  !!$            ! saturation region
   565  !!$            !   set saturated momentum flux
   566  !!$            xyz_MomFlux(i,j,k+1) = MomFluxSaturated
   567  !!$            !   derivative of momentum flux with reference level flow
   568  !!$            xyz_DMomFluxDU(i,j,k+1) =                 &
   569  !!$              & - 3.0_DP * MomFluxFactor * CrtlFNumSq &
   570  !!$              &   * xyz_Rho(i,j,k+1) / xyz_N(i,j,k+1) &
   571  !!$              &   * xyz_WindSpeed(i,j,k+1)**2
   572  !!$          else
   573  !!$            ! non-saturation region
   574  !!$            !   derivative of momentum flux with reference level flow
   575  !!$            xyz_DMomFluxDU(i,j,k+1) = 0.0_DP
   576  !!$          end if
   577  !!$        end do
   578  !!$      end do
   579  !!$    end do
   580  !!$    ! No deceleration is assumed in the highest level
   581  !!$    k = kmax
   582  !!$    xyz_DWindSpeedDt(:,:,k) = 0.0_DP
   583  
   584      do k = 1, kmax
   585        do j = 1, jmax
   586          do i = 0, imax-1
   587            if ( xy_AbsWindSpeedRef(i,j) /= 0.0_DP ) then
   588              xyz_DUDt(i,j,k) = &
   589                & xyz_DWindSpeedDt(i,j,k) * xy_URef(i,j) / xy_AbsWindSpeedRef(i,j)
   590              xyz_DVDt(i,j,k) = &
   591                & xyz_DWindSpeedDt(i,j,k) * xy_VRef(i,j) / xy_AbsWindSpeedRef(i,j)
   592            else
   593              xyz_DUDt(i,j,k) = 0.0_DP
   594              xyz_DVDt(i,j,k) = 0.0_DP
   595            end if
   596          end do
   597        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_uref,xy_vref,xy_abswindspeedref)                        
     .        do j = 1, jmax*imax                                               
     .           if (xy_abswindspeedref(j-1,1) .ne. 0.0000000000000000e+000)    
     .       1      then                                                        
     .              xyz_dudt3 = xyz_dwindspeeddt(j-1,1,k)*xy_uref(j-1,1)/       
     .       1         xy_abswindspeedref(j-1,1)                                
     .              xyz_dvdt4 = xyz_dwindspeeddt(j-1,1,k)*xy_vref(j-1,1)/       
     .       1         xy_abswindspeedref(j-1,1)                                
     .           else                                                           
     .              xyz_dudt3 = 0.0000000000000000e+000                         
     .              xyz_dvdt4 = 0.0000000000000000e+000                         
     .           endif                                                          
     .           xyz_dvdt(j-1,1,k) = xyz_dvdt4                                  
     .           xyz_dudt(j-1,1,k) = xyz_dudt3                                  
     .        enddo                                                             
   598      end do
   599  
   600  !!$    if ( FlagGWDDamp ) then
   601  !!$
   602  !!$      GWDDampCoef = 1.0_DP / DelTime * ( GWDDampPeriod - TimeN ) / GWDDampPeriod
   603  !!$
   604  !!$      if ( GWDDampCoef < 0.0_DP ) GWDDampCoef = 0.0_DP
   605  !!$
   606  !!$      xyz_DUDt = xyz_DUDt / ( 1.0_DP + 2.0_DP * DelTime * DivDampCoef )
   607  !!$
   608  !!$    end if
   609  
   610  
   611      ! estimated momentum flux at layer interface and at next time step
   612      do k = 0+1, kmax-1
   613        xyr_MomFluxA(:,:,k) =                                           &
   614          &   (   xyz_MomFlux(:,:,k)                                    &
   615          &     + xyz_MomFlux(:,:,k+1)                                  &
   616          &       + xyz_DMomFluxDU(:,:,k+1) * xyz_DWindSpeedDt(:,:,k+1) &
   617          &         * ( 2.0_DP * DelTime ) )                            &
   618          & / 2.0_DP
   619  !!$      xyr_MomFluxA(:,:,k) =                                         &
   620  !!$        &   (   xyz_MomFlux(:,:,k)                                  &
   621  !!$        &       + xyz_DMomFluxDU(:,:,k) * xyz_DWindSpeedDt(:,:,k)   &
   622  !!$        &         * ( 2.0_DP * DelTime )                            &
   623  !!$        &     + xyz_MomFlux(:,:,k+1)                              ) &
   624  !!$        & / 2.0_DP
   625      end do
     .        d5 = 1.D0/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 1)*xyz_momflux.DSC.U2*(xyz_momflux.DSC.U1 + 1)  
     .           xyr_momfluxa(k-1,1,1) = (xyz_momflux(k-1,1,1)+xyz_momflux(k-1,1
     .       1      ,2)+xyz_dmomfluxdu(k-1,1,2)*xyz_dwindspeeddt(k-1,1,2)*      
     .       2      2.00000000000000e+000*deltime)*d5                           
     .        enddo                                                             
   626      k = 0
   627      xyr_MomFluxA(:,:,k) = xyr_MomFluxA(:,:,k+1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1590 = 1, xyr_momfluxa.DSC.U2*xyr_momfluxa.DSC.U1 +           
     .       1   xyr_momfluxa.DSC.U2                                            
     .           xyr_momfluxa(t1590-1,1,0) = xyr_momfluxa(t1590-1,1,1)          
     .        enddo                                                             
   628      k = kmax
   629      xyr_MomFluxA(:,:,k) = xyr_MomFluxA(:,:,k-1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1598 = 1, xyr_momfluxa.DSC.U2*xyr_momfluxa.DSC.U1 +           
     .       1   xyr_momfluxa.DSC.U2                                            
     .           xyr_momfluxa(t1598-1,1,k) = xyr_momfluxa(t1598-1,1,k-1)        
     .        enddo                                                             
   630  
   631  
   632      do k = 0, kmax
   633        do j = 1, jmax
   634          do i = 0, imax-1
   635            if ( xy_AbsWindSpeedRef(i,j) /= 0.0_DP ) then
   636              xyr_MomFluxXA(i,j,k) = &
   637                & xyr_MomFluxA(i,j,k) * xy_URef(i,j) / xy_AbsWindSpeedRef(i,j)
   638              xyr_MomFluxYA(i,j,k) = &
   639                & xyr_MomFluxA(i,j,k) * xy_VRef(i,j) / xy_AbsWindSpeedRef(i,j)
   640            else
   641              xyr_MomFluxXA(i,j,k) = 0.0_DP
   642              xyr_MomFluxYA(i,j,k) = 0.0_DP
   643            end if
   644          end do
   645        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_uref,xy_vref,xy_abswindspeedref)                        
     .        do j = 1, jmax*imax                                               
     .           if (xy_abswindspeedref(j-1,1) .ne. 0.0000000000000000e+000)    
     .       1      then                                                        
     .              xyr_momfluxxa6 = xyr_momfluxa(j-1,1,k)*xy_uref(j-1,1)/      
     .       1         xy_abswindspeedref(j-1,1)                                
     .              xyr_momfluxya7 = xyr_momfluxa(j-1,1,k)*xy_vref(j-1,1)/      
     .       1         xy_abswindspeedref(j-1,1)                                
     .           else                                                           
     .              xyr_momfluxxa6 = 0.0000000000000000e+000                    
     .              xyr_momfluxya7 = 0.0000000000000000e+000                    
     .           endif                                                          
     .           xyr_momfluxya(j-1,1,k) = xyr_momfluxya7                        
     .           xyr_momfluxxa(j-1,1,k) = xyr_momfluxxa6                        
     .        enddo                                                             
   646      end do
   647  
   648  
   649  !!$    ! Set up of simultaneously linear equations
   650  !!$    do k = 1, kmax
   651  !!$      do j = 1, jmax
   652  !!$        do i = 0, imax-1
   653  !!$          az_A(i+imax*(j-1),k) =                    &
   654  !!$            &   Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   655  !!$            &   * xyz_DMomFluxDU(i,j,k-1)           &
   656  !!$            &   * ( 2.0_DP * DelTime )
   657  !!$          az_A(i+imax*(j-1),k) = - 1.0_DP
   658  !!$          az_C(i+imax*(j-1),k) =                    &
   659  !!$            & - Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   660  !!$            &   * xyz_DMomFluxDU(i,j,k+1)           &
   661  !!$            &   * ( 2.0_DP * DelTime )
   662  !!$          az_D(i+imax*(j-1),k) =                    &
   663  !!$            & - Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   664  !!$            &  * ( xyz_MomFlux(i,j,k-1) - xyz_MomFlux(i,j,k+1) )
   665  !!$        end do
   666  !!$      end do
   667  !!$    end do
   668  !!$
   669  !!$    mmax = imax*jmax
   670  !!$    ms = 1
   671  !!$    me = imax*jmax
   672  !!$    call tridiag( mmax, kmax, az_A, az_B, az_C, az_D, ms, me )
   673  !!$
   674  !!$    do k = 1, kmax
   675  !!$      do j = 1, jmax
   676  !!$        do i = 0, imax-1
   677  !!$          xyz_DUDt = az_D(i+imax*(j-1),k) * xy_URef(i,j) / xy_WindSpeedRef(i,j)
   678  !!$          xyz_DVDt = az_D(i+imax*(j-1),k) * xy_VRef(i,j) / xy_WindSpeedRef(i,j)
   679  !!$        end do
   680  !!$      end do
   681  !!$    end do
   682  
   683  
   684      ! ヒストリデータ出力
   685      ! History data output
   686      !
   687      call HistoryAutoPut( TimeN, 'GWMomFlux' , xyr_MomFluxA  )
   688      call HistoryAutoPut( TimeN, 'GWMomFluxX', xyr_MomFluxXA )
   689      call HistoryAutoPut( TimeN, 'GWMomFluxY', xyr_MomFluxYA )
   690      call HistoryAutoPut( TimeN, 'DUDtGWD'   , xyz_DUDt      )
   691      call HistoryAutoPut( TimeN, 'DVDtGWD'   , xyz_DVDt      )
   692      call HistoryAutoPut( TimeN, 'DWSDtGWD'  , xyz_DWindSpeedDt )
   693  
   694  
   695      ! 計算時間計測一時停止
   696      ! Pause measurement of computation time
   697      !
   698      call TimesetClockStop( module_name )
   699  
   700    end subroutine GWDM1987
   701  
   702    !--------------------------------------------------------------------------------------
   703  
   704    !******************************************************************************
   705    !      subroutine tridiag
   706    !      tidiagonal solver
   707    !******************************************************************************
   708    !     a(j), b(j), and c(j) are, respectively, the subdiagonal, diagonal,
   709    !     and superdiagonal entries in row j.
   710    !     a(1) and c(jmx) need not be initialized.
   711    !     The output is in f; a, b, and c are unchanged.
   712    !******************************************************************************
   713    !     jmx    : dimensions of all the following arrays
   714    !     a      : sub (lower) diagonal
   715    !     b      : center diagonal
   716    !     c      : super (upper) diagonal
   717    !     f      : right hand side
   718    !******************************************************************************
   719  
   720    subroutine tridiag( mm, jmx, a, b, c, f, ms, me )
   721  
   722      integer , intent(in   ) :: mm, jmx
   723      real(DP), intent(in   ) :: a( mm, jmx ),b( mm, jmx )
   724      real(DP), intent(in   ) :: c( mm, jmx )
   725      real(DP), intent(inout) :: f( mm, jmx )
   726      integer , intent(in   ) :: ms, me
   727  
   728  
   729      ! Local variables
   730      !
   731      real(DP) :: q( mm, jmx ), p
   732      integer  :: j, m
   733  
   734  
   735      ! Forward elimination sweep
   736      !
   737      do m = ms, me
   738        q( m, 1 ) = - c( m, 1 ) / b( m, 1 )
   739        f( m, 1 ) =   f( m, 1 ) / b( m, 1 )
   740      end do
   741  
   742      do j = 2, jmx
   743        do m = ms, me
   744          p         = 1.0d0 / ( b( m, j ) + a( m, j ) * q( m, j-1 ) )
   745          q( m, j ) = - c( m, j ) * p
   746          f( m, j ) = ( f( m, j ) - a( m, j ) * f( m, j-1 ) ) * p
   747        end do
     .  !cdir    nodep                                                          
     .        do m = 1, me + 1 - ms                                             
     .           p = 1.00000000000000e+000/(b(ms+m-1,j)+a(ms+m-1,j)*q(ms+m-1,j-1
     .       1      ))                                                          
     .           q(ms+m-1,j) = -c(ms+m-1,j)*p                                   
     .           f(ms+m-1,j) = (f(ms+m-1,j)-a(ms+m-1,j)*f(ms+m-1,j-1))*p        
     .        enddo                                                             
   748      end do
   749  
   750      ! Backward pass
   751      !
   752      do j = jmx - 1, 1, -1
   753        do m = ms, me
   754          f( m, j ) = f( m, j ) + q( m, j ) * f( m, j+1 )
   755        end do
   756      end do
   757  
   758    end subroutine tridiag
   759  
   760    !--------------------------------------------------------------------------------------
   761  
   762    subroutine GWDM1987Init
   763      !
   764      ! moist_conv_adjust モジュールの初期化を行います.
   765      ! NAMELIST#moist_conv_adjust_nml の読み込みはこの手続きで行われます.
   766      !
   767      ! "moist_conv_adjust" module is initialized.
   768      ! "NAMELIST#moist_conv_adjust_nml" is loaded in this procedure.
   769      !
   770  
   771      ! モジュール引用 ; USE statements
   772      !
   773  
   774      ! 日付および時刻の取り扱い
   775      ! Date and time handler
   776      !
   777      use dc_calendar, only: DCCalConvertByUnit
   778  
   779      ! NAMELIST ファイル入力に関するユーティリティ
   780      ! Utilities for NAMELIST file input
   781      !
   782      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   783  
   784      ! ファイル入出力補助
   785      ! File I/O support
   786      !
   787      use dc_iounit, only: FileOpen
   788  
   789      ! 文字列操作
   790      ! Character handling
   791      !
   792      use dc_string, only: StoA
   793  
   794      ! ヒストリデータ出力
   795      ! History data output
   796      !
   797      use gtool_historyauto, only: HistoryAutoAddVariable
   798  
   799      ! 座標データ設定
   800      ! Axes data settings
   801      !
   802      use axesset, only: &
   803        & AxnameX, &
   804        & AxnameY, &
   805        & AxnameZ, &
   806        & AxnameR, &
   807        & AxnameT
   808  
   809      ! 物理定数設定
   810      ! Physical constants settings
   811      !
   812      use constants, only : &
   813        RPlanet
   814                                ! $ a $ [m].
   815                                ! 惑星半径.
   816                                ! Radius of planet
   817  
   818  
   819      ! 宣言文 ; Declaration statements
   820      !
   821      implicit none
   822  
   823      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   824                                ! Unit number for NAMELIST file open
   825      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   826                                ! IOSTAT of NAMELIST read
   827  
   828  !!$    real(DP)         :: GWDDampPeriodValue
   829  !!$    character(TOKEN) :: GWDDampPeriodUnit
   830  
   831      integer:: k
   832  
   833  
   834      ! NAMELIST 変数群
   835      ! NAMELIST group name
   836      !
   837      namelist /gwd_m1987_nml/ &
   838        & FlagDetermineRefLevByStd, &
   839        & SigmaRef, &
   840        & CrtlFNumSq, &
   841        & Efficiency, &
   842        & OrogEffWaveLength !, &
   843  !!$      & FlagGWDDamp, GWDDampPeriodValue, GWDDampPeriodUnit
   844            ! デフォルト値については初期化手続 "moist_conv_adjust#CumAdjInit"
   845            ! のソースコードを参照のこと.
   846            !
   847            ! Refer to source codes in the initialization procedure
   848            ! "moist_conv_adjust#MoistConvAdjustInit" for the default values.
   849            !
   850  
   851      ! 実行文 ; Executable statement
   852      !
   853  
   854      if ( gwd_m1987_inited ) return
   855  
   856  
   857      ! デフォルト値の設定
   858      ! Default values settings
   859      !
   860      FlagDetermineRefLevByStd = .false.
   861  
   862      SigmaRef           = 1.0_DP   ! lowest model level
   863  
   864      CrtlFNumSq         = 0.5_DP   ! value used by McFarlane (1987)
   865      Efficiency         = 1.0_DP   ! arbitrary
   866  !!$    OrogEffWaveLength  = 2.0_DP * PI / ( 2.0_DP * 8.0e-6_DP / Efficiency )
   867                                    ! value used by McFarlane (1987)
   868      if ( imax /= 1 ) then
   869        OrogEffWaveLength  = 2.0_DP * PI * RPlanet / ( ( imax - 1 ) / 3.0_DP )
   870                                    ! wavelength of smallest resolved wave
   871      else
   872        OrogEffWaveLength  = 2.0_DP * PI / ( 2.0_DP * 8.0e-6_DP / Efficiency )
   873                                    ! value used by McFarlane (1987)
   874      end if
   875  
   876  !!$    FlagGWDDamp        = .false.
   877  !!$    GWDDampPeriodValue = 0.0_DP
   878  !!$    GWDDampPeriodUnit  = 'day'
   879  
   880  
   881      ! NAMELIST の読み込み
   882      ! NAMELIST is input
   883      !
   884      if ( trim(namelist_filename) /= '' ) then
   885        call FileOpen( unit_nml, &          ! (out)
   886          & namelist_filename, mode = 'r' ) ! (in)
   887  
   888        rewind( unit_nml )
   889        read( unit_nml,                     &  ! (in)
   890          & nml = gwd_m1987_nml,            &  ! (out)
   891          & iostat = iostat_nml )              ! (out)
   892        close( unit_nml )
   893  
   894        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   895      end if
   896  
   897  
   898      ! Calculate factor for momentum flux
   899      MomFluxFactor = Efficiency * 2.0_DP * PI / OrogEffWaveLength / 2.0_DP
   900  
   901      ! Check values
   902      !
   903      SigmaRef = max( min( SigmaRef, 1.0_DP ), 0.0_DP )
   904  
   905      ! Calculation of divergence damping period
   906      !
   907  !!$    GWDDampPeriod = DCCalConvertByUnit( GWDDampPeriodValue, GWDDampPeriodUnit, 'sec' )
   908  
   909      ! ヒストリデータ出力のためのへの変数登録
   910      ! Register of variables for history data output
   911      !
   912      call HistoryAutoAddVariable( 'GWMomFlux', &
   913        & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   914        & 'gravity wave momentum flux', 'kg m-1 s-2' )
   915      call HistoryAutoAddVariable( 'GWMomFluxX', &
   916        & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   917        & 'gravity wave zonal momentum flux', 'kg m-1 s-2' )
   918      call HistoryAutoAddVariable( 'GWMomFluxY', &
   919        & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   920        & 'gravity wave meridional momentum flux', 'kg m-1 s-2' )
   921      call HistoryAutoAddVariable( 'DUDtGWD', &
   922        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   923        & 'zonal wind tendency by gravity wave drag', 'm-1 s-2' )
   924      call HistoryAutoAddVariable( 'DVDtGWD', &
   925        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   926        & 'meridional wind tendency by gravity wave drag', 'm-1 s-2' )
   927      call HistoryAutoAddVariable( 'DWSDtGWD', &
   928        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   929        & 'wind speed tendency by gravity wave drag', 'm-1 s-2' )
   930  
   931  
   932      ! Initialization of modules used in this module
   933      !
   934  
   935  
   936      ! 印字 ; Print
   937      !
   938      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   939      call MessageNotify( 'M', module_name, '  FlagDetermineRefLevByStd = %b', l = (/ FlagDetermineRefLevByStd /) )
   940      call MessageNotify( 'M', module_name, '  SigmaRef            = %f', d = (/ SigmaRef /) )
   941      call MessageNotify( 'M', module_name, '  CrtlFNumSq          = %f', d = (/ CrtlFNumSq /) )
   942      call MessageNotify( 'M', module_name, '  Efficiency          = %f', d = (/ Efficiency /) )
   943      call MessageNotify( 'M', module_name, '  OrogEffWaveLength   = %f', d = (/ OrogEffWaveLength /) )
   944      call MessageNotify( 'M', module_name, '    MomFluxFactor     = %f', d = (/ MomFluxFactor /) )
   945      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   946  
   947      gwd_m1987_inited = .true.
   948  
   949    end subroutine GWDM1987Init
   950  
   951    !--------------------------------------------------------------------------------------
   952  
   953  end module gwd_m1987
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:48 2016
FILE NAME: gwd_m1987.f90
PROGRAM NAME: gwd_m1987
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Gravity wave drag by McFarlane (1987)
     2:             !
     3:             != Gravity wave drag by McFarlane (1987)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: gwd_m1987.f90,v 1.2 2015/03/11 04:54:29 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module gwd_m1987
    13:               !
    14:               != Gravity wave drag by McFarlane (1987)
    15:               !
    16:               != Gravity wave drag by McFarlane (1987)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! Calculate tendency by gravity wave drag
    21:               !
    22:               !== References
    23:               !
    24:               !  McFarlane, N. A., 
    25:               !    The effect of orographically excited gravity wave drag on the general
    26:               !    circulation of the lower stratosphere and troposphsere,
    27:               !    J. Atmos. Sci., 44, 1775-1800, 1987.
    28:               !
    29:               !== Procedures List
    30:               !
    31:               ! GWDM1987     :: Calculation of gravity wave drag tendency
    32:               ! GWDM1987Init :: Initialization
    33:               ! ------------ :: ------------
    34:               ! GWDM1987     :: Calculation of gravity wave drag tendency
    35:               ! GWDM1987Init :: Initialization
    36:               !
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#gwd_m1987_nml
    40:               !
    41:             
    42:               ! モジュール引用 ; USE statements
    43:               !
    44:             
    45:               ! 格子点設定
    46:               ! Grid points settings
    47:               !
    48:               use gridset, only: imax, & ! 経度格子点数. 
    49:                                          ! Number of grid points in longitude
    50:                 &                jmax, & ! 緯度格子点数. 
    51:                                          ! Number of grid points in latitude
    52:                 &                kmax    ! 鉛直層数. 
    53:                                          ! Number of vertical level
    54:             
    55:               ! 種別型パラメタ
    56:               ! Kind type parameter
    57:               !
    58:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    59:                 &                 STRING     ! 文字列.       Strings. 
    60:             
    61:               ! NAMELIST ファイル入力に関するユーティリティ
    62:               ! Utilities for NAMELIST file input
    63:               !
    64:               use namelist_util, only: MaxNmlArySize
    65:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    66:                                           ! Maximum size of arrays loaded from NAMELIST
    67:             
    68:               ! メッセージ出力
    69:               ! Message output
    70:               !
    71:               use dc_message, only: MessageNotify
    72:             
    73:               ! 物理・数学定数設定
    74:               ! Physical and mathematical constants settings
    75:               !
    76:               use constants0, only: &
    77:                 & PI                    ! $ \pi $.
    78:                                         ! 円周率. Circular constant
    79:             
    80:             
    81:               ! 宣言文 ; Declaration statements
    82:               !
    83:               implicit none
    84:               private
    85:             
    86:             !!$  logical , save :: FlagUse
    87:             !!$                              ! 使用フラグ
    88:             !!$                              ! flag for use of this scheme
    89:             
    90:               logical , save :: FlagDetermineRefLevByStd
    91:               real(DP), save :: SigmaRef
    92:                                           ! Sigma at reference level
    93:               real(DP), save :: Efficiency
    94:                                           ! "Efficiency"
    95:               real(DP), save :: OrogEffWaveLength
    96:                                           ! Orography effective wave length
    97:               real(DP), save :: CrtlFNumSq
    98:                                           ! Critical Froude number squared
    99:               real(DP), save :: MomFluxFactor
   100:                                           ! Factor for momentum flux
   101:             
   102:             !!$  logical, save  :: FlagGWDDamp
   103:             !!$  real(DP), save :: GWDDampPeriod
   104:             
   105:               ! 公開手続き
   106:               ! Public procedure
   107:               !
   108:               public :: GWDM1987
   109:               public :: GWDM1987Init
   110:             
   111:               ! 公開変数
   112:               ! Public variables
   113:               !
   114:             
   115:               ! 非公開変数
   116:               ! Private variables
   117:               !
   118:               logical, save :: gwd_m1987_inited = .false.
   119:                                           ! 初期設定フラグ. 
   120:                                           ! Initialization flag
   121:             
   122:               character(*), parameter:: module_name = 'gwd_m1987'
   123:                                           ! モジュールの名称. 
   124:                                           ! Module name
   125:               character(*), parameter:: version = &
   126:                 & '$Name:  $' // &
   127:                 & '$Id: gwd_m1987.f90,v 1.2 2015/03/11 04:54:29 yot Exp $'
   128:                                           ! モジュールのバージョン
   129:                                           ! Module version
   130:             
   131:             contains
   132:             
   133:               subroutine GWDM1987(                                 &
   134:                 & xyz_U, xyz_V, xyz_Temp,                          & ! (in)
   135:                 & xyz_Press, xyr_Press, xyz_Exner, xyz_Height,     & ! (in)
   136:                 & xy_SurfHeight, xy_SurfHeightStd,                 & ! (in)
   137:                 & xyz_DUDt, xyz_DVDt                               & ! (out)
   138:                 & )
   139:                 !
   140:                 ! 
   141:                 !
   142:                 ! Tendency of gravity wave drag based on McFarlane (1987)
   143:                 !
   144:             
   145:                 ! モジュール引用 ; USE statements
   146:                 !
   147:             
   148:                 ! 物理定数設定
   149:                 ! Physical constants settings
   150:                 !
   151:                 use constants, only: &
   152:                   & Grav, & 
   153:                                           ! $ g $ [m s-2]. 
   154:                                           ! 重力加速度. 
   155:                                           ! Gravitational acceleration
   156:                   & GasRDry
   157:                                           ! $ R $ [J kg-1 K-1]. 
   158:                                           ! 乾燥大気の気体定数. 
   159:                                           ! Gas constant of air
   160:             
   161:                 ! 時刻管理
   162:                 ! Time control
   163:                 !
   164:                 use timeset, only: &
   165:                   & DelTime, &            ! $ \Delta t $
   166:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   167:                   & TimesetClockStart, TimesetClockStop
   168:             
   169:                 ! ヒストリデータ出力
   170:                 ! History data output
   171:                 !
   172:                 use gtool_historyauto, only: HistoryAutoPut
   173:             
   174:             
   175:                 ! 宣言文 ; Declaration statements
   176:                 !
   177:             
   178:                 real(DP), intent(in ) :: xyz_U       (0:imax-1, 1:jmax, 1:kmax)
   179:                                           ! Zonal wind
   180:                 real(DP), intent(in ) :: xyz_V       (0:imax-1, 1:jmax, 1:kmax)
   181:                                           ! Meridional wind
   182:                 real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   183:                                           ! Temperature
   184:                 real(DP), intent(in ) :: xyz_Press   (0:imax-1, 1:jmax, 1:kmax)
   185:                                           ! Pressure
   186:                 real(DP), intent(in ) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
   187:                                           ! Pressure
   188:                 real(DP), intent(in ) :: xyz_Exner   (0:imax-1, 1:jmax, 1:kmax)
   189:                                           ! Exner function
   190:                 real(DP), intent(in ) :: xyz_Height   (0:imax-1, 1:jmax, 1:kmax)
   191:                                           ! Height
   192:                 real(DP), intent(in ) :: xy_SurfHeight   (0:imax-1, 1:jmax)
   193:                 real(DP), intent(in ) :: xy_SurfHeightStd(0:imax-1, 1:jmax)
   194:                 real(DP), intent(out) :: xyz_DUDt    (0:imax-1, 1:jmax, 1:kmax)
   195:                                           ! 東西風変化率. 
   196:                                           ! Zonal wind tendency
   197:                 real(DP), intent(out) :: xyz_DVDt    (0:imax-1, 1:jmax, 1:kmax)
   198:                                           ! 南北風変化率. 
   199:                                           ! Meridional wind tendency
   200:             
   201:             
   202:                 ! 作業変数
   203:                 ! Work variables
   204:                 !
   205:                 real(DP) :: xy_OrogEffHeight(0:imax-1, 1:jmax)
   206:             
   207:                 real(DP) :: xyz_DelPress   (0:imax-1, 1:jmax, 1:kmax)
   208:             
   209:                 integer  :: xy_KIndexRef   (0:imax-1, 1:jmax)
   210:                 real(DP) :: xy_URef        (0:imax-1, 1:jmax)
   211:                 real(DP) :: xy_VRef        (0:imax-1, 1:jmax)
   212:                 real(DP) :: xyz_WindSpeed  (0:imax-1, 1:jmax, 1:kmax)
   213:             
   214:                 real(DP) :: xy_AbsWindSpeedRef(0:imax-1, 1:jmax)
   215:                 real(DP) :: xy_RhoRef         (0:imax-1, 1:jmax)
   216:                 real(DP) :: xy_NRef           (0:imax-1, 1:jmax)
   217:             
   218:                 real(DP) :: xyz_Rho       (0:imax-1, 1:jmax, 1:kmax)
   219:                 real(DP) :: xyz_PotTemp   (0:imax-1, 1:jmax, 1:kmax)
   220:                 real(DP) :: xyz_N         (0:imax-1, 1:jmax, 1:kmax)
   221:                 real(DP) :: xyz_Amp       (0:imax-1, 1:jmax, 1:kmax)
   222:                 real(DP) :: xyz_ZeroOne   (0:imax-1, 1:jmax, 1:kmax)
   223:                 real(DP) :: xy_MomFluxRef (0:imax-1, 1:jmax)
   224:                 real(DP) :: xyz_MomFlux   (0:imax-1, 1:jmax, 1:kmax)
   225:                 real(DP) :: MomFluxSaturated
   226:                 real(DP) :: xyz_DMomFluxDU(0:imax-1, 1:jmax, 1:kmax)
   227:             
   228:                 real(DP) :: xyz_DWindSpeedDt(0:imax-1, 1:jmax, 1:kmax)
   229:                 real(DP) :: xyr_MomFluxA (0:imax-1, 1:jmax, 0:kmax)
   230:                 real(DP) :: xyr_MomFluxXA(0:imax-1, 1:jmax, 0:kmax)
   231:                 real(DP) :: xyr_MomFluxYA(0:imax-1, 1:jmax, 0:kmax)
   232:             
   233:                 real(DP) :: WindSpeedTentative
   234:             
   235:             !!$    real(DP) :: MomFluxTentative
   236:             
   237:             
   238:                 integer :: mmax
   239:                 integer :: ms
   240:                 integer :: me
   241:                 real(DP) :: az_A(0:imax*jmax-1, 1:kmax)
   242:                 real(DP) :: az_B(0:imax*jmax-1, 1:kmax)
   243:                 real(DP) :: az_C(0:imax*jmax-1, 1:kmax)
   244:                 real(DP) :: az_D(0:imax*jmax-1, 1:kmax)
   245:             
   246:             
   247:             
   248:                 integer :: i               ! 経度方向に回る DO ループ用作業変数
   249:                                            ! Work variables for DO loop in longitude
   250:                 integer :: j               ! 緯度方向に回る DO ループ用作業変数
   251:                                            ! Work variables for DO loop in latitude
   252:                 integer :: k               ! 鉛直方向に回る DO ループ用作業変数
   253:                                            ! Work variables for DO loop in vertical direction
   254:                 integer :: kp
   255:                 integer :: kn
   256:             
   257:             !!$    real(DP) :: xyz_WindSpeedTentative(0:imax-1, 1:jmax, 1:kmax)
   258:             !!$    integer :: itr
   259:             
   260:             
   261:                 ! 実行文 ; Executable statement
   262:                 !
   263:             
   264:                 ! 初期化確認
   265:                 ! Initialization check
   266:                 !
   267:                 if ( .not. gwd_m1987_inited ) then
   268:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   269:                 end if
   270:             
   271:                 ! 計算時間計測開始
   272:                 ! Start measurement of computation time
   273:                 !
   274:                 call TimesetClockStart( module_name )
   275:             
   276:             
   277:                 ! Calculation of additional variables
   278:                 !
   279: W*===== A       xy_OrogEffHeight = 2.0_DP * xy_SurfHeightStd
   280:                 !
   281: W------>        do k = 1, kmax
   282: |**==== A         xyz_DelPress(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
   283: W------         end do
   284:                 !
   285:                 !   Determine reference level
   286:                 !
   287:                 if ( FlagDetermineRefLevByStd ) then
   288: W*=====           xy_KIndexRef = 2
   289: +------>          do k = 1+1, kmax
   290: |W----->            do j = 1, jmax
   291: ||*---->              do i = 0, imax-1
   292: |||     A               if ( ( xyz_Height(i,j,k) - xy_SurfHeight(i,j) ) < xy_OrogEffHeight(i,j) ) then
   293: |||     A                 xy_KIndexRef(i,j) = k
   294: |||                     end if
   295: ||*----               end do
   296: |W-----             end do
   297: +------           end do
   298:                 else
   299: W*=====           xy_KIndexRef = 2
   300: +------>          do k = 1+1, kmax
   301: |W----->            do j = 1, jmax
   302: ||*---->              do i = 0, imax-1
   303: |||     A               if ( xyz_Press(i,j,k) / xyr_Press(i,j,0) > SigmaRef ) then
   304: |||     A                 xy_KIndexRef(i,j) = k
   305: |||                     end if
   306: ||*----               end do
   307: |W-----             end do
   308: +------           end do
   309:                 end if
   310:             
   311:                 !
   312:                 !   Set reference level wind velocity
   313:                 !
   314: +------>        do j = 1, jmax
   315: |+----->          do i = 0, imax-1
   316: ||*W--->A           xy_URef = xyz_U(i,j,xy_KIndexRef(i,j))
   317: ||*W--- A           xy_VRef = xyz_V(i,j,xy_KIndexRef(i,j))
   318: |+-----           end do
   319: +------         end do
   320: W*===== A       xy_AbsWindSpeedRef = sqrt( xy_URef**2 + xy_VRef**2 )
   321:             
   322:                 ! Calculation of additional variables
   323:                 !
   324: W**==== A       xyz_Rho = xyz_Press / ( GasRDry * xyz_Temp )
   325: +------>        do j = 1, jmax
   326: |+----->          do i = 0, imax-1
   327: ||W*=== A           xy_RhoRef = xyz_Rho(i,j,xy_KIndexRef(i,j))
   328: |+-----           end do
   329: +------         end do
   330:                 !
   331: W**==== A       xyz_PotTemp = xyz_Temp / xyz_Exner
   332:                 !
   333: +------>        do k = 1, kmax
   334: |                 kp = max( k - 1, 1    )
   335: |                 kn = min( k + 1, kmax )
   336: |W*==== A         xyz_N(:,:,k) =                                      &
   337: |                   & Grav / xyz_PotTemp(:,:,k)                       &
   338: |                   & * ( xyz_PotTemp(:,:,kn) - xyz_PotTemp(:,:,kp) ) &
   339: |                   & / ( xyz_Height (:,:,kn) - xyz_Height (:,:,kp) )
   340: +------         end do
   341:             !!$    xyz_N = max( xyz_N, 1.0e-6_DP )
   342: **W---->        xyz_N = max( xyz_N, 0.0_DP )
   343: **W----         xyz_N = sqrt( xyz_N )
   344: +------>        do j = 1, jmax
   345: |+----->          do i = 0, imax-1
   346: ||W*=== A           xy_NRef = xyz_N(i,j,xy_KIndexRef(i,j))
   347: |+-----           end do
   348: +------         end do
   349:                 !
   350: +------>        do k = 1, kmax
   351: |W----->          do j = 1, jmax
   352: ||*---->            do i = 0, imax-1
   353: |||     A             if ( xy_AbsWindSpeedRef(i,j) /= 0.0_DP ) then
   354: |||     A               xyz_WindSpeed(i,j,k) = &
   355: |||                       & ( xyz_U(i,j,k) * xy_URef(i,j) + xyz_V(i,j,k) * xy_VRef(i,j) ) &
   356: |||                       & / xy_AbsWindSpeedRef(i,j)
   357: |||                   else
   358: |||                     xyz_WindSpeed(i,j,k) = 0.0_DP
   359: |||                   end if
   360: ||*----             end do
   361: |W-----           end do
   362: +------         end do
   363:                 ! Negative wind speed is inrelevant in the current formulation.
   364: W**====         xyz_WindSpeed = max( xyz_WindSpeed, 0.0_DP )
   365:             
   366:             
   367:                 ! Wave amplitude
   368:                 !
   369:                 ! Momentum flux parallel to the reference level flow at reference level
   370:                 !
   371: W*===== A       xy_MomFluxRef = - MomFluxFactor * xy_OrogEffHeight**2 &
   372:                   & * xy_RhoRef * xy_NRef * xy_AbsWindSpeedRef
   373:             
   374:                 !
   375:                 ! Momentum flux parallel to the reference level flow
   376:                 !
   377: +------>        do j = 1, jmax
   378: |+----->          do i = 0, imax-1
   379: ||                  ! Region at and below the reference level
   380: ||V---->            do k = 1, xy_KIndexRef(i,j)
   381: |||     A             xyz_MomFlux(i,j,k) = xy_MomFluxRef(i,j)
   382: |||     A             xyz_ZeroOne(i,j,k) = 0.0_DP
   383: ||V----             end do
   384: ||                  ! Region above the reference level and below the highest model level
   385: ||+---->            do k = xy_KIndexRef(i,j)+1, kmax-1
   386: |||                   ! momentum flux is same as that in lower level tentatively
   387: |||                   xyz_MomFlux(i,j,k) = xyz_MomFlux(i,j,k-1)
   388: |||                   ! calculate momentum flux in the case of saturation
   389: |||                   if ( xyz_N(i,j,k) > 0.0_DP ) then
   390: |||                     MomFluxSaturated = &
   391: |||                       & - MomFluxFactor * CrtlFNumSq &
   392: |||                       &   * xyz_Rho(i,j,k) / xyz_N(i,j,k) * xyz_WindSpeed(i,j,k)**3
   393: |||                   else
   394: |||                     MomFluxSaturated = 0.0_DP
   395: |||                   end if
   396: |||                   ! comparison of momentum flux
   397: |||                   ! check whether saturationed or not
   398: |||                   ! It should be noted that momentum flux here is negative, since 
   399: |||                   ! a direction of the momentum flux is parallel to reference level 
   400: |||                   ! flow.
   401: |||                   if ( MomFluxSaturated > xyz_MomFlux(i,j,k) ) then
   402: |||                     ! saturation region
   403: |||                     xyz_MomFlux(i,j,k) = MomFluxSaturated
   404: |||                     xyz_ZeroOne(i,j,k) = 1.0_DP
   405: |||                   else
   406: |||                     ! non-saturation region
   407: |||                     xyz_ZeroOne(i,j,k) = 0.0_DP
   408: |||                   end if
   409: ||+----             end do
   410: ||                  ! highest model level
   411: ||*---->            do k = kmax, kmax
   412: |||                   ! momentum flux is same as that in lower level
   413: |||                   xyz_MomFlux(i,j,k) = xyz_MomFlux(i,j,k-1)
   414: |||                   xyz_ZeroOne(i,j,k) = 0.0_DP
   415: ||*----             end do
   416: |+-----           end do
   417: +------         end do
   418:                 !
   419:                 ! Momentum flux derivative with reference level flow
   420:                 !
   421:             !!$    xyz_DMomFluxDU =                                            &
   422:             !!$      & - 3.0_DP * MomFluxFactor * CrtlFNumSq * xyz_Rho / xyz_N &
   423:             !!$      &   * xyz_WindSpeed**2                                    &
   424:             !!$      &   * xyz_ZeroOne
   425: W------>        do k = 1, kmax
   426: |*----->          do j = 1, jmax
   427: ||*---->            do i = 0, imax-1
   428: |||                   if ( xyz_N(i,j,k) > 0.0_DP ) then
   429: |||                     xyz_DMomFluxDU(i,j,k) =                   &
   430: |||                       & - 3.0_DP * MomFluxFactor * CrtlFNumSq &
   431: |||                       &   * xyz_Rho(i,j,k) / xyz_N(i,j,k)     &
   432: |||                       &   * xyz_WindSpeed(i,j,k)**2           &
   433: |||                       &   * xyz_ZeroOne(i,j,k)
   434: |||                   else
   435: |||                     xyz_DMomFluxDU(i,j,k) = 0.0_DP
   436: |||                   end if
   437: ||*----             end do
   438: |*-----           end do
   439: W------         end do
   440:             
   441:             
   442:                 !
   443:                 ! calculation of wind velocity tendency
   444:                 !
   445: +------>        do j = 1, jmax
   446: |+----->          do i = 0, imax-1
   447: ||                  ! No deceleration is assumed in the highest level
   448: ||                  k = kmax
   449: ||                  xyz_DWindSpeedDt(i,j,k) = 0.0_DP
   450: ||+---->            do k = kmax-1, 1+1, -1
   451: |||                   xyz_DWindSpeedDt(i,j,k) = &
   452: |||                     & Grav / xyz_DelPress(i,j,k) / 2.0_DP                         &
   453: |||                     & * (   xyz_MomFlux(i,j,k-1)                                  &
   454: |||                     &     - xyz_MomFlux(i,j,k+1)                                  &
   455: |||                     &     - xyz_DMomFluxDU(i,j,k+1) * xyz_DWindSpeedDt(i,j,k+1)   &
   456: |||                     &       * ( 2.0_DP * DelTime )                              ) &
   457: |||                     & / ( 1.0_DP - Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   458: |||                     &              * xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )
   459: |||         
   460: |||                   ! Wind speed tendency at k level and momentum flux at k-1 level 
   461: |||                   ! are estimated again.
   462: |||                   if ( k >= xy_KIndexRef(i,j) ) then
   463: |||                     ! Region above reference level
   464: |||                     WindSpeedTentative =       &
   465: |||                       &   xyz_WindSpeed(i,j,k) &
   466: |||                       & + xyz_DWindSpeedDt(i,j,k) * ( 2.0_DP * DelTime )
   467: |||                     if ( WindSpeedTentative < 0.0_DP ) then
   468: |||                       xyz_DWindSpeedDt(i,j,k) = &
   469: |||                         & ( 0.0_DP - xyz_WindSpeed(i,j,k) ) / ( 2.0_DP * DelTime )
   470: |||                       xyz_MomFlux(i,j,k-1) = &
   471: |||                         &   (   2.0_DP * xyz_DelPress(i,j,k) / Grav                   &
   472: |||                         &     - xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )        &
   473: |||                         &   * xyz_DWindSpeedDt(i,j,k)                                 &
   474: |||                         & + xyz_MomFlux(i,j,k+1)                                      &
   475: |||                         & + xyz_DMomFluxDU(i,j,k+1) * xyz_DWindSpeedDt(i,j,k+1)       &
   476: |||                         &       * ( 2.0_DP * DelTime )
   477: |||                     end if
   478: |||                   else
   479: |||                     ! below the reference level
   480: |||                     xyz_DWindSpeedDt(i,j,k) = 0.0_DP
   481: |||                     xyz_MomFlux(i,j,k-1) = &
   482: |||                       &   (   2.0_DP * xyz_DelPress(i,j,k) / Grav                   &
   483: |||                       &     - xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )        &
   484: |||                       &   * xyz_DWindSpeedDt(i,j,k)                                 &
   485: |||                       & + xyz_MomFlux(i,j,k+1)                                      &
   486: |||                       & + xyz_DMomFluxDU(i,j,k+1) * xyz_DWindSpeedDt(i,j,k+1)       &
   487: |||                       &       * ( 2.0_DP * DelTime )
   488: |||                   end if
   489: |||         
   490: ||+----             end do
   491: ||                  ! No deceleration is assumed in the lowest level
   492: ||                  k = 1
   493: ||                  xyz_DWindSpeedDt(i,j,k) = 0.0_DP
   494: |+-----           end do
   495: +------         end do
   496:             
   497:             
   498:             
   499:             !!$    ! No deceleration is assumed in the lowest level
   500:             !!$    k = 1
   501:             !!$    xyz_DWindSpeedDt(:,:,k) = 0.0_DP
   502:             !!$    do k = 1+1, kmax-1
   503:             !!$      do j = 1, jmax
   504:             !!$        do i = 0, imax-1
   505:             !!$          !
   506:             !!$          ! calculation of wind velocity tendency
   507:             !!$          !
   508:             !!$          xyz_DWindSpeedDt(i,j,k) = &
   509:             !!$            & Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   510:             !!$            & * (   xyz_MomFlux(i,j,k-1) &
   511:             !!$            &     + xyz_DMomFluxDU(i,j,k-1) * xyz_DWindSpeedDt(i,j,k-1) &
   512:             !!$            &       * ( 2.0_DP * DelTime ) &
   513:             !!$            &     - xyz_MomFlux(i,j,k+1) ) &
   514:             !!$            & / ( 1.0_DP + Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   515:             !!$            &              * xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )
   516:             
   517:             
   518:             
   519:             !!$          xyz_DWindSpeedDt(i,j,k) = 0.0_DP
   520:             !!$
   521:             !!$          do itr = 1, 10
   522:             !!$
   523:             !!$            xyz_WindSpeedTentative(i,j,k) = &
   524:             !!$              & xyz_WindSpeed(i,j,k) + xyz_DWindSpeedDt(i,j,k) * ( 2.0_DP * DelTime )
   525:             !!$
   526:             !!$            if ( xyz_N(i,j,k) > 0.0_DP ) then
   527:             !!$              xyz_DMomFluxDU(i,j,k) =                   &
   528:             !!$                & - 3.0_DP * MomFluxFactor * CrtlFNumSq &
   529:             !!$                &   * xyz_Rho(i,j,k) / xyz_N(i,j,k)     &
   530:             !!$                &   * xyz_WindSpeedTentative(i,j,k)**2           &
   531:             !!$                &   * xyz_ZeroOne(i,j,k)
   532:             !!$            else
   533:             !!$              xyz_DMomFluxDU(i,j,k) = 0.0_DP
   534:             !!$            end if
   535:             !!$
   536:             !!$            xyz_DWindSpeedDt(i,j,k) = &
   537:             !!$              & Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   538:             !!$              & * (   xyz_MomFlux(i,j,k-1) &
   539:             !!$              &     + xyz_DMomFluxDU(i,j,k-1) * xyz_DWindSpeedDt(i,j,k-1) &
   540:             !!$              &       * ( 2.0_DP * DelTime ) &
   541:             !!$              &     - xyz_MomFlux(i,j,k+1) ) &
   542:             !!$              & / ( 1.0_DP + Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   543:             !!$              &              * xyz_DMomFluxDU(i,j,k) * ( 2.0_DP * DelTime ) )
   544:             !!$
   545:             !!$          end do
   546:             
   547:             
   548:             !!$          !
   549:             !!$          ! preparation for next level
   550:             !!$          !
   551:             !!$          !   estimated momentum flux at k and next time step
   552:             !!$          MomFluxTentative =                                    &
   553:             !!$            &   xyz_MomFlux(i,j,k)                              &
   554:             !!$            & + xyz_DMomFluxDU(i,j,k) * xyz_DWindSpeedDt(i,j,k) &
   555:             !!$            &   * ( 2.0_DP * DelTime )
   556:             !!$          xyz_MomFlux(i,j,k+1) = MomFluxTentative
   557:             !!$          !   calculate momentum flux at k+1 in the case of saturation
   558:             !!$          MomFluxSaturated = &
   559:             !!$            & - MomFluxFactor * CrtlFNumSq &
   560:             !!$            &   * xyz_Rho(i,j,k+1) / xyz_N(i,j,k+1) * xyz_WindSpeed(i,j,k+1)**3
   561:             !!$          !   comparison of momentum flux
   562:             !!$          !   check whether saturationed or not
   563:             !!$          if ( abs( MomFluxSaturated ) < abs( xyz_MomFlux(i,j,k+1) ) ) then
   564:             !!$            ! saturation region
   565:             !!$            !   set saturated momentum flux
   566:             !!$            xyz_MomFlux(i,j,k+1) = MomFluxSaturated
   567:             !!$            !   derivative of momentum flux with reference level flow
   568:             !!$            xyz_DMomFluxDU(i,j,k+1) =                 &
   569:             !!$              & - 3.0_DP * MomFluxFactor * CrtlFNumSq &
   570:             !!$              &   * xyz_Rho(i,j,k+1) / xyz_N(i,j,k+1) &
   571:             !!$              &   * xyz_WindSpeed(i,j,k+1)**2
   572:             !!$          else
   573:             !!$            ! non-saturation region
   574:             !!$            !   derivative of momentum flux with reference level flow
   575:             !!$            xyz_DMomFluxDU(i,j,k+1) = 0.0_DP
   576:             !!$          end if
   577:             !!$        end do
   578:             !!$      end do
   579:             !!$    end do
   580:             !!$    ! No deceleration is assumed in the highest level
   581:             !!$    k = kmax
   582:             !!$    xyz_DWindSpeedDt(:,:,k) = 0.0_DP
   583:             
   584: +------>        do k = 1, kmax
   585: |W----->          do j = 1, jmax
   586: ||*---->            do i = 0, imax-1
   587: |||     A             if ( xy_AbsWindSpeedRef(i,j) /= 0.0_DP ) then
   588: |||     A               xyz_DUDt(i,j,k) = &
   589: |||                       & xyz_DWindSpeedDt(i,j,k) * xy_URef(i,j) / xy_AbsWindSpeedRef(i,j)
   590: |||     A               xyz_DVDt(i,j,k) = &
   591: |||                       & xyz_DWindSpeedDt(i,j,k) * xy_VRef(i,j) / xy_AbsWindSpeedRef(i,j)
   592: |||                   else
   593: |||                     xyz_DUDt(i,j,k) = 0.0_DP
   594: |||                     xyz_DVDt(i,j,k) = 0.0_DP
   595: |||                   end if
   596: ||*---- A           end do
   597: |W-----           end do
   598: +------         end do
   599:             
   600:             !!$    if ( FlagGWDDamp ) then
   601:             !!$
   602:             !!$      GWDDampCoef = 1.0_DP / DelTime * ( GWDDampPeriod - TimeN ) / GWDDampPeriod
   603:             !!$
   604:             !!$      if ( GWDDampCoef < 0.0_DP ) GWDDampCoef = 0.0_DP
   605:             !!$
   606:             !!$      xyz_DUDt = xyz_DUDt / ( 1.0_DP + 2.0_DP * DelTime * DivDampCoef )
   607:             !!$
   608:             !!$    end if
   609:             
   610:             
   611:                 ! estimated momentum flux at layer interface and at next time step
   612: W------>        do k = 0+1, kmax-1
   613: |**==== A         xyr_MomFluxA(:,:,k) =                                           &
   614: |                   &   (   xyz_MomFlux(:,:,k)                                    &
   615: |                   &     + xyz_MomFlux(:,:,k+1)                                  &
   616: |                   &       + xyz_DMomFluxDU(:,:,k+1) * xyz_DWindSpeedDt(:,:,k+1) &
   617: |                   &         * ( 2.0_DP * DelTime ) )                            &
   618: |                   & / 2.0_DP
   619: |           !!$      xyr_MomFluxA(:,:,k) =                                         &
   620: |           !!$        &   (   xyz_MomFlux(:,:,k)                                  &
   621: |           !!$        &       + xyz_DMomFluxDU(:,:,k) * xyz_DWindSpeedDt(:,:,k)   &
   622: |           !!$        &         * ( 2.0_DP * DelTime )                            &
   623: |           !!$        &     + xyz_MomFlux(:,:,k+1)                              ) &
   624: |           !!$        & / 2.0_DP
   625: W------         end do
   626:                 k = 0
   627: W*===== A       xyr_MomFluxA(:,:,k) = xyr_MomFluxA(:,:,k+1)
   628:                 k = kmax
   629: W*===== A       xyr_MomFluxA(:,:,k) = xyr_MomFluxA(:,:,k-1)
   630:             
   631:             
   632: +------>        do k = 0, kmax
   633: |W----->          do j = 1, jmax
   634: ||*---->            do i = 0, imax-1
   635: |||     A             if ( xy_AbsWindSpeedRef(i,j) /= 0.0_DP ) then
   636: |||     A               xyr_MomFluxXA(i,j,k) = &
   637: |||                       & xyr_MomFluxA(i,j,k) * xy_URef(i,j) / xy_AbsWindSpeedRef(i,j)
   638: |||     A               xyr_MomFluxYA(i,j,k) = &
   639: |||                       & xyr_MomFluxA(i,j,k) * xy_VRef(i,j) / xy_AbsWindSpeedRef(i,j)
   640: |||                   else
   641: |||                     xyr_MomFluxXA(i,j,k) = 0.0_DP
   642: |||                     xyr_MomFluxYA(i,j,k) = 0.0_DP
   643: |||                   end if
   644: ||*---- A           end do
   645: |W-----           end do
   646: +------         end do
   647:             
   648:             
   649:             !!$    ! Set up of simultaneously linear equations
   650:             !!$    do k = 1, kmax
   651:             !!$      do j = 1, jmax
   652:             !!$        do i = 0, imax-1
   653:             !!$          az_A(i+imax*(j-1),k) =                    &
   654:             !!$            &   Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   655:             !!$            &   * xyz_DMomFluxDU(i,j,k-1)           &
   656:             !!$            &   * ( 2.0_DP * DelTime )
   657:             !!$          az_A(i+imax*(j-1),k) = - 1.0_DP
   658:             !!$          az_C(i+imax*(j-1),k) =                    &
   659:             !!$            & - Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   660:             !!$            &   * xyz_DMomFluxDU(i,j,k+1)           &
   661:             !!$            &   * ( 2.0_DP * DelTime )
   662:             !!$          az_D(i+imax*(j-1),k) =                    &
   663:             !!$            & - Grav / xyz_DelPress(i,j,k) / 2.0_DP &
   664:             !!$            &  * ( xyz_MomFlux(i,j,k-1) - xyz_MomFlux(i,j,k+1) )
   665:             !!$        end do
   666:             !!$      end do
   667:             !!$    end do
   668:             !!$
   669:             !!$    mmax = imax*jmax
   670:             !!$    ms = 1
   671:             !!$    me = imax*jmax
   672:             !!$    call tridiag( mmax, kmax, az_A, az_B, az_C, az_D, ms, me )
   673:             !!$
   674:             !!$    do k = 1, kmax
   675:             !!$      do j = 1, jmax
   676:             !!$        do i = 0, imax-1
   677:             !!$          xyz_DUDt = az_D(i+imax*(j-1),k) * xy_URef(i,j) / xy_WindSpeedRef(i,j)
   678:             !!$          xyz_DVDt = az_D(i+imax*(j-1),k) * xy_VRef(i,j) / xy_WindSpeedRef(i,j)
   679:             !!$        end do
   680:             !!$      end do
   681:             !!$    end do
   682:             
   683:             
   684:                 ! ヒストリデータ出力
   685:                 ! History data output
   686:                 !
   687:                 call HistoryAutoPut( TimeN, 'GWMomFlux' , xyr_MomFluxA  )
   688:                 call HistoryAutoPut( TimeN, 'GWMomFluxX', xyr_MomFluxXA )
   689:                 call HistoryAutoPut( TimeN, 'GWMomFluxY', xyr_MomFluxYA )
   690:                 call HistoryAutoPut( TimeN, 'DUDtGWD'   , xyz_DUDt      )
   691:                 call HistoryAutoPut( TimeN, 'DVDtGWD'   , xyz_DVDt      )
   692:                 call HistoryAutoPut( TimeN, 'DWSDtGWD'  , xyz_DWindSpeedDt )
   693:             
   694:             
   695:                 ! 計算時間計測一時停止
   696:                 ! Pause measurement of computation time
   697:                 !
   698:                 call TimesetClockStop( module_name )
   699:             
   700:               end subroutine GWDM1987
   701:             
   702:               !--------------------------------------------------------------------------------------
   703:             
   704:               !******************************************************************************
   705:               !      subroutine tridiag
   706:               !      tidiagonal solver
   707:               !******************************************************************************
   708:               !     a(j), b(j), and c(j) are, respectively, the subdiagonal, diagonal,
   709:               !     and superdiagonal entries in row j.
   710:               !     a(1) and c(jmx) need not be initialized.
   711:               !     The output is in f; a, b, and c are unchanged.
   712:               !******************************************************************************
   713:               !     jmx    : dimensions of all the following arrays
   714:               !     a      : sub (lower) diagonal
   715:               !     b      : center diagonal
   716:               !     c      : super (upper) diagonal
   717:               !     f      : right hand side
   718:               !******************************************************************************
   719:             
   720:               subroutine tridiag( mm, jmx, a, b, c, f, ms, me )
   721:             
   722:                 integer , intent(in   ) :: mm, jmx
   723:                 real(DP), intent(in   ) :: a( mm, jmx ),b( mm, jmx )
   724:                 real(DP), intent(in   ) :: c( mm, jmx )
   725:                 real(DP), intent(inout) :: f( mm, jmx )
   726:                 integer , intent(in   ) :: ms, me
   727:             
   728:             
   729:                 ! Local variables
   730:                 !
   731:                 real(DP) :: q( mm, jmx ), p
   732:                 integer  :: j, m
   733:             
   734:             
   735:                 ! Forward elimination sweep
   736:                 !
   737: V------>        do m = ms, me
   738: |       A         q( m, 1 ) = - c( m, 1 ) / b( m, 1 )
   739: |       A         f( m, 1 ) =   f( m, 1 ) / b( m, 1 )
   740: V------         end do
   741:             
   742: +------>        do j = 2, jmx
   743: |V----->          do m = ms, me
   744: ||      A           p         = 1.0d0 / ( b( m, j ) + a( m, j ) * q( m, j-1 ) )
   745: ||      A           q( m, j ) = - c( m, j ) * p
   746: ||      A           f( m, j ) = ( f( m, j ) - a( m, j ) * f( m, j-1 ) ) * p
   747: |V-----           end do
   748: +------         end do
   749:             
   750:                 ! Backward pass
   751:                 !
   752: +------>        do j = jmx - 1, 1, -1
   753: |V----->          do m = ms, me
   754: ||      A           f( m, j ) = f( m, j ) + q( m, j ) * f( m, j+1 )
   755: |V-----           end do
   756: +------         end do
   757:             
   758:               end subroutine tridiag
   759:             
   760:               !--------------------------------------------------------------------------------------
   761:             
   762:               subroutine GWDM1987Init
   763:                 !
   764:                 ! moist_conv_adjust モジュールの初期化を行います. 
   765:                 ! NAMELIST#moist_conv_adjust_nml の読み込みはこの手続きで行われます. 
   766:                 !
   767:                 ! "moist_conv_adjust" module is initialized. 
   768:                 ! "NAMELIST#moist_conv_adjust_nml" is loaded in this procedure. 
   769:                 !
   770:             
   771:                 ! モジュール引用 ; USE statements
   772:                 !
   773:             
   774:                 ! 日付および時刻の取り扱い
   775:                 ! Date and time handler
   776:                 !
   777:                 use dc_calendar, only: DCCalConvertByUnit
   778:             
   779:                 ! NAMELIST ファイル入力に関するユーティリティ
   780:                 ! Utilities for NAMELIST file input
   781:                 !
   782:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   783:             
   784:                 ! ファイル入出力補助
   785:                 ! File I/O support
   786:                 !
   787:                 use dc_iounit, only: FileOpen
   788:             
   789:                 ! 文字列操作
   790:                 ! Character handling
   791:                 !
   792:                 use dc_string, only: StoA
   793:             
   794:                 ! ヒストリデータ出力
   795:                 ! History data output
   796:                 !
   797:                 use gtool_historyauto, only: HistoryAutoAddVariable
   798:             
   799:                 ! 座標データ設定
   800:                 ! Axes data settings
   801:                 !
   802:                 use axesset, only: &
   803:                   & AxnameX, &
   804:                   & AxnameY, &
   805:                   & AxnameZ, &
   806:                   & AxnameR, &
   807:                   & AxnameT
   808:             
   809:                 ! 物理定数設定
   810:                 ! Physical constants settings
   811:                 !
   812:                 use constants, only : &
   813:                   RPlanet
   814:                                           ! $ a $ [m].
   815:                                           ! 惑星半径.
   816:                                           ! Radius of planet
   817:             
   818:             
   819:                 ! 宣言文 ; Declaration statements
   820:                 !
   821:                 implicit none
   822:             
   823:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   824:                                           ! Unit number for NAMELIST file open
   825:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   826:                                           ! IOSTAT of NAMELIST read
   827:             
   828:             !!$    real(DP)         :: GWDDampPeriodValue
   829:             !!$    character(TOKEN) :: GWDDampPeriodUnit
   830:             
   831:                 integer:: k
   832:             
   833:             
   834:                 ! NAMELIST 変数群
   835:                 ! NAMELIST group name
   836:                 !
   837:                 namelist /gwd_m1987_nml/ &
   838:                   & FlagDetermineRefLevByStd, &
   839:                   & SigmaRef, &
   840:                   & CrtlFNumSq, &
   841:                   & Efficiency, &
   842:                   & OrogEffWaveLength !, &
   843:             !!$      & FlagGWDDamp, GWDDampPeriodValue, GWDDampPeriodUnit
   844:                       ! デフォルト値については初期化手続 "moist_conv_adjust#CumAdjInit" 
   845:                       ! のソースコードを参照のこと. 
   846:                       !
   847:                       ! Refer to source codes in the initialization procedure
   848:                       ! "moist_conv_adjust#MoistConvAdjustInit" for the default values. 
   849:                       !
   850:             
   851:                 ! 実行文 ; Executable statement
   852:                 !
   853:             
   854:                 if ( gwd_m1987_inited ) return
   855:             
   856:             
   857:                 ! デフォルト値の設定
   858:                 ! Default values settings
   859:                 !
   860:                 FlagDetermineRefLevByStd = .false.
   861:             
   862:                 SigmaRef           = 1.0_DP   ! lowest model level
   863:             
   864:                 CrtlFNumSq         = 0.5_DP   ! value used by McFarlane (1987)
   865:                 Efficiency         = 1.0_DP   ! arbitrary
   866:             !!$    OrogEffWaveLength  = 2.0_DP * PI / ( 2.0_DP * 8.0e-6_DP / Efficiency )
   867:                                               ! value used by McFarlane (1987)
   868:                 if ( imax /= 1 ) then
   869:                   OrogEffWaveLength  = 2.0_DP * PI * RPlanet / ( ( imax - 1 ) / 3.0_DP )
   870:                                               ! wavelength of smallest resolved wave
   871:                 else
   872:                   OrogEffWaveLength  = 2.0_DP * PI / ( 2.0_DP * 8.0e-6_DP / Efficiency )
   873:                                               ! value used by McFarlane (1987)
   874:                 end if
   875:             
   876:             !!$    FlagGWDDamp        = .false.
   877:             !!$    GWDDampPeriodValue = 0.0_DP
   878:             !!$    GWDDampPeriodUnit  = 'day'
   879:             
   880:             
   881:                 ! NAMELIST の読み込み
   882:                 ! NAMELIST is input
   883:                 !
   884:                 if ( trim(namelist_filename) /= '' ) then
   885:                   call FileOpen( unit_nml, &          ! (out)
   886:                     & namelist_filename, mode = 'r' ) ! (in)
   887:             
   888:                   rewind( unit_nml )
   889:                   read( unit_nml,                     &  ! (in)
   890:                     & nml = gwd_m1987_nml,            &  ! (out)
   891:                     & iostat = iostat_nml )              ! (out)
   892:                   close( unit_nml )
   893:             
   894:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   895:                 end if
   896:             
   897:             
   898:                 ! Calculate factor for momentum flux
   899:                 MomFluxFactor = Efficiency * 2.0_DP * PI / OrogEffWaveLength / 2.0_DP
   900:             
   901:                 ! Check values
   902:                 !
   903:                 SigmaRef = max( min( SigmaRef, 1.0_DP ), 0.0_DP )
   904:             
   905:                 ! Calculation of divergence damping period
   906:                 !
   907:             !!$    GWDDampPeriod = DCCalConvertByUnit( GWDDampPeriodValue, GWDDampPeriodUnit, 'sec' )
   908:             
   909:                 ! ヒストリデータ出力のためのへの変数登録
   910:                 ! Register of variables for history data output
   911:                 !
   912:                 call HistoryAutoAddVariable( 'GWMomFlux', &
   913:                   & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   914:                   & 'gravity wave momentum flux', 'kg m-1 s-2' )
   915:                 call HistoryAutoAddVariable( 'GWMomFluxX', &
   916:                   & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   917:                   & 'gravity wave zonal momentum flux', 'kg m-1 s-2' )
   918:                 call HistoryAutoAddVariable( 'GWMomFluxY', &
   919:                   & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   920:                   & 'gravity wave meridional momentum flux', 'kg m-1 s-2' )
   921:                 call HistoryAutoAddVariable( 'DUDtGWD', &
   922:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   923:                   & 'zonal wind tendency by gravity wave drag', 'm-1 s-2' )
   924:                 call HistoryAutoAddVariable( 'DVDtGWD', &
   925:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   926:                   & 'meridional wind tendency by gravity wave drag', 'm-1 s-2' )
   927:                 call HistoryAutoAddVariable( 'DWSDtGWD', &
   928:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   929:                   & 'wind speed tendency by gravity wave drag', 'm-1 s-2' )
   930:             
   931:             
   932:                 ! Initialization of modules used in this module
   933:                 !
   934:             
   935:             
   936:                 ! 印字 ; Print
   937:                 !
   938:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   939:                 call MessageNotify( 'M', module_name, '  FlagDetermineRefLevByStd = %b', l = (/ FlagDetermineRefLevByStd /) )
   940:                 call MessageNotify( 'M', module_name, '  SigmaRef            = %f', d = (/ SigmaRef /) )
   941:                 call MessageNotify( 'M', module_name, '  CrtlFNumSq          = %f', d = (/ CrtlFNumSq /) )
   942:                 call MessageNotify( 'M', module_name, '  Efficiency          = %f', d = (/ Efficiency /) )
   943:                 call MessageNotify( 'M', module_name, '  OrogEffWaveLength   = %f', d = (/ OrogEffWaveLength /) )
   944:                 call MessageNotify( 'M', module_name, '    MomFluxFactor     = %f', d = (/ MomFluxFactor /) )
   945:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   946:             
   947:                 gwd_m1987_inited = .true.
   948:             
   949:               end subroutine GWDM1987Init
   950:             
   951:               !--------------------------------------------------------------------------------------
   952:             
   953:             end module gwd_m1987
