Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:46 2016
FILE NAME: held_suarez_1994.f90
PROGRAM NAME: held_suarez_1994
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   280  opt  (1772): Loop nest fused with following nest(s).
   280  vec  (   3): Unvectorized loop.
   280  vec  (  13): Overhead of loop division is too large.
   281  opt  (  11): Fused array assignments. :line 281 - 282
   281  opt  (1593): Loop nest collapsed into one loop.
   281  vec  (   4): Vectorized array expression.
   281  vec  (  29): ADB is used for array.: xy_ps
   281  vec  (  29): ADB is used for array.: xyz_dvdt
   281  vec  (  29): ADB is used for array.: xyz_v
   281  vec  (  29): ADB is used for array.: xyz_dudt
   281  vec  (  29): ADB is used for array.: xyz_u
   292  vec  (   3): Unvectorized loop.
   292  vec  (  13): Overhead of loop division is too large.
   293  vec  (   4): Vectorized array expression.
   293  vec  (  29): ADB is used for array.: xyz_tempeq
   305  opt  (1592): Outer loop unrolled inside inner loop.
   305  vec  (   3): Unvectorized loop.
   305  vec  (  13): Overhead of loop division is too large.
   305  vec  (   3): Unvectorized loop.
   305  vec  (  13): Overhead of loop division is too large.
   306  vec  (   4): Vectorized array expression.
   306  vec  (  29): ADB is used for array.: xyz_dtempdt
   306  vec  (  29): ADB is used for array.: xyz_tempeq
   306  vec  (  29): ADB is used for array.: xyz_temp
   306  vec  (   4): Vectorized array expression.
   306  vec  (  29): ADB is used for array.: xyz_dtempdt
   306  vec  (  29): ADB is used for array.: xyz_tempeq
   306  vec  (  29): ADB is used for array.: xyz_temp
   482  vec  (   4): Vectorized array expression.
   482  vec  (  29): ADB is used for array.: z_kv
   482  vec  (  29): ADB is used for array.: z_sigma
   487  opt  (1592): Outer loop unrolled inside inner loop.
   488  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   488  vec  (   1): Vectorized loop.
   488  vec  (  29): ADB is used for array.: d2
   488  vec  (  29): ADB is used for array.: y_lat
   488  vec  (   1): Vectorized loop.
   488  vec  (  29): ADB is used for array.: yz_kt
   488  vec  (  29): ADB is used for array.: d2
   488  vec  (   1): Vectorized loop.
   488  vec  (  29): ADB is used for array.: yz_kt
   488  vec  (  29): ADB is used for array.: d2
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:46 2016
FILE NAME: held_suarez_1994.f90
PROGRAM NAME: held_suarez_1994
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Held and Suarez (1994) による強制と散逸
     2  !
     3  != Forcing and dissipation suggested by Held and Suarez (1994)
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: held_suarez_1994.f90,v 1.14 2012/04/27 11:24:45 noda Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module held_suarez_1994
    13    !
    14    != Held and Suarez (1994) による強制と散逸
    15    !
    16    != Forcing and dissipation suggested by Held and Suarez (1994)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! Held and Suarez (1994) で提案される乾燥大気 GCM ベンチマーク用の
    21    ! 強制と散逸を計算します.
    22    ! 与える強制と散逸として, 温度場の帯状対称場への簡単なニュートン冷却と,
    23    ! 境界層摩擦を表現する下層風のレイリー摩擦を用います.
    24    ! 詳細を以下に記します.
    25    !
    26    ! Forcing and dissipation for dry air GCM benchmark
    27    ! suggested by Held and Suarez (1994) are caluclate.
    28    ! We use simple Newtonian relaxation of the temperature field to a
    29    ! zonally symmetric state and Rayleigh damping of low-level winds to
    30    ! represent boundary-layer friction.
    31    ! Their specifications are detailed as follows.
    32    !
    33    ! \[
    34    !    \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} =
    35    !        - k_v (\sigma) \Dvect{v}, \] \[
    36    !    \left( \DP{T}{t} \right)_{\mathrm{HS94}} =
    37    !        - k_T (\phi, \sigma) [T - T_{eq} (\phi,p)], \] \[
    38    !    T_{eq} = \mathrm{max}
    39    !     \left\{
    40    !        200 \mathrm{K},
    41    !        \left[
    42    !          315 \mathrm{K} - (\Delta T)_y \sin^2\phi
    43    !                         - (\Delta \theta)_z
    44    !                           \log \left(\frac{p}{p_0}\right) \cos^2\phi
    45    !        \right] \left(\frac{p}{p_0}\right)^\kappa
    46    !     \right\}, \] \[
    47    !    k_T = k_a + (k_s - k_a)
    48    !          \mathrm{max}
    49    !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right) \cos^4\phi,
    50    !     \] \[
    51    !    k_v = k_f
    52    !          \mathrm{max}
    53    !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right),
    54    !     \] \[
    55    !    \sigma_b = 0.7, \qquad
    56    !    k_f = 1 \mathrm{day}^{-1}, \qquad
    57    !    k_a = \Dinv{40} \mathrm{day}^{-1}, \qquad
    58    !    k_s = \Dinv{4} \mathrm{day}^{-1}, \] \[
    59    !    (\Delta T)_y = 60 \mathrm{K}, \qquad
    60    !    (\Delta \theta)_z = 10 \mathrm{K}, \qquad
    61    !    p_0 = 1000 \mathrm{hPa}, \qquad
    62    !    \kappa = \frac{R}{c_p}.
    63    ! \]
    64    !
    65    ! Forcing では, 与えられた速度や温度 ( $ t+\Delta t$ を想定)
    66    ! に対して以下のように強制と散逸を適用します.
    67    !
    68    ! By Forcing, forcing and dissipation are applied to
    69    ! given wind and temperature ($ t+\Delta t$ is expected) as follows.
    70    !
    71    ! \[
    72    !    \hat{\Dvect{v}}^{t+\Delta t} =
    73    !      \Dvect{v}^{t+\Delta t}
    74    !      + 2 \Delta t \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} \] \[
    75    !    \hat{T}^{t+\Delta t} =
    76    !      T^{t+\Delta t}
    77    !      + 2 \Delta t \left( \DP{T}{t} \right)_{\mathrm{HS94}}
    78    ! \]
    79    !
    80    !== Procedures List
    81    !
    82    ! Hs94Forcing   :: 強制と散逸の計算
    83    ! Hs94Finalize  :: 終了処理 (モジュール内部の変数の割り付け解除)
    84    ! ------------  :: ------------
    85    ! Hs94Forcing   :: Calculate forcing and dissipation
    86    ! Hs94Finalize  :: Termination (deallocate variables in this module)
    87    !
    88    !--
    89    !== NAMELIST
    90    !
    91    ! NAMELIST#held_suarez_1994_nml
    92    !++
    93    !== References
    94    !
    95    ! * Held, I. M., Suarez, M. J., 1994:
    96    !   A proposal for the intercomparison of the dynamical cores of
    97    !   atmospheric general circuation models.
    98    !   <i>Bull. Am. Meteor. Soc.</i>, <b>75</b>, 1825--1830.
    99    !
   100  
   101    ! モジュール引用 ; USE statements
   102    !
   103  
   104    ! 格子点設定
   105    ! Grid points settings
   106    !
   107    use gridset, only: imax, & ! 経度格子点数.
   108                               ! Number of grid points in longitude
   109      &                jmax, & ! 緯度格子点数.
   110                               ! Number of grid points in latitude
   111      &                kmax    ! 鉛直層数.
   112                               ! Number of vertical level
   113  
   114    ! 種別型パラメタ
   115    ! Kind type parameter
   116    !
   117    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   118      &                 STRING     ! 文字列.       Strings.
   119  
   120  
   121    ! メッセージ出力
   122    ! Message output
   123    !
   124    use dc_message, only: MessageNotify
   125  
   126    ! 宣言文 ; Declaration statements
   127    !
   128    implicit none
   129    private
   130  
   131    ! 公開手続き
   132    ! Public procedure
   133    !
   134    public :: HS94Forcing
   135    public :: HS94Init
   136    public :: HS94Finalize
   137  
   138    ! 公開変数
   139    ! Public variables
   140    !
   141  
   142    ! 非公開変数
   143    ! Private variables
   144    !
   145    logical, save :: held_suarez_1994_inited = .false.
   146                                ! 初期設定フラグ.
   147                                ! Initialization flag
   148  
   149    real(DP):: Kappa            ! $ \kappa = R/C_p $ .
   150                                ! 気体定数の定圧比熱に対する比. Ratio of gas constant to specific heat
   151    real(DP):: P0               ! $ p_0 $ .
   152    real(DP):: DelTempY         ! $ (\Delta T)_y $ .
   153                                ! 極と赤道の温度差
   154    real(DP):: DelPotTempZ      ! $ (\Delta \theta)_z $ .
   155                                ! 赤道における鉛直方向の温位差
   156    real(DP), allocatable:: z_kv (:)
   157                                ! $ k_v $ .
   158    real(DP), allocatable:: yz_kt (:,:)
   159                                ! $ k_T $ .
   160  
   161    character(*), parameter:: module_name = 'held_suarez_1994'
   162                                ! モジュールの名称.
   163                                ! Module name
   164    character(*), parameter:: version = &
   165      & '$Name:  $' // &
   166      & '$Id: held_suarez_1994.f90,v 1.14 2012/04/27 11:24:45 noda Exp $'
   167                                ! モジュールのバージョン
   168                                ! Module version
   169  
   170  contains
   171  
   172    !--------------------------------------------------------------------------------------
   173  
   174    subroutine HS94Forcing( &
   175      & xyz_U,    xyz_V,    xyz_Temp, xy_Ps, & ! (in)
   176      & xyz_DUDt, xyz_DVDt, xyz_DTempDt &      ! (out)
   177      & )
   178      !
   179      ! 引数として与えられた東西風速 xyz_U, 南北風速 xyz_V,
   180      ! 温度 xyz_Temp から,
   181      ! 温度場の帯状対称場への簡単なニュートン冷却と
   182      ! 境界層摩擦を表現する下層風のレイリー摩擦による
   183      ! 風速と温度の変化率を求め,
   184      ! xyz_DUDt, xyz_DVDt, xyz_DTempDt に返します.
   185      !
   186      ! Tendencies by simple Newtonian relaxation of the temperature field to a
   187      ! zonally symmetric state and Rayleigh damping of low-level winds to
   188      ! represent boundary-layer friction are calculated
   189      ! from eastward wind "xyz_U", northward wind "xyz_V",
   190      ! temperature "xyz_Temp".
   191      ! And the tencencies are returned as
   192      ! "xyz_DUDt", "xyz_DVDt", "xyz_DTempDt".
   193      !
   194      !
   195  
   196      ! モジュール引用 ; USE statements
   197      !
   198  
   199      ! 座標データ設定
   200      ! Axes data settings
   201      !
   202      use axesset, only: &
   203        & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   204        & z_Sigma               ! $ \sigma $ レベル (整数).
   205                                ! Full $ \sigma $ level
   206  
   207      ! 時刻管理
   208      ! Time control
   209      !
   210      use timeset, only: &
   211        & DelTime, &            ! $ \Delta t $
   212        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   213        & TimesetClockStart, TimesetClockStop
   214  
   215      ! ヒストリデータ出力
   216      ! History data output
   217      !
   218      use gtool_historyauto, only: HistoryAutoPut
   219  
   220      ! 宣言文 ; Declaration statements
   221      !
   222      implicit none
   223  
   224      real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   225                                ! $ u $ . 東西風速.
   226                                ! Eastward wind
   227      real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   228                                ! $ v $ . 南北風速.
   229                                ! Northward wind
   230      real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   231                                ! $ T $ . 温度.
   232                                ! Temperature
   233      real(DP), intent(in):: xy_Ps (0:imax-1, 1:jmax)
   234                                ! $ p_s $ . 地表面気圧.
   235                                ! Surface pressure
   236      real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   237                                ! $ \DP{u}{t} $ . 東西風速変化.
   238                                ! Eastward wind tendency
   239      real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   240                                ! $ \DP{v}{t} $ . 南北風速変化.
   241                                ! Northward wind tendency
   242      real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   243                                ! $ \DP{T}{t} $ . 温度変化.
   244                                ! Temperature tendency
   245  
   246      ! 作業変数
   247      ! Work variables
   248      !
   249      real(DP):: xyz_TempEQ (0:imax-1, 1:jmax, 1:kmax)
   250                                ! $ T_{eq} $ . 平衡温度.
   251                                ! Equilibrium temperature
   252      real(DP):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   253                                ! $ T $ . 圧力.
   254                                ! Pressure
   255  
   256      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   257                                ! Work variables for DO loop in latitude
   258      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   259                                ! Work variables for DO loop in vertical direction
   260  
   261      ! 実行文 ; Executable statement
   262      !
   263  
   264      ! 初期化確認
   265      ! Initialization check
   266      !
   267      if ( .not. held_suarez_1994_inited ) then
   268        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   269      end if
   270  
   271      ! 計算時間計測開始
   272      ! Start measurement of computation time
   273      !
   274      call TimesetClockStart( module_name )
   275  
   276  
   277      ! 東西風速 $ u $ と南北風速 $ v $ へレイリー摩擦を適用
   278      ! Apply Rayleigh damping to eastward wind $ u $ and northward wind $ v $
   279      !
   280      do k = 1, kmax
   281        xyz_DUDt (:,:,k) = - z_kv (k) * xyz_U (:,:,k)
   282        xyz_DVDt (:,:,k) = - z_kv (k) * xyz_V (:,:,k)
   283      end do
   284  
   285      ! 温度 $ T $ へニュートン冷却を適用
   286      ! Apply Newtonian relaxation to temperature $ T $
   287      !
   288      do k = 1, kmax
   289         xyz_Press(:,:,k) = z_Sigma(k) * xy_Ps
   290      enddo
   291  
   292      do j = 1, jmax
   293        xyz_TempEQ(:,j,:) = &
   294          & max( 200.0_DP, &
   295          &      (   315.0_DP &
   296          &        - DelTempY * sin( y_Lat(j) ) ** 2 &
   297          &        - DelPotTempZ * log( xyz_Press(:,j,:) / P0 ) &
   298          &                                 * cos( y_Lat(j) ) ** 2 &
   299          &      ) &
   300          &      * ( xyz_Press(:,j,:) / P0 ) ** Kappa &
   301          &     )
   302      end do
   303  
   304      do k = 1, kmax
   305        do j = 1, jmax
   306          xyz_DTempDt (:,j,k) = &
   307            & - yz_kt (j,k) * ( xyz_Temp (:,j,k) - xyz_TempEQ (:,j,k) )
   308        end do
   309      end do
   310  
   311  
   312      ! ヒストリデータ出力
   313      ! History data output
   314      !
   315      call HistoryAutoPut( TimeN, 'DUDtHS94',    xyz_DUDt )
   316      call HistoryAutoPut( TimeN, 'DVDtHS94',    xyz_DVDt )
   317      call HistoryAutoPut( TimeN, 'DTempDtHS94', xyz_DTempDt )
   318      call HistoryAutoPut( TimeN, 'TempEQHS94',  xyz_TempEQ )
   319  
   320  
   321      ! 計算時間計測一時停止
   322      ! Pause measurement of computation time
   323      !
   324      call TimesetClockStop( module_name )
     .        xyz_dudt.DSC.ADDR = loc(xyz_dudt)                                 
     .        xyz_dvdt.DSC.ADDR = loc(xyz_dvdt)                                 
     .        xyz_dtempdt.DSC.ADDR = loc(xyz_dtempdt)                           
     .        xyz_dudt.DSC.U1 = imax - 1                                        
     .        xyz_dudt.DSC.U2 = jmax                                            
     .        xyz_dudt.DSC.U3 = kmax                                            
     .        xyz_dudt.DSC.S2 = (xyz_dudt.DSC.U1 + 1)*8                         
     .        xyz_dudt.DSC.S3 = xyz_dudt.DSC.U2*(xyz_dudt.DSC.U1 + 1)*8         
     .        xyz_dvdt.DSC.U1 = imax - 1                                        
     .        xyz_dvdt.DSC.U2 = jmax                                            
     .        xyz_dvdt.DSC.U3 = kmax                                            
     .        xyz_dvdt.DSC.S2 = (xyz_dvdt.DSC.U1 + 1)*8                         
     .        xyz_dvdt.DSC.S3 = xyz_dvdt.DSC.U2*(xyz_dvdt.DSC.U1 + 1)*8         
     .        xyz_dtempdt.DSC.U1 = imax - 1                                     
     .        xyz_dtempdt.DSC.U2 = jmax                                         
     .        xyz_dtempdt.DSC.U3 = kmax                                         
     .        xyz_dtempdt.DSC.S2 = (xyz_dtempdt.DSC.U1 + 1)*8                   
     .        xyz_dtempdt.DSC.S3 = xyz_dtempdt.DSC.U2*(xyz_dtempdt.DSC.U1 + 1)*8
     .        xyz_tempeq.DSC.U1 = imax - 1                                      
     .        xyz_tempeq.DSC.U2 = jmax                                          
     .        xyz_tempeq.DSC.U3 = kmax                                          
     .        allocate (xyz_tempeq(0:imax-1,1:jmax,1:kmax))                     
     .        xyz_press.DSC.U1 = imax - 1                                       
     .        xyz_press.DSC.U2 = jmax                                           
     .        xyz_press.DSC.U3 = kmax                                           
     .        allocate (xyz_press(0:imax-1,1:jmax,1:kmax))                      
     .        xyz_press.DSC.S2 = (xyz_press.DSC.U1 + 1)*8                       
     .        xyz_press.DSC.S3 = xyz_press.DSC.U2*(xyz_press.DSC.U1 + 1)*8      
     .        xyz_tempeq.DSC.S2 = (xyz_tempeq.DSC.U1 + 1)*8                     
     .        xyz_tempeq.DSC.S3 = xyz_tempeq.DSC.U2*(xyz_tempeq.DSC.U1 + 1)*8   
     .        if (held_suarez_1994_inited .ne. 0) goto 10001                    
     .        call messagenotifyc ('E', module_name,                            
     .       1   'This module has not been initialized.', 1, 1, 1, 1, 1, 1, 1, 1
     .       2   , 1, 1, 1, 16, 37, 0, 0, 0, 0)                                 
     .  10001 continue                                                          
     .        call timesetclockstart (module_name, 16)                          
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_ps)                                                  
     .           do t290 = 1, jmax*imax                                         
     .              xyz_dudt(t290-1,1,k) = -z_kv(k)*xyz_u(t290-1,1,k)           
     .              xyz_dvdt(t290-1,1,k) = -z_kv(k)*xyz_v(t290-1,1,k)           
     .              xyz_press(t290-1,1,k) = z_sigma(k)*xy_ps(t290-1,1)          
     .           enddo                                                          
     .        enddo                                                             
     .        do j = 1, jmax                                                    
     .  !cdir    nodep                                                          
     .           do t310 = 0, xyz_press.DSC.U3 - 1                              
     .              d1 = 1.D0/p0                                                
     .              d2 = 1.D0/p0                                                
     .  !cdir       nodep                                                       
     .              do t312 = 1, xyz_press.DSC.U1 + 1                           
     .                 xyz_tempeq(t312-1,j,t310+1) = max(2.00000000000000e+002,(
     .       1            3.15000000000000e+002 - deltempy*dsin(y_lat(j))**2-   
     .       2            delpottempz*dlog((xyz_press(t312-1,j,t310+1)*d1))*dcos
     .       3            (y_lat(j))**2)*(xyz_press(t312-1,j,t310+1)*d2)**kappa)
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        do k = 1, kmax                                                    
     .           if (jmax .gt. 0) then                                          
     .              j1 = and(jmax,3)                                            
     .              do j = 1, j1                                                
     .  !cdir          nodep                                                    
     .                 do t320 = 1, imax                                        
     .                    xyz_dtempdt(t320-1,j,k) = -yz_kt(j,k)*(xyz_temp(t320-1
     .       1               ,j,k)-xyz_tempeq(t320-1,j,k))                      
     .                 enddo                                                    
     .              enddo                                                       
     .              do j = j1 + 1, jmax, 4                                      
     .  !cdir          nodep                                                    
     .                 do t320 = 1, imax                                        
     .                    xyz_dtempdt(t320-1,j,k) = -yz_kt(j,k)*(xyz_temp(t320-1
     .       1               ,j,k)-xyz_tempeq(t320-1,j,k))                      
     .                    xyz_dtempdt(t320-1,j+1,k) = -yz_kt(j+1,k)*(xyz_temp(  
     .       1               t320-1,j+1,k)-xyz_tempeq(t320-1,j+1,k))            
     .                    xyz_dtempdt(t320-1,j+2,k) = -yz_kt(j+2,k)*(xyz_temp(  
     .       1               t320-1,j+2,k)-xyz_tempeq(t320-1,j+2,k))            
     .                    xyz_dtempdt(t320-1,j+3,k) = -yz_kt(j+3,k)*(xyz_temp(  
     .       1               t320-1,j+3,k)-xyz_tempeq(t320-1,j+3,k))            
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .        call historyautoputdouble3 (timen, 'DUDtHS94', xyz_dudt, 1, 8)    
     .        call historyautoputdouble3 (timen, 'DVDtHS94', xyz_dvdt, 1, 8)    
     .        call historyautoputdouble3 (timen, 'DTempDtHS94', xyz_dtempdt, 1, 
     .       1   11)                                                            
     .        call historyautoputdouble3 (timen, 'TempEQHS94', xyz_tempeq, 1, 10
     .       1   )                                                              
     .        call timesetclockstop (module_name, 16)                           
   325  
   326    end subroutine HS94Forcing
   327  
   328    !--------------------------------------------------------------------------------------
   329  
   330    subroutine HS94Init
   331      !
   332      ! held_suarez_1994 モジュールの初期化を行います.
   333      ! NAMELIST#held_suarez_1994_nml の読み込みはこの手続きで行われます.
   334      !
   335      ! "held_suarez_1994" module is initialized.
   336      ! "NAMELIST#held_suarez_1994_nml" is loaded in this procedure.
   337      !
   338  
   339      ! モジュール引用 ; USE statements
   340      !
   341  
   342      ! 物理定数設定
   343      ! Physical constants settings
   344      !
   345      use constants, only: &
   346        & GasRDry, &
   347                                ! $ R $ [J kg-1 K-1].
   348                                ! 乾燥大気の気体定数.
   349                                ! Gas constant of air
   350        & CpDry
   351                                ! $ C_p $ [J kg-1 K-1].
   352                                ! 乾燥大気の定圧比熱.
   353                                ! Specific heat of air at constant pressure
   354  
   355      ! 座標データ設定
   356      ! Axes data settings
   357      !
   358      use axesset, only: &
   359        & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   360        & z_Sigma               ! $ \sigma $ レベル (整数).
   361                                ! Full $ \sigma $ level
   362  
   363      ! NAMELIST ファイル入力に関するユーティリティ
   364      ! Utilities for NAMELIST file input
   365      !
   366      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   367  
   368      ! ファイル入出力補助
   369      ! File I/O support
   370      !
   371      use dc_iounit, only: FileOpen
   372  
   373      ! 種別型パラメタ
   374      ! Kind type parameter
   375      !
   376      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   377  
   378      ! 文字列操作
   379      ! Character handling
   380      !
   381      use dc_string, only: StoA
   382  
   383      ! ヒストリデータ出力
   384      ! History data output
   385      !
   386      use gtool_historyauto, only: HistoryAutoAddVariable
   387  
   388      ! 宣言文 ; Declaration statements
   389      !
   390      implicit none
   391  
   392      real(DP), parameter :: day_seconds = 86400.0_DP
   393                                ! 1 日の秒数.
   394                                ! Seconds in day.
   395      real(DP):: SigmaB         ! $ \sigma_b $ .
   396                                ! 境界層上端の高度
   397      real(DP):: kf             ! $ k_f $ .
   398                                ! 地表面での Rayleigh 摩擦の緩和係数
   399      real(DP):: ka             ! $ k_a $ .
   400                                ! 大気上層における Newton 冷却の緩和係数
   401      real(DP):: ks             ! $ k_s $ .
   402                                ! 赤道地表面における Newton 冷却の緩和係数
   403  
   404      real(DP):: kfTimeScaleInDay
   405      real(DP):: kaTimeScaleInDay
   406      real(DP):: ksTimeScaleInDay
   407  
   408      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   409                                ! Work variables for DO loop in latitude
   410      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   411                                ! Work variables for DO loop in vertical direction
   412  
   413      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   414                                ! Unit number for NAMELIST file open
   415      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   416                                ! IOSTAT of NAMELIST read
   417  
   418      ! NAMELIST 変数群
   419      ! NAMELIST group name
   420      !
   421      namelist /held_suarez_1994_nml/ &
   422        & SigmaB, &
   423        & kfTimeScaleInDay, &
   424        & kaTimeScaleInDay, &
   425        & ksTimeScaleInDay
   426            !
   427            ! デフォルト値については初期化手続 "held_suarez_1994#HS94Init"
   428            ! のソースコードを参照のこと.
   429            !
   430            ! Refer to source codes in the initialization procedure
   431            ! "held_suarez_1994#HS94Init" for the default values.
   432            !
   433  
   434      ! 実行文 ; Executable statement
   435      !
   436  
   437      if ( held_suarez_1994_inited ) return
   438  
   439  
   440      ! デフォルト値の設定
   441      ! Default values settings
   442      !
   443      SigmaB           =  0.7_DP
   444      kfTimeScaleInDay =  1.0_DP
   445      kaTimeScaleInDay = 40.0_DP
   446      ksTimeScaleInDay =  4.0_DP
   447  
   448      ! NAMELIST の読み込み
   449      ! NAMELIST is input
   450      !
   451      if ( trim(namelist_filename) /= '' ) then
   452        call FileOpen( unit_nml, &          ! (out)
   453          & namelist_filename, mode = 'r' ) ! (in)
   454  
   455        rewind( unit_nml )
   456        read( unit_nml, &                ! (in)
   457          & nml = held_suarez_1994_nml, &  ! (out)
   458          & iostat = iostat_nml )        ! (out)
   459        close( unit_nml )
   460  
   461        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   462  !$      if ( iostat_nml == 0 ) write( STDOUT, nml = held_suarez_1994_nml )
   463      end if
   464  
   465      ! 係数の設定
   466      ! Configure coefficients
   467      !
   468      Kappa = GasRDry / CpDry
   469  
   470      P0          = 1000.0e2_DP
   471      DelTempY    = 60.0_DP
   472      DelPotTempZ = 10.0_DP
   473  
   474  !!$    kf     = 1.0_DP / day_seconds
   475  !!$    ka     = 1.0_DP / ( 40.0_DP * day_seconds )
   476  !!$    ks     = 1.0_DP / (  4.0_DP * day_seconds )
   477      kf     = 1.0_DP / ( kfTimeScaleInDay * day_seconds )
   478      ka     = 1.0_DP / ( kaTimeScaleInDay * day_seconds )
   479      ks     = 1.0_DP / ( ksTimeScaleInDay * day_seconds )
   480  
   481      allocate( z_kv (1:kmax) )
   482      z_kv = kf * max( 0.0_DP, &
     .        d1 = 1.D0/(1.00000000000000e+000 - sigmab)                        
     .  !cdir nodep                                                             
     .        do t244 = 1, z_sigma.DSC.U1 + 1 - z_sigma.DSC.L1                  
     .           z_kv(z_kv.DSC.L1+t244-1) = kf*max(0.0000000000000000e+000,(    
     .       1      z_sigma(z_sigma.DSC.L1+t244-1)-sigmab)*d1)                  
     .        enddo                                                             
   483        &              ( z_Sigma - SigmaB ) / ( 1.0_DP - SigmaB ) )
   484  
   485      allocate( yz_kt (1:jmax, 1:kmax) )
   486  
   487      do k = 1, kmax
   488        do j = 1, jmax
   489          yz_kt(j,k) = &
   490            & ka + ( ks - ka ) &
   491            &  * max( 0.0_DP, &
   492            &         ( z_Sigma(k) - SigmaB ) / ( 1.0_DP - SigmaB ) &
   493            &       ) * cos( y_Lat(j) ) ** 4
   494        end do
   495      end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(d2,y_lat)                                                  
     .        do j = 1, jmax                                                    
     .           d2(j) = dcos(y_lat(j))                                         
     .        enddo                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(d2)                                                        
     .        do j1 = 0, jmax - 1, maxvl()                                      
     .           j2 = min0(jmax - j1,maxvl())                                   
     .           if (kmax .gt. 0) then                                          
     .              j3 = and(kmax,3)                                            
     .              do k = 1, j3                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(d2)                                               
     .                 do j = 1, j2                                             
     .                    yz_kt(j1+j,k) = ka + (ks - ka)*max(                   
     .       1               0.0000000000000000e+000,(z_sigma(k)-sigmab)/(      
     .       2               1.00000000000000e+000-sigmab))*d2(j1+j)**4         
     .                 enddo                                                    
     .              enddo                                                       
     .              do k = j3 + 1, kmax, 4                                      
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(d2)                                               
     .                 do j = 1, j2                                             
     .                    d3 = d2(j1+j)                                         
     .                    yz_kt(j1+j,k) = ka + (ks - ka)*max(                   
     .       1               0.0000000000000000e+000,(z_sigma(k)-sigmab)/(      
     .       2               1.00000000000000e+000-sigmab))*(d3**4)             
     .                    yz_kt(j1+j,k+1) = ka + (ks - ka)*max(                 
     .       1               0.0000000000000000e+000,(z_sigma(k+1)-sigmab)/(    
     .       2               1.00000000000000e+000-sigmab))*(d3**4)             
     .                    yz_kt(j1+j,k+2) = ka + (ks - ka)*max(                 
     .       1               0.0000000000000000e+000,(z_sigma(k+2)-sigmab)/(    
     .       2               1.00000000000000e+000-sigmab))*(d3**4)             
     .                    yz_kt(j1+j,k+3) = ka + (ks - ka)*max(                 
     .       1               0.0000000000000000e+000,(z_sigma(k+3)-sigmab)/(    
     .       2               1.00000000000000e+000-sigmab))*(d3**4)             
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   496  
   497  
   498      ! ヒストリデータ出力のためのへの変数登録
   499      ! Register of variables for history data output
   500      !
   501      call HistoryAutoAddVariable( 'DUDtHS94', &
   502        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   503        & 'eastward wind tendency', 'm s-2' )
   504      call HistoryAutoAddVariable( 'DVDtHS94', &
   505        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   506        & 'northward wind tendency', 'm s-2' )
   507      call HistoryAutoAddVariable( 'DTempDtHS94', &
   508        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   509        & 'temperature tendency', 'K s-1' )
   510      call HistoryAutoAddVariable( 'TempEQHS94', &
   511        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   512        & 'equilibrium temperature', 'K' )
   513  
   514      ! 印字 ; Print
   515      !
   516      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   517      call MessageNotify( 'M', module_name, 'SigmaB           = %f', d = (/ SigmaB /) )
   518      call MessageNotify( 'M', module_name, 'kfTimeScaleInDay = %f', d = (/ kfTimeScaleInDay /) )
   519      call MessageNotify( 'M', module_name, 'kaTimeScaleInDay = %f', d = (/ kaTimeScaleInDay /) )
   520      call MessageNotify( 'M', module_name, 'ksTimeScaleInDay = %f', d = (/ ksTimeScaleInDay /) )
   521  
   522      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   523  
   524      held_suarez_1994_inited = .true.
   525  
   526    end subroutine HS94Init
   527  
   528    !--------------------------------------------------------------------------------------
   529  
   530    subroutine HS94Finalize
   531      !
   532      ! モジュール内部の変数の割り付け解除を行います.
   533      !
   534      ! Deallocate variables in this module.
   535      !
   536  
   537      ! 宣言文 ; Declaration statements
   538      !
   539      implicit none
   540  
   541      ! 実行文 ; Executable statement
   542      !
   543  
   544      if ( .not. held_suarez_1994_inited ) return
   545  
   546      ! 割り付け解除
   547      ! Deallocation
   548      !
   549      if ( allocated( z_kv  ) ) deallocate( z_kv  )
   550      if ( allocated( yz_kt ) ) deallocate( yz_kt )
   551  
   552      held_suarez_1994_inited = .false.
   553  
   554    end subroutine HS94Finalize
   555  
   556    !--------------------------------------------------------------------------------------
   557  
   558  end module held_suarez_1994
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:46 2016
FILE NAME: held_suarez_1994.f90
PROGRAM NAME: held_suarez_1994
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Held and Suarez (1994) による強制と散逸
     2:             !
     3:             != Forcing and dissipation suggested by Held and Suarez (1994)
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: held_suarez_1994.f90,v 1.14 2012/04/27 11:24:45 noda Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module held_suarez_1994
    13:               !
    14:               != Held and Suarez (1994) による強制と散逸
    15:               !
    16:               != Forcing and dissipation suggested by Held and Suarez (1994)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! Held and Suarez (1994) で提案される乾燥大気 GCM ベンチマーク用の
    21:               ! 強制と散逸を計算します. 
    22:               ! 与える強制と散逸として, 温度場の帯状対称場への簡単なニュートン冷却と, 
    23:               ! 境界層摩擦を表現する下層風のレイリー摩擦を用います. 
    24:               ! 詳細を以下に記します. 
    25:               !
    26:               ! Forcing and dissipation for dry air GCM benchmark
    27:               ! suggested by Held and Suarez (1994) are caluclate.
    28:               ! We use simple Newtonian relaxation of the temperature field to a
    29:               ! zonally symmetric state and Rayleigh damping of low-level winds to
    30:               ! represent boundary-layer friction.
    31:               ! Their specifications are detailed as follows.
    32:               !
    33:               ! \[
    34:               !    \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} = 
    35:               !        - k_v (\sigma) \Dvect{v}, \] \[
    36:               !    \left( \DP{T}{t} \right)_{\mathrm{HS94}} = 
    37:               !        - k_T (\phi, \sigma) [T - T_{eq} (\phi,p)], \] \[
    38:               !    T_{eq} = \mathrm{max}
    39:               !     \left\{
    40:               !        200 \mathrm{K}, 
    41:               !        \left[
    42:               !          315 \mathrm{K} - (\Delta T)_y \sin^2\phi 
    43:               !                         - (\Delta \theta)_z 
    44:               !                           \log \left(\frac{p}{p_0}\right) \cos^2\phi
    45:               !        \right] \left(\frac{p}{p_0}\right)^\kappa
    46:               !     \right\}, \] \[
    47:               !    k_T = k_a + (k_s - k_a) 
    48:               !          \mathrm{max} 
    49:               !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right) \cos^4\phi,
    50:               !     \] \[
    51:               !    k_v = k_f
    52:               !          \mathrm{max} 
    53:               !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right),
    54:               !     \] \[
    55:               !    \sigma_b = 0.7, \qquad 
    56:               !    k_f = 1 \mathrm{day}^{-1}, \qquad
    57:               !    k_a = \Dinv{40} \mathrm{day}^{-1}, \qquad
    58:               !    k_s = \Dinv{4} \mathrm{day}^{-1}, \] \[
    59:               !    (\Delta T)_y = 60 \mathrm{K}, \qquad
    60:               !    (\Delta \theta)_z = 10 \mathrm{K}, \qquad
    61:               !    p_0 = 1000 \mathrm{hPa}, \qquad
    62:               !    \kappa = \frac{R}{c_p}.
    63:               ! \]
    64:               !
    65:               ! Forcing では, 与えられた速度や温度 ( $ t+\Delta t$ を想定) 
    66:               ! に対して以下のように強制と散逸を適用します.
    67:               !
    68:               ! By Forcing, forcing and dissipation are applied to 
    69:               ! given wind and temperature ($ t+\Delta t$ is expected) as follows.
    70:               !
    71:               ! \[
    72:               !    \hat{\Dvect{v}}^{t+\Delta t} = 
    73:               !      \Dvect{v}^{t+\Delta t} 
    74:               !      + 2 \Delta t \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} \] \[
    75:               !    \hat{T}^{t+\Delta t} = 
    76:               !      T^{t+\Delta t} 
    77:               !      + 2 \Delta t \left( \DP{T}{t} \right)_{\mathrm{HS94}}
    78:               ! \]
    79:               !
    80:               !== Procedures List
    81:               ! 
    82:               ! Hs94Forcing   :: 強制と散逸の計算
    83:               ! Hs94Finalize  :: 終了処理 (モジュール内部の変数の割り付け解除)
    84:               ! ------------  :: ------------
    85:               ! Hs94Forcing   :: Calculate forcing and dissipation
    86:               ! Hs94Finalize  :: Termination (deallocate variables in this module)
    87:               !
    88:               !--
    89:               !== NAMELIST
    90:               !
    91:               ! NAMELIST#held_suarez_1994_nml
    92:               !++
    93:               !== References
    94:               !
    95:               ! * Held, I. M., Suarez, M. J., 1994: 
    96:               !   A proposal for the intercomparison of the dynamical cores of
    97:               !   atmospheric general circuation models.
    98:               !   <i>Bull. Am. Meteor. Soc.</i>, <b>75</b>, 1825--1830.
    99:               !
   100:             
   101:               ! モジュール引用 ; USE statements
   102:               !
   103:             
   104:               ! 格子点設定
   105:               ! Grid points settings
   106:               !
   107:               use gridset, only: imax, & ! 経度格子点数. 
   108:                                          ! Number of grid points in longitude
   109:                 &                jmax, & ! 緯度格子点数. 
   110:                                          ! Number of grid points in latitude
   111:                 &                kmax    ! 鉛直層数. 
   112:                                          ! Number of vertical level
   113:             
   114:               ! 種別型パラメタ
   115:               ! Kind type parameter
   116:               !
   117:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
   118:                 &                 STRING     ! 文字列.       Strings. 
   119:             
   120:             
   121:               ! メッセージ出力
   122:               ! Message output
   123:               !
   124:               use dc_message, only: MessageNotify
   125:             
   126:               ! 宣言文 ; Declaration statements
   127:               !
   128:               implicit none
   129:               private
   130:             
   131:               ! 公開手続き
   132:               ! Public procedure
   133:               !
   134:               public :: HS94Forcing
   135:               public :: HS94Init
   136:               public :: HS94Finalize
   137:             
   138:               ! 公開変数
   139:               ! Public variables
   140:               !
   141:             
   142:               ! 非公開変数
   143:               ! Private variables
   144:               !
   145:               logical, save :: held_suarez_1994_inited = .false.
   146:                                           ! 初期設定フラグ. 
   147:                                           ! Initialization flag
   148:             
   149:               real(DP):: Kappa            ! $ \kappa = R/C_p $ .
   150:                                           ! 気体定数の定圧比熱に対する比. Ratio of gas constant to specific heat
   151:               real(DP):: P0               ! $ p_0 $ .
   152:               real(DP):: DelTempY         ! $ (\Delta T)_y $ .
   153:                                           ! 極と赤道の温度差
   154:               real(DP):: DelPotTempZ      ! $ (\Delta \theta)_z $ .
   155:                                           ! 赤道における鉛直方向の温位差
   156:               real(DP), allocatable:: z_kv (:)
   157:                                           ! $ k_v $ .
   158:               real(DP), allocatable:: yz_kt (:,:)
   159:                                           ! $ k_T $ .
   160:             
   161:               character(*), parameter:: module_name = 'held_suarez_1994'
   162:                                           ! モジュールの名称. 
   163:                                           ! Module name
   164:               character(*), parameter:: version = &
   165:                 & '$Name:  $' // &
   166:                 & '$Id: held_suarez_1994.f90,v 1.14 2012/04/27 11:24:45 noda Exp $'
   167:                                           ! モジュールのバージョン
   168:                                           ! Module version
   169:             
   170:             contains
   171:             
   172:               !--------------------------------------------------------------------------------------
   173:             
   174:               subroutine HS94Forcing( &
   175:                 & xyz_U,    xyz_V,    xyz_Temp, xy_Ps, & ! (in)
   176:                 & xyz_DUDt, xyz_DVDt, xyz_DTempDt &      ! (out)
   177:                 & )
   178:                 !
   179:                 ! 引数として与えられた東西風速 xyz_U, 南北風速 xyz_V, 
   180:                 ! 温度 xyz_Temp から, 
   181:                 ! 温度場の帯状対称場への簡単なニュートン冷却と
   182:                 ! 境界層摩擦を表現する下層風のレイリー摩擦による
   183:                 ! 風速と温度の変化率を求め, 
   184:                 ! xyz_DUDt, xyz_DVDt, xyz_DTempDt に返します. 
   185:                 !
   186:                 ! Tendencies by simple Newtonian relaxation of the temperature field to a
   187:                 ! zonally symmetric state and Rayleigh damping of low-level winds to
   188:                 ! represent boundary-layer friction are calculated 
   189:                 ! from eastward wind "xyz_U", northward wind "xyz_V", 
   190:                 ! temperature "xyz_Temp".
   191:                 ! And the tencencies are returned as 
   192:                 ! "xyz_DUDt", "xyz_DVDt", "xyz_DTempDt". 
   193:                 !
   194:                 !
   195:             
   196:                 ! モジュール引用 ; USE statements
   197:                 !
   198:             
   199:                 ! 座標データ設定
   200:                 ! Axes data settings
   201:                 !
   202:                 use axesset, only: &
   203:                   & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   204:                   & z_Sigma               ! $ \sigma $ レベル (整数). 
   205:                                           ! Full $ \sigma $ level
   206:             
   207:                 ! 時刻管理
   208:                 ! Time control
   209:                 !
   210:                 use timeset, only: &
   211:                   & DelTime, &            ! $ \Delta t $
   212:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   213:                   & TimesetClockStart, TimesetClockStop
   214:             
   215:                 ! ヒストリデータ出力
   216:                 ! History data output
   217:                 !
   218:                 use gtool_historyauto, only: HistoryAutoPut
   219:             
   220:                 ! 宣言文 ; Declaration statements
   221:                 !
   222:                 implicit none
   223:             
   224:                 real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   225:                                           ! $ u $ . 東西風速. 
   226:                                           ! Eastward wind
   227:                 real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   228:                                           ! $ v $ . 南北風速. 
   229:                                           ! Northward wind
   230:                 real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   231:                                           ! $ T $ . 温度. 
   232:                                           ! Temperature
   233:                 real(DP), intent(in):: xy_Ps (0:imax-1, 1:jmax)
   234:                                           ! $ p_s $ . 地表面気圧. 
   235:                                           ! Surface pressure
   236:                 real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   237:                                           ! $ \DP{u}{t} $ . 東西風速変化. 
   238:                                           ! Eastward wind tendency
   239:                 real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   240:                                           ! $ \DP{v}{t} $ . 南北風速変化. 
   241:                                           ! Northward wind tendency
   242:                 real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   243:                                           ! $ \DP{T}{t} $ . 温度変化. 
   244:                                           ! Temperature tendency
   245:             
   246:                 ! 作業変数
   247:                 ! Work variables
   248:                 !
   249:                 real(DP):: xyz_TempEQ (0:imax-1, 1:jmax, 1:kmax)
   250:                                           ! $ T_{eq} $ . 平衡温度. 
   251:                                           ! Equilibrium temperature
   252:                 real(DP):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   253:                                           ! $ T $ . 圧力. 
   254:                                           ! Pressure
   255:             
   256:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   257:                                           ! Work variables for DO loop in latitude
   258:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   259:                                           ! Work variables for DO loop in vertical direction
   260:             
   261:                 ! 実行文 ; Executable statement
   262:                 !
   263:             
   264:                 ! 初期化確認
   265:                 ! Initialization check
   266:                 !
   267:                 if ( .not. held_suarez_1994_inited ) then
   268:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   269:                 end if
   270:             
   271:                 ! 計算時間計測開始
   272:                 ! Start measurement of computation time
   273:                 !
   274:                 call TimesetClockStart( module_name )
   275:             
   276:             
   277:                 ! 東西風速 $ u $ と南北風速 $ v $ へレイリー摩擦を適用
   278:                 ! Apply Rayleigh damping to eastward wind $ u $ and northward wind $ v $
   279:                 !
   280: +------>        do k = 1, kmax
   281: |*W---->A         xyz_DUDt (:,:,k) = - z_kv (k) * xyz_U (:,:,k)
   282: |*----- A         xyz_DVDt (:,:,k) = - z_kv (k) * xyz_V (:,:,k)
   283: |               end do
   284: |           
   285: |               ! 温度 $ T $ へニュートン冷却を適用
   286: |               ! Apply Newtonian relaxation to temperature $ T $
   287: |               !
   288: |               do k = 1, kmax
   289: |*=====            xyz_Press(:,:,k) = z_Sigma(k) * xy_Ps
   290: +------         enddo
   291:             
   292: +------>        do j = 1, jmax
   293: |+V==== A         xyz_TempEQ(:,j,:) = &
   294: |                   & max( 200.0_DP, &
   295: |                   &      (   315.0_DP &
   296: |                   &        - DelTempY * sin( y_Lat(j) ) ** 2 &
   297: |                   &        - DelPotTempZ * log( xyz_Press(:,j,:) / P0 ) &
   298: |                   &                                 * cos( y_Lat(j) ) ** 2 &
   299: |                   &      ) &
   300: |                   &      * ( xyz_Press(:,j,:) / P0 ) ** Kappa &
   301: |                   &     )
   302: +------         end do
   303:             
   304: +------>        do k = 1, kmax
   305: |+----->          do j = 1, jmax
   306: ||V==== A           xyz_DTempDt (:,j,k) = &
   307: |||                   & - yz_kt (j,k) * ( xyz_Temp (:,j,k) - xyz_TempEQ (:,j,k) )
   308: |+-----           end do
   309: +------         end do
   310:             
   311:             
   312:                 ! ヒストリデータ出力
   313:                 ! History data output
   314:                 !
   315:                 call HistoryAutoPut( TimeN, 'DUDtHS94',    xyz_DUDt )
   316:                 call HistoryAutoPut( TimeN, 'DVDtHS94',    xyz_DVDt )
   317:                 call HistoryAutoPut( TimeN, 'DTempDtHS94', xyz_DTempDt )
   318:                 call HistoryAutoPut( TimeN, 'TempEQHS94',  xyz_TempEQ )
   319:             
   320:             
   321:                 ! 計算時間計測一時停止
   322:                 ! Pause measurement of computation time
   323:                 !
   324:                 call TimesetClockStop( module_name )
   325:             
   326:               end subroutine HS94Forcing
   327:             
   328:               !--------------------------------------------------------------------------------------
   329:             
   330:               subroutine HS94Init
   331:                 !
   332:                 ! held_suarez_1994 モジュールの初期化を行います. 
   333:                 ! NAMELIST#held_suarez_1994_nml の読み込みはこの手続きで行われます. 
   334:                 !
   335:                 ! "held_suarez_1994" module is initialized. 
   336:                 ! "NAMELIST#held_suarez_1994_nml" is loaded in this procedure. 
   337:                 !
   338:             
   339:                 ! モジュール引用 ; USE statements
   340:                 !
   341:             
   342:                 ! 物理定数設定
   343:                 ! Physical constants settings
   344:                 !
   345:                 use constants, only: &
   346:                   & GasRDry, &
   347:                                           ! $ R $ [J kg-1 K-1]. 
   348:                                           ! 乾燥大気の気体定数. 
   349:                                           ! Gas constant of air
   350:                   & CpDry
   351:                                           ! $ C_p $ [J kg-1 K-1]. 
   352:                                           ! 乾燥大気の定圧比熱. 
   353:                                           ! Specific heat of air at constant pressure
   354:             
   355:                 ! 座標データ設定
   356:                 ! Axes data settings
   357:                 !
   358:                 use axesset, only: &
   359:                   & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   360:                   & z_Sigma               ! $ \sigma $ レベル (整数). 
   361:                                           ! Full $ \sigma $ level
   362:             
   363:                 ! NAMELIST ファイル入力に関するユーティリティ
   364:                 ! Utilities for NAMELIST file input
   365:                 !
   366:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   367:             
   368:                 ! ファイル入出力補助
   369:                 ! File I/O support
   370:                 !
   371:                 use dc_iounit, only: FileOpen
   372:             
   373:                 ! 種別型パラメタ
   374:                 ! Kind type parameter
   375:                 !
   376:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   377:             
   378:                 ! 文字列操作
   379:                 ! Character handling
   380:                 !
   381:                 use dc_string, only: StoA
   382:             
   383:                 ! ヒストリデータ出力
   384:                 ! History data output
   385:                 !
   386:                 use gtool_historyauto, only: HistoryAutoAddVariable
   387:             
   388:                 ! 宣言文 ; Declaration statements
   389:                 !
   390:                 implicit none
   391:             
   392:                 real(DP), parameter :: day_seconds = 86400.0_DP
   393:                                           ! 1 日の秒数. 
   394:                                           ! Seconds in day. 
   395:                 real(DP):: SigmaB         ! $ \sigma_b $ .
   396:                                           ! 境界層上端の高度
   397:                 real(DP):: kf             ! $ k_f $ .
   398:                                           ! 地表面での Rayleigh 摩擦の緩和係数
   399:                 real(DP):: ka             ! $ k_a $ .
   400:                                           ! 大気上層における Newton 冷却の緩和係数
   401:                 real(DP):: ks             ! $ k_s $ .
   402:                                           ! 赤道地表面における Newton 冷却の緩和係数
   403:             
   404:                 real(DP):: kfTimeScaleInDay
   405:                 real(DP):: kaTimeScaleInDay
   406:                 real(DP):: ksTimeScaleInDay
   407:             
   408:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   409:                                           ! Work variables for DO loop in latitude
   410:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   411:                                           ! Work variables for DO loop in vertical direction
   412:             
   413:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   414:                                           ! Unit number for NAMELIST file open
   415:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   416:                                           ! IOSTAT of NAMELIST read
   417:             
   418:                 ! NAMELIST 変数群
   419:                 ! NAMELIST group name
   420:                 !
   421:                 namelist /held_suarez_1994_nml/ &
   422:                   & SigmaB, &
   423:                   & kfTimeScaleInDay, &
   424:                   & kaTimeScaleInDay, &
   425:                   & ksTimeScaleInDay
   426:                       !
   427:                       ! デフォルト値については初期化手続 "held_suarez_1994#HS94Init" 
   428:                       ! のソースコードを参照のこと. 
   429:                       !
   430:                       ! Refer to source codes in the initialization procedure
   431:                       ! "held_suarez_1994#HS94Init" for the default values. 
   432:                       !
   433:             
   434:                 ! 実行文 ; Executable statement
   435:                 !
   436:             
   437:                 if ( held_suarez_1994_inited ) return
   438:             
   439:             
   440:                 ! デフォルト値の設定
   441:                 ! Default values settings
   442:                 !
   443:                 SigmaB           =  0.7_DP
   444:                 kfTimeScaleInDay =  1.0_DP
   445:                 kaTimeScaleInDay = 40.0_DP
   446:                 ksTimeScaleInDay =  4.0_DP
   447:             
   448:                 ! NAMELIST の読み込み
   449:                 ! NAMELIST is input
   450:                 !
   451:                 if ( trim(namelist_filename) /= '' ) then
   452:                   call FileOpen( unit_nml, &          ! (out)
   453:                     & namelist_filename, mode = 'r' ) ! (in)
   454:             
   455:                   rewind( unit_nml )
   456:                   read( unit_nml, &                ! (in)
   457:                     & nml = held_suarez_1994_nml, &  ! (out)
   458:                     & iostat = iostat_nml )        ! (out)
   459:                   close( unit_nml )
   460:             
   461:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   462:             !$      if ( iostat_nml == 0 ) write( STDOUT, nml = held_suarez_1994_nml )
   463:                 end if
   464:             
   465:                 ! 係数の設定
   466:                 ! Configure coefficients
   467:                 !
   468:                 Kappa = GasRDry / CpDry
   469:             
   470:                 P0          = 1000.0e2_DP
   471:                 DelTempY    = 60.0_DP
   472:                 DelPotTempZ = 10.0_DP
   473:             
   474:             !!$    kf     = 1.0_DP / day_seconds
   475:             !!$    ka     = 1.0_DP / ( 40.0_DP * day_seconds )
   476:             !!$    ks     = 1.0_DP / (  4.0_DP * day_seconds )
   477:                 kf     = 1.0_DP / ( kfTimeScaleInDay * day_seconds )
   478:                 ka     = 1.0_DP / ( kaTimeScaleInDay * day_seconds )
   479:                 ks     = 1.0_DP / ( ksTimeScaleInDay * day_seconds )
   480:             
   481:                 allocate( z_kv (1:kmax) )
   482: V====== A       z_kv = kf * max( 0.0_DP, &
   483:                   &              ( z_Sigma - SigmaB ) / ( 1.0_DP - SigmaB ) )
   484:             
   485:                 allocate( yz_kt (1:jmax, 1:kmax) )
   486:             
   487: +------>A       do k = 1, kmax
   488: |V----->A         do j = 1, jmax
   489: |||     A           yz_kt(j,k) = &
   490: |||                   & ka + ( ks - ka ) &
   491: |||                   &  * max( 0.0_DP, &
   492: |||                   &         ( z_Sigma(k) - SigmaB ) / ( 1.0_DP - SigmaB ) &
   493: |||                   &       ) * cos( y_Lat(j) ) ** 4
   494: |V-----           end do
   495: +------         end do
   496:             
   497:             
   498:                 ! ヒストリデータ出力のためのへの変数登録
   499:                 ! Register of variables for history data output
   500:                 !
   501:                 call HistoryAutoAddVariable( 'DUDtHS94', &
   502:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   503:                   & 'eastward wind tendency', 'm s-2' )
   504:                 call HistoryAutoAddVariable( 'DVDtHS94', &
   505:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   506:                   & 'northward wind tendency', 'm s-2' )
   507:                 call HistoryAutoAddVariable( 'DTempDtHS94', &
   508:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   509:                   & 'temperature tendency', 'K s-1' )
   510:                 call HistoryAutoAddVariable( 'TempEQHS94', &
   511:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   512:                   & 'equilibrium temperature', 'K' )
   513:             
   514:                 ! 印字 ; Print
   515:                 !
   516:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   517:                 call MessageNotify( 'M', module_name, 'SigmaB           = %f', d = (/ SigmaB /) )
   518:                 call MessageNotify( 'M', module_name, 'kfTimeScaleInDay = %f', d = (/ kfTimeScaleInDay /) )
   519:                 call MessageNotify( 'M', module_name, 'kaTimeScaleInDay = %f', d = (/ kaTimeScaleInDay /) )
   520:                 call MessageNotify( 'M', module_name, 'ksTimeScaleInDay = %f', d = (/ ksTimeScaleInDay /) )
   521:             
   522:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   523:             
   524:                 held_suarez_1994_inited = .true.
   525:             
   526:               end subroutine HS94Init
   527:             
   528:               !--------------------------------------------------------------------------------------
   529:             
   530:               subroutine HS94Finalize
   531:                 !
   532:                 ! モジュール内部の変数の割り付け解除を行います. 
   533:                 !
   534:                 ! Deallocate variables in this module. 
   535:                 !
   536:             
   537:                 ! 宣言文 ; Declaration statements
   538:                 !
   539:                 implicit none
   540:             
   541:                 ! 実行文 ; Executable statement
   542:                 !
   543:             
   544:                 if ( .not. held_suarez_1994_inited ) return
   545:             
   546:                 ! 割り付け解除
   547:                 ! Deallocation
   548:                 !
   549:                 if ( allocated( z_kv  ) ) deallocate( z_kv  )
   550:                 if ( allocated( yz_kt ) ) deallocate( yz_kt )
   551:             
   552:                 held_suarez_1994_inited = .false.
   553:             
   554:               end subroutine HS94Finalize
   555:             
   556:               !--------------------------------------------------------------------------------------
   557:             
   558:             end module held_suarez_1994
