Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:47 2016
FILE NAME: sl09_diffusion.f90
PROGRAM NAME: sl09_diffusion
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   227  opt  (  11): Fused array assignments. :line 227 - 228
   227  opt  (1592): Outer loop unrolled inside inner loop.
   227  vec  (   4): Vectorized array expression.
   227  vec  (  29): ADB is used for array.: xyz_dvdt
   227  vec  (  29): ADB is used for array.: xyz_v
   227  vec  (  29): ADB is used for array.: xyz_dudt
   227  vec  (  29): ADB is used for array.: xyz_u
   227  vec  (  29): ADB is used for array.: xyz_kv
   227  vec  (   4): Vectorized array expression.
   227  vec  (  29): ADB is used for array.: xyz_dvdt
   227  vec  (  29): ADB is used for array.: xyz_v
   227  vec  (  29): ADB is used for array.: xyz_dudt
   227  vec  (  29): ADB is used for array.: xyz_u
   227  vec  (  29): ADB is used for array.: xyz_kv
   233  opt  (1593): Loop nest collapsed into one loop.
   233  vec  (   4): Vectorized array expression.
   233  vec  (  29): ADB is used for array.: xyr_heatflux
   234  opt  (1593): Loop nest collapsed into one loop.
   234  vec  (   4): Vectorized array expression.
   234  vec  (  29): ADB is used for array.: xyr_heatflux
   238  opt  (1593): Loop nest collapsed into one loop.
   238  vec  (   4): Vectorized array expression.
   238  vec  (  29): ADB is used for array.: xyrf_qmixflux
   241  opt  (  11): Fused array assignments. :line 241 - 245
   241  opt  (1593): Loop nest collapsed into one loop.
   241  vec  (   4): Vectorized array expression.
   241  vec  (  29): ADB is used for array.: xyrf_qmixflux
   241  vec  (  29): ADB is used for array.: xyzf_qmix
   241  vec  (  29): ADB is used for array.: xy_surfheight
   241  vec  (  29): ADB is used for array.: xyz_height
   241  vec  (  29): ADB is used for array.: xyr_virtemp
   241  vec  (  29): ADB is used for array.: xyr_press
   277  opt  (1592): Outer loop unrolled inside inner loop.
   277  vec  (   4): Vectorized array expression.
   277  vec  (  29): ADB is used for array.: xyz_dtempdt
   277  vec  (  29): ADB is used for array.: xyz_v
   277  vec  (  29): ADB is used for array.: xyz_dvdt
   277  vec  (  29): ADB is used for array.: xyz_u
   277  vec  (  29): ADB is used for array.: xyz_dudt
   277  vec  (   4): Vectorized array expression.
   277  vec  (  29): ADB is used for array.: xyz_dtempdt
   277  vec  (  29): ADB is used for array.: xyz_v
   277  vec  (  29): ADB is used for array.: xyz_dvdt
   277  vec  (  29): ADB is used for array.: xyz_u
   277  vec  (  29): ADB is used for array.: xyz_dudt
   454  vec  (   3): Unvectorized loop.
   454  vec  (  13): Overhead of loop division is too large.
   456  vec  (   4): Vectorized array expression.
   456  vec  (  29): ADB is used for array.: xyz_kv
   458  vec  (   4): Vectorized array expression.
   458  vec  (  29): ADB is used for array.: xyz_kv
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:47 2016
FILE NAME: sl09_diffusion.f90
PROGRAM NAME: sl09_diffusion
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Schneider and Liu (2009) による鉛直混合課程
     2  !
     3  != Vertical diffusion by Schneider and Liu (2009)
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: sl09_diffusion.f90,v 1.8 2013/09/16 12:20:02 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module sl09_diffusion
    13    !
    14    != Schneider and Liu (2009) による鉛直混合課程
    15    !
    16    != Vertical diffusion by Schneider and Liu (2009)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !== Procedures List
    22    !
    23  !!$  ! Hs94Forcing   :: 強制と散逸の計算
    24  !!$  ! Hs94Finalize  :: 終了処理 (モジュール内部の変数の割り付け解除)
    25  !!$  ! ------------  :: ------------
    26  !!$  ! Hs94Forcing   :: Calculate forcing and dissipation
    27  !!$  ! Hs94Finalize  :: Termination (deallocate variables in this module)
    28    !
    29    !--
    30    !== NAMELIST
    31    !
    32    ! NAMELIST#sl09_diffusion_nml
    33    !++
    34    !== References
    35    !
    36    !  Schneider, T. and J. Liu,
    37    !    Formation of jets and equatorial superrotation on Jupiter,
    38    !    J. Atmos. Sci., 69, 579, 2009.
    39    !
    40  
    41    ! モジュール引用 ; USE statements
    42    !
    43  
    44    ! 格子点設定
    45    ! Grid points settings
    46    !
    47    use gridset, only: imax, & ! 経度格子点数.
    48                               ! Number of grid points in longitude
    49      &                jmax, & ! 緯度格子点数.
    50                               ! Number of grid points in latitude
    51      &                kmax    ! 鉛直層数.
    52                               ! Number of vertical level
    53  
    54    ! 組成に関わる配列の設定
    55    ! Settings of array for atmospheric composition
    56    !
    57    use composition, only: &
    58      &                    ncmax, &
    59                                ! 成分の数
    60                                ! Number of composition
    61      &                    IndexH2OVap
    62  
    63    ! 種別型パラメタ
    64    ! Kind type parameter
    65    !
    66    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    67      &                 STRING     ! 文字列.       Strings.
    68  
    69  
    70    ! メッセージ出力
    71    ! Message output
    72    !
    73    use dc_message, only: MessageNotify
    74  
    75    ! 宣言文 ; Declaration statements
    76    !
    77    implicit none
    78    private
    79  
    80    ! 公開手続き
    81    ! Public procedure
    82    !
    83    public:: SL09Diffusion, SL09DiffusionInit
    84  
    85    ! 公開変数
    86    ! Public variables
    87    !
    88    logical, save, public:: sl09_diffusion_inited = .false.
    89                                ! 初期設定フラグ.
    90                                ! Initialization flag
    91  
    92    ! 非公開変数
    93    ! Private variables
    94    !
    95    real(DP), save, allocatable :: xyz_kv (:,:,:)
    96                                ! $ k_v $ .
    97    real(DP), save              :: LBHeatFlux
    98  
    99    real(DP), save              :: SurfQMixDiffCoef
   100    real(DP), save              :: SurfQVap
   101  
   102  
   103    character(*), parameter:: module_name = 'sl09_diffusion'
   104                                ! モジュールの名称.
   105                                ! Module name
   106    character(*), parameter:: version = &
   107      & '$Name:  $' // &
   108      & '$Id: sl09_diffusion.f90,v 1.8 2013/09/16 12:20:02 yot Exp $'
   109                                ! モジュールのバージョン
   110                                ! Module version
   111  
   112  contains
   113  
   114    subroutine SL09Diffusion(                            &
   115      & xy_SurfHeight, xyz_Height,                       &
   116      & xyz_U, xyz_V, xyzf_QMix, xyr_Press, xyr_VirTemp, & ! (in)
   117      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt    & ! (out)
   118      & )
   119      !
   120      !
   121      !
   122  
   123      ! モジュール引用 ; USE statements
   124      !
   125  
   126      ! 座標データ設定
   127      ! Axes data settings
   128      !
   129      use axesset, only: &
   130        & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   131        & z_Sigma               ! $ \sigma $ レベル (整数).
   132                                ! Full $ \sigma $ level
   133  
   134      ! 時刻管理
   135      ! Time control
   136      !
   137      use timeset, only: &
   138        & DelTime, &            ! $ \Delta t $
   139        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   140        & TimesetClockStart, TimesetClockStop
   141  
   142      ! ヒストリデータ出力
   143      ! History data output
   144      !
   145      use gtool_historyauto, only: HistoryAutoPut
   146  
   147      ! 物理定数設定
   148      ! Physical constants settings
   149      !
   150      use constants, only: &
   151        & GasRDry, &
   152                                ! $ R $ [J kg-1 K-1].
   153                                ! 乾燥大気の気体定数.
   154                                ! Gas constant of air
   155        &                  CpDry    ! $ C_p $ [J kg-1 K-1].
   156                                    ! 乾燥大気の定圧比熱.
   157                                    ! Specific heat of air at constant pressure
   158  
   159      ! 鉛直拡散フラックス
   160      ! Vertical diffusion flux
   161      !
   162      use vdiffusion_my, only: VDiffusionExpTendency
   163  
   164      ! 宣言文 ; Declaration statements
   165      !
   166      implicit none
   167  
   168      real(DP), intent(in):: xy_SurfHeight(0:imax-1, 1:jmax)
   169      real(DP), intent(in):: xyz_Height   (0:imax-1, 1:jmax, 1:kmax)
   170      real(DP), intent(in):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   171                                ! $ u $ . 東西風速.
   172                                ! Eastward wind
   173      real(DP), intent(in):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   174                                ! $ v $ . 南北風速.
   175                                ! Northward wind
   176      real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   177      real(DP), intent(in):: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
   178                                ! $ p_s $ . 地表面気圧.
   179                                ! Surface pressure
   180      real(DP), intent(in):: xyr_VirTemp  (0:imax-1, 1:jmax, 0:kmax)
   181      real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   182                                ! $ \DP{u}{t} $ . 東西風速変化.
   183                                ! Eastward wind tendency
   184      real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   185                                ! $ \DP{v}{t} $ . 南北風速変化.
   186                                ! Northward wind tendency
   187      real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   188                                ! $ \DP{T}{t} $ . 温度変化.
   189                                ! Temperature tendency
   190      real(DP), intent(out):: xyzf_DQMixDt (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   191  
   192      ! 作業変数
   193      ! Work variables
   194      !
   195      real(DP) :: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   196                                ! 熱フラックス.
   197                                ! Heat flux
   198      real(DP) :: xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   199  
   200      real(DP) :: xy_SurfQMixTransCoef(0:imax-1, 1:jmax)
   201  
   202  !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   203  !!$                              ! Work variables for DO loop in latitude
   204      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   205                                ! Work variables for DO loop in vertical direction
   206      integer:: n
   207  
   208  
   209      ! 実行文 ; Executable statement
   210      !
   211  
   212      ! 初期化
   213      ! Initialization
   214      !
   215      if ( .not. sl09_diffusion_inited ) then
   216        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   217      end if
   218  
   219      ! 計算時間計測開始
   220      ! Start measurement of computation time
   221      !
   222      call TimesetClockStart( module_name )
   223  
   224      ! 東西風速 $ u $ と南北風速 $ v $ へレイリー摩擦を適用
   225      ! Apply Rayleigh damping to eastward wind $ u $ and northward wind $ v $
   226      !
   227      xyz_DUDt = - xyz_kv * xyz_U
     .        if (xyz_kv.DSC.U2 + 1 - xyz_kv.DSC.L2 .gt. 0) then                
     .           j1 = and(xyz_kv.DSC.U2 + 1 - xyz_kv.DSC.L2,3)                  
     .  !cdir    nodep                                                          
     .           do t298 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t300 = 1, xyz_kv.DSC.U1 + 1 - xyz_kv.DSC.L1              
     .                 xyz_dudt(t300-1,t298,t296+1) = -xyz_kv(xyz_kv.DSC.L1+t300
     .       1            -1,t298-1+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_u(t300
     .       2            -1,t298,t296+1)                                       
     .                 xyz_dvdt(t300-1,t298,t296+1) = -xyz_kv(xyz_kv.DSC.L1+t300
     .       1            -1,t298-1+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_v(t300
     .       2            -1,t298,t296+1)                                       
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t298 = j1 + 1, xyz_kv.DSC.U2 + 1 - xyz_kv.DSC.L2, 4         
     .  !cdir       nodep                                                       
     .              do t300 = 1, xyz_kv.DSC.U1 + 1 - xyz_kv.DSC.L1              
     .                 xyz_dudt(t300-1,t298,t296+1) = -xyz_kv(xyz_kv.DSC.L1+t300
     .       1            -1,t298-1+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_u(t300
     .       2            -1,t298,t296+1)                                       
     .                 xyz_dudt(t300-1,t298+1,t296+1) = -xyz_kv(xyz_kv.DSC.L1+  
     .       1            t300-1,t298+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_u(  
     .       2            t300-1,t298+1,t296+1)                                 
     .                 xyz_dudt(t300-1,t298+2,t296+1) = -xyz_kv(xyz_kv.DSC.L1+  
     .       1            t300-1,t298+1+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_u(
     .       2            t300-1,t298+2,t296+1)                                 
     .                 xyz_dudt(t300-1,t298+3,t296+1) = -xyz_kv(xyz_kv.DSC.L1+  
     .       1            t300-1,t298+2+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_u(
     .       2            t300-1,t298+3,t296+1)                                 
     .                 xyz_dvdt(t300-1,t298,t296+1) = -xyz_kv(xyz_kv.DSC.L1+t300
     .       1            -1,t298-1+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_v(t300
     .       2            -1,t298,t296+1)                                       
     .                 xyz_dvdt(t300-1,t298+1,t296+1) = -xyz_kv(xyz_kv.DSC.L1+  
     .       1            t300-1,t298+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_v(  
     .       2            t300-1,t298+1,t296+1)                                 
     .                 xyz_dvdt(t300-1,t298+2,t296+1) = -xyz_kv(xyz_kv.DSC.L1+  
     .       1            t300-1,t298+1+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_v(
     .       2            t300-1,t298+2,t296+1)                                 
     .                 xyz_dvdt(t300-1,t298+3,t296+1) = -xyz_kv(xyz_kv.DSC.L1+  
     .       1            t300-1,t298+2+xyz_kv.DSC.L2,t296+xyz_kv.DSC.L3)*xyz_v(
     .       2            t300-1,t298+3,t296+1)                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   228      xyz_DVDt = - xyz_kv * xyz_V
   229  
   230  
   231      ! Set heat flux at the lower boundary
   232      !
   233      xyr_HeatFlux(:,:,0     ) = LBHeatFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t320 = 1, xyr_heatflux.DSC.U2*xyr_heatflux.DSC.U1 +            
     .       1   xyr_heatflux.DSC.U2                                            
     .           xyr_heatflux(t320-1,1,0) = lbheatflux                          
     .        enddo                                                             
   234      xyr_HeatFlux(:,:,1:kmax) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t326 = 1, kmax*(xyr_heatflux.DSC.U2*xyr_heatflux.DSC.U1 +      
     .       1   xyr_heatflux.DSC.U2)                                           
     .           xyr_heatflux(t326-1,1,1) = 0.0000000000000000e+000             
     .        enddo                                                             
   235  
   236      ! Set moisture flux at the lower boundary
   237      !
   238      xyrf_QMixFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t335 = 1, xyrf_qmixflux.DSC.U4*(xyrf_qmixflux.DSC.U3 + 1)*     
     .       1   xyrf_qmixflux.DSC.U2*(xyrf_qmixflux.DSC.U1 + 1)                
     .           xyrf_qmixflux(t335-1,1,0,1) = 0.0000000000000000e+000          
     .        enddo                                                             
   239      n = IndexH2OVap
   240      k = 0
   241      xy_SurfQMixTransCoef =                                    &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t347 = 1, jmax*imax                                            
     .           xy_surfqmixtranscoef1 = surfqmixdiffcoef*xyr_press(t347-1,1,0)/
     .       1      (gasrdry*xyr_virtemp(t347-1,1,0)*(xyz_height(t347-1,1,1)-   
     .       2      xy_surfheight(t347-1,1)))                                   
     .           xyrf_qmixflux(t347-1,1,0,n) = -xy_surfqmixtranscoef1*(xyzf_qmix
     .       1      (t347-1,1,1,n)-surfqvap)                                    
     .        enddo                                                             
   242        &   SurfQMixDiffCoef                                    &
   243        & * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   244        & / ( xyz_Height(:,:,k+1) - xy_SurfHeight )
   245      xyrf_QMixFlux(:,:,k,n) =   &
   246        & - xy_SurfQMixTransCoef &
   247        &   * ( xyzf_QMix(:,:,k+1,n) - SurfQVap )
   248  
   249  
   250  
   251      ! 時間変化率の計算を行います.
   252      ! Calculate tendencies.
   253      !
   254      call VDiffusionExpTendency(        &
   255        & xyr_Press,                     & ! (in )
   256        & xyr_HeatFlux  = xyr_HeatFlux,  & ! (in ) optional
   257        & xyrf_QMixFlux = xyrf_QMixFlux, & ! (in ) optional
   258        & xyz_DTempDt  = xyz_DTempDt,    & ! (out) optional
   259        & xyzf_DQMixDt = xyzf_DQMixDt    & ! (out) optional
   260        & )
   261  
   262  
   263      ! This is commented out (yot, 2013/05/12) to be consistent with SL09.
   264      ! Temporarily, xyzf_DQMixDt is overwritten.
   265  !!$    xyzf_DQMixDt = 0.0_DP
   266  !!$    k = 1
   267  !!$    n = IndexH2OVap
   268  !!$    xyzf_DQMixDt(:,:,k,n) = ( SurfQVap - xyzf_QMix(:,:,k,n) ) &
   269  !!$      & / ( 2.0_DP * DelTime )
   270  !!$    xyzf_DQMixDt(:,:,k,n) = ( SurfQVap - xyzf_QMix(:,:,k,n) ) &
   271  !!$      & / ( 2.0_DP * DelTime )
   272  
   273  
   274      !
   275      ! Add heating due to MHD drag dissipation
   276      !
   277      xyz_DTempDt = xyz_DTempDt &
     .        if (xyz_dtempdt.DSC.U2 .gt. 0) then                               
     .           j2 = and(xyz_dtempdt.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t369 = 1, j2                                                
     .              d2 = 1.D0/cpdry                                             
     .  !cdir       nodep                                                       
     .              do t371 = 1, xyz_dtempdt.DSC.U1 + 1                         
     .                 xyz_dtempdt(t371-1,t369,t367+1) = xyz_dtempdt(t371-1,t369
     .       1            ,t367+1) - (xyz_dudt(t371-1,t369,t367+1)*xyz_u(t371-1,
     .       2            t369,t367+1)+xyz_dvdt(t371-1,t369,t367+1)*xyz_v(t371-1
     .       3            ,t369,t367+1))*d2                                     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t369 = j2 + 1, xyz_dtempdt.DSC.U2, 4                        
     .              d3 = 1.D0/cpdry                                             
     .              d4 = 1.D0/cpdry                                             
     .              d5 = 1.D0/cpdry                                             
     .              d6 = 1.D0/cpdry                                             
     .  !cdir       nodep                                                       
     .              do t371 = 1, xyz_dtempdt.DSC.U1 + 1                         
     .                 xyz_dtempdt(t371-1,t369,t367+1) = xyz_dtempdt(t371-1,t369
     .       1            ,t367+1) - (xyz_dudt(t371-1,t369,t367+1)*xyz_u(t371-1,
     .       2            t369,t367+1)+xyz_dvdt(t371-1,t369,t367+1)*xyz_v(t371-1
     .       3            ,t369,t367+1))*d3                                     
     .                 xyz_dtempdt(t371-1,t369+1,t367+1) = xyz_dtempdt(t371-1,  
     .       1            t369+1,t367+1) - (xyz_dudt(t371-1,t369+1,t367+1)*xyz_u
     .       2            (t371-1,t369+1,t367+1)+xyz_dvdt(t371-1,t369+1,t367+1)*
     .       3            xyz_v(t371-1,t369+1,t367+1))*d4                       
     .                 xyz_dtempdt(t371-1,t369+2,t367+1) = xyz_dtempdt(t371-1,  
     .       1            t369+2,t367+1) - (xyz_dudt(t371-1,t369+2,t367+1)*xyz_u
     .       2            (t371-1,t369+2,t367+1)+xyz_dvdt(t371-1,t369+2,t367+1)*
     .       3            xyz_v(t371-1,t369+2,t367+1))*d5                       
     .                 xyz_dtempdt(t371-1,t369+3,t367+1) = xyz_dtempdt(t371-1,  
     .       1            t369+3,t367+1) - (xyz_dudt(t371-1,t369+3,t367+1)*xyz_u
     .       2            (t371-1,t369+3,t367+1)+xyz_dvdt(t371-1,t369+3,t367+1)*
     .       3            xyz_v(t371-1,t369+3,t367+1))*d6                       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   278        & - ( xyz_DUDt * xyz_U + xyz_DVDt * xyz_V ) / CpDry
   279  
   280  
   281      ! ヒストリデータ出力
   282      ! History data output
   283      !
   284      call HistoryAutoPut( TimeN, 'DUDtVDiffSL09',    xyz_DUDt    )
   285      call HistoryAutoPut( TimeN, 'DVDtVDiffSL09',    xyz_DVDt    )
   286      call HistoryAutoPut( TimeN, 'DTempDtVDiffSL09', xyz_DTempDt )
   287  
   288  
   289      ! 計算時間計測一時停止
   290      ! Pause measurement of computation time
   291      !
   292      call TimesetClockStop( module_name )
   293  
   294    end subroutine SL09Diffusion
   295  
   296    !-------------------------------------------------------------------
   297  
   298    subroutine SL09DiffusionInit
   299      !
   300      ! sl09_diffusion モジュールの初期化を行います.
   301      ! NAMELIST#sl09_diffusion_nml の読み込みはこの手続きで行われます.
   302      !
   303      ! "sl09_diffusion" module is initialized.
   304      ! "NAMELIST#sl09_diffusion_nml" is loaded in this procedure.
   305      !
   306  
   307      ! モジュール引用 ; USE statements
   308      !
   309  
   310      ! 物理・数学定数設定
   311      ! Physical and mathematical constants settings
   312      !
   313      use constants0, only: &
   314        & PI
   315                                ! $ \pi $ .
   316                                ! 円周率.  Circular constant
   317  
   318      ! 物理定数設定
   319      ! Physical constants settings
   320      !
   321      use constants, only: &
   322        & GasRDry, &
   323                                ! $ R $ [J kg-1 K-1].
   324                                ! 乾燥大気の気体定数.
   325                                ! Gas constant of air
   326        & CpDry
   327                                ! $ C_p $ [J kg-1 K-1].
   328                                ! 乾燥大気の定圧比熱.
   329                                ! Specific heat of air at constant pressure
   330  
   331      ! 座標データ設定
   332      ! Axes data settings
   333      !
   334      use axesset, only: &
   335        & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   336        & z_Sigma               ! $ \sigma $ レベル (整数).
   337                                ! Full $ \sigma $ level
   338  
   339      ! NAMELIST ファイル入力に関するユーティリティ
   340      ! Utilities for NAMELIST file input
   341      !
   342      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   343  
   344      ! ファイル入出力補助
   345      ! File I/O support
   346      !
   347      use dc_iounit, only: FileOpen
   348  
   349      ! 種別型パラメタ
   350      ! Kind type parameter
   351      !
   352      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   353  
   354      ! 文字列操作
   355      ! Character handling
   356      !
   357      use dc_string, only: StoA
   358  
   359      ! ヒストリデータ出力
   360      ! History data output
   361      !
   362      use gtool_historyauto, only: HistoryAutoAddVariable
   363  
   364      ! 鉛直拡散フラックス
   365      ! Vertical diffusion flux
   366      !
   367      use vdiffusion_my, only: VDiffusionInit
   368  
   369  
   370      ! 宣言文 ; Declaration statements
   371      !
   372      implicit none
   373  
   374      real(DP), parameter :: day_seconds = 86400.0_DP
   375                                ! 1 日の秒数.
   376                                ! Seconds in day.
   377      real(DP):: SigmaB         ! $ \sigma_b $ .
   378      real(DP):: kf             ! $ k_f $ .
   379  
   380      real(DP):: kfTimeScaleInDay
   381      real(DP):: FrictionLBLat
   382  
   383      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   384                                ! Work variables for DO loop in latitude
   385      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   386                                ! Work variables for DO loop in vertical direction
   387  
   388      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   389                                ! Unit number for NAMELIST file open
   390      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   391                                ! IOSTAT of NAMELIST read
   392  
   393      ! NAMELIST 変数群
   394      ! NAMELIST group name
   395      !
   396      namelist /sl09_diffusion_nml/ &
   397        & SigmaB,                   &
   398        & kfTimeScaleInDay,         &
   399        & FrictionLBLat,            &
   400        & LBHeatFlux,               &
   401        & SurfQMixDiffCoef,         &
   402        & SurfQVap
   403  
   404            !
   405            ! デフォルト値については初期化手続 "sl09_diffusion#SL09DiffusionInit"
   406            ! のソースコードを参照のこと.
   407            !
   408            ! Refer to source codes in the initialization procedure
   409            ! "sl09_diffusion#SL09DiffusionInit" for the default values.
   410            !
   411  
   412      ! 実行文 ; Executable statement
   413      !
   414  
   415      if ( sl09_diffusion_inited ) return
   416  
   417      ! デフォルト値の設定
   418      ! Default values settings
   419      !
   420      SigmaB           =  0.8_DP
   421      kfTimeScaleInDay = 20.0_DP
   422      FrictionLBLat    = 16.3_DP
   423      LBHeatFlux       =  5.7_DP
   424      SurfQMixDiffCoef =  0.0_DP
   425  !!$    SurfQMixDiffCoef = 800.0d2    ! Sugiyama et al. (2009) Nagare Multimedia
   426      SurfQVap         =  0.0_DP
   427  !!$    SurfQVap         = 7.816d-4   ! Sugiyama et al. (2009) Nagare Multimedia
   428  
   429  
   430      ! NAMELIST の読み込み
   431      ! NAMELIST is input
   432      !
   433      if ( trim(namelist_filename) /= '' ) then
   434        call FileOpen( unit_nml, &          ! (out)
   435          & namelist_filename, mode = 'r' ) ! (in)
   436  
   437        rewind( unit_nml )
   438        read( unit_nml, &                       ! (in)
   439          & nml = sl09_diffusion_nml, &         ! (out)
   440          & iostat = iostat_nml )               ! (out)
   441        close( unit_nml )
   442  
   443        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   444  !!$      if ( iostat_nml == 0 ) write( STDOUT, nml = held_suarez_1994_nml )
   445      end if
   446  
   447      ! 係数の設定
   448      ! Configure coefficients
   449      !
   450      kf     = 1.0_DP / ( kfTimeScaleInDay * day_seconds )
   451  
   452      allocate( xyz_kv (0:imax-1, 1:jmax, 1:kmax) )
   453      do k = 1, kmax
   454        do j = 1, jmax
   455          if ( abs( y_Lat(j) ) * 180.0_DP / PI <= FrictionLBLat ) then
   456            xyz_kv(:,j,k) = 0.0_DP
   457          else
   458            xyz_kv(:,j,k) = kf &
   459              & * max( 0.0_DP, ( z_Sigma(k) - SigmaB ) / ( 1.0_DP - SigmaB ) )
   460          end if
   461        end do
   462      end do
   463  
   464  
   465      ! 鉛直拡散フラックス (Mellor and Yamada, 1974, レベル 2)
   466      ! Vertical diffusion flux (Mellor and Yamada, 1974, Level 2)
   467      !
   468      call VDiffusionInit
   469  
   470  
   471      ! ヒストリデータ出力のためのへの変数登録
   472      ! Register of variables for history data output
   473      !
   474      call HistoryAutoAddVariable( 'DUDtVDiffSL09', &
   475        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   476        & 'eastward wind tendency', 'm s-2' )
   477      call HistoryAutoAddVariable( 'DVDtVDiffSL09', &
   478        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   479        & 'northward wind tendency', 'm s-2' )
   480      call HistoryAutoAddVariable( 'DTempDtVDiffSL09', &
   481        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   482        & 'temperature tendency', 'K s-1' )
   483  
   484      ! 印字 ; Print
   485      !
   486      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   487      call MessageNotify( 'M', module_name, 'SigmaB           = %f', d = (/ SigmaB /) )
   488      call MessageNotify( 'M', module_name, 'kfTimeScaleInDay = %f', d = (/ kfTimeScaleInDay /) )
   489      call MessageNotify( 'M', module_name, 'FrictionLBLat    = %f', d = (/ FrictionLBLat /) )
   490      call MessageNotify( 'M', module_name, 'LBHeatFlux       = %f', d = (/ LBHeatFlux /) )
   491      call MessageNotify( 'M', module_name, 'SurfQMixDiffCoef = %f', d = (/ SurfQMixDiffCoef /) )
   492      call MessageNotify( 'M', module_name, 'SurfQVap         = %f', d = (/ SurfQVap /) )
   493      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   494  
   495      sl09_diffusion_inited = .true.
   496    end subroutine SL09DiffusionInit
   497  
   498    !-------------------------------------------------------------------
   499  
   500  end module sl09_diffusion
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:47 2016
FILE NAME: sl09_diffusion.f90
PROGRAM NAME: sl09_diffusion
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Schneider and Liu (2009) による鉛直混合課程
     2:             !
     3:             != Vertical diffusion by Schneider and Liu (2009)
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: sl09_diffusion.f90,v 1.8 2013/09/16 12:20:02 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module sl09_diffusion
    13:               !
    14:               != Schneider and Liu (2009) による鉛直混合課程
    15:               !
    16:               != Vertical diffusion by Schneider and Liu (2009)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !
    21:               !== Procedures List
    22:               ! 
    23:             !!$  ! Hs94Forcing   :: 強制と散逸の計算
    24:             !!$  ! Hs94Finalize  :: 終了処理 (モジュール内部の変数の割り付け解除)
    25:             !!$  ! ------------  :: ------------
    26:             !!$  ! Hs94Forcing   :: Calculate forcing and dissipation
    27:             !!$  ! Hs94Finalize  :: Termination (deallocate variables in this module)
    28:               !
    29:               !--
    30:               !== NAMELIST
    31:               !
    32:               ! NAMELIST#sl09_diffusion_nml
    33:               !++
    34:               !== References
    35:               !
    36:               !  Schneider, T. and J. Liu, 
    37:               !    Formation of jets and equatorial superrotation on Jupiter, 
    38:               !    J. Atmos. Sci., 69, 579, 2009.
    39:               !
    40:             
    41:               ! モジュール引用 ; USE statements
    42:               !
    43:             
    44:               ! 格子点設定
    45:               ! Grid points settings
    46:               !
    47:               use gridset, only: imax, & ! 経度格子点数. 
    48:                                          ! Number of grid points in longitude
    49:                 &                jmax, & ! 緯度格子点数. 
    50:                                          ! Number of grid points in latitude
    51:                 &                kmax    ! 鉛直層数. 
    52:                                          ! Number of vertical level
    53:             
    54:               ! 組成に関わる配列の設定
    55:               ! Settings of array for atmospheric composition
    56:               !
    57:               use composition, only: &
    58:                 &                    ncmax, &
    59:                                           ! 成分の数
    60:                                           ! Number of composition
    61:                 &                    IndexH2OVap
    62:             
    63:               ! 種別型パラメタ
    64:               ! Kind type parameter
    65:               !
    66:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    67:                 &                 STRING     ! 文字列.       Strings. 
    68:             
    69:             
    70:               ! メッセージ出力
    71:               ! Message output
    72:               !
    73:               use dc_message, only: MessageNotify
    74:             
    75:               ! 宣言文 ; Declaration statements
    76:               !
    77:               implicit none
    78:               private
    79:             
    80:               ! 公開手続き
    81:               ! Public procedure
    82:               !
    83:               public:: SL09Diffusion, SL09DiffusionInit 
    84:             
    85:               ! 公開変数
    86:               ! Public variables
    87:               !
    88:               logical, save, public:: sl09_diffusion_inited = .false.
    89:                                           ! 初期設定フラグ. 
    90:                                           ! Initialization flag
    91:             
    92:               ! 非公開変数
    93:               ! Private variables
    94:               !
    95:               real(DP), save, allocatable :: xyz_kv (:,:,:)
    96:                                           ! $ k_v $ .
    97:               real(DP), save              :: LBHeatFlux
    98:             
    99:               real(DP), save              :: SurfQMixDiffCoef
   100:               real(DP), save              :: SurfQVap
   101:             
   102:             
   103:               character(*), parameter:: module_name = 'sl09_diffusion'
   104:                                           ! モジュールの名称. 
   105:                                           ! Module name
   106:               character(*), parameter:: version = &
   107:                 & '$Name:  $' // &
   108:                 & '$Id: sl09_diffusion.f90,v 1.8 2013/09/16 12:20:02 yot Exp $'
   109:                                           ! モジュールのバージョン
   110:                                           ! Module version
   111:             
   112:             contains
   113:             
   114:               subroutine SL09Diffusion(                            &
   115:                 & xy_SurfHeight, xyz_Height,                       &
   116:                 & xyz_U, xyz_V, xyzf_QMix, xyr_Press, xyr_VirTemp, & ! (in)
   117:                 & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt    & ! (out)
   118:                 & )
   119:                 !
   120:                 !
   121:                 !
   122:             
   123:                 ! モジュール引用 ; USE statements
   124:                 !
   125:             
   126:                 ! 座標データ設定
   127:                 ! Axes data settings
   128:                 !
   129:                 use axesset, only: &
   130:                   & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   131:                   & z_Sigma               ! $ \sigma $ レベル (整数). 
   132:                                           ! Full $ \sigma $ level
   133:             
   134:                 ! 時刻管理
   135:                 ! Time control
   136:                 !
   137:                 use timeset, only: &
   138:                   & DelTime, &            ! $ \Delta t $
   139:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   140:                   & TimesetClockStart, TimesetClockStop
   141:             
   142:                 ! ヒストリデータ出力
   143:                 ! History data output
   144:                 !
   145:                 use gtool_historyauto, only: HistoryAutoPut
   146:             
   147:                 ! 物理定数設定
   148:                 ! Physical constants settings
   149:                 !
   150:                 use constants, only: &
   151:                   & GasRDry, &
   152:                                           ! $ R $ [J kg-1 K-1]. 
   153:                                           ! 乾燥大気の気体定数. 
   154:                                           ! Gas constant of air
   155:                   &                  CpDry    ! $ C_p $ [J kg-1 K-1].
   156:                                               ! 乾燥大気の定圧比熱.
   157:                                               ! Specific heat of air at constant pressure
   158:             
   159:                 ! 鉛直拡散フラックス
   160:                 ! Vertical diffusion flux
   161:                 !
   162:                 use vdiffusion_my, only: VDiffusionExpTendency
   163:             
   164:                 ! 宣言文 ; Declaration statements
   165:                 !
   166:                 implicit none
   167:             
   168:                 real(DP), intent(in):: xy_SurfHeight(0:imax-1, 1:jmax)
   169:                 real(DP), intent(in):: xyz_Height   (0:imax-1, 1:jmax, 1:kmax)
   170:                 real(DP), intent(in):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   171:                                           ! $ u $ . 東西風速. 
   172:                                           ! Eastward wind
   173:                 real(DP), intent(in):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   174:                                           ! $ v $ . 南北風速. 
   175:                                           ! Northward wind
   176:                 real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   177:                 real(DP), intent(in):: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
   178:                                           ! $ p_s $ . 地表面気圧. 
   179:                                           ! Surface pressure
   180:                 real(DP), intent(in):: xyr_VirTemp  (0:imax-1, 1:jmax, 0:kmax)
   181:                 real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   182:                                           ! $ \DP{u}{t} $ . 東西風速変化. 
   183:                                           ! Eastward wind tendency
   184:                 real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   185:                                           ! $ \DP{v}{t} $ . 南北風速変化. 
   186:                                           ! Northward wind tendency
   187:                 real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   188:                                           ! $ \DP{T}{t} $ . 温度変化. 
   189:                                           ! Temperature tendency
   190:                 real(DP), intent(out):: xyzf_DQMixDt (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   191:             
   192:                 ! 作業変数
   193:                 ! Work variables
   194:                 !
   195:                 real(DP) :: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   196:                                           ! 熱フラックス. 
   197:                                           ! Heat flux
   198:                 real(DP) :: xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   199:             
   200:                 real(DP) :: xy_SurfQMixTransCoef(0:imax-1, 1:jmax)
   201:             
   202:             !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   203:             !!$                              ! Work variables for DO loop in latitude
   204:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   205:                                           ! Work variables for DO loop in vertical direction
   206:                 integer:: n
   207:             
   208:             
   209:                 ! 実行文 ; Executable statement
   210:                 !
   211:             
   212:                 ! 初期化
   213:                 ! Initialization
   214:                 !
   215:                 if ( .not. sl09_diffusion_inited ) then
   216:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   217:                 end if
   218:             
   219:                 ! 計算時間計測開始
   220:                 ! Start measurement of computation time
   221:                 !
   222:                 call TimesetClockStart( module_name )
   223:             
   224:                 ! 東西風速 $ u $ と南北風速 $ v $ へレイリー摩擦を適用
   225:                 ! Apply Rayleigh damping to eastward wind $ u $ and northward wind $ v $
   226:                 !
   227: **V---->A       xyz_DUDt = - xyz_kv * xyz_U
   228: **V---- A       xyz_DVDt = - xyz_kv * xyz_V
   229:             
   230:             
   231:                 ! Set heat flux at the lower boundary
   232:                 !
   233: W*===== A       xyr_HeatFlux(:,:,0     ) = LBHeatFlux
   234: W**==== A       xyr_HeatFlux(:,:,1:kmax) = 0.0_DP
   235:             
   236:                 ! Set moisture flux at the lower boundary
   237:                 !
   238: W***=== A       xyrf_QMixFlux = 0.0_DP
   239:                 n = IndexH2OVap
   240:                 k = 0
   241: *W----->A       xy_SurfQMixTransCoef =                                    &
   242: ||                &   SurfQMixDiffCoef                                    &
   243: ||                & * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   244: ||                & / ( xyz_Height(:,:,k+1) - xy_SurfHeight )
   245: *W----- A       xyrf_QMixFlux(:,:,k,n) =   &
   246:                   & - xy_SurfQMixTransCoef &
   247:                   &   * ( xyzf_QMix(:,:,k+1,n) - SurfQVap )
   248:             
   249:             
   250:             
   251:                 ! 時間変化率の計算を行います.
   252:                 ! Calculate tendencies.
   253:                 !
   254:                 call VDiffusionExpTendency(        &
   255:                   & xyr_Press,                     & ! (in )
   256:                   & xyr_HeatFlux  = xyr_HeatFlux,  & ! (in ) optional
   257:                   & xyrf_QMixFlux = xyrf_QMixFlux, & ! (in ) optional
   258:                   & xyz_DTempDt  = xyz_DTempDt,    & ! (out) optional
   259:                   & xyzf_DQMixDt = xyzf_DQMixDt    & ! (out) optional
   260:                   & )
   261:             
   262:             
   263:                 ! This is commented out (yot, 2013/05/12) to be consistent with SL09.
   264:                 ! Temporarily, xyzf_DQMixDt is overwritten.
   265:             !!$    xyzf_DQMixDt = 0.0_DP
   266:             !!$    k = 1
   267:             !!$    n = IndexH2OVap
   268:             !!$    xyzf_DQMixDt(:,:,k,n) = ( SurfQVap - xyzf_QMix(:,:,k,n) ) &
   269:             !!$      & / ( 2.0_DP * DelTime )
   270:             !!$    xyzf_DQMixDt(:,:,k,n) = ( SurfQVap - xyzf_QMix(:,:,k,n) ) &
   271:             !!$      & / ( 2.0_DP * DelTime )
   272:             
   273:             
   274:                 !
   275:                 ! Add heating due to MHD drag dissipation
   276:                 !
   277: ++V==== A       xyz_DTempDt = xyz_DTempDt &
   278:                   & - ( xyz_DUDt * xyz_U + xyz_DVDt * xyz_V ) / CpDry
   279:             
   280:             
   281:                 ! ヒストリデータ出力
   282:                 ! History data output
   283:                 !
   284:                 call HistoryAutoPut( TimeN, 'DUDtVDiffSL09',    xyz_DUDt    )
   285:                 call HistoryAutoPut( TimeN, 'DVDtVDiffSL09',    xyz_DVDt    )
   286:                 call HistoryAutoPut( TimeN, 'DTempDtVDiffSL09', xyz_DTempDt )
   287:             
   288:             
   289:                 ! 計算時間計測一時停止
   290:                 ! Pause measurement of computation time
   291:                 !
   292:                 call TimesetClockStop( module_name )
   293:             
   294:               end subroutine SL09Diffusion
   295:             
   296:               !-------------------------------------------------------------------
   297:             
   298:               subroutine SL09DiffusionInit
   299:                 !
   300:                 ! sl09_diffusion モジュールの初期化を行います. 
   301:                 ! NAMELIST#sl09_diffusion_nml の読み込みはこの手続きで行われます. 
   302:                 !
   303:                 ! "sl09_diffusion" module is initialized. 
   304:                 ! "NAMELIST#sl09_diffusion_nml" is loaded in this procedure. 
   305:                 !
   306:             
   307:                 ! モジュール引用 ; USE statements
   308:                 !
   309:             
   310:                 ! 物理・数学定数設定
   311:                 ! Physical and mathematical constants settings
   312:                 !
   313:                 use constants0, only: &
   314:                   & PI
   315:                                           ! $ \pi $ .
   316:                                           ! 円周率.  Circular constant
   317:             
   318:                 ! 物理定数設定
   319:                 ! Physical constants settings
   320:                 !
   321:                 use constants, only: &
   322:                   & GasRDry, &
   323:                                           ! $ R $ [J kg-1 K-1]. 
   324:                                           ! 乾燥大気の気体定数. 
   325:                                           ! Gas constant of air
   326:                   & CpDry
   327:                                           ! $ C_p $ [J kg-1 K-1]. 
   328:                                           ! 乾燥大気の定圧比熱. 
   329:                                           ! Specific heat of air at constant pressure
   330:             
   331:                 ! 座標データ設定
   332:                 ! Axes data settings
   333:                 !
   334:                 use axesset, only: &
   335:                   & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   336:                   & z_Sigma               ! $ \sigma $ レベル (整数). 
   337:                                           ! Full $ \sigma $ level
   338:             
   339:                 ! NAMELIST ファイル入力に関するユーティリティ
   340:                 ! Utilities for NAMELIST file input
   341:                 !
   342:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   343:             
   344:                 ! ファイル入出力補助
   345:                 ! File I/O support
   346:                 !
   347:                 use dc_iounit, only: FileOpen
   348:             
   349:                 ! 種別型パラメタ
   350:                 ! Kind type parameter
   351:                 !
   352:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   353:             
   354:                 ! 文字列操作
   355:                 ! Character handling
   356:                 !
   357:                 use dc_string, only: StoA
   358:             
   359:                 ! ヒストリデータ出力
   360:                 ! History data output
   361:                 !
   362:                 use gtool_historyauto, only: HistoryAutoAddVariable
   363:             
   364:                 ! 鉛直拡散フラックス
   365:                 ! Vertical diffusion flux
   366:                 !
   367:                 use vdiffusion_my, only: VDiffusionInit
   368:             
   369:             
   370:                 ! 宣言文 ; Declaration statements
   371:                 !
   372:                 implicit none
   373:             
   374:                 real(DP), parameter :: day_seconds = 86400.0_DP
   375:                                           ! 1 日の秒数. 
   376:                                           ! Seconds in day. 
   377:                 real(DP):: SigmaB         ! $ \sigma_b $ .
   378:                 real(DP):: kf             ! $ k_f $ .
   379:             
   380:                 real(DP):: kfTimeScaleInDay
   381:                 real(DP):: FrictionLBLat
   382:             
   383:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   384:                                           ! Work variables for DO loop in latitude
   385:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   386:                                           ! Work variables for DO loop in vertical direction
   387:             
   388:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   389:                                           ! Unit number for NAMELIST file open
   390:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   391:                                           ! IOSTAT of NAMELIST read
   392:             
   393:                 ! NAMELIST 変数群
   394:                 ! NAMELIST group name
   395:                 !
   396:                 namelist /sl09_diffusion_nml/ &
   397:                   & SigmaB,                   &
   398:                   & kfTimeScaleInDay,         &
   399:                   & FrictionLBLat,            &
   400:                   & LBHeatFlux,               &
   401:                   & SurfQMixDiffCoef,         &
   402:                   & SurfQVap
   403:             
   404:                       !
   405:                       ! デフォルト値については初期化手続 "sl09_diffusion#SL09DiffusionInit" 
   406:                       ! のソースコードを参照のこと. 
   407:                       !
   408:                       ! Refer to source codes in the initialization procedure
   409:                       ! "sl09_diffusion#SL09DiffusionInit" for the default values. 
   410:                       !
   411:             
   412:                 ! 実行文 ; Executable statement
   413:                 !
   414:             
   415:                 if ( sl09_diffusion_inited ) return
   416:             
   417:                 ! デフォルト値の設定
   418:                 ! Default values settings
   419:                 !
   420:                 SigmaB           =  0.8_DP
   421:                 kfTimeScaleInDay = 20.0_DP
   422:                 FrictionLBLat    = 16.3_DP
   423:                 LBHeatFlux       =  5.7_DP
   424:                 SurfQMixDiffCoef =  0.0_DP
   425:             !!$    SurfQMixDiffCoef = 800.0d2    ! Sugiyama et al. (2009) Nagare Multimedia
   426:                 SurfQVap         =  0.0_DP
   427:             !!$    SurfQVap         = 7.816d-4   ! Sugiyama et al. (2009) Nagare Multimedia
   428:             
   429:             
   430:                 ! NAMELIST の読み込み
   431:                 ! NAMELIST is input
   432:                 !
   433:                 if ( trim(namelist_filename) /= '' ) then
   434:                   call FileOpen( unit_nml, &          ! (out)
   435:                     & namelist_filename, mode = 'r' ) ! (in)
   436:             
   437:                   rewind( unit_nml )
   438:                   read( unit_nml, &                       ! (in)
   439:                     & nml = sl09_diffusion_nml, &         ! (out)
   440:                     & iostat = iostat_nml )               ! (out)
   441:                   close( unit_nml )
   442:             
   443:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   444:             !!$      if ( iostat_nml == 0 ) write( STDOUT, nml = held_suarez_1994_nml )
   445:                 end if
   446:             
   447:                 ! 係数の設定
   448:                 ! Configure coefficients
   449:                 !
   450:                 kf     = 1.0_DP / ( kfTimeScaleInDay * day_seconds )
   451:             
   452:                 allocate( xyz_kv (0:imax-1, 1:jmax, 1:kmax) )
   453: +------>        do k = 1, kmax
   454: |+----->          do j = 1, jmax
   455: ||                  if ( abs( y_Lat(j) ) * 180.0_DP / PI <= FrictionLBLat ) then
   456: ||V==== A             xyz_kv(:,j,k) = 0.0_DP
   457: ||                  else
   458: ||V==== A             xyz_kv(:,j,k) = kf &
   459: ||                      & * max( 0.0_DP, ( z_Sigma(k) - SigmaB ) / ( 1.0_DP - SigmaB ) )
   460: ||                  end if
   461: |+-----           end do
   462: +------         end do
   463:             
   464:             
   465:                 ! 鉛直拡散フラックス (Mellor and Yamada, 1974, レベル 2)
   466:                 ! Vertical diffusion flux (Mellor and Yamada, 1974, Level 2)
   467:                 !
   468:                 call VDiffusionInit
   469:             
   470:             
   471:                 ! ヒストリデータ出力のためのへの変数登録
   472:                 ! Register of variables for history data output
   473:                 !
   474:                 call HistoryAutoAddVariable( 'DUDtVDiffSL09', &
   475:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   476:                   & 'eastward wind tendency', 'm s-2' )
   477:                 call HistoryAutoAddVariable( 'DVDtVDiffSL09', &
   478:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   479:                   & 'northward wind tendency', 'm s-2' )
   480:                 call HistoryAutoAddVariable( 'DTempDtVDiffSL09', &
   481:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   482:                   & 'temperature tendency', 'K s-1' )
   483:             
   484:                 ! 印字 ; Print
   485:                 !
   486:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   487:                 call MessageNotify( 'M', module_name, 'SigmaB           = %f', d = (/ SigmaB /) )
   488:                 call MessageNotify( 'M', module_name, 'kfTimeScaleInDay = %f', d = (/ kfTimeScaleInDay /) )
   489:                 call MessageNotify( 'M', module_name, 'FrictionLBLat    = %f', d = (/ FrictionLBLat /) )
   490:                 call MessageNotify( 'M', module_name, 'LBHeatFlux       = %f', d = (/ LBHeatFlux /) )
   491:                 call MessageNotify( 'M', module_name, 'SurfQMixDiffCoef = %f', d = (/ SurfQMixDiffCoef /) )
   492:                 call MessageNotify( 'M', module_name, 'SurfQVap         = %f', d = (/ SurfQVap /) )
   493:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   494:             
   495:                 sl09_diffusion_inited = .true.
   496:               end subroutine SL09DiffusionInit
   497:             
   498:               !-------------------------------------------------------------------
   499:             
   500:             end module sl09_diffusion
