Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:47 2016
FILE NAME: yt2003_forcing.f90
PROGRAM NAME: yt2003_forcing
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   203  opt  (1593): Loop nest collapsed into one loop.
   203  vec  (   4): Vectorized array expression.
   203  vec  (  29): ADB is used for array.: xyzf_qmix
   222  opt  (  11): Fused array assignments. :line 222 - 225
   222  opt  (1593): Loop nest collapsed into one loop.
   222  vec  (   4): Vectorized array expression.
   222  vec  (  29): ADB is used for array.: xyz_dtempdt
   222  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   222  vec  (  29): ADB is used for array.: xyz_dtempdtradl
   222  vec  (  29): ADB is used for array.: xyz_dtempdtsfcfric
   222  vec  (  29): ADB is used for array.: xyz_dtempdtvdiff
   222  vec  (  29): ADB is used for array.: xyz_dvdt
   222  vec  (  29): ADB is used for array.: xyz_dvdtsfcfric
   222  vec  (  29): ADB is used for array.: xyz_dvdtvdiff
   222  vec  (  29): ADB is used for array.: xyz_dudt
   222  vec  (  29): ADB is used for array.: xyz_dudtsfcfric
   222  vec  (  29): ADB is used for array.: xyz_dudtvdiff
   310  vec  (   4): Vectorized array expression.
   310  vec  (  29): ADB is used for array.: y_coslat
   310  vec  (  29): ADB is used for array.: y_lat
   322  opt  (  11): Fused array assignments. :line 322 - 327
   322  vec  (   4): Vectorized array expression.
   322  vec  (  29): ADB is used for array.: xyz_dtempdtradl
   322  vec  (  29): ADB is used for array.: xyz_tempeq
   322  vec  (  29): ADB is used for array.: xyz_temp
   322  vec  (  29): ADB is used for array.: xyz_ncc
   372  opt  (1592): Outer loop unrolled inside inner loop.
   372  vec  (   4): Vectorized array expression.
   372  vec  (  29): ADB is used for array.: xyz_equivtempeq
   372  vec  (  29): ADB is used for array.: xyz_ncc
   372  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   372  vec  (  29): ADB is used for array.: xyz_tempeq
   372  vec  (   4): Vectorized array expression.
   372  vec  (  29): ADB is used for array.: xyz_equivtempeq
   372  vec  (  29): ADB is used for array.: xyz_ncc
   372  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   372  vec  (  29): ADB is used for array.: xyz_tempeq
   384  opt  (1593): Loop nest collapsed into one loop.
   384  vec  (   4): Vectorized array expression.
   384  vec  (  29): ADB is used for array.: xyz_equivtempeq
   387  vec  (   3): Unvectorized loop.
   387  vec  (  13): Overhead of loop division is too large.
   388  opt  (1037): Feedback of array elements.
   388  opt  (1593): Loop nest collapsed into one loop.
   388  vec  (   4): Vectorized array expression.
   388  vec  (  29): ADB is used for array.: xyz_equivtempeq
   394  opt  (1592): Outer loop unrolled inside inner loop.
   394  vec  (   3): Unvectorized loop.
   394  vec  (  13): Overhead of loop division is too large.
   394  vec  (   3): Unvectorized loop.
   394  vec  (  13): Overhead of loop division is too large.
   405  vec  (   4): Vectorized array expression.
   405  vec  (  29): ADB is used for array.: xyz_ubalance
   405  vec  (   4): Vectorized array expression.
   405  vec  (  29): ADB is used for array.: xyz_ubalance
   503  opt  (1592): Outer loop unrolled inside inner loop.
   503  vec  (   4): Vectorized array expression.
   503  vec  (  29): ADB is used for array.: xyz_ncc
   503  vec  (   4): Vectorized array expression.
   503  vec  (  29): ADB is used for array.: xyz_ncc
   509  vec  (   3): Unvectorized loop.
   509  vec  (  13): Overhead of loop division is too large.
   510  opt  (1593): Loop nest collapsed into one loop.
   510  vec  (   4): Vectorized array expression.
   510  vec  (  29): ADB is used for array.: xy_ps
   510  vec  (  29): ADB is used for array.: xyz_press
   512  opt  (1593): Loop nest collapsed into one loop.
   512  vec  (   1): Vectorized loop.
   532  opt  (1593): Loop nest collapsed into one loop.
   532  vec  (   1): Vectorized loop.
   532  vec  (  29): ADB is used for array.: xyz_ncc
   607  vec  (   4): Vectorized array expression.
   607  vec  (  26): Macro operation Sum/InnerProd.
   607  vec  (  29): ADB is used for array.: y_lat_weight
   607  vec  (  29): ADB is used for array.: y_coslat
   607  vec  (   4): Vectorized array expression.
   607  vec  (  26): Macro operation Sum/InnerProd.
   607  vec  (  29): ADB is used for array.: y_lat_weight
   611  opt  (1592): Outer loop unrolled inside inner loop.
   611  vec  (   3): Unvectorized loop.
   611  vec  (  13): Overhead of loop division is too large.
   611  vec  (   3): Unvectorized loop.
   611  vec  (  13): Overhead of loop division is too large.
   612  vec  (   4): Vectorized array expression.
   612  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   612  vec  (   4): Vectorized array expression.
   612  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   676  opt  (  11): Fused array assignments. :line 676 - 677
   676  opt  (1593): Loop nest collapsed into one loop.
   676  vec  (   4): Vectorized array expression.
   676  vec  (  29): ADB is used for array.: xyz_dvdt
   676  vec  (  29): ADB is used for array.: xyz_dudt
   679  opt  (  11): Fused array assignments. :line 679 - 680
   679  opt  (1593): Loop nest collapsed into one loop.
   679  vec  (   4): Vectorized array expression.
   679  vec  (  29): ADB is used for array.: xyz_dvdt
   679  vec  (  29): ADB is used for array.: xyz_vb
   679  vec  (  29): ADB is used for array.: xyz_dudt
   679  vec  (  29): ADB is used for array.: xyz_ub
   683  opt  (1593): Loop nest collapsed into one loop.
   683  vec  (   4): Vectorized array expression.
   683  vec  (  29): ADB is used for array.: xyz_dtempdt
   690  opt  (1593): Loop nest collapsed into one loop.
   690  vec  (   4): Vectorized array expression.
   690  vec  (  29): ADB is used for array.: xyz_dtempdt
   690  vec  (  29): ADB is used for array.: xyz_tempb
   693  warn (  82): Name "temp" is not used.
   693  warn (  82): Name "height" is not used.
   740  vec  (   1): Vectorized loop.
   740  vec  (  29): ADB is used for array.: a_yt2003temp
   740  vec  (  29): ADB is used for array.: a_yt2003heightfort
   799  vec  (   1): Vectorized loop.
   799  vec  (  29): ADB is used for array.: a_yt2003q
   799  vec  (  29): ADB is used for array.: a_yt2003heightforq
  1141  opt  (1593): Loop nest collapsed into one loop.
  1141  vec  (   4): Vectorized array expression.
  1141  vec  (  29): ADB is used for array.: xyz_tempeq
  1141  vec  (  29): ADB is used for array.: xyz_height
  1143  vec  (   3): Unvectorized loop.
  1143  vec  (  13): Overhead of loop division is too large.
  1145  opt  (  11): Fused array assignments. :line 1145 - 1148
  1145  opt  (1593): Loop nest collapsed into one loop.
  1145  vec  (   4): Vectorized array expression.
  1145  vec  (  29): ADB is used for array.: xyz_tempeq
  1145  vec  (  29): ADB is used for array.: xyz_height
  1235  opt  (1593): Loop nest collapsed into one loop.
  1235  vec  (   4): Vectorized array expression.
  1235  vec  (  29): ADB is used for array.: xyz_dtempdtrads
  1235  vec  (  29): ADB is used for array.: xyz_press
  1239  opt  (1772): Loop nest fused with following nest(s).
  1241  vec  (   1): Vectorized loop.
  1241  vec  (  29): ADB is used for array.: xyz_dtempdtrads
  1241  vec  (  29): ADB is used for array.: xyz_press
  1321  warn (  83): Dummy argument "xyz_height" is not used.
  1321  warn (  82): Name "dtempdtradsmax" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:47 2016
FILE NAME: yt2003_forcing.f90
PROGRAM NAME: yt2003_forcing
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Yamamoto and Takahashi (2003) に従った簡単金星計算のための強制
     2  !
     3  != forcing for simple Venus calculation following Yamamoto and Takahashi (2003)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi (code by Shin-ichi Takehiro is included)
     6  ! Version::   $Id: yt2003_forcing.f90,v 1.7 2014/05/07 09:39:18 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module yt2003_forcing
    13    !
    14    != Yamamoto and Takahashi (2003) に従った簡単金星計算のための強制
    15    !
    16    != forcing for simple Venus calculation following Yamamoto and Takahashi (2003)
    17  
    18    !== Procedures List
    19    !
    20  !!$  ! Hs94Forcing   :: 強制と散逸の計算
    21  !!$  ! Hs94Finalize  :: 終了処理 (モジュール内部の変数の割り付け解除)
    22  !!$  ! ------------  :: ------------
    23  !!$  ! Hs94Forcing   :: Calculate forcing and dissipation
    24  !!$  ! Hs94Finalize  :: Termination (deallocate variables in this module)
    25    !
    26    !--
    27    !== NAMELIST
    28    !
    29    ! NAMELIST#venus_simple_forcing_nml
    30    !++
    31    !== References
    32    !
    33    ! * Yamamoto, M, and M. Takahashi, 2003:
    34    !   The Fully Developed Superrotation Simulated by a General Circulation Model
    35    !   of a Venus-like Atmosphere,
    36    !   <i>J. Atmos. Sci.</i>, <b>60</b>, 561--574.
    37    ! * Hou, A. Y., and B. F. Farrell, 1987:
    38    !   Superrotation Induced by Critical-Level Absorption of Gravity Waves on Venus:
    39    !   An Assessment,
    40    !   <i>J. Atmos. Sci.</i>, <b>44</b>, 1049--1061.
    41    !
    42  
    43    ! モジュール引用 ; USE statements
    44    !
    45  
    46    ! 種別型パラメタ
    47    ! Kind type parameter
    48    !
    49    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    50      &                 STRING     ! 文字列.       Strings.
    51  
    52    ! メッセージ出力
    53    ! Message output
    54    !
    55    use dc_message, only: MessageNotify
    56  
    57    ! 宣言文 ; Declaration statements
    58    !
    59    implicit none
    60    private
    61  
    62    real(DP), parameter :: DayEarth = 86400.0d0
    63  
    64    real(DP), save      :: SurfFrictionTimeConstInEarthDay
    65    logical , save      :: FlagConstNCC
    66    real(DP), save      :: ConstNCCInEarthDay
    67  
    68  
    69    real(DP), save :: a_YT2003Temp      (0:25)
    70    real(DP), save :: a_YT2003HeightForT(0:25)
    71    real(DP), save :: a_YT2003Q         (0:20)
    72    real(DP), save :: a_YT2003HeightForQ(0:20)
    73  
    74    ! 公開手続き
    75    ! Public procedure
    76    !
    77    public :: YT2003Forcing
    78    public :: YT2003ForcingInit
    79  
    80    ! 公開変数
    81    ! Public variables
    82    !
    83  
    84    ! 非公開変数
    85    ! Private variables
    86    !
    87    logical, save :: venus_simple_forcing_inited = .false.
    88                                ! 初期設定フラグ.
    89                                ! Initialization flag
    90  
    91    character(*), parameter:: module_name = 'venus_simple_forcing_1994'
    92                                ! モジュールの名称.
    93                                ! Module name
    94    character(*), parameter:: version = &
    95      & '$Name:  $' // &
    96      & '$Id: yt2003_forcing.f90,v 1.7 2014/05/07 09:39:18 murashin Exp $'
    97                                ! モジュールのバージョン
    98                                ! Module version
    99  
   100    !--------------------------------------------------------------------------------------
   101  
   102  contains
   103  
   104    subroutine YT2003Forcing(                                &
   105      & xy_SurfHeight,                                       & ! (in )
   106      & xyz_UB, xyz_VB, xyz_TempB, xyz_VirTemp, xyr_VirTemp, & ! (in )
   107      & xy_PsB, xyz_Press, xyr_Press, xyr_Temp,              & ! (in )
   108      & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,        & ! (in )
   109      & xyz_DUDt, xyz_DVDt, xyz_DTempDt                      & ! (out)
   110      & )
   111  
   112      ! モジュール引用 ; USE statements
   113      !
   114  
   115      ! 格子点設定
   116      ! Grid points settings
   117      !
   118      use gridset, only: imax, & ! 経度格子点数.
   119                                 ! Number of grid points in longitude
   120        &                jmax, & ! 緯度格子点数.
   121                                 ! Number of grid points in latitude
   122        &                kmax    ! 鉛直層数.
   123                                 ! Number of vertical level
   124  
   125      ! 組成に関わる配列の設定
   126      ! Settings of array for atmospheric composition
   127      !
   128      use composition, only: &
   129        &                    ncmax
   130                                ! 成分の数
   131                                ! Number of composition
   132  
   133      ! 鉛直拡散フラックス
   134      ! Vertical diffusion flux
   135      !
   136      use vdiffusion_my, only: VDiffusion, VDiffusionExpTendency
   137  
   138      real(DP), intent(in ) :: xy_SurfHeight(0:imax-1,1:jmax)
   139      real(DP), intent(in ) :: xyz_UB       (0:imax-1,1:jmax,1:kmax)
   140      real(DP), intent(in ) :: xyz_VB       (0:imax-1,1:jmax,1:kmax)
   141      real(DP), intent(in ) :: xyz_TempB    (0:imax-1,1:jmax,1:kmax)
   142      real(DP), intent(in ) :: xy_PsB       (0:imax-1,1:jmax)
   143      real(DP), intent(in ) :: xyz_Press    (0:imax-1,1:jmax,1:kmax)
   144      real(DP), intent(in ) :: xyr_Press    (0:imax-1,1:jmax,0:kmax)
   145      real(DP), intent(in ) :: xyr_Temp     (0:imax-1,1:jmax,0:kmax)
   146      real(DP), intent(in ) :: xyz_VirTemp  (0:imax-1,1:jmax,1:kmax)
   147      real(DP), intent(in ) :: xyr_VirTemp  (0:imax-1,1:jmax,0:kmax)
   148      real(DP), intent(in ) :: xyz_Height   (0:imax-1,1:jmax,1:kmax)
   149      real(DP), intent(in ) :: xyr_Height   (0:imax-1,1:jmax,0:kmax)
   150      real(DP), intent(in ) :: xyz_Exner    (0:imax-1,1:jmax,1:kmax)
   151      real(DP), intent(in ) :: xyr_Exner    (0:imax-1,1:jmax,0:kmax)
   152      real(DP), intent(out) :: xyz_DUDt     (0:imax-1,1:jmax,1:kmax)
   153      real(DP), intent(out) :: xyz_DVDt     (0:imax-1,1:jmax,1:kmax)
   154      real(DP), intent(out) :: xyz_DTempDt  (0:imax-1,1:jmax,1:kmax)
   155  
   156  
   157      !
   158      ! local variables
   159      !
   160      real(DP) :: xyz_DTempDtRadL   (0:imax-1,1:jmax,1:kmax)
   161      real(DP) :: xyz_DTempDtRadS   (0:imax-1,1:jmax,1:kmax)
   162  
   163      real(DP) :: xyz_DUDtSFCFric   (0:imax-1,1:jmax,1:kmax)
   164      real(DP) :: xyz_DVDtSFCFric   (0:imax-1,1:jmax,1:kmax)
   165      real(DP) :: xyz_DTempDtSFCFric(0:imax-1,1:jmax,1:kmax)
   166  
   167      real(DP) :: xyzf_QMix         (0:imax-1,1:jmax,1:kmax,1:ncmax)
   168  
   169      real(DP) :: xyr_MomFluxX      (0:imax-1,1:jmax,0:kmax)
   170      real(DP) :: xyr_MomFluxY      (0:imax-1,1:jmax,0:kmax)
   171      real(DP) :: xyr_HeatFlux      (0:imax-1,1:jmax,0:kmax)
   172      real(DP) :: xyrf_QMixFlux     (0:imax-1,1:jmax,0:kmax,1:ncmax)
   173      real(DP) :: xyr_VelTransCoef  (0:imax-1,1:jmax,0:kmax)
   174      real(DP) :: xyr_TempTransCoef (0:imax-1,1:jmax,0:kmax)
   175      real(DP) :: xyr_QMixTransCoef (0:imax-1,1:jmax,0:kmax)
   176      real(DP) :: xyz_DUDtVDiff     (0:imax-1,1:jmax,1:kmax)
   177      real(DP) :: xyz_DVDtVDiff     (0:imax-1,1:jmax,1:kmax)
   178      real(DP) :: xyz_DTempDtVDiff  (0:imax-1,1:jmax,1:kmax)
   179  
   180  
   181      ! 初期化確認
   182      ! Initialization check
   183      !
   184      if ( .not. venus_simple_forcing_inited ) then
   185        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   186      end if
   187  
   188  
   189      call YT2003RadForcing(           &
   190        & xy_PsB, xyz_Press, xyz_TempB, xyz_Height, & ! (in )
   191        & xyz_DTempDtRadL, xyz_DTempDtRadS          & ! (out)
   192        & )
   193  
   194  
   195      call YT2003SurfFriction( &
   196        & xyz_UB, xyz_VB, xyz_TempB,       & ! (in )
   197        & xyz_DUDtSFCFric, xyz_DVDtSFCFric, xyz_DTempDtSFCFric  & ! (out)
   198        & )
   199  
   200  
   201      ! This is set temporarily
   202      !
   203      xyzf_QMix = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t491 = 1, xyzf_qmix.DSC.U4*xyzf_qmix.DSC.U3*xyzf_qmix.DSC.U2*( 
     .       1   xyzf_qmix.DSC.U1 + 1)                                          
     .           xyzf_qmix(t491-1,1,1,1) = 0.0000000000000000e+000              
     .        enddo                                                             
   204  
   205      call VDiffusion(                                               &
   206        & xyz_UB,     xyz_VB,     xyzf_QMix,                         & ! (in)
   207        & xyz_TempB, xyr_Temp, xyz_VirTemp, xyr_VirTemp, xyr_Press,  & ! (in)
   208        & xy_SurfHeight,                                             & ! (in)
   209        & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,              & ! (in)
   210        & xyr_MomFluxX,  xyr_MomFluxY,  xyr_HeatFlux, xyrf_QMixFlux, & ! (out)
   211        & xyr_VelTransCoef, xyr_TempTransCoef,                       & ! (out)
   212        & xyr_QMixTransCoef                                          & ! (out)
   213        & )
   214  
   215      call VDiffusionExpTendency(                            &
   216        & xyr_Press,                                               & ! (in )
   217        & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in ) optional
   218        & xyz_DUDtVDiff, xyz_DVDtVDiff, xyz_DTempDtVDiff  & ! (out) optional
   219        & )
   220  
   221  
   222      xyz_DUDt    =   xyz_DUDtVDiff    + xyz_DUDtSFCFric
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t503 = 1, xyz_dudtvdiff.DSC.U3*(xyz_dudtvdiff.DSC.U2*          
     .       1   xyz_dudtvdiff.DSC.U1 + xyz_dudtvdiff.DSC.U2)                   
     .           xyz_dudt(t503-1,1,1) = xyz_dudtvdiff(t503-1,1,1) +             
     .       1      xyz_dudtsfcfric(t503-1,1,1)                                 
     .           xyz_dvdt(t503-1,1,1) = xyz_dvdtvdiff(t503-1,1,1) +             
     .       1      xyz_dvdtsfcfric(t503-1,1,1)                                 
     .           xyz_dtempdt(t503-1,1,1) = xyz_dtempdtvdiff(t503-1,1,1) +       
     .       1      xyz_dtempdtsfcfric(t503-1,1,1) + xyz_dtempdtradl(t503-1,1,1)
     .       2       + xyz_dtempdtrads(t503-1,1,1)                              
     .        enddo                                                             
   223      xyz_DVDt    =   xyz_DVDtVDiff    + xyz_DVDtSFCFric
   224  
   225      xyz_DTempDt =   xyz_DTempDtVDiff + xyz_DTempDtSFCFric &
   226        &           + xyz_DTempDtRadL  + xyz_DTempDtRadS
   227  
   228  
   229    end subroutine YT2003Forcing
   230  
   231    !--------------------------------------------------------------------------------------
   232  
   233    subroutine YT2003RadForcing(                &
   234      & xy_Ps, xyz_Press, xyz_Temp, xyz_Height, & ! (in )
   235      & xyz_DTempDtRadL, xyz_DTempDtRadS        & ! (out)
   236      & )
   237  
   238      ! モジュール引用 ; USE statements
   239      !
   240  
   241      ! 時刻管理
   242      ! Time control
   243      !
   244      use timeset, only: &
   245        & DelTime, &            ! $ \Delta t $
   246        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   247        & TimesetClockStart, TimesetClockStop
   248  
   249      ! ヒストリデータ出力
   250      ! History data output
   251      !
   252      use gtool_historyauto, only: HistoryAutoPut
   253  
   254      ! 格子点設定
   255      ! Grid points settings
   256      !
   257      use gridset, only: imax, & ! 経度格子点数.
   258                                 ! Number of grid points in longitude
   259        &                jmax, & ! 緯度格子点数.
   260                                 ! Number of grid points in latitude
   261        &                kmax    ! 鉛直層数.
   262                                 ! Number of vertical level
   263  
   264      ! 物理定数設定
   265      ! Physical constants settings
   266      !
   267      use constants, only: &
   268        & Grav, &               ! $ g $ [m s-2].
   269                                ! 重力加速度.
   270                                ! Gravitational acceleration
   271        & CpDry, &
   272                                ! $ C_p $ [J kg-1 K-1].
   273                                ! 乾燥大気の定圧比熱.
   274                                ! Specific heat of air at constant pressure
   275        & GasRDry
   276                                ! $ R $ [J kg-1 K-1].
   277                                ! 乾燥大気の気体定数.
   278                                ! Gas constant of air
   279  
   280      ! 座標データ設定
   281      ! Axes data settings
   282      !
   283      use axesset, only: &
   284        & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   285        & z_Sigma               ! $ \sigma $ レベル (整数).
   286                                ! Full $ \sigma $ level
   287  
   288  
   289      real(DP), intent(in ):: xy_Ps          (0:imax-1,1:jmax)
   290      real(DP), intent(in ):: xyz_Press      (0:imax-1,1:jmax,1:kmax)
   291      real(DP), intent(in ):: xyz_Temp       (0:imax-1,1:jmax,1:kmax)
   292      real(DP), intent(in ):: xyz_Height     (0:imax-1,1:jmax,1:kmax)
   293      real(DP), intent(out):: xyz_DTempDtRadL(0:imax-1,1:jmax,1:kmax)
   294      real(DP), intent(out):: xyz_DTempDtRadS(0:imax-1,1:jmax,1:kmax)
   295  
   296  
   297      !
   298      ! local variables
   299      !
   300      real(DP) :: y_CosLat(1:jmax)
   301      real(DP) :: xyz_TempEq(0:imax-1,1:jmax,1:kmax)
   302      real(DP) :: xyz_NCC   (0:imax-1,1:jmax,1:kmax)
   303      real(DP) :: xyz_EquivTempEq(0:imax-1,1:jmax,1:kmax)
   304      real(DP) :: xyz_Geopot(0:imax-1,1:jmax,1:kmax)
   305      real(DP) :: xyz_UBalance(0:imax-1,1:jmax,1:kmax)
   306      integer  :: j, k
   307      integer  :: jp, jn
   308  
   309  
   310      y_CosLat = cos( y_Lat )
   311  
   312      call YT2003NCTempEq( &
   313        & xyz_Height, &
   314        & xyz_TempEq  &
   315        & )
   316  
   317      call YT2003NCCoef( &
   318        & xy_Ps, xyz_Press, &
   319        & xyz_NCC &
   320        & )
   321  
   322      xyz_DTempDtRadL = - xyz_NCC * ( xyz_Temp - xyz_TempEq )
     .  10012 continue                                                          
     .        d1 = 1.D0/8.64000000000000e+004                                   
     .  !cdir nodep                                                             
     .        do t344 = 1, xyz_ncc.DSC.U1 + 2 - min0(1,xyz_ncc.DSC.U1 + 1)      
     .           xyz_dtempdtradl(t344-1,t355,t354) = -xyz_ncc(t344-1,t352,t351)*
     .       1      (xyz_temp(t344-1,t346,t345)-xyz_tempeq(t344-1,t349,t348))   
     .           xyz_dtempdtradl(t344-1,t364,t363) = xyz_dtempdtradl(t344-1,t361
     .       1      ,t360) - %000281(t344-1,t358,t357)*d1                       
     .        enddo                                                             
   323  
   324      !
   325      !  add global mean cooling rate
   326      !
   327      xyz_DTempDtRadL = xyz_DTempDtRadL - xyz_YT2003Q0( xyz_Height ) / DayEarth
   328  
   329  
   330      call YT2003DTempDtRadS(   &
   331        & y_CosLat, xyz_Height,            & ! (in)
   332        & xyz_DTempDtRadS                  & ! (out)
   333        & )
   334  
   335  
   336      !
   337      ! code for debug
   338      !
   339  !!$    do k = 1, kmax
   340  !!$      do j = 1, jmax
   341  !!$        do i = 0, imax-1
   342  !!$           xyz_DTempDtRadS(i,j,k) = xyz_DTempDtRadS(i,j,k) &
   343  !!$             & - Q0YT2003( xyz_Height(i,j,k) ) / DayEarth
   344  !!$        end do
   345  !!$      end do
   346  !!$    end do
   347  !!$
   348  !!$    i = 0
   349  !!$    do k = 1, kmax
   350  !!$      do j = 1, jmax
   351  !!$        write( 60, * ) j, xyz_Press(i,j,k), xyz_Height(i,j,k), xyz_DTempDtRadS(i,j,k) * DayEarth
   352  !!$      end do
   353  !!$      write( 60, * )
   354  !!$    end do
   355  !!$    call flush( 60 )
   356  !!$
   357  !!$    i = 0
   358  !!$    j = jmax/2+1
   359  !!$    do k = 1, kmax
   360  !!$      write( 61, * ) k, xyz_Height(i,j,k), xyz_Press(i,j,k), &
   361  !!$        & 1.0d0 / xyz_NCC(i,j,k) / DayEarth, xyz_TempEq(i,j,k), xyz_DTempDtRadS(i,j,k) * DayEarth
   362  !!$    end do
   363  !!$    call flush( 61 )
   364  !!$    stop
   365  
   366  
   367      !
   368      ! In the following, output variables are calculated.
   369      ! Variables calculated below are used only for output.
   370      !
   371  
   372      xyz_EquivTempEq = xyz_TempEq                                      &
     .        if (xyz_tempeq.DSC.U2 .gt. 0) then                                
     .           j1 = and(xyz_tempeq.DSC.U2,3)                                  
     .  !cdir    nodep                                                          
     .           do t369 = 1, j1                                                
     .              d2 = 1.D0/8.64000000000000e+004                             
     .  !cdir       nodep                                                       
     .              do t371 = 1, xyz_tempeq.DSC.U1 + 1                          
     .                 xyz_equivtempeq(t371-1,t369,t367+1) = xyz_tempeq(t371-1, 
     .       1            t369,t367+1) + (xyz_dtempdtrads(t371-1,t369,t367+1)-  
     .       2            %00029d(t371-1,t369,t367+1)*d2)/(xyz_ncc(t371-1,t369, 
     .       3            t367+1)+1.00000000000000e-100)                        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t369 = j1 + 1, xyz_tempeq.DSC.U2, 4                         
     .              d3 = 1.D0/8.64000000000000e+004                             
     .              d4 = 1.D0/8.64000000000000e+004                             
     .              d5 = 1.D0/8.64000000000000e+004                             
     .              d6 = 1.D0/8.64000000000000e+004                             
     .  !cdir       nodep                                                       
     .              do t371 = 1, xyz_tempeq.DSC.U1 + 1                          
     .                 xyz_equivtempeq(t371-1,t369,t367+1) = xyz_tempeq(t371-1, 
     .       1            t369,t367+1) + (xyz_dtempdtrads(t371-1,t369,t367+1)-  
     .       2            %00029d(t371-1,t369,t367+1)*d3)/(xyz_ncc(t371-1,t369, 
     .       3            t367+1)+1.00000000000000e-100)                        
     .                 xyz_equivtempeq(t371-1,t369+1,t367+1) = xyz_tempeq(t371-1
     .       1            ,t369+1,t367+1) + (xyz_dtempdtrads(t371-1,t369+1,t367+
     .       2            1)-%00029d(t371-1,t369+1,t367+1)*d4)/(xyz_ncc(t371-1, 
     .       3            t369+1,t367+1)+1.00000000000000e-100)                 
     .                 xyz_equivtempeq(t371-1,t369+2,t367+1) = xyz_tempeq(t371-1
     .       1            ,t369+2,t367+1) + (xyz_dtempdtrads(t371-1,t369+2,t367+
     .       2            1)-%00029d(t371-1,t369+2,t367+1)*d5)/(xyz_ncc(t371-1, 
     .       3            t369+2,t367+1)+1.00000000000000e-100)                 
     .                 xyz_equivtempeq(t371-1,t369+3,t367+1) = xyz_tempeq(t371-1
     .       1            ,t369+3,t367+1) + (xyz_dtempdtrads(t371-1,t369+3,t367+
     .       2            1)-%00029d(t371-1,t369+3,t367+1)*d6)/(xyz_ncc(t371-1, 
     .       3            t369+3,t367+1)+1.00000000000000e-100)                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   373        & + ( xyz_DTempDtRadS - xyz_YT2003Q0( xyz_Height ) / DayEarth ) &
   374        &   / ( xyz_NCC + 1.0e-100_DP )
   375  
   376  
   377      ! dp/dz = -rho g
   378      ! dp / dphi = -rho
   379      ! dphi / dp = -1/rho = - R T / p
   380      ! p dphi / dp = -1/rho = - R T
   381      ! dphi / dlogp = - R T
   382  
   383      k = 1
   384      xyz_Geopot(:,:,k) = 0.0_DP             &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t388 = 1, xyz_equivtempeq.DSC.U2*xyz_equivtempeq.DSC.U1 +      
     .       1   xyz_equivtempeq.DSC.U2                                         
     .           xyz_geopot(t388-1,1,1) = 0.0000000000000000e+000 - gasrdry*    
     .       1      xyz_equivtempeq(t388-1,1,1)*dlog(z_sigma(1))                
     .        enddo                                                             
   385        & - GasRDry * xyz_EquivTempEq(:,:,k) &
   386        & * log( z_Sigma(k) )
   387      do k = 2, kmax
   388        xyz_Geopot(:,:,k) = xyz_Geopot(:,:,k-1)                                       &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t396 = 1, xyz_geopot.DSC.U2*xyz_geopot.DSC.U1 +                
     .       1   xyz_geopot.DSC.U2                                              
     .           xyz_geopot(t396-1,1,k) = xyz_geopot(t396-1,1,k-1) - gasrdry*(  
     .       1      xyz_equivtempeq(t396-1,1,k-1)+xyz_equivtempeq(t396-1,1,k))* 
     .       2      5.00000000000000e-001*dlog(z_sigma(k)/z_sigma(k-1))         
     .        enddo                                                             
   389          & - GasRDry * ( xyz_EquivTempEq(:,:,k-1) + xyz_EquivTempEq(:,:,k) ) * 0.5d0 &
   390          & * log( z_Sigma(k) / z_Sigma(k-1) )
   391      end do
   392  
   393      do k = 1, kmax
   394        do j = 1, jmax
   395          if ( j == 1 ) then
   396            jp = 1
   397            jn = j + 1
   398          else if ( j == jmax ) then
   399            jp = j - 1
   400            jn = jmax
   401          else
   402            jp = j - 1
   403            jn = j + 1
   404          end if
   405          xyz_UBalance(:,j,k) =                                                       &
   406            & sqrt( - ( xyz_Geopot(:,jn,k) - xyz_Geopot(:,jp,k) )                     &
   407            &       / ( y_Lat(jn)          - y_Lat(jp)          ) / tan( y_Lat(j) ) )
   408        end do
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           do j = 1, j2                                                   
     .              if (j .eq. 1) then                                          
     .                 jp = 1                                                   
     .                 jn = j + 1                                               
     .              else                                                        
     .                 if (j .eq. jmax) then                                    
     .                    jp = j - 1                                            
     .                    jn = jmax                                             
     .                 else                                                     
     .                    jp = j - 1                                            
     .                    jn = j + 1                                            
     .                 endif                                                    
     .              endif                                                       
     .              d7 = 1.D0/(y_lat(jn)-y_lat(jp))                             
     .              d8 = d7/dtan(y_lat(j))                                      
     .  !cdir       nodep                                                       
     .              do t408 = 1, xyz_geopot.DSC.U1 + 1                          
     .                 xyz_ubalance(t408-1,j,k) = dsqrt((-(xyz_geopot(t408-1,jn,
     .       1            k)-xyz_geopot(t408-1,jp,k))*d8))                      
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j2 + 1, jmax, 4                                         
     .              if (j .eq. 1) then                                          
     .                 jp4 = 1                                                  
     .                 jn4 = 1 + j                                              
     .              else                                                        
     .                 if (j .eq. jmax) then                                    
     .                    jp4 = j - 1                                           
     .                    jn4 = jmax                                            
     .                 else                                                     
     .                    jp4 = j - 1                                           
     .                    jn4 = 1 + j                                           
     .                 endif                                                    
     .              endif                                                       
     .              if (1 + j .eq. 1) then                                      
     .                 jp3 = 1                                                  
     .                 jn3 = 2 + j                                              
     .              else                                                        
     .                 if (1 + j .eq. jmax) then                                
     .                    jp3 = j                                               
     .                    jn3 = jmax                                            
     .                 else                                                     
     .                    jp3 = j                                               
     .                    jn3 = 2 + j                                           
     .                 endif                                                    
     .              endif                                                       
     .              if (2 + j .eq. 1) then                                      
     .                 jp2 = 1                                                  
     .                 jn2 = 3 + j                                              
     .              else                                                        
     .                 if (2 + j .eq. jmax) then                                
     .                    jp2 = 1 + j                                           
     .                    jn2 = jmax                                            
     .                 else                                                     
     .                    jp2 = 1 + j                                           
     .                    jn2 = 3 + j                                           
     .                 endif                                                    
     .              endif                                                       
     .              if (3 + j .eq. 1) then                                      
     .                 jp1 = 1                                                  
     .                 jn1 = 4 + j                                              
     .              else                                                        
     .                 if (3 + j .eq. jmax) then                                
     .                    jp1 = 2 + j                                           
     .                    jn1 = jmax                                            
     .                 else                                                     
     .                    jp1 = 2 + j                                           
     .                    jn1 = 4 + j                                           
     .                 endif                                                    
     .              endif                                                       
     .              d9 = 1.D0/(y_lat(jn4)-y_lat(jp4))                           
     .              d10 = d9/dtan(y_lat(j))                                     
     .              d11 = 1.D0/(y_lat(jn3)-y_lat(jp3))                          
     .              d12 = d11/dtan(y_lat(j+1))                                  
     .              d13 = 1.D0/(y_lat(jn2)-y_lat(jp2))                          
     .              d14 = d13/dtan(y_lat(j+2))                                  
     .              d15 = 1.D0/(y_lat(jn1)-y_lat(jp1))                          
     .              d16 = d15/dtan(y_lat(j+3))                                  
     .  !cdir       nodep                                                       
     .              do t408 = 1, xyz_geopot.DSC.U1 + 1                          
     .                 xyz_ubalance(t408-1,j,k) = dsqrt((-(xyz_geopot(t408-1,jn4
     .       1            ,k)-xyz_geopot(t408-1,jp4,k))*d10))                   
     .                 xyz_ubalance(t408-1,j+1,k) = dsqrt((-(xyz_geopot(t408-1, 
     .       1            jn3,k)-xyz_geopot(t408-1,jp3,k))*d12))                
     .                 xyz_ubalance(t408-1,j+2,k) = dsqrt((-(xyz_geopot(t408-1, 
     .       1            jn2,k)-xyz_geopot(t408-1,jp2,k))*d14))                
     .                 xyz_ubalance(t408-1,j+3,k) = dsqrt((-(xyz_geopot(t408-1, 
     .       1            jn1,k)-xyz_geopot(t408-1,jp1,k))*d16))                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   409      end do
   410  
   411  
   412      ! ヒストリデータ出力
   413      ! History data output
   414      !
   415      call HistoryAutoPut( TimeN, 'VTempEq'     , xyz_TempEq )
   416      call HistoryAutoPut( TimeN, 'VSRadHR'     , xyz_DTempDtRadS )
   417      call HistoryAutoPut( TimeN, 'VEquivTempEq', xyz_EquivTempEq )
   418      call HistoryAutoPut( TimeN, 'VUBalance'   , xyz_UBalance )
   419  
   420  
   421    end subroutine YT2003RadForcing
   422  
   423    !--------------------------------------------------------------------------------------
   424  
   425    subroutine YT2003NCTempEq( &
   426      & xyz_Height, & ! (in)
   427      & xyz_TempEq  & ! (out)
   428      & )
   429  
   430      ! 種別型パラメタ
   431      ! Kind type parameter
   432      !
   433      use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   434        &                 STRING     ! 文字列.       Strings.
   435  
   436  
   437      ! 格子点設定
   438      ! Grid points settings
   439      !
   440      use gridset, only: imax, & ! 経度格子点数.
   441                                 ! Number of grid points in longitude
   442        &                jmax, & ! 緯度格子点数.
   443                                 ! Number of grid points in latitude
   444        &                kmax    ! 鉛直層数.
   445                                 ! Number of vertical level
   446  
   447      real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
   448      real(DP), intent(out) :: xyz_TempEq(0:imax-1,1:jmax,1:kmax)
   449  
   450  
   451      !
   452      ! local variables
   453      !
   454  
   455      xyz_TempEq = xyz_YT2003TempEq( xyz_Height )
   456  
   457  
   458    end subroutine YT2003NCTempEq
   459  
   460    !--------------------------------------------------------------------------------------
   461  
   462    subroutine YT2003NCCoef( &
   463      & xy_Ps, xyz_Press,         & ! (in)
   464      & xyz_NCC                   & ! (out)
   465      & )
   466  
   467      ! 種別型パラメタ
   468      ! Kind type parameter
   469      !
   470      use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   471        &                 STRING     ! 文字列.       Strings.
   472  
   473  
   474      ! 格子点設定
   475      ! Grid points settings
   476      !
   477      use gridset, only: imax, & ! 経度格子点数.
   478                                 ! Number of grid points in longitude
   479        &                jmax, & ! 緯度格子点数.
   480                                 ! Number of grid points in latitude
   481        &                kmax    ! 鉛直層数.
   482                                 ! Number of vertical level
   483  
   484      real(DP), intent(in ) :: xy_Ps    (0:imax-1,1:jmax)
   485      real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   486      real(DP), intent(out) :: xyz_NCC  (0:imax-1,1:jmax,1:kmax)
   487  
   488  
   489      !
   490      ! local variables
   491      !
   492      real(DP) :: xyz_alp1  (0:imax-1,1:jmax,1:kmax)
   493      real(DP) :: xyz_alp2  (0:imax-1,1:jmax,1:kmax)
   494      real(DP) :: xyz_alp3  (0:imax-1,1:jmax,1:kmax)
   495      real(DP) :: xyz_lnPRat(0:imax-1,1:jmax,1:kmax)
   496      real(DP) :: NCTimeConst
   497      real(DP) :: NCTimeConst0
   498      integer  :: i, j, k
   499  
   500  
   501      if ( FlagConstNCC ) then
   502  
   503        xyz_NCC = 1.0_DP / ( ConstNCCInEarthDay * DayEarth )
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j1 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t261 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t263 = 1, 1 + imax - min0(1,imax)                        
     .                 xyz_ncc(t263-1,t261,t259+1) = 1.00000000000000e+000/(    
     .       1            constnccinearthday*8.64000000000000e+004)             
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t261 = j1 + 1, 1 + jmax - min0(1,jmax), 4                   
     .  !cdir       nodep                                                       
     .              do t263 = 1, 1 + imax - min0(1,imax)                        
     .                 xyz_ncc(t263-1,t261,t259+1) = (1.00000000000000e+000/(   
     .       1            constnccinearthday*8.64000000000000e+004))            
     .                 xyz_ncc(t263-1,t261+1,t259+1) = (1.00000000000000e+000/( 
     .       1            constnccinearthday*8.64000000000000e+004))            
     .                 xyz_ncc(t263-1,t261+2,t259+1) = (1.00000000000000e+000/( 
     .       1            constnccinearthday*8.64000000000000e+004))            
     .                 xyz_ncc(t263-1,t261+3,t259+1) = (1.00000000000000e+000/( 
     .       1            constnccinearthday*8.64000000000000e+004))            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   504  
   505      else
   506  
   507        ! Thermal damping coefficient by Hou and Farrel (1987)
   508        !
   509        do k = 1, kmax
   510          xyz_lnPRat(:,:,k) = log( xyz_Press(:,:,k) / xy_Ps(:,:) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_ps)                                                     
     .        do t249 = 1, jmax*imax                                            
     .           xyz_lnprat(t249-1,1,k) = dlog(xyz_press(t249-1,1,k)/xy_ps(t249-
     .       1      1,1))                                                       
     .        enddo                                                             
   511        end do
   512        do k = 1, kmax
   513          do j = 1, jmax
   514            do i = 0, imax-1
   515              if( -xyz_lnPRat(i,j,k) .le. 5.0_DP ) then
   516                xyz_alp1(i,j,k) =  0.0_DP
   517                xyz_alp2(i,j,k) =  0.9_DP
   518                xyz_alp3(i,j,k) =  0.0_DP
   519              else if( -xyz_lnPRat(i,j,k) .le. 7.0_DP ) then
   520                xyz_alp1(i,j,k) = -4.5_DP
   521                xyz_alp2(i,j,k) =  2.0_DP
   522                xyz_alp3(i,j,k) =  5.0_DP
   523              else
   524                xyz_alp1(i,j,k) = -8.5_DP
   525                xyz_alp2(i,j,k) =  0.5_DP
   526                xyz_alp3(i,j,k) =  7.0_DP
   527              end if
   528            end do
   529          end do
   530        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if ((-xyz_lnprat(k-1,1,1)) .le. 5.00000000000000e+000) then    
     .              xyz_alp11 = 0.0000000000000000e+000                         
     .              xyz_alp22 = 9.00000000000000e-001                           
     .              xyz_alp33 = 0.0000000000000000e+000                         
     .           else                                                           
     .              if ((-xyz_lnprat(k-1,1,1)) .le. 7.00000000000000e+000) then 
     .                 xyz_alp11 = -4.50000000000000e+000                       
     .                 xyz_alp22 = 2.00000000000000e+000                        
     .                 xyz_alp33 = 5.00000000000000e+000                        
     .              else                                                        
     .                 xyz_alp11 = -8.50000000000000e+000                       
     .                 xyz_alp22 = 5.00000000000000e-001                        
     .                 xyz_alp33 = 7.00000000000000e+000                        
     .              endif                                                       
     .           endif                                                          
     .           xyz_alp3(k-1,1,1) = xyz_alp33                                  
     .           xyz_alp2(k-1,1,1) = xyz_alp22                                  
     .           xyz_alp1(k-1,1,1) = xyz_alp11                                  
     .        enddo                                                             
   531        NCTimeConst0 = 1.32e9_DP
   532        do k = 1, kmax
   533          do j = 1, jmax
   534            do i = 0, imax-1
   535              NCTimeConst = NCTimeConst0                                                 &
   536                & * exp(   xyz_alp1(i,j,k)                                               &
   537                &        - xyz_alp2(i,j,k) * ( -xyz_lnPRat(i,j,k) - xyz_alp3(i,j,k) ) )
   538              xyz_NCC(i,j,k) = 1.0_DP / NCTimeConst
   539            end do
   540          end do
   541        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           nctimeconst = nctimeconst0*dexp(xyz_alp1(k-1,1,1)-xyz_alp2(k-1,
     .       1      1,1)*((-xyz_lnprat(k-1,1,1))-xyz_alp3(k-1,1,1)))            
     .           xyz_ncc(k-1,1,1) = 1.00000000000000e+000/nctimeconst           
     .        enddo                                                             
   542  
   543      end if
   544  
   545  
   546    end subroutine YT2003NCCoef
   547  
   548    !--------------------------------------------------------------------------------------
   549  
   550    subroutine YT2003DTempDtRadS(   &
   551      & y_CosLat, xyz_Height,            & ! (in)
   552      & xyz_DTempDtRadS                  & ! (out)
   553      & )
   554  
   555      ! 種別型パラメタ
   556      ! Kind type parameter
   557      !
   558      use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   559        &                 STRING     ! 文字列.       Strings.
   560  
   561  
   562      ! 格子点設定
   563      ! Grid points settings
   564      !
   565      use gridset, only: imax, & ! 経度格子点数.
   566                                 ! Number of grid points in longitude
   567        &                jmax, & ! 緯度格子点数.
   568                                 ! Number of grid points in latitude
   569        &                kmax    ! 鉛直層数.
   570                                 ! Number of vertical level
   571  
   572      use axesset, only: &
   573        & y_Lat_weight             ! $ \varphi $ [rad.] . 緯度重み. Latitude
   574  
   575      ! 物理・数学定数設定
   576      ! Physical and mathematical constants settings
   577      !
   578      use constants0, only: &
   579        & PI
   580                                ! $ \pi $ .
   581                                ! 円周率.  Circular constant
   582  
   583      real(DP), intent(in ) :: y_CosLat       (1:jmax)
   584      real(DP), intent(in ) :: xyz_Height     (0:imax-1,1:jmax,1:kmax)
   585      real(DP), intent(out) :: xyz_DTempDtRadS(0:imax-1,1:jmax,1:kmax)
   586  
   587  
   588      !
   589      ! local variables
   590      !
   591      real(DP) :: GM
   592      integer  :: j
   593      integer  :: k
   594  
   595  
   596  !!$    do k = 1, kmax
   597  !!$      do j = 1, jmax
   598  !!$        do i = 0, imax-1
   599  !!$           xyz_DTempDtRadS(i,j,k) = Q0YT2003( xyz_Height(i,j,k) ) &
   600  !!$             & * y_CosLat(j) * 4.0_DP / PI                        &
   601  !!$             & / DayEarth
   602  !!$        end do
   603  !!$      end do
   604  !!$    end do
   605  
   606  
   607      GM = sum( y_CosLat**(7.0_DP / 5.0_DP ) * y_Lat_weight ) / sum( y_Lat_Weight )
     .  !cdir nodep                                                             
     .        do t103 = 1, jmax                                                 
     .           t42 = t42 + y_coslat(t103)**1.39999999999999e+000*y_lat_weight(
     .       1      t1+t103-1)                                                  
     .        enddo                                                             
     .  !cdir nodep                                                             
     .        do t48 = 1, y_lat_weight.DSC.U1 + 1 - y_lat_weight.DSC.L1         
     .           t46 = t46 + y_lat_weight(t1+t48-1)                             
     .        enddo                                                             
   608  
   609      xyz_DTempDtRadS = xyz_YT2003Q0( xyz_Height )
   610      do k = 1, kmax
   611        do j = 1, jmax
   612          xyz_DTempDtRadS(:,j,k) = xyz_DTempDtRadS(:,j,k)      &
   613            & * y_CosLat(j)**(7.0_DP/5.0_DP) / GM                    &
   614            & / DayEarth
   615        end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .              d1 = y_coslat(j)**1.39999999999999e+000/gm                  
     .              d2 = d1/8.64000000000000e+004                               
     .  !cdir       nodep                                                       
     .              do t107 = 1, t15 + 1                                        
     .                 xyz_dtempdtrads(t107-1,j,k) = xyz_dtempdtrads(t107-1,j,k)
     .       1            *d2                                                   
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .              d3 = y_coslat(j)**1.39999999999999e+000/gm                  
     .              d4 = d3/8.64000000000000e+004                               
     .              d5 = y_coslat(j+1)**1.39999999999999e+000/gm                
     .              d6 = d5/8.64000000000000e+004                               
     .              d7 = y_coslat(j+2)**1.39999999999999e+000/gm                
     .              d8 = d7/8.64000000000000e+004                               
     .              d9 = y_coslat(j+3)**1.39999999999999e+000/gm                
     .              d10 = d9/8.64000000000000e+004                              
     .  !cdir       nodep                                                       
     .              do t107 = 1, t15 + 1                                        
     .                 xyz_dtempdtrads(t107-1,j,k) = xyz_dtempdtrads(t107-1,j,k)
     .       1            *d4                                                   
     .                 xyz_dtempdtrads(t107-1,j+1,k) = xyz_dtempdtrads(t107-1,j+
     .       1            1,k)*d6                                               
     .                 xyz_dtempdtrads(t107-1,j+2,k) = xyz_dtempdtrads(t107-1,j+
     .       1            2,k)*d8                                               
     .                 xyz_dtempdtrads(t107-1,j+3,k) = xyz_dtempdtrads(t107-1,j+
     .       1            3,k)*d10                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   616      end do
   617  
   618  
   619    end subroutine YT2003DTempDtRadS
   620  
   621    !--------------------------------------------------------------------------------------
   622  
   623    subroutine YT2003SurfFriction(  &
   624      & xyz_UB, xyz_VB, xyz_TempB,       & ! (in )
   625      & xyz_DUDt, xyz_DVDt, xyz_DTempDt  & ! (out)
   626      & )
   627  
   628      ! モジュール引用 ; USE statements
   629      !
   630  
   631      ! 格子点設定
   632      ! Grid points settings
   633      !
   634      use gridset, only: imax, & ! 経度格子点数.
   635                                 ! Number of grid points in longitude
   636        &                jmax, & ! 緯度格子点数.
   637                                 ! Number of grid points in latitude
   638        &                kmax    ! 鉛直層数.
   639                                 ! Number of vertical level
   640  
   641      ! 物理定数設定
   642      ! Physical constants settings
   643      !
   644      use constants, only: &
   645        & Grav, &               ! $ g $ [m s-2].
   646                                ! 重力加速度.
   647                                ! Gravitational acceleration
   648        & CpDry
   649                                ! $ C_p $ [J kg-1 K-1].
   650                                ! 乾燥大気の定圧比熱.
   651                                ! Specific heat of air at constant pressure
   652  
   653  
   654      use axesset  , only : y_Lat
   655  
   656  
   657      real(DP), intent(in ):: xyz_UB     (0:imax-1,1:jmax,1:kmax)
   658      real(DP), intent(in ):: xyz_VB     (0:imax-1,1:jmax,1:kmax)
   659      real(DP), intent(in ):: xyz_TempB  (0:imax-1,1:jmax,1:kmax)
   660      real(DP), intent(out):: xyz_DUDt   (0:imax-1,1:jmax,1:kmax)
   661      real(DP), intent(out):: xyz_DVDt   (0:imax-1,1:jmax,1:kmax)
   662      real(DP), intent(out):: xyz_DTempDt(0:imax-1,1:jmax,1:kmax)
   663  
   664  
   665      !
   666      ! local variables
   667      !
   668      real(DP) :: SurfFrictionTimeConst
   669      real(DP) :: Temp  (24:25)
   670      real(DP) :: Height(24:25)
   671      real(DP) :: SurfTemp
   672  
   673  
   674      SurfFrictionTimeConst = SurfFrictionTimeConstInEarthDay * DayEarth
   675  
   676      xyz_DUDt(:,:,2:kmax) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t129 = 1, jmax*(kmax*imax - imax)                              
     .           xyz_dudt(t129-1,1,2) = 0.0000000000000000e+000                 
     .           xyz_dvdt(t129-1,1,2) = 0.0000000000000000e+000                 
     .        enddo                                                             
   677      xyz_DVDt(:,:,2:kmax) = 0.0_DP
   678  
   679      xyz_DUDt(:,:,1) = - xyz_UB(:,:,1) / SurfFrictionTimeConst
     .        d1 = 1.D0/surffrictiontimeconst                                   
     .        d2 = 1.D0/surffrictiontimeconst                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t141 = 1, jmax*imax                                            
     .           xyz_dudt(t141-1,1,1) = -xyz_ub(t141-1,1,1)*d1                  
     .           xyz_dvdt(t141-1,1,1) = -xyz_vb(t141-1,1,1)*d2                  
     .        enddo                                                             
   680      xyz_DVDt(:,:,1) = - xyz_VB(:,:,1) / SurfFrictionTimeConst
   681  
   682  
   683      xyz_DTempDt(:,:,2:kmax) = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t153 = 1, jmax*(kmax*imax - imax)                              
     .           xyz_dtempdt(t153-1,1,2) = 0.0000000000000000e+000              
     .        enddo                                                             
   684  
   685      SurfTemp =                                                &
   686        &   ( a_YT2003Temp      (25) - A_YT2003Temp      (24) ) &
   687        & / ( a_YT2003HeightForT(25) - a_YT2003HeightForT(24) ) &
   688        & * ( 0.0_DP - a_YT2003HeightForT(24) )                 &
   689        & + A_YT2003Temp(24)
   690      xyz_DTempDt(:,:,1) = - ( xyz_TempB(:,:,1) - SurfTemp ) / SurfFrictionTimeConst
     .        d3 = 1.D0/surffrictiontimeconst                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t162 = 1, jmax*imax                                            
     .           xyz_dtempdt(t162-1,1,1) = -(xyz_tempb(t162-1,1,1)-surftemp)*d3 
     .        enddo                                                             
   691  
   692  
   693    end subroutine YT2003SurfFriction
   694  
   695    !--------------------------------------------------------------------------------------
   696  
   697    function xyz_YT2003TempEq( xyz_h_in )
   698  
   699      ! 種別型パラメタ
   700      ! Kind type parameter
   701      !
   702      use dc_types, only: DP         ! 倍精度実数型. Double precision.
   703  
   704      ! 格子点設定
   705      ! Grid points settings
   706      !
   707      use gridset, only: imax, & ! 経度格子点数.
   708                                 ! Number of grid points in longitude
   709        &                jmax, & ! 緯度格子点数.
   710                                 ! Number of grid points in latitude
   711        &                kmax    ! 鉛直層数.
   712                                 ! Number of vertical level
   713  
   714      real(DP), intent(IN) :: xyz_h_in        (0:imax-1, 1:jmax, 1:kmax)     ! 高度(m)
   715      real(DP)             :: xyz_YT2003TempEq(0:imax-1, 1:jmax, 1:kmax)     ! 温度(K)
   716  
   717      !
   718      ! local variables
   719      !
   720      real(DP) :: x
   721      integer  :: i
   722      integer  :: j
   723      integer  :: k
   724      integer  :: kk
   725  
   726  
   727      do k = 1, kmax
   728        do j = 1, jmax
   729          do i = 0, imax-1
   730  
   731            if ( xyz_h_in(i,j,k) > a_YT2003HeightForT(0) ) then
   732              xyz_YT2003TempEq(i,j,k) = a_YT2003Temp(0)
   733            else if ( xyz_h_in(i,j,k) < a_YT2003HeightForT(25) ) then
   734              xyz_YT2003TempEq(i,j,k) =                                 &
   735                &   ( a_YT2003Temp      (24) - a_YT2003Temp      (25) ) &
   736                & / ( a_YT2003HeightForT(24) - a_YT2003HeightForT(25) ) &
   737                & * ( xyz_h_in(i,j,k)        - a_YT2003HeightForT(25) ) &
   738                & + a_YT2003Temp(25)
   739            else
   740              do kk = 1, 25
   741                if ( ( xyz_h_in(i,j,k) < a_YT2003HeightForT(kk-1) ) .and. &
   742                  &  ( xyz_h_in(i,j,k) > a_YT2003HeightForT(kk  ) ) ) then
   743                  x =   ( a_YT2003HeightForT(kk-1) - xyz_h_in(i,j,k)        ) &
   744                    & / ( a_YT2003HeightForT(kk-1) - a_YT2003HeightForT(kk) )
   745                  xyz_YT2003TempEq(i,j,k) = &
   746                    & ( 1 - x ) * a_YT2003Temp(kk-1) + x * a_YT2003Temp(kk)
   747                endif
   748              end do
     .        xyz_yt2003tempeq1 = xyz_yt2003tempeq(i,j,k)                       
     .  !cdir nodep                                                             
     .        do kk = 1, 25                                                     
     .           if (xyz_h_in(i,j,k).lt.a_yt2003heightfort(kk-1) .and. xyz_h_in(
     .       1      i,j,k).gt.a_yt2003heightfort(kk)) then                      
     .              x = (a_yt2003heightfort(kk-1)-xyz_h_in(i,j,k))/(            
     .       1         a_yt2003heightfort(kk-1)-a_yt2003heightfort(kk))         
     .              xyz_yt2003tempeq1 = (1.00000000000000e+000 - x)*a_yt2003temp
     .       1         (kk-1) + x*a_yt2003temp(kk)                              
     .           endif                                                          
     .        enddo                                                             
     .        xyz_yt2003tempeq(i,j,k) = xyz_yt2003tempeq1                       
   749            end if
   750  
   751          end do
   752        end do
   753      end do
   754  
   755  
   756    end function xyz_YT2003TempEq
   757  
   758    !--------------------------------------------------------------------------------------
   759  
   760    function xyz_YT2003Q0( xyz_h_in )
   761  
   762      ! 種別型パラメタ
   763      ! Kind type parameter
   764      !
   765      use dc_types, only: DP         ! 倍精度実数型. Double precision.
   766  
   767      ! 格子点設定
   768      ! Grid points settings
   769      !
   770      use gridset, only: imax, & ! 経度格子点数.
   771                                 ! Number of grid points in longitude
   772        &                jmax, & ! 緯度格子点数.
   773                                 ! Number of grid points in latitude
   774        &                kmax    ! 鉛直層数.
   775                                 ! Number of vertical level
   776  
   777      real(DP), intent(IN) :: xyz_h_in    (0:imax-1, 1:jmax, 1:kmax)         ! 高度(m)
   778      real(DP)             :: xyz_YT2003Q0(0:imax-1, 1:jmax, 1:kmax)         ! 温度(K)
   779  
   780      !
   781      ! local variables
   782      !
   783      real(DP) :: x
   784      integer  :: i
   785      integer  :: j
   786      integer  :: k
   787      integer  :: kk
   788  
   789  
   790      do k = 1, kmax
   791        do j = 1, jmax
   792          do i = 0, imax-1
   793  
   794            if ( xyz_h_in(i,j,k) > a_YT2003HeightForQ(0) ) then
   795              xyz_YT2003Q0(i,j,k) = a_YT2003Q(0)
   796            else if ( xyz_h_in(i,j,k) <= a_YT2003HeightForQ(20) ) then
   797              xyz_YT2003Q0(i,j,k) = a_YT2003Q(20)
   798            else
   799              do kk = 1, 20
   800                if ( ( xyz_h_in(i,j,k) <= a_YT2003HeightForQ(kk-1) ) .and. &
   801                  &  ( xyz_h_in(i,j,k) >  a_YT2003HeightForQ(kk  ) ) ) then
   802                  x =   ( a_YT2003HeightForQ(kk-1) - xyz_h_in(i,j,k)        ) &
   803                    & / ( a_YT2003HeightForQ(kk-1) - a_YT2003HeightForQ(kk) )
   804                  xyz_YT2003Q0(i,j,k) = ( 1 - x ) * a_YT2003Q(kk-1) + x * a_YT2003Q(kk)
   805                endif
   806              end do
     .        xyz_yt2003q01 = xyz_yt2003q0(i,j,k)                               
     .  !cdir nodep                                                             
     .        do kk = 1, 20                                                     
     .           if (xyz_h_in(i,j,k).le.a_yt2003heightforq(kk-1) .and. xyz_h_in(
     .       1      i,j,k).gt.a_yt2003heightforq(kk)) then                      
     .              x = (a_yt2003heightforq(kk-1)-xyz_h_in(i,j,k))/(            
     .       1         a_yt2003heightforq(kk-1)-a_yt2003heightforq(kk))         
     .              xyz_yt2003q01 = (1.00000000000000e+000 - x)*a_yt2003q(kk-1) 
     .       1          + x*a_yt2003q(kk)                                       
     .           endif                                                          
     .        enddo                                                             
     .        xyz_yt2003q0(i,j,k) = xyz_yt2003q01                               
   807            end if
   808  
   809          end do
   810        end do
   811      end do
   812  
   813  
   814    end function xyz_YT2003Q0
   815  
   816    !--------------------------------------------------------------------------------------
   817  
   818    subroutine YT2003ForcingInit
   819      !
   820      ! venus_simple_forcing モジュールの初期化を行います.
   821      ! NAMELIST#venus_simple_forcing_nml の読み込みはこの手続きで行われます.
   822      !
   823      ! "venus_simple_forcing" module is initialized.
   824      ! "NAMELIST#venus_simple_forcing_nml" is loaded in this procedure.
   825      !
   826  
   827  
   828      ! モジュール引用 ; USE statements
   829      !
   830  
   831      ! 物理定数設定
   832      ! Physical constants settings
   833      !
   834      use constants, only: &
   835        & GasRDry, &
   836                                ! $ R $ [J kg-1 K-1].
   837                                ! 乾燥大気の気体定数.
   838                                ! Gas constant of air
   839        & CpDry
   840                                ! $ C_p $ [J kg-1 K-1].
   841                                ! 乾燥大気の定圧比熱.
   842                                ! Specific heat of air at constant pressure
   843  
   844      ! 座標データ設定
   845      ! Axes data settings
   846      !
   847      use axesset, only: &
   848        & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   849        & z_Sigma               ! $ \sigma $ レベル (整数).
   850                                ! Full $ \sigma $ level
   851  
   852      ! NAMELIST ファイル入力に関するユーティリティ
   853      ! Utilities for NAMELIST file input
   854      !
   855      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   856  
   857      ! ファイル入出力補助
   858      ! File I/O support
   859      !
   860      use dc_iounit, only: FileOpen
   861  
   862      ! 種別型パラメタ
   863      ! Kind type parameter
   864      !
   865      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   866  
   867      ! 文字列操作
   868      ! Character handling
   869      !
   870      use dc_string, only: StoA
   871  
   872      ! ヒストリデータ出力
   873      ! History data output
   874      !
   875      use gtool_historyauto, only: HistoryAutoAddVariable
   876  
   877      ! 鉛直拡散フラックス
   878      ! Vertical diffusion flux
   879      !
   880      use vdiffusion_my, only: VDiffusionInit
   881  
   882  
   883      ! 宣言文 ; Declaration statements
   884      !
   885      implicit none
   886  
   887      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   888                                ! Unit number for NAMELIST file open
   889      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   890                                ! IOSTAT of NAMELIST read
   891  
   892      ! NAMELIST 変数群
   893      ! NAMELIST group name
   894      !
   895      namelist /venus_simple_forcing_nml/  &
   896        & SurfFrictionTimeConstInEarthDay, &
   897        & FlagConstNCC,                    &
   898        & ConstNCCInEarthDay
   899            !
   900            ! デフォルト値については初期化手続 "venus_simple_forcing#YT2003ForcingInit"
   901            ! のソースコードを参照のこと.
   902            !
   903            ! Refer to source codes in the initialization procedure
   904            ! "venus_simple_forcing#YT2003ForcingInit" for the default values.
   905            !
   906  
   907      ! 実行文 ; Executable statement
   908      !
   909  
   910      if ( venus_simple_forcing_inited ) return
   911  
   912  
   913      ! デフォルト値の設定
   914      ! Default values settings
   915      !
   916      SurfFrictionTimeConstInEarthDay = 30.0_DP
   917      FlagConstNCC                    = .false.
   918      ConstNCCInEarthDay              = 30.0_DP
   919  
   920  
   921      ! NAMELIST の読み込み
   922      ! NAMELIST is input
   923      !
   924      if ( trim(namelist_filename) /= '' ) then
   925        call FileOpen( unit_nml, &          ! (out)
   926          & namelist_filename, mode = 'r' ) ! (in)
   927  
   928        rewind( unit_nml )
   929        read( unit_nml,                     &  ! (in)
   930          & nml = venus_simple_forcing_nml, &  ! (out)
   931          & iostat = iostat_nml             &  ! (out)
   932          & )
   933        close( unit_nml )
   934  
   935        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   936  !$      if ( iostat_nml == 0 ) write( STDOUT, nml = venus_simple_forcing_nml )
   937      end if
   938  
   939  
   940      ! ヒストリデータ出力のためのへの変数登録
   941      ! Register of variables for history data output
   942      !
   943      call HistoryAutoAddVariable( 'VTempEq', &
   944        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   945        & 'radiative equilibrium temperature', 'K' )
   946      call HistoryAutoAddVariable( 'VSRadHR', &
   947        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   948        & 'solar heating rate', 'K s-1' )
   949      call HistoryAutoAddVariable( 'VEquivTempEq', &
   950        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   951        & '"equivalent" radiative equilibrium temperature', 'K' )
   952      call HistoryAutoAddVariable( 'VUBalance', &
   953        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   954        & 'balanced zonal wind', 'm s-1' )
   955  
   956  
   957      a_YT2003Temp( 0)=178.76712328767124_DP ; a_YT2003HeightForT(0)=94.54545454545455e3_DP
   958      a_YT2003Temp( 1)=180.82191780821918_DP ; a_YT2003HeightForT(1)=89.35064935064935e3_DP
   959      a_YT2003Temp( 2)=184.93150684931507_DP ; a_YT2003HeightForT(2)=84.5021645021645e3_DP
   960      a_YT2003Temp( 3)=193.15068493150685_DP ; a_YT2003HeightForT(3)=80.0e3_DP
   961      a_YT2003Temp( 4)=203.4246575342466_DP  ; a_YT2003HeightForT(4)=75.84415584415585e3_DP
   962      a_YT2003Temp( 5)=217.8082191780822_DP  ; a_YT2003HeightForT(5)=71.34199134199135e3_DP
   963      a_YT2003Temp( 6)=236.3013698630137_DP  ; a_YT2003HeightForT(6)=67.18614718614718e3_DP
   964      a_YT2003Temp( 7)=252.73972602739724_DP ; a_YT2003HeightForT(7)=64.06926406926407e3_DP
   965      a_YT2003Temp( 8)=273.28767123287673_DP ; a_YT2003HeightForT(8)=60.60606060606061e3_DP
   966      a_YT2003Temp( 9)=295.8904109589041_DP  ; a_YT2003HeightForT(9)=56.45021645021645e3_DP
   967      a_YT2003Temp(10)=320.54794520547944_DP ; a_YT2003HeightForT(10)=52.98701298701299e3_DP
   968      a_YT2003Temp(11)=343.1506849315068_DP  ; a_YT2003HeightForT(11)=49.523809523809526e3_DP
   969      a_YT2003Temp(12)=365.75342465753425_DP ; a_YT2003HeightForT(12)=46.40692640692641e3_DP
   970      a_YT2003Temp(13)=392.4657534246575_DP  ; a_YT2003HeightForT(13)=42.5974025974026e3_DP
   971      a_YT2003Temp(14)=419.17808219178085_DP ; a_YT2003HeightForT(14)=38.78787878787879e3_DP
   972      a_YT2003Temp(15)=445.8904109589041_DP  ; a_YT2003HeightForT(15)=35.324675324675326e3_DP
   973      a_YT2003Temp(16)=472.6027397260274_DP  ; a_YT2003HeightForT(16)=31.861471861471863e3_DP
   974      a_YT2003Temp(17)=499.3150684931507_DP  ; a_YT2003HeightForT(17)=28.3982683982684e3_DP
   975      a_YT2003Temp(18)=528.0821917808219_DP  ; a_YT2003HeightForT(18)=24.935064935064936e3_DP
   976      a_YT2003Temp(19)=556.8493150684931_DP  ; a_YT2003HeightForT(19)=21.125541125541126e3_DP
   977      a_YT2003Temp(20)=587.6712328767123_DP  ; a_YT2003HeightForT(20)=17.316017316017316e3_DP
   978      a_YT2003Temp(21)=614.3835616438356_DP  ; a_YT2003HeightForT(21)=13.852813852813853e3_DP
   979      a_YT2003Temp(22)=645.2054794520548_DP  ; a_YT2003HeightForT(22)=10.043290043290042e3_DP
   980      a_YT2003Temp(23)=669.8630136986301_DP  ; a_YT2003HeightForT(23)=6.926406926406926e3_DP
   981      a_YT2003Temp(24)=698.6301369863014_DP  ; a_YT2003HeightForT(24)=3.463203463203463e3_DP
   982      a_YT2003Temp(25)=725.3424657534247_DP  ; a_YT2003HeightForT(25)=0.3463203463203463e3_DP
   983  
   984  
   985      a_YT2003Q( 0)=0.0_DP                ; a_YT2003HeightForQ( 0)=80.0e3_DP
   986      a_YT2003Q( 1)=0.1282051282051282_DP ; a_YT2003HeightForQ( 1)=73.33333333333333e3_DP
   987      a_YT2003Q( 2)=0.2564102564102564_DP ; a_YT2003HeightForQ( 2)=71.11111111111111e3_DP
   988      a_YT2003Q( 3)=0.7692307692307693_DP ; a_YT2003HeightForQ( 3)=68.33333333333333e3_DP
   989      a_YT2003Q( 4)=1.4102564102564104_DP ; a_YT2003HeightForQ( 4)=66.11111111111111e3_DP
   990      a_YT2003Q( 5)=2.051282051282051_DP  ; a_YT2003HeightForQ( 5)=64.44444444444444e3_DP
   991      a_YT2003Q( 6)=2.6923076923076925_DP ; a_YT2003HeightForQ( 6)=62.77777777777778e3_DP
   992      a_YT2003Q( 7)=3.3333333333333335_DP ; a_YT2003HeightForQ( 7)=61.666666666666664e3_DP
   993      a_YT2003Q( 8)=3.9743589743589745_DP ; a_YT2003HeightForQ( 8)=60.55555555555556e3_DP
   994      a_YT2003Q( 9)=4.743589743589744_DP  ; a_YT2003HeightForQ( 9)=58.333333333333336e3_DP
   995      a_YT2003Q(10)=5.128205128205129_DP  ; a_YT2003HeightForQ(10)=56.666666666666664e3_DP
   996      a_YT2003Q(11)=5.2_DP                ; a_YT2003HeightForQ(11)=55.0e3_DP
   997      a_YT2003Q(12)=4.871794871794871_DP  ; a_YT2003HeightForQ(12)=52.22222222222222e3_DP
   998      a_YT2003Q(13)=4.358974358974359_DP  ; a_YT2003HeightForQ(13)=50.0e3_DP
   999      a_YT2003Q(14)=3.58974358974359_DP   ; a_YT2003HeightForQ(14)=47.77777777777778e3_DP
  1000      a_YT2003Q(15)=2.948717948717949_DP  ; a_YT2003HeightForQ(15)=46.111111111111114e3_DP
  1001      a_YT2003Q(16)=2.3076923076923075_DP ; a_YT2003HeightForQ(16)=43.888888888888886e3_DP
  1002      a_YT2003Q(17)=1.6666666666666667_DP ; a_YT2003HeightForQ(17)=41.666666666666664e3_DP
  1003      a_YT2003Q(18)=1.1538461538461537_DP ; a_YT2003HeightForQ(18)=38.888888888888886e3_DP
  1004      a_YT2003Q(19)=0.7692307692307693_DP ; a_YT2003HeightForQ(19)=37.22222222222222e3_DP
  1005      a_YT2003Q(20)=0.52_DP               ; a_YT2003HeightForQ(20)=35.0e3_DP
  1006  
  1007  
  1008      ! Initialization of modules used in this module
  1009      !
  1010  
  1011      ! 鉛直拡散フラックス (Mellor and Yamada, 1974)
  1012      ! Vertical diffusion flux (Mellor and Yamada, 1974)
  1013      !
  1014      call VDiffusionInit
  1015  
  1016  
  1017      ! 印字 ; Print
  1018      !
  1019      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1020      call MessageNotify( 'M', module_name, '  SurfFrictionTimeConstInEarthDay = %f', d = (/ SurfFrictionTimeConstInEarthDay /) )
  1021      call MessageNotify( 'M', module_name, '  FlagConstNCC                    = %b', l = (/ FlagConstNCC /) )
  1022      call MessageNotify( 'M', module_name, '  ConstNCCInEarthDay              = %f', d = (/ ConstNCCInEarthDay /) )
  1023      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1024  
  1025      venus_simple_forcing_inited = .true.
  1026  
  1027    end subroutine YT2003ForcingInit
  1028  
  1029    !--------------------------------------------------------------------------------------
  1030  
  1031    !
  1032    ! A subroutine below will be deleted (yot, 2010/10/29)
  1033    !
  1034    subroutine VenusSimpleNCTempEq_old( &
  1035      & xyz_Height, & ! (in)
  1036      & xyz_TempEq  & ! (out)
  1037      & )
  1038  
  1039      ! 種別型パラメタ
  1040      ! Kind type parameter
  1041      !
  1042      use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
  1043        &                 STRING     ! 文字列.       Strings.
  1044  
  1045  
  1046      ! 格子点設定
  1047      ! Grid points settings
  1048      !
  1049      use gridset, only: imax, & ! 経度格子点数.
  1050                                 ! Number of grid points in longitude
  1051        &                jmax, & ! 緯度格子点数.
  1052                                 ! Number of grid points in latitude
  1053        &                kmax    ! 鉛直層数.
  1054                                 ! Number of vertical level
  1055  
  1056      ! 物理定数設定
  1057      ! Physical constants settings
  1058      !
  1059      use constants, only: &
  1060        & Grav, &               ! $ g $ [m s-2].
  1061                                ! 重力加速度.
  1062                                ! Gravitational acceleration
  1063        & CpDry
  1064                                ! $ C_p $ [J kg-1 K-1].
  1065                                ! 乾燥大気の定圧比熱.
  1066                                ! Specific heat of air at constant pressure
  1067  
  1068      use axesset, only: &
  1069        & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
  1070        & z_Sigma               ! $ \sigma $ レベル (整数).
  1071                                ! Full $ \sigma $ level
  1072  
  1073      real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
  1074      real(DP), intent(out) :: xyz_TempEq(0:imax-1,1:jmax,1:kmax )
  1075  
  1076  
  1077      !
  1078      ! local variables
  1079      !
  1080      real(DP)   :: SurfTemp
  1081      real(DP)   :: z( 5 ), a( 6 ), ah( 5 ), d( 5 )
  1082      integer(4) :: l
  1083  
  1084  
  1085      ! Coefficients for thermal structure by Hou and Farrel (1987)
  1086      !
  1087  !!$    z ( 1 ) =   0.0d3
  1088  !!$    z ( 2 ) =  10.0d3
  1089  !!$    z ( 3 ) =  25.0d3
  1090  !!$    z ( 4 ) =  55.0d3
  1091  !!$    z ( 5 ) = 100.0d3
  1092  !!$
  1093  !!$    ah( 1 ) =  -1.0d-3
  1094  !!$    ah( 2 ) =  -1.0d-3
  1095  !!$    ah( 3 ) =  -3.1d-3
  1096  !!$    ah( 4 ) =  -6.75d-3
  1097  !!$    ah( 5 ) =  10.0d-3
  1098  !!$
  1099  !!$    d ( 1 ) =  10.0d3
  1100  !!$    d ( 2 ) =  10.0d3
  1101  !!$    d ( 3 ) =   8.0d3
  1102  !!$    d ( 4 ) =   5.0d3
  1103  !!$    d ( 5 ) =  70.0d3
  1104  
  1105  
  1106      ! Slightly modified coefficients for thermal structure by Hou and Farrel (1987)
  1107      !
  1108      z ( 1 ) =   0.0e3_DP
  1109      z ( 2 ) =  10.0e3_DP
  1110      z ( 3 ) =  25.0e3_DP
  1111  !!$    z ( 4 ) =  55.0e3_DP
  1112      z ( 4 ) =  50.0e3_DP
  1113      z ( 5 ) = 100.0e3_DP
  1114  
  1115      ah( 1 ) =  -1.0e-3_DP
  1116      ah( 2 ) =  -1.0e-3_DP
  1117  !!$    ah( 3 ) =  -3.1e-3_DP
  1118      ah( 3 ) =  -2.0e-3_DP
  1119  !!$    ah( 4 ) =  -6.75e-3_DP
  1120      ah( 4 ) =  -3.0e-3_DP
  1121      ah( 5 ) =  10.0e-3_DP
  1122  
  1123      d ( 1 ) =  10.0e3_DP
  1124      d ( 2 ) =  10.0e3_DP
  1125  !!$    d ( 3 ) =   8.0e3_DP
  1126      d ( 3 ) =  15.0e3_DP
  1127  !!$    d ( 4 ) =   5.0e3_DP
  1128      d ( 4 ) =  10.0e3_DP
  1129      d ( 5 ) =  70.0e3_DP
  1130  
  1131  
  1132  
  1133      a ( 1 ) =   0.0e0_DP
  1134  
  1135      do l = 2, 6
  1136        a( l ) = 2.0_DP * ah( l-1 ) * d( l-1 ) + a( l-1 )
  1137      end do
     .        a(2) = 2.00000000000000e+000*ah(1)*d(1) + a(1)                    
     .        a(3) = 2.00000000000000e+000*ah(2)*d(2) + a(2)                    
     .        a(4) = 2.00000000000000e+000*ah(3)*d(3) + a(3)                    
     .        a(5) = 2.00000000000000e+000*ah(4)*d(4) + a(4)                    
     .        a(6) = 2.00000000000000e+000*ah(5)*d(5) + a(5)                    
  1138  
  1139  
  1140      SurfTemp = 750.0_DP
  1141      xyz_TempEq = SurfTemp - Grav / CpDry * xyz_Height
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t136 = 1, kmax*jmax*imax                                       
     .           xyz_tempeq(t136-1,1,1) = surftemp - grav/cpdry*xyz_height(t136-
     .       1      1,1,1)                                                      
     .        enddo                                                             
  1142  
  1143      do l = 1, 5
  1144  !!$      if ( l == 4 ) cycle
  1145        xyz_TempEq = xyz_TempEq &
     .        d1 = 1.D0/d(l)                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_tempeq,xyz_height)                                     
     .        do t148 = 1, kmax*jmax*imax                                       
     .           xyz_tempeq(t148-1,1,1) = xyz_tempeq(t148-1,1,1) - ((a(l+1)-a(l)
     .       1      )*5.00000000000000e-001)*(1.00000000000000e+000 + dtanh((   
     .       2      0.0000000000000000e+000 - z(l))/d(l)))                      
     .           xyz_tempeq(t148-1,1,1) = xyz_tempeq(t148-1,1,1) + ((a(l+1)-a(l)
     .       1      )*5.00000000000000e-001)*(1.00000000000000e+000 + dtanh((   
     .       2      xyz_height(t148-1,1,1)-z(l))*d1))                           
     .        enddo                                                             
  1146          & - ( a(l+1) - a(l) ) * 0.5_DP &
  1147          &   * ( 1.0_DP + tanh( ( 0.0_DP      - z(l) ) / d(l) ) )
  1148        xyz_TempEq = xyz_TempEq &
  1149          & + ( a(l+1) - a(l) ) * 0.5_DP &
  1150          &   * ( 1.0_DP + tanh( ( xyz_Height - z(l) ) / d(l) ) )
  1151      end do
  1152  
  1153  !!$    do l = 1, kmax
  1154  !!$      write( 90, * ) xyz_TempEq(0,jmax/2+1,l), z_sigma(l)
  1155  !!$    end do
  1156  !!$    call flush( 90 )
  1157  !!$    stop
  1158  
  1159  
  1160    end subroutine VenusSimpleNCTempEq_old
  1161  
  1162    !--------------------------------------------------------------------------------------
  1163  
  1164    !
  1165    ! A subroutine below will be deleted (yot, 2010/10/29)
  1166    !
  1167  
  1168    subroutine VenusSimpleDTempDtRadS_old(   &
  1169      & y_CosLat, xyz_Press, xyz_Height, & ! (in)
  1170      & xyz_DTempDtRadS                  & ! (out)
  1171      )
  1172  
  1173      ! 物理定数設定
  1174      ! Physical constants settings
  1175      !
  1176      use constants, only: &
  1177        & Grav, &               ! $ g $ [m s-2].
  1178                                ! 重力加速度.
  1179                                ! Gravitational acceleration
  1180        & CpDry, &
  1181                                ! $ C_p $ [J kg-1 K-1].
  1182                                ! 乾燥大気の定圧比熱.
  1183                                ! Specific heat of air at constant pressure
  1184        & GasRDry
  1185  
  1186      ! 種別型パラメタ
  1187      ! Kind type parameter
  1188      !
  1189      use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
  1190        &                 STRING     ! 文字列.       Strings.
  1191  
  1192  
  1193      ! 格子点設定
  1194      ! Grid points settings
  1195      !
  1196      use gridset, only: imax, & ! 経度格子点数.
  1197                                 ! Number of grid points in longitude
  1198        &                jmax, & ! 緯度格子点数.
  1199                                 ! Number of grid points in latitude
  1200        &                kmax    ! 鉛直層数.
  1201                                 ! Number of vertical level
  1202  
  1203      real(DP), intent(in ) :: y_CosLat       (1:jmax)
  1204      real(DP), intent(in ) :: xyz_Press      (0:imax-1,1:jmax,1:kmax)
  1205      real(DP), intent(in ) :: xyz_Height     (0:imax-1,1:jmax,1:kmax)
  1206      real(DP), intent(out) :: xyz_DTempDtRadS(0:imax-1,1:jmax,1:kmax)
  1207  
  1208  
  1209      !
  1210      ! local variables
  1211      !
  1212      real(DP)   :: scaleheight
  1213      real(DP)   :: DTempDtRadSMax
  1214      integer(4) :: i, j, k
  1215  
  1216  
  1217  !!$    xyz_DTempDtRadS &
  1218  !!$      & = 5.0d0 / dayearth * exp( - ( ( xyz_Height - 55.0d3 ) / 10.0d3 )**2  )
  1219  !!$
  1220  !!$    do k = 1, kmax
  1221  !!$      do j = 1, jmax
  1222  !!$        do i = 0, imax-1
  1223  !!$          if( xyz_Height(i,j,k) .le. 55.0d3 ) then
  1224  !!$            if( xyz_DTempDtRadS(i,j,k) .lt. 0.5d0 / dayearth ) then
  1225  !!$              xyz_DTempDtRadS(i,j,k) = 0.5d0 / dayearth
  1226  !!$            end if
  1227  !!$          end if
  1228  !!$        end do
  1229  !!$      end do
  1230  !!$    end do
  1231  
  1232  
  1233      scaleheight = GasRDry * 300.0_DP / Grav
  1234  
  1235      xyz_DTempDtRadS &
     .        d1 = 1.D0/5.00000000000000e+004                                   
     .        d2 = 1.D0/(2.00000000000000e+000*scaleheight)                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t149 = 1, kmax*jmax*imax                                       
     .           xyz_dtempdtrads(t149-1,1,1) = 5.78703703703703e-005*dexp((-((- 
     .       1      scaleheight*dlog(xyz_press(t149-1,1,1)*d1))*d2)**2))        
     .        enddo                                                             
  1236        & = 5.0_DP / DayEarth &
  1237        & * exp( - ( ( - scaleheight * log( xyz_Press / 500.0e2_DP ) ) / ( 2.0_DP * scaleheight ) )**2 )
  1238  
  1239      do k = 1, kmax
  1240        do j = 1, jmax
  1241          do i = 0, imax-1
  1242            if ( xyz_Press(i,j,k) > 500.0e2_DP ) then
  1243              if ( xyz_DTempDtRadS(i,j,k) .lt. 0.5_DP / DayEarth ) then
  1244                xyz_DTempDtRadS(i,j,k) = 0.5_DP / DayEarth
  1245              end if
  1246            end if
  1247          end do
  1248        end do
  1249      end do
  1250  
  1251  
  1252  
  1253  
  1254  !!$    do k = 1, kmax
  1255  !!$      do j = 1, jmax
  1256  !!$        do i = 0, imax-1
  1257  
  1258  
  1259  !!$          if( xyz_Press(i,j,k) .le. 1.0d5 ) then
  1260  !!$!                  gswrh( i, j, k ) = 5.0d0 / dayearth
  1261  !!$            xyz_DTempDtRadS(i,j,k) = 5.0d0 / dayearth &
  1262  !!$              & * exp( - ( 5.0d3 * log( xyz_Press(i,j,k) / 1.0d5 ) / 15.0d3 )**2  )
  1263  !!$          else
  1264  !!$            xyz_DTempDtRadS(i,j,k) &
  1265  !!$              & = log( ( 5.0d0 / dayearth ) / ( 1.0d-4 / dayearth ) ) &
  1266  !!$              & / log(   1.0d5              /   100.0d5             ) &
  1267  !!$              & * log(   xyz_Press(i,j,k)   /   100.0d5             ) &
  1268  !!$              & + log(   1.0d-4 / dayearth  )
  1269  !!$            xyz_DTempDtRadS(i,j,k) = exp( xyz_DTempDtRadS(i,j,k) )
  1270  !!$            if( xyz_DTempDtRadS(i,j,k) .lt. 0.5d0 / dayearth ) then
  1271  !!$              xyz_DTempDtRadS(i,j,k) = 0.5d0 / dayearth
  1272  !!$            end if
  1273  !!$          end if
  1274  
  1275  
  1276            !-----
  1277  
  1278  
  1279  !!$          DTempDtRadSMax = 3.0d0 / dayearth
  1280  !!$
  1281  !!$          if( xyz_Press(i,j,k) .le. 1.0d4 ) then
  1282  !!$            xyz_DTempDtRadS(i,j,k) = DTempDtRadSMax &
  1283  !!$              & * exp( - ( 5.0d3 * log( xyz_Press(i,j,k) / 1.0d4 ) / 10.0d3 )**2  )
  1284  !!$          else if( xyz_Press(i,j,k) .le. 1.0d5 ) then
  1285  !!$            xyz_DTempDtRadS(i,j,k) = DTempDtRadSMax
  1286  !!$
  1287  !!$!               if( gp( i, j, k ) .le. 1.0d5 ) then
  1288  !!$!                  gswrh( i, j, k ) = sw_hr_peak &
  1289  !!$!                       * exp( - ( 5.0d3 * log( gp( i, j, k ) / 1.0d5 ) / 15.0d3 )**2  )
  1290  !!$
  1291  !!$          else
  1292  !!$            xyz_DTempDtRadS(i,j,k) &
  1293  !!$              & = log( DTempDtRadSMax       / ( 1.0d-4 / dayearth ) ) &
  1294  !!$              & / log(   1.0d5              /   100.0d5             ) &
  1295  !!$              & * log( xyz_Press(i,j,k)     /   100.0d5             ) &
  1296  !!$              & + log(   1.0d-4 / dayearth  )
  1297  !!$            xyz_DTempDtRadS(i,j,k) = exp( xyz_DTempDtRadS(i,j,k) )
  1298  !!$            if( xyz_DTempDtRadS(i,j,k) .lt. 0.5d0 / dayearth ) then
  1299  !!$              xyz_DTempDtRadS(i,j,k) = 0.5d0 / dayearth
  1300  !!$            end if
  1301  !!$!                  if( gswrh( i, j, k ) .lt. 0.15d0 / dayearth ) then
  1302  !!$!                     gswrh( i, j, k ) = 0.15d0 / dayearth
  1303  !!$!                  end if
  1304  !!$          end if
  1305  
  1306  
  1307  !!$        end do
  1308  !!$      end do
  1309  !!$    end do
  1310  
  1311  
  1312      do k = 1, kmax
  1313        do j = 1, jmax
  1314          do i = 0, imax-1
  1315            xyz_DTempDtRadS(i,j,k) = xyz_DTempDtRadS(i,j,k) * y_CosLat(j)
  1316          end do
  1317        end do
  1318      end do
     .        do k = 1, kmax                                                    
     .           do j = 1, jmax                                                 
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_press(i-1,j,k) .gt. 5.00000000000000e+004) then  
     .                    if (xyz_dtempdtrads(i-1,j,k) .lt.                     
     .       1               5.78703703703703e-006) then                        
     .                       xyz_dtempdtrads(i-1,j,k) = 5.78703703703703e-006   
     .                    endif                                                 
     .                 endif                                                    
     .                 xyz_dtempdtrads(i-1,j,k) = xyz_dtempdtrads(i-1,j,k)*     
     .       1            y_coslat(j)                                           
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
  1319  
  1320  
  1321    end subroutine VenusSimpleDTempDtRadS_old
  1322  
  1323    !--------------------------------------------------------------------------------------
  1324  
  1325  end module yt2003_forcing
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:47 2016
FILE NAME: yt2003_forcing.f90
PROGRAM NAME: yt2003_forcing
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Yamamoto and Takahashi (2003) に従った簡単金星計算のための強制
     2:             !
     3:             != forcing for simple Venus calculation following Yamamoto and Takahashi (2003)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi (code by Shin-ichi Takehiro is included)
     6:             ! Version::   $Id: yt2003_forcing.f90,v 1.7 2014/05/07 09:39:18 murashin Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module yt2003_forcing
    13:               !
    14:               != Yamamoto and Takahashi (2003) に従った簡単金星計算のための強制
    15:               !
    16:               != forcing for simple Venus calculation following Yamamoto and Takahashi (2003)
    17:             
    18:               !== Procedures List
    19:               !
    20:             !!$  ! Hs94Forcing   :: 強制と散逸の計算
    21:             !!$  ! Hs94Finalize  :: 終了処理 (モジュール内部の変数の割り付け解除)
    22:             !!$  ! ------------  :: ------------
    23:             !!$  ! Hs94Forcing   :: Calculate forcing and dissipation
    24:             !!$  ! Hs94Finalize  :: Termination (deallocate variables in this module)
    25:               !
    26:               !--
    27:               !== NAMELIST
    28:               !
    29:               ! NAMELIST#venus_simple_forcing_nml
    30:               !++
    31:               !== References
    32:               !
    33:               ! * Yamamoto, M, and M. Takahashi, 2003:
    34:               !   The Fully Developed Superrotation Simulated by a General Circulation Model 
    35:               !   of a Venus-like Atmosphere, 
    36:               !   <i>J. Atmos. Sci.</i>, <b>60</b>, 561--574.
    37:               ! * Hou, A. Y., and B. F. Farrell, 1987:
    38:               !   Superrotation Induced by Critical-Level Absorption of Gravity Waves on Venus:
    39:               !   An Assessment, 
    40:               !   <i>J. Atmos. Sci.</i>, <b>44</b>, 1049--1061.
    41:               !
    42:             
    43:               ! モジュール引用 ; USE statements
    44:               !
    45:             
    46:               ! 種別型パラメタ
    47:               ! Kind type parameter
    48:               !
    49:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    50:                 &                 STRING     ! 文字列.       Strings.
    51:             
    52:               ! メッセージ出力
    53:               ! Message output
    54:               !
    55:               use dc_message, only: MessageNotify
    56:             
    57:               ! 宣言文 ; Declaration statements
    58:               !
    59:               implicit none
    60:               private
    61:             
    62:               real(DP), parameter :: DayEarth = 86400.0d0
    63:             
    64:               real(DP), save      :: SurfFrictionTimeConstInEarthDay
    65:               logical , save      :: FlagConstNCC
    66:               real(DP), save      :: ConstNCCInEarthDay
    67:             
    68:             
    69:               real(DP), save :: a_YT2003Temp      (0:25)
    70:               real(DP), save :: a_YT2003HeightForT(0:25)
    71:               real(DP), save :: a_YT2003Q         (0:20)
    72:               real(DP), save :: a_YT2003HeightForQ(0:20)
    73:             
    74:               ! 公開手続き
    75:               ! Public procedure
    76:               !
    77:               public :: YT2003Forcing
    78:               public :: YT2003ForcingInit
    79:             
    80:               ! 公開変数
    81:               ! Public variables
    82:               !
    83:             
    84:               ! 非公開変数
    85:               ! Private variables
    86:               !
    87:               logical, save :: venus_simple_forcing_inited = .false.
    88:                                           ! 初期設定フラグ.
    89:                                           ! Initialization flag
    90:             
    91:               character(*), parameter:: module_name = 'venus_simple_forcing_1994'
    92:                                           ! モジュールの名称.
    93:                                           ! Module name
    94:               character(*), parameter:: version = &
    95:                 & '$Name:  $' // &
    96:                 & '$Id: yt2003_forcing.f90,v 1.7 2014/05/07 09:39:18 murashin Exp $'
    97:                                           ! モジュールのバージョン
    98:                                           ! Module version
    99:             
   100:               !--------------------------------------------------------------------------------------
   101:             
   102:             contains
   103:             
   104:               subroutine YT2003Forcing(                                &
   105:                 & xy_SurfHeight,                                       & ! (in )
   106:                 & xyz_UB, xyz_VB, xyz_TempB, xyz_VirTemp, xyr_VirTemp, & ! (in )
   107:                 & xy_PsB, xyz_Press, xyr_Press, xyr_Temp,              & ! (in )
   108:                 & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,        & ! (in )
   109:                 & xyz_DUDt, xyz_DVDt, xyz_DTempDt                      & ! (out)
   110:                 & )
   111:             
   112:                 ! モジュール引用 ; USE statements
   113:                 !
   114:             
   115:                 ! 格子点設定
   116:                 ! Grid points settings
   117:                 !
   118:                 use gridset, only: imax, & ! 経度格子点数.
   119:                                            ! Number of grid points in longitude
   120:                   &                jmax, & ! 緯度格子点数.
   121:                                            ! Number of grid points in latitude
   122:                   &                kmax    ! 鉛直層数.
   123:                                            ! Number of vertical level
   124:             
   125:                 ! 組成に関わる配列の設定
   126:                 ! Settings of array for atmospheric composition
   127:                 !
   128:                 use composition, only: &
   129:                   &                    ncmax
   130:                                           ! 成分の数
   131:                                           ! Number of composition
   132:             
   133:                 ! 鉛直拡散フラックス
   134:                 ! Vertical diffusion flux
   135:                 !
   136:                 use vdiffusion_my, only: VDiffusion, VDiffusionExpTendency
   137:             
   138:                 real(DP), intent(in ) :: xy_SurfHeight(0:imax-1,1:jmax)
   139:                 real(DP), intent(in ) :: xyz_UB       (0:imax-1,1:jmax,1:kmax)
   140:                 real(DP), intent(in ) :: xyz_VB       (0:imax-1,1:jmax,1:kmax)
   141:                 real(DP), intent(in ) :: xyz_TempB    (0:imax-1,1:jmax,1:kmax)
   142:                 real(DP), intent(in ) :: xy_PsB       (0:imax-1,1:jmax)
   143:                 real(DP), intent(in ) :: xyz_Press    (0:imax-1,1:jmax,1:kmax)
   144:                 real(DP), intent(in ) :: xyr_Press    (0:imax-1,1:jmax,0:kmax)
   145:                 real(DP), intent(in ) :: xyr_Temp     (0:imax-1,1:jmax,0:kmax)
   146:                 real(DP), intent(in ) :: xyz_VirTemp  (0:imax-1,1:jmax,1:kmax)
   147:                 real(DP), intent(in ) :: xyr_VirTemp  (0:imax-1,1:jmax,0:kmax)
   148:                 real(DP), intent(in ) :: xyz_Height   (0:imax-1,1:jmax,1:kmax)
   149:                 real(DP), intent(in ) :: xyr_Height   (0:imax-1,1:jmax,0:kmax)
   150:                 real(DP), intent(in ) :: xyz_Exner    (0:imax-1,1:jmax,1:kmax)
   151:                 real(DP), intent(in ) :: xyr_Exner    (0:imax-1,1:jmax,0:kmax)
   152:                 real(DP), intent(out) :: xyz_DUDt     (0:imax-1,1:jmax,1:kmax)
   153:                 real(DP), intent(out) :: xyz_DVDt     (0:imax-1,1:jmax,1:kmax)
   154:                 real(DP), intent(out) :: xyz_DTempDt  (0:imax-1,1:jmax,1:kmax)
   155:             
   156:             
   157:                 !
   158:                 ! local variables
   159:                 !
   160:                 real(DP) :: xyz_DTempDtRadL   (0:imax-1,1:jmax,1:kmax)
   161:                 real(DP) :: xyz_DTempDtRadS   (0:imax-1,1:jmax,1:kmax)
   162:             
   163:                 real(DP) :: xyz_DUDtSFCFric   (0:imax-1,1:jmax,1:kmax)
   164:                 real(DP) :: xyz_DVDtSFCFric   (0:imax-1,1:jmax,1:kmax)
   165:                 real(DP) :: xyz_DTempDtSFCFric(0:imax-1,1:jmax,1:kmax)
   166:             
   167:                 real(DP) :: xyzf_QMix         (0:imax-1,1:jmax,1:kmax,1:ncmax)
   168:             
   169:                 real(DP) :: xyr_MomFluxX      (0:imax-1,1:jmax,0:kmax)
   170:                 real(DP) :: xyr_MomFluxY      (0:imax-1,1:jmax,0:kmax)
   171:                 real(DP) :: xyr_HeatFlux      (0:imax-1,1:jmax,0:kmax)
   172:                 real(DP) :: xyrf_QMixFlux     (0:imax-1,1:jmax,0:kmax,1:ncmax)
   173:                 real(DP) :: xyr_VelTransCoef  (0:imax-1,1:jmax,0:kmax)
   174:                 real(DP) :: xyr_TempTransCoef (0:imax-1,1:jmax,0:kmax)
   175:                 real(DP) :: xyr_QMixTransCoef (0:imax-1,1:jmax,0:kmax)
   176:                 real(DP) :: xyz_DUDtVDiff     (0:imax-1,1:jmax,1:kmax)
   177:                 real(DP) :: xyz_DVDtVDiff     (0:imax-1,1:jmax,1:kmax)
   178:                 real(DP) :: xyz_DTempDtVDiff  (0:imax-1,1:jmax,1:kmax)
   179:             
   180:             
   181:                 ! 初期化確認
   182:                 ! Initialization check
   183:                 !
   184:                 if ( .not. venus_simple_forcing_inited ) then
   185:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   186:                 end if
   187:             
   188:             
   189:                 call YT2003RadForcing(           &
   190:                   & xy_PsB, xyz_Press, xyz_TempB, xyz_Height, & ! (in )
   191:                   & xyz_DTempDtRadL, xyz_DTempDtRadS          & ! (out)
   192:                   & )
   193:             
   194:             
   195:                 call YT2003SurfFriction( &
   196:                   & xyz_UB, xyz_VB, xyz_TempB,       & ! (in )
   197:                   & xyz_DUDtSFCFric, xyz_DVDtSFCFric, xyz_DTempDtSFCFric  & ! (out)
   198:                   & )
   199:             
   200:             
   201:                 ! This is set temporarily
   202:                 !
   203: W***=== A       xyzf_QMix = 0.0_DP
   204:             
   205:                 call VDiffusion(                                               &
   206:                   & xyz_UB,     xyz_VB,     xyzf_QMix,                         & ! (in)
   207:                   & xyz_TempB, xyr_Temp, xyz_VirTemp, xyr_VirTemp, xyr_Press,  & ! (in)
   208:                   & xy_SurfHeight,                                             & ! (in)
   209:                   & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,              & ! (in)
   210:                   & xyr_MomFluxX,  xyr_MomFluxY,  xyr_HeatFlux, xyrf_QMixFlux, & ! (out)
   211:                   & xyr_VelTransCoef, xyr_TempTransCoef,                       & ! (out)
   212:                   & xyr_QMixTransCoef                                          & ! (out)
   213:                   & )
   214:             
   215:                 call VDiffusionExpTendency(                            &
   216:                   & xyr_Press,                                               & ! (in )
   217:                   & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in ) optional
   218:                   & xyz_DUDtVDiff, xyz_DVDtVDiff, xyz_DTempDtVDiff  & ! (out) optional
   219:                   & )
   220:             
   221:             
   222: **W---->A       xyz_DUDt    =   xyz_DUDtVDiff    + xyz_DUDtSFCFric
   223: |||     A       xyz_DVDt    =   xyz_DVDtVDiff    + xyz_DVDtSFCFric
   224: |||         
   225: **W---- A       xyz_DTempDt =   xyz_DTempDtVDiff + xyz_DTempDtSFCFric &
   226:                   &           + xyz_DTempDtRadL  + xyz_DTempDtRadS
   227:             
   228:             
   229:               end subroutine YT2003Forcing
   230:             
   231:               !--------------------------------------------------------------------------------------
   232:             
   233:               subroutine YT2003RadForcing(                &
   234:                 & xy_Ps, xyz_Press, xyz_Temp, xyz_Height, & ! (in )
   235:                 & xyz_DTempDtRadL, xyz_DTempDtRadS        & ! (out)
   236:                 & )
   237:             
   238:                 ! モジュール引用 ; USE statements
   239:                 !
   240:             
   241:                 ! 時刻管理
   242:                 ! Time control
   243:                 !
   244:                 use timeset, only: &
   245:                   & DelTime, &            ! $ \Delta t $
   246:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   247:                   & TimesetClockStart, TimesetClockStop
   248:             
   249:                 ! ヒストリデータ出力
   250:                 ! History data output
   251:                 !
   252:                 use gtool_historyauto, only: HistoryAutoPut
   253:             
   254:                 ! 格子点設定
   255:                 ! Grid points settings
   256:                 !
   257:                 use gridset, only: imax, & ! 経度格子点数.
   258:                                            ! Number of grid points in longitude
   259:                   &                jmax, & ! 緯度格子点数.
   260:                                            ! Number of grid points in latitude
   261:                   &                kmax    ! 鉛直層数.
   262:                                            ! Number of vertical level
   263:             
   264:                 ! 物理定数設定
   265:                 ! Physical constants settings
   266:                 !
   267:                 use constants, only: &
   268:                   & Grav, &               ! $ g $ [m s-2].
   269:                                           ! 重力加速度.
   270:                                           ! Gravitational acceleration
   271:                   & CpDry, &
   272:                                           ! $ C_p $ [J kg-1 K-1].
   273:                                           ! 乾燥大気の定圧比熱.
   274:                                           ! Specific heat of air at constant pressure
   275:                   & GasRDry
   276:                                           ! $ R $ [J kg-1 K-1].
   277:                                           ! 乾燥大気の気体定数.
   278:                                           ! Gas constant of air
   279:             
   280:                 ! 座標データ設定
   281:                 ! Axes data settings
   282:                 !
   283:                 use axesset, only: &
   284:                   & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   285:                   & z_Sigma               ! $ \sigma $ レベル (整数).
   286:                                           ! Full $ \sigma $ level
   287:             
   288:             
   289:                 real(DP), intent(in ):: xy_Ps          (0:imax-1,1:jmax)
   290:                 real(DP), intent(in ):: xyz_Press      (0:imax-1,1:jmax,1:kmax)
   291:                 real(DP), intent(in ):: xyz_Temp       (0:imax-1,1:jmax,1:kmax)
   292:                 real(DP), intent(in ):: xyz_Height     (0:imax-1,1:jmax,1:kmax)
   293:                 real(DP), intent(out):: xyz_DTempDtRadL(0:imax-1,1:jmax,1:kmax)
   294:                 real(DP), intent(out):: xyz_DTempDtRadS(0:imax-1,1:jmax,1:kmax)
   295:             
   296:             
   297:                 !
   298:                 ! local variables
   299:                 !
   300:                 real(DP) :: y_CosLat(1:jmax)
   301:                 real(DP) :: xyz_TempEq(0:imax-1,1:jmax,1:kmax)
   302:                 real(DP) :: xyz_NCC   (0:imax-1,1:jmax,1:kmax)
   303:                 real(DP) :: xyz_EquivTempEq(0:imax-1,1:jmax,1:kmax)
   304:                 real(DP) :: xyz_Geopot(0:imax-1,1:jmax,1:kmax)
   305:                 real(DP) :: xyz_UBalance(0:imax-1,1:jmax,1:kmax)
   306:                 integer  :: j, k
   307:                 integer  :: jp, jn
   308:             
   309:             
   310: V====== A       y_CosLat = cos( y_Lat )
   311:             
   312:                 call YT2003NCTempEq( &
   313:                   & xyz_Height, &
   314:                   & xyz_TempEq  &
   315:                   & )
   316:             
   317:                 call YT2003NCCoef( &
   318:                   & xy_Ps, xyz_Press, &
   319:                   & xyz_NCC &
   320:                   & )
   321:             
   322: **V---->A       xyz_DTempDtRadL = - xyz_NCC * ( xyz_Temp - xyz_TempEq )
   323: |||         
   324: |||             !
   325: |||             !  add global mean cooling rate
   326: |||             !
   327: **V---- A       xyz_DTempDtRadL = xyz_DTempDtRadL - xyz_YT2003Q0( xyz_Height ) / DayEarth
   328:             
   329:             
   330:                 call YT2003DTempDtRadS(   &
   331:                   & y_CosLat, xyz_Height,            & ! (in)
   332:                   & xyz_DTempDtRadS                  & ! (out)
   333:                   & )
   334:             
   335:             
   336:                 !
   337:                 ! code for debug
   338:                 !
   339:             !!$    do k = 1, kmax
   340:             !!$      do j = 1, jmax
   341:             !!$        do i = 0, imax-1
   342:             !!$           xyz_DTempDtRadS(i,j,k) = xyz_DTempDtRadS(i,j,k) &
   343:             !!$             & - Q0YT2003( xyz_Height(i,j,k) ) / DayEarth
   344:             !!$        end do
   345:             !!$      end do
   346:             !!$    end do
   347:             !!$
   348:             !!$    i = 0
   349:             !!$    do k = 1, kmax
   350:             !!$      do j = 1, jmax
   351:             !!$        write( 60, * ) j, xyz_Press(i,j,k), xyz_Height(i,j,k), xyz_DTempDtRadS(i,j,k) * DayEarth
   352:             !!$      end do
   353:             !!$      write( 60, * )
   354:             !!$    end do
   355:             !!$    call flush( 60 )
   356:             !!$
   357:             !!$    i = 0
   358:             !!$    j = jmax/2+1
   359:             !!$    do k = 1, kmax
   360:             !!$      write( 61, * ) k, xyz_Height(i,j,k), xyz_Press(i,j,k), &
   361:             !!$        & 1.0d0 / xyz_NCC(i,j,k) / DayEarth, xyz_TempEq(i,j,k), xyz_DTempDtRadS(i,j,k) * DayEarth
   362:             !!$    end do
   363:             !!$    call flush( 61 )
   364:             !!$    stop
   365:             
   366:             
   367:                 !
   368:                 ! In the following, output variables are calculated. 
   369:                 ! Variables calculated below are used only for output. 
   370:                 !
   371:             
   372: ++V==== A       xyz_EquivTempEq = xyz_TempEq                                      &
   373:                   & + ( xyz_DTempDtRadS - xyz_YT2003Q0( xyz_Height ) / DayEarth ) &
   374:                   &   / ( xyz_NCC + 1.0e-100_DP )
   375:             
   376:             
   377:                 ! dp/dz = -rho g
   378:                 ! dp / dphi = -rho
   379:                 ! dphi / dp = -1/rho = - R T / p
   380:                 ! p dphi / dp = -1/rho = - R T
   381:                 ! dphi / dlogp = - R T
   382:             
   383:                 k = 1
   384: W*===== A       xyz_Geopot(:,:,k) = 0.0_DP             &
   385:                   & - GasRDry * xyz_EquivTempEq(:,:,k) &
   386:                   & * log( z_Sigma(k) )
   387: +------>        do k = 2, kmax
   388: |W*==== A         xyz_Geopot(:,:,k) = xyz_Geopot(:,:,k-1)                                       &
   389: |                   & - GasRDry * ( xyz_EquivTempEq(:,:,k-1) + xyz_EquivTempEq(:,:,k) ) * 0.5d0 &
   390: |                   & * log( z_Sigma(k) / z_Sigma(k-1) )
   391: +------         end do
   392:             
   393: +------>        do k = 1, kmax
   394: |+----->          do j = 1, jmax
   395: ||                  if ( j == 1 ) then
   396: ||                    jp = 1
   397: ||                    jn = j + 1
   398: ||                  else if ( j == jmax ) then
   399: ||                    jp = j - 1
   400: ||                    jn = jmax
   401: ||                  else
   402: ||                    jp = j - 1
   403: ||                    jn = j + 1
   404: ||                  end if
   405: ||V==== A           xyz_UBalance(:,j,k) =                                                       &
   406: ||                    & sqrt( - ( xyz_Geopot(:,jn,k) - xyz_Geopot(:,jp,k) )                     &
   407: ||                    &       / ( y_Lat(jn)          - y_Lat(jp)          ) / tan( y_Lat(j) ) )
   408: |+-----           end do
   409: +------         end do
   410:             
   411:             
   412:                 ! ヒストリデータ出力
   413:                 ! History data output
   414:                 !
   415:                 call HistoryAutoPut( TimeN, 'VTempEq'     , xyz_TempEq )
   416:                 call HistoryAutoPut( TimeN, 'VSRadHR'     , xyz_DTempDtRadS )
   417:                 call HistoryAutoPut( TimeN, 'VEquivTempEq', xyz_EquivTempEq )
   418:                 call HistoryAutoPut( TimeN, 'VUBalance'   , xyz_UBalance )
   419:             
   420:             
   421:               end subroutine YT2003RadForcing
   422:             
   423:               !--------------------------------------------------------------------------------------
   424:             
   425:               subroutine YT2003NCTempEq( &
   426:                 & xyz_Height, & ! (in)
   427:                 & xyz_TempEq  & ! (out)
   428:                 & )
   429:             
   430:                 ! 種別型パラメタ
   431:                 ! Kind type parameter
   432:                 !
   433:                 use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   434:                   &                 STRING     ! 文字列.       Strings.
   435:             
   436:             
   437:                 ! 格子点設定
   438:                 ! Grid points settings
   439:                 !
   440:                 use gridset, only: imax, & ! 経度格子点数.
   441:                                            ! Number of grid points in longitude
   442:                   &                jmax, & ! 緯度格子点数.
   443:                                            ! Number of grid points in latitude
   444:                   &                kmax    ! 鉛直層数.
   445:                                            ! Number of vertical level
   446:             
   447:                 real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
   448:                 real(DP), intent(out) :: xyz_TempEq(0:imax-1,1:jmax,1:kmax)
   449:             
   450:             
   451:                 !
   452:                 ! local variables
   453:                 !
   454:             
   455:                 xyz_TempEq = xyz_YT2003TempEq( xyz_Height )
   456:             
   457:             
   458:               end subroutine YT2003NCTempEq
   459:             
   460:               !--------------------------------------------------------------------------------------
   461:             
   462:               subroutine YT2003NCCoef( &
   463:                 & xy_Ps, xyz_Press,         & ! (in)
   464:                 & xyz_NCC                   & ! (out)
   465:                 & )
   466:             
   467:                 ! 種別型パラメタ
   468:                 ! Kind type parameter
   469:                 !
   470:                 use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   471:                   &                 STRING     ! 文字列.       Strings.
   472:             
   473:             
   474:                 ! 格子点設定
   475:                 ! Grid points settings
   476:                 !
   477:                 use gridset, only: imax, & ! 経度格子点数.
   478:                                            ! Number of grid points in longitude
   479:                   &                jmax, & ! 緯度格子点数.
   480:                                            ! Number of grid points in latitude
   481:                   &                kmax    ! 鉛直層数.
   482:                                            ! Number of vertical level
   483:             
   484:                 real(DP), intent(in ) :: xy_Ps    (0:imax-1,1:jmax)
   485:                 real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   486:                 real(DP), intent(out) :: xyz_NCC  (0:imax-1,1:jmax,1:kmax)
   487:             
   488:             
   489:                 !
   490:                 ! local variables
   491:                 !
   492:                 real(DP) :: xyz_alp1  (0:imax-1,1:jmax,1:kmax)
   493:                 real(DP) :: xyz_alp2  (0:imax-1,1:jmax,1:kmax)
   494:                 real(DP) :: xyz_alp3  (0:imax-1,1:jmax,1:kmax)
   495:                 real(DP) :: xyz_lnPRat(0:imax-1,1:jmax,1:kmax)
   496:                 real(DP) :: NCTimeConst
   497:                 real(DP) :: NCTimeConst0
   498:                 integer  :: i, j, k
   499:             
   500:             
   501:                 if ( FlagConstNCC ) then
   502:             
   503: ++V==== A         xyz_NCC = 1.0_DP / ( ConstNCCInEarthDay * DayEarth )
   504:             
   505:                 else
   506:             
   507:                   ! Thermal damping coefficient by Hou and Farrel (1987)
   508:                   !
   509: +------>          do k = 1, kmax
   510: |W*==== A           xyz_lnPRat(:,:,k) = log( xyz_Press(:,:,k) / xy_Ps(:,:) )
   511: +------           end do
   512: W------>          do k = 1, kmax
   513: |*----->            do j = 1, jmax
   514: ||*---->              do i = 0, imax-1
   515: |||                     if( -xyz_lnPRat(i,j,k) .le. 5.0_DP ) then
   516: |||                       xyz_alp1(i,j,k) =  0.0_DP
   517: |||                       xyz_alp2(i,j,k) =  0.9_DP
   518: |||                       xyz_alp3(i,j,k) =  0.0_DP
   519: |||                     else if( -xyz_lnPRat(i,j,k) .le. 7.0_DP ) then
   520: |||                       xyz_alp1(i,j,k) = -4.5_DP
   521: |||                       xyz_alp2(i,j,k) =  2.0_DP
   522: |||                       xyz_alp3(i,j,k) =  5.0_DP
   523: |||                     else
   524: |||                       xyz_alp1(i,j,k) = -8.5_DP
   525: |||                       xyz_alp2(i,j,k) =  0.5_DP
   526: |||                       xyz_alp3(i,j,k) =  7.0_DP
   527: |||                     end if
   528: ||*----               end do
   529: |*-----             end do
   530: W------           end do
   531:                   NCTimeConst0 = 1.32e9_DP
   532: W------>          do k = 1, kmax
   533: |*----->            do j = 1, jmax
   534: ||*---->              do i = 0, imax-1
   535: |||                     NCTimeConst = NCTimeConst0                                                 &
   536: |||                       & * exp(   xyz_alp1(i,j,k)                                               &
   537: |||                       &        - xyz_alp2(i,j,k) * ( -xyz_lnPRat(i,j,k) - xyz_alp3(i,j,k) ) )
   538: |||     A               xyz_NCC(i,j,k) = 1.0_DP / NCTimeConst
   539: ||*----               end do
   540: |*-----             end do
   541: W------           end do
   542:             
   543:                 end if
   544:             
   545:             
   546:               end subroutine YT2003NCCoef
   547:             
   548:               !--------------------------------------------------------------------------------------
   549:             
   550:               subroutine YT2003DTempDtRadS(   &
   551:                 & y_CosLat, xyz_Height,            & ! (in)
   552:                 & xyz_DTempDtRadS                  & ! (out)
   553:                 & )
   554:             
   555:                 ! 種別型パラメタ
   556:                 ! Kind type parameter
   557:                 !
   558:                 use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   559:                   &                 STRING     ! 文字列.       Strings.
   560:             
   561:             
   562:                 ! 格子点設定
   563:                 ! Grid points settings
   564:                 !
   565:                 use gridset, only: imax, & ! 経度格子点数.
   566:                                            ! Number of grid points in longitude
   567:                   &                jmax, & ! 緯度格子点数.
   568:                                            ! Number of grid points in latitude
   569:                   &                kmax    ! 鉛直層数.
   570:                                            ! Number of vertical level
   571:             
   572:                 use axesset, only: &
   573:                   & y_Lat_weight             ! $ \varphi $ [rad.] . 緯度重み. Latitude
   574:             
   575:                 ! 物理・数学定数設定
   576:                 ! Physical and mathematical constants settings
   577:                 !
   578:                 use constants0, only: &
   579:                   & PI
   580:                                           ! $ \pi $ .
   581:                                           ! 円周率.  Circular constant
   582:             
   583:                 real(DP), intent(in ) :: y_CosLat       (1:jmax)
   584:                 real(DP), intent(in ) :: xyz_Height     (0:imax-1,1:jmax,1:kmax)
   585:                 real(DP), intent(out) :: xyz_DTempDtRadS(0:imax-1,1:jmax,1:kmax)
   586:             
   587:             
   588:                 !
   589:                 ! local variables
   590:                 !
   591:                 real(DP) :: GM
   592:                 integer  :: j
   593:                 integer  :: k
   594:             
   595:             
   596:             !!$    do k = 1, kmax
   597:             !!$      do j = 1, jmax
   598:             !!$        do i = 0, imax-1
   599:             !!$           xyz_DTempDtRadS(i,j,k) = Q0YT2003( xyz_Height(i,j,k) ) &
   600:             !!$             & * y_CosLat(j) * 4.0_DP / PI                        &
   601:             !!$             & / DayEarth
   602:             !!$        end do
   603:             !!$      end do
   604:             !!$    end do
   605:             
   606:             
   607: V====== A       GM = sum( y_CosLat**(7.0_DP / 5.0_DP ) * y_Lat_weight ) / sum( y_Lat_Weight )
   608:             
   609:                 xyz_DTempDtRadS = xyz_YT2003Q0( xyz_Height )
   610: +------>        do k = 1, kmax
   611: |+----->          do j = 1, jmax
   612: ||V==== A           xyz_DTempDtRadS(:,j,k) = xyz_DTempDtRadS(:,j,k)      &
   613: ||                    & * y_CosLat(j)**(7.0_DP/5.0_DP) / GM                    &
   614: ||                    & / DayEarth
   615: |+-----           end do
   616: +------         end do
   617:             
   618:             
   619:               end subroutine YT2003DTempDtRadS
   620:             
   621:               !--------------------------------------------------------------------------------------
   622:             
   623:               subroutine YT2003SurfFriction(  &
   624:                 & xyz_UB, xyz_VB, xyz_TempB,       & ! (in )
   625:                 & xyz_DUDt, xyz_DVDt, xyz_DTempDt  & ! (out)
   626:                 & )
   627:             
   628:                 ! モジュール引用 ; USE statements
   629:                 !
   630:             
   631:                 ! 格子点設定
   632:                 ! Grid points settings
   633:                 !
   634:                 use gridset, only: imax, & ! 経度格子点数.
   635:                                            ! Number of grid points in longitude
   636:                   &                jmax, & ! 緯度格子点数.
   637:                                            ! Number of grid points in latitude
   638:                   &                kmax    ! 鉛直層数.
   639:                                            ! Number of vertical level
   640:             
   641:                 ! 物理定数設定
   642:                 ! Physical constants settings
   643:                 !
   644:                 use constants, only: &
   645:                   & Grav, &               ! $ g $ [m s-2].
   646:                                           ! 重力加速度.
   647:                                           ! Gravitational acceleration
   648:                   & CpDry
   649:                                           ! $ C_p $ [J kg-1 K-1].
   650:                                           ! 乾燥大気の定圧比熱.
   651:                                           ! Specific heat of air at constant pressure
   652:             
   653:             
   654:                 use axesset  , only : y_Lat
   655:             
   656:             
   657:                 real(DP), intent(in ):: xyz_UB     (0:imax-1,1:jmax,1:kmax)
   658:                 real(DP), intent(in ):: xyz_VB     (0:imax-1,1:jmax,1:kmax)
   659:                 real(DP), intent(in ):: xyz_TempB  (0:imax-1,1:jmax,1:kmax)
   660:                 real(DP), intent(out):: xyz_DUDt   (0:imax-1,1:jmax,1:kmax)
   661:                 real(DP), intent(out):: xyz_DVDt   (0:imax-1,1:jmax,1:kmax)
   662:                 real(DP), intent(out):: xyz_DTempDt(0:imax-1,1:jmax,1:kmax)
   663:             
   664:             
   665:                 !
   666:                 ! local variables
   667:                 !
   668:                 real(DP) :: SurfFrictionTimeConst
   669:                 real(DP) :: Temp  (24:25)
   670:                 real(DP) :: Height(24:25)
   671:                 real(DP) :: SurfTemp
   672:             
   673:             
   674:                 SurfFrictionTimeConst = SurfFrictionTimeConstInEarthDay * DayEarth
   675:             
   676: **W---->A       xyz_DUDt(:,:,2:kmax) = 0.0_DP
   677: **W---- A       xyz_DVDt(:,:,2:kmax) = 0.0_DP
   678:             
   679: *W----->A       xyz_DUDt(:,:,1) = - xyz_UB(:,:,1) / SurfFrictionTimeConst
   680: *W----- A       xyz_DVDt(:,:,1) = - xyz_VB(:,:,1) / SurfFrictionTimeConst
   681:             
   682:             
   683: W**==== A       xyz_DTempDt(:,:,2:kmax) = 0.0d0
   684:             
   685:                 SurfTemp =                                                &
   686:                   &   ( a_YT2003Temp      (25) - A_YT2003Temp      (24) ) &
   687:                   & / ( a_YT2003HeightForT(25) - a_YT2003HeightForT(24) ) &
   688:                   & * ( 0.0_DP - a_YT2003HeightForT(24) )                 &
   689:                   & + A_YT2003Temp(24)
   690: W*===== A       xyz_DTempDt(:,:,1) = - ( xyz_TempB(:,:,1) - SurfTemp ) / SurfFrictionTimeConst
   691:             
   692:             
   693:               end subroutine YT2003SurfFriction
   694:             
   695:               !--------------------------------------------------------------------------------------
   696:             
   697:               function xyz_YT2003TempEq( xyz_h_in )
   698:             
   699:                 ! 種別型パラメタ
   700:                 ! Kind type parameter
   701:                 !
   702:                 use dc_types, only: DP         ! 倍精度実数型. Double precision.
   703:             
   704:                 ! 格子点設定
   705:                 ! Grid points settings
   706:                 !
   707:                 use gridset, only: imax, & ! 経度格子点数.
   708:                                            ! Number of grid points in longitude
   709:                   &                jmax, & ! 緯度格子点数.
   710:                                            ! Number of grid points in latitude
   711:                   &                kmax    ! 鉛直層数.
   712:                                            ! Number of vertical level
   713:             
   714:                 real(DP), intent(IN) :: xyz_h_in        (0:imax-1, 1:jmax, 1:kmax)     ! 高度(m)
   715:                 real(DP)             :: xyz_YT2003TempEq(0:imax-1, 1:jmax, 1:kmax)     ! 温度(K)
   716:             
   717:                 !
   718:                 ! local variables
   719:                 !
   720:                 real(DP) :: x
   721:                 integer  :: i
   722:                 integer  :: j
   723:                 integer  :: k
   724:                 integer  :: kk
   725:             
   726:             
   727: +------>        do k = 1, kmax
   728: |+----->          do j = 1, jmax
   729: ||+---->            do i = 0, imax-1
   730: |||         
   731: |||                   if ( xyz_h_in(i,j,k) > a_YT2003HeightForT(0) ) then
   732: |||                     xyz_YT2003TempEq(i,j,k) = a_YT2003Temp(0)
   733: |||                   else if ( xyz_h_in(i,j,k) < a_YT2003HeightForT(25) ) then
   734: |||                     xyz_YT2003TempEq(i,j,k) =                                 &
   735: |||                       &   ( a_YT2003Temp      (24) - a_YT2003Temp      (25) ) &
   736: |||                       & / ( a_YT2003HeightForT(24) - a_YT2003HeightForT(25) ) &
   737: |||                       & * ( xyz_h_in(i,j,k)        - a_YT2003HeightForT(25) ) &
   738: |||                       & + a_YT2003Temp(25)
   739: |||                   else
   740: |||V--->                do kk = 1, 25
   741: ||||    A                 if ( ( xyz_h_in(i,j,k) < a_YT2003HeightForT(kk-1) ) .and. &
   742: ||||                        &  ( xyz_h_in(i,j,k) > a_YT2003HeightForT(kk  ) ) ) then
   743: ||||                        x =   ( a_YT2003HeightForT(kk-1) - xyz_h_in(i,j,k)        ) &
   744: ||||                          & / ( a_YT2003HeightForT(kk-1) - a_YT2003HeightForT(kk) )
   745: ||||    A                   xyz_YT2003TempEq(i,j,k) = &
   746: ||||                          & ( 1 - x ) * a_YT2003Temp(kk-1) + x * a_YT2003Temp(kk)
   747: ||||                      endif
   748: |||V---                 end do
   749: |||                   end if
   750: |||         
   751: ||+----             end do
   752: |+-----           end do
   753: +------         end do
   754:             
   755:             
   756:               end function xyz_YT2003TempEq
   757:             
   758:               !--------------------------------------------------------------------------------------
   759:             
   760:               function xyz_YT2003Q0( xyz_h_in )
   761:             
   762:                 ! 種別型パラメタ
   763:                 ! Kind type parameter
   764:                 !
   765:                 use dc_types, only: DP         ! 倍精度実数型. Double precision.
   766:             
   767:                 ! 格子点設定
   768:                 ! Grid points settings
   769:                 !
   770:                 use gridset, only: imax, & ! 経度格子点数.
   771:                                            ! Number of grid points in longitude
   772:                   &                jmax, & ! 緯度格子点数.
   773:                                            ! Number of grid points in latitude
   774:                   &                kmax    ! 鉛直層数.
   775:                                            ! Number of vertical level
   776:             
   777:                 real(DP), intent(IN) :: xyz_h_in    (0:imax-1, 1:jmax, 1:kmax)         ! 高度(m)
   778:                 real(DP)             :: xyz_YT2003Q0(0:imax-1, 1:jmax, 1:kmax)         ! 温度(K)
   779:             
   780:                 !
   781:                 ! local variables
   782:                 !
   783:                 real(DP) :: x
   784:                 integer  :: i
   785:                 integer  :: j
   786:                 integer  :: k
   787:                 integer  :: kk
   788:             
   789:             
   790: +------>        do k = 1, kmax
   791: |+----->          do j = 1, jmax
   792: ||+---->            do i = 0, imax-1
   793: |||         
   794: |||                   if ( xyz_h_in(i,j,k) > a_YT2003HeightForQ(0) ) then
   795: |||                     xyz_YT2003Q0(i,j,k) = a_YT2003Q(0)
   796: |||                   else if ( xyz_h_in(i,j,k) <= a_YT2003HeightForQ(20) ) then
   797: |||                     xyz_YT2003Q0(i,j,k) = a_YT2003Q(20)
   798: |||                   else
   799: |||V--->                do kk = 1, 20
   800: ||||    A                 if ( ( xyz_h_in(i,j,k) <= a_YT2003HeightForQ(kk-1) ) .and. &
   801: ||||                        &  ( xyz_h_in(i,j,k) >  a_YT2003HeightForQ(kk  ) ) ) then
   802: ||||                        x =   ( a_YT2003HeightForQ(kk-1) - xyz_h_in(i,j,k)        ) &
   803: ||||                          & / ( a_YT2003HeightForQ(kk-1) - a_YT2003HeightForQ(kk) )
   804: ||||    A                   xyz_YT2003Q0(i,j,k) = ( 1 - x ) * a_YT2003Q(kk-1) + x * a_YT2003Q(kk)
   805: ||||                      endif
   806: |||V---                 end do
   807: |||                   end if
   808: |||         
   809: ||+----             end do
   810: |+-----           end do
   811: +------         end do
   812:             
   813:             
   814:               end function xyz_YT2003Q0
   815:             
   816:               !--------------------------------------------------------------------------------------
   817:             
   818:               subroutine YT2003ForcingInit
   819:                 !
   820:                 ! venus_simple_forcing モジュールの初期化を行います.
   821:                 ! NAMELIST#venus_simple_forcing_nml の読み込みはこの手続きで行われます.
   822:                 !
   823:                 ! "venus_simple_forcing" module is initialized.
   824:                 ! "NAMELIST#venus_simple_forcing_nml" is loaded in this procedure.
   825:                 !
   826:             
   827:             
   828:                 ! モジュール引用 ; USE statements
   829:                 !
   830:             
   831:                 ! 物理定数設定
   832:                 ! Physical constants settings
   833:                 !
   834:                 use constants, only: &
   835:                   & GasRDry, &
   836:                                           ! $ R $ [J kg-1 K-1].
   837:                                           ! 乾燥大気の気体定数.
   838:                                           ! Gas constant of air
   839:                   & CpDry
   840:                                           ! $ C_p $ [J kg-1 K-1].
   841:                                           ! 乾燥大気の定圧比熱.
   842:                                           ! Specific heat of air at constant pressure
   843:             
   844:                 ! 座標データ設定
   845:                 ! Axes data settings
   846:                 !
   847:                 use axesset, only: &
   848:                   & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   849:                   & z_Sigma               ! $ \sigma $ レベル (整数).
   850:                                           ! Full $ \sigma $ level
   851:             
   852:                 ! NAMELIST ファイル入力に関するユーティリティ
   853:                 ! Utilities for NAMELIST file input
   854:                 !
   855:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   856:             
   857:                 ! ファイル入出力補助
   858:                 ! File I/O support
   859:                 !
   860:                 use dc_iounit, only: FileOpen
   861:             
   862:                 ! 種別型パラメタ
   863:                 ! Kind type parameter
   864:                 !
   865:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   866:             
   867:                 ! 文字列操作
   868:                 ! Character handling
   869:                 !
   870:                 use dc_string, only: StoA
   871:             
   872:                 ! ヒストリデータ出力
   873:                 ! History data output
   874:                 !
   875:                 use gtool_historyauto, only: HistoryAutoAddVariable
   876:             
   877:                 ! 鉛直拡散フラックス
   878:                 ! Vertical diffusion flux
   879:                 !
   880:                 use vdiffusion_my, only: VDiffusionInit
   881:             
   882:             
   883:                 ! 宣言文 ; Declaration statements
   884:                 !
   885:                 implicit none
   886:             
   887:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   888:                                           ! Unit number for NAMELIST file open
   889:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   890:                                           ! IOSTAT of NAMELIST read
   891:             
   892:                 ! NAMELIST 変数群
   893:                 ! NAMELIST group name
   894:                 !
   895:                 namelist /venus_simple_forcing_nml/  &
   896:                   & SurfFrictionTimeConstInEarthDay, &
   897:                   & FlagConstNCC,                    &
   898:                   & ConstNCCInEarthDay
   899:                       !
   900:                       ! デフォルト値については初期化手続 "venus_simple_forcing#YT2003ForcingInit"
   901:                       ! のソースコードを参照のこと.
   902:                       !
   903:                       ! Refer to source codes in the initialization procedure
   904:                       ! "venus_simple_forcing#YT2003ForcingInit" for the default values.
   905:                       !
   906:             
   907:                 ! 実行文 ; Executable statement
   908:                 !
   909:             
   910:                 if ( venus_simple_forcing_inited ) return
   911:             
   912:             
   913:                 ! デフォルト値の設定
   914:                 ! Default values settings
   915:                 !
   916:                 SurfFrictionTimeConstInEarthDay = 30.0_DP
   917:                 FlagConstNCC                    = .false.
   918:                 ConstNCCInEarthDay              = 30.0_DP
   919:             
   920:             
   921:                 ! NAMELIST の読み込み
   922:                 ! NAMELIST is input
   923:                 !
   924:                 if ( trim(namelist_filename) /= '' ) then
   925:                   call FileOpen( unit_nml, &          ! (out)
   926:                     & namelist_filename, mode = 'r' ) ! (in)
   927:             
   928:                   rewind( unit_nml )
   929:                   read( unit_nml,                     &  ! (in)
   930:                     & nml = venus_simple_forcing_nml, &  ! (out)
   931:                     & iostat = iostat_nml             &  ! (out)
   932:                     & )
   933:                   close( unit_nml )
   934:             
   935:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   936:             !$      if ( iostat_nml == 0 ) write( STDOUT, nml = venus_simple_forcing_nml )
   937:                 end if
   938:             
   939:             
   940:                 ! ヒストリデータ出力のためのへの変数登録
   941:                 ! Register of variables for history data output
   942:                 !
   943:                 call HistoryAutoAddVariable( 'VTempEq', &
   944:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   945:                   & 'radiative equilibrium temperature', 'K' )
   946:                 call HistoryAutoAddVariable( 'VSRadHR', &
   947:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   948:                   & 'solar heating rate', 'K s-1' )
   949:                 call HistoryAutoAddVariable( 'VEquivTempEq', &
   950:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   951:                   & '"equivalent" radiative equilibrium temperature', 'K' )
   952:                 call HistoryAutoAddVariable( 'VUBalance', &
   953:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   954:                   & 'balanced zonal wind', 'm s-1' )
   955:             
   956:             
   957:                 a_YT2003Temp( 0)=178.76712328767124_DP ; a_YT2003HeightForT(0)=94.54545454545455e3_DP
   958:                 a_YT2003Temp( 1)=180.82191780821918_DP ; a_YT2003HeightForT(1)=89.35064935064935e3_DP
   959:                 a_YT2003Temp( 2)=184.93150684931507_DP ; a_YT2003HeightForT(2)=84.5021645021645e3_DP
   960:                 a_YT2003Temp( 3)=193.15068493150685_DP ; a_YT2003HeightForT(3)=80.0e3_DP
   961:                 a_YT2003Temp( 4)=203.4246575342466_DP  ; a_YT2003HeightForT(4)=75.84415584415585e3_DP
   962:                 a_YT2003Temp( 5)=217.8082191780822_DP  ; a_YT2003HeightForT(5)=71.34199134199135e3_DP
   963:                 a_YT2003Temp( 6)=236.3013698630137_DP  ; a_YT2003HeightForT(6)=67.18614718614718e3_DP
   964:                 a_YT2003Temp( 7)=252.73972602739724_DP ; a_YT2003HeightForT(7)=64.06926406926407e3_DP
   965:                 a_YT2003Temp( 8)=273.28767123287673_DP ; a_YT2003HeightForT(8)=60.60606060606061e3_DP
   966:                 a_YT2003Temp( 9)=295.8904109589041_DP  ; a_YT2003HeightForT(9)=56.45021645021645e3_DP
   967:                 a_YT2003Temp(10)=320.54794520547944_DP ; a_YT2003HeightForT(10)=52.98701298701299e3_DP
   968:                 a_YT2003Temp(11)=343.1506849315068_DP  ; a_YT2003HeightForT(11)=49.523809523809526e3_DP
   969:                 a_YT2003Temp(12)=365.75342465753425_DP ; a_YT2003HeightForT(12)=46.40692640692641e3_DP
   970:                 a_YT2003Temp(13)=392.4657534246575_DP  ; a_YT2003HeightForT(13)=42.5974025974026e3_DP
   971:                 a_YT2003Temp(14)=419.17808219178085_DP ; a_YT2003HeightForT(14)=38.78787878787879e3_DP
   972:                 a_YT2003Temp(15)=445.8904109589041_DP  ; a_YT2003HeightForT(15)=35.324675324675326e3_DP
   973:                 a_YT2003Temp(16)=472.6027397260274_DP  ; a_YT2003HeightForT(16)=31.861471861471863e3_DP
   974:                 a_YT2003Temp(17)=499.3150684931507_DP  ; a_YT2003HeightForT(17)=28.3982683982684e3_DP
   975:                 a_YT2003Temp(18)=528.0821917808219_DP  ; a_YT2003HeightForT(18)=24.935064935064936e3_DP
   976:                 a_YT2003Temp(19)=556.8493150684931_DP  ; a_YT2003HeightForT(19)=21.125541125541126e3_DP
   977:                 a_YT2003Temp(20)=587.6712328767123_DP  ; a_YT2003HeightForT(20)=17.316017316017316e3_DP
   978:                 a_YT2003Temp(21)=614.3835616438356_DP  ; a_YT2003HeightForT(21)=13.852813852813853e3_DP
   979:                 a_YT2003Temp(22)=645.2054794520548_DP  ; a_YT2003HeightForT(22)=10.043290043290042e3_DP
   980:                 a_YT2003Temp(23)=669.8630136986301_DP  ; a_YT2003HeightForT(23)=6.926406926406926e3_DP
   981:                 a_YT2003Temp(24)=698.6301369863014_DP  ; a_YT2003HeightForT(24)=3.463203463203463e3_DP
   982:                 a_YT2003Temp(25)=725.3424657534247_DP  ; a_YT2003HeightForT(25)=0.3463203463203463e3_DP
   983:             
   984:             
   985:                 a_YT2003Q( 0)=0.0_DP                ; a_YT2003HeightForQ( 0)=80.0e3_DP
   986:                 a_YT2003Q( 1)=0.1282051282051282_DP ; a_YT2003HeightForQ( 1)=73.33333333333333e3_DP
   987:                 a_YT2003Q( 2)=0.2564102564102564_DP ; a_YT2003HeightForQ( 2)=71.11111111111111e3_DP
   988:                 a_YT2003Q( 3)=0.7692307692307693_DP ; a_YT2003HeightForQ( 3)=68.33333333333333e3_DP
   989:                 a_YT2003Q( 4)=1.4102564102564104_DP ; a_YT2003HeightForQ( 4)=66.11111111111111e3_DP
   990:                 a_YT2003Q( 5)=2.051282051282051_DP  ; a_YT2003HeightForQ( 5)=64.44444444444444e3_DP
   991:                 a_YT2003Q( 6)=2.6923076923076925_DP ; a_YT2003HeightForQ( 6)=62.77777777777778e3_DP
   992:                 a_YT2003Q( 7)=3.3333333333333335_DP ; a_YT2003HeightForQ( 7)=61.666666666666664e3_DP
   993:                 a_YT2003Q( 8)=3.9743589743589745_DP ; a_YT2003HeightForQ( 8)=60.55555555555556e3_DP
   994:                 a_YT2003Q( 9)=4.743589743589744_DP  ; a_YT2003HeightForQ( 9)=58.333333333333336e3_DP
   995:                 a_YT2003Q(10)=5.128205128205129_DP  ; a_YT2003HeightForQ(10)=56.666666666666664e3_DP
   996:                 a_YT2003Q(11)=5.2_DP                ; a_YT2003HeightForQ(11)=55.0e3_DP
   997:                 a_YT2003Q(12)=4.871794871794871_DP  ; a_YT2003HeightForQ(12)=52.22222222222222e3_DP
   998:                 a_YT2003Q(13)=4.358974358974359_DP  ; a_YT2003HeightForQ(13)=50.0e3_DP
   999:                 a_YT2003Q(14)=3.58974358974359_DP   ; a_YT2003HeightForQ(14)=47.77777777777778e3_DP
  1000:                 a_YT2003Q(15)=2.948717948717949_DP  ; a_YT2003HeightForQ(15)=46.111111111111114e3_DP
  1001:                 a_YT2003Q(16)=2.3076923076923075_DP ; a_YT2003HeightForQ(16)=43.888888888888886e3_DP
  1002:                 a_YT2003Q(17)=1.6666666666666667_DP ; a_YT2003HeightForQ(17)=41.666666666666664e3_DP
  1003:                 a_YT2003Q(18)=1.1538461538461537_DP ; a_YT2003HeightForQ(18)=38.888888888888886e3_DP
  1004:                 a_YT2003Q(19)=0.7692307692307693_DP ; a_YT2003HeightForQ(19)=37.22222222222222e3_DP
  1005:                 a_YT2003Q(20)=0.52_DP               ; a_YT2003HeightForQ(20)=35.0e3_DP
  1006:             
  1007:             
  1008:                 ! Initialization of modules used in this module
  1009:                 !
  1010:             
  1011:                 ! 鉛直拡散フラックス (Mellor and Yamada, 1974)
  1012:                 ! Vertical diffusion flux (Mellor and Yamada, 1974)
  1013:                 !
  1014:                 call VDiffusionInit
  1015:             
  1016:             
  1017:                 ! 印字 ; Print
  1018:                 !
  1019:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1020:                 call MessageNotify( 'M', module_name, '  SurfFrictionTimeConstInEarthDay = %f', d = (/ SurfFrictionTimeConstInEarthDay /) )
  1021:                 call MessageNotify( 'M', module_name, '  FlagConstNCC                    = %b', l = (/ FlagConstNCC /) )
  1022:                 call MessageNotify( 'M', module_name, '  ConstNCCInEarthDay              = %f', d = (/ ConstNCCInEarthDay /) )
  1023:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1024:             
  1025:                 venus_simple_forcing_inited = .true.
  1026:             
  1027:               end subroutine YT2003ForcingInit
  1028:             
  1029:               !--------------------------------------------------------------------------------------
  1030:             
  1031:               !
  1032:               ! A subroutine below will be deleted (yot, 2010/10/29)
  1033:               !
  1034:               subroutine VenusSimpleNCTempEq_old( &
  1035:                 & xyz_Height, & ! (in)
  1036:                 & xyz_TempEq  & ! (out)
  1037:                 & )
  1038:             
  1039:                 ! 種別型パラメタ
  1040:                 ! Kind type parameter
  1041:                 !
  1042:                 use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
  1043:                   &                 STRING     ! 文字列.       Strings.
  1044:             
  1045:             
  1046:                 ! 格子点設定
  1047:                 ! Grid points settings
  1048:                 !
  1049:                 use gridset, only: imax, & ! 経度格子点数.
  1050:                                            ! Number of grid points in longitude
  1051:                   &                jmax, & ! 緯度格子点数.
  1052:                                            ! Number of grid points in latitude
  1053:                   &                kmax    ! 鉛直層数.
  1054:                                            ! Number of vertical level
  1055:             
  1056:                 ! 物理定数設定
  1057:                 ! Physical constants settings
  1058:                 !
  1059:                 use constants, only: &
  1060:                   & Grav, &               ! $ g $ [m s-2].
  1061:                                           ! 重力加速度.
  1062:                                           ! Gravitational acceleration
  1063:                   & CpDry
  1064:                                           ! $ C_p $ [J kg-1 K-1].
  1065:                                           ! 乾燥大気の定圧比熱.
  1066:                                           ! Specific heat of air at constant pressure
  1067:             
  1068:                 use axesset, only: &
  1069:                   & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
  1070:                   & z_Sigma               ! $ \sigma $ レベル (整数).
  1071:                                           ! Full $ \sigma $ level
  1072:             
  1073:                 real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
  1074:                 real(DP), intent(out) :: xyz_TempEq(0:imax-1,1:jmax,1:kmax )
  1075:             
  1076:             
  1077:                 !
  1078:                 ! local variables
  1079:                 !
  1080:                 real(DP)   :: SurfTemp
  1081:                 real(DP)   :: z( 5 ), a( 6 ), ah( 5 ), d( 5 )
  1082:                 integer(4) :: l
  1083:             
  1084:             
  1085:                 ! Coefficients for thermal structure by Hou and Farrel (1987)
  1086:                 !
  1087:             !!$    z ( 1 ) =   0.0d3
  1088:             !!$    z ( 2 ) =  10.0d3
  1089:             !!$    z ( 3 ) =  25.0d3
  1090:             !!$    z ( 4 ) =  55.0d3
  1091:             !!$    z ( 5 ) = 100.0d3
  1092:             !!$
  1093:             !!$    ah( 1 ) =  -1.0d-3
  1094:             !!$    ah( 2 ) =  -1.0d-3
  1095:             !!$    ah( 3 ) =  -3.1d-3
  1096:             !!$    ah( 4 ) =  -6.75d-3
  1097:             !!$    ah( 5 ) =  10.0d-3
  1098:             !!$
  1099:             !!$    d ( 1 ) =  10.0d3
  1100:             !!$    d ( 2 ) =  10.0d3
  1101:             !!$    d ( 3 ) =   8.0d3
  1102:             !!$    d ( 4 ) =   5.0d3
  1103:             !!$    d ( 5 ) =  70.0d3
  1104:             
  1105:             
  1106:                 ! Slightly modified coefficients for thermal structure by Hou and Farrel (1987)
  1107:                 !
  1108:                 z ( 1 ) =   0.0e3_DP
  1109:                 z ( 2 ) =  10.0e3_DP
  1110:                 z ( 3 ) =  25.0e3_DP
  1111:             !!$    z ( 4 ) =  55.0e3_DP
  1112:                 z ( 4 ) =  50.0e3_DP
  1113:                 z ( 5 ) = 100.0e3_DP
  1114:             
  1115:                 ah( 1 ) =  -1.0e-3_DP
  1116:                 ah( 2 ) =  -1.0e-3_DP
  1117:             !!$    ah( 3 ) =  -3.1e-3_DP
  1118:                 ah( 3 ) =  -2.0e-3_DP
  1119:             !!$    ah( 4 ) =  -6.75e-3_DP
  1120:                 ah( 4 ) =  -3.0e-3_DP
  1121:                 ah( 5 ) =  10.0e-3_DP
  1122:             
  1123:                 d ( 1 ) =  10.0e3_DP
  1124:                 d ( 2 ) =  10.0e3_DP
  1125:             !!$    d ( 3 ) =   8.0e3_DP
  1126:                 d ( 3 ) =  15.0e3_DP
  1127:             !!$    d ( 4 ) =   5.0e3_DP
  1128:                 d ( 4 ) =  10.0e3_DP
  1129:                 d ( 5 ) =  70.0e3_DP
  1130:             
  1131:             
  1132:             
  1133:                 a ( 1 ) =   0.0e0_DP
  1134:             
  1135: *------>        do l = 2, 6
  1136: |                 a( l ) = 2.0_DP * ah( l-1 ) * d( l-1 ) + a( l-1 )
  1137: *------         end do
  1138:             
  1139:             
  1140:                 SurfTemp = 750.0_DP
  1141: W**==== A       xyz_TempEq = SurfTemp - Grav / CpDry * xyz_Height
  1142:             
  1143: +------>        do l = 1, 5
  1144: |           !!$      if ( l == 4 ) cycle
  1145: |**W--->A         xyz_TempEq = xyz_TempEq &
  1146: ||||                & - ( a(l+1) - a(l) ) * 0.5_DP &
  1147: ||||                &   * ( 1.0_DP + tanh( ( 0.0_DP      - z(l) ) / d(l) ) )
  1148: |**W--- A         xyz_TempEq = xyz_TempEq &
  1149: |                   & + ( a(l+1) - a(l) ) * 0.5_DP &
  1150: |                   &   * ( 1.0_DP + tanh( ( xyz_Height - z(l) ) / d(l) ) )
  1151: +------         end do
  1152:             
  1153:             !!$    do l = 1, kmax
  1154:             !!$      write( 90, * ) xyz_TempEq(0,jmax/2+1,l), z_sigma(l)
  1155:             !!$    end do
  1156:             !!$    call flush( 90 )
  1157:             !!$    stop
  1158:             
  1159:             
  1160:               end subroutine VenusSimpleNCTempEq_old
  1161:             
  1162:               !--------------------------------------------------------------------------------------
  1163:             
  1164:               !
  1165:               ! A subroutine below will be deleted (yot, 2010/10/29)
  1166:               !
  1167:             
  1168:               subroutine VenusSimpleDTempDtRadS_old(   &
  1169:                 & y_CosLat, xyz_Press, xyz_Height, & ! (in)
  1170:                 & xyz_DTempDtRadS                  & ! (out)
  1171:                 )
  1172:             
  1173:                 ! 物理定数設定
  1174:                 ! Physical constants settings
  1175:                 !
  1176:                 use constants, only: &
  1177:                   & Grav, &               ! $ g $ [m s-2].
  1178:                                           ! 重力加速度.
  1179:                                           ! Gravitational acceleration
  1180:                   & CpDry, &
  1181:                                           ! $ C_p $ [J kg-1 K-1].
  1182:                                           ! 乾燥大気の定圧比熱.
  1183:                                           ! Specific heat of air at constant pressure
  1184:                   & GasRDry
  1185:             
  1186:                 ! 種別型パラメタ
  1187:                 ! Kind type parameter
  1188:                 !
  1189:                 use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
  1190:                   &                 STRING     ! 文字列.       Strings.
  1191:             
  1192:             
  1193:                 ! 格子点設定
  1194:                 ! Grid points settings
  1195:                 !
  1196:                 use gridset, only: imax, & ! 経度格子点数.
  1197:                                            ! Number of grid points in longitude
  1198:                   &                jmax, & ! 緯度格子点数.
  1199:                                            ! Number of grid points in latitude
  1200:                   &                kmax    ! 鉛直層数.
  1201:                                            ! Number of vertical level
  1202:             
  1203:                 real(DP), intent(in ) :: y_CosLat       (1:jmax)
  1204:                 real(DP), intent(in ) :: xyz_Press      (0:imax-1,1:jmax,1:kmax)
  1205:                 real(DP), intent(in ) :: xyz_Height     (0:imax-1,1:jmax,1:kmax)
  1206:                 real(DP), intent(out) :: xyz_DTempDtRadS(0:imax-1,1:jmax,1:kmax)
  1207:             
  1208:             
  1209:                 !
  1210:                 ! local variables
  1211:                 !
  1212:                 real(DP)   :: scaleheight
  1213:                 real(DP)   :: DTempDtRadSMax
  1214:                 integer(4) :: i, j, k
  1215:             
  1216:             
  1217:             !!$    xyz_DTempDtRadS &
  1218:             !!$      & = 5.0d0 / dayearth * exp( - ( ( xyz_Height - 55.0d3 ) / 10.0d3 )**2  )
  1219:             !!$
  1220:             !!$    do k = 1, kmax
  1221:             !!$      do j = 1, jmax
  1222:             !!$        do i = 0, imax-1
  1223:             !!$          if( xyz_Height(i,j,k) .le. 55.0d3 ) then
  1224:             !!$            if( xyz_DTempDtRadS(i,j,k) .lt. 0.5d0 / dayearth ) then
  1225:             !!$              xyz_DTempDtRadS(i,j,k) = 0.5d0 / dayearth
  1226:             !!$            end if
  1227:             !!$          end if
  1228:             !!$        end do
  1229:             !!$      end do
  1230:             !!$    end do
  1231:             
  1232:             
  1233:                 scaleheight = GasRDry * 300.0_DP / Grav
  1234:             
  1235: W**==== A       xyz_DTempDtRadS &
  1236:                   & = 5.0_DP / DayEarth &
  1237:                   & * exp( - ( ( - scaleheight * log( xyz_Press / 500.0e2_DP ) ) / ( 2.0_DP * scaleheight ) )**2 )
  1238:             
  1239: +------>        do k = 1, kmax
  1240: |+----->          do j = 1, jmax
  1241: ||V---->            do i = 0, imax-1
  1242: |||     A             if ( xyz_Press(i,j,k) > 500.0e2_DP ) then
  1243: |||     A               if ( xyz_DTempDtRadS(i,j,k) .lt. 0.5_DP / DayEarth ) then
  1244: |||     A                 xyz_DTempDtRadS(i,j,k) = 0.5_DP / DayEarth
  1245: |||                     end if
  1246: |||                   end if
  1247: |||                 end do
  1248: |||               end do
  1249: |||             end do
  1250: |||         
  1251: |||         
  1252: |||         
  1253: |||         
  1254: |||         !!$    do k = 1, kmax
  1255: |||         !!$      do j = 1, jmax
  1256: |||         !!$        do i = 0, imax-1
  1257: |||         
  1258: |||         
  1259: |||         !!$          if( xyz_Press(i,j,k) .le. 1.0d5 ) then
  1260: |||         !!$!                  gswrh( i, j, k ) = 5.0d0 / dayearth
  1261: |||         !!$            xyz_DTempDtRadS(i,j,k) = 5.0d0 / dayearth &
  1262: |||         !!$              & * exp( - ( 5.0d3 * log( xyz_Press(i,j,k) / 1.0d5 ) / 15.0d3 )**2  )
  1263: |||         !!$          else
  1264: |||         !!$            xyz_DTempDtRadS(i,j,k) &
  1265: |||         !!$              & = log( ( 5.0d0 / dayearth ) / ( 1.0d-4 / dayearth ) ) &
  1266: |||         !!$              & / log(   1.0d5              /   100.0d5             ) &
  1267: |||         !!$              & * log(   xyz_Press(i,j,k)   /   100.0d5             ) &
  1268: |||         !!$              & + log(   1.0d-4 / dayearth  )
  1269: |||         !!$            xyz_DTempDtRadS(i,j,k) = exp( xyz_DTempDtRadS(i,j,k) )
  1270: |||         !!$            if( xyz_DTempDtRadS(i,j,k) .lt. 0.5d0 / dayearth ) then
  1271: |||         !!$              xyz_DTempDtRadS(i,j,k) = 0.5d0 / dayearth
  1272: |||         !!$            end if
  1273: |||         !!$          end if
  1274: |||         
  1275: |||         
  1276: |||                   !-----
  1277: |||         
  1278: |||         
  1279: |||         !!$          DTempDtRadSMax = 3.0d0 / dayearth
  1280: |||         !!$
  1281: |||         !!$          if( xyz_Press(i,j,k) .le. 1.0d4 ) then
  1282: |||         !!$            xyz_DTempDtRadS(i,j,k) = DTempDtRadSMax &
  1283: |||         !!$              & * exp( - ( 5.0d3 * log( xyz_Press(i,j,k) / 1.0d4 ) / 10.0d3 )**2  )
  1284: |||         !!$          else if( xyz_Press(i,j,k) .le. 1.0d5 ) then
  1285: |||         !!$            xyz_DTempDtRadS(i,j,k) = DTempDtRadSMax
  1286: |||         !!$
  1287: |||         !!$!               if( gp( i, j, k ) .le. 1.0d5 ) then
  1288: |||         !!$!                  gswrh( i, j, k ) = sw_hr_peak &
  1289: |||         !!$!                       * exp( - ( 5.0d3 * log( gp( i, j, k ) / 1.0d5 ) / 15.0d3 )**2  )
  1290: |||         !!$
  1291: |||         !!$          else
  1292: |||         !!$            xyz_DTempDtRadS(i,j,k) &
  1293: |||         !!$              & = log( DTempDtRadSMax       / ( 1.0d-4 / dayearth ) ) &
  1294: |||         !!$              & / log(   1.0d5              /   100.0d5             ) &
  1295: |||         !!$              & * log( xyz_Press(i,j,k)     /   100.0d5             ) &
  1296: |||         !!$              & + log(   1.0d-4 / dayearth  )
  1297: |||         !!$            xyz_DTempDtRadS(i,j,k) = exp( xyz_DTempDtRadS(i,j,k) )
  1298: |||         !!$            if( xyz_DTempDtRadS(i,j,k) .lt. 0.5d0 / dayearth ) then
  1299: |||         !!$              xyz_DTempDtRadS(i,j,k) = 0.5d0 / dayearth
  1300: |||         !!$            end if
  1301: |||         !!$!                  if( gswrh( i, j, k ) .lt. 0.15d0 / dayearth ) then
  1302: |||         !!$!                     gswrh( i, j, k ) = 0.15d0 / dayearth
  1303: |||         !!$!                  end if
  1304: |||         !!$          end if
  1305: |||         
  1306: |||         
  1307: |||         !!$        end do
  1308: |||         !!$      end do
  1309: |||         !!$    end do
  1310: |||         
  1311: |||         
  1312: |||             do k = 1, kmax
  1313: |||               do j = 1, jmax
  1314: |||                 do i = 0, imax-1
  1315: |||                   xyz_DTempDtRadS(i,j,k) = xyz_DTempDtRadS(i,j,k) * y_CosLat(j)
  1316: ||V----             end do
  1317: |+-----           end do
  1318: +------         end do
  1319:             
  1320:             
  1321:               end subroutine VenusSimpleDTempDtRadS_old
  1322:             
  1323:               !--------------------------------------------------------------------------------------
  1324:             
  1325:             end module yt2003_forcing
