Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:31 2016
FILE NAME: i.history_file_io.F90
PROGRAM NAME: history_file_io
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   349  vec  (   4): Vectorized array expression.
   349  vec  (  29): ADB is used for array.: x_lon
   351  vec  (   4): Vectorized array expression.
   351  vec  (  29): ADB is used for array.: y_lat
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:31 2016
FILE NAME: i.history_file_io.F90
PROGRAM NAME: history_file_io
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != ヒストリデータ出力
     2  !
     3  != History data output
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6  ! Version::   $Id: history_file_io.F90,v 1.9 2013/09/16 12:23:38 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module history_file_io
    13    !
    14    != ヒストリデータ出力
    15    !
    16    != History data output
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! ヒストリデータ出力の初期化, 時刻進行, 登録変数の表示と
    21    ! 終了処理を行います.
    22    ! [gtool5 ライブラリ]{http://www.gfd-dennou.org/library/gtool} の
    23    ! gtool_historyauto モジュールを用います.
    24    !
    25    ! 各データの出力は, モデルの各プログラム内において,
    26    ! gtool_historyauto モジュールから提供される
    27    ! HistoryAutoAddVariable および HistoryAutoPut を用います.
    28    !
    29  
    30    ! モジュール引用 ; USE statements
    31    !
    32  
    33    ! 格子点設定
    34    ! Grid points settings
    35    !
    36    use gridset, only:   lmax, & ! スペクトルデータの配列サイズ
    37                                 ! Size of array for spectral data
    38      &                  imax, & ! 経度格子点数.
    39                                 ! Number of grid points in longitude
    40      &                  jmax, & ! 緯度格子点数.
    41                                 ! Number of grid points in latitude
    42      &                  kmax, & ! 鉛直層数.
    43                                 ! Number of vertical level
    44      &                kslmax, & ! 地下の鉛直層数.
    45                                 ! Number of subsurface vertical level
    46      &                ksimax    ! 海氷の鉛直層数.
    47                                 ! Number of sea ice vertical level
    48  
    49    ! 種別型パラメタ
    50    ! Kind type parameter
    51    !
    52    use dc_types, only: DP, &    ! 倍精度実数型. Double precision.
    53      &                 STRING, &  ! 文字列.       Strings.
    54      &                 TOKEN      ! キーワード.   Keywords.
    55  
    56    ! メッセージ出力
    57    ! Message output
    58    !
    59    use dc_message, only: MessageNotify
    60  
    61  
    62    ! 宣言文 ; Declaration statements
    63    !
    64    implicit none
    65    private
    66  
    67    ! 公開手続き
    68    ! Public procedure
    69    !
    70    public:: HistoryFileOpen, HistoryFileClose
    71  
    72    ! 公開変数
    73    ! Public variables
    74    !
    75    logical, save, public:: history_file_io_inited = .false.
    76                                ! 初期設定フラグ.
    77                                ! Initialization flag
    78  
    79    ! 非公開変数
    80    ! Private variables
    81    !
    82    real(DP),      save:: DefaultIntValue
    83                                ! ヒストリデータの出力間隔の数値 (デフォルト値).
    84                                ! Numerical value for interval of history data output (default value)
    85    character(STRING), save:: DefaultIntUnit
    86                                ! ヒストリデータの出力間隔の単位 (デフォルト値).
    87                                ! Unit for interval of history data output (default value)
    88    character(STRING):: DefaultFilePrefix
    89                                ! ヒストリデータのファイル名の接頭詞 (デフォルト値).
    90                                ! Prefixes of history data filenames (default value)
    91  
    92  !!$  namelist /history_file_io_nml/
    93  
    94    character(*), parameter:: module_name = 'history_file_io'
    95                                ! モジュールの名称.
    96                                ! Module name
    97    character(*), parameter:: version = &
    98      & '$Name:  $' // &
    99      & '$Id: history_file_io.F90,v 1.9 2013/09/16 12:23:38 yot Exp $'
   100                                ! モジュールのバージョン
   101                                ! Module version
   102  
   103    ! INTERFACE 文 ; INTERFACE statements
   104    !
   105    interface HistoryFileOpen
   106      module procedure HistoryFileOpen
   107    end interface
   108  
   109    interface HistoryFileClose
   110      module procedure HistoryFileClose
   111    end interface
   112  
   113  contains
   114  
   115    !-------------------------------------------------------------------
   116  
   117    subroutine HistoryFileOpen
   118      !
   119      ! history_file_io モジュールの初期化を行います.
   120      !--
   121      ! NAMELIST#history_file_io_nml の読み込みはこの手続きで行われます.
   122      !++
   123      !
   124      ! "history_file_io" module is initialized.
   125      !--
   126      ! "NAMELIST#history_file_io_nml" is loaded in this procedure.
   127      !++
   128      !
   129  
   130      ! モジュール引用 ; USE statements
   131      !
   132  
   133      ! 出力ファイルの基本情報
   134      ! Basic information for output files
   135      !
   136      use fileset, only: &
   137        & FileTitle, &
   138                                ! 出力データファイルの表題.
   139                                ! Title of output data files
   140        & FileSource, &
   141                                ! データファイル作成の手段.
   142                                ! Source of data file
   143        & FileInstitution
   144                                ! データファイルを最終的に変更した組織/個人.
   145                                ! Institution or person that changes data files for the last time
   146  
   147      ! 物理・数学定数設定
   148      ! Physical and mathematical constants settings
   149      !
   150      use constants0, only: &
   151        & PI                    ! $ \pi $.
   152                                ! 円周率. Circular constant
   153  
   154      ! 座標データ設定
   155      ! Axes data settings
   156      !
   157      use axesset, only: &
   158        & AxnameX  , &
   159        & AxnameY  , &
   160        & AxnameZ  , &
   161        & AxnameR  , &
   162        & AxnameSSZ, &
   163        & AxnameSSR, &
   164        & AxnameSIZ, &
   165        & AxnameSIR, &
   166        & AxnameWN , &
   167        & AxnameT  , &
   168        & x_Lon, &
   169                                ! $ \lambda $ [rad.] . 経度. Longitude
   170        & x_Lon_Weight, &
   171                                ! $ \Delta \lambda $ [rad.] .
   172                                ! 経度座標重み.
   173                                ! Weight of longitude
   174        & y_Lat, &
   175                                ! $ \varphi $ [rad.] . 緯度. Latitude
   176        & y_Lat_Weight, &
   177                                ! $ \Delta \varphi $ [rad.] .
   178                                ! 緯度座標重み.
   179                                ! Weight of latitude
   180        & z_Sigma, &
   181                                ! $ \sigma $ レベル (整数).
   182                                ! Full $ \sigma $ level
   183        & r_Sigma, &
   184                                ! $ \sigma $ レベル (半整数).
   185                                ! Half $ \sigma $ level
   186        & z_DelSigma, &
   187                                ! $ \Delta \sigma $ (整数).
   188                                ! $ \Delta \sigma $ (Full)
   189        & w_Number, &
   190                                ! スペクトルデータの添字番号.
   191                                ! Subscript of spectral data
   192        & r_SSDepth, &
   193                                ! subsurface grid on interface of layer
   194        & z_SSDepth, &
   195                                ! subsurface grid at midpoint of layer
   196        & r_SIDepth, &
   197                                ! sea ice grid on interface of layer
   198        & z_SIDepth
   199                                ! sea ice grid at midpoint of layer
   200  
   201      ! NAMELIST ファイル入力に関するユーティリティ
   202      ! Utilities for NAMELIST file input
   203      !
   204      use namelist_util, only: namelist_filename, NmlutilMsg
   205  
   206      ! 時刻管理
   207      ! Time control
   208      !
   209      use timeset, only: &
   210        & RestartTime, &        ! リスタート開始時刻.
   211                                ! Restart time of calculation
   212        & EndTime, &            ! 計算終了時刻.
   213                                ! End time of calculation
   214        & InitialDate, &        ! 計算開始日時.
   215                                ! Start date of calculation
   216        & DelTime               ! $ \Delta t $ [s]
   217  
   218      ! gtool4 netCDF データの入出力インターフェース (大規模モデル用)
   219      ! Interface of Input/Output of gtool4 netCDF data (For large models)
   220      !
   221      use gtool_historyauto, only: HistoryAutoCreate, &
   222        & HistoryAutoAddAttr, HistoryAutoAddWeight, HistoryAutoPutAxis, &
   223        & HistoryAutoPutAxisMPI
   224  
   225      ! ファイル入出力補助
   226      ! File I/O support
   227      !
   228      use dc_iounit, only: FileOpen
   229  
   230      ! 文字列操作
   231      ! Character handling
   232      !
   233      use dc_string, only: CPrintf
   234  
   235      ! 種別型パラメタ
   236      ! Kind type parameter
   237      !
   238      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   239  
   240      ! 宣言文 ; Declaration statements
   241      !
   242      implicit none
   243  
   244      ! 作業変数
   245      ! Work variables
   246      !
   247      logical:: flag_mpi_init
   248  
   249      ! 実行文 ; Executable statement
   250      !
   251  
   252      if ( history_file_io_inited ) return
   253      call InitCheck
   254  
   255      ! デフォルト値の設定
   256      ! Default values settings
   257      !
   258      DefaultIntValue = 1.0
   259      DefaultIntUnit  = 'sec'
   260      DefaultFilePrefix = ''
   261  !!$    DefaultIntValue = 1.0
   262  !!$    DefaultIntUnit  = 'hrs'
   263  !!$    DefaultFilePrefix = 'data01/'
   264  
   265      flag_mpi_init = .false.
   266  
   267      ! HistoryAutoCreate による初期化
   268      ! Initialization by "HistoryAutoCreate"
   269      !
   270      call HistoryAutoCreate( &
   271        &     title = trim(FileTitle) // ' history data',        &   ! (in)
   272        &    source = FileSource, institution = FileInstitution, &   ! (in)
   273        &      dims = (/ AxnameX, AxnameY, AxnameZ, AxnameR,     &   ! (in)
   274        &                AxnameSSZ, AxnameSSR,                   &   ! (in)
   275        &                AxnameSIZ, AxnameSIR,                   &   ! (in)
   276        &                AxnameWN, AxnameT /),                   &   ! (in)
   277        &  dimsizes = (/ imax, jmax, kmax, kmax + 1,             &   ! (in)
   278        &                max(kslmax,1), kslmax+1,                &   ! (in)
   279        &                max(ksimax,1), ksimax+1,                &   ! (in)
   280        &                lmax, 0 /),                             &   ! (in)
   281        & longnames = (/ 'longitude                                       ', &
   282        &                'latitude                                        ', &
   283        &                'sigma at layer midpoints                        ', &
   284        &                'sigma at layer interface (half level)           ', &
   285        &                'depth at subsurface layer midpoints             ', &
   286        &                'depth at subsurface layer interface (half level)', &
   287        &                'depth at sea ice layer midpoints                ', &
   288        &                'depth at sea ice layer interface (half level)   ', &
   289        &                'subscript of spectral data                      ', &
   290        &                'time                                            ' /), & ! (in)
   291        &     units = (/ 'degrees_east ', 'degrees_north', &
   292        &                '1            ', '1            ', &
   293        &                'm            ', 'm            ', &
   294        &                'm            ', 'm            ', &
   295        &                '1            ', DefaultIntUnit(1:13) /), &       ! (in)
   296        &     xtypes = (/ 'float', 'float', &
   297        &                 'float', 'float', &
   298        &                 'float', 'float', &
   299        &                 'float', 'float', &
   300        &                 'int  ', 'float' /), &                     ! (in)
   301        &          origin  = RestartTime, &                      ! (in) optional
   302        &         terminus = EndTime + 2. * DelTime, &           ! (in) optional
   303        &         interval = DefaultIntValue, &                  ! (in) optional
   304  
   305  !!$      &     slice_start  = (/ 1.0, 1.0, 1.0, 1.0, 1.0 /), & ! (in) optional
   306  !!$      &     slice_end    = (/ 0.0, 0.0, 0.0, 0.0, 0.0 /), & ! (in) optional
   307  !!$      &     slice_stride = (/   1,   1,   1,   1,   1 /), & ! (in) optional
   308  !!$      &    space_average = (/ .false., .false., .false., &
   309  !!$      &                       .false., .false. /), &        ! (in) optional
   310  !!$      & newfile_interval = real( delta_time * 10 ), &       ! (in) optional
   311  
   312  !!$      &  flag_mpi_gather = flag_mpi_init, &                    ! (in) optional
   313        &  flag_mpi_split  = .true., &                           ! (in) optional
   314        &      file_prefix = DefaultFilePrefix, &                ! (in) optional
   315        & namelist_filename = namelist_filename )                ! (in) optional
   316  
   317  
   318      ! 座標データへの属性の設定
   319      ! Attributes of axes data settings
   320      !
   321      call HistoryAutoAddAttr( &
   322        & varname = 'lon', attrname = 'standard_name', &   ! (in)
   323        & value = 'longitude' )                            ! (in)
   324      call HistoryAutoAddAttr( &
   325        & varname = 'lat', attrname = 'standard_name', &   ! (in)
   326        & value = 'latitude' )                             ! (in)
   327      call HistoryAutoAddAttr( &
   328        & varname = 'sig', attrname = 'standard_name', &   ! (in)
   329        & value = 'atmosphere_sigma_coordinate' )          ! (in)
   330      call HistoryAutoAddAttr( &
   331        & varname = 'sigm', attrname = 'standard_name', &  ! (in)
   332        & value = 'atmosphere_sigma_coordinate' )          ! (in)
   333      call HistoryAutoAddAttr( &
   334        & varname = 'sig', attrname = 'positive', &        ! (in)
   335        & value = 'down' )                                 ! (in)
   336      call HistoryAutoAddAttr( &
   337        & varname = 'sigm', attrname = 'positive', &       ! (in)
   338        & value = 'down' )                                 ! (in)
   339      call HistoryAutoAddAttr( &
   340        & varname = 'ssz', attrname = 'standard_name', &   ! (in)
   341        & value = 'depth' )                                ! (in)
   342      call HistoryAutoAddAttr( &
   343        & varname = 'sszi', attrname = 'standard_name', &  ! (in)
   344        & value = 'depth' )                                ! (in)
   345  
   346      ! 座標データの設定
   347      ! Axes data settings
   348      !
   349      call HistoryAutoPutAxis( &
     .        d1 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t360 = 1, x_lon.DSC.U1 + 1 - x_lon.DSC.L1                      
     .           %IG8(t360) = x_lon(x_lon.DSC.L1+t360-1)*d1*                    
     .       1      1.80000000000000e+002                                       
     .        enddo                                                             
   350        & 'lon',  x_Lon / PI * 180.0_DP )  ! (in)
   351      call HistoryAutoPutAxis( &
     .        d2 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t364 = 1, y_lat.DSC.U1 + 1 - y_lat.DSC.L1                      
     .           %IG11(t364) = y_lat(y_lat.DSC.L1+t364-1)*d2*                   
     .       1      1.80000000000000e+002                                       
     .        enddo                                                             
   352        & 'lat',  y_Lat / PI * 180.0_DP )  ! (in)
   353      call HistoryAutoPutAxis( &
   354        & 'sig',  z_Sigma )                ! (in)
   355      call HistoryAutoPutAxis( &
   356        & 'sigm', r_Sigma )                ! (in)
   357      if ( kslmax == 0 ) then
   358        call HistoryAutoPutAxis( &
   359          & 'ssz',  r_SSDepth )              ! (in)
   360      else
   361        call HistoryAutoPutAxis( &
   362          & 'ssz',  z_SSDepth )              ! (in)
   363      end if
   364      call HistoryAutoPutAxis( &
   365        & 'sszi', r_SSDepth )              ! (in)
   366      if ( ksimax == 0 ) then
   367        call HistoryAutoPutAxis( &
   368          & 'siz',  r_SIDepth )              ! (in)
   369      else
   370        call HistoryAutoPutAxis( &
   371          & 'siz',  z_SIDepth )              ! (in)
   372      end if
   373      call HistoryAutoPutAxis( &
   374        & 'sizi', r_SIDepth )              ! (in)
   375      call HistoryAutoPutAxis( &
   376        & 'wn',   w_Number )               ! (in)
   377  
   378      ! 座標重みの設定
   379      ! Axes weights settings
   380      !
   381      call HistoryAutoAddWeight( &
   382        & dim = 'lon', weight = x_Lon_Weight, & ! (in)
   383        & units = 'radian', xtype = 'double' )  ! (in) optional
   384      call HistoryAutoAddWeight( &
   385        & dim = 'lat', weight = y_Lat_Weight, & ! (in)
   386        & units = 'radian', xtype = 'double' )  ! (in) optional
   387      call HistoryAutoAddWeight( &
   388        & dim = 'sig', weight = z_DelSigma, &   ! (in)
   389        & xtype = 'double' )                    ! (in) optional
   390  
   391      ! 印字 ; Print
   392      !
   393      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   394      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   395  
   396      history_file_io_inited = .true.
   397    end subroutine HistoryFileOpen
   398  
   399    !-------------------------------------------------------------------
   400  
   401    subroutine HistoryFileClose
   402      !
   403      ! ヒストリデータファイル出力の終了処理を行います.
   404      !
   405      ! Terminate history data files output.
   406  
   407      ! モジュール引用 ; USE statements
   408      !
   409  
   410      ! gtool4 netCDF データの入出力インターフェース (大規模モデル用)
   411      ! Interface of Input/Output of gtool4 netCDF data (For large models)
   412      !
   413      use gtool_historyauto, only: HistoryAutoClose
   414  
   415      ! 宣言文 ; Declaration statements
   416      !
   417      implicit none
   418  
   419      ! 作業変数
   420      ! Work variables
   421      !
   422  
   423      ! 実行文 ; Executable statement
   424      !
   425  
   426      call HistoryAutoClose
   427  
   428    end subroutine HistoryFileClose
   429  
   430    !-------------------------------------------------------------------
   431  
   432    subroutine InitCheck
   433      !
   434      ! 依存モジュールの初期化チェック
   435      !
   436      ! Check initialization of dependency modules
   437  
   438      ! モジュール引用 ; USE statements
   439      !
   440  
   441      ! NAMELIST ファイル入力に関するユーティリティ
   442      ! Utilities for NAMELIST file input
   443      !
   444      use namelist_util, only: namelist_util_inited
   445  
   446      ! 出力ファイルの基本情報管理
   447      ! Management basic information for output files
   448      !
   449      use fileset, only: fileset_inited
   450  
   451      ! 格子点設定
   452      ! Grid points settings
   453      !
   454      use gridset, only: gridset_inited
   455  
   456      ! 座標データ設定
   457      ! Axes data settings
   458      !
   459      use axesset, only: axesset_inited
   460  
   461      ! 時刻管理
   462      ! Time control
   463      !
   464      use timeset, only: timeset_inited
   465  
   466      ! 実行文 ; Executable statement
   467      !
   468  
   469      if ( .not. namelist_util_inited ) &
   470        & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
   471  
   472      if ( .not. fileset_inited ) &
   473        & call MessageNotify( 'E', module_name, '"fileset" module is not initialized.' )
   474  
   475      if ( .not. gridset_inited ) &
   476        & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )
   477  
   478      if ( .not. axesset_inited ) &
   479        & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )
   480  
   481      if ( .not. timeset_inited ) &
   482        & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )
   483  
   484    end subroutine InitCheck
   485  
   486  end module history_file_io
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:31 2016
FILE NAME: i.history_file_io.F90
PROGRAM NAME: history_file_io
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != ヒストリデータ出力
     2:             !
     3:             != History data output
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6:             ! Version::   $Id: history_file_io.F90,v 1.9 2013/09/16 12:23:38 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module history_file_io
    13:               !
    14:               != ヒストリデータ出力
    15:               !
    16:               != History data output
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! ヒストリデータ出力の初期化, 時刻進行, 登録変数の表示と
    21:               ! 終了処理を行います. 
    22:               ! [gtool5 ライブラリ]{http://www.gfd-dennou.org/library/gtool} の 
    23:               ! gtool_historyauto モジュールを用います. 
    24:               ! 
    25:               ! 各データの出力は, モデルの各プログラム内において, 
    26:               ! gtool_historyauto モジュールから提供される
    27:               ! HistoryAutoAddVariable および HistoryAutoPut を用います. 
    28:               !
    29:             
    30:               ! モジュール引用 ; USE statements
    31:               !
    32:             
    33:               ! 格子点設定
    34:               ! Grid points settings
    35:               !
    36:               use gridset, only:   lmax, & ! スペクトルデータの配列サイズ
    37:                                            ! Size of array for spectral data
    38:                 &                  imax, & ! 経度格子点数. 
    39:                                            ! Number of grid points in longitude
    40:                 &                  jmax, & ! 緯度格子点数. 
    41:                                            ! Number of grid points in latitude
    42:                 &                  kmax, & ! 鉛直層数. 
    43:                                            ! Number of vertical level
    44:                 &                kslmax, & ! 地下の鉛直層数. 
    45:                                            ! Number of subsurface vertical level
    46:                 &                ksimax    ! 海氷の鉛直層数. 
    47:                                            ! Number of sea ice vertical level
    48:             
    49:               ! 種別型パラメタ
    50:               ! Kind type parameter
    51:               !
    52:               use dc_types, only: DP, &    ! 倍精度実数型. Double precision. 
    53:                 &                 STRING, &  ! 文字列.       Strings. 
    54:                 &                 TOKEN      ! キーワード.   Keywords. 
    55:             
    56:               ! メッセージ出力
    57:               ! Message output
    58:               !
    59:               use dc_message, only: MessageNotify
    60:             
    61:             
    62:               ! 宣言文 ; Declaration statements
    63:               !
    64:               implicit none
    65:               private
    66:             
    67:               ! 公開手続き
    68:               ! Public procedure
    69:               !
    70:               public:: HistoryFileOpen, HistoryFileClose
    71:             
    72:               ! 公開変数
    73:               ! Public variables
    74:               !
    75:               logical, save, public:: history_file_io_inited = .false.
    76:                                           ! 初期設定フラグ. 
    77:                                           ! Initialization flag
    78:             
    79:               ! 非公開変数
    80:               ! Private variables
    81:               !
    82:               real(DP),      save:: DefaultIntValue
    83:                                           ! ヒストリデータの出力間隔の数値 (デフォルト値). 
    84:                                           ! Numerical value for interval of history data output (default value)
    85:               character(STRING), save:: DefaultIntUnit
    86:                                           ! ヒストリデータの出力間隔の単位 (デフォルト値). 
    87:                                           ! Unit for interval of history data output (default value)
    88:               character(STRING):: DefaultFilePrefix
    89:                                           ! ヒストリデータのファイル名の接頭詞 (デフォルト値). 
    90:                                           ! Prefixes of history data filenames (default value)
    91:             
    92:             !!$  namelist /history_file_io_nml/ 
    93:             
    94:               character(*), parameter:: module_name = 'history_file_io'
    95:                                           ! モジュールの名称. 
    96:                                           ! Module name
    97:               character(*), parameter:: version = &
    98:                 & '$Name:  $' // &
    99:                 & '$Id: history_file_io.F90,v 1.9 2013/09/16 12:23:38 yot Exp $'
   100:                                           ! モジュールのバージョン
   101:                                           ! Module version
   102:             
   103:               ! INTERFACE 文 ; INTERFACE statements
   104:               !
   105:               interface HistoryFileOpen
   106:                 module procedure HistoryFileOpen
   107:               end interface
   108:             
   109:               interface HistoryFileClose
   110:                 module procedure HistoryFileClose
   111:               end interface
   112:             
   113:             contains
   114:             
   115:               !-------------------------------------------------------------------
   116:             
   117:               subroutine HistoryFileOpen
   118:                 !
   119:                 ! history_file_io モジュールの初期化を行います. 
   120:                 !--
   121:                 ! NAMELIST#history_file_io_nml の読み込みはこの手続きで行われます. 
   122:                 !++
   123:                 !
   124:                 ! "history_file_io" module is initialized. 
   125:                 !--
   126:                 ! "NAMELIST#history_file_io_nml" is loaded in this procedure. 
   127:                 !++
   128:                 !
   129:             
   130:                 ! モジュール引用 ; USE statements
   131:                 !
   132:             
   133:                 ! 出力ファイルの基本情報
   134:                 ! Basic information for output files
   135:                 ! 
   136:                 use fileset, only: &
   137:                   & FileTitle, &
   138:                                           ! 出力データファイルの表題.
   139:                                           ! Title of output data files
   140:                   & FileSource, &
   141:                                           ! データファイル作成の手段. 
   142:                                           ! Source of data file
   143:                   & FileInstitution
   144:                                           ! データファイルを最終的に変更した組織/個人. 
   145:                                           ! Institution or person that changes data files for the last time
   146:             
   147:                 ! 物理・数学定数設定
   148:                 ! Physical and mathematical constants settings
   149:                 !
   150:                 use constants0, only: &
   151:                   & PI                    ! $ \pi $.
   152:                                           ! 円周率. Circular constant
   153:             
   154:                 ! 座標データ設定
   155:                 ! Axes data settings
   156:                 !
   157:                 use axesset, only: &
   158:                   & AxnameX  , &
   159:                   & AxnameY  , &
   160:                   & AxnameZ  , &
   161:                   & AxnameR  , &
   162:                   & AxnameSSZ, &
   163:                   & AxnameSSR, &
   164:                   & AxnameSIZ, &
   165:                   & AxnameSIR, &
   166:                   & AxnameWN , &
   167:                   & AxnameT  , &
   168:                   & x_Lon, &
   169:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   170:                   & x_Lon_Weight, &
   171:                                           ! $ \Delta \lambda $ [rad.] . 
   172:                                           ! 経度座標重み. 
   173:                                           ! Weight of longitude
   174:                   & y_Lat, &
   175:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   176:                   & y_Lat_Weight, &
   177:                                           ! $ \Delta \varphi $ [rad.] . 
   178:                                           ! 緯度座標重み. 
   179:                                           ! Weight of latitude
   180:                   & z_Sigma, &
   181:                                           ! $ \sigma $ レベル (整数). 
   182:                                           ! Full $ \sigma $ level
   183:                   & r_Sigma, &
   184:                                           ! $ \sigma $ レベル (半整数). 
   185:                                           ! Half $ \sigma $ level
   186:                   & z_DelSigma, &
   187:                                           ! $ \Delta \sigma $ (整数). 
   188:                                           ! $ \Delta \sigma $ (Full)
   189:                   & w_Number, &
   190:                                           ! スペクトルデータの添字番号. 
   191:                                           ! Subscript of spectral data
   192:                   & r_SSDepth, &
   193:                                           ! subsurface grid on interface of layer
   194:                   & z_SSDepth, &
   195:                                           ! subsurface grid at midpoint of layer
   196:                   & r_SIDepth, &
   197:                                           ! sea ice grid on interface of layer
   198:                   & z_SIDepth
   199:                                           ! sea ice grid at midpoint of layer
   200:             
   201:                 ! NAMELIST ファイル入力に関するユーティリティ
   202:                 ! Utilities for NAMELIST file input
   203:                 !
   204:                 use namelist_util, only: namelist_filename, NmlutilMsg
   205:             
   206:                 ! 時刻管理
   207:                 ! Time control
   208:                 !
   209:                 use timeset, only: &
   210:                   & RestartTime, &        ! リスタート開始時刻. 
   211:                                           ! Restart time of calculation
   212:                   & EndTime, &            ! 計算終了時刻. 
   213:                                           ! End time of calculation
   214:                   & InitialDate, &        ! 計算開始日時. 
   215:                                           ! Start date of calculation
   216:                   & DelTime               ! $ \Delta t $ [s]
   217:             
   218:                 ! gtool4 netCDF データの入出力インターフェース (大規模モデル用)
   219:                 ! Interface of Input/Output of gtool4 netCDF data (For large models)
   220:                 !
   221:                 use gtool_historyauto, only: HistoryAutoCreate, &
   222:                   & HistoryAutoAddAttr, HistoryAutoAddWeight, HistoryAutoPutAxis, &
   223:                   & HistoryAutoPutAxisMPI
   224:             
   225:                 ! ファイル入出力補助
   226:                 ! File I/O support
   227:                 !
   228:                 use dc_iounit, only: FileOpen
   229:             
   230:                 ! 文字列操作
   231:                 ! Character handling
   232:                 !
   233:                 use dc_string, only: CPrintf
   234:             
   235:                 ! 種別型パラメタ
   236:                 ! Kind type parameter
   237:                 !
   238:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   239:             
   240:                 ! 宣言文 ; Declaration statements
   241:                 !
   242:                 implicit none
   243:             
   244:                 ! 作業変数
   245:                 ! Work variables
   246:                 !
   247:                 logical:: flag_mpi_init
   248:             
   249:                 ! 実行文 ; Executable statement
   250:                 !
   251:             
   252:                 if ( history_file_io_inited ) return
   253:                 call InitCheck
   254:             
   255:                 ! デフォルト値の設定
   256:                 ! Default values settings
   257:                 !
   258:                 DefaultIntValue = 1.0
   259:                 DefaultIntUnit  = 'sec'
   260:                 DefaultFilePrefix = ''
   261:             !!$    DefaultIntValue = 1.0
   262:             !!$    DefaultIntUnit  = 'hrs'
   263:             !!$    DefaultFilePrefix = 'data01/'
   264:             
   265:                 flag_mpi_init = .false.
   266:             
   267:                 ! HistoryAutoCreate による初期化
   268:                 ! Initialization by "HistoryAutoCreate"
   269:                 !
   270:                 call HistoryAutoCreate( &
   271:                   &     title = trim(FileTitle) // ' history data',        &   ! (in)
   272:                   &    source = FileSource, institution = FileInstitution, &   ! (in)
   273:                   &      dims = (/ AxnameX, AxnameY, AxnameZ, AxnameR,     &   ! (in)
   274:                   &                AxnameSSZ, AxnameSSR,                   &   ! (in)
   275:                   &                AxnameSIZ, AxnameSIR,                   &   ! (in)
   276:                   &                AxnameWN, AxnameT /),                   &   ! (in)
   277:                   &  dimsizes = (/ imax, jmax, kmax, kmax + 1,             &   ! (in)
   278:                   &                max(kslmax,1), kslmax+1,                &   ! (in)
   279:                   &                max(ksimax,1), ksimax+1,                &   ! (in)
   280:                   &                lmax, 0 /),                             &   ! (in)
   281:                   & longnames = (/ 'longitude                                       ', &
   282:                   &                'latitude                                        ', &
   283:                   &                'sigma at layer midpoints                        ', &
   284:                   &                'sigma at layer interface (half level)           ', &
   285:                   &                'depth at subsurface layer midpoints             ', &
   286:                   &                'depth at subsurface layer interface (half level)', &
   287:                   &                'depth at sea ice layer midpoints                ', &
   288:                   &                'depth at sea ice layer interface (half level)   ', &
   289:                   &                'subscript of spectral data                      ', &
   290:                   &                'time                                            ' /), & ! (in)
   291:                   &     units = (/ 'degrees_east ', 'degrees_north', &
   292:                   &                '1            ', '1            ', &
   293:                   &                'm            ', 'm            ', &
   294:                   &                'm            ', 'm            ', &
   295:                   &                '1            ', DefaultIntUnit(1:13) /), &       ! (in)
   296:                   &     xtypes = (/ 'float', 'float', &
   297:                   &                 'float', 'float', &
   298:                   &                 'float', 'float', &
   299:                   &                 'float', 'float', &
   300:                   &                 'int  ', 'float' /), &                     ! (in)
   301:                   &          origin  = RestartTime, &                      ! (in) optional
   302:                   &         terminus = EndTime + 2. * DelTime, &           ! (in) optional
   303:                   &         interval = DefaultIntValue, &                  ! (in) optional
   304:             
   305:             !!$      &     slice_start  = (/ 1.0, 1.0, 1.0, 1.0, 1.0 /), & ! (in) optional
   306:             !!$      &     slice_end    = (/ 0.0, 0.0, 0.0, 0.0, 0.0 /), & ! (in) optional
   307:             !!$      &     slice_stride = (/   1,   1,   1,   1,   1 /), & ! (in) optional
   308:             !!$      &    space_average = (/ .false., .false., .false., &
   309:             !!$      &                       .false., .false. /), &        ! (in) optional
   310:             !!$      & newfile_interval = real( delta_time * 10 ), &       ! (in) optional
   311:             
   312:             !!$      &  flag_mpi_gather = flag_mpi_init, &                    ! (in) optional
   313:                   &  flag_mpi_split  = .true., &                           ! (in) optional
   314:                   &      file_prefix = DefaultFilePrefix, &                ! (in) optional
   315:                   & namelist_filename = namelist_filename )                ! (in) optional
   316:             
   317:             
   318:                 ! 座標データへの属性の設定
   319:                 ! Attributes of axes data settings
   320:                 !
   321:                 call HistoryAutoAddAttr( &
   322:                   & varname = 'lon', attrname = 'standard_name', &   ! (in)
   323:                   & value = 'longitude' )                            ! (in)
   324:                 call HistoryAutoAddAttr( &
   325:                   & varname = 'lat', attrname = 'standard_name', &   ! (in)
   326:                   & value = 'latitude' )                             ! (in)
   327:                 call HistoryAutoAddAttr( &
   328:                   & varname = 'sig', attrname = 'standard_name', &   ! (in)
   329:                   & value = 'atmosphere_sigma_coordinate' )          ! (in)
   330:                 call HistoryAutoAddAttr( &
   331:                   & varname = 'sigm', attrname = 'standard_name', &  ! (in)
   332:                   & value = 'atmosphere_sigma_coordinate' )          ! (in)
   333:                 call HistoryAutoAddAttr( &
   334:                   & varname = 'sig', attrname = 'positive', &        ! (in)
   335:                   & value = 'down' )                                 ! (in)
   336:                 call HistoryAutoAddAttr( &
   337:                   & varname = 'sigm', attrname = 'positive', &       ! (in)
   338:                   & value = 'down' )                                 ! (in)
   339:                 call HistoryAutoAddAttr( &
   340:                   & varname = 'ssz', attrname = 'standard_name', &   ! (in)
   341:                   & value = 'depth' )                                ! (in)
   342:                 call HistoryAutoAddAttr( &
   343:                   & varname = 'sszi', attrname = 'standard_name', &  ! (in)
   344:                   & value = 'depth' )                                ! (in)
   345:             
   346:                 ! 座標データの設定
   347:                 ! Axes data settings
   348:                 !
   349: V====== A       call HistoryAutoPutAxis( &
   350:                   & 'lon',  x_Lon / PI * 180.0_DP )  ! (in)
   351: V====== A       call HistoryAutoPutAxis( &
   352:                   & 'lat',  y_Lat / PI * 180.0_DP )  ! (in)
   353:                 call HistoryAutoPutAxis( &
   354:                   & 'sig',  z_Sigma )                ! (in)
   355:                 call HistoryAutoPutAxis( &
   356:                   & 'sigm', r_Sigma )                ! (in)
   357:                 if ( kslmax == 0 ) then
   358:                   call HistoryAutoPutAxis( &
   359:                     & 'ssz',  r_SSDepth )              ! (in)
   360:                 else
   361:                   call HistoryAutoPutAxis( &
   362:                     & 'ssz',  z_SSDepth )              ! (in)
   363:                 end if
   364:                 call HistoryAutoPutAxis( &
   365:                   & 'sszi', r_SSDepth )              ! (in)
   366:                 if ( ksimax == 0 ) then
   367:                   call HistoryAutoPutAxis( &
   368:                     & 'siz',  r_SIDepth )              ! (in)
   369:                 else
   370:                   call HistoryAutoPutAxis( &
   371:                     & 'siz',  z_SIDepth )              ! (in)
   372:                 end if
   373:                 call HistoryAutoPutAxis( &
   374:                   & 'sizi', r_SIDepth )              ! (in)
   375:                 call HistoryAutoPutAxis( &
   376:                   & 'wn',   w_Number )               ! (in)
   377:             
   378:                 ! 座標重みの設定
   379:                 ! Axes weights settings
   380:                 !
   381:                 call HistoryAutoAddWeight( &
   382:                   & dim = 'lon', weight = x_Lon_Weight, & ! (in)
   383:                   & units = 'radian', xtype = 'double' )  ! (in) optional
   384:                 call HistoryAutoAddWeight( &
   385:                   & dim = 'lat', weight = y_Lat_Weight, & ! (in)
   386:                   & units = 'radian', xtype = 'double' )  ! (in) optional
   387:                 call HistoryAutoAddWeight( &
   388:                   & dim = 'sig', weight = z_DelSigma, &   ! (in)
   389:                   & xtype = 'double' )                    ! (in) optional
   390:             
   391:                 ! 印字 ; Print
   392:                 !
   393:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   394:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   395:             
   396:                 history_file_io_inited = .true.
   397:               end subroutine HistoryFileOpen
   398:             
   399:               !-------------------------------------------------------------------
   400:             
   401:               subroutine HistoryFileClose
   402:                 !
   403:                 ! ヒストリデータファイル出力の終了処理を行います. 
   404:                 !
   405:                 ! Terminate history data files output. 
   406:             
   407:                 ! モジュール引用 ; USE statements
   408:                 !
   409:             
   410:                 ! gtool4 netCDF データの入出力インターフェース (大規模モデル用)
   411:                 ! Interface of Input/Output of gtool4 netCDF data (For large models)
   412:                 !
   413:                 use gtool_historyauto, only: HistoryAutoClose
   414:             
   415:                 ! 宣言文 ; Declaration statements
   416:                 !
   417:                 implicit none
   418:             
   419:                 ! 作業変数
   420:                 ! Work variables
   421:                 !
   422:             
   423:                 ! 実行文 ; Executable statement
   424:                 !
   425:             
   426:                 call HistoryAutoClose
   427:             
   428:               end subroutine HistoryFileClose
   429:             
   430:               !-------------------------------------------------------------------
   431:             
   432:               subroutine InitCheck
   433:                 !
   434:                 ! 依存モジュールの初期化チェック
   435:                 !
   436:                 ! Check initialization of dependency modules
   437:             
   438:                 ! モジュール引用 ; USE statements
   439:                 !
   440:             
   441:                 ! NAMELIST ファイル入力に関するユーティリティ
   442:                 ! Utilities for NAMELIST file input
   443:                 !
   444:                 use namelist_util, only: namelist_util_inited
   445:             
   446:                 ! 出力ファイルの基本情報管理
   447:                 ! Management basic information for output files
   448:                 !
   449:                 use fileset, only: fileset_inited
   450:             
   451:                 ! 格子点設定
   452:                 ! Grid points settings
   453:                 !
   454:                 use gridset, only: gridset_inited
   455:             
   456:                 ! 座標データ設定
   457:                 ! Axes data settings
   458:                 !
   459:                 use axesset, only: axesset_inited
   460:             
   461:                 ! 時刻管理
   462:                 ! Time control
   463:                 !
   464:                 use timeset, only: timeset_inited
   465:             
   466:                 ! 実行文 ; Executable statement
   467:                 !
   468:             
   469:                 if ( .not. namelist_util_inited ) &
   470:                   & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
   471:             
   472:                 if ( .not. fileset_inited ) &
   473:                   & call MessageNotify( 'E', module_name, '"fileset" module is not initialized.' )
   474:             
   475:                 if ( .not. gridset_inited ) &
   476:                   & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )
   477:             
   478:                 if ( .not. axesset_inited ) &
   479:                   & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )
   480:             
   481:                 if ( .not. timeset_inited ) &
   482:                   & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )
   483:             
   484:               end subroutine InitCheck
   485:             
   486:             end module history_file_io
