Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: output_freq_used_vars.f90
PROGRAM NAME: output_freq_used_vars
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   286  opt  (1593): Loop nest collapsed into one loop.
   286  vec  (   4): Vectorized array expression.
   286  vec  (  29): ADB is used for array.: xy_sum
   287  vec  (   3): Unvectorized loop.
   287  vec  (  13): Overhead of loop division is too large.
   288  opt  (1593): Loop nest collapsed into one loop.
   288  vec  (   4): Vectorized array expression.
   288  vec  (  29): ADB is used for array.: xy_sum
   288  vec  (  29): ADB is used for array.: xyr_press
   288  vec  (  29): ADB is used for array.: xyzf_qmixa
   292  opt  (1017): Subroutine call prevents optimization.
   295  opt  (1593): Loop nest collapsed into one loop.
   295  vec  (   4): Vectorized array expression.
   295  vec  (  29): ADB is used for array.: xyz_press
   295  vec  (  29): ADB is used for array.: xyz_tempa
   296  opt  (1592): Outer loop unrolled inside inner loop.
   296  vec  (   4): Vectorized array expression.
   296  vec  (  29): ADB is used for array.: xyz_exner
   296  vec  (  29): ADB is used for array.: xyz_tempa
   296  vec  (   4): Vectorized array expression.
   296  vec  (  29): ADB is used for array.: xyz_exner
   296  vec  (  29): ADB is used for array.: xyz_tempa
   300  opt  (1592): Outer loop unrolled inside inner loop.
   300  vec  (   4): Vectorized array expression.
   300  vec  (  29): ADB is used for array.: xyz_pottemp
   300  vec  (  29): ADB is used for array.: xyz_exner
   300  vec  (  29): ADB is used for array.: xyz_tempa
   300  vec  (   4): Vectorized array expression.
   300  vec  (  29): ADB is used for array.: xyz_pottemp
   300  vec  (  29): ADB is used for array.: xyz_exner
   300  vec  (  29): ADB is used for array.: xyz_tempa
   303  vec  (   3): Unvectorized loop.
   303  vec  (  13): Overhead of loop division is too large.
   306  opt  (1593): Loop nest collapsed into one loop.
   306  vec  (   4): Vectorized array expression.
   306  vec  (  29): ADB is used for array.: xyz_bvfreqsq
   306  vec  (  29): ADB is used for array.: xyz_height
   306  vec  (  29): ADB is used for array.: xyz_pottemp
   314  opt  (1593): Loop nest collapsed into one loop.
   314  vec  (   4): Vectorized array expression.
   316  opt  (1593): Loop nest collapsed into one loop.
   316  vec  (   1): Vectorized loop.
   316  vec  (  29): ADB is used for array.: xy_kindex
   316  vec  (  29): ADB is used for array.: xy_psa
   316  vec  (  29): ADB is used for array.: xyz_press
   319  opt  (1059): Unable to determine last value of scalar temporary.
   324  opt  (1592): Outer loop unrolled inside inner loop.
   325  vec  (   1): Vectorized loop.
   325  vec  (  29): ADB is used for array.: xyz_virtemp
   325  vec  (  29): ADB is used for array.: xyz_height
   325  vec  (  29): ADB is used for array.: xyz_press
   325  vec  (  29): ADB is used for array.: xy_kindex
   325  vec  (   1): Vectorized loop.
   325  vec  (  29): ADB is used for array.: xyz_virtemp
   325  vec  (  29): ADB is used for array.: xyz_height
   325  vec  (  29): ADB is used for array.: xyz_press
   325  vec  (  29): ADB is used for array.: xy_kindex
   331  opt  (1593): Loop nest collapsed into one loop.
   331  vec  (   4): Vectorized array expression.
   331  vec  (  29): ADB is used for array.: xy_slp
   341  opt  (1592): Outer loop unrolled inside inner loop.
   341  vec  (   4): Vectorized array expression.
   341  vec  (  29): ADB is used for array.: xyz_rh
   341  vec  (  29): ADB is used for array.: xyz_qvapsat
   341  vec  (  29): ADB is used for array.: xyzf_qmixa
   341  vec  (   4): Vectorized array expression.
   341  vec  (  29): ADB is used for array.: xyz_rh
   341  vec  (  29): ADB is used for array.: xyz_qvapsat
   341  vec  (  29): ADB is used for array.: xyzf_qmixa
   345  opt  (1592): Outer loop unrolled inside inner loop.
   345  vec  (   4): Vectorized array expression.
   345  vec  (  29): ADB is used for array.: xyz_rh
   345  vec  (  29): ADB is used for array.: xyz_qvapsat
   345  vec  (  29): ADB is used for array.: xyzf_qmixa
   345  vec  (   4): Vectorized array expression.
   345  vec  (  29): ADB is used for array.: xyz_rh
   345  vec  (  29): ADB is used for array.: xyz_qvapsat
   345  vec  (  29): ADB is used for array.: xyzf_qmixa
   375  opt  (1592): Outer loop unrolled inside inner loop.
   376  vec  (   1): Vectorized loop.
   376  vec  (  29): ADB is used for array.: xyz_virtemp
   376  vec  (  29): ADB is used for array.: xy_kindex
   376  vec  (   1): Vectorized loop.
   376  vec  (  29): ADB is used for array.: xyz_virtemp
   376  vec  (  29): ADB is used for array.: xy_kindex
   380  opt  (1593): Loop nest collapsed into one loop.
   380  vec  (   4): Vectorized array expression.
   380  vec  (  29): ADB is used for array.: xy_slp
   380  vec  (  29): ADB is used for array.: xy_surfheight
   380  vec  (  29): ADB is used for array.: xy_psa
   534  vec  (   3): Unvectorized loop.
   535  opt  (1017): Subroutine call prevents optimization.
   535  vec  (   9): Vectorization obstructive statement.
   535  vec  (  10): Vectorization obstructive procedure reference.:historyautoaddvariable1
   580  warn (  82): Name "k" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: output_freq_used_vars.f90
PROGRAM NAME: output_freq_used_vars
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Output frequently used variables
     2  !
     3  != Output frequently used variables
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: output_freq_used_vars.f90,v 1.2 2015/02/11 11:55:46 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module output_freq_used_vars
    13    !
    14    != Output frequently used variables
    15    !
    16    != Output frequently used variables
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !== References
    22    !
    23  !!$  !  McFarlane, N. A.,
    24  !!$  !    The effect of orographically excited gravity wave drag on the general
    25  !!$  !    circulation of the lower stratosphere and troposphsere,
    26  !!$  !    J. Atmos. Sci., 44, 1775-1800, 1987.
    27    !
    28    !== Procedures List
    29    !
    30  !!$  ! GWDM1987     :: Calculation of gravity wave drag tendency
    31  !!$  ! GWDM1987Init :: Initialization
    32  !!$  ! ------------ :: ------------
    33  !!$  ! GWDM1987     :: Calculation of gravity wave drag tendency
    34  !!$  ! GWDM1987Init :: Initialization
    35    !
    36    !== NAMELIST
    37    !
    38    ! NAMELIST#gwd_m1987_nml
    39    !
    40  
    41    ! モジュール引用 ; USE statements
    42    !
    43  
    44    ! 格子点設定
    45    ! Grid points settings
    46    !
    47    use gridset, only: imax, & ! 経度格子点数.
    48                               ! Number of grid points in longitude
    49      &                jmax, & ! 緯度格子点数.
    50                               ! Number of grid points in latitude
    51      &                kmax    ! 鉛直層数.
    52                               ! Number of vertical level
    53  
    54    ! 組成に関わる配列の設定
    55    ! Settings of array for atmospheric composition
    56    !
    57    use composition, only: &
    58      &                    ncmax
    59  
    60    ! 種別型パラメタ
    61    ! Kind type parameter
    62    !
    63    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    64      &                 STRING     ! 文字列.       Strings.
    65  
    66    ! NAMELIST ファイル入力に関するユーティリティ
    67    ! Utilities for NAMELIST file input
    68    !
    69    use namelist_util, only: MaxNmlArySize
    70                                ! NAMELIST から読み込む配列の最大サイズ.
    71                                ! Maximum size of arrays loaded from NAMELIST
    72  
    73    ! メッセージ出力
    74    ! Message output
    75    !
    76    use dc_message, only: MessageNotify
    77  
    78    ! 物理・数学定数設定
    79    ! Physical and mathematical constants settings
    80    !
    81    use constants0, only: &
    82      & PI                    ! $ \pi $.
    83                              ! 円周率. Circular constant
    84  
    85  
    86    ! 宣言文 ; Declaration statements
    87    !
    88    implicit none
    89    private
    90  
    91    ! 公開手続き
    92    ! Public procedure
    93    !
    94    public :: OutputFreqUsedVars
    95    public :: OutputFreqUsedVarsInit
    96  
    97    ! 公開変数
    98    ! Public variables
    99    !
   100  
   101    ! 非公開変数
   102    ! Private variables
   103    !
   104    real(DP), save :: AdiabLapseRate
   105                                ! Adiabatic lapse rate
   106    real(DP), save :: SigmaRefForSLP
   107                                ! Sigma of level for calculation of scale height
   108  
   109  
   110    logical, save :: output_freq_used_vars_inited = .false.
   111                                ! 初期設定フラグ.
   112                                ! Initialization flag
   113  
   114    character(*), parameter:: module_name = 'output_freq_used_vars'
   115                                ! モジュールの名称.
   116                                ! Module name
   117    character(*), parameter:: version = &
   118      & '$Name:  $' // &
   119      & '$Id: output_freq_used_vars.f90,v 1.2 2015/02/11 11:55:46 yot Exp $'
   120                                ! モジュールのバージョン
   121                                ! Module version
   122  
   123  contains
   124  
   125    subroutine OutputFreqUsedVars(     &
   126      & xy_PsA, xyz_TempA, xyzf_QMixA, & ! (in)
   127      & xy_SurfHeight                  & ! (in)
   128      & )
   129      !
   130      !
   131      !
   132      ! Output frequently used variables
   133      !
   134  
   135      ! モジュール引用 ; USE statements
   136      !
   137  
   138      ! 時刻管理
   139      ! Time control
   140      !
   141      use timeset, only: &
   142        & DelTime, &            ! $ \Delta t $
   143        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   144        & TimeA, &              ! ステップ $ t + \Delta t $ の時刻.
   145                                ! Time of step $ t + \Delta t $.
   146        & TimesetClockStart, TimesetClockStop
   147  
   148      ! ヒストリデータ出力
   149      ! History data output
   150      !
   151      use gtool_historyauto, only: HistoryAutoPut
   152  
   153      ! 組成に関わる配列の設定
   154      ! Settings of array for atmospheric composition
   155      !
   156      use composition, only: &
   157        &                    IndexH2OVap, &
   158        &                    a_QMixName
   159                                ! 成分の変数名
   160                                ! Name of variables for composition
   161  
   162      ! 物理定数設定
   163      ! Physical constants settings
   164      !
   165      use constants, only: &
   166        & Grav, &
   167                                ! $ g $ [m s-2].
   168                                ! 重力加速度.
   169                                ! Gravitational acceleration
   170        & GasRDry, &
   171                                ! $ R $ [J kg-1 K-1].
   172                                ! 乾燥大気の気体定数.
   173                                ! Gas constant of air
   174        & CpDry
   175                                ! $ C_p $ [J kg-1 K-1].
   176                                ! 乾燥大気の定圧比熱.
   177                                ! Specific heat of air at constant pressure
   178  
   179      ! 積分と平均の操作
   180      ! Operation for integral and average
   181      !
   182      use intavr_operate, only: IntLonLat_xy
   183  
   184      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   185      ! Interpolate temperature on half sigma level,
   186      ! and calculate pressure and height
   187      !
   188      use auxiliary, only: AuxVars
   189  
   190      ! 飽和比湿の算出
   191      ! Evaluate saturation specific humidity
   192      !
   193      use saturate, only: xyz_CalcQVapSat, xyz_CalcQVapSatOnLiq
   194  
   195  
   196      ! 宣言文 ; Declaration statements
   197      !
   198  
   199      real(DP), intent(in ) :: xy_PsA       (0:imax-1, 1:jmax)
   200                                ! Temperature
   201      real(DP), intent(in ) :: xyz_TempA    (0:imax-1, 1:jmax, 1:kmax)
   202                                ! Temperature
   203      real(DP), intent(in ) :: xyzf_QMixA   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   204      real(DP), intent(in ) :: xy_SurfHeight(0:imax-1, 1:jmax)
   205  
   206  
   207      ! 作業変数
   208      ! Work variables
   209      !
   210      real(DP) :: xyr_Press     (0:imax-1, 1:jmax, 0:kmax)
   211                                ! Pressure
   212      real(DP) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
   213                                ! Pressure
   214      real(DP) :: xyz_Exner     (0:imax-1, 1:jmax, 1:kmax)
   215                                ! Exner function
   216      real(DP) :: xyz_VirTemp   (0:imax-1, 1:jmax, 1:kmax)
   217                                ! Virtual temperature
   218      real(DP) :: xyz_Height    (0:imax-1, 1:jmax, 1:kmax)
   219                                ! Height
   220  
   221      real(DP) :: xy_Sum        (0:imax-1, 1:jmax)
   222      real(DP) :: Sum
   223  
   224      real(DP) :: xyz_Rho       (0:imax-1, 1:jmax, 1:kmax)
   225                                ! Pressure
   226      real(DP) :: xyz_PotTemp   (0:imax-1, 1:jmax, 1:kmax)
   227                                ! Potential temperature
   228      real(DP) :: xyz_BVFreqSq  (0:imax-1, 1:jmax, 1:kmax)
   229                                ! Brunt-Vaisalla frequency squared
   230  
   231      real(DP) :: xyz_QVapSat(0:imax-1, 1:jmax, 1:kmax)
   232      real(DP) :: xyz_RH     (0:imax-1, 1:jmax, 1:kmax)
   233  
   234      integer  :: xy_KIndex          (0:imax-1, 1:jmax)
   235                                ! K index for reference level used for SLP calc.
   236      real(DP) :: xy_PressRefForSLP  (0:imax-1, 1:jmax)
   237      real(DP) :: xy_HeightRefForSLP (0:imax-1, 1:jmax)
   238      real(DP) :: xy_VirTempRefForSLP(0:imax-1, 1:jmax)
   239      real(DP) :: xy_ScaleHeight     (0:imax-1, 1:jmax)
   240      real(DP) :: xy_SLP             (0:imax-1, 1:jmax)
   241                                ! Sea level pressure
   242  
   243  
   244      integer :: i               ! 経度方向に回る DO ループ用作業変数
   245                                 ! Work variables for DO loop in longitude
   246      integer :: j               ! 緯度方向に回る DO ループ用作業変数
   247                                 ! Work variables for DO loop in latitude
   248      integer :: k               ! 鉛直方向に回る DO ループ用作業変数
   249                                 ! Work variables for DO loop in vertical direction
   250      integer :: kp
   251      integer :: kn
   252      integer :: n
   253  
   254  
   255      ! 実行文 ; Executable statement
   256      !
   257  
   258      ! 初期化確認
   259      ! Initialization check
   260      !
   261      if ( .not. output_freq_used_vars_inited ) then
   262        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   263      end if
   264  
   265      ! 計算時間計測開始
   266      ! Start measurement of computation time
   267      !
   268      call TimesetClockStart( module_name )
   269  
   270  
   271      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   272      ! Interpolate temperature on half sigma level,
   273      ! and calculate pressure and height
   274      !
   275      call AuxVars( &
   276        & xy_PsA, xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),    & ! (in )
   277        & xy_SurfHeight = xy_SurfHeight,                       & ! (in ) optional
   278        & xyr_Press     = xyr_Press,                           & ! (out) optional
   279        & xyz_Press     = xyz_Press,                           & ! (out) optional
   280        & xyz_VirTemp   = xyz_VirTemp,                         & ! (out) optional
   281        & xyz_Height    = xyz_Height,                          & ! (out) optional
   282        & xyz_Exner     = xyz_Exner                            & ! (out) optional
   283        & )
   284      !
   285      do n = 1, ncmax
   286        xy_Sum = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t664 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t664-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
   287        do k = kmax, 1, -1
   288          xy_Sum = xy_Sum + xyzf_QMixA(:,:,k,n) &
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum,xyr_press)                                          
     .        do t670 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t670-1,1) = xy_sum(t670-1,1) + xyzf_qmixa(t670-1,1,k,n)*
     .       1      (xyr_press(t670-1,1,k-1)-xyr_press(t670-1,1,k))*d1          
     .        enddo                                                             
   289            & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   290        end do
   291        Sum = IntLonLat_xy( xy_Sum )
   292        call HistoryAutoPut( TimeA, 'GM'//trim(a_QMixName(n)), Sum )
   293      end do
   294      !
   295      xyz_Rho = xyz_Press / ( GasRDry * xyz_TempA )
   296      call HistoryAutoPut( TimeA, 'Rho', xyz_TempA / xyz_Exner )
     .        if (xyz_tempa.DSC.U2 .gt. 0) then                                 
     .           j1 = and(xyz_tempa.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t701 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t703 = 1, xyz_tempa.DSC.U1 + 1                           
     .                 %IG2(t703,t701,t699+1) = xyz_tempa(t703-1,t701,t699+1)/  
     .       1            xyz_exner(t703-1,t701,t699+1)                         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t701 = j1 + 1, xyz_tempa.DSC.U2, 4                          
     .  !cdir       nodep                                                       
     .              do t703 = 1, xyz_tempa.DSC.U1 + 1                           
     .                 %IG2(t703,t701,t699+1) = xyz_tempa(t703-1,t701,t699+1)/  
     .       1            xyz_exner(t703-1,t701,t699+1)                         
     .                 %IG2(t703,t701+1,t699+1) = xyz_tempa(t703-1,t701+1,t699+1
     .       1            )/xyz_exner(t703-1,t701+1,t699+1)                     
     .                 %IG2(t703,t701+2,t699+1) = xyz_tempa(t703-1,t701+2,t699+1
     .       1            )/xyz_exner(t703-1,t701+2,t699+1)                     
     .                 %IG2(t703,t701+3,t699+1) = xyz_tempa(t703-1,t701+3,t699+1
     .       1            )/xyz_exner(t703-1,t701+3,t699+1)                     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   297      !
   298      call HistoryAutoPut( TimeA, 'Height', xyz_Height )
   299      !
   300      xyz_PotTemp = xyz_TempA / xyz_Exner
     .        if (xyz_tempa.DSC.U2 .gt. 0) then                                 
     .           j2 = and(xyz_tempa.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t716 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t718 = 1, xyz_tempa.DSC.U1 + 1                           
     .                 xyz_pottemp(t718-1,t716,t714+1) = xyz_tempa(t718-1,t716, 
     .       1            t714+1)/xyz_exner(t718-1,t716,t714+1)                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t716 = j2 + 1, xyz_tempa.DSC.U2, 4                          
     .  !cdir       nodep                                                       
     .              do t718 = 1, xyz_tempa.DSC.U1 + 1                           
     .                 xyz_pottemp(t718-1,t716,t714+1) = xyz_tempa(t718-1,t716, 
     .       1            t714+1)/xyz_exner(t718-1,t716,t714+1)                 
     .                 xyz_pottemp(t718-1,t716+1,t714+1) = xyz_tempa(t718-1,t716
     .       1            +1,t714+1)/xyz_exner(t718-1,t716+1,t714+1)            
     .                 xyz_pottemp(t718-1,t716+2,t714+1) = xyz_tempa(t718-1,t716
     .       1            +2,t714+1)/xyz_exner(t718-1,t716+2,t714+1)            
     .                 xyz_pottemp(t718-1,t716+3,t714+1) = xyz_tempa(t718-1,t716
     .       1            +3,t714+1)/xyz_exner(t718-1,t716+3,t714+1)            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   301      call HistoryAutoPut( TimeA, 'PotTemp', xyz_PotTemp )
   302      !
   303      do k = 1, kmax
   304        kp = max( k - 1, 1    )
   305        kn = min( k + 1, kmax )
   306        xyz_BVFreqSq(:,:,k) =                               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t729 = 1, xyz_pottemp.DSC.U2*xyz_pottemp.DSC.U1 +              
     .       1   xyz_pottemp.DSC.U2                                             
     .           xyz_bvfreqsq(t729-1,1,k) = grav/xyz_pottemp(t729-1,1,k)*(      
     .       1      xyz_pottemp(t729-1,1,kn)-xyz_pottemp(t729-1,1,kp))/(        
     .       2      xyz_height(t729-1,1,kn)-xyz_height(t729-1,1,kp))            
     .        enddo                                                             
   307          & Grav / xyz_PotTemp(:,:,k)                       &
   308          & * ( xyz_PotTemp(:,:,kn) - xyz_PotTemp(:,:,kp) ) &
   309          & / ( xyz_Height (:,:,kn) - xyz_Height (:,:,kp) )
   310      end do
   311      call HistoryAutoPut( TimeA, 'BVFreqSq', xyz_BVFreqSq )
   312  
   313  
   314      xy_KIndex = 1
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t745 = 1, xy_kindex.DSC.U2*xy_kindex.DSC.U1 + xy_kindex.DSC.U2 
     .           xy_kindex(t745-1,1) = 1                                        
     .        enddo                                                             
   315      do k = 1, kmax
   316        do j = 1, jmax
   317          do i = 0, imax-1
   318            if ( xyz_Press(i,j,k) / xy_PsA(i,j) > SigmaRefForSLP ) then
   319              xy_KIndex(i,j) = k
   320            end if
   321          end do
   322        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_psa,xy_kindex)                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyz_press(j-1,1,k)/xy_psa(j-1,1) .gt. sigmarefforslp) then 
     .              xy_kindex(j-1,1) = k                                        
     .           endif                                                          
     .        enddo                                                             
   323      end do
   324      do j = 1, jmax
   325        do i = 0, imax-1
   326          xy_PressRefForSLP  (i,j) = xyz_Press  (i,j,xy_KIndex(i,j))
   327          xy_HeightRefForSLP (i,j) = xyz_Height (i,j,xy_KIndex(i,j))
   328          xy_VirTempRefForSLP(i,j) = xyz_VirTemp(i,j,xy_KIndex(i,j))
   329        end do
   330      end do
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .           do j = 1, j3                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_kindex,xyz_virtemp)                               
     .              do i = 1, imax                                              
     .                 xy_pressrefforslp(i-1,j) = xyz_press(i-1,j,xy_kindex(i-1,
     .       1            j))                                                   
     .                 xy_heightrefforslp(i-1,j) = xyz_height(i-1,j,xy_kindex(i-
     .       1            1,j))                                                 
     .                 xy_virtemprefforslp(i-1,j) = xyz_virtemp(i-1,j,xy_kindex(
     .       1            i-1,j))                                               
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j3 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_kindex,xyz_virtemp)                               
     .              do i = 1, imax                                              
     .                 xy_pressrefforslp(i-1,j) = xyz_press(i-1,j,xy_kindex(i-1,
     .       1            j))                                                   
     .                 xy_pressrefforslp(i-1,j+1) = xyz_press(i-1,1+j,xy_kindex(
     .       1            i-1,j+1))                                             
     .                 xy_pressrefforslp(i-1,j+2) = xyz_press(i-1,2+j,xy_kindex(
     .       1            i-1,j+2))                                             
     .                 xy_pressrefforslp(i-1,j+3) = xyz_press(i-1,3+j,xy_kindex(
     .       1            i-1,j+3))                                             
     .                 xy_heightrefforslp(i-1,j) = xyz_height(i-1,j,xy_kindex(i-
     .       1            1,j))                                                 
     .                 xy_heightrefforslp(i-1,j+1) = xyz_height(i-1,1+j,        
     .       1            xy_kindex(i-1,j+1))                                   
     .                 xy_heightrefforslp(i-1,j+2) = xyz_height(i-1,2+j,        
     .       1            xy_kindex(i-1,j+2))                                   
     .                 xy_heightrefforslp(i-1,j+3) = xyz_height(i-1,3+j,        
     .       1            xy_kindex(i-1,j+3))                                   
     .                 xy_virtemprefforslp(i-1,j) = xyz_virtemp(i-1,j,xy_kindex(
     .       1            i-1,j))                                               
     .                 xy_virtemprefforslp(i-1,j+1) = xyz_virtemp(i-1,1+j,      
     .       1            xy_kindex(i-1,j+1))                                   
     .                 xy_virtemprefforslp(i-1,j+2) = xyz_virtemp(i-1,2+j,      
     .       1            xy_kindex(i-1,j+2))                                   
     .                 xy_virtemprefforslp(i-1,j+3) = xyz_virtemp(i-1,3+j,      
     .       1            xy_kindex(i-1,j+3))                                   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   331      xy_SLP = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t751 = 1, xy_pressrefforslp.DSC.U2*xy_pressrefforslp.DSC.U1 +  
     .       1   xy_pressrefforslp.DSC.U2                                       
     .           xy_slp(t751-1,1) = xy_pressrefforslp(t751-1,1)*(               
     .       1      1.00000000000000e+000 + adiablapserate*(                    
     .       2      0.0000000000000000e+000 - xy_heightrefforslp(t751-1,1))/    
     .       3      xy_virtemprefforslp(t751-1,1))**(-grav/(gasrdry*            
     .       4      adiablapserate))                                            
     .        enddo                                                             
   332        & xy_PressRefForSLP &
   333        & * (   1.0_DP &
   334        &     + AdiabLapseRate &
   335        &       * ( 0.0_DP - xy_HeightRefForSLP ) / xy_VirTempRefForSLP &
   336        &   )**( - Grav / ( GasRDry * AdiabLapseRate ) )
   337      call HistoryAutoPut( TimeA, 'SLP', xy_SLP )
   338  
   339  
   340      xyz_QVapSat = xyz_CalcQVapSat( xyz_TempA, xyz_Press )
   341      xyz_RH = xyzf_QMixA(:,:,:,IndexH2OVap) / xyz_QVapSat
     .        if (jmax .gt. 0) then                                             
     .           j4 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t765 = 1, j4                                                
     .  !cdir       nodep                                                       
     .              do t767 = 1, imax                                           
     .                 xyz_rh(t767-1,t765,t763+1) = xyzf_qmixa(t767-1,t765,t763+
     .       1            1,indexh2ovap)/xyz_qvapsat(t767-1,t765,t763+1)        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t765 = j4 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t767 = 1, imax                                           
     .                 xyz_rh(t767-1,t765,t763+1) = xyzf_qmixa(t767-1,t765,t763+
     .       1            1,indexh2ovap)/xyz_qvapsat(t767-1,t765,t763+1)        
     .                 xyz_rh(t767-1,t765+1,t763+1) = xyzf_qmixa(t767-1,t765+1, 
     .       1            t763+1,indexh2ovap)/xyz_qvapsat(t767-1,t765+1,t763+1) 
     .                 xyz_rh(t767-1,t765+2,t763+1) = xyzf_qmixa(t767-1,t765+2, 
     .       1            t763+1,indexh2ovap)/xyz_qvapsat(t767-1,t765+2,t763+1) 
     .                 xyz_rh(t767-1,t765+3,t763+1) = xyzf_qmixa(t767-1,t765+3, 
     .       1            t763+1,indexh2ovap)/xyz_qvapsat(t767-1,t765+3,t763+1) 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   342      call HistoryAutoPut( TimeA, 'RH', xyz_RH )
   343  
   344      xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_TempA, xyz_Press )
   345      xyz_RH = xyzf_QMixA(:,:,:,IndexH2OVap) / xyz_QVapSat
     .        if (jmax .gt. 0) then                                             
     .           j5 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t780 = 1, j5                                                
     .  !cdir       nodep                                                       
     .              do t782 = 1, imax                                           
     .                 xyz_rh(t782-1,t780,t778+1) = xyzf_qmixa(t782-1,t780,t778+
     .       1            1,indexh2ovap)/xyz_qvapsat(t782-1,t780,t778+1)        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t780 = j5 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t782 = 1, imax                                           
     .                 xyz_rh(t782-1,t780,t778+1) = xyzf_qmixa(t782-1,t780,t778+
     .       1            1,indexh2ovap)/xyz_qvapsat(t782-1,t780,t778+1)        
     .                 xyz_rh(t782-1,t780+1,t778+1) = xyzf_qmixa(t782-1,t780+1, 
     .       1            t778+1,indexh2ovap)/xyz_qvapsat(t782-1,t780+1,t778+1) 
     .                 xyz_rh(t782-1,t780+2,t778+1) = xyzf_qmixa(t782-1,t780+2, 
     .       1            t778+1,indexh2ovap)/xyz_qvapsat(t782-1,t780+2,t778+1) 
     .                 xyz_rh(t782-1,t780+3,t778+1) = xyzf_qmixa(t782-1,t780+3, 
     .       1            t778+1,indexh2ovap)/xyz_qvapsat(t782-1,t780+3,t778+1) 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   346      call HistoryAutoPut( TimeA, 'RHOnWat', xyz_RH )
   347  
   348  
   349      ! MEMO
   350      !
   351      ! dp/dz = - \rho g
   352      !       = - p / (RT) g
   353      ! 1/p dp/dz = - g / (RT)
   354      ! d(lnp)/dz = - g / (RT)
   355      !
   356      ! \int_{z_0}^z d{lnp(z')}/dz' = - \int_{z_0}^z g / (RT(z')) dz'
   357      ! ln{p(z)} - ln{p(z_0)} = - g/R \int_{z_0}^z 1/T(z') dz'
   358      ! ln{p(z)/p(z_0)}
   359      ! = - g/R \int_{z_0}^z 1/T(z') dz'
   360      ! = - g/R \int_{z_0}^z 1/{ T(z_0) + \Gamma (z' - z_0) } dz'
   361      ! = - g/(R \Gamma) \int_{z_0}^z \Gamma/{ T(z_0) + \Gamma (z' - z_0) } dz'
   362      ! = - g/(R \Gamma) [ ln{ T(z_0) + \Gamma (z' - z_0) } ]_{z_0}^z
   363      ! = - g/(R \Gamma) [ ln{ T(z_0) + \Gamma (z - z_0) } - ln{ T(z_0) } ]
   364      ! = - g/(R \Gamma) ln[ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]
   365      ! = ln[ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
   366      ! p(z)/p(z_0)
   367      ! = [ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
   368      ! p(z)
   369      ! = p(z_0) [ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
   370      ! = p(z_0) { 1.0 + \Gamma (z - z_0) / T(z_0) }^{- g/(R \Gamma)}
   371      !
   372      ! T(z) = T(z_0) + \Gamma (z - z_0)
   373  
   374  
   375      do j = 1, jmax
   376        do i = 0, imax-1
   377          xy_ScaleHeight(i,j) = GasRDry * xyz_VirTemp(i,j,xy_KIndex(i,j)) / Grav
   378        end do
   379      end do
     .        if (jmax .gt. 0) then                                             
     .           j6 = and(jmax,3)                                               
     .           do j = 1, j6                                                   
     .              d2 = gasrdry/grav                                           
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_kindex,xyz_virtemp)                               
     .              do i = 1, imax                                              
     .                 xy_scaleheight(i-1,j) = xyz_virtemp(i-1,j,xy_kindex(i-1,j
     .       1            ))*d2                                                 
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j6 + 1, jmax, 4                                         
     .              d3 = gasrdry/grav                                           
     .              d4 = gasrdry/grav                                           
     .              d5 = gasrdry/grav                                           
     .              d6 = gasrdry/grav                                           
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_kindex,xyz_virtemp)                               
     .              do i = 1, imax                                              
     .                 xy_scaleheight(i-1,j) = xyz_virtemp(i-1,j,xy_kindex(i-1,j
     .       1            ))*d3                                                 
     .                 xy_scaleheight(i-1,j+1) = xyz_virtemp(i-1,1+j,xy_kindex(i
     .       1            -1,j+1))*d4                                           
     .                 xy_scaleheight(i-1,j+2) = xyz_virtemp(i-1,2+j,xy_kindex(i
     .       1            -1,j+2))*d5                                           
     .                 xy_scaleheight(i-1,j+3) = xyz_virtemp(i-1,3+j,xy_kindex(i
     .       1            -1,j+3))*d6                                           
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   380      xy_SLP = xy_PsA * exp( - ( 0.0_DP - xy_SurfHeight ) / xy_ScaleHeight )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_psa)                                                    
     .        do t793 = 1, jmax*imax                                            
     .           xy_slp(t793-1,1) = xy_psa(t793-1,1)*dexp((-(                   
     .       1      0.0000000000000000e+000 - xy_surfheight(t793-1,1))/         
     .       2      xy_scaleheight(t793-1,1)))                                  
     .        enddo                                                             
   381      call HistoryAutoPut( TimeA, 'SLPTmp', xy_SLP )
   382  
   383  
   384      ! 計算時間計測一時停止
   385      ! Pause measurement of computation time
   386      !
   387      call TimesetClockStop( module_name )
   388  
   389    end subroutine OutputFreqUsedVars
   390  
   391    !--------------------------------------------------------------------------------------
   392  
   393    subroutine OutputFreqUsedVarsInit
   394      !
   395      ! moist_conv_adjust モジュールの初期化を行います.
   396      ! NAMELIST#moist_conv_adjust_nml の読み込みはこの手続きで行われます.
   397      !
   398      ! "moist_conv_adjust" module is initialized.
   399      ! "NAMELIST#moist_conv_adjust_nml" is loaded in this procedure.
   400      !
   401  
   402      ! モジュール引用 ; USE statements
   403      !
   404  
   405      ! NAMELIST ファイル入力に関するユーティリティ
   406      ! Utilities for NAMELIST file input
   407      !
   408      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   409  
   410      ! ファイル入出力補助
   411      ! File I/O support
   412      !
   413      use dc_iounit, only: FileOpen
   414  
   415      ! 文字列操作
   416      ! Character handling
   417      !
   418      use dc_string, only: StoA
   419  
   420      ! ヒストリデータ出力
   421      ! History data output
   422      !
   423      use gtool_historyauto, only: HistoryAutoAddVariable
   424  
   425      ! 座標データ設定
   426      ! Axes data settings
   427      !
   428      use axesset, only: &
   429        & AxnameX, &
   430        & AxnameY, &
   431        & AxnameZ, &
   432        & AxnameR, &
   433        & AxnameT
   434  
   435      ! 組成に関わる配列の設定
   436      ! Settings of array for atmospheric composition
   437      !
   438      use composition, only: &
   439      &                    a_QMixName
   440                                ! 成分の変数名
   441                                ! Name of variables for composition
   442  
   443      ! 物理定数設定
   444      ! Physical constants settings
   445      !
   446      use constants, only: &
   447        & Grav, &
   448                                ! $ g $ [m s-2].
   449                                ! 重力加速度.
   450                                ! Gravitational acceleration
   451        & GasRDry, &
   452                                ! $ R $ [J kg-1 K-1].
   453                                ! 乾燥大気の気体定数.
   454                                ! Gas constant of air
   455        & CpDry
   456                                ! $ C_p $ [J kg-1 K-1].
   457                                ! 乾燥大気の定圧比熱.
   458                                ! Specific heat of air at constant pressure
   459  
   460      ! 宣言文 ; Declaration statements
   461      !
   462      implicit none
   463  
   464      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   465                                ! Unit number for NAMELIST file open
   466      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   467                                ! IOSTAT of NAMELIST read
   468  
   469  !!$    real(DP)         :: GWDDampPeriodValue
   470  !!$    character(TOKEN) :: GWDDampPeriodUnit
   471  
   472      integer:: k
   473      integer:: n
   474  
   475  
   476      ! NAMELIST 変数群
   477      ! NAMELIST group name
   478      !
   479      namelist /output_freq_used_vars_nml/ &
   480        & SigmaRefForSLP, &
   481        & AdiabLapseRate
   482            ! デフォルト値については初期化手続 "moist_conv_adjust#CumAdjInit"
   483            ! のソースコードを参照のこと.
   484            !
   485            ! Refer to source codes in the initialization procedure
   486            ! "moist_conv_adjust#MoistConvAdjustInit" for the default values.
   487            !
   488  
   489      ! 実行文 ; Executable statement
   490      !
   491  
   492      if ( output_freq_used_vars_inited ) return
   493  
   494  
   495      ! デフォルト値の設定
   496      ! Default values settings
   497      !
   498      SigmaRefForSLP = exp( - 200.0_DP / ( ( GasRDry * 300.0_DP ) / Grav ) )
   499                                ! 200 m height is approximately set
   500  
   501      AdiabLapseRate = - 5.0e-3_DP
   502                                ! Another example:
   503                                ! -5 degrees / km
   504                                ! This value is originated from JMA method
   505                                ! (see dcmodel e-mail at 2013/03/25 from
   506                                ! Toyoda-san).
   507                                ! In addition, this value is shown in a book
   508                                ! by Ninomiya-sensei, "気象がわかる数と式".
   509  
   510      ! NAMELIST の読み込み
   511      ! NAMELIST is input
   512      !
   513      if ( trim(namelist_filename) /= '' ) then
   514        call FileOpen( unit_nml, &          ! (out)
   515          & namelist_filename, mode = 'r' ) ! (in)
   516  
   517        rewind( unit_nml )
   518        read( unit_nml,                      &  ! (in)
   519          & nml = output_freq_used_vars_nml, &  ! (out)
   520          & iostat = iostat_nml )               ! (out)
   521        close( unit_nml )
   522  
   523        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   524      end if
   525  
   526  
   527      ! Calculation of divergence damping period
   528      !
   529  !!$    GWDDampPeriod = DCCalConvertByUnit( GWDDampPeriodValue, GWDDampPeriodUnit, 'sec' )
   530  
   531      ! ヒストリデータ出力のためのへの変数登録
   532      ! Register of variables for history data output
   533      !
   534      do n = 1, ncmax
   535        call HistoryAutoAddVariable( 'GM'//trim(a_QMixName(n)), &  ! (in)
   536          & (/ AxNameT /),                                      &  ! (in)
   537          & 'global mean column mass of ' // trim(a_QMixName(n)), 'kg m-2' ) ! (in)
   538      end do
   539      call HistoryAutoAddVariable( 'Rho'    ,       &  ! (in)
   540        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   541        & 'density', 'kg m-3' )                        ! (in)
   542      call HistoryAutoAddVariable( 'Height' ,       &  ! (in)
   543        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   544        & 'geopotential height', 'm' )                 ! (in)
   545      call HistoryAutoAddVariable( 'PotTemp' ,      &  ! (in)
   546        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   547        & 'potential temperature', 'K' )               ! (in)
   548      call HistoryAutoAddVariable( 'BVFreqSq'    ,  &  ! (in)
   549        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   550        & 'Brunt-Vaisala frequency squared', 's-2' )   ! (in)
   551      call HistoryAutoAddVariable( 'RH'          ,  &  ! (in)
   552        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   553        & 'relative humidity', '1' )                   ! (in)
   554      call HistoryAutoAddVariable( 'RHOnWat'     ,  &  ! (in)
   555        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   556        & 'relative humidity on water', '1' )          ! (in)
   557      call HistoryAutoAddVariable( 'SLP'    ,       &  ! (in)
   558        & (/ AxNameX, AxNameY, AxNameT /),          &  ! (in)
   559        & 'sea level pressure', 'Pa' )                 ! (in)
   560      call HistoryAutoAddVariable( 'SLPTmp' ,       &  ! (in)
   561        & (/ AxNameX, AxNameY, AxNameT /),          &  ! (in)
   562        & 'sea level pressure', 'Pa' )                 ! (in)
   563  
   564  
   565      ! Initialization of modules used in this module
   566      !
   567  
   568  
   569      ! 印字 ; Print
   570      !
   571      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   572  !!$    call MessageNotify( 'M', module_name, '  FlagUse               = %b', l = (/ FlagUse /) )
   573      call MessageNotify( 'M', module_name, '  SigmaRefForSLP = %f', d = (/ SigmaRefForSLP /) )
   574      call MessageNotify( 'M', module_name, '  AdiabLapseRate = %f', d = (/ AdiabLapseRate /) )
   575      call MessageNotify( 'M', module_name, '    (compared to -g/Cp = %f)', d = (/ (- Grav / CpDry) /) )
   576      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   577  
   578      output_freq_used_vars_inited = .true.
   579  
   580    end subroutine OutputFreqUsedVarsInit
   581  
   582    !--------------------------------------------------------------------------------------
   583  
   584  end module output_freq_used_vars
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: output_freq_used_vars.f90
PROGRAM NAME: output_freq_used_vars
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Output frequently used variables
     2:             !
     3:             != Output frequently used variables
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: output_freq_used_vars.f90,v 1.2 2015/02/11 11:55:46 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module output_freq_used_vars
    13:               !
    14:               != Output frequently used variables
    15:               !
    16:               != Output frequently used variables
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !
    21:               !== References
    22:               !
    23:             !!$  !  McFarlane, N. A., 
    24:             !!$  !    The effect of orographically excited gravity wave drag on the general
    25:             !!$  !    circulation of the lower stratosphere and troposphsere,
    26:             !!$  !    J. Atmos. Sci., 44, 1775-1800, 1987.
    27:               !
    28:               !== Procedures List
    29:               !
    30:             !!$  ! GWDM1987     :: Calculation of gravity wave drag tendency
    31:             !!$  ! GWDM1987Init :: Initialization
    32:             !!$  ! ------------ :: ------------
    33:             !!$  ! GWDM1987     :: Calculation of gravity wave drag tendency
    34:             !!$  ! GWDM1987Init :: Initialization
    35:               !
    36:               !== NAMELIST
    37:               !
    38:               ! NAMELIST#gwd_m1987_nml
    39:               !
    40:             
    41:               ! モジュール引用 ; USE statements
    42:               !
    43:             
    44:               ! 格子点設定
    45:               ! Grid points settings
    46:               !
    47:               use gridset, only: imax, & ! 経度格子点数. 
    48:                                          ! Number of grid points in longitude
    49:                 &                jmax, & ! 緯度格子点数. 
    50:                                          ! Number of grid points in latitude
    51:                 &                kmax    ! 鉛直層数. 
    52:                                          ! Number of vertical level
    53:             
    54:               ! 組成に関わる配列の設定
    55:               ! Settings of array for atmospheric composition
    56:               !
    57:               use composition, only: &
    58:                 &                    ncmax
    59:             
    60:               ! 種別型パラメタ
    61:               ! Kind type parameter
    62:               !
    63:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    64:                 &                 STRING     ! 文字列.       Strings. 
    65:             
    66:               ! NAMELIST ファイル入力に関するユーティリティ
    67:               ! Utilities for NAMELIST file input
    68:               !
    69:               use namelist_util, only: MaxNmlArySize
    70:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    71:                                           ! Maximum size of arrays loaded from NAMELIST
    72:             
    73:               ! メッセージ出力
    74:               ! Message output
    75:               !
    76:               use dc_message, only: MessageNotify
    77:             
    78:               ! 物理・数学定数設定
    79:               ! Physical and mathematical constants settings
    80:               !
    81:               use constants0, only: &
    82:                 & PI                    ! $ \pi $.
    83:                                         ! 円周率. Circular constant
    84:             
    85:             
    86:               ! 宣言文 ; Declaration statements
    87:               !
    88:               implicit none
    89:               private
    90:             
    91:               ! 公開手続き
    92:               ! Public procedure
    93:               !
    94:               public :: OutputFreqUsedVars
    95:               public :: OutputFreqUsedVarsInit
    96:             
    97:               ! 公開変数
    98:               ! Public variables
    99:               !
   100:             
   101:               ! 非公開変数
   102:               ! Private variables
   103:               !
   104:               real(DP), save :: AdiabLapseRate
   105:                                           ! Adiabatic lapse rate
   106:               real(DP), save :: SigmaRefForSLP
   107:                                           ! Sigma of level for calculation of scale height
   108:             
   109:             
   110:               logical, save :: output_freq_used_vars_inited = .false.
   111:                                           ! 初期設定フラグ. 
   112:                                           ! Initialization flag
   113:             
   114:               character(*), parameter:: module_name = 'output_freq_used_vars'
   115:                                           ! モジュールの名称. 
   116:                                           ! Module name
   117:               character(*), parameter:: version = &
   118:                 & '$Name:  $' // &
   119:                 & '$Id: output_freq_used_vars.f90,v 1.2 2015/02/11 11:55:46 yot Exp $'
   120:                                           ! モジュールのバージョン
   121:                                           ! Module version
   122:             
   123:             contains
   124:             
   125:               subroutine OutputFreqUsedVars(     &
   126:                 & xy_PsA, xyz_TempA, xyzf_QMixA, & ! (in)
   127:                 & xy_SurfHeight                  & ! (in)
   128:                 & )
   129:                 !
   130:                 ! 
   131:                 !
   132:                 ! Output frequently used variables
   133:                 !
   134:             
   135:                 ! モジュール引用 ; USE statements
   136:                 !
   137:             
   138:                 ! 時刻管理
   139:                 ! Time control
   140:                 !
   141:                 use timeset, only: &
   142:                   & DelTime, &            ! $ \Delta t $
   143:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   144:                   & TimeA, &              ! ステップ $ t + \Delta t $ の時刻.
   145:                                           ! Time of step $ t + \Delta t $.
   146:                   & TimesetClockStart, TimesetClockStop
   147:             
   148:                 ! ヒストリデータ出力
   149:                 ! History data output
   150:                 !
   151:                 use gtool_historyauto, only: HistoryAutoPut
   152:             
   153:                 ! 組成に関わる配列の設定
   154:                 ! Settings of array for atmospheric composition
   155:                 !
   156:                 use composition, only: &
   157:                   &                    IndexH2OVap, &
   158:                   &                    a_QMixName
   159:                                           ! 成分の変数名
   160:                                           ! Name of variables for composition
   161:             
   162:                 ! 物理定数設定
   163:                 ! Physical constants settings
   164:                 !
   165:                 use constants, only: &
   166:                   & Grav, & 
   167:                                           ! $ g $ [m s-2]. 
   168:                                           ! 重力加速度. 
   169:                                           ! Gravitational acceleration
   170:                   & GasRDry, &
   171:                                           ! $ R $ [J kg-1 K-1]. 
   172:                                           ! 乾燥大気の気体定数. 
   173:                                           ! Gas constant of air
   174:                   & CpDry
   175:                                           ! $ C_p $ [J kg-1 K-1].
   176:                                           ! 乾燥大気の定圧比熱.
   177:                                           ! Specific heat of air at constant pressure
   178:             
   179:                 ! 積分と平均の操作
   180:                 ! Operation for integral and average
   181:                 !
   182:                 use intavr_operate, only: IntLonLat_xy
   183:             
   184:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   185:                 ! Interpolate temperature on half sigma level,
   186:                 ! and calculate pressure and height
   187:                 !
   188:                 use auxiliary, only: AuxVars
   189:             
   190:                 ! 飽和比湿の算出
   191:                 ! Evaluate saturation specific humidity
   192:                 !
   193:                 use saturate, only: xyz_CalcQVapSat, xyz_CalcQVapSatOnLiq
   194:             
   195:             
   196:                 ! 宣言文 ; Declaration statements
   197:                 !
   198:             
   199:                 real(DP), intent(in ) :: xy_PsA       (0:imax-1, 1:jmax)
   200:                                           ! Temperature
   201:                 real(DP), intent(in ) :: xyz_TempA    (0:imax-1, 1:jmax, 1:kmax)
   202:                                           ! Temperature
   203:                 real(DP), intent(in ) :: xyzf_QMixA   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   204:                 real(DP), intent(in ) :: xy_SurfHeight(0:imax-1, 1:jmax)
   205:             
   206:             
   207:                 ! 作業変数
   208:                 ! Work variables
   209:                 !
   210:                 real(DP) :: xyr_Press     (0:imax-1, 1:jmax, 0:kmax)
   211:                                           ! Pressure
   212:                 real(DP) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
   213:                                           ! Pressure
   214:                 real(DP) :: xyz_Exner     (0:imax-1, 1:jmax, 1:kmax)
   215:                                           ! Exner function
   216:                 real(DP) :: xyz_VirTemp   (0:imax-1, 1:jmax, 1:kmax)
   217:                                           ! Virtual temperature
   218:                 real(DP) :: xyz_Height    (0:imax-1, 1:jmax, 1:kmax)
   219:                                           ! Height
   220:             
   221:                 real(DP) :: xy_Sum        (0:imax-1, 1:jmax)
   222:                 real(DP) :: Sum
   223:             
   224:                 real(DP) :: xyz_Rho       (0:imax-1, 1:jmax, 1:kmax)
   225:                                           ! Pressure
   226:                 real(DP) :: xyz_PotTemp   (0:imax-1, 1:jmax, 1:kmax)
   227:                                           ! Potential temperature
   228:                 real(DP) :: xyz_BVFreqSq  (0:imax-1, 1:jmax, 1:kmax)
   229:                                           ! Brunt-Vaisalla frequency squared
   230:             
   231:                 real(DP) :: xyz_QVapSat(0:imax-1, 1:jmax, 1:kmax)
   232:                 real(DP) :: xyz_RH     (0:imax-1, 1:jmax, 1:kmax)
   233:             
   234:                 integer  :: xy_KIndex          (0:imax-1, 1:jmax)
   235:                                           ! K index for reference level used for SLP calc.
   236:                 real(DP) :: xy_PressRefForSLP  (0:imax-1, 1:jmax)
   237:                 real(DP) :: xy_HeightRefForSLP (0:imax-1, 1:jmax)
   238:                 real(DP) :: xy_VirTempRefForSLP(0:imax-1, 1:jmax)
   239:                 real(DP) :: xy_ScaleHeight     (0:imax-1, 1:jmax)
   240:                 real(DP) :: xy_SLP             (0:imax-1, 1:jmax)
   241:                                           ! Sea level pressure
   242:             
   243:             
   244:                 integer :: i               ! 経度方向に回る DO ループ用作業変数
   245:                                            ! Work variables for DO loop in longitude
   246:                 integer :: j               ! 緯度方向に回る DO ループ用作業変数
   247:                                            ! Work variables for DO loop in latitude
   248:                 integer :: k               ! 鉛直方向に回る DO ループ用作業変数
   249:                                            ! Work variables for DO loop in vertical direction
   250:                 integer :: kp
   251:                 integer :: kn
   252:                 integer :: n
   253:             
   254:             
   255:                 ! 実行文 ; Executable statement
   256:                 !
   257:             
   258:                 ! 初期化確認
   259:                 ! Initialization check
   260:                 !
   261:                 if ( .not. output_freq_used_vars_inited ) then
   262:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   263:                 end if
   264:             
   265:                 ! 計算時間計測開始
   266:                 ! Start measurement of computation time
   267:                 !
   268:                 call TimesetClockStart( module_name )
   269:             
   270:             
   271:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   272:                 ! Interpolate temperature on half sigma level,
   273:                 ! and calculate pressure and height
   274:                 !
   275:                 call AuxVars( &
   276:                   & xy_PsA, xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),    & ! (in )
   277:                   & xy_SurfHeight = xy_SurfHeight,                       & ! (in ) optional
   278:                   & xyr_Press     = xyr_Press,                           & ! (out) optional
   279:                   & xyz_Press     = xyz_Press,                           & ! (out) optional
   280:                   & xyz_VirTemp   = xyz_VirTemp,                         & ! (out) optional
   281:                   & xyz_Height    = xyz_Height,                          & ! (out) optional
   282:                   & xyz_Exner     = xyz_Exner                            & ! (out) optional
   283:                   & )
   284:                 !
   285: +------>        do n = 1, ncmax
   286: |W*==== A         xy_Sum = 0.0_DP
   287: |+----->          do k = kmax, 1, -1
   288: ||W*=== A           xy_Sum = xy_Sum + xyzf_QMixA(:,:,k,n) &
   289: ||                    & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   290: |+-----           end do
   291: |                 Sum = IntLonLat_xy( xy_Sum )
   292: |                 call HistoryAutoPut( TimeA, 'GM'//trim(a_QMixName(n)), Sum )
   293: +------         end do
   294:                 !
   295: ++V==== A       xyz_Rho = xyz_Press / ( GasRDry * xyz_TempA )
   296: ++V==== A       call HistoryAutoPut( TimeA, 'Rho', xyz_TempA / xyz_Exner )
   297:                 !
   298:                 call HistoryAutoPut( TimeA, 'Height', xyz_Height )
   299:                 !
   300: ++V==== A       xyz_PotTemp = xyz_TempA / xyz_Exner
   301:                 call HistoryAutoPut( TimeA, 'PotTemp', xyz_PotTemp )
   302:                 !
   303: +------>        do k = 1, kmax
   304: |                 kp = max( k - 1, 1    )
   305: |                 kn = min( k + 1, kmax )
   306: |W*==== A         xyz_BVFreqSq(:,:,k) =                               &
   307: |                   & Grav / xyz_PotTemp(:,:,k)                       &
   308: |                   & * ( xyz_PotTemp(:,:,kn) - xyz_PotTemp(:,:,kp) ) &
   309: |                   & / ( xyz_Height (:,:,kn) - xyz_Height (:,:,kp) )
   310: +------         end do
   311:                 call HistoryAutoPut( TimeA, 'BVFreqSq', xyz_BVFreqSq )
   312:             
   313:             
   314: W*=====         xy_KIndex = 1
   315: +------>        do k = 1, kmax
   316: |W----->          do j = 1, jmax
   317: ||*---->            do i = 0, imax-1
   318: |||     A             if ( xyz_Press(i,j,k) / xy_PsA(i,j) > SigmaRefForSLP ) then
   319: |||     A               xy_KIndex(i,j) = k
   320: |||                   end if
   321: ||*----             end do
   322: |W-----           end do
   323: +------         end do
   324: +------>        do j = 1, jmax
   325: |V----->          do i = 0, imax-1
   326: ||      A           xy_PressRefForSLP  (i,j) = xyz_Press  (i,j,xy_KIndex(i,j))
   327: ||      A           xy_HeightRefForSLP (i,j) = xyz_Height (i,j,xy_KIndex(i,j))
   328: ||      A           xy_VirTempRefForSLP(i,j) = xyz_VirTemp(i,j,xy_KIndex(i,j))
   329: |V-----           end do
   330: +------         end do
   331: W*===== A       xy_SLP = &
   332:                   & xy_PressRefForSLP &
   333:                   & * (   1.0_DP &
   334:                   &     + AdiabLapseRate &
   335:                   &       * ( 0.0_DP - xy_HeightRefForSLP ) / xy_VirTempRefForSLP &
   336:                   &   )**( - Grav / ( GasRDry * AdiabLapseRate ) )
   337:                 call HistoryAutoPut( TimeA, 'SLP', xy_SLP )
   338:             
   339:             
   340:                 xyz_QVapSat = xyz_CalcQVapSat( xyz_TempA, xyz_Press )
   341: ++V==== A       xyz_RH = xyzf_QMixA(:,:,:,IndexH2OVap) / xyz_QVapSat
   342:                 call HistoryAutoPut( TimeA, 'RH', xyz_RH )
   343:             
   344:                 xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_TempA, xyz_Press )
   345: ++V==== A       xyz_RH = xyzf_QMixA(:,:,:,IndexH2OVap) / xyz_QVapSat
   346:                 call HistoryAutoPut( TimeA, 'RHOnWat', xyz_RH )
   347:             
   348:             
   349:                 ! MEMO
   350:                 !
   351:                 ! dp/dz = - \rho g
   352:                 !       = - p / (RT) g
   353:                 ! 1/p dp/dz = - g / (RT)
   354:                 ! d(lnp)/dz = - g / (RT)
   355:                 !
   356:                 ! \int_{z_0}^z d{lnp(z')}/dz' = - \int_{z_0}^z g / (RT(z')) dz'
   357:                 ! ln{p(z)} - ln{p(z_0)} = - g/R \int_{z_0}^z 1/T(z') dz'
   358:                 ! ln{p(z)/p(z_0)}
   359:                 ! = - g/R \int_{z_0}^z 1/T(z') dz'
   360:                 ! = - g/R \int_{z_0}^z 1/{ T(z_0) + \Gamma (z' - z_0) } dz'
   361:                 ! = - g/(R \Gamma) \int_{z_0}^z \Gamma/{ T(z_0) + \Gamma (z' - z_0) } dz'
   362:                 ! = - g/(R \Gamma) [ ln{ T(z_0) + \Gamma (z' - z_0) } ]_{z_0}^z
   363:                 ! = - g/(R \Gamma) [ ln{ T(z_0) + \Gamma (z - z_0) } - ln{ T(z_0) } ]
   364:                 ! = - g/(R \Gamma) ln[ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]
   365:                 ! = ln[ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
   366:                 ! p(z)/p(z_0)
   367:                 ! = [ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
   368:                 ! p(z)
   369:                 ! = p(z_0) [ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
   370:                 ! = p(z_0) { 1.0 + \Gamma (z - z_0) / T(z_0) }^{- g/(R \Gamma)}
   371:                 !
   372:                 ! T(z) = T(z_0) + \Gamma (z - z_0)
   373:             
   374:             
   375: +------>        do j = 1, jmax
   376: |V----->          do i = 0, imax-1
   377: ||      A           xy_ScaleHeight(i,j) = GasRDry * xyz_VirTemp(i,j,xy_KIndex(i,j)) / Grav
   378: |V-----           end do
   379: +------         end do
   380: W*===== A       xy_SLP = xy_PsA * exp( - ( 0.0_DP - xy_SurfHeight ) / xy_ScaleHeight )
   381:                 call HistoryAutoPut( TimeA, 'SLPTmp', xy_SLP )
   382:             
   383:             
   384:                 ! 計算時間計測一時停止
   385:                 ! Pause measurement of computation time
   386:                 !
   387:                 call TimesetClockStop( module_name )
   388:             
   389:               end subroutine OutputFreqUsedVars
   390:             
   391:               !--------------------------------------------------------------------------------------
   392:             
   393:               subroutine OutputFreqUsedVarsInit
   394:                 !
   395:                 ! moist_conv_adjust モジュールの初期化を行います. 
   396:                 ! NAMELIST#moist_conv_adjust_nml の読み込みはこの手続きで行われます. 
   397:                 !
   398:                 ! "moist_conv_adjust" module is initialized. 
   399:                 ! "NAMELIST#moist_conv_adjust_nml" is loaded in this procedure. 
   400:                 !
   401:             
   402:                 ! モジュール引用 ; USE statements
   403:                 !
   404:             
   405:                 ! NAMELIST ファイル入力に関するユーティリティ
   406:                 ! Utilities for NAMELIST file input
   407:                 !
   408:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   409:             
   410:                 ! ファイル入出力補助
   411:                 ! File I/O support
   412:                 !
   413:                 use dc_iounit, only: FileOpen
   414:             
   415:                 ! 文字列操作
   416:                 ! Character handling
   417:                 !
   418:                 use dc_string, only: StoA
   419:             
   420:                 ! ヒストリデータ出力
   421:                 ! History data output
   422:                 !
   423:                 use gtool_historyauto, only: HistoryAutoAddVariable
   424:             
   425:                 ! 座標データ設定
   426:                 ! Axes data settings
   427:                 !
   428:                 use axesset, only: &
   429:                   & AxnameX, &
   430:                   & AxnameY, &
   431:                   & AxnameZ, &
   432:                   & AxnameR, &
   433:                   & AxnameT
   434:             
   435:                 ! 組成に関わる配列の設定
   436:                 ! Settings of array for atmospheric composition
   437:                 !
   438:                 use composition, only: &
   439:                 &                    a_QMixName
   440:                                           ! 成分の変数名
   441:                                           ! Name of variables for composition
   442:             
   443:                 ! 物理定数設定
   444:                 ! Physical constants settings
   445:                 !
   446:                 use constants, only: &
   447:                   & Grav, & 
   448:                                           ! $ g $ [m s-2]. 
   449:                                           ! 重力加速度. 
   450:                                           ! Gravitational acceleration
   451:                   & GasRDry, &
   452:                                           ! $ R $ [J kg-1 K-1]. 
   453:                                           ! 乾燥大気の気体定数. 
   454:                                           ! Gas constant of air
   455:                   & CpDry
   456:                                           ! $ C_p $ [J kg-1 K-1].
   457:                                           ! 乾燥大気の定圧比熱.
   458:                                           ! Specific heat of air at constant pressure
   459:             
   460:                 ! 宣言文 ; Declaration statements
   461:                 !
   462:                 implicit none
   463:             
   464:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   465:                                           ! Unit number for NAMELIST file open
   466:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   467:                                           ! IOSTAT of NAMELIST read
   468:             
   469:             !!$    real(DP)         :: GWDDampPeriodValue
   470:             !!$    character(TOKEN) :: GWDDampPeriodUnit
   471:             
   472:                 integer:: k
   473:                 integer:: n
   474:             
   475:             
   476:                 ! NAMELIST 変数群
   477:                 ! NAMELIST group name
   478:                 !
   479:                 namelist /output_freq_used_vars_nml/ &
   480:                   & SigmaRefForSLP, &
   481:                   & AdiabLapseRate
   482:                       ! デフォルト値については初期化手続 "moist_conv_adjust#CumAdjInit" 
   483:                       ! のソースコードを参照のこと. 
   484:                       !
   485:                       ! Refer to source codes in the initialization procedure
   486:                       ! "moist_conv_adjust#MoistConvAdjustInit" for the default values. 
   487:                       !
   488:             
   489:                 ! 実行文 ; Executable statement
   490:                 !
   491:             
   492:                 if ( output_freq_used_vars_inited ) return
   493:             
   494:             
   495:                 ! デフォルト値の設定
   496:                 ! Default values settings
   497:                 !
   498:                 SigmaRefForSLP = exp( - 200.0_DP / ( ( GasRDry * 300.0_DP ) / Grav ) )
   499:                                           ! 200 m height is approximately set
   500:             
   501:                 AdiabLapseRate = - 5.0e-3_DP
   502:                                           ! Another example:
   503:                                           ! -5 degrees / km
   504:                                           ! This value is originated from JMA method
   505:                                           ! (see dcmodel e-mail at 2013/03/25 from 
   506:                                           ! Toyoda-san).
   507:                                           ! In addition, this value is shown in a book 
   508:                                           ! by Ninomiya-sensei, "気象がわかる数と式".
   509:             
   510:                 ! NAMELIST の読み込み
   511:                 ! NAMELIST is input
   512:                 !
   513:                 if ( trim(namelist_filename) /= '' ) then
   514:                   call FileOpen( unit_nml, &          ! (out)
   515:                     & namelist_filename, mode = 'r' ) ! (in)
   516:             
   517:                   rewind( unit_nml )
   518:                   read( unit_nml,                      &  ! (in)
   519:                     & nml = output_freq_used_vars_nml, &  ! (out)
   520:                     & iostat = iostat_nml )               ! (out)
   521:                   close( unit_nml )
   522:             
   523:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   524:                 end if
   525:             
   526:             
   527:                 ! Calculation of divergence damping period
   528:                 !
   529:             !!$    GWDDampPeriod = DCCalConvertByUnit( GWDDampPeriodValue, GWDDampPeriodUnit, 'sec' )
   530:             
   531:                 ! ヒストリデータ出力のためのへの変数登録
   532:                 ! Register of variables for history data output
   533:                 !
   534: +------>        do n = 1, ncmax
   535: |                 call HistoryAutoAddVariable( 'GM'//trim(a_QMixName(n)), &  ! (in)
   536: |                   & (/ AxNameT /),                                      &  ! (in)
   537: |                   & 'global mean column mass of ' // trim(a_QMixName(n)), 'kg m-2' ) ! (in)
   538: +------         end do
   539:                 call HistoryAutoAddVariable( 'Rho'    ,       &  ! (in)
   540:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   541:                   & 'density', 'kg m-3' )                        ! (in)
   542:                 call HistoryAutoAddVariable( 'Height' ,       &  ! (in)
   543:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   544:                   & 'geopotential height', 'm' )                 ! (in)
   545:                 call HistoryAutoAddVariable( 'PotTemp' ,      &  ! (in)
   546:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   547:                   & 'potential temperature', 'K' )               ! (in)
   548:                 call HistoryAutoAddVariable( 'BVFreqSq'    ,  &  ! (in)
   549:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   550:                   & 'Brunt-Vaisala frequency squared', 's-2' )   ! (in)
   551:                 call HistoryAutoAddVariable( 'RH'          ,  &  ! (in)
   552:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   553:                   & 'relative humidity', '1' )                   ! (in)
   554:                 call HistoryAutoAddVariable( 'RHOnWat'     ,  &  ! (in)
   555:                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
   556:                   & 'relative humidity on water', '1' )          ! (in)
   557:                 call HistoryAutoAddVariable( 'SLP'    ,       &  ! (in)
   558:                   & (/ AxNameX, AxNameY, AxNameT /),          &  ! (in)
   559:                   & 'sea level pressure', 'Pa' )                 ! (in)
   560:                 call HistoryAutoAddVariable( 'SLPTmp' ,       &  ! (in)
   561:                   & (/ AxNameX, AxNameY, AxNameT /),          &  ! (in)
   562:                   & 'sea level pressure', 'Pa' )                 ! (in)
   563:             
   564:             
   565:                 ! Initialization of modules used in this module
   566:                 !
   567:             
   568:             
   569:                 ! 印字 ; Print
   570:                 !
   571:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   572:             !!$    call MessageNotify( 'M', module_name, '  FlagUse               = %b', l = (/ FlagUse /) )
   573:                 call MessageNotify( 'M', module_name, '  SigmaRefForSLP = %f', d = (/ SigmaRefForSLP /) )
   574:                 call MessageNotify( 'M', module_name, '  AdiabLapseRate = %f', d = (/ AdiabLapseRate /) )
   575:                 call MessageNotify( 'M', module_name, '    (compared to -g/Cp = %f)', d = (/ (- Grav / CpDry) /) )
   576:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   577:             
   578:                 output_freq_used_vars_inited = .true.
   579:             
   580:               end subroutine OutputFreqUsedVarsInit
   581:             
   582:               !--------------------------------------------------------------------------------------
   583:             
   584:             end module output_freq_used_vars
