Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: read_time_series.f90
PROGRAM NAME: read_time_series
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   337  vec  (   3): Unvectorized loop.
   338  vec  (  18): Unvectorizable data type.
   339  opt  (1084): Branch out of the loop inhibits optimization.
   534  vec  (   1): Vectorized loop.
   534  vec  (  29): ADB is used for array.: a_time
   536  opt  (1268): Use of pointer variable inhibits optimization.
   648  opt  (1592): Outer loop unrolled inside inner loop.
   648  vec  (   4): Vectorized array expression.
   648  vec  (  29): ADB is used for array.: xy_var
   648  vec  (  29): ADB is used for array.: xyza_saveddata
   648  vec  (   4): Vectorized array expression.
   648  vec  (  29): ADB is used for array.: xy_var
   648  vec  (  29): ADB is used for array.: xyza_saveddata
   657  opt  (1592): Outer loop unrolled inside inner loop.
   657  vec  (   4): Vectorized array expression.
   657  vec  (  29): ADB is used for array.: xyz_vartimeinterpolated
   657  vec  (  29): ADB is used for array.: xyza_saveddata
   657  vec  (   4): Vectorized array expression.
   657  vec  (  29): ADB is used for array.: xyz_vartimeinterpolated
   657  vec  (  29): ADB is used for array.: xyza_saveddata
   680  opt  (1592): Outer loop unrolled inside inner loop.
   680  vec  (   4): Vectorized array expression.
   680  vec  (  29): ADB is used for array.: xy_var
   680  vec  (  29): ADB is used for array.: xyza_saveddata
   680  vec  (   4): Vectorized array expression.
   680  vec  (  29): ADB is used for array.: xy_var
   680  vec  (  29): ADB is used for array.: xyza_saveddata
   682  opt  (1592): Outer loop unrolled inside inner loop.
   682  vec  (   4): Vectorized array expression.
   682  vec  (  29): ADB is used for array.: xyza_saveddata
   682  vec  (   4): Vectorized array expression.
   682  vec  (  29): ADB is used for array.: xyza_saveddata
   771  opt  (1593): Loop nest collapsed into one loop.
   771  vec  (   4): Vectorized array expression.
   775  opt  (1593): Loop nest collapsed into one loop.
   775  vec  (   1): Vectorized loop.
   775  vec  (  29): ADB is used for array.: xyz_kk
   775  vec  (  29): ADB is used for array.: xyz_vlevelsout
   779  opt  (1059): Unable to determine last value of scalar temporary.
   795  vec  (   1): Vectorized loop.
   795  vec  (  29): ADB is used for array.: xyz_varout
   795  vec  (  29): ADB is used for array.: xyz_vlevelsout
   795  vec  (  29): ADB is used for array.: z_vlevelsin
   795  vec  (  29): ADB is used for array.: xyz_varin
   795  vec  (  29): ADB is used for array.: xyz_kk
   833  opt  (1592): Outer loop unrolled inside inner loop.
   834  vec  (   1): Vectorized loop.
   834  vec  (  29): ADB is used for array.: xyz_varout
   834  vec  (  29): ADB is used for array.: xyz_vlevelsout
   834  vec  (  29): ADB is used for array.: z_vlevelsin
   834  vec  (  29): ADB is used for array.: xyz_varin
   834  vec  (  29): ADB is used for array.: xyz_kk
   834  vec  (   1): Vectorized loop.
   834  vec  (  29): ADB is used for array.: xyz_varout
   834  vec  (  29): ADB is used for array.: xyz_vlevelsout
   834  vec  (  29): ADB is used for array.: xyz_varin
   834  vec  (  29): ADB is used for array.: z_vlevelsin
   834  vec  (  29): ADB is used for array.: xyz_kk
   858  vec  (   1): Vectorized loop.
   858  vec  (  29): ADB is used for array.: xyz_varout
   858  vec  (  29): ADB is used for array.: xyz_vlevelsout
   858  vec  (  29): ADB is used for array.: z_vlevelsin
   858  vec  (  29): ADB is used for array.: xyz_varin
   858  vec  (  29): ADB is used for array.: xyz_kk
   878  opt  (1592): Outer loop unrolled inside inner loop.
   879  vec  (   1): Vectorized loop.
   879  vec  (  29): ADB is used for array.: xyz_varout
   879  vec  (  29): ADB is used for array.: xyz_vlevelsout
   879  vec  (  29): ADB is used for array.: z_vlevelsin
   879  vec  (  29): ADB is used for array.: xyz_varin
   879  vec  (  29): ADB is used for array.: xyz_kk
   879  vec  (   1): Vectorized loop.
   879  vec  (  29): ADB is used for array.: xyz_varout
   879  vec  (  29): ADB is used for array.: xyz_vlevelsout
   879  vec  (  29): ADB is used for array.: xyz_varin
   879  vec  (  29): ADB is used for array.: z_vlevelsin
   879  vec  (  29): ADB is used for array.: xyz_kk
   901  opt  (1593): Loop nest collapsed into one loop.
   901  vec  (   1): Vectorized loop.
   901  vec  (  29): ADB is used for array.: xyz_varout
   995  vec  (   4): Vectorized array expression.
   995  vec  (  26): Macro operation Sum/InnerProd.
   995  vec  (  29): ADB is used for array.: day_in_month_ptr
  1089  vec  (   3): Unvectorized loop.
  1090  opt  (1084): Branch out of the loop inhibits optimization.
  1090  vec  (  18): Unvectorizable data type.
  1104  vec  (   3): Unvectorized loop.
  1105  opt  (1084): Branch out of the loop inhibits optimization.
  1105  vec  (  18): Unvectorizable data type.
  1114  vec  (   3): Unvectorized loop.
  1115  opt  (1084): Branch out of the loop inhibits optimization.
  1115  vec  (  18): Unvectorizable data type.
  1124  vec  (   3): Unvectorized loop.
  1125  opt  (1084): Branch out of the loop inhibits optimization.
  1125  vec  (  18): Unvectorizable data type.
  1140  vec  (   3): Unvectorized loop.
  1141  opt  (1084): Branch out of the loop inhibits optimization.
  1141  vec  (  18): Unvectorizable data type.
  1150  vec  (   3): Unvectorized loop.
  1151  opt  (1084): Branch out of the loop inhibits optimization.
  1151  vec  (  18): Unvectorizable data type.
  1160  vec  (   3): Unvectorized loop.
  1161  opt  (1084): Branch out of the loop inhibits optimization.
  1161  vec  (  18): Unvectorizable data type.
  1275  vec  (   4): Vectorized array expression.
  1275  vec  (  26): Macro operation Sum/InnerProd.
  1275  vec  (  29): ADB is used for array.: day_in_month_ptr
  1404  vec  (   4): Vectorized array expression.
  1404  vec  (  29): ADB is used for array.: a_time
  1431  vec  (   1): Vectorized loop.
  1431  vec  (  29): ADB is used for array.: a_time
  1433  opt  (1268): Use of pointer variable inhibits optimization.
  1545  vec  (   4): Vectorized array expression.
  1545  vec  (  29): ADB is used for array.: a_time
  1671  warn (  82): Name "flag_mpi_init" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: read_time_series.f90
PROGRAM NAME: read_time_series
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 時系列データの読み込み
     2  !
     3  != Reading time series
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Satoshi NODA
     6  ! Version::   $Id: read_time_series.f90,v 1.19 2015/01/29 12:02:29 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module read_time_series
    13    !
    14    != 時系列データの読み込み
    15    !
    16    != Reading time series
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 海表面温度, O3 量などの時系列データを NetCDF ファイルから読み込む.
    21    !
    22    ! Reading time series data, such as sea surface temperature, O3, and so on, from
    23    ! NetCDF file.
    24    !
    25    !== Procedures List
    26  !!$  ! GroundFileGet    :: 地表面データファイルの入力
    27  !!$  !--
    28  !!$  ! GroundFileOpen   :: 地表面データファイルのオープン
    29  !!$  ! GroundFileOutput :: 地表面データファイルへのデータ出力
    30  !!$  ! GroundFileClose  :: 地表面データファイルのクローズ
    31    !++
    32    ! ------------     :: ------------
    33  !!$  ! GroundFileGet    :: Input ground data file
    34  !!$  !--
    35  !!$  ! GroundFileOpen   :: Open ground data file
    36  !!$  ! GroundFileOutput :: Data output to ground data file
    37  !!$  ! GroundFileClose  :: Close ground data file
    38    !++
    39    !
    40    !== NAMELIST
    41    !
    42  !!$  ! NAMELIST#ground_file_io_nml
    43    !
    44  
    45    ! モジュール引用 ; USE statements
    46    !
    47  
    48    ! 種別型パラメタ
    49    ! Kind type parameter
    50    !
    51    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    52      &                 STRING, &  ! 文字列.       Strings.
    53      &                 TOKEN      ! キーワード.   Keywords.
    54  
    55    ! メッセージ出力
    56    ! Message output
    57    !
    58    use dc_message, only: MessageNotify
    59  
    60    ! 格子点設定
    61    ! Grid points settings
    62    !
    63    use gridset, only: imax, & ! 経度格子点数.
    64                               ! Number of grid points in longitude
    65      &                jmax, & ! 緯度格子点数.
    66                               ! Number of grid points in latitude
    67      &                kmax    ! 鉛直層数.
    68                               ! Number of vertical level
    69  
    70    ! 宣言文 ; Declaration statements
    71    !
    72    implicit none
    73    private
    74  
    75    ! 公開手続き
    76    ! Public procedure
    77    !
    78    public:: SetValuesFromTimeSeriesWrapper
    79  !!$  public:: SetValuesFromTimeSeries
    80    public:: ReadTimeSeriesInit
    81  
    82    ! 公開変数
    83    ! Public variables
    84    !
    85    logical, save :: read_time_series_inited = .false.
    86                                ! 初期設定フラグ.
    87                                ! Initialization flag
    88  
    89  
    90    ! 非公開変数
    91    ! Private variables
    92    !
    93  
    94    type time_series_data
    95      character(STRING):: Keyword
    96                                !
    97                                ! Keyword
    98      character(STRING):: FileName
    99                                ! ファイル名.
   100                                ! File name
   101      character(STRING):: VarName
   102                                ! 変数名.
   103                                ! Variable name
   104      integer          :: NDims
   105      integer          :: tmax
   106      integer          :: NVLevels
   107      real(DP), pointer:: z_VLevels(:)
   108      real(DP), pointer:: a_time(:)
   109      integer , pointer:: a_tindex(:)
   110      real(DP), pointer:: xyza_SavedData(:,:,:,:)
   111      real(DP), pointer:: xyz_VarTimeInterpolated(:,:,:)
   112      real(DP)         :: TimeFromOriginToInitialDate
   113    end type time_series_data
   114  
   115    integer, parameter :: NumMaxStructArr = 25
   116    integer, save      :: NumMaxStruct
   117  
   118    type(time_series_data), save :: a_TSDataInfo( NumMaxStructArr )
   119  
   120    logical, save :: FlagYearCyclic = .true.
   121  
   122    logical, save :: flag_mpi_split = .true.
   123  
   124  
   125  
   126    character(*), parameter:: module_name = 'read_time_series_from_file'
   127                                ! モジュールの名称.
   128                                ! Module name
   129    character(*), parameter:: version = &
   130      & '$Name:  $' // &
   131      & '$Id: read_time_series.f90,v 1.19 2015/01/29 12:02:29 yot Exp $'
   132                                ! モジュールのバージョン
   133                                ! Module version
   134  
   135    ! INTERFACE 文 ; INTERFACE statements
   136    !
   137    interface SetValuesFromTimeSeriesWrapper
   138      module procedure SetValFromTimeSeriesWrapper0D, SetValFromTimeSeriesWrapper2D, SetValFromTimeSeriesWrapper3D
   139    end interface
   140  
   141  contains
   142  
   143    !--------------------------------------------------------------------------------------
   144  
   145    subroutine SetValFromTimeSeriesWrapper0D( &
   146      & Keyword,           &
   147      & FileName, VarName, &
   148      & Var                &               ! (inout)
   149      & )
   150  
   151  
   152      ! 宣言文 ; Declaration statements
   153      !
   154      implicit none
   155  
   156      character(*), intent(in   ):: Keyword
   157      character(*), intent(in   ):: FileName
   158                                ! ファイル名.
   159                                ! File name
   160      character(*), intent(in   ):: VarName
   161                                ! 変数名.
   162                                ! Variable name
   163      real(DP)    , intent(inout):: Var
   164                                ! 地表面温度.
   165                                ! Surface temperature
   166  
   167  
   168      integer :: Index
   169  
   170  
   171      ! 初期化確認
   172      ! Initialization check
   173      !
   174      if ( .not. read_time_series_inited ) then
   175        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   176      end if
   177  
   178  
   179      call SetValFromTimeSeriesFindIndex( &
   180        & Keyword, & ! (in)
   181        & Index    & ! (out)
   182        & )
   183      call SetValuesFromTimeSeries( &
   184        & a_TSDataInfo( Index ),    &
   185        & FileName, VarName,        &
   186        & Var = Var                 & ! (inout)
   187        & )
   188  
   189  
   190    end subroutine SetValFromTimeSeriesWrapper0D
   191  
   192    !--------------------------------------------------------------------------------------
   193  
   194    subroutine SetValFromTimeSeriesWrapper2D( &
   195      & Keyword,           &
   196      & FileName, VarName, &
   197      & xy_Var             &               ! (inout)
   198      & )
   199  
   200  
   201      ! 宣言文 ; Declaration statements
   202      !
   203      implicit none
   204  
   205      character(*), intent(in   ):: Keyword
   206      character(*), intent(in   ):: FileName
   207                                ! ファイル名.
   208                                ! File name
   209      character(*), intent(in   ):: VarName
   210                                ! 変数名.
   211                                ! Variable name
   212      real(DP)    , intent(inout):: xy_Var(0:imax-1, 1:jmax)
   213                                ! 地表面温度.
   214                                ! Surface temperature
   215  
   216  
   217      integer :: Index
   218  
   219  
   220      ! 初期化確認
   221      ! Initialization check
   222      !
   223      if ( .not. read_time_series_inited ) then
   224        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   225      end if
   226  
   227  
   228      call SetValFromTimeSeriesFindIndex( &
   229        & Keyword, & ! (in)
   230        & Index    & ! (out)
   231        & )
   232      call SetValuesFromTimeSeries( &
   233        & a_TSDataInfo( Index ),    &
   234        & FileName, VarName,        &
   235        & xy_Var = xy_Var           & ! (inout)
   236        & )
   237  
   238  
   239    end subroutine SetValFromTimeSeriesWrapper2D
   240  
   241    !--------------------------------------------------------------------------------------
   242  
   243    subroutine SetValFromTimeSeriesWrapper3D( &
   244      & Keyword,                              & ! (in)
   245      & FileName, VarName,                    & ! (in)
   246      & xyz_Press,                            & ! (in)
   247      & xyz_Var,                              & ! (inout)
   248      & FlagLogVLev, FlagLog, FlagPositiveDef & ! (in)
   249      & )
   250  
   251  
   252      ! 宣言文 ; Declaration statements
   253      !
   254      implicit none
   255  
   256      character(*), intent(in   ):: Keyword
   257      character(*), intent(in   ):: FileName
   258                                ! ファイル名.
   259                                ! File name
   260      character(*), intent(in   ):: VarName
   261                                ! 変数名.
   262                                ! Variable name
   263      real(DP)    , intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   264                                ! 地表面温度.
   265                                ! Surface temperature
   266      real(DP)    , intent(inout):: xyz_Var(0:imax-1, 1:jmax, 1:kmax)
   267                                ! 地表面温度.
   268                                ! Surface temperature
   269      logical     , intent(in   ):: FlagLogVLev
   270      logical     , intent(in   ):: FlagLog
   271      logical     , intent(in   ):: FlagPositiveDef
   272  
   273  
   274      integer :: Index
   275  
   276  
   277      ! 初期化確認
   278      ! Initialization check
   279      !
   280      if ( .not. read_time_series_inited ) then
   281        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   282      end if
   283  
   284  
   285      call SetValFromTimeSeriesFindIndex( &
   286        & Keyword, & ! (in)
   287        & Index    & ! (out)
   288        & )
   289      call SetValuesFromTimeSeries( &
   290        & a_TSDataInfo(Index),      &
   291        & FileName, VarName,        &
   292        & xyz_Press = xyz_Press,    & ! (in)
   293        & xyz_Var = xyz_Var,        & ! (inout)
   294        & FlagLogVLev     = FlagLogVLev,     & ! (in ) optional
   295        & FlagLog         = FlagLog,         & ! (in ) optional
   296        & FlagPositiveDef = FlagPositiveDef  & ! (in ) optional
   297        & )
   298  
   299  
   300  
   301    end subroutine SetValFromTimeSeriesWrapper3D
   302  
   303    !--------------------------------------------------------------------------------------
   304  
   305    subroutine SetValFromTimeSeriesFindIndex( &
   306      & Keyword, & ! (in)
   307      & Index    & ! (out)
   308      & )
   309  
   310  
   311      ! 宣言文 ; Declaration statements
   312      !
   313      implicit none
   314  
   315      character(*), intent(in ):: Keyword
   316                                !
   317                                ! Keyword
   318      integer     , intent(out):: Index
   319                                !
   320                                ! Index
   321  
   322      integer :: l
   323  
   324  
   325      ! 初期化確認
   326      ! Initialization check
   327      !
   328      if ( .not. read_time_series_inited ) then
   329        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   330      end if
   331  
   332  
   333      ! Search index of a_TSDataInfo with Keyword
   334  
   335      Index = 0
   336  
   337      search_index : do l = 1, NumMaxStruct
   338        if ( a_TSDataInfo( l ) % Keyword == Keyword ) then
   339          Index = l
   340          exit search_index
   341        end if
   342      end do search_index
   343  
   344      ! If an element of a_TSDataInfo with Keyword cannot be found, a new
   345      ! element will be used.
   346      if ( Index == 0 ) then
   347        NumMaxStruct = NumMaxStruct + 1
   348        Index        = NumMaxStruct
   349        a_TSDataInfo( Index ) % Keyword = Keyword
   350      end if
   351  
   352  
   353      if ( Index > NumMaxStructArr ) then
   354        call MessageNotify( 'E', module_name, 'Index is greater than NumMaxStructArr.' )
   355      end if
   356  
   357  
   358    end subroutine SetValFromTimeSeriesFindIndex
   359  
   360    !--------------------------------------------------------------------------------------
   361  
   362    subroutine SetValuesFromTimeSeries(          &
   363      & TSDataInfo,                              &
   364      & FileName, VarName,                       &
   365      & xyz_Press,                               & ! (in   ) optional
   366      & Var,                                     & ! (inout) optional
   367      & xy_Var,                                  & ! (inout) optional
   368      & xyz_Var,                                 & ! (inout) optional
   369      & FlagLogVLev, FlagLog, FlagPositiveDef    & ! (in   ) optional
   370      & )
   371      !
   372      ! 地表面の諸々のデータを設定します.
   373      ! xy_SurfTemp 以外は一回目に呼ばれた時のみ設定されます.
   374      !
   375      ! Get various data on ground.
   376      ! Arguments excluding "xy_SurfTemp" are configured at first only.
   377      !
   378  
   379      ! モジュール引用 ; USE statements
   380      !
   381  
   382      ! gtool4 データ入力
   383      ! Gtool4 data input
   384      !
   385      use gtool_history, only: HistoryGet
   386  
   387      ! 文字列操作
   388      ! Character handling
   389      !
   390      use dc_string, only: toChar
   391  
   392      ! 日付および時刻の取り扱い
   393      ! Date and time handler
   394      !
   395      use dc_calendar, only: DCCalDateEvalSecOfYear
   396  
   397      ! 時刻管理
   398      ! Time control
   399      !
   400      use timeset, only: TimeN, InitialDate
   401  
   402      ! 宣言文 ; Declaration statements
   403      !
   404      implicit none
   405  
   406      type(time_series_data), intent(inout):: TSDataInfo
   407      character(*)          , intent(in   ):: FileName
   408                                ! ファイル名.
   409                                ! File name
   410      character(*)          , intent(in   ):: VarName
   411                                ! 変数名.
   412                                ! Variable name
   413      real(DP)    , optional, intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   414                                ! 3 次元配列.
   415                                ! 3D array
   416      real(DP)    , optional, intent(inout):: Var
   417                                ! 2 次元配列.
   418                                ! 2D array
   419      real(DP)    , optional, intent(inout):: xy_Var (0:imax-1, 1:jmax)
   420                                ! 2 次元配列.
   421                                ! 2D array
   422      real(DP)    , optional, intent(inout):: xyz_Var(0:imax-1, 1:jmax, 1:kmax)
   423                                ! 3 次元配列.
   424                                ! 3D array
   425      logical     , optional, intent(in   ):: FlagLogVLev
   426      logical     , optional, intent(in   ):: FlagLog
   427      logical     , optional, intent(in   ):: FlagPositiveDef
   428  
   429      ! 作業変数
   430      ! Work variables
   431      !
   432      real(DP):: CurrentTimeInSec
   433      integer :: tindex
   434  
   435  !!$    real(DP):: xyza_VarInterpolated(0:imax-1, 1:jmax, 1:kmax, 2)
   436  
   437      logical :: FlagReadData
   438  
   439      integer :: t
   440  
   441  
   442      ! 初期化確認
   443      ! Initialization check
   444      !
   445      if ( .not. read_time_series_inited ) then
   446        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   447      end if
   448  
   449  
   450      if ( ( .not. present( Var ) ) .and. ( .not. present( xy_Var ) ) .and. ( .not. present( xyz_Var ) ) ) then
   451        call MessageNotify( 'E', module_name, 'Var or xy_Var or xyz_Var have to be given.' )
   452      end if
   453  
   454      if ( ( present( Var ) ) .and. ( present( xy_Var ) ) ) then
   455        call MessageNotify( 'E', module_name, 'Both Var and xy_Var are not given.' )
   456      end if
   457  
   458      if ( ( present( xy_Var ) ) .and. ( present( xyz_Var ) ) ) then
   459        call MessageNotify( 'E', module_name, 'Both xy_Var and xyz_Var are not given.' )
   460      end if
   461  
   462      if ( ( present( xyz_Var ) ) .and. ( present( Var ) ) ) then
   463        call MessageNotify( 'E', module_name, 'Both xyz_Var and Var are not be given.' )
   464      end if
   465  
   466      if ( ( present( xyz_Var ) ) .and. ( .not. present( xyz_Press ) ) ) then
   467        call MessageNotify( 'E', module_name, 'xyz_Press has to be given, when xyz_Var is given.' )
   468      end if
   469  
   470      ! 実行文 ; Executable statement
   471      !
   472      if ( .not. associated( TSDataInfo % a_time ) ) then
   473        if ( present( Var ) ) then
   474          call StructureInit(       &
   475            & FileName, VarName, 0, &
   476            & TSDataInfo            &
   477            & )
   478        else if ( present( xy_Var ) ) then
   479          call StructureInit(       &
   480            & FileName, VarName, 2, &
   481            & TSDataInfo            &
   482            & )
   483        else
   484          call StructureInit(       &
   485            & FileName, VarName, 3, &
   486            & TSDataInfo            &
   487            & )
   488        end if
   489      end if
   490  
   491  
   492      ! Update values of time paying attention to leap year
   493      ! This is not used, because this causes error when FlagYearCyclic = .true..
   494      !
   495  !!$    call UpdateTime(     &
   496  !!$      & TSDataInfo             & ! (inout)
   497  !!$      & )
   498  
   499  
   500      if ( TSDataInfo % tmax >= 2 ) then
   501  
   502        if ( FlagYearCyclic ) then
   503          CurrentTimeInSec = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )
   504        else
   505          CurrentTimeInSec = TimeN + TSDataInfo%TimeFromOriginToInitialDate
   506        end if
   507  
   508  !!$      write( 6, * ) TSDataInfo%a_time(TSDataInfo%a_tindex(1)), &
   509  !!$        & SecOfYear, TSDataInfo%a_time(TSDataInfo%a_tindex(2))
   510  
   511  
   512        ! Check whether the data have to be read or not
   513        if ( ( CurrentTimeInSec <  TSDataInfo%a_time(TSDataInfo%a_tindex(1)) ) .or. &
   514          &  ( CurrentTimeInSec >= TSDataInfo%a_time(TSDataInfo%a_tindex(2)) ) ) then
   515          FlagReadData = .true.
   516        else
   517          FlagReadData = .false.
   518        end if
   519        if ( .not. FlagYearCyclic ) then
   520          if ( ( CurrentTimeInSec <  TSDataInfo%a_time(1)               ) .or. &
   521            &  ( CurrentTimeInSec >= TSDataInfo%a_time(TSDataInfo%tmax) ) ) then
   522            FlagReadData = .false.
   523            CurrentTimeInSec = max( CurrentTimeInSec, TSDataInfo%a_time(1) )
   524            CurrentTimeInSec = min( CurrentTimeInSec, TSDataInfo%a_time(TSDataInfo%tmax) )
   525          end if
   526        end if
   527  
   528        if ( FlagReadData ) then
   529  !!$      if ( ( CurrentTimeInSec <   TSDataInfo%a_time(TSDataInfo%a_tindex(1)) ) .or. &
   530  !!$        &  ( CurrentTimeInSec >=  TSDataInfo%a_time(TSDataInfo%a_tindex(2)) ) ) then
   531  
   532          TSDataInfo % a_tindex(1) = 0
   533          TSDataInfo % a_tindex(2) = 1
   534          do t = 1, TSDataInfo%tmax
   535            if ( TSDataInfo % a_time(t) <= CurrentTimeInSec ) then
   536              TSDataInfo % a_tindex(1) = t
   537              TSDataInfo % a_tindex(2) = t+1
   538            end if
   539          end do
   540  
   541  !!$        write( 6, * ) '##############################################'
   542  !!$        write( 6, * ) '##############################################'
   543  !!$        write( 6, * ) '##############################################'
   544  !!$        write( 6, * ) '##############################################'
   545  !!$        write( 6, * ) '##############################################'
   546  !!$        write( 6, * ) 'in if', TSDataInfo % a_tindex(1), TSDataInfo % a_tindex(2)
   547  !!$        write( 6, * ) '##############################################'
   548  !!$        write( 6, * ) '##############################################'
   549  !!$        write( 6, * ) '##############################################'
   550  !!$        write( 6, * ) '##############################################'
   551  !!$        write( 6, * ) '##############################################'
   552  
   553          ! set time index
   554          if ( FlagYearCyclic ) then
   555            tindex = TSDataInfo % a_tindex(1)
   556            if ( tindex == 0 ) then
   557              tindex = TSDataInfo % tmax
   558            else if ( tindex == TSDataInfo % tmax + 1 ) then
   559              tindex = 1
   560            else
   561              tindex = tindex
   562            end if
   563          else
   564            tindex = TSDataInfo % a_tindex(1)
   565            tindex = min( max( tindex, 1 ), TSDataInfo % tmax )
   566          end if
   567  
   568  
   569          if ( present( Var ) ) then
   570            call HistoryGet(                                       &
   571              & TSDataInfo%FileName,                               &
   572              & TSDataInfo%VarName,                                &
   573              & TSDataInfo%xyza_SavedData(0,1,1,1),                &
   574              & range = 'time=^'//toChar(tindex),                  &
   575              & flag_mpi_split = flag_mpi_split                    &
   576              & )
   577          else if ( present( xy_Var ) ) then
   578            call HistoryGet(                                       &
   579              & TSDataInfo%FileName,                               &
   580              & TSDataInfo%VarName,                                &
   581              & TSDataInfo%xyza_SavedData(:,:,1,1),                &
   582              & range = 'time=^'//toChar(tindex),                  &
   583              & flag_mpi_split = flag_mpi_split                    &
   584              & )
   585          else
   586            call HistoryGet(                                       &
   587              & TSDataInfo%FileName,                               &
   588              & TSDataInfo%VarName,                                &
   589              & TSDataInfo%xyza_SavedData(:,:,:,1),                &
   590              & range = 'time=^'//toChar(tindex),                  &
   591              & flag_mpi_split = flag_mpi_split                    &
   592              & )
   593          end if
   594  
   595          ! set time index
   596          if ( FlagYearCyclic ) then
   597            tindex = TSDataInfo % a_tindex(2)
   598            if ( tindex == 0 ) then
   599              tindex = TSDataInfo % tmax
   600            else if ( tindex == TSDataInfo % tmax + 1 ) then
   601              tindex = 1
   602            else
   603              tindex = tindex
   604            end if
   605          else
   606            tindex = TSDataInfo % a_tindex(2)
   607            tindex = min( max( tindex, 1 ), TSDataInfo % tmax )
   608          end if
   609  
   610          if ( present( Var ) ) then
   611            call HistoryGet(                                       &
   612              & TSDataInfo%FileName,                               &
   613              & TSDataInfo%VarName,                                &
   614              & TSDataInfo%xyza_SavedData(0,1,1,2),                &
   615              & range = 'time=^'//toChar(tindex),                  &
   616              & flag_mpi_split = flag_mpi_split                    &
   617              & )
   618          else if ( present( xy_Var ) ) then
   619            call HistoryGet(                                       &
   620              & TSDataInfo%FileName,                               &
   621              & TSDataInfo%VarName,                                &
   622              & TSDataInfo%xyza_SavedData(:,:,1,2),                &
   623              & range = 'time=^'//toChar(tindex),                  &
   624              & flag_mpi_split = flag_mpi_split                    &
   625              & )
   626          else
   627            call HistoryGet(                                       &
   628              & TSDataInfo%FileName,                               &
   629              & TSDataInfo%VarName,                                &
   630              & TSDataInfo%xyza_SavedData(:,:,:,2),                &
   631              & range = 'time=^'//toChar(tindex),                  &
   632              & flag_mpi_split = flag_mpi_split                    &
   633              & )
   634          end if
   635  
   636        end if
   637  
   638        if ( present( Var ) ) then
   639          Var =                                                 &
   640            &   ( TSDataInfo%xyza_SavedData(0,1,1,2)            &
   641            &   - TSDataInfo%xyza_SavedData(0,1,1,1)  )         &
   642            & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2))     &
   643            &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  )  &
   644            & * ( CurrentTimeInSec                              &
   645            &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
   646            & + TSDataInfo%xyza_SavedData(0,1,1,1)
   647        else if ( present( xy_Var ) ) then
   648          xy_Var =                                              &
     .        if (tsdatainfo.xyza_saveddata.DSC.U2 + 1 -                        
     .       1   tsdatainfo.xyza_saveddata.DSC.L2 .gt. 0) then                  
     .           j3 = and(tsdatainfo.xyza_saveddata.DSC.U2 + 1 -                
     .       1      tsdatainfo.xyza_saveddata.DSC.L2,3)                         
     .  !cdir    nodep                                                          
     .           do t2156 = 1, j3                                               
     .              tsdatainfo.a_tindex5 = tsdatainfo.a_tindex(1)               
     .              d3 = 1.D0/(tsdatainfo.a_time(tsdatainfo.a_tindex(2))-       
     .       1         tsdatainfo.a_time(tsdatainfo.a_tindex5))                 
     .  !cdir       nodep                                                       
     .              do t2158 = 1, tsdatainfo.xyza_saveddata.DSC.U1 -            
     .       1         tsdatainfo.xyza_saveddata.DSC.L1 + 2 - min0(1,           
     .       2         tsdatainfo.xyza_saveddata.DSC.U1 -                       
     .       3         tsdatainfo.xyza_saveddata.DSC.L1 + 1)                    
     .                 xy_var(t2158-1,t2156) = (tsdatainfo.xyza_saveddata(      
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156-1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,2)-                
     .       3            tsdatainfo.xyza_saveddata(                            
     .       4            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156-1+     
     .       5            tsdatainfo.xyza_saveddata.DSC.L2,1,1))*d3*(           
     .       6            currenttimeinsec - tsdatainfo.a_time(                 
     .       7            tsdatainfo.a_tindex5)) + tsdatainfo.xyza_saveddata(   
     .       8            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156-1+     
     .       9            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2156 = j3 + 1, tsdatainfo.xyza_saveddata.DSC.U2 + 1 -      
     .       1      tsdatainfo.xyza_saveddata.DSC.L2, 4                         
     .              tsdatainfo.a_tindex6 = tsdatainfo.a_tindex(1)               
     .              tsdatainfo.a_tindex7 = tsdatainfo.a_tindex(2)               
     .  !cdir       nodep                                                       
     .              do t2158 = 1, tsdatainfo.xyza_saveddata.DSC.U1 -            
     .       1         tsdatainfo.xyza_saveddata.DSC.L1 + 2 - min0(1,           
     .       2         tsdatainfo.xyza_saveddata.DSC.U1 -                       
     .       3         tsdatainfo.xyza_saveddata.DSC.L1 + 1)                    
     .                 d2 = tsdatainfo.a_time(tsdatainfo.a_tindex6)             
     .                 d1 = tsdatainfo.a_time(tsdatainfo.a_tindex7)             
     .                 xy_var(t2158-1,t2156) = (tsdatainfo.xyza_saveddata(      
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156-1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,2)-                
     .       3            tsdatainfo.xyza_saveddata(                            
     .       4            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156-1+     
     .       5            tsdatainfo.xyza_saveddata.DSC.L2,1,1))/(d1 - d2)*(    
     .       6            currenttimeinsec - d2) + tsdatainfo.xyza_saveddata(   
     .       7            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156-1+     
     .       8            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .                 xy_var(t2158-1,t2156+1) = (tsdatainfo.xyza_saveddata(    
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+       
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,2)-                
     .       3            tsdatainfo.xyza_saveddata(                            
     .       4            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+       
     .       5            tsdatainfo.xyza_saveddata.DSC.L2,1,1))/(d1 - d2)*(    
     .       6            currenttimeinsec - d2) + tsdatainfo.xyza_saveddata(   
     .       7            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+       
     .       8            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .                 xy_var(t2158-1,t2156+2) = (tsdatainfo.xyza_saveddata(    
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,2)-                
     .       3            tsdatainfo.xyza_saveddata(                            
     .       4            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+1+     
     .       5            tsdatainfo.xyza_saveddata.DSC.L2,1,1))/(d1 - d2)*(    
     .       6            currenttimeinsec - d2) + tsdatainfo.xyza_saveddata(   
     .       7            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+1+     
     .       8            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .                 xy_var(t2158-1,t2156+3) = (tsdatainfo.xyza_saveddata(    
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+2+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,2)-                
     .       3            tsdatainfo.xyza_saveddata(                            
     .       4            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+2+     
     .       5            tsdatainfo.xyza_saveddata.DSC.L2,1,1))/(d1 - d2)*(    
     .       6            currenttimeinsec - d2) + tsdatainfo.xyza_saveddata(   
     .       7            tsdatainfo.xyza_saveddata.DSC.L1+t2158-1,t2156+2+     
     .       8            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10021                                                        
   649            &   ( TSDataInfo%xyza_SavedData(:,:,1,2)            &
   650            &   - TSDataInfo%xyza_SavedData(:,:,1,1)  )         &
   651            & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2))     &
   652            &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  )  &
   653            & * ( CurrentTimeInSec                              &
   654            &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
   655            & + TSDataInfo%xyza_SavedData(:,:,1,1)
   656        else
   657          TSDataInfo%xyz_VarTimeInterpolated =                  &
     .        if (tsdatainfo.xyza_saveddata.DSC.U2 + 1 -                        
     .       1   tsdatainfo.xyza_saveddata.DSC.L2 .gt. 0) then                  
     .           j8 = and(tsdatainfo.xyza_saveddata.DSC.U2 + 1 -                
     .       1      tsdatainfo.xyza_saveddata.DSC.L2,3)                         
     .  !cdir    nodep                                                          
     .           do t2140 = 1, j8                                               
     .              tsdatainfo.a_tindex10 = tsdatainfo.a_tindex(1)              
     .              d6 = 1.D0/(tsdatainfo.a_time(tsdatainfo.a_tindex(2))-       
     .       1         tsdatainfo.a_time(tsdatainfo.a_tindex10))                
     .  !cdir       nodep                                                       
     .              do t2142 = 1, tsdatainfo.xyza_saveddata.DSC.U1 + 1 -        
     .       1         tsdatainfo.xyza_saveddata.DSC.L1                         
     .                 tsdatainfo.xyz_vartimeinterpolated(                      
     .       1            tsdatainfo.xyz_vartimeinterpolated.DSC.L1+t2142-1,    
     .       2            t2140-1+tsdatainfo.xyz_vartimeinterpolated.DSC.L2,    
     .       3            t2138+tsdatainfo.xyz_vartimeinterpolated.DSC.L3) = (  
     .       4            tsdatainfo.xyza_saveddata(                            
     .       5            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140-1+     
     .       6            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       7            tsdatainfo.xyza_saveddata.DSC.L3,2)-                  
     .       8            tsdatainfo.xyza_saveddata(                            
     .       9            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140-1+     
     .       .            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       1            tsdatainfo.xyza_saveddata.DSC.L3,1))*d6*(             
     .       2            currenttimeinsec - tsdatainfo.a_time(                 
     .       3            tsdatainfo.a_tindex10)) + tsdatainfo.xyza_saveddata(  
     .       4            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140-1+     
     .       5            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       6            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2140 = j8 + 1, tsdatainfo.xyza_saveddata.DSC.U2 + 1 -      
     .       1      tsdatainfo.xyza_saveddata.DSC.L2, 4                         
     .              tsdatainfo.a_tindex11 = tsdatainfo.a_tindex(1)              
     .              tsdatainfo.a_tindex12 = tsdatainfo.a_tindex(2)              
     .  !cdir       nodep                                                       
     .              do t2142 = 1, tsdatainfo.xyza_saveddata.DSC.U1 + 1 -        
     .       1         tsdatainfo.xyza_saveddata.DSC.L1                         
     .                 d5 = tsdatainfo.a_time(tsdatainfo.a_tindex11)            
     .                 d4 = tsdatainfo.a_time(tsdatainfo.a_tindex12)            
     .                 tsdatainfo.xyz_vartimeinterpolated(                      
     .       1            tsdatainfo.xyz_vartimeinterpolated.DSC.L1+t2142-1,    
     .       2            t2140-1+tsdatainfo.xyz_vartimeinterpolated.DSC.L2,    
     .       3            t2138+tsdatainfo.xyz_vartimeinterpolated.DSC.L3) = (  
     .       4            tsdatainfo.xyza_saveddata(                            
     .       5            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140-1+     
     .       6            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       7            tsdatainfo.xyza_saveddata.DSC.L3,2)-                  
     .       8            tsdatainfo.xyza_saveddata(                            
     .       9            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140-1+     
     .       .            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       1            tsdatainfo.xyza_saveddata.DSC.L3,1))/(d4 - d5)*(      
     .       2            currenttimeinsec - d5) + tsdatainfo.xyza_saveddata(   
     .       3            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140-1+     
     .       4            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       5            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .                 tsdatainfo.xyz_vartimeinterpolated(                      
     .       1            tsdatainfo.xyz_vartimeinterpolated.DSC.L1+t2142-1,    
     .       2            t2140+tsdatainfo.xyz_vartimeinterpolated.DSC.L2,t2138+
     .       3            tsdatainfo.xyz_vartimeinterpolated.DSC.L3) = (        
     .       4            tsdatainfo.xyza_saveddata(                            
     .       5            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+       
     .       6            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       7            tsdatainfo.xyza_saveddata.DSC.L3,2)-                  
     .       8            tsdatainfo.xyza_saveddata(                            
     .       9            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+       
     .       .            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       1            tsdatainfo.xyza_saveddata.DSC.L3,1))/(d4 - d5)*(      
     .       2            currenttimeinsec - d5) + tsdatainfo.xyza_saveddata(   
     .       3            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+       
     .       4            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       5            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .                 tsdatainfo.xyz_vartimeinterpolated(                      
     .       1            tsdatainfo.xyz_vartimeinterpolated.DSC.L1+t2142-1,    
     .       2            t2140+1+tsdatainfo.xyz_vartimeinterpolated.DSC.L2,    
     .       3            t2138+tsdatainfo.xyz_vartimeinterpolated.DSC.L3) = (  
     .       4            tsdatainfo.xyza_saveddata(                            
     .       5            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+1+     
     .       6            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       7            tsdatainfo.xyza_saveddata.DSC.L3,2)-                  
     .       8            tsdatainfo.xyza_saveddata(                            
     .       9            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+1+     
     .       .            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       1            tsdatainfo.xyza_saveddata.DSC.L3,1))/(d4 - d5)*(      
     .       2            currenttimeinsec - d5) + tsdatainfo.xyza_saveddata(   
     .       3            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+1+     
     .       4            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       5            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .                 tsdatainfo.xyz_vartimeinterpolated(                      
     .       1            tsdatainfo.xyz_vartimeinterpolated.DSC.L1+t2142-1,    
     .       2            t2140+2+tsdatainfo.xyz_vartimeinterpolated.DSC.L2,    
     .       3            t2138+tsdatainfo.xyz_vartimeinterpolated.DSC.L3) = (  
     .       4            tsdatainfo.xyza_saveddata(                            
     .       5            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+2+     
     .       6            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       7            tsdatainfo.xyza_saveddata.DSC.L3,2)-                  
     .       8            tsdatainfo.xyza_saveddata(                            
     .       9            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+2+     
     .       .            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       1            tsdatainfo.xyza_saveddata.DSC.L3,1))/(d4 - d5)*(      
     .       2            currenttimeinsec - d5) + tsdatainfo.xyza_saveddata(   
     .       3            tsdatainfo.xyza_saveddata.DSC.L1+t2142-1,t2140+2+     
     .       4            tsdatainfo.xyza_saveddata.DSC.L2,t2138+               
     .       5            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   658            &   ( TSDataInfo%xyza_SavedData(:,:,:,2)            &
   659            &   - TSDataInfo%xyza_SavedData(:,:,:,1)  )         &
   660            & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2))     &
   661            &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  )  &
   662            & * ( CurrentTimeInSec                              &
   663            &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
   664            & + TSDataInfo%xyza_SavedData(:,:,:,1)
   665  
   666          call VerticalInterpolation(                    &
   667            & TSDataInfo%NVLevels, TSDataInfo%z_VLevels, & ! (in )
   668            & TSDataInfo%xyz_VarTimeInterpolated,        & ! (in )
   669            & xyz_Press,                                 & ! (in )
   670            & xyz_Var,                                   & ! (out)
   671            & FlagLogVLev, FlagLog, FlagPositiveDef      & ! (in ) optional
   672            & )
   673        end if
   674  
   675      else
   676  
   677        if ( present( Var ) ) then
   678          Var = TSDataInfo%xyza_SavedData(0,1,1,1)
   679        else if ( present( xy_Var ) ) then
   680          xy_Var = TSDataInfo%xyza_SavedData(:,:,1,1)
     .        if (jmax .gt. 0) then                                             
     .           j13 = and(jmax,3)                                              
     .  !cdir    nodep                                                          
     .           do t2130 = 1, j13                                              
     .  !cdir       nodep                                                       
     .              do t2132 = 1, 1 + imax - min0(1,imax)                       
     .                 xy_var(t2132-1,t2130) = tsdatainfo.xyza_saveddata(       
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2132-1,t2130-1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2130 = j13 + 1, jmax, 4                                    
     .  !cdir       nodep                                                       
     .              do t2132 = 1, 1 + imax - min0(1,imax)                       
     .                 xy_var(t2132-1,t2130) = tsdatainfo.xyza_saveddata(       
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2132-1,t2130-1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .                 xy_var(t2132-1,t2130+1) = tsdatainfo.xyza_saveddata(     
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2132-1,t2130+       
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .                 xy_var(t2132-1,t2130+2) = tsdatainfo.xyza_saveddata(     
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2132-1,t2130+1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .                 xy_var(t2132-1,t2130+3) = tsdatainfo.xyza_saveddata(     
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2132-1,t2130+2+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,1,1)                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10021                                                        
   681        else
   682          call VerticalInterpolation(                    &
     .        if (tsdatainfo.xyza_saveddata.DSC.U2 + 1 -                        
     .       1   tsdatainfo.xyza_saveddata.DSC.L2 .gt. 0) then                  
     .           j14 = and(tsdatainfo.xyza_saveddata.DSC.U2 + 1 -               
     .       1      tsdatainfo.xyza_saveddata.DSC.L2,3)                         
     .  !cdir    nodep                                                          
     .           do t2120 = 1, j14                                              
     .  !cdir       nodep                                                       
     .              do t2122 = 1, tsdatainfo.xyza_saveddata.DSC.U1 + 1 -        
     .       1         tsdatainfo.xyza_saveddata.DSC.L1                         
     .                 %IG19(t2122,t2120,t2118+1) = tsdatainfo.xyza_saveddata(  
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2122-1,t2120-1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,t2118+               
     .       3            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2120 = j14 + 1, tsdatainfo.xyza_saveddata.DSC.U2 + 1 -     
     .       1      tsdatainfo.xyza_saveddata.DSC.L2, 4                         
     .  !cdir       nodep                                                       
     .              do t2122 = 1, tsdatainfo.xyza_saveddata.DSC.U1 + 1 -        
     .       1         tsdatainfo.xyza_saveddata.DSC.L1                         
     .                 %IG19(t2122,t2120,t2118+1) = tsdatainfo.xyza_saveddata(  
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2122-1,t2120-1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,t2118+               
     .       3            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .                 %IG19(t2122,t2120+1,t2118+1) = tsdatainfo.xyza_saveddata(
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2122-1,t2120+       
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,t2118+               
     .       3            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .                 %IG19(t2122,t2120+2,t2118+1) = tsdatainfo.xyza_saveddata(
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2122-1,t2120+1+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,t2118+               
     .       3            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .                 %IG19(t2122,t2120+3,t2118+1) = tsdatainfo.xyza_saveddata(
     .       1            tsdatainfo.xyza_saveddata.DSC.L1+t2122-1,t2120+2+     
     .       2            tsdatainfo.xyza_saveddata.DSC.L2,t2118+               
     .       3            tsdatainfo.xyza_saveddata.DSC.L3,1)                   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   683            & TSDataInfo%NVLevels, TSDataInfo%z_VLevels, & ! (in )
   684            & TSDataInfo%xyza_SavedData(:,:,:,1),        & ! (in )
   685            & xyz_Press,                                 & ! (in )
   686            & xyz_Var,                                   & ! (out)
   687            & FlagLogVLev, FlagLog, FlagPositiveDef      & ! (in ) optional
   688            & )
   689        end if
   690  
   691      end if
   692  
   693  
   694    end subroutine SetValuesFromTimeSeries
   695  
   696    !--------------------------------------------------------------------------------------
   697  
   698    subroutine VerticalInterpolation(          &
   699      & NVLevels, z_VLevelsIn, xyz_VarIn,      & ! (in )
   700      & xyz_VLevelsOut,                        & ! (in )
   701      & xyz_VarOut,                            & ! (out)
   702      & FlagLogVLev, FlagLog, FlagPositiveDef  & ! (in ) optional
   703      & )
   704  
   705      ! モジュール引用 ; USE statements
   706      !
   707  
   708      ! 宣言文 ; Declaration statements
   709      !
   710      implicit none
   711  
   712      integer , intent(in ):: NVLevels
   713      real(DP), intent(in ):: z_VLevelsIn(1:NVLevels)
   714      real(DP), intent(in ):: xyz_VarIn  (0:imax-1, 1:jmax, 1:NVLevels)
   715      real(DP), intent(in ):: xyz_VlevelsOut(0:imax-1, 1:jmax, 1:kmax)
   716      real(DP), intent(out):: xyz_VarOut    (0:imax-1, 1:jmax, 1:kmax)
   717      logical , intent(in ), optional:: FlagLogVLev
   718      logical , intent(in ), optional:: FlagLog
   719      logical , intent(in ), optional:: FlagPositiveDef
   720  
   721  
   722      ! 作業変数
   723      ! Work variables
   724      !
   725      logical:: FlagLogVLevLV
   726      logical:: FlagLogLV
   727      logical:: FlagPositiveDefLV
   728      integer:: i
   729      integer:: j
   730      integer:: k
   731      integer:: kk
   732      integer:: xyz_kk(0:imax-1, 1:jmax, 1:kmax)
   733  
   734  
   735      ! 実行文 ; Executable statement
   736      !
   737  
   738      ! 初期化確認
   739      ! Initialization check
   740      !
   741      if ( .not. read_time_series_inited ) then
   742        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   743      end if
   744  
   745      ! Check order of vertical levels
   746      !
   747      if ( z_VlevelsIn(1) < z_VlevelsIn(2) ) then
   748        call MessageNotify( 'E', module_name, 'The order of vertical levels is inappropriate.' )
   749      end if
   750  
   751  
   752      ! Flags are checked
   753      !
   754      if ( present( FlagLogVLev ) ) then
   755        FlagLogVLevLV = FlagLogVLev
   756      else
   757        FlagLogVLevLV = .false.
   758      end if
   759      if ( present( FlagLog ) ) then
   760        FlagLogLV = FlagLog
   761      else
   762        FlagLogLV = .false.
   763      end if
   764      if ( present( FlagPositiveDef ) ) then
   765        FlagPositiveDefLV = FlagPositiveDef
   766      else
   767        FlagPositiveDefLV = .false.
   768      end if
   769  
   770  
   771      xyz_kk = 1
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t532 = 1, xyz_kk.DSC.U3*(xyz_kk.DSC.U2*xyz_kk.DSC.U1 +         
     .       1   xyz_kk.DSC.U2)                                                 
     .           xyz_kk(t532-1,1,1) = 1                                         
     .        enddo                                                             
   772  
   773      do kk = 1, NVLevels-1
   774  
   775        do k = 1, kmax
   776          do j = 1, jmax
   777            do i = 0, imax-1
   778              if ( xyz_VLevelsOut(i,j,k) < z_VLevelsIn(kk) ) then
   779                xyz_kk(i,j,k) = kk
   780              end if
   781            end do
   782          end do
   783        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_vlevelsout,xyz_kk)                                     
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_vlevelsout(k-1,1,1) .lt. z_vlevelsin(kk)) then         
     .              xyz_kk(k-1,1,1) = kk                                        
     .           endif                                                          
     .        enddo                                                             
   784  
   785      end do
   786  
   787  
   788      if ( FlagLogVLevLV ) then
   789  
   790        if ( FlagLogLV ) then
   791          ! log-log
   792  
   793          do k = 1, kmax
   794            do j = 1, jmax
   795              do i = 0, imax-1
   796  
   797  !!$          if ( xyz_VLevelsOut(i,j,k) > z_VLevelsIn(1) ) then
   798  !!$            xyz_VarOut(i,j,k) = xyz_VarIn(i,j,1)
   799  !!$
   800  !!$!          else if ( xyz_VLevelsOut(i,j,k) < z_VLevelsIn(NVLevels) ) then
   801  !!$!            call MessageNotify( 'E', module_name, 'Vertical level is out of given range.' )
   802  !!$!!            xyz_VarOut(i,j,k) = 0.0d0
   803  !!$
   804  !!$          else
   805  !!$
   806  !!$            xyz_VarOut(i,j,k) = &
   807  !!$              &   ( xyz_VarIn(i,j,xyz_kk(i,j,k)+1)     - xyz_VarIn(i,j,xyz_kk(i,j,k)) ) &
   808  !!$              & / log( z_VLevelsIn   (xyz_kk(i,j,k)+1) / z_VLevelsIn(xyz_kk(i,j,k))   ) &
   809  !!$              & * log( xyz_VLevelsOut(i,j,k)           / z_VLevelsIn(xyz_kk(i,j,k))   ) &
   810  !!$              & + xyz_VarIn(i,j,xyz_kk(i,j,k))
   811  !!$
   812  !!$          end if
   813  
   814  
   815                xyz_VarOut(i,j,k) = &
   816                  &   log(   ( xyz_VarIn(i,j,xyz_kk(i,j,k)+1) + 1.0d-100 )    &
   817                  &        / ( xyz_VarIn(i,j,xyz_kk(i,j,k)  ) + 1.0d-100 )  ) &
   818                  & / log(   z_VLevelsIn   (xyz_kk(i,j,k)+1)                  &
   819                  &        / z_VLevelsIn(xyz_kk(i,j,k))      )                &
   820                  & * log(   xyz_VLevelsOut(i,j,k)                            &
   821                  &        / z_VLevelsIn(xyz_kk(i,j,k))      )                &
   822                  & + log( xyz_VarIn(i,j,xyz_kk(i,j,k)) + 1.0d-100 )
   823                xyz_VarOut(i,j,k) = exp( xyz_VarOut(i,j,k) )
   824  
   825              end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(xyz_vlevelsout,xyz_kk)                                     
     .        do i = 1, imax                                                    
     .           xyz_varout1 = dlog((xyz_varin(i-1,j,xyz_kk(i-1,j,k)+1)+        
     .       1      1.00000000000000e-100)/(xyz_varin(i-1,j,xyz_kk(i-1,j,k))+   
     .       2      1.00000000000000e-100))/dlog(z_vlevelsin(xyz_kk(i-1,j,k)+1)/
     .       3      (z_vlevelsin(xyz_kk(i-1,j,k))))*dlog(xyz_vlevelsout(i-1,j,k)
     .       4      /(z_vlevelsin(xyz_kk(i-1,j,k)))) + dlog(xyz_varin(i-1,j,    
     .       5      xyz_kk(i-1,j,k))+1.00000000000000e-100)                     
     .           xyz_varout(i-1,j,k) = dexp(xyz_varout1)                        
     .        enddo                                                             
   826            end do
   827          end do
   828  
   829        else
   830          ! log-linear
   831  
   832          do k = 1, kmax
   833            do j = 1, jmax
   834              do i = 0, imax-1
   835  
   836                xyz_VarOut(i,j,k) =                            &
   837                  &   (   xyz_VarIn(i,j,xyz_kk(i,j,k)+1)       &
   838                  &     - xyz_VarIn(i,j,xyz_kk(i,j,k)  )     ) &
   839                  & / log(   z_VLevelsIn   (xyz_kk(i,j,k)+1)   &
   840                  &        / z_VLevelsIn(xyz_kk(i,j,k))      ) &
   841                  & * log(   xyz_VLevelsOut(i,j,k)             &
   842                  &        / z_VLevelsIn(xyz_kk(i,j,k))      ) &
   843                  & + xyz_VarIn(i,j,xyz_kk(i,j,k))
   844  
   845              end do
   846            end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_vlevelsout,xyz_kk)                               
     .              do i = 1, imax                                              
     .                 xyz_varout(i-1,j,k) = (xyz_varin(i-1,j,xyz_kk(i-1,j,k)+1)
     .       1            -xyz_varin(i-1,j,xyz_kk(i-1,j,k)))/dlog(z_vlevelsin(  
     .       2            xyz_kk(i-1,j,k)+1)/(z_vlevelsin(xyz_kk(i-1,j,k))))*   
     .       3            dlog(xyz_vlevelsout(i-1,j,k)/(z_vlevelsin(xyz_kk(i-1,j
     .       4            ,k)))) + xyz_varin(i-1,j,xyz_kk(i-1,j,k))             
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_vlevelsout,xyz_kk)                               
     .              do i = 1, imax                                              
     .                 xyz_varout(i-1,j,k) = (xyz_varin(i-1,j,xyz_kk(i-1,j,k)+1)
     .       1            -xyz_varin(i-1,j,xyz_kk(i-1,j,k)))/dlog(z_vlevelsin(  
     .       2            xyz_kk(i-1,j,k)+1)/(z_vlevelsin(xyz_kk(i-1,j,k))))*   
     .       3            dlog(xyz_vlevelsout(i-1,j,k)/(z_vlevelsin(xyz_kk(i-1,j
     .       4            ,k)))) + xyz_varin(i-1,j,xyz_kk(i-1,j,k))             
     .                 xyz_varout(i-1,j+1,k) = (xyz_varin(i-1,1+j,xyz_kk(i-1,j+1
     .       1            ,k)+1)-xyz_varin(i-1,1+j,xyz_kk(i-1,j+1,k)))/dlog(    
     .       2            z_vlevelsin(xyz_kk(i-1,j+1,k)+1)/(z_vlevelsin(xyz_kk(i
     .       3            -1,j+1,k))))*dlog(xyz_vlevelsout(i-1,j+1,k)/(         
     .       4            z_vlevelsin(xyz_kk(i-1,j+1,k)))) + xyz_varin(i-1,1+j, 
     .       5            xyz_kk(i-1,j+1,k))                                    
     .                 xyz_varout(i-1,j+2,k) = (xyz_varin(i-1,2+j,xyz_kk(i-1,j+2
     .       1            ,k)+1)-xyz_varin(i-1,2+j,xyz_kk(i-1,j+2,k)))/dlog(    
     .       2            z_vlevelsin(xyz_kk(i-1,j+2,k)+1)/(z_vlevelsin(xyz_kk(i
     .       3            -1,j+2,k))))*dlog(xyz_vlevelsout(i-1,j+2,k)/(         
     .       4            z_vlevelsin(xyz_kk(i-1,j+2,k)))) + xyz_varin(i-1,2+j, 
     .       5            xyz_kk(i-1,j+2,k))                                    
     .                 xyz_varout(i-1,j+3,k) = (xyz_varin(i-1,3+j,xyz_kk(i-1,j+3
     .       1            ,k)+1)-xyz_varin(i-1,3+j,xyz_kk(i-1,j+3,k)))/dlog(    
     .       2            z_vlevelsin(xyz_kk(i-1,j+3,k)+1)/(z_vlevelsin(xyz_kk(i
     .       3            -1,j+3,k))))*dlog(xyz_vlevelsout(i-1,j+3,k)/(         
     .       4            z_vlevelsin(xyz_kk(i-1,j+3,k)))) + xyz_varin(i-1,3+j, 
     .       5            xyz_kk(i-1,j+3,k))                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   847          end do
   848  
   849        end if
   850  
   851      else
   852  
   853        if ( FlagLogLV ) then
   854          ! linear-log
   855  
   856          do k = 1, kmax
   857            do j = 1, jmax
   858              do i = 0, imax-1
   859  
   860                xyz_VarOut(i,j,k) = &
   861                  &   log(   ( xyz_VarIn(i,j,xyz_kk(i,j,k)+1) + 1.0d-100 )    &
   862                  &        / ( xyz_VarIn(i,j,xyz_kk(i,j,k)  ) + 1.0d-100 )  ) &
   863                  & / (   z_VLevelsIn(xyz_kk(i,j,k)+1)                        &
   864                  &     - z_VLevelsIn(xyz_kk(i,j,k)  )    )                   &
   865                  & * (   xyz_VLevelsOut(i,j,k)                               &
   866                  &     - z_VLevelsIn(xyz_kk(i,j,k))      )                   &
   867                  & + log( xyz_VarIn(i,j,xyz_kk(i,j,k)) + 1.0d-100 )
   868                xyz_VarOut(i,j,k) = exp( xyz_VarOut(i,j,k) )
   869  
   870              end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(xyz_vlevelsout,xyz_kk)                                     
     .        do i = 1, imax                                                    
     .           xyz_varout2 = dlog((xyz_varin(i-1,j,xyz_kk(i-1,j,k)+1)+        
     .       1      1.00000000000000e-100)/(xyz_varin(i-1,j,xyz_kk(i-1,j,k))+   
     .       2      1.00000000000000e-100))/(z_vlevelsin(xyz_kk(i-1,j,k)+1)-(   
     .       3      z_vlevelsin(xyz_kk(i-1,j,k))))*(xyz_vlevelsout(i-1,j,k)-(   
     .       4      z_vlevelsin(xyz_kk(i-1,j,k)))) + dlog(xyz_varin(i-1,j,xyz_kk
     .       5      (i-1,j,k))+1.00000000000000e-100)                           
     .           xyz_varout(i-1,j,k) = dexp(xyz_varout2)                        
     .        enddo                                                             
   871            end do
   872          end do
   873  
   874        else
   875          ! linear-linear
   876  
   877          do k = 1, kmax
   878            do j = 1, jmax
   879              do i = 0, imax-1
   880  
   881                xyz_VarOut(i,j,k) = &
   882                  &   (   xyz_VarIn(i,j,xyz_kk(i,j,k)+1)   &
   883                  &     - xyz_VarIn(i,j,xyz_kk(i,j,k)  ) ) &
   884                  & / (   z_VLevelsIn(xyz_kk(i,j,k)+1)     &
   885                  &     - z_VLevelsIn(xyz_kk(i,j,k)  )   ) &
   886                  & * (   xyz_VLevelsOut(i,j,k)            &
   887                  &     - z_VLevelsIn(xyz_kk(i,j,k))     ) &
   888                  & + xyz_VarIn(i,j,xyz_kk(i,j,k))
   889  
   890              end do
   891            end do
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           do j = 1, j2                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_vlevelsout,xyz_kk)                               
     .              do i = 1, imax                                              
     .                 xyz_varout(i-1,j,k) = (xyz_varin(i-1,j,xyz_kk(i-1,j,k)+1)
     .       1            -xyz_varin(i-1,j,xyz_kk(i-1,j,k)))/(z_vlevelsin(xyz_kk
     .       2            (i-1,j,k)+1)-(z_vlevelsin(xyz_kk(i-1,j,k))))*(        
     .       3            xyz_vlevelsout(i-1,j,k)-(z_vlevelsin(xyz_kk(i-1,j,k)))
     .       4            ) + xyz_varin(i-1,j,xyz_kk(i-1,j,k))                  
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j2 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_vlevelsout,xyz_kk)                               
     .              do i = 1, imax                                              
     .                 xyz_varout(i-1,j,k) = (xyz_varin(i-1,j,xyz_kk(i-1,j,k)+1)
     .       1            -xyz_varin(i-1,j,xyz_kk(i-1,j,k)))/(z_vlevelsin(xyz_kk
     .       2            (i-1,j,k)+1)-(z_vlevelsin(xyz_kk(i-1,j,k))))*(        
     .       3            xyz_vlevelsout(i-1,j,k)-(z_vlevelsin(xyz_kk(i-1,j,k)))
     .       4            ) + xyz_varin(i-1,j,xyz_kk(i-1,j,k))                  
     .                 xyz_varout(i-1,j+1,k) = (xyz_varin(i-1,1+j,xyz_kk(i-1,j+1
     .       1            ,k)+1)-xyz_varin(i-1,1+j,xyz_kk(i-1,j+1,k)))/(        
     .       2            z_vlevelsin(xyz_kk(i-1,j+1,k)+1)-(z_vlevelsin(xyz_kk(i
     .       3            -1,j+1,k))))*(xyz_vlevelsout(i-1,j+1,k)-(z_vlevelsin( 
     .       4            xyz_kk(i-1,j+1,k)))) + xyz_varin(i-1,1+j,xyz_kk(i-1,j+
     .       5            1,k))                                                 
     .                 xyz_varout(i-1,j+2,k) = (xyz_varin(i-1,2+j,xyz_kk(i-1,j+2
     .       1            ,k)+1)-xyz_varin(i-1,2+j,xyz_kk(i-1,j+2,k)))/(        
     .       2            z_vlevelsin(xyz_kk(i-1,j+2,k)+1)-(z_vlevelsin(xyz_kk(i
     .       3            -1,j+2,k))))*(xyz_vlevelsout(i-1,j+2,k)-(z_vlevelsin( 
     .       4            xyz_kk(i-1,j+2,k)))) + xyz_varin(i-1,2+j,xyz_kk(i-1,j+
     .       5            2,k))                                                 
     .                 xyz_varout(i-1,j+3,k) = (xyz_varin(i-1,3+j,xyz_kk(i-1,j+3
     .       1            ,k)+1)-xyz_varin(i-1,3+j,xyz_kk(i-1,j+3,k)))/(        
     .       2            z_vlevelsin(xyz_kk(i-1,j+3,k)+1)-(z_vlevelsin(xyz_kk(i
     .       3            -1,j+3,k))))*(xyz_vlevelsout(i-1,j+3,k)-(z_vlevelsin( 
     .       4            xyz_kk(i-1,j+3,k)))) + xyz_varin(i-1,3+j,xyz_kk(i-1,j+
     .       5            3,k))                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   892          end do
   893  
   894        end if
   895  
   896      end if
   897  
   898  
   899      if ( FlagPositiveDefLV ) then
   900  
   901        do k = 1, kmax
   902          do j = 1, jmax
   903            do i = 0, imax-1
   904  
   905              if ( xyz_VarOut(i,j,k) < 0.0_DP ) then
   906                xyz_VarOut(i,j,k) = 0.0_DP
   907              end if
   908  
   909            end do
   910          end do
   911        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_varout(k-1,1,1) .lt. 0.0000000000000000e+000) then     
     .              xyz_varout(k-1,1,1) = 0.0000000000000000e+000               
     .           endif                                                          
     .        enddo                                                             
   912  
   913      end if
   914  
   915  
   916  !!$    i = 0
   917  !!$    j = jmax / 2
   918  !!$    do k = 1, NVLevels
   919  !!$      write( 92, * ) z_VLevelsIn(k), xyz_VarIn(i,j,k)
   920  !!$    end do
   921  !!$    write( 92, * )
   922  !!$    call flush( 92 )
   923  !!$    do k = 1, kmax
   924  !!$      write( 93, * ) xyz_VLevelsOut(i,j,k), xyz_VarOut(i,j,k)
   925  !!$    end do
   926  !!$    write( 93, * )
   927  !!$    call flush( 93 )
   928  !!$    stop
   929  
   930  
   931    end subroutine VerticalInterpolation
   932  
   933    !--------------------------------------------------------------------------------------
   934  
   935    subroutine UpdateTime(     &
   936      & TSDataInfo             & ! (inout)
   937      & )
   938  
   939      ! モジュール引用 ; USE statements
   940      !
   941  
   942      ! 暦と日時の取り扱い
   943      ! Calendar and Date handler
   944      !
   945      use dc_calendar, only: &
   946        & DC_CAL_DATE             ! 日時を表現するデータ型.
   947                                  ! Data type for date and time
   948  
   949      ! 日付および時刻の取り扱い
   950      ! Date and time handler
   951      !
   952      use dc_calendar, only: DCCalInquire, DCCalDateCreate, DCCalDateInquire, DCCalDateChkLeapYear
   953  
   954      ! 時刻管理
   955      ! Time control
   956      !
   957      use timeset, only: TimeN, InitialDate
   958  
   959      ! 宣言文 ; Declaration statements
   960      !
   961      implicit none
   962  
   963      type(time_series_data), intent(inout):: TSDataInfo
   964  
   965  
   966      ! 作業変数
   967      ! Work variables
   968      !
   969      integer           :: hour_in_day, min_in_hour, day_in_year
   970      integer, pointer  :: day_in_month_ptr(:) => null()
   971      real(DP)          :: sec_in_min, sec_in_day
   972  
   973      integer           :: year
   974      type(DC_CAL_DATE) :: PreYearDate
   975  
   976  
   977      ! 実行文 ; Executable statement
   978      !
   979  
   980      ! 初期化確認
   981      ! Initialization check
   982      !
   983      if ( .not. read_time_series_inited ) then
   984        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   985      end if
   986  
   987  
   988      if ( TSDataInfo % tmax >= 2 ) then
   989  
   990        call DCCalInquire( &
   991          & day_in_month_ptr = day_in_month_ptr , & ! (out)
   992          & hour_in_day      = hour_in_day  , &     ! (out)
   993          & min_in_hour      = min_in_hour  , &     ! (out)
   994          & sec_in_min       = sec_in_min )         ! (out)
   995        day_in_year = sum( day_in_month_ptr )
   996        deallocate( day_in_month_ptr )
   997        sec_in_day  = hour_in_day * min_in_hour * sec_in_min
   998  
   999  
  1000        ! Set TSDataInfo % a_time(0)
  1001        !
  1002  
  1003        call DCCalDateInquire(       &
  1004          & year       = year,       & ! (out)
  1005          & elapse_sec = TimeN,      & ! (in)
  1006          & date       = InitialDate & ! (in)
  1007          & )
  1008        call DCCalDateCreate(        &
  1009          & year       = year - 1,   & ! (in)
  1010          & month      = 1,          & ! (in)
  1011          & day        = 1,          & ! (in)
  1012          & hour       = 0,          & ! (in)
  1013          & min        = 0,          & ! (in)
  1014          & sec        = 0.0_DP,     & ! (in)
  1015          & date       = PreYearDate & ! (out)
  1016          & )
  1017  
  1018        if ( DCCalDateChkLeapYear( 0.0_DP, PreYearDate ) ) then
  1019          TSDataInfo % a_time(0                ) = &
  1020            & - ( ( day_in_year + 1 ) * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
  1021        else
  1022          TSDataInfo % a_time(0                ) = &
  1023            & - (   day_in_year       * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
  1024        end if
  1025  
  1026  
  1027        ! Set TSDataInfo % a_time(TSDataInfo%tmax+1)
  1028        !
  1029  
  1030        if ( DCCalDateChkLeapYear( TimeN, InitialDate ) ) then
  1031          TSDataInfo % a_time(TSDataInfo%tmax+1) = &
  1032            &     ( day_in_year + 1 ) * sec_in_day + TSDataInfo % a_time(1              )
  1033        else
  1034          TSDataInfo % a_time(TSDataInfo%tmax+1) = &
  1035            &       day_in_year       * sec_in_day + TSDataInfo % a_time(1              )
  1036        end if
  1037  
  1038  
  1039      end if
  1040  
  1041  
  1042    end subroutine UpdateTime
  1043  
  1044    !--------------------------------------------------------------------------------------
  1045  
  1046    subroutine InterpretTimeUnitString( &
  1047      & FileName, DateString,       & ! (in)
  1048      & Yr, Mon, Day, Hr, Min, Sec  & ! (out)
  1049      & )
  1050  
  1051      ! モジュール引用 ; USE statements
  1052      !
  1053  
  1054      ! 宣言文 ; Declaration statements
  1055      !
  1056      implicit none
  1057  
  1058      character(*), intent(in ) :: FileName
  1059      character(*), intent(in ) :: DateString
  1060      integer     , intent(out) :: Yr
  1061      integer     , intent(out) :: Mon
  1062      integer     , intent(out) :: Day
  1063      integer     , intent(out) :: Hr
  1064      integer     , intent(out) :: Min
  1065      real(DP)    , intent(out) :: Sec
  1066  
  1067  
  1068      ! 作業変数
  1069      ! Work variables
  1070      !
  1071      integer :: StrLen
  1072      integer :: l
  1073      integer :: ll
  1074  
  1075      ! 実行文 ; Executable statement
  1076      !
  1077  
  1078      ! 初期化確認
  1079      ! Initialization check
  1080      !
  1081      if ( .not. read_time_series_inited ) then
  1082        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1083      end if
  1084  
  1085      StrLen = len_trim( DateString )
  1086  
  1087      ! format of the DateString has to be "... since YYYY/MM/DD HH:MM:SS".
  1088  
  1089      search_since : do ll = 1, StrLen-5+1
  1090        if ( DateString(ll:ll+5-1) == "since" ) exit search_since
  1091      end do search_since
  1092      if ( ll > StrLen-5+1 ) then
  1093        call MessageNotify( 'E', module_name, 'Unable to find "since" in %c.', c1 = trim(FileName) )
  1094      end if
  1095      !
  1096      l = ll + 5
  1097      !
  1098      if ( DateString(l:l) /= " " ) then
  1099        call MessageNotify( 'E', module_name, 'Unable to find a space after "since" in %c.', c1 = trim(FileName) )
  1100      end if
  1101      !
  1102      l = l + 1
  1103      !
  1104      search_yr : do ll = l, StrLen
  1105        if ( DateString(ll:ll) == "-" ) exit search_yr
  1106      end do search_yr
  1107      if ( ll > StrLen ) then
  1108        call MessageNotify( 'E', module_name, 'Unable to find "-" between year and month in %c.', c1 = trim(FileName) )
  1109      end if
  1110      read( DateString(l:ll-1), * ) Yr
  1111      !
  1112      l = ll + 1
  1113      !
  1114      search_mon : do ll = l, StrLen
  1115        if ( DateString(ll:ll) == "-" ) exit search_mon
  1116      end do search_mon
  1117      if ( ll > StrLen ) then
  1118        call MessageNotify( 'E', module_name, 'Unable to find "-" between month and day in %c.', c1 = trim(FileName) )
  1119      end if
  1120      read( DateString(l:ll-1), * ) Mon
  1121      !
  1122      l = ll + 1
  1123      !
  1124      search_day : do ll = l, StrLen
  1125        if ( DateString(ll:ll) == " " ) exit search_day
  1126      end do search_day
  1127      if ( ll > StrLen ) then
  1128        call MessageNotify( 'E', module_name, 'Unable to find a space between day and hour in %c.', c1 = trim(FileName) )
  1129      end if
  1130      read( DateString(l:ll-1), * ) Day
  1131      !
  1132      l = ll
  1133      !
  1134      if ( DateString(l:l) /= " " ) then
  1135        call MessageNotify( 'E', module_name, 'Unable to confirm a space between day and hour in %c.', c1 = trim(FileName) )
  1136      end if
  1137      !
  1138      l = l + 1
  1139      !
  1140      search_hr : do ll = l, StrLen
  1141        if ( DateString(ll:ll) == ":" ) exit search_hr
  1142      end do search_hr
  1143      if ( ll > StrLen ) then
  1144        call MessageNotify( 'E', module_name, 'Unable to find ":" between hour and minute in %c.', c1 = trim(FileName) )
  1145      end if
  1146      read( DateString(l:ll-1), * ) Hr
  1147      !
  1148      l = ll + 1
  1149      !
  1150      search_min : do ll = l, StrLen
  1151        if ( DateString(ll:ll) == ":" ) exit search_min
  1152      end do search_min
  1153      if ( ll > StrLen ) then
  1154        call MessageNotify( 'E', module_name, 'Unable to find ":" between minute and second in %c.', c1 = trim(FileName) )
  1155      end if
  1156      read( DateString(l:ll-1), * ) Min
  1157      !
  1158      l = ll + 1
  1159      !
  1160      search_sec : do ll = l, StrLen
  1161        if ( ( DateString(ll:ll) == " " ) .or. ( DateString(ll:ll) == "." ) ) exit search_sec
  1162      end do search_sec
  1163  !!$    if ( ll > StrLen ) then
  1164  !!$      call MessageNotify( 'E', module_name, 'Unable to find end of second in %c.', c1 = trim(FileName) )
  1165  !!$    end if
  1166      read( DateString(l:ll-1), * ) Sec
  1167  
  1168  
  1169    end subroutine InterpretTimeUnitString
  1170  
  1171    !--------------------------------------------------------------------------------------
  1172  
  1173    subroutine StructureInit(     &
  1174      & FileName, VarName, NDims, &
  1175      & TSDataInfo                &
  1176      & )
  1177  
  1178      ! モジュール引用 ; USE statements
  1179      !
  1180  
  1181      ! gtool4 データ入力
  1182      ! Gtool4 data input
  1183      !
  1184      use gtool_history, only: HistoryGet, HistoryGetPointer
  1185  
  1186      ! 文字列操作
  1187      ! Character handling
  1188      !
  1189      use dc_string, only: toChar
  1190  
  1191      ! 暦と日時の取り扱い
  1192      ! Calendar and Date handler
  1193      !
  1194      use dc_calendar, only: &
  1195        & DC_CAL_DATE,            & ! 日時を表現するデータ型.
  1196                                    ! Data type for date and time
  1197        & DCCalInquire,           &
  1198        & DCCalDateEvalSecOfYear, &
  1199        & DCCalDateCreate,        &
  1200        & DCCalDateDifference
  1201  
  1202      ! 時刻管理
  1203      ! Time control
  1204      !
  1205      use timeset, only: TimeN, InitialDate
  1206  
  1207      ! NetCDF wrapper
  1208      !
  1209      use netcdf_wrapper, only: NWGetAtt, NWInqDimLen
  1210  
  1211  
  1212      ! 宣言文 ; Declaration statements
  1213      !
  1214      implicit none
  1215  
  1216      character(*)          , intent(in   ):: FileName
  1217                                ! ファイル名.
  1218                                ! File name
  1219      character(*)          , intent(in   ):: VarName
  1220                                ! 変数名.
  1221                                ! Variable name
  1222      integer               , intent(in   ):: NDims
  1223                                ! 時間以外の変数の次元.
  1224                                ! Number of dimensions except for time dimension
  1225      type(time_series_data), intent(inout):: TSDataInfo
  1226  
  1227  
  1228      ! 作業変数
  1229      ! Work variables
  1230      !
  1231      real(DP)         :: CurrentTimeInSec
  1232  !!$    real(DP), pointer:: a_time(:)
  1233      integer          :: tindex
  1234      integer          :: t
  1235  
  1236      character(STRING):: VLevelName
  1237  
  1238      character(STRING):: attchar
  1239  
  1240      integer:: hour_in_day, min_in_hour, day_in_year
  1241      integer, pointer:: day_in_month_ptr(:) => null()
  1242      real(DP):: sec_in_min, sec_in_day
  1243  
  1244  
  1245      type(DC_CAL_DATE), save :: DataOriginDate
  1246                                ! データ日時基準
  1247                                ! Origin date of data
  1248      integer  :: DataOriginYr
  1249      integer  :: DataOriginMon
  1250      integer  :: DataOriginDay
  1251      integer  :: DataOriginHr
  1252      integer  :: DataOriginMin
  1253      real(DP) :: DataOriginSec
  1254  
  1255  
  1256      ! 実行文 ; Executable statement
  1257      !
  1258  
  1259      ! 初期化確認
  1260      ! Initialization check
  1261      !
  1262      if ( .not. read_time_series_inited ) then
  1263        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1264      end if
  1265  
  1266  
  1267  !!$    nullify( a_time )
  1268  
  1269  
  1270      call DCCalInquire( &
  1271        & day_in_month_ptr = day_in_month_ptr , & ! (out)
  1272        & hour_in_day      = hour_in_day  , &     ! (out)
  1273        & min_in_hour      = min_in_hour  , &     ! (out)
  1274        & sec_in_min       = sec_in_min )         ! (out)
  1275      day_in_year = sum( day_in_month_ptr )
  1276      deallocate( day_in_month_ptr )
  1277      sec_in_day  = hour_in_day * min_in_hour * sec_in_min
  1278  
  1279  
  1280      TSDataInfo % FileName = FileName
  1281      TSDataInfo % VarName  = VarName
  1282      TSDataInfo % NDims    = NDims
  1283  
  1284  
  1285      if ( TSDataInfo % NDims == 0 ) then
  1286        TSDataInfo % NVLevels = 1
  1287      else if ( TSDataInfo % NDims == 2 ) then
  1288        TSDataInfo % NVLevels = 1
  1289      else
  1290        VLevelName = "plev"
  1291  
  1292        call HistoryGetPointer(               &
  1293          & TSDataInfo%FileName,              &
  1294          & VLevelName,                       &
  1295          & TSDataInfo % z_VLevels,           &
  1296          & flag_mpi_split = flag_mpi_split   &
  1297          & )
  1298        TSDataInfo % NVLevels = size( TSDataInfo % z_Vlevels )
  1299      end if
  1300  
  1301  
  1302      call NWInqDimLen( &
  1303        & TSDataInfo%FileName,    & ! (in )
  1304        & 'time', & ! (in )
  1305        & TSDataInfo%tmax      & ! (out)
  1306        & )
  1307  
  1308  
  1309      if ( ( FlagYearCyclic ) .or. ( TSDataInfo % tmax < 2 ) ) then
  1310        ! case in which the data are cyclic
  1311  
  1312        TSDataInfo % TimeFromOriginToInitialDate = 0.0_DP
  1313  
  1314      else
  1315        ! case in which the data are not cyclic
  1316  
  1317        call NWGetAtt( TSDataInfo%FileName, 'time', 'units', AttChar )
  1318  
  1319        call InterpretTimeUnitString( &
  1320          & TSDataInfo%FileName,                        & ! (in)
  1321          & AttChar,                                    & ! (in)
  1322          & DataOriginYr, DataOriginMon, DataOriginDay, & ! (in)
  1323          & DataOriginHr, DataOriginMin, DataOriginSec  & ! (out)
  1324          & )
  1325  
  1326        ! Check time from data origin to start time of integration
  1327        !
  1328        call DCCalDateCreate(            &
  1329          & year       = DataOriginYr,   & ! (in)
  1330          & month      = DataOriginMon,  & ! (in)
  1331          & day        = DataOriginDay,  & ! (in)
  1332          & hour       = DataOriginHr  , & ! (in)
  1333          & min        = DataOriginMin,  & ! (in)
  1334          & sec        = DataOriginSec,  & ! (in)
  1335          & date       = DataOriginDate  & ! (out)
  1336          & )
  1337        TSDataInfo % TimeFromOriginToInitialDate = &
  1338          & DCCalDateDifference( DataOriginDate, InitialDate )
  1339  
  1340        call MessageNotify( 'M', module_name, 'Origin time for a variable %c is %d/%d/%d %d:%d:%f.', &
  1341          & c1 = trim(TSDataInfo%VarName), &
  1342          & i = (/ DataOriginYr, DataOriginMon, DataOriginDay, DataOriginHr, DataOriginMin /), &
  1343          & d = (/ DataOriginSec /) )
  1344        call MessageNotify( 'M', module_name, 'Time from origin to initial date is %f s.', &
  1345          & d = (/ TSDataInfo % TimeFromOriginToInitialDate /) )
  1346  
  1347      end if
  1348  
  1349  
  1350  
  1351      !-----
  1352  !!$    call HistoryGetPointer(               &
  1353  !!$      & TSDataInfo%FileName,              &
  1354  !!$      & 'time',                           &
  1355  !!$      & a_time,                           &
  1356  !!$      & flag_mpi_split = flag_mpi_split   &
  1357  !!$      & )
  1358  !!$    TSDataInfo % tmax = size( a_time )
  1359  !!$
  1360  !!$    call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )
  1361  !!$    if ( ( attchar(1:3) == 'day' ) .or. &
  1362  !!$      &  ( attchar(1:3) == 'DAY' ) .or. &
  1363  !!$      &  ( attchar(1:3) == 'Day' ) ) then
  1364  !!$      a_time = a_time * DAY_SECONDS
  1365  !!$    else
  1366  !!$      call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', c1 = trim(attchar) )
  1367  !!$    end if
  1368      !-----
  1369  
  1370  
  1371      if ( TSDataInfo % tmax >= 2 ) then
  1372  
  1373        if ( FlagYearCyclic ) then
  1374          CurrentTimeInSec = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )
  1375        else
  1376          CurrentTimeInSec = TimeN + TSDataInfo%TimeFromOriginToInitialDate
  1377        end if
  1378  
  1379        !-----
  1380  !!$      allocate( TSDataInfo % a_time(0:TSDataInfo%tmax+1) )
  1381  !!$      TSDataInfo % a_time(0) = - ( YEAR_DAYS * DAY_SECONDS - a_time(TSDataInfo%tmax) )
  1382  !!$      do t = 1, TSDataInfo%tmax
  1383  !!$        TSDataInfo % a_time(t) = a_time(t)
  1384  !!$      end do
  1385  !!$      TSDataInfo % a_time(TSDataInfo%tmax+1) = YEAR_DAYS * DAY_SECONDS + a_time(1)
  1386  !!$      deallocate( a_time )
  1387        !-----
  1388  
  1389  
  1390        allocate( TSDataInfo % a_time(0:TSDataInfo%tmax+1) )
  1391        call HistoryGet(               &
  1392          & TSDataInfo%FileName,              &
  1393          & 'time',                           &
  1394          & TSDataInfo%a_time(1:TSDataInfo%tmax),                           &
  1395          & flag_mpi_split = flag_mpi_split   &
  1396          & )
  1397        call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )
  1398  
  1399        if ( ( attchar(1:3) == 'day' ) .or. &
  1400          &  ( attchar(1:3) == 'DAY' ) .or. &
  1401          &  ( attchar(1:3) == 'Day' ) ) then
  1402  
  1403          ! convert unit of time from day to sec
  1404          TSDataInfo%a_time(1:TSDataInfo%tmax) = &
  1405            & TSDataInfo%a_time(1:TSDataInfo%tmax) * sec_in_day
  1406        else
  1407          call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', &
  1408            & c1 = trim(attchar) )
  1409        end if
  1410  
  1411        ! set time in hallo regions
  1412        if ( FlagYearCyclic ) then
  1413          TSDataInfo % a_time(0                ) = &
  1414            & - ( day_in_year * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
  1415          TSDataInfo % a_time(TSDataInfo%tmax+1) = &
  1416            &     day_in_year * sec_in_day + TSDataInfo % a_time(1              )
  1417        else
  1418          TSDataInfo % a_time(0                ) = &
  1419            & TSDataInfo % a_time(1                ) - 1.0_DP
  1420  
  1421          TSDataInfo % a_time(TSDataInfo%tmax+1) = &
  1422            & TSDataInfo % a_time(TSDataInfo%tmax  ) + 1.0_DP
  1423        end if
  1424  
  1425  
  1426        allocate( TSDataInfo % a_tindex(1:2) )
  1427        allocate( TSDataInfo % xyza_SavedData(0:imax-1,1:jmax,1:TSDataInfo%NVLevels,1:2) )
  1428  
  1429        TSDataInfo % a_tindex(1) = 0
  1430        TSDataInfo % a_tindex(2) = 1
  1431        do t = 1, TSDataInfo%tmax
  1432          if ( TSDataInfo % a_time(t) <= CurrentTimeInSec ) then
  1433            TSDataInfo % a_tindex(1) = t
  1434            TSDataInfo % a_tindex(2) = t+1
  1435          end if
  1436        end do
  1437  
  1438        ! set time index
  1439        if ( FlagYearCyclic ) then
  1440          tindex = TSDataInfo % a_tindex(1)
  1441          if ( tindex == 0 ) then
  1442            tindex = TSDataInfo % tmax
  1443          else if ( tindex == TSDataInfo % tmax + 1 ) then
  1444            tindex = 1
  1445          else
  1446            tindex = tindex
  1447          end if
  1448        else
  1449          tindex = TSDataInfo % a_tindex(1)
  1450          tindex = min( max( tindex, 1 ), TSDataInfo % tmax )
  1451        end if
  1452  
  1453  
  1454        if ( TSDataInfo % NDims == 0 ) then
  1455          call HistoryGet(                                       &
  1456            & TSDataInfo%FileName,                               &
  1457            & TSDataInfo%VarName,                                &
  1458            & TSDataInfo%xyza_SavedData(0,1,1,1),                &
  1459            & range = 'time=^'//toChar(tindex),                  &
  1460            & flag_mpi_split = flag_mpi_split                    &
  1461            & )
  1462        else if ( TSDataInfo % NDims == 2 ) then
  1463          call HistoryGet(                                       &
  1464            & TSDataInfo%FileName,                               &
  1465            & TSDataInfo%VarName,                                &
  1466            & TSDataInfo%xyza_SavedData(:,:,1,1),                &
  1467            & range = 'time=^'//toChar(tindex),                  &
  1468            & flag_mpi_split = flag_mpi_split                    &
  1469            & )
  1470        else
  1471          call HistoryGet(                                       &
  1472            & TSDataInfo%FileName,                               &
  1473            & TSDataInfo%VarName,                                &
  1474            & TSDataInfo%xyza_SavedData(:,:,:,1),                &
  1475            & range = 'time=^'//toChar(tindex),                  &
  1476            & flag_mpi_split = flag_mpi_split                    &
  1477            & )
  1478        end if
  1479  
  1480        ! set time index
  1481        if ( FlagYearCyclic ) then
  1482          tindex = TSDataInfo % a_tindex(2)
  1483          if ( tindex == 0 ) then
  1484            tindex = TSDataInfo % tmax
  1485          else if ( tindex == TSDataInfo % tmax + 1 ) then
  1486            tindex = 1
  1487          else
  1488            tindex = tindex
  1489          end if
  1490        else
  1491          tindex = TSDataInfo % a_tindex(2)
  1492          tindex = min( max( tindex, 1 ), TSDataInfo % tmax )
  1493        end if
  1494  
  1495        if ( TSDataInfo % NDims == 0 ) then
  1496          call HistoryGet(                                       &
  1497            & TSDataInfo%FileName,                               &
  1498            & TSDataInfo%VarName,                                &
  1499            & TSDataInfo%xyza_SavedData(0,1,1,2),                &
  1500            & range = 'time=^'//toChar(tindex),                  &
  1501            & flag_mpi_split = flag_mpi_split                    &
  1502            & )
  1503        else if ( TSDataInfo % NDims == 2 ) then
  1504          call HistoryGet(                                       &
  1505            & TSDataInfo%FileName,                               &
  1506            & TSDataInfo%VarName,                                &
  1507            & TSDataInfo%xyza_SavedData(:,:,1,2),                &
  1508            & range = 'time=^'//toChar(tindex),                  &
  1509            & flag_mpi_split = flag_mpi_split                    &
  1510            & )
  1511        else
  1512          call HistoryGet(                                       &
  1513            & TSDataInfo%FileName,                               &
  1514            & TSDataInfo%VarName,                                &
  1515            & TSDataInfo%xyza_SavedData(:,:,:,2),                &
  1516            & range = 'time=^'//toChar(tindex),                  &
  1517            & flag_mpi_split = flag_mpi_split                    &
  1518            & )
  1519        end if
  1520  
  1521        allocate( TSDataInfo%xyz_VarTimeInterpolated(0:imax-1, 1:jmax, 1:TSDataInfo%NVLevels) )
  1522  
  1523      else
  1524  
  1525        !-----
  1526  !!$      allocate( TSDataInfo % a_time(TSDataInfo%tmax) )
  1527  !!$      do t = 1, TSDataInfo%tmax
  1528  !!$        TSDataInfo % a_time(t) = a_time(t)
  1529  !!$      end do
  1530        !-----
  1531  
  1532  
  1533        allocate( TSDataInfo % a_time(TSDataInfo%tmax) )
  1534        call HistoryGet(               &
  1535          & TSDataInfo%FileName,              &
  1536          & 'time',                           &
  1537          & TSDataInfo%a_time(1:TSDataInfo%tmax),                           &
  1538          & flag_mpi_split = flag_mpi_split   &
  1539          & )
  1540        call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )
  1541        if ( ( attchar(1:3) == 'day' ) .or. &
  1542          &  ( attchar(1:3) == 'DAY' ) .or. &
  1543          &  ( attchar(1:3) == 'Day' ) ) then
  1544          ! convert unit of time from day to sec
  1545          TSDataInfo%a_time(1:TSDataInfo%tmax) = &
  1546            & TSDataInfo%a_time(1:TSDataInfo%tmax) * sec_in_day
  1547        else
  1548          call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', &
  1549            & c1 = trim(attchar) )
  1550        end if
  1551  
  1552        allocate( TSDataInfo % a_tindex(1:1) )
  1553        allocate( TSDataInfo % xyza_SavedData(0:imax-1,1:jmax,1:TSDataInfo%NVLevels,1:1) )
  1554  
  1555        TSDataInfo % a_tindex(1) = 1
  1556  
  1557        if ( TSDataInfo % NDims == 0 ) then
  1558          call HistoryGet(                                       &
  1559            & TSDataInfo%FileName,                               &
  1560            & TSDataInfo%VarName,                                &
  1561            & TSDataInfo%xyza_SavedData(0,1,1,1),                &
  1562            & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)),  &
  1563            & flag_mpi_split = flag_mpi_split                    &
  1564            & )
  1565        else if ( TSDataInfo % NDims == 2 ) then
  1566          call HistoryGet(                                       &
  1567            & TSDataInfo%FileName,                               &
  1568            & TSDataInfo%VarName,                                &
  1569            & TSDataInfo%xyza_SavedData(:,:,1,1),                &
  1570            & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)),  &
  1571            & flag_mpi_split = flag_mpi_split                    &
  1572            & )
  1573        else
  1574          call HistoryGet(                                       &
  1575            & TSDataInfo%FileName,                               &
  1576            & TSDataInfo%VarName,                                &
  1577            & TSDataInfo%xyza_SavedData(:,:,:,1),                &
  1578            & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)),  &
  1579            & flag_mpi_split = flag_mpi_split                    &
  1580            & )
  1581        end if
  1582  
  1583      end if
  1584  
  1585  
  1586    end subroutine StructureInit
  1587  
  1588    !--------------------------------------------------------------------------------------
  1589  
  1590    subroutine ReadTimeSeriesInit
  1591  
  1592      ! ファイル入出力補助
  1593      ! File I/O support
  1594      !
  1595      use dc_iounit, only: FileOpen
  1596  
  1597      ! NAMELIST ファイル入力に関するユーティリティ
  1598      ! Utilities for NAMELIST file input
  1599      !
  1600      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1601  
  1602      ! 時刻管理
  1603      ! Time control
  1604      !
  1605      use timeset, only: InitialDate
  1606  
  1607      ! 宣言文 ; Declaration statements
  1608      !
  1609  
  1610      logical :: flag_mpi_init
  1611  
  1612      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1613                                ! Unit number for NAMELIST file open
  1614      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1615                                ! IOSTAT of NAMELIST read
  1616  
  1617      ! NAMELIST 変数群
  1618      ! NAMELIST group name
  1619      !
  1620      namelist /read_time_series_nml/ &
  1621        & FlagYearCyclic
  1622            !
  1623            ! デフォルト値については初期化手続 "read_time_series#ReadTimeSeriesInit"
  1624            ! のソースコードを参照のこと.
  1625            !
  1626            ! Refer to source codes in the initialization procedure
  1627            ! "read_time_series#ReadTimeSeriesInit" for the default values.
  1628            !
  1629  
  1630      if ( read_time_series_inited ) return
  1631  
  1632  
  1633      ! デフォルト値の設定
  1634      ! Default values settings
  1635      !
  1636  
  1637      FlagYearCyclic = .true.
  1638  
  1639      ! NAMELIST の読み込み
  1640      ! NAMELIST is input
  1641      !
  1642      if ( trim(namelist_filename) /= '' ) then
  1643        call FileOpen( unit_nml, &          ! (out)
  1644          & namelist_filename, mode = 'r' ) ! (in)
  1645  
  1646        rewind( unit_nml )
  1647        read( unit_nml,                     & ! (in)
  1648          & nml = read_time_series_nml,       & ! (out)
  1649          & iostat = iostat_nml )             ! (out)
  1650        close( unit_nml )
  1651  
  1652        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1653      end if
  1654  
  1655  
  1656      ! Initialzation
  1657      !
  1658      NumMaxStruct = 0
  1659  
  1660  
  1661      ! 印字 ; Print
  1662      !
  1663      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1664      call MessageNotify( 'M', module_name, 'FlagYearCyclic = %b', l = (/ FlagYearCyclic /) )
  1665      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1666  
  1667  
  1668      read_time_series_inited = .true.
  1669  
  1670  
  1671    end subroutine ReadTimeSeriesInit
  1672  
  1673    !--------------------------------------------------------------------------------------
  1674  
  1675  end module read_time_series
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: read_time_series.f90
PROGRAM NAME: read_time_series
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 時系列データの読み込み
     2:             !
     3:             != Reading time series
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Satoshi NODA
     6:             ! Version::   $Id: read_time_series.f90,v 1.19 2015/01/29 12:02:29 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module read_time_series
    13:               !
    14:               != 時系列データの読み込み
    15:               !
    16:               != Reading time series
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 海表面温度, O3 量などの時系列データを NetCDF ファイルから読み込む. 
    21:               !
    22:               ! Reading time series data, such as sea surface temperature, O3, and so on, from 
    23:               ! NetCDF file. 
    24:               !
    25:               !== Procedures List
    26:             !!$  ! GroundFileGet    :: 地表面データファイルの入力
    27:             !!$  !--
    28:             !!$  ! GroundFileOpen   :: 地表面データファイルのオープン
    29:             !!$  ! GroundFileOutput :: 地表面データファイルへのデータ出力
    30:             !!$  ! GroundFileClose  :: 地表面データファイルのクローズ
    31:               !++
    32:               ! ------------     :: ------------
    33:             !!$  ! GroundFileGet    :: Input ground data file
    34:             !!$  !--
    35:             !!$  ! GroundFileOpen   :: Open ground data file
    36:             !!$  ! GroundFileOutput :: Data output to ground data file
    37:             !!$  ! GroundFileClose  :: Close ground data file
    38:               !++
    39:               !
    40:               !== NAMELIST
    41:               !
    42:             !!$  ! NAMELIST#ground_file_io_nml
    43:               !
    44:             
    45:               ! モジュール引用 ; USE statements
    46:               !
    47:             
    48:               ! 種別型パラメタ
    49:               ! Kind type parameter
    50:               !
    51:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    52:                 &                 STRING, &  ! 文字列.       Strings. 
    53:                 &                 TOKEN      ! キーワード.   Keywords. 
    54:             
    55:               ! メッセージ出力
    56:               ! Message output
    57:               !
    58:               use dc_message, only: MessageNotify
    59:             
    60:               ! 格子点設定
    61:               ! Grid points settings
    62:               !
    63:               use gridset, only: imax, & ! 経度格子点数. 
    64:                                          ! Number of grid points in longitude
    65:                 &                jmax, & ! 緯度格子点数. 
    66:                                          ! Number of grid points in latitude
    67:                 &                kmax    ! 鉛直層数. 
    68:                                          ! Number of vertical level
    69:             
    70:               ! 宣言文 ; Declaration statements
    71:               !
    72:               implicit none
    73:               private
    74:             
    75:               ! 公開手続き
    76:               ! Public procedure
    77:               !
    78:               public:: SetValuesFromTimeSeriesWrapper
    79:             !!$  public:: SetValuesFromTimeSeries
    80:               public:: ReadTimeSeriesInit
    81:             
    82:               ! 公開変数
    83:               ! Public variables
    84:               !
    85:               logical, save :: read_time_series_inited = .false.
    86:                                           ! 初期設定フラグ. 
    87:                                           ! Initialization flag
    88:             
    89:             
    90:               ! 非公開変数
    91:               ! Private variables
    92:               !
    93:             
    94:               type time_series_data
    95:                 character(STRING):: Keyword
    96:                                           ! 
    97:                                           ! Keyword
    98:                 character(STRING):: FileName
    99:                                           ! ファイル名. 
   100:                                           ! File name
   101:                 character(STRING):: VarName
   102:                                           ! 変数名. 
   103:                                           ! Variable name
   104:                 integer          :: NDims
   105:                 integer          :: tmax
   106:                 integer          :: NVLevels
   107:                 real(DP), pointer:: z_VLevels(:)
   108:                 real(DP), pointer:: a_time(:)
   109:                 integer , pointer:: a_tindex(:)
   110:                 real(DP), pointer:: xyza_SavedData(:,:,:,:)
   111:                 real(DP), pointer:: xyz_VarTimeInterpolated(:,:,:)
   112:                 real(DP)         :: TimeFromOriginToInitialDate
   113:               end type time_series_data
   114:             
   115:               integer, parameter :: NumMaxStructArr = 25
   116:               integer, save      :: NumMaxStruct
   117:             
   118:               type(time_series_data), save :: a_TSDataInfo( NumMaxStructArr )
   119:             
   120:               logical, save :: FlagYearCyclic = .true.
   121:             
   122:               logical, save :: flag_mpi_split = .true.
   123:             
   124:             
   125:             
   126:               character(*), parameter:: module_name = 'read_time_series_from_file'
   127:                                           ! モジュールの名称. 
   128:                                           ! Module name
   129:               character(*), parameter:: version = &
   130:                 & '$Name:  $' // &
   131:                 & '$Id: read_time_series.f90,v 1.19 2015/01/29 12:02:29 yot Exp $'
   132:                                           ! モジュールのバージョン
   133:                                           ! Module version
   134:             
   135:               ! INTERFACE 文 ; INTERFACE statements
   136:               !
   137:               interface SetValuesFromTimeSeriesWrapper
   138:                 module procedure SetValFromTimeSeriesWrapper0D, SetValFromTimeSeriesWrapper2D, SetValFromTimeSeriesWrapper3D
   139:               end interface
   140:             
   141:             contains
   142:             
   143:               !--------------------------------------------------------------------------------------
   144:             
   145:               subroutine SetValFromTimeSeriesWrapper0D( &
   146:                 & Keyword,           &
   147:                 & FileName, VarName, &
   148:                 & Var                &               ! (inout)
   149:                 & )
   150:             
   151:             
   152:                 ! 宣言文 ; Declaration statements
   153:                 !
   154:                 implicit none
   155:             
   156:                 character(*), intent(in   ):: Keyword
   157:                 character(*), intent(in   ):: FileName
   158:                                           ! ファイル名. 
   159:                                           ! File name
   160:                 character(*), intent(in   ):: VarName
   161:                                           ! 変数名. 
   162:                                           ! Variable name
   163:                 real(DP)    , intent(inout):: Var
   164:                                           ! 地表面温度. 
   165:                                           ! Surface temperature
   166:             
   167:             
   168:                 integer :: Index
   169:             
   170:             
   171:                 ! 初期化確認
   172:                 ! Initialization check
   173:                 !
   174:                 if ( .not. read_time_series_inited ) then
   175:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   176:                 end if
   177:             
   178:             
   179:                 call SetValFromTimeSeriesFindIndex( &
   180:                   & Keyword, & ! (in)
   181:                   & Index    & ! (out)
   182:                   & )
   183:                 call SetValuesFromTimeSeries( &
   184:                   & a_TSDataInfo( Index ),    &
   185:                   & FileName, VarName,        &
   186:                   & Var = Var                 & ! (inout)
   187:                   & )
   188:             
   189:             
   190:               end subroutine SetValFromTimeSeriesWrapper0D
   191:             
   192:               !--------------------------------------------------------------------------------------
   193:             
   194:               subroutine SetValFromTimeSeriesWrapper2D( &
   195:                 & Keyword,           &
   196:                 & FileName, VarName, &
   197:                 & xy_Var             &               ! (inout)
   198:                 & )
   199:             
   200:             
   201:                 ! 宣言文 ; Declaration statements
   202:                 !
   203:                 implicit none
   204:             
   205:                 character(*), intent(in   ):: Keyword
   206:                 character(*), intent(in   ):: FileName
   207:                                           ! ファイル名. 
   208:                                           ! File name
   209:                 character(*), intent(in   ):: VarName
   210:                                           ! 変数名. 
   211:                                           ! Variable name
   212:                 real(DP)    , intent(inout):: xy_Var(0:imax-1, 1:jmax)
   213:                                           ! 地表面温度. 
   214:                                           ! Surface temperature
   215:             
   216:             
   217:                 integer :: Index
   218:             
   219:             
   220:                 ! 初期化確認
   221:                 ! Initialization check
   222:                 !
   223:                 if ( .not. read_time_series_inited ) then
   224:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   225:                 end if
   226:             
   227:             
   228:                 call SetValFromTimeSeriesFindIndex( &
   229:                   & Keyword, & ! (in)
   230:                   & Index    & ! (out)
   231:                   & )
   232:                 call SetValuesFromTimeSeries( &
   233:                   & a_TSDataInfo( Index ),    &
   234:                   & FileName, VarName,        &
   235:                   & xy_Var = xy_Var           & ! (inout)
   236:                   & )
   237:             
   238:             
   239:               end subroutine SetValFromTimeSeriesWrapper2D
   240:             
   241:               !--------------------------------------------------------------------------------------
   242:             
   243:               subroutine SetValFromTimeSeriesWrapper3D( &
   244:                 & Keyword,                              & ! (in)
   245:                 & FileName, VarName,                    & ! (in)
   246:                 & xyz_Press,                            & ! (in)
   247:                 & xyz_Var,                              & ! (inout)
   248:                 & FlagLogVLev, FlagLog, FlagPositiveDef & ! (in)
   249:                 & )
   250:             
   251:             
   252:                 ! 宣言文 ; Declaration statements
   253:                 !
   254:                 implicit none
   255:             
   256:                 character(*), intent(in   ):: Keyword
   257:                 character(*), intent(in   ):: FileName
   258:                                           ! ファイル名. 
   259:                                           ! File name
   260:                 character(*), intent(in   ):: VarName
   261:                                           ! 変数名. 
   262:                                           ! Variable name
   263:                 real(DP)    , intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   264:                                           ! 地表面温度. 
   265:                                           ! Surface temperature
   266:                 real(DP)    , intent(inout):: xyz_Var(0:imax-1, 1:jmax, 1:kmax)
   267:                                           ! 地表面温度. 
   268:                                           ! Surface temperature
   269:                 logical     , intent(in   ):: FlagLogVLev
   270:                 logical     , intent(in   ):: FlagLog
   271:                 logical     , intent(in   ):: FlagPositiveDef
   272:             
   273:             
   274:                 integer :: Index
   275:             
   276:             
   277:                 ! 初期化確認
   278:                 ! Initialization check
   279:                 !
   280:                 if ( .not. read_time_series_inited ) then
   281:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   282:                 end if
   283:             
   284:             
   285:                 call SetValFromTimeSeriesFindIndex( &
   286:                   & Keyword, & ! (in)
   287:                   & Index    & ! (out)
   288:                   & )
   289:                 call SetValuesFromTimeSeries( &
   290:                   & a_TSDataInfo(Index),      &
   291:                   & FileName, VarName,        &
   292:                   & xyz_Press = xyz_Press,    & ! (in)
   293:                   & xyz_Var = xyz_Var,        & ! (inout)
   294:                   & FlagLogVLev     = FlagLogVLev,     & ! (in ) optional
   295:                   & FlagLog         = FlagLog,         & ! (in ) optional
   296:                   & FlagPositiveDef = FlagPositiveDef  & ! (in ) optional
   297:                   & )
   298:             
   299:             
   300:             
   301:               end subroutine SetValFromTimeSeriesWrapper3D
   302:             
   303:               !--------------------------------------------------------------------------------------
   304:             
   305:               subroutine SetValFromTimeSeriesFindIndex( &
   306:                 & Keyword, & ! (in)
   307:                 & Index    & ! (out)
   308:                 & )
   309:             
   310:             
   311:                 ! 宣言文 ; Declaration statements
   312:                 !
   313:                 implicit none
   314:             
   315:                 character(*), intent(in ):: Keyword
   316:                                           ! 
   317:                                           ! Keyword
   318:                 integer     , intent(out):: Index
   319:                                           ! 
   320:                                           ! Index
   321:             
   322:                 integer :: l
   323:             
   324:             
   325:                 ! 初期化確認
   326:                 ! Initialization check
   327:                 !
   328:                 if ( .not. read_time_series_inited ) then
   329:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   330:                 end if
   331:             
   332:             
   333:                 ! Search index of a_TSDataInfo with Keyword
   334:             
   335:                 Index = 0
   336:             
   337: +------>        search_index : do l = 1, NumMaxStruct
   338: |                 if ( a_TSDataInfo( l ) % Keyword == Keyword ) then
   339: |                   Index = l
   340: |                   exit search_index
   341: |                 end if
   342: +------         end do search_index
   343:             
   344:                 ! If an element of a_TSDataInfo with Keyword cannot be found, a new 
   345:                 ! element will be used. 
   346:                 if ( Index == 0 ) then
   347:                   NumMaxStruct = NumMaxStruct + 1
   348:                   Index        = NumMaxStruct
   349:                   a_TSDataInfo( Index ) % Keyword = Keyword
   350:                 end if
   351:             
   352:             
   353:                 if ( Index > NumMaxStructArr ) then
   354:                   call MessageNotify( 'E', module_name, 'Index is greater than NumMaxStructArr.' )
   355:                 end if
   356:             
   357:             
   358:               end subroutine SetValFromTimeSeriesFindIndex
   359:             
   360:               !--------------------------------------------------------------------------------------
   361:             
   362:               subroutine SetValuesFromTimeSeries(          &
   363:                 & TSDataInfo,                              &
   364:                 & FileName, VarName,                       &
   365:                 & xyz_Press,                               & ! (in   ) optional
   366:                 & Var,                                     & ! (inout) optional
   367:                 & xy_Var,                                  & ! (inout) optional
   368:                 & xyz_Var,                                 & ! (inout) optional
   369:                 & FlagLogVLev, FlagLog, FlagPositiveDef    & ! (in   ) optional
   370:                 & )
   371:                 !
   372:                 ! 地表面の諸々のデータを設定します. 
   373:                 ! xy_SurfTemp 以外は一回目に呼ばれた時のみ設定されます. 
   374:                 !
   375:                 ! Get various data on ground. 
   376:                 ! Arguments excluding "xy_SurfTemp" are configured at first only. 
   377:                 !
   378:             
   379:                 ! モジュール引用 ; USE statements
   380:                 !
   381:             
   382:                 ! gtool4 データ入力
   383:                 ! Gtool4 data input
   384:                 !
   385:                 use gtool_history, only: HistoryGet
   386:             
   387:                 ! 文字列操作
   388:                 ! Character handling
   389:                 !
   390:                 use dc_string, only: toChar
   391:             
   392:                 ! 日付および時刻の取り扱い
   393:                 ! Date and time handler
   394:                 !
   395:                 use dc_calendar, only: DCCalDateEvalSecOfYear
   396:             
   397:                 ! 時刻管理
   398:                 ! Time control
   399:                 !
   400:                 use timeset, only: TimeN, InitialDate
   401:             
   402:                 ! 宣言文 ; Declaration statements
   403:                 !
   404:                 implicit none
   405:             
   406:                 type(time_series_data), intent(inout):: TSDataInfo
   407:                 character(*)          , intent(in   ):: FileName
   408:                                           ! ファイル名. 
   409:                                           ! File name
   410:                 character(*)          , intent(in   ):: VarName
   411:                                           ! 変数名. 
   412:                                           ! Variable name
   413:                 real(DP)    , optional, intent(in   ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   414:                                           ! 3 次元配列. 
   415:                                           ! 3D array
   416:                 real(DP)    , optional, intent(inout):: Var
   417:                                           ! 2 次元配列. 
   418:                                           ! 2D array
   419:                 real(DP)    , optional, intent(inout):: xy_Var (0:imax-1, 1:jmax)
   420:                                           ! 2 次元配列. 
   421:                                           ! 2D array
   422:                 real(DP)    , optional, intent(inout):: xyz_Var(0:imax-1, 1:jmax, 1:kmax)
   423:                                           ! 3 次元配列. 
   424:                                           ! 3D array
   425:                 logical     , optional, intent(in   ):: FlagLogVLev
   426:                 logical     , optional, intent(in   ):: FlagLog
   427:                 logical     , optional, intent(in   ):: FlagPositiveDef
   428:             
   429:                 ! 作業変数
   430:                 ! Work variables
   431:                 !
   432:                 real(DP):: CurrentTimeInSec
   433:                 integer :: tindex
   434:             
   435:             !!$    real(DP):: xyza_VarInterpolated(0:imax-1, 1:jmax, 1:kmax, 2)
   436:             
   437:                 logical :: FlagReadData
   438:             
   439:                 integer :: t
   440:             
   441:             
   442:                 ! 初期化確認
   443:                 ! Initialization check
   444:                 !
   445:                 if ( .not. read_time_series_inited ) then
   446:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   447:                 end if
   448:             
   449:             
   450:                 if ( ( .not. present( Var ) ) .and. ( .not. present( xy_Var ) ) .and. ( .not. present( xyz_Var ) ) ) then
   451:                   call MessageNotify( 'E', module_name, 'Var or xy_Var or xyz_Var have to be given.' )
   452:                 end if
   453:             
   454:                 if ( ( present( Var ) ) .and. ( present( xy_Var ) ) ) then
   455:                   call MessageNotify( 'E', module_name, 'Both Var and xy_Var are not given.' )
   456:                 end if
   457:             
   458:                 if ( ( present( xy_Var ) ) .and. ( present( xyz_Var ) ) ) then
   459:                   call MessageNotify( 'E', module_name, 'Both xy_Var and xyz_Var are not given.' )
   460:                 end if
   461:             
   462:                 if ( ( present( xyz_Var ) ) .and. ( present( Var ) ) ) then
   463:                   call MessageNotify( 'E', module_name, 'Both xyz_Var and Var are not be given.' )
   464:                 end if
   465:             
   466:                 if ( ( present( xyz_Var ) ) .and. ( .not. present( xyz_Press ) ) ) then
   467:                   call MessageNotify( 'E', module_name, 'xyz_Press has to be given, when xyz_Var is given.' )
   468:                 end if
   469:             
   470:                 ! 実行文 ; Executable statement
   471:                 !
   472:                 if ( .not. associated( TSDataInfo % a_time ) ) then
   473:                   if ( present( Var ) ) then
   474:                     call StructureInit(       &
   475:                       & FileName, VarName, 0, &
   476:                       & TSDataInfo            &
   477:                       & )
   478:                   else if ( present( xy_Var ) ) then
   479:                     call StructureInit(       &
   480:                       & FileName, VarName, 2, &
   481:                       & TSDataInfo            &
   482:                       & )
   483:                   else
   484:                     call StructureInit(       &
   485:                       & FileName, VarName, 3, &
   486:                       & TSDataInfo            &
   487:                       & )
   488:                   end if
   489:                 end if
   490:             
   491:             
   492:                 ! Update values of time paying attention to leap year
   493:                 ! This is not used, because this causes error when FlagYearCyclic = .true..
   494:                 !
   495:             !!$    call UpdateTime(     &
   496:             !!$      & TSDataInfo             & ! (inout)
   497:             !!$      & )
   498:             
   499:             
   500:                 if ( TSDataInfo % tmax >= 2 ) then
   501:             
   502:                   if ( FlagYearCyclic ) then
   503:                     CurrentTimeInSec = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )
   504:                   else
   505:                     CurrentTimeInSec = TimeN + TSDataInfo%TimeFromOriginToInitialDate
   506:                   end if
   507:             
   508:             !!$      write( 6, * ) TSDataInfo%a_time(TSDataInfo%a_tindex(1)), &
   509:             !!$        & SecOfYear, TSDataInfo%a_time(TSDataInfo%a_tindex(2))
   510:             
   511:             
   512:                   ! Check whether the data have to be read or not
   513:                   if ( ( CurrentTimeInSec <  TSDataInfo%a_time(TSDataInfo%a_tindex(1)) ) .or. &
   514:                     &  ( CurrentTimeInSec >= TSDataInfo%a_time(TSDataInfo%a_tindex(2)) ) ) then
   515:                     FlagReadData = .true.
   516:                   else
   517:                     FlagReadData = .false.
   518:                   end if
   519:                   if ( .not. FlagYearCyclic ) then
   520:                     if ( ( CurrentTimeInSec <  TSDataInfo%a_time(1)               ) .or. &
   521:                       &  ( CurrentTimeInSec >= TSDataInfo%a_time(TSDataInfo%tmax) ) ) then
   522:                       FlagReadData = .false.
   523:                       CurrentTimeInSec = max( CurrentTimeInSec, TSDataInfo%a_time(1) )
   524:                       CurrentTimeInSec = min( CurrentTimeInSec, TSDataInfo%a_time(TSDataInfo%tmax) )
   525:                     end if
   526:                   end if
   527:             
   528:                   if ( FlagReadData ) then
   529:             !!$      if ( ( CurrentTimeInSec <   TSDataInfo%a_time(TSDataInfo%a_tindex(1)) ) .or. &
   530:             !!$        &  ( CurrentTimeInSec >=  TSDataInfo%a_time(TSDataInfo%a_tindex(2)) ) ) then
   531:             
   532:                     TSDataInfo % a_tindex(1) = 0
   533:                     TSDataInfo % a_tindex(2) = 1
   534: V------>            do t = 1, TSDataInfo%tmax
   535: |       A             if ( TSDataInfo % a_time(t) <= CurrentTimeInSec ) then
   536: |                       TSDataInfo % a_tindex(1) = t
   537: |                       TSDataInfo % a_tindex(2) = t+1
   538: |                     end if
   539: V------             end do
   540:             
   541:             !!$        write( 6, * ) '##############################################'
   542:             !!$        write( 6, * ) '##############################################'
   543:             !!$        write( 6, * ) '##############################################'
   544:             !!$        write( 6, * ) '##############################################'
   545:             !!$        write( 6, * ) '##############################################'
   546:             !!$        write( 6, * ) 'in if', TSDataInfo % a_tindex(1), TSDataInfo % a_tindex(2)
   547:             !!$        write( 6, * ) '##############################################'
   548:             !!$        write( 6, * ) '##############################################'
   549:             !!$        write( 6, * ) '##############################################'
   550:             !!$        write( 6, * ) '##############################################'
   551:             !!$        write( 6, * ) '##############################################'
   552:             
   553:                     ! set time index
   554:                     if ( FlagYearCyclic ) then
   555:                       tindex = TSDataInfo % a_tindex(1)
   556:                       if ( tindex == 0 ) then
   557:                         tindex = TSDataInfo % tmax
   558:                       else if ( tindex == TSDataInfo % tmax + 1 ) then
   559:                         tindex = 1
   560:                       else
   561:                         tindex = tindex
   562:                       end if
   563:                     else
   564:                       tindex = TSDataInfo % a_tindex(1)
   565:                       tindex = min( max( tindex, 1 ), TSDataInfo % tmax )
   566:                     end if
   567:             
   568:             
   569:                     if ( present( Var ) ) then
   570:                       call HistoryGet(                                       &
   571:                         & TSDataInfo%FileName,                               &
   572:                         & TSDataInfo%VarName,                                &
   573:                         & TSDataInfo%xyza_SavedData(0,1,1,1),                &
   574:                         & range = 'time=^'//toChar(tindex),                  &
   575:                         & flag_mpi_split = flag_mpi_split                    &
   576:                         & )
   577:                     else if ( present( xy_Var ) ) then
   578:                       call HistoryGet(                                       &
   579:                         & TSDataInfo%FileName,                               &
   580:                         & TSDataInfo%VarName,                                &
   581:                         & TSDataInfo%xyza_SavedData(:,:,1,1),                &
   582:                         & range = 'time=^'//toChar(tindex),                  &
   583:                         & flag_mpi_split = flag_mpi_split                    &
   584:                         & )
   585:                     else
   586:                       call HistoryGet(                                       &
   587:                         & TSDataInfo%FileName,                               &
   588:                         & TSDataInfo%VarName,                                &
   589:                         & TSDataInfo%xyza_SavedData(:,:,:,1),                &
   590:                         & range = 'time=^'//toChar(tindex),                  &
   591:                         & flag_mpi_split = flag_mpi_split                    &
   592:                         & )
   593:                     end if
   594:             
   595:                     ! set time index
   596:                     if ( FlagYearCyclic ) then
   597:                       tindex = TSDataInfo % a_tindex(2)
   598:                       if ( tindex == 0 ) then
   599:                         tindex = TSDataInfo % tmax
   600:                       else if ( tindex == TSDataInfo % tmax + 1 ) then
   601:                         tindex = 1
   602:                       else
   603:                         tindex = tindex
   604:                       end if
   605:                     else
   606:                       tindex = TSDataInfo % a_tindex(2)
   607:                       tindex = min( max( tindex, 1 ), TSDataInfo % tmax )
   608:                     end if
   609:             
   610:                     if ( present( Var ) ) then
   611:                       call HistoryGet(                                       &
   612:                         & TSDataInfo%FileName,                               &
   613:                         & TSDataInfo%VarName,                                &
   614:                         & TSDataInfo%xyza_SavedData(0,1,1,2),                &
   615:                         & range = 'time=^'//toChar(tindex),                  &
   616:                         & flag_mpi_split = flag_mpi_split                    &
   617:                         & )
   618:                     else if ( present( xy_Var ) ) then
   619:                       call HistoryGet(                                       &
   620:                         & TSDataInfo%FileName,                               &
   621:                         & TSDataInfo%VarName,                                &
   622:                         & TSDataInfo%xyza_SavedData(:,:,1,2),                &
   623:                         & range = 'time=^'//toChar(tindex),                  &
   624:                         & flag_mpi_split = flag_mpi_split                    &
   625:                         & )
   626:                     else
   627:                       call HistoryGet(                                       &
   628:                         & TSDataInfo%FileName,                               &
   629:                         & TSDataInfo%VarName,                                &
   630:                         & TSDataInfo%xyza_SavedData(:,:,:,2),                &
   631:                         & range = 'time=^'//toChar(tindex),                  &
   632:                         & flag_mpi_split = flag_mpi_split                    &
   633:                         & )
   634:                     end if
   635:             
   636:                   end if
   637:             
   638:                   if ( present( Var ) ) then
   639:                     Var =                                                 &
   640:                       &   ( TSDataInfo%xyza_SavedData(0,1,1,2)            &
   641:                       &   - TSDataInfo%xyza_SavedData(0,1,1,1)  )         &
   642:                       & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2))     &
   643:                       &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  )  &
   644:                       & * ( CurrentTimeInSec                              &
   645:                       &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
   646:                       & + TSDataInfo%xyza_SavedData(0,1,1,1)
   647:                   else if ( present( xy_Var ) ) then
   648: +V===== A           xy_Var =                                              &
   649:                       &   ( TSDataInfo%xyza_SavedData(:,:,1,2)            &
   650:                       &   - TSDataInfo%xyza_SavedData(:,:,1,1)  )         &
   651:                       & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2))     &
   652:                       &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  )  &
   653:                       & * ( CurrentTimeInSec                              &
   654:                       &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
   655:                       & + TSDataInfo%xyza_SavedData(:,:,1,1)
   656:                   else
   657: ++V==== A           TSDataInfo%xyz_VarTimeInterpolated =                  &
   658:                       &   ( TSDataInfo%xyza_SavedData(:,:,:,2)            &
   659:                       &   - TSDataInfo%xyza_SavedData(:,:,:,1)  )         &
   660:                       & / ( TSDataInfo%a_time(TSDataInfo%a_tindex(2))     &
   661:                       &   - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  )  &
   662:                       & * ( CurrentTimeInSec                              &
   663:                       &    - TSDataInfo%a_time(TSDataInfo%a_tindex(1))  ) &
   664:                       & + TSDataInfo%xyza_SavedData(:,:,:,1)
   665:             
   666:                     call VerticalInterpolation(                    &
   667:                       & TSDataInfo%NVLevels, TSDataInfo%z_VLevels, & ! (in )
   668:                       & TSDataInfo%xyz_VarTimeInterpolated,        & ! (in )
   669:                       & xyz_Press,                                 & ! (in )
   670:                       & xyz_Var,                                   & ! (out)
   671:                       & FlagLogVLev, FlagLog, FlagPositiveDef      & ! (in ) optional
   672:                       & )
   673:                   end if
   674:             
   675:                 else
   676:             
   677:                   if ( present( Var ) ) then
   678:                     Var = TSDataInfo%xyza_SavedData(0,1,1,1)
   679:                   else if ( present( xy_Var ) ) then
   680: +V===== A           xy_Var = TSDataInfo%xyza_SavedData(:,:,1,1)
   681:                   else
   682: ++V==== A           call VerticalInterpolation(                    &
   683:                       & TSDataInfo%NVLevels, TSDataInfo%z_VLevels, & ! (in )
   684:                       & TSDataInfo%xyza_SavedData(:,:,:,1),        & ! (in )
   685:                       & xyz_Press,                                 & ! (in )
   686:                       & xyz_Var,                                   & ! (out)
   687:                       & FlagLogVLev, FlagLog, FlagPositiveDef      & ! (in ) optional
   688:                       & )
   689:                   end if
   690:             
   691:                 end if
   692:             
   693:             
   694:               end subroutine SetValuesFromTimeSeries
   695:             
   696:               !--------------------------------------------------------------------------------------
   697:             
   698:               subroutine VerticalInterpolation(          &
   699:                 & NVLevels, z_VLevelsIn, xyz_VarIn,      & ! (in )
   700:                 & xyz_VLevelsOut,                        & ! (in )
   701:                 & xyz_VarOut,                            & ! (out)
   702:                 & FlagLogVLev, FlagLog, FlagPositiveDef  & ! (in ) optional
   703:                 & )
   704:             
   705:                 ! モジュール引用 ; USE statements
   706:                 !
   707:             
   708:                 ! 宣言文 ; Declaration statements
   709:                 !
   710:                 implicit none
   711:             
   712:                 integer , intent(in ):: NVLevels
   713:                 real(DP), intent(in ):: z_VLevelsIn(1:NVLevels)
   714:                 real(DP), intent(in ):: xyz_VarIn  (0:imax-1, 1:jmax, 1:NVLevels)
   715:                 real(DP), intent(in ):: xyz_VlevelsOut(0:imax-1, 1:jmax, 1:kmax)
   716:                 real(DP), intent(out):: xyz_VarOut    (0:imax-1, 1:jmax, 1:kmax)
   717:                 logical , intent(in ), optional:: FlagLogVLev
   718:                 logical , intent(in ), optional:: FlagLog
   719:                 logical , intent(in ), optional:: FlagPositiveDef
   720:             
   721:             
   722:                 ! 作業変数
   723:                 ! Work variables
   724:                 !
   725:                 logical:: FlagLogVLevLV
   726:                 logical:: FlagLogLV
   727:                 logical:: FlagPositiveDefLV
   728:                 integer:: i
   729:                 integer:: j
   730:                 integer:: k
   731:                 integer:: kk
   732:                 integer:: xyz_kk(0:imax-1, 1:jmax, 1:kmax)
   733:             
   734:             
   735:                 ! 実行文 ; Executable statement
   736:                 !
   737:             
   738:                 ! 初期化確認
   739:                 ! Initialization check
   740:                 !
   741:                 if ( .not. read_time_series_inited ) then
   742:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   743:                 end if
   744:             
   745:                 ! Check order of vertical levels
   746:                 !
   747:                 if ( z_VlevelsIn(1) < z_VlevelsIn(2) ) then
   748:                   call MessageNotify( 'E', module_name, 'The order of vertical levels is inappropriate.' )
   749:                 end if
   750:             
   751:             
   752:                 ! Flags are checked
   753:                 !
   754:                 if ( present( FlagLogVLev ) ) then
   755:                   FlagLogVLevLV = FlagLogVLev
   756:                 else
   757:                   FlagLogVLevLV = .false.
   758:                 end if
   759:                 if ( present( FlagLog ) ) then
   760:                   FlagLogLV = FlagLog
   761:                 else
   762:                   FlagLogLV = .false.
   763:                 end if
   764:                 if ( present( FlagPositiveDef ) ) then
   765:                   FlagPositiveDefLV = FlagPositiveDef
   766:                 else
   767:                   FlagPositiveDefLV = .false.
   768:                 end if
   769:             
   770:             
   771: W**====         xyz_kk = 1
   772:             
   773: +------>        do kk = 1, NVLevels-1
   774: |           
   775: |W----->          do k = 1, kmax
   776: ||*---->            do j = 1, jmax
   777: |||*--->              do i = 0, imax-1
   778: ||||    A               if ( xyz_VLevelsOut(i,j,k) < z_VLevelsIn(kk) ) then
   779: ||||    A                 xyz_kk(i,j,k) = kk
   780: ||||                    end if
   781: |||*---               end do
   782: ||*----             end do
   783: |W-----           end do
   784: |           
   785: +------         end do
   786:             
   787:             
   788:                 if ( FlagLogVLevLV ) then
   789:             
   790:                   if ( FlagLogLV ) then
   791:                     ! log-log
   792:             
   793: +------>            do k = 1, kmax
   794: |+----->              do j = 1, jmax
   795: ||V---->                do i = 0, imax-1
   796: |||         
   797: |||         !!$          if ( xyz_VLevelsOut(i,j,k) > z_VLevelsIn(1) ) then
   798: |||         !!$            xyz_VarOut(i,j,k) = xyz_VarIn(i,j,1)
   799: |||         !!$
   800: |||         !!$!          else if ( xyz_VLevelsOut(i,j,k) < z_VLevelsIn(NVLevels) ) then
   801: |||         !!$!            call MessageNotify( 'E', module_name, 'Vertical level is out of given range.' )
   802: |||         !!$!!            xyz_VarOut(i,j,k) = 0.0d0
   803: |||         !!$
   804: |||         !!$          else
   805: |||         !!$
   806: |||         !!$            xyz_VarOut(i,j,k) = &
   807: |||         !!$              &   ( xyz_VarIn(i,j,xyz_kk(i,j,k)+1)     - xyz_VarIn(i,j,xyz_kk(i,j,k)) ) &
   808: |||         !!$              & / log( z_VLevelsIn   (xyz_kk(i,j,k)+1) / z_VLevelsIn(xyz_kk(i,j,k))   ) &
   809: |||         !!$              & * log( xyz_VLevelsOut(i,j,k)           / z_VLevelsIn(xyz_kk(i,j,k))   ) &
   810: |||         !!$              & + xyz_VarIn(i,j,xyz_kk(i,j,k))
   811: |||         !!$
   812: |||         !!$          end if
   813: |||         
   814: |||         
   815: |||     A                 xyz_VarOut(i,j,k) = &
   816: |||                         &   log(   ( xyz_VarIn(i,j,xyz_kk(i,j,k)+1) + 1.0d-100 )    &
   817: |||                         &        / ( xyz_VarIn(i,j,xyz_kk(i,j,k)  ) + 1.0d-100 )  ) &
   818: |||                         & / log(   z_VLevelsIn   (xyz_kk(i,j,k)+1)                  &
   819: |||                         &        / z_VLevelsIn(xyz_kk(i,j,k))      )                &
   820: |||                         & * log(   xyz_VLevelsOut(i,j,k)                            &
   821: |||                         &        / z_VLevelsIn(xyz_kk(i,j,k))      )                &
   822: |||                         & + log( xyz_VarIn(i,j,xyz_kk(i,j,k)) + 1.0d-100 )
   823: |||     A                 xyz_VarOut(i,j,k) = exp( xyz_VarOut(i,j,k) )
   824: |||         
   825: ||V----                 end do
   826: |+-----               end do
   827: +------             end do
   828:             
   829:                   else
   830:                     ! log-linear
   831:             
   832: +------>            do k = 1, kmax
   833: |+----->              do j = 1, jmax
   834: ||V---->                do i = 0, imax-1
   835: |||         
   836: |||     A                 xyz_VarOut(i,j,k) =                            &
   837: |||                         &   (   xyz_VarIn(i,j,xyz_kk(i,j,k)+1)       &
   838: |||                         &     - xyz_VarIn(i,j,xyz_kk(i,j,k)  )     ) &
   839: |||                         & / log(   z_VLevelsIn   (xyz_kk(i,j,k)+1)   &
   840: |||                         &        / z_VLevelsIn(xyz_kk(i,j,k))      ) &
   841: |||                         & * log(   xyz_VLevelsOut(i,j,k)             &
   842: |||                         &        / z_VLevelsIn(xyz_kk(i,j,k))      ) &
   843: |||                         & + xyz_VarIn(i,j,xyz_kk(i,j,k))
   844: |||         
   845: ||V----                 end do
   846: |+-----               end do
   847: +------             end do
   848:             
   849:                   end if
   850:             
   851:                 else
   852:             
   853:                   if ( FlagLogLV ) then
   854:                     ! linear-log
   855:             
   856: +------>            do k = 1, kmax
   857: |+----->              do j = 1, jmax
   858: ||V---->                do i = 0, imax-1
   859: |||         
   860: |||     A                 xyz_VarOut(i,j,k) = &
   861: |||                         &   log(   ( xyz_VarIn(i,j,xyz_kk(i,j,k)+1) + 1.0d-100 )    &
   862: |||                         &        / ( xyz_VarIn(i,j,xyz_kk(i,j,k)  ) + 1.0d-100 )  ) &
   863: |||                         & / (   z_VLevelsIn(xyz_kk(i,j,k)+1)                        &
   864: |||                         &     - z_VLevelsIn(xyz_kk(i,j,k)  )    )                   &
   865: |||                         & * (   xyz_VLevelsOut(i,j,k)                               &
   866: |||                         &     - z_VLevelsIn(xyz_kk(i,j,k))      )                   &
   867: |||                         & + log( xyz_VarIn(i,j,xyz_kk(i,j,k)) + 1.0d-100 )
   868: |||     A                 xyz_VarOut(i,j,k) = exp( xyz_VarOut(i,j,k) )
   869: |||         
   870: ||V----                 end do
   871: |+-----               end do
   872: +------             end do
   873:             
   874:                   else
   875:                     ! linear-linear
   876:             
   877: +------>            do k = 1, kmax
   878: |+----->              do j = 1, jmax
   879: ||V---->                do i = 0, imax-1
   880: |||         
   881: |||     A                 xyz_VarOut(i,j,k) = &
   882: |||                         &   (   xyz_VarIn(i,j,xyz_kk(i,j,k)+1)   &
   883: |||                         &     - xyz_VarIn(i,j,xyz_kk(i,j,k)  ) ) &
   884: |||                         & / (   z_VLevelsIn(xyz_kk(i,j,k)+1)     &
   885: |||                         &     - z_VLevelsIn(xyz_kk(i,j,k)  )   ) &
   886: |||                         & * (   xyz_VLevelsOut(i,j,k)            &
   887: |||                         &     - z_VLevelsIn(xyz_kk(i,j,k))     ) &
   888: |||                         & + xyz_VarIn(i,j,xyz_kk(i,j,k))
   889: |||         
   890: ||V----                 end do
   891: |+-----               end do
   892: +------             end do
   893:             
   894:                   end if
   895:             
   896:                 end if
   897:             
   898:             
   899:                 if ( FlagPositiveDefLV ) then
   900:             
   901: W------>          do k = 1, kmax
   902: |*----->            do j = 1, jmax
   903: ||*---->              do i = 0, imax-1
   904: |||         
   905: |||     A               if ( xyz_VarOut(i,j,k) < 0.0_DP ) then
   906: |||     A                 xyz_VarOut(i,j,k) = 0.0_DP
   907: |||                     end if
   908: |||         
   909: ||*----               end do
   910: |*-----             end do
   911: W------           end do
   912:             
   913:                 end if
   914:             
   915:             
   916:             !!$    i = 0
   917:             !!$    j = jmax / 2
   918:             !!$    do k = 1, NVLevels
   919:             !!$      write( 92, * ) z_VLevelsIn(k), xyz_VarIn(i,j,k)
   920:             !!$    end do
   921:             !!$    write( 92, * )
   922:             !!$    call flush( 92 )
   923:             !!$    do k = 1, kmax
   924:             !!$      write( 93, * ) xyz_VLevelsOut(i,j,k), xyz_VarOut(i,j,k)
   925:             !!$    end do
   926:             !!$    write( 93, * )
   927:             !!$    call flush( 93 )
   928:             !!$    stop
   929:             
   930:             
   931:               end subroutine VerticalInterpolation
   932:             
   933:               !--------------------------------------------------------------------------------------
   934:             
   935:               subroutine UpdateTime(     &
   936:                 & TSDataInfo             & ! (inout)
   937:                 & )
   938:             
   939:                 ! モジュール引用 ; USE statements
   940:                 !
   941:             
   942:                 ! 暦と日時の取り扱い
   943:                 ! Calendar and Date handler
   944:                 !
   945:                 use dc_calendar, only: &
   946:                   & DC_CAL_DATE             ! 日時を表現するデータ型.
   947:                                             ! Data type for date and time
   948:             
   949:                 ! 日付および時刻の取り扱い
   950:                 ! Date and time handler
   951:                 !
   952:                 use dc_calendar, only: DCCalInquire, DCCalDateCreate, DCCalDateInquire, DCCalDateChkLeapYear
   953:             
   954:                 ! 時刻管理
   955:                 ! Time control
   956:                 !
   957:                 use timeset, only: TimeN, InitialDate
   958:             
   959:                 ! 宣言文 ; Declaration statements
   960:                 !
   961:                 implicit none
   962:             
   963:                 type(time_series_data), intent(inout):: TSDataInfo
   964:             
   965:             
   966:                 ! 作業変数
   967:                 ! Work variables
   968:                 !
   969:                 integer           :: hour_in_day, min_in_hour, day_in_year
   970:                 integer, pointer  :: day_in_month_ptr(:) => null()
   971:                 real(DP)          :: sec_in_min, sec_in_day
   972:             
   973:                 integer           :: year
   974:                 type(DC_CAL_DATE) :: PreYearDate
   975:             
   976:             
   977:                 ! 実行文 ; Executable statement
   978:                 !
   979:             
   980:                 ! 初期化確認
   981:                 ! Initialization check
   982:                 !
   983:                 if ( .not. read_time_series_inited ) then
   984:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   985:                 end if
   986:             
   987:             
   988:                 if ( TSDataInfo % tmax >= 2 ) then
   989:             
   990:                   call DCCalInquire( &
   991:                     & day_in_month_ptr = day_in_month_ptr , & ! (out)
   992:                     & hour_in_day      = hour_in_day  , &     ! (out)
   993:                     & min_in_hour      = min_in_hour  , &     ! (out)
   994:                     & sec_in_min       = sec_in_min )         ! (out)
   995: V====== A         day_in_year = sum( day_in_month_ptr )
   996:                   deallocate( day_in_month_ptr )
   997:                   sec_in_day  = hour_in_day * min_in_hour * sec_in_min
   998:             
   999:             
  1000:                   ! Set TSDataInfo % a_time(0)
  1001:                   !
  1002:             
  1003:                   call DCCalDateInquire(       &
  1004:                     & year       = year,       & ! (out)
  1005:                     & elapse_sec = TimeN,      & ! (in)
  1006:                     & date       = InitialDate & ! (in)
  1007:                     & )
  1008:                   call DCCalDateCreate(        &
  1009:                     & year       = year - 1,   & ! (in)
  1010:                     & month      = 1,          & ! (in)
  1011:                     & day        = 1,          & ! (in)
  1012:                     & hour       = 0,          & ! (in)
  1013:                     & min        = 0,          & ! (in)
  1014:                     & sec        = 0.0_DP,     & ! (in)
  1015:                     & date       = PreYearDate & ! (out)
  1016:                     & )
  1017:             
  1018:                   if ( DCCalDateChkLeapYear( 0.0_DP, PreYearDate ) ) then
  1019:                     TSDataInfo % a_time(0                ) = &
  1020:                       & - ( ( day_in_year + 1 ) * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
  1021:                   else
  1022:                     TSDataInfo % a_time(0                ) = &
  1023:                       & - (   day_in_year       * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
  1024:                   end if
  1025:             
  1026:             
  1027:                   ! Set TSDataInfo % a_time(TSDataInfo%tmax+1)
  1028:                   !
  1029:             
  1030:                   if ( DCCalDateChkLeapYear( TimeN, InitialDate ) ) then
  1031:                     TSDataInfo % a_time(TSDataInfo%tmax+1) = &
  1032:                       &     ( day_in_year + 1 ) * sec_in_day + TSDataInfo % a_time(1              )
  1033:                   else
  1034:                     TSDataInfo % a_time(TSDataInfo%tmax+1) = &
  1035:                       &       day_in_year       * sec_in_day + TSDataInfo % a_time(1              )
  1036:                   end if
  1037:             
  1038:             
  1039:                 end if
  1040:             
  1041:             
  1042:               end subroutine UpdateTime
  1043:             
  1044:               !--------------------------------------------------------------------------------------
  1045:             
  1046:               subroutine InterpretTimeUnitString( &
  1047:                 & FileName, DateString,       & ! (in)
  1048:                 & Yr, Mon, Day, Hr, Min, Sec  & ! (out)
  1049:                 & )
  1050:             
  1051:                 ! モジュール引用 ; USE statements
  1052:                 !
  1053:             
  1054:                 ! 宣言文 ; Declaration statements
  1055:                 !
  1056:                 implicit none
  1057:             
  1058:                 character(*), intent(in ) :: FileName
  1059:                 character(*), intent(in ) :: DateString
  1060:                 integer     , intent(out) :: Yr
  1061:                 integer     , intent(out) :: Mon
  1062:                 integer     , intent(out) :: Day
  1063:                 integer     , intent(out) :: Hr
  1064:                 integer     , intent(out) :: Min
  1065:                 real(DP)    , intent(out) :: Sec
  1066:             
  1067:             
  1068:                 ! 作業変数
  1069:                 ! Work variables
  1070:                 !
  1071:                 integer :: StrLen
  1072:                 integer :: l
  1073:                 integer :: ll
  1074:             
  1075:                 ! 実行文 ; Executable statement
  1076:                 !
  1077:             
  1078:                 ! 初期化確認
  1079:                 ! Initialization check
  1080:                 !
  1081:                 if ( .not. read_time_series_inited ) then
  1082:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1083:                 end if
  1084:             
  1085:                 StrLen = len_trim( DateString )
  1086:             
  1087:                 ! format of the DateString has to be "... since YYYY/MM/DD HH:MM:SS".
  1088:             
  1089: +------>        search_since : do ll = 1, StrLen-5+1
  1090: |                 if ( DateString(ll:ll+5-1) == "since" ) exit search_since
  1091: +------         end do search_since
  1092:                 if ( ll > StrLen-5+1 ) then
  1093:                   call MessageNotify( 'E', module_name, 'Unable to find "since" in %c.', c1 = trim(FileName) )
  1094:                 end if
  1095:                 !
  1096:                 l = ll + 5
  1097:                 !
  1098:                 if ( DateString(l:l) /= " " ) then
  1099:                   call MessageNotify( 'E', module_name, 'Unable to find a space after "since" in %c.', c1 = trim(FileName) )
  1100:                 end if
  1101:                 !
  1102:                 l = l + 1
  1103:                 !
  1104: +------>        search_yr : do ll = l, StrLen
  1105: |                 if ( DateString(ll:ll) == "-" ) exit search_yr
  1106: +------         end do search_yr
  1107:                 if ( ll > StrLen ) then
  1108:                   call MessageNotify( 'E', module_name, 'Unable to find "-" between year and month in %c.', c1 = trim(FileName) )
  1109:                 end if
  1110:                 read( DateString(l:ll-1), * ) Yr
  1111:                 !
  1112:                 l = ll + 1
  1113:                 !
  1114: +------>        search_mon : do ll = l, StrLen
  1115: |                 if ( DateString(ll:ll) == "-" ) exit search_mon
  1116: +------         end do search_mon
  1117:                 if ( ll > StrLen ) then
  1118:                   call MessageNotify( 'E', module_name, 'Unable to find "-" between month and day in %c.', c1 = trim(FileName) )
  1119:                 end if
  1120:                 read( DateString(l:ll-1), * ) Mon
  1121:                 !
  1122:                 l = ll + 1
  1123:                 !
  1124: +------>        search_day : do ll = l, StrLen
  1125: |                 if ( DateString(ll:ll) == " " ) exit search_day
  1126: +------         end do search_day
  1127:                 if ( ll > StrLen ) then
  1128:                   call MessageNotify( 'E', module_name, 'Unable to find a space between day and hour in %c.', c1 = trim(FileName) )
  1129:                 end if
  1130:                 read( DateString(l:ll-1), * ) Day
  1131:                 !
  1132:                 l = ll
  1133:                 !
  1134:                 if ( DateString(l:l) /= " " ) then
  1135:                   call MessageNotify( 'E', module_name, 'Unable to confirm a space between day and hour in %c.', c1 = trim(FileName) )
  1136:                 end if
  1137:                 !
  1138:                 l = l + 1
  1139:                 !
  1140: +------>        search_hr : do ll = l, StrLen
  1141: |                 if ( DateString(ll:ll) == ":" ) exit search_hr
  1142: +------         end do search_hr
  1143:                 if ( ll > StrLen ) then
  1144:                   call MessageNotify( 'E', module_name, 'Unable to find ":" between hour and minute in %c.', c1 = trim(FileName) )
  1145:                 end if
  1146:                 read( DateString(l:ll-1), * ) Hr
  1147:                 !
  1148:                 l = ll + 1
  1149:                 !
  1150: +------>        search_min : do ll = l, StrLen
  1151: |                 if ( DateString(ll:ll) == ":" ) exit search_min
  1152: +------         end do search_min
  1153:                 if ( ll > StrLen ) then
  1154:                   call MessageNotify( 'E', module_name, 'Unable to find ":" between minute and second in %c.', c1 = trim(FileName) )
  1155:                 end if
  1156:                 read( DateString(l:ll-1), * ) Min
  1157:                 !
  1158:                 l = ll + 1
  1159:                 !
  1160: +------>        search_sec : do ll = l, StrLen
  1161: |                 if ( ( DateString(ll:ll) == " " ) .or. ( DateString(ll:ll) == "." ) ) exit search_sec
  1162: +------         end do search_sec
  1163:             !!$    if ( ll > StrLen ) then
  1164:             !!$      call MessageNotify( 'E', module_name, 'Unable to find end of second in %c.', c1 = trim(FileName) )
  1165:             !!$    end if
  1166:                 read( DateString(l:ll-1), * ) Sec
  1167:             
  1168:             
  1169:               end subroutine InterpretTimeUnitString
  1170:             
  1171:               !--------------------------------------------------------------------------------------
  1172:             
  1173:               subroutine StructureInit(     &
  1174:                 & FileName, VarName, NDims, &
  1175:                 & TSDataInfo                &
  1176:                 & )
  1177:             
  1178:                 ! モジュール引用 ; USE statements
  1179:                 !
  1180:             
  1181:                 ! gtool4 データ入力
  1182:                 ! Gtool4 data input
  1183:                 !
  1184:                 use gtool_history, only: HistoryGet, HistoryGetPointer
  1185:             
  1186:                 ! 文字列操作
  1187:                 ! Character handling
  1188:                 !
  1189:                 use dc_string, only: toChar
  1190:             
  1191:                 ! 暦と日時の取り扱い
  1192:                 ! Calendar and Date handler
  1193:                 !
  1194:                 use dc_calendar, only: &
  1195:                   & DC_CAL_DATE,            & ! 日時を表現するデータ型.
  1196:                                               ! Data type for date and time
  1197:                   & DCCalInquire,           &
  1198:                   & DCCalDateEvalSecOfYear, &
  1199:                   & DCCalDateCreate,        &
  1200:                   & DCCalDateDifference
  1201:             
  1202:                 ! 時刻管理
  1203:                 ! Time control
  1204:                 !
  1205:                 use timeset, only: TimeN, InitialDate
  1206:             
  1207:                 ! NetCDF wrapper
  1208:                 !
  1209:                 use netcdf_wrapper, only: NWGetAtt, NWInqDimLen
  1210:             
  1211:             
  1212:                 ! 宣言文 ; Declaration statements
  1213:                 !
  1214:                 implicit none
  1215:             
  1216:                 character(*)          , intent(in   ):: FileName
  1217:                                           ! ファイル名. 
  1218:                                           ! File name
  1219:                 character(*)          , intent(in   ):: VarName
  1220:                                           ! 変数名. 
  1221:                                           ! Variable name
  1222:                 integer               , intent(in   ):: NDims
  1223:                                           ! 時間以外の変数の次元. 
  1224:                                           ! Number of dimensions except for time dimension
  1225:                 type(time_series_data), intent(inout):: TSDataInfo
  1226:             
  1227:             
  1228:                 ! 作業変数
  1229:                 ! Work variables
  1230:                 !
  1231:                 real(DP)         :: CurrentTimeInSec
  1232:             !!$    real(DP), pointer:: a_time(:)
  1233:                 integer          :: tindex
  1234:                 integer          :: t
  1235:             
  1236:                 character(STRING):: VLevelName
  1237:             
  1238:                 character(STRING):: attchar
  1239:             
  1240:                 integer:: hour_in_day, min_in_hour, day_in_year
  1241:                 integer, pointer:: day_in_month_ptr(:) => null()
  1242:                 real(DP):: sec_in_min, sec_in_day
  1243:             
  1244:             
  1245:                 type(DC_CAL_DATE), save :: DataOriginDate
  1246:                                           ! データ日時基準
  1247:                                           ! Origin date of data
  1248:                 integer  :: DataOriginYr
  1249:                 integer  :: DataOriginMon
  1250:                 integer  :: DataOriginDay
  1251:                 integer  :: DataOriginHr
  1252:                 integer  :: DataOriginMin
  1253:                 real(DP) :: DataOriginSec
  1254:             
  1255:             
  1256:                 ! 実行文 ; Executable statement
  1257:                 !
  1258:             
  1259:                 ! 初期化確認
  1260:                 ! Initialization check
  1261:                 !
  1262:                 if ( .not. read_time_series_inited ) then
  1263:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1264:                 end if
  1265:             
  1266:             
  1267:             !!$    nullify( a_time )
  1268:             
  1269:             
  1270:                 call DCCalInquire( &
  1271:                   & day_in_month_ptr = day_in_month_ptr , & ! (out)
  1272:                   & hour_in_day      = hour_in_day  , &     ! (out)
  1273:                   & min_in_hour      = min_in_hour  , &     ! (out)
  1274:                   & sec_in_min       = sec_in_min )         ! (out)
  1275: V====== A       day_in_year = sum( day_in_month_ptr )
  1276:                 deallocate( day_in_month_ptr )
  1277:                 sec_in_day  = hour_in_day * min_in_hour * sec_in_min
  1278:             
  1279:             
  1280:                 TSDataInfo % FileName = FileName
  1281:                 TSDataInfo % VarName  = VarName
  1282:                 TSDataInfo % NDims    = NDims
  1283:             
  1284:             
  1285:                 if ( TSDataInfo % NDims == 0 ) then
  1286:                   TSDataInfo % NVLevels = 1
  1287:                 else if ( TSDataInfo % NDims == 2 ) then
  1288:                   TSDataInfo % NVLevels = 1
  1289:                 else
  1290:                   VLevelName = "plev"
  1291:             
  1292:                   call HistoryGetPointer(               &
  1293:                     & TSDataInfo%FileName,              &
  1294:                     & VLevelName,                       &
  1295:                     & TSDataInfo % z_VLevels,           &
  1296:                     & flag_mpi_split = flag_mpi_split   &
  1297:                     & )
  1298:                   TSDataInfo % NVLevels = size( TSDataInfo % z_Vlevels )
  1299:                 end if
  1300:             
  1301:             
  1302:                 call NWInqDimLen( &
  1303:                   & TSDataInfo%FileName,    & ! (in )
  1304:                   & 'time', & ! (in )
  1305:                   & TSDataInfo%tmax      & ! (out)
  1306:                   & )
  1307:             
  1308:             
  1309:                 if ( ( FlagYearCyclic ) .or. ( TSDataInfo % tmax < 2 ) ) then
  1310:                   ! case in which the data are cyclic
  1311:             
  1312:                   TSDataInfo % TimeFromOriginToInitialDate = 0.0_DP
  1313:             
  1314:                 else
  1315:                   ! case in which the data are not cyclic
  1316:             
  1317:                   call NWGetAtt( TSDataInfo%FileName, 'time', 'units', AttChar )
  1318:             
  1319:                   call InterpretTimeUnitString( &
  1320:                     & TSDataInfo%FileName,                        & ! (in)
  1321:                     & AttChar,                                    & ! (in)
  1322:                     & DataOriginYr, DataOriginMon, DataOriginDay, & ! (in)
  1323:                     & DataOriginHr, DataOriginMin, DataOriginSec  & ! (out)
  1324:                     & )
  1325:             
  1326:                   ! Check time from data origin to start time of integration
  1327:                   !
  1328:                   call DCCalDateCreate(            &
  1329:                     & year       = DataOriginYr,   & ! (in)
  1330:                     & month      = DataOriginMon,  & ! (in)
  1331:                     & day        = DataOriginDay,  & ! (in)
  1332:                     & hour       = DataOriginHr  , & ! (in)
  1333:                     & min        = DataOriginMin,  & ! (in)
  1334:                     & sec        = DataOriginSec,  & ! (in)
  1335:                     & date       = DataOriginDate  & ! (out)
  1336:                     & )
  1337:                   TSDataInfo % TimeFromOriginToInitialDate = &
  1338:                     & DCCalDateDifference( DataOriginDate, InitialDate )
  1339:             
  1340:                   call MessageNotify( 'M', module_name, 'Origin time for a variable %c is %d/%d/%d %d:%d:%f.', &
  1341:                     & c1 = trim(TSDataInfo%VarName), &
  1342:                     & i = (/ DataOriginYr, DataOriginMon, DataOriginDay, DataOriginHr, DataOriginMin /), &
  1343:                     & d = (/ DataOriginSec /) )
  1344:                   call MessageNotify( 'M', module_name, 'Time from origin to initial date is %f s.', &
  1345:                     & d = (/ TSDataInfo % TimeFromOriginToInitialDate /) )
  1346:             
  1347:                 end if
  1348:             
  1349:             
  1350:             
  1351:                 !-----
  1352:             !!$    call HistoryGetPointer(               &
  1353:             !!$      & TSDataInfo%FileName,              &
  1354:             !!$      & 'time',                           &
  1355:             !!$      & a_time,                           &
  1356:             !!$      & flag_mpi_split = flag_mpi_split   &
  1357:             !!$      & )
  1358:             !!$    TSDataInfo % tmax = size( a_time )
  1359:             !!$
  1360:             !!$    call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )
  1361:             !!$    if ( ( attchar(1:3) == 'day' ) .or. &
  1362:             !!$      &  ( attchar(1:3) == 'DAY' ) .or. &
  1363:             !!$      &  ( attchar(1:3) == 'Day' ) ) then
  1364:             !!$      a_time = a_time * DAY_SECONDS
  1365:             !!$    else
  1366:             !!$      call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', c1 = trim(attchar) )
  1367:             !!$    end if
  1368:                 !-----
  1369:             
  1370:             
  1371:                 if ( TSDataInfo % tmax >= 2 ) then
  1372:             
  1373:                   if ( FlagYearCyclic ) then
  1374:                     CurrentTimeInSec = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )
  1375:                   else
  1376:                     CurrentTimeInSec = TimeN + TSDataInfo%TimeFromOriginToInitialDate
  1377:                   end if
  1378:             
  1379:                   !-----
  1380:             !!$      allocate( TSDataInfo % a_time(0:TSDataInfo%tmax+1) )
  1381:             !!$      TSDataInfo % a_time(0) = - ( YEAR_DAYS * DAY_SECONDS - a_time(TSDataInfo%tmax) )
  1382:             !!$      do t = 1, TSDataInfo%tmax
  1383:             !!$        TSDataInfo % a_time(t) = a_time(t)
  1384:             !!$      end do
  1385:             !!$      TSDataInfo % a_time(TSDataInfo%tmax+1) = YEAR_DAYS * DAY_SECONDS + a_time(1)
  1386:             !!$      deallocate( a_time )
  1387:                   !-----
  1388:             
  1389:             
  1390:                   allocate( TSDataInfo % a_time(0:TSDataInfo%tmax+1) )
  1391:                   call HistoryGet(               &
  1392:                     & TSDataInfo%FileName,              &
  1393:                     & 'time',                           &
  1394:                     & TSDataInfo%a_time(1:TSDataInfo%tmax),                           &
  1395:                     & flag_mpi_split = flag_mpi_split   &
  1396:                     & )
  1397:                   call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )
  1398:             
  1399:                   if ( ( attchar(1:3) == 'day' ) .or. &
  1400:                     &  ( attchar(1:3) == 'DAY' ) .or. &
  1401:                     &  ( attchar(1:3) == 'Day' ) ) then
  1402:             
  1403:                     ! convert unit of time from day to sec
  1404: V====== A           TSDataInfo%a_time(1:TSDataInfo%tmax) = &
  1405:                       & TSDataInfo%a_time(1:TSDataInfo%tmax) * sec_in_day
  1406:                   else
  1407:                     call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', &
  1408:                       & c1 = trim(attchar) )
  1409:                   end if
  1410:             
  1411:                   ! set time in hallo regions
  1412:                   if ( FlagYearCyclic ) then
  1413:                     TSDataInfo % a_time(0                ) = &
  1414:                       & - ( day_in_year * sec_in_day - TSDataInfo % a_time(TSDataInfo%tmax) )
  1415:                     TSDataInfo % a_time(TSDataInfo%tmax+1) = &
  1416:                       &     day_in_year * sec_in_day + TSDataInfo % a_time(1              )
  1417:                   else
  1418:                     TSDataInfo % a_time(0                ) = &
  1419:                       & TSDataInfo % a_time(1                ) - 1.0_DP
  1420:             
  1421:                     TSDataInfo % a_time(TSDataInfo%tmax+1) = &
  1422:                       & TSDataInfo % a_time(TSDataInfo%tmax  ) + 1.0_DP
  1423:                   end if
  1424:             
  1425:             
  1426:                   allocate( TSDataInfo % a_tindex(1:2) )
  1427:                   allocate( TSDataInfo % xyza_SavedData(0:imax-1,1:jmax,1:TSDataInfo%NVLevels,1:2) )
  1428:             
  1429:                   TSDataInfo % a_tindex(1) = 0
  1430:                   TSDataInfo % a_tindex(2) = 1
  1431: V------>          do t = 1, TSDataInfo%tmax
  1432: |       A           if ( TSDataInfo % a_time(t) <= CurrentTimeInSec ) then
  1433: |                     TSDataInfo % a_tindex(1) = t
  1434: |                     TSDataInfo % a_tindex(2) = t+1
  1435: |                   end if
  1436: V------           end do
  1437:             
  1438:                   ! set time index
  1439:                   if ( FlagYearCyclic ) then
  1440:                     tindex = TSDataInfo % a_tindex(1)
  1441:                     if ( tindex == 0 ) then
  1442:                       tindex = TSDataInfo % tmax
  1443:                     else if ( tindex == TSDataInfo % tmax + 1 ) then
  1444:                       tindex = 1
  1445:                     else
  1446:                       tindex = tindex
  1447:                     end if
  1448:                   else
  1449:                     tindex = TSDataInfo % a_tindex(1)
  1450:                     tindex = min( max( tindex, 1 ), TSDataInfo % tmax )
  1451:                   end if
  1452:             
  1453:             
  1454:                   if ( TSDataInfo % NDims == 0 ) then
  1455:                     call HistoryGet(                                       &
  1456:                       & TSDataInfo%FileName,                               &
  1457:                       & TSDataInfo%VarName,                                &
  1458:                       & TSDataInfo%xyza_SavedData(0,1,1,1),                &
  1459:                       & range = 'time=^'//toChar(tindex),                  &
  1460:                       & flag_mpi_split = flag_mpi_split                    &
  1461:                       & )
  1462:                   else if ( TSDataInfo % NDims == 2 ) then
  1463:                     call HistoryGet(                                       &
  1464:                       & TSDataInfo%FileName,                               &
  1465:                       & TSDataInfo%VarName,                                &
  1466:                       & TSDataInfo%xyza_SavedData(:,:,1,1),                &
  1467:                       & range = 'time=^'//toChar(tindex),                  &
  1468:                       & flag_mpi_split = flag_mpi_split                    &
  1469:                       & )
  1470:                   else
  1471:                     call HistoryGet(                                       &
  1472:                       & TSDataInfo%FileName,                               &
  1473:                       & TSDataInfo%VarName,                                &
  1474:                       & TSDataInfo%xyza_SavedData(:,:,:,1),                &
  1475:                       & range = 'time=^'//toChar(tindex),                  &
  1476:                       & flag_mpi_split = flag_mpi_split                    &
  1477:                       & )
  1478:                   end if
  1479:             
  1480:                   ! set time index
  1481:                   if ( FlagYearCyclic ) then
  1482:                     tindex = TSDataInfo % a_tindex(2)
  1483:                     if ( tindex == 0 ) then
  1484:                       tindex = TSDataInfo % tmax
  1485:                     else if ( tindex == TSDataInfo % tmax + 1 ) then
  1486:                       tindex = 1
  1487:                     else
  1488:                       tindex = tindex
  1489:                     end if
  1490:                   else
  1491:                     tindex = TSDataInfo % a_tindex(2)
  1492:                     tindex = min( max( tindex, 1 ), TSDataInfo % tmax )
  1493:                   end if
  1494:             
  1495:                   if ( TSDataInfo % NDims == 0 ) then
  1496:                     call HistoryGet(                                       &
  1497:                       & TSDataInfo%FileName,                               &
  1498:                       & TSDataInfo%VarName,                                &
  1499:                       & TSDataInfo%xyza_SavedData(0,1,1,2),                &
  1500:                       & range = 'time=^'//toChar(tindex),                  &
  1501:                       & flag_mpi_split = flag_mpi_split                    &
  1502:                       & )
  1503:                   else if ( TSDataInfo % NDims == 2 ) then
  1504:                     call HistoryGet(                                       &
  1505:                       & TSDataInfo%FileName,                               &
  1506:                       & TSDataInfo%VarName,                                &
  1507:                       & TSDataInfo%xyza_SavedData(:,:,1,2),                &
  1508:                       & range = 'time=^'//toChar(tindex),                  &
  1509:                       & flag_mpi_split = flag_mpi_split                    &
  1510:                       & )
  1511:                   else
  1512:                     call HistoryGet(                                       &
  1513:                       & TSDataInfo%FileName,                               &
  1514:                       & TSDataInfo%VarName,                                &
  1515:                       & TSDataInfo%xyza_SavedData(:,:,:,2),                &
  1516:                       & range = 'time=^'//toChar(tindex),                  &
  1517:                       & flag_mpi_split = flag_mpi_split                    &
  1518:                       & )
  1519:                   end if
  1520:             
  1521:                   allocate( TSDataInfo%xyz_VarTimeInterpolated(0:imax-1, 1:jmax, 1:TSDataInfo%NVLevels) )
  1522:             
  1523:                 else
  1524:             
  1525:                   !-----
  1526:             !!$      allocate( TSDataInfo % a_time(TSDataInfo%tmax) )
  1527:             !!$      do t = 1, TSDataInfo%tmax
  1528:             !!$        TSDataInfo % a_time(t) = a_time(t)
  1529:             !!$      end do
  1530:                   !-----
  1531:             
  1532:             
  1533:                   allocate( TSDataInfo % a_time(TSDataInfo%tmax) )
  1534:                   call HistoryGet(               &
  1535:                     & TSDataInfo%FileName,              &
  1536:                     & 'time',                           &
  1537:                     & TSDataInfo%a_time(1:TSDataInfo%tmax),                           &
  1538:                     & flag_mpi_split = flag_mpi_split   &
  1539:                     & )
  1540:                   call NWGetAtt( TSDataInfo%FileName, 'time', 'units', attchar )
  1541:                   if ( ( attchar(1:3) == 'day' ) .or. &
  1542:                     &  ( attchar(1:3) == 'DAY' ) .or. &
  1543:                     &  ( attchar(1:3) == 'Day' ) ) then
  1544:                     ! convert unit of time from day to sec
  1545: V====== A           TSDataInfo%a_time(1:TSDataInfo%tmax) = &
  1546:                       & TSDataInfo%a_time(1:TSDataInfo%tmax) * sec_in_day
  1547:                   else
  1548:                     call MessageNotify( 'E', module_name, 'Unit of time, %c, is not supported.', &
  1549:                       & c1 = trim(attchar) )
  1550:                   end if
  1551:             
  1552:                   allocate( TSDataInfo % a_tindex(1:1) )
  1553:                   allocate( TSDataInfo % xyza_SavedData(0:imax-1,1:jmax,1:TSDataInfo%NVLevels,1:1) )
  1554:             
  1555:                   TSDataInfo % a_tindex(1) = 1
  1556:             
  1557:                   if ( TSDataInfo % NDims == 0 ) then
  1558:                     call HistoryGet(                                       &
  1559:                       & TSDataInfo%FileName,                               &
  1560:                       & TSDataInfo%VarName,                                &
  1561:                       & TSDataInfo%xyza_SavedData(0,1,1,1),                &
  1562:                       & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)),  &
  1563:                       & flag_mpi_split = flag_mpi_split                    &
  1564:                       & )
  1565:                   else if ( TSDataInfo % NDims == 2 ) then
  1566:                     call HistoryGet(                                       &
  1567:                       & TSDataInfo%FileName,                               &
  1568:                       & TSDataInfo%VarName,                                &
  1569:                       & TSDataInfo%xyza_SavedData(:,:,1,1),                &
  1570:                       & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)),  &
  1571:                       & flag_mpi_split = flag_mpi_split                    &
  1572:                       & )
  1573:                   else
  1574:                     call HistoryGet(                                       &
  1575:                       & TSDataInfo%FileName,                               &
  1576:                       & TSDataInfo%VarName,                                &
  1577:                       & TSDataInfo%xyza_SavedData(:,:,:,1),                &
  1578:                       & range = 'time=^'//toChar(TSDataInfo%a_tindex(1)),  &
  1579:                       & flag_mpi_split = flag_mpi_split                    &
  1580:                       & )
  1581:                   end if
  1582:             
  1583:                 end if
  1584:             
  1585:             
  1586:               end subroutine StructureInit
  1587:             
  1588:               !--------------------------------------------------------------------------------------
  1589:             
  1590:               subroutine ReadTimeSeriesInit
  1591:             
  1592:                 ! ファイル入出力補助
  1593:                 ! File I/O support
  1594:                 !
  1595:                 use dc_iounit, only: FileOpen
  1596:             
  1597:                 ! NAMELIST ファイル入力に関するユーティリティ
  1598:                 ! Utilities for NAMELIST file input
  1599:                 !
  1600:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1601:             
  1602:                 ! 時刻管理
  1603:                 ! Time control
  1604:                 !
  1605:                 use timeset, only: InitialDate
  1606:             
  1607:                 ! 宣言文 ; Declaration statements
  1608:                 !
  1609:             
  1610:                 logical :: flag_mpi_init
  1611:             
  1612:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1613:                                           ! Unit number for NAMELIST file open
  1614:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1615:                                           ! IOSTAT of NAMELIST read
  1616:             
  1617:                 ! NAMELIST 変数群
  1618:                 ! NAMELIST group name
  1619:                 !
  1620:                 namelist /read_time_series_nml/ &
  1621:                   & FlagYearCyclic
  1622:                       !
  1623:                       ! デフォルト値については初期化手続 "read_time_series#ReadTimeSeriesInit"
  1624:                       ! のソースコードを参照のこと.
  1625:                       !
  1626:                       ! Refer to source codes in the initialization procedure
  1627:                       ! "read_time_series#ReadTimeSeriesInit" for the default values.
  1628:                       !
  1629:             
  1630:                 if ( read_time_series_inited ) return
  1631:             
  1632:             
  1633:                 ! デフォルト値の設定
  1634:                 ! Default values settings
  1635:                 !
  1636:             
  1637:                 FlagYearCyclic = .true.
  1638:             
  1639:                 ! NAMELIST の読み込み
  1640:                 ! NAMELIST is input
  1641:                 !
  1642:                 if ( trim(namelist_filename) /= '' ) then
  1643:                   call FileOpen( unit_nml, &          ! (out)
  1644:                     & namelist_filename, mode = 'r' ) ! (in)
  1645:             
  1646:                   rewind( unit_nml )
  1647:                   read( unit_nml,                     & ! (in)
  1648:                     & nml = read_time_series_nml,       & ! (out)
  1649:                     & iostat = iostat_nml )             ! (out)
  1650:                   close( unit_nml )
  1651:             
  1652:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1653:                 end if
  1654:             
  1655:             
  1656:                 ! Initialzation
  1657:                 !
  1658:                 NumMaxStruct = 0
  1659:             
  1660:             
  1661:                 ! 印字 ; Print
  1662:                 !
  1663:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1664:                 call MessageNotify( 'M', module_name, 'FlagYearCyclic = %b', l = (/ FlagYearCyclic /) )
  1665:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1666:             
  1667:             
  1668:                 read_time_series_inited = .true.
  1669:             
  1670:             
  1671:               end subroutine ReadTimeSeriesInit
  1672:             
  1673:               !--------------------------------------------------------------------------------------
  1674:             
  1675:             end module read_time_series
