Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:32 2016
FILE NAME: restart_file_io.f90
PROGRAM NAME: restart_file_io
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   531  vec  (   4): Vectorized array expression.
   531  vec  (  29): ADB is used for array.: x_lon
   534  vec  (   4): Vectorized array expression.
   534  vec  (  29): ADB is used for array.: y_lat
   610  vec  (   3): Unvectorized loop.
   611  opt  (1017): Subroutine call prevents optimization.
   611  vec  (  10): Vectorization obstructive procedure reference.:historyaddvariable1
   644  vec  (   3): Unvectorized loop.
   645  opt  (1017): Subroutine call prevents optimization.
   645  vec  (   9): Vectorization obstructive statement.
   645  vec  (  10): Vectorization obstructive procedure reference.:historyaddvariable1
   673  vec  (   3): Unvectorized loop.
   674  opt  (1017): Subroutine call prevents optimization.
   674  vec  (   9): Vectorization obstructive statement.
   674  vec  (  10): Vectorization obstructive procedure reference.:historyaddvariable1
   821  vec  (   3): Unvectorized loop.
   822  opt  (1017): Subroutine call prevents optimization.
   822  vec  (   9): Vectorization obstructive statement.
   822  vec  (  10): Vectorization obstructive procedure reference.:historyputdouble3
   834  vec  (   3): Unvectorized loop.
   835  opt  (1017): Subroutine call prevents optimization.
   835  vec  (   9): Vectorization obstructive statement.
   835  vec  (  10): Vectorization obstructive procedure reference.:historyputdouble3
   941  vec  (   3): Unvectorized loop.
   942  opt  (1017): Subroutine call prevents optimization.
   942  vec  (   9): Vectorization obstructive statement.
   942  vec  (  10): Vectorization obstructive procedure reference.:historyputdouble3
  1130  opt  (1593): Loop nest collapsed into one loop.
  1130  vec  (   4): Vectorized array expression.
  1130  vec  (  29): ADB is used for array.: xyzf_qmixb
  1131  opt  (1593): Loop nest collapsed into one loop.
  1131  vec  (   4): Vectorized array expression.
  1131  vec  (  29): ADB is used for array.: xyzf_qmixb
  1138  opt  (  11): Fused array assignments. :line 1138 - 1140
  1138  opt  (1592): Outer loop unrolled inside inner loop.
  1138  vec  (   4): Vectorized array expression.
  1138  vec  (  29): ADB is used for array.: xyz_tempn
  1138  vec  (  29): ADB is used for array.: xyz_tempb
  1138  vec  (  29): ADB is used for array.: xyz_vn
  1138  vec  (  29): ADB is used for array.: xyz_vb
  1138  vec  (  29): ADB is used for array.: xyz_un
  1138  vec  (  29): ADB is used for array.: xyz_ub
  1138  vec  (   4): Vectorized array expression.
  1138  vec  (  29): ADB is used for array.: xyz_tempn
  1138  vec  (  29): ADB is used for array.: xyz_tempb
  1138  vec  (  29): ADB is used for array.: xyz_vn
  1138  vec  (  29): ADB is used for array.: xyz_vb
  1138  vec  (  29): ADB is used for array.: xyz_un
  1138  vec  (  29): ADB is used for array.: xyz_ub
  1141  opt  (1593): Loop nest collapsed into one loop.
  1141  vec  (   4): Vectorized array expression.
  1141  vec  (  29): ADB is used for array.: xyzf_qmixn
  1141  vec  (  29): ADB is used for array.: xyzf_qmixb
  1142  opt  (1592): Outer loop unrolled inside inner loop.
  1142  vec  (   4): Vectorized array expression.
  1142  vec  (  29): ADB is used for array.: xy_psn
  1142  vec  (  29): ADB is used for array.: xy_psb
  1142  vec  (   4): Vectorized array expression.
  1142  vec  (  29): ADB is used for array.: xy_psn
  1142  vec  (  29): ADB is used for array.: xy_psb
  1367  vec  (   3): Unvectorized loop.
  1368  opt  (1017): Subroutine call prevents optimization.
  1368  vec  (   9): Vectorization obstructive statement.
  1368  vec  (  10): Vectorization obstructive procedure reference.:historygetdouble3
  1385  opt  (  11): Fused array assignments. :line 1385 - 1387
  1385  opt  (1592): Outer loop unrolled inside inner loop.
  1385  vec  (   4): Vectorized array expression.
  1385  vec  (  29): ADB is used for array.: xyz_tempn
  1385  vec  (  29): ADB is used for array.: xyz_tempb
  1385  vec  (  29): ADB is used for array.: xyz_vn
  1385  vec  (  29): ADB is used for array.: xyz_vb
  1385  vec  (  29): ADB is used for array.: xyz_un
  1385  vec  (  29): ADB is used for array.: xyz_ub
  1385  vec  (   4): Vectorized array expression.
  1385  vec  (  29): ADB is used for array.: xyz_tempn
  1385  vec  (  29): ADB is used for array.: xyz_tempb
  1385  vec  (  29): ADB is used for array.: xyz_vn
  1385  vec  (  29): ADB is used for array.: xyz_vb
  1385  vec  (  29): ADB is used for array.: xyz_un
  1385  vec  (  29): ADB is used for array.: xyz_ub
  1388  opt  (1593): Loop nest collapsed into one loop.
  1388  vec  (   4): Vectorized array expression.
  1388  vec  (  29): ADB is used for array.: xyzf_qmixn
  1388  vec  (  29): ADB is used for array.: xyzf_qmixb
  1389  opt  (1592): Outer loop unrolled inside inner loop.
  1389  vec  (   4): Vectorized array expression.
  1389  vec  (  29): ADB is used for array.: xy_psn
  1389  vec  (  29): ADB is used for array.: xy_psb
  1389  vec  (   4): Vectorized array expression.
  1389  vec  (  29): ADB is used for array.: xy_psn
  1389  vec  (  29): ADB is used for array.: xy_psb
  1404  vec  (   3): Unvectorized loop.
  1405  opt  (1017): Subroutine call prevents optimization.
  1405  vec  (   9): Vectorization obstructive statement.
  1405  vec  (  10): Vectorization obstructive procedure reference.:historygetdouble3
  1428  vec  (   3): Unvectorized loop.
  1429  opt  (1017): Subroutine call prevents optimization.
  1429  vec  (   9): Vectorization obstructive statement.
  1429  vec  (  10): Vectorization obstructive procedure reference.:historygetdouble3
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:32 2016
FILE NAME: restart_file_io.f90
PROGRAM NAME: restart_file_io
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != リスタートデータ, 初期値データ入出力
     2  !
     3  != Restart data, initial data input/output
     4  !
     5  ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: restart_file_io.f90,v 1.26 2013/09/30 03:03:42 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module restart_file_io
    13    !
    14    != リスタートデータ, 初期値データ入出力
    15    !
    16    != Restart data, initial data input/output
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! リスタートデータもしくは初期値データの入出力を行います.
    21    ! 入力ファイル, 出力ファイル, データの出力の間隔は
    22    ! NAMELIST#restart_file_io_nml で設定します.
    23    !
    24    ! リスタートデータの入力ファイルが指定されない場合,
    25    ! initial_data モジュールで生成された初期値データを取得します.
    26    !
    27    ! Restart data or initial data is input/output.
    28    ! Settings of input file, output file, and interval of data output
    29    ! is configured by "NAMELIST#restart_file_io_nml".
    30    !
    31    ! If input file of restart data is not set,
    32    ! initial data is generated in "initial_data" module, and
    33    ! obtained data from the module.
    34    !
    35    !== Procedures List
    36    !
    37    ! RestartFileOpen   :: リスタート/初期値ファイルのオープン
    38    ! RestartFileOutput :: リスタート/初期値ファイルへのデータ出力
    39    ! InitialFileOutput :: 初期値ファイルへのデータ出力
    40    ! RestartFileClose  :: リスタート/初期値ファイルのクローズ
    41    ! RestartFileGet    :: リスタート/初期値ファイルの入力
    42    ! ------------      :: ------------
    43    ! RestartFileOpen   :: Open restart/initial file
    44    ! RestartFileOutput :: Data output to restart/initial file
    45    ! InitialFileOutput :: Data output to initial file
    46    ! RestartFileClose  :: Close restart/initial file
    47    ! RestartFileGet    :: Input restart/initial file
    48    !
    49    !== NAMELIST
    50    !
    51    ! NAMELIST#restart_file_io_nml
    52    !
    53  
    54    ! モジュール引用 ; USE statements
    55    !
    56  
    57    ! 格子点設定
    58    ! Grid points settings
    59    !
    60    use gridset, only: imax, & ! 経度格子点数.
    61                               ! Number of grid points in longitude
    62      &                jmax, & ! 緯度格子点数.
    63                               ! Number of grid points in latitude
    64      &                kmax    ! 鉛直層数.
    65                               ! Number of vertical level
    66  
    67    ! 組成に関わる配列の設定
    68    ! Settings of array for atmospheric composition
    69    !
    70    use composition, only: &
    71      &                    ncmax, &
    72                                ! 成分の数
    73                                ! Number of composition
    74      &                    a_QMixName, &
    75                                ! 成分の変数名
    76                                ! Name of variables for composition
    77      &                    a_QMixLongName, &
    78                                ! 成分の長い変数名
    79                                ! Long name of variables for composition
    80      &                    IndexH2OVap
    81                                ! 水蒸気のインデックス
    82                                ! Index for water vapor
    83  
    84  
    85    ! 種別型パラメタ
    86    ! Kind type parameter
    87    !
    88    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    89      &                 STRING, &  ! 文字列.       Strings.
    90      &                 TOKEN      ! キーワード.   Keywords.
    91  
    92    ! メッセージ出力
    93    ! Message output
    94    !
    95    use dc_message, only: MessageNotify
    96  
    97    ! gtool4 データ出力
    98    ! Gtool4 data output
    99    !
   100    use gtool_history, only: GT_HISTORY
   101  
   102  
   103    ! 宣言文 ; Declaration statements
   104    !
   105    implicit none
   106    private
   107  
   108    ! 公開手続き
   109    ! Public procedure
   110    !
   111    public :: RestartFileInit
   112    public :: RestartFileOpen, RestartFileClose, RestartFileOutPut, InitialFileOutput
   113    public :: RestartFileGet
   114  
   115    ! 公開変数
   116    ! Public variables
   117    !
   118    logical, save, public:: restart_file_io_inited = .false.
   119                                ! 初期設定フラグ.
   120                                ! Initialization flag
   121  
   122    logical, save, public:: restart_file_opened = .false.
   123                                ! リスタートファイルのオープンに関するフラグ.
   124                                ! Flag of restart file open
   125  
   126    character(STRING), save, public:: InputFile
   127                                ! 入力するリスタートデータのファイル名
   128                                ! Filename of input restart data
   129  
   130    character(STRING), save, public:: OutputFile
   131                                ! 出力するリスタートデータのファイル名
   132                                ! Filename of output restart data
   133    real(DP), save, public:: IntValue
   134                                ! リスタートデータの出力間隔 (数値).
   135                                ! Interval of restart data output (numerical value)
   136    character(TOKEN), save, public:: IntUnit
   137                                ! リスタートデータの出力間隔 (単位).
   138                                ! Interval of restart data output (unit)
   139    real(DP), save, public:: IntTime
   140                                ! リスタートデータの出力間隔 [秒].
   141                                ! Interval of restart data output [sec]
   142  
   143    ! 非公開変数
   144    ! Private variables
   145    !
   146    logical, save:: flag_init_data_save
   147                                ! 初期値データを作成する場合は,
   148                                ! この引数に .true. を与えます.
   149                                !
   150                                ! If initial data is created,
   151                                ! give ".true." to this argument.
   152  
   153    type(GT_HISTORY), save:: gthst_rst
   154                                ! リスタートデータ用 gtool_history#GT_HISTORY 変数
   155                                ! "gtool_history#GT_HISTORY" variable for restart data
   156  
   157    real(DP), save:: PrevOutputTime
   158                                ! 前回の出力時間.
   159                                ! Previous output time
   160    logical, save:: flag_output_end
   161                                ! 計算最終時刻の出力完了のフラグ.
   162                                ! Flag for completion of output at the end time of calculation
   163  
   164    character(*), parameter:: module_name = 'restart_file_io'
   165                                ! モジュールの名称.
   166                                ! Module name
   167    character(*), parameter:: version = &
   168      & '$Name:  $' // &
   169      & '$Id: restart_file_io.f90,v 1.26 2013/09/30 03:03:42 yot Exp $'
   170                                ! モジュールのバージョン
   171                                ! Module version
   172  
   173  contains
   174  
   175    !--------------------------------------------------------------------------------------
   176  
   177    subroutine RestartFileOpen( flag_init_data )
   178      !
   179      ! リスタート/初期値ファイルをオープンします.
   180      !
   181      ! A restart/initial data file is opened.
   182      !
   183  
   184      ! モジュール引用 ; USE statements
   185      !
   186  
   187      ! 出力ファイルの基本情報
   188      ! Basic information for output files
   189      !
   190      use fileset, only: &
   191        & FileTitle, &
   192                                ! 出力データファイルの表題.
   193                                ! Title of output data files
   194        & FileSource, &
   195                                ! データファイル作成の手段.
   196                                ! Source of data file
   197        & FileInstitution
   198                                ! データファイルを最終的に変更した組織/個人.
   199                                ! Institution or person that changes data files for the last time
   200  
   201      ! 物理・数学定数設定
   202      ! Physical and mathematical constants settings
   203      !
   204      use constants0, only: &
   205        & PI                    ! $ \pi $.
   206                                ! 円周率. Circular constant
   207  
   208      ! 座標データ設定
   209      ! Axes data settings
   210      !
   211      use axesset, only: &
   212        & x_Lon, &
   213                                ! $ \lambda $ [rad.] . 経度. Longitude
   214        & x_Lon_Weight, &
   215                                ! $ \Delta \lambda $ [rad.] .
   216                                ! 経度座標重み.
   217                                ! Weight of longitude
   218        & y_Lat, &
   219                                ! $ \varphi $ [rad.] . 緯度. Latitude
   220        & y_Lat_Weight, &
   221                                ! $ \Delta \varphi $ [rad.] .
   222                                ! 緯度座標重み.
   223                                ! Weight of latitude
   224        & z_Sigma, &
   225                                ! $ \sigma $ レベル (整数).
   226                                ! Full $ \sigma $ level
   227        & r_Sigma, &
   228                                ! $ \sigma $ レベル (半整数).
   229                                ! Half $ \sigma $ level
   230        & z_DelSigma
   231                                ! $ \Delta \sigma $ (整数).
   232                                ! $ \Delta \sigma $ (Full)
   233  
   234      ! 時刻管理
   235      ! Time control
   236      !
   237      use timeset, only: &
   238        & DelTime, &            ! $ \Delta t $ [s]
   239        & RestartTime, &        ! リスタート開始時刻.
   240                                ! Restart time of calculation
   241        & InitialDate           ! 計算開始日時.
   242                                ! Start date of calculation
   243  
   244      ! gtool4 データ出力
   245      ! Gtool4 data output
   246      !
   247      use gtool_history, only: HistoryCreate, HistoryAddVariable, &
   248        & HistoryPut, HistoryAddAttr
   249  
   250      ! 暦と日時の取り扱い
   251      ! Calendar and Date handler
   252      !
   253      use dc_calendar, only: DCCalInquire, DCCalDateInquire
   254  
   255      ! 文字列操作
   256      ! Character handling
   257      !
   258      use dc_string, only: CPrintf, LChar
   259  
   260      ! 組み込み関数 PRESENT の拡張版関数
   261      ! Extended functions of intrinsic function "PRESENT"
   262      !
   263      use dc_present, only: present_and_true
   264  
   265      ! 宣言文 ; Declaration statements
   266      !
   267      implicit none
   268      logical, intent(in), optional:: flag_init_data
   269                                ! 初期値データを作成する場合は,
   270                                ! この引数に .true. を与えます.
   271                                !
   272                                ! If initial data is created,
   273                                ! give ".true." to this argument.
   274  
   275      ! 作業変数
   276      ! Work variables
   277      !
   278      character(STRING):: title_msg
   279                                ! 表題に付加するメッセージ.
   280                                ! Message added to title
   281      real(DP):: origin_time
   282                                ! 計算開始時刻.
   283                                ! Start time of calculation
   284  
   285      integer:: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
   286                                ! 計算開始の年月日時分.
   287      real(DP):: InitialSec
   288                                ! 計算開始の秒.
   289  
   290      character(TOKEN):: cal_type
   291                                ! 暦のタイプ.
   292      integer:: month_in_year, hour_in_day, min_in_hour
   293      integer, pointer:: day_in_month_ptr(:) => null()
   294      real(DP):: sec_in_min
   295                                ! 暦の詳細情報
   296  
   297      logical:: flag_mpi_init
   298  
   299      integer :: n
   300  
   301  
   302      ! 実行文 ; Executable statement
   303      !
   304  
   305      ! 初期化
   306      ! Initialization
   307      !
   308      flag_init_data_save = present_and_true( flag_init_data )
   309  
   310      if ( .not. restart_file_io_inited ) then
   311        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   312      end if
   313  
   314      if ( restart_file_opened ) return
   315  
   316      ! 表題に付加するメッセージの設定
   317      ! Configure message added to title
   318      !
   319      if ( .not. flag_init_data_save ) then
   320        title_msg = ' restart data'
   321      else
   322        title_msg = ' initial data'
   323      end if
   324  
   325      ! 時刻情報の取得
   326      ! Get time information
   327      !
   328      if ( .not. flag_init_data_save ) then
   329        origin_time = RestartTime + IntTime
   330      else
   331        origin_time = RestartTime
   332      end if
   333  
   334      flag_mpi_init = .false.
   335  
   336      ! リスタートファイルのオープン
   337      ! Open a restart file
   338      !
   339      call HistoryCreate( &
   340        &      file = OutputFile, &                                   ! (in)
   341        &     title = trim(FileTitle) // trim(title_msg), &           ! (in)
   342        &    source = FileSource, institution = FileInstitution, &    ! (in)
   343        &      dims = (/ 'lon    ', 'lat    ', 'sig    ', 'sigm   ', &
   344        &                'timestr', 'time   ' /), &                   ! (in)
   345        &  dimsizes = (/ imax, jmax, kmax, kmax + 1, TOKEN, 0 /), &   ! (in)
   346        & longnames = (/ 'longitude                             ', &
   347        &                'latitude                              ', &
   348        &                'sigma at layer midpoints              ', &
   349        &                'sigma at layer end-points (half level)', &
   350        &                'number of characters for datetime     ', &    ! (in)
   351        &                'time                                  ' /), & ! (in)
   352        &     units = (/ 'degrees_east ', 'degrees_north', &
   353        &                '1            ', '1            ', &
   354        &                '1            ',                  &
   355        &                'sec          ' /), &                           ! (in)
   356        & xtypes = (/'double', 'double', 'double', &
   357        &            'double', 'int   ', 'double'/), &                  ! (in)
   358        &        origind = origin_time, &       ! (in) optional
   359        &      intervald = IntTime, &           ! (in) optional
   360  !!$      & flag_mpi_split = flag_mpi_init, &     ! (in) optional
   361        & flag_mpi_split = .true., &            ! (in) optional
   362        &        history = gthst_rst )          ! (out) optional
   363  
   364  
   365      ! ※ 元々再計算データかどうかのチェックのためのフラグとして
   366      !    作成したものであるため、下記 flag_rst 設定完了後
   367      !    削除予定 (morikawa  2010/06/13)
   368      !
   369      ! $ \Delta t $ に関する情報を追加.
   370      ! Add information about $ \Delta t $.
   371      !
   372  !!$    if ( .not. flag_init_data_save ) then
   373  !!$      call HistoryAddVariable( &
   374  !!$        & varname = 'deltime', &             ! (in)
   375  !!$        & dims = (/''/), &                   ! (in)
   376  !!$        & longname = 'delta time', &         ! (in)
   377  !!$        & units = 'sec', xtype = 'double', & ! (in)
   378  !!$        & history = gthst_rst )              ! (inout)
   379  !!$      call HistoryPut( &
   380  !!$        & varname = 'deltime', &            ! (in)
   381  !!$        & array = (/ DelTime /), &          ! (in)
   382  !!$        & history = gthst_rst )             ! (inout)
   383  !!$    end if
   384  
   385      ! 開始日時情報を "time" の属性として設定
   386      ! Set start date information as attributes of "time"
   387      !
   388      call DCCalDateInquire( &
   389        & InitialYear, InitialMonth, InitialDay, & ! (out)
   390        & InitialHour, InitialMin,   InitialSec, & ! (out)
   391        & date = InitialDate )               ! (in)
   392  
   393      call HistoryAddAttr( &
   394        & 'time', attrname = 'origin', &     ! (in)
   395        & value = 'origin_year origin_month origin_day origin_hour origin_min origin_sec', &
   396                                             ! (in)
   397        & history = gthst_rst )              ! (inout)
   398      call HistoryAddAttr( &
   399        & 'time', attrname = 'origin_year', & ! (in)
   400        & value = InitialYear, &                ! (in)
   401        & history = gthst_rst )               ! (inout)
   402      call HistoryAddAttr( &
   403        & 'time', attrname = 'origin_month', & ! (in)
   404        & value = InitialMonth, &                ! (in)
   405        & history = gthst_rst )                ! (inout)
   406      call HistoryAddAttr( &
   407        & 'time', attrname = 'origin_day', &  ! (in)
   408        & value = InitialDay, &                 ! (in)
   409        & history = gthst_rst )               ! (inout)
   410      call HistoryAddAttr( &
   411        & 'time', attrname = 'origin_hour', &  ! (in)
   412        & value = InitialHour, &                 ! (in)
   413        & history = gthst_rst )                ! (inout)
   414      call HistoryAddAttr( &
   415        & 'time', attrname = 'origin_min', &  ! (in)
   416        & value = InitialMin, &                 ! (in)
   417        & history = gthst_rst )               ! (inout)
   418      call HistoryAddAttr( &
   419        & 'time', attrname = 'origin_sec', &  ! (in)
   420        & value = InitialSec, &                 ! (in)
   421        & history = gthst_rst )               ! (inout)
   422  
   423      ! 暦情報を "time" の属性として設定
   424      ! Set calendar information as attributes of "time"
   425      !
   426      call DCCalInquire( &
   427        & cal_type         = cal_type, &          ! (out)
   428        & month_in_year    = month_in_year, &     ! (out)
   429        & day_in_month_ptr = day_in_month_ptr , & ! (out)
   430        & hour_in_day      = hour_in_day  , &     ! (out)
   431        & min_in_hour      = min_in_hour  , &     ! (out)
   432        & sec_in_min       = sec_in_min )         ! (out)
   433  
   434      call HistoryAddAttr( &
   435        & 'time', attrname = 'calendar', & ! (in)
   436        & value = cal_type, &              ! (in)
   437        & history = gthst_rst )            ! (inout)
   438      call HistoryAddAttr( &
   439        & 'time', attrname = 'month_in_year', & ! (in)
   440        & value = month_in_year, &              ! (in)
   441        & history = gthst_rst )                 ! (inout)
   442      call HistoryAddAttr( &
   443        & 'time', attrname = 'day_in_month', & ! (in)
   444        & value = day_in_month_ptr, &          ! (in)
   445        & history = gthst_rst )                ! (inout)
   446      call HistoryAddAttr( &
   447        & 'time', attrname = 'hour_in_day', & ! (in)
   448        & value = hour_in_day, &              ! (in)
   449        & history = gthst_rst )               ! (inout)
   450      call HistoryAddAttr( &
   451        & 'time', attrname = 'min_in_hour', & ! (in)
   452        & value = min_in_hour, &              ! (in)
   453        & history = gthst_rst )               ! (inout)
   454      call HistoryAddAttr( &
   455        & 'time', attrname = 'sec_in_min', & ! (in)
   456        & value = sec_in_min, &              ! (in)
   457        & history = gthst_rst )              ! (inout)
   458  
   459      deallocate( day_in_month_ptr )
   460  
   461      ! 再計算データ用のフラグ設定
   462      ! Set flag for a restart data file.
   463      !
   464      call HistoryAddVariable( &
   465        & varname = 'flag_rst', &               ! (in)
   466        & dims = (/''/), &                      ! (in)
   467        & longname = 'flag for restart data', & ! (in)
   468        & units = '1', xtype = 'int', &         ! (in)
   469        & history = gthst_rst )                 ! (inout)
   470      call HistoryAddAttr( &
   471        & varname = 'flag_rst', &               ! (in)
   472        & attrname = 'comment', &               ! (in)
   473        & value = 'If this value is nonzero, this file provides restart data', &
   474                                                  ! (in)
   475        & history = gthst_rst )                 ! (inout)
   476  
   477      if ( flag_init_data_save ) then
   478        call HistoryPut( &
   479          & varname = 'flag_rst', &               ! (in)
   480          & array = (/ 0 /), &                    ! (in)
   481          & history = gthst_rst )                 ! (inout)
   482      else
   483        call HistoryPut( &
   484          & varname = 'flag_rst', &               ! (in)
   485          & array = (/ 1 /), &                    ! (in)
   486          & history = gthst_rst )                 ! (inout)
   487      end if
   488  
   489      ! 年月日時分秒形式の日時情報変数の設定
   490      ! Set a date information variable with year-month-day hour:minute:second format
   491      !
   492      call HistoryAddVariable( &
   493        & varname = 'datetime', &                     ! (in)
   494        & dims =  (/'timestr', 'time   ' /), &        ! (in)
   495        & longname = 'time represented as strings', & ! (in)
   496        & units = '1', xtype = 'char', &              ! (in)
   497        & history = gthst_rst )                       ! (inout) optional
   498  
   499      ! 座標データの設定
   500      ! Axes data settings
   501      !
   502      call HistoryAddAttr( &
   503        & 'lon', attrname = 'standard_name', &     ! (in)
   504        & value = 'longitude', &                   ! (in)
   505        & history = gthst_rst )                    ! (inout)
   506      call HistoryAddAttr( &
   507        & 'lat', attrname = 'standard_name', &     ! (in)
   508        & value = 'latitude', &                    ! (in)
   509        & history = gthst_rst )                    ! (inout)
   510      call HistoryAddAttr( &
   511        & 'sig', attrname = 'standard_name', &     ! (in)
   512        & value = 'atmosphere_sigma_coordinate', & ! (in)
   513        & history = gthst_rst )                    ! (inout)
   514      call HistoryAddAttr( &
   515        & 'sigm', attrname = 'standard_name', &    ! (in)
   516        & value = 'atmosphere_sigma_coordinate', & ! (in)
   517        & history = gthst_rst )                    ! (inout)
   518      call HistoryAddAttr( &
   519        & 'time', attrname = 'standard_name', &    ! (in)
   520        & value = 'time', &                        ! (in)
   521        & history = gthst_rst )                    ! (inout)
   522      call HistoryAddAttr( &
   523        & 'sig', attrname = 'positive', &          ! (in)
   524        & value = 'down', &                        ! (in)
   525        & history = gthst_rst )                    ! (inout)
   526      call HistoryAddAttr( &
   527        & 'sigm', attrname = 'positive', &         ! (in)
   528        & value = 'down', &                        ! (in)
   529        & history = gthst_rst )                    ! (inout)
   530  
   531      call HistoryPut( &
     .        d1 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t1043 = 1, x_lon.DSC.U1 + 1 - x_lon.DSC.L1                     
     .           %IG11(t1043) = x_lon(x_lon.DSC.L1+t1043-1)*d1*                 
     .       1      1.80000000000000e+002                                       
     .        enddo                                                             
   532        & 'lon', x_Lon / PI * 180.0_DP, & ! (in)
   533        & history = gthst_rst )           ! (inout)
   534      call HistoryPut( &
     .        d2 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t1047 = 1, y_lat.DSC.U1 + 1 - y_lat.DSC.L1                     
     .           %IG14(t1047) = y_lat(y_lat.DSC.L1+t1047-1)*d2*                 
     .       1      1.80000000000000e+002                                       
     .        enddo                                                             
   535        & 'lat', y_Lat / PI * 180.0_DP, & ! (in)
   536        & history = gthst_rst )           ! (inout)
   537      call HistoryPut( &
   538        & 'sig', z_Sigma, &               ! (in)
   539        & history = gthst_rst )           ! (inout)
   540      call HistoryPut( &
   541        & 'sigm', r_Sigma, &              ! (in)
   542        & history = gthst_rst )           ! (inout)
   543  
   544      ! 座標重みの設定
   545      ! Axes weights settings
   546      !
   547      call HistoryAddVariable( 'lon_weight', &               ! (in)
   548        & (/'lon'/), &                                       ! (in)
   549        & 'weight for integration in longitude', 'radian', & ! (in)
   550        & xtype = 'double', &                                ! (in)
   551        & history = gthst_rst )                              ! (inout)
   552      call HistoryAddAttr( &
   553        & 'lon', attrname = 'gt_calc_weight', &     ! (in)
   554        & value = 'lon_weight', &                   ! (in)
   555        & history = gthst_rst )                     ! (inout)
   556      call HistoryPut( &
   557        & 'lon_weight', x_Lon_Weight, &             ! (in)
   558        & history = gthst_rst )                     ! (inout)
   559  
   560      call HistoryAddVariable( 'lat_weight', &                      ! (in)
   561        & (/'lat'/), &                                              ! (in)
   562        & 'weight for integration in latitude', units = 'radian', & ! (in)
   563        & xtype = 'double', &                                       ! (in)
   564        & history = gthst_rst )                                     ! (inout)
   565      call HistoryAddAttr( &
   566        & 'lat', attrname = 'gt_calc_weight', &     ! (in)
   567        & value = 'lat_weight', &                   ! (in)
   568        & history = gthst_rst )                     ! (inout)
   569      call HistoryPut( &
   570        & 'lat_weight', y_Lat_Weight, &             ! (in)
   571        & history = gthst_rst )                     ! (inout)
   572  
   573      call HistoryAddVariable( 'sig_weight', &      ! (in)
   574        & (/'sig'/), &                              ! (in)
   575        & 'weight for integration in sigma', '1', & ! (in)
   576        & xtype = 'double', &                       ! (in)
   577        & history = gthst_rst )                     ! (inout)
   578      call HistoryAddAttr( &
   579        & 'sig', attrname = 'gt_calc_weight', &     ! (in)
   580        & value = 'sig_weight', &                   ! (in)
   581        & history = gthst_rst )                     ! (inout)
   582      call HistoryPut( &
   583        & 'sig_weight', z_DelSigma, &               ! (in)
   584        & history = gthst_rst )                     ! (inout)
   585  
   586  
   587      ! 予報変数の設定
   588      ! Predictional variables settings
   589      !
   590      if ( flag_init_data_save ) then
   591  
   592        ! 初期データファイル用
   593        ! For initial data file
   594        !
   595        call HistoryAddVariable( 'U', &                         ! (in)
   596          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   597          & 'eastward wind', 'm s-1', &                         ! (in)
   598          & xtype = 'double', &                                 ! (in)
   599          & history = gthst_rst )                               ! (inout)
   600        call HistoryAddVariable( 'V', &                         ! (in)
   601          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   602          & 'northward wind', 'm s-1', &                        ! (in)
   603          & xtype = 'double', &                                 ! (in)
   604          & history = gthst_rst )                               ! (inout)
   605        call HistoryAddVariable( 'Temp', &                      ! (in)
   606          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   607          & 'temperature', 'K', &                               ! (in)
   608          & xtype = 'double', &                                 ! (in)
   609          & history = gthst_rst )                               ! (inout)
   610        do n = 1, ncmax
   611          call HistoryAddVariable( a_QMixName(n),                & ! (in)
   612            & (/ 'lon ', 'lat ', 'sig ', 'time' /),              & ! (in)
   613            & a_QMixLongName(n), 'kg kg-1',                      & ! (in)
   614            & xtype = 'double',                                  & ! (in)
   615            & history = gthst_rst                                & ! (inout)
   616            & )
   617        end do
   618        call HistoryAddVariable( 'Ps', &                        ! (in)
   619          & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
   620          & 'surface pressure', 'Pa', &                         ! (in)
   621          & xtype = 'double', &                                 ! (in)
   622          & history = gthst_rst )                               ! (inout)
   623  
   624      else
   625  
   626        ! リスタートデータファイル用
   627        ! For restart data file
   628        !
   629        call HistoryAddVariable( 'UB', &                        ! (in)
   630          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   631          & 'eastward wind (at t-\Delta t)', 'm s-1', &         ! (in)
   632          & xtype = 'double', &                                 ! (in)
   633          & history = gthst_rst )                               ! (inout)
   634        call HistoryAddVariable( 'VB', &                        ! (in)
   635          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   636          & 'northward wind (at t-\Delta t)', 'm s-1', &        ! (in)
   637          & xtype = 'double', &                                 ! (in)
   638          & history = gthst_rst )                               ! (inout)
   639        call HistoryAddVariable( 'TempB', &                     ! (in)
   640          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   641          & 'temperature (at t-\Delta t)', 'K', &               ! (in)
   642          & xtype = 'double', &                                 ! (in)
   643          & history = gthst_rst )                               ! (inout)
   644        do n = 1, ncmax
   645          call HistoryAddVariable( trim(a_QMixName(n))//'B',    & ! (in)
   646            & (/ 'lon ', 'lat ', 'sig ', 'time' /),             & ! (in)
   647            & a_QMixLongName(n), 'kg kg-1',                     & ! (in)
   648            & xtype = 'double',                                 & ! (in)
   649            & history = gthst_rst                               & ! (inout)
   650            & )
   651        end do
   652        call HistoryAddVariable( 'PsB', &                       ! (in)
   653          & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
   654          & 'surface pressure (at t-\Delta t)', 'Pa', &         ! (in)
   655          & xtype = 'double', &                                 ! (in)
   656          & history = gthst_rst )                               ! (inout)
   657  
   658        call HistoryAddVariable( 'UN', &                        ! (in)
   659          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   660          & 'eastward wind (at t)', 'm s-1', &                  ! (in)
   661          & xtype = 'double', &                                 ! (in)
   662          & history = gthst_rst )                               ! (inout)
   663        call HistoryAddVariable( 'VN', &                        ! (in)
   664          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   665          & 'northward wind (at t)', 'm s-1', &                 ! (in)
   666          & xtype = 'double', &                                 ! (in)
   667          & history = gthst_rst )                               ! (inout)
   668        call HistoryAddVariable( 'TempN', &                     ! (in)
   669          & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   670          & 'temperature (at t)', 'K', &                        ! (in)
   671          & xtype = 'double', &                                 ! (in)
   672          & history = gthst_rst )                               ! (inout)
   673        do n = 1, ncmax
   674          call HistoryAddVariable( trim(a_QMixName(n))//'N',    & ! (in)
   675            & (/ 'lon ', 'lat ', 'sig ', 'time' /),             & ! (in)
   676            & a_QMixLongName(n), 'kg kg-1',                     & ! (in)
   677            & xtype = 'double',                                 & ! (in)
   678            & history = gthst_rst                               & ! (inout)
   679            & )
   680        end do
   681        call HistoryAddVariable( 'PsN', &                       ! (in)
   682          & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
   683          & 'surface pressure (at t)', 'Pa', &                  ! (in)
   684          & xtype = 'double', &                                 ! (in)
   685          & history = gthst_rst )                               ! (inout)
   686      end if
   687  
   688      restart_file_opened = .true.
   689    end subroutine RestartFileOpen
   690  
   691    !--------------------------------------------------------------------------------------
   692  
   693    subroutine RestartFileOutput(                      &
   694      & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
   695      & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN  &   ! (in)
   696      & )
   697      !
   698      ! リスタートデータの出力を行います.
   699      !
   700      ! Output restart data
   701  
   702      ! モジュール引用 ; USE statements
   703      !
   704  
   705      ! 時刻管理
   706      ! Time control
   707      !
   708      use timeset, only: &
   709        & TimeN, &              ! ステップ $ t $ の時刻.
   710                                ! Time of step $ t $.
   711        & EndTime, &            ! 計算終了時刻.
   712                                ! End time of calculation
   713        & InitialDate           ! 計算開始日時.
   714                                ! Start date of calculation
   715  
   716      ! gtool4 データ出力
   717      ! Gtool4 data output
   718      !
   719      use gtool_history, only: HistoryPut, HistorySetTime
   720  
   721      ! 暦と日時の取り扱い
   722      ! Calendar and Date handler
   723      !
   724      use dc_calendar, only: DCCalDateInquire
   725  
   726      ! 組み込み関数 PRESENT の拡張版関数
   727      ! Extended functions of intrinsic function "PRESENT"
   728      !
   729      use dc_present, only: present_and_true
   730  
   731      ! 宣言文 ; Declaration statements
   732      !
   733      implicit none
   734      real(DP), intent(in):: xyz_UB     (0:imax-1, 1:jmax, 1:kmax)
   735                                ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
   736      real(DP), intent(in):: xyz_VB     (0:imax-1, 1:jmax, 1:kmax)
   737                                ! $ v (t-\Delta t) $ .   南北風速. Northward wind
   738      real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
   739                                ! $ T (t-\Delta t) $ .   温度. Temperature
   740      real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   741                                ! $ q (t-\Delta t) $ .   比湿. Specific humidity
   742      real(DP), intent(in):: xy_PsB     (0:imax-1, 1:jmax)
   743                                ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   744      real(DP), intent(in):: xyz_UN     (0:imax-1, 1:jmax, 1:kmax)
   745                                ! $ u (t) $ .     東西風速. Eastward wind
   746      real(DP), intent(in):: xyz_VN     (0:imax-1, 1:jmax, 1:kmax)
   747                                ! $ v (t) $ .     南北風速. Northward wind
   748      real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
   749                                ! $ T (t) $ .     温度. Temperature
   750      real(DP), intent(in):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   751                                ! $ q (t) $ .     比湿. Specific humidity
   752      real(DP), intent(in):: xy_PsN     (0:imax-1, 1:jmax)
   753                                ! $ p_s (t) $ .   地表面気圧. Surface pressure
   754  
   755      ! 作業変数
   756      ! Work variables
   757      !
   758      logical:: flag_output
   759                                ! 出力のフラグ.
   760                                ! Flag for output
   761      character(TOKEN):: date_str         ! 日時の年月日時分秒形式.
   762                                          ! Date with year-month-day hour:minute:second format
   763      integer :: n
   764  
   765  
   766      ! 実行文 ; Executable statement
   767      !
   768      if ( .not. restart_file_opened ) call RestartFileOpen
   769  
   770      ! リスタートデータ出力であることのチェック
   771      ! Check restart data output
   772      !
   773      if ( flag_init_data_save ) then
   774        call MessageNotify( 'E', module_name, &
   775          & 'Now, initial data output mode.' )
   776      end if
   777  
   778      ! 出力タイミングのチェック
   779      ! Check output timing
   780      !
   781      flag_output = TimeN - PrevOutputTime >= IntTime
   782      if ( TimeN >= EndTime .and. .not. flag_output_end ) then
   783        flag_output = .true.
   784        flag_output_end = .true.
   785      end if
   786      flag_output = ( .not. TimeN == PrevOutputTime ) .and. flag_output
   787      flag_output = flag_init_data_save .or. flag_output
   788  
   789      if ( .not. flag_output ) return
   790  
   791      ! 次回用に, 今回の出力 (希望) 時刻 を保存
   792      ! Save output time (expected) in this time, for next time
   793      !
   794      PrevOutputTime = PrevOutputTime + IntTime
   795  
   796      ! 時刻の設定
   797      ! Set time
   798      !
   799      call HistorySetTime( timed = TimeN, history = gthst_rst )
   800  
   801      ! "TimeN" を年月日時分秒表記にして "datetime" 変数へ出力
   802      ! Put "TimeN" on "datetime" variable with year-month-day hour:minute:second format
   803      !
   804      call DCCalDateInquire( &
   805        & date_str   = date_str, &   ! (out)
   806        & elapse_sec = TimeN, &      ! (in) optional
   807        & date       = InitialDate ) ! (in) optional
   808  
   809      call HistoryPut( 'datetime', date_str, &  ! (in)
   810        &              history = gthst_rst )    ! (inout) optional
   811  
   812      ! データ出力
   813      ! Data output
   814      !
   815      call HistoryPut( &
   816        & 'UB', xyz_UB, history = gthst_rst ) ! (in)
   817      call HistoryPut( &
   818        & 'VB', xyz_VB, history = gthst_rst ) ! (in)
   819      call HistoryPut( &
   820        & 'TempB', xyz_TempB, history = gthst_rst ) ! (in)
   821      do n = 1, ncmax
   822        call HistoryPut( &
   823          & trim(a_QMixName(n))//'B', xyzf_QMixB(:,:,:,n), history = gthst_rst ) ! (in)
   824      end do
   825      call HistoryPut( &
   826        & 'PsB', xy_PsB, history = gthst_rst ) ! (in)
   827  
   828      call HistoryPut( &
   829        & 'UN', xyz_UN, history = gthst_rst ) ! (in)
   830      call HistoryPut( &
   831        & 'VN', xyz_VN, history = gthst_rst ) ! (in)
   832      call HistoryPut( &
   833        & 'TempN', xyz_TempN, history = gthst_rst ) ! (in)
   834      do n = 1, ncmax
   835        call HistoryPut( &
   836          & trim(a_QMixName(n))//'N', xyzf_QMixN(:,:,:,n), history = gthst_rst ) ! (in)
   837      end do
   838      call HistoryPut( &
   839        & 'PsN', xy_PsN, history = gthst_rst ) ! (in)
   840  
   841    end subroutine RestartFileOutput
   842  
   843    !--------------------------------------------------------------------------------------
   844  
   845    subroutine InitialFileOutput(                 &
   846      & xyz_U, xyz_V, xyz_Temp, xyzf_QMix, xy_Ps  &   ! (in)
   847      & )
   848      !
   849      ! 初期値データの出力を行います.
   850      !
   851      ! Output initial data
   852  
   853      ! モジュール引用 ; USE statements
   854      !
   855  
   856      ! 時刻管理
   857      ! Time control
   858      !
   859      use timeset, only: &
   860        & TimeN, &              ! ステップ $ t $ の時刻.
   861                                ! Time of step $ t $.
   862        & EndTime, &            ! 計算終了時刻.
   863                                ! End time of calculation
   864        & InitialDate           ! 計算開始日時.
   865                                ! Start date of calculation
   866  
   867      ! gtool4 データ出力
   868      ! Gtool4 data output
   869      !
   870      use gtool_history, only: HistoryPut, HistorySetTime
   871  
   872      ! 暦と日時の取り扱い
   873      ! Calendar and Date handler
   874      !
   875      use dc_calendar, only: DCCalDateInquire
   876  
   877      ! 組み込み関数 PRESENT の拡張版関数
   878      ! Extended functions of intrinsic function "PRESENT"
   879      !
   880      use dc_present, only: present_and_true
   881  
   882      ! 宣言文 ; Declaration statements
   883      !
   884      implicit none
   885      real(DP), intent(in):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   886                                ! $ u $ .     東西風速. Eastward wind
   887      real(DP), intent(in):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   888                                ! $ v $ .     南北風速. Northward wind
   889      real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   890                                ! $ T $ .     温度. Temperature
   891      real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   892                                ! $ q $ .     比湿. Specific humidity
   893      real(DP), intent(in):: xy_Ps    (0:imax-1, 1:jmax)
   894                                ! $ p_s $ .   地表面気圧. Surface pressure
   895  
   896      ! 作業変数
   897      ! Work variables
   898      !
   899      character(STRING):: date_str        ! 日時の年月日時分秒形式.
   900                                          ! Date with year-month-day hour:minute:second format
   901      integer          :: n
   902  
   903  
   904      ! 実行文 ; Executable statement
   905      !
   906      if ( .not. restart_file_opened ) call RestartFileOpen( flag_init_data = .true. )
   907  
   908      ! 初期値出力であることのチェック
   909      ! Check initial data output
   910      !
   911      if ( .not. flag_init_data_save ) then
   912        call MessageNotify( 'E', module_name, &
   913          & 'Now, restart data output mode.' )
   914      end if
   915  
   916      ! 時刻の設定
   917      ! Set time
   918      !
   919      call HistorySetTime( timed = TimeN, history = gthst_rst )
   920  
   921      ! "TimeN" を年月日時分秒表記にして "datetime" 変数へ出力
   922      ! Put "TimeN" on "datetime" variable with year-month-day hour:minute:second format
   923      !
   924      call DCCalDateInquire( &
   925        & date_str   = date_str, &   ! (out)
   926        & elapse_sec = TimeN, &      ! (in) optional
   927        & date       = InitialDate ) ! (in) optional
   928  
   929      call HistoryPut( 'datetime', date_str, &  ! (in)
   930        &              history = gthst_rst )    ! (inout) optional
   931  
   932      ! データ出力
   933      ! Data output
   934      !
   935      call HistoryPut( &
   936        & 'U', xyz_U, history = gthst_rst )       ! (in)
   937      call HistoryPut( &
   938        & 'V', xyz_V, history = gthst_rst )       ! (in)
   939      call HistoryPut( &
   940        & 'Temp', xyz_Temp, history = gthst_rst ) ! (in)
   941      do n = 1, ncmax
   942        call HistoryPut( &
   943          & a_QMixName(n), xyzf_QMix(:,:,:,n), history = gthst_rst ) ! (in)
   944      end do
   945      call HistoryPut( &
   946        & 'Ps', xy_Ps, history = gthst_rst )      ! (in)
   947  
   948  
   949    end subroutine InitialFileOutput
   950  
   951    !--------------------------------------------------------------------------------------
   952  
   953    subroutine RestartFileClose
   954      !
   955      ! リスタートデータファイル出力の終了処理を行います.
   956      !
   957      ! Terminate restart data files output.
   958  
   959      ! モジュール引用 ; USE statements
   960      !
   961  
   962      ! gtool4 データ出力
   963      ! Gtool4 data output
   964      !
   965      use gtool_history, only: HistoryClose
   966  
   967      ! 宣言文 ; Declaration statements
   968      !
   969      implicit none
   970  
   971      ! 作業変数
   972      ! Work variables
   973      !
   974  
   975      ! 実行文 ; Executable statement
   976      !
   977      if ( .not. restart_file_opened ) return
   978  
   979      call HistoryClose( history = gthst_rst ) ! (inout)
   980  
   981      restart_file_opened = .false.
   982    end subroutine RestartFileClose
   983  
   984    !--------------------------------------------------------------------------------------
   985  
   986    subroutine RestartFileGet( &
   987      & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, & ! (out)
   988      & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, & ! (out)
   989      & flag_initial                                   & ! (out) optional
   990      & )
   991      !
   992      ! リスタート/初期値データの入力を行います.
   993      ! リスタート/初期値データファイルが存在しない場合には,
   994      ! initial_data モジュールを用いて, 初期値生成を行います.
   995      !
   996      ! Input restart/initial data.
   997      ! If a restart/initial data file is not exist,
   998      ! initial data is created by "initial_data".
   999  
  1000  
  1001      ! モジュール引用 ; USE statements
  1002      !
  1003  
  1004      ! 時刻管理
  1005      ! Time control
  1006      !
  1007      use timeset, only: &
  1008        & DelTime               ! $ \Delta t $ [s]
  1009  
  1010      ! 初期値データ (リスタートデータ) 提供
  1011      ! Prepare initial data (restart data)
  1012      !
  1013      use initial_data, only: SetInitData
  1014  
  1015      ! 時刻管理
  1016      ! Time control
  1017      !
  1018      use timeset, only: TimesetSetInitialDate, TimesetSetTimeN, TimesetSetCalendar, &
  1019        & RestartTime           ! リスタート開始時刻.
  1020                                ! Restart time of calculation
  1021  
  1022      ! gtool4 データ入力
  1023      ! Gtool4 data input
  1024      !
  1025      use gtool_history, only: HistoryGet, HistoryGetAttr
  1026  
  1027      ! 文字列操作
  1028      ! Character handling
  1029      !
  1030      use dc_string, only: toChar
  1031  
  1032      ! ファイル入出力補助
  1033      ! File I/O support
  1034      !
  1035      use dc_iounit, only: FileOpen
  1036  
  1037  
  1038      ! 宣言文 ; Declaration statements
  1039      !
  1040      implicit none
  1041      real(DP), intent(out):: xyz_UB      (0:imax-1, 1:jmax, 1:kmax)
  1042                                ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
  1043      real(DP), intent(out):: xyz_VB      (0:imax-1, 1:jmax, 1:kmax)
  1044                                ! $ v (t-\Delta t) $ .   南北風速. Northward wind
  1045      real(DP), intent(out):: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
  1046                                ! $ T (t-\Delta t) $ .   温度. Temperature
  1047      real(DP), intent(out):: xyzf_QMixB  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1048                                ! $ q (t-\Delta t) $ .   比湿. Specific humidity
  1049      real(DP), intent(out):: xy_PsB      (0:imax-1, 1:jmax)
  1050                                ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
  1051      real(DP), intent(out):: xyz_UN      (0:imax-1, 1:jmax, 1:kmax)
  1052                                ! $ u (t) $ .     東西風速. Eastward wind
  1053      real(DP), intent(out):: xyz_VN      (0:imax-1, 1:jmax, 1:kmax)
  1054                                ! $ v (t) $ .     南北風速. Northward wind
  1055      real(DP), intent(out):: xyz_TempN   (0:imax-1, 1:jmax, 1:kmax)
  1056                                ! $ T (t) $ .     温度. Temperature
  1057      real(DP), intent(out):: xyzf_QMixN  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1058                                ! $ q (t) $ .     比湿. Specific humidity
  1059      real(DP), intent(out):: xy_PsN      (0:imax-1, 1:jmax)
  1060                                ! $ p_s (t) $ .   地表面気圧. Surface pressure
  1061      logical , intent(out), optional:: flag_initial
  1062                                ! リスタートデータを読み込む場合には,
  1063                                ! .false. が, 初期値データを読み込む場合には
  1064                                ! .true. が返ります.
  1065                                !
  1066                                ! If restart data is loaded, .false. is returned.
  1067                                ! On the other hand, if initial data is loaded,
  1068                                ! .true. is returned.
  1069  
  1070      ! 作業変数
  1071      ! Work variables
  1072      !
  1073      integer:: flag_rst        ! 初期値データから入力時は 0,
  1074                                ! リスタートデータ入力時は 1.
  1075                                !
  1076                                ! If initial data is input, this value is 0.
  1077                                ! If restart data is input, this value is 1.
  1078  
  1079      character(STRING):: time_range
  1080                                ! 時刻の指定.
  1081                                ! Specification of time
  1082      character(TOKEN):: dummy_str
  1083                                ! 入力チェック用のダミー変数
  1084                                ! Dummy variable for check of input
  1085      logical:: get_err
  1086                                ! 入力時のエラーフラグ.
  1087                                ! Error flag for input
  1088      real(DP):: returned_time
  1089                                ! 入力データの時刻.
  1090                                ! Time of input data.
  1091      logical:: flag_time_exist
  1092                                ! 入力データの時刻用のフラグ.
  1093                                ! Flag for time of input data.
  1094  
  1095      integer:: origin_year, origin_month, origin_day, origin_hour, origin_min
  1096                                ! 計算開始の年月日時分.
  1097      real(DP):: origin_sec
  1098                                ! 計算開始の秒.
  1099      character(TOKEN):: cal_type
  1100                                ! 暦のタイプ.
  1101      integer:: month_in_year, hour_in_day, min_in_hour
  1102      integer, pointer:: day_in_month_ptr(:) => null()
  1103      real(DP):: sec_in_min
  1104                                ! 暦の詳細情報
  1105      real(DP):: rst_time
  1106                                ! リスタートデータファイルから得られる時刻変数
  1107                                ! Time variable from a restart data file
  1108  
  1109      logical:: flag_mpi_init
  1110  
  1111      integer :: n
  1112  
  1113  
  1114      ! 実行文 ; Executable statement
  1115      !
  1116  
  1117      if ( .not. restart_file_io_inited ) then
  1118        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1119      end if
  1120  
  1121      ! データを initial_data モジュールから取得
  1122      ! Data is input from "initial_data" module
  1123      !
  1124      if ( trim(InputFile) == '' ) then
  1125        call SetInitData( &
  1126          & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap), xy_PsB )   ! (out)
  1127  
  1128        ! The variables below are initialized here, temporarily.
  1129        !
  1130        xyzf_QMixB(:,:,:,1:IndexH2OVap-1)     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t628 = 1, (indexh2ovap - 1)*kmax*jmax*imax                     
     .           xyzf_qmixb(t628-1,1,1,1) = 0.0000000000000000e+000             
     .        enddo                                                             
  1131        xyzf_QMixB(:,:,:,IndexH2OVap+1:ncmax) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t640 = 1, (ncmax - indexh2ovap)*kmax*jmax*imax                 
     .           xyzf_qmixb(t640-1,1,1,1+indexh2ovap) = 0.0000000000000000e+000 
     .        enddo                                                             
  1132  
  1133        call MessageNotify( 'M', module_name, &
  1134          & 'Initial data (not restart data) is input ' // &
  1135          & 'from a module "initial_data". ' // &
  1136          & '*B (t-dt) and *N (t) are same.' )
  1137  
  1138        xyz_UN     = xyz_UB
     .        if (xyz_un.DSC.U2 .gt. 0) then                                    
     .           j1 = and(xyz_un.DSC.U2,3)                                      
     .  !cdir    nodep                                                          
     .           do t654 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t656 = 1, xyz_un.DSC.U1 + 1                              
     .                 xyz_un(t656-1,t654,t652+1) = xyz_ub(t656-1,t654,t652+1)  
     .                 xyz_vn(t656-1,t654,t652+1) = xyz_vb(t656-1,t654,t652+1)  
     .                 xyz_tempn(t656-1,t654,t652+1) = xyz_tempb(t656-1,t654,   
     .       1            t652+1)                                               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t654 = j1 + 1, xyz_un.DSC.U2, 4                             
     .  !cdir       nodep                                                       
     .              do t656 = 1, xyz_un.DSC.U1 + 1                              
     .                 xyz_un(t656-1,t654,t652+1) = xyz_ub(t656-1,t654,t652+1)  
     .                 xyz_un(t656-1,t654+1,t652+1) = xyz_ub(t656-1,t654+1,t652+
     .       1            1)                                                    
     .                 xyz_un(t656-1,t654+2,t652+1) = xyz_ub(t656-1,t654+2,t652+
     .       1            1)                                                    
     .                 xyz_un(t656-1,t654+3,t652+1) = xyz_ub(t656-1,t654+3,t652+
     .       1            1)                                                    
     .                 xyz_vn(t656-1,t654,t652+1) = xyz_vb(t656-1,t654,t652+1)  
     .                 xyz_vn(t656-1,t654+1,t652+1) = xyz_vb(t656-1,t654+1,t652+
     .       1            1)                                                    
     .                 xyz_vn(t656-1,t654+2,t652+1) = xyz_vb(t656-1,t654+2,t652+
     .       1            1)                                                    
     .                 xyz_vn(t656-1,t654+3,t652+1) = xyz_vb(t656-1,t654+3,t652+
     .       1            1)                                                    
     .                 xyz_tempn(t656-1,t654,t652+1) = xyz_tempb(t656-1,t654,   
     .       1            t652+1)                                               
     .                 xyz_tempn(t656-1,t654+1,t652+1) = xyz_tempb(t656-1,t654+1
     .       1            ,t652+1)                                              
     .                 xyz_tempn(t656-1,t654+2,t652+1) = xyz_tempb(t656-1,t654+2
     .       1            ,t652+1)                                              
     .                 xyz_tempn(t656-1,t654+3,t652+1) = xyz_tempb(t656-1,t654+3
     .       1            ,t652+1)                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1139        xyz_VN     = xyz_VB
  1140        xyz_TempN  = xyz_TempB
  1141        xyzf_QMixN = xyzf_QMixB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t676 = 1, ncmax*kmax*jmax*imax                                 
     .           xyzf_qmixn(t676-1,1,1,1) = xyzf_qmixb(t676-1,1,1,1)            
     .        enddo                                                             
  1142        xy_PsN     = xy_PsB
     .        if (xy_psn.DSC.U2 .gt. 0) then                                    
     .           j2 = and(xy_psn.DSC.U2,3)                                      
     .  !cdir    nodep                                                          
     .           do t692 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t694 = 1, xy_psn.DSC.U1 + 1                              
     .                 xy_psn(t694-1,t692) = xy_psb(t694-1,t692)                
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t692 = j2 + 1, xy_psn.DSC.U2, 4                             
     .  !cdir       nodep                                                       
     .              do t694 = 1, xy_psn.DSC.U1 + 1                              
     .                 xy_psn(t694-1,t692) = xy_psb(t694-1,t692)                
     .                 xy_psn(t694-1,t692+1) = xy_psb(t694-1,t692+1)            
     .                 xy_psn(t694-1,t692+2) = xy_psb(t694-1,t692+2)            
     .                 xy_psn(t694-1,t692+3) = xy_psb(t694-1,t692+3)            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1143  
  1144        if ( present(flag_initial) ) flag_initial = .true.
  1145  
  1146      ! データを InputFile から取得
  1147      ! Data is input from InputFile
  1148      !
  1149      else
  1150  
  1151  !!$      flag_mpi_init = .false.
  1152        flag_mpi_init = .true.
  1153  
  1154        ! ファイルの有無を確認
  1155        ! Conform an existence of an input file
  1156        !
  1157        call HistoryGetAttr( InputFile, 'lon', 'units', & ! (in)
  1158          & dummy_str, &                                  ! (out)
  1159          & flag_mpi_split = flag_mpi_init, &             ! (in) optional
  1160          & err = get_err )                               ! (out)
  1161  
  1162        if ( get_err ) then
  1163          call MessageNotify( 'E', module_name, &
  1164            & 'restart/initial data file "%c" is not found.', &
  1165            & c1 = trim(InputFile) )
  1166        end if
  1167  
  1168        ! 時刻情報の取得
  1169        ! Get time information
  1170        !
  1171        time_range = 'time=' // toChar( RestartTime )
  1172  
  1173        ! 初期値データかリスタートデータかのチェック
  1174        ! Check whether input data is initial data or restart data
  1175        !
  1176        call HistoryGet( &
  1177          & InputFile, 'flag_rst', &                ! (in)
  1178          & flag_rst, &                             ! (out)
  1179          & err = get_err, &                        ! (out) optional
  1180          & quiet = .true., &                       ! (in) optional
  1181          & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1182  
  1183        if ( get_err ) then
  1184          ! flag_rst 変数が読み込めない場合、とりあえず初期値データと見なす
  1185          !
  1186          flag_rst = 0
  1187          if ( present(flag_initial) ) flag_initial = .true.
  1188  
  1189        else if ( flag_rst == 0 ) then
  1190          if ( present(flag_initial) ) flag_initial = .true.
  1191  
  1192        else
  1193          if ( present(flag_initial) ) flag_initial = .false.
  1194        end if
  1195  
  1196        ! 物理量データの有無のチェック ("U", "UB" のみ)
  1197        ! Check existence or nonexistence of physical data (only "U", "UB")
  1198        !
  1199        if ( flag_rst == 0 ) then
  1200          call HistoryGet( &
  1201            & InputFile, 'U', &                       ! (in)
  1202            & xyz_UB, &                               ! (out)
  1203            & err = get_err, &                        ! (out) optional
  1204            & quiet = .true., &                       ! (in) optional
  1205            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1206  
  1207          if ( get_err ) then
  1208            call MessageNotify( 'E', module_name, &
  1209              & 'One of necessary variables "U" for start of calculation ' // &
  1210              & 'cannot be read from "%c"', &
  1211              & c1 = trim(InputFile) )
  1212          end if
  1213  
  1214        else
  1215  
  1216          call HistoryGet( &
  1217            & InputFile, 'UB', &                      ! (in)
  1218            & xyz_UB, &                               ! (out)
  1219            & range = time_range, &                   ! (in) optional
  1220            & quiet = .true., &                       ! (in) optional
  1221            & err = get_err, &                        ! (out) optional
  1222            & returned_time = returned_time, &        ! (out) optional
  1223            & flag_time_exist = flag_time_exist, &    ! (out) optional
  1224            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1225  
  1226          if ( get_err ) then
  1227            call MessageNotify( 'E', module_name, &
  1228              & 'One of necessary variables "UB" for restart ' // &
  1229              & 'cannot be read from "%c"', &
  1230              & c1 = trim(InputFile) )
  1231          end if
  1232        end if
  1233  
  1234        ! 初期値データを入力する場合、経過時間を 0 に設定
  1235        ! Set 0 to elapsed time, when initial data is input
  1236        !
  1237        if ( flag_rst == 0 ) then
  1238          call TimesetSetTimeN( 0.0_DP )
  1239        end if
  1240  
  1241        ! 暦、開始日時、経過時刻の読み込みと上書き設定
  1242        ! Input and overwrite calendar, start date, and elapsed time
  1243        !
  1244        if ( flag_rst /= 0 ) then
  1245  
  1246          ! 暦の読み込み
  1247          ! Input calendar
  1248          !
  1249          call HistoryGetAttr( &
  1250            & InputFile, 'time', 'calendar', &          ! (in)
  1251            & cal_type, &                               ! (out)
  1252            & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1253  
  1254          call HistoryGetAttr( &
  1255            & InputFile, 'time', 'month_in_year', &     ! (in)
  1256            & month_in_year, &                          ! (out)
  1257            & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1258  
  1259          allocate( day_in_month_ptr(month_in_year) )
  1260          call HistoryGetAttr( &
  1261            & InputFile, 'time', 'day_in_month', &      ! (in)
  1262            & day_in_month_ptr, &                       ! (out)
  1263            & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1264  
  1265          call HistoryGetAttr( &
  1266            & InputFile, 'time', 'hour_in_day', &       ! (in)
  1267            & hour_in_day, &                            ! (out)
  1268            & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1269  
  1270          call HistoryGetAttr( &
  1271            & InputFile, 'time', 'min_in_hour', &       ! (in)
  1272            & min_in_hour, &                            ! (out)
  1273            & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1274  
  1275          call HistoryGetAttr( &
  1276            & InputFile, 'time', 'sec_in_min', &        ! (in)
  1277            & sec_in_min, &                             ! (out)
  1278            & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1279  
  1280          ! 暦の上書き設定
  1281          ! Overwrite calendar
  1282          !
  1283          call TimesetSetCalendar( cal_type, &       ! (in)
  1284            & month_in_year, day_in_month_ptr, &     ! (in)
  1285            & hour_in_day, min_in_hour, sec_in_min ) ! (in)
  1286  
  1287          deallocate( day_in_month_ptr )
  1288  
  1289          ! 開始日時の読み込み
  1290          ! Input start date
  1291          !
  1292          call HistoryGetAttr( &
  1293            & InputFile, 'time', 'origin_year', &     ! (in)
  1294            & origin_year, &                          ! (out)
  1295            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1296  
  1297          call HistoryGetAttr( &
  1298            & InputFile, 'time', 'origin_month', &    ! (in)
  1299            & origin_month, &                         ! (out)
  1300            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1301  
  1302          call HistoryGetAttr( &
  1303            & InputFile, 'time', 'origin_day', &      ! (in)
  1304            & origin_day, &                           ! (out)
  1305            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1306  
  1307          call HistoryGetAttr( &
  1308            & InputFile, 'time', 'origin_hour', &     ! (in)
  1309            & origin_hour, &                          ! (out)
  1310            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1311  
  1312          call HistoryGetAttr( &
  1313            & InputFile, 'time', 'origin_min', &      ! (in)
  1314            & origin_min, &                           ! (out)
  1315            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1316  
  1317          call HistoryGetAttr( &
  1318            & InputFile, 'time', 'origin_sec', &      ! (in)
  1319            & origin_sec, &                           ! (out)
  1320            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1321  
  1322          ! 開始日時の上書き設定
  1323          ! Overwrite start date
  1324          !
  1325          call TimesetSetInitialDate( &
  1326            & origin_year, origin_month, origin_day, & ! (in)
  1327            & origin_hour, origin_min,   origin_sec )  ! (in)
  1328  
  1329          ! 経過時間の読み込み
  1330          ! Input elapsed time
  1331          !
  1332          call HistoryGet( &
  1333            & InputFile, 'time', range = time_range, &  ! (in)
  1334            & array = rst_time, &                       ! (out)
  1335            & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1336  
  1337          call MessageNotify( 'M', module_name, &
  1338            & '  Specified RestartTime from a NAMELIST file            = <%f>, ', &
  1339            & d = (/ RestartTime /) )
  1340          call MessageNotify( 'M', module_name, &
  1341            & '  Actual initial value of TimeN  from a restart file  = <%f>', &
  1342            & d = (/ rst_time /) )
  1343  
  1344          ! 経過時間の上書き設定
  1345          ! Overwrite elapsed time
  1346          !
  1347          call TimesetSetTimeN( rst_time )
  1348  
  1349        end if
  1350  
  1351        ! データ入力
  1352        ! Data input
  1353        !
  1354        if ( flag_rst == 0 ) then
  1355          call HistoryGet( &
  1356            & InputFile, 'U', &                 ! (in)
  1357            & array = xyz_UB, &                 ! (out)
  1358            & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1359          call HistoryGet( &
  1360            & InputFile, 'V', &                 ! (in)
  1361            & array = xyz_VB, &                 ! (out)
  1362            & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1363          call HistoryGet( &
  1364            & InputFile, 'Temp', &              ! (in)
  1365            & array = xyz_TempB, &              ! (out)
  1366            & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1367          do n = 1, ncmax
  1368            call HistoryGet(                           &
  1369              & InputFile, trim(a_QMixName(n)),        &              ! (in)
  1370              & array = xyzf_QMixB(:,:,:,n),           &              ! (out)
  1371              & flag_mpi_split = flag_mpi_init         &              ! (in) optional
  1372              & )
  1373          end do
  1374          call HistoryGet( &
  1375            & InputFile, 'Ps', &                ! (in)
  1376            & array = xy_PsB, &                 ! (out)
  1377            & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1378  
  1379          call MessageNotify( 'M', module_name, &
  1380            & 'Initial data (not restart data) is input ' // &
  1381            & 'from a data file "%c". ' // &
  1382            & '*B (t-dt) and *N (t) are same.', &
  1383            & c1 = trim(InputFile) )
  1384  
  1385          xyz_UN     = xyz_UB
     .        if (xyz_un.DSC.U2 .gt. 0) then                                    
     .           j3 = and(xyz_un.DSC.U2,3)                                      
     .  !cdir    nodep                                                          
     .           do t582 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t584 = 1, xyz_un.DSC.U1 + 1                              
     .                 xyz_un(t584-1,t582,t580+1) = xyz_ub(t584-1,t582,t580+1)  
     .                 xyz_vn(t584-1,t582,t580+1) = xyz_vb(t584-1,t582,t580+1)  
     .                 xyz_tempn(t584-1,t582,t580+1) = xyz_tempb(t584-1,t582,   
     .       1            t580+1)                                               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t582 = j3 + 1, xyz_un.DSC.U2, 4                             
     .  !cdir       nodep                                                       
     .              do t584 = 1, xyz_un.DSC.U1 + 1                              
     .                 xyz_un(t584-1,t582,t580+1) = xyz_ub(t584-1,t582,t580+1)  
     .                 xyz_un(t584-1,t582+1,t580+1) = xyz_ub(t584-1,t582+1,t580+
     .       1            1)                                                    
     .                 xyz_un(t584-1,t582+2,t580+1) = xyz_ub(t584-1,t582+2,t580+
     .       1            1)                                                    
     .                 xyz_un(t584-1,t582+3,t580+1) = xyz_ub(t584-1,t582+3,t580+
     .       1            1)                                                    
     .                 xyz_vn(t584-1,t582,t580+1) = xyz_vb(t584-1,t582,t580+1)  
     .                 xyz_vn(t584-1,t582+1,t580+1) = xyz_vb(t584-1,t582+1,t580+
     .       1            1)                                                    
     .                 xyz_vn(t584-1,t582+2,t580+1) = xyz_vb(t584-1,t582+2,t580+
     .       1            1)                                                    
     .                 xyz_vn(t584-1,t582+3,t580+1) = xyz_vb(t584-1,t582+3,t580+
     .       1            1)                                                    
     .                 xyz_tempn(t584-1,t582,t580+1) = xyz_tempb(t584-1,t582,   
     .       1            t580+1)                                               
     .                 xyz_tempn(t584-1,t582+1,t580+1) = xyz_tempb(t584-1,t582+1
     .       1            ,t580+1)                                              
     .                 xyz_tempn(t584-1,t582+2,t580+1) = xyz_tempb(t584-1,t582+2
     .       1            ,t580+1)                                              
     .                 xyz_tempn(t584-1,t582+3,t580+1) = xyz_tempb(t584-1,t582+3
     .       1            ,t580+1)                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1386          xyz_VN     = xyz_VB
  1387          xyz_TempN  = xyz_TempB
  1388          xyzf_QMixN = xyzf_QMixB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t604 = 1, ncmax*kmax*jmax*imax                                 
     .           xyzf_qmixn(t604-1,1,1,1) = xyzf_qmixb(t604-1,1,1,1)            
     .        enddo                                                             
  1389          xy_PsN     = xy_PsB
     .        if (xy_psn.DSC.U2 .gt. 0) then                                    
     .           j4 = and(xy_psn.DSC.U2,3)                                      
     .  !cdir    nodep                                                          
     .           do t620 = 1, j4                                                
     .  !cdir       nodep                                                       
     .              do t622 = 1, xy_psn.DSC.U1 + 2 - min0(1,xy_psn.DSC.U1 + 1)  
     .                 xy_psn(t622-1,t620) = xy_psb(t622-1,t620)                
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t620 = j4 + 1, xy_psn.DSC.U2, 4                             
     .  !cdir       nodep                                                       
     .              do t622 = 1, xy_psn.DSC.U1 + 2 - min0(1,xy_psn.DSC.U1 + 1)  
     .                 xy_psn(t622-1,t620) = xy_psb(t622-1,t620)                
     .                 xy_psn(t622-1,t620+1) = xy_psb(t622-1,t620+1)            
     .                 xy_psn(t622-1,t620+2) = xy_psb(t622-1,t620+2)            
     .                 xy_psn(t622-1,t620+3) = xy_psb(t622-1,t620+3)            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10031                                                        
  1390  
  1391        else
  1392          call HistoryGet( &
  1393            & InputFile, 'UB', range = time_range, &  ! (in)
  1394            & array = xyz_UB, &                       ! (out)
  1395            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1396          call HistoryGet( &
  1397            & InputFile, 'VB', range = time_range, &  ! (in)
  1398            & array = xyz_VB, &                       ! (out)
  1399            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1400          call HistoryGet( &
  1401            & InputFile, 'TempB', range = time_range, &  ! (in)
  1402            & array = xyz_TempB, &                       ! (out)
  1403            & flag_mpi_split = flag_mpi_init )           ! (in) optional
  1404          do n = 1, ncmax
  1405            call HistoryGet(                                             &
  1406              & InputFile, trim(a_QMixName(n))//'B', range = time_range, & ! (in)
  1407              & array = xyzf_QMixB(:,:,:,n),                             & ! (out)
  1408              & flag_mpi_split = flag_mpi_init                           & ! (in) optional
  1409              & )
  1410          end do
  1411          call HistoryGet( &
  1412            & InputFile, 'PsB', range = time_range, &  ! (in)
  1413            & array = xy_PsB, &                        ! (out)
  1414            & flag_mpi_split = flag_mpi_init )         ! (in) optional
  1415  
  1416          call HistoryGet( &
  1417            & InputFile, 'UN', range = time_range, &  ! (in)
  1418            & array = xyz_UN, &                       ! (out)
  1419            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1420          call HistoryGet( &
  1421            & InputFile, 'VN', range = time_range, &  ! (in)
  1422            & array = xyz_VN, &                       ! (out)
  1423            & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1424          call HistoryGet( &
  1425            & InputFile, 'TempN', range = time_range, &  ! (in)
  1426            & array = xyz_TempN, &                       ! (out)
  1427            & flag_mpi_split = flag_mpi_init )           ! (in) optional
  1428          do n = 1, ncmax
  1429            call HistoryGet(                                             &
  1430              & InputFile, trim(a_QMixName(n))//'N', range = time_range, & ! (in)
  1431              & array = xyzf_QMixN(:,:,:,n),                             & ! (out)
  1432              & flag_mpi_split = flag_mpi_init                           & ! (in) optional
  1433              & )
  1434          end do
  1435          call HistoryGet( &
  1436            & InputFile, 'PsN', range = time_range, &  ! (in)
  1437            & array = xy_PsN, &                        ! (out)
  1438            & flag_mpi_split = flag_mpi_init )         ! (in) optional
  1439  
  1440          call MessageNotify( 'M', module_name, &
  1441            & 'Restart data (not initial data) is input ' // &
  1442            & 'from a data file "%c". ', &
  1443            & c1 = trim(InputFile) )
  1444        end if
  1445  
  1446      end if
  1447  
  1448    end subroutine RestartFileGet
  1449  
  1450    !--------------------------------------------------------------------------------------
  1451  
  1452    subroutine RestartFileInit
  1453      !
  1454      ! restart_file_io モジュールの初期化を行います.
  1455      ! NAMELIST#restart_file_io_nml の読み込みはこの手続きで行われます.
  1456      !
  1457      ! "restart_file_io" module is initialized.
  1458      ! "NAMELIST#restart_file_io_nml" is loaded in this procedure.
  1459      !
  1460  
  1461      ! モジュール引用 ; USE statements
  1462      !
  1463  
  1464      ! 時刻管理
  1465      ! Time control
  1466      !
  1467      use timeset, only: &
  1468        & RestartTime           ! リスタート開始時刻.
  1469                                ! Restart time of calculation
  1470  
  1471      ! NAMELIST ファイル入力に関するユーティリティ
  1472      ! Utilities for NAMELIST file input
  1473      !
  1474      use namelist_util, only: namelist_filename, NmlutilMsg
  1475  
  1476      ! 暦と日時の取り扱い
  1477      ! Calendar and Date handler
  1478      !
  1479      use dc_calendar, only: DCCalConvertByUnit
  1480  
  1481      ! ファイル入出力補助
  1482      ! File I/O support
  1483      !
  1484      use dc_iounit, only: FileOpen
  1485  
  1486      ! 種別型パラメタ
  1487      ! Kind type parameter
  1488      !
  1489      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1490  
  1491      ! 初期値データ (リスタートデータ) 提供
  1492      ! Prepare initial data (restart data)
  1493      !
  1494      use initial_data, only: InitDataInit
  1495  
  1496  
  1497      ! 宣言文 ; Declaration statements
  1498      !
  1499      implicit none
  1500  
  1501      ! 作業変数
  1502      ! Work variables
  1503      !
  1504      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1505                                ! Unit number for NAMELIST file open
  1506      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1507                                ! IOSTAT of NAMELIST read
  1508  
  1509      ! NAMELIST 変数群
  1510      ! NAMELIST group name
  1511      !
  1512      namelist /restart_file_io_nml/ &
  1513        & InputFile, &
  1514        & OutputFile, &
  1515        & IntValue, IntUnit
  1516            !
  1517            ! デフォルト値については初期化手続 "restart_file_io#RestartFileInit"
  1518            ! のソースコードを参照のこと.
  1519            !
  1520            ! Refer to source codes in the initialization procedure
  1521            ! "restart_file_io#RestartFileInit" for the default values.
  1522            !
  1523  
  1524  
  1525      ! 実行文 ; Executable statement
  1526      !
  1527  
  1528      if ( restart_file_io_inited ) return
  1529  
  1530  
  1531      ! デフォルト値の設定
  1532      ! Default values settings
  1533      !
  1534      InputFile  = ''
  1535      if ( .not. flag_init_data_save ) then
  1536        OutputFile = 'rst.nc'
  1537      else
  1538        OutputFile = 'init.nc'
  1539      end if
  1540      IntValue   = 365.0d0
  1541      IntUnit    = 'day'
  1542  
  1543      ! NAMELIST の読み込み
  1544      ! NAMELIST is input
  1545      !
  1546      if ( trim(namelist_filename) /= '' ) then
  1547        call FileOpen( unit_nml, &          ! (out)
  1548          & namelist_filename, mode = 'r' ) ! (in)
  1549  
  1550        rewind( unit_nml )
  1551        read( unit_nml, &         ! (in)
  1552          & nml = restart_file_io_nml, &  ! (out)
  1553          & iostat = iostat_nml ) ! (out)
  1554        close( unit_nml )
  1555  
  1556        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1557        if ( iostat_nml == 0 ) write( STDOUT, nml = restart_file_io_nml )
  1558      end if
  1559  
  1560      ! 出力時間間隔の設定
  1561      ! Configure time interval of output
  1562      !
  1563      IntTime = DCCalConvertByUnit( IntValue, IntUnit, 'sec' ) ! (in)
  1564      PrevOutputTime = RestartTime
  1565  
  1566      ! フラグの初期化
  1567      ! Initialize flag
  1568      !
  1569      flag_output_end = .false.
  1570  
  1571  
  1572      ! Initialization of modules used in this module
  1573  
  1574      ! 初期値データ (リスタートデータ) 提供
  1575      ! Prepare initial data (restart data)
  1576      !
  1577      call InitDataInit
  1578  
  1579  
  1580      ! 印字 ; Print
  1581      !
  1582      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1583      call MessageNotify( 'M', module_name, 'Input:: ' )
  1584      if ( trim(InputFile) /= '' ) then
  1585        call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
  1586      else
  1587        call MessageNotify( 'M', module_name, '  InputFile  = <Non>' )
  1588        call MessageNotify( 'M', module_name, '  ** Initial data is generated in "initial_data" module' )
  1589      end if
  1590      call MessageNotify( 'M', module_name, 'Output:: ' )
  1591      call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
  1592      call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
  1593      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1594  
  1595      restart_file_io_inited = .true.
  1596  
  1597    end subroutine RestartFileInit
  1598  
  1599    !--------------------------------------------------------------------------------------
  1600  
  1601  end module restart_file_io
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:32 2016
FILE NAME: restart_file_io.f90
PROGRAM NAME: restart_file_io
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != リスタートデータ, 初期値データ入出力
     2:             !
     3:             != Restart data, initial data input/output
     4:             !
     5:             ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: restart_file_io.f90,v 1.26 2013/09/30 03:03:42 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module restart_file_io
    13:               !
    14:               != リスタートデータ, 初期値データ入出力
    15:               !
    16:               != Restart data, initial data input/output
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! リスタートデータもしくは初期値データの入出力を行います. 
    21:               ! 入力ファイル, 出力ファイル, データの出力の間隔は
    22:               ! NAMELIST#restart_file_io_nml で設定します. 
    23:               !
    24:               ! リスタートデータの入力ファイルが指定されない場合, 
    25:               ! initial_data モジュールで生成された初期値データを取得します. 
    26:               !
    27:               ! Restart data or initial data is input/output. 
    28:               ! Settings of input file, output file, and interval of data output 
    29:               ! is configured by "NAMELIST#restart_file_io_nml". 
    30:               !
    31:               ! If input file of restart data is not set, 
    32:               ! initial data is generated in "initial_data" module, and 
    33:               ! obtained data from the module. 
    34:               !
    35:               !== Procedures List
    36:               !
    37:               ! RestartFileOpen   :: リスタート/初期値ファイルのオープン
    38:               ! RestartFileOutput :: リスタート/初期値ファイルへのデータ出力
    39:               ! InitialFileOutput :: 初期値ファイルへのデータ出力
    40:               ! RestartFileClose  :: リスタート/初期値ファイルのクローズ
    41:               ! RestartFileGet    :: リスタート/初期値ファイルの入力
    42:               ! ------------      :: ------------
    43:               ! RestartFileOpen   :: Open restart/initial file
    44:               ! RestartFileOutput :: Data output to restart/initial file
    45:               ! InitialFileOutput :: Data output to initial file
    46:               ! RestartFileClose  :: Close restart/initial file
    47:               ! RestartFileGet    :: Input restart/initial file
    48:               !
    49:               !== NAMELIST
    50:               !
    51:               ! NAMELIST#restart_file_io_nml
    52:               !
    53:             
    54:               ! モジュール引用 ; USE statements
    55:               !
    56:             
    57:               ! 格子点設定
    58:               ! Grid points settings
    59:               !
    60:               use gridset, only: imax, & ! 経度格子点数. 
    61:                                          ! Number of grid points in longitude
    62:                 &                jmax, & ! 緯度格子点数. 
    63:                                          ! Number of grid points in latitude
    64:                 &                kmax    ! 鉛直層数. 
    65:                                          ! Number of vertical level
    66:             
    67:               ! 組成に関わる配列の設定
    68:               ! Settings of array for atmospheric composition
    69:               !
    70:               use composition, only: &
    71:                 &                    ncmax, &
    72:                                           ! 成分の数
    73:                                           ! Number of composition
    74:                 &                    a_QMixName, &
    75:                                           ! 成分の変数名
    76:                                           ! Name of variables for composition
    77:                 &                    a_QMixLongName, &
    78:                                           ! 成分の長い変数名
    79:                                           ! Long name of variables for composition
    80:                 &                    IndexH2OVap
    81:                                           ! 水蒸気のインデックス
    82:                                           ! Index for water vapor
    83:             
    84:             
    85:               ! 種別型パラメタ
    86:               ! Kind type parameter
    87:               !
    88:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    89:                 &                 STRING, &  ! 文字列.       Strings. 
    90:                 &                 TOKEN      ! キーワード.   Keywords. 
    91:             
    92:               ! メッセージ出力
    93:               ! Message output
    94:               !
    95:               use dc_message, only: MessageNotify
    96:             
    97:               ! gtool4 データ出力
    98:               ! Gtool4 data output
    99:               !
   100:               use gtool_history, only: GT_HISTORY
   101:             
   102:             
   103:               ! 宣言文 ; Declaration statements
   104:               !
   105:               implicit none
   106:               private
   107:             
   108:               ! 公開手続き
   109:               ! Public procedure
   110:               !
   111:               public :: RestartFileInit
   112:               public :: RestartFileOpen, RestartFileClose, RestartFileOutPut, InitialFileOutput
   113:               public :: RestartFileGet
   114:             
   115:               ! 公開変数
   116:               ! Public variables
   117:               !
   118:               logical, save, public:: restart_file_io_inited = .false.
   119:                                           ! 初期設定フラグ. 
   120:                                           ! Initialization flag
   121:             
   122:               logical, save, public:: restart_file_opened = .false.
   123:                                           ! リスタートファイルのオープンに関するフラグ. 
   124:                                           ! Flag of restart file open
   125:             
   126:               character(STRING), save, public:: InputFile
   127:                                           ! 入力するリスタートデータのファイル名
   128:                                           ! Filename of input restart data
   129:             
   130:               character(STRING), save, public:: OutputFile
   131:                                           ! 出力するリスタートデータのファイル名
   132:                                           ! Filename of output restart data
   133:               real(DP), save, public:: IntValue
   134:                                           ! リスタートデータの出力間隔 (数値). 
   135:                                           ! Interval of restart data output (numerical value)
   136:               character(TOKEN), save, public:: IntUnit
   137:                                           ! リスタートデータの出力間隔 (単位). 
   138:                                           ! Interval of restart data output (unit)
   139:               real(DP), save, public:: IntTime
   140:                                           ! リスタートデータの出力間隔 [秒]. 
   141:                                           ! Interval of restart data output [sec]
   142:             
   143:               ! 非公開変数
   144:               ! Private variables
   145:               !
   146:               logical, save:: flag_init_data_save
   147:                                           ! 初期値データを作成する場合は, 
   148:                                           ! この引数に .true. を与えます. 
   149:                                           ! 
   150:                                           ! If initial data is created, 
   151:                                           ! give ".true." to this argument. 
   152:             
   153:               type(GT_HISTORY), save:: gthst_rst
   154:                                           ! リスタートデータ用 gtool_history#GT_HISTORY 変数
   155:                                           ! "gtool_history#GT_HISTORY" variable for restart data
   156:             
   157:               real(DP), save:: PrevOutputTime
   158:                                           ! 前回の出力時間. 
   159:                                           ! Previous output time
   160:               logical, save:: flag_output_end
   161:                                           ! 計算最終時刻の出力完了のフラグ. 
   162:                                           ! Flag for completion of output at the end time of calculation
   163:             
   164:               character(*), parameter:: module_name = 'restart_file_io'
   165:                                           ! モジュールの名称. 
   166:                                           ! Module name
   167:               character(*), parameter:: version = &
   168:                 & '$Name:  $' // &
   169:                 & '$Id: restart_file_io.f90,v 1.26 2013/09/30 03:03:42 yot Exp $'
   170:                                           ! モジュールのバージョン
   171:                                           ! Module version
   172:             
   173:             contains
   174:             
   175:               !--------------------------------------------------------------------------------------
   176:             
   177:               subroutine RestartFileOpen( flag_init_data )
   178:                 !
   179:                 ! リスタート/初期値ファイルをオープンします. 
   180:                 !
   181:                 ! A restart/initial data file is opened. 
   182:                 !
   183:             
   184:                 ! モジュール引用 ; USE statements
   185:                 !
   186:             
   187:                 ! 出力ファイルの基本情報
   188:                 ! Basic information for output files
   189:                 ! 
   190:                 use fileset, only: &
   191:                   & FileTitle, &
   192:                                           ! 出力データファイルの表題. 
   193:                                           ! Title of output data files
   194:                   & FileSource, &
   195:                                           ! データファイル作成の手段. 
   196:                                           ! Source of data file
   197:                   & FileInstitution
   198:                                           ! データファイルを最終的に変更した組織/個人. 
   199:                                           ! Institution or person that changes data files for the last time
   200:             
   201:                 ! 物理・数学定数設定
   202:                 ! Physical and mathematical constants settings
   203:                 !
   204:                 use constants0, only: &
   205:                   & PI                    ! $ \pi $.
   206:                                           ! 円周率. Circular constant
   207:             
   208:                 ! 座標データ設定
   209:                 ! Axes data settings
   210:                 !
   211:                 use axesset, only: &
   212:                   & x_Lon, &
   213:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   214:                   & x_Lon_Weight, &
   215:                                           ! $ \Delta \lambda $ [rad.] . 
   216:                                           ! 経度座標重み. 
   217:                                           ! Weight of longitude
   218:                   & y_Lat, &
   219:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   220:                   & y_Lat_Weight, &
   221:                                           ! $ \Delta \varphi $ [rad.] . 
   222:                                           ! 緯度座標重み. 
   223:                                           ! Weight of latitude
   224:                   & z_Sigma, &
   225:                                           ! $ \sigma $ レベル (整数). 
   226:                                           ! Full $ \sigma $ level
   227:                   & r_Sigma, &
   228:                                           ! $ \sigma $ レベル (半整数). 
   229:                                           ! Half $ \sigma $ level
   230:                   & z_DelSigma
   231:                                           ! $ \Delta \sigma $ (整数). 
   232:                                           ! $ \Delta \sigma $ (Full)
   233:             
   234:                 ! 時刻管理
   235:                 ! Time control
   236:                 !
   237:                 use timeset, only: &
   238:                   & DelTime, &            ! $ \Delta t $ [s]
   239:                   & RestartTime, &        ! リスタート開始時刻. 
   240:                                           ! Restart time of calculation
   241:                   & InitialDate           ! 計算開始日時. 
   242:                                           ! Start date of calculation
   243:             
   244:                 ! gtool4 データ出力
   245:                 ! Gtool4 data output
   246:                 !
   247:                 use gtool_history, only: HistoryCreate, HistoryAddVariable, &
   248:                   & HistoryPut, HistoryAddAttr
   249:             
   250:                 ! 暦と日時の取り扱い
   251:                 ! Calendar and Date handler
   252:                 !
   253:                 use dc_calendar, only: DCCalInquire, DCCalDateInquire
   254:             
   255:                 ! 文字列操作
   256:                 ! Character handling
   257:                 !
   258:                 use dc_string, only: CPrintf, LChar
   259:             
   260:                 ! 組み込み関数 PRESENT の拡張版関数
   261:                 ! Extended functions of intrinsic function "PRESENT"
   262:                 !
   263:                 use dc_present, only: present_and_true
   264:             
   265:                 ! 宣言文 ; Declaration statements
   266:                 !
   267:                 implicit none
   268:                 logical, intent(in), optional:: flag_init_data
   269:                                           ! 初期値データを作成する場合は, 
   270:                                           ! この引数に .true. を与えます. 
   271:                                           ! 
   272:                                           ! If initial data is created, 
   273:                                           ! give ".true." to this argument. 
   274:             
   275:                 ! 作業変数
   276:                 ! Work variables
   277:                 !
   278:                 character(STRING):: title_msg
   279:                                           ! 表題に付加するメッセージ. 
   280:                                           ! Message added to title
   281:                 real(DP):: origin_time
   282:                                           ! 計算開始時刻. 
   283:                                           ! Start time of calculation
   284:             
   285:                 integer:: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
   286:                                           ! 計算開始の年月日時分. 
   287:                 real(DP):: InitialSec
   288:                                           ! 計算開始の秒. 
   289:             
   290:                 character(TOKEN):: cal_type
   291:                                           ! 暦のタイプ. 
   292:                 integer:: month_in_year, hour_in_day, min_in_hour
   293:                 integer, pointer:: day_in_month_ptr(:) => null()
   294:                 real(DP):: sec_in_min
   295:                                           ! 暦の詳細情報
   296:             
   297:                 logical:: flag_mpi_init
   298:             
   299:                 integer :: n
   300:             
   301:             
   302:                 ! 実行文 ; Executable statement
   303:                 !
   304:             
   305:                 ! 初期化
   306:                 ! Initialization
   307:                 !
   308:                 flag_init_data_save = present_and_true( flag_init_data )
   309:             
   310:                 if ( .not. restart_file_io_inited ) then
   311:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   312:                 end if
   313:             
   314:                 if ( restart_file_opened ) return
   315:             
   316:                 ! 表題に付加するメッセージの設定
   317:                 ! Configure message added to title
   318:                 !
   319:                 if ( .not. flag_init_data_save ) then
   320:                   title_msg = ' restart data'
   321:                 else
   322:                   title_msg = ' initial data'
   323:                 end if
   324:             
   325:                 ! 時刻情報の取得
   326:                 ! Get time information
   327:                 !
   328:                 if ( .not. flag_init_data_save ) then
   329:                   origin_time = RestartTime + IntTime
   330:                 else
   331:                   origin_time = RestartTime
   332:                 end if
   333:             
   334:                 flag_mpi_init = .false.
   335:             
   336:                 ! リスタートファイルのオープン
   337:                 ! Open a restart file
   338:                 !
   339:                 call HistoryCreate( &
   340:                   &      file = OutputFile, &                                   ! (in)
   341:                   &     title = trim(FileTitle) // trim(title_msg), &           ! (in)
   342:                   &    source = FileSource, institution = FileInstitution, &    ! (in)
   343:                   &      dims = (/ 'lon    ', 'lat    ', 'sig    ', 'sigm   ', &
   344:                   &                'timestr', 'time   ' /), &                   ! (in)
   345:                   &  dimsizes = (/ imax, jmax, kmax, kmax + 1, TOKEN, 0 /), &   ! (in)
   346:                   & longnames = (/ 'longitude                             ', &
   347:                   &                'latitude                              ', &
   348:                   &                'sigma at layer midpoints              ', &
   349:                   &                'sigma at layer end-points (half level)', &
   350:                   &                'number of characters for datetime     ', &    ! (in)
   351:                   &                'time                                  ' /), & ! (in)
   352:                   &     units = (/ 'degrees_east ', 'degrees_north', &
   353:                   &                '1            ', '1            ', &
   354:                   &                '1            ',                  &
   355:                   &                'sec          ' /), &                           ! (in)
   356:                   & xtypes = (/'double', 'double', 'double', &
   357:                   &            'double', 'int   ', 'double'/), &                  ! (in)
   358:                   &        origind = origin_time, &       ! (in) optional
   359:                   &      intervald = IntTime, &           ! (in) optional
   360:             !!$      & flag_mpi_split = flag_mpi_init, &     ! (in) optional
   361:                   & flag_mpi_split = .true., &            ! (in) optional
   362:                   &        history = gthst_rst )          ! (out) optional
   363:             
   364:             
   365:                 ! ※ 元々再計算データかどうかのチェックのためのフラグとして
   366:                 !    作成したものであるため、下記 flag_rst 設定完了後 
   367:                 !    削除予定 (morikawa  2010/06/13)
   368:                 !
   369:                 ! $ \Delta t $ に関する情報を追加. 
   370:                 ! Add information about $ \Delta t $. 
   371:                 !
   372:             !!$    if ( .not. flag_init_data_save ) then
   373:             !!$      call HistoryAddVariable( &
   374:             !!$        & varname = 'deltime', &             ! (in)
   375:             !!$        & dims = (/''/), &                   ! (in)
   376:             !!$        & longname = 'delta time', &         ! (in)
   377:             !!$        & units = 'sec', xtype = 'double', & ! (in)
   378:             !!$        & history = gthst_rst )              ! (inout)
   379:             !!$      call HistoryPut( &
   380:             !!$        & varname = 'deltime', &            ! (in)
   381:             !!$        & array = (/ DelTime /), &          ! (in)
   382:             !!$        & history = gthst_rst )             ! (inout)
   383:             !!$    end if
   384:             
   385:                 ! 開始日時情報を "time" の属性として設定
   386:                 ! Set start date information as attributes of "time"
   387:                 !
   388:                 call DCCalDateInquire( &
   389:                   & InitialYear, InitialMonth, InitialDay, & ! (out)
   390:                   & InitialHour, InitialMin,   InitialSec, & ! (out)
   391:                   & date = InitialDate )               ! (in)
   392:             
   393:                 call HistoryAddAttr( &
   394:                   & 'time', attrname = 'origin', &     ! (in)
   395:                   & value = 'origin_year origin_month origin_day origin_hour origin_min origin_sec', &
   396:                                                        ! (in)
   397:                   & history = gthst_rst )              ! (inout)
   398:                 call HistoryAddAttr( &
   399:                   & 'time', attrname = 'origin_year', & ! (in)
   400:                   & value = InitialYear, &                ! (in)
   401:                   & history = gthst_rst )               ! (inout)
   402:                 call HistoryAddAttr( &
   403:                   & 'time', attrname = 'origin_month', & ! (in)
   404:                   & value = InitialMonth, &                ! (in)
   405:                   & history = gthst_rst )                ! (inout)
   406:                 call HistoryAddAttr( &
   407:                   & 'time', attrname = 'origin_day', &  ! (in)
   408:                   & value = InitialDay, &                 ! (in)
   409:                   & history = gthst_rst )               ! (inout)
   410:                 call HistoryAddAttr( &
   411:                   & 'time', attrname = 'origin_hour', &  ! (in)
   412:                   & value = InitialHour, &                 ! (in)
   413:                   & history = gthst_rst )                ! (inout)
   414:                 call HistoryAddAttr( &
   415:                   & 'time', attrname = 'origin_min', &  ! (in)
   416:                   & value = InitialMin, &                 ! (in)
   417:                   & history = gthst_rst )               ! (inout)
   418:                 call HistoryAddAttr( &
   419:                   & 'time', attrname = 'origin_sec', &  ! (in)
   420:                   & value = InitialSec, &                 ! (in)
   421:                   & history = gthst_rst )               ! (inout)
   422:             
   423:                 ! 暦情報を "time" の属性として設定
   424:                 ! Set calendar information as attributes of "time"
   425:                 !
   426:                 call DCCalInquire( &
   427:                   & cal_type         = cal_type, &          ! (out)
   428:                   & month_in_year    = month_in_year, &     ! (out)
   429:                   & day_in_month_ptr = day_in_month_ptr , & ! (out)
   430:                   & hour_in_day      = hour_in_day  , &     ! (out)
   431:                   & min_in_hour      = min_in_hour  , &     ! (out)
   432:                   & sec_in_min       = sec_in_min )         ! (out)
   433:             
   434:                 call HistoryAddAttr( &
   435:                   & 'time', attrname = 'calendar', & ! (in)
   436:                   & value = cal_type, &              ! (in)
   437:                   & history = gthst_rst )            ! (inout)
   438:                 call HistoryAddAttr( &
   439:                   & 'time', attrname = 'month_in_year', & ! (in)
   440:                   & value = month_in_year, &              ! (in)
   441:                   & history = gthst_rst )                 ! (inout)
   442:                 call HistoryAddAttr( &
   443:                   & 'time', attrname = 'day_in_month', & ! (in)
   444:                   & value = day_in_month_ptr, &          ! (in)
   445:                   & history = gthst_rst )                ! (inout)
   446:                 call HistoryAddAttr( &
   447:                   & 'time', attrname = 'hour_in_day', & ! (in)
   448:                   & value = hour_in_day, &              ! (in)
   449:                   & history = gthst_rst )               ! (inout)
   450:                 call HistoryAddAttr( &
   451:                   & 'time', attrname = 'min_in_hour', & ! (in)
   452:                   & value = min_in_hour, &              ! (in)
   453:                   & history = gthst_rst )               ! (inout)
   454:                 call HistoryAddAttr( &
   455:                   & 'time', attrname = 'sec_in_min', & ! (in)
   456:                   & value = sec_in_min, &              ! (in)
   457:                   & history = gthst_rst )              ! (inout)
   458:             
   459:                 deallocate( day_in_month_ptr )
   460:             
   461:                 ! 再計算データ用のフラグ設定
   462:                 ! Set flag for a restart data file. 
   463:                 !
   464:                 call HistoryAddVariable( &
   465:                   & varname = 'flag_rst', &               ! (in)
   466:                   & dims = (/''/), &                      ! (in)
   467:                   & longname = 'flag for restart data', & ! (in)
   468:                   & units = '1', xtype = 'int', &         ! (in)
   469:                   & history = gthst_rst )                 ! (inout)
   470:                 call HistoryAddAttr( &
   471:                   & varname = 'flag_rst', &               ! (in)
   472:                   & attrname = 'comment', &               ! (in)
   473:                   & value = 'If this value is nonzero, this file provides restart data', &
   474:                                                             ! (in)
   475:                   & history = gthst_rst )                 ! (inout)
   476:             
   477:                 if ( flag_init_data_save ) then
   478:                   call HistoryPut( &
   479:                     & varname = 'flag_rst', &               ! (in)
   480:                     & array = (/ 0 /), &                    ! (in)
   481:                     & history = gthst_rst )                 ! (inout)
   482:                 else
   483:                   call HistoryPut( &
   484:                     & varname = 'flag_rst', &               ! (in)
   485:                     & array = (/ 1 /), &                    ! (in)
   486:                     & history = gthst_rst )                 ! (inout)
   487:                 end if
   488:             
   489:                 ! 年月日時分秒形式の日時情報変数の設定
   490:                 ! Set a date information variable with year-month-day hour:minute:second format
   491:                 !
   492:                 call HistoryAddVariable( &
   493:                   & varname = 'datetime', &                     ! (in)
   494:                   & dims =  (/'timestr', 'time   ' /), &        ! (in)
   495:                   & longname = 'time represented as strings', & ! (in)
   496:                   & units = '1', xtype = 'char', &              ! (in)
   497:                   & history = gthst_rst )                       ! (inout) optional
   498:             
   499:                 ! 座標データの設定
   500:                 ! Axes data settings
   501:                 !
   502:                 call HistoryAddAttr( &
   503:                   & 'lon', attrname = 'standard_name', &     ! (in)
   504:                   & value = 'longitude', &                   ! (in)
   505:                   & history = gthst_rst )                    ! (inout)
   506:                 call HistoryAddAttr( &
   507:                   & 'lat', attrname = 'standard_name', &     ! (in)
   508:                   & value = 'latitude', &                    ! (in)
   509:                   & history = gthst_rst )                    ! (inout)
   510:                 call HistoryAddAttr( &
   511:                   & 'sig', attrname = 'standard_name', &     ! (in)
   512:                   & value = 'atmosphere_sigma_coordinate', & ! (in)
   513:                   & history = gthst_rst )                    ! (inout)
   514:                 call HistoryAddAttr( &
   515:                   & 'sigm', attrname = 'standard_name', &    ! (in)
   516:                   & value = 'atmosphere_sigma_coordinate', & ! (in)
   517:                   & history = gthst_rst )                    ! (inout)
   518:                 call HistoryAddAttr( &
   519:                   & 'time', attrname = 'standard_name', &    ! (in)
   520:                   & value = 'time', &                        ! (in)
   521:                   & history = gthst_rst )                    ! (inout)
   522:                 call HistoryAddAttr( &
   523:                   & 'sig', attrname = 'positive', &          ! (in)
   524:                   & value = 'down', &                        ! (in)
   525:                   & history = gthst_rst )                    ! (inout)
   526:                 call HistoryAddAttr( &
   527:                   & 'sigm', attrname = 'positive', &         ! (in)
   528:                   & value = 'down', &                        ! (in)
   529:                   & history = gthst_rst )                    ! (inout)
   530:             
   531: V====== A       call HistoryPut( &
   532:                   & 'lon', x_Lon / PI * 180.0_DP, & ! (in)
   533:                   & history = gthst_rst )           ! (inout)
   534: V====== A       call HistoryPut( &
   535:                   & 'lat', y_Lat / PI * 180.0_DP, & ! (in)
   536:                   & history = gthst_rst )           ! (inout)
   537:                 call HistoryPut( &
   538:                   & 'sig', z_Sigma, &               ! (in)
   539:                   & history = gthst_rst )           ! (inout)
   540:                 call HistoryPut( & 
   541:                   & 'sigm', r_Sigma, &              ! (in)
   542:                   & history = gthst_rst )           ! (inout)
   543:             
   544:                 ! 座標重みの設定
   545:                 ! Axes weights settings
   546:                 !
   547:                 call HistoryAddVariable( 'lon_weight', &               ! (in)
   548:                   & (/'lon'/), &                                       ! (in)
   549:                   & 'weight for integration in longitude', 'radian', & ! (in)
   550:                   & xtype = 'double', &                                ! (in)
   551:                   & history = gthst_rst )                              ! (inout)
   552:                 call HistoryAddAttr( &
   553:                   & 'lon', attrname = 'gt_calc_weight', &     ! (in)
   554:                   & value = 'lon_weight', &                   ! (in)
   555:                   & history = gthst_rst )                     ! (inout)
   556:                 call HistoryPut( &
   557:                   & 'lon_weight', x_Lon_Weight, &             ! (in)
   558:                   & history = gthst_rst )                     ! (inout)
   559:             
   560:                 call HistoryAddVariable( 'lat_weight', &                      ! (in)
   561:                   & (/'lat'/), &                                              ! (in)
   562:                   & 'weight for integration in latitude', units = 'radian', & ! (in)
   563:                   & xtype = 'double', &                                       ! (in)
   564:                   & history = gthst_rst )                                     ! (inout)
   565:                 call HistoryAddAttr( &
   566:                   & 'lat', attrname = 'gt_calc_weight', &     ! (in)
   567:                   & value = 'lat_weight', &                   ! (in)
   568:                   & history = gthst_rst )                     ! (inout)
   569:                 call HistoryPut( &
   570:                   & 'lat_weight', y_Lat_Weight, &             ! (in)
   571:                   & history = gthst_rst )                     ! (inout)
   572:             
   573:                 call HistoryAddVariable( 'sig_weight', &      ! (in)
   574:                   & (/'sig'/), &                              ! (in)
   575:                   & 'weight for integration in sigma', '1', & ! (in)
   576:                   & xtype = 'double', &                       ! (in)
   577:                   & history = gthst_rst )                     ! (inout)
   578:                 call HistoryAddAttr( &
   579:                   & 'sig', attrname = 'gt_calc_weight', &     ! (in)
   580:                   & value = 'sig_weight', &                   ! (in)
   581:                   & history = gthst_rst )                     ! (inout)
   582:                 call HistoryPut( &
   583:                   & 'sig_weight', z_DelSigma, &               ! (in)
   584:                   & history = gthst_rst )                     ! (inout)
   585:             
   586:             
   587:                 ! 予報変数の設定
   588:                 ! Predictional variables settings
   589:                 !
   590:                 if ( flag_init_data_save ) then
   591:             
   592:                   ! 初期データファイル用
   593:                   ! For initial data file
   594:                   !
   595:                   call HistoryAddVariable( 'U', &                         ! (in)
   596:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   597:                     & 'eastward wind', 'm s-1', &                         ! (in)
   598:                     & xtype = 'double', &                                 ! (in)
   599:                     & history = gthst_rst )                               ! (inout)
   600:                   call HistoryAddVariable( 'V', &                         ! (in)
   601:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   602:                     & 'northward wind', 'm s-1', &                        ! (in)
   603:                     & xtype = 'double', &                                 ! (in)
   604:                     & history = gthst_rst )                               ! (inout)
   605:                   call HistoryAddVariable( 'Temp', &                      ! (in)
   606:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   607:                     & 'temperature', 'K', &                               ! (in)
   608:                     & xtype = 'double', &                                 ! (in)
   609:                     & history = gthst_rst )                               ! (inout)
   610: +------>          do n = 1, ncmax
   611: |                   call HistoryAddVariable( a_QMixName(n),                & ! (in)
   612: |                     & (/ 'lon ', 'lat ', 'sig ', 'time' /),              & ! (in)
   613: |                     & a_QMixLongName(n), 'kg kg-1',                      & ! (in)
   614: |                     & xtype = 'double',                                  & ! (in)
   615: |                     & history = gthst_rst                                & ! (inout)
   616: |                     & )
   617: +------           end do
   618:                   call HistoryAddVariable( 'Ps', &                        ! (in)
   619:                     & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
   620:                     & 'surface pressure', 'Pa', &                         ! (in)
   621:                     & xtype = 'double', &                                 ! (in)
   622:                     & history = gthst_rst )                               ! (inout)
   623:             
   624:                 else
   625:             
   626:                   ! リスタートデータファイル用
   627:                   ! For restart data file
   628:                   !
   629:                   call HistoryAddVariable( 'UB', &                        ! (in)
   630:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   631:                     & 'eastward wind (at t-\Delta t)', 'm s-1', &         ! (in)
   632:                     & xtype = 'double', &                                 ! (in)
   633:                     & history = gthst_rst )                               ! (inout)
   634:                   call HistoryAddVariable( 'VB', &                        ! (in)
   635:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   636:                     & 'northward wind (at t-\Delta t)', 'm s-1', &        ! (in)
   637:                     & xtype = 'double', &                                 ! (in)
   638:                     & history = gthst_rst )                               ! (inout)
   639:                   call HistoryAddVariable( 'TempB', &                     ! (in)
   640:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   641:                     & 'temperature (at t-\Delta t)', 'K', &               ! (in)
   642:                     & xtype = 'double', &                                 ! (in)
   643:                     & history = gthst_rst )                               ! (inout)
   644: +------>          do n = 1, ncmax
   645: |                   call HistoryAddVariable( trim(a_QMixName(n))//'B',    & ! (in)
   646: |                     & (/ 'lon ', 'lat ', 'sig ', 'time' /),             & ! (in)
   647: |                     & a_QMixLongName(n), 'kg kg-1',                     & ! (in)
   648: |                     & xtype = 'double',                                 & ! (in)
   649: |                     & history = gthst_rst                               & ! (inout)
   650: |                     & )
   651: +------           end do
   652:                   call HistoryAddVariable( 'PsB', &                       ! (in)
   653:                     & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
   654:                     & 'surface pressure (at t-\Delta t)', 'Pa', &         ! (in)
   655:                     & xtype = 'double', &                                 ! (in)
   656:                     & history = gthst_rst )                               ! (inout)
   657:             
   658:                   call HistoryAddVariable( 'UN', &                        ! (in)
   659:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   660:                     & 'eastward wind (at t)', 'm s-1', &                  ! (in)
   661:                     & xtype = 'double', &                                 ! (in)
   662:                     & history = gthst_rst )                               ! (inout)
   663:                   call HistoryAddVariable( 'VN', &                        ! (in)
   664:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   665:                     & 'northward wind (at t)', 'm s-1', &                 ! (in)
   666:                     & xtype = 'double', &                                 ! (in)
   667:                     & history = gthst_rst )                               ! (inout)
   668:                   call HistoryAddVariable( 'TempN', &                     ! (in)
   669:                     & (/ 'lon ', 'lat ', 'sig ', 'time' /), &             ! (in)
   670:                     & 'temperature (at t)', 'K', &                        ! (in)
   671:                     & xtype = 'double', &                                 ! (in)
   672:                     & history = gthst_rst )                               ! (inout)
   673: +------>          do n = 1, ncmax
   674: |                   call HistoryAddVariable( trim(a_QMixName(n))//'N',    & ! (in)
   675: |                     & (/ 'lon ', 'lat ', 'sig ', 'time' /),             & ! (in)
   676: |                     & a_QMixLongName(n), 'kg kg-1',                     & ! (in)
   677: |                     & xtype = 'double',                                 & ! (in)
   678: |                     & history = gthst_rst                               & ! (inout)
   679: |                     & )
   680: +------           end do
   681:                   call HistoryAddVariable( 'PsN', &                       ! (in)
   682:                     & (/ 'lon ', 'lat ', 'time' /), &                     ! (in)
   683:                     & 'surface pressure (at t)', 'Pa', &                  ! (in)
   684:                     & xtype = 'double', &                                 ! (in)
   685:                     & history = gthst_rst )                               ! (inout)
   686:                 end if
   687:             
   688:                 restart_file_opened = .true.
   689:               end subroutine RestartFileOpen
   690:             
   691:               !--------------------------------------------------------------------------------------
   692:             
   693:               subroutine RestartFileOutput(                      &
   694:                 & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
   695:                 & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN  &   ! (in)
   696:                 & )
   697:                 !
   698:                 ! リスタートデータの出力を行います. 
   699:                 !
   700:                 ! Output restart data
   701:             
   702:                 ! モジュール引用 ; USE statements
   703:                 !
   704:             
   705:                 ! 時刻管理
   706:                 ! Time control
   707:                 !
   708:                 use timeset, only: &
   709:                   & TimeN, &              ! ステップ $ t $ の時刻. 
   710:                                           ! Time of step $ t $. 
   711:                   & EndTime, &            ! 計算終了時刻. 
   712:                                           ! End time of calculation
   713:                   & InitialDate           ! 計算開始日時. 
   714:                                           ! Start date of calculation
   715:             
   716:                 ! gtool4 データ出力
   717:                 ! Gtool4 data output
   718:                 !
   719:                 use gtool_history, only: HistoryPut, HistorySetTime
   720:             
   721:                 ! 暦と日時の取り扱い
   722:                 ! Calendar and Date handler
   723:                 !
   724:                 use dc_calendar, only: DCCalDateInquire
   725:             
   726:                 ! 組み込み関数 PRESENT の拡張版関数
   727:                 ! Extended functions of intrinsic function "PRESENT"
   728:                 !
   729:                 use dc_present, only: present_and_true
   730:             
   731:                 ! 宣言文 ; Declaration statements
   732:                 !
   733:                 implicit none
   734:                 real(DP), intent(in):: xyz_UB     (0:imax-1, 1:jmax, 1:kmax)
   735:                                           ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
   736:                 real(DP), intent(in):: xyz_VB     (0:imax-1, 1:jmax, 1:kmax)
   737:                                           ! $ v (t-\Delta t) $ .   南北風速. Northward wind
   738:                 real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
   739:                                           ! $ T (t-\Delta t) $ .   温度. Temperature
   740:                 real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   741:                                           ! $ q (t-\Delta t) $ .   比湿. Specific humidity
   742:                 real(DP), intent(in):: xy_PsB     (0:imax-1, 1:jmax)
   743:                                           ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   744:                 real(DP), intent(in):: xyz_UN     (0:imax-1, 1:jmax, 1:kmax)
   745:                                           ! $ u (t) $ .     東西風速. Eastward wind
   746:                 real(DP), intent(in):: xyz_VN     (0:imax-1, 1:jmax, 1:kmax)
   747:                                           ! $ v (t) $ .     南北風速. Northward wind
   748:                 real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
   749:                                           ! $ T (t) $ .     温度. Temperature
   750:                 real(DP), intent(in):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   751:                                           ! $ q (t) $ .     比湿. Specific humidity
   752:                 real(DP), intent(in):: xy_PsN     (0:imax-1, 1:jmax)
   753:                                           ! $ p_s (t) $ .   地表面気圧. Surface pressure
   754:             
   755:                 ! 作業変数
   756:                 ! Work variables
   757:                 !
   758:                 logical:: flag_output
   759:                                           ! 出力のフラグ. 
   760:                                           ! Flag for output
   761:                 character(TOKEN):: date_str         ! 日時の年月日時分秒形式. 
   762:                                                     ! Date with year-month-day hour:minute:second format
   763:                 integer :: n
   764:             
   765:             
   766:                 ! 実行文 ; Executable statement
   767:                 !
   768:                 if ( .not. restart_file_opened ) call RestartFileOpen
   769:             
   770:                 ! リスタートデータ出力であることのチェック
   771:                 ! Check restart data output
   772:                 !
   773:                 if ( flag_init_data_save ) then
   774:                   call MessageNotify( 'E', module_name, &
   775:                     & 'Now, initial data output mode.' )
   776:                 end if
   777:             
   778:                 ! 出力タイミングのチェック
   779:                 ! Check output timing
   780:                 !
   781:                 flag_output = TimeN - PrevOutputTime >= IntTime
   782:                 if ( TimeN >= EndTime .and. .not. flag_output_end ) then
   783:                   flag_output = .true.
   784:                   flag_output_end = .true.
   785:                 end if
   786:                 flag_output = ( .not. TimeN == PrevOutputTime ) .and. flag_output
   787:                 flag_output = flag_init_data_save .or. flag_output
   788:             
   789:                 if ( .not. flag_output ) return
   790:             
   791:                 ! 次回用に, 今回の出力 (希望) 時刻 を保存
   792:                 ! Save output time (expected) in this time, for next time
   793:                 !
   794:                 PrevOutputTime = PrevOutputTime + IntTime
   795:             
   796:                 ! 時刻の設定
   797:                 ! Set time
   798:                 !
   799:                 call HistorySetTime( timed = TimeN, history = gthst_rst )
   800:             
   801:                 ! "TimeN" を年月日時分秒表記にして "datetime" 変数へ出力
   802:                 ! Put "TimeN" on "datetime" variable with year-month-day hour:minute:second format
   803:                 !
   804:                 call DCCalDateInquire( &
   805:                   & date_str   = date_str, &   ! (out)
   806:                   & elapse_sec = TimeN, &      ! (in) optional
   807:                   & date       = InitialDate ) ! (in) optional
   808:             
   809:                 call HistoryPut( 'datetime', date_str, &  ! (in)
   810:                   &              history = gthst_rst )    ! (inout) optional
   811:             
   812:                 ! データ出力
   813:                 ! Data output
   814:                 !
   815:                 call HistoryPut( &
   816:                   & 'UB', xyz_UB, history = gthst_rst ) ! (in)
   817:                 call HistoryPut( &
   818:                   & 'VB', xyz_VB, history = gthst_rst ) ! (in)
   819:                 call HistoryPut( &
   820:                   & 'TempB', xyz_TempB, history = gthst_rst ) ! (in)
   821: +------>        do n = 1, ncmax
   822: |                 call HistoryPut( &
   823: |                   & trim(a_QMixName(n))//'B', xyzf_QMixB(:,:,:,n), history = gthst_rst ) ! (in)
   824: +------         end do
   825:                 call HistoryPut( &
   826:                   & 'PsB', xy_PsB, history = gthst_rst ) ! (in)
   827:             
   828:                 call HistoryPut( &
   829:                   & 'UN', xyz_UN, history = gthst_rst ) ! (in)
   830:                 call HistoryPut( &
   831:                   & 'VN', xyz_VN, history = gthst_rst ) ! (in)
   832:                 call HistoryPut( &
   833:                   & 'TempN', xyz_TempN, history = gthst_rst ) ! (in)
   834: +------>        do n = 1, ncmax
   835: |                 call HistoryPut( &
   836: |                   & trim(a_QMixName(n))//'N', xyzf_QMixN(:,:,:,n), history = gthst_rst ) ! (in)
   837: +------         end do
   838:                 call HistoryPut( &
   839:                   & 'PsN', xy_PsN, history = gthst_rst ) ! (in)
   840:             
   841:               end subroutine RestartFileOutput
   842:             
   843:               !--------------------------------------------------------------------------------------
   844:             
   845:               subroutine InitialFileOutput(                 &
   846:                 & xyz_U, xyz_V, xyz_Temp, xyzf_QMix, xy_Ps  &   ! (in)
   847:                 & )
   848:                 !
   849:                 ! 初期値データの出力を行います. 
   850:                 !
   851:                 ! Output initial data
   852:             
   853:                 ! モジュール引用 ; USE statements
   854:                 !
   855:             
   856:                 ! 時刻管理
   857:                 ! Time control
   858:                 !
   859:                 use timeset, only: &
   860:                   & TimeN, &              ! ステップ $ t $ の時刻. 
   861:                                           ! Time of step $ t $. 
   862:                   & EndTime, &            ! 計算終了時刻. 
   863:                                           ! End time of calculation
   864:                   & InitialDate           ! 計算開始日時. 
   865:                                           ! Start date of calculation
   866:             
   867:                 ! gtool4 データ出力
   868:                 ! Gtool4 data output
   869:                 !
   870:                 use gtool_history, only: HistoryPut, HistorySetTime
   871:             
   872:                 ! 暦と日時の取り扱い
   873:                 ! Calendar and Date handler
   874:                 !
   875:                 use dc_calendar, only: DCCalDateInquire
   876:             
   877:                 ! 組み込み関数 PRESENT の拡張版関数
   878:                 ! Extended functions of intrinsic function "PRESENT"
   879:                 !
   880:                 use dc_present, only: present_and_true
   881:             
   882:                 ! 宣言文 ; Declaration statements
   883:                 !
   884:                 implicit none
   885:                 real(DP), intent(in):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   886:                                           ! $ u $ .     東西風速. Eastward wind
   887:                 real(DP), intent(in):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   888:                                           ! $ v $ .     南北風速. Northward wind
   889:                 real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   890:                                           ! $ T $ .     温度. Temperature
   891:                 real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   892:                                           ! $ q $ .     比湿. Specific humidity
   893:                 real(DP), intent(in):: xy_Ps    (0:imax-1, 1:jmax)
   894:                                           ! $ p_s $ .   地表面気圧. Surface pressure
   895:             
   896:                 ! 作業変数
   897:                 ! Work variables
   898:                 !
   899:                 character(STRING):: date_str        ! 日時の年月日時分秒形式. 
   900:                                                     ! Date with year-month-day hour:minute:second format
   901:                 integer          :: n
   902:             
   903:             
   904:                 ! 実行文 ; Executable statement
   905:                 !
   906:                 if ( .not. restart_file_opened ) call RestartFileOpen( flag_init_data = .true. )
   907:             
   908:                 ! 初期値出力であることのチェック
   909:                 ! Check initial data output
   910:                 !
   911:                 if ( .not. flag_init_data_save ) then
   912:                   call MessageNotify( 'E', module_name, &
   913:                     & 'Now, restart data output mode.' )
   914:                 end if
   915:             
   916:                 ! 時刻の設定
   917:                 ! Set time
   918:                 !
   919:                 call HistorySetTime( timed = TimeN, history = gthst_rst )
   920:             
   921:                 ! "TimeN" を年月日時分秒表記にして "datetime" 変数へ出力
   922:                 ! Put "TimeN" on "datetime" variable with year-month-day hour:minute:second format
   923:                 !
   924:                 call DCCalDateInquire( &
   925:                   & date_str   = date_str, &   ! (out)
   926:                   & elapse_sec = TimeN, &      ! (in) optional
   927:                   & date       = InitialDate ) ! (in) optional
   928:             
   929:                 call HistoryPut( 'datetime', date_str, &  ! (in)
   930:                   &              history = gthst_rst )    ! (inout) optional
   931:             
   932:                 ! データ出力
   933:                 ! Data output
   934:                 !
   935:                 call HistoryPut( &
   936:                   & 'U', xyz_U, history = gthst_rst )       ! (in)
   937:                 call HistoryPut( &
   938:                   & 'V', xyz_V, history = gthst_rst )       ! (in)
   939:                 call HistoryPut( &
   940:                   & 'Temp', xyz_Temp, history = gthst_rst ) ! (in)
   941: +------>        do n = 1, ncmax
   942: |                 call HistoryPut( &
   943: |                   & a_QMixName(n), xyzf_QMix(:,:,:,n), history = gthst_rst ) ! (in)
   944: +------         end do
   945:                 call HistoryPut( &
   946:                   & 'Ps', xy_Ps, history = gthst_rst )      ! (in)
   947:             
   948:             
   949:               end subroutine InitialFileOutput
   950:             
   951:               !--------------------------------------------------------------------------------------
   952:             
   953:               subroutine RestartFileClose
   954:                 !
   955:                 ! リスタートデータファイル出力の終了処理を行います. 
   956:                 !
   957:                 ! Terminate restart data files output. 
   958:             
   959:                 ! モジュール引用 ; USE statements
   960:                 !
   961:             
   962:                 ! gtool4 データ出力
   963:                 ! Gtool4 data output
   964:                 !
   965:                 use gtool_history, only: HistoryClose
   966:             
   967:                 ! 宣言文 ; Declaration statements
   968:                 !
   969:                 implicit none
   970:             
   971:                 ! 作業変数
   972:                 ! Work variables
   973:                 !
   974:             
   975:                 ! 実行文 ; Executable statement
   976:                 !
   977:                 if ( .not. restart_file_opened ) return
   978:             
   979:                 call HistoryClose( history = gthst_rst ) ! (inout)
   980:             
   981:                 restart_file_opened = .false.
   982:               end subroutine RestartFileClose
   983:             
   984:               !--------------------------------------------------------------------------------------
   985:             
   986:               subroutine RestartFileGet( &
   987:                 & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, & ! (out)
   988:                 & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, & ! (out)
   989:                 & flag_initial                                   & ! (out) optional
   990:                 & )
   991:                 !
   992:                 ! リスタート/初期値データの入力を行います. 
   993:                 ! リスタート/初期値データファイルが存在しない場合には, 
   994:                 ! initial_data モジュールを用いて, 初期値生成を行います. 
   995:                 !
   996:                 ! Input restart/initial data. 
   997:                 ! If a restart/initial data file is not exist, 
   998:                 ! initial data is created by "initial_data". 
   999:             
  1000:             
  1001:                 ! モジュール引用 ; USE statements
  1002:                 !
  1003:             
  1004:                 ! 時刻管理
  1005:                 ! Time control
  1006:                 !
  1007:                 use timeset, only: &
  1008:                   & DelTime               ! $ \Delta t $ [s]
  1009:             
  1010:                 ! 初期値データ (リスタートデータ) 提供
  1011:                 ! Prepare initial data (restart data)
  1012:                 !
  1013:                 use initial_data, only: SetInitData
  1014:             
  1015:                 ! 時刻管理
  1016:                 ! Time control
  1017:                 !
  1018:                 use timeset, only: TimesetSetInitialDate, TimesetSetTimeN, TimesetSetCalendar, &
  1019:                   & RestartTime           ! リスタート開始時刻. 
  1020:                                           ! Restart time of calculation
  1021:             
  1022:                 ! gtool4 データ入力
  1023:                 ! Gtool4 data input
  1024:                 !
  1025:                 use gtool_history, only: HistoryGet, HistoryGetAttr
  1026:             
  1027:                 ! 文字列操作
  1028:                 ! Character handling
  1029:                 !
  1030:                 use dc_string, only: toChar
  1031:             
  1032:                 ! ファイル入出力補助
  1033:                 ! File I/O support
  1034:                 !
  1035:                 use dc_iounit, only: FileOpen
  1036:             
  1037:             
  1038:                 ! 宣言文 ; Declaration statements
  1039:                 !
  1040:                 implicit none
  1041:                 real(DP), intent(out):: xyz_UB      (0:imax-1, 1:jmax, 1:kmax)
  1042:                                           ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
  1043:                 real(DP), intent(out):: xyz_VB      (0:imax-1, 1:jmax, 1:kmax)
  1044:                                           ! $ v (t-\Delta t) $ .   南北風速. Northward wind
  1045:                 real(DP), intent(out):: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
  1046:                                           ! $ T (t-\Delta t) $ .   温度. Temperature
  1047:                 real(DP), intent(out):: xyzf_QMixB  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1048:                                           ! $ q (t-\Delta t) $ .   比湿. Specific humidity
  1049:                 real(DP), intent(out):: xy_PsB      (0:imax-1, 1:jmax)
  1050:                                           ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
  1051:                 real(DP), intent(out):: xyz_UN      (0:imax-1, 1:jmax, 1:kmax)
  1052:                                           ! $ u (t) $ .     東西風速. Eastward wind
  1053:                 real(DP), intent(out):: xyz_VN      (0:imax-1, 1:jmax, 1:kmax)
  1054:                                           ! $ v (t) $ .     南北風速. Northward wind
  1055:                 real(DP), intent(out):: xyz_TempN   (0:imax-1, 1:jmax, 1:kmax)
  1056:                                           ! $ T (t) $ .     温度. Temperature
  1057:                 real(DP), intent(out):: xyzf_QMixN  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1058:                                           ! $ q (t) $ .     比湿. Specific humidity
  1059:                 real(DP), intent(out):: xy_PsN      (0:imax-1, 1:jmax)
  1060:                                           ! $ p_s (t) $ .   地表面気圧. Surface pressure
  1061:                 logical , intent(out), optional:: flag_initial
  1062:                                           ! リスタートデータを読み込む場合には, 
  1063:                                           ! .false. が, 初期値データを読み込む場合には
  1064:                                           ! .true. が返ります. 
  1065:                                           ! 
  1066:                                           ! If restart data is loaded, .false. is returned.
  1067:                                           ! On the other hand, if initial data is loaded, 
  1068:                                           ! .true. is returned. 
  1069:             
  1070:                 ! 作業変数
  1071:                 ! Work variables
  1072:                 !
  1073:                 integer:: flag_rst        ! 初期値データから入力時は 0, 
  1074:                                           ! リスタートデータ入力時は 1. 
  1075:                                           ! 
  1076:                                           ! If initial data is input, this value is 0. 
  1077:                                           ! If restart data is input, this value is 1.
  1078:             
  1079:                 character(STRING):: time_range
  1080:                                           ! 時刻の指定. 
  1081:                                           ! Specification of time
  1082:                 character(TOKEN):: dummy_str
  1083:                                           ! 入力チェック用のダミー変数
  1084:                                           ! Dummy variable for check of input
  1085:                 logical:: get_err
  1086:                                           ! 入力時のエラーフラグ. 
  1087:                                           ! Error flag for input
  1088:                 real(DP):: returned_time
  1089:                                           ! 入力データの時刻. 
  1090:                                           ! Time of input data.
  1091:                 logical:: flag_time_exist
  1092:                                           ! 入力データの時刻用のフラグ. 
  1093:                                           ! Flag for time of input data.
  1094:             
  1095:                 integer:: origin_year, origin_month, origin_day, origin_hour, origin_min
  1096:                                           ! 計算開始の年月日時分. 
  1097:                 real(DP):: origin_sec
  1098:                                           ! 計算開始の秒. 
  1099:                 character(TOKEN):: cal_type
  1100:                                           ! 暦のタイプ. 
  1101:                 integer:: month_in_year, hour_in_day, min_in_hour
  1102:                 integer, pointer:: day_in_month_ptr(:) => null()
  1103:                 real(DP):: sec_in_min
  1104:                                           ! 暦の詳細情報
  1105:                 real(DP):: rst_time
  1106:                                           ! リスタートデータファイルから得られる時刻変数
  1107:                                           ! Time variable from a restart data file
  1108:             
  1109:                 logical:: flag_mpi_init
  1110:             
  1111:                 integer :: n
  1112:             
  1113:             
  1114:                 ! 実行文 ; Executable statement
  1115:                 !
  1116:             
  1117:                 if ( .not. restart_file_io_inited ) then
  1118:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1119:                 end if
  1120:             
  1121:                 ! データを initial_data モジュールから取得
  1122:                 ! Data is input from "initial_data" module
  1123:                 ! 
  1124:                 if ( trim(InputFile) == '' ) then
  1125:                   call SetInitData( &
  1126:                     & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap), xy_PsB )   ! (out)
  1127:             
  1128:                   ! The variables below are initialized here, temporarily. 
  1129:                   !
  1130: W***=== A         xyzf_QMixB(:,:,:,1:IndexH2OVap-1)     = 0.0_DP
  1131: W***=== A         xyzf_QMixB(:,:,:,IndexH2OVap+1:ncmax) = 0.0_DP
  1132:             
  1133:                   call MessageNotify( 'M', module_name, &
  1134:                     & 'Initial data (not restart data) is input ' // &
  1135:                     & 'from a module "initial_data". ' // &
  1136:                     & '*B (t-dt) and *N (t) are same.' )
  1137:             
  1138: **V---->A         xyz_UN     = xyz_UB
  1139: |||     A         xyz_VN     = xyz_VB
  1140: **V---- A         xyz_TempN  = xyz_TempB
  1141: W***=== A         xyzf_QMixN = xyzf_QMixB
  1142: +V===== A         xy_PsN     = xy_PsB
  1143:             
  1144:                   if ( present(flag_initial) ) flag_initial = .true.
  1145:             
  1146:                 ! データを InputFile から取得
  1147:                 ! Data is input from InputFile
  1148:                 ! 
  1149:                 else
  1150:             
  1151:             !!$      flag_mpi_init = .false.
  1152:                   flag_mpi_init = .true.
  1153:             
  1154:                   ! ファイルの有無を確認
  1155:                   ! Conform an existence of an input file
  1156:                   ! 
  1157:                   call HistoryGetAttr( InputFile, 'lon', 'units', & ! (in)
  1158:                     & dummy_str, &                                  ! (out)
  1159:                     & flag_mpi_split = flag_mpi_init, &             ! (in) optional
  1160:                     & err = get_err )                               ! (out)
  1161:             
  1162:                   if ( get_err ) then
  1163:                     call MessageNotify( 'E', module_name, &
  1164:                       & 'restart/initial data file "%c" is not found.', &
  1165:                       & c1 = trim(InputFile) )
  1166:                   end if
  1167:             
  1168:                   ! 時刻情報の取得
  1169:                   ! Get time information
  1170:                   !
  1171:                   time_range = 'time=' // toChar( RestartTime )
  1172:             
  1173:                   ! 初期値データかリスタートデータかのチェック
  1174:                   ! Check whether input data is initial data or restart data
  1175:                   ! 
  1176:                   call HistoryGet( &
  1177:                     & InputFile, 'flag_rst', &                ! (in)
  1178:                     & flag_rst, &                             ! (out)
  1179:                     & err = get_err, &                        ! (out) optional
  1180:                     & quiet = .true., &                       ! (in) optional
  1181:                     & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1182:             
  1183:                   if ( get_err ) then
  1184:                     ! flag_rst 変数が読み込めない場合、とりあえず初期値データと見なす
  1185:                     !
  1186:                     flag_rst = 0
  1187:                     if ( present(flag_initial) ) flag_initial = .true.
  1188:             
  1189:                   else if ( flag_rst == 0 ) then
  1190:                     if ( present(flag_initial) ) flag_initial = .true.
  1191:             
  1192:                   else
  1193:                     if ( present(flag_initial) ) flag_initial = .false.
  1194:                   end if
  1195:             
  1196:                   ! 物理量データの有無のチェック ("U", "UB" のみ)
  1197:                   ! Check existence or nonexistence of physical data (only "U", "UB")
  1198:                   ! 
  1199:                   if ( flag_rst == 0 ) then
  1200:                     call HistoryGet( &
  1201:                       & InputFile, 'U', &                       ! (in)
  1202:                       & xyz_UB, &                               ! (out)
  1203:                       & err = get_err, &                        ! (out) optional
  1204:                       & quiet = .true., &                       ! (in) optional
  1205:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1206:             
  1207:                     if ( get_err ) then
  1208:                       call MessageNotify( 'E', module_name, &
  1209:                         & 'One of necessary variables "U" for start of calculation ' // &
  1210:                         & 'cannot be read from "%c"', &
  1211:                         & c1 = trim(InputFile) )
  1212:                     end if
  1213:             
  1214:                   else
  1215:             
  1216:                     call HistoryGet( &
  1217:                       & InputFile, 'UB', &                      ! (in)
  1218:                       & xyz_UB, &                               ! (out)
  1219:                       & range = time_range, &                   ! (in) optional
  1220:                       & quiet = .true., &                       ! (in) optional
  1221:                       & err = get_err, &                        ! (out) optional
  1222:                       & returned_time = returned_time, &        ! (out) optional
  1223:                       & flag_time_exist = flag_time_exist, &    ! (out) optional
  1224:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1225:             
  1226:                     if ( get_err ) then
  1227:                       call MessageNotify( 'E', module_name, &
  1228:                         & 'One of necessary variables "UB" for restart ' // &
  1229:                         & 'cannot be read from "%c"', &
  1230:                         & c1 = trim(InputFile) )
  1231:                     end if
  1232:                   end if
  1233:             
  1234:                   ! 初期値データを入力する場合、経過時間を 0 に設定
  1235:                   ! Set 0 to elapsed time, when initial data is input
  1236:                   !
  1237:                   if ( flag_rst == 0 ) then
  1238:                     call TimesetSetTimeN( 0.0_DP )
  1239:                   end if
  1240:             
  1241:                   ! 暦、開始日時、経過時刻の読み込みと上書き設定
  1242:                   ! Input and overwrite calendar, start date, and elapsed time
  1243:                   !
  1244:                   if ( flag_rst /= 0 ) then
  1245:             
  1246:                     ! 暦の読み込み
  1247:                     ! Input calendar
  1248:                     !
  1249:                     call HistoryGetAttr( &
  1250:                       & InputFile, 'time', 'calendar', &          ! (in)
  1251:                       & cal_type, &                               ! (out)
  1252:                       & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1253:             
  1254:                     call HistoryGetAttr( &
  1255:                       & InputFile, 'time', 'month_in_year', &     ! (in)
  1256:                       & month_in_year, &                          ! (out)
  1257:                       & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1258:             
  1259:                     allocate( day_in_month_ptr(month_in_year) )
  1260:                     call HistoryGetAttr( &
  1261:                       & InputFile, 'time', 'day_in_month', &      ! (in)
  1262:                       & day_in_month_ptr, &                       ! (out)
  1263:                       & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1264:             
  1265:                     call HistoryGetAttr( &
  1266:                       & InputFile, 'time', 'hour_in_day', &       ! (in)
  1267:                       & hour_in_day, &                            ! (out)
  1268:                       & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1269:             
  1270:                     call HistoryGetAttr( &
  1271:                       & InputFile, 'time', 'min_in_hour', &       ! (in)
  1272:                       & min_in_hour, &                            ! (out)
  1273:                       & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1274:             
  1275:                     call HistoryGetAttr( &
  1276:                       & InputFile, 'time', 'sec_in_min', &        ! (in)
  1277:                       & sec_in_min, &                             ! (out)
  1278:                       & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1279:             
  1280:                     ! 暦の上書き設定
  1281:                     ! Overwrite calendar
  1282:                     !
  1283:                     call TimesetSetCalendar( cal_type, &       ! (in)
  1284:                       & month_in_year, day_in_month_ptr, &     ! (in)
  1285:                       & hour_in_day, min_in_hour, sec_in_min ) ! (in)
  1286:             
  1287:                     deallocate( day_in_month_ptr )
  1288:             
  1289:                     ! 開始日時の読み込み
  1290:                     ! Input start date
  1291:                     !
  1292:                     call HistoryGetAttr( &
  1293:                       & InputFile, 'time', 'origin_year', &     ! (in)
  1294:                       & origin_year, &                          ! (out)
  1295:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1296:             
  1297:                     call HistoryGetAttr( &
  1298:                       & InputFile, 'time', 'origin_month', &    ! (in)
  1299:                       & origin_month, &                         ! (out)
  1300:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1301:             
  1302:                     call HistoryGetAttr( &
  1303:                       & InputFile, 'time', 'origin_day', &      ! (in)
  1304:                       & origin_day, &                           ! (out)
  1305:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1306:             
  1307:                     call HistoryGetAttr( &
  1308:                       & InputFile, 'time', 'origin_hour', &     ! (in)
  1309:                       & origin_hour, &                          ! (out)
  1310:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1311:             
  1312:                     call HistoryGetAttr( &
  1313:                       & InputFile, 'time', 'origin_min', &      ! (in)
  1314:                       & origin_min, &                           ! (out)
  1315:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1316:             
  1317:                     call HistoryGetAttr( &
  1318:                       & InputFile, 'time', 'origin_sec', &      ! (in)
  1319:                       & origin_sec, &                           ! (out)
  1320:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1321:             
  1322:                     ! 開始日時の上書き設定
  1323:                     ! Overwrite start date
  1324:                     !
  1325:                     call TimesetSetInitialDate( &
  1326:                       & origin_year, origin_month, origin_day, & ! (in)
  1327:                       & origin_hour, origin_min,   origin_sec )  ! (in)
  1328:             
  1329:                     ! 経過時間の読み込み
  1330:                     ! Input elapsed time
  1331:                     !
  1332:                     call HistoryGet( &
  1333:                       & InputFile, 'time', range = time_range, &  ! (in)
  1334:                       & array = rst_time, &                       ! (out)
  1335:                       & flag_mpi_split = flag_mpi_init )          ! (in) optional
  1336:             
  1337:                     call MessageNotify( 'M', module_name, &
  1338:                       & '  Specified RestartTime from a NAMELIST file            = <%f>, ', &
  1339:                       & d = (/ RestartTime /) )
  1340:                     call MessageNotify( 'M', module_name, &
  1341:                       & '  Actual initial value of TimeN  from a restart file  = <%f>', &
  1342:                       & d = (/ rst_time /) )
  1343:             
  1344:                     ! 経過時間の上書き設定
  1345:                     ! Overwrite elapsed time
  1346:                     !
  1347:                     call TimesetSetTimeN( rst_time )
  1348:             
  1349:                   end if
  1350:             
  1351:                   ! データ入力
  1352:                   ! Data input
  1353:                   ! 
  1354:                   if ( flag_rst == 0 ) then
  1355:                     call HistoryGet( &
  1356:                       & InputFile, 'U', &                 ! (in)
  1357:                       & array = xyz_UB, &                 ! (out)
  1358:                       & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1359:                     call HistoryGet( &
  1360:                       & InputFile, 'V', &                 ! (in)
  1361:                       & array = xyz_VB, &                 ! (out)
  1362:                       & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1363:                     call HistoryGet( &
  1364:                       & InputFile, 'Temp', &              ! (in)
  1365:                       & array = xyz_TempB, &              ! (out)
  1366:                       & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1367: +------>            do n = 1, ncmax
  1368: |                     call HistoryGet(                           &
  1369: |                       & InputFile, trim(a_QMixName(n)),        &              ! (in)
  1370: |                       & array = xyzf_QMixB(:,:,:,n),           &              ! (out)
  1371: |                       & flag_mpi_split = flag_mpi_init         &              ! (in) optional
  1372: |                       & )
  1373: +------             end do
  1374:                     call HistoryGet( &
  1375:                       & InputFile, 'Ps', &                ! (in)
  1376:                       & array = xy_PsB, &                 ! (out)
  1377:                       & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1378:             
  1379:                     call MessageNotify( 'M', module_name, &
  1380:                       & 'Initial data (not restart data) is input ' // &
  1381:                       & 'from a data file "%c". ' // &
  1382:                       & '*B (t-dt) and *N (t) are same.', &
  1383:                       & c1 = trim(InputFile) )
  1384:             
  1385: **V---->A           xyz_UN     = xyz_UB
  1386: |||     A           xyz_VN     = xyz_VB
  1387: **V---- A           xyz_TempN  = xyz_TempB
  1388: W***=== A           xyzf_QMixN = xyzf_QMixB
  1389: +V===== A           xy_PsN     = xy_PsB
  1390:             
  1391:                   else
  1392:                     call HistoryGet( &
  1393:                       & InputFile, 'UB', range = time_range, &  ! (in)
  1394:                       & array = xyz_UB, &                       ! (out)
  1395:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1396:                     call HistoryGet( &
  1397:                       & InputFile, 'VB', range = time_range, &  ! (in)
  1398:                       & array = xyz_VB, &                       ! (out)
  1399:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1400:                     call HistoryGet( &
  1401:                       & InputFile, 'TempB', range = time_range, &  ! (in)
  1402:                       & array = xyz_TempB, &                       ! (out)
  1403:                       & flag_mpi_split = flag_mpi_init )           ! (in) optional
  1404: +------>            do n = 1, ncmax
  1405: |                     call HistoryGet(                                             &
  1406: |                       & InputFile, trim(a_QMixName(n))//'B', range = time_range, & ! (in)
  1407: |                       & array = xyzf_QMixB(:,:,:,n),                             & ! (out)
  1408: |                       & flag_mpi_split = flag_mpi_init                           & ! (in) optional
  1409: |                       & )
  1410: +------             end do
  1411:                     call HistoryGet( &
  1412:                       & InputFile, 'PsB', range = time_range, &  ! (in)
  1413:                       & array = xy_PsB, &                        ! (out)
  1414:                       & flag_mpi_split = flag_mpi_init )         ! (in) optional
  1415:             
  1416:                     call HistoryGet( &
  1417:                       & InputFile, 'UN', range = time_range, &  ! (in)
  1418:                       & array = xyz_UN, &                       ! (out)
  1419:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1420:                     call HistoryGet( &
  1421:                       & InputFile, 'VN', range = time_range, &  ! (in)
  1422:                       & array = xyz_VN, &                       ! (out)
  1423:                       & flag_mpi_split = flag_mpi_init )        ! (in) optional
  1424:                     call HistoryGet( &
  1425:                       & InputFile, 'TempN', range = time_range, &  ! (in)
  1426:                       & array = xyz_TempN, &                       ! (out)
  1427:                       & flag_mpi_split = flag_mpi_init )           ! (in) optional
  1428: +------>            do n = 1, ncmax
  1429: |                     call HistoryGet(                                             &
  1430: |                       & InputFile, trim(a_QMixName(n))//'N', range = time_range, & ! (in)
  1431: |                       & array = xyzf_QMixN(:,:,:,n),                             & ! (out)
  1432: |                       & flag_mpi_split = flag_mpi_init                           & ! (in) optional
  1433: |                       & )
  1434: +------             end do
  1435:                     call HistoryGet( &
  1436:                       & InputFile, 'PsN', range = time_range, &  ! (in)
  1437:                       & array = xy_PsN, &                        ! (out)
  1438:                       & flag_mpi_split = flag_mpi_init )         ! (in) optional
  1439:             
  1440:                     call MessageNotify( 'M', module_name, &
  1441:                       & 'Restart data (not initial data) is input ' // &
  1442:                       & 'from a data file "%c". ', &
  1443:                       & c1 = trim(InputFile) )
  1444:                   end if
  1445:             
  1446:                 end if
  1447:             
  1448:               end subroutine RestartFileGet
  1449:             
  1450:               !--------------------------------------------------------------------------------------
  1451:             
  1452:               subroutine RestartFileInit
  1453:                 !
  1454:                 ! restart_file_io モジュールの初期化を行います. 
  1455:                 ! NAMELIST#restart_file_io_nml の読み込みはこの手続きで行われます. 
  1456:                 !
  1457:                 ! "restart_file_io" module is initialized. 
  1458:                 ! "NAMELIST#restart_file_io_nml" is loaded in this procedure. 
  1459:                 !
  1460:             
  1461:                 ! モジュール引用 ; USE statements
  1462:                 !
  1463:             
  1464:                 ! 時刻管理
  1465:                 ! Time control
  1466:                 !
  1467:                 use timeset, only: &
  1468:                   & RestartTime           ! リスタート開始時刻. 
  1469:                                           ! Restart time of calculation
  1470:             
  1471:                 ! NAMELIST ファイル入力に関するユーティリティ
  1472:                 ! Utilities for NAMELIST file input
  1473:                 !
  1474:                 use namelist_util, only: namelist_filename, NmlutilMsg
  1475:             
  1476:                 ! 暦と日時の取り扱い
  1477:                 ! Calendar and Date handler
  1478:                 !
  1479:                 use dc_calendar, only: DCCalConvertByUnit
  1480:             
  1481:                 ! ファイル入出力補助
  1482:                 ! File I/O support
  1483:                 !
  1484:                 use dc_iounit, only: FileOpen
  1485:             
  1486:                 ! 種別型パラメタ
  1487:                 ! Kind type parameter
  1488:                 !
  1489:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1490:             
  1491:                 ! 初期値データ (リスタートデータ) 提供
  1492:                 ! Prepare initial data (restart data)
  1493:                 !
  1494:                 use initial_data, only: InitDataInit
  1495:             
  1496:             
  1497:                 ! 宣言文 ; Declaration statements
  1498:                 !
  1499:                 implicit none
  1500:             
  1501:                 ! 作業変数
  1502:                 ! Work variables
  1503:                 !
  1504:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1505:                                           ! Unit number for NAMELIST file open
  1506:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1507:                                           ! IOSTAT of NAMELIST read
  1508:             
  1509:                 ! NAMELIST 変数群
  1510:                 ! NAMELIST group name
  1511:                 !
  1512:                 namelist /restart_file_io_nml/ &
  1513:                   & InputFile, &
  1514:                   & OutputFile, &
  1515:                   & IntValue, IntUnit
  1516:                       !
  1517:                       ! デフォルト値については初期化手続 "restart_file_io#RestartFileInit" 
  1518:                       ! のソースコードを参照のこと. 
  1519:                       !
  1520:                       ! Refer to source codes in the initialization procedure
  1521:                       ! "restart_file_io#RestartFileInit" for the default values. 
  1522:                       !
  1523:             
  1524:             
  1525:                 ! 実行文 ; Executable statement
  1526:                 !
  1527:             
  1528:                 if ( restart_file_io_inited ) return
  1529:             
  1530:             
  1531:                 ! デフォルト値の設定
  1532:                 ! Default values settings
  1533:                 !
  1534:                 InputFile  = ''
  1535:                 if ( .not. flag_init_data_save ) then
  1536:                   OutputFile = 'rst.nc'
  1537:                 else
  1538:                   OutputFile = 'init.nc'
  1539:                 end if
  1540:                 IntValue   = 365.0d0
  1541:                 IntUnit    = 'day'
  1542:             
  1543:                 ! NAMELIST の読み込み
  1544:                 ! NAMELIST is input
  1545:                 !
  1546:                 if ( trim(namelist_filename) /= '' ) then
  1547:                   call FileOpen( unit_nml, &          ! (out)
  1548:                     & namelist_filename, mode = 'r' ) ! (in)
  1549:             
  1550:                   rewind( unit_nml )
  1551:                   read( unit_nml, &         ! (in)
  1552:                     & nml = restart_file_io_nml, &  ! (out)
  1553:                     & iostat = iostat_nml ) ! (out)
  1554:                   close( unit_nml )
  1555:             
  1556:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1557:                   if ( iostat_nml == 0 ) write( STDOUT, nml = restart_file_io_nml )
  1558:                 end if
  1559:             
  1560:                 ! 出力時間間隔の設定
  1561:                 ! Configure time interval of output
  1562:                 !
  1563:                 IntTime = DCCalConvertByUnit( IntValue, IntUnit, 'sec' ) ! (in)
  1564:                 PrevOutputTime = RestartTime
  1565:             
  1566:                 ! フラグの初期化
  1567:                 ! Initialize flag
  1568:                 !
  1569:                 flag_output_end = .false.
  1570:             
  1571:             
  1572:                 ! Initialization of modules used in this module
  1573:             
  1574:                 ! 初期値データ (リスタートデータ) 提供
  1575:                 ! Prepare initial data (restart data)
  1576:                 !
  1577:                 call InitDataInit
  1578:             
  1579:             
  1580:                 ! 印字 ; Print
  1581:                 !
  1582:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1583:                 call MessageNotify( 'M', module_name, 'Input:: ' )
  1584:                 if ( trim(InputFile) /= '' ) then
  1585:                   call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
  1586:                 else
  1587:                   call MessageNotify( 'M', module_name, '  InputFile  = <Non>' )
  1588:                   call MessageNotify( 'M', module_name, '  ** Initial data is generated in "initial_data" module' )
  1589:                 end if
  1590:                 call MessageNotify( 'M', module_name, 'Output:: ' )
  1591:                 call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
  1592:                 call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
  1593:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1594:             
  1595:                 restart_file_io_inited = .true.
  1596:             
  1597:               end subroutine RestartFileInit
  1598:             
  1599:               !--------------------------------------------------------------------------------------
  1600:             
  1601:             end module restart_file_io
