Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:32 2016
FILE NAME: restart_surftemp_io.f90
PROGRAM NAME: restart_surftemp_io
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   427  vec  (   4): Vectorized array expression.
   427  vec  (  29): ADB is used for array.: x_lon
   432  vec  (   4): Vectorized array expression.
   432  vec  (  29): ADB is used for array.: y_lat
   815  vec  (   3): Unvectorized loop.
   815  vec  (  13): Overhead of loop division is too large.
   816  opt  (1592): Outer loop unrolled inside inner loop.
   816  vec  (   4): Vectorized array expression.
   816  vec  (  29): ADB is used for array.: xyz_soiltemp
   816  vec  (  29): ADB is used for array.: xy_surftemp
   816  vec  (   4): Vectorized array expression.
   816  vec  (  29): ADB is used for array.: xyz_soiltemp
   816  vec  (  29): ADB is used for array.: xy_surftemp
   819  vec  (   3): Unvectorized loop.
   819  vec  (  13): Overhead of loop division is too large.
   820  opt  (1592): Outer loop unrolled inside inner loop.
   820  vec  (   4): Vectorized array expression.
   820  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   820  vec  (  29): ADB is used for array.: xy_surftemp
   820  vec  (   4): Vectorized array expression.
   820  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   820  vec  (  29): ADB is used for array.: xy_surftemp
   822  opt  (  11): Fused array assignments. :line 822 - 830
   822  vec  (   4): Vectorized array expression.
   822  vec  (  29): ADB is used for array.: xy_surfsnown
   822  vec  (  29): ADB is used for array.: xy_soilmoistn
   822  vec  (  29): ADB is used for array.: xy_surfmajcompicen
   822  vec  (  29): ADB is used for array.: xy_surfsnowb
   822  vec  (  29): ADB is used for array.: xy_soilmoistb
   822  vec  (  29): ADB is used for array.: xy_surfmajcompiceb
   822  vec  (  29): ADB is used for array.: xy_soseaicemass
   864  vec  (   3): Unvectorized loop.
   864  vec  (  13): Overhead of loop division is too large.
   865  opt  (1592): Outer loop unrolled inside inner loop.
   865  vec  (   4): Vectorized array expression.
   865  vec  (  29): ADB is used for array.: xyz_soiltemp
   865  vec  (  29): ADB is used for array.: xy_surftemp
   865  vec  (   4): Vectorized array expression.
   865  vec  (  29): ADB is used for array.: xyz_soiltemp
   865  vec  (  29): ADB is used for array.: xy_surftemp
   884  vec  (   3): Unvectorized loop.
   884  vec  (  13): Overhead of loop division is too large.
   885  opt  (1592): Outer loop unrolled inside inner loop.
   885  vec  (   4): Vectorized array expression.
   885  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   885  vec  (  29): ADB is used for array.: xy_surftemp
   885  vec  (   4): Vectorized array expression.
   885  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   885  vec  (  29): ADB is used for array.: xy_surftemp
   903  opt  (1592): Outer loop unrolled inside inner loop.
   903  vec  (   4): Vectorized array expression.
   903  vec  (  29): ADB is used for array.: xy_soseaicemass
   903  vec  (   4): Vectorized array expression.
   903  vec  (  29): ADB is used for array.: xy_soseaicemass
   919  opt  (1592): Outer loop unrolled inside inner loop.
   919  vec  (   4): Vectorized array expression.
   919  vec  (  29): ADB is used for array.: xy_surfmajcompiceb
   919  vec  (   4): Vectorized array expression.
   919  vec  (  29): ADB is used for array.: xy_surfmajcompiceb
   935  opt  (1592): Outer loop unrolled inside inner loop.
   935  vec  (   4): Vectorized array expression.
   935  vec  (  29): ADB is used for array.: xy_soilmoistb
   935  vec  (   4): Vectorized array expression.
   935  vec  (  29): ADB is used for array.: xy_soilmoistb
   951  opt  (1592): Outer loop unrolled inside inner loop.
   951  vec  (   4): Vectorized array expression.
   951  vec  (  29): ADB is used for array.: xy_surfsnowb
   951  vec  (   4): Vectorized array expression.
   951  vec  (  29): ADB is used for array.: xy_surfsnowb
   967  opt  (1592): Outer loop unrolled inside inner loop.
   967  vec  (   4): Vectorized array expression.
   967  vec  (  29): ADB is used for array.: xy_surfmajcompicen
   967  vec  (  29): ADB is used for array.: xy_surfmajcompiceb
   967  vec  (   4): Vectorized array expression.
   967  vec  (  29): ADB is used for array.: xy_surfmajcompicen
   967  vec  (  29): ADB is used for array.: xy_surfmajcompiceb
   983  opt  (1592): Outer loop unrolled inside inner loop.
   983  vec  (   4): Vectorized array expression.
   983  vec  (  29): ADB is used for array.: xy_soilmoistn
   983  vec  (  29): ADB is used for array.: xy_soilmoistb
   983  vec  (   4): Vectorized array expression.
   983  vec  (  29): ADB is used for array.: xy_soilmoistn
   983  vec  (  29): ADB is used for array.: xy_soilmoistb
   999  opt  (1592): Outer loop unrolled inside inner loop.
   999  vec  (   4): Vectorized array expression.
   999  vec  (  29): ADB is used for array.: xy_surfsnown
   999  vec  (  29): ADB is used for array.: xy_surfsnowb
   999  vec  (   4): Vectorized array expression.
   999  vec  (  29): ADB is used for array.: xy_surfsnown
   999  vec  (  29): ADB is used for array.: xy_surfsnowb
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:32 2016
FILE NAME: restart_surftemp_io.f90
PROGRAM NAME: restart_surftemp_io
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地表面温度リスタートデータ, 初期値データ入出力
     2  !
     3  != Restart data, initial data of surface temperature input/output
     4  !
     5  ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: restart_surftemp_io.f90,v 1.11 2014/05/07 09:39:18 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module restart_surftemp_io
    13    !
    14    != 地表面温度リスタートデータ, 初期値データ入出力
    15    !
    16    != Restart data, initial data of surface temperature input/output
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 地表面温度のリスタートデータもしくは初期値データの入出力を行います.
    21    ! 入力ファイル, 出力ファイル, データの出力の間隔は
    22    ! NAMELIST#restart_surftemp_io_nml で設定します.
    23    !
    24    ! リスタートデータの入力ファイルが指定されない場合,
    25    ! surface_data モジュールで生成された初期値データを取得します.
    26    !
    27    ! Restart data or initial data is input/output.
    28    ! Settings of input file, output file, and interval of data output
    29    ! is configured by "NAMELIST#restart_surftemp_io_nml".
    30    !
    31    ! If input file of restart data is not set,
    32    ! initial data is generated in "surface_data" module, and
    33    ! obtained data from the module.
    34    !
    35    !== Procedures List
    36    !
    37    ! RestartSurfTempOpen   :: リスタートファイルのオープン
    38    ! RestartSurfTempOutput :: リスタートファイルへのデータ出力
    39    ! RestartSurfTempClose  :: リスタートファイルのクローズ
    40    ! RestartSurfTempGet    :: リスタートファイルの入力
    41    ! ------------      :: ------------
    42    ! RestartSurfTempOpen   :: Open restart file
    43    ! RestartSurfTempOutput :: Data output to restart file
    44    ! RestartSurfTempClose  :: Close restart file
    45    ! RestartSurfTempGet    :: Input restart file
    46    !
    47    !== NAMELIST
    48    !
    49    ! NAMELIST#restart_surftemp_io_nml
    50    !
    51  
    52    ! モジュール引用 ; USE statements
    53    !
    54  
    55    ! 格子点設定
    56    ! Grid points settings
    57    !
    58    use gridset, only: imax, & ! 経度格子点数.
    59                               ! Number of grid points in longitude
    60      &                jmax, & ! 緯度格子点数.
    61                               ! Number of grid points in latitude
    62      &                kmax, & ! 鉛直層数.
    63                               ! Number of vertical level
    64      &                kslmax, & ! 地下の鉛直層数.
    65                                 ! Number of subsurface vertical level
    66      &                ksimax    ! 海氷の鉛直層数.
    67                                 ! Number of sea ice vertical level
    68  
    69    ! 種別型パラメタ
    70    ! Kind type parameter
    71    !
    72    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    73      &                 STRING, &  ! 文字列.       Strings.
    74      &                 TOKEN      ! キーワード.   Keywords.
    75  
    76    ! メッセージ出力
    77    ! Message output
    78    !
    79    use dc_message, only: MessageNotify
    80  
    81    ! gtool4 データ出力
    82    ! Gtool4 data output
    83    !
    84    use gtool_history, only: GT_HISTORY
    85  
    86    ! 宣言文 ; Declaration statements
    87    !
    88    implicit none
    89    private
    90  
    91    ! 公開手続き
    92    ! Public procedure
    93    !
    94    public :: RestartSurfTempInit
    95    public :: RestartSurfTempOpen, RestartSurfTempClose, RestartSurfTempOutPut
    96    public :: RestartSurfTempGet
    97  
    98    ! 公開変数
    99    ! Public variables
   100    !
   101    logical, save, public:: restart_surftemp_io_inited = .false.
   102                                ! 初期設定フラグ.
   103                                ! Initialization flag
   104  
   105    logical, save, public:: restart_surftemp_opened = .false.
   106                                ! リスタートファイルのオープンに関するフラグ.
   107                                ! Flag of restart file open
   108  
   109    ! 非公開変数
   110    ! Private variables
   111    !
   112    logical, save:: flag_init_data_save
   113                                ! 初期値データを作成する場合は,
   114                                ! この引数に .true. を与えます.
   115                                !
   116                                ! If initial data is created,
   117                                ! give ".true." to this argument.
   118  
   119    character(STRING), save:: InputFile
   120                                ! 入力するリスタートデータのファイル名
   121                                ! Filename of input restart data
   122  
   123    ! This is not used, and variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
   124  !!$  character(TOKEN), save:: InputName
   125  !!$                              ! 入力するリスタートデータの変数名
   126  !!$                              ! Variable name of input restart data
   127  
   128    character(STRING), save:: OutputFile
   129                                ! 出力するリスタートデータのファイル名
   130                                ! Filename of output restart data
   131    real(DP), save:: IntValue
   132                                ! リスタートデータの出力間隔.
   133                                ! Interval of restart data output
   134    character(TOKEN):: IntUnit
   135                                ! リスタートデータの出力間隔の単位.
   136                                ! Unit for interval of restart data output
   137  
   138    type(GT_HISTORY), save:: gthst_rst
   139                                ! リスタートデータ用 gtool_history#GT_HISTORY 変数
   140                                ! "gtool_history#GT_HISTORY" variable for restart data
   141  
   142    real(DP), save:: PrevOutputTime
   143                                ! 前回の出力時間.
   144                                ! Previous output time
   145    logical, save:: flag_output_end
   146                                ! 計算最終時刻の出力完了のフラグ.
   147                                ! Flag for completion of output at the end time of calculation
   148  
   149    real(DP), save:: IntTime
   150                                ! リスタートデータの出力時間.
   151                                ! Time interval of restart data output
   152  
   153    character(*), parameter:: time_name = 'time'
   154                                ! 時刻の次元の変数名
   155                                ! Variable name of time dimension
   156    character(*), parameter:: deltime_name = 'deltime'
   157                                ! Δt の変数名
   158                                ! Variable name of Delta t
   159  
   160  
   161    character(*), parameter:: module_name = 'restart_surftemp_io'
   162                                ! モジュールの名称.
   163                                ! Module name
   164    character(*), parameter:: version = &
   165      & '$Name:  $' // &
   166      & '$Id: restart_surftemp_io.f90,v 1.11 2014/05/07 09:39:18 murashin Exp $'
   167                                ! モジュールのバージョン
   168                                ! Module version
   169  
   170  contains
   171  
   172    !--------------------------------------------------------------------------------------
   173  
   174    subroutine RestartSurfTempOpen( flag_init_data )
   175      !
   176      ! リスタートファイルをオープンします.
   177      !
   178      ! A restart file is opened.
   179      !
   180  
   181      ! モジュール引用 ; USE statements
   182      !
   183  
   184      ! 出力ファイルの基本情報
   185      ! Basic information for output files
   186      !
   187      use fileset, only: &
   188        & FileTitle, &
   189                                ! 出力データファイルの表題.
   190                                ! Title of output data files
   191        & FileSource, &
   192                                ! データファイル作成の手段.
   193                                ! Source of data file
   194        & FileInstitution
   195                                ! データファイルを最終的に変更した組織/個人.
   196                                ! Institution or person that changes data files for the last time
   197  
   198      ! 物理・数学定数設定
   199      ! Physical and mathematical constants settings
   200      !
   201      use constants0, only: &
   202        & PI                    ! $ \pi $.
   203                                ! 円周率. Circular constant
   204  
   205      ! 座標データ設定
   206      ! Axes data settings
   207      !
   208      use axesset, only: &
   209        & x_Lon, &
   210                                ! $ \lambda $ [rad.] . 経度. Longitude
   211        & x_Lon_Weight, &
   212                                ! $ \Delta \lambda $ [rad.] .
   213                                ! 経度座標重み.
   214                                ! Weight of longitude
   215        & y_Lat, &
   216                                ! $ \varphi $ [rad.] . 緯度. Latitude
   217        & y_Lat_Weight, &
   218                                ! $ \Delta \varphi $ [rad.] .
   219                                ! 緯度座標重み.
   220                                ! Weight of latitude
   221        & z_SSDepth, &
   222                                ! 地下の格子点の深さ
   223                                ! subsurface grid at midpoint of layer
   224        & z_SIDepth
   225                                ! 海氷の格子点の深さ
   226                                ! sea ice grid at midpoint of layer
   227  
   228      ! 時刻管理
   229      ! Time control
   230      !
   231      use timeset, only: &
   232        & DelTime, &            ! $ \Delta t $ [s]
   233        & RestartTime           ! リスタート開始時刻.
   234                                ! Retart time of calculation
   235  
   236      ! gtool4 データ出力
   237      ! Gtool4 data output
   238      !
   239      use gtool_history, only: HistoryCreate, HistoryAddVariable, &
   240        & HistoryPut, HistoryAddAttr
   241  
   242      ! 文字列操作
   243      ! Character handling
   244      !
   245      use dc_string, only: StoA, CPrintf, LChar
   246  
   247      ! 組み込み関数 PRESENT の拡張版関数
   248      ! Extended functions of intrinsic function "PRESENT"
   249      !
   250      use dc_present, only: present_and_true
   251  
   252      ! 宣言文 ; Declaration statements
   253      !
   254      logical, intent(in), optional:: flag_init_data
   255                                ! 初期値データを作成する場合は,
   256                                ! この引数に .true. を与えます.
   257                                !
   258                                ! If initial data is created,
   259                                ! give ".true." to this argument.
   260  
   261      ! 作業変数
   262      ! Work variables
   263      !
   264      integer                       :: NDims
   265      character(STRING), allocatable:: a_DimNames    (:)
   266      integer          , allocatable:: a_DimLens     (:)
   267      character(STRING), allocatable:: a_DimLongNames(:)
   268      character(STRING), allocatable:: a_DimUnits    (:)
   269  
   270      character(STRING):: title_msg
   271                                ! 表題に付加するメッセージ.
   272                                ! Message added to title
   273      real(DP):: origin_time
   274                                ! 計算開始時刻.
   275                                ! Start time of calculation
   276      character(STRING):: time_unit
   277                                ! 日時の単位. Units of date and time
   278  
   279      logical:: flag_mpi_init
   280  
   281      integer:: n
   282  
   283  
   284      ! 実行文 ; Executable statement
   285      !
   286  
   287      ! 初期化
   288      ! Initialization
   289      !
   290      flag_init_data_save = present_and_true( flag_init_data )
   291      if ( .not. restart_surftemp_io_inited ) then
   292        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   293      end if
   294      if ( restart_surftemp_opened ) return
   295  
   296      ! 表題に付加するメッセージの設定
   297      ! Configure message added to title
   298      !
   299      if ( .not. flag_init_data_save ) then
   300        title_msg = ' restart data of surface temperature'
   301      else
   302        title_msg = ' initial data of surface temperature'
   303      end if
   304  
   305      ! 時刻情報の取得
   306      ! Get time information
   307      !
   308      if ( .not. flag_init_data_save ) then
   309        origin_time = RestartTime + IntTime
   310      else
   311        origin_time = RestartTime
   312      end if
   313  
   314      time_unit = IntUnit
   315  
   316      flag_mpi_init = .true.
   317  
   318      ! リスタートファイルのオープン
   319      ! Open a restart file
   320      !
   321      n = 3                              ! lon, lat, time
   322      if ( kslmax /= 0 ) n = n + 1       ! dep
   323      if ( ksimax /= 0 ) n = n + 1       ! sidep
   324      NDims = n
   325      !
   326      allocate( a_DimNames    ( 1:NDims ) )
   327      allocate( a_DimLens     ( 1:NDims ) )
   328      allocate( a_DimLongNames( 1:NDims ) )
   329      allocate( a_DimUnits    ( 1:NDims ) )
   330      !
   331      n = 1 ! lon
   332      a_DimNames    (n) = 'lon'
   333      a_DimLens     (n) = imax
   334      a_DimLongNames(n) = 'longitude'
   335      a_DimUnits    (n) = 'degrees_east'
   336      n = n + 1 ! lat
   337      a_DimNames    (n) = 'lat'
   338      a_DimLens     (n) = jmax
   339      a_DimLongNames(n) = 'latitude'
   340      a_DimUnits    (n) = 'degrees_north'
   341      if ( kslmax /= 0 ) then
   342        n = n + 1 ! dep
   343        a_DimNames    (n) = 'dep'
   344        a_DimLens     (n) = kslmax
   345        a_DimLongNames(n) = 'depth'
   346        a_DimUnits    (n) = 'm'
   347      end if
   348      if ( ksimax /= 0 ) then
   349        n = n + 1 ! sidep
   350        a_DimNames    (n) = 'sidep'
   351        a_DimLens     (n) = ksimax
   352        a_DimLongNames(n) = 'depth'
   353        a_DimUnits    (n) = 'm'
   354      end if
   355      n = n + 1 ! time
   356      a_DimNames    (n) = time_name
   357      a_DimLens     (n) = 0
   358      a_DimLongNames(n) = time_name
   359      a_DimUnits    (n) = time_unit
   360      !
   361  !!$    call HistoryCreate(                                                     &
   362  !!$      &      file = OutputFile,                                             &  ! (in)
   363  !!$      &     title = trim(FileTitle) // trim(title_msg),                     &  ! (in)
   364  !!$      &    source = FileSource, institution = FileInstitution,              &  ! (in)
   365  !!$      &      dims = StoA( 'lon  ', 'lat  ', 'dep  ', 'sidep', time_name ),  &  ! (in)
   366  !!$      &  dimsizes = (/ imax, jmax, kslmax, ksimax, 0 /),                    &  ! (in)
   367  !!$      & longnames = StoA( 'longitude', 'latitude', 'depth   ', 'depth   ', time_name ), &  ! (in)
   368  !!$      &     units = StoA( 'degrees_east', 'degrees_north', 'm            ', 'm            ', &  ! (in)
   369  !!$      &                    time_unit ),                                     &  ! (in)
   370  !!$      &        origind = origin_time,                                       &  ! (in) optional
   371  !!$      &      intervald = IntValue,                                          &  ! (in) optional
   372  !!$      & flag_mpi_split = flag_mpi_init,                                     &  ! (in) optional
   373  !!$      &        history = gthst_rst                                          &  ! (out) optional
   374  !!$      & )
   375      call HistoryCreate(                                        &
   376        &      file = OutputFile,                                &  ! (in)
   377        &     title = trim(FileTitle) // trim(title_msg),        &  ! (in)
   378        &    source = FileSource, institution = FileInstitution, &  ! (in)
   379        &      dims = a_DimNames,                                &  ! (in)
   380        &  dimsizes = a_DimLens,                                 &  ! (in)
   381        & longnames = a_DimLongNames,                            &  ! (in)
   382        &     units = a_DimUnits,                                &  ! (in)
   383        &        origind = origin_time,                          &  ! (in) optional
   384        &      intervald = IntValue,                             &  ! (in) optional
   385        & flag_mpi_split = flag_mpi_init,                        &  ! (in) optional
   386        &        history = gthst_rst                             &  ! (out) optional
   387        & )
   388      !
   389      deallocate( a_DimNames     )
   390      deallocate( a_DimLens      )
   391      deallocate( a_DimLongNames )
   392      deallocate( a_DimUnits     )
   393  
   394      ! 座標データの設定
   395      ! Axes data settings
   396      !
   397      call HistoryAddAttr(                                 &
   398        & varname = 'lon', attrname = 'standard_name',     & ! (in)
   399        & value = 'longitude',                             & ! (in)
   400        & history = gthst_rst                              & ! (inout)
   401        & )
   402      call HistoryAddAttr(                                 &
   403        & varname = 'lat', attrname = 'standard_name',     & ! (in)
   404        & value = 'latitude',                              & ! (in)
   405        & history = gthst_rst                              & ! (inout)
   406        & )
   407      if ( kslmax /= 0 ) then
   408        call HistoryAddAttr(                                 &
   409          & varname = 'dep', attrname = 'standard_name',     & ! (in)
   410          & value = 'depth',                                 & ! (in)
   411          & history = gthst_rst                              & ! (inout)
   412          & )
   413      end if
   414      if ( ksimax /= 0 ) then
   415        call HistoryAddAttr(                                 &
   416          & varname = 'sidep', attrname = 'standard_name',   & ! (in)
   417          & value = 'depth',                                 & ! (in)
   418          & history = gthst_rst                              & ! (inout)
   419          & )
   420      end if
   421      call HistoryAddAttr(                                 &
   422        & varname = time_name, attrname = 'standard_name', & ! (in)
   423        & value = 'time',                                  & ! (in)
   424        & history = gthst_rst                              & ! (inout)
   425        & )
   426  
   427      call HistoryPut(                   &
     .        d1 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t745 = 1, x_lon.DSC.U1 + 1 - x_lon.DSC.L1                      
     .           %IG2(t745) = x_lon(x_lon.DSC.L1+t745-1)*d1*                    
     .       1      1.80000000000000e+002                                       
     .        enddo                                                             
   428        & varname = 'lon',               & ! (in)
   429        & array = x_Lon / PI * 180.0_DP, & ! (in)
   430        & history = gthst_rst            & ! (inout)
   431        & )
   432      call HistoryPut(                   &
     .        d2 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t749 = 1, y_lat.DSC.U1 + 1 - y_lat.DSC.L1                      
     .           %IG5(t749) = y_lat(y_lat.DSC.L1+t749-1)*d2*                    
     .       1      1.80000000000000e+002                                       
     .        enddo                                                             
   433        & varname = 'lat',               & ! (in)
   434        & array = y_Lat / PI * 180.0_DP, & ! (in)
   435        & history = gthst_rst            & ! (inout)
   436        & )
   437      if ( kslmax /= 0 ) then
   438        call HistoryPut(                   &
   439          & varname = 'dep',               & ! (in)
   440          & array = z_SSDepth,             & ! (in)
   441          & history = gthst_rst            & ! (inout)
   442          & )
   443      end if
   444      if ( ksimax /= 0 ) then
   445        call HistoryPut(                   &
   446          & varname = 'sidep',             & ! (in)
   447          & array = z_SIDepth,             & ! (in)
   448          & history = gthst_rst            & ! (inout)
   449          & )
   450      end if
   451  
   452      ! 座標重みの設定
   453      ! Axes weights settings
   454      !
   455      call HistoryAddVariable( &
   456        & varname = 'lon_weight', &                           ! (in)
   457        & dims = StoA('lon'), &                               ! (in)
   458        & longname = 'weight for integration in longitude', & ! (in)
   459        & units = 'radian', xtype = 'double', &               ! (in)
   460        & history = gthst_rst )                               ! (inout)
   461      call HistoryAddAttr( &
   462        & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
   463        & value = 'lon_weight', &                             ! (in)
   464        & history = gthst_rst )                               ! (inout)
   465      call HistoryPut( &
   466        & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
   467        & history = gthst_rst )                               ! (inout)
   468  
   469      call HistoryAddVariable( &
   470        & varname = 'lat_weight', &                           ! (in)
   471        & dims = StoA('lat'), &                               ! (in)
   472        & longname = 'weight for integration in latitude', &  ! (in)
   473        & units = 'radian', xtype = 'double', &               ! (in)
   474        & history = gthst_rst )                               ! (inout)
   475      call HistoryAddAttr( &
   476        & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
   477        & value = 'lat_weight', &                             ! (in)
   478        & history = gthst_rst )                               ! (inout)
   479      call HistoryPut( &
   480        & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
   481        & history = gthst_rst )                               ! (inout)
   482  
   483      ! 予報変数の設定
   484      ! Predictional variables settings
   485      !
   486      call HistoryAddVariable(                  &
   487        & varname = 'SurfTemp',                 & ! (in)
   488        & dims = StoA('lon', 'lat', time_name), & ! (in)
   489        & longname = 'surface temperature',     & ! (in)
   490        & units = 'K', xtype = 'double',        & ! (in)
   491        & history = gthst_rst                   & ! (inout)
   492        & )
   493      if ( kslmax /= 0 ) then
   494        call HistoryAddVariable(                         &
   495          & varname = 'SoilTemp',                        & ! (in)
   496          & dims = StoA('lon', 'lat', 'dep', time_name), & ! (in)
   497          & longname = 'soil temperature',               & ! (in)
   498          & units = 'K', xtype = 'double',               & ! (in)
   499          & history = gthst_rst                          & ! (inout)
   500          & )
   501      end if
   502      if ( ksimax /= 0 ) then
   503        call HistoryAddVariable(                           &
   504          & varname = 'SOSeaIceTemp',                      & ! (in)
   505          & dims = StoA('lon', 'lat', 'sidep', time_name), & ! (in)
   506          & longname = 'sea ice temperature',              & ! (in)
   507          & units = 'K', xtype = 'double',                 & ! (in)
   508          & history = gthst_rst                            & ! (inout)
   509          & )
   510      end if
   511      call HistoryAddVariable(                     &
   512        & varname = 'SOSeaIceMass',                & ! (in)
   513        & dims = StoA('lon', 'lat', time_name),    & ! (in)
   514        & longname = 'slab sea ice mass',          & ! (in)
   515        & units = 'kg m-2', xtype = 'double',      & ! (in)
   516        & history = gthst_rst                      & ! (inout)
   517        & )
   518      call HistoryAddVariable(                  &
   519        & varname = 'SurfMajCompIceB',          & ! (in)
   520        & dims = StoA('lon', 'lat', time_name), & ! (in)
   521        & longname = 'major component ice amount on the surface', & ! (in)
   522        & units = 'kg m-2', xtype = 'double',   & ! (in)
   523        & history = gthst_rst                   & ! (inout)
   524        & )
   525      call HistoryAddVariable(                  &
   526        & varname = 'SoilMoistB',               & ! (in)
   527        & dims = StoA('lon', 'lat', time_name), & ! (in)
   528        & longname = 'soil moisture',           & ! (in)
   529        & units = 'kg m-2', xtype = 'double',   & ! (in)
   530        & history = gthst_rst                   & ! (inout)
   531        & )
   532      call HistoryAddVariable(                     &
   533        & varname = 'SurfSnowB',                   & ! (in)
   534        & dims = StoA('lon', 'lat', time_name),    & ! (in)
   535        & longname = 'snow amount on the surface', & ! (in)
   536        & units = 'kg m-2', xtype = 'double',      & ! (in)
   537        & history = gthst_rst                      & ! (inout)
   538        & )
   539      call HistoryAddVariable(                  &
   540        & varname = 'SurfMajCompIceN',          & ! (in)
   541        & dims = StoA('lon', 'lat', time_name), & ! (in)
   542        & longname = 'major component ice amount on the surface', & ! (in)
   543        & units = 'kg m-2', xtype = 'double',   & ! (in)
   544        & history = gthst_rst                   & ! (inout)
   545        & )
   546      call HistoryAddVariable(                  &
   547        & varname = 'SoilMoistN',               & ! (in)
   548        & dims = StoA('lon', 'lat', time_name), & ! (in)
   549        & longname = 'soil moisture',           & ! (in)
   550        & units = 'kg m-2', xtype = 'double',   & ! (in)
   551        & history = gthst_rst                   & ! (inout)
   552        & )
   553      call HistoryAddVariable(                     &
   554        & varname = 'SurfSnowN',                   & ! (in)
   555        & dims = StoA('lon', 'lat', time_name),    & ! (in)
   556        & longname = 'snow amount on the surface', & ! (in)
   557        & units = 'kg m-2', xtype = 'double',      & ! (in)
   558        & history = gthst_rst                      & ! (inout)
   559        & )
   560  
   561      restart_surftemp_opened = .true.
   562    end subroutine RestartSurfTempOpen
   563  
   564    !--------------------------------------------------------------------------------------
   565  
   566    subroutine RestartSurfTempOutput(                    &
   567      & xy_SurfTemp,                                     & ! (in)
   568      & xyz_SoilTemp,                                    & ! (in) optional
   569      & xyz_SOSeaIceTemp, xy_SOSeaIceMass,               & ! (in) optional
   570      & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in) optional
   571      & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN  & ! (in) optional
   572      & )
   573      !
   574      ! リスタートデータの出力を行います.
   575      !
   576      ! Output restart data
   577  
   578      ! モジュール引用 ; USE statements
   579      !
   580  
   581      ! gtool4 データ出力
   582      ! Gtool4 data output
   583      !
   584      use gtool_history, only: HistoryPut, HistorySetTime
   585  
   586      ! 時刻管理
   587      ! Time control
   588      !
   589      use timeset, only: &
   590        & TimeN, &              ! ステップ $ t $ の時刻.
   591                                ! Time of step $ t $.
   592        & EndTime               ! 計算終了時刻.
   593                                ! End time of calculation
   594  
   595      ! 組み込み関数 PRESENT の拡張版関数
   596      ! Extended functions of intrinsic function "PRESENT"
   597      !
   598      use dc_present, only: present_and_true
   599  
   600      ! 宣言文 ; Declaration statements
   601      !
   602      real(DP), intent(in)           :: xy_SurfTemp (0:imax-1, 1:jmax)
   603                                ! 地表面温度.
   604                                ! Surface temperature
   605      real(DP), intent(in), optional :: xyz_SoilTemp      (0:imax-1, 1:jmax, 1:kslmax)
   606  !!! modified by M. Ishiwatari (2016-12-10)
   607  !!!    real(DP), intent(in), optional :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 1:ksimax)
   608      real(DP), intent(in), optional :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 0:ksimax)
   609      real(DP), intent(in), optional :: xy_SOSeaIceMass   (0:imax-1, 1:jmax)
   610      real(DP), intent(in), optional :: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   611      real(DP), intent(in), optional :: xy_SoilMoistB     (0:imax-1, 1:jmax)
   612      real(DP), intent(in), optional :: xy_SurfSnowB      (0:imax-1, 1:jmax)
   613      real(DP), intent(in), optional :: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
   614      real(DP), intent(in), optional :: xy_SoilMoistN     (0:imax-1, 1:jmax)
   615      real(DP), intent(in), optional :: xy_SurfSnowN      (0:imax-1, 1:jmax)
   616  
   617      ! 作業変数
   618      ! Work variables
   619      !
   620      logical:: flag_output
   621                                ! 出力のフラグ.
   622                                ! Flag for output
   623  
   624      ! 実行文 ; Executable statement
   625      !
   626  
   627      if ( .not. restart_surftemp_opened ) call RestartSurfTempOpen
   628  
   629      ! 出力タイミングのチェック
   630      ! Check output timing
   631      !
   632      flag_output = TimeN - PrevOutputTime >= IntTime
   633      if ( TimeN >= EndTime .and. .not. flag_output_end ) then
   634        flag_output = .true.
   635        flag_output_end = .true.
   636      end if
   637      flag_output = ( .not. TimeN == PrevOutputTime ) .and. flag_output
   638      flag_output = flag_init_data_save .or. flag_output
   639  
   640      if ( .not. flag_output ) return
   641  
   642      ! 次回用に, 今回の出力 (希望) 時刻 を保存
   643      ! Save output time (expected) in this time, for next time
   644      !
   645      PrevOutputTime = PrevOutputTime + IntTime
   646  
   647      ! 時刻の設定
   648      ! Set time
   649      !
   650      call HistorySetTime( timed = TimeN, history = gthst_rst )
   651  
   652      ! データ出力
   653      ! Data output
   654      !
   655      call HistoryPut( 'SurfTemp'  , xy_SurfTemp  , history = gthst_rst ) ! (in)
   656      if ( present( xyz_SoilTemp ) ) then
   657        if ( kslmax /= 0 ) then
   658          call HistoryPut( 'SoilTemp'  , xyz_SoilTemp , history = gthst_rst ) ! (in)
   659        end if
   660      end if
   661      if ( present( xyz_SOSeaIceTemp ) ) then
   662        if ( ksimax /= 0 ) then
   663          call HistoryPut( 'SOSeaIceTemp'  , xyz_SOSeaIceTemp , history = gthst_rst ) ! (in)
   664        end if
   665      end if
   666      if ( present( xy_SOSeaIceMass ) ) then
   667        call HistoryPut( 'SOSeaIceMass' , xy_SOSeaIceMass , history = gthst_rst ) ! (in)
   668      end if
   669      if ( present( xy_SurfMajCompIceB ) ) then
   670        call HistoryPut( 'SurfMajCompIceB', xy_SurfMajCompIceB, history = gthst_rst ) ! (in)
   671      end if
   672      if ( present( xy_SoilMoistB ) ) then
   673        call HistoryPut( 'SoilMoistB', xy_SoilMoistB, history = gthst_rst ) ! (in)
   674      end if
   675      if ( present( xy_SurfSnowB ) ) then
   676        call HistoryPut( 'SurfSnowB' , xy_SurfSnowB , history = gthst_rst ) ! (in)
   677      end if
   678      if ( present( xy_SurfMajCompIceN ) ) then
   679        call HistoryPut( 'SurfMajCompIceN', xy_SurfMajCompIceN, history = gthst_rst ) ! (in)
   680      end if
   681      if ( present( xy_SoilMoistN ) ) then
   682        call HistoryPut( 'SoilMoistN', xy_SoilMoistN, history = gthst_rst ) ! (in)
   683      end if
   684      if ( present( xy_SurfSnowN ) ) then
   685        call HistoryPut( 'SurfSnowN' , xy_SurfSnowN , history = gthst_rst ) ! (in)
   686      end if
   687  
   688    end subroutine RestartSurfTempOutput
   689  
   690    !--------------------------------------------------------------------------------------
   691  
   692    subroutine RestartSurfTempClose
   693      !
   694      ! リスタートデータファイル出力の終了処理を行います.
   695      !
   696      ! Terminate restart data files output.
   697  
   698      ! モジュール引用 ; USE statements
   699      !
   700  
   701      ! gtool4 データ出力
   702      ! Gtool4 data output
   703      !
   704      use gtool_history, only: HistoryClose
   705  
   706      ! 宣言文 ; Declaration statements
   707      !
   708  
   709      ! 作業変数
   710      ! Work variables
   711      !
   712  
   713      ! 実行文 ; Executable statement
   714      !
   715      if ( .not. restart_surftemp_opened ) return
   716  
   717      call HistoryClose( history = gthst_rst ) ! (inout)
   718  
   719      restart_surftemp_opened = .false.
   720    end subroutine RestartSurfTempClose
   721  
   722    !--------------------------------------------------------------------------------------
   723  
   724    subroutine RestartSurfTempGet(                       &
   725      & xy_SurfTemp,                                     & ! (out)
   726      & xyz_SoilTemp,                                    & ! (out)
   727      & xyz_SOSeaIceTemp, xy_SOSeaIceMass,               & ! (out)
   728      & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (out)
   729      & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN  & ! (out)
   730      & )
   731      !
   732      ! リスタートデータの入力を行います.
   733      ! リスタートデータが存在しない場合には,
   734      ! surface_data モジュールを用いて, 地表面温度データ生成を行います.
   735      !
   736      ! Input restart data.
   737      ! If restart data is not exist,
   738      ! surface temperature data is created by "surface_data".
   739  
   740  
   741      ! モジュール引用 ; USE statements
   742      !
   743  
   744      ! 地表面データ提供
   745      ! Prepare surface data
   746      !
   747      use surface_data, only: SetSurfData
   748  
   749      ! 時刻管理
   750      ! Time control
   751      !
   752      use timeset, only: &
   753        & RestartTime           ! リスタート開始時刻.
   754                                ! Retart time of calculation
   755  
   756      ! gtool4 データ入力
   757      ! Gtool4 data input
   758      !
   759      use gtool_history, only: HistoryGet
   760  
   761      ! 文字列操作
   762      ! Character handling
   763      !
   764      use dc_string, only: toChar
   765  
   766      ! NetCDF のラッパープログラム
   767      ! NetCDF wrapper
   768      !
   769      use netcdf_wrapper, only: NWPresentAVarInFile
   770  
   771  
   772      ! 宣言文 ; Declaration statements
   773      !
   774      real(DP), intent(out) :: xy_SurfTemp (0:imax-1, 1:jmax)
   775                                ! 地表面温度.
   776                                ! Surface temperature
   777      real(DP), intent(out) :: xyz_SoilTemp (0:imax-1, 1:jmax, 1:kslmax)
   778  !!!! Modified by M.Ishiwatari (2016-12-10)
   779  !!!    real(DP), intent(out) :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 1:ksimax)
   780      real(DP), intent(out) :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 0:ksimax)
   781      real(DP), intent(out) :: xy_SOSeaIceMass   (0:imax-1, 1:jmax)
   782      real(DP), intent(out) :: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   783      real(DP), intent(out) :: xy_SoilMoistB     (0:imax-1, 1:jmax)
   784      real(DP), intent(out) :: xy_SurfSnowB      (0:imax-1, 1:jmax)
   785      real(DP), intent(out) :: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
   786      real(DP), intent(out) :: xy_SoilMoistN     (0:imax-1, 1:jmax)
   787      real(DP), intent(out) :: xy_SurfSnowN      (0:imax-1, 1:jmax)
   788  
   789  
   790      ! 作業変数
   791      ! Work variables
   792      !
   793      character(TOKEN) :: time_range
   794                                ! 時刻の指定.
   795                                ! Specification of time
   796      logical          :: flag_mpi_init
   797      integer          :: k
   798  
   799      ! 実行文 ; Executable statement
   800      !
   801  
   802      if ( .not. restart_surftemp_io_inited ) then
   803        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   804      end if
   805  
   806      ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
   807  !!$    if ( trim(InputFile) == '' .or. trim(InputName) == '' ) then
   808      if ( trim(InputFile) == '' ) then
   809  
   810        ! データを surface_data モジュールから取得
   811        ! Data is input from "surface_data" module
   812        !
   813        call SetSurfData( xy_SurfTemp = xy_SurfTemp )  ! (out) optional
   814  
   815        do k = 1, kslmax
   816          xyz_SoilTemp(:,:,k) = xy_SurfTemp
     .        if (xyz_soiltemp.DSC.U2 .gt. 0) then                              
     .           j1 = and(xyz_soiltemp.DSC.U2,3)                                
     .  !cdir    nodep                                                          
     .           do t487 = 1, j1                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surftemp)                                         
     .              do t489 = 1, xyz_soiltemp.DSC.U1 + 1                        
     .                 xyz_soiltemp(t489-1,t487,k) = xy_surftemp(t489-1,t487)   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t487 = j1 + 1, xyz_soiltemp.DSC.U2, 4                       
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surftemp)                                         
     .              do t489 = 1, xyz_soiltemp.DSC.U1 + 1                        
     .                 xyz_soiltemp(t489-1,t487,k) = xy_surftemp(t489-1,t487)   
     .                 xyz_soiltemp(t489-1,t487+1,k)=xy_surftemp(t489-1,t487+1) 
     .                 xyz_soiltemp(t489-1,t487+2,k)=xy_surftemp(t489-1,t487+2) 
     .                 xyz_soiltemp(t489-1,t487+3,k)=xy_surftemp(t489-1,t487+3) 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   817        end do
   818  
   819        do k = 1, ksimax
   820          xyz_SOSeaIceTemp(:,:,k) = xy_SurfTemp
     .        if (xyz_soseaicetemp.DSC.U2 .gt. 0) then                          
     .           j2 = and(xyz_soseaicetemp.DSC.U2,3)                            
     .  !cdir    nodep                                                          
     .           do t495 = 1, j2                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surftemp)                                         
     .              do t497 = 1, xyz_soseaicetemp.DSC.U1 + 1                    
     .                 xyz_soseaicetemp(t497-1,t495,k)=xy_surftemp(t497-1,t495) 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t495 = j2 + 1, xyz_soseaicetemp.DSC.U2, 4                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surftemp)                                         
     .              do t497 = 1, xyz_soseaicetemp.DSC.U1 + 1                    
     .                 xyz_soseaicetemp(t497-1,t495,k)=xy_surftemp(t497-1,t495) 
     .                 xyz_soseaicetemp(t497-1,t495+1,k) = xy_surftemp(t497-1,  
     .       1            t495+1)                                               
     .                 xyz_soseaicetemp(t497-1,t495+2,k) = xy_surftemp(t497-1,  
     .       1            t495+2)                                               
     .                 xyz_soseaicetemp(t497-1,t495+3,k) = xy_surftemp(t497-1,  
     .       1            t495+3)                                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   821        end do
   822        xy_SOSeaIceMass = 0.0_DP
     .  !cdir nodep                                                             
     .        do t505 = 0, 1 + xy_soseaicemass.DSC.U1 - min0(1,                 
     .       1   xy_soseaicemass.DSC.U1 + 1)                                    
   823  
   824        xy_SurfMajCompIceB = 0.0_DP
   825        xy_SoilMoistB      = 0.0_DP
   826        xy_SurfSnowB       = 0.0_DP
   827  
   828        xy_SurfMajCompIceN = xy_SurfMajCompIceB
   829        xy_SoilMoistN      = xy_SoilMoistB
   830        xy_SurfSnowN       = xy_SurfSnowB
   831  
   832      else
   833  
   834        ! データを InputFile から取得
   835        ! Data is input from InputFile
   836        !
   837  
   838        ! 時刻情報の取得
   839        ! Get time information
   840        !
   841        time_range = time_name // '=' // toChar( RestartTime )
   842  
   843  !!$      flag_mpi_init = .false.
   844        flag_mpi_init = .true.
   845  
   846        ! データ入力
   847        ! Data input
   848        !
   849        call HistoryGet(                               &
   850          ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
   851  !!$        & InputFile, InputName, range = time_range, &  ! (in)
   852          & InputFile, 'SurfTemp', range = time_range, & ! (in)
   853          & array = xy_SurfTemp,                       & ! (out)
   854          & flag_mpi_split = flag_mpi_init             & ! (in) optional
   855          & )
   856        if ( kslmax /= 0 ) then
   857          if ( NWPresentAVarInFile( InputFile, 'SoilTemp' ) ) then
   858            call HistoryGet(                               &
   859              & InputFile, 'SoilTemp', range = time_range, & ! (in)
   860              & array = xyz_SoilTemp,                      & ! (out)
   861              & flag_mpi_split = flag_mpi_init             & ! (in) optional
   862              & )
   863          else
   864            do k = 1, kslmax
   865              xyz_SoilTemp(:,:,k) = xy_SurfTemp
     .           if (xyz_soiltemp.DSC.U2 .gt. 0) then                           
     .           j3 = and(xyz_soiltemp.DSC.U2,3)                                
     .  !cdir    nodep                                                          
     .           do t479 = 1, j3                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surftemp)                                         
     .              do t481 = 1, xyz_soiltemp.DSC.U1 + 1                        
     .                 xyz_soiltemp(t481-1,t479,k) = xy_surftemp(t481-1,t479)   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t479 = j3 + 1, xyz_soiltemp.DSC.U2, 4                       
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surftemp)                                         
     .              do t481 = 1, xyz_soiltemp.DSC.U1 + 1                        
     .                 xyz_soiltemp(t481-1,t479,k) = xy_surftemp(t481-1,t479)   
     .                 xyz_soiltemp(t481-1,t479+1,k)=xy_surftemp(t481-1,t479+1) 
     .                 xyz_soiltemp(t481-1,t479+2,k)=xy_surftemp(t481-1,t479+2) 
     .                 xyz_soiltemp(t481-1,t479+3,k)=xy_surftemp(t481-1,t479+3) 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   866            end do
   867            call MessageNotify( 'M', module_name,             &
   868              & 'Variable, %c, cannot be found in file, %c.', &
   869              & c1 = 'SoilTemp', c2 = trim(InputFile)         &
   870              & )
   871            call MessageNotify( 'M', module_name,                           &
   872              & 'Values in SoilTemp is assumed to be the same as SurfTemp.' &
   873              & )
   874          end if
   875        end if
   876        if ( ksimax /= 0 ) then
   877          if ( NWPresentAVarInFile( InputFile, 'SOSeaIceTemp' ) ) then
   878            call HistoryGet(                                   &
   879              & InputFile, 'SOSeaIceTemp', range = time_range, & ! (in)
   880              & array = xyz_SOSeaIceTemp,                      & ! (out)
   881              & flag_mpi_split = flag_mpi_init                 & ! (in) optional
   882              & )
   883          else
   884            do k = 1, ksimax
   885              xyz_SOSeaIceTemp(:,:,k) = xy_SurfTemp
     .        if (xyz_soseaicetemp.DSC.U2 .gt. 0) then                          
     .           j4 = and(xyz_soseaicetemp.DSC.U2,3)                            
     .  !cdir    nodep                                                          
     .           do t471 = 1, j4                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surftemp)                                         
     .              do t473 = 1, xyz_soseaicetemp.DSC.U1 + 1                    
     .                 xyz_soseaicetemp(t473-1,t471,k)=xy_surftemp(t473-1,t471) 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t471 = j4 + 1, xyz_soseaicetemp.DSC.U2, 4                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surftemp)                                         
     .              do t473 = 1, xyz_soseaicetemp.DSC.U1 + 1                    
     .                 xyz_soseaicetemp(t473-1,t471,k)=xy_surftemp(t473-1,t471) 
     .                 xyz_soseaicetemp(t473-1,t471+1,k) = xy_surftemp(t473-1,  
     .       1            t471+1)                                               
     .                 xyz_soseaicetemp(t473-1,t471+2,k) = xy_surftemp(t473-1,  
     .       1            t471+2)                                               
     .                 xyz_soseaicetemp(t473-1,t471+3,k) = xy_surftemp(t473-1,  
     .       1            t471+3)                                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   886            end do
   887            call MessageNotify( 'M', module_name,             &
   888              & 'Variable, %c, cannot be found in file, %c.', &
   889              & c1 = 'SOSeaIceTemp', c2 = trim(InputFile)     &
   890              & )
   891            call MessageNotify( 'M', module_name,                           &
   892              & 'Values in SOSeaIceTemp is assumed to be the same as SurfTemp.' &
   893              & )
   894          end if
   895        end if
   896        if ( NWPresentAVarInFile( InputFile, 'SOSeaIceMass' ) ) then
   897          call HistoryGet(                                     &
   898            & InputFile, 'SOSeaIceMass', range = time_range,   & ! (in)
   899            & array = xy_SOSeaIceMass,                         & ! (out)
   900            & flag_mpi_split = flag_mpi_init                   & ! (in) optional
   901            & )
   902        else
   903          xy_SOSeaIceMass = 0.0_DP
     .        if (xy_soseaicemass.DSC.U2 .gt. 0) then                           
     .           j5 = and(xy_soseaicemass.DSC.U2,3)                             
     .  !cdir    nodep                                                          
     .           do t423 = 1, j5                                                
     .  !cdir       nodep                                                       
     .              do t425 = 1, xy_soseaicemass.DSC.U1 + 1                     
     .                 xy_soseaicemass(t425-1,t423) = 0.0000000000000000e+000   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t423 = j5 + 1, xy_soseaicemass.DSC.U2, 4                    
     .  !cdir       nodep                                                       
     .              do t425 = 1, xy_soseaicemass.DSC.U1 + 1                     
     .                 xy_soseaicemass(t425-1,t423) = 0.0000000000000000e+000   
     .                 xy_soseaicemass(t425-1,t423+1) = 0.0000000000000000e+000 
     .                 xy_soseaicemass(t425-1,t423+2) = 0.0000000000000000e+000 
     .                 xy_soseaicemass(t425-1,t423+3) = 0.0000000000000000e+000 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   904          call MessageNotify( 'M', module_name,             &
   905            & 'Variable, %c, cannot be found in file, %c.', &
   906            & c1 = 'SOSeaIceMass', c2 = trim(InputFile)     &
   907            & )
   908          call MessageNotify( 'M', module_name,                &
   909            & 'Values in SOSeaIceMass is assumed to be zero.'  &
   910            & )
   911        end if
   912        if ( NWPresentAVarInFile( InputFile, 'SurfMajCompIceB' ) ) then
   913          call HistoryGet(                                      &
   914            & InputFile, 'SurfMajCompIceB', range = time_range, & ! (in)
   915            & array = xy_SurfMajCompIceB,                       & ! (out)
   916            & flag_mpi_split = flag_mpi_init                    & ! (in) optional
   917            & )
   918        else
   919          xy_SurfMajCompIceB = 0.0_DP
     .        if (xy_surfmajcompiceb.DSC.U2 .gt. 0) then                        
     .           j6 = and(xy_surfmajcompiceb.DSC.U2,3)                          
     .  !cdir    nodep                                                          
     .           do t429 = 1, j6                                                
     .  !cdir       nodep                                                       
     .              do t431 = 1, xy_surfmajcompiceb.DSC.U1 + 1                  
     .                 xy_surfmajcompiceb(t431-1,t429) = 0.0000000000000000e+000
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t429 = j6 + 1, xy_surfmajcompiceb.DSC.U2, 4                 
     .  !cdir       nodep                                                       
     .              do t431 = 1, xy_surfmajcompiceb.DSC.U1 + 1                  
     .                 xy_surfmajcompiceb(t431-1,t429) = 0.0000000000000000e+000
     .                 xy_surfmajcompiceb(t431-1,t429+1) =                      
     .       1            0.0000000000000000e+000                               
     .                 xy_surfmajcompiceb(t431-1,t429+2) =                      
     .       1            0.0000000000000000e+000                               
     .                 xy_surfmajcompiceb(t431-1,t429+3) =                      
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   920          call MessageNotify( 'M', module_name,             &
   921            & 'Variable, %c, cannot be found in file, %c.', &
   922            & c1 = 'SurfMajCompIceB', c2 = trim(InputFile)  &
   923            & )
   924          call MessageNotify( 'M', module_name,                  &
   925            & 'Values in SurfMajCompIceB is assumed to be zero.' &
   926            & )
   927        end if
   928        if ( NWPresentAVarInFile( InputFile, 'SoilMoistB' ) ) then
   929          call HistoryGet(                                 &
   930            & InputFile, 'SoilMoistB', range = time_range, & ! (in)
   931            & array = xy_SoilMoistB,                       & ! (out)
   932            & flag_mpi_split = flag_mpi_init               & ! (in) optional
   933            & )
   934        else
   935          xy_SoilMoistB = 0.0_DP
     .        if (xy_soilmoistb.DSC.U2 .gt. 0) then                             
     .           j7 = and(xy_soilmoistb.DSC.U2,3)                               
     .  !cdir    nodep                                                          
     .           do t435 = 1, j7                                                
     .  !cdir       nodep                                                       
     .              do t437 = 1, xy_soilmoistb.DSC.U1 + 1                       
     .                 xy_soilmoistb(t437-1,t435) = 0.0000000000000000e+000     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t435 = j7 + 1, xy_soilmoistb.DSC.U2, 4                      
     .  !cdir       nodep                                                       
     .              do t437 = 1, xy_soilmoistb.DSC.U1 + 1                       
     .                 xy_soilmoistb(t437-1,t435) = 0.0000000000000000e+000     
     .                 xy_soilmoistb(t437-1,t435+1) = 0.0000000000000000e+000   
     .                 xy_soilmoistb(t437-1,t435+2) = 0.0000000000000000e+000   
     .                 xy_soilmoistb(t437-1,t435+3) = 0.0000000000000000e+000   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   936          call MessageNotify( 'M', module_name,             &
   937            & 'Variable, %c, cannot be found in file, %c.', &
   938            & c1 = 'SoilMoistB', c2 = trim(InputFile)       &
   939            & )
   940          call MessageNotify( 'M', module_name,             &
   941            & 'Values in SoilMoistB is assumed to be zero.' &
   942            & )
   943        end if
   944        if ( NWPresentAVarInFile( InputFile, 'SurfSnowB' ) ) then
   945          call HistoryGet(                                 &
   946            & InputFile, 'SurfSnowB', range = time_range,  & ! (in)
   947            & array = xy_SurfSnowB,                        & ! (out)
   948            & flag_mpi_split = flag_mpi_init               & ! (in) optional
   949            & )
   950        else
   951          xy_SurfSnowB = 0.0_DP
     .        if (xy_surfsnowb.DSC.U2 .gt. 0) then                              
     .           j8 = and(xy_surfsnowb.DSC.U2,3)                                
     .  !cdir    nodep                                                          
     .           do t441 = 1, j8                                                
     .  !cdir       nodep                                                       
     .              do t443 = 1, xy_surfsnowb.DSC.U1 + 1                        
     .                 xy_surfsnowb(t443-1,t441) = 0.0000000000000000e+000      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t441 = j8 + 1, xy_surfsnowb.DSC.U2, 4                       
     .  !cdir       nodep                                                       
     .              do t443 = 1, xy_surfsnowb.DSC.U1 + 1                        
     .                 xy_surfsnowb(t443-1,t441) = 0.0000000000000000e+000      
     .                 xy_surfsnowb(t443-1,t441+1) = 0.0000000000000000e+000    
     .                 xy_surfsnowb(t443-1,t441+2) = 0.0000000000000000e+000    
     .                 xy_surfsnowb(t443-1,t441+3) = 0.0000000000000000e+000    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   952          call MessageNotify( 'M', module_name,             &
   953            & 'Variable, %c, cannot be found in file, %c.', &
   954            & c1 = 'SurfSnowB', c2 = trim(InputFile)        &
   955            & )
   956          call MessageNotify( 'M', module_name,             &
   957            & 'Values in SurfSnowB is assumed to be zero.'  &
   958            & )
   959        end if
   960        if ( NWPresentAVarInFile( InputFile, 'SurfMajCompIceN' ) ) then
   961          call HistoryGet(                                      &
   962            & InputFile, 'SurfMajCompIceN', range = time_range, & ! (in)
   963            & array = xy_SurfMajCompIceN,                       & ! (out)
   964            & flag_mpi_split = flag_mpi_init                    & ! (in) optional
   965            & )
   966        else
   967          xy_SurfMajCompIceN = xy_SurfMajCompIceB
     .        if (xy_surfmajcompicen.DSC.U2 .gt. 0) then                        
     .           j9 = and(xy_surfmajcompicen.DSC.U2,3)                          
     .  !cdir    nodep                                                          
     .           do t447 = 1, j9                                                
     .  !cdir       nodep                                                       
     .              do t449 = 1, xy_surfmajcompicen.DSC.U1 + 1                  
     .                 xy_surfmajcompicen(t449-1,t447) = xy_surfmajcompiceb(t449
     .       1            -1,t447)                                              
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t447 = j9 + 1, xy_surfmajcompicen.DSC.U2, 4                 
     .  !cdir       nodep                                                       
     .              do t449 = 1, xy_surfmajcompicen.DSC.U1 + 1                  
     .                 xy_surfmajcompicen(t449-1,t447) = xy_surfmajcompiceb(t449
     .       1            -1,t447)                                              
     .                 xy_surfmajcompicen(t449-1,t447+1) = xy_surfmajcompiceb(  
     .       1            t449-1,t447+1)                                        
     .                 xy_surfmajcompicen(t449-1,t447+2) = xy_surfmajcompiceb(  
     .       1            t449-1,t447+2)                                        
     .                 xy_surfmajcompicen(t449-1,t447+3) = xy_surfmajcompiceb(  
     .       1            t449-1,t447+3)                                        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   968          call MessageNotify( 'M', module_name,             &
   969            & 'Variable, %c, cannot be found in file, %c.', &
   970            & c1 = 'SurfMajCompIceN', c2 = trim(InputFile)  &
   971            & )
   972          call MessageNotify( 'M', module_name,                                         &
   973            & 'Values in SurfMajCompIceN is assumed to be the same as SurfMajCompIceB.' &
   974            & )
   975        end if
   976        if ( NWPresentAVarInFile( InputFile, 'SoilMoistN' ) ) then
   977          call HistoryGet(                                 &
   978            & InputFile, 'SoilMoistN', range = time_range, & ! (in)
   979            & array = xy_SoilMoistN,                       & ! (out)
   980            & flag_mpi_split = flag_mpi_init               & ! (in) optional
   981            & )
   982        else
   983          xy_SoilMoistN = xy_SoilMoistB
     .        if (xy_soilmoistn.DSC.U2 .gt. 0) then                             
     .           j10 = and(xy_soilmoistn.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t455 = 1, j10                                               
     .  !cdir       nodep                                                       
     .              do t457 = 1, xy_soilmoistn.DSC.U1 + 1                       
     .                 xy_soilmoistn(t457-1,t455) = xy_soilmoistb(t457-1,t455)  
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t455 = j10 + 1, xy_soilmoistn.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .              do t457 = 1, xy_soilmoistn.DSC.U1 + 1                       
     .                 xy_soilmoistn(t457-1,t455) = xy_soilmoistb(t457-1,t455)  
     .                 xy_soilmoistn(t457-1,t455+1) = xy_soilmoistb(t457-1,t455+
     .       1            1)                                                    
     .                 xy_soilmoistn(t457-1,t455+2) = xy_soilmoistb(t457-1,t455+
     .       1            2)                                                    
     .                 xy_soilmoistn(t457-1,t455+3) = xy_soilmoistb(t457-1,t455+
     .       1            3)                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   984          call MessageNotify( 'M', module_name,             &
   985            & 'Variable, %c, cannot be found in file, %c.', &
   986            & c1 = 'SoilMoistN', c2 = trim(InputFile)       &
   987            & )
   988          call MessageNotify( 'M', module_name,                               &
   989            & 'Values in SoilMoistN is assumed to be the same as SoilMoistB.' &
   990            & )
   991        end if
   992        if ( NWPresentAVarInFile( InputFile, 'SurfSnowN' ) ) then
   993          call HistoryGet(                                 &
   994            & InputFile, 'SurfSnowN', range = time_range,  & ! (in)
   995            & array = xy_SurfSnowN,                        & ! (out)
   996            & flag_mpi_split = flag_mpi_init               & ! (in) optional
   997            & )
   998        else
   999          xy_SurfSnowN = xy_SurfSnowB
     .        if (xy_surfsnown.DSC.U2 .gt. 0) then                              
     .           j11 = and(xy_surfsnown.DSC.U2,3)                               
     .  !cdir    nodep                                                          
     .           do t463 = 1, j11                                               
     .  !cdir       nodep                                                       
     .              do t465 = 1, xy_surfsnown.DSC.U1 + 1                        
     .                 xy_surfsnown(t465-1,t463) = xy_surfsnowb(t465-1,t463)    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t463 = j11 + 1, xy_surfsnown.DSC.U2, 4                      
     .  !cdir       nodep                                                       
     .              do t465 = 1, xy_surfsnown.DSC.U1 + 1                        
     .                 xy_surfsnown(t465-1,t463) = xy_surfsnowb(t465-1,t463)    
     .                 xy_surfsnown(t465-1,t463+1) = xy_surfsnowb(t465-1,t463+1)
     .                 xy_surfsnown(t465-1,t463+2) = xy_surfsnowb(t465-1,t463+2)
     .                 xy_surfsnown(t465-1,t463+3) = xy_surfsnowb(t465-1,t463+3)
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1000          call MessageNotify( 'M', module_name,             &
  1001            & 'Variable, %c, cannot be found in file, %c.', &
  1002            & c1 = 'SurfSnowN', c2 = trim(InputFile)        &
  1003            & )
  1004          call MessageNotify( 'M', module_name,                             &
  1005            & 'Values in SurfSnowN is assumed to be the same as SurfSnowB.' &
  1006            & )
  1007        end if
  1008  
  1009      end if
  1010  
  1011    end subroutine RestartSurfTempGet
  1012  
  1013    !--------------------------------------------------------------------------------------
  1014  
  1015    subroutine RestartSurfTempInit
  1016      !
  1017      ! restart_surftemp_io モジュールの初期化を行います.
  1018      ! NAMELIST#restart_surftemp_io_nml の読み込みはこの手続きで行われます.
  1019      !
  1020      ! "restart_surftemp_io" module is initialized.
  1021      ! "NAMELIST#restart_surftemp_io_nml" is loaded in this procedure.
  1022      !
  1023  
  1024      ! モジュール引用 ; USE statements
  1025      !
  1026  
  1027      ! リスタートデータ入出力
  1028      ! Restart data input/output
  1029      !
  1030      use restart_file_io, only: restart_file_io_inited, &
  1031        & RestartFileIntValue => IntValue, &
  1032                                ! リスタートデータの出力間隔.
  1033                                ! Interval of restart data output
  1034        & RestartFileIntUnit  => IntUnit
  1035                                ! リスタートデータの出力間隔の単位.
  1036                                ! Unit for interval of restart data output
  1037  
  1038      ! 時刻管理
  1039      ! Time control
  1040      !
  1041      use timeset, only: &
  1042        & RestartTime           ! リスタート開始時刻.
  1043                                ! Retart time of calculation
  1044  
  1045      ! NAMELIST ファイル入力に関するユーティリティ
  1046      ! Utilities for NAMELIST file input
  1047      !
  1048      use namelist_util, only: namelist_filename, NmlutilMsg
  1049  
  1050      ! 暦と日時の取り扱い
  1051      ! Calendar and Date handler
  1052      !
  1053      use dc_calendar, only: DCCalConvertByUnit
  1054  
  1055      ! ファイル入出力補助
  1056      ! File I/O support
  1057      !
  1058      use dc_iounit, only: FileOpen
  1059  
  1060      ! 種別型パラメタ
  1061      ! Kind type parameter
  1062      !
  1063      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1064  
  1065      ! 宣言文 ; Declaration statements
  1066      !
  1067  
  1068      ! 作業変数
  1069      ! Work variables
  1070      !
  1071      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1072                                ! Unit number for NAMELIST file open
  1073      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1074                                ! IOSTAT of NAMELIST read
  1075  
  1076      ! NAMELIST 変数群
  1077      ! NAMELIST group name
  1078      !
  1079      namelist /restart_surftemp_io_nml/ &
  1080        & InputFile, &
  1081        ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
  1082  !!$      & InputName, &
  1083        & OutputFile, &
  1084        & IntValue, IntUnit
  1085            !
  1086            ! デフォルト値については初期化手続 "restart_surftemp_io#RestartSurfTempInit"
  1087            ! のソースコードを参照のこと.
  1088            !
  1089            ! Refer to source codes in the initialization procedure
  1090            ! "restart_surftemp_io#RestartSurfTempInit" for the default values.
  1091            !
  1092  
  1093  
  1094      ! 実行文 ; Executable statement
  1095      !
  1096  
  1097      if ( restart_surftemp_io_inited ) return
  1098  
  1099  
  1100      ! デフォルト値の設定
  1101      ! Default values settings
  1102      !
  1103      InputFile  = ''
  1104      ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
  1105  !!$    InputName  = 'SurfTemp'
  1106      if ( .not. flag_init_data_save ) then
  1107        OutputFile = 'rst_sst.nc'
  1108      else
  1109        OutputFile = 'sst.nc'
  1110      end if
  1111  
  1112      if ( restart_file_io_inited ) then
  1113        IntValue   = RestartFileIntValue
  1114        IntUnit    = RestartFileIntUnit
  1115      else
  1116        IntValue   = 365.0_DP
  1117        IntUnit    = 'day'
  1118      end if
  1119  
  1120      ! NAMELIST の読み込み
  1121      ! NAMELIST is input
  1122      !
  1123      if ( trim(namelist_filename) /= '' ) then
  1124        call FileOpen( unit_nml, &          ! (out)
  1125          & namelist_filename, mode = 'r' ) ! (in)
  1126  
  1127        rewind( unit_nml )
  1128        read( unit_nml, &         ! (in)
  1129          & nml = restart_surftemp_io_nml, &  ! (out)
  1130          & iostat = iostat_nml ) ! (out)
  1131        close( unit_nml )
  1132  
  1133        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1134        if ( iostat_nml == 0 ) write( STDOUT, nml = restart_surftemp_io_nml )
  1135      end if
  1136  
  1137      ! 出力時間間隔の設定
  1138      ! Configure time interval of output
  1139      !
  1140      IntTime = DCCalConvertByUnit( IntValue, IntUnit, 'sec' ) ! (in)
  1141      PrevOutputTime = RestartTime
  1142  
  1143      ! フラグの初期化
  1144      ! Initialize flag
  1145      !
  1146      flag_output_end = .false.
  1147  
  1148  
  1149      ! 印字 ; Print
  1150      !
  1151      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1152      call MessageNotify( 'M', module_name, 'Input:: ' )
  1153      call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
  1154      ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
  1155  !!$    call MessageNotify( 'M', module_name, '  InputName  = %c', c1 = trim(InputName) )
  1156      call MessageNotify( 'M', module_name, 'Output:: ' )
  1157      call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
  1158      call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
  1159      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1160  
  1161      restart_surftemp_io_inited = .true.
  1162  
  1163    end subroutine RestartSurfTempInit
  1164  
  1165    !--------------------------------------------------------------------------------------
  1166  
  1167  end module restart_surftemp_io
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:32 2016
FILE NAME: restart_surftemp_io.f90
PROGRAM NAME: restart_surftemp_io
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地表面温度リスタートデータ, 初期値データ入出力
     2:             !
     3:             != Restart data, initial data of surface temperature input/output
     4:             !
     5:             ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: restart_surftemp_io.f90,v 1.11 2014/05/07 09:39:18 murashin Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module restart_surftemp_io
    13:               !
    14:               != 地表面温度リスタートデータ, 初期値データ入出力
    15:               !
    16:               != Restart data, initial data of surface temperature input/output
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 地表面温度のリスタートデータもしくは初期値データの入出力を行います. 
    21:               ! 入力ファイル, 出力ファイル, データの出力の間隔は
    22:               ! NAMELIST#restart_surftemp_io_nml で設定します. 
    23:               !
    24:               ! リスタートデータの入力ファイルが指定されない場合, 
    25:               ! surface_data モジュールで生成された初期値データを取得します. 
    26:               !
    27:               ! Restart data or initial data is input/output. 
    28:               ! Settings of input file, output file, and interval of data output 
    29:               ! is configured by "NAMELIST#restart_surftemp_io_nml". 
    30:               !
    31:               ! If input file of restart data is not set, 
    32:               ! initial data is generated in "surface_data" module, and 
    33:               ! obtained data from the module. 
    34:               !
    35:               !== Procedures List
    36:               !
    37:               ! RestartSurfTempOpen   :: リスタートファイルのオープン
    38:               ! RestartSurfTempOutput :: リスタートファイルへのデータ出力
    39:               ! RestartSurfTempClose  :: リスタートファイルのクローズ
    40:               ! RestartSurfTempGet    :: リスタートファイルの入力
    41:               ! ------------      :: ------------
    42:               ! RestartSurfTempOpen   :: Open restart file
    43:               ! RestartSurfTempOutput :: Data output to restart file
    44:               ! RestartSurfTempClose  :: Close restart file
    45:               ! RestartSurfTempGet    :: Input restart file
    46:               !
    47:               !== NAMELIST
    48:               !
    49:               ! NAMELIST#restart_surftemp_io_nml
    50:               !
    51:             
    52:               ! モジュール引用 ; USE statements
    53:               !
    54:             
    55:               ! 格子点設定
    56:               ! Grid points settings
    57:               !
    58:               use gridset, only: imax, & ! 経度格子点数. 
    59:                                          ! Number of grid points in longitude
    60:                 &                jmax, & ! 緯度格子点数. 
    61:                                          ! Number of grid points in latitude
    62:                 &                kmax, & ! 鉛直層数. 
    63:                                          ! Number of vertical level
    64:                 &                kslmax, & ! 地下の鉛直層数.
    65:                                            ! Number of subsurface vertical level
    66:                 &                ksimax    ! 海氷の鉛直層数.
    67:                                            ! Number of sea ice vertical level
    68:             
    69:               ! 種別型パラメタ
    70:               ! Kind type parameter
    71:               !
    72:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    73:                 &                 STRING, &  ! 文字列.       Strings. 
    74:                 &                 TOKEN      ! キーワード.   Keywords. 
    75:             
    76:               ! メッセージ出力
    77:               ! Message output
    78:               !
    79:               use dc_message, only: MessageNotify
    80:             
    81:               ! gtool4 データ出力
    82:               ! Gtool4 data output
    83:               !
    84:               use gtool_history, only: GT_HISTORY
    85:             
    86:               ! 宣言文 ; Declaration statements
    87:               !
    88:               implicit none
    89:               private
    90:             
    91:               ! 公開手続き
    92:               ! Public procedure
    93:               !
    94:               public :: RestartSurfTempInit
    95:               public :: RestartSurfTempOpen, RestartSurfTempClose, RestartSurfTempOutPut
    96:               public :: RestartSurfTempGet
    97:             
    98:               ! 公開変数
    99:               ! Public variables
   100:               !
   101:               logical, save, public:: restart_surftemp_io_inited = .false.
   102:                                           ! 初期設定フラグ. 
   103:                                           ! Initialization flag
   104:             
   105:               logical, save, public:: restart_surftemp_opened = .false.
   106:                                           ! リスタートファイルのオープンに関するフラグ. 
   107:                                           ! Flag of restart file open
   108:             
   109:               ! 非公開変数
   110:               ! Private variables
   111:               !
   112:               logical, save:: flag_init_data_save
   113:                                           ! 初期値データを作成する場合は, 
   114:                                           ! この引数に .true. を与えます. 
   115:                                           ! 
   116:                                           ! If initial data is created, 
   117:                                           ! give ".true." to this argument. 
   118:             
   119:               character(STRING), save:: InputFile
   120:                                           ! 入力するリスタートデータのファイル名
   121:                                           ! Filename of input restart data
   122:             
   123:               ! This is not used, and variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
   124:             !!$  character(TOKEN), save:: InputName
   125:             !!$                              ! 入力するリスタートデータの変数名
   126:             !!$                              ! Variable name of input restart data
   127:             
   128:               character(STRING), save:: OutputFile
   129:                                           ! 出力するリスタートデータのファイル名
   130:                                           ! Filename of output restart data
   131:               real(DP), save:: IntValue
   132:                                           ! リスタートデータの出力間隔. 
   133:                                           ! Interval of restart data output
   134:               character(TOKEN):: IntUnit
   135:                                           ! リスタートデータの出力間隔の単位. 
   136:                                           ! Unit for interval of restart data output
   137:             
   138:               type(GT_HISTORY), save:: gthst_rst
   139:                                           ! リスタートデータ用 gtool_history#GT_HISTORY 変数
   140:                                           ! "gtool_history#GT_HISTORY" variable for restart data
   141:             
   142:               real(DP), save:: PrevOutputTime
   143:                                           ! 前回の出力時間. 
   144:                                           ! Previous output time
   145:               logical, save:: flag_output_end
   146:                                           ! 計算最終時刻の出力完了のフラグ. 
   147:                                           ! Flag for completion of output at the end time of calculation
   148:             
   149:               real(DP), save:: IntTime
   150:                                           ! リスタートデータの出力時間. 
   151:                                           ! Time interval of restart data output
   152:             
   153:               character(*), parameter:: time_name = 'time'
   154:                                           ! 時刻の次元の変数名
   155:                                           ! Variable name of time dimension
   156:               character(*), parameter:: deltime_name = 'deltime'
   157:                                           ! Δt の変数名
   158:                                           ! Variable name of Delta t
   159:             
   160:             
   161:               character(*), parameter:: module_name = 'restart_surftemp_io'
   162:                                           ! モジュールの名称. 
   163:                                           ! Module name
   164:               character(*), parameter:: version = &
   165:                 & '$Name:  $' // &
   166:                 & '$Id: restart_surftemp_io.f90,v 1.11 2014/05/07 09:39:18 murashin Exp $'
   167:                                           ! モジュールのバージョン
   168:                                           ! Module version
   169:             
   170:             contains
   171:             
   172:               !--------------------------------------------------------------------------------------
   173:             
   174:               subroutine RestartSurfTempOpen( flag_init_data )
   175:                 !
   176:                 ! リスタートファイルをオープンします. 
   177:                 !
   178:                 ! A restart file is opened. 
   179:                 !
   180:             
   181:                 ! モジュール引用 ; USE statements
   182:                 !
   183:             
   184:                 ! 出力ファイルの基本情報
   185:                 ! Basic information for output files
   186:                 ! 
   187:                 use fileset, only: &
   188:                   & FileTitle, &
   189:                                           ! 出力データファイルの表題.
   190:                                           ! Title of output data files
   191:                   & FileSource, &
   192:                                           ! データファイル作成の手段. 
   193:                                           ! Source of data file
   194:                   & FileInstitution
   195:                                           ! データファイルを最終的に変更した組織/個人. 
   196:                                           ! Institution or person that changes data files for the last time
   197:             
   198:                 ! 物理・数学定数設定
   199:                 ! Physical and mathematical constants settings
   200:                 !
   201:                 use constants0, only: &
   202:                   & PI                    ! $ \pi $.
   203:                                           ! 円周率. Circular constant
   204:             
   205:                 ! 座標データ設定
   206:                 ! Axes data settings
   207:                 !
   208:                 use axesset, only: &
   209:                   & x_Lon, &
   210:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   211:                   & x_Lon_Weight, &
   212:                                           ! $ \Delta \lambda $ [rad.] . 
   213:                                           ! 経度座標重み. 
   214:                                           ! Weight of longitude
   215:                   & y_Lat, &
   216:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   217:                   & y_Lat_Weight, &
   218:                                           ! $ \Delta \varphi $ [rad.] . 
   219:                                           ! 緯度座標重み. 
   220:                                           ! Weight of latitude
   221:                   & z_SSDepth, &
   222:                                           ! 地下の格子点の深さ
   223:                                           ! subsurface grid at midpoint of layer
   224:                   & z_SIDepth
   225:                                           ! 海氷の格子点の深さ
   226:                                           ! sea ice grid at midpoint of layer
   227:             
   228:                 ! 時刻管理
   229:                 ! Time control
   230:                 !
   231:                 use timeset, only: &
   232:                   & DelTime, &            ! $ \Delta t $ [s]
   233:                   & RestartTime           ! リスタート開始時刻. 
   234:                                           ! Retart time of calculation
   235:             
   236:                 ! gtool4 データ出力
   237:                 ! Gtool4 data output
   238:                 !
   239:                 use gtool_history, only: HistoryCreate, HistoryAddVariable, &
   240:                   & HistoryPut, HistoryAddAttr
   241:             
   242:                 ! 文字列操作
   243:                 ! Character handling
   244:                 !
   245:                 use dc_string, only: StoA, CPrintf, LChar
   246:             
   247:                 ! 組み込み関数 PRESENT の拡張版関数
   248:                 ! Extended functions of intrinsic function "PRESENT"
   249:                 !
   250:                 use dc_present, only: present_and_true
   251:             
   252:                 ! 宣言文 ; Declaration statements
   253:                 !
   254:                 logical, intent(in), optional:: flag_init_data
   255:                                           ! 初期値データを作成する場合は, 
   256:                                           ! この引数に .true. を与えます. 
   257:                                           ! 
   258:                                           ! If initial data is created, 
   259:                                           ! give ".true." to this argument. 
   260:             
   261:                 ! 作業変数
   262:                 ! Work variables
   263:                 !
   264:                 integer                       :: NDims
   265:                 character(STRING), allocatable:: a_DimNames    (:)
   266:                 integer          , allocatable:: a_DimLens     (:)
   267:                 character(STRING), allocatable:: a_DimLongNames(:)
   268:                 character(STRING), allocatable:: a_DimUnits    (:)
   269:             
   270:                 character(STRING):: title_msg
   271:                                           ! 表題に付加するメッセージ. 
   272:                                           ! Message added to title
   273:                 real(DP):: origin_time
   274:                                           ! 計算開始時刻. 
   275:                                           ! Start time of calculation
   276:                 character(STRING):: time_unit
   277:                                           ! 日時の単位. Units of date and time
   278:             
   279:                 logical:: flag_mpi_init
   280:             
   281:                 integer:: n
   282:             
   283:             
   284:                 ! 実行文 ; Executable statement
   285:                 !
   286:             
   287:                 ! 初期化
   288:                 ! Initialization
   289:                 !
   290:                 flag_init_data_save = present_and_true( flag_init_data )
   291:                 if ( .not. restart_surftemp_io_inited ) then
   292:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   293:                 end if
   294:                 if ( restart_surftemp_opened ) return
   295:             
   296:                 ! 表題に付加するメッセージの設定
   297:                 ! Configure message added to title
   298:                 !
   299:                 if ( .not. flag_init_data_save ) then
   300:                   title_msg = ' restart data of surface temperature'
   301:                 else
   302:                   title_msg = ' initial data of surface temperature'
   303:                 end if
   304:             
   305:                 ! 時刻情報の取得
   306:                 ! Get time information
   307:                 !
   308:                 if ( .not. flag_init_data_save ) then
   309:                   origin_time = RestartTime + IntTime
   310:                 else
   311:                   origin_time = RestartTime
   312:                 end if
   313:             
   314:                 time_unit = IntUnit
   315:             
   316:                 flag_mpi_init = .true.
   317:             
   318:                 ! リスタートファイルのオープン
   319:                 ! Open a restart file
   320:                 !
   321:                 n = 3                              ! lon, lat, time
   322:                 if ( kslmax /= 0 ) n = n + 1       ! dep
   323:                 if ( ksimax /= 0 ) n = n + 1       ! sidep
   324:                 NDims = n
   325:                 !
   326:                 allocate( a_DimNames    ( 1:NDims ) )
   327:                 allocate( a_DimLens     ( 1:NDims ) )
   328:                 allocate( a_DimLongNames( 1:NDims ) )
   329:                 allocate( a_DimUnits    ( 1:NDims ) )
   330:                 !
   331:                 n = 1 ! lon
   332:                 a_DimNames    (n) = 'lon'
   333:                 a_DimLens     (n) = imax
   334:                 a_DimLongNames(n) = 'longitude'
   335:                 a_DimUnits    (n) = 'degrees_east'
   336:                 n = n + 1 ! lat
   337:                 a_DimNames    (n) = 'lat'
   338:                 a_DimLens     (n) = jmax
   339:                 a_DimLongNames(n) = 'latitude'
   340:                 a_DimUnits    (n) = 'degrees_north'
   341:                 if ( kslmax /= 0 ) then
   342:                   n = n + 1 ! dep
   343:                   a_DimNames    (n) = 'dep'
   344:                   a_DimLens     (n) = kslmax
   345:                   a_DimLongNames(n) = 'depth'
   346:                   a_DimUnits    (n) = 'm'
   347:                 end if
   348:                 if ( ksimax /= 0 ) then
   349:                   n = n + 1 ! sidep
   350:                   a_DimNames    (n) = 'sidep'
   351:                   a_DimLens     (n) = ksimax
   352:                   a_DimLongNames(n) = 'depth'
   353:                   a_DimUnits    (n) = 'm'
   354:                 end if
   355:                 n = n + 1 ! time
   356:                 a_DimNames    (n) = time_name
   357:                 a_DimLens     (n) = 0
   358:                 a_DimLongNames(n) = time_name
   359:                 a_DimUnits    (n) = time_unit
   360:                 !
   361:             !!$    call HistoryCreate(                                                     &
   362:             !!$      &      file = OutputFile,                                             &  ! (in)
   363:             !!$      &     title = trim(FileTitle) // trim(title_msg),                     &  ! (in)
   364:             !!$      &    source = FileSource, institution = FileInstitution,              &  ! (in)
   365:             !!$      &      dims = StoA( 'lon  ', 'lat  ', 'dep  ', 'sidep', time_name ),  &  ! (in)
   366:             !!$      &  dimsizes = (/ imax, jmax, kslmax, ksimax, 0 /),                    &  ! (in)
   367:             !!$      & longnames = StoA( 'longitude', 'latitude', 'depth   ', 'depth   ', time_name ), &  ! (in)
   368:             !!$      &     units = StoA( 'degrees_east', 'degrees_north', 'm            ', 'm            ', &  ! (in)
   369:             !!$      &                    time_unit ),                                     &  ! (in)
   370:             !!$      &        origind = origin_time,                                       &  ! (in) optional
   371:             !!$      &      intervald = IntValue,                                          &  ! (in) optional
   372:             !!$      & flag_mpi_split = flag_mpi_init,                                     &  ! (in) optional
   373:             !!$      &        history = gthst_rst                                          &  ! (out) optional
   374:             !!$      & )
   375:                 call HistoryCreate(                                        &
   376:                   &      file = OutputFile,                                &  ! (in)
   377:                   &     title = trim(FileTitle) // trim(title_msg),        &  ! (in)
   378:                   &    source = FileSource, institution = FileInstitution, &  ! (in)
   379:                   &      dims = a_DimNames,                                &  ! (in)
   380:                   &  dimsizes = a_DimLens,                                 &  ! (in)
   381:                   & longnames = a_DimLongNames,                            &  ! (in)
   382:                   &     units = a_DimUnits,                                &  ! (in)
   383:                   &        origind = origin_time,                          &  ! (in) optional
   384:                   &      intervald = IntValue,                             &  ! (in) optional
   385:                   & flag_mpi_split = flag_mpi_init,                        &  ! (in) optional
   386:                   &        history = gthst_rst                             &  ! (out) optional
   387:                   & )
   388:                 !
   389:                 deallocate( a_DimNames     )
   390:                 deallocate( a_DimLens      )
   391:                 deallocate( a_DimLongNames )
   392:                 deallocate( a_DimUnits     )
   393:             
   394:                 ! 座標データの設定
   395:                 ! Axes data settings
   396:                 !
   397:                 call HistoryAddAttr(                                 &
   398:                   & varname = 'lon', attrname = 'standard_name',     & ! (in)
   399:                   & value = 'longitude',                             & ! (in)
   400:                   & history = gthst_rst                              & ! (inout)
   401:                   & )
   402:                 call HistoryAddAttr(                                 &
   403:                   & varname = 'lat', attrname = 'standard_name',     & ! (in)
   404:                   & value = 'latitude',                              & ! (in)
   405:                   & history = gthst_rst                              & ! (inout)
   406:                   & )
   407:                 if ( kslmax /= 0 ) then
   408:                   call HistoryAddAttr(                                 &
   409:                     & varname = 'dep', attrname = 'standard_name',     & ! (in)
   410:                     & value = 'depth',                                 & ! (in)
   411:                     & history = gthst_rst                              & ! (inout)
   412:                     & )
   413:                 end if
   414:                 if ( ksimax /= 0 ) then
   415:                   call HistoryAddAttr(                                 &
   416:                     & varname = 'sidep', attrname = 'standard_name',   & ! (in)
   417:                     & value = 'depth',                                 & ! (in)
   418:                     & history = gthst_rst                              & ! (inout)
   419:                     & )
   420:                 end if
   421:                 call HistoryAddAttr(                                 &
   422:                   & varname = time_name, attrname = 'standard_name', & ! (in)
   423:                   & value = 'time',                                  & ! (in)
   424:                   & history = gthst_rst                              & ! (inout)
   425:                   & )
   426:             
   427: V====== A       call HistoryPut(                   &
   428:                   & varname = 'lon',               & ! (in)
   429:                   & array = x_Lon / PI * 180.0_DP, & ! (in)
   430:                   & history = gthst_rst            & ! (inout)
   431:                   & )
   432: V====== A       call HistoryPut(                   &
   433:                   & varname = 'lat',               & ! (in)
   434:                   & array = y_Lat / PI * 180.0_DP, & ! (in)
   435:                   & history = gthst_rst            & ! (inout)
   436:                   & )
   437:                 if ( kslmax /= 0 ) then
   438:                   call HistoryPut(                   &
   439:                     & varname = 'dep',               & ! (in)
   440:                     & array = z_SSDepth,             & ! (in)
   441:                     & history = gthst_rst            & ! (inout)
   442:                     & )
   443:                 end if
   444:                 if ( ksimax /= 0 ) then
   445:                   call HistoryPut(                   &
   446:                     & varname = 'sidep',             & ! (in)
   447:                     & array = z_SIDepth,             & ! (in)
   448:                     & history = gthst_rst            & ! (inout)
   449:                     & )
   450:                 end if
   451:             
   452:                 ! 座標重みの設定
   453:                 ! Axes weights settings
   454:                 !
   455:                 call HistoryAddVariable( &
   456:                   & varname = 'lon_weight', &                           ! (in)
   457:                   & dims = StoA('lon'), &                               ! (in)
   458:                   & longname = 'weight for integration in longitude', & ! (in)
   459:                   & units = 'radian', xtype = 'double', &               ! (in)
   460:                   & history = gthst_rst )                               ! (inout)
   461:                 call HistoryAddAttr( &
   462:                   & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
   463:                   & value = 'lon_weight', &                             ! (in)
   464:                   & history = gthst_rst )                               ! (inout)
   465:                 call HistoryPut( &
   466:                   & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
   467:                   & history = gthst_rst )                               ! (inout)
   468:             
   469:                 call HistoryAddVariable( &
   470:                   & varname = 'lat_weight', &                           ! (in)
   471:                   & dims = StoA('lat'), &                               ! (in)
   472:                   & longname = 'weight for integration in latitude', &  ! (in)
   473:                   & units = 'radian', xtype = 'double', &               ! (in)
   474:                   & history = gthst_rst )                               ! (inout)
   475:                 call HistoryAddAttr( &
   476:                   & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
   477:                   & value = 'lat_weight', &                             ! (in)
   478:                   & history = gthst_rst )                               ! (inout)
   479:                 call HistoryPut( &
   480:                   & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
   481:                   & history = gthst_rst )                               ! (inout)
   482:             
   483:                 ! 予報変数の設定
   484:                 ! Predictional variables settings
   485:                 !
   486:                 call HistoryAddVariable(                  &
   487:                   & varname = 'SurfTemp',                 & ! (in)
   488:                   & dims = StoA('lon', 'lat', time_name), & ! (in)
   489:                   & longname = 'surface temperature',     & ! (in)
   490:                   & units = 'K', xtype = 'double',        & ! (in)
   491:                   & history = gthst_rst                   & ! (inout)
   492:                   & )
   493:                 if ( kslmax /= 0 ) then
   494:                   call HistoryAddVariable(                         &
   495:                     & varname = 'SoilTemp',                        & ! (in)
   496:                     & dims = StoA('lon', 'lat', 'dep', time_name), & ! (in)
   497:                     & longname = 'soil temperature',               & ! (in)
   498:                     & units = 'K', xtype = 'double',               & ! (in)
   499:                     & history = gthst_rst                          & ! (inout)
   500:                     & )
   501:                 end if
   502:                 if ( ksimax /= 0 ) then
   503:                   call HistoryAddVariable(                           &
   504:                     & varname = 'SOSeaIceTemp',                      & ! (in)
   505:                     & dims = StoA('lon', 'lat', 'sidep', time_name), & ! (in)
   506:                     & longname = 'sea ice temperature',              & ! (in)
   507:                     & units = 'K', xtype = 'double',                 & ! (in)
   508:                     & history = gthst_rst                            & ! (inout)
   509:                     & )
   510:                 end if
   511:                 call HistoryAddVariable(                     &
   512:                   & varname = 'SOSeaIceMass',                & ! (in)
   513:                   & dims = StoA('lon', 'lat', time_name),    & ! (in)
   514:                   & longname = 'slab sea ice mass',          & ! (in)
   515:                   & units = 'kg m-2', xtype = 'double',      & ! (in)
   516:                   & history = gthst_rst                      & ! (inout)
   517:                   & )
   518:                 call HistoryAddVariable(                  &
   519:                   & varname = 'SurfMajCompIceB',          & ! (in)
   520:                   & dims = StoA('lon', 'lat', time_name), & ! (in)
   521:                   & longname = 'major component ice amount on the surface', & ! (in)
   522:                   & units = 'kg m-2', xtype = 'double',   & ! (in)
   523:                   & history = gthst_rst                   & ! (inout)
   524:                   & )
   525:                 call HistoryAddVariable(                  &
   526:                   & varname = 'SoilMoistB',               & ! (in)
   527:                   & dims = StoA('lon', 'lat', time_name), & ! (in)
   528:                   & longname = 'soil moisture',           & ! (in)
   529:                   & units = 'kg m-2', xtype = 'double',   & ! (in)
   530:                   & history = gthst_rst                   & ! (inout)
   531:                   & )
   532:                 call HistoryAddVariable(                     &
   533:                   & varname = 'SurfSnowB',                   & ! (in)
   534:                   & dims = StoA('lon', 'lat', time_name),    & ! (in)
   535:                   & longname = 'snow amount on the surface', & ! (in)
   536:                   & units = 'kg m-2', xtype = 'double',      & ! (in)
   537:                   & history = gthst_rst                      & ! (inout)
   538:                   & )
   539:                 call HistoryAddVariable(                  &
   540:                   & varname = 'SurfMajCompIceN',          & ! (in)
   541:                   & dims = StoA('lon', 'lat', time_name), & ! (in)
   542:                   & longname = 'major component ice amount on the surface', & ! (in)
   543:                   & units = 'kg m-2', xtype = 'double',   & ! (in)
   544:                   & history = gthst_rst                   & ! (inout)
   545:                   & )
   546:                 call HistoryAddVariable(                  &
   547:                   & varname = 'SoilMoistN',               & ! (in)
   548:                   & dims = StoA('lon', 'lat', time_name), & ! (in)
   549:                   & longname = 'soil moisture',           & ! (in)
   550:                   & units = 'kg m-2', xtype = 'double',   & ! (in)
   551:                   & history = gthst_rst                   & ! (inout)
   552:                   & )
   553:                 call HistoryAddVariable(                     &
   554:                   & varname = 'SurfSnowN',                   & ! (in)
   555:                   & dims = StoA('lon', 'lat', time_name),    & ! (in)
   556:                   & longname = 'snow amount on the surface', & ! (in)
   557:                   & units = 'kg m-2', xtype = 'double',      & ! (in)
   558:                   & history = gthst_rst                      & ! (inout)
   559:                   & )
   560:             
   561:                 restart_surftemp_opened = .true.
   562:               end subroutine RestartSurfTempOpen
   563:             
   564:               !--------------------------------------------------------------------------------------
   565:             
   566:               subroutine RestartSurfTempOutput(                    &
   567:                 & xy_SurfTemp,                                     & ! (in)
   568:                 & xyz_SoilTemp,                                    & ! (in) optional
   569:                 & xyz_SOSeaIceTemp, xy_SOSeaIceMass,               & ! (in) optional
   570:                 & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in) optional
   571:                 & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN  & ! (in) optional
   572:                 & )
   573:                 !
   574:                 ! リスタートデータの出力を行います. 
   575:                 !
   576:                 ! Output restart data
   577:             
   578:                 ! モジュール引用 ; USE statements
   579:                 !
   580:             
   581:                 ! gtool4 データ出力
   582:                 ! Gtool4 data output
   583:                 !
   584:                 use gtool_history, only: HistoryPut, HistorySetTime
   585:             
   586:                 ! 時刻管理
   587:                 ! Time control
   588:                 !
   589:                 use timeset, only: &
   590:                   & TimeN, &              ! ステップ $ t $ の時刻. 
   591:                                           ! Time of step $ t $. 
   592:                   & EndTime               ! 計算終了時刻. 
   593:                                           ! End time of calculation
   594:             
   595:                 ! 組み込み関数 PRESENT の拡張版関数
   596:                 ! Extended functions of intrinsic function "PRESENT"
   597:                 !
   598:                 use dc_present, only: present_and_true
   599:             
   600:                 ! 宣言文 ; Declaration statements
   601:                 !
   602:                 real(DP), intent(in)           :: xy_SurfTemp (0:imax-1, 1:jmax)
   603:                                           ! 地表面温度. 
   604:                                           ! Surface temperature
   605:                 real(DP), intent(in), optional :: xyz_SoilTemp      (0:imax-1, 1:jmax, 1:kslmax)
   606:             !!! modified by M. Ishiwatari (2016-12-10)
   607:             !!!    real(DP), intent(in), optional :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 1:ksimax)
   608:                 real(DP), intent(in), optional :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 0:ksimax)
   609:                 real(DP), intent(in), optional :: xy_SOSeaIceMass   (0:imax-1, 1:jmax)
   610:                 real(DP), intent(in), optional :: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   611:                 real(DP), intent(in), optional :: xy_SoilMoistB     (0:imax-1, 1:jmax)
   612:                 real(DP), intent(in), optional :: xy_SurfSnowB      (0:imax-1, 1:jmax)
   613:                 real(DP), intent(in), optional :: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
   614:                 real(DP), intent(in), optional :: xy_SoilMoistN     (0:imax-1, 1:jmax)
   615:                 real(DP), intent(in), optional :: xy_SurfSnowN      (0:imax-1, 1:jmax)
   616:             
   617:                 ! 作業変数
   618:                 ! Work variables
   619:                 !
   620:                 logical:: flag_output
   621:                                           ! 出力のフラグ. 
   622:                                           ! Flag for output
   623:             
   624:                 ! 実行文 ; Executable statement
   625:                 !
   626:             
   627:                 if ( .not. restart_surftemp_opened ) call RestartSurfTempOpen
   628:             
   629:                 ! 出力タイミングのチェック
   630:                 ! Check output timing
   631:                 !
   632:                 flag_output = TimeN - PrevOutputTime >= IntTime
   633:                 if ( TimeN >= EndTime .and. .not. flag_output_end ) then
   634:                   flag_output = .true.
   635:                   flag_output_end = .true.
   636:                 end if
   637:                 flag_output = ( .not. TimeN == PrevOutputTime ) .and. flag_output
   638:                 flag_output = flag_init_data_save .or. flag_output
   639:             
   640:                 if ( .not. flag_output ) return
   641:             
   642:                 ! 次回用に, 今回の出力 (希望) 時刻 を保存
   643:                 ! Save output time (expected) in this time, for next time
   644:                 !
   645:                 PrevOutputTime = PrevOutputTime + IntTime
   646:             
   647:                 ! 時刻の設定
   648:                 ! Set time
   649:                 !
   650:                 call HistorySetTime( timed = TimeN, history = gthst_rst )
   651:             
   652:                 ! データ出力
   653:                 ! Data output
   654:                 !
   655:                 call HistoryPut( 'SurfTemp'  , xy_SurfTemp  , history = gthst_rst ) ! (in)
   656:                 if ( present( xyz_SoilTemp ) ) then
   657:                   if ( kslmax /= 0 ) then
   658:                     call HistoryPut( 'SoilTemp'  , xyz_SoilTemp , history = gthst_rst ) ! (in)
   659:                   end if
   660:                 end if
   661:                 if ( present( xyz_SOSeaIceTemp ) ) then
   662:                   if ( ksimax /= 0 ) then
   663:                     call HistoryPut( 'SOSeaIceTemp'  , xyz_SOSeaIceTemp , history = gthst_rst ) ! (in)
   664:                   end if
   665:                 end if
   666:                 if ( present( xy_SOSeaIceMass ) ) then
   667:                   call HistoryPut( 'SOSeaIceMass' , xy_SOSeaIceMass , history = gthst_rst ) ! (in)
   668:                 end if
   669:                 if ( present( xy_SurfMajCompIceB ) ) then
   670:                   call HistoryPut( 'SurfMajCompIceB', xy_SurfMajCompIceB, history = gthst_rst ) ! (in)
   671:                 end if
   672:                 if ( present( xy_SoilMoistB ) ) then
   673:                   call HistoryPut( 'SoilMoistB', xy_SoilMoistB, history = gthst_rst ) ! (in)
   674:                 end if
   675:                 if ( present( xy_SurfSnowB ) ) then
   676:                   call HistoryPut( 'SurfSnowB' , xy_SurfSnowB , history = gthst_rst ) ! (in)
   677:                 end if
   678:                 if ( present( xy_SurfMajCompIceN ) ) then
   679:                   call HistoryPut( 'SurfMajCompIceN', xy_SurfMajCompIceN, history = gthst_rst ) ! (in)
   680:                 end if
   681:                 if ( present( xy_SoilMoistN ) ) then
   682:                   call HistoryPut( 'SoilMoistN', xy_SoilMoistN, history = gthst_rst ) ! (in)
   683:                 end if
   684:                 if ( present( xy_SurfSnowN ) ) then
   685:                   call HistoryPut( 'SurfSnowN' , xy_SurfSnowN , history = gthst_rst ) ! (in)
   686:                 end if
   687:             
   688:               end subroutine RestartSurfTempOutput
   689:             
   690:               !--------------------------------------------------------------------------------------
   691:             
   692:               subroutine RestartSurfTempClose
   693:                 !
   694:                 ! リスタートデータファイル出力の終了処理を行います. 
   695:                 !
   696:                 ! Terminate restart data files output. 
   697:             
   698:                 ! モジュール引用 ; USE statements
   699:                 !
   700:             
   701:                 ! gtool4 データ出力
   702:                 ! Gtool4 data output
   703:                 !
   704:                 use gtool_history, only: HistoryClose
   705:             
   706:                 ! 宣言文 ; Declaration statements
   707:                 !
   708:             
   709:                 ! 作業変数
   710:                 ! Work variables
   711:                 !
   712:             
   713:                 ! 実行文 ; Executable statement
   714:                 !
   715:                 if ( .not. restart_surftemp_opened ) return
   716:             
   717:                 call HistoryClose( history = gthst_rst ) ! (inout)
   718:             
   719:                 restart_surftemp_opened = .false.
   720:               end subroutine RestartSurfTempClose
   721:             
   722:               !--------------------------------------------------------------------------------------
   723:             
   724:               subroutine RestartSurfTempGet(                       &
   725:                 & xy_SurfTemp,                                     & ! (out)
   726:                 & xyz_SoilTemp,                                    & ! (out)
   727:                 & xyz_SOSeaIceTemp, xy_SOSeaIceMass,               & ! (out)
   728:                 & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (out)
   729:                 & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN  & ! (out)
   730:                 & )
   731:                 !
   732:                 ! リスタートデータの入力を行います. 
   733:                 ! リスタートデータが存在しない場合には, 
   734:                 ! surface_data モジュールを用いて, 地表面温度データ生成を行います. 
   735:                 !
   736:                 ! Input restart data. 
   737:                 ! If restart data is not exist, 
   738:                 ! surface temperature data is created by "surface_data". 
   739:             
   740:             
   741:                 ! モジュール引用 ; USE statements
   742:                 !
   743:             
   744:                 ! 地表面データ提供
   745:                 ! Prepare surface data
   746:                 !
   747:                 use surface_data, only: SetSurfData
   748:             
   749:                 ! 時刻管理
   750:                 ! Time control
   751:                 !
   752:                 use timeset, only: &
   753:                   & RestartTime           ! リスタート開始時刻. 
   754:                                           ! Retart time of calculation
   755:             
   756:                 ! gtool4 データ入力
   757:                 ! Gtool4 data input
   758:                 !
   759:                 use gtool_history, only: HistoryGet
   760:             
   761:                 ! 文字列操作
   762:                 ! Character handling
   763:                 !
   764:                 use dc_string, only: toChar
   765:             
   766:                 ! NetCDF のラッパープログラム
   767:                 ! NetCDF wrapper
   768:                 !
   769:                 use netcdf_wrapper, only: NWPresentAVarInFile
   770:             
   771:             
   772:                 ! 宣言文 ; Declaration statements
   773:                 !
   774:                 real(DP), intent(out) :: xy_SurfTemp (0:imax-1, 1:jmax)
   775:                                           ! 地表面温度. 
   776:                                           ! Surface temperature
   777:                 real(DP), intent(out) :: xyz_SoilTemp (0:imax-1, 1:jmax, 1:kslmax)
   778:             !!!! Modified by M.Ishiwatari (2016-12-10)
   779:             !!!    real(DP), intent(out) :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 1:ksimax)
   780:                 real(DP), intent(out) :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 0:ksimax)
   781:                 real(DP), intent(out) :: xy_SOSeaIceMass   (0:imax-1, 1:jmax)
   782:                 real(DP), intent(out) :: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   783:                 real(DP), intent(out) :: xy_SoilMoistB     (0:imax-1, 1:jmax)
   784:                 real(DP), intent(out) :: xy_SurfSnowB      (0:imax-1, 1:jmax)
   785:                 real(DP), intent(out) :: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
   786:                 real(DP), intent(out) :: xy_SoilMoistN     (0:imax-1, 1:jmax)
   787:                 real(DP), intent(out) :: xy_SurfSnowN      (0:imax-1, 1:jmax)
   788:             
   789:             
   790:                 ! 作業変数
   791:                 ! Work variables
   792:                 !
   793:                 character(TOKEN) :: time_range
   794:                                           ! 時刻の指定. 
   795:                                           ! Specification of time
   796:                 logical          :: flag_mpi_init
   797:                 integer          :: k
   798:             
   799:                 ! 実行文 ; Executable statement
   800:                 !
   801:             
   802:                 if ( .not. restart_surftemp_io_inited ) then
   803:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   804:                 end if
   805:             
   806:                 ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
   807:             !!$    if ( trim(InputFile) == '' .or. trim(InputName) == '' ) then
   808:                 if ( trim(InputFile) == '' ) then
   809:             
   810:                   ! データを surface_data モジュールから取得
   811:                   ! Data is input from "surface_data" module
   812:                   !
   813:                   call SetSurfData( xy_SurfTemp = xy_SurfTemp )  ! (out) optional
   814:             
   815: +------>          do k = 1, kslmax
   816: |+V==== A           xyz_SoilTemp(:,:,k) = xy_SurfTemp
   817: +------           end do
   818:             
   819: +------>          do k = 1, ksimax
   820: |+V==== A           xyz_SOSeaIceTemp(:,:,k) = xy_SurfTemp
   821: +------           end do
   822: *V----->A         xy_SOSeaIceMass = 0.0_DP
   823: ||          
   824: ||      A         xy_SurfMajCompIceB = 0.0_DP
   825: ||      A         xy_SoilMoistB      = 0.0_DP
   826: ||      A         xy_SurfSnowB       = 0.0_DP
   827: ||          
   828: ||      A         xy_SurfMajCompIceN = xy_SurfMajCompIceB
   829: ||      A         xy_SoilMoistN      = xy_SoilMoistB
   830: *V----- A         xy_SurfSnowN       = xy_SurfSnowB
   831:             
   832:                 else
   833:             
   834:                   ! データを InputFile から取得
   835:                   ! Data is input from InputFile
   836:                   !
   837:             
   838:                   ! 時刻情報の取得
   839:                   ! Get time information
   840:                   !
   841:                   time_range = time_name // '=' // toChar( RestartTime )
   842:             
   843:             !!$      flag_mpi_init = .false.
   844:                   flag_mpi_init = .true.
   845:             
   846:                   ! データ入力
   847:                   ! Data input
   848:                   ! 
   849:                   call HistoryGet(                               &
   850:                     ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
   851:             !!$        & InputFile, InputName, range = time_range, &  ! (in)
   852:                     & InputFile, 'SurfTemp', range = time_range, & ! (in)
   853:                     & array = xy_SurfTemp,                       & ! (out)
   854:                     & flag_mpi_split = flag_mpi_init             & ! (in) optional
   855:                     & )
   856:                   if ( kslmax /= 0 ) then
   857:                     if ( NWPresentAVarInFile( InputFile, 'SoilTemp' ) ) then
   858:                       call HistoryGet(                               &
   859:                         & InputFile, 'SoilTemp', range = time_range, & ! (in)
   860:                         & array = xyz_SoilTemp,                      & ! (out)
   861:                         & flag_mpi_split = flag_mpi_init             & ! (in) optional
   862:                         & )
   863:                     else
   864: +------>              do k = 1, kslmax
   865: |+V==== A               xyz_SoilTemp(:,:,k) = xy_SurfTemp
   866: +------               end do
   867:                       call MessageNotify( 'M', module_name,             &
   868:                         & 'Variable, %c, cannot be found in file, %c.', &
   869:                         & c1 = 'SoilTemp', c2 = trim(InputFile)         &
   870:                         & )
   871:                       call MessageNotify( 'M', module_name,                           &
   872:                         & 'Values in SoilTemp is assumed to be the same as SurfTemp.' &
   873:                         & )
   874:                     end if
   875:                   end if
   876:                   if ( ksimax /= 0 ) then
   877:                     if ( NWPresentAVarInFile( InputFile, 'SOSeaIceTemp' ) ) then
   878:                       call HistoryGet(                                   &
   879:                         & InputFile, 'SOSeaIceTemp', range = time_range, & ! (in)
   880:                         & array = xyz_SOSeaIceTemp,                      & ! (out)
   881:                         & flag_mpi_split = flag_mpi_init                 & ! (in) optional
   882:                         & )
   883:                     else
   884: +------>              do k = 1, ksimax
   885: |+V==== A               xyz_SOSeaIceTemp(:,:,k) = xy_SurfTemp
   886: +------               end do
   887:                       call MessageNotify( 'M', module_name,             &
   888:                         & 'Variable, %c, cannot be found in file, %c.', &
   889:                         & c1 = 'SOSeaIceTemp', c2 = trim(InputFile)     &
   890:                         & )
   891:                       call MessageNotify( 'M', module_name,                           &
   892:                         & 'Values in SOSeaIceTemp is assumed to be the same as SurfTemp.' &
   893:                         & )
   894:                     end if
   895:                   end if
   896:                   if ( NWPresentAVarInFile( InputFile, 'SOSeaIceMass' ) ) then
   897:                     call HistoryGet(                                     &
   898:                       & InputFile, 'SOSeaIceMass', range = time_range,   & ! (in)
   899:                       & array = xy_SOSeaIceMass,                         & ! (out)
   900:                       & flag_mpi_split = flag_mpi_init                   & ! (in) optional
   901:                       & )
   902:                   else
   903: +V===== A           xy_SOSeaIceMass = 0.0_DP
   904:                     call MessageNotify( 'M', module_name,             &
   905:                       & 'Variable, %c, cannot be found in file, %c.', &
   906:                       & c1 = 'SOSeaIceMass', c2 = trim(InputFile)     &
   907:                       & )
   908:                     call MessageNotify( 'M', module_name,                &
   909:                       & 'Values in SOSeaIceMass is assumed to be zero.'  &
   910:                       & )
   911:                   end if
   912:                   if ( NWPresentAVarInFile( InputFile, 'SurfMajCompIceB' ) ) then
   913:                     call HistoryGet(                                      &
   914:                       & InputFile, 'SurfMajCompIceB', range = time_range, & ! (in)
   915:                       & array = xy_SurfMajCompIceB,                       & ! (out)
   916:                       & flag_mpi_split = flag_mpi_init                    & ! (in) optional
   917:                       & )
   918:                   else
   919: +V===== A           xy_SurfMajCompIceB = 0.0_DP
   920:                     call MessageNotify( 'M', module_name,             &
   921:                       & 'Variable, %c, cannot be found in file, %c.', &
   922:                       & c1 = 'SurfMajCompIceB', c2 = trim(InputFile)  &
   923:                       & )
   924:                     call MessageNotify( 'M', module_name,                  &
   925:                       & 'Values in SurfMajCompIceB is assumed to be zero.' &
   926:                       & )
   927:                   end if
   928:                   if ( NWPresentAVarInFile( InputFile, 'SoilMoistB' ) ) then
   929:                     call HistoryGet(                                 &
   930:                       & InputFile, 'SoilMoistB', range = time_range, & ! (in)
   931:                       & array = xy_SoilMoistB,                       & ! (out)
   932:                       & flag_mpi_split = flag_mpi_init               & ! (in) optional
   933:                       & )
   934:                   else
   935: +V===== A           xy_SoilMoistB = 0.0_DP
   936:                     call MessageNotify( 'M', module_name,             &
   937:                       & 'Variable, %c, cannot be found in file, %c.', &
   938:                       & c1 = 'SoilMoistB', c2 = trim(InputFile)       &
   939:                       & )
   940:                     call MessageNotify( 'M', module_name,             &
   941:                       & 'Values in SoilMoistB is assumed to be zero.' &
   942:                       & )
   943:                   end if
   944:                   if ( NWPresentAVarInFile( InputFile, 'SurfSnowB' ) ) then
   945:                     call HistoryGet(                                 &
   946:                       & InputFile, 'SurfSnowB', range = time_range,  & ! (in)
   947:                       & array = xy_SurfSnowB,                        & ! (out)
   948:                       & flag_mpi_split = flag_mpi_init               & ! (in) optional
   949:                       & )
   950:                   else
   951: +V===== A           xy_SurfSnowB = 0.0_DP
   952:                     call MessageNotify( 'M', module_name,             &
   953:                       & 'Variable, %c, cannot be found in file, %c.', &
   954:                       & c1 = 'SurfSnowB', c2 = trim(InputFile)        &
   955:                       & )
   956:                     call MessageNotify( 'M', module_name,             &
   957:                       & 'Values in SurfSnowB is assumed to be zero.'  &
   958:                       & )
   959:                   end if
   960:                   if ( NWPresentAVarInFile( InputFile, 'SurfMajCompIceN' ) ) then
   961:                     call HistoryGet(                                      &
   962:                       & InputFile, 'SurfMajCompIceN', range = time_range, & ! (in)
   963:                       & array = xy_SurfMajCompIceN,                       & ! (out)
   964:                       & flag_mpi_split = flag_mpi_init                    & ! (in) optional
   965:                       & )
   966:                   else
   967: +V===== A           xy_SurfMajCompIceN = xy_SurfMajCompIceB
   968:                     call MessageNotify( 'M', module_name,             &
   969:                       & 'Variable, %c, cannot be found in file, %c.', &
   970:                       & c1 = 'SurfMajCompIceN', c2 = trim(InputFile)  &
   971:                       & )
   972:                     call MessageNotify( 'M', module_name,                                         &
   973:                       & 'Values in SurfMajCompIceN is assumed to be the same as SurfMajCompIceB.' &
   974:                       & )
   975:                   end if
   976:                   if ( NWPresentAVarInFile( InputFile, 'SoilMoistN' ) ) then
   977:                     call HistoryGet(                                 &
   978:                       & InputFile, 'SoilMoistN', range = time_range, & ! (in)
   979:                       & array = xy_SoilMoistN,                       & ! (out)
   980:                       & flag_mpi_split = flag_mpi_init               & ! (in) optional
   981:                       & )
   982:                   else
   983: +V===== A           xy_SoilMoistN = xy_SoilMoistB
   984:                     call MessageNotify( 'M', module_name,             &
   985:                       & 'Variable, %c, cannot be found in file, %c.', &
   986:                       & c1 = 'SoilMoistN', c2 = trim(InputFile)       &
   987:                       & )
   988:                     call MessageNotify( 'M', module_name,                               &
   989:                       & 'Values in SoilMoistN is assumed to be the same as SoilMoistB.' &
   990:                       & )
   991:                   end if
   992:                   if ( NWPresentAVarInFile( InputFile, 'SurfSnowN' ) ) then
   993:                     call HistoryGet(                                 &
   994:                       & InputFile, 'SurfSnowN', range = time_range,  & ! (in)
   995:                       & array = xy_SurfSnowN,                        & ! (out)
   996:                       & flag_mpi_split = flag_mpi_init               & ! (in) optional
   997:                       & )
   998:                   else
   999: +V===== A           xy_SurfSnowN = xy_SurfSnowB
  1000:                     call MessageNotify( 'M', module_name,             &
  1001:                       & 'Variable, %c, cannot be found in file, %c.', &
  1002:                       & c1 = 'SurfSnowN', c2 = trim(InputFile)        &
  1003:                       & )
  1004:                     call MessageNotify( 'M', module_name,                             &
  1005:                       & 'Values in SurfSnowN is assumed to be the same as SurfSnowB.' &
  1006:                       & )
  1007:                   end if
  1008:             
  1009:                 end if
  1010:             
  1011:               end subroutine RestartSurfTempGet
  1012:             
  1013:               !--------------------------------------------------------------------------------------
  1014:             
  1015:               subroutine RestartSurfTempInit
  1016:                 !
  1017:                 ! restart_surftemp_io モジュールの初期化を行います. 
  1018:                 ! NAMELIST#restart_surftemp_io_nml の読み込みはこの手続きで行われます. 
  1019:                 !
  1020:                 ! "restart_surftemp_io" module is initialized. 
  1021:                 ! "NAMELIST#restart_surftemp_io_nml" is loaded in this procedure. 
  1022:                 !
  1023:             
  1024:                 ! モジュール引用 ; USE statements
  1025:                 !
  1026:             
  1027:                 ! リスタートデータ入出力
  1028:                 ! Restart data input/output
  1029:                 !
  1030:                 use restart_file_io, only: restart_file_io_inited, &
  1031:                   & RestartFileIntValue => IntValue, &
  1032:                                           ! リスタートデータの出力間隔. 
  1033:                                           ! Interval of restart data output
  1034:                   & RestartFileIntUnit  => IntUnit
  1035:                                           ! リスタートデータの出力間隔の単位. 
  1036:                                           ! Unit for interval of restart data output
  1037:             
  1038:                 ! 時刻管理
  1039:                 ! Time control
  1040:                 !
  1041:                 use timeset, only: &
  1042:                   & RestartTime           ! リスタート開始時刻. 
  1043:                                           ! Retart time of calculation
  1044:             
  1045:                 ! NAMELIST ファイル入力に関するユーティリティ
  1046:                 ! Utilities for NAMELIST file input
  1047:                 !
  1048:                 use namelist_util, only: namelist_filename, NmlutilMsg
  1049:             
  1050:                 ! 暦と日時の取り扱い
  1051:                 ! Calendar and Date handler
  1052:                 !
  1053:                 use dc_calendar, only: DCCalConvertByUnit
  1054:             
  1055:                 ! ファイル入出力補助
  1056:                 ! File I/O support
  1057:                 !
  1058:                 use dc_iounit, only: FileOpen
  1059:             
  1060:                 ! 種別型パラメタ
  1061:                 ! Kind type parameter
  1062:                 !
  1063:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1064:             
  1065:                 ! 宣言文 ; Declaration statements
  1066:                 !
  1067:             
  1068:                 ! 作業変数
  1069:                 ! Work variables
  1070:                 !
  1071:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1072:                                           ! Unit number for NAMELIST file open
  1073:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1074:                                           ! IOSTAT of NAMELIST read
  1075:             
  1076:                 ! NAMELIST 変数群
  1077:                 ! NAMELIST group name
  1078:                 !
  1079:                 namelist /restart_surftemp_io_nml/ &
  1080:                   & InputFile, &
  1081:                   ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
  1082:             !!$      & InputName, &
  1083:                   & OutputFile, &
  1084:                   & IntValue, IntUnit
  1085:                       !
  1086:                       ! デフォルト値については初期化手続 "restart_surftemp_io#RestartSurfTempInit" 
  1087:                       ! のソースコードを参照のこと. 
  1088:                       !
  1089:                       ! Refer to source codes in the initialization procedure
  1090:                       ! "restart_surftemp_io#RestartSurfTempInit" for the default values. 
  1091:                       !
  1092:             
  1093:             
  1094:                 ! 実行文 ; Executable statement
  1095:                 !
  1096:             
  1097:                 if ( restart_surftemp_io_inited ) return
  1098:             
  1099:             
  1100:                 ! デフォルト値の設定
  1101:                 ! Default values settings
  1102:                 !
  1103:                 InputFile  = ''
  1104:                 ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
  1105:             !!$    InputName  = 'SurfTemp'
  1106:                 if ( .not. flag_init_data_save ) then
  1107:                   OutputFile = 'rst_sst.nc'
  1108:                 else
  1109:                   OutputFile = 'sst.nc'
  1110:                 end if
  1111:             
  1112:                 if ( restart_file_io_inited ) then
  1113:                   IntValue   = RestartFileIntValue
  1114:                   IntUnit    = RestartFileIntUnit
  1115:                 else
  1116:                   IntValue   = 365.0_DP
  1117:                   IntUnit    = 'day'
  1118:                 end if
  1119:             
  1120:                 ! NAMELIST の読み込み
  1121:                 ! NAMELIST is input
  1122:                 !
  1123:                 if ( trim(namelist_filename) /= '' ) then
  1124:                   call FileOpen( unit_nml, &          ! (out)
  1125:                     & namelist_filename, mode = 'r' ) ! (in)
  1126:             
  1127:                   rewind( unit_nml )
  1128:                   read( unit_nml, &         ! (in)
  1129:                     & nml = restart_surftemp_io_nml, &  ! (out)
  1130:                     & iostat = iostat_nml ) ! (out)
  1131:                   close( unit_nml )
  1132:             
  1133:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1134:                   if ( iostat_nml == 0 ) write( STDOUT, nml = restart_surftemp_io_nml )
  1135:                 end if
  1136:             
  1137:                 ! 出力時間間隔の設定
  1138:                 ! Configure time interval of output
  1139:                 !
  1140:                 IntTime = DCCalConvertByUnit( IntValue, IntUnit, 'sec' ) ! (in)
  1141:                 PrevOutputTime = RestartTime
  1142:             
  1143:                 ! フラグの初期化
  1144:                 ! Initialize flag
  1145:                 !
  1146:                 flag_output_end = .false.
  1147:             
  1148:             
  1149:                 ! 印字 ; Print
  1150:                 !
  1151:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1152:                 call MessageNotify( 'M', module_name, 'Input:: ' )
  1153:                 call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
  1154:                 ! The variable name is fixed, 'SurfTemp' (yot, 2011/09/10).
  1155:             !!$    call MessageNotify( 'M', module_name, '  InputName  = %c', c1 = trim(InputName) )
  1156:                 call MessageNotify( 'M', module_name, 'Output:: ' )
  1157:                 call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
  1158:                 call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
  1159:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1160:             
  1161:                 restart_surftemp_io_inited = .true.
  1162:             
  1163:               end subroutine RestartSurfTempInit
  1164:             
  1165:               !--------------------------------------------------------------------------------------
  1166:             
  1167:             end module restart_surftemp_io
