Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:41 2016
FILE NAME: lscond_LL91.f90
PROGRAM NAME: lscond_ll91
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   293  opt  (  11): Fused array assignments. :line 293 - 305
   293  opt  (1593): Loop nest collapsed into one loop.
   293  vec  (   4): Vectorized array expression.
   293  vec  (  29): ADB is used for array.: xyz_temptentative
   293  vec  (  29): ADB is used for array.: xyz_qsol
   293  vec  (  29): ADB is used for array.: xyz_qliq
   293  vec  (  29): ADB is used for array.: xyz_qvap
   293  vec  (  29): ADB is used for array.: xyz_temp
   320  opt  (1592): Outer loop unrolled inside inner loop.
   321  vec  (   1): Vectorized loop.
   321  vec  (  29): ADB is used for array.: xyz_qvapsat
   321  vec  (   1): Vectorized loop.
   321  vec  (  29): ADB is used for array.: xyz_qvapsat
   346  vec  (   3): Unvectorized loop.
   356  opt  (1017): Subroutine call prevents optimization.
   356  vec  (  10): Vectorization obstructive procedure reference.:saturatewatfraction0d
   396  opt  (  11): Fused array assignments. :line 396 - 397
   396  opt  (1592): Outer loop unrolled inside inner loop.
   396  vec  (   4): Vectorized array expression.
   396  vec  (   4): Vectorized array expression.
   396  vec  (  29): ADB is used for array.: xyz_qvapsat
   407  opt  (  11): Fused array assignments. :line 407 - 410
   407  opt  (1592): Outer loop unrolled inside inner loop.
   407  vec  (   4): Vectorized array expression.
   407  vec  (  29): ADB is used for array.: xyz_dqsoldt
   407  vec  (  29): ADB is used for array.: xyz_qsol
   407  vec  (  29): ADB is used for array.: xyz_dqliqdt
   407  vec  (  29): ADB is used for array.: xyz_qliq
   407  vec  (  29): ADB is used for array.: xyz_dqvapdt
   407  vec  (  29): ADB is used for array.: xyz_qvap
   407  vec  (  29): ADB is used for array.: xyz_dtempdt
   407  vec  (  29): ADB is used for array.: xyz_temp
   407  vec  (   4): Vectorized array expression.
   407  vec  (  29): ADB is used for array.: xyz_dqsoldt
   407  vec  (  29): ADB is used for array.: xyz_qsol
   407  vec  (  29): ADB is used for array.: xyz_dqliqdt
   407  vec  (  29): ADB is used for array.: xyz_qliq
   407  vec  (  29): ADB is used for array.: xyz_dqvapdt
   407  vec  (  29): ADB is used for array.: xyz_qvap
   407  vec  (  29): ADB is used for array.: xyz_dtempdt
   407  vec  (  29): ADB is used for array.: xyz_temp
   414  opt  (1593): Loop nest collapsed into one loop.
   414  vec  (   4): Vectorized array expression.
   415  vec  (   3): Unvectorized loop.
   415  vec  (  13): Overhead of loop division is too large.
   416  opt  (1593): Loop nest collapsed into one loop.
   416  vec  (   4): Vectorized array expression.
   416  vec  (  29): ADB is used for array.: xy_rainlsc
   416  vec  (  29): ADB is used for array.: xyr_press
   416  vec  (  29): ADB is used for array.: xyz_dqsoldt
   416  vec  (  29): ADB is used for array.: xyz_dqliqdt
   424  opt  (1592): Outer loop unrolled inside inner loop.
   424  vec  (   4): Vectorized array expression.
   424  vec  (  29): ADB is used for array.: xy_rainlsc
   424  vec  (   4): Vectorized array expression.
   424  vec  (  29): ADB is used for array.: xy_rainlsc
   435  warn (  82): Name "xyz_dqliqdtlsc" is not used.
   435  warn (  82): Name "xyz_dqsoldtlsc" is not used.
   435  warn (  81): Name "xyz_dqvapdtlsc" is referenced but not defined.
   435  warn (  81): Name "xyz_dtempdtlsc" is referenced but not defined.
   435  warn (  82): Name "xyz_rainlsc" is not used.
   603  opt  (  11): Fused array assignments. :line 603 - 628
   603  vec  (   4): Vectorized array expression.
   603  vec  (  29): ADB is used for array.: xyz_qvap
   603  vec  (  29): ADB is used for array.: xyz_qvapsat
   603  vec  (  29): ADB is used for array.: xyz_tempcldy
   603  vec  (  29): ADB is used for array.: xyz_temp
   629  opt  (1772): Loop nest fused with following nest(s).
   629  opt  (1593): Loop nest collapsed into one loop.
   629  vec  (   1): Vectorized loop.
   629  vec  (  29): ADB is used for array.: xyz_qvap
   676  opt  (1017): Subroutine call prevents optimization.
   680  opt  (1592): Outer loop unrolled inside inner loop.
   681  vec  (   1): Vectorized loop.
   681  vec  (  29): ADB is used for array.: xyz_tempcldy
   681  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   681  vec  (  29): ADB is used for array.: xyz_qvapsat
   681  vec  (   1): Vectorized loop.
   681  vec  (  29): ADB is used for array.: xyz_tempcldy
   681  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   681  vec  (  29): ADB is used for array.: xyz_qvapsat
   736  opt  (  11): Fused array assignments. :line 736 - 780
   736  opt  (1593): Loop nest collapsed into one loop.
   736  vec  (   4): Vectorized array expression.
   736  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   736  vec  (  29): ADB is used for array.: xyz_dqvapdt
   736  vec  (  29): ADB is used for array.: xyz_dtempdt
   736  vec  (  29): ADB is used for array.: xyz_dtempdtlsc
   736  vec  (  29): ADB is used for array.: xyz_dqvapdtlsc
   736  vec  (  29): ADB is used for array.: xyz_qvap
   736  vec  (  29): ADB is used for array.: xyz_temp
   736  vec  (  29): ADB is used for array.: xyz_tempcldy
   784  opt  (1593): Loop nest collapsed into one loop.
   784  vec  (   4): Vectorized array expression.
   785  vec  (   3): Unvectorized loop.
   785  vec  (  13): Overhead of loop division is too large.
   786  opt  (1593): Loop nest collapsed into one loop.
   786  vec  (   4): Vectorized array expression.
   786  vec  (  29): ADB is used for array.: xy_rainlsc
   786  vec  (  29): ADB is used for array.: xyr_press
   786  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   793  opt  (1592): Outer loop unrolled inside inner loop.
   793  vec  (   4): Vectorized array expression.
   793  vec  (  29): ADB is used for array.: xy_rainlsc
   793  vec  (   4): Vectorized array expression.
   793  vec  (  29): ADB is used for array.: xy_rainlsc
   804  warn (  82): Name "xyz_rainlsc" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:41 2016
FILE NAME: lscond_LL91.f90
PROGRAM NAME: lscond_ll91
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 大規模凝結 (非対流性凝結) (Le Treut and Li, 1991)
     2  !
     3  != Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: lscond_LL91.f90,v 1.4 2015/01/29 12:02:56 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module lscond_LL91
    13    !
    14    != 大規模凝結 (非対流性凝結)
    15    !
    16    != Large scale condensation (non-convective condensation)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 大規模凝結過程によって温度と比湿を調節します.
    21    !
    22    ! Adjust temperature and specific humidity by
    23    ! a large scale condensation process.
    24    !
    25    !== References
    26    !
    27    !  Le Treut, H., and Z.-X. Li,
    28    !    Sensitivity of an atmospheric general circulation model to prescribed SST changes:
    29    !    feedback effects associated with the simulation of cloud optical properties,
    30    !    Clim. Dyn., 5, 175-187, 1991.
    31    !
    32    !  Manabe, S., J. Smagorinsky, R. F. Strickler,
    33    !    Simulated climatology of a general circulation model with a hydrologic cycle,
    34    !    Mon. Wea. Rev., 93, 769-798, 1965.
    35    !
    36    !== Procedures List
    37    !
    38    ! LScaleCondLL91     :: 温度と比湿の調節
    39    ! LScaleCondLL91Init :: 初期化
    40    ! -----------------  :: ------------
    41    ! LScaleCondLL91     :: Adjust temperature and specific humidity
    42    ! LScaleCondLL91Init :: Initialization
    43    !
    44    !== NAMELIST
    45    !
    46    ! NAMELIST#lscond_nml
    47    !
    48  
    49    ! モジュール引用 ; USE statements
    50    !
    51  
    52    ! 格子点設定
    53    ! Grid points settings
    54    !
    55    use gridset, only: imax, & ! 経度格子点数.
    56                               ! Number of grid points in longitude
    57      &                jmax, & ! 緯度格子点数.
    58                               ! Number of grid points in latitude
    59      &                kmax    ! 鉛直層数.
    60                               ! Number of vertical level
    61  
    62    ! 種別型パラメタ
    63    ! Kind type parameter
    64    !
    65    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    66      &                 STRING     ! 文字列.       Strings.
    67  
    68    ! メッセージ出力
    69    ! Message output
    70    !
    71    use dc_message, only: MessageNotify
    72  
    73    ! 宣言文 ; Declaration statements
    74    !
    75    implicit none
    76    private
    77  
    78    ! 公開手続き
    79    ! Public procedure
    80    !
    81    public:: LScaleCondLL91Ice
    82    public:: LScaleCondLL91
    83    public:: LScaleCondLL91Init
    84  
    85    ! 公開変数
    86    ! Public variables
    87    !
    88  
    89    ! 非公開変数
    90    ! Private variables
    91    !
    92    logical, save :: lscond_LL91_inited = .false.
    93                                ! 初期設定フラグ.
    94                                ! Initialization flag
    95  
    96    real(DP), save :: Gamma
    97                                !
    98                                ! Subgrid scale variation of specific humidity
    99                                ! expressed as fraction of specific humidity
   100  !!$  real(DP), save:: CrtlRH
   101  !!$                              ! 臨界相対湿度.
   102  !!$                              ! Critical relative humidity
   103    integer, save :: ItrtMax
   104                                ! イテレーション回数.
   105                                ! Number of iteration
   106  !!$  logical, save :: FlagUse
   107  !!$                              ! 使用フラグ
   108  !!$                              ! flag for use of this scheme
   109  
   110    character(*), parameter:: module_name = 'lscond_LL91'
   111                                ! モジュールの名称.
   112                                ! Module name
   113    character(*), parameter:: version = &
   114      & '$Name:  $' // &
   115      & '$Id: lscond_LL91.f90,v 1.4 2015/01/29 12:02:56 yot Exp $'
   116                                ! モジュールのバージョン
   117                                ! Module version
   118  
   119  contains
   120  
   121    !--------------------------------------------------------------------------------------
   122  
   123    subroutine LScaleCondLL91Ice(                            &
   124      & xyz_Press, xyr_Press,                                &  ! (in)
   125      & xyz_Temp, xyz_QVap, xyz_QLiq, xyz_QSol,              &  ! (inout)
   126      & xyz_DTempDt, xyz_DQVapDt, xyz_DQLiqDt, xyz_DQSolDt   &  ! (out)
   127      & )
   128      !
   129      ! 大規模凝結スキームにより, 温度と比湿を調節します.
   130      !
   131      ! Adjust temperature and specific humidity by
   132      ! large scale condensation scheme.
   133      !
   134  
   135      ! モジュール引用 ; USE statements
   136      !
   137  
   138      ! 物理定数設定
   139      ! Physical constants settings
   140      !
   141      use constants, only: &
   142        & Grav, &
   143                                ! $ g $ [m s-2].
   144                                ! 重力加速度.
   145                                ! Gravitational acceleration
   146        & CpDry, &
   147                                ! $ C_p $ [J kg-1 K-1].
   148                                ! 乾燥大気の定圧比熱.
   149                                ! Specific heat of air at constant pressure
   150        & LatentHeat, &
   151                                ! $ L $ [J kg-1] .
   152                                ! 凝結の潜熱.
   153                                ! Latent heat of condensation
   154        & LatentHeatFusion
   155  
   156  
   157      ! 時刻管理
   158      ! Time control
   159      !
   160      use timeset, only: &
   161        & DelTime, &            ! $ \Delta t $
   162        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   163        & TimesetClockStart, TimesetClockStop
   164  
   165      ! ヒストリデータ出力
   166      ! History data output
   167      !
   168      use gtool_historyauto, only: HistoryAutoPut
   169  
   170      ! 飽和比湿の算出
   171      ! Evaluate saturation specific humidity
   172      !
   173      use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp, SaturateWatFraction
   174  
   175      ! 宣言文 ; Declaration statements
   176      !
   177      implicit none
   178  
   179      real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   180                                ! $ p $ . 気圧 (整数レベル).
   181                                ! Air pressure (full level)
   182      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   183                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   184                                ! Air pressure (half level)
   185      real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   186                                ! $ T $ .     温度. Temperature
   187      real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   188                                ! $ q $ .     比湿. Specific humidity
   189      real(DP), intent(inout):: xyz_QLiq (0:imax-1, 1:jmax, 1:kmax)
   190                                ! $ q_l $ .     Specific liquid water content
   191      real(DP), intent(inout):: xyz_QSol (0:imax-1, 1:jmax, 1:kmax)
   192                                ! $ q_i $ .     Specific ice water content
   193      real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   194                                ! 温度変化率.
   195                                ! Temperature tendency
   196      real(DP), intent(out):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
   197                                ! 比湿変化率.
   198                                ! Specific humidity tendency
   199      real(DP), intent(out) :: xyz_DQLiqDt(0:imax-1,1:jmax,1:kmax)
   200      real(DP), intent(out) :: xyz_DQSolDt(0:imax-1,1:jmax,1:kmax)
   201  
   202  
   203      ! 作業変数
   204      ! Work variables
   205      !
   206      real(DP) :: xyz_CldFrac   (0:imax-1, 1:jmax, 1:kmax)
   207                                !
   208                                ! Cloud fraction
   209  
   210      real(DP) :: QCld
   211      real(DP) :: WatFrac
   212      real(DP) :: IceFrac
   213  
   214      real(DP) :: xy_RainLsc (0:imax-1, 1:jmax)
   215                                ! 降水量.
   216                                ! Precipitation
   217      real(DP) :: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   218                                ! 温度変化率.
   219                                ! Temperature tendency
   220      real(DP) :: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   221                                ! 比湿変化率.
   222                                ! Specific humidity tendency
   223      real(DP) :: xyz_DQLiqDtLsc (0:imax-1, 1:jmax, 1:kmax)
   224      real(DP) :: xyz_DQSolDtLsc (0:imax-1, 1:jmax, 1:kmax)
   225  
   226      real(DP) :: xyz_TempTentative(0:imax-1, 1:jmax, 1:kmax)
   227  
   228  
   229      real(DP) :: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   230                                ! 調節前の温度.
   231                                ! Temperature before adjust.
   232      real(DP) :: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   233                                ! 調節前の比湿.
   234                                ! Specific humidity before adjust.
   235      real(DP) :: xyz_QLiqB (0:imax-1, 1:jmax, 1:kmax)
   236      real(DP) :: xyz_QSolB (0:imax-1, 1:jmax, 1:kmax)
   237                                !
   238  
   239      real(DP) :: xyz_QTot         (0:imax-1, 1:jmax, 1:kmax)
   240      real(DP) :: xyz_DelQ         (0:imax-1, 1:jmax, 1:kmax)
   241  
   242  
   243      real(DP) :: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
   244                                ! 飽和比湿.
   245                                ! Saturation specific humidity.
   246      real(DP) :: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:kmax)
   247                                ! $ \DD{q_{\rm{sat}}}{T} $
   248      real(DP) :: DelTemp
   249                                ! 調節による温度変化量.
   250                                ! Temperature variation by adjustment
   251  
   252      integer :: i              ! 経度方向に回る DO ループ用作業変数
   253                                ! Work variables for DO loop in longitude
   254      integer :: j              ! 緯度方向に回る DO ループ用作業変数
   255                                ! Work variables for DO loop in latitude
   256      integer :: k              ! 鉛直方向に回る DO ループ用作業変数
   257                                ! Work variables for DO loop in vertical direction
   258      integer :: itr            ! イテレーション方向に回る DO ループ用作業変数
   259                                ! Work variables for DO loop in iteration direction
   260  
   261      real(DP) :: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)
   262  
   263      logical  :: xyz_FlagSaturated(0:imax-1, 1:jmax, 1:kmax)
   264  
   265      ! Variables for debug
   266  !!$    real(DP) :: TempBefAdj
   267  !!$    real(DP) :: QVapBefAdj
   268  
   269  
   270      ! 実行文 ; Executable statement
   271      !
   272  
   273      ! 初期化確認
   274      ! Initialization check
   275      !
   276      if ( .not. lscond_LL91_inited ) then
   277        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   278      end if
   279  
   280  !!$    if ( .not. FlagUse ) return
   281  
   282  
   283      ! 計算時間計測開始
   284      ! Start measurement of computation time
   285      !
   286      call TimesetClockStart( module_name )
   287  
   288  
   289  
   290      ! 調節前 "QVap", "Temp" の保存
   291      ! Store "QVap", "Temp" before adjustment
   292      !
   293      xyz_TempB  = xyz_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t808 = 1, xyz_tempb.DSC.U3*(xyz_tempb.DSC.U2*xyz_tempb.DSC.U1  
     .       1    + xyz_tempb.DSC.U2)                                           
     .           xyz_tempb(t808-1,1,1) = xyz_temp(t808-1,1,1)                   
     .           xyz_qvapb(t808-1,1,1) = xyz_qvap(t808-1,1,1)                   
     .           xyz_qliqb(t808-1,1,1) = xyz_qliq(t808-1,1,1)                   
     .           xyz_qsolb(t808-1,1,1) = xyz_qsol(t808-1,1,1)                   
     .           xyz_qtot(t808-1,1,1) = xyz_qvap(t808-1,1,1) + xyz_qliq(t808-1,1
     .       1      ,1) + xyz_qsol(t808-1,1,1)                                  
     .           xyz_delq(t808-1,1,1) = gamma*xyz_qtot(t808-1,1,1)              
     .           xyz_temptentative(t808-1,1,1) = xyz_temp(t808-1,1,1) -         
     .       1      latentheat*xyz_qliq(t808-1,1,1) - (latentheat +             
     .       2      latentheatfusion)*xyz_qsol(t808-1,1,1)                      
     .        enddo                                                             
   294      xyz_QVapB  = xyz_QVap
   295      xyz_QLiqB  = xyz_QLiq
   296      xyz_QSolB  = xyz_QSol
   297  
   298      xyz_QTot = xyz_QVap + xyz_QLiq + xyz_QSol
   299      xyz_DelQ = Gamma * xyz_QTot
   300  
   301  
   302      ! All cloud water and ice are evaporated temporarily
   303      ! After this temporal evaporation, adjustment will be done below.
   304      !
   305      xyz_TempTentative = xyz_Temp                       &
   306        & -   LatentHeat                      * xyz_QLiq &
   307        & - ( LatentHeat + LatentHeatFusion ) * xyz_QSol
   308  
   309  
   310      ! 調節
   311      ! Adjustment
   312      !
   313  
   314      ! 飽和比湿計算
   315      ! Calculate saturation specific humidity
   316      !
   317      xyz_QVapSat = xyz_CalcQVapSat( xyz_TempTentative, xyz_Press )
   318  
   319      do k = 1, kmax
   320        do j = 1, jmax
   321          do i = 0, imax-1
   322  
   323  !!$          if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) ) >= CrtlRH ) then
   324            if ( ( ( xyz_QTot(i,j,k) + xyz_DelQ(i,j,k) ) / xyz_QVapSat(i,j,k) ) >= 1.0_DP ) then
   325              xyz_FlagSaturated(i,j,k) = .true.
   326            else
   327              xyz_FlagSaturated(i,j,k) = .false.
   328            end if
   329  
   330          end do
   331        end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if ((xyz_qtot(i-1,j,k)+xyz_delq(i-1,j,k))/xyz_qvapsat(i-1
     .       1            ,j,k) .ge. 1.00000000000000e+000) then                
     .                    xyz_flagsaturated2 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated2 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j,k) = xyz_flagsaturated2          
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if ((xyz_qtot(i-1,j,k)+xyz_delq(i-1,j,k))/xyz_qvapsat(i-1
     .       1            ,j,k) .ge. 1.00000000000000e+000) then                
     .                    xyz_flagsaturated3 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated3 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j,k) = xyz_flagsaturated3          
     .                 if ((xyz_qtot(i-1,j+1,k)+xyz_delq(i-1,j+1,k))/xyz_qvapsat
     .       1            (i-1,j+1,k) .ge. 1.00000000000000e+000) then          
     .                    xyz_flagsaturated4 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated4 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j+1,k) = xyz_flagsaturated4        
     .                 if ((xyz_qtot(i-1,j+2,k)+xyz_delq(i-1,j+2,k))/xyz_qvapsat
     .       1            (i-1,j+2,k) .ge. 1.00000000000000e+000) then          
     .                    xyz_flagsaturated5 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated5 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j+2,k) = xyz_flagsaturated5        
     .                 if ((xyz_qtot(i-1,j+3,k)+xyz_delq(i-1,j+3,k))/xyz_qvapsat
     .       1            (i-1,j+3,k) .ge. 1.00000000000000e+000) then          
     .                    xyz_flagsaturated6 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated6 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j+3,k) = xyz_flagsaturated6        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   332      end do
   333  
   334  
   335      do itr = 1, ItrtMax
   336  
   337  
   338        ! 飽和比湿計算
   339        ! Calculate saturation specific humidity
   340        !
   341        xyz_QVapSat       = xyz_CalcQVapSat      ( xyz_Temp, xyz_Press   )
   342        xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   343  
   344        do k = 1, kmax
   345          do j = 1, jmax
   346            do i = 0, imax-1
   347  
   348              ! 飽和していたら, 温度と比湿の変化を計算
   349              ! Calculate tendency of temperature and humidity
   350              ! if moist is saturation.
   351              !
   352              if ( xyz_FlagSaturated(i,j,k) ) then
   353  
   354  
   355                ! Liquid water and ice fractions
   356                call SaturateWatFraction(   &
   357                  & xyz_Temp(i,j,k),        & ! (in )
   358                  & WatFrac                 & ! (out)
   359                  & )
   360                IceFrac = 1.0_DP - WatFrac
   361  
   362                ! 温度の変化分をニュートン法で求める
   363                ! Calculate variation of temperature
   364                !
   365                DelTemp = &
   366                  & ( &
   367                  &     LatentHeat            &
   368                  &     * (   xyz_QVap(i,j,k) &
   369                  &         - ( xyz_QVapSat(i,j,k) + xyz_QTot(i,j,k) - xyz_DelQ(i,j,k) ) / 2.0_DP ) &
   370                  &   - LatentHeatFusion                      &
   371                  &     * (   xyz_QSol(i,j,k)                 &
   372                  &         - IceFrac * ( xyz_QVapSat(i,j,k) + xyz_QTot(i,j,k) + xyz_DelQ(i,j,k) ) / 2.0_DP ) &
   373                  & ) &
   374                  &    / (   CpDry &
   375                  &        + ( LatentHeat - LatentHeatFusion * IceFrac ) &
   376                  &          * xyz_DQVapSatDTemp(i,j,k) / 2.0_DP )
   377  
   378  
   379                ! 温度と比湿の調節
   380                ! Adjust temperature and specific humidity
   381                !
   382                xyz_QVapSat(i,j,k) = &
   383                  & xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp
   384                xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
   385                QCld = ( xyz_QVapSat(i,j,k) + xyz_QTot(i,j,k) + xyz_DelQ(i,j,k) ) / 2.0_DP
   386                xyz_QVap(i,j,k) = ( xyz_QVapSat(i,j,k) + xyz_QTot(i,j,k) - xyz_DelQ(i,j,k) ) / 2.0_DP
   387                xyz_QLiq(i,j,k) = WatFrac * QCld
   388                xyz_QSol(i,j,k) = IceFrac * QCld
   389  
   390              end if
   391  
   392            end do
   393          end do
   394        end do
   395  
   396        xyz_CldFrac = ( xyz_QTot + xyz_DelQ - xyz_QVapSat )
     .        if (xyz_qtot.DSC.U2 .gt. 0) then                                  
     .           j7 = and(xyz_qtot.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t870 = 1, j7                                                
     .  !cdir       nodep                                                       
     .              do t872 = 1, xyz_qtot.DSC.U1 + 1                            
     .                 xyz_cldfrac1 = xyz_qtot(t872-1,t870,t868+1) + xyz_delq(  
     .       1            t872-1,t870,t868+1) - xyz_qvapsat(t872-1,t870,t868+1) 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t870 = j7 + 1, xyz_qtot.DSC.U2, 4                           
     .  !cdir       nodep                                                       
     .              do t872 = 1, xyz_qtot.DSC.U1 + 1                            
     .                 xyz_cldfrac(t872-1,t870,t868+1) = xyz_qtot(t872-1,t870,  
     .       1            t868+1) + xyz_delq(t872-1,t870,t868+1) - xyz_qvapsat( 
     .       2            t872-1,t870,t868+1)                                   
     .                 xyz_cldfrac(t872-1,t870+1,t868+1) = xyz_qtot(t872-1,t870+
     .       1            1,t868+1) + xyz_delq(t872-1,t870+1,t868+1) -          
     .       2            xyz_qvapsat(t872-1,t870+1,t868+1)                     
     .                 xyz_cldfrac(t872-1,t870+2,t868+1) = xyz_qtot(t872-1,t870+
     .       1            2,t868+1) + xyz_delq(t872-1,t870+2,t868+1) -          
     .       2            xyz_qvapsat(t872-1,t870+2,t868+1)                     
     .                 xyz_cldfrac(t872-1,t870+3,t868+1) = xyz_qtot(t872-1,t870+
     .       1            3,t868+1) + xyz_delq(t872-1,t870+3,t868+1) -          
     .       2            xyz_qvapsat(t872-1,t870+3,t868+1)                     
     .                 xyz_cldfrac(t872-1,t870,t868+1) = max(min(xyz_cldfrac(   
     .       1            t872-1,t870,t868+1),1.00000000000000e+000),           
     .       2            0.0000000000000000e+000)                              
     .                 xyz_cldfrac(t872-1,t870+1,t868+1) = max(min(xyz_cldfrac( 
     .       1            t872-1,t870+1,t868+1),1.00000000000000e+000),         
     .       2            0.0000000000000000e+000)                              
     .                 xyz_cldfrac(t872-1,t870+2,t868+1) = max(min(xyz_cldfrac( 
     .       1            t872-1,t870+2,t868+1),1.00000000000000e+000),         
     .       2            0.0000000000000000e+000)                              
     .                 xyz_cldfrac(t872-1,t870+3,t868+1) = max(min(xyz_cldfrac( 
     .       1            t872-1,t870+3,t868+1),1.00000000000000e+000),         
     .       2            0.0000000000000000e+000)                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   397        xyz_CldFrac = max( min( xyz_CldFrac, 1.0_DP ), 0.0_DP )
   398  
   399  
   400      end do
   401  
   402  
   403      ! 比湿変化率, 温度変化率, 降水量の算出
   404      ! Calculate specific humidity tendency, temperature tendency,
   405      ! precipitation
   406      !
   407      xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j8 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t894 = 1, j8                                                
     .              d2 = 1.D0/(2.00000000000000e+000*deltime)                   
     .              d3 = 1.D0/(2.00000000000000e+000*deltime)                   
     .              d4 = 1.D0/(2.00000000000000e+000*deltime)                   
     .              d5 = 1.D0/(2.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do t896 = 1, xyz_temp.DSC.U1 + 1                            
     .                 xyz_dtempdt(t896-1,t894,t892+1) = (xyz_temp(t896-1,t894, 
     .       1            t892+1)-xyz_tempb(t896-1,t894,t892+1))*d2             
     .                 xyz_dqvapdt(t896-1,t894,t892+1) = (xyz_qvap(t896-1,t894, 
     .       1            t892+1)-xyz_qvapb(t896-1,t894,t892+1))*d3             
     .                 xyz_dqliqdt(t896-1,t894,t892+1) = (xyz_qliq(t896-1,t894, 
     .       1            t892+1)-xyz_qliqb(t896-1,t894,t892+1))*d4             
     .                 xyz_dqsoldt(t896-1,t894,t892+1) = (xyz_qsol(t896-1,t894, 
     .       1            t892+1)-xyz_qsolb(t896-1,t894,t892+1))*d5             
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t894 = j8 + 1, xyz_temp.DSC.U2, 4                           
     .              d6 = 1.D0/(2.00000000000000e+000*deltime)                   
     .              d7 = 1.D0/(2.00000000000000e+000*deltime)                   
     .              d8 = 1.D0/(2.00000000000000e+000*deltime)                   
     .              d9 = 1.D0/(2.00000000000000e+000*deltime)                   
     .              d10 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d11 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d12 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d13 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d14 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d15 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d16 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d17 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d18 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d19 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d20 = 1.D0/(2.00000000000000e+000*deltime)                  
     .              d21 = 1.D0/(2.00000000000000e+000*deltime)                  
     .  !cdir       nodep                                                       
     .              do t896 = 1, xyz_temp.DSC.U1 + 1                            
     .                 xyz_dtempdt(t896-1,t894,t892+1) = (xyz_temp(t896-1,t894, 
     .       1            t892+1)-xyz_tempb(t896-1,t894,t892+1))*d6             
     .                 xyz_dtempdt(t896-1,t894+1,t892+1) = (xyz_temp(t896-1,t894
     .       1            +1,t892+1)-xyz_tempb(t896-1,t894+1,t892+1))*d7        
     .                 xyz_dtempdt(t896-1,t894+2,t892+1) = (xyz_temp(t896-1,t894
     .       1            +2,t892+1)-xyz_tempb(t896-1,t894+2,t892+1))*d8        
     .                 xyz_dtempdt(t896-1,t894+3,t892+1) = (xyz_temp(t896-1,t894
     .       1            +3,t892+1)-xyz_tempb(t896-1,t894+3,t892+1))*d9        
     .                 xyz_dqvapdt(t896-1,t894,t892+1) = (xyz_qvap(t896-1,t894, 
     .       1            t892+1)-xyz_qvapb(t896-1,t894,t892+1))*d10            
     .                 xyz_dqvapdt(t896-1,t894+1,t892+1) = (xyz_qvap(t896-1,t894
     .       1            +1,t892+1)-xyz_qvapb(t896-1,t894+1,t892+1))*d11       
     .                 xyz_dqvapdt(t896-1,t894+2,t892+1) = (xyz_qvap(t896-1,t894
     .       1            +2,t892+1)-xyz_qvapb(t896-1,t894+2,t892+1))*d12       
     .                 xyz_dqvapdt(t896-1,t894+3,t892+1) = (xyz_qvap(t896-1,t894
     .       1            +3,t892+1)-xyz_qvapb(t896-1,t894+3,t892+1))*d13       
     .                 xyz_dqliqdt(t896-1,t894,t892+1) = (xyz_qliq(t896-1,t894, 
     .       1            t892+1)-xyz_qliqb(t896-1,t894,t892+1))*d14            
     .                 xyz_dqliqdt(t896-1,t894+1,t892+1) = (xyz_qliq(t896-1,t894
     .       1            +1,t892+1)-xyz_qliqb(t896-1,t894+1,t892+1))*d15       
     .                 xyz_dqliqdt(t896-1,t894+2,t892+1) = (xyz_qliq(t896-1,t894
     .       1            +2,t892+1)-xyz_qliqb(t896-1,t894+2,t892+1))*d16       
     .                 xyz_dqliqdt(t896-1,t894+3,t892+1) = (xyz_qliq(t896-1,t894
     .       1            +3,t892+1)-xyz_qliqb(t896-1,t894+3,t892+1))*d17       
     .                 xyz_dqsoldt(t896-1,t894,t892+1) = (xyz_qsol(t896-1,t894, 
     .       1            t892+1)-xyz_qsolb(t896-1,t894,t892+1))*d18            
     .                 xyz_dqsoldt(t896-1,t894+1,t892+1) = (xyz_qsol(t896-1,t894
     .       1            +1,t892+1)-xyz_qsolb(t896-1,t894+1,t892+1))*d19       
     .                 xyz_dqsoldt(t896-1,t894+2,t892+1) = (xyz_qsol(t896-1,t894
     .       1            +2,t892+1)-xyz_qsolb(t896-1,t894+2,t892+1))*d20       
     .                 xyz_dqsoldt(t896-1,t894+3,t892+1) = (xyz_qsol(t896-1,t894
     .       1            +3,t892+1)-xyz_qsolb(t896-1,t894+3,t892+1))*d21       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   408      xyz_DQVapDt = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
   409      xyz_DQLiqDt = ( xyz_QLiq - xyz_QLiqB ) / ( 2.0_DP * DelTime )
   410      xyz_DQSolDt = ( xyz_QSol - xyz_QSolB ) / ( 2.0_DP * DelTime )
   411  
   412  
   413      ! calculation for output
   414      xy_RainLsc     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t934 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t934-1,1) = 0.0000000000000000e+000                 
     .        enddo                                                             
   415      do k = kmax, 1, -1
   416        xy_RainLsc = xy_RainLsc                                     &
     .        d22 = 1.D0/grav                                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_rainlsc,xyr_press)                                      
     .        do t940 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t940-1,1) = xy_rainlsc(t940-1,1) + (xyz_dqliqdt(t940
     .       1      -1,1,k)+xyz_dqsoldt(t940-1,1,k))*(xyr_press(t940-1,1,k-1)-  
     .       2      xyr_press(t940-1,1,k))*d22                                  
     .        enddo                                                             
   417          & + ( xyz_DQLiqDt(:,:,k) + xyz_DQSolDt(:,:,k) )           &
   418          &   * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   419      end do
   420  
   421      ! ヒストリデータ出力
   422      ! History data output
   423      !
   424      call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc * LatentHeat )
     .        if (xy_rainlsc.DSC.U2 .gt. 0) then                                
     .           j9 = and(xy_rainlsc.DSC.U2,3)                                  
     .  !cdir    nodep                                                          
     .           do t956 = 1, j9                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_rainlsc)                                          
     .              do t958 = 1, xy_rainlsc.DSC.U1 + 1                          
     .                 %IG0(t958,t956) = xy_rainlsc(t958-1,t956)*latentheat     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t956 = j9 + 1, xy_rainlsc.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_rainlsc)                                          
     .              do t958 = 1, xy_rainlsc.DSC.U1 + 1                          
     .                 %IG0(t958,t956) = xy_rainlsc(t958-1,t956)*latentheat     
     .                 %IG0(t958,t956+1) = xy_rainlsc(t958-1,t956+1)*latentheat 
     .                 %IG0(t958,t956+2) = xy_rainlsc(t958-1,t956+2)*latentheat 
     .                 %IG0(t958,t956+3) = xy_rainlsc(t958-1,t956+3)*latentheat 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   425      call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   426      call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
   427  
   428  
   429  
   430      ! 計算時間計測一時停止
   431      ! Pause measurement of computation time
   432      !
   433      call TimesetClockStop( module_name )
   434  
   435    end subroutine LScaleCondLL91Ice
   436  
   437    !--------------------------------------------------------------------------------------
   438  
   439    subroutine LScaleCondLL91(       &
   440      & xyz_Temp, xyz_QVap,          &  ! (inout)
   441      & xyz_DTempDt, xyz_DQVapDt,    &  ! (inout)
   442      & xyz_Press, xyr_Press,        &  ! (in)
   443      & xyz_DQH2OLiqDt               &  ! (out)
   444      & )
   445      !
   446      ! 大規模凝結スキームにより, 温度と比湿を調節します.
   447      !
   448      ! Adjust temperature and specific humidity by
   449      ! large scale condensation scheme.
   450      !
   451  
   452      ! モジュール引用 ; USE statements
   453      !
   454  
   455      ! 物理定数設定
   456      ! Physical constants settings
   457      !
   458      use constants, only: &
   459        & Grav, &
   460                                ! $ g $ [m s-2].
   461                                ! 重力加速度.
   462                                ! Gravitational acceleration
   463        & CpDry, &
   464                                ! $ C_p $ [J kg-1 K-1].
   465                                ! 乾燥大気の定圧比熱.
   466                                ! Specific heat of air at constant pressure
   467        & LatentHeat
   468                                ! $ L $ [J kg-1] .
   469                                ! 凝結の潜熱.
   470                                ! Latent heat of condensation
   471  
   472      ! 時刻管理
   473      ! Time control
   474      !
   475      use timeset, only: &
   476        & DelTime, &            ! $ \Delta t $
   477        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   478        & TimesetClockStart, TimesetClockStop
   479  
   480      ! ヒストリデータ出力
   481      ! History data output
   482      !
   483      use gtool_historyauto, only: HistoryAutoPut
   484  
   485      ! 飽和比湿の算出
   486      ! Evaluate saturation specific humidity
   487      !
   488      use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp
   489  
   490  
   491      ! 宣言文 ; Declaration statements
   492      !
   493      implicit none
   494  
   495      real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   496                                ! $ T $ .     温度. Temperature
   497      real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   498                                ! $ q $ .     比湿. Specific humidity
   499      real(DP), intent(inout):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   500                                ! 温度変化率.
   501                                ! Temperature tendency
   502      real(DP), intent(inout):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
   503                                ! 比湿変化率.
   504                                ! Specific humidity tendency
   505      real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   506                                ! $ p $ . 気圧 (整数レベル).
   507                                ! Air pressure (full level)
   508      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   509                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   510                                ! Air pressure (half level)
   511      real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
   512  
   513  
   514      ! 作業変数
   515      ! Work variables
   516      !
   517      real(DP) :: xyz_CldFrac   (0:imax-1, 1:jmax, 1:kmax)
   518                                !
   519                                ! Cloud fraction
   520      real(DP) :: xyz_QVapHalRan(0:imax-1, 1:jmax, 1:kmax)
   521                                !
   522                                ! Half range of specific humidity
   523      real(DP) :: xyz_QVapCler  (0:imax-1, 1:jmax, 1:kmax)
   524                                !
   525                                ! Specific humidity in clear region
   526      real(DP) :: xyz_QVapCldy  (0:imax-1, 1:jmax, 1:kmax)
   527                                !
   528                                ! Specific humidity in cloudy region
   529      real(DP) :: xyz_TempCler  (0:imax-1, 1:jmax, 1:kmax)
   530                                !
   531                                ! Temperature in clear region
   532      real(DP) :: xyz_TempCldy  (0:imax-1, 1:jmax, 1:kmax)
   533                                !
   534                                ! Temperature in cloudy region
   535  
   536      real(DP) :: xy_RainLsc (0:imax-1, 1:jmax)
   537                                ! 降水量.
   538                                ! Precipitation
   539      real(DP) :: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   540                                ! 温度変化率.
   541                                ! Temperature tendency
   542      real(DP) :: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   543                                ! 比湿変化率.
   544                                ! Specific humidity tendency
   545  
   546      real(DP) :: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   547                                ! 調節前の比湿.
   548                                ! Specific humidity before adjust.
   549      real(DP) :: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   550                                ! 調節前の温度.
   551                                ! Temperature before adjust.
   552                                !
   553      real(DP) :: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
   554                                ! 飽和比湿.
   555                                ! Saturation specific humidity.
   556      real(DP) :: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:kmax)
   557                                ! $ \DD{q_{\rm{sat}}}{T} $
   558      real(DP) :: DelTemp
   559                                ! 調節による温度変化量.
   560                                ! Temperature variation by adjustment
   561  
   562      integer :: i              ! 経度方向に回る DO ループ用作業変数
   563                                ! Work variables for DO loop in longitude
   564      integer :: j              ! 緯度方向に回る DO ループ用作業変数
   565                                ! Work variables for DO loop in latitude
   566      integer :: k              ! 鉛直方向に回る DO ループ用作業変数
   567                                ! Work variables for DO loop in vertical direction
   568      integer :: itr            ! イテレーション方向に回る DO ループ用作業変数
   569                                ! Work variables for DO loop in iteration direction
   570  
   571      real(DP) :: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)
   572  
   573      logical  :: xyz_FlagSaturated(0:imax-1, 1:jmax, 1:kmax)
   574  
   575      ! Variables for debug
   576  !!$    real(DP) :: TempBefAdj
   577  !!$    real(DP) :: QVapBefAdj
   578  
   579  
   580      ! 実行文 ; Executable statement
   581      !
   582  
   583      ! 初期化確認
   584      ! Initialization check
   585      !
   586      if ( .not. lscond_LL91_inited ) then
   587        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   588      end if
   589  
   590  !!$    if ( .not. FlagUse ) return
   591  
   592  
   593      ! 計算時間計測開始
   594      ! Start measurement of computation time
   595      !
   596      call TimesetClockStart( module_name )
   597  
   598  
   599  
   600      ! 調節前 "QVap", "Temp" の保存
   601      ! Store "QVap", "Temp" before adjustment
   602      !
   603      xyz_QVapB  = xyz_QVap
   604      xyz_TempB  = xyz_Temp
   605  
   606  
   607      ! 調節
   608      ! Adjustment
   609      !
   610  
   611      ! 飽和比湿計算
   612      ! Calculate saturation specific humidity
   613      !
   614      xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   615  
   616  
   617      ! Preparation for temperature in clear and cloudy regions
   618      !
   619      xyz_TempCler = xyz_Temp
   620      xyz_TempCldy = xyz_Temp
   621  
   622      ! Calculation of cloud fraction, specific humidities in clear and cloudy regions
   623      !
   624      xyz_QVapHalRan = Gamma * xyz_QVap
   625      xyz_CldFrac  = ( xyz_QVap + xyz_QVapHalRan - xyz_QVapSat ) &
   626        & / ( 2.0_DP * xyz_QVapHalRan + 1.0e-100_DP )
   627      xyz_QVapCler = ( xyz_QVapSat + xyz_QVap - xyz_QVapHalRan ) / 2.0_DP
   628      xyz_QVapCldy = ( xyz_QVapSat + xyz_QVap + xyz_QVapHalRan ) / 2.0_DP
   629      do k = 1, kmax
   630        do j = 1, jmax
   631          do i = 0, imax-1
   632            if ( xyz_CldFrac(i,j,k) >= 1.0_DP ) then
   633              xyz_QVapCler(i,j,k) = 0.0_DP
   634              xyz_QVapCldy(i,j,k) = xyz_QVap(i,j,k)
   635            else if ( xyz_CldFrac(i,j,k) <= 0.0_DP ) then
   636              xyz_QVapCler(i,j,k) = xyz_QVap(i,j,k)
   637              xyz_QVapCldy(i,j,k) = 0.0_DP
   638            end if
   639          end do
   640        end do
   641      end do
   642      do k = 1, kmax
   643        do j = 1, jmax
   644          do i = 0, imax-1
   645            if ( xyz_CldFrac(i,j,k) > 1.0_DP ) then
   646              xyz_CldFrac(i,j,k) = 1.0_DP
   647            else if ( xyz_CldFrac(i,j,k) < 0.0_DP ) then
   648              xyz_CldFrac(i,j,k) = 0.0_DP
   649            end if
   650          end do
   651        end do
   652      end do
   653  
   654  
   655      do k = 1, kmax
   656        do j = 1, jmax
   657          do i = 0, imax-1
   658  
   659  !!$          if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) ) >= CrtlRH ) then
   660            if ( xyz_CldFrac(i,j,k) > 0.0_DP ) then
   661              xyz_FlagSaturated(i,j,k) = .true.
   662            else
   663              xyz_FlagSaturated(i,j,k) = .false.
   664            end if
   665  
   666          end do
   667        end do
   668      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_cldfrac(k-1,1,1) .ge. 1.00000000000000e+000) then      
     .              xyz_qvapcler(k-1,1,1) = 0.0000000000000000e+000             
     .              xyz_qvapcldy(k-1,1,1) = xyz_qvap(k-1,1,1)                   
     .           else                                                           
     .              if (xyz_cldfrac(k-1,1,1) .le. 0.0000000000000000e+000) then 
     .                 xyz_qvapcler(k-1,1,1) = xyz_qvap(k-1,1,1)                
     .                 xyz_qvapcldy(k-1,1,1) = 0.0000000000000000e+000          
     .              endif                                                       
     .           endif                                                          
     .           if (xyz_cldfrac(k-1,1,1) .gt. 1.00000000000000e+000) then      
     .              xyz_cldfrac(k-1,1,1) = 1.00000000000000e+000                
     .           else                                                           
     .              if (xyz_cldfrac(k-1,1,1) .lt. 0.0000000000000000e+000) then 
     .                 xyz_cldfrac(k-1,1,1) = 0.0000000000000000e+000           
     .              endif                                                       
     .           endif                                                          
     .           if (xyz_cldfrac(k-1,1,1) .gt. 0.0000000000000000e+000) then    
     .              xyz_flagsaturated1 = 1                                      
     .           else                                                           
     .              xyz_flagsaturated1 = 0                                      
     .           endif                                                          
     .           xyz_flagsaturated(k-1,1,1) = xyz_flagsaturated1                
     .        enddo                                                             
   669  
   670  
   671      do itr = 1, ItrtMax
   672  
   673        ! 飽和比湿計算
   674        ! Calculate saturation specific humidity
   675        !
   676        xyz_QVapSat       = xyz_CalcQVapSat      ( xyz_TempCldy, xyz_Press   )
   677        xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_TempCldy, xyz_QVapSat )
   678  
   679        do k = 1, kmax
   680          do j = 1, jmax
   681            do i = 0, imax-1
   682  
   683              ! 飽和していたら, 温度と比湿の変化を計算
   684              ! Calculate tendency of temperature and humidity
   685              ! if moist is saturation.
   686              !
   687              if ( xyz_FlagSaturated(i,j,k) ) then
   688  
   689                ! 温度の変化分をニュートン法で求める
   690                ! Calculate variation of temperature
   691                !
   692                DelTemp = &
   693                  & LatentHeat * ( xyz_QVapCldy(i,j,k) - xyz_QVapSat(i,j,k) ) &
   694                  &    / ( CpDry + LatentHeat * xyz_DQVapSatDTemp(i,j,k) )
   695  
   696  
   697                !=========
   698                ! check routine
   699                !---------
   700  !!$              TempBefAdj = xyz_TempCldy(i,j,k)
   701  !!$              QVapBefAdj = xyz_QVapCldy(i,j,k)
   702                !=========
   703  
   704                ! 温度と比湿の調節
   705                ! Adjust temperature and specific humidity
   706                !
   707                xyz_TempCldy(i,j,k) = xyz_TempCldy(i,j,k) &
   708                  & + DelTemp
   709                xyz_QVapCldy(i,j,k) = xyz_QVapSat(i,j,k)  &
   710                  & + xyz_DQVapSatDTemp(i,j,k) * DelTemp
   711  
   712                !=========
   713                ! check routine
   714                !---------
   715  !!$              write( 6, * ) '====='
   716  !!$              write( 6, * ) 'Energy difference before and after adjustment and each energy', xyz_CldFrac(i,j,k)
   717  !!$              write( 6, * ) &
   718  !!$                & (     CpDry*TempBefAdj          + LatentHeat*QVapBefAdj              &
   719  !!$                &   - ( CpDry*xyz_TempCldy(i,j,k) + LatentHeat*xyz_QVapCldy(i,j,k) ) ) &
   720  !!$                & /(    CpDry*TempBefAdj          + LatentHeat*QVapBefAdj ),           &
   721  !!$                &     CpDry*TempBefAdj          + LatentHeat*QVapBefAdj,               &
   722  !!$                &   ( CpDry*xyz_TempCldy(i,j,k) + LatentHeat*xyz_QVapCldy(i,j,k) )
   723                !=========
   724  
   725  
   726              end if
   727  
   728            end do
   729          end do
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           do j = 1, j2                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_flagsaturated(i-1,j,k) .ne. 0) then              
     .                    deltemp = latentheat*(xyz_qvapcldy(i-1,j,k)-          
     .       1               xyz_qvapsat(i-1,j,k))/(cpdry + latentheat*         
     .       2               xyz_dqvapsatdtemp(i-1,j,k))                        
     .                    xyz_tempcldy(i-1,j,k) = xyz_tempcldy(i-1,j,k) +       
     .       1               deltemp                                            
     .                    xyz_qvapcldy(i-1,j,k) = xyz_qvapsat(i-1,j,k) +        
     .       1               xyz_dqvapsatdtemp(i-1,j,k)*deltemp                 
     .                 endif                                                    
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j2 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_flagsaturated(i-1,j,k) .ne. 0) then              
     .                    deltemp4 = latentheat*(xyz_qvapcldy(i-1,j,k)-         
     .       1               xyz_qvapsat(i-1,j,k))/(cpdry + latentheat*         
     .       2               xyz_dqvapsatdtemp(i-1,j,k))                        
     .                    xyz_tempcldy(i-1,j,k) = xyz_tempcldy(i-1,j,k) +       
     .       1               deltemp4                                           
     .                    xyz_qvapcldy(i-1,j,k) = xyz_qvapsat(i-1,j,k) +        
     .       1               xyz_dqvapsatdtemp(i-1,j,k)*deltemp4                
     .                 endif                                                    
     .                 if (xyz_flagsaturated(i-1,j+1,k) .ne. 0) then            
     .                    deltemp3 = latentheat*(xyz_qvapcldy(i-1,j+1,k)-       
     .       1               xyz_qvapsat(i-1,j+1,k))/(cpdry + latentheat*       
     .       2               xyz_dqvapsatdtemp(i-1,j+1,k))                      
     .                    xyz_tempcldy(i-1,j+1,k) = xyz_tempcldy(i-1,j+1,k) +   
     .       1               deltemp3                                           
     .                    xyz_qvapcldy(i-1,j+1,k) = xyz_qvapsat(i-1,j+1,k) +    
     .       1               xyz_dqvapsatdtemp(i-1,j+1,k)*deltemp3              
     .                 endif                                                    
     .                 if (xyz_flagsaturated(i-1,j+2,k) .ne. 0) then            
     .                    deltemp2 = latentheat*(xyz_qvapcldy(i-1,j+2,k)-       
     .       1               xyz_qvapsat(i-1,j+2,k))/(cpdry + latentheat*       
     .       2               xyz_dqvapsatdtemp(i-1,j+2,k))                      
     .                    xyz_tempcldy(i-1,j+2,k) = xyz_tempcldy(i-1,j+2,k) +   
     .       1               deltemp2                                           
     .                    xyz_qvapcldy(i-1,j+2,k) = xyz_qvapsat(i-1,j+2,k) +    
     .       1               xyz_dqvapsatdtemp(i-1,j+2,k)*deltemp2              
     .                 endif                                                    
     .                 if (xyz_flagsaturated(i-1,j+3,k) .ne. 0) then            
     .                    deltemp1 = latentheat*(xyz_qvapcldy(i-1,j+3,k)-       
     .       1               xyz_qvapsat(i-1,j+3,k))/(cpdry + latentheat*       
     .       2               xyz_dqvapsatdtemp(i-1,j+3,k))                      
     .                    xyz_tempcldy(i-1,j+3,k) = xyz_tempcldy(i-1,j+3,k) +   
     .       1               deltemp1                                           
     .                    xyz_qvapcldy(i-1,j+3,k) = xyz_qvapsat(i-1,j+3,k) +    
     .       1               xyz_dqvapsatdtemp(i-1,j+3,k)*deltemp1              
     .                 endif                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   730        end do
   731  
   732      end do
   733  
   734      ! Calculation of temperature and specific humidity averaged over a grid
   735      !
   736      xyz_Temp = xyz_CldFrac * xyz_TempCldy + ( 1.0_DP - xyz_CldFrac ) * xyz_TempCler
     .        d7 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d8 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t820 = 1, xyz_cldfrac.DSC.U3*(xyz_cldfrac.DSC.U2*              
     .       1   xyz_cldfrac.DSC.U1 + xyz_cldfrac.DSC.U2)                       
     .           xyz_temp(t820-1,1,1) = xyz_cldfrac(t820-1,1,1)*xyz_tempcldy(   
     .       1      t820-1,1,1) + (1.00000000000000e+000 - xyz_cldfrac(t820-1,1,
     .       2      1))*xyz_tempcler(t820-1,1,1)                                
     .           xyz_qvap(t820-1,1,1) = xyz_cldfrac(t820-1,1,1)*xyz_qvapcldy(   
     .       1      t820-1,1,1) + (1.00000000000000e+000 - xyz_cldfrac(t820-1,1,
     .       2      1))*xyz_qvapcler(t820-1,1,1)                                
     .           xyz_dqvapdtlsc(t820-1,1,1) = (xyz_qvap(t820-1,1,1)-xyz_qvapb(  
     .       1      t820-1,1,1))*d7                                             
     .           xyz_dtempdtlsc(t820-1,1,1) = (xyz_temp(t820-1,1,1)-xyz_tempb(  
     .       1      t820-1,1,1))*d8                                             
     .           xyz_dtempdt(t820-1,1,1) = xyz_dtempdt(t820-1,1,1) +            
     .       1      xyz_dtempdtlsc(t820-1,1,1)                                  
     .           xyz_dqvapdt(t820-1,1,1) = xyz_dqvapdt(t820-1,1,1) +            
     .       1      xyz_dqvapdtlsc(t820-1,1,1)                                  
     .           xyz_dqh2oliqdt(t820-1,1,1) = -xyz_dqvapdtlsc(t820-1,1,1)       
     .        enddo                                                             
   737      xyz_QVap = xyz_CldFrac * xyz_QVapCldy + ( 1.0_DP - xyz_CldFrac ) * xyz_QVapCler
   738  
   739  
   740      ! 比湿変化率, 温度変化率, 降水量の算出
   741      ! Calculate specific humidity tendency, temperature tendency,
   742      ! precipitation
   743      !
   744      xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
   745      xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   746  
   747      xyz_DTempDt = xyz_DTempDt + xyz_DTempDtLsc
   748      xyz_DQVapDt = xyz_DQVapDt + xyz_DQVapDtLsc
   749  
   750  
   751  !!$    xy_RainLsc     = 0.0d0
   752  !!$    do k = kmax, 1, -1
   753  !!$      xy_RainLsc = xy_RainLsc                                     &
   754  !!$        & + ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav      &
   755  !!$        & * ( xyz_QVapB(:,:,k  ) - xyz_QVap (:,:,k) )
   756  !!$    end do
   757  !!$    xy_RainLsc = xy_RainLsc / ( 2.0_DP * DelTime )
   758  
   759  
   760  !!$    i = 0
   761  !!$    j = jmax/2+1
   762  !!$    write( 6, * ) xy_RainLsc(i,j)
   763  
   764  
   765  !!$    xyz_DQH2OLiqDt = - xyz_DQVapDtLsc
   766  !!$    xy_RainLsc     = 0.0d0
   767  !!$    do k = kmax, 1, -1
   768  !!$      xy_RainLsc = xy_RainLsc                                     &
   769  !!$        & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   770  !!$    end do
   771  
   772  !!$    i = 0
   773  !!$    j = jmax/2+1
   774  !!$    write( 6, * ) xy_RainLsc(i,j)
   775  !!$    write( 6, * ) '---'
   776  
   777  !!$    xy_Rain     = xy_Rain     + xy_RainLsc
   778  
   779  
   780      xyz_DQH2OLiqDt = - xyz_DQVapDtLsc
   781  
   782  
   783      ! calculation for output
   784      xy_RainLsc     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t898 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t898-1,1) = 0.0000000000000000e+000                 
     .        enddo                                                             
   785      do k = kmax, 1, -1
   786        xy_RainLsc = xy_RainLsc                                     &
     .        d9 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_rainlsc,xyr_press)                                      
     .        do t904 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t904-1,1) = xy_rainlsc(t904-1,1) + xyz_dqh2oliqdt(  
     .       1      t904-1,1,k)*(xyr_press(t904-1,1,k-1)-xyr_press(t904-1,1,k))*
     .       2      d9                                                          
     .        enddo                                                             
   787          & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   788      end do
   789  
   790      ! ヒストリデータ出力
   791      ! History data output
   792      !
   793      call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc * LatentHeat )
     .        if (xy_rainlsc.DSC.U2 .gt. 0) then                                
     .           j3 = and(xy_rainlsc.DSC.U2,3)                                  
     .  !cdir    nodep                                                          
     .           do t918 = 1, j3                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_rainlsc)                                          
     .              do t920 = 1, xy_rainlsc.DSC.U1 + 1                          
     .                 %IG5(t920,t918) = xy_rainlsc(t920-1,t918)*latentheat     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t918 = j3 + 1, xy_rainlsc.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_rainlsc)                                          
     .              do t920 = 1, xy_rainlsc.DSC.U1 + 1                          
     .                 %IG5(t920,t918) = xy_rainlsc(t920-1,t918)*latentheat     
     .                 %IG5(t920,t918+1) = xy_rainlsc(t920-1,t918+1)*latentheat 
     .                 %IG5(t920,t918+2) = xy_rainlsc(t920-1,t918+2)*latentheat 
     .                 %IG5(t920,t918+3) = xy_rainlsc(t920-1,t918+3)*latentheat 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   794      call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   795      call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
   796  
   797  
   798  
   799      ! 計算時間計測一時停止
   800      ! Pause measurement of computation time
   801      !
   802      call TimesetClockStop( module_name )
   803  
   804    end subroutine LScaleCondLL91
   805  
   806    !--------------------------------------------------------------------------------------
   807  
   808    subroutine LScaleCondLL91Init
   809      !
   810      ! lscond モジュールの初期化を行います.
   811      ! NAMELIST#lscond_nml の読み込みはこの手続きで行われます.
   812      !
   813      ! "lscond" module is initialized.
   814      ! "NAMELIST#lscond_nml" is loaded in this procedure.
   815      !
   816  
   817      ! モジュール引用 ; USE statements
   818      !
   819  
   820      ! NAMELIST ファイル入力に関するユーティリティ
   821      ! Utilities for NAMELIST file input
   822      !
   823      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   824  
   825      ! ファイル入出力補助
   826      ! File I/O support
   827      !
   828      use dc_iounit, only: FileOpen
   829  
   830      ! 種別型パラメタ
   831      ! Kind type parameter
   832      !
   833      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   834  
   835      ! 文字列操作
   836      ! Character handling
   837      !
   838      use dc_string, only: StoA
   839  
   840      ! ヒストリデータ出力
   841      ! History data output
   842      !
   843      use gtool_historyauto, only: HistoryAutoAddVariable
   844  
   845      ! 宣言文 ; Declaration statements
   846      !
   847      implicit none
   848  
   849      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   850                                ! Unit number for NAMELIST file open
   851      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   852                                ! IOSTAT of NAMELIST read
   853  
   854      ! NAMELIST 変数群
   855      ! NAMELIST group name
   856      !
   857      namelist /lscond_nml/ &
   858  !!$      & CrtlRH, ItrtMax, FlagUse
   859        & Gamma, ItrtMax
   860            !
   861            ! デフォルト値については初期化手続 "lscond#LSCondInit"
   862            ! のソースコードを参照のこと.
   863            !
   864            ! Refer to source codes in the initialization procedure
   865            ! "lscond#LSCondInit" for the default values.
   866            !
   867  
   868      ! 実行文 ; Executable statement
   869      !
   870  
   871      if ( lscond_LL91_inited ) return
   872  
   873  
   874      ! デフォルト値の設定
   875      ! Default values settings
   876      !
   877  !!$    CrtlRH  = 1.0_DP
   878      Gamma   = 0.2_DP
   879      !  This value is from Le Treut and Li (1991).
   880      ItrtMax = 3
   881  !!$    FlagUse = .true.
   882  
   883      ! NAMELIST の読み込み
   884      ! NAMELIST is input
   885      !
   886      if ( trim(namelist_filename) /= '' ) then
   887        call FileOpen( unit_nml, &          ! (out)
   888          & namelist_filename, mode = 'r' ) ! (in)
   889  
   890        rewind( unit_nml )
   891        read( unit_nml, &         ! (in)
   892          & nml = lscond_nml, &   ! (out)
   893          & iostat = iostat_nml ) ! (out)
   894        close( unit_nml )
   895  
   896        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   897        if ( iostat_nml == 0 ) write( STDOUT, nml = lscond_nml )
   898      end if
   899  
   900      ! ヒストリデータ出力のためのへの変数登録
   901      ! Register of variables for history data output
   902      !
   903      call HistoryAutoAddVariable( 'RainLsc', &
   904        & (/ 'lon ', 'lat ', 'time' /), &
   905        & 'precipitation by large scale condensation', 'W m-2' )
   906      call HistoryAutoAddVariable( 'DTempDtLsc', &
   907        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   908        & 'large-scale condensation heating', 'K s-1' )
   909      call HistoryAutoAddVariable( 'DQVapDtLsc', &
   910        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   911        & 'large-scale condensation moistening', 'kg kg-1 s-1' )
   912  
   913      ! 印字 ; Print
   914      !
   915      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   916  !!$    call MessageNotify( 'M', module_name, '  FlagUse = %b', l = (/ FlagUse /) )
   917  !!$    call MessageNotify( 'M', module_name, '  CrtlRH  = %f', d = (/ CrtlRH /) )
   918      call MessageNotify( 'M', module_name, '  Gamma   = %f', d = (/ Gamma /) )
   919      call MessageNotify( 'M', module_name, '  ItrtMax = %d', i = (/ ItrtMax /) )
   920      call MessageNotify( 'M', module_name, '' )
   921      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   922  
   923      lscond_LL91_inited = .true.
   924  
   925    end subroutine LScaleCondLL91Init
   926  
   927    !--------------------------------------------------------------------------------------
   928  
   929  end module lscond_LL91
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:41 2016
FILE NAME: lscond_LL91.f90
PROGRAM NAME: lscond_ll91
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 大規模凝結 (非対流性凝結) (Le Treut and Li, 1991)
     2:             !
     3:             != Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: lscond_LL91.f90,v 1.4 2015/01/29 12:02:56 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module lscond_LL91
    13:               !
    14:               != 大規模凝結 (非対流性凝結)
    15:               !
    16:               != Large scale condensation (non-convective condensation)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 大規模凝結過程によって温度と比湿を調節します. 
    21:               !
    22:               ! Adjust temperature and specific humidity by 
    23:               ! a large scale condensation process.
    24:               !
    25:               !== References
    26:               !
    27:               !  Le Treut, H., and Z.-X. Li,
    28:               !    Sensitivity of an atmospheric general circulation model to prescribed SST changes:
    29:               !    feedback effects associated with the simulation of cloud optical properties, 
    30:               !    Clim. Dyn., 5, 175-187, 1991.
    31:               !
    32:               !  Manabe, S., J. Smagorinsky, R. F. Strickler, 
    33:               !    Simulated climatology of a general circulation model with a hydrologic cycle,
    34:               !    Mon. Wea. Rev., 93, 769-798, 1965.
    35:               !
    36:               !== Procedures List
    37:               ! 
    38:               ! LScaleCondLL91     :: 温度と比湿の調節
    39:               ! LScaleCondLL91Init :: 初期化
    40:               ! -----------------  :: ------------
    41:               ! LScaleCondLL91     :: Adjust temperature and specific humidity
    42:               ! LScaleCondLL91Init :: Initialization
    43:               !
    44:               !== NAMELIST
    45:               !
    46:               ! NAMELIST#lscond_nml
    47:               !
    48:             
    49:               ! モジュール引用 ; USE statements
    50:               !
    51:             
    52:               ! 格子点設定
    53:               ! Grid points settings
    54:               !
    55:               use gridset, only: imax, & ! 経度格子点数. 
    56:                                          ! Number of grid points in longitude
    57:                 &                jmax, & ! 緯度格子点数. 
    58:                                          ! Number of grid points in latitude
    59:                 &                kmax    ! 鉛直層数. 
    60:                                          ! Number of vertical level
    61:             
    62:               ! 種別型パラメタ
    63:               ! Kind type parameter
    64:               !
    65:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    66:                 &                 STRING     ! 文字列.       Strings. 
    67:             
    68:               ! メッセージ出力
    69:               ! Message output
    70:               !
    71:               use dc_message, only: MessageNotify
    72:             
    73:               ! 宣言文 ; Declaration statements
    74:               !
    75:               implicit none
    76:               private
    77:             
    78:               ! 公開手続き
    79:               ! Public procedure
    80:               !
    81:               public:: LScaleCondLL91Ice
    82:               public:: LScaleCondLL91
    83:               public:: LScaleCondLL91Init
    84:             
    85:               ! 公開変数
    86:               ! Public variables
    87:               !
    88:             
    89:               ! 非公開変数
    90:               ! Private variables
    91:               !
    92:               logical, save :: lscond_LL91_inited = .false.
    93:                                           ! 初期設定フラグ. 
    94:                                           ! Initialization flag
    95:             
    96:               real(DP), save :: Gamma
    97:                                           !
    98:                                           ! Subgrid scale variation of specific humidity 
    99:                                           ! expressed as fraction of specific humidity
   100:             !!$  real(DP), save:: CrtlRH
   101:             !!$                              ! 臨界相対湿度. 
   102:             !!$                              ! Critical relative humidity
   103:               integer, save :: ItrtMax
   104:                                           ! イテレーション回数. 
   105:                                           ! Number of iteration
   106:             !!$  logical, save :: FlagUse
   107:             !!$                              ! 使用フラグ
   108:             !!$                              ! flag for use of this scheme
   109:             
   110:               character(*), parameter:: module_name = 'lscond_LL91'
   111:                                           ! モジュールの名称. 
   112:                                           ! Module name
   113:               character(*), parameter:: version = &
   114:                 & '$Name:  $' // &
   115:                 & '$Id: lscond_LL91.f90,v 1.4 2015/01/29 12:02:56 yot Exp $'
   116:                                           ! モジュールのバージョン
   117:                                           ! Module version
   118:             
   119:             contains
   120:             
   121:               !--------------------------------------------------------------------------------------
   122:             
   123:               subroutine LScaleCondLL91Ice(                            &
   124:                 & xyz_Press, xyr_Press,                                &  ! (in)
   125:                 & xyz_Temp, xyz_QVap, xyz_QLiq, xyz_QSol,              &  ! (inout)
   126:                 & xyz_DTempDt, xyz_DQVapDt, xyz_DQLiqDt, xyz_DQSolDt   &  ! (out)
   127:                 & )
   128:                 !
   129:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
   130:                 !
   131:                 ! Adjust temperature and specific humidity by 
   132:                 ! large scale condensation scheme. 
   133:                 !
   134:             
   135:                 ! モジュール引用 ; USE statements
   136:                 !
   137:             
   138:                 ! 物理定数設定
   139:                 ! Physical constants settings
   140:                 !
   141:                 use constants, only: &
   142:                   & Grav, & 
   143:                                           ! $ g $ [m s-2]. 
   144:                                           ! 重力加速度. 
   145:                                           ! Gravitational acceleration
   146:                   & CpDry, &
   147:                                           ! $ C_p $ [J kg-1 K-1]. 
   148:                                           ! 乾燥大気の定圧比熱. 
   149:                                           ! Specific heat of air at constant pressure
   150:                   & LatentHeat, &
   151:                                           ! $ L $ [J kg-1] . 
   152:                                           ! 凝結の潜熱. 
   153:                                           ! Latent heat of condensation
   154:                   & LatentHeatFusion
   155:             
   156:             
   157:                 ! 時刻管理
   158:                 ! Time control
   159:                 !
   160:                 use timeset, only: &
   161:                   & DelTime, &            ! $ \Delta t $
   162:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   163:                   & TimesetClockStart, TimesetClockStop
   164:             
   165:                 ! ヒストリデータ出力
   166:                 ! History data output
   167:                 !
   168:                 use gtool_historyauto, only: HistoryAutoPut
   169:             
   170:                 ! 飽和比湿の算出
   171:                 ! Evaluate saturation specific humidity
   172:                 !
   173:                 use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp, SaturateWatFraction
   174:             
   175:                 ! 宣言文 ; Declaration statements
   176:                 !
   177:                 implicit none
   178:             
   179:                 real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   180:                                           ! $ p $ . 気圧 (整数レベル). 
   181:                                           ! Air pressure (full level)
   182:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   183:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   184:                                           ! Air pressure (half level)
   185:                 real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   186:                                           ! $ T $ .     温度. Temperature
   187:                 real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   188:                                           ! $ q $ .     比湿. Specific humidity
   189:                 real(DP), intent(inout):: xyz_QLiq (0:imax-1, 1:jmax, 1:kmax)
   190:                                           ! $ q_l $ .     Specific liquid water content
   191:                 real(DP), intent(inout):: xyz_QSol (0:imax-1, 1:jmax, 1:kmax)
   192:                                           ! $ q_i $ .     Specific ice water content
   193:                 real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   194:                                           ! 温度変化率. 
   195:                                           ! Temperature tendency
   196:                 real(DP), intent(out):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
   197:                                           ! 比湿変化率. 
   198:                                           ! Specific humidity tendency
   199:                 real(DP), intent(out) :: xyz_DQLiqDt(0:imax-1,1:jmax,1:kmax)
   200:                 real(DP), intent(out) :: xyz_DQSolDt(0:imax-1,1:jmax,1:kmax)
   201:             
   202:             
   203:                 ! 作業変数
   204:                 ! Work variables
   205:                 !
   206:                 real(DP) :: xyz_CldFrac   (0:imax-1, 1:jmax, 1:kmax)
   207:                                           !
   208:                                           ! Cloud fraction
   209:             
   210:                 real(DP) :: QCld
   211:                 real(DP) :: WatFrac
   212:                 real(DP) :: IceFrac
   213:             
   214:                 real(DP) :: xy_RainLsc (0:imax-1, 1:jmax)
   215:                                           ! 降水量. 
   216:                                           ! Precipitation
   217:                 real(DP) :: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   218:                                           ! 温度変化率. 
   219:                                           ! Temperature tendency
   220:                 real(DP) :: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   221:                                           ! 比湿変化率. 
   222:                                           ! Specific humidity tendency
   223:                 real(DP) :: xyz_DQLiqDtLsc (0:imax-1, 1:jmax, 1:kmax)
   224:                 real(DP) :: xyz_DQSolDtLsc (0:imax-1, 1:jmax, 1:kmax)
   225:             
   226:                 real(DP) :: xyz_TempTentative(0:imax-1, 1:jmax, 1:kmax)
   227:             
   228:             
   229:                 real(DP) :: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   230:                                           ! 調節前の温度. 
   231:                                           ! Temperature before adjust. 
   232:                 real(DP) :: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   233:                                           ! 調節前の比湿. 
   234:                                           ! Specific humidity before adjust. 
   235:                 real(DP) :: xyz_QLiqB (0:imax-1, 1:jmax, 1:kmax)
   236:                 real(DP) :: xyz_QSolB (0:imax-1, 1:jmax, 1:kmax)
   237:                                           !
   238:             
   239:                 real(DP) :: xyz_QTot         (0:imax-1, 1:jmax, 1:kmax)
   240:                 real(DP) :: xyz_DelQ         (0:imax-1, 1:jmax, 1:kmax)
   241:             
   242:             
   243:                 real(DP) :: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
   244:                                           ! 飽和比湿. 
   245:                                           ! Saturation specific humidity. 
   246:                 real(DP) :: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:kmax)
   247:                                           ! $ \DD{q_{\rm{sat}}}{T} $
   248:                 real(DP) :: DelTemp
   249:                                           ! 調節による温度変化量. 
   250:                                           ! Temperature variation by adjustment
   251:             
   252:                 integer :: i              ! 経度方向に回る DO ループ用作業変数
   253:                                           ! Work variables for DO loop in longitude
   254:                 integer :: j              ! 緯度方向に回る DO ループ用作業変数
   255:                                           ! Work variables for DO loop in latitude
   256:                 integer :: k              ! 鉛直方向に回る DO ループ用作業変数
   257:                                           ! Work variables for DO loop in vertical direction
   258:                 integer :: itr            ! イテレーション方向に回る DO ループ用作業変数
   259:                                           ! Work variables for DO loop in iteration direction
   260:             
   261:                 real(DP) :: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)
   262:             
   263:                 logical  :: xyz_FlagSaturated(0:imax-1, 1:jmax, 1:kmax)
   264:             
   265:                 ! Variables for debug
   266:             !!$    real(DP) :: TempBefAdj
   267:             !!$    real(DP) :: QVapBefAdj
   268:             
   269:             
   270:                 ! 実行文 ; Executable statement
   271:                 !
   272:             
   273:                 ! 初期化確認
   274:                 ! Initialization check
   275:                 !
   276:                 if ( .not. lscond_LL91_inited ) then
   277:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   278:                 end if
   279:             
   280:             !!$    if ( .not. FlagUse ) return
   281:             
   282:             
   283:                 ! 計算時間計測開始
   284:                 ! Start measurement of computation time
   285:                 !
   286:                 call TimesetClockStart( module_name )
   287:             
   288:             
   289:             
   290:                 ! 調節前 "QVap", "Temp" の保存
   291:                 ! Store "QVap", "Temp" before adjustment
   292:                 !
   293: **W---->A       xyz_TempB  = xyz_Temp
   294: |||     A       xyz_QVapB  = xyz_QVap
   295: |||     A       xyz_QLiqB  = xyz_QLiq
   296: |||     A       xyz_QSolB  = xyz_QSol
   297: |||         
   298: |||             xyz_QTot = xyz_QVap + xyz_QLiq + xyz_QSol
   299: |||             xyz_DelQ = Gamma * xyz_QTot
   300: |||         
   301: |||         
   302: |||             ! All cloud water and ice are evaporated temporarily
   303: |||             ! After this temporal evaporation, adjustment will be done below. 
   304: |||             !
   305: **W---- A       xyz_TempTentative = xyz_Temp                       &
   306:                   & -   LatentHeat                      * xyz_QLiq &
   307:                   & - ( LatentHeat + LatentHeatFusion ) * xyz_QSol
   308:             
   309:             
   310:                 ! 調節
   311:                 ! Adjustment
   312:                 !
   313:             
   314:                 ! 飽和比湿計算
   315:                 ! Calculate saturation specific humidity 
   316:                 !
   317:                 xyz_QVapSat = xyz_CalcQVapSat( xyz_TempTentative, xyz_Press )
   318:             
   319: +------>        do k = 1, kmax
   320: |+----->          do j = 1, jmax
   321: ||V---->            do i = 0, imax-1
   322: |||         
   323: |||         !!$          if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) ) >= CrtlRH ) then
   324: |||     A             if ( ( ( xyz_QTot(i,j,k) + xyz_DelQ(i,j,k) ) / xyz_QVapSat(i,j,k) ) >= 1.0_DP ) then
   325: |||                     xyz_FlagSaturated(i,j,k) = .true.
   326: |||                   else
   327: |||                     xyz_FlagSaturated(i,j,k) = .false.
   328: |||                   end if
   329: |||         
   330: ||V---- A           end do
   331: |+-----           end do
   332: +------         end do
   333:             
   334:             
   335: +------>        do itr = 1, ItrtMax
   336: |           
   337: |           
   338: |                 ! 飽和比湿計算
   339: |                 ! Calculate saturation specific humidity
   340: |                 !
   341: |                 xyz_QVapSat       = xyz_CalcQVapSat      ( xyz_Temp, xyz_Press   )
   342: |                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   343: |           
   344: |+----->          do k = 1, kmax
   345: ||+---->            do j = 1, jmax
   346: |||+--->              do i = 0, imax-1
   347: ||||        
   348: ||||                    ! 飽和していたら, 温度と比湿の変化を計算
   349: ||||                    ! Calculate tendency of temperature and humidity 
   350: ||||                    ! if moist is saturation. 
   351: ||||                    !
   352: ||||                    if ( xyz_FlagSaturated(i,j,k) ) then
   353: ||||        
   354: ||||        
   355: ||||                      ! Liquid water and ice fractions
   356: ||||                      call SaturateWatFraction(   &
   357: ||||                        & xyz_Temp(i,j,k),        & ! (in )
   358: ||||                        & WatFrac                 & ! (out)
   359: ||||                        & )
   360: ||||                      IceFrac = 1.0_DP - WatFrac
   361: ||||        
   362: ||||                      ! 温度の変化分をニュートン法で求める
   363: ||||                      ! Calculate variation of temperature
   364: ||||                      !
   365: ||||                      DelTemp = &
   366: ||||                        & ( &
   367: ||||                        &     LatentHeat            &
   368: ||||                        &     * (   xyz_QVap(i,j,k) &
   369: ||||                        &         - ( xyz_QVapSat(i,j,k) + xyz_QTot(i,j,k) - xyz_DelQ(i,j,k) ) / 2.0_DP ) &
   370: ||||                        &   - LatentHeatFusion                      &
   371: ||||                        &     * (   xyz_QSol(i,j,k)                 &
   372: ||||                        &         - IceFrac * ( xyz_QVapSat(i,j,k) + xyz_QTot(i,j,k) + xyz_DelQ(i,j,k) ) / 2.0_DP ) &
   373: ||||                        & ) &
   374: ||||                        &    / (   CpDry &
   375: ||||                        &        + ( LatentHeat - LatentHeatFusion * IceFrac ) &
   376: ||||                        &          * xyz_DQVapSatDTemp(i,j,k) / 2.0_DP )
   377: ||||        
   378: ||||        
   379: ||||                      ! 温度と比湿の調節
   380: ||||                      ! Adjust temperature and specific humidity
   381: ||||                      !
   382: ||||                      xyz_QVapSat(i,j,k) = &
   383: ||||                        & xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp
   384: ||||                      xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
   385: ||||                      QCld = ( xyz_QVapSat(i,j,k) + xyz_QTot(i,j,k) + xyz_DelQ(i,j,k) ) / 2.0_DP
   386: ||||                      xyz_QVap(i,j,k) = ( xyz_QVapSat(i,j,k) + xyz_QTot(i,j,k) - xyz_DelQ(i,j,k) ) / 2.0_DP
   387: ||||                      xyz_QLiq(i,j,k) = WatFrac * QCld
   388: ||||                      xyz_QSol(i,j,k) = IceFrac * QCld
   389: ||||        
   390: ||||                    end if
   391: ||||        
   392: |||+---               end do
   393: ||+----             end do
   394: |+-----           end do
   395: |           
   396: |**V--->A         xyz_CldFrac = ( xyz_QTot + xyz_DelQ - xyz_QVapSat )
   397: |**V---           xyz_CldFrac = max( min( xyz_CldFrac, 1.0_DP ), 0.0_DP )
   398: |           
   399: |           
   400: +------         end do
   401:             
   402:             
   403:                 ! 比湿変化率, 温度変化率, 降水量の算出
   404:                 ! Calculate specific humidity tendency, temperature tendency, 
   405:                 ! precipitation
   406:                 !
   407: **V---->A       xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   408: |||     A       xyz_DQVapDt = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
   409: |||     A       xyz_DQLiqDt = ( xyz_QLiq - xyz_QLiqB ) / ( 2.0_DP * DelTime )
   410: **V---- A       xyz_DQSolDt = ( xyz_QSol - xyz_QSolB ) / ( 2.0_DP * DelTime )
   411:             
   412:             
   413:                 ! calculation for output
   414: W*=====         xy_RainLsc     = 0.0_DP
   415: +------>        do k = kmax, 1, -1
   416: |W*==== A         xy_RainLsc = xy_RainLsc                                     &
   417: |                   & + ( xyz_DQLiqDt(:,:,k) + xyz_DQSolDt(:,:,k) )           &
   418: |                   &   * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   419: +------         end do
   420:             
   421:                 ! ヒストリデータ出力
   422:                 ! History data output
   423:                 !
   424: +V===== A       call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc * LatentHeat )
   425:                 call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   426:                 call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
   427:             
   428:             
   429:             
   430:                 ! 計算時間計測一時停止
   431:                 ! Pause measurement of computation time
   432:                 !
   433:                 call TimesetClockStop( module_name )
   434:             
   435:               end subroutine LScaleCondLL91Ice
   436:             
   437:               !--------------------------------------------------------------------------------------
   438:             
   439:               subroutine LScaleCondLL91(       &
   440:                 & xyz_Temp, xyz_QVap,          &  ! (inout)
   441:                 & xyz_DTempDt, xyz_DQVapDt,    &  ! (inout)
   442:                 & xyz_Press, xyr_Press,        &  ! (in)
   443:                 & xyz_DQH2OLiqDt               &  ! (out)
   444:                 & )
   445:                 !
   446:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
   447:                 !
   448:                 ! Adjust temperature and specific humidity by 
   449:                 ! large scale condensation scheme. 
   450:                 !
   451:             
   452:                 ! モジュール引用 ; USE statements
   453:                 !
   454:             
   455:                 ! 物理定数設定
   456:                 ! Physical constants settings
   457:                 !
   458:                 use constants, only: &
   459:                   & Grav, & 
   460:                                           ! $ g $ [m s-2]. 
   461:                                           ! 重力加速度. 
   462:                                           ! Gravitational acceleration
   463:                   & CpDry, &
   464:                                           ! $ C_p $ [J kg-1 K-1]. 
   465:                                           ! 乾燥大気の定圧比熱. 
   466:                                           ! Specific heat of air at constant pressure
   467:                   & LatentHeat
   468:                                           ! $ L $ [J kg-1] . 
   469:                                           ! 凝結の潜熱. 
   470:                                           ! Latent heat of condensation
   471:             
   472:                 ! 時刻管理
   473:                 ! Time control
   474:                 !
   475:                 use timeset, only: &
   476:                   & DelTime, &            ! $ \Delta t $
   477:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   478:                   & TimesetClockStart, TimesetClockStop
   479:             
   480:                 ! ヒストリデータ出力
   481:                 ! History data output
   482:                 !
   483:                 use gtool_historyauto, only: HistoryAutoPut
   484:             
   485:                 ! 飽和比湿の算出
   486:                 ! Evaluate saturation specific humidity
   487:                 !
   488:                 use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp
   489:             
   490:             
   491:                 ! 宣言文 ; Declaration statements
   492:                 !
   493:                 implicit none
   494:             
   495:                 real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   496:                                           ! $ T $ .     温度. Temperature
   497:                 real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   498:                                           ! $ q $ .     比湿. Specific humidity
   499:                 real(DP), intent(inout):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   500:                                           ! 温度変化率. 
   501:                                           ! Temperature tendency
   502:                 real(DP), intent(inout):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
   503:                                           ! 比湿変化率. 
   504:                                           ! Specific humidity tendency
   505:                 real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   506:                                           ! $ p $ . 気圧 (整数レベル). 
   507:                                           ! Air pressure (full level)
   508:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   509:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   510:                                           ! Air pressure (half level)
   511:                 real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
   512:             
   513:             
   514:                 ! 作業変数
   515:                 ! Work variables
   516:                 !
   517:                 real(DP) :: xyz_CldFrac   (0:imax-1, 1:jmax, 1:kmax)
   518:                                           !
   519:                                           ! Cloud fraction
   520:                 real(DP) :: xyz_QVapHalRan(0:imax-1, 1:jmax, 1:kmax)
   521:                                           !
   522:                                           ! Half range of specific humidity
   523:                 real(DP) :: xyz_QVapCler  (0:imax-1, 1:jmax, 1:kmax)
   524:                                           !
   525:                                           ! Specific humidity in clear region
   526:                 real(DP) :: xyz_QVapCldy  (0:imax-1, 1:jmax, 1:kmax)
   527:                                           !
   528:                                           ! Specific humidity in cloudy region
   529:                 real(DP) :: xyz_TempCler  (0:imax-1, 1:jmax, 1:kmax)
   530:                                           !
   531:                                           ! Temperature in clear region
   532:                 real(DP) :: xyz_TempCldy  (0:imax-1, 1:jmax, 1:kmax)
   533:                                           !
   534:                                           ! Temperature in cloudy region
   535:             
   536:                 real(DP) :: xy_RainLsc (0:imax-1, 1:jmax)
   537:                                           ! 降水量. 
   538:                                           ! Precipitation
   539:                 real(DP) :: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   540:                                           ! 温度変化率. 
   541:                                           ! Temperature tendency
   542:                 real(DP) :: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   543:                                           ! 比湿変化率. 
   544:                                           ! Specific humidity tendency
   545:             
   546:                 real(DP) :: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   547:                                           ! 調節前の比湿. 
   548:                                           ! Specific humidity before adjust. 
   549:                 real(DP) :: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   550:                                           ! 調節前の温度. 
   551:                                           ! Temperature before adjust. 
   552:                                           !
   553:                 real(DP) :: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
   554:                                           ! 飽和比湿. 
   555:                                           ! Saturation specific humidity. 
   556:                 real(DP) :: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:kmax)
   557:                                           ! $ \DD{q_{\rm{sat}}}{T} $
   558:                 real(DP) :: DelTemp
   559:                                           ! 調節による温度変化量. 
   560:                                           ! Temperature variation by adjustment
   561:             
   562:                 integer :: i              ! 経度方向に回る DO ループ用作業変数
   563:                                           ! Work variables for DO loop in longitude
   564:                 integer :: j              ! 緯度方向に回る DO ループ用作業変数
   565:                                           ! Work variables for DO loop in latitude
   566:                 integer :: k              ! 鉛直方向に回る DO ループ用作業変数
   567:                                           ! Work variables for DO loop in vertical direction
   568:                 integer :: itr            ! イテレーション方向に回る DO ループ用作業変数
   569:                                           ! Work variables for DO loop in iteration direction
   570:             
   571:                 real(DP) :: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)
   572:             
   573:                 logical  :: xyz_FlagSaturated(0:imax-1, 1:jmax, 1:kmax)
   574:             
   575:                 ! Variables for debug
   576:             !!$    real(DP) :: TempBefAdj
   577:             !!$    real(DP) :: QVapBefAdj
   578:             
   579:             
   580:                 ! 実行文 ; Executable statement
   581:                 !
   582:             
   583:                 ! 初期化確認
   584:                 ! Initialization check
   585:                 !
   586:                 if ( .not. lscond_LL91_inited ) then
   587:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   588:                 end if
   589:             
   590:             !!$    if ( .not. FlagUse ) return
   591:             
   592:             
   593:                 ! 計算時間計測開始
   594:                 ! Start measurement of computation time
   595:                 !
   596:                 call TimesetClockStart( module_name )
   597:             
   598:             
   599:             
   600:                 ! 調節前 "QVap", "Temp" の保存
   601:                 ! Store "QVap", "Temp" before adjustment
   602:                 !
   603: **V---->A       xyz_QVapB  = xyz_QVap
   604: |||     A       xyz_TempB  = xyz_Temp
   605: |||         
   606: |||         
   607: |||             ! 調節
   608: |||             ! Adjustment
   609: |||             !
   610: |||         
   611: |||             ! 飽和比湿計算
   612: |||             ! Calculate saturation specific humidity 
   613: |||             !
   614: |||     A       xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   615: |||         
   616: |||         
   617: |||             ! Preparation for temperature in clear and cloudy regions
   618: |||             !
   619: |||     A       xyz_TempCler = xyz_Temp
   620: |||     A       xyz_TempCldy = xyz_Temp
   621: |||         
   622: |||             ! Calculation of cloud fraction, specific humidities in clear and cloudy regions
   623: |||             !
   624: |||     A       xyz_QVapHalRan = Gamma * xyz_QVap
   625: |||     A       xyz_CldFrac  = ( xyz_QVap + xyz_QVapHalRan - xyz_QVapSat ) &
   626: |||               & / ( 2.0_DP * xyz_QVapHalRan + 1.0e-100_DP )
   627: |||     A       xyz_QVapCler = ( xyz_QVapSat + xyz_QVap - xyz_QVapHalRan ) / 2.0_DP
   628: **V---- A       xyz_QVapCldy = ( xyz_QVapSat + xyz_QVap + xyz_QVapHalRan ) / 2.0_DP
   629: W------>        do k = 1, kmax
   630: |*----->          do j = 1, jmax
   631: ||*---->            do i = 0, imax-1
   632: |||                   if ( xyz_CldFrac(i,j,k) >= 1.0_DP ) then
   633: |||                     xyz_QVapCler(i,j,k) = 0.0_DP
   634: |||     A               xyz_QVapCldy(i,j,k) = xyz_QVap(i,j,k)
   635: |||                   else if ( xyz_CldFrac(i,j,k) <= 0.0_DP ) then
   636: |||     A               xyz_QVapCler(i,j,k) = xyz_QVap(i,j,k)
   637: |||                     xyz_QVapCldy(i,j,k) = 0.0_DP
   638: |||                   end if
   639: |||                 end do
   640: |||               end do
   641: |||             end do
   642: |||             do k = 1, kmax
   643: |||               do j = 1, jmax
   644: |||                 do i = 0, imax-1
   645: |||                   if ( xyz_CldFrac(i,j,k) > 1.0_DP ) then
   646: |||                     xyz_CldFrac(i,j,k) = 1.0_DP
   647: |||                   else if ( xyz_CldFrac(i,j,k) < 0.0_DP ) then
   648: |||                     xyz_CldFrac(i,j,k) = 0.0_DP
   649: |||                   end if
   650: |||                 end do
   651: |||               end do
   652: |||             end do
   653: |||         
   654: |||         
   655: |||             do k = 1, kmax
   656: |||               do j = 1, jmax
   657: |||                 do i = 0, imax-1
   658: |||         
   659: |||         !!$          if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) ) >= CrtlRH ) then
   660: |||                   if ( xyz_CldFrac(i,j,k) > 0.0_DP ) then
   661: |||                     xyz_FlagSaturated(i,j,k) = .true.
   662: |||                   else
   663: |||                     xyz_FlagSaturated(i,j,k) = .false.
   664: |||                   end if
   665: |||         
   666: ||*----             end do
   667: |*-----           end do
   668: W------         end do
   669:             
   670:             
   671: +------>        do itr = 1, ItrtMax
   672: |           
   673: |                 ! 飽和比湿計算
   674: |                 ! Calculate saturation specific humidity
   675: |                 !
   676: |                 xyz_QVapSat       = xyz_CalcQVapSat      ( xyz_TempCldy, xyz_Press   )
   677: |                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_TempCldy, xyz_QVapSat )
   678: |           
   679: |+----->          do k = 1, kmax
   680: ||+---->            do j = 1, jmax
   681: |||V--->              do i = 0, imax-1
   682: ||||        
   683: ||||                    ! 飽和していたら, 温度と比湿の変化を計算
   684: ||||                    ! Calculate tendency of temperature and humidity 
   685: ||||                    ! if moist is saturation. 
   686: ||||                    !
   687: ||||                    if ( xyz_FlagSaturated(i,j,k) ) then
   688: ||||        
   689: ||||                      ! 温度の変化分をニュートン法で求める
   690: ||||                      ! Calculate variation of temperature
   691: ||||                      !
   692: ||||    A                 DelTemp = &
   693: ||||                        & LatentHeat * ( xyz_QVapCldy(i,j,k) - xyz_QVapSat(i,j,k) ) &
   694: ||||                        &    / ( CpDry + LatentHeat * xyz_DQVapSatDTemp(i,j,k) )
   695: ||||        
   696: ||||        
   697: ||||                      !=========
   698: ||||                      ! check routine
   699: ||||                      !---------
   700: ||||        !!$              TempBefAdj = xyz_TempCldy(i,j,k)
   701: ||||        !!$              QVapBefAdj = xyz_QVapCldy(i,j,k)
   702: ||||                      !=========
   703: ||||        
   704: ||||                      ! 温度と比湿の調節
   705: ||||                      ! Adjust temperature and specific humidity
   706: ||||                      !
   707: ||||    A                 xyz_TempCldy(i,j,k) = xyz_TempCldy(i,j,k) &
   708: ||||                        & + DelTemp
   709: ||||                      xyz_QVapCldy(i,j,k) = xyz_QVapSat(i,j,k)  &
   710: ||||                        & + xyz_DQVapSatDTemp(i,j,k) * DelTemp
   711: ||||        
   712: ||||                      !=========
   713: ||||                      ! check routine
   714: ||||                      !---------
   715: ||||        !!$              write( 6, * ) '====='
   716: ||||        !!$              write( 6, * ) 'Energy difference before and after adjustment and each energy', xyz_CldFrac(i,j,k)
   717: ||||        !!$              write( 6, * ) &
   718: ||||        !!$                & (     CpDry*TempBefAdj          + LatentHeat*QVapBefAdj              &
   719: ||||        !!$                &   - ( CpDry*xyz_TempCldy(i,j,k) + LatentHeat*xyz_QVapCldy(i,j,k) ) ) &
   720: ||||        !!$                & /(    CpDry*TempBefAdj          + LatentHeat*QVapBefAdj ),           &
   721: ||||        !!$                &     CpDry*TempBefAdj          + LatentHeat*QVapBefAdj,               &
   722: ||||        !!$                &   ( CpDry*xyz_TempCldy(i,j,k) + LatentHeat*xyz_QVapCldy(i,j,k) )
   723: ||||                      !=========
   724: ||||        
   725: ||||        
   726: ||||                    end if
   727: ||||        
   728: |||V--- A             end do
   729: ||+----             end do
   730: |+-----           end do
   731: |           
   732: +------         end do
   733:             
   734:                 ! Calculation of temperature and specific humidity averaged over a grid
   735:                 !
   736: **W---->A       xyz_Temp = xyz_CldFrac * xyz_TempCldy + ( 1.0_DP - xyz_CldFrac ) * xyz_TempCler
   737: |||     A       xyz_QVap = xyz_CldFrac * xyz_QVapCldy + ( 1.0_DP - xyz_CldFrac ) * xyz_QVapCler
   738: |||         
   739: |||         
   740: |||             ! 比湿変化率, 温度変化率, 降水量の算出
   741: |||             ! Calculate specific humidity tendency, temperature tendency, 
   742: |||             ! precipitation
   743: |||             !
   744: |||     A       xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
   745: |||     A       xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   746: |||         
   747: |||     A       xyz_DTempDt = xyz_DTempDt + xyz_DTempDtLsc
   748: |||     A       xyz_DQVapDt = xyz_DQVapDt + xyz_DQVapDtLsc
   749: |||         
   750: |||         
   751: |||         !!$    xy_RainLsc     = 0.0d0
   752: |||         !!$    do k = kmax, 1, -1
   753: |||         !!$      xy_RainLsc = xy_RainLsc                                     &
   754: |||         !!$        & + ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav      &
   755: |||         !!$        & * ( xyz_QVapB(:,:,k  ) - xyz_QVap (:,:,k) )
   756: |||         !!$    end do
   757: |||         !!$    xy_RainLsc = xy_RainLsc / ( 2.0_DP * DelTime )
   758: |||         
   759: |||         
   760: |||         !!$    i = 0
   761: |||         !!$    j = jmax/2+1
   762: |||         !!$    write( 6, * ) xy_RainLsc(i,j)
   763: |||         
   764: |||         
   765: |||         !!$    xyz_DQH2OLiqDt = - xyz_DQVapDtLsc
   766: |||         !!$    xy_RainLsc     = 0.0d0
   767: |||         !!$    do k = kmax, 1, -1
   768: |||         !!$      xy_RainLsc = xy_RainLsc                                     &
   769: |||         !!$        & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   770: |||         !!$    end do
   771: |||         
   772: |||         !!$    i = 0
   773: |||         !!$    j = jmax/2+1
   774: |||         !!$    write( 6, * ) xy_RainLsc(i,j)
   775: |||         !!$    write( 6, * ) '---'
   776: |||         
   777: |||         !!$    xy_Rain     = xy_Rain     + xy_RainLsc
   778: |||         
   779: |||         
   780: **W---- A       xyz_DQH2OLiqDt = - xyz_DQVapDtLsc
   781:             
   782:             
   783:                 ! calculation for output
   784: W*=====         xy_RainLsc     = 0.0_DP
   785: +------>        do k = kmax, 1, -1
   786: |W*==== A         xy_RainLsc = xy_RainLsc                                     &
   787: |                   & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   788: +------         end do
   789:             
   790:                 ! ヒストリデータ出力
   791:                 ! History data output
   792:                 !
   793: +V===== A       call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc * LatentHeat )
   794:                 call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   795:                 call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
   796:             
   797:             
   798:             
   799:                 ! 計算時間計測一時停止
   800:                 ! Pause measurement of computation time
   801:                 !
   802:                 call TimesetClockStop( module_name )
   803:             
   804:               end subroutine LScaleCondLL91
   805:             
   806:               !--------------------------------------------------------------------------------------
   807:             
   808:               subroutine LScaleCondLL91Init
   809:                 !
   810:                 ! lscond モジュールの初期化を行います. 
   811:                 ! NAMELIST#lscond_nml の読み込みはこの手続きで行われます. 
   812:                 !
   813:                 ! "lscond" module is initialized. 
   814:                 ! "NAMELIST#lscond_nml" is loaded in this procedure. 
   815:                 !
   816:             
   817:                 ! モジュール引用 ; USE statements
   818:                 !
   819:             
   820:                 ! NAMELIST ファイル入力に関するユーティリティ
   821:                 ! Utilities for NAMELIST file input
   822:                 !
   823:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   824:             
   825:                 ! ファイル入出力補助
   826:                 ! File I/O support
   827:                 !
   828:                 use dc_iounit, only: FileOpen
   829:             
   830:                 ! 種別型パラメタ
   831:                 ! Kind type parameter
   832:                 !
   833:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   834:             
   835:                 ! 文字列操作
   836:                 ! Character handling
   837:                 !
   838:                 use dc_string, only: StoA
   839:             
   840:                 ! ヒストリデータ出力
   841:                 ! History data output
   842:                 !
   843:                 use gtool_historyauto, only: HistoryAutoAddVariable
   844:             
   845:                 ! 宣言文 ; Declaration statements
   846:                 !
   847:                 implicit none
   848:             
   849:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   850:                                           ! Unit number for NAMELIST file open
   851:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   852:                                           ! IOSTAT of NAMELIST read
   853:             
   854:                 ! NAMELIST 変数群
   855:                 ! NAMELIST group name
   856:                 !
   857:                 namelist /lscond_nml/ &
   858:             !!$      & CrtlRH, ItrtMax, FlagUse
   859:                   & Gamma, ItrtMax
   860:                       !
   861:                       ! デフォルト値については初期化手続 "lscond#LSCondInit" 
   862:                       ! のソースコードを参照のこと. 
   863:                       !
   864:                       ! Refer to source codes in the initialization procedure
   865:                       ! "lscond#LSCondInit" for the default values. 
   866:                       !
   867:             
   868:                 ! 実行文 ; Executable statement
   869:                 !
   870:             
   871:                 if ( lscond_LL91_inited ) return
   872:             
   873:             
   874:                 ! デフォルト値の設定
   875:                 ! Default values settings
   876:                 !
   877:             !!$    CrtlRH  = 1.0_DP
   878:                 Gamma   = 0.2_DP
   879:                 !  This value is from Le Treut and Li (1991). 
   880:                 ItrtMax = 3
   881:             !!$    FlagUse = .true.
   882:             
   883:                 ! NAMELIST の読み込み
   884:                 ! NAMELIST is input
   885:                 !
   886:                 if ( trim(namelist_filename) /= '' ) then
   887:                   call FileOpen( unit_nml, &          ! (out)
   888:                     & namelist_filename, mode = 'r' ) ! (in)
   889:             
   890:                   rewind( unit_nml )
   891:                   read( unit_nml, &         ! (in)
   892:                     & nml = lscond_nml, &   ! (out)
   893:                     & iostat = iostat_nml ) ! (out)
   894:                   close( unit_nml )
   895:             
   896:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   897:                   if ( iostat_nml == 0 ) write( STDOUT, nml = lscond_nml )
   898:                 end if
   899:             
   900:                 ! ヒストリデータ出力のためのへの変数登録
   901:                 ! Register of variables for history data output
   902:                 !
   903:                 call HistoryAutoAddVariable( 'RainLsc', &
   904:                   & (/ 'lon ', 'lat ', 'time' /), &
   905:                   & 'precipitation by large scale condensation', 'W m-2' )
   906:                 call HistoryAutoAddVariable( 'DTempDtLsc', &
   907:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   908:                   & 'large-scale condensation heating', 'K s-1' )
   909:                 call HistoryAutoAddVariable( 'DQVapDtLsc', &
   910:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   911:                   & 'large-scale condensation moistening', 'kg kg-1 s-1' )
   912:             
   913:                 ! 印字 ; Print
   914:                 !
   915:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   916:             !!$    call MessageNotify( 'M', module_name, '  FlagUse = %b', l = (/ FlagUse /) )
   917:             !!$    call MessageNotify( 'M', module_name, '  CrtlRH  = %f', d = (/ CrtlRH /) )
   918:                 call MessageNotify( 'M', module_name, '  Gamma   = %f', d = (/ Gamma /) )
   919:                 call MessageNotify( 'M', module_name, '  ItrtMax = %d', i = (/ ItrtMax /) )
   920:                 call MessageNotify( 'M', module_name, '' )
   921:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   922:             
   923:                 lscond_LL91_inited = .true.
   924:             
   925:               end subroutine LScaleCondLL91Init
   926:             
   927:               !--------------------------------------------------------------------------------------
   928:             
   929:             end module lscond_LL91
