Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:41 2016
FILE NAME: saturation_adjust.f90
PROGRAM NAME: saturation_adjust
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   252  opt  (  11): Fused array assignments. :line 252 - 259
   252  vec  (   4): Vectorized array expression.
   252  vec  (  29): ADB is used for array.: xyz_temp
   252  vec  (  29): ADB is used for array.: xyz_qh2oliq
   252  vec  (  29): ADB is used for array.: xyz_qvap
   264  opt  (1593): Loop nest collapsed into one loop.
   264  vec  (   1): Vectorized loop.
   264  vec  (  29): ADB is used for array.: xyz_temp
   264  vec  (  29): ADB is used for array.: xyz_qh2oliq
   264  vec  (  29): ADB is used for array.: xyz_qvap
   282  opt  (  11): Fused array assignments. :line 282 - 283
   282  opt  (1592): Outer loop unrolled inside inner loop.
   282  vec  (   4): Vectorized array expression.
   282  vec  (  29): ADB is used for array.: xyz_qvap
   282  vec  (  29): ADB is used for array.: xyz_temp
   282  vec  (   4): Vectorized array expression.
   282  vec  (  29): ADB is used for array.: xyz_qvap
   282  vec  (  29): ADB is used for array.: xyz_temp
   300  opt  (  11): Fused array assignments. :line 300 - 304
   300  opt  (1593): Loop nest collapsed into one loop.
   300  vec  (   4): Vectorized array expression.
   300  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   300  vec  (  29): ADB is used for array.: xyz_dtempdtlsc
   300  vec  (  29): ADB is used for array.: xyz_temp
   300  vec  (  29): ADB is used for array.: xyz_dqvapdtlsc
   300  vec  (  29): ADB is used for array.: xyz_qvap
   308  opt  (1593): Loop nest collapsed into one loop.
   308  vec  (   4): Vectorized array expression.
   308  vec  (  29): ADB is used for array.: xy_rainlsc
   309  vec  (   3): Unvectorized loop.
   309  vec  (  13): Overhead of loop division is too large.
   310  opt  (1593): Loop nest collapsed into one loop.
   310  vec  (   4): Vectorized array expression.
   310  vec  (  29): ADB is used for array.: xy_rainlsc
   310  vec  (  29): ADB is used for array.: xyr_press
   310  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   328  warn (  82): Name "xyz_rainlsc" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:41 2016
FILE NAME: saturation_adjust.f90
PROGRAM NAME: saturation_adjust
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Saturation adjustment
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: saturation_adjust.f90,v 1.4 2015/01/29 12:03:22 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module saturation_adjust
    13    !
    14    !=
    15    !
    16    != Saturation adjustment
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    ! Adjust temperature and specific humidity by the use of saturation
    23    ! adjustment
    24    !
    25    !== References
    26    !
    27  !!$  !  Manabe, S., J. Smagorinsky, R. F. Strickler,
    28  !!$  !    Simulated climatology of a general circulation model with a hydrologic cycle,
    29  !!$  !    Mon. Wea. Rev., 93, 769-798, 1965.
    30    !
    31    !== Procedures List
    32    !
    33    ! SaturationAdjust :: 温度と比湿の調節
    34    ! ---------------- :: ------------
    35    ! SaturationAdjust :: Adjust temperature and specific humidity
    36    !
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#saturation_adjust_nml
    40    !
    41  
    42    ! モジュール引用 ; USE statements
    43    !
    44  
    45    ! 格子点設定
    46    ! Grid points settings
    47    !
    48    use gridset, only: imax, & ! 経度格子点数.
    49                               ! Number of grid points in longitude
    50      &                jmax, & ! 緯度格子点数.
    51                               ! Number of grid points in latitude
    52      &                kmax    ! 鉛直層数.
    53                               ! Number of vertical level
    54  
    55    ! 種別型パラメタ
    56    ! Kind type parameter
    57    !
    58    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    59      &                 STRING     ! 文字列.       Strings.
    60  
    61    ! メッセージ出力
    62    ! Message output
    63    !
    64    use dc_message, only: MessageNotify
    65  
    66    ! 宣言文 ; Declaration statements
    67    !
    68    implicit none
    69    private
    70  
    71    ! 公開手続き
    72    ! Public procedure
    73    !
    74    public:: SaturationAdjust
    75    public:: SaturationAdjustInit
    76  
    77    ! 公開変数
    78    ! Public variables
    79    !
    80    logical, save :: saturation_adjust_inited = .false.
    81                                ! 初期設定フラグ.
    82                                ! Initialization flag
    83  
    84    ! 非公開変数
    85    ! Private variables
    86    !
    87    logical, save:: FlagSublimation
    88                                !
    89                                ! flag for treating sublimation
    90  
    91    character(*), parameter:: module_name = 'saturation_adjust'
    92                                ! モジュールの名称.
    93                                ! Module name
    94    character(*), parameter:: version = &
    95      & '$Name:  $' // &
    96      & '$Id: saturation_adjust.f90,v 1.4 2015/01/29 12:03:22 yot Exp $'
    97                                ! モジュールのバージョン
    98                                ! Module version
    99  
   100  contains
   101  
   102    !--------------------------------------------------------------------------------------
   103  
   104    subroutine SaturationAdjust(         &
   105      & xyz_Temp, xyz_QVap,              &  ! (inout)
   106      & xyz_QH2OLiq,                     &  ! (in)
   107      & xyz_Press, xyr_Press,            &  ! (in)
   108      & xyz_DQH2OLiqDt                   &  ! (out)
   109      & )
   110      !
   111      !
   112      !
   113      ! Adjust temperature and specific humidity by the use of saturation
   114      ! adjustment
   115      !
   116  
   117      ! モジュール引用 ; USE statements
   118      !
   119  
   120      ! 物理定数設定
   121      ! Physical constants settings
   122      !
   123      use constants, only: &
   124        & Grav, &
   125                                ! $ g $ [m s-2].
   126                                ! 重力加速度.
   127                                ! Gravitational acceleration
   128        & CpDry, &
   129                                ! $ C_p $ [J kg-1 K-1].
   130                                ! 乾燥大気の定圧比熱.
   131                                ! Specific heat of air at constant pressure
   132        & LatentHeat, &
   133                                ! $ L $ [J kg-1] .
   134                                ! 凝結の潜熱.
   135                                ! Latent heat of condensation
   136        & LatentHeatFusion
   137                                ! $ L $ [J kg-1] .
   138                                ! 融解の潜熱.
   139                                ! Latent heat of fusion
   140  
   141      ! 時刻管理
   142      ! Time control
   143      !
   144      use timeset, only: &
   145        & DelTime, &            ! $ \Delta t $
   146        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   147        & TimesetClockStart, TimesetClockStop
   148  
   149      ! ヒストリデータ出力
   150      ! History data output
   151      !
   152      use gtool_historyauto, only: HistoryAutoPut
   153  
   154      ! 飽和比湿の算出
   155      ! Evaluate saturation specific humidity
   156      !
   157      use saturate, only: xyz_CalcQVapSat
   158  
   159      ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
   160      ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
   161      use lscond, only : LScaleCond
   162  
   163  
   164      ! 宣言文 ; Declaration statements
   165      !
   166      implicit none
   167  
   168      real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   169                                ! $ T $ .     温度. Temperature
   170      real(DP), intent(inout):: xyz_QVap   (0:imax-1, 1:jmax, 1:kmax)
   171                                ! $ q $ .     比湿. Specific humidity
   172      real(DP), intent(in   ):: xyz_QH2OLiq(0:imax-1, 1:jmax, 1:kmax)
   173                                ! $ q_w $ .   雲水混合比. Cloud water mixing ratio
   174      real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   175                                ! $ p $ . 気圧 (整数レベル).
   176                                ! Air pressure (full level)
   177      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   178                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   179                                ! Air pressure (half level)
   180      real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
   181  
   182  
   183      ! 作業変数
   184      ! Work variables
   185      !
   186      real(DP):: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
   187                                ! 飽和比湿.
   188                                ! Saturation specific humidity.
   189      real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
   190                                ! 降水量.
   191                                ! Precipitation
   192      real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   193                                ! 温度変化率.
   194                                ! Temperature tendency
   195      real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   196                                ! 比湿変化率.
   197                                ! Specific humidity tendency
   198  
   199      real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   200                                ! 調節前の比湿.
   201                                ! Specific humidity before adjust.
   202      real(DP):: xyz_QH2OLiqB (0:imax-1, 1:jmax, 1:kmax)
   203                                ! 調節前の雲水混合比.
   204                                ! Mixing ratio of cloud water before adjust.
   205      real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   206                                ! 調節前の温度.
   207                                ! Temperature before adjust.
   208                                !
   209      real(DP):: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)
   210  
   211      real(DP):: xyz_EvapQH2OLiq(0:imax-1, 1:jmax, 1:kmax)
   212      real(DP):: TempTentative
   213  
   214      real(DP):: LatentHeatLocal
   215                                !
   216                                ! Latent heat used in this routine
   217      integer:: i
   218      integer:: j
   219      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   220                                ! Work variables for DO loop in vertical direction
   221  
   222  
   223  
   224      ! 実行文 ; Executable statement
   225      !
   226  
   227      ! 初期化確認
   228      ! Initialization check
   229      !
   230      if ( .not. saturation_adjust_inited ) then
   231        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   232      end if
   233  
   234  
   235      ! 計算時間計測開始
   236      ! Start measurement of computation time
   237      !
   238      call TimesetClockStart( module_name )
   239  
   240  
   241      ! Set a value for latent heat
   242      if ( FlagSublimation ) then
   243        LatentHeatLocal = LatentHeat + LatentHeatFusion
   244      else
   245        LatentHeatLocal = LatentHeat
   246      end if
   247  
   248  
   249      ! 調節前 "QVap", "QH2OLiq", "Temp" の保存
   250      ! Store "QVap", "QH2OLiq", "Temp" before adjustment
   251      !
   252      xyz_QVapB    = xyz_QVap
   253      xyz_QH2OLiqB = xyz_QH2OLiq
   254      xyz_TempB    = xyz_Temp
   255  
   256      ! 飽和比湿計算
   257      ! Calculate saturation specific humidity
   258      !
   259      xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   260  
   261      ! Evaporate all of cloud liquid water temporarily
   262  !!$    xyz_EvapQH2OLiq = xyz_QH2OLiq
   263      ! Evaporate part of cloud liquid water temporarily
   264      do k = 1, kmax
   265        do j = 1, jmax
   266          do i = 0, imax-1
   267            xyz_EvapQH2OLiq(i,j,k) = &
   268              & min( max( xyz_QVapSat(i,j,k), xyz_QVap(i,j,k) ) - xyz_QVap(i,j,k), &
   269              &      xyz_QH2OLiq(i,j,k) )
   270            xyz_EvapQH2OLiq(i,j,k) = &
   271              & xyz_EvapQH2OLiq(i,j,k) * ( 1.0_DP - 1.0e-10_DP )
   272            TempTentative = xyz_Temp(i,j,k) - LatentHeatLocal * xyz_EvapQH2OLiq(i,j,k) / CpDry
   273            if ( TempTentative < 1.0_DP ) then
   274              TempTentative = 1.0_DP
   275              xyz_EvapQH2OLiq(i,j,k) = &
   276                & ( xyz_Temp(i,j,k) - TempTentative ) / ( LatentHeatLocal / CpDry )
   277            end if
   278          end do
   279        end do
   280      end do
     .        d2 = latentheatlocal/cpdry                                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_evapqh2oliq1 = min(max(xyz_qvapsat(k-1,1,1),xyz_qvap(k-1,1,
     .       1      1))-xyz_qvap(k-1,1,1),xyz_qh2oliq(k-1,1,1))                 
     .           xyz_evapqh2oliq1 = xyz_evapqh2oliq1*9.99999999899999e-001      
     .           temptentative = xyz_temp(k-1,1,1) - xyz_evapqh2oliq1*d2        
     .           if (temptentative .lt. 1.00000000000000e+000) then             
     .              temptentative = 1.00000000000000e+000                       
     .              xyz_evapqh2oliq1 = (xyz_temp(k-1,1,1)-temptentative)/(      
     .       1         latentheatlocal/cpdry)                                   
     .           endif                                                          
     .           xyz_evapqh2oliq(k-1,1,1) = xyz_evapqh2oliq1                    
     .        enddo                                                             
   281      !
   282      xyz_Temp    = xyz_Temp    - LatentHeatLocal * xyz_EvapQH2OLiq / CpDry
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j1 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t444 = 1, j1                                                
     .              d3 = latentheatlocal/cpdry                                  
     .  !cdir       nodep                                                       
     .              do t446 = 1, xyz_temp.DSC.U1 + 1                            
     .                 xyz_temp(t446-1,t444,t442+1) = xyz_temp(t446-1,t444,t442+
     .       1            1) - xyz_evapqh2oliq(t446-1,t444,t442+1)*d3           
     .                 xyz_qvap(t446-1,t444,t442+1) = xyz_qvap(t446-1,t444,t442+
     .       1            1) + xyz_evapqh2oliq(t446-1,t444,t442+1)              
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t444 = j1 + 1, xyz_temp.DSC.U2, 4                           
     .              d4 = latentheatlocal/cpdry                                  
     .              d5 = latentheatlocal/cpdry                                  
     .              d6 = latentheatlocal/cpdry                                  
     .              d7 = latentheatlocal/cpdry                                  
     .  !cdir       nodep                                                       
     .              do t446 = 1, xyz_temp.DSC.U1 + 1                            
     .                 xyz_temp(t446-1,t444,t442+1) = xyz_temp(t446-1,t444,t442+
     .       1            1) - xyz_evapqh2oliq(t446-1,t444,t442+1)*d4           
     .                 xyz_temp(t446-1,t444+1,t442+1) = xyz_temp(t446-1,t444+1, 
     .       1            t442+1) - xyz_evapqh2oliq(t446-1,t444+1,t442+1)*d5    
     .                 xyz_temp(t446-1,t444+2,t442+1) = xyz_temp(t446-1,t444+2, 
     .       1            t442+1) - xyz_evapqh2oliq(t446-1,t444+2,t442+1)*d6    
     .                 xyz_temp(t446-1,t444+3,t442+1) = xyz_temp(t446-1,t444+3, 
     .       1            t442+1) - xyz_evapqh2oliq(t446-1,t444+3,t442+1)*d7    
     .                 xyz_qvap(t446-1,t444,t442+1) = xyz_qvap(t446-1,t444,t442+
     .       1            1) + xyz_evapqh2oliq(t446-1,t444,t442+1)              
     .                 xyz_qvap(t446-1,t444+1,t442+1) = xyz_qvap(t446-1,t444+1, 
     .       1            t442+1) + xyz_evapqh2oliq(t446-1,t444+1,t442+1)       
     .                 xyz_qvap(t446-1,t444+2,t442+1) = xyz_qvap(t446-1,t444+2, 
     .       1            t442+1) + xyz_evapqh2oliq(t446-1,t444+2,t442+1)       
     .                 xyz_qvap(t446-1,t444+3,t442+1) = xyz_qvap(t446-1,t444+3, 
     .       1            t442+1) + xyz_evapqh2oliq(t446-1,t444+3,t442+1)       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   283      xyz_QVap    = xyz_QVap    +                   xyz_EvapQH2OLiq
   284      ! QH2OLiq will be updated in cloud model. Tendency will be updated below.
   285  !!$    xyz_QH2OLiq = 0.0_DP
   286  
   287  
   288      call LScaleCond(              &
   289        & xyz_Temp, xyz_QVap,       &  ! (inout)
   290        & xyz_Press, xyr_Press,     &  ! (in)
   291        & xyz_DQH2OLiqDt,           &  ! (out)
   292        & .false.                   &
   293        & )
   294  
   295  
   296      ! 比湿変化率, 温度変化率, 降水量の算出
   297      ! Calculate specific humidity tendency, temperature tendency,
   298      ! precipitation
   299      !
   300      xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
     .        d8 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d9 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d10 = 1.D0/(2.00000000000000e+000*deltime)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t466 = 1, kmax*jmax*imax                                       
     .           xyz_dqvapdtlsc(t466-1,1,1) = (xyz_qvap(t466-1,1,1)-xyz_qvapb(  
     .       1      t466-1,1,1))*d8                                             
     .           xyz_dtempdtlsc(t466-1,1,1) = (xyz_temp(t466-1,1,1)-xyz_tempb(  
     .       1      t466-1,1,1))*d9                                             
     .           xyz_dqh2oliqdt(t466-1,1,1) = xyz_dqh2oliqdt(t466-1,1,1) -      
     .       1      xyz_evapqh2oliq(t466-1,1,1)*d10                             
     .        enddo                                                             
   301      xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   302  
   303  
   304      xyz_DQH2OLiqDt = xyz_DQH2OLiqDt - xyz_EvapQH2OLiq / ( 2.0_DP * DelTime )
   305  
   306  
   307      ! calculation for output
   308      xy_RainLsc     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t499 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t499-1,1) = 0.0000000000000000e+000                 
     .        enddo                                                             
   309      do k = kmax, 1, -1
   310        xy_RainLsc = xy_RainLsc                                     &
     .        d11 = 1.D0/grav                                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_rainlsc,xyr_press)                                      
     .        do t505 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t505-1,1) = xy_rainlsc(t505-1,1) + xyz_dqh2oliqdt(  
     .       1      t505-1,1,k)*(xyr_press(t505-1,1,k-1)-xyr_press(t505-1,1,k))*
     .       2      d11                                                         
     .        enddo                                                             
   311          & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   312      end do
   313  
   314  
   315      ! ヒストリデータ出力
   316      ! History data output
   317      !
   318      call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc     )
   319      call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   320      call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
   321  
   322  
   323      ! 計算時間計測一時停止
   324      ! Pause measurement of computation time
   325      !
   326      call TimesetClockStop( module_name )
   327  
   328    end subroutine SaturationAdjust
   329  
   330    !--------------------------------------------------------------------------------------
   331  
   332    subroutine SaturationAdjustInit( &
   333      & FlagSnow &
   334      & )
   335      !
   336      ! saturation_adjust モジュールの初期化を行います.
   337      ! NAMELIST#saturation_adjust_nml の読み込みはこの手続きで行われます.
   338      !
   339      ! "saturation_adjust" module is initialized.
   340      ! "NAMELIST#saturation_adjust_nml" is loaded in this procedure.
   341      !
   342  
   343      ! モジュール引用 ; USE statements
   344      !
   345  
   346      ! NAMELIST ファイル入力に関するユーティリティ
   347      ! Utilities for NAMELIST file input
   348      !
   349      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   350  
   351      ! ファイル入出力補助
   352      ! File I/O support
   353      !
   354      use dc_iounit, only: FileOpen
   355  
   356      ! 種別型パラメタ
   357      ! Kind type parameter
   358      !
   359      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   360  
   361      ! 文字列操作
   362      ! Character handling
   363      !
   364      use dc_string, only: StoA
   365  
   366      ! ヒストリデータ出力
   367      ! History data output
   368      !
   369      use gtool_historyauto, only: HistoryAutoAddVariable
   370  
   371      ! 飽和比湿の算出
   372      ! Evaluate saturation specific humidity
   373      !
   374      use saturate, only: SaturateInit
   375  
   376      ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
   377      ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
   378      use lscond, only : LScaleCondInit
   379  
   380      ! 宣言文 ; Declaration statements
   381      !
   382      implicit none
   383  
   384      logical, intent(in) :: FlagSnow
   385  
   386  
   387      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   388                                ! Unit number for NAMELIST file open
   389      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   390                                ! IOSTAT of NAMELIST read
   391  
   392      ! NAMELIST 変数群
   393      ! NAMELIST group name
   394      !
   395      namelist /saturation_adjust_nml/ &
   396        & FlagSublimation
   397            !
   398            ! デフォルト値については初期化手続 "saturation_adjust#SaturationAdjustInit"
   399            ! のソースコードを参照のこと.
   400            !
   401            ! Refer to source codes in the initialization procedure
   402            ! "saturation_adjust#SaturationAdjustInit" for the default values.
   403            !
   404  
   405      ! 実行文 ; Executable statement
   406      !
   407  
   408      if ( saturation_adjust_inited ) return
   409  
   410  
   411      ! デフォルト値の設定
   412      ! Default values settings
   413      !
   414      FlagSublimation = .false.
   415  
   416      ! NAMELIST の読み込み
   417      ! NAMELIST is input
   418      !
   419      if ( trim(namelist_filename) /= '' ) then
   420        call FileOpen( unit_nml, &          ! (out)
   421          & namelist_filename, mode = 'r' ) ! (in)
   422  
   423        rewind( unit_nml )
   424        read( unit_nml, &                    ! (in)
   425          & nml = saturation_adjust_nml, &   ! (out)
   426          & iostat = iostat_nml )            ! (out)
   427        close( unit_nml )
   428  
   429        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   430        if ( iostat_nml == 0 ) write( STDOUT, nml = saturation_adjust_nml )
   431      end if
   432  
   433      ! Initialization of modules used in this routine
   434  
   435      ! 飽和比湿の算出
   436      ! Evaluate saturation specific humidity
   437      !
   438      call SaturateInit
   439  
   440      ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
   441      ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
   442      !
   443      call LScaleCondInit( &
   444        & FlagSnow &
   445        & )
   446  
   447  
   448      ! ヒストリデータ出力のためのへの変数登録
   449      ! Register of variables for history data output
   450      !
   451      ! HistoryAutoAddVariable is called in LScaleCond for variables below.
   452      !
   453  !!$    call HistoryAutoAddVariable( 'RainLsc', &
   454  !!$      & (/ 'lon ', 'lat ', 'time' /), &
   455  !!$      & 'precipitation by large scale condensation', 'kg m-2 s-1' )
   456  !!$    call HistoryAutoAddVariable( 'DTempDtLsc', &
   457  !!$      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   458  !!$      & 'large-scale condensation heating', 'K s-1' )
   459  !!$    call HistoryAutoAddVariable( 'DQVapDtLsc', &
   460  !!$      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   461  !!$      & 'large-scale condensation moistening', 'kg kg-1 s-1' )
   462  
   463      ! 印字 ; Print
   464      !
   465      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   466      call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
   467      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   468  
   469      saturation_adjust_inited = .true.
   470  
   471    end subroutine SaturationAdjustInit
   472  
   473    !--------------------------------------------------------------------------------------
   474  
   475  end module saturation_adjust
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:41 2016
FILE NAME: saturation_adjust.f90
PROGRAM NAME: saturation_adjust
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Saturation adjustment
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: saturation_adjust.f90,v 1.4 2015/01/29 12:03:22 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module saturation_adjust
    13:               !
    14:               != 
    15:               !
    16:               != Saturation adjustment
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! Adjust temperature and specific humidity by the use of saturation 
    23:               ! adjustment
    24:               !
    25:               !== References
    26:               !
    27:             !!$  !  Manabe, S., J. Smagorinsky, R. F. Strickler,
    28:             !!$  !    Simulated climatology of a general circulation model with a hydrologic cycle,
    29:             !!$  !    Mon. Wea. Rev., 93, 769-798, 1965.
    30:               !
    31:               !== Procedures List
    32:               ! 
    33:               ! SaturationAdjust :: 温度と比湿の調節
    34:               ! ---------------- :: ------------
    35:               ! SaturationAdjust :: Adjust temperature and specific humidity
    36:               !
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#saturation_adjust_nml
    40:               !
    41:             
    42:               ! モジュール引用 ; USE statements
    43:               !
    44:             
    45:               ! 格子点設定
    46:               ! Grid points settings
    47:               !
    48:               use gridset, only: imax, & ! 経度格子点数. 
    49:                                          ! Number of grid points in longitude
    50:                 &                jmax, & ! 緯度格子点数. 
    51:                                          ! Number of grid points in latitude
    52:                 &                kmax    ! 鉛直層数. 
    53:                                          ! Number of vertical level
    54:             
    55:               ! 種別型パラメタ
    56:               ! Kind type parameter
    57:               !
    58:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    59:                 &                 STRING     ! 文字列.       Strings. 
    60:             
    61:               ! メッセージ出力
    62:               ! Message output
    63:               !
    64:               use dc_message, only: MessageNotify
    65:             
    66:               ! 宣言文 ; Declaration statements
    67:               !
    68:               implicit none
    69:               private
    70:             
    71:               ! 公開手続き
    72:               ! Public procedure
    73:               !
    74:               public:: SaturationAdjust
    75:               public:: SaturationAdjustInit
    76:             
    77:               ! 公開変数
    78:               ! Public variables
    79:               !
    80:               logical, save :: saturation_adjust_inited = .false.
    81:                                           ! 初期設定フラグ. 
    82:                                           ! Initialization flag
    83:             
    84:               ! 非公開変数
    85:               ! Private variables
    86:               !
    87:               logical, save:: FlagSublimation
    88:                                           !
    89:                                           ! flag for treating sublimation
    90:             
    91:               character(*), parameter:: module_name = 'saturation_adjust'
    92:                                           ! モジュールの名称. 
    93:                                           ! Module name
    94:               character(*), parameter:: version = &
    95:                 & '$Name:  $' // &
    96:                 & '$Id: saturation_adjust.f90,v 1.4 2015/01/29 12:03:22 yot Exp $'
    97:                                           ! モジュールのバージョン
    98:                                           ! Module version
    99:             
   100:             contains
   101:             
   102:               !--------------------------------------------------------------------------------------
   103:             
   104:               subroutine SaturationAdjust(         &
   105:                 & xyz_Temp, xyz_QVap,              &  ! (inout)
   106:                 & xyz_QH2OLiq,                     &  ! (in)
   107:                 & xyz_Press, xyr_Press,            &  ! (in)
   108:                 & xyz_DQH2OLiqDt                   &  ! (out)
   109:                 & )
   110:                 !
   111:                 ! 
   112:                 !
   113:                 ! Adjust temperature and specific humidity by the use of saturation 
   114:                 ! adjustment
   115:                 !
   116:             
   117:                 ! モジュール引用 ; USE statements
   118:                 !
   119:             
   120:                 ! 物理定数設定
   121:                 ! Physical constants settings
   122:                 !
   123:                 use constants, only: &
   124:                   & Grav, & 
   125:                                           ! $ g $ [m s-2]. 
   126:                                           ! 重力加速度. 
   127:                                           ! Gravitational acceleration
   128:                   & CpDry, &
   129:                                           ! $ C_p $ [J kg-1 K-1]. 
   130:                                           ! 乾燥大気の定圧比熱. 
   131:                                           ! Specific heat of air at constant pressure
   132:                   & LatentHeat, &
   133:                                           ! $ L $ [J kg-1] . 
   134:                                           ! 凝結の潜熱. 
   135:                                           ! Latent heat of condensation
   136:                   & LatentHeatFusion
   137:                                           ! $ L $ [J kg-1] .
   138:                                           ! 融解の潜熱.
   139:                                           ! Latent heat of fusion
   140:             
   141:                 ! 時刻管理
   142:                 ! Time control
   143:                 !
   144:                 use timeset, only: &
   145:                   & DelTime, &            ! $ \Delta t $
   146:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   147:                   & TimesetClockStart, TimesetClockStop
   148:             
   149:                 ! ヒストリデータ出力
   150:                 ! History data output
   151:                 !
   152:                 use gtool_historyauto, only: HistoryAutoPut
   153:             
   154:                 ! 飽和比湿の算出
   155:                 ! Evaluate saturation specific humidity
   156:                 !
   157:                 use saturate, only: xyz_CalcQVapSat
   158:             
   159:                 ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
   160:                 ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
   161:                 use lscond, only : LScaleCond
   162:             
   163:             
   164:                 ! 宣言文 ; Declaration statements
   165:                 !
   166:                 implicit none
   167:             
   168:                 real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   169:                                           ! $ T $ .     温度. Temperature
   170:                 real(DP), intent(inout):: xyz_QVap   (0:imax-1, 1:jmax, 1:kmax)
   171:                                           ! $ q $ .     比湿. Specific humidity
   172:                 real(DP), intent(in   ):: xyz_QH2OLiq(0:imax-1, 1:jmax, 1:kmax)
   173:                                           ! $ q_w $ .   雲水混合比. Cloud water mixing ratio
   174:                 real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   175:                                           ! $ p $ . 気圧 (整数レベル). 
   176:                                           ! Air pressure (full level)
   177:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   178:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   179:                                           ! Air pressure (half level)
   180:                 real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
   181:             
   182:             
   183:                 ! 作業変数
   184:                 ! Work variables
   185:                 !
   186:                 real(DP):: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
   187:                                           ! 飽和比湿.
   188:                                           ! Saturation specific humidity.
   189:                 real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
   190:                                           ! 降水量. 
   191:                                           ! Precipitation
   192:                 real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   193:                                           ! 温度変化率. 
   194:                                           ! Temperature tendency
   195:                 real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   196:                                           ! 比湿変化率. 
   197:                                           ! Specific humidity tendency
   198:             
   199:                 real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   200:                                           ! 調節前の比湿. 
   201:                                           ! Specific humidity before adjust. 
   202:                 real(DP):: xyz_QH2OLiqB (0:imax-1, 1:jmax, 1:kmax)
   203:                                           ! 調節前の雲水混合比. 
   204:                                           ! Mixing ratio of cloud water before adjust. 
   205:                 real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   206:                                           ! 調節前の温度. 
   207:                                           ! Temperature before adjust. 
   208:                                           !
   209:                 real(DP):: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)
   210:             
   211:                 real(DP):: xyz_EvapQH2OLiq(0:imax-1, 1:jmax, 1:kmax)
   212:                 real(DP):: TempTentative
   213:             
   214:                 real(DP):: LatentHeatLocal
   215:                                           ! 
   216:                                           ! Latent heat used in this routine
   217:                 integer:: i
   218:                 integer:: j
   219:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   220:                                           ! Work variables for DO loop in vertical direction
   221:             
   222:             
   223:             
   224:                 ! 実行文 ; Executable statement
   225:                 !
   226:             
   227:                 ! 初期化確認
   228:                 ! Initialization check
   229:                 !
   230:                 if ( .not. saturation_adjust_inited ) then
   231:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   232:                 end if
   233:             
   234:             
   235:                 ! 計算時間計測開始
   236:                 ! Start measurement of computation time
   237:                 !
   238:                 call TimesetClockStart( module_name )
   239:             
   240:             
   241:                 ! Set a value for latent heat
   242:                 if ( FlagSublimation ) then
   243:                   LatentHeatLocal = LatentHeat + LatentHeatFusion
   244:                 else
   245:                   LatentHeatLocal = LatentHeat
   246:                 end if
   247:             
   248:             
   249:                 ! 調節前 "QVap", "QH2OLiq", "Temp" の保存
   250:                 ! Store "QVap", "QH2OLiq", "Temp" before adjustment
   251:                 !
   252: **V---->A       xyz_QVapB    = xyz_QVap
   253: |||     A       xyz_QH2OLiqB = xyz_QH2OLiq
   254: |||     A       xyz_TempB    = xyz_Temp
   255: |||         
   256: |||             ! 飽和比湿計算
   257: |||             ! Calculate saturation specific humidity
   258: |||             !
   259: **V----         xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   260:             
   261:                 ! Evaporate all of cloud liquid water temporarily
   262:             !!$    xyz_EvapQH2OLiq = xyz_QH2OLiq
   263:                 ! Evaporate part of cloud liquid water temporarily
   264: W------>        do k = 1, kmax
   265: |*----->          do j = 1, jmax
   266: ||*---->            do i = 0, imax-1
   267: |||     A             xyz_EvapQH2OLiq(i,j,k) = &
   268: |||                     & min( max( xyz_QVapSat(i,j,k), xyz_QVap(i,j,k) ) - xyz_QVap(i,j,k), &
   269: |||                     &      xyz_QH2OLiq(i,j,k) )
   270: |||                   xyz_EvapQH2OLiq(i,j,k) = &
   271: |||                     & xyz_EvapQH2OLiq(i,j,k) * ( 1.0_DP - 1.0e-10_DP )
   272: |||     A             TempTentative = xyz_Temp(i,j,k) - LatentHeatLocal * xyz_EvapQH2OLiq(i,j,k) / CpDry
   273: |||                   if ( TempTentative < 1.0_DP ) then
   274: |||                     TempTentative = 1.0_DP
   275: |||                     xyz_EvapQH2OLiq(i,j,k) = &
   276: |||                       & ( xyz_Temp(i,j,k) - TempTentative ) / ( LatentHeatLocal / CpDry )
   277: |||                   end if
   278: ||*----             end do
   279: |*-----           end do
   280: W------         end do
   281:                 !
   282: **V---->A       xyz_Temp    = xyz_Temp    - LatentHeatLocal * xyz_EvapQH2OLiq / CpDry
   283: **V---- A       xyz_QVap    = xyz_QVap    +                   xyz_EvapQH2OLiq
   284:                 ! QH2OLiq will be updated in cloud model. Tendency will be updated below.
   285:             !!$    xyz_QH2OLiq = 0.0_DP
   286:             
   287:             
   288:                 call LScaleCond(              &
   289:                   & xyz_Temp, xyz_QVap,       &  ! (inout)
   290:                   & xyz_Press, xyr_Press,     &  ! (in)
   291:                   & xyz_DQH2OLiqDt,           &  ! (out)
   292:                   & .false.                   &
   293:                   & )
   294:             
   295:             
   296:                 ! 比湿変化率, 温度変化率, 降水量の算出
   297:                 ! Calculate specific humidity tendency, temperature tendency, 
   298:                 ! precipitation
   299:                 !
   300: **W---->A       xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
   301: |||     A       xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   302: |||         
   303: |||         
   304: **W---- A       xyz_DQH2OLiqDt = xyz_DQH2OLiqDt - xyz_EvapQH2OLiq / ( 2.0_DP * DelTime )
   305:             
   306:             
   307:                 ! calculation for output
   308: W*===== A       xy_RainLsc     = 0.0_DP
   309: +------>        do k = kmax, 1, -1
   310: |W*==== A         xy_RainLsc = xy_RainLsc                                     &
   311: |                   & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   312: +------         end do
   313:             
   314:             
   315:                 ! ヒストリデータ出力
   316:                 ! History data output
   317:                 !
   318:                 call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc     )
   319:                 call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   320:                 call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )
   321:             
   322:             
   323:                 ! 計算時間計測一時停止
   324:                 ! Pause measurement of computation time
   325:                 !
   326:                 call TimesetClockStop( module_name )
   327:             
   328:               end subroutine SaturationAdjust
   329:             
   330:               !--------------------------------------------------------------------------------------
   331:             
   332:               subroutine SaturationAdjustInit( &
   333:                 & FlagSnow &
   334:                 & )
   335:                 !
   336:                 ! saturation_adjust モジュールの初期化を行います. 
   337:                 ! NAMELIST#saturation_adjust_nml の読み込みはこの手続きで行われます. 
   338:                 !
   339:                 ! "saturation_adjust" module is initialized. 
   340:                 ! "NAMELIST#saturation_adjust_nml" is loaded in this procedure. 
   341:                 !
   342:             
   343:                 ! モジュール引用 ; USE statements
   344:                 !
   345:             
   346:                 ! NAMELIST ファイル入力に関するユーティリティ
   347:                 ! Utilities for NAMELIST file input
   348:                 !
   349:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   350:             
   351:                 ! ファイル入出力補助
   352:                 ! File I/O support
   353:                 !
   354:                 use dc_iounit, only: FileOpen
   355:             
   356:                 ! 種別型パラメタ
   357:                 ! Kind type parameter
   358:                 !
   359:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   360:             
   361:                 ! 文字列操作
   362:                 ! Character handling
   363:                 !
   364:                 use dc_string, only: StoA
   365:             
   366:                 ! ヒストリデータ出力
   367:                 ! History data output
   368:                 !
   369:                 use gtool_historyauto, only: HistoryAutoAddVariable
   370:             
   371:                 ! 飽和比湿の算出
   372:                 ! Evaluate saturation specific humidity
   373:                 !
   374:                 use saturate, only: SaturateInit
   375:             
   376:                 ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
   377:                 ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
   378:                 use lscond, only : LScaleCondInit
   379:             
   380:                 ! 宣言文 ; Declaration statements
   381:                 !
   382:                 implicit none
   383:             
   384:                 logical, intent(in) :: FlagSnow
   385:             
   386:             
   387:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   388:                                           ! Unit number for NAMELIST file open
   389:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   390:                                           ! IOSTAT of NAMELIST read
   391:             
   392:                 ! NAMELIST 変数群
   393:                 ! NAMELIST group name
   394:                 !
   395:                 namelist /saturation_adjust_nml/ &
   396:                   & FlagSublimation
   397:                       !
   398:                       ! デフォルト値については初期化手続 "saturation_adjust#SaturationAdjustInit" 
   399:                       ! のソースコードを参照のこと. 
   400:                       !
   401:                       ! Refer to source codes in the initialization procedure
   402:                       ! "saturation_adjust#SaturationAdjustInit" for the default values. 
   403:                       !
   404:             
   405:                 ! 実行文 ; Executable statement
   406:                 !
   407:             
   408:                 if ( saturation_adjust_inited ) return
   409:             
   410:             
   411:                 ! デフォルト値の設定
   412:                 ! Default values settings
   413:                 !
   414:                 FlagSublimation = .false.
   415:             
   416:                 ! NAMELIST の読み込み
   417:                 ! NAMELIST is input
   418:                 !
   419:                 if ( trim(namelist_filename) /= '' ) then
   420:                   call FileOpen( unit_nml, &          ! (out)
   421:                     & namelist_filename, mode = 'r' ) ! (in)
   422:             
   423:                   rewind( unit_nml )
   424:                   read( unit_nml, &                    ! (in)
   425:                     & nml = saturation_adjust_nml, &   ! (out)
   426:                     & iostat = iostat_nml )            ! (out)
   427:                   close( unit_nml )
   428:             
   429:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   430:                   if ( iostat_nml == 0 ) write( STDOUT, nml = saturation_adjust_nml )
   431:                 end if
   432:             
   433:                 ! Initialization of modules used in this routine
   434:             
   435:                 ! 飽和比湿の算出
   436:                 ! Evaluate saturation specific humidity
   437:                 !
   438:                 call SaturateInit
   439:             
   440:                 ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
   441:                 ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
   442:                 !
   443:                 call LScaleCondInit( &
   444:                   & FlagSnow &
   445:                   & )
   446:             
   447:             
   448:                 ! ヒストリデータ出力のためのへの変数登録
   449:                 ! Register of variables for history data output
   450:                 !
   451:                 ! HistoryAutoAddVariable is called in LScaleCond for variables below.
   452:                 !
   453:             !!$    call HistoryAutoAddVariable( 'RainLsc', &
   454:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
   455:             !!$      & 'precipitation by large scale condensation', 'kg m-2 s-1' )
   456:             !!$    call HistoryAutoAddVariable( 'DTempDtLsc', &
   457:             !!$      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   458:             !!$      & 'large-scale condensation heating', 'K s-1' )
   459:             !!$    call HistoryAutoAddVariable( 'DQVapDtLsc', &
   460:             !!$      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   461:             !!$      & 'large-scale condensation moistening', 'kg kg-1 s-1' )
   462:             
   463:                 ! 印字 ; Print
   464:                 !
   465:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   466:                 call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
   467:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   468:             
   469:                 saturation_adjust_inited = .true.
   470:             
   471:               end subroutine SaturationAdjustInit
   472:             
   473:               !--------------------------------------------------------------------------------------
   474:             
   475:             end module saturation_adjust
