Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:40:36 2016
FILE NAME: dcpam_init_data.f90
PROGRAM NAME: dcpam_init_data
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   344  warn (  82): Name "n" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:40:36 2016
FILE NAME: dcpam_init_data.f90
PROGRAM NAME: dcpam_init_data
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 初期値データファイル生成主プログラム
     2  !
     3  != dcpam main program for generation of initial data file
     4  !
     5  ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: dcpam_init_data.f90,v 1.1 2013/10/06 13:42:17 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  program dcpam_init_data
    13    !
    14    ! <b>Note that Japanese and English are described in parallel.</b>
    15    !
    16    ! 初期値データファイルを生成します.
    17    !
    18    ! Initial data file is created.
    19    !
    20  
    21    ! モジュール引用 ; USE statements
    22    !
    23  
    24    ! 組成に関わる配列の設定
    25    ! Settings of array for atmospheric composition
    26    !
    27    use composition, only : &
    28      &                ncmax, & ! 成分の数
    29                                ! Number of composition
    30      &                IndexH2OVap
    31                                ! 水蒸気のインデックス
    32                                ! Index for water vapor
    33  
    34    ! 初期値データ (リスタートデータ) 提供
    35    ! Prepare initial data (restart data)
    36    !
    37    use initial_data, only: SetInitData
    38  
    39    ! リスタートデータ入出力
    40    ! Restart data input/output
    41    !
    42    use restart_file_io, only: InitialFileOutPut
    43  
    44    ! 種別型パラメタ
    45    ! Kind type parameter
    46    !
    47    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    48      &                 STRING, &  ! 文字列.       Strings.
    49      &                 TOKEN      ! キーワード.   Keywords.
    50  
    51    ! 宣言文 ; Declaration statements
    52    !
    53    implicit none
    54  
    55    ! 予報変数 (ステップ $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
    56    ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
    57    !
    58    real(DP), allocatable:: xyz_U (:,:,:)
    59                                ! $ u $ .   東西風速. Eastward wind
    60    real(DP), allocatable:: xyz_V (:,:,:)
    61                                ! $ v $ .   南北風速. Northward wind
    62    real(DP), allocatable:: xyz_Temp (:,:,:)
    63                                ! $ T $ .   温度. Temperature
    64    real(DP), allocatable:: xyzf_QVap (:,:,:,:)
    65                                ! $ q $ .   比湿. Specific humidity
    66    real(DP), allocatable:: xy_Ps (:,:)
    67                                ! $ p_s $ . 地表面気圧. Surface pressure
    68  
    69    ! 作業変数
    70    ! Work variables
    71    !
    72    integer :: n
    73  
    74  
    75    ! 実行文 ; Executable statement
    76    !
    77  
    78    ! 主プログラムの初期化 (内部サブルーチン)
    79    ! Initialization for the main program (Internal subroutine)
    80    !
    81    call MainInit
    82  
    83    ! 初期値データの作成
    84    ! Generate initial data
    85    !
    86    call SetInitData( &
    87      & xyz_U, xyz_V, xyz_Temp, xyzf_QVap, xy_Ps )  ! (out)
    88  
    89    ! 初期値データの出力
    90    ! Output initial data
    91    !
    92    call InitialFileOutput( &
    93      & xyz_U, xyz_V, xyz_Temp, xyzf_QVap, xy_Ps )  ! (in)
    94  
    95    ! 主プログラムの終了処理 (内部サブルーチン)
    96    ! Termination for the main program (Internal subroutine)
    97    !
    98    call MainTerminate
    99  
   100  contains
   101  
   102    !-------------------------------------------------------------------
   103  
   104    subroutine MainInit
   105      !
   106      ! 主プログラムの初期化手続き.
   107      !
   108      ! Initialization procedure for the main program.
   109      !
   110  
   111      ! MPI
   112      !
   113      use mpi_wrapper, only : MPIWrapperInit
   114  
   115      use dc_message, only: MessageNotify
   116  
   117      ! コマンドライン引数処理
   118      ! Command line option parser
   119      !
   120      use option_parser, only: OptParseInit
   121  
   122      ! NAMELIST ファイル入力に関するユーティリティ
   123      ! Utilities for NAMELIST file input
   124      !
   125      use namelist_util, only: NmlutilInit
   126  
   127      ! 時刻管理
   128      ! Time control
   129      !
   130      use timeset, only: TimesetInit
   131                                ! ステップ $ t $ の時刻. Time of step $ t $.
   132  
   133      ! 出力ファイルの基本情報管理
   134      ! Management basic information for output files
   135      !
   136      use fileset, only: FilesetInit
   137  
   138      ! 格子点設定
   139      ! Grid points settings
   140      !
   141      use gridset, only: GridsetInit, &
   142        &                imax, & ! 経度格子点数.
   143                                 ! Number of grid points in longitude
   144        &                jmax, & ! 緯度格子点数.
   145                                 ! Number of grid points in latitude
   146        &                kmax    ! 鉛直層数.
   147                                 ! Number of vertical level
   148  
   149      ! 組成に関わる配列の設定
   150      ! Settings of array for atmospheric composition
   151      !
   152      use composition, only : &
   153        &                CompositionInit, &
   154        &                ncmax   ! 成分の数
   155                                 ! Number of composition
   156  
   157      ! 物理定数設定
   158      ! Physical constants settings
   159      !
   160      use constants, only: ConstantsInit
   161  
   162      ! 座標データ設定
   163      ! Axes data settings
   164      !
   165      use axesset, only: AxessetInit
   166  
   167      ! ファイルから 1 次元プロファイルを読んで設定する.
   168      ! read 1-D profile from a file and set it
   169      !
   170      use set_1d_profile, only : Set1DProfileInit
   171  
   172      ! リスタートデータ入出力
   173      ! Restart data input/output
   174      !
   175      use restart_file_io, only: RestartFileInit, RestartFileOpen
   176  
   177      ! 初期値データ (リスタートデータ) 提供
   178      ! Prepare initial data (restart data)
   179      !
   180      use initial_data, only: InitDataInit
   181  
   182  
   183      ! 宣言文 ; Declaration statements
   184      !
   185      implicit none
   186      character(*), parameter:: prog_name = 'dcpam_init_data'
   187                                ! 主プログラム名.
   188                                ! Main program name
   189      character(*), parameter:: version = &
   190        & '$Name:  $' // &
   191        & '$Id: dcpam_init_data.f90,v 1.1 2013/10/06 13:42:17 yot Exp $'
   192                                ! 主プログラムのバージョン
   193                                ! Main program version
   194      character(STRING)      :: namelist_filename
   195                                ! NAMELIST ファイルの名称.
   196                                ! NAMELIST file name
   197  
   198      character(STRING):: brief
   199                                ! 実行ファイルの簡潔な説明
   200                                ! Brief account of executable file
   201  
   202      ! 実行文 ; Executable statement
   203      !
   204  
   205      ! Initialize MPI
   206      !
   207      call MPIWrapperInit
   208  
   209  
   210      brief = 'Initial data generation'
   211      call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
   212      call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )
   213  
   214      ! コマンドライン引数処理
   215      ! Command line option parser
   216      !
   217      call OptParseInit(       &
   218        & namelist_filename,   & ! (out)
   219        & prog_name,           & ! (in )
   220        & brief                & ! (in )
   221        & )
   222  
   223      ! NAMELIST ファイル名入力
   224      ! Input NAMELIST file name
   225      !
   226      call NmlutilInit( &
   227        & namelist_filename  & ! (in)
   228        & )
   229  
   230      ! 時刻管理
   231      ! Time control
   232      !
   233      call TimesetInit
   234  
   235      ! 出力ファイルの基本情報管理
   236      ! Management basic information for output files
   237      !
   238      call FilesetInit
   239  
   240      ! 格子点設定
   241      ! Grid points settings
   242      !
   243      call GridsetInit
   244  
   245      ! 組成に関わる配列の設定
   246      ! Settings of array for atmospheric composition
   247      !
   248      call CompositionInit
   249  
   250      ! 物理定数設定
   251      ! Physical constants settings
   252      !
   253      call ConstantsInit
   254  
   255      ! 座標データ設定
   256      ! Axes data settings
   257      !
   258      call AxessetInit
   259  
   260      ! 初期値データ (リスタートデータ) 提供
   261      ! Prepare initial data (restart data)
   262      !
   263      call InitDataInit
   264  
   265  
   266      ! 予報変数の割付
   267      ! Allocation of prediction variables
   268      !
   269      allocate( xyz_U    (0:imax-1, 1:jmax, 1:kmax) )
   270      allocate( xyz_V    (0:imax-1, 1:jmax, 1:kmax) )
   271      allocate( xyz_Temp (0:imax-1, 1:jmax, 1:kmax) )
   272      allocate( xyzf_QVap(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
   273      allocate( xy_Ps    (0:imax-1, 1:jmax) )
   274  
   275      ! ファイルから 1 次元プロファイルを読んで設定する.
   276      ! read 1-D profile from a file and set it
   277      !
   278      call Set1DProfileInit
   279  
   280      ! 初期値データ出力
   281      ! Initial data output
   282      !
   283      call RestartFileInit
   284      call RestartFileOpen( flag_init_data = .true. ) ! (in) optional
   285  
   286    end subroutine MainInit
   287  
   288    !-------------------------------------------------------------------
   289  
   290    subroutine MainTerminate
   291      !
   292      ! 主プログラムの終了処理手続き.
   293      !
   294      ! Termination procedure for the main program.
   295      !
   296  
   297      ! MPI
   298      !
   299      use mpi_wrapper, only : MPIWrapperFinalize
   300  
   301      ! 時刻管理
   302      ! Time control
   303      !
   304      use timeset, only: TimesetClose
   305  
   306      ! リスタートデータ入出力
   307      ! Restart data input/output
   308      !
   309      use restart_file_io, only: RestartFileClose
   310  
   311      ! 宣言文 ; Declaration statements
   312      !
   313      implicit none
   314  
   315      ! 実行文 ; Executable statement
   316      !
   317  
   318      ! リスタートデータファイルクローズ
   319      ! Close restart data input
   320      !
   321      call RestartFileClose
   322  
   323      ! 時刻管理終了処理
   324      ! Termination of time control
   325      !
   326      call TimesetClose
   327  
   328      ! 予報変数の割付解除
   329      ! Deallocation of prediction variables
   330      !
   331      deallocate( xyz_U     )
   332      deallocate( xyz_V     )
   333      deallocate( xyz_Temp  )
   334      deallocate( xyzf_QVap )
   335      deallocate( xy_Ps     )
   336  
   337      ! Finalize MPI
   338      !
   339      call MPIWrapperFinalize
   340  
   341  
   342    end subroutine MainTerminate
   343  
   344  end program dcpam_init_data
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:40:36 2016
FILE NAME: dcpam_init_data.f90
PROGRAM NAME: dcpam_init_data
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 初期値データファイル生成主プログラム
     2:             !
     3:             != dcpam main program for generation of initial data file
     4:             !
     5:             ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: dcpam_init_data.f90,v 1.1 2013/10/06 13:42:17 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             program dcpam_init_data
    13:               !
    14:               ! <b>Note that Japanese and English are described in parallel.</b>
    15:               !
    16:               ! 初期値データファイルを生成します. 
    17:               !
    18:               ! Initial data file is created. 
    19:               !
    20:             
    21:               ! モジュール引用 ; USE statements
    22:               !
    23:             
    24:               ! 組成に関わる配列の設定
    25:               ! Settings of array for atmospheric composition
    26:               !
    27:               use composition, only : &
    28:                 &                ncmax, & ! 成分の数
    29:                                           ! Number of composition
    30:                 &                IndexH2OVap
    31:                                           ! 水蒸気のインデックス
    32:                                           ! Index for water vapor
    33:             
    34:               ! 初期値データ (リスタートデータ) 提供
    35:               ! Prepare initial data (restart data)
    36:               !
    37:               use initial_data, only: SetInitData
    38:             
    39:               ! リスタートデータ入出力
    40:               ! Restart data input/output
    41:               !
    42:               use restart_file_io, only: InitialFileOutPut
    43:             
    44:               ! 種別型パラメタ
    45:               ! Kind type parameter
    46:               !
    47:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    48:                 &                 STRING, &  ! 文字列.       Strings. 
    49:                 &                 TOKEN      ! キーワード.   Keywords. 
    50:             
    51:               ! 宣言文 ; Declaration statements
    52:               !
    53:               implicit none
    54:             
    55:               ! 予報変数 (ステップ $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
    56:               ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
    57:               !
    58:               real(DP), allocatable:: xyz_U (:,:,:)
    59:                                           ! $ u $ .   東西風速. Eastward wind
    60:               real(DP), allocatable:: xyz_V (:,:,:)
    61:                                           ! $ v $ .   南北風速. Northward wind
    62:               real(DP), allocatable:: xyz_Temp (:,:,:)
    63:                                           ! $ T $ .   温度. Temperature
    64:               real(DP), allocatable:: xyzf_QVap (:,:,:,:)
    65:                                           ! $ q $ .   比湿. Specific humidity
    66:               real(DP), allocatable:: xy_Ps (:,:)
    67:                                           ! $ p_s $ . 地表面気圧. Surface pressure
    68:             
    69:               ! 作業変数
    70:               ! Work variables
    71:               !
    72:               integer :: n
    73:             
    74:             
    75:               ! 実行文 ; Executable statement
    76:               !
    77:             
    78:               ! 主プログラムの初期化 (内部サブルーチン)
    79:               ! Initialization for the main program (Internal subroutine)
    80:               !
    81:               call MainInit
    82:             
    83:               ! 初期値データの作成
    84:               ! Generate initial data
    85:               !
    86:               call SetInitData( &
    87:                 & xyz_U, xyz_V, xyz_Temp, xyzf_QVap, xy_Ps )  ! (out)
    88:             
    89:               ! 初期値データの出力
    90:               ! Output initial data
    91:               !
    92:               call InitialFileOutput( &
    93:                 & xyz_U, xyz_V, xyz_Temp, xyzf_QVap, xy_Ps )  ! (in)
    94:             
    95:               ! 主プログラムの終了処理 (内部サブルーチン)
    96:               ! Termination for the main program (Internal subroutine)
    97:               !
    98:               call MainTerminate
    99:             
   100:             contains
   101:             
   102:               !-------------------------------------------------------------------
   103:             
   104:               subroutine MainInit
   105:                 !
   106:                 ! 主プログラムの初期化手続き. 
   107:                 !
   108:                 ! Initialization procedure for the main program. 
   109:                 !
   110:             
   111:                 ! MPI
   112:                 !
   113:                 use mpi_wrapper, only : MPIWrapperInit
   114:             
   115:                 use dc_message, only: MessageNotify
   116:             
   117:                 ! コマンドライン引数処理
   118:                 ! Command line option parser
   119:                 !
   120:                 use option_parser, only: OptParseInit
   121:             
   122:                 ! NAMELIST ファイル入力に関するユーティリティ
   123:                 ! Utilities for NAMELIST file input
   124:                 !
   125:                 use namelist_util, only: NmlutilInit
   126:             
   127:                 ! 時刻管理
   128:                 ! Time control
   129:                 !
   130:                 use timeset, only: TimesetInit
   131:                                           ! ステップ $ t $ の時刻. Time of step $ t $. 
   132:             
   133:                 ! 出力ファイルの基本情報管理
   134:                 ! Management basic information for output files
   135:                 ! 
   136:                 use fileset, only: FilesetInit
   137:             
   138:                 ! 格子点設定
   139:                 ! Grid points settings
   140:                 !
   141:                 use gridset, only: GridsetInit, &
   142:                   &                imax, & ! 経度格子点数. 
   143:                                            ! Number of grid points in longitude
   144:                   &                jmax, & ! 緯度格子点数. 
   145:                                            ! Number of grid points in latitude
   146:                   &                kmax    ! 鉛直層数. 
   147:                                            ! Number of vertical level
   148:             
   149:                 ! 組成に関わる配列の設定
   150:                 ! Settings of array for atmospheric composition
   151:                 !
   152:                 use composition, only : &
   153:                   &                CompositionInit, &
   154:                   &                ncmax   ! 成分の数
   155:                                            ! Number of composition
   156:             
   157:                 ! 物理定数設定
   158:                 ! Physical constants settings
   159:                 !
   160:                 use constants, only: ConstantsInit
   161:             
   162:                 ! 座標データ設定
   163:                 ! Axes data settings
   164:                 !
   165:                 use axesset, only: AxessetInit
   166:             
   167:                 ! ファイルから 1 次元プロファイルを読んで設定する. 
   168:                 ! read 1-D profile from a file and set it 
   169:                 !
   170:                 use set_1d_profile, only : Set1DProfileInit
   171:             
   172:                 ! リスタートデータ入出力
   173:                 ! Restart data input/output
   174:                 !
   175:                 use restart_file_io, only: RestartFileInit, RestartFileOpen
   176:             
   177:                 ! 初期値データ (リスタートデータ) 提供
   178:                 ! Prepare initial data (restart data)
   179:                 !
   180:                 use initial_data, only: InitDataInit
   181:             
   182:             
   183:                 ! 宣言文 ; Declaration statements
   184:                 !
   185:                 implicit none
   186:                 character(*), parameter:: prog_name = 'dcpam_init_data'
   187:                                           ! 主プログラム名. 
   188:                                           ! Main program name
   189:                 character(*), parameter:: version = &
   190:                   & '$Name:  $' // &
   191:                   & '$Id: dcpam_init_data.f90,v 1.1 2013/10/06 13:42:17 yot Exp $'
   192:                                           ! 主プログラムのバージョン
   193:                                           ! Main program version
   194:                 character(STRING)      :: namelist_filename
   195:                                           ! NAMELIST ファイルの名称. 
   196:                                           ! NAMELIST file name
   197:             
   198:                 character(STRING):: brief
   199:                                           ! 実行ファイルの簡潔な説明
   200:                                           ! Brief account of executable file
   201:             
   202:                 ! 実行文 ; Executable statement
   203:                 !
   204:             
   205:                 ! Initialize MPI
   206:                 !
   207:                 call MPIWrapperInit
   208:             
   209:             
   210:                 brief = 'Initial data generation'
   211:                 call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
   212:                 call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )
   213:             
   214:                 ! コマンドライン引数処理
   215:                 ! Command line option parser
   216:                 !
   217:                 call OptParseInit(       &
   218:                   & namelist_filename,   & ! (out)
   219:                   & prog_name,           & ! (in )
   220:                   & brief                & ! (in )
   221:                   & )
   222:             
   223:                 ! NAMELIST ファイル名入力
   224:                 ! Input NAMELIST file name
   225:                 !
   226:                 call NmlutilInit( &
   227:                   & namelist_filename  & ! (in)
   228:                   & )
   229:             
   230:                 ! 時刻管理
   231:                 ! Time control
   232:                 !
   233:                 call TimesetInit
   234:             
   235:                 ! 出力ファイルの基本情報管理
   236:                 ! Management basic information for output files
   237:                 ! 
   238:                 call FilesetInit
   239:             
   240:                 ! 格子点設定
   241:                 ! Grid points settings
   242:                 !
   243:                 call GridsetInit
   244:             
   245:                 ! 組成に関わる配列の設定
   246:                 ! Settings of array for atmospheric composition
   247:                 !
   248:                 call CompositionInit
   249:             
   250:                 ! 物理定数設定
   251:                 ! Physical constants settings
   252:                 !
   253:                 call ConstantsInit
   254:             
   255:                 ! 座標データ設定
   256:                 ! Axes data settings
   257:                 !
   258:                 call AxessetInit
   259:             
   260:                 ! 初期値データ (リスタートデータ) 提供
   261:                 ! Prepare initial data (restart data)
   262:                 !
   263:                 call InitDataInit
   264:             
   265:             
   266:                 ! 予報変数の割付
   267:                 ! Allocation of prediction variables
   268:                 !
   269:                 allocate( xyz_U    (0:imax-1, 1:jmax, 1:kmax) )
   270:                 allocate( xyz_V    (0:imax-1, 1:jmax, 1:kmax) )
   271:                 allocate( xyz_Temp (0:imax-1, 1:jmax, 1:kmax) )
   272:                 allocate( xyzf_QVap(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
   273:                 allocate( xy_Ps    (0:imax-1, 1:jmax) )
   274:             
   275:                 ! ファイルから 1 次元プロファイルを読んで設定する. 
   276:                 ! read 1-D profile from a file and set it 
   277:                 !
   278:                 call Set1DProfileInit
   279:             
   280:                 ! 初期値データ出力
   281:                 ! Initial data output
   282:                 !
   283:                 call RestartFileInit
   284:                 call RestartFileOpen( flag_init_data = .true. ) ! (in) optional
   285:             
   286:               end subroutine MainInit
   287:             
   288:               !-------------------------------------------------------------------
   289:             
   290:               subroutine MainTerminate
   291:                 !
   292:                 ! 主プログラムの終了処理手続き. 
   293:                 !
   294:                 ! Termination procedure for the main program. 
   295:                 !
   296:             
   297:                 ! MPI
   298:                 !
   299:                 use mpi_wrapper, only : MPIWrapperFinalize
   300:             
   301:                 ! 時刻管理
   302:                 ! Time control
   303:                 !
   304:                 use timeset, only: TimesetClose
   305:             
   306:                 ! リスタートデータ入出力
   307:                 ! Restart data input/output
   308:                 !
   309:                 use restart_file_io, only: RestartFileClose
   310:             
   311:                 ! 宣言文 ; Declaration statements
   312:                 !
   313:                 implicit none
   314:             
   315:                 ! 実行文 ; Executable statement
   316:                 !
   317:             
   318:                 ! リスタートデータファイルクローズ
   319:                 ! Close restart data input
   320:                 !
   321:                 call RestartFileClose
   322:             
   323:                 ! 時刻管理終了処理
   324:                 ! Termination of time control
   325:                 !
   326:                 call TimesetClose
   327:             
   328:                 ! 予報変数の割付解除
   329:                 ! Deallocation of prediction variables
   330:                 !
   331:                 deallocate( xyz_U     )
   332:                 deallocate( xyz_V     )
   333:                 deallocate( xyz_Temp  )
   334:                 deallocate( xyzf_QVap )
   335:                 deallocate( xy_Ps     )
   336:             
   337:                 ! Finalize MPI
   338:                 !
   339:                 call MPIWrapperFinalize
   340:             
   341:             
   342:               end subroutine MainTerminate
   343:             
   344:             end program dcpam_init_data
