Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:40:36 2016
FILE NAME: dcpam_init_data_surface.f90
PROGRAM NAME: dcpam_init_data_surface
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   117  vec  (   3): Unvectorized loop.
   117  vec  (  13): Overhead of loop division is too large.
   118  opt  (1593): Loop nest collapsed into one loop.
   118  vec  (   4): Vectorized array expression.
   118  vec  (  29): ADB is used for array.: xyz_soiltemp
   118  vec  (  29): ADB is used for array.: xy_surftemp
   120  vec  (   3): Unvectorized loop.
   120  vec  (  13): Overhead of loop division is too large.
   121  opt  (1593): Loop nest collapsed into one loop.
   121  vec  (   4): Vectorized array expression.
   121  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   121  vec  (  29): ADB is used for array.: xy_surftemp
   130  opt  (1593): Loop nest collapsed into one loop.
   130  vec  (   4): Vectorized array expression.
   130  vec  (  29): ADB is used for array.: xy_surfmajcompicen
   130  vec  (  29): ADB is used for array.: xy_surfmajcompiceb
   131  opt  (1593): Loop nest collapsed into one loop.
   131  vec  (   4): Vectorized array expression.
   131  vec  (  29): ADB is used for array.: xy_soilmoistn
   131  vec  (  29): ADB is used for array.: xy_soilmoistb
   132  opt  (1593): Loop nest collapsed into one loop.
   132  vec  (   4): Vectorized array expression.
   132  vec  (  29): ADB is used for array.: xy_surfsnown
   132  vec  (  29): ADB is used for array.: xy_surfsnowb
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:40:36 2016
FILE NAME: dcpam_init_data_surface.f90
PROGRAM NAME: dcpam_init_data_surface
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地表面データ生成主プログラム
     2  !
     3  != dcpam main program for generation of surface data
     4  !
     5  ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: dcpam_init_data_surface.f90,v 1.1 2013/10/06 13:42:17 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  program dcpam_init_data_surface
    13    !
    14    ! <b>Note that Japanese and English are described in parallel.</b>
    15    !
    16    ! 地表面データファイルを生成します.
    17    !
    18    ! Surface data file is created.
    19    !
    20  
    21    ! モジュール引用 ; USE statements
    22    !
    23  
    24    ! 格子点設定
    25    ! Grid points settings
    26    !
    27    use gridset, only:       &
    28      &                imax, & ! 経度格子点数.
    29                               ! Number of grid points in longitude
    30      &                jmax, & ! 緯度格子点数.
    31                               ! Number of grid points in latitude
    32      &                kslmax, & ! 地下の鉛直層数.
    33                                 ! Number of subsurface vertical level
    34      &                ksimax  ! 海氷の鉛直層数.
    35                               ! Number of sea ice vertical level
    36  
    37    ! 地表面データ提供
    38    ! Prepare surface data
    39    !
    40    use surface_data, only: SetSurfData
    41  
    42    !
    43    ! Prepare initial surface data
    44    !
    45    use initial_surface_data, only: SetInitSurfaceData
    46  
    47    ! 地表面温度リスタートデータ入出力
    48    ! Restart data of surface temperature input/output
    49    !
    50    use restart_surftemp_io, only: RestartSurfTempOutput
    51  
    52    ! 種別型パラメタ
    53    ! Kind type parameter
    54    !
    55    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    56      &                 STRING, &  ! 文字列.       Strings.
    57      &                 TOKEN      ! キーワード.   Keywords.
    58  
    59    ! 宣言文 ; Declaration statements
    60    !
    61    implicit none
    62  
    63    ! 変数
    64    ! Variables
    65    !
    66    real(DP), allocatable:: xy_SurfTemp (:,:)
    67                              ! 地表面温度.
    68                              ! Surface temperature
    69    real(DP), allocatable:: xyz_SoilTemp (:,:,:)
    70                              ! 土壌温度.
    71                              ! Soil temperature
    72    real(DP), allocatable:: xyz_SOSeaIceTemp (:,:,:)
    73                              ! 海氷温度.
    74                              ! Sea ice temperature
    75    real(DP), allocatable:: xy_SOSeaIceMass(:,:)
    76                              !
    77                              ! slab sea ice mass
    78    real(DP), allocatable:: xy_SurfMajCompIceB(:,:)
    79                              !
    80                              ! surface major component ice at previous time step
    81    real(DP), allocatable:: xy_SurfMajCompIceN(:,:)
    82                              !
    83                              ! surface major component ice at present time step
    84    real(DP), allocatable:: xy_SoilMoistB(:,:)
    85                              !
    86                              ! soil moisture at previous time step
    87    real(DP), allocatable:: xy_SoilMoistN(:,:)
    88                              !
    89                              ! soil moisture at present time step
    90    real(DP), allocatable:: xy_SurfSnowB(:,:)
    91                              !
    92                              ! surface snow amount at previous time step
    93    real(DP), allocatable:: xy_SurfSnowN(:,:)
    94                              !
    95                              ! surface snow amount at present time step
    96  
    97  
    98    ! 作業変数
    99    ! Work variables
   100    !
   101    integer :: k
   102  
   103  
   104    ! 実行文 ; Executable statement
   105    !
   106  
   107    ! 主プログラムの初期化 (内部サブルーチン)
   108    ! Initialization for the main program (Internal subroutine)
   109    !
   110    call MainInit
   111  
   112    ! 地表面データの作成
   113    ! Generate surface data
   114    !
   115    call SetSurfData( xy_SurfTemp = xy_SurfTemp )  ! (out) optional
   116  
   117    do k = 1, kslmax
   118      xyz_SoilTemp(:,:,k) = xy_SurfTemp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surftemp)                                               
     .        do t201 = 1, (xyz_soiltemp.DSC.U2 + 1 - xyz_soiltemp.DSC.L2)*(    
     .       1   xyz_soiltemp.DSC.U1 + 1 - xyz_soiltemp.DSC.L1)                 
     .           xyz_soiltemp(xyz_soiltemp.DSC.L1+t201-1,xyz_soiltemp.DSC.L2,k) 
     .       1       = xy_surftemp(t33+t201-1,t35)                              
     .        enddo                                                             
   119    end do
   120    do k = 1, ksimax
   121      xyz_SOSeaIceTemp(:,:,k) = xy_SurfTemp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surftemp)                                               
     .        do t209 = 1, (xyz_soseaicetemp.DSC.U2 + 1 -                       
     .       1   xyz_soseaicetemp.DSC.L2)*(xyz_soseaicetemp.DSC.U1 + 1 -        
     .       2   xyz_soseaicetemp.DSC.L1)                                       
     .           xyz_soseaicetemp(xyz_soseaicetemp.DSC.L1+t209-1,               
     .       1      xyz_soseaicetemp.DSC.L2,k) = xy_surftemp(t33+t209-1,t35)    
     .        enddo                                                             
   122    end do
   123  
   124    !
   125    != Prepare initial surface data
   126    !
   127    call SetInitSurfaceData(                                              &
   128      & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, xy_SOSeaIceMass  & ! (out)
   129      & )
   130    xy_SurfMajCompIceN = xy_SurfMajCompIceB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t217 = 1, (xy_surfmajcompicen.DSC.U2 + 1 -                     
     .       1   xy_surfmajcompicen.DSC.L2)*(xy_surfmajcompicen.DSC.U1 + 1 -    
     .       2   xy_surfmajcompicen.DSC.L1)                                     
     .           xy_surfmajcompicen(xy_surfmajcompicen.DSC.L1+t217-1,           
     .       1      xy_surfmajcompicen.DSC.L2) = xy_surfmajcompiceb(            
     .       2      xy_surfmajcompiceb.DSC.L1+t217-1,xy_surfmajcompiceb.DSC.L2) 
     .        enddo                                                             
   131    xy_SoilMoistN      = xy_SoilMoistB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t225 = 1, (xy_soilmoistn.DSC.U2 + 1 - xy_soilmoistn.DSC.L2)*(  
     .       1   xy_soilmoistn.DSC.U1 + 1 - xy_soilmoistn.DSC.L1)               
     .           xy_soilmoistn(xy_soilmoistn.DSC.L1+t225-1,xy_soilmoistn.DSC.L2)
     .       1       = xy_soilmoistb(xy_soilmoistb.DSC.L1+t225-1,               
     .       2      xy_soilmoistb.DSC.L2)                                       
     .        enddo                                                             
   132    xy_SurfSnowN       = xy_SurfSnowB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t233 = 1, (xy_surfsnown.DSC.U2 + 1 - xy_surfsnown.DSC.L2)*(    
     .       1   xy_surfsnown.DSC.U1 + 1 - xy_surfsnown.DSC.L1)                 
     .           xy_surfsnown(xy_surfsnown.DSC.L1+t233-1,xy_surfsnown.DSC.L2) = 
     .       1      xy_surfsnowb(xy_surfsnowb.DSC.L1+t233-1,xy_surfsnowb.DSC.L2)
     .        enddo                                                             
   133  
   134  
   135    ! 地表面温度リスタートデータ出力
   136    ! Restart data of surface temperature output
   137    !
   138    call RestartSurfTempOutput(                          &
   139      & xy_SurfTemp,                                     & ! (in)
   140      & xyz_SoilTemp,                                    & ! (in) optional
   141      & xyz_SOSeaIceTemp, xy_SOSeaIceMass,               & ! (in) optional
   142      & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in) optional
   143      & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN  & ! (in) optional
   144      & )
   145  
   146  
   147    ! 主プログラムの終了処理 (内部サブルーチン)
   148    ! Termination for the main program (Internal subroutine)
   149    !
   150    call MainTerminate
   151  
   152  contains
   153  
   154    !-------------------------------------------------------------------
   155  
   156    subroutine MainInit
   157      !
   158      ! 主プログラムの初期化手続き.
   159      !
   160      ! Initialization procedure for the main program.
   161      !
   162  
   163      ! MPI
   164      !
   165      use mpi_wrapper, only : MPIWrapperInit
   166  
   167      use dc_message, only: MessageNotify
   168  
   169      ! コマンドライン引数処理
   170      ! Command line option parser
   171      !
   172      use option_parser, only: OptParseInit
   173  
   174      ! NAMELIST ファイル入力に関するユーティリティ
   175      ! Utilities for NAMELIST file input
   176      !
   177      use namelist_util, only: NmlutilInit
   178  
   179      ! 時刻管理
   180      ! Time control
   181      !
   182      use timeset, only: TimesetInit
   183                                ! ステップ $ t $ の時刻. Time of step $ t $.
   184  
   185      ! 出力ファイルの基本情報管理
   186      ! Management basic information for output files
   187      !
   188      use fileset, only: FilesetInit
   189  
   190      ! 格子点設定
   191      ! Grid points settings
   192      !
   193      use gridset, only: GridsetInit, &
   194        &                imax, & ! 経度格子点数.
   195                                 ! Number of grid points in longitude
   196        &                jmax, & ! 緯度格子点数.
   197                                 ! Number of grid points in latitude
   198        &                kslmax, & ! 地下の鉛直層数.
   199                                   ! Number of subsurface vertical level
   200        &                ksimax  ! 海氷の鉛直層数.
   201                                 ! Number of sea ice vertical level
   202  
   203      ! 物理定数設定
   204      ! Physical constants settings
   205      !
   206      use constants, only: ConstantsInit
   207  
   208      ! 座標データ設定
   209      ! Axes data settings
   210      !
   211      use axesset, only: AxessetInit
   212  
   213      ! 地表面温度リスタートデータ入出力
   214      ! Restart data of surface temperature input/output
   215      !
   216      use restart_surftemp_io, only: RestartSurfTempInit, RestartSurfTempOpen
   217  
   218      ! 地表面データ提供
   219      ! Prepare surface data
   220      !
   221      use surface_data, only : SurfDataInit
   222  
   223      !
   224      ! Prepare initial surface data
   225      !
   226      use initial_surface_data, only: InitSurfaceDataInit
   227  
   228  
   229      ! 宣言文 ; Declaration statements
   230      !
   231      implicit none
   232      character(*), parameter:: prog_name = 'dcpam_init_data_surface'
   233                                ! 主プログラム名.
   234                                ! Main program name
   235      character(*), parameter:: version = &
   236        & '$Name:  $' // &
   237        & '$Id: dcpam_init_data_surface.f90,v 1.1 2013/10/06 13:42:17 yot Exp $'
   238                                ! 主プログラムのバージョン
   239                                ! Main program version
   240      character(STRING)      :: namelist_filename
   241                                ! NAMELIST ファイルの名称.
   242                                ! NAMELIST file name
   243  
   244      character(STRING):: brief
   245                                ! 実行ファイルの簡潔な説明
   246                                ! Brief account of executable file
   247  
   248      ! 実行文 ; Executable statement
   249      !
   250  
   251      ! Initialize MPI
   252      !
   253      call MPIWrapperInit
   254  
   255      brief = 'SST data generation'
   256      call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
   257      call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )
   258  
   259      ! コマンドライン引数処理
   260      ! Command line option parser
   261      !
   262      call OptParseInit(       &
   263        & namelist_filename,   & ! (out)
   264        & prog_name,           & ! (in )
   265        & brief                & ! (in )
   266        & )
   267  
   268      ! NAMELIST ファイル名入力
   269      ! Input NAMELIST file name
   270      !
   271      call NmlutilInit( &
   272        & namelist_filename  & ! (in)
   273        & )
   274  
   275      ! 時刻管理
   276      ! Time control
   277      !
   278      call TimesetInit
   279  
   280      ! 出力ファイルの基本情報管理
   281      ! Management basic information for output files
   282      !
   283      call FilesetInit
   284  
   285      ! 格子点設定
   286      ! Grid points settings
   287      !
   288      call GridsetInit
   289  
   290      ! 物理定数設定
   291      ! Physical constants settings
   292      !
   293      call ConstantsInit
   294  
   295      ! 座標データ設定
   296      ! Axes data settings
   297      !
   298      call AxessetInit
   299  
   300      ! 地表面データ提供
   301      ! Prepare surface data
   302      !
   303      call SurfDataInit
   304  
   305      !
   306      ! Prepare initial surface data
   307      !
   308      call InitSurfaceDataInit
   309  
   310  
   311      ! 地表面温度変数の割付
   312      ! Allocation of a variable of surface temperature
   313      !
   314      allocate( xy_SurfTemp       (0:imax-1, 1:jmax) )
   315      allocate( xyz_SoilTemp      (0:imax-1, 1:jmax, 1:kslmax) )
   316      allocate( xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 1:ksimax) )
   317      allocate( xy_SurfMajCompIceB(0:imax-1, 1:jmax) )
   318      allocate( xy_SurfMajCompIceN(0:imax-1, 1:jmax) )
   319      allocate( xy_SoilMoistB     (0:imax-1, 1:jmax) )
   320      allocate( xy_SoilMoistN     (0:imax-1, 1:jmax) )
   321      allocate( xy_SurfSnowB      (0:imax-1, 1:jmax) )
   322      allocate( xy_SurfSnowN      (0:imax-1, 1:jmax) )
   323      allocate( xy_SOSeaIceMass   (0:imax-1, 1:jmax) )
   324  
   325      ! 地表面温度リスタートデータファイルの初期化
   326      ! Initialization of restart data file of surface temperature
   327      !
   328      call RestartSurfTempInit
   329      call RestartSurfTempOpen( flag_init_data = .true. ) ! (in) optional
   330  
   331    end subroutine MainInit
   332  
   333    !-------------------------------------------------------------------
   334  
   335    subroutine MainTerminate
   336      !
   337      ! 主プログラムの終了処理手続き.
   338      !
   339      ! Termination procedure for the main program.
   340      !
   341  
   342      ! MPI
   343      !
   344      use mpi_wrapper, only : MPIWrapperFinalize
   345  
   346      ! 時刻管理
   347      ! Time control
   348      !
   349      use timeset, only: TimesetClose
   350  
   351      ! 地表面温度リスタートデータ入出力
   352      ! Restart data of surface temperature input/output
   353      !
   354      use restart_surftemp_io, only: RestartSurfTempClose
   355  
   356      ! ヒストリデータ出力
   357      ! History data output
   358      !
   359      use history_file_io, only: HistoryFileClose
   360  
   361      ! 宣言文 ; Declaration statements
   362      !
   363      implicit none
   364  
   365      ! 実行文 ; Executable statement
   366      !
   367  
   368      ! 地表面温度リスタートデータファイルクローズ
   369      ! Close restart data file of surface temperature
   370      !
   371      call RestartSurfTempClose
   372  
   373      ! 時刻管理終了処理
   374      ! Termination of time control
   375      !
   376      call TimesetClose
   377  
   378      ! 地表面温度変数の割付解除
   379      ! Deallocation of a variable of surface temperature
   380      !
   381      deallocate( xy_SurfTemp )
   382  
   383      ! Finalize MPI
   384      !
   385      call MPIWrapperFinalize
   386  
   387    end subroutine MainTerminate
   388  
   389  end program dcpam_init_data_surface
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:40:36 2016
FILE NAME: dcpam_init_data_surface.f90
PROGRAM NAME: dcpam_init_data_surface
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地表面データ生成主プログラム
     2:             !
     3:             != dcpam main program for generation of surface data
     4:             !
     5:             ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: dcpam_init_data_surface.f90,v 1.1 2013/10/06 13:42:17 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             program dcpam_init_data_surface
    13:               !
    14:               ! <b>Note that Japanese and English are described in parallel.</b>
    15:               !
    16:               ! 地表面データファイルを生成します. 
    17:               !
    18:               ! Surface data file is created. 
    19:               !
    20:             
    21:               ! モジュール引用 ; USE statements
    22:               !
    23:             
    24:               ! 格子点設定
    25:               ! Grid points settings
    26:               !
    27:               use gridset, only:       &
    28:                 &                imax, & ! 経度格子点数. 
    29:                                          ! Number of grid points in longitude
    30:                 &                jmax, & ! 緯度格子点数. 
    31:                                          ! Number of grid points in latitude
    32:                 &                kslmax, & ! 地下の鉛直層数.
    33:                                            ! Number of subsurface vertical level
    34:                 &                ksimax  ! 海氷の鉛直層数.
    35:                                          ! Number of sea ice vertical level
    36:             
    37:               ! 地表面データ提供
    38:               ! Prepare surface data
    39:               !
    40:               use surface_data, only: SetSurfData
    41:             
    42:               !
    43:               ! Prepare initial surface data
    44:               !
    45:               use initial_surface_data, only: SetInitSurfaceData
    46:             
    47:               ! 地表面温度リスタートデータ入出力
    48:               ! Restart data of surface temperature input/output
    49:               !
    50:               use restart_surftemp_io, only: RestartSurfTempOutput
    51:             
    52:               ! 種別型パラメタ
    53:               ! Kind type parameter
    54:               !
    55:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    56:                 &                 STRING, &  ! 文字列.       Strings. 
    57:                 &                 TOKEN      ! キーワード.   Keywords. 
    58:             
    59:               ! 宣言文 ; Declaration statements
    60:               !
    61:               implicit none
    62:             
    63:               ! 変数
    64:               ! Variables
    65:               !
    66:               real(DP), allocatable:: xy_SurfTemp (:,:)
    67:                                         ! 地表面温度. 
    68:                                         ! Surface temperature
    69:               real(DP), allocatable:: xyz_SoilTemp (:,:,:)
    70:                                         ! 土壌温度. 
    71:                                         ! Soil temperature
    72:               real(DP), allocatable:: xyz_SOSeaIceTemp (:,:,:)
    73:                                         ! 海氷温度. 
    74:                                         ! Sea ice temperature
    75:               real(DP), allocatable:: xy_SOSeaIceMass(:,:)
    76:                                         ! 
    77:                                         ! slab sea ice mass
    78:               real(DP), allocatable:: xy_SurfMajCompIceB(:,:)
    79:                                         ! 
    80:                                         ! surface major component ice at previous time step
    81:               real(DP), allocatable:: xy_SurfMajCompIceN(:,:)
    82:                                         ! 
    83:                                         ! surface major component ice at present time step
    84:               real(DP), allocatable:: xy_SoilMoistB(:,:)
    85:                                         ! 
    86:                                         ! soil moisture at previous time step
    87:               real(DP), allocatable:: xy_SoilMoistN(:,:)
    88:                                         ! 
    89:                                         ! soil moisture at present time step
    90:               real(DP), allocatable:: xy_SurfSnowB(:,:)
    91:                                         ! 
    92:                                         ! surface snow amount at previous time step
    93:               real(DP), allocatable:: xy_SurfSnowN(:,:)
    94:                                         ! 
    95:                                         ! surface snow amount at present time step
    96:             
    97:             
    98:               ! 作業変数
    99:               ! Work variables
   100:               !
   101:               integer :: k
   102:             
   103:             
   104:               ! 実行文 ; Executable statement
   105:               !
   106:             
   107:               ! 主プログラムの初期化 (内部サブルーチン)
   108:               ! Initialization for the main program (Internal subroutine)
   109:               !
   110:               call MainInit
   111:             
   112:               ! 地表面データの作成
   113:               ! Generate surface data
   114:               !
   115:               call SetSurfData( xy_SurfTemp = xy_SurfTemp )  ! (out) optional
   116:             
   117: +------>      do k = 1, kslmax
   118: |W*==== A       xyz_SoilTemp(:,:,k) = xy_SurfTemp
   119: +------       end do
   120: +------>      do k = 1, ksimax
   121: |W*==== A       xyz_SOSeaIceTemp(:,:,k) = xy_SurfTemp
   122: +------       end do
   123:             
   124:               !
   125:               != Prepare initial surface data
   126:               !
   127:               call SetInitSurfaceData(                                              &
   128:                 & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, xy_SOSeaIceMass  & ! (out)
   129:                 & )
   130: W*===== A     xy_SurfMajCompIceN = xy_SurfMajCompIceB
   131: W*===== A     xy_SoilMoistN      = xy_SoilMoistB
   132: W*===== A     xy_SurfSnowN       = xy_SurfSnowB
   133:             
   134:             
   135:               ! 地表面温度リスタートデータ出力
   136:               ! Restart data of surface temperature output
   137:               !
   138:               call RestartSurfTempOutput(                          &
   139:                 & xy_SurfTemp,                                     & ! (in)
   140:                 & xyz_SoilTemp,                                    & ! (in) optional
   141:                 & xyz_SOSeaIceTemp, xy_SOSeaIceMass,               & ! (in) optional
   142:                 & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in) optional
   143:                 & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN  & ! (in) optional
   144:                 & )
   145:             
   146:             
   147:               ! 主プログラムの終了処理 (内部サブルーチン)
   148:               ! Termination for the main program (Internal subroutine)
   149:               !
   150:               call MainTerminate
   151:             
   152:             contains
   153:             
   154:               !-------------------------------------------------------------------
   155:             
   156:               subroutine MainInit
   157:                 !
   158:                 ! 主プログラムの初期化手続き. 
   159:                 !
   160:                 ! Initialization procedure for the main program. 
   161:                 !
   162:             
   163:                 ! MPI
   164:                 !
   165:                 use mpi_wrapper, only : MPIWrapperInit
   166:             
   167:                 use dc_message, only: MessageNotify
   168:             
   169:                 ! コマンドライン引数処理
   170:                 ! Command line option parser
   171:                 !
   172:                 use option_parser, only: OptParseInit
   173:             
   174:                 ! NAMELIST ファイル入力に関するユーティリティ
   175:                 ! Utilities for NAMELIST file input
   176:                 !
   177:                 use namelist_util, only: NmlutilInit
   178:             
   179:                 ! 時刻管理
   180:                 ! Time control
   181:                 !
   182:                 use timeset, only: TimesetInit
   183:                                           ! ステップ $ t $ の時刻. Time of step $ t $. 
   184:             
   185:                 ! 出力ファイルの基本情報管理
   186:                 ! Management basic information for output files
   187:                 ! 
   188:                 use fileset, only: FilesetInit
   189:             
   190:                 ! 格子点設定
   191:                 ! Grid points settings
   192:                 !
   193:                 use gridset, only: GridsetInit, &
   194:                   &                imax, & ! 経度格子点数. 
   195:                                            ! Number of grid points in longitude
   196:                   &                jmax, & ! 緯度格子点数. 
   197:                                            ! Number of grid points in latitude
   198:                   &                kslmax, & ! 地下の鉛直層数.
   199:                                              ! Number of subsurface vertical level
   200:                   &                ksimax  ! 海氷の鉛直層数.
   201:                                            ! Number of sea ice vertical level
   202:             
   203:                 ! 物理定数設定
   204:                 ! Physical constants settings
   205:                 !
   206:                 use constants, only: ConstantsInit
   207:             
   208:                 ! 座標データ設定
   209:                 ! Axes data settings
   210:                 !
   211:                 use axesset, only: AxessetInit
   212:             
   213:                 ! 地表面温度リスタートデータ入出力
   214:                 ! Restart data of surface temperature input/output
   215:                 !
   216:                 use restart_surftemp_io, only: RestartSurfTempInit, RestartSurfTempOpen
   217:             
   218:                 ! 地表面データ提供
   219:                 ! Prepare surface data
   220:                 !
   221:                 use surface_data, only : SurfDataInit
   222:             
   223:                 !
   224:                 ! Prepare initial surface data
   225:                 !
   226:                 use initial_surface_data, only: InitSurfaceDataInit
   227:             
   228:             
   229:                 ! 宣言文 ; Declaration statements
   230:                 !
   231:                 implicit none
   232:                 character(*), parameter:: prog_name = 'dcpam_init_data_surface'
   233:                                           ! 主プログラム名. 
   234:                                           ! Main program name
   235:                 character(*), parameter:: version = &
   236:                   & '$Name:  $' // &
   237:                   & '$Id: dcpam_init_data_surface.f90,v 1.1 2013/10/06 13:42:17 yot Exp $'
   238:                                           ! 主プログラムのバージョン
   239:                                           ! Main program version
   240:                 character(STRING)      :: namelist_filename
   241:                                           ! NAMELIST ファイルの名称. 
   242:                                           ! NAMELIST file name
   243:             
   244:                 character(STRING):: brief
   245:                                           ! 実行ファイルの簡潔な説明
   246:                                           ! Brief account of executable file
   247:             
   248:                 ! 実行文 ; Executable statement
   249:                 !
   250:             
   251:                 ! Initialize MPI
   252:                 !
   253:                 call MPIWrapperInit
   254:             
   255:                 brief = 'SST data generation'
   256:                 call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
   257:                 call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )
   258:             
   259:                 ! コマンドライン引数処理
   260:                 ! Command line option parser
   261:                 !
   262:                 call OptParseInit(       &
   263:                   & namelist_filename,   & ! (out)
   264:                   & prog_name,           & ! (in )
   265:                   & brief                & ! (in )
   266:                   & )
   267:             
   268:                 ! NAMELIST ファイル名入力
   269:                 ! Input NAMELIST file name
   270:                 !
   271:                 call NmlutilInit( &
   272:                   & namelist_filename  & ! (in)
   273:                   & )
   274:             
   275:                 ! 時刻管理
   276:                 ! Time control
   277:                 !
   278:                 call TimesetInit
   279:             
   280:                 ! 出力ファイルの基本情報管理
   281:                 ! Management basic information for output files
   282:                 ! 
   283:                 call FilesetInit
   284:             
   285:                 ! 格子点設定
   286:                 ! Grid points settings
   287:                 !
   288:                 call GridsetInit
   289:             
   290:                 ! 物理定数設定
   291:                 ! Physical constants settings
   292:                 !
   293:                 call ConstantsInit
   294:             
   295:                 ! 座標データ設定
   296:                 ! Axes data settings
   297:                 !
   298:                 call AxessetInit
   299:             
   300:                 ! 地表面データ提供
   301:                 ! Prepare surface data
   302:                 !
   303:                 call SurfDataInit
   304:             
   305:                 !
   306:                 ! Prepare initial surface data
   307:                 !
   308:                 call InitSurfaceDataInit
   309:             
   310:             
   311:                 ! 地表面温度変数の割付
   312:                 ! Allocation of a variable of surface temperature
   313:                 !
   314:                 allocate( xy_SurfTemp       (0:imax-1, 1:jmax) )
   315:                 allocate( xyz_SoilTemp      (0:imax-1, 1:jmax, 1:kslmax) )
   316:                 allocate( xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 1:ksimax) )
   317:                 allocate( xy_SurfMajCompIceB(0:imax-1, 1:jmax) )
   318:                 allocate( xy_SurfMajCompIceN(0:imax-1, 1:jmax) )
   319:                 allocate( xy_SoilMoistB     (0:imax-1, 1:jmax) )
   320:                 allocate( xy_SoilMoistN     (0:imax-1, 1:jmax) )
   321:                 allocate( xy_SurfSnowB      (0:imax-1, 1:jmax) )
   322:                 allocate( xy_SurfSnowN      (0:imax-1, 1:jmax) )
   323:                 allocate( xy_SOSeaIceMass   (0:imax-1, 1:jmax) )
   324:             
   325:                 ! 地表面温度リスタートデータファイルの初期化
   326:                 ! Initialization of restart data file of surface temperature
   327:                 !
   328:                 call RestartSurfTempInit
   329:                 call RestartSurfTempOpen( flag_init_data = .true. ) ! (in) optional
   330:             
   331:               end subroutine MainInit
   332:             
   333:               !-------------------------------------------------------------------
   334:             
   335:               subroutine MainTerminate
   336:                 !
   337:                 ! 主プログラムの終了処理手続き. 
   338:                 !
   339:                 ! Termination procedure for the main program. 
   340:                 !
   341:             
   342:                 ! MPI
   343:                 !
   344:                 use mpi_wrapper, only : MPIWrapperFinalize
   345:             
   346:                 ! 時刻管理
   347:                 ! Time control
   348:                 !
   349:                 use timeset, only: TimesetClose
   350:             
   351:                 ! 地表面温度リスタートデータ入出力
   352:                 ! Restart data of surface temperature input/output
   353:                 !
   354:                 use restart_surftemp_io, only: RestartSurfTempClose
   355:             
   356:                 ! ヒストリデータ出力
   357:                 ! History data output
   358:                 !
   359:                 use history_file_io, only: HistoryFileClose
   360:             
   361:                 ! 宣言文 ; Declaration statements
   362:                 !
   363:                 implicit none
   364:             
   365:                 ! 実行文 ; Executable statement
   366:                 !
   367:             
   368:                 ! 地表面温度リスタートデータファイルクローズ
   369:                 ! Close restart data file of surface temperature
   370:                 !
   371:                 call RestartSurfTempClose
   372:             
   373:                 ! 時刻管理終了処理
   374:                 ! Termination of time control
   375:                 !
   376:                 call TimesetClose
   377:             
   378:                 ! 地表面温度変数の割付解除
   379:                 ! Deallocation of a variable of surface temperature
   380:                 !
   381:                 deallocate( xy_SurfTemp )
   382:             
   383:                 ! Finalize MPI
   384:                 !
   385:                 call MPIWrapperFinalize
   386:             
   387:               end subroutine MainTerminate
   388:             
   389:             end program dcpam_init_data_surface
