Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:02 2016
FILE NAME: phy_implicit.f90
PROGRAM NAME: phy_implicit
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   359  opt  (  11): Fused array assignments. :line 359 - 364
   359  opt  (1593): Loop nest collapsed into one loop.
   359  vec  (   4): Vectorized array expression.
   366  opt  (1593): Loop nest collapsed into one loop.
   366  vec  (   1): Vectorized loop.
   366  vec  (  29): ADB is used for array.: xyr_qmixdiffcoef
   366  vec  (  29): ADB is used for array.: xyr_tempdiffcoef
   366  vec  (  29): ADB is used for array.: xyz_height
   366  vec  (  29): ADB is used for array.: xyr_virtemp
   366  vec  (  29): ADB is used for array.: xyr_press
   366  vec  (  29): ADB is used for array.: xyr_veldiffcoef
   367  opt  (  11): Fused array assignments. :line 367 - 377
   391  opt  (  11): Fused array assignments. :line 391 - 396
   391  opt  (1593): Loop nest collapsed into one loop.
   391  vec  (   4): Vectorized array expression.
   391  vec  (  29): ADB is used for array.: xyr_press
   391  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   399  opt  (1593): Loop nest collapsed into one loop.
   399  vec  (   1): Vectorized loop.
   399  vec  (  29): ADB is used for array.: xyr_press
   400  opt  (  11): Fused array assignments. :line 400 - 406
   411  opt  (  11): Fused array assignments. :line 411 - 416
   411  opt  (1593): Loop nest collapsed into one loop.
   411  vec  (   4): Vectorized array expression.
   411  vec  (  29): ADB is used for array.: xyr_press
   423  opt  (  11): Fused array assignments. :line 423 - 429
   423  opt  (1593): Loop nest collapsed into one loop.
   423  vec  (   4): Vectorized array expression.
   423  vec  (  29): ADB is used for array.: xyz_exner
   423  vec  (  29): ADB is used for array.: xyr_press
   423  vec  (  29): ADB is used for array.: xyr_exner
   423  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   432  opt  (1593): Loop nest collapsed into one loop.
   432  vec  (   1): Vectorized loop.
   432  vec  (  29): ADB is used for array.: xyr_press
   432  vec  (  29): ADB is used for array.: xyr_exner
   432  vec  (  29): ADB is used for array.: xyz_exner
   433  opt  (  11): Fused array assignments. :line 433 - 439
   444  opt  (  11): Fused array assignments. :line 444 - 449
   444  opt  (1593): Loop nest collapsed into one loop.
   444  vec  (   4): Vectorized array expression.
   444  vec  (  29): ADB is used for array.: xyr_press
   444  vec  (  29): ADB is used for array.: xyz_exner
   444  vec  (  29): ADB is used for array.: xyr_exner
   467  opt  (  11): Fused array assignments. :line 467 - 469
   467  opt  (1592): Outer loop unrolled inside inner loop.
   467  vec  (   4): Vectorized array expression.
   467  vec  (  29): ADB is used for array.: xyr_press
   467  vec  (   4): Vectorized array expression.
   467  vec  (  29): ADB is used for array.: xyr_press
   473  opt  (  11): Fused array assignments. :line 473 - 476
   473  opt  (1592): Outer loop unrolled inside inner loop.
   473  vec  (   4): Vectorized array expression.
   473  vec  (  29): ADB is used for array.: xyr_press
   473  vec  (  29): ADB is used for array.: xy_surfdqvapsatdtemp
   473  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   473  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   473  vec  (   4): Vectorized array expression.
   473  vec  (  29): ADB is used for array.: xyr_press
   473  vec  (  29): ADB is used for array.: xy_surfdqvapsatdtemp
   473  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   473  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   481  opt  (1593): Loop nest collapsed into one loop.
   481  vec  (   4): Vectorized array expression.
   484  opt  (1593): Loop nest collapsed into one loop.
   484  vec  (   1): Vectorized loop.
   484  vec  (  29): ADB is used for array.: xyr_press
   485  opt  (  11): Fused array assignments. :line 485 - 491
   496  opt  (  11): Fused array assignments. :line 496 - 501
   496  opt  (1593): Loop nest collapsed into one loop.
   496  vec  (   4): Vectorized array expression.
   496  vec  (  29): ADB is used for array.: xyr_press
   508  opt  (  11): Fused array assignments. :line 508 - 513
   508  opt  (1593): Loop nest collapsed into one loop.
   508  vec  (   4): Vectorized array expression.
   508  vec  (  29): ADB is used for array.: xyr_press
   517  opt  (1772): Loop nest fused with following nest(s).
   517  opt  (1593): Loop nest collapsed into one loop.
   517  vec  (   1): Vectorized loop.
   527  vec  (   1): Vectorized loop.
   527  vec  (  29): ADB is used for array.: xyaa_surfmtx
   527  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   527  vec  (  29): ADB is used for array.: xyz_exner
   527  vec  (  29): ADB is used for array.: xyr_exner
   527  vec  (  29): ADB is used for array.: xyra_delradlflux
   527  vec  (  29): ADB is used for array.: xy_surfheatcapacity
   527  vec  (  29): ADB is used for array.: xy_surfdqvapsatdtemp
   527  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   527  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   527  vec  (  29): ADB is used for array.: xy_surfcond
   563  opt  (1772): Loop nest fused with following nest(s).
   563  opt  (1593): Loop nest collapsed into one loop.
   563  vec  (   4): Vectorized array expression.
   563  vec  (  29): ADB is used for array.: xyza_uvlumtx
   569  opt  (1593): Loop nest collapsed into one loop.
   569  vec  (   1): Vectorized loop.
   569  vec  (  29): ADB is used for array.: xyz_dvdt
   569  vec  (  29): ADB is used for array.: xyr_momfluxy
   569  vec  (  29): ADB is used for array.: xyz_dudt
   569  vec  (  29): ADB is used for array.: xyr_momfluxx
   570  opt  (  11): Fused array assignments. :line 570 - 571
   589  vec  (   3): Unvectorized loop.
   589  vec  (  13): Overhead of loop division is too large.
   590  opt  (1033): Potential multiple store conflict -- use directive if OK.
   590  opt  (1593): Loop nest collapsed into one loop.
   590  vec  (   4): Vectorized array expression.
   590  vec  (  29): ADB is used for array.: xyza_tempqvaplumtx
   594  opt  (1593): Loop nest collapsed into one loop.
   594  vec  (   4): Vectorized array expression.
   594  vec  (  29): ADB is used for array.: xyza_tempqvaplumtx
   596  opt  (1593): Loop nest collapsed into one loop.
   596  vec  (   1): Vectorized loop.
   596  vec  (  29): ADB is used for array.: xyza_tempqvaplumtx
   606  vec  (   3): Unvectorized loop.
   606  vec  (  13): Overhead of loop division is too large.
   607  opt  (1593): Loop nest collapsed into one loop.
   607  vec  (   4): Vectorized array expression.
   607  vec  (  29): ADB is used for array.: xyz_deltempqvap
   607  vec  (  29): ADB is used for array.: xyrf_qmixflux
   612  opt  (1593): Loop nest collapsed into one loop.
   612  vec  (   1): Vectorized loop.
   612  vec  (  29): ADB is used for array.: xyz_deltempqvap
   612  vec  (  29): ADB is used for array.: xy_groundtempflux
   612  vec  (  29): ADB is used for array.: xyrf_qmixflux
   612  vec  (  29): ADB is used for array.: xyr_heatflux
   612  vec  (  29): ADB is used for array.: xyr_radlflux
   612  vec  (  29): ADB is used for array.: xyr_radsflux
   612  vec  (  29): ADB is used for array.: xy_surfcond
   627  opt  (1593): Loop nest collapsed into one loop.
   627  vec  (   1): Vectorized loop.
   627  vec  (  29): ADB is used for array.: xyz_deltempqvap
   627  vec  (  29): ADB is used for array.: xyr_heatflux
   639  vec  (   3): Unvectorized loop.
   639  vec  (  13): Overhead of loop division is too large.
   640  opt  (  11): Fused array assignments. :line 640 - 643
   640  opt  (1593): Loop nest collapsed into one loop.
   640  vec  (   4): Vectorized array expression.
   640  vec  (  29): ADB is used for array.: xyzf_dqmixdt
   640  vec  (  29): ADB is used for array.: xyz_dtempdt
   640  vec  (  29): ADB is used for array.: xyz_deltempqvap
   640  vec  (  29): ADB is used for array.: xyz_dvdt
   640  vec  (  29): ADB is used for array.: xyz_dudt
   646  opt  (1593): Loop nest collapsed into one loop.
   646  vec  (   1): Vectorized loop.
   646  vec  (  29): ADB is used for array.: xy_dsurftempdt
   646  vec  (  29): ADB is used for array.: xyz_deltempqvap
   646  vec  (  29): ADB is used for array.: xy_surfcond
   660  opt  (1772): Loop nest fused with following nest(s).
   660  opt  (1593): Loop nest collapsed into one loop.
   660  vec  (   4): Vectorized array expression.
   660  vec  (  29): ADB is used for array.: xyza_qmixlumtx
   670  opt  (1593): Loop nest collapsed into one loop.
   670  vec  (   1): Vectorized loop.
   670  vec  (  29): ADB is used for array.: xyzf_dqmixdt
   670  vec  (  29): ADB is used for array.: xyrf_qmixflux
   675  opt  (1017): Subroutine call prevents optimization.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:02 2016
FILE NAME: phy_implicit.f90
PROGRAM NAME: phy_implicit
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 陰解法による時間積分
     2  !
     3  != Time integration with implicit scheme
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6  ! Version::   $Id: phy_implicit.f90,v 1.24 2015/01/29 12:05:01 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module phy_implicit
    13    !
    14    != 陰解法による時間積分
    15    !
    16    != Time integration with implicit scheme
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22    ! PhyImplTendency      :: 時間変化率の計算
    23    ! PhyImplEvalRadLFluxA :: 長波フラックス補正
    24    ! ------------         :: ------------
    25    ! PhyImplTendency      :: Calculate tendency
    26    ! PhyImplEvalRadLFluxA :: Longwave flux correction
    27    !
    28    !--
    29    !== NAMELIST
    30    !
    31    ! NAMELIST#phy_implicit_nml
    32    !++
    33  
    34    ! モジュール引用 ; USE statements
    35    !
    36  
    37    ! 格子点設定
    38    ! Grid points settings
    39    !
    40    use gridset, only: imax, & ! 経度格子点数.
    41                               ! Number of grid points in longitude
    42      &                jmax, & ! 緯度格子点数.
    43                               ! Number of grid points in latitude
    44      &                kmax    ! 鉛直層数.
    45                               ! Number of vertical level
    46  
    47    ! 組成に関わる配列の設定
    48    ! Settings of array for atmospheric composition
    49    !
    50    use composition, only: ncmax, IndexH2OVap
    51  
    52    ! 種別型パラメタ
    53    ! Kind type parameter
    54    !
    55    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    56      &                 STRING     ! 文字列.       Strings.
    57  
    58    ! メッセージ出力
    59    ! Message output
    60    !
    61    use dc_message, only: MessageNotify
    62  
    63    ! 宣言文 ; Declaration statements
    64    !
    65    implicit none
    66    private
    67  
    68    ! 公開手続き
    69    ! Public procedure
    70    !
    71    public :: PhyImplTendency
    72    public :: PhyImplInit
    73  
    74    ! 公開変数
    75    ! Public variables
    76    !
    77  
    78    ! 非公開変数
    79    ! Private variables
    80    !
    81    logical, save :: FlagBucketModel
    82    logical, save :: FlagSnow
    83    logical, save :: phy_implicit_inited = .false.
    84                                ! 初期設定フラグ.
    85                                ! Initialization flag
    86  
    87    character(*), parameter:: module_name = 'phy_implicit'
    88                                ! モジュールの名称.
    89                                ! Module name
    90    character(*), parameter:: version = &
    91      & '$Name:  $' // &
    92      & '$Id: phy_implicit.f90,v 1.24 2015/01/29 12:05:01 yot Exp $'
    93                                ! モジュールのバージョン
    94                                ! Module version
    95  
    96  contains
    97  
    98    !--------------------------------------------------------------------------------------
    99  
   100    subroutine PhyImplTendency(                                  &
   101      & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
   102      & xyr_RadSFlux, xyr_RadLFlux,                              & ! (in)
   103      & xy_GroundTempFlux,                                       & ! (in)
   104      & xy_SurfTemp, xy_SurfHumidCoef, xy_SurfCond,              & ! (in)
   105      & xy_SurfHeatCapacity,                                     & ! (in)
   106      & xyra_DelRadLFlux,                                        & ! (in)
   107      & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
   108      & xyr_VirTemp, xyz_Height,                                 & ! (in)
   109      & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,     & ! (in)
   110      & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
   111      & xy_SurfQVapTransCoef,                                    & ! (in)
   112      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (out)
   113      & xy_DSurfTempDt                                           & ! (out)
   114      & )
   115      !
   116      ! 時間変化率の計算を行います.
   117      !
   118      ! Calculate tendencies.
   119      !
   120  
   121      ! モジュール引用 ; USE statements
   122      !
   123  
   124      ! 物理定数設定
   125      ! Physical constants settings
   126      !
   127      use constants, only: &
   128        & Grav, &               ! $ g $ [m s-2].
   129                                ! 重力加速度.
   130                                ! Gravitational acceleration
   131        & CpDry, &
   132                                ! $ C_p $ [J kg-1 K-1].
   133                                ! 乾燥大気の定圧比熱.
   134                                ! Specific heat of air at constant pressure
   135        & LatentHeat, &
   136                                ! $ L $ [J kg-1] .
   137                                ! 凝結の潜熱.
   138                                ! Latent heat of condensation
   139        & GasRDry
   140                                ! $ R $ [J kg-1 K-1].
   141                                ! 乾燥大気の気体定数.
   142                                ! Gas constant of air
   143  
   144      ! 時刻管理
   145      ! Time control
   146      !
   147      use timeset, only: &
   148        & DelTime, &            ! $ \Delta t $ [s]
   149        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   150        & TimesetClockStart, TimesetClockStop
   151  
   152      ! ヒストリデータ出力
   153      ! History data output
   154      !
   155      use gtool_historyauto, only: HistoryAutoPut
   156  
   157      ! 飽和比湿の算出
   158      ! Evaluate saturation specific humidity
   159      !
   160      use saturate, only: xy_CalcQVapSat, xy_CalcDQVapSatDTemp
   161  
   162      ! 陰解法による時間積分のためのルーチン
   163      ! Routines for time integration with implicit scheme
   164      !
   165      use phy_implicit_utils, only : PhyImplLUDecomp3, PhyImplLUSolve3
   166  
   167      ! 宣言文 ; Declaration statements
   168      !
   169      implicit none
   170  
   171      real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
   172                                ! 東西方向運動量フラックス.
   173                                ! Eastward momentum flux
   174      real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
   175                                ! 南北方向運動量フラックス.
   176                                ! Northward momentum flux
   177      real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   178                                ! 熱フラックス.
   179                                ! Heat flux
   180      real(DP), intent(in):: xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   181                                ! 質量フラックス.
   182                                ! Mass flux of constituents
   183  
   184      real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
   185                                ! 短波 (日射) フラックス.
   186                                ! Shortwave (insolation) flux
   187      real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   188                                ! 長波フラックス.
   189                                ! Longwave flux
   190  
   191      real(DP), intent(in):: xy_GroundTempFlux (0:imax-1, 1:jmax)
   192                                ! 地中熱フラックス.
   193                                ! Ground temperature flux
   194      real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   195                                ! 地表面温度.
   196                                ! Surface temperature
   197      real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   198                                ! 地表湿潤度.
   199                                ! Surface humidity coefficient
   200      integer, intent(in):: xy_SurfCond (0:imax-1, 1:jmax)
   201                                ! 地表状態.
   202                                ! Surface condition
   203      real(DP), intent(in):: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
   204                                ! 地表熱容量.
   205                                ! Surface heat capacity
   206  
   207      real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   208                                ! 長波地表温度変化.
   209                                ! Surface temperature tendency with longwave
   210  
   211      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   212                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   213                                ! Air pressure (half level)
   214      real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   215                                ! Exner 関数 (整数レベル).
   216                                ! Exner function (full level)
   217      real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   218                                ! Exner 関数 (半整数レベル).
   219                                ! Exner function (half level)
   220  
   221      real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   222                                ! $ \hat{T}_v $ . 仮温度 (半整数レベル).
   223                                ! Virtual temperature (half level)
   224      real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   225                                ! 高度 (整数レベル).
   226                                ! Height (full level)
   227  
   228      real(DP), intent(in):: xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   229                                ! 拡散係数：運動量.
   230                                ! Diffusion coefficient: velocity
   231      real(DP), intent(in):: xyr_TempDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   232                                ! 拡散係数：温度.
   233                                ! Transfer coefficient: temperature
   234      real(DP), intent(in):: xyr_QMixDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   235                                ! 拡散係数：比湿.
   236                                ! Diffusion coefficient: specific humidity
   237  
   238      real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   239                                ! 輸送係数：運動量.
   240                                ! Diffusion coefficient: velocity
   241      real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   242                                ! 輸送係数：温度.
   243                                ! Transfer coefficient: temperature
   244      real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   245                                ! 輸送係数：比湿.
   246                                ! Transfer coefficient: specific humidity
   247  
   248      real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   249                                ! $ \DP{u}{t} $ . 東西風速変化.
   250                                ! Eastward wind tendency
   251      real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   252                                ! $ \DP{v}{t} $ . 南北風速変化.
   253                                ! Northward wind tendency
   254      real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   255                                ! $ \DP{T}{t} $ . 温度変化.
   256                                ! Temperature tendency
   257      real(DP), intent(out):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   258                                ! $ \DP{q}{t} $ . 比湿変化.
   259                                ! Temperature tendency
   260      real(DP), intent(out):: xy_DSurfTempDt (0:imax-1, 1:jmax)
   261                                ! 地表面温度変化率.
   262                                ! Surface temperature tendency
   263  
   264      ! 作業変数
   265      ! Work variables
   266      !
   267      real(DP) :: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
   268                                ! 輸送係数：運動量.
   269                                ! Transfer coefficient: velocity
   270      real(DP) :: xyr_TempTransCoef (0:imax-1, 1:jmax, 0:kmax)
   271                                ! 輸送係数：温度.
   272                                ! Transfer coefficient: temperature
   273      real(DP) :: xyr_QMixTransCoef(0:imax-1, 1:jmax, 0:kmax)
   274                                ! 輸送係数：質量.
   275                                ! Transfer coefficient: mass of constituents
   276      real(DP):: xyza_UVMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
   277                                ! 速度陰解行列.
   278                                ! Implicit matrix about velocity
   279      real(DP):: xyra_TempMtx (0:imax-1, 1:jmax, 0:kmax, -1:1)
   280                                ! 温度陰解行列.
   281                                ! Implicit matrix about temperature
   282      real(DP):: xyza_QVapMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
   283                                ! 比湿陰解行列.
   284                                ! Implicit matrix about specific humidity
   285      real(DP):: xyza_QMixMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
   286                                ! 質量混合比陰解行列.
   287                                ! Implicit matrix about mass mixing ratio
   288      real(DP):: xyaa_SurfMtx (0:imax-1, 1:jmax, 0:0, -1:1)
   289                                ! 惑星表面エネルギー収支用陰解行列
   290                                ! Implicit matrix for surface energy balance
   291      real(DP):: xyz_DelTempQVap (0:imax-1, 1:jmax, -kmax:kmax)
   292                                ! $ T q $ の時間変化.
   293                                ! Tendency of $ T q $
   294      real(DP):: xyza_TempQVapLUMtx (0:imax-1, 1:jmax, -kmax:kmax, -1:1)
   295                                ! LU 行列.
   296                                ! LU matrix
   297      real(DP):: xyza_UVLUMtx (0:imax-1, 1:jmax, 1:kmax,-1:1)
   298                                ! LU 行列.
   299                                ! LU matrix
   300      real(DP):: xyza_QMixLUMtx(0:imax-1, 1:jmax, 1:kmax,-1:1)
   301                                ! LU 行列.
   302                                ! LU matrix
   303      real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
   304                                ! 地表飽和比湿.
   305                                ! Saturated specific humidity on surface
   306      real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
   307                                ! 地表飽和比湿変化.
   308                                ! Saturated specific humidity tendency on surface
   309  
   310      integer:: i               ! 経度方向に回る DO ループ用作業変数
   311                                ! Work variables for DO loop in longitude
   312      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   313                                ! Work variables for DO loop in latitude
   314      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   315                                ! Work variables for DO loop in vertical direction
   316      integer:: l               ! 行列用 DO ループ用作業変数
   317                                ! Work variables for DO loop of matrices
   318      integer:: n               ! 組成方向に回る DO ループ用作業変数
   319                                ! Work variables for DO loop in dimension of constituents
   320  
   321      ! 実行文 ; Executable statement
   322      !
   323  
   324      ! 初期化確認
   325      ! Initialization check
   326      !
   327      if ( .not. phy_implicit_inited ) then
   328        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   329      end if
   330  
   331  
   332      ! 計算時間計測開始
   333      ! Start measurement of computation time
   334      !
   335      call TimesetClockStart( module_name )
   336  
   337  
   338      ! バケツモデルの扱いの確認
   339      ! Check use of bucket model
   340      !
   341      ! Bucket model with this routine is not supported fully, although some
   342      ! parts of calculation is implemented.
   343      !
   344      if ( FlagBucketModel ) then
   345        call MessageNotify( 'E', module_name, 'Bucket model cannot be used with this routine.' )
   346      end if
   347  
   348      ! 雪の扱いの確認
   349      ! Check about treatment of snow
   350      !
   351      if ( FlagSnow ) then
   352        call MessageNotify( 'E', module_name, 'Snow melt is not treated in this routine.' )
   353      end if
   354  
   355  
   356      ! 輸送係数の計算
   357      ! Calculate transfer coefficient
   358      !
   359      xyr_VelTransCoef (:,:,0)    = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1489 = 1, xyr_veltranscoef.DSC.U2*xyr_veltranscoef.DSC.U1 +   
     .       1   xyr_veltranscoef.DSC.U2                                        
     .           xyr_veltranscoef(t1489-1,1,0) = 0.0000000000000000e+000        
     .           xyr_veltranscoef(t1489-1,1,kmax) = 0.0000000000000000e+000     
     .           xyr_temptranscoef(t1489-1,1,0) = 0.0000000000000000e+000       
     .           xyr_temptranscoef(t1489-1,1,kmax) = 0.0000000000000000e+000    
     .           xyr_qmixtranscoef(t1489-1,1,0) = 0.0000000000000000e+000       
     .           xyr_qmixtranscoef(t1489-1,1,kmax) = 0.0000000000000000e+000    
     .        enddo                                                             
   360      xyr_VelTransCoef (:,:,kmax) = 0.0_DP
   361      xyr_TempTransCoef(:,:,0)    = 0.0_DP
   362      xyr_TempTransCoef(:,:,kmax) = 0.0_DP
   363      xyr_QMixTransCoef(:,:,0)    = 0.0_DP
   364      xyr_QMixTransCoef(:,:,kmax) = 0.0_DP
   365  
   366      do k = 1, kmax-1
   367        xyr_VelTransCoef(:,:,k) =                                     &
   368          &   xyr_VelDiffCoef(:,:,k)                                  &
   369          &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   370          &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   371  
   372        xyr_TempTransCoef(:,:,k) =                                    &
   373          &   xyr_TempDiffCoef(:,:,k)                                 &
   374          &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   375          &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   376  
   377        xyr_QMixTransCoef(:,:,k) =                                    &
   378          &   xyr_QMixDiffCoef(:,:,k)                                 &
   379          &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   380          &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   381      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyr_veltranscoef(k-1,1,1) = xyr_veldiffcoef(k-1,1,1)*xyr_press(
     .       1      k-1,1,1)/((gasrdry*xyr_virtemp(k-1,1,1))*(xyz_height(k-1,1,2
     .       2      )-xyz_height(k-1,1,1)))                                     
     .           xyr_temptranscoef(k-1,1,1) = xyr_tempdiffcoef(k-1,1,1)*        
     .       1      xyr_press(k-1,1,1)/((gasrdry*xyr_virtemp(k-1,1,1))*(        
     .       2      xyz_height(k-1,1,2)-xyz_height(k-1,1,1)))                   
     .           xyr_qmixtranscoef(k-1,1,1) = xyr_qmixdiffcoef(k-1,1,1)*        
     .       1      xyr_press(k-1,1,1)/((gasrdry*xyr_virtemp(k-1,1,1))*(        
     .       2      xyz_height(k-1,1,2)-xyz_height(k-1,1,1)))                   
     .        enddo                                                             
   382  
   383      ! 陰解法のための行列作成
   384      ! Create matrices for implicit scheme
   385      !
   386  
   387      ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (速度)
   388      ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (velocity)
   389      !
   390      k = 1
   391      xyza_UVMtx  (:,:,k,-1) = 0.0_DP
     .        d1 = 1.D0/grav                                                    
     .        d2 = d1/(2.00000000000000e+000*deltime)                           
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1545 = 1, xyza_uvmtx.DSC.U2*xyza_uvmtx.DSC.U1 +               
     .       1   xyza_uvmtx.DSC.U2                                              
     .           xyza_uvmtx(t1545-1,1,1,-1) = 0.0000000000000000e+000           
     .           xyza_uvmtx(t1545-1,1,1,0) = xy_surfveltranscoef(t1545-1,1) - ( 
     .       1      xyr_press(t1545-1,1,1)-xyr_press(t1545-1,1,0))*d2 +         
     .       2      xyr_veltranscoef(t1545-1,1,1)                               
     .           xyza_uvmtx(t1545-1,1,1,1) = -xyr_veltranscoef(t1545-1,1,1)     
     .        enddo                                                             
   392      xyza_UVMtx  (:,:,k, 0) =                                                  &
   393        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   394        & + xy_SurfVelTransCoef(:,:)                                            &
   395        & + xyr_VelTransCoef(:,:,k  )
   396      xyza_UVMtx  (:,:,k, 1) = &
   397        & - xyr_VelTransCoef(:,:,k)
   398  
   399      do k = 2, kmax-1
   400        xyza_UVMtx  (:,:,k,-1) = &
   401          & - xyr_VelTransCoef(:,:,k-1)
   402        xyza_UVMtx  (:,:,k, 0) =                                                  &
   403          & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   404          & + xyr_VelTransCoef(:,:,k-1)                                           &
   405          & + xyr_VelTransCoef(:,:,k  )
   406        xyza_UVMtx  (:,:,k, 1) = &
   407          & - xyr_VelTransCoef(:,:,k)
   408      end do
     .        d3 = 1.D0/grav                                                    
     .        d4 = d3/(2.00000000000000e+000*deltime)                           
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 2)*(xyr_veltranscoef.DSC.U2*                    
     .       1   xyr_veltranscoef.DSC.U1 + xyr_veltranscoef.DSC.U2)             
     .           xyza_uvmtx(k-1,1,2,-1) = -xyr_veltranscoef(k-1,1,1)            
     .           xyza_uvmtx(k-1,1,2,0) = xyr_veltranscoef(k-1,1,1) - (xyr_press(
     .       1      k-1,1,2)-xyr_press(k-1,1,1))*d4 + xyr_veltranscoef(k-1,1,2) 
     .           xyza_uvmtx(k-1,1,2,1) = -xyr_veltranscoef(k-1,1,2)             
     .        enddo                                                             
   409  
   410      k = kmax
   411      xyza_UVMtx  (:,:,k,-1) = &
     .        d5 = 1.D0/grav                                                    
     .        d6 = d5/(2.00000000000000e+000*deltime)                           
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1587 = 1, xyr_veltranscoef.DSC.U2*xyr_veltranscoef.DSC.U1 +   
     .       1   xyr_veltranscoef.DSC.U2                                        
     .           xyza_uvmtx(t1587-1,1,k,-1) = -xyr_veltranscoef(t1587-1,1,k-1)  
     .           xyza_uvmtx(t1587-1,1,k,0) = xyr_veltranscoef(t1587-1,1,k-1) - (
     .       1      xyr_press(t1587-1,1,k)-xyr_press(t1587-1,1,k-1))*d6         
     .           xyza_uvmtx(t1587-1,1,k,1) = 0.0000000000000000e+000            
     .        enddo                                                             
   412        & - xyr_VelTransCoef(:,:,k-1)
   413      xyza_UVMtx  (:,:,k, 0) =                                                  &
   414        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   415        & + xyr_VelTransCoef(:,:,k-1)
   416      xyza_UVMtx  (:,:,k, 1) = 0.0_DP
   417  
   418  
   419      ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (温度)
   420      ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (temperature)
   421      !
   422      k = 1
   423      xyra_TempMtx(:,:,k,-1) = &
     .        d7 = cpdry/grav                                                   
     .        d8 = d7/(2.00000000000000e+000*deltime)                           
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1605 = 1, jmax*imax                                           
     .           xyra_tempmtx(t1605-1,1,1,-1) = -cpdry*xy_surftemptranscoef(    
     .       1      t1605-1,1)                                                  
     .           xyra_tempmtx(t1605-1,1,1,0) = cpdry*xyr_exner(t1605-1,1,0)/    
     .       1      xyz_exner(t1605-1,1,1)*xy_surftemptranscoef(t1605-1,1) - (  
     .       2      xyr_press(t1605-1,1,1)-xyr_press(t1605-1,1,0))*d8 + (cpdry* 
     .       3      xyr_exner(t1605-1,1,1))/xyz_exner(t1605-1,1,1)*             
     .       4      xyr_temptranscoef(t1605-1,1,1)                              
     .           xyra_tempmtx(t1605-1,1,1,1) = -(cpdry*xyr_exner(t1605-1,1,1))/ 
     .       1      xyz_exner(t1605-1,1,2)*xyr_temptranscoef(t1605-1,1,1)       
     .        enddo                                                             
   424        & - CpDry * xy_SurfTempTransCoef(:,:)
   425      xyra_TempMtx(:,:,k, 0) =                                                          &
   426        & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   427        & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xy_SurfTempTransCoef(:,:) &
   428        & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   429      xyra_TempMtx(:,:,k, 1) = &
   430        & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
   431  
   432      do k = 2, kmax-1
   433        xyra_TempMtx(:,:,k,-1) = &
   434          & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
   435        xyra_TempMtx(:,:,k, 0) =                                                          &
   436          & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   437          & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)&
   438          & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   439        xyra_TempMtx(:,:,k, 1) = &
   440          & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
   441      end do
     .        d9 = cpdry/grav                                                   
     .        d10 = d9/(2.00000000000000e+000*deltime)                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 2)*jmax*imax                                    
     .           xyra_tempmtx(k-1,1,2,-1) = -(cpdry*xyr_exner(k-1,1,1))/        
     .       1      xyz_exner(k-1,1,1)*xyr_temptranscoef(k-1,1,1)               
     .           xyra_tempmtx(k-1,1,2,0) = (cpdry*xyr_exner(k-1,1,1))/xyz_exner(
     .       1      k-1,1,2)*xyr_temptranscoef(k-1,1,1) - (xyr_press(k-1,1,2)-  
     .       2      xyr_press(k-1,1,1))*d10 + (cpdry*xyr_exner(k-1,1,2))/       
     .       3      xyz_exner(k-1,1,2)*xyr_temptranscoef(k-1,1,2)               
     .           xyra_tempmtx(k-1,1,2,1) = -(cpdry*xyr_exner(k-1,1,2))/xyz_exner
     .       1      (k-1,1,3)*xyr_temptranscoef(k-1,1,2)                        
     .        enddo                                                             
   442  
   443      k = kmax
   444      xyra_TempMtx(:,:,k,-1) = &
     .        d11 = cpdry/grav                                                  
     .        d12 = d11/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1677 = 1, jmax*imax                                           
     .           xyra_tempmtx(t1677-1,1,k,-1) = -(cpdry*xyr_exner(t1677-1,1,k-1)
     .       1      )/xyz_exner(t1677-1,1,k-1)*xyr_temptranscoef(t1677-1,1,k-1) 
     .           xyra_tempmtx(t1677-1,1,k,0) = (cpdry*xyr_exner(t1677-1,1,k-1))/
     .       1      xyz_exner(t1677-1,1,k)*xyr_temptranscoef(t1677-1,1,k-1) - ( 
     .       2      xyr_press(t1677-1,1,k)-xyr_press(t1677-1,1,k-1))*d12        
     .           xyra_tempmtx(t1677-1,1,k,1) = 0.0000000000000000e+000          
     .        enddo                                                             
   445        & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
   446      xyra_TempMtx(:,:,k, 0) =                                                          &
   447        & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   448        & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)
   449      xyra_TempMtx(:,:,k, 1) = 0.0_DP
   450  
   451  
   452  
   453  
   454      ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (比湿)
   455      ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (specific humidity)
   456      !
   457      ! 飽和比湿の計算
   458      ! Calculate saturated specific humidity
   459      !
   460      xy_SurfQVapSat       = &
   461        & xy_CalcQVapSat      ( xy_SurfTemp, xyr_Press(:,:,0) )
   462      xy_SurfDQVapSatDTemp = &
   463        & xy_CalcDQVapSatDTemp( xy_SurfTemp, xy_SurfQVapSat   )
   464  
   465      k = 1
   466      if ( FlagBucketModel ) then
   467        xyza_QVapMtx(:,:,k,-1) =                                                  &
     .        if (xyza_qvapmtx.DSC.U2 .gt. 0) then                              
     .           j1 = and(xyza_qvapmtx.DSC.U2,3)                                
     .  !cdir    nodep                                                          
     .           do t1923 = 1, j1                                               
     .              d13 = 1.D0/grav                                             
     .              d14 = d13/(2.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do t1925 = 1, xyza_qvapmtx.DSC.U1 + 2 - min0(1,             
     .       1         xyza_qvapmtx.DSC.U1 + 1)                                 
     .                 xyza_qvapmtx(t1925-1,t1923,1,-1) =                       
     .       1            0.0000000000000000e+000                               
     .                 xyza_qvapmtx(t1925-1,t1923,1,0) = xyr_qmixtranscoef(t1925
     .       1            -1,t1923,1) - (xyr_press(t1925-1,t1923,1)-xyr_press(  
     .       2            t1925-1,t1923,0))*d14                                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1923 = j1 + 1, xyza_qvapmtx.DSC.U2, 4                      
     .              d15 = 1.D0/grav                                             
     .              d16 = d15/(2.00000000000000e+000*deltime)                   
     .              d17 = 1.D0/grav                                             
     .              d18 = d17/(2.00000000000000e+000*deltime)                   
     .              d19 = 1.D0/grav                                             
     .              d20 = d19/(2.00000000000000e+000*deltime)                   
     .              d21 = 1.D0/grav                                             
     .              d22 = d21/(2.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do t1925 = 1, xyza_qvapmtx.DSC.U1 + 2 - min0(1,             
     .       1         xyza_qvapmtx.DSC.U1 + 1)                                 
     .                 xyza_qvapmtx(t1925-1,t1923,1,-1) =                       
     .       1            0.0000000000000000e+000                               
     .                 xyza_qvapmtx(t1925-1,t1923+1,1,-1) =                     
     .       1            0.0000000000000000e+000                               
     .                 xyza_qvapmtx(t1925-1,t1923+2,1,-1) =                     
     .       1            0.0000000000000000e+000                               
     .                 xyza_qvapmtx(t1925-1,t1923+3,1,-1) =                     
     .       1            0.0000000000000000e+000                               
     .                 xyza_qvapmtx(t1925-1,t1923,1,0) = xyr_qmixtranscoef(t1925
     .       1            -1,t1923,1) - (xyr_press(t1925-1,t1923,1)-xyr_press(  
     .       2            t1925-1,t1923,0))*d16                                 
     .                 xyza_qvapmtx(t1925-1,t1923+1,1,0) = xyr_qmixtranscoef(   
     .       1            t1925-1,t1923+1,1) - (xyr_press(t1925-1,t1923+1,1)-   
     .       2            xyr_press(t1925-1,t1923+1,0))*d18                     
     .                 xyza_qvapmtx(t1925-1,t1923+2,1,0) = xyr_qmixtranscoef(   
     .       1            t1925-1,t1923+2,1) - (xyr_press(t1925-1,t1923+2,1)-   
     .       2            xyr_press(t1925-1,t1923+2,0))*d20                     
     .                 xyza_qvapmtx(t1925-1,t1923+3,1,0) = xyr_qmixtranscoef(   
     .       1            t1925-1,t1923+3,1) - (xyr_press(t1925-1,t1923+3,1)-   
     .       2            xyr_press(t1925-1,t1923+3,0))*d22                     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10067                                                        
   468          & 0.0d0
   469        xyza_QVapMtx(:,:,k, 0) =                                                  &
   470          & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   471          & + xyr_QMixTransCoef(:,:,k  )
   472      else
   473        xyza_QVapMtx(:,:,k,-1) =                                                  &
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t1703 = 1, j2                                               
     .              d23 = 1.D0/grav                                             
     .              d24 = d23/(2.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do t1705 = 1, imax                                          
     .                 xyza_qvapmtx(t1705-1,t1703,1,-1) = -(xy_surfhumidcoef(   
     .       1            t1705-1,t1703)*xy_surfqvaptranscoef(t1705-1,t1703))*  
     .       2            xy_surfdqvapsatdtemp(t1705-1,t1703)                   
     .                 xyza_qvapmtx(t1705-1,t1703,1,0) = (xy_surfhumidcoef(t1705
     .       1            -1,t1703)*xy_surfqvaptranscoef(t1705-1,t1703)) - (    
     .       2            xyr_press(t1705-1,t1703,1)-xyr_press(t1705-1,t1703,0))
     .       3            *d24 + xyr_qmixtranscoef(t1705-1,t1703,1)             
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1703 = j2 + 1, jmax, 4                                     
     .              d25 = 1.D0/grav                                             
     .              d26 = d25/(2.00000000000000e+000*deltime)                   
     .              d27 = 1.D0/grav                                             
     .              d28 = d27/(2.00000000000000e+000*deltime)                   
     .              d29 = 1.D0/grav                                             
     .              d30 = d29/(2.00000000000000e+000*deltime)                   
     .              d31 = 1.D0/grav                                             
     .              d32 = d31/(2.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do t1705 = 1, imax                                          
     .                 xyza_qvapmtx(t1705-1,t1703,1,-1) = -(xy_surfhumidcoef(   
     .       1            t1705-1,t1703)*xy_surfqvaptranscoef(t1705-1,t1703))*  
     .       2            xy_surfdqvapsatdtemp(t1705-1,t1703)                   
     .                 xyza_qvapmtx(t1705-1,t1703+1,1,-1) = -(xy_surfhumidcoef( 
     .       1            t1705-1,t1703+1)*xy_surfqvaptranscoef(t1705-1,t1703+1)
     .       2            )*xy_surfdqvapsatdtemp(t1705-1,t1703+1)               
     .                 xyza_qvapmtx(t1705-1,t1703+2,1,-1) = -(xy_surfhumidcoef( 
     .       1            t1705-1,t1703+2)*xy_surfqvaptranscoef(t1705-1,t1703+2)
     .       2            )*xy_surfdqvapsatdtemp(t1705-1,t1703+2)               
     .                 xyza_qvapmtx(t1705-1,t1703+3,1,-1) = -(xy_surfhumidcoef( 
     .       1            t1705-1,t1703+3)*xy_surfqvaptranscoef(t1705-1,t1703+3)
     .       2            )*xy_surfdqvapsatdtemp(t1705-1,t1703+3)               
     .                 xyza_qvapmtx(t1705-1,t1703,1,0) = (xy_surfhumidcoef(t1705
     .       1            -1,t1703)*xy_surfqvaptranscoef(t1705-1,t1703)) - (    
     .       2            xyr_press(t1705-1,t1703,1)-xyr_press(t1705-1,t1703,0))
     .       3            *d26 + xyr_qmixtranscoef(t1705-1,t1703,1)             
     .                 xyza_qvapmtx(t1705-1,t1703+1,1,0) = (xy_surfhumidcoef(   
     .       1            t1705-1,t1703+1)*xy_surfqvaptranscoef(t1705-1,t1703+1)
     .       2            ) - (xyr_press(t1705-1,t1703+1,1)-xyr_press(t1705-1,  
     .       3            t1703+1,0))*d28 + xyr_qmixtranscoef(t1705-1,t1703+1,1)
     .                 xyza_qvapmtx(t1705-1,t1703+2,1,0) = (xy_surfhumidcoef(   
     .       1            t1705-1,t1703+2)*xy_surfqvaptranscoef(t1705-1,t1703+2)
     .       2            ) - (xyr_press(t1705-1,t1703+2,1)-xyr_press(t1705-1,  
     .       3            t1703+2,0))*d30 + xyr_qmixtranscoef(t1705-1,t1703+2,1)
     .                 xyza_qvapmtx(t1705-1,t1703+3,1,0) = (xy_surfhumidcoef(   
     .       1            t1705-1,t1703+3)*xy_surfqvaptranscoef(t1705-1,t1703+3)
     .       2            ) - (xyr_press(t1705-1,t1703+3,1)-xyr_press(t1705-1,  
     .       3            t1703+3,0))*d32 + xyr_qmixtranscoef(t1705-1,t1703+3,1)
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   474          & - xy_SurfHumidCoef(:,:) * xy_SurfQVapTransCoef(:,:)                   &
   475          &   * xy_SurfDQVapSatDTemp(:,:)
   476        xyza_QVapMtx(:,:,k, 0) =                                                  &
   477          & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   478          & + xy_SurfHumidCoef(:,:) * xy_SurfQVapTransCoef(:,:)                   &
   479          & + xyr_QMixTransCoef(:,:,k  )
   480      end if
   481      xyza_QVapMtx(:,:,k, 1) =                                                  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1727 = 1, xyr_qmixtranscoef.DSC.U2*xyr_qmixtranscoef.DSC.U1 + 
     .       1   xyr_qmixtranscoef.DSC.U2                                       
     .           xyza_qvapmtx(t1727-1,1,1,1) = -xyr_qmixtranscoef(t1727-1,1,1)  
     .        enddo                                                             
   482        & - xyr_QMixTransCoef(:,:,k  )
   483  
   484      do k = 2, kmax-1
   485        xyza_QVapMtx(:,:,k,-1) = &
   486          & - xyr_QMixTransCoef(:,:,k-1)
   487        xyza_QVapMtx(:,:,k, 0) =                                                  &
   488          & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   489          & + xyr_QMixTransCoef(:,:,k-1)                                          &
   490          & + xyr_QMixTransCoef(:,:,k  )
   491        xyza_QVapMtx(:,:,k, 1) = &
   492          & - xyr_QMixTransCoef(:,:,k  )
   493      end do
     .        d33 = 1.D0/grav                                                   
     .        d34 = d33/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 2)*(xyr_qmixtranscoef.DSC.U2*                   
     .       1   xyr_qmixtranscoef.DSC.U1 + xyr_qmixtranscoef.DSC.U2)           
     .           xyza_qvapmtx(k-1,1,2,-1) = -xyr_qmixtranscoef(k-1,1,1)         
     .           xyza_qvapmtx(k-1,1,2,0) = xyr_qmixtranscoef(k-1,1,1) - (       
     .       1      xyr_press(k-1,1,2)-xyr_press(k-1,1,1))*d34 +                
     .       2      xyr_qmixtranscoef(k-1,1,2)                                  
     .           xyza_qvapmtx(k-1,1,2,1) = -xyr_qmixtranscoef(k-1,1,2)          
     .        enddo                                                             
   494  
   495      k = kmax
   496      xyza_QVapMtx(:,:,k,-1) = &
     .        d35 = 1.D0/grav                                                   
     .        d36 = d35/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1757 = 1, xyr_qmixtranscoef.DSC.U2*xyr_qmixtranscoef.DSC.U1 + 
     .       1   xyr_qmixtranscoef.DSC.U2                                       
     .           xyza_qvapmtx(t1757-1,1,k,-1)=-xyr_qmixtranscoef(t1757-1,1,k-1) 
     .           xyza_qvapmtx(t1757-1,1,k,0) = xyr_qmixtranscoef(t1757-1,1,k-1) 
     .       1       - (xyr_press(t1757-1,1,k)-xyr_press(t1757-1,1,k-1))*d36    
     .           xyza_qvapmtx(t1757-1,1,k,1) = 0.0000000000000000e+000          
     .        enddo                                                             
   497        & - xyr_QMixTransCoef(:,:,k-1)
   498      xyza_QVapMtx(:,:,k, 0) =                                                  &
   499        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   500        & + xyr_QMixTransCoef(:,:,k-1)
   501      xyza_QVapMtx(:,:,k, 1) = 0.0_DP
   502  
   503  
   504      ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (比湿を除く混合比)
   505      ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (mixing ratio except for specific humidity)
   506      !
   507      k = 1
   508      xyza_QMixMtx(:,:,k,-1) =                                                  &
     .        d37 = 1.D0/grav                                                   
     .        d38 = d37/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1775 = 1, xyza_qmixmtx.DSC.U2*xyza_qmixmtx.DSC.U1 +           
     .       1   xyza_qmixmtx.DSC.U2                                            
     .           xyza_qmixmtx(t1775-1,1,1,-1) = 0.0000000000000000e+000         
     .           xyza_qmixmtx(t1775-1,1,1,0) = xyr_qmixtranscoef(t1775-1,1,1) - 
     .       1      (xyr_press(t1775-1,1,1)-xyr_press(t1775-1,1,0))*d38         
     .           xyza_qmixmtx(t1775-1,1,1,1) = -xyr_qmixtranscoef(t1775-1,1,1)  
     .        enddo                                                             
   509        & 0.0d0
   510      xyza_QMixMtx(:,:,k, 0) =                                                  &
   511        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   512        & + xyr_QMixTransCoef(:,:,k  )
   513      xyza_QMixMtx(:,:,k, 1) =                                                  &
   514        & - xyr_QMixTransCoef(:,:,k  )
   515  
   516      do l = -1, 1
   517        do k = 2, kmax
   518          xyza_QMixMtx(:,:,k,l) = xyza_QVapMtx(:,:,k,l)
   519        end do
   520      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 1)*xyza_qmixmtx.DSC.U2*(xyza_qmixmtx.DSC.U1 + 1)
     .           xyza_qmixmtx(k-1,1,2,-1) = xyza_qvapmtx(k-1,1,2,-1)            
     .           xyza_qmixmtx(k-1,1,2,0) = xyza_qvapmtx(k-1,1,2,0)              
     .           xyza_qmixmtx(k-1,1,2,1) = xyza_qvapmtx(k-1,1,2,1)              
     .        enddo                                                             
   521  
   522  
   523      ! 地表面過程の輸送係数から陰解行列の計算
   524      ! Calculate implicit matrices from transfer coefficient of surface process
   525      !
   526      do i = 0, imax-1
   527        do j = 1, jmax
   528          if ( xy_SurfCond(i,j) == 1 ) then
   529  
   530            if ( FlagBucketModel ) then
   531              xyaa_SurfMtx(i,j,0,-1) =                                             &
   532                & 0.0_DP
   533              xyaa_SurfMtx(i,j,0, 0) =                                             &
   534                &   xy_SurfHeatCapacity(i,j) / ( 2.0_DP * DelTime )                    &
   535                & + CpDry * xy_SurfTempTransCoef(i,j)                              &
   536                & + xyra_DelRadLFlux(i,j,0,0)
   537            else
   538              xyaa_SurfMtx(i,j,0,-1) =                                             &
   539                & - LatentHeat * xy_SurfHumidCoef(i,j) * xy_SurfQVapTransCoef(i,j)
   540              xyaa_SurfMtx(i,j,0, 0) =                                             &
   541                &   xy_SurfHeatCapacity(i,j) / ( 2.0_DP * DelTime )                    &
   542                & + CpDry * xy_SurfTempTransCoef(i,j)                              &
   543                & + xyra_DelRadLFlux(i,j,0,0)                                      &
   544                & + LatentHeat * xy_SurfHumidCoef(i,j) * xy_SurfQVapTransCoef(i,j) &
   545                &   * xy_SurfDQVapSatDTemp(i,j)
   546            end if
   547            xyaa_SurfMtx(i,j,0, 1) =                                             &
   548              & - CpDry * xyr_Exner(i,j,0) / xyz_Exner(i,j,1)                    &
   549              &   * xy_SurfTempTransCoef(i,j)                                    &
   550              & + xyra_DelRadLFlux(i,j,0,1)
   551          else
   552            xyaa_SurfMtx(i,j,0,-1) = 0.0_DP
   553            xyaa_SurfMtx(i,j,0, 0) = 1.0_DP
   554            xyaa_SurfMtx(i,j,0, 1) = 0.0_DP
   555          end if
   556        end do
     .  !cdir nodep                                                             
     .        do j = 1, jmax                                                    
     .           if (xy_surfcond(i,j) .eq. 1) then                              
     .              if (flagbucketmodel .ne. 0) then                            
     .                 xyaa_surfmtx(i,j,0,-1) = 0.0000000000000000e+000         
     .                 xyaa_surfmtx(i,j,0,0) = xy_surfheatcapacity(i,j)/(       
     .       1            2.00000000000000e+000*deltime) + cpdry*               
     .       2            xy_surftemptranscoef(i,j) + xyra_delradlflux(i,j,0,0) 
     .              else                                                        
     .                 xyaa_surfmtx(i,j,0,-1) = -((latentheat*xy_surfhumidcoef(i
     .       1            ,j))*xy_surfqvaptranscoef(i,j))                       
     .                 xyaa_surfmtx(i,j,0,0) = xy_surfheatcapacity(i,j)/(       
     .       1            2.00000000000000e+000*deltime) + cpdry*               
     .       2            xy_surftemptranscoef(i,j) + xyra_delradlflux(i,j,0,0) 
     .       3             + ((latentheat*xy_surfhumidcoef(i,j))*               
     .       4            xy_surfqvaptranscoef(i,j))*xy_surfdqvapsatdtemp(i,j)  
     .              endif                                                       
     .              xyaa_surfmtx(i,j,0,1) = xyra_delradlflux(i,j,0,1) - cpdry*  
     .       1         xyr_exner(i,j,0)/xyz_exner(i,j,1)*xy_surftemptranscoef(i,
     .       2         j)                                                       
     .           else                                                           
     .              xyaa_surfmtx(i,j,0,-1) = 0.0000000000000000e+000            
     .              xyaa_surfmtx(i,j,0,0) = 1.00000000000000e+000               
     .              xyaa_surfmtx(i,j,0,1) = 0.0000000000000000e+000             
     .           endif                                                          
     .        enddo                                                             
   557      end do
   558  
   559  
   560      ! 東西風速, 南北風速の計算
   561      ! Calculate eastward and northward wind
   562      !
   563      xyza_UVLUMtx = xyza_UVMtx
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1803 = 1, xyza_uvlumtx.DSC.U3*(xyza_uvlumtx.DSC.U2*           
     .       1   xyza_uvlumtx.DSC.U1 + xyza_uvlumtx.DSC.U2)                     
     .           xyza_uvlumtx(t1803-1,1,1,-1) = xyza_uvmtx(t1803-1,1,1,-1)      
     .           xyza_uvlumtx(t1803-1,1,1,0) = xyza_uvmtx(t1803-1,1,1,0)        
     .           xyza_uvlumtx(t1803-1,1,1,1) = xyza_uvmtx(t1803-1,1,1,1)        
     .        enddo                                                             
   564  
   565      call PhyImplLUDecomp3( &
   566        & xyza_UVLUMtx, &     ! (inout)
   567        & imax * jmax, kmax ) ! (in)
   568  
   569      do k = 1, kmax
   570        xyz_DUDt(:,:,k) = - ( xyr_MomFluxX(:,:,k) - xyr_MomFluxX(:,:,k-1) )
   571        xyz_DVDt(:,:,k) = - ( xyr_MomFluxY(:,:,k) - xyr_MomFluxY(:,:,k-1) )
   572      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_dudt(k-1,1,1) = -(xyr_momfluxx(k-1,1,1)-xyr_momfluxx(k-1,1,
     .       1      0))                                                         
     .           xyz_dvdt(k-1,1,1) = -(xyr_momfluxy(k-1,1,1)-xyr_momfluxy(k-1,1,
     .       1      0))                                                         
     .        enddo                                                             
   573  
   574      call PhyImplLUSolve3( &
   575        & xyz_DUDt, &            ! (inout)
   576        & xyza_UVLUMtx, &        ! (in)
   577        & 1, imax * jmax, kmax ) ! (in)
   578  
   579      call PhyImplLUSolve3( &
   580        & xyz_DVDt, &            ! (inout)
   581        & xyza_UVLUMtx, &        ! (in)
   582        & 1, imax * jmax, kmax ) ! (in)
   583  
   584      ! 温度と比湿の計算
   585      ! Calculate temperature and specific humidity
   586      !
   587      do l = -1, 1
   588  
   589        do k = 1, kmax
   590          xyza_TempQVapLUMtx(:,:,-k,-l) = xyza_QVapMtx(:,:,k,l)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1833 = 1, xyza_tempqvaplumtx.DSC.U2*xyza_tempqvaplumtx.DSC.U1 
     .       1    + xyza_tempqvaplumtx.DSC.U2                                   
     .           xyza_tempqvaplumtx(t1833-1,1,(-k),(-l)) = xyza_qvapmtx(t1833-1,
     .       1      1,k,l)                                                      
     .        enddo                                                             
   591        end do
   592  
   593        k = 0
   594        xyza_TempQVapLUMtx(:,:, k, l) = xyaa_SurfMtx(:,:,0,l)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1841 = 1, xyza_tempqvaplumtx.DSC.U2*xyza_tempqvaplumtx.DSC.U1 
     .       1    + xyza_tempqvaplumtx.DSC.U2                                   
     .           xyza_tempqvaplumtx(t1841-1,1,0,l) = xyaa_surfmtx(t1841-1,1,0,l)
     .        enddo                                                             
   595  
   596        do k =  1,  kmax
   597          xyza_TempQVapLUMtx(:,:, k, l) = xyra_TempMtx(:,:,k,l)
   598        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*(xyza_tempqvaplumtx.DSC.U2*                        
     .       1   xyza_tempqvaplumtx.DSC.U1 + xyza_tempqvaplumtx.DSC.U2)         
     .           xyza_tempqvaplumtx(k-1,1,1,l) = xyra_tempmtx(k-1,1,1,l)        
     .        enddo                                                             
   599  
   600      end do
   601  
   602      call PhyImplLUDecomp3( &
   603        & xyza_TempQVapLUMtx, &         ! (inout)
   604        & imax * jmax, (2 * kmax) + 1 ) ! (in)
   605  
   606      do k = 1, kmax
   607        xyz_DelTempQVap(:,:,-k) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrf_qmixflux)                                             
     .        do t1857 = 1, jmax*imax                                           
     .           xyz_deltempqvap(t1857-1,1,(-k)) = -(xyrf_qmixflux(t1857-1,1,k, 
     .       1      indexh2ovap)-xyrf_qmixflux(t1857-1,1,k-1,indexh2ovap))      
     .        enddo                                                             
   608          & - ( xyrf_QMixFlux(:,:,k,IndexH2OVap) - xyrf_QMixFlux(:,:,k-1,IndexH2OVap) )
   609      end do
   610  
   611      k = 0
   612      do j = 1, jmax
   613        do i = 0, imax-1
   614          if ( xy_SurfCond(i,j) == 1 ) then
   615            xyz_DelTempQVap(i,j,k) =                            &
   616              & - xyr_RadSFlux(i,j,0)                           &
   617              & - xyr_RadLFlux(i,j,0)                           &
   618              & - xyr_HeatFlux(i,j,0)                           &
   619              & - LatentHeat * xyrf_QMixFlux(i,j,0,IndexH2OVap) &
   620              & + xy_GroundTempFlux(i,j)
   621          else
   622            xyz_DelTempQVap(i,j,k) = 0.0_DP
   623          end if
   624        end do
   625      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrf_qmixflux)                                             
     .        do j = 1, jmax*imax                                               
     .           if (xy_surfcond(j-1,1) .eq. 1) then                            
     .              xyz_deltempqvap39 = (-xyr_radsflux(j-1,1,0)) - xyr_radlflux(
     .       1         j-1,1,0) - xyr_heatflux(j-1,1,0) - latentheat*           
     .       2         xyrf_qmixflux(j-1,1,0,indexh2ovap) + xy_groundtempflux(j-
     .       3         1,1)                                                     
     .           else                                                           
     .              xyz_deltempqvap39 = 0.0000000000000000e+000                 
     .           endif                                                          
     .           xyz_deltempqvap(j-1,1,0) = xyz_deltempqvap39                   
     .        enddo                                                             
   626  
   627      do k = 1, kmax
   628        xyz_DelTempQVap(:,:,k) = - ( xyr_HeatFlux(:,:, k) - xyr_HeatFlux(:,:,  k-1 ) )
   629      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_deltempqvap(k-1,1,1) = -(xyr_heatflux(k-1,1,1)-xyr_heatflux
     .       1      (k-1,1,0))                                                  
     .        enddo                                                             
   630  
   631      call PhyImplLUSolve3( &
   632        & xyz_DelTempQVap, &                ! (inout)
   633        & xyza_TempQVapLUMtx, &             ! (in)
   634        & 1, imax * jmax , (2 * kmax) + 1 ) ! (in)
   635  
   636      ! 時間変化率の計算
   637      ! Calculate tendency
   638      !
   639      do k = 1, kmax
   640        xyz_DUDt(:,:,k)                 = xyz_DUDt(:,:,k)         / ( 2.0_DP * DelTime )
     .        d40 = 1.D0/(2.00000000000000e+000*deltime)                        
     .        d41 = 1.D0/(2.00000000000000e+000*deltime)                        
     .        d42 = 1.D0/(2.00000000000000e+000*deltime)                        
     .        d43 = 1.D0/(2.00000000000000e+000*deltime)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1877 = 1, jmax*imax                                           
     .           xyz_dudt(t1877-1,1,k) = xyz_dudt(t1877-1,1,k)*d40              
     .           xyz_dvdt(t1877-1,1,k) = xyz_dvdt(t1877-1,1,k)*d41              
     .           xyz_dtempdt(t1877-1,1,k) = xyz_deltempqvap(t1877-1,1,k)*d42    
     .           xyzf_dqmixdt(t1877-1,1,k,indexh2ovap) = xyz_deltempqvap(t1877-1
     .       1      ,1,(-k))*d43                                                
     .        enddo                                                             
   641        xyz_DVDt(:,:,k)                 = xyz_DVDt(:,:,k)         / ( 2.0_DP * DelTime )
   642        xyz_DTempDt(:,:,k)              = xyz_DelTempQVap(:,:, k) / ( 2.0_DP * DelTime )
   643        xyzf_DQMixDt(:,:,k,IndexH2OVap) = xyz_DelTempQVap(:,:,-k) / ( 2.0_DP * DelTime )
   644      end do
   645  
   646      do j = 1, jmax
   647        do i = 0, imax-1
   648          if ( xy_SurfCond(i,j) == 1 ) then
   649            xy_DSurfTempDt(i,j) = xyz_DelTempQVap(i,j,0) / ( 2.0_DP * DelTime )
   650          else
   651            xy_DSurfTempDt(i,j) = 0.0_DP
   652          end if
   653        end do
   654      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surfcond(j-1,1) .eq. 1) then                            
     .              xy_dsurftempdt44 = xyz_deltempqvap(j-1,1,0)/(               
     .       1         2.00000000000000e+000*deltime)                           
     .           else                                                           
     .              xy_dsurftempdt44 = 0.0000000000000000e+000                  
     .           endif                                                          
     .           xy_dsurftempdt(j-1,1) = xy_dsurftempdt44                       
     .        enddo                                                             
   655  
   656  
   657      ! 比湿を除く質量混合比
   658      ! Calculate mass mixing ratio except for specific humidity
   659      !
   660      xyza_QMixLUMtx = xyza_QMixMtx
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1899 = 1, xyza_qmixlumtx.DSC.U3*(xyza_qmixlumtx.DSC.U2*       
     .       1   xyza_qmixlumtx.DSC.U1 + xyza_qmixlumtx.DSC.U2)                 
     .           xyza_qmixlumtx(t1899-1,1,1,-1) = xyza_qmixmtx(t1899-1,1,1,-1)  
     .           xyza_qmixlumtx(t1899-1,1,1,0) = xyza_qmixmtx(t1899-1,1,1,0)    
     .           xyza_qmixlumtx(t1899-1,1,1,1) = xyza_qmixmtx(t1899-1,1,1,1)    
     .        enddo                                                             
   661  
   662      call PhyImplLUDecomp3( &
   663        & xyza_QMixLUMtx,    & ! (inout)
   664        & imax * jmax, kmax  & ! (in)
   665        & )
   666  
   667      do n = 1, ncmax
   668        if ( n == IndexH2OVap ) cycle
   669  
   670        do k = 1, kmax
   671          xyzf_DQMixDt(:,:,k,n) = &
   672            & - ( xyrf_QMixFlux(:,:,k,n) - xyrf_QMixFlux(:,:,k-1,n) )
   673        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrf_qmixflux)                                             
     .        do k = 1, kmax*jmax*imax                                          
     .           xyzf_dqmixdt(k-1,1,1,n) = -(xyrf_qmixflux(k-1,1,1,n)-          
     .       1      xyrf_qmixflux(k-1,1,0,n))                                   
     .        enddo                                                             
   674  
   675        call PhyImplLUSolve3(      &
   676          & xyzf_DQMixDt(:,:,:,n), & ! (inout)
   677          & xyza_QMixLUMtx,        & ! (in)
   678          & 1, imax * jmax, kmax   & ! (in)
   679          & )
   680      end do
   681  
   682  
   683  
   684      !#########################################################
   685      ! code for debug, this will be removed, (Y. O. Takahashi, 2009/04/07)
   686  !!$    i = 1
   687  !!$    j = jmax / 2
   688  !!$    n = IndexH2OVap
   689  !!$    write( 6, * ) &
   690  !!$      & - xyr_RadSFlux(i,j,0),                                                      &
   691  !!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
   692  !!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
   693  !!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) ), &
   694  !!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
   695  !!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
   696  !!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
   697  !!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) ),   &
   698  !!$      & - LatentHeat                                                                &
   699  !!$      &   * ( xyrf_QMixFlux(i,j,0,n)                                                &
   700  !!$      &     - xy_SurfQVapTransCoef(i,j)                                             &
   701  !!$      &       * ( xyzf_DQMixDt(i,j,1,n)                                             &
   702  !!$      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
   703  !!$      &       * ( 2.0d0 * DelTime ) ) !, &
   704  !!$!      & + xy_GroundTempFlux(i,j)
   705  !!$    write( 6, * ) &
   706  !!$      & - xyr_RadSFlux(i,j,0)                                                       &
   707  !!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
   708  !!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
   709  !!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) )  &
   710  !!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
   711  !!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
   712  !!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
   713  !!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) )    &
   714  !!$      & - LatentHeat                                                                &
   715  !!$      &   * ( xyrf_QMixFlux(i,j,0,n)                                                &
   716  !!$      &     - xy_SurfQVapTransCoef(i,j)                                             &
   717  !!$      &       * ( xyzf_DQMixDt(i,j,1,n)                                             &
   718  !!$      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
   719  !!$      &       * ( 2.0d0 * DelTime ) ) !, &
   720  !!$!      & + xy_GroundTempFlux(i,j)
   721  !!$
   722  !!$    xy_SurfQVapSat(i,j) =                                                           &
   723  !!$      & - xyr_RadSFlux(i,j,0)                                                       &
   724  !!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
   725  !!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
   726  !!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) )  &
   727  !!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
   728  !!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
   729  !!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
   730  !!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) )    &
   731  !!$      & - LatentHeat                                                                &
   732  !!$!      &   * ( xyr_QVapFlux(i,j,0)                                                   &
   733  !!$!      &     - xy_SurfQVapTransCoef(i,j)                                             &
   734  !!$!      &       * ( xyz_DQVapDt(i,j,1)                                                &
   735  !!$!      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
   736  !!$!      &       * ( 2.0d0 * DelTime ) )
   737  !!$      &   * xyrf_QMixFlux(i,j,0,n)
   738  !!$    write( 6, * ) xy_SurfQVapSat(i,j)
   739      !#########################################################
   740  
   741  
   742  
   743      ! 計算時間計測一時停止
   744      ! Pause measurement of computation time
   745      !
   746      call TimesetClockStop( module_name )
   747  
   748    end subroutine PhyImplTendency
   749  
   750    !--------------------------------------------------------------------------------------
   751  
   752    subroutine PhyImplInit(              &
   753      & ArgFlagBucketModel, ArgFlagSnow  & ! (in)
   754      & )
   755      !
   756      ! phy_implicit モジュールの初期化を行います.
   757      ! NAMELIST#phy_implicit_nml の読み込みはこの手続きで行われます.
   758      !
   759      ! "phy_implicit" module is initialized.
   760      ! "NAMELIST#phy_implicit_nml" is loaded in this procedure.
   761      !
   762  
   763      ! モジュール引用 ; USE statements
   764      !
   765  
   766      ! NAMELIST ファイル入力に関するユーティリティ
   767      ! Utilities for NAMELIST file input
   768      !
   769      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   770  
   771      ! ファイル入出力補助
   772      ! File I/O support
   773      !
   774      use dc_iounit, only: FileOpen
   775  
   776      ! 種別型パラメタ
   777      ! Kind type parameter
   778      !
   779      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   780  
   781      ! 文字列操作
   782      ! Character handling
   783      !
   784      use dc_string, only: StoA
   785  
   786      ! ヒストリデータ出力
   787      ! History data output
   788      !
   789      use gtool_historyauto, only: HistoryAutoAddVariable
   790  
   791      ! 宣言文 ; Declaration statements
   792      !
   793      implicit none
   794  
   795      logical, intent(in ) :: ArgFlagBucketModel
   796      logical, intent(in ) :: ArgFlagSnow
   797  
   798  
   799      ! 作業変数
   800      ! Work variables
   801      !
   802  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   803  !!$                              ! Unit number for NAMELIST file open
   804  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   805  !!$                              ! IOSTAT of NAMELIST read
   806  
   807      ! NAMELIST 変数群
   808      ! NAMELIST group name
   809      !
   810  !!$    namelist /phy_implicit_nml/
   811  !!$          !
   812  !!$          ! デフォルト値については初期化手続 "phy_implicit#PhyImplInit"
   813  !!$          ! のソースコードを参照のこと.
   814  !!$          !
   815  !!$          ! Refer to source codes in the initialization procedure
   816  !!$          ! "phy_implicit#PhyImplInit" for the default values.
   817  !!$          !
   818  
   819      ! 実行文 ; Executable statement
   820      !
   821  
   822      if ( phy_implicit_inited ) return
   823  
   824  
   825      ! デフォルト値の設定
   826      ! Default values settings
   827      !
   828  
   829      ! NAMELIST の読み込み
   830      ! NAMELIST is input
   831      !
   832  !!$    if ( trim(namelist_filename) /= '' ) then
   833  !!$      call FileOpen( unit_nml, &          ! (out)
   834  !!$        & namelist_filename, mode = 'r' ) ! (in)
   835  !!$
   836  !!$      rewind( unit_nml )
   837  !!$      read( unit_nml, &           ! (in)
   838  !!$        & nml = phy_implicit_nml, &  ! (out)
   839  !!$        & iostat = iostat_nml )   ! (out)
   840  !!$      close( unit_nml )
   841  !!$
   842  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   843  !!$    end if
   844  
   845  
   846      FlagBucketModel = ArgFlagBucketModel
   847      FlagSnow        = ArgFlagSnow
   848  
   849      ! 印字 ; Print
   850      !
   851      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   852      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   853  
   854      phy_implicit_inited = .true.
   855  
   856    end subroutine PhyImplInit
   857  
   858    !--------------------------------------------------------------------------------------
   859  
   860  end module phy_implicit
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:02 2016
FILE NAME: phy_implicit.f90
PROGRAM NAME: phy_implicit
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 陰解法による時間積分
     2:             !
     3:             != Time integration with implicit scheme
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6:             ! Version::   $Id: phy_implicit.f90,v 1.24 2015/01/29 12:05:01 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module phy_implicit
    13:               !
    14:               != 陰解法による時間積分
    15:               !
    16:               != Time integration with implicit scheme
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               !
    22:               ! PhyImplTendency      :: 時間変化率の計算
    23:               ! PhyImplEvalRadLFluxA :: 長波フラックス補正
    24:               ! ------------         :: ------------
    25:               ! PhyImplTendency      :: Calculate tendency
    26:               ! PhyImplEvalRadLFluxA :: Longwave flux correction
    27:               !
    28:               !--
    29:               !== NAMELIST
    30:               !
    31:               ! NAMELIST#phy_implicit_nml
    32:               !++
    33:             
    34:               ! モジュール引用 ; USE statements
    35:               !
    36:             
    37:               ! 格子点設定
    38:               ! Grid points settings
    39:               !
    40:               use gridset, only: imax, & ! 経度格子点数. 
    41:                                          ! Number of grid points in longitude
    42:                 &                jmax, & ! 緯度格子点数. 
    43:                                          ! Number of grid points in latitude
    44:                 &                kmax    ! 鉛直層数. 
    45:                                          ! Number of vertical level
    46:             
    47:               ! 組成に関わる配列の設定
    48:               ! Settings of array for atmospheric composition
    49:               !
    50:               use composition, only: ncmax, IndexH2OVap
    51:             
    52:               ! 種別型パラメタ
    53:               ! Kind type parameter
    54:               !
    55:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    56:                 &                 STRING     ! 文字列.       Strings. 
    57:             
    58:               ! メッセージ出力
    59:               ! Message output
    60:               !
    61:               use dc_message, only: MessageNotify
    62:             
    63:               ! 宣言文 ; Declaration statements
    64:               !
    65:               implicit none
    66:               private
    67:             
    68:               ! 公開手続き
    69:               ! Public procedure
    70:               !
    71:               public :: PhyImplTendency
    72:               public :: PhyImplInit
    73:             
    74:               ! 公開変数
    75:               ! Public variables
    76:               !
    77:             
    78:               ! 非公開変数
    79:               ! Private variables
    80:               !
    81:               logical, save :: FlagBucketModel
    82:               logical, save :: FlagSnow
    83:               logical, save :: phy_implicit_inited = .false.
    84:                                           ! 初期設定フラグ. 
    85:                                           ! Initialization flag
    86:             
    87:               character(*), parameter:: module_name = 'phy_implicit'
    88:                                           ! モジュールの名称. 
    89:                                           ! Module name
    90:               character(*), parameter:: version = &
    91:                 & '$Name:  $' // &
    92:                 & '$Id: phy_implicit.f90,v 1.24 2015/01/29 12:05:01 yot Exp $'
    93:                                           ! モジュールのバージョン
    94:                                           ! Module version
    95:             
    96:             contains
    97:             
    98:               !--------------------------------------------------------------------------------------
    99:             
   100:               subroutine PhyImplTendency(                                  &
   101:                 & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
   102:                 & xyr_RadSFlux, xyr_RadLFlux,                              & ! (in)
   103:                 & xy_GroundTempFlux,                                       & ! (in)
   104:                 & xy_SurfTemp, xy_SurfHumidCoef, xy_SurfCond,              & ! (in)
   105:                 & xy_SurfHeatCapacity,                                     & ! (in)
   106:                 & xyra_DelRadLFlux,                                        & ! (in)
   107:                 & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
   108:                 & xyr_VirTemp, xyz_Height,                                 & ! (in)
   109:                 & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,     & ! (in)
   110:                 & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
   111:                 & xy_SurfQVapTransCoef,                                    & ! (in)
   112:                 & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (out)
   113:                 & xy_DSurfTempDt                                           & ! (out)
   114:                 & )
   115:                 !
   116:                 ! 時間変化率の計算を行います. 
   117:                 !
   118:                 ! Calculate tendencies. 
   119:                 !
   120:             
   121:                 ! モジュール引用 ; USE statements
   122:                 !
   123:             
   124:                 ! 物理定数設定
   125:                 ! Physical constants settings
   126:                 !
   127:                 use constants, only: &
   128:                   & Grav, &               ! $ g $ [m s-2]. 
   129:                                           ! 重力加速度. 
   130:                                           ! Gravitational acceleration
   131:                   & CpDry, &
   132:                                           ! $ C_p $ [J kg-1 K-1]. 
   133:                                           ! 乾燥大気の定圧比熱. 
   134:                                           ! Specific heat of air at constant pressure
   135:                   & LatentHeat, &
   136:                                           ! $ L $ [J kg-1] . 
   137:                                           ! 凝結の潜熱. 
   138:                                           ! Latent heat of condensation
   139:                   & GasRDry
   140:                                           ! $ R $ [J kg-1 K-1]. 
   141:                                           ! 乾燥大気の気体定数. 
   142:                                           ! Gas constant of air
   143:             
   144:                 ! 時刻管理
   145:                 ! Time control
   146:                 !
   147:                 use timeset, only: &
   148:                   & DelTime, &            ! $ \Delta t $ [s]
   149:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   150:                   & TimesetClockStart, TimesetClockStop
   151:             
   152:                 ! ヒストリデータ出力
   153:                 ! History data output
   154:                 !
   155:                 use gtool_historyauto, only: HistoryAutoPut
   156:             
   157:                 ! 飽和比湿の算出
   158:                 ! Evaluate saturation specific humidity
   159:                 !
   160:                 use saturate, only: xy_CalcQVapSat, xy_CalcDQVapSatDTemp
   161:             
   162:                 ! 陰解法による時間積分のためのルーチン
   163:                 ! Routines for time integration with implicit scheme
   164:                 !
   165:                 use phy_implicit_utils, only : PhyImplLUDecomp3, PhyImplLUSolve3
   166:             
   167:                 ! 宣言文 ; Declaration statements
   168:                 !
   169:                 implicit none
   170:             
   171:                 real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
   172:                                           ! 東西方向運動量フラックス. 
   173:                                           ! Eastward momentum flux
   174:                 real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
   175:                                           ! 南北方向運動量フラックス. 
   176:                                           ! Northward momentum flux
   177:                 real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   178:                                           ! 熱フラックス. 
   179:                                           ! Heat flux
   180:                 real(DP), intent(in):: xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   181:                                           ! 質量フラックス. 
   182:                                           ! Mass flux of constituents
   183:             
   184:                 real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
   185:                                           ! 短波 (日射) フラックス. 
   186:                                           ! Shortwave (insolation) flux
   187:                 real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   188:                                           ! 長波フラックス. 
   189:                                           ! Longwave flux
   190:             
   191:                 real(DP), intent(in):: xy_GroundTempFlux (0:imax-1, 1:jmax)
   192:                                           ! 地中熱フラックス. 
   193:                                           ! Ground temperature flux
   194:                 real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   195:                                           ! 地表面温度. 
   196:                                           ! Surface temperature
   197:                 real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   198:                                           ! 地表湿潤度. 
   199:                                           ! Surface humidity coefficient
   200:                 integer, intent(in):: xy_SurfCond (0:imax-1, 1:jmax)
   201:                                           ! 地表状態. 
   202:                                           ! Surface condition
   203:                 real(DP), intent(in):: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
   204:                                           ! 地表熱容量. 
   205:                                           ! Surface heat capacity
   206:             
   207:                 real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   208:                                           ! 長波地表温度変化. 
   209:                                           ! Surface temperature tendency with longwave
   210:             
   211:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   212:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   213:                                           ! Air pressure (half level)
   214:                 real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   215:                                           ! Exner 関数 (整数レベル). 
   216:                                           ! Exner function (full level)
   217:                 real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   218:                                           ! Exner 関数 (半整数レベル). 
   219:                                           ! Exner function (half level)
   220:             
   221:                 real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   222:                                           ! $ \hat{T}_v $ . 仮温度 (半整数レベル). 
   223:                                           ! Virtual temperature (half level)
   224:                 real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   225:                                           ! 高度 (整数レベル). 
   226:                                           ! Height (full level)
   227:             
   228:                 real(DP), intent(in):: xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   229:                                           ! 拡散係数：運動量. 
   230:                                           ! Diffusion coefficient: velocity
   231:                 real(DP), intent(in):: xyr_TempDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   232:                                           ! 拡散係数：温度. 
   233:                                           ! Transfer coefficient: temperature
   234:                 real(DP), intent(in):: xyr_QMixDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   235:                                           ! 拡散係数：比湿. 
   236:                                           ! Diffusion coefficient: specific humidity
   237:             
   238:                 real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   239:                                           ! 輸送係数：運動量. 
   240:                                           ! Diffusion coefficient: velocity
   241:                 real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   242:                                           ! 輸送係数：温度. 
   243:                                           ! Transfer coefficient: temperature
   244:                 real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   245:                                           ! 輸送係数：比湿. 
   246:                                           ! Transfer coefficient: specific humidity
   247:             
   248:                 real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   249:                                           ! $ \DP{u}{t} $ . 東西風速変化. 
   250:                                           ! Eastward wind tendency
   251:                 real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   252:                                           ! $ \DP{v}{t} $ . 南北風速変化. 
   253:                                           ! Northward wind tendency
   254:                 real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   255:                                           ! $ \DP{T}{t} $ . 温度変化. 
   256:                                           ! Temperature tendency
   257:                 real(DP), intent(out):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   258:                                           ! $ \DP{q}{t} $ . 比湿変化. 
   259:                                           ! Temperature tendency
   260:                 real(DP), intent(out):: xy_DSurfTempDt (0:imax-1, 1:jmax)
   261:                                           ! 地表面温度変化率. 
   262:                                           ! Surface temperature tendency
   263:             
   264:                 ! 作業変数
   265:                 ! Work variables
   266:                 !
   267:                 real(DP) :: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
   268:                                           ! 輸送係数：運動量. 
   269:                                           ! Transfer coefficient: velocity
   270:                 real(DP) :: xyr_TempTransCoef (0:imax-1, 1:jmax, 0:kmax)
   271:                                           ! 輸送係数：温度. 
   272:                                           ! Transfer coefficient: temperature
   273:                 real(DP) :: xyr_QMixTransCoef(0:imax-1, 1:jmax, 0:kmax)
   274:                                           ! 輸送係数：質量. 
   275:                                           ! Transfer coefficient: mass of constituents
   276:                 real(DP):: xyza_UVMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
   277:                                           ! 速度陰解行列. 
   278:                                           ! Implicit matrix about velocity 
   279:                 real(DP):: xyra_TempMtx (0:imax-1, 1:jmax, 0:kmax, -1:1)
   280:                                           ! 温度陰解行列. 
   281:                                           ! Implicit matrix about temperature
   282:                 real(DP):: xyza_QVapMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
   283:                                           ! 比湿陰解行列. 
   284:                                           ! Implicit matrix about specific humidity
   285:                 real(DP):: xyza_QMixMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
   286:                                           ! 質量混合比陰解行列. 
   287:                                           ! Implicit matrix about mass mixing ratio
   288:                 real(DP):: xyaa_SurfMtx (0:imax-1, 1:jmax, 0:0, -1:1)
   289:                                           ! 惑星表面エネルギー収支用陰解行列
   290:                                           ! Implicit matrix for surface energy balance
   291:                 real(DP):: xyz_DelTempQVap (0:imax-1, 1:jmax, -kmax:kmax)
   292:                                           ! $ T q $ の時間変化. 
   293:                                           ! Tendency of $ T q $ 
   294:                 real(DP):: xyza_TempQVapLUMtx (0:imax-1, 1:jmax, -kmax:kmax, -1:1)
   295:                                           ! LU 行列. 
   296:                                           ! LU matrix
   297:                 real(DP):: xyza_UVLUMtx (0:imax-1, 1:jmax, 1:kmax,-1:1)
   298:                                           ! LU 行列. 
   299:                                           ! LU matrix
   300:                 real(DP):: xyza_QMixLUMtx(0:imax-1, 1:jmax, 1:kmax,-1:1)
   301:                                           ! LU 行列. 
   302:                                           ! LU matrix
   303:                 real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
   304:                                           ! 地表飽和比湿. 
   305:                                           ! Saturated specific humidity on surface
   306:                 real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
   307:                                           ! 地表飽和比湿変化. 
   308:                                           ! Saturated specific humidity tendency on surface
   309:             
   310:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   311:                                           ! Work variables for DO loop in longitude
   312:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   313:                                           ! Work variables for DO loop in latitude
   314:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   315:                                           ! Work variables for DO loop in vertical direction
   316:                 integer:: l               ! 行列用 DO ループ用作業変数
   317:                                           ! Work variables for DO loop of matrices
   318:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   319:                                           ! Work variables for DO loop in dimension of constituents
   320:             
   321:                 ! 実行文 ; Executable statement
   322:                 !
   323:             
   324:                 ! 初期化確認
   325:                 ! Initialization check
   326:                 !
   327:                 if ( .not. phy_implicit_inited ) then
   328:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   329:                 end if
   330:             
   331:             
   332:                 ! 計算時間計測開始
   333:                 ! Start measurement of computation time
   334:                 !
   335:                 call TimesetClockStart( module_name )
   336:             
   337:             
   338:                 ! バケツモデルの扱いの確認
   339:                 ! Check use of bucket model
   340:                 !
   341:                 ! Bucket model with this routine is not supported fully, although some 
   342:                 ! parts of calculation is implemented. 
   343:                 !
   344:                 if ( FlagBucketModel ) then
   345:                   call MessageNotify( 'E', module_name, 'Bucket model cannot be used with this routine.' )
   346:                 end if
   347:             
   348:                 ! 雪の扱いの確認
   349:                 ! Check about treatment of snow
   350:                 !
   351:                 if ( FlagSnow ) then
   352:                   call MessageNotify( 'E', module_name, 'Snow melt is not treated in this routine.' )
   353:                 end if
   354:             
   355:             
   356:                 ! 輸送係数の計算
   357:                 ! Calculate transfer coefficient
   358:                 !
   359: *W----->        xyr_VelTransCoef (:,:,0)    = 0.0_DP
   360: ||              xyr_VelTransCoef (:,:,kmax) = 0.0_DP
   361: ||              xyr_TempTransCoef(:,:,0)    = 0.0_DP
   362: ||              xyr_TempTransCoef(:,:,kmax) = 0.0_DP
   363: ||              xyr_QMixTransCoef(:,:,0)    = 0.0_DP
   364: *W-----         xyr_QMixTransCoef(:,:,kmax) = 0.0_DP
   365:             
   366: W------>        do k = 1, kmax-1
   367: |**---->A         xyr_VelTransCoef(:,:,k) =                                     &
   368: |||                 &   xyr_VelDiffCoef(:,:,k)                                  &
   369: |||                 &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   370: |||                 &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   371: |||         
   372: |||     A         xyr_TempTransCoef(:,:,k) =                                    &
   373: |||                 &   xyr_TempDiffCoef(:,:,k)                                 &
   374: |||                 &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   375: |||                 &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   376: |||         
   377: |**---- A         xyr_QMixTransCoef(:,:,k) =                                    &
   378: |                   &   xyr_QMixDiffCoef(:,:,k)                                 &
   379: |                   &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   380: |                   &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   381: W------         end do
   382:             
   383:                 ! 陰解法のための行列作成
   384:                 ! Create matrices for implicit scheme
   385:                 !
   386:             
   387:                 ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (速度)
   388:                 ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (velocity)
   389:                 !
   390:                 k = 1
   391: *W----->        xyza_UVMtx  (:,:,k,-1) = 0.0_DP
   392: ||      A       xyza_UVMtx  (:,:,k, 0) =                                                  &
   393: ||                & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   394: ||                & + xy_SurfVelTransCoef(:,:)                                            &
   395: ||                & + xyr_VelTransCoef(:,:,k  )
   396: *W-----         xyza_UVMtx  (:,:,k, 1) = &
   397:                   & - xyr_VelTransCoef(:,:,k)
   398:             
   399: W------>        do k = 2, kmax-1
   400: |**---->          xyza_UVMtx  (:,:,k,-1) = &
   401: |||                 & - xyr_VelTransCoef(:,:,k-1)
   402: |||     A         xyza_UVMtx  (:,:,k, 0) =                                                  &
   403: |||                 & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   404: |||                 & + xyr_VelTransCoef(:,:,k-1)                                           &
   405: |||                 & + xyr_VelTransCoef(:,:,k  )
   406: |**----           xyza_UVMtx  (:,:,k, 1) = &
   407: |                   & - xyr_VelTransCoef(:,:,k)
   408: W------         end do
   409:             
   410:                 k = kmax
   411: *W----->        xyza_UVMtx  (:,:,k,-1) = &
   412: ||                & - xyr_VelTransCoef(:,:,k-1)
   413: ||      A       xyza_UVMtx  (:,:,k, 0) =                                                  &
   414: ||                & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   415: ||                & + xyr_VelTransCoef(:,:,k-1)
   416: *W-----         xyza_UVMtx  (:,:,k, 1) = 0.0_DP
   417:             
   418:             
   419:                 ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (温度)
   420:                 ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (temperature)
   421:                 !
   422:                 k = 1
   423: *W----->A       xyra_TempMtx(:,:,k,-1) = &
   424: ||                & - CpDry * xy_SurfTempTransCoef(:,:)
   425: ||      A       xyra_TempMtx(:,:,k, 0) =                                                          &
   426: ||                & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   427: ||                & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xy_SurfTempTransCoef(:,:) &
   428: ||                & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   429: *W----- A       xyra_TempMtx(:,:,k, 1) = &
   430:                   & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
   431:             
   432: W------>        do k = 2, kmax-1
   433: |**---->A         xyra_TempMtx(:,:,k,-1) = &
   434: |||                 & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
   435: |||     A         xyra_TempMtx(:,:,k, 0) =                                                          &
   436: |||     A           & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   437: |||     A           & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)&
   438: |||     A           & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   439: |**---- A         xyra_TempMtx(:,:,k, 1) = &
   440: |                   & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
   441: W------         end do
   442:             
   443:                 k = kmax
   444: *W----->A       xyra_TempMtx(:,:,k,-1) = &
   445: ||                & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
   446: ||      A       xyra_TempMtx(:,:,k, 0) =                                                          &
   447: ||                & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   448: ||                & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)
   449: *W-----         xyra_TempMtx(:,:,k, 1) = 0.0_DP
   450:             
   451:             
   452:             
   453:             
   454:                 ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (比湿)
   455:                 ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (specific humidity)
   456:                 !
   457:                 ! 飽和比湿の計算
   458:                 ! Calculate saturated specific humidity
   459:                 !
   460:                 xy_SurfQVapSat       = &
   461:                   & xy_CalcQVapSat      ( xy_SurfTemp, xyr_Press(:,:,0) )
   462:                 xy_SurfDQVapSatDTemp = &
   463:                   & xy_CalcDQVapSatDTemp( xy_SurfTemp, xy_SurfQVapSat   )
   464:             
   465:                 k = 1
   466:                 if ( FlagBucketModel ) then
   467: *V----->          xyza_QVapMtx(:,:,k,-1) =                                                  &
   468: ||                  & 0.0d0
   469: *V----- A         xyza_QVapMtx(:,:,k, 0) =                                                  &
   470:                     & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   471:                     & + xyr_QMixTransCoef(:,:,k  )
   472:                 else
   473: *V----->A         xyza_QVapMtx(:,:,k,-1) =                                                  &
   474: ||                  & - xy_SurfHumidCoef(:,:) * xy_SurfQVapTransCoef(:,:)                   &
   475: ||                  &   * xy_SurfDQVapSatDTemp(:,:)
   476: *V----- A         xyza_QVapMtx(:,:,k, 0) =                                                  &
   477:                     & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   478:                     & + xy_SurfHumidCoef(:,:) * xy_SurfQVapTransCoef(:,:)                   &
   479:                     & + xyr_QMixTransCoef(:,:,k  )
   480:                 end if
   481: W*=====         xyza_QVapMtx(:,:,k, 1) =                                                  &
   482:                   & - xyr_QMixTransCoef(:,:,k  )
   483:             
   484: W------>        do k = 2, kmax-1
   485: |**---->          xyza_QVapMtx(:,:,k,-1) = &
   486: |||                 & - xyr_QMixTransCoef(:,:,k-1)
   487: |||     A         xyza_QVapMtx(:,:,k, 0) =                                                  &
   488: |||                 & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   489: |||                 & + xyr_QMixTransCoef(:,:,k-1)                                          &
   490: |||                 & + xyr_QMixTransCoef(:,:,k  )
   491: |**----           xyza_QVapMtx(:,:,k, 1) = &
   492: |                   & - xyr_QMixTransCoef(:,:,k  )
   493: W------         end do
   494:             
   495:                 k = kmax
   496: *W----->        xyza_QVapMtx(:,:,k,-1) = &
   497: ||                & - xyr_QMixTransCoef(:,:,k-1)
   498: ||      A       xyza_QVapMtx(:,:,k, 0) =                                                  &
   499: ||                & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   500: ||                & + xyr_QMixTransCoef(:,:,k-1)
   501: *W-----         xyza_QVapMtx(:,:,k, 1) = 0.0_DP
   502:             
   503:             
   504:                 ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (比湿を除く混合比)
   505:                 ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (mixing ratio except for specific humidity)
   506:                 !
   507:                 k = 1
   508: *W----->        xyza_QMixMtx(:,:,k,-1) =                                                  &
   509: ||                & 0.0d0
   510: ||      A       xyza_QMixMtx(:,:,k, 0) =                                                  &
   511: ||                & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   512: ||                & + xyr_QMixTransCoef(:,:,k  )
   513: *W-----         xyza_QMixMtx(:,:,k, 1) =                                                  &
   514:                   & - xyr_QMixTransCoef(:,:,k  )
   515:             
   516: *------>        do l = -1, 1
   517: |W----->          do k = 2, kmax
   518: ||**===             xyza_QMixMtx(:,:,k,l) = xyza_QVapMtx(:,:,k,l)
   519: |W-----           end do
   520: *------         end do
   521:             
   522:             
   523:                 ! 地表面過程の輸送係数から陰解行列の計算
   524:                 ! Calculate implicit matrices from transfer coefficient of surface process
   525:                 !
   526: +------>        do i = 0, imax-1
   527: |V----->          do j = 1, jmax
   528: ||      A           if ( xy_SurfCond(i,j) == 1 ) then
   529: ||          
   530: ||                    if ( FlagBucketModel ) then
   531: ||      A               xyaa_SurfMtx(i,j,0,-1) =                                             &
   532: ||                        & 0.0_DP
   533: ||      A               xyaa_SurfMtx(i,j,0, 0) =                                             &
   534: ||                        &   xy_SurfHeatCapacity(i,j) / ( 2.0_DP * DelTime )                    &
   535: ||                        & + CpDry * xy_SurfTempTransCoef(i,j)                              &
   536: ||                        & + xyra_DelRadLFlux(i,j,0,0)
   537: ||                    else
   538: ||      A               xyaa_SurfMtx(i,j,0,-1) =                                             &
   539: ||                        & - LatentHeat * xy_SurfHumidCoef(i,j) * xy_SurfQVapTransCoef(i,j)
   540: ||      A               xyaa_SurfMtx(i,j,0, 0) =                                             &
   541: ||                        &   xy_SurfHeatCapacity(i,j) / ( 2.0_DP * DelTime )                    &
   542: ||                        & + CpDry * xy_SurfTempTransCoef(i,j)                              &
   543: ||                        & + xyra_DelRadLFlux(i,j,0,0)                                      &
   544: ||                        & + LatentHeat * xy_SurfHumidCoef(i,j) * xy_SurfQVapTransCoef(i,j) &
   545: ||                        &   * xy_SurfDQVapSatDTemp(i,j)
   546: ||                    end if
   547: ||      A             xyaa_SurfMtx(i,j,0, 1) =                                             &
   548: ||                      & - CpDry * xyr_Exner(i,j,0) / xyz_Exner(i,j,1)                    &
   549: ||                      &   * xy_SurfTempTransCoef(i,j)                                    &
   550: ||                      & + xyra_DelRadLFlux(i,j,0,1)
   551: ||                  else
   552: ||      A             xyaa_SurfMtx(i,j,0,-1) = 0.0_DP
   553: ||      A             xyaa_SurfMtx(i,j,0, 0) = 1.0_DP
   554: ||      A             xyaa_SurfMtx(i,j,0, 1) = 0.0_DP
   555: ||                  end if
   556: |V-----           end do
   557: +------         end do
   558:             
   559:             
   560:                 ! 東西風速, 南北風速の計算
   561:                 ! Calculate eastward and northward wind
   562:                 !
   563: W***=== A       xyza_UVLUMtx = xyza_UVMtx
   564:             
   565:                 call PhyImplLUDecomp3( &
   566:                   & xyza_UVLUMtx, &     ! (inout)
   567:                   & imax * jmax, kmax ) ! (in)
   568:             
   569: W------>        do k = 1, kmax
   570: |**---->A         xyz_DUDt(:,:,k) = - ( xyr_MomFluxX(:,:,k) - xyr_MomFluxX(:,:,k-1) )
   571: |**---- A         xyz_DVDt(:,:,k) = - ( xyr_MomFluxY(:,:,k) - xyr_MomFluxY(:,:,k-1) )
   572: W------         end do
   573:             
   574:                 call PhyImplLUSolve3( &
   575:                   & xyz_DUDt, &            ! (inout)
   576:                   & xyza_UVLUMtx, &        ! (in)
   577:                   & 1, imax * jmax, kmax ) ! (in)
   578:             
   579:                 call PhyImplLUSolve3( &
   580:                   & xyz_DVDt, &            ! (inout)
   581:                   & xyza_UVLUMtx, &        ! (in)
   582:                   & 1, imax * jmax, kmax ) ! (in)
   583:             
   584:                 ! 温度と比湿の計算
   585:                 ! Calculate temperature and specific humidity
   586:                 !
   587: +------>        do l = -1, 1
   588: |           
   589: |+----->          do k = 1, kmax
   590: ||W*=== A           xyza_TempQVapLUMtx(:,:,-k,-l) = xyza_QVapMtx(:,:,k,l)
   591: |+-----           end do
   592: |           
   593: |                 k = 0
   594: |W*==== A         xyza_TempQVapLUMtx(:,:, k, l) = xyaa_SurfMtx(:,:,0,l)
   595: |           
   596: |W----->          do k =  1,  kmax
   597: ||**=== A           xyza_TempQVapLUMtx(:,:, k, l) = xyra_TempMtx(:,:,k,l)
   598: |W-----           end do
   599: |           
   600: +------         end do
   601:             
   602:                 call PhyImplLUDecomp3( &
   603:                   & xyza_TempQVapLUMtx, &         ! (inout)
   604:                   & imax * jmax, (2 * kmax) + 1 ) ! (in)
   605:             
   606: +------>        do k = 1, kmax
   607: |W*==== A         xyz_DelTempQVap(:,:,-k) = &
   608: |                   & - ( xyrf_QMixFlux(:,:,k,IndexH2OVap) - xyrf_QMixFlux(:,:,k-1,IndexH2OVap) )
   609: +------         end do
   610:             
   611:                 k = 0
   612: W------>        do j = 1, jmax
   613: |*----->          do i = 0, imax-1
   614: ||      A           if ( xy_SurfCond(i,j) == 1 ) then
   615: ||      A             xyz_DelTempQVap(i,j,k) =                            &
   616: ||                      & - xyr_RadSFlux(i,j,0)                           &
   617: ||                      & - xyr_RadLFlux(i,j,0)                           &
   618: ||                      & - xyr_HeatFlux(i,j,0)                           &
   619: ||                      & - LatentHeat * xyrf_QMixFlux(i,j,0,IndexH2OVap) &
   620: ||                      & + xy_GroundTempFlux(i,j)
   621: ||                  else
   622: ||                    xyz_DelTempQVap(i,j,k) = 0.0_DP
   623: ||                  end if
   624: |*----- A         end do
   625: W------         end do
   626:             
   627: W------>        do k = 1, kmax
   628: |**==== A         xyz_DelTempQVap(:,:,k) = - ( xyr_HeatFlux(:,:, k) - xyr_HeatFlux(:,:,  k-1 ) )
   629: W------         end do
   630:             
   631:                 call PhyImplLUSolve3( &
   632:                   & xyz_DelTempQVap, &                ! (inout)
   633:                   & xyza_TempQVapLUMtx, &             ! (in)
   634:                   & 1, imax * jmax , (2 * kmax) + 1 ) ! (in)
   635:             
   636:                 ! 時間変化率の計算
   637:                 ! Calculate tendency
   638:                 !
   639: +------>        do k = 1, kmax
   640: |*W---->A         xyz_DUDt(:,:,k)                 = xyz_DUDt(:,:,k)         / ( 2.0_DP * DelTime )
   641: |||     A         xyz_DVDt(:,:,k)                 = xyz_DVDt(:,:,k)         / ( 2.0_DP * DelTime )
   642: |||     A         xyz_DTempDt(:,:,k)              = xyz_DelTempQVap(:,:, k) / ( 2.0_DP * DelTime )
   643: |*W---- A         xyzf_DQMixDt(:,:,k,IndexH2OVap) = xyz_DelTempQVap(:,:,-k) / ( 2.0_DP * DelTime )
   644: +------         end do
   645:             
   646: W------>        do j = 1, jmax
   647: |*----->          do i = 0, imax-1
   648: ||      A           if ( xy_SurfCond(i,j) == 1 ) then
   649: ||      A             xy_DSurfTempDt(i,j) = xyz_DelTempQVap(i,j,0) / ( 2.0_DP * DelTime )
   650: ||                  else
   651: ||                    xy_DSurfTempDt(i,j) = 0.0_DP
   652: ||                  end if
   653: |*----- A         end do
   654: W------         end do
   655:             
   656:             
   657:                 ! 比湿を除く質量混合比
   658:                 ! Calculate mass mixing ratio except for specific humidity
   659:                 !
   660: W***=== A       xyza_QMixLUMtx = xyza_QMixMtx
   661:             
   662:                 call PhyImplLUDecomp3( &
   663:                   & xyza_QMixLUMtx,    & ! (inout)
   664:                   & imax * jmax, kmax  & ! (in)
   665:                   & )
   666:             
   667: +------>        do n = 1, ncmax
   668: |                 if ( n == IndexH2OVap ) cycle
   669: |           
   670: |W----->          do k = 1, kmax
   671: ||**=== A           xyzf_DQMixDt(:,:,k,n) = &
   672: ||                    & - ( xyrf_QMixFlux(:,:,k,n) - xyrf_QMixFlux(:,:,k-1,n) )
   673: |W-----           end do
   674: |           
   675: |                 call PhyImplLUSolve3(      &
   676: |                   & xyzf_DQMixDt(:,:,:,n), & ! (inout)
   677: |                   & xyza_QMixLUMtx,        & ! (in)
   678: |                   & 1, imax * jmax, kmax   & ! (in)
   679: |                   & )
   680: +------         end do
   681:             
   682:             
   683:             
   684:                 !#########################################################
   685:                 ! code for debug, this will be removed, (Y. O. Takahashi, 2009/04/07)
   686:             !!$    i = 1
   687:             !!$    j = jmax / 2
   688:             !!$    n = IndexH2OVap
   689:             !!$    write( 6, * ) &
   690:             !!$      & - xyr_RadSFlux(i,j,0),                                                      &
   691:             !!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
   692:             !!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
   693:             !!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) ), &
   694:             !!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
   695:             !!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
   696:             !!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
   697:             !!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) ),   &
   698:             !!$      & - LatentHeat                                                                &
   699:             !!$      &   * ( xyrf_QMixFlux(i,j,0,n)                                                &
   700:             !!$      &     - xy_SurfQVapTransCoef(i,j)                                             &
   701:             !!$      &       * ( xyzf_DQMixDt(i,j,1,n)                                             &
   702:             !!$      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
   703:             !!$      &       * ( 2.0d0 * DelTime ) ) !, &
   704:             !!$!      & + xy_GroundTempFlux(i,j)
   705:             !!$    write( 6, * ) &
   706:             !!$      & - xyr_RadSFlux(i,j,0)                                                       &
   707:             !!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
   708:             !!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
   709:             !!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) )  &
   710:             !!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
   711:             !!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
   712:             !!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
   713:             !!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) )    &
   714:             !!$      & - LatentHeat                                                                &
   715:             !!$      &   * ( xyrf_QMixFlux(i,j,0,n)                                                &
   716:             !!$      &     - xy_SurfQVapTransCoef(i,j)                                             &
   717:             !!$      &       * ( xyzf_DQMixDt(i,j,1,n)                                             &
   718:             !!$      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
   719:             !!$      &       * ( 2.0d0 * DelTime ) ) !, &
   720:             !!$!      & + xy_GroundTempFlux(i,j)
   721:             !!$
   722:             !!$    xy_SurfQVapSat(i,j) =                                                           &
   723:             !!$      & - xyr_RadSFlux(i,j,0)                                                       &
   724:             !!$      & - ( xyr_RadLFlux(i,j,0)                                                     &
   725:             !!$      &   + xyra_DelRadLFlux(i,j,0,0) * xy_DSurfTempDt(i,j) * ( 2.0d0 * DelTime )   &
   726:             !!$      &   + xyra_DelRadLFlux(i,j,0,1) * xyz_DTempDt(i,j,1) * ( 2.0d0 * DelTime ) )  &
   727:             !!$      & - ( xyr_HeatFlux(i,j,0)                                                     &
   728:             !!$      &   - CpDry * xyr_Exner(i,j,0) * xy_SurfTempTransCoef(i,j)                    &
   729:             !!$      &     * ( xyz_DTempDt(i,j,1) / xyz_Exner(i,j,1)                               &
   730:             !!$      &       - xy_DSurfTempDt(i,j) / xyr_Exner(i,j,0) ) * ( 2.0d0 * DelTime ) )    &
   731:             !!$      & - LatentHeat                                                                &
   732:             !!$!      &   * ( xyr_QVapFlux(i,j,0)                                                   &
   733:             !!$!      &     - xy_SurfQVapTransCoef(i,j)                                             &
   734:             !!$!      &       * ( xyz_DQVapDt(i,j,1)                                                &
   735:             !!$!      &         - xy_SurfDQVapSatDTemp(i,j) * xy_DSurfTempDt(i,j) )                 &
   736:             !!$!      &       * ( 2.0d0 * DelTime ) )
   737:             !!$      &   * xyrf_QMixFlux(i,j,0,n)
   738:             !!$    write( 6, * ) xy_SurfQVapSat(i,j)
   739:                 !#########################################################
   740:             
   741:             
   742:             
   743:                 ! 計算時間計測一時停止
   744:                 ! Pause measurement of computation time
   745:                 !
   746:                 call TimesetClockStop( module_name )
   747:             
   748:               end subroutine PhyImplTendency
   749:             
   750:               !--------------------------------------------------------------------------------------
   751:             
   752:               subroutine PhyImplInit(              &
   753:                 & ArgFlagBucketModel, ArgFlagSnow  & ! (in)
   754:                 & )
   755:                 !
   756:                 ! phy_implicit モジュールの初期化を行います. 
   757:                 ! NAMELIST#phy_implicit_nml の読み込みはこの手続きで行われます. 
   758:                 !
   759:                 ! "phy_implicit" module is initialized. 
   760:                 ! "NAMELIST#phy_implicit_nml" is loaded in this procedure. 
   761:                 !
   762:             
   763:                 ! モジュール引用 ; USE statements
   764:                 !
   765:             
   766:                 ! NAMELIST ファイル入力に関するユーティリティ
   767:                 ! Utilities for NAMELIST file input
   768:                 !
   769:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   770:             
   771:                 ! ファイル入出力補助
   772:                 ! File I/O support
   773:                 !
   774:                 use dc_iounit, only: FileOpen
   775:             
   776:                 ! 種別型パラメタ
   777:                 ! Kind type parameter
   778:                 !
   779:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   780:             
   781:                 ! 文字列操作
   782:                 ! Character handling
   783:                 !
   784:                 use dc_string, only: StoA
   785:             
   786:                 ! ヒストリデータ出力
   787:                 ! History data output
   788:                 !
   789:                 use gtool_historyauto, only: HistoryAutoAddVariable
   790:             
   791:                 ! 宣言文 ; Declaration statements
   792:                 !
   793:                 implicit none
   794:             
   795:                 logical, intent(in ) :: ArgFlagBucketModel
   796:                 logical, intent(in ) :: ArgFlagSnow
   797:             
   798:             
   799:                 ! 作業変数
   800:                 ! Work variables
   801:                 !
   802:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   803:             !!$                              ! Unit number for NAMELIST file open
   804:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   805:             !!$                              ! IOSTAT of NAMELIST read
   806:             
   807:                 ! NAMELIST 変数群
   808:                 ! NAMELIST group name
   809:                 !
   810:             !!$    namelist /phy_implicit_nml/
   811:             !!$          !
   812:             !!$          ! デフォルト値については初期化手続 "phy_implicit#PhyImplInit" 
   813:             !!$          ! のソースコードを参照のこと. 
   814:             !!$          !
   815:             !!$          ! Refer to source codes in the initialization procedure
   816:             !!$          ! "phy_implicit#PhyImplInit" for the default values. 
   817:             !!$          !
   818:             
   819:                 ! 実行文 ; Executable statement
   820:                 !
   821:             
   822:                 if ( phy_implicit_inited ) return
   823:             
   824:             
   825:                 ! デフォルト値の設定
   826:                 ! Default values settings
   827:                 !
   828:             
   829:                 ! NAMELIST の読み込み
   830:                 ! NAMELIST is input
   831:                 !
   832:             !!$    if ( trim(namelist_filename) /= '' ) then
   833:             !!$      call FileOpen( unit_nml, &          ! (out)
   834:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   835:             !!$
   836:             !!$      rewind( unit_nml )
   837:             !!$      read( unit_nml, &           ! (in)
   838:             !!$        & nml = phy_implicit_nml, &  ! (out)
   839:             !!$        & iostat = iostat_nml )   ! (out)
   840:             !!$      close( unit_nml )
   841:             !!$
   842:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   843:             !!$    end if
   844:             
   845:             
   846:                 FlagBucketModel = ArgFlagBucketModel
   847:                 FlagSnow        = ArgFlagSnow
   848:             
   849:                 ! 印字 ; Print
   850:                 !
   851:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   852:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   853:             
   854:                 phy_implicit_inited = .true.
   855:             
   856:               end subroutine PhyImplInit
   857:             
   858:               !--------------------------------------------------------------------------------------
   859:             
   860:             end module phy_implicit
