Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:27 2016
FILE NAME: phy_implicit_atmonly.f90
PROGRAM NAME: phy_implicit_atmonly
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   293  opt  (  11): Fused array assignments. :line 293 - 298
   293  opt  (1593): Loop nest collapsed into one loop.
   293  vec  (   4): Vectorized array expression.
   300  opt  (1593): Loop nest collapsed into one loop.
   300  vec  (   1): Vectorized loop.
   300  vec  (  29): ADB is used for array.: xyr_qmixdiffcoef
   300  vec  (  29): ADB is used for array.: xyr_tempdiffcoef
   300  vec  (  29): ADB is used for array.: xyz_height
   300  vec  (  29): ADB is used for array.: xyr_virtemp
   300  vec  (  29): ADB is used for array.: xyr_press
   300  vec  (  29): ADB is used for array.: xyr_veldiffcoef
   301  opt  (  11): Fused array assignments. :line 301 - 311
   326  opt  (  11): Fused array assignments. :line 326 - 331
   326  opt  (1593): Loop nest collapsed into one loop.
   326  vec  (   4): Vectorized array expression.
   326  vec  (  29): ADB is used for array.: xyr_press
   326  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   334  opt  (1593): Loop nest collapsed into one loop.
   334  vec  (   1): Vectorized loop.
   334  vec  (  29): ADB is used for array.: xyr_press
   335  opt  (  11): Fused array assignments. :line 335 - 341
   346  opt  (  11): Fused array assignments. :line 346 - 351
   346  opt  (1593): Loop nest collapsed into one loop.
   346  vec  (   4): Vectorized array expression.
   346  vec  (  29): ADB is used for array.: xyr_press
   358  opt  (1593): Loop nest collapsed into one loop.
   358  vec  (   4): Vectorized array expression.
   361  vec  (   4): Vectorized array expression.
   361  vec  (  29): ADB is used for array.: xyr_press
   361  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   361  vec  (  29): ADB is used for array.: xyz_exner
   361  vec  (  29): ADB is used for array.: xyr_exner
   367  opt  (1593): Loop nest collapsed into one loop.
   367  vec  (   4): Vectorized array expression.
   367  vec  (  29): ADB is used for array.: xyr_press
   367  vec  (  29): ADB is used for array.: xyz_exner
   367  vec  (  29): ADB is used for array.: xyr_exner
   371  opt  (1593): Loop nest collapsed into one loop.
   371  vec  (   4): Vectorized array expression.
   371  vec  (  29): ADB is used for array.: xyz_exner
   371  vec  (  29): ADB is used for array.: xyr_exner
   374  opt  (1593): Loop nest collapsed into one loop.
   374  vec  (   1): Vectorized loop.
   374  vec  (  29): ADB is used for array.: xyr_press
   374  vec  (  29): ADB is used for array.: xyr_exner
   374  vec  (  29): ADB is used for array.: xyz_exner
   375  opt  (  11): Fused array assignments. :line 375 - 381
   386  opt  (  11): Fused array assignments. :line 386 - 391
   386  opt  (1593): Loop nest collapsed into one loop.
   386  vec  (   4): Vectorized array expression.
   386  vec  (  29): ADB is used for array.: xyr_press
   386  vec  (  29): ADB is used for array.: xyz_exner
   386  vec  (  29): ADB is used for array.: xyr_exner
   400  opt  (1593): Loop nest collapsed into one loop.
   400  vec  (   4): Vectorized array expression.
   404  opt  (1592): Outer loop unrolled inside inner loop.
   404  vec  (   4): Vectorized array expression.
   404  vec  (  29): ADB is used for array.: xyr_press
   404  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   404  vec  (   4): Vectorized array expression.
   404  vec  (  29): ADB is used for array.: xyr_press
   404  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   410  opt  (1593): Loop nest collapsed into one loop.
   410  vec  (   4): Vectorized array expression.
   410  vec  (  29): ADB is used for array.: xyr_press
   414  opt  (1593): Loop nest collapsed into one loop.
   414  vec  (   4): Vectorized array expression.
   417  opt  (1593): Loop nest collapsed into one loop.
   417  vec  (   1): Vectorized loop.
   417  vec  (  29): ADB is used for array.: xyr_press
   418  opt  (  11): Fused array assignments. :line 418 - 424
   429  opt  (  11): Fused array assignments. :line 429 - 434
   429  opt  (1593): Loop nest collapsed into one loop.
   429  vec  (   4): Vectorized array expression.
   429  vec  (  29): ADB is used for array.: xyr_press
   442  opt  (1772): Loop nest fused with following nest(s).
   442  opt  (1593): Loop nest collapsed into one loop.
   442  vec  (   4): Vectorized array expression.
   442  vec  (  29): ADB is used for array.: xyza_uvlumtx
   448  opt  (1593): Loop nest collapsed into one loop.
   448  vec  (   1): Vectorized loop.
   448  vec  (  29): ADB is used for array.: xyz_dvdt
   448  vec  (  29): ADB is used for array.: xyr_momfluxy
   448  vec  (  29): ADB is used for array.: xyz_dudt
   448  vec  (  29): ADB is used for array.: xyr_momfluxx
   449  opt  (  11): Fused array assignments. :line 449 - 450
   463  opt  (1593): Loop nest collapsed into one loop.
   463  vec  (   1): Vectorized loop.
   463  vec  (  29): ADB is used for array.: xyz_dvdt
   463  vec  (  29): ADB is used for array.: xyz_dudt
   464  opt  (  11): Fused array assignments. :line 464 - 465
   472  opt  (1772): Loop nest fused with following nest(s).
   472  opt  (1593): Loop nest collapsed into one loop.
   472  vec  (   4): Vectorized array expression.
   472  vec  (  29): ADB is used for array.: xyaa_templumtx
   479  opt  (1593): Loop nest collapsed into one loop.
   479  vec  (   1): Vectorized loop.
   479  vec  (  29): ADB is used for array.: xya_deltempluvec
   479  vec  (  29): ADB is used for array.: xyr_heatflux
   490  opt  (1593): Loop nest collapsed into one loop.
   490  vec  (   4): Vectorized array expression.
   490  vec  (  29): ADB is used for array.: xyz_dtempdt
   490  vec  (  29): ADB is used for array.: xya_deltempluvec
   496  opt  (1772): Loop nest fused with following nest(s).
   496  opt  (1593): Loop nest collapsed into one loop.
   496  vec  (   4): Vectorized array expression.
   496  vec  (  29): ADB is used for array.: xyza_qmixlumtx
   504  opt  (1593): Loop nest collapsed into one loop.
   504  vec  (   1): Vectorized loop.
   504  vec  (  29): ADB is used for array.: xyz_delqmixluvec
   504  vec  (  29): ADB is used for array.: xyrf_qmixflux
   509  opt  (1017): Subroutine call prevents optimization.
   515  opt  (1593): Loop nest collapsed into one loop.
   515  vec  (   4): Vectorized array expression.
   515  vec  (  29): ADB is used for array.: xyzf_dqmixdt
   515  vec  (  29): ADB is used for array.: xyz_delqmixluvec
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:27 2016
FILE NAME: phy_implicit_atmonly.f90
PROGRAM NAME: phy_implicit_atmonly
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 陰解法による時間積分 (大気のみ / 惑星表面温度・土壌温度計算なし)
     2  !
     3  != Time integration by using implicit scheme in case without calculation of surface and soil temperature
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: phy_implicit_atmonly.f90,v 1.5 2015/01/29 12:05:01 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module phy_implicit_atmonly
    13    !
    14    != 陰解法による時間積分 (大気のみ / 惑星表面温度・土壌温度計算なし)
    15    !
    16    != Time integration by using implicit scheme in case without calculation of surface and soil temperature
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22    ! PhyImplTendency      :: 時間変化率の計算
    23    ! ------------         :: ------------
    24    ! PhyImplTendency      :: Calculate tendency
    25    !
    26    !--
    27    !== NAMELIST
    28    !
    29    ! NAMELIST#phy_implicit_nml
    30    !++
    31  
    32    ! モジュール引用 ; USE statements
    33    !
    34  
    35    ! 格子点設定
    36    ! Grid points settings
    37    !
    38    use gridset, only:   imax, & ! 経度格子点数.
    39                                 ! Number of grid points in longitude
    40      &                  jmax, & ! 緯度格子点数.
    41                                 ! Number of grid points in latitude
    42      &                  kmax, & ! 鉛直層数.
    43                                 ! Number of vertical level
    44      &                  kslmax  ! 地下の鉛直層数.
    45                                 ! Number of subsurface vertical level
    46  
    47    ! 組成に関わる配列の設定
    48    ! Settings of array for atmospheric composition
    49    !
    50    use composition, only: ncmax, IndexH2OVap
    51  
    52    ! 種別型パラメタ
    53    ! Kind type parameter
    54    !
    55    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    56      &                 STRING     ! 文字列.       Strings.
    57  
    58    ! メッセージ出力
    59    ! Message output
    60    !
    61    use dc_message, only: MessageNotify
    62  
    63    ! 宣言文 ; Declaration statements
    64    !
    65    implicit none
    66    private
    67  
    68    ! 公開手続き
    69    ! Public procedure
    70    !
    71    public :: PhyImplAtmOnlyTendency
    72    public :: PhyImplAtmOnlyInit
    73  
    74  
    75    ! 公開変数
    76    ! Public variables
    77    !
    78  
    79    ! 非公開変数
    80    ! Private variables
    81    !
    82    logical, save :: FlagPresSurfTemp
    83    logical, save :: FlagPresSurfQMix
    84  
    85  
    86    logical, save :: phy_implicit_atmonly_inited = .false.
    87                                ! 初期設定フラグ.
    88                                ! Initialization flag
    89  
    90    character(*), parameter:: module_name = 'phy_implicit_atmonly'
    91                                ! モジュールの名称.
    92                                ! Module name
    93    character(*), parameter:: version = &
    94      & '$Name:  $' // &
    95      & '$Id: phy_implicit_atmonly.f90,v 1.5 2015/01/29 12:05:01 yot Exp $'
    96                                ! モジュールのバージョン
    97                                ! Module version
    98  
    99  
   100  contains
   101  
   102    subroutine PhyImplAtmOnlyTendency(                           &
   103      & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
   104      & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
   105      & xyr_VirTemp, xyz_Height,                                 & ! (in)
   106      & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,     & ! (in)
   107      & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
   108      & xy_SurfQVapTransCoef,                                    & ! (in)
   109      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt            & ! (out)
   110      & )
   111      !
   112      ! 時間変化率の計算を行います.
   113      !
   114      ! Calculate tendencies.
   115      !
   116  
   117      ! モジュール引用 ; USE statements
   118      !
   119  
   120      ! 物理定数設定
   121      ! Physical constants settings
   122      !
   123      use constants, only: &
   124        & Grav, &               ! $ g $ [m s-2].
   125                                ! 重力加速度.
   126                                ! Gravitational acceleration
   127        & CpDry, &
   128                                ! $ C_p $ [J kg-1 K-1].
   129                                ! 乾燥大気の定圧比熱.
   130                                ! Specific heat of air at constant pressure
   131        & LatentHeat, &
   132                                ! $ L $ [J kg-1] .
   133                                ! 凝結の潜熱.
   134                                ! Latent heat of condensation
   135        & GasRDry
   136                                ! $ R $ [J kg-1 K-1].
   137                                ! 乾燥大気の気体定数.
   138                                ! Gas constant of air
   139  
   140      ! 時刻管理
   141      ! Time control
   142      !
   143      use timeset, only: &
   144        & DelTime, &            ! $ \Delta t $ [s]
   145        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   146        & TimesetClockStart, TimesetClockStop
   147  
   148      ! 陰解法による時間積分のためのルーチン
   149      ! Routines for time integration with implicit scheme
   150      !
   151      use phy_implicit_utils, only : PhyImplLUDecomp3, PhyImplLUSolve3
   152  
   153      ! 宣言文 ; Declaration statements
   154      !
   155      implicit none
   156  
   157      real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
   158                                ! 東西方向運動量フラックス.
   159                                ! Eastward momentum flux
   160      real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
   161                                ! 南北方向運動量フラックス.
   162                                ! Northward momentum flux
   163      real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   164                                ! 熱フラックス.
   165                                ! Heat flux
   166      real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   167                                ! 比湿フラックス.
   168                                ! Specific humidity flux
   169  
   170      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   171                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   172                                ! Air pressure (half level)
   173      real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   174                                ! Exner 関数 (整数レベル).
   175                                ! Exner function (full level)
   176      real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   177                                ! Exner 関数 (半整数レベル).
   178                                ! Exner function (half level)
   179  
   180      real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   181                                ! $ \hat{T}_v $ . 仮温度 (半整数レベル).
   182                                ! Virtual temperature (half level)
   183      real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   184                                ! 高度 (整数レベル).
   185                                ! Height (full level)
   186  
   187      real(DP), intent(in):: xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   188                                ! 拡散係数：運動量.
   189                                ! Diffusion coefficient: velocity
   190      real(DP), intent(in):: xyr_TempDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   191                                ! 拡散係数：温度.
   192                                ! Transfer coefficient: temperature
   193      real(DP), intent(in):: xyr_QMixDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   194                                ! 拡散係数：比湿.
   195                                ! Diffusion coefficient: specific humidity
   196  
   197      real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   198                                ! 輸送係数：運動量.
   199                                ! Diffusion coefficient: velocity
   200      real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   201                                ! 輸送係数：温度.
   202                                ! Transfer coefficient: temperature
   203      real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   204                                ! 輸送係数：比湿.
   205                                ! Transfer coefficient: specific humidity
   206  
   207      real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   208                                ! $ \DP{u}{t} $ . 東西風速変化.
   209                                ! Eastward wind tendency
   210      real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   211                                ! $ \DP{v}{t} $ . 南北風速変化.
   212                                ! Northward wind tendency
   213      real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   214                                ! $ \DP{T}{t} $ . 温度変化.
   215                                ! Temperature tendency
   216      real(DP), intent(out):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   217                                ! $ \DP{q}{t} $ . 質量混合比変化.
   218                                ! Mass mixing ratio tendency
   219  
   220      ! 作業変数
   221      ! Work variables
   222      !
   223  
   224      real(DP) :: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
   225                                ! 輸送係数：運動量.
   226                                ! Transfer coefficient: velocity
   227      real(DP) :: xyr_TempTransCoef (0:imax-1, 1:jmax, 0:kmax)
   228                                ! 輸送係数：温度.
   229                                ! Transfer coefficient: temperature
   230      real(DP) :: xyr_QMixTransCoef(0:imax-1, 1:jmax, 0:kmax)
   231                                ! 輸送係数：質量.
   232                                ! Transfer coefficient: mass of constituents
   233  
   234      real(DP):: xyza_UVMtx  (0:imax-1, 1:jmax, 1:kmax, -1:1)
   235                                ! 速度陰解行列.
   236                                ! Implicit matrix about velocity
   237      real(DP):: xyra_TempMtx(0:imax-1, 1:jmax, 1:kmax, -1:1)
   238                                ! 温度陰解行列.
   239                                ! Implicit matrix about temperature
   240      real(DP):: xyza_QMixMtx(0:imax-1, 1:jmax, 1:kmax, -1:1)
   241                                ! 質量混合比陰解行列.
   242                                ! Implicit matrix about mass mixing ratio
   243  
   244      real(DP):: xyza_UVLUMtx    (0:imax-1, 1:jmax, 1:kmax,-1:1)
   245                                ! LU 行列.
   246                                ! LU matrix
   247      real(DP):: xyza_QMixLUMtx  (0:imax-1, 1:jmax, 1:kmax, -1:1)
   248                                ! LU 行列.
   249                                ! LU matrix
   250      real(DP):: xyz_DelQMixLUVec(0:imax-1, 1:jmax, 1:kmax)
   251                                ! $ q $ の時間変化.
   252                                ! Tendency of $ q $
   253  
   254      real(DP):: xyaa_TempLUMtx  (0:imax-1, 1:jmax, 1:kmax, -1:1)
   255                                ! LU 行列.
   256                                ! LU matrix
   257      real(DP):: xya_DelTempLUVec(0:imax-1, 1:jmax, 1:kmax)
   258                                ! $ T, Tg $ の時間変化.
   259                                ! Tendency of $ T $ and $ Tg |
   260  
   261  
   262  !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   263  !!$                              ! Work variables for DO loop in longitude
   264  !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   265  !!$                              ! Work variables for DO loop in latitude
   266      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   267                                ! Work variables for DO loop in vertical direction
   268  !!$    integer:: l               ! 行列用 DO ループ用作業変数
   269  !!$                              ! Work variables for DO loop of matrices
   270      integer:: n               ! 組成方向に回る DO ループ用作業変数
   271                                ! Work variables for DO loop in dimension of constituents
   272  
   273      ! 実行文 ; Executable statement
   274      !
   275  
   276      ! 初期化確認
   277      ! Initialization check
   278      !
   279      if ( .not. phy_implicit_atmonly_inited ) then
   280        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   281      end if
   282  
   283  
   284      ! 計算時間計測開始
   285      ! Start measurement of computation time
   286      !
   287      call TimesetClockStart( module_name )
   288  
   289  
   290      ! 輸送係数の計算
   291      ! Calculate transfer coefficient
   292      !
   293      xyr_VelTransCoef (:,:,0)    = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1022 = 1, xyr_veltranscoef.DSC.U2*xyr_veltranscoef.DSC.U1 +   
     .       1   xyr_veltranscoef.DSC.U2                                        
     .           xyr_veltranscoef(t1022-1,1,0) = 0.0000000000000000e+000        
     .           xyr_veltranscoef(t1022-1,1,kmax) = 0.0000000000000000e+000     
     .           xyr_temptranscoef(t1022-1,1,0) = 0.0000000000000000e+000       
     .           xyr_temptranscoef(t1022-1,1,kmax) = 0.0000000000000000e+000    
     .           xyr_qmixtranscoef(t1022-1,1,0) = 0.0000000000000000e+000       
     .           xyr_qmixtranscoef(t1022-1,1,kmax) = 0.0000000000000000e+000    
     .        enddo                                                             
   294      xyr_VelTransCoef (:,:,kmax) = 0.0_DP
   295      xyr_TempTransCoef(:,:,0)    = 0.0_DP
   296      xyr_TempTransCoef(:,:,kmax) = 0.0_DP
   297      xyr_QMixTransCoef(:,:,0)    = 0.0_DP
   298      xyr_QMixTransCoef(:,:,kmax) = 0.0_DP
   299  
   300      do k = 1, kmax-1
   301        xyr_VelTransCoef(:,:,k) =                                     &
   302          &   xyr_VelDiffCoef(:,:,k)                                  &
   303          &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   304          &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   305  
   306        xyr_TempTransCoef(:,:,k) =                                    &
   307          &   xyr_TempDiffCoef(:,:,k)                                 &
   308          &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   309          &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   310  
   311        xyr_QMixTransCoef(:,:,k) =                                    &
   312          &   xyr_QMixDiffCoef(:,:,k)                                 &
   313          &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   314          &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   315      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyr_veltranscoef(k-1,1,1) = xyr_veldiffcoef(k-1,1,1)*xyr_press(
     .       1      k-1,1,1)/((gasrdry*xyr_virtemp(k-1,1,1))*(xyz_height(k-1,1,2
     .       2      )-xyz_height(k-1,1,1)))                                     
     .           xyr_temptranscoef(k-1,1,1) = xyr_tempdiffcoef(k-1,1,1)*        
     .       1      xyr_press(k-1,1,1)/((gasrdry*xyr_virtemp(k-1,1,1))*(        
     .       2      xyz_height(k-1,1,2)-xyz_height(k-1,1,1)))                   
     .           xyr_qmixtranscoef(k-1,1,1) = xyr_qmixdiffcoef(k-1,1,1)*        
     .       1      xyr_press(k-1,1,1)/((gasrdry*xyr_virtemp(k-1,1,1))*(        
     .       2      xyz_height(k-1,1,2)-xyz_height(k-1,1,1)))                   
     .        enddo                                                             
   316  
   317  
   318      ! 陰解法のための行列作成
   319      ! Create matrices for implicit scheme
   320      !
   321  
   322      ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (速度)
   323      ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (velocity)
   324      !
   325      k = 1
   326      xyza_UVMtx  (:,:,k,-1) = 0.0_DP
     .        d1 = 1.D0/grav                                                    
     .        d2 = d1/(2.00000000000000e+000*deltime)                           
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1078 = 1, xyza_uvmtx.DSC.U2*xyza_uvmtx.DSC.U1 +               
     .       1   xyza_uvmtx.DSC.U2                                              
     .           xyza_uvmtx(t1078-1,1,1,-1) = 0.0000000000000000e+000           
     .           xyza_uvmtx(t1078-1,1,1,0) = xy_surfveltranscoef(t1078-1,1) - ( 
     .       1      xyr_press(t1078-1,1,1)-xyr_press(t1078-1,1,0))*d2 +         
     .       2      xyr_veltranscoef(t1078-1,1,1)                               
     .           xyza_uvmtx(t1078-1,1,1,1) = -xyr_veltranscoef(t1078-1,1,1)     
     .        enddo                                                             
   327      xyza_UVMtx  (:,:,k, 0) =                                                  &
   328        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   329        & + xy_SurfVelTransCoef(:,:)                                            &
   330        & + xyr_VelTransCoef(:,:,k  )
   331      xyza_UVMtx  (:,:,k, 1) = &
   332        & - xyr_VelTransCoef(:,:,k)
   333  
   334      do k = 2, kmax-1
   335        xyza_UVMtx  (:,:,k,-1) = &
   336          & - xyr_VelTransCoef(:,:,k-1)
   337        xyza_UVMtx  (:,:,k, 0) =                                                  &
   338          & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   339          & + xyr_VelTransCoef(:,:,k-1)                                           &
   340          & + xyr_VelTransCoef(:,:,k  )
   341        xyza_UVMtx  (:,:,k, 1) = &
   342          & - xyr_VelTransCoef(:,:,k)
   343      end do
     .        d3 = 1.D0/grav                                                    
     .        d4 = d3/(2.00000000000000e+000*deltime)                           
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 2)*(xyr_veltranscoef.DSC.U2*                    
     .       1   xyr_veltranscoef.DSC.U1 + xyr_veltranscoef.DSC.U2)             
     .           xyza_uvmtx(k-1,1,2,-1) = -xyr_veltranscoef(k-1,1,1)            
     .           xyza_uvmtx(k-1,1,2,0) = xyr_veltranscoef(k-1,1,1) - (xyr_press(
     .       1      k-1,1,2)-xyr_press(k-1,1,1))*d4 + xyr_veltranscoef(k-1,1,2) 
     .           xyza_uvmtx(k-1,1,2,1) = -xyr_veltranscoef(k-1,1,2)             
     .        enddo                                                             
   344  
   345      k = kmax
   346      xyza_UVMtx  (:,:,k,-1) = &
     .        d5 = 1.D0/grav                                                    
     .        d6 = d5/(2.00000000000000e+000*deltime)                           
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1120 = 1, xyr_veltranscoef.DSC.U2*xyr_veltranscoef.DSC.U1 +   
     .       1   xyr_veltranscoef.DSC.U2                                        
     .           xyza_uvmtx(t1120-1,1,k,-1) = -xyr_veltranscoef(t1120-1,1,k-1)  
     .           xyza_uvmtx(t1120-1,1,k,0) = xyr_veltranscoef(t1120-1,1,k-1) - (
     .       1      xyr_press(t1120-1,1,k)-xyr_press(t1120-1,1,k-1))*d6         
     .           xyza_uvmtx(t1120-1,1,k,1) = 0.0000000000000000e+000            
     .        enddo                                                             
   347        & - xyr_VelTransCoef(:,:,k-1)
   348      xyza_UVMtx  (:,:,k, 0) =                                                  &
   349        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   350        & + xyr_VelTransCoef(:,:,k-1)
   351      xyza_UVMtx  (:,:,k, 1) = 0.0_DP
   352  
   353  
   354      ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (温度)
   355      ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (temperature)
   356      !
   357      k = 1
   358      xyra_TempMtx(:,:,k,-1) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1138 = 1, xyra_tempmtx.DSC.U2*xyra_tempmtx.DSC.U1 +           
     .       1   xyra_tempmtx.DSC.U2                                            
     .           xyra_tempmtx(t1138-1,1,1,-1) = 0.0000000000000000e+000         
     .        enddo                                                             
   359      if ( FlagPresSurfTemp ) then
   360        ! Prescribe surface temperature
   361        xyra_TempMtx(:,:,k, 0) =                                                          &
     .        d7 = cpdry/grav                                                   
     .        d8 = d7/(2.00000000000000e+000*deltime)                           
     .  !cdir nodep                                                             
     .        do t1438 = 1, 1 + imax - min0(1,imax)                             
     .           xyra_tempmtx(t1438-1,t1436+1,1,0) = cpdry*xyr_exner(t1438-1,   
     .       1      t1436+1,0)/xyz_exner(t1438-1,t1436+1,1)*xy_surftemptranscoef
     .       2      (t1438-1,t1436+1) - (xyr_press(t1438-1,t1436+1,1)-xyr_press(
     .       3      t1438-1,t1436+1,0))*d8 + cpdry*xyr_exner(t1438-1,t1436+1,1)/
     .       4      xyz_exner(t1438-1,t1436+1,1)*xyr_temptranscoef(t1438-1,t1436
     .       5      +1,1)                                                       
     .        enddo                                                             
   362          & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   363          & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xy_SurfTempTransCoef(:,:) &
   364          & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   365      else
   366        ! Prescribe surface flux
   367        xyra_TempMtx(:,:,k, 0) =                                                          &
     .        d9 = cpdry/grav                                                   
     .        d10 = d9/(2.00000000000000e+000*deltime)                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1144 = 1, jmax*imax                                           
     .           xyra_tempmtx(t1144-1,1,1,0) = cpdry*xyr_exner(t1144-1,1,1)/    
     .       1      xyz_exner(t1144-1,1,1)*xyr_temptranscoef(t1144-1,1,1) - (   
     .       2      xyr_press(t1144-1,1,1)-xyr_press(t1144-1,1,0))*d10          
     .        enddo                                                             
   368          & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   369          & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   370      end if
   371      xyra_TempMtx(:,:,k, 1) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1160 = 1, jmax*imax                                           
     .           xyra_tempmtx(t1160-1,1,1,1) = -cpdry*xyr_exner(t1160-1,1,1)/   
     .       1      xyz_exner(t1160-1,1,2)*xyr_temptranscoef(t1160-1,1,1)       
     .        enddo                                                             
   372        & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
   373  
   374      do k = 2, kmax-1
   375        xyra_TempMtx(:,:,k,-1) = &
   376          & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
   377        xyra_TempMtx(:,:,k, 0) =                                                          &
   378          & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   379          & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)&
   380          & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   381        xyra_TempMtx(:,:,k, 1) = &
   382          & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
   383      end do
     .        d11 = cpdry/grav                                                  
     .        d12 = d11/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 2)*jmax*imax                                    
     .           xyra_tempmtx(k-1,1,2,-1) = -(cpdry*xyr_exner(k-1,1,1))/        
     .       1      xyz_exner(k-1,1,1)*xyr_temptranscoef(k-1,1,1)               
     .           xyra_tempmtx(k-1,1,2,0) = (cpdry*xyr_exner(k-1,1,1))/xyz_exner(
     .       1      k-1,1,2)*xyr_temptranscoef(k-1,1,1) - (xyr_press(k-1,1,2)-  
     .       2      xyr_press(k-1,1,1))*d12 + (cpdry*xyr_exner(k-1,1,2))/       
     .       3      xyz_exner(k-1,1,2)*xyr_temptranscoef(k-1,1,2)               
     .           xyra_tempmtx(k-1,1,2,1) = -(cpdry*xyr_exner(k-1,1,2))/xyz_exner
     .       1      (k-1,1,3)*xyr_temptranscoef(k-1,1,2)                        
     .        enddo                                                             
   384  
   385      k = kmax
   386      xyra_TempMtx(:,:,k,-1) = &
     .        d13 = cpdry/grav                                                  
     .        d14 = d13/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1210 = 1, jmax*imax                                           
     .           xyra_tempmtx(t1210-1,1,k,-1) = -(cpdry*xyr_exner(t1210-1,1,k-1)
     .       1      )/xyz_exner(t1210-1,1,k-1)*xyr_temptranscoef(t1210-1,1,k-1) 
     .           xyra_tempmtx(t1210-1,1,k,0) = (cpdry*xyr_exner(t1210-1,1,k-1))/
     .       1      xyz_exner(t1210-1,1,k)*xyr_temptranscoef(t1210-1,1,k-1) - ( 
     .       2      xyr_press(t1210-1,1,k)-xyr_press(t1210-1,1,k-1))*d14        
     .           xyra_tempmtx(t1210-1,1,k,1) = 0.0000000000000000e+000          
     .        enddo                                                             
   387        & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
   388      xyra_TempMtx(:,:,k, 0) =                                                          &
   389        & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   390        & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)
   391      xyra_TempMtx(:,:,k, 1) = 0.0_DP
   392  
   393  
   394  
   395      ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (比湿)
   396      ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (specific humidity)
   397      !
   398  
   399      k = 1
   400      xyza_QMixMtx(:,:,k,-1) =                                                  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1236 = 1, xyza_qmixmtx.DSC.U2*xyza_qmixmtx.DSC.U1 +           
     .       1   xyza_qmixmtx.DSC.U2                                            
     .           xyza_qmixmtx(t1236-1,1,1,-1) = 0.0000000000000000e+000         
     .        enddo                                                             
   401        & 0.0_DP
   402      if ( FlagPresSurfQMix ) then
   403        ! Prescribe surface mixing ratio
   404        xyza_QMixMtx(:,:,k, 0) =                                                  &
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t1422 = 1, j1                                               
     .              d15 = 1.D0/grav                                             
     .              d16 = d15/(2.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do t1424 = 1, 1 + imax - min0(1,imax)                       
     .                 xyza_qmixmtx(t1424-1,t1422,1,0) = xy_surfqvaptranscoef(  
     .       1            t1424-1,t1422) - (xyr_press(t1424-1,t1422,1)-xyr_press
     .       2            (t1424-1,t1422,0))*d16 + xyr_qmixtranscoef(t1424-1,   
     .       3            t1422,1)                                              
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1422 = j1 + 1, jmax, 4                                     
     .              d17 = 1.D0/grav                                             
     .              d18 = d17/(2.00000000000000e+000*deltime)                   
     .              d19 = 1.D0/grav                                             
     .              d20 = d19/(2.00000000000000e+000*deltime)                   
     .              d21 = 1.D0/grav                                             
     .              d22 = d21/(2.00000000000000e+000*deltime)                   
     .              d23 = 1.D0/grav                                             
     .              d24 = d23/(2.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do t1424 = 1, 1 + imax - min0(1,imax)                       
     .                 xyza_qmixmtx(t1424-1,t1422,1,0) = xy_surfqvaptranscoef(  
     .       1            t1424-1,t1422) - (xyr_press(t1424-1,t1422,1)-xyr_press
     .       2            (t1424-1,t1422,0))*d18 + xyr_qmixtranscoef(t1424-1,   
     .       3            t1422,1)                                              
     .                 xyza_qmixmtx(t1424-1,t1422+1,1,0) = xy_surfqvaptranscoef(
     .       1            t1424-1,t1422+1) - (xyr_press(t1424-1,t1422+1,1)-     
     .       2            xyr_press(t1424-1,t1422+1,0))*d20 + xyr_qmixtranscoef(
     .       3            t1424-1,t1422+1,1)                                    
     .                 xyza_qmixmtx(t1424-1,t1422+2,1,0) = xy_surfqvaptranscoef(
     .       1            t1424-1,t1422+2) - (xyr_press(t1424-1,t1422+2,1)-     
     .       2            xyr_press(t1424-1,t1422+2,0))*d22 + xyr_qmixtranscoef(
     .       3            t1424-1,t1422+2,1)                                    
     .                 xyza_qmixmtx(t1424-1,t1422+3,1,0) = xy_surfqvaptranscoef(
     .       1            t1424-1,t1422+3) - (xyr_press(t1424-1,t1422+3,1)-     
     .       2            xyr_press(t1424-1,t1422+3,0))*d24 + xyr_qmixtranscoef(
     .       3            t1424-1,t1422+3,1)                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10082                                                        
   405          & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   406          & + xy_SurfQVapTransCoef(:,:)                                           &
   407          & + xyr_QMixTransCoef(:,:,k  )
   408      else
   409        ! Prescribe surface flux
   410        xyza_QMixMtx(:,:,k, 0) =                                                  &
     .        d25 = 1.D0/grav                                                   
     .        d26 = d25/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1242 = 1, jmax*imax                                           
     .           xyza_qmixmtx(t1242-1,1,1,0) = xyr_qmixtranscoef(t1242-1,1,1) - 
     .       1      (xyr_press(t1242-1,1,1)-xyr_press(t1242-1,1,0))*d26         
     .        enddo                                                             
   411          & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   412          & + xyr_QMixTransCoef(:,:,k  )
   413      end if
   414      xyza_QMixMtx(:,:,k, 1) =                                                  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1254 = 1, xyr_qmixtranscoef.DSC.U2*xyr_qmixtranscoef.DSC.U1 + 
     .       1   xyr_qmixtranscoef.DSC.U2                                       
     .           xyza_qmixmtx(t1254-1,1,1,1) = -xyr_qmixtranscoef(t1254-1,1,1)  
     .        enddo                                                             
   415        & - xyr_QMixTransCoef(:,:,k  )
   416  
   417      do k = 2, kmax-1
   418        xyza_QMixMtx(:,:,k,-1) =                                                  &
   419          & - xyr_QMixTransCoef(:,:,k-1)
   420        xyza_QMixMtx(:,:,k, 0) =                                                  &
   421          & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   422          & + xyr_QMixTransCoef(:,:,k-1)                                          &
   423          & + xyr_QMixTransCoef(:,:,k  )
   424        xyza_QMixMtx(:,:,k, 1) =                                                  &
   425          & - xyr_QMixTransCoef(:,:,k  )
   426      end do
     .        d27 = 1.D0/grav                                                   
     .        d28 = d27/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 2)*(xyr_qmixtranscoef.DSC.U2*                   
     .       1   xyr_qmixtranscoef.DSC.U1 + xyr_qmixtranscoef.DSC.U2)           
     .           xyza_qmixmtx(k-1,1,2,-1) = -xyr_qmixtranscoef(k-1,1,1)         
     .           xyza_qmixmtx(k-1,1,2,0) = xyr_qmixtranscoef(k-1,1,1) - (       
     .       1      xyr_press(k-1,1,2)-xyr_press(k-1,1,1))*d28 +                
     .       2      xyr_qmixtranscoef(k-1,1,2)                                  
     .           xyza_qmixmtx(k-1,1,2,1) = -xyr_qmixtranscoef(k-1,1,2)          
     .        enddo                                                             
   427  
   428      k = kmax
   429      xyza_QMixMtx(:,:,k,-1) =                                                  &
     .        d29 = 1.D0/grav                                                   
     .        d30 = d29/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1284 = 1, xyr_qmixtranscoef.DSC.U2*xyr_qmixtranscoef.DSC.U1 + 
     .       1   xyr_qmixtranscoef.DSC.U2                                       
     .           xyza_qmixmtx(t1284-1,1,k,-1)=-xyr_qmixtranscoef(t1284-1,1,k-1) 
     .           xyza_qmixmtx(t1284-1,1,k,0) = xyr_qmixtranscoef(t1284-1,1,k-1) 
     .       1       - (xyr_press(t1284-1,1,k)-xyr_press(t1284-1,1,k-1))*d30    
     .           xyza_qmixmtx(t1284-1,1,k,1) = 0.0000000000000000e+000          
     .        enddo                                                             
   430        & - xyr_QMixTransCoef(:,:,k-1)
   431      xyza_QMixMtx(:,:,k, 0) =                                                  &
   432        & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   433        & + xyr_QMixTransCoef(:,:,k-1)
   434      xyza_QMixMtx(:,:,k, 1) = 0.0_DP
   435  
   436  
   437  
   438  
   439      ! 東西風速, 南北風速の計算
   440      ! Calculate eastward and northward wind
   441      !
   442      xyza_UVLUMtx = xyza_UVMtx
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1304 = 1, xyza_uvlumtx.DSC.U3*(xyza_uvlumtx.DSC.U2*           
     .       1   xyza_uvlumtx.DSC.U1 + xyza_uvlumtx.DSC.U2)                     
     .           xyza_uvlumtx(t1304-1,1,1,-1) = xyza_uvmtx(t1304-1,1,1,-1)      
     .           xyza_uvlumtx(t1304-1,1,1,0) = xyza_uvmtx(t1304-1,1,1,0)        
     .           xyza_uvlumtx(t1304-1,1,1,1) = xyza_uvmtx(t1304-1,1,1,1)        
     .        enddo                                                             
   443  
   444      call PhyImplLUDecomp3( &
   445        & xyza_UVLUMtx, &     ! (inout)
   446        & imax * jmax, kmax ) ! (in)
   447  
   448      do k = 1, kmax
   449        xyz_DUDt(:,:,k) = - ( xyr_MomFluxX(:,:,k) - xyr_MomFluxX(:,:,k-1) )
   450        xyz_DVDt(:,:,k) = - ( xyr_MomFluxY(:,:,k) - xyr_MomFluxY(:,:,k-1) )
   451      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_dudt(k-1,1,1) = -(xyr_momfluxx(k-1,1,1)-xyr_momfluxx(k-1,1,
     .       1      0))                                                         
     .           xyz_dvdt(k-1,1,1) = -(xyr_momfluxy(k-1,1,1)-xyr_momfluxy(k-1,1,
     .       1      0))                                                         
     .        enddo                                                             
   452  
   453      call PhyImplLUSolve3( &
   454        & xyz_DUDt, &            ! (inout)
   455        & xyza_UVLUMtx, &        ! (in)
   456        & 1, imax * jmax, kmax ) ! (in)
   457  
   458      call PhyImplLUSolve3( &
   459        & xyz_DVDt, &            ! (inout)
   460        & xyza_UVLUMtx, &        ! (in)
   461        & 1, imax * jmax, kmax ) ! (in)
   462  
   463      do k = 1, kmax
   464        xyz_DUDt(:,:,k) = xyz_DUDt(:,:,k) / ( 2.0_DP * DelTime )
   465        xyz_DVDt(:,:,k) = xyz_DVDt(:,:,k) / ( 2.0_DP * DelTime )
   466      end do
     .        d31 = 1.D0/(2.00000000000000e+000*deltime)                        
     .        d32 = 1.D0/(2.00000000000000e+000*deltime)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_dudt(k-1,1,1) = xyz_dudt(k-1,1,1)*d31                      
     .           xyz_dvdt(k-1,1,1) = xyz_dvdt(k-1,1,1)*d32                      
     .        enddo                                                             
   467  
   468  
   469      ! 温度の計算
   470      ! Calculate temperature
   471      !
   472      xyaa_TempLUMtx = xyra_TempMtx
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1348 = 1, xyaa_templumtx.DSC.U3*(xyaa_templumtx.DSC.U2*       
     .       1   xyaa_templumtx.DSC.U1 + xyaa_templumtx.DSC.U2)                 
     .           xyaa_templumtx(t1348-1,1,1,-1) = xyra_tempmtx(t1348-1,1,1,-1)  
     .           xyaa_templumtx(t1348-1,1,1,0) = xyra_tempmtx(t1348-1,1,1,0)    
     .           xyaa_templumtx(t1348-1,1,1,1) = xyra_tempmtx(t1348-1,1,1,1)    
     .        enddo                                                             
   473  
   474      call PhyImplLUDecomp3( &
   475        & xyaa_TempLUMtx,    & ! (inout)
   476        & imax * jmax, kmax  & ! (in)
   477        )
   478  
   479      do k = 1, kmax
   480        xya_DelTempLUVec(:,:,k) = &
   481          - ( xyr_HeatFlux(:,:,k) - xyr_HeatFlux(:,:,k-1) )
   482      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xya_deltempluvec(k-1,1,1) = -(xyr_heatflux(k-1,1,1)-           
     .       1      xyr_heatflux(k-1,1,0))                                      
     .        enddo                                                             
   483  
   484      call PhyImplLUSolve3(           &
   485        & xya_DelTempLUVec,           & ! (inout)
   486        & xyaa_TempLUMtx,             & ! (in)
   487        & 1, imax * jmax , kmax       & ! (in)
   488        & )
   489  
   490      xyz_DTempDt = xya_DelTempLUVec / ( 2.0_DP * DelTime )
     .        d33 = 1.D0/(2.00000000000000e+000*deltime)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1372 = 1, xya_deltempluvec.DSC.U3*(xya_deltempluvec.DSC.U2*   
     .       1   xya_deltempluvec.DSC.U1 + xya_deltempluvec.DSC.U2)             
     .           xyz_dtempdt(t1372-1,1,1) = xya_deltempluvec(t1372-1,1,1)*d33   
     .        enddo                                                             
   491  
   492  
   493      ! 比湿の計算
   494      ! Calculate specific humidity
   495      !
   496      xyza_QMixLUMtx = xyza_QMixMtx
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1386 = 1, xyza_qmixlumtx.DSC.U3*(xyza_qmixlumtx.DSC.U2*       
     .       1   xyza_qmixlumtx.DSC.U1 + xyza_qmixlumtx.DSC.U2)                 
     .           xyza_qmixlumtx(t1386-1,1,1,-1) = xyza_qmixmtx(t1386-1,1,1,-1)  
     .           xyza_qmixlumtx(t1386-1,1,1,0) = xyza_qmixmtx(t1386-1,1,1,0)    
     .           xyza_qmixlumtx(t1386-1,1,1,1) = xyza_qmixmtx(t1386-1,1,1,1)    
     .        enddo                                                             
   497  
   498      call PhyImplLUDecomp3( &
   499        & xyza_QMixLUMtx,    &   ! (inout)
   500        & imax * jmax, kmax  &   ! (in)
   501        & )
   502  
   503      do n = 1, ncmax
   504        do k = 1, kmax
   505          xyz_DelQMixLUVec(:,:,k) = &
   506            & - ( xyrf_QMixFlux(:,:,k,n) - xyrf_QMixFlux(:,:,k-1,n) )
   507        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delqmixluvec(k-1,1,1) = -(xyrf_qmixflux(k-1,1,1,n)-        
     .       1      xyrf_qmixflux(k-1,1,0,n))                                   
     .        enddo                                                             
   508  
   509        call PhyImplLUSolve3(      &
   510          & xyz_DelQMixLUVec,      & ! (inout)
   511          & xyza_QMixLUMtx,        & ! (in)
   512          & 1, imax * jmax , kmax  & ! (in)
   513          & )
   514  
   515        xyzf_DQMixDt(:,:,:,n) = xyz_DelQMixLUVec(:,:,:) / ( 2.0_DP * DelTime )
     .        d34 = 1.D0/(2.00000000000000e+000*deltime)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1410 = 1, xyz_delqmixluvec.DSC.U3*(xyz_delqmixluvec.DSC.U2*   
     .       1   xyz_delqmixluvec.DSC.U1 + xyz_delqmixluvec.DSC.U2)             
     .           xyzf_dqmixdt(t1410-1,1,1,n) = xyz_delqmixluvec(t1410-1,1,1)*d34
     .        enddo                                                             
   516      end do
   517  
   518  
   519      ! 計算時間計測一時停止
   520      ! Pause measurement of computation time
   521      !
   522      call TimesetClockStop( module_name )
   523  
   524    end subroutine PhyImplAtmOnlyTendency
   525  
   526    !-------------------------------------------------------------------
   527  
   528    subroutine PhyImplAtmOnlyInit
   529      !
   530      ! phy_implicit_atmonly モジュールの初期化を行います.
   531      ! NAMELIST#phy_implicit_atmonly_nml の読み込みはこの手続きで行われます.
   532      !
   533      ! "phy_implicit_atmonly" module is initialized.
   534      ! "NAMELIST#phy_implicit_atmonly_nml" is loaded in this procedure.
   535      !
   536  
   537      ! モジュール引用 ; USE statements
   538      !
   539  
   540      ! NAMELIST ファイル入力に関するユーティリティ
   541      ! Utilities for NAMELIST file input
   542      !
   543      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   544  
   545      ! ファイル入出力補助
   546      ! File I/O support
   547      !
   548      use dc_iounit, only: FileOpen
   549  
   550      ! 種別型パラメタ
   551      ! Kind type parameter
   552      !
   553      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   554  
   555      ! 文字列操作
   556      ! Character handling
   557      !
   558      use dc_string, only: StoA
   559  
   560      ! 宣言文 ; Declaration statements
   561      !
   562      implicit none
   563  
   564      ! 作業変数
   565      ! Work variables
   566      !
   567      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   568                                ! Unit number for NAMELIST file open
   569      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   570                                ! IOSTAT of NAMELIST read
   571  
   572      ! NAMELIST 変数群
   573      ! NAMELIST group name
   574      !
   575      namelist /phy_implicit_atmonly_nml/ &
   576        & FlagPresSurfTemp, FlagPresSurfQMix
   577            !
   578            ! デフォルト値については初期化手続 "phy_implicit_atmonly#PhyImplInit"
   579            ! のソースコードを参照のこと.
   580            !
   581            ! Refer to source codes in the initialization procedure
   582            ! "phy_implicit_atmonly#PhyImplInit" for the default values.
   583            !
   584  
   585      ! 実行文 ; Executable statement
   586      !
   587  
   588      if ( phy_implicit_atmonly_inited ) return
   589  
   590      ! デフォルト値の設定
   591      ! Default values settings
   592      !
   593      FlagPresSurfTemp = .false.
   594      FlagPresSurfQMix = .false.
   595  
   596  
   597      ! NAMELIST の読み込み
   598      ! NAMELIST is input
   599      !
   600      if ( trim(namelist_filename) /= '' ) then
   601        call FileOpen( unit_nml, &          ! (out)
   602          & namelist_filename, mode = 'r' ) ! (in)
   603  
   604        rewind( unit_nml )
   605        read( unit_nml,                     &  ! (in)
   606          & nml = phy_implicit_atmonly_nml, &  ! (out)
   607          & iostat = iostat_nml )              ! (out)
   608        close( unit_nml )
   609  
   610        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   611      end if
   612  
   613  
   614      ! 印字 ; Print
   615      !
   616      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   617      call MessageNotify( 'M', module_name, '  FlagPresSurfTemp = %b', l = (/ FlagPresSurfTemp /) )
   618      call MessageNotify( 'M', module_name, '  FlagPresSurfQMix = %b', l = (/ FlagPresSurfQMix /) )
   619      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   620  
   621      phy_implicit_atmonly_inited = .true.
   622  
   623    end subroutine PhyImplAtmOnlyInit
   624  
   625    !-------------------------------------------------------------------
   626  
   627  end module phy_implicit_atmonly
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:27 2016
FILE NAME: phy_implicit_atmonly.f90
PROGRAM NAME: phy_implicit_atmonly
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 陰解法による時間積分 (大気のみ / 惑星表面温度・土壌温度計算なし)
     2:             !
     3:             != Time integration by using implicit scheme in case without calculation of surface and soil temperature
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: phy_implicit_atmonly.f90,v 1.5 2015/01/29 12:05:01 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module phy_implicit_atmonly
    13:               !
    14:               != 陰解法による時間積分 (大気のみ / 惑星表面温度・土壌温度計算なし)
    15:               !
    16:               != Time integration by using implicit scheme in case without calculation of surface and soil temperature
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               !
    22:               ! PhyImplTendency      :: 時間変化率の計算
    23:               ! ------------         :: ------------
    24:               ! PhyImplTendency      :: Calculate tendency
    25:               !
    26:               !--
    27:               !== NAMELIST
    28:               !
    29:               ! NAMELIST#phy_implicit_nml
    30:               !++
    31:             
    32:               ! モジュール引用 ; USE statements
    33:               !
    34:             
    35:               ! 格子点設定
    36:               ! Grid points settings
    37:               !
    38:               use gridset, only:   imax, & ! 経度格子点数. 
    39:                                            ! Number of grid points in longitude
    40:                 &                  jmax, & ! 緯度格子点数. 
    41:                                            ! Number of grid points in latitude
    42:                 &                  kmax, & ! 鉛直層数. 
    43:                                            ! Number of vertical level
    44:                 &                  kslmax  ! 地下の鉛直層数. 
    45:                                            ! Number of subsurface vertical level
    46:             
    47:               ! 組成に関わる配列の設定
    48:               ! Settings of array for atmospheric composition
    49:               !
    50:               use composition, only: ncmax, IndexH2OVap
    51:             
    52:               ! 種別型パラメタ
    53:               ! Kind type parameter
    54:               !
    55:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    56:                 &                 STRING     ! 文字列.       Strings. 
    57:             
    58:               ! メッセージ出力
    59:               ! Message output
    60:               !
    61:               use dc_message, only: MessageNotify
    62:             
    63:               ! 宣言文 ; Declaration statements
    64:               !
    65:               implicit none
    66:               private
    67:             
    68:               ! 公開手続き
    69:               ! Public procedure
    70:               !
    71:               public :: PhyImplAtmOnlyTendency
    72:               public :: PhyImplAtmOnlyInit
    73:             
    74:             
    75:               ! 公開変数
    76:               ! Public variables
    77:               !
    78:             
    79:               ! 非公開変数
    80:               ! Private variables
    81:               !
    82:               logical, save :: FlagPresSurfTemp
    83:               logical, save :: FlagPresSurfQMix
    84:             
    85:             
    86:               logical, save :: phy_implicit_atmonly_inited = .false.
    87:                                           ! 初期設定フラグ. 
    88:                                           ! Initialization flag
    89:             
    90:               character(*), parameter:: module_name = 'phy_implicit_atmonly'
    91:                                           ! モジュールの名称. 
    92:                                           ! Module name
    93:               character(*), parameter:: version = &
    94:                 & '$Name:  $' // &
    95:                 & '$Id: phy_implicit_atmonly.f90,v 1.5 2015/01/29 12:05:01 yot Exp $'
    96:                                           ! モジュールのバージョン
    97:                                           ! Module version
    98:             
    99:             
   100:             contains
   101:             
   102:               subroutine PhyImplAtmOnlyTendency(                           &
   103:                 & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
   104:                 & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
   105:                 & xyr_VirTemp, xyz_Height,                                 & ! (in)
   106:                 & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,     & ! (in)
   107:                 & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
   108:                 & xy_SurfQVapTransCoef,                                    & ! (in)
   109:                 & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt            & ! (out)
   110:                 & )
   111:                 !
   112:                 ! 時間変化率の計算を行います. 
   113:                 !
   114:                 ! Calculate tendencies. 
   115:                 !
   116:             
   117:                 ! モジュール引用 ; USE statements
   118:                 !
   119:             
   120:                 ! 物理定数設定
   121:                 ! Physical constants settings
   122:                 !
   123:                 use constants, only: &
   124:                   & Grav, &               ! $ g $ [m s-2]. 
   125:                                           ! 重力加速度. 
   126:                                           ! Gravitational acceleration
   127:                   & CpDry, &
   128:                                           ! $ C_p $ [J kg-1 K-1]. 
   129:                                           ! 乾燥大気の定圧比熱. 
   130:                                           ! Specific heat of air at constant pressure
   131:                   & LatentHeat, &
   132:                                           ! $ L $ [J kg-1] . 
   133:                                           ! 凝結の潜熱. 
   134:                                           ! Latent heat of condensation
   135:                   & GasRDry
   136:                                           ! $ R $ [J kg-1 K-1]. 
   137:                                           ! 乾燥大気の気体定数. 
   138:                                           ! Gas constant of air
   139:             
   140:                 ! 時刻管理
   141:                 ! Time control
   142:                 !
   143:                 use timeset, only: &
   144:                   & DelTime, &            ! $ \Delta t $ [s]
   145:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   146:                   & TimesetClockStart, TimesetClockStop
   147:             
   148:                 ! 陰解法による時間積分のためのルーチン
   149:                 ! Routines for time integration with implicit scheme
   150:                 !
   151:                 use phy_implicit_utils, only : PhyImplLUDecomp3, PhyImplLUSolve3
   152:             
   153:                 ! 宣言文 ; Declaration statements
   154:                 !
   155:                 implicit none
   156:             
   157:                 real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
   158:                                           ! 東西方向運動量フラックス. 
   159:                                           ! Eastward momentum flux
   160:                 real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
   161:                                           ! 南北方向運動量フラックス. 
   162:                                           ! Northward momentum flux
   163:                 real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   164:                                           ! 熱フラックス. 
   165:                                           ! Heat flux
   166:                 real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   167:                                           ! 比湿フラックス. 
   168:                                           ! Specific humidity flux
   169:             
   170:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   171:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   172:                                           ! Air pressure (half level)
   173:                 real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   174:                                           ! Exner 関数 (整数レベル). 
   175:                                           ! Exner function (full level)
   176:                 real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   177:                                           ! Exner 関数 (半整数レベル). 
   178:                                           ! Exner function (half level)
   179:             
   180:                 real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   181:                                           ! $ \hat{T}_v $ . 仮温度 (半整数レベル). 
   182:                                           ! Virtual temperature (half level)
   183:                 real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   184:                                           ! 高度 (整数レベル). 
   185:                                           ! Height (full level)
   186:             
   187:                 real(DP), intent(in):: xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   188:                                           ! 拡散係数：運動量. 
   189:                                           ! Diffusion coefficient: velocity
   190:                 real(DP), intent(in):: xyr_TempDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   191:                                           ! 拡散係数：温度. 
   192:                                           ! Transfer coefficient: temperature
   193:                 real(DP), intent(in):: xyr_QMixDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   194:                                           ! 拡散係数：比湿. 
   195:                                           ! Diffusion coefficient: specific humidity
   196:             
   197:                 real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   198:                                           ! 輸送係数：運動量. 
   199:                                           ! Diffusion coefficient: velocity
   200:                 real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   201:                                           ! 輸送係数：温度. 
   202:                                           ! Transfer coefficient: temperature
   203:                 real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   204:                                           ! 輸送係数：比湿. 
   205:                                           ! Transfer coefficient: specific humidity
   206:             
   207:                 real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   208:                                           ! $ \DP{u}{t} $ . 東西風速変化. 
   209:                                           ! Eastward wind tendency
   210:                 real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   211:                                           ! $ \DP{v}{t} $ . 南北風速変化. 
   212:                                           ! Northward wind tendency
   213:                 real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   214:                                           ! $ \DP{T}{t} $ . 温度変化. 
   215:                                           ! Temperature tendency
   216:                 real(DP), intent(out):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   217:                                           ! $ \DP{q}{t} $ . 質量混合比変化. 
   218:                                           ! Mass mixing ratio tendency
   219:             
   220:                 ! 作業変数
   221:                 ! Work variables
   222:                 !
   223:             
   224:                 real(DP) :: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
   225:                                           ! 輸送係数：運動量. 
   226:                                           ! Transfer coefficient: velocity
   227:                 real(DP) :: xyr_TempTransCoef (0:imax-1, 1:jmax, 0:kmax)
   228:                                           ! 輸送係数：温度. 
   229:                                           ! Transfer coefficient: temperature
   230:                 real(DP) :: xyr_QMixTransCoef(0:imax-1, 1:jmax, 0:kmax)
   231:                                           ! 輸送係数：質量. 
   232:                                           ! Transfer coefficient: mass of constituents
   233:             
   234:                 real(DP):: xyza_UVMtx  (0:imax-1, 1:jmax, 1:kmax, -1:1)
   235:                                           ! 速度陰解行列. 
   236:                                           ! Implicit matrix about velocity 
   237:                 real(DP):: xyra_TempMtx(0:imax-1, 1:jmax, 1:kmax, -1:1)
   238:                                           ! 温度陰解行列. 
   239:                                           ! Implicit matrix about temperature
   240:                 real(DP):: xyza_QMixMtx(0:imax-1, 1:jmax, 1:kmax, -1:1)
   241:                                           ! 質量混合比陰解行列. 
   242:                                           ! Implicit matrix about mass mixing ratio
   243:             
   244:                 real(DP):: xyza_UVLUMtx    (0:imax-1, 1:jmax, 1:kmax,-1:1)
   245:                                           ! LU 行列. 
   246:                                           ! LU matrix
   247:                 real(DP):: xyza_QMixLUMtx  (0:imax-1, 1:jmax, 1:kmax, -1:1)
   248:                                           ! LU 行列.
   249:                                           ! LU matrix
   250:                 real(DP):: xyz_DelQMixLUVec(0:imax-1, 1:jmax, 1:kmax)
   251:                                           ! $ q $ の時間変化.
   252:                                           ! Tendency of $ q $
   253:             
   254:                 real(DP):: xyaa_TempLUMtx  (0:imax-1, 1:jmax, 1:kmax, -1:1)
   255:                                           ! LU 行列.
   256:                                           ! LU matrix
   257:                 real(DP):: xya_DelTempLUVec(0:imax-1, 1:jmax, 1:kmax)
   258:                                           ! $ T, Tg $ の時間変化.
   259:                                           ! Tendency of $ T $ and $ Tg |
   260:             
   261:             
   262:             !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   263:             !!$                              ! Work variables for DO loop in longitude
   264:             !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   265:             !!$                              ! Work variables for DO loop in latitude
   266:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   267:                                           ! Work variables for DO loop in vertical direction
   268:             !!$    integer:: l               ! 行列用 DO ループ用作業変数
   269:             !!$                              ! Work variables for DO loop of matrices
   270:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   271:                                           ! Work variables for DO loop in dimension of constituents
   272:             
   273:                 ! 実行文 ; Executable statement
   274:                 !
   275:             
   276:                 ! 初期化確認
   277:                 ! Initialization check
   278:                 !
   279:                 if ( .not. phy_implicit_atmonly_inited ) then
   280:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   281:                 end if
   282:             
   283:             
   284:                 ! 計算時間計測開始
   285:                 ! Start measurement of computation time
   286:                 !
   287:                 call TimesetClockStart( module_name )
   288:             
   289:             
   290:                 ! 輸送係数の計算
   291:                 ! Calculate transfer coefficient
   292:                 !
   293: *W----->        xyr_VelTransCoef (:,:,0)    = 0.0_DP
   294: ||              xyr_VelTransCoef (:,:,kmax) = 0.0_DP
   295: ||              xyr_TempTransCoef(:,:,0)    = 0.0_DP
   296: ||              xyr_TempTransCoef(:,:,kmax) = 0.0_DP
   297: ||              xyr_QMixTransCoef(:,:,0)    = 0.0_DP
   298: *W-----         xyr_QMixTransCoef(:,:,kmax) = 0.0_DP
   299:             
   300: W------>        do k = 1, kmax-1
   301: |**---->A         xyr_VelTransCoef(:,:,k) =                                     &
   302: |||                 &   xyr_VelDiffCoef(:,:,k)                                  &
   303: |||                 &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   304: |||                 &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   305: |||         
   306: |||     A         xyr_TempTransCoef(:,:,k) =                                    &
   307: |||                 &   xyr_TempDiffCoef(:,:,k)                                 &
   308: |||                 &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   309: |||                 &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   310: |||         
   311: |**---- A         xyr_QMixTransCoef(:,:,k) =                                    &
   312: |                   &   xyr_QMixDiffCoef(:,:,k)                                 &
   313: |                   &     * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
   314: |                   &     / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
   315: W------         end do
   316:             
   317:             
   318:                 ! 陰解法のための行列作成
   319:                 ! Create matrices for implicit scheme
   320:                 !
   321:             
   322:                 ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (速度)
   323:                 ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (velocity)
   324:                 !
   325:                 k = 1
   326: *W----->        xyza_UVMtx  (:,:,k,-1) = 0.0_DP
   327: ||      A       xyza_UVMtx  (:,:,k, 0) =                                                  &
   328: ||                & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   329: ||                & + xy_SurfVelTransCoef(:,:)                                            &
   330: ||                & + xyr_VelTransCoef(:,:,k  )
   331: *W-----         xyza_UVMtx  (:,:,k, 1) = &
   332:                   & - xyr_VelTransCoef(:,:,k)
   333:             
   334: W------>        do k = 2, kmax-1
   335: |**---->          xyza_UVMtx  (:,:,k,-1) = &
   336: |||                 & - xyr_VelTransCoef(:,:,k-1)
   337: |||     A         xyza_UVMtx  (:,:,k, 0) =                                                  &
   338: |||                 & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   339: |||                 & + xyr_VelTransCoef(:,:,k-1)                                           &
   340: |||                 & + xyr_VelTransCoef(:,:,k  )
   341: |**----           xyza_UVMtx  (:,:,k, 1) = &
   342: |                   & - xyr_VelTransCoef(:,:,k)
   343: W------         end do
   344:             
   345:                 k = kmax
   346: *W----->        xyza_UVMtx  (:,:,k,-1) = &
   347: ||                & - xyr_VelTransCoef(:,:,k-1)
   348: ||      A       xyza_UVMtx  (:,:,k, 0) =                                                  &
   349: ||                & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   350: ||                & + xyr_VelTransCoef(:,:,k-1)
   351: *W-----         xyza_UVMtx  (:,:,k, 1) = 0.0_DP
   352:             
   353:             
   354:                 ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (温度)
   355:                 ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (temperature)
   356:                 !
   357:                 k = 1
   358: W*=====         xyra_TempMtx(:,:,k,-1) = 0.0_DP
   359:                 if ( FlagPresSurfTemp ) then
   360:                   ! Prescribe surface temperature
   361: +V===== A         xyra_TempMtx(:,:,k, 0) =                                                          &
   362:                     & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   363:                     & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xy_SurfTempTransCoef(:,:) &
   364:                     & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   365:                 else
   366:                   ! Prescribe surface flux
   367: W*===== A         xyra_TempMtx(:,:,k, 0) =                                                          &
   368:                     & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   369:                     & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   370:                 end if
   371: W*===== A       xyra_TempMtx(:,:,k, 1) = &
   372:                   & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
   373:             
   374: W------>        do k = 2, kmax-1
   375: |**---->A         xyra_TempMtx(:,:,k,-1) = &
   376: |||                 & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
   377: |||     A         xyra_TempMtx(:,:,k, 0) =                                                          &
   378: |||     A           & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   379: |||     A           & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)&
   380: |||     A           & + CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k  )
   381: |**---- A         xyra_TempMtx(:,:,k, 1) = &
   382: |                   & - CpDry * xyr_Exner(:,:,k  ) / xyz_Exner(:,:,k+1) * xyr_TempTransCoef(:,:,k  )
   383: W------         end do
   384:             
   385:                 k = kmax
   386: *W----->A       xyra_TempMtx(:,:,k,-1) = &
   387: ||                & - CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1) * xyr_TempTransCoef(:,:,k-1)
   388: ||      A       xyra_TempMtx(:,:,k, 0) =                                                          &
   389: ||                & - CpDry * ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   390: ||                & + CpDry * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k  ) * xyr_TempTransCoef(:,:,k-1)
   391: *W-----         xyra_TempMtx(:,:,k, 1) = 0.0_DP
   392:             
   393:             
   394:             
   395:                 ! 鉛直拡散スキームの輸送係数から陰解行列の計算 (比湿)
   396:                 ! Calculate implicit matrices from transfer coefficient of vertical diffusion scheme (specific humidity)
   397:                 !
   398:             
   399:                 k = 1
   400: W*=====         xyza_QMixMtx(:,:,k,-1) =                                                  &
   401:                   & 0.0_DP
   402:                 if ( FlagPresSurfQMix ) then
   403:                   ! Prescribe surface mixing ratio
   404: +V===== A         xyza_QMixMtx(:,:,k, 0) =                                                  &
   405:                     & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   406:                     & + xy_SurfQVapTransCoef(:,:)                                           &
   407:                     & + xyr_QMixTransCoef(:,:,k  )
   408:                 else
   409:                   ! Prescribe surface flux
   410: W*===== A         xyza_QMixMtx(:,:,k, 0) =                                                  &
   411:                     & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   412:                     & + xyr_QMixTransCoef(:,:,k  )
   413:                 end if
   414: W*=====         xyza_QMixMtx(:,:,k, 1) =                                                  &
   415:                   & - xyr_QMixTransCoef(:,:,k  )
   416:             
   417: W------>        do k = 2, kmax-1
   418: |**---->          xyza_QMixMtx(:,:,k,-1) =                                                  &
   419: |||                 & - xyr_QMixTransCoef(:,:,k-1)
   420: |||     A         xyza_QMixMtx(:,:,k, 0) =                                                  &
   421: |||                 & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   422: |||                 & + xyr_QMixTransCoef(:,:,k-1)                                          &
   423: |||                 & + xyr_QMixTransCoef(:,:,k  )
   424: |**----           xyza_QMixMtx(:,:,k, 1) =                                                  &
   425: |                   & - xyr_QMixTransCoef(:,:,k  )
   426: W------         end do
   427:             
   428:                 k = kmax
   429: *W----->        xyza_QMixMtx(:,:,k,-1) =                                                  &
   430: ||                & - xyr_QMixTransCoef(:,:,k-1)
   431: ||      A       xyza_QMixMtx(:,:,k, 0) =                                                  &
   432: ||                & - ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) ) / Grav / ( 2.0_DP * DelTime ) &
   433: ||                & + xyr_QMixTransCoef(:,:,k-1)
   434: *W-----         xyza_QMixMtx(:,:,k, 1) = 0.0_DP
   435:             
   436:             
   437:             
   438:             
   439:                 ! 東西風速, 南北風速の計算
   440:                 ! Calculate eastward and northward wind
   441:                 !
   442: W***=== A       xyza_UVLUMtx = xyza_UVMtx
   443:             
   444:                 call PhyImplLUDecomp3( &
   445:                   & xyza_UVLUMtx, &     ! (inout)
   446:                   & imax * jmax, kmax ) ! (in)
   447:             
   448: W------>        do k = 1, kmax
   449: |**---->A         xyz_DUDt(:,:,k) = - ( xyr_MomFluxX(:,:,k) - xyr_MomFluxX(:,:,k-1) )
   450: |**---- A         xyz_DVDt(:,:,k) = - ( xyr_MomFluxY(:,:,k) - xyr_MomFluxY(:,:,k-1) )
   451: W------         end do
   452:             
   453:                 call PhyImplLUSolve3( &
   454:                   & xyz_DUDt, &            ! (inout)
   455:                   & xyza_UVLUMtx, &        ! (in)
   456:                   & 1, imax * jmax, kmax ) ! (in)
   457:             
   458:                 call PhyImplLUSolve3( &
   459:                   & xyz_DVDt, &            ! (inout)
   460:                   & xyza_UVLUMtx, &        ! (in)
   461:                   & 1, imax * jmax, kmax ) ! (in)
   462:             
   463: W------>        do k = 1, kmax
   464: |**---->A         xyz_DUDt(:,:,k) = xyz_DUDt(:,:,k) / ( 2.0_DP * DelTime )
   465: |**---- A         xyz_DVDt(:,:,k) = xyz_DVDt(:,:,k) / ( 2.0_DP * DelTime )
   466: W------         end do
   467:             
   468:             
   469:                 ! 温度の計算
   470:                 ! Calculate temperature
   471:                 !
   472: W***=== A       xyaa_TempLUMtx = xyra_TempMtx
   473:             
   474:                 call PhyImplLUDecomp3( &
   475:                   & xyaa_TempLUMtx,    & ! (inout)
   476:                   & imax * jmax, kmax  & ! (in)
   477:                   )
   478:             
   479: W------>        do k = 1, kmax
   480: |**==== A         xya_DelTempLUVec(:,:,k) = &
   481: |                   - ( xyr_HeatFlux(:,:,k) - xyr_HeatFlux(:,:,k-1) )
   482: W------         end do
   483:             
   484:                 call PhyImplLUSolve3(           &
   485:                   & xya_DelTempLUVec,           & ! (inout)
   486:                   & xyaa_TempLUMtx,             & ! (in)
   487:                   & 1, imax * jmax , kmax       & ! (in)
   488:                   & )
   489:             
   490: W**==== A       xyz_DTempDt = xya_DelTempLUVec / ( 2.0_DP * DelTime )
   491:             
   492:             
   493:                 ! 比湿の計算
   494:                 ! Calculate specific humidity
   495:                 !
   496: W***=== A       xyza_QMixLUMtx = xyza_QMixMtx
   497:             
   498:                 call PhyImplLUDecomp3( &
   499:                   & xyza_QMixLUMtx,    &   ! (inout)
   500:                   & imax * jmax, kmax  &   ! (in)
   501:                   & )
   502:             
   503: +------>        do n = 1, ncmax
   504: |W----->          do k = 1, kmax
   505: ||**=== A           xyz_DelQMixLUVec(:,:,k) = &
   506: ||                    & - ( xyrf_QMixFlux(:,:,k,n) - xyrf_QMixFlux(:,:,k-1,n) )
   507: |W-----           end do
   508: |           
   509: |                 call PhyImplLUSolve3(      &
   510: |                   & xyz_DelQMixLUVec,      & ! (inout)
   511: |                   & xyza_QMixLUMtx,        & ! (in)
   512: |                   & 1, imax * jmax , kmax  & ! (in)
   513: |                   & )
   514: |           
   515: |W**=== A         xyzf_DQMixDt(:,:,:,n) = xyz_DelQMixLUVec(:,:,:) / ( 2.0_DP * DelTime )
   516: +------         end do
   517:             
   518:             
   519:                 ! 計算時間計測一時停止
   520:                 ! Pause measurement of computation time
   521:                 !
   522:                 call TimesetClockStop( module_name )
   523:             
   524:               end subroutine PhyImplAtmOnlyTendency
   525:             
   526:               !-------------------------------------------------------------------
   527:             
   528:               subroutine PhyImplAtmOnlyInit
   529:                 !
   530:                 ! phy_implicit_atmonly モジュールの初期化を行います. 
   531:                 ! NAMELIST#phy_implicit_atmonly_nml の読み込みはこの手続きで行われます. 
   532:                 !
   533:                 ! "phy_implicit_atmonly" module is initialized. 
   534:                 ! "NAMELIST#phy_implicit_atmonly_nml" is loaded in this procedure. 
   535:                 !
   536:             
   537:                 ! モジュール引用 ; USE statements
   538:                 !
   539:             
   540:                 ! NAMELIST ファイル入力に関するユーティリティ
   541:                 ! Utilities for NAMELIST file input
   542:                 !
   543:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   544:             
   545:                 ! ファイル入出力補助
   546:                 ! File I/O support
   547:                 !
   548:                 use dc_iounit, only: FileOpen
   549:             
   550:                 ! 種別型パラメタ
   551:                 ! Kind type parameter
   552:                 !
   553:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   554:             
   555:                 ! 文字列操作
   556:                 ! Character handling
   557:                 !
   558:                 use dc_string, only: StoA
   559:             
   560:                 ! 宣言文 ; Declaration statements
   561:                 !
   562:                 implicit none
   563:             
   564:                 ! 作業変数
   565:                 ! Work variables
   566:                 !
   567:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   568:                                           ! Unit number for NAMELIST file open
   569:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   570:                                           ! IOSTAT of NAMELIST read
   571:             
   572:                 ! NAMELIST 変数群
   573:                 ! NAMELIST group name
   574:                 !
   575:                 namelist /phy_implicit_atmonly_nml/ &
   576:                   & FlagPresSurfTemp, FlagPresSurfQMix
   577:                       !
   578:                       ! デフォルト値については初期化手続 "phy_implicit_atmonly#PhyImplInit" 
   579:                       ! のソースコードを参照のこと. 
   580:                       !
   581:                       ! Refer to source codes in the initialization procedure
   582:                       ! "phy_implicit_atmonly#PhyImplInit" for the default values. 
   583:                       !
   584:             
   585:                 ! 実行文 ; Executable statement
   586:                 !
   587:             
   588:                 if ( phy_implicit_atmonly_inited ) return
   589:             
   590:                 ! デフォルト値の設定
   591:                 ! Default values settings
   592:                 !
   593:                 FlagPresSurfTemp = .false.
   594:                 FlagPresSurfQMix = .false.
   595:             
   596:             
   597:                 ! NAMELIST の読み込み
   598:                 ! NAMELIST is input
   599:                 !
   600:                 if ( trim(namelist_filename) /= '' ) then
   601:                   call FileOpen( unit_nml, &          ! (out)
   602:                     & namelist_filename, mode = 'r' ) ! (in)
   603:             
   604:                   rewind( unit_nml )
   605:                   read( unit_nml,                     &  ! (in)
   606:                     & nml = phy_implicit_atmonly_nml, &  ! (out)
   607:                     & iostat = iostat_nml )              ! (out)
   608:                   close( unit_nml )
   609:             
   610:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   611:                 end if
   612:             
   613:             
   614:                 ! 印字 ; Print
   615:                 !
   616:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   617:                 call MessageNotify( 'M', module_name, '  FlagPresSurfTemp = %b', l = (/ FlagPresSurfTemp /) )
   618:                 call MessageNotify( 'M', module_name, '  FlagPresSurfQMix = %b', l = (/ FlagPresSurfQMix /) )
   619:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   620:             
   621:                 phy_implicit_atmonly_inited = .true.
   622:             
   623:               end subroutine PhyImplAtmOnlyInit
   624:             
   625:               !-------------------------------------------------------------------
   626:             
   627:             end module phy_implicit_atmonly
