Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: phy_implicit_utils.f90
PROGRAM NAME: phy_implicit_utils
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   168  vec  (   3): Unvectorized loop.
   168  vec  (  13): Overhead of loop division is too large.
   169  opt  (1593): Loop nest collapsed into one loop.
   169  vec  (   4): Vectorized array expression.
   169  vec  (  29): ADB is used for array.: xyr_radlfluxa
   169  vec  (  29): ADB is used for array.: xyz_dtempdt
   169  vec  (  29): ADB is used for array.: xyra_delradlflux
   169  vec  (  29): ADB is used for array.: xy_dsurftempdt
   169  vec  (  29): ADB is used for array.: xyr_radlflux
   216  vec  (   1): Vectorized loop.
   216  vec  (  29): ADB is used for array.: jna_lumtx
   221  vec  (   1): Vectorized loop.
   221  vec  (  29): ADB is used for array.: jna_lumtx
   222  opt  (1037): Feedback of array elements.
   229  vec  (   1): Vectorized loop.
   229  vec  (  29): ADB is used for array.: jna_lumtx
   274  opt  (1592): Outer loop unrolled inside inner loop.
   275  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   275  vec  (   1): Vectorized loop.
   275  vec  (  29): ADB is used for array.: ijn_vector
   275  vec  (  29): ADB is used for array.: jna_lumtx
   275  vec  (   1): Vectorized loop.
   275  vec  (  29): ADB is used for array.: ijn_vector
   275  vec  (  29): ADB is used for array.: jna_lumtx
   281  opt  (1592): Outer loop unrolled inside inner loop.
   282  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   282  vec  (   1): Vectorized loop.
   282  vec  (  29): ADB is used for array.: ijn_vector
   282  vec  (  29): ADB is used for array.: jna_lumtx
   282  vec  (   1): Vectorized loop.
   282  vec  (  29): ADB is used for array.: ijn_vector
   282  vec  (  29): ADB is used for array.: jna_lumtx
   283  opt  (1037): Feedback of array elements.
   294  opt  (1592): Outer loop unrolled inside inner loop.
   295  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   295  vec  (   1): Vectorized loop.
   295  vec  (  29): ADB is used for array.: ijn_vector
   295  vec  (  29): ADB is used for array.: jna_lumtx
   295  vec  (   1): Vectorized loop.
   295  vec  (  29): ADB is used for array.: ijn_vector
   295  vec  (  29): ADB is used for array.: jna_lumtx
   296  opt  (1037): Feedback of array elements.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: phy_implicit_utils.f90
PROGRAM NAME: phy_implicit_utils
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 陰解法による時間積分のためのルーチン
     2  !
     3  != Routines for time integration with implicit scheme
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6  ! Version::   $Id: phy_implicit_utils.f90,v 1.3 2014/05/07 09:39:20 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module phy_implicit_utils
    13    !
    14    != 陰解法による時間積分のためのルーチン
    15    !
    16    != Routines for time integration with implicit scheme
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22    ! PhyImplEvalRadLFluxA :: 長波フラックス補正
    23    ! ------------         :: ------------
    24    ! PhyImplEvalRadLFluxA :: Longwave flux correction
    25    !
    26    !--
    27    !== NAMELIST
    28    !
    29    ! NAMELIST#phy_implicit_utils_nml
    30    !++
    31  
    32    ! モジュール引用 ; USE statements
    33    !
    34  
    35    ! 格子点設定
    36    ! Grid points settings
    37    !
    38    use gridset, only: imax, & ! 経度格子点数.
    39                               ! Number of grid points in longitude
    40      &                jmax, & ! 緯度格子点数.
    41                               ! Number of grid points in latitude
    42      &                kmax    ! 鉛直層数.
    43                               ! Number of vertical level
    44  
    45    ! 組成に関わる配列の設定
    46    ! Settings of array for atmospheric composition
    47    !
    48    use composition, only: ncmax, IndexH2OVap
    49  
    50    ! 種別型パラメタ
    51    ! Kind type parameter
    52    !
    53    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    54      &                 STRING     ! 文字列.       Strings.
    55  
    56    ! メッセージ出力
    57    ! Message output
    58    !
    59    use dc_message, only: MessageNotify
    60  
    61    ! 宣言文 ; Declaration statements
    62    !
    63    implicit none
    64    private
    65  
    66    ! 公開手続き
    67    ! Public procedure
    68    !
    69    public :: PhyImplEvalRadLFluxA, PhyImplLUDecomp3, PhyImplLUSolve3
    70    public :: PhyImplUtilsInit
    71  
    72    ! 公開変数
    73    ! Public variables
    74    !
    75  
    76    ! 非公開変数
    77    ! Private variables
    78    !
    79    logical, save :: phy_implicit_utils_inited = .false.
    80                                ! 初期設定フラグ.
    81                                ! Initialization flag
    82  
    83    character(*), parameter:: module_name = 'phy_implicit_utils'
    84                                ! モジュールの名称.
    85                                ! Module name
    86    character(*), parameter:: version = &
    87      & '$Name:  $' // &
    88      & '$Id: phy_implicit_utils.f90,v 1.3 2014/05/07 09:39:20 murashin Exp $'
    89                                ! モジュールのバージョン
    90                                ! Module version
    91  
    92  contains
    93  
    94    !-------------------------------------------------------------------
    95  
    96    subroutine PhyImplEvalRadLFluxA( &
    97      & xyr_RadLFlux, &                                  ! (in)
    98      & xyz_DTempDt, xy_DSurfTempDt, xyra_DelRadLFlux, & ! (in)
    99      & xyr_RadLFluxA &                                  ! (out)
   100      & )
   101      !
   102      ! $ t-\Delta t $ における変化率を元に,
   103      ! $ t+\Delta t $ の長波フラックス (xyr_RadLFluxA) を算出します.
   104      !
   105      ! Evaluate longwave flux at $ t+\Delta t $ (xyr_RadLFluxA)
   106      ! from the tendency at $ t-\Delta t $ .
   107      !
   108  
   109      ! モジュール引用 ; USE statements
   110      !
   111  
   112      ! 時刻管理
   113      ! Time control
   114      !
   115      use timeset, only: DelTime, &  ! $ \Delta t $ [s]
   116        & TimesetClockStart, TimesetClockStop
   117  
   118      ! 宣言文 ; Declaration statements
   119      !
   120      implicit none
   121      real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   122                                ! 長波フラックス.
   123                                ! Longwave flux
   124      real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   125                                ! $ \DP{T}{t} $ . 温度変化.
   126                                ! Temperature tendency
   127      real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
   128                                ! 地表面温度変化率.
   129                                ! Surface temperature tendency
   130      real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax,  0:1)
   131                                ! 長波地表温度変化.
   132                                ! Surface temperature tendency with longwave
   133      real(DP), intent(out):: xyr_RadLFluxA (0:imax-1, 1:jmax, 0:kmax)
   134                                ! $ t-\Delta t $ における変化率を元に
   135                                ! 算出された $ t+\Delta t $ における
   136                                ! 長波フラックス.
   137                                !
   138                                ! Longwave flux at $ t+\Delta t $
   139                                ! calculated from the tendency at
   140                                ! $ t-\Delta t $ .
   141  
   142      ! 作業変数
   143      ! Work variables
   144      !
   145      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   146                                ! Work variables for DO loop in vertical direction
   147  
   148      ! 実行文 ; Executable statement
   149      !
   150  
   151      ! 初期化確認
   152      ! Initialization check
   153      !
   154      if ( .not. phy_implicit_utils_inited ) then
   155        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   156      end if
   157  
   158  
   159      ! 計算時間計測開始
   160      ! Start measurement of computation time
   161      !
   162      call TimesetClockStart( module_name )
   163  
   164  
   165      ! $ t+\Delta t $ の長波フラックス (xyr_RadLFluxA) を算出
   166      ! Evaluate longwave flux at $ t+\Delta t $ (xyr_RadLFluxA)
   167      !
   168      do k = 0, kmax
   169        xyr_RadLFluxA(:,:,k) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_dsurftempdt,xyz_dtempdt)                                
     .        do t96 = 1, jmax*imax                                             
     .           xyr_radlfluxa(t96-1,1,k) = xyr_radlflux(t96-1,1,k) + (         
     .       1      xy_dsurftempdt(t96-1,1)*xyra_delradlflux(t96-1,1,k,0)+      
     .       2      xyz_dtempdt(t96-1,1,1)*xyra_delradlflux(t96-1,1,k,1))*      
     .       3      2.00000000000000e+000*deltime                               
     .        enddo                                                             
   170          &   xyr_RadLFlux(:,:,k) &
   171          & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
   172          &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
   173          &   * 2.0_DP * DelTime
   174      end do
   175  
   176      ! 計算時間計測一時停止
   177      ! Pause measurement of computation time
   178      !
   179      call TimesetClockStop( module_name )
   180  
   181    end subroutine PhyImplEvalRadLFluxA
   182  
   183    !-------------------------------------------------------------------
   184  
   185    subroutine PhyImplLUDecomp3( &
   186      & jna_LUMtx, &            ! (inout)
   187      & JDim, NDim &            ! (in)
   188      & )
   189      !
   190      ! 3 重対角行列の LU 分解を行います.
   191      !
   192      ! LU decomposition of triple diagonal matrix.
   193      !
   194  
   195      ! 宣言文 ; Declaration statements
   196      !
   197      implicit none
   198      integer, intent(in):: JDim
   199      integer, intent(in):: NDim
   200      real(DP), intent(inout):: jna_LUMtx(JDim, NDim, -1:1)
   201                                ! LU 行列.
   202                                ! LU matrix
   203  
   204      ! 作業変数
   205      ! Work variables
   206      !
   207      integer:: j, n            ! DO ループ用作業変数
   208                                ! Work variables for DO loop
   209  
   210      ! 実行文 ; Executable statement
   211      !
   212  
   213      ! LU 分解
   214      ! LU decomposition
   215      !
   216      do j = 1, JDim
   217        jna_LUMtx(j,1,1) = jna_LUMtx(j,1,1) / jna_LUMtx(j,1,0)
   218      end do
   219  
   220      do n = 2, NDim-1
   221        do j = 1, JDim
   222          jna_LUMtx(j,n,0)  =   jna_LUMtx(j,n,0) &
   223            &                 - jna_LUMtx(j,n,-1) * jna_LUMtx(j,n-1,1)
   224  
   225          jna_LUMtx(j,n,1)  =   jna_LUMtx(j,n,1) / jna_LUMtx(j,n,0)
   226        end do
   227      end do
   228  
   229      do j = 1, JDim
   230        jna_LUMtx(j,NDim,0) =   jna_LUMtx(j,NDim, 0) &
   231          &                   - jna_LUMtx(j,NDim,-1) * jna_LUMtx(j,NDim-1,1)
   232      end do
   233  
   234    end subroutine PhyImplLUDecomp3
   235  
   236    !-------------------------------------------------------------------
   237  
   238    subroutine PhyImplLUSolve3( &
   239      & ijn_Vector, &       ! (inout)
   240      & jna_LUMtx, &        ! (in)
   241      & IDim, JDim, NDim &  ! (in)
   242      & )
   243      !
   244      ! LU 分解による解の計算 (3重対角行列用) を行います.
   245      !
   246      ! Solve with LU decomposition (For triple diagonal matrix).
   247      !
   248  
   249      ! 宣言文 ; Declaration statements
   250      !
   251      implicit none
   252      integer, intent(in):: IDim
   253      integer, intent(in):: JDim
   254      integer, intent(in):: NDim
   255      real(DP), intent(in):: jna_LUMtx(JDim, NDim, -1:1)
   256                                ! LU 行列.
   257                                ! LU matrix
   258      real(DP), intent(inout):: ijn_Vector(IDim, JDim, NDim)
   259                                ! 右辺ベクトル / 解.
   260                                ! Right-hand side vector / solution
   261  
   262      ! 作業変数
   263      ! Work variables
   264      !
   265      integer:: i, j, n         ! DO ループ用作業変数
   266                                ! Work variables for DO loop
   267  
   268      ! 実行文 ; Executable statement
   269      !
   270  
   271      ! 前進代入
   272      ! Forward substitution
   273      !
   274      do i = 1, IDim
   275        do j = 1, JDim
   276          ijn_Vector(i,j,1) = ijn_Vector(i,j,1) / jna_LUMtx(j,1,0)
   277        end do
   278      end do
     .  !cdir noassume                                                          
     .        do j1 = 0, jdim - 1, maxvl()                                      
     .           j2 = min0(jdim - j1,maxvl())                                   
     .           if (idim .gt. 0) then                                          
     .              j3 = and(idim,3)                                            
     .              do i = 1, j3                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .                 do j = 1, j2                                             
     .                    ijn_vector(i,j1+j,1) = ijn_vector(i,j1+j,1)/jna_lumtx(
     .       1               j1+j,1,0)                                          
     .                 enddo                                                    
     .              enddo                                                       
     .              do i = j3 + 1, idim, 4                                      
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .                 do j = 1, j2                                             
     .                    d1 = jna_lumtx(j1+j,1,0)                              
     .                    ijn_vector(i,j1+j,1) = ijn_vector(i,j1+j,1)/d1        
     .                    ijn_vector(i+1,j1+j,1) = ijn_vector(i+1,j1+j,1)/d1    
     .                    ijn_vector(i+2,j1+j,1) = ijn_vector(i+2,j1+j,1)/d1    
     .                    ijn_vector(i+3,j1+j,1) = ijn_vector(i+3,j1+j,1)/d1    
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   279  
   280      do n = 2, NDim
   281        do i = 1, IDim
   282          do j = 1, JDim
   283            ijn_Vector(i,j,n) = (   ijn_Vector(i,j,n) &
   284              &                   - ijn_Vector(i,j,n-1) * jna_LUMtx(j,n,-1) &
   285              &                  ) / jna_LUMtx(j,n,0)
   286          end do
   287        end do
     .  !cdir noassume                                                          
     .        do j4 = 0, jdim - 1, maxvl()                                      
     .           j5 = min0(jdim - j4,maxvl())                                   
     .           if (idim .gt. 0) then                                          
     .              j6 = and(idim,3)                                            
     .              do i = 1, j6                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(jna_lumtx)                                        
     .                 do j = 1, j5                                             
     .                    ijn_vector(i,j4+j,n) = (ijn_vector(i,j4+j,n)-         
     .       1               ijn_vector(i,j4+j,n-1)*jna_lumtx(j4+j,n,-1))/      
     .       2               jna_lumtx(j4+j,n,0)                                
     .                 enddo                                                    
     .              enddo                                                       
     .              do i = j6 + 1, idim, 4                                      
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(jna_lumtx)                                        
     .                 do j = 1, j5                                             
     .                    d3 = jna_lumtx(j4+j,n,0)                              
     .                    d2 = jna_lumtx(j4+j,n,-1)                             
     .                    ijn_vector(i,j4+j,n) = (ijn_vector(i,j4+j,n)-         
     .       1               ijn_vector(i,j4+j,n-1)*d2)/d3                      
     .                    ijn_vector(i+1,j4+j,n) = (ijn_vector(i+1,j4+j,n)-     
     .       1               ijn_vector(i+1,j4+j,n-1)*d2)/d3                    
     .                    ijn_vector(i+2,j4+j,n) = (ijn_vector(i+2,j4+j,n)-     
     .       1               ijn_vector(i+2,j4+j,n-1)*d2)/d3                    
     .                    ijn_vector(i+3,j4+j,n) = (ijn_vector(i+3,j4+j,n)-     
     .       1               ijn_vector(i+3,j4+j,n-1)*d2)/d3                    
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   288      end do
   289  
   290      ! 後退代入
   291      ! Backward substitution
   292      !
   293      do n = NDim-1, 1, -1
   294        do i = 1, IDim
   295          do j = 1, JDim
   296            ijn_Vector(i,j,n) =   ijn_Vector(i,j,n) &
   297              &                 - ijn_Vector(i,j,n+1) * jna_LUMtx(j,n,1)
   298          end do
   299        end do
     .  !cdir noassume                                                          
     .        do j7 = 0, jdim - 1, maxvl()                                      
     .           j8 = min0(jdim - j7,maxvl())                                   
     .           if (idim .gt. 0) then                                          
     .              j9 = and(idim,3)                                            
     .              do i = 1, j9                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(jna_lumtx)                                        
     .                 do j = 1, j8                                             
     .                    ijn_vector(i,j7+j,n) = ijn_vector(i,j7+j,n) -         
     .       1               ijn_vector(i,j7+j,n+1)*jna_lumtx(j7+j,n,1)         
     .                 enddo                                                    
     .              enddo                                                       
     .              do i = j9 + 1, idim, 4                                      
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(jna_lumtx)                                        
     .                 do j = 1, j8                                             
     .                    d4 = jna_lumtx(j7+j,n,1)                              
     .                    ijn_vector(i,j7+j,n) = ijn_vector(i,j7+j,n) -         
     .       1               ijn_vector(i,j7+j,n+1)*d4                          
     .                    ijn_vector(i+1,j7+j,n) = ijn_vector(i+1,j7+j,n) -     
     .       1               ijn_vector(i+1,j7+j,n+1)*d4                        
     .                    ijn_vector(i+2,j7+j,n) = ijn_vector(i+2,j7+j,n) -     
     .       1               ijn_vector(i+2,j7+j,n+1)*d4                        
     .                    ijn_vector(i+3,j7+j,n) = ijn_vector(i+3,j7+j,n) -     
     .       1               ijn_vector(i+3,j7+j,n+1)*d4                        
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   300      end do
   301  
   302    end subroutine PhyImplLUSolve3
   303  
   304    !-------------------------------------------------------------------
   305  
   306    subroutine PhyImplUtilsInit
   307      !
   308      ! phy_implicit_utils モジュールの初期化を行います.
   309      ! NAMELIST#phy_implicit_nml の読み込みはこの手続きで行われます.
   310      !
   311      ! "phy_implicit_utils" module is initialized.
   312      ! "NAMELIST#phy_implicit_utils_nml" is loaded in this procedure.
   313      !
   314  
   315      ! モジュール引用 ; USE statements
   316      !
   317  
   318      ! NAMELIST ファイル入力に関するユーティリティ
   319      ! Utilities for NAMELIST file input
   320      !
   321      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   322  
   323      ! ファイル入出力補助
   324      ! File I/O support
   325      !
   326      use dc_iounit, only: FileOpen
   327  
   328      ! 種別型パラメタ
   329      ! Kind type parameter
   330      !
   331      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   332  
   333      ! 文字列操作
   334      ! Character handling
   335      !
   336      use dc_string, only: StoA
   337  
   338      ! ヒストリデータ出力
   339      ! History data output
   340      !
   341      use gtool_historyauto, only: HistoryAutoAddVariable
   342  
   343      ! 宣言文 ; Declaration statements
   344      !
   345      implicit none
   346  
   347      ! 作業変数
   348      ! Work variables
   349      !
   350  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   351  !!$                              ! Unit number for NAMELIST file open
   352  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   353  !!$                              ! IOSTAT of NAMELIST read
   354  
   355      ! NAMELIST 変数群
   356      ! NAMELIST group name
   357      !
   358  !!$    namelist /phy_implicit_nml/
   359  !!$          !
   360  !!$          ! デフォルト値については初期化手続 "phy_implicit#PhyImplInit"
   361  !!$          ! のソースコードを参照のこと.
   362  !!$          !
   363  !!$          ! Refer to source codes in the initialization procedure
   364  !!$          ! "phy_implicit#PhyImplInit" for the default values.
   365  !!$          !
   366  
   367      ! 実行文 ; Executable statement
   368      !
   369  
   370      if ( phy_implicit_utils_inited ) return
   371  
   372      ! デフォルト値の設定
   373      ! Default values settings
   374      !
   375  
   376      ! NAMELIST の読み込み
   377      ! NAMELIST is input
   378      !
   379  !!$    if ( trim(namelist_filename) /= '' ) then
   380  !!$      call FileOpen( unit_nml, &          ! (out)
   381  !!$        & namelist_filename, mode = 'r' ) ! (in)
   382  !!$
   383  !!$      rewind( unit_nml )
   384  !!$      read( unit_nml, &           ! (in)
   385  !!$        & nml = phy_implicit_nml, &  ! (out)
   386  !!$        & iostat = iostat_nml )   ! (out)
   387  !!$      close( unit_nml )
   388  !!$
   389  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   390  !!$    end if
   391  
   392      ! 印字 ; Print
   393      !
   394      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   395      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   396  
   397      phy_implicit_utils_inited = .true.
   398  
   399    end subroutine PhyImplUtilsInit
   400  
   401    !-------------------------------------------------------------------
   402  
   403  end module phy_implicit_utils
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: phy_implicit_utils.f90
PROGRAM NAME: phy_implicit_utils
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 陰解法による時間積分のためのルーチン
     2:             !
     3:             != Routines for time integration with implicit scheme
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6:             ! Version::   $Id: phy_implicit_utils.f90,v 1.3 2014/05/07 09:39:20 murashin Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module phy_implicit_utils
    13:               !
    14:               != 陰解法による時間積分のためのルーチン
    15:               !
    16:               != Routines for time integration with implicit scheme
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               !
    22:               ! PhyImplEvalRadLFluxA :: 長波フラックス補正
    23:               ! ------------         :: ------------
    24:               ! PhyImplEvalRadLFluxA :: Longwave flux correction
    25:               !
    26:               !--
    27:               !== NAMELIST
    28:               !
    29:               ! NAMELIST#phy_implicit_utils_nml
    30:               !++
    31:             
    32:               ! モジュール引用 ; USE statements
    33:               !
    34:             
    35:               ! 格子点設定
    36:               ! Grid points settings
    37:               !
    38:               use gridset, only: imax, & ! 経度格子点数. 
    39:                                          ! Number of grid points in longitude
    40:                 &                jmax, & ! 緯度格子点数. 
    41:                                          ! Number of grid points in latitude
    42:                 &                kmax    ! 鉛直層数. 
    43:                                          ! Number of vertical level
    44:             
    45:               ! 組成に関わる配列の設定
    46:               ! Settings of array for atmospheric composition
    47:               !
    48:               use composition, only: ncmax, IndexH2OVap
    49:             
    50:               ! 種別型パラメタ
    51:               ! Kind type parameter
    52:               !
    53:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    54:                 &                 STRING     ! 文字列.       Strings. 
    55:             
    56:               ! メッセージ出力
    57:               ! Message output
    58:               !
    59:               use dc_message, only: MessageNotify
    60:             
    61:               ! 宣言文 ; Declaration statements
    62:               !
    63:               implicit none
    64:               private
    65:             
    66:               ! 公開手続き
    67:               ! Public procedure
    68:               !
    69:               public :: PhyImplEvalRadLFluxA, PhyImplLUDecomp3, PhyImplLUSolve3
    70:               public :: PhyImplUtilsInit
    71:             
    72:               ! 公開変数
    73:               ! Public variables
    74:               !
    75:             
    76:               ! 非公開変数
    77:               ! Private variables
    78:               !
    79:               logical, save :: phy_implicit_utils_inited = .false.
    80:                                           ! 初期設定フラグ. 
    81:                                           ! Initialization flag
    82:             
    83:               character(*), parameter:: module_name = 'phy_implicit_utils'
    84:                                           ! モジュールの名称. 
    85:                                           ! Module name
    86:               character(*), parameter:: version = &
    87:                 & '$Name:  $' // &
    88:                 & '$Id: phy_implicit_utils.f90,v 1.3 2014/05/07 09:39:20 murashin Exp $'
    89:                                           ! モジュールのバージョン
    90:                                           ! Module version
    91:             
    92:             contains
    93:             
    94:               !-------------------------------------------------------------------
    95:             
    96:               subroutine PhyImplEvalRadLFluxA( &
    97:                 & xyr_RadLFlux, &                                  ! (in)
    98:                 & xyz_DTempDt, xy_DSurfTempDt, xyra_DelRadLFlux, & ! (in)
    99:                 & xyr_RadLFluxA &                                  ! (out)
   100:                 & )
   101:                 !
   102:                 ! $ t-\Delta t $ における変化率を元に, 
   103:                 ! $ t+\Delta t $ の長波フラックス (xyr_RadLFluxA) を算出します. 
   104:                 ! 
   105:                 ! Evaluate longwave flux at $ t+\Delta t $ (xyr_RadLFluxA) 
   106:                 ! from the tendency at $ t-\Delta t $ . 
   107:                 !
   108:             
   109:                 ! モジュール引用 ; USE statements
   110:                 !
   111:             
   112:                 ! 時刻管理
   113:                 ! Time control
   114:                 !
   115:                 use timeset, only: DelTime, &  ! $ \Delta t $ [s]
   116:                   & TimesetClockStart, TimesetClockStop
   117:             
   118:                 ! 宣言文 ; Declaration statements
   119:                 !
   120:                 implicit none
   121:                 real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   122:                                           ! 長波フラックス. 
   123:                                           ! Longwave flux
   124:                 real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   125:                                           ! $ \DP{T}{t} $ . 温度変化. 
   126:                                           ! Temperature tendency
   127:                 real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
   128:                                           ! 地表面温度変化率. 
   129:                                           ! Surface temperature tendency
   130:                 real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax,  0:1)
   131:                                           ! 長波地表温度変化. 
   132:                                           ! Surface temperature tendency with longwave
   133:                 real(DP), intent(out):: xyr_RadLFluxA (0:imax-1, 1:jmax, 0:kmax)
   134:                                           ! $ t-\Delta t $ における変化率を元に
   135:                                           ! 算出された $ t+\Delta t $ における
   136:                                           ! 長波フラックス. 
   137:                                           !
   138:                                           ! Longwave flux at $ t+\Delta t $ 
   139:                                           ! calculated from the tendency at 
   140:                                           ! $ t-\Delta t $ . 
   141:             
   142:                 ! 作業変数
   143:                 ! Work variables
   144:                 !
   145:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   146:                                           ! Work variables for DO loop in vertical direction
   147:             
   148:                 ! 実行文 ; Executable statement
   149:                 !
   150:             
   151:                 ! 初期化確認
   152:                 ! Initialization check
   153:                 !
   154:                 if ( .not. phy_implicit_utils_inited ) then
   155:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   156:                 end if
   157:             
   158:             
   159:                 ! 計算時間計測開始
   160:                 ! Start measurement of computation time
   161:                 !
   162:                 call TimesetClockStart( module_name )
   163:             
   164:             
   165:                 ! $ t+\Delta t $ の長波フラックス (xyr_RadLFluxA) を算出
   166:                 ! Evaluate longwave flux at $ t+\Delta t $ (xyr_RadLFluxA)
   167:                 !
   168: +------>        do k = 0, kmax
   169: |W*==== A         xyr_RadLFluxA(:,:,k) = &
   170: |                   &   xyr_RadLFlux(:,:,k) &
   171: |                   & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
   172: |                   &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
   173: |                   &   * 2.0_DP * DelTime
   174: +------         end do
   175:             
   176:                 ! 計算時間計測一時停止
   177:                 ! Pause measurement of computation time
   178:                 !
   179:                 call TimesetClockStop( module_name )
   180:             
   181:               end subroutine PhyImplEvalRadLFluxA
   182:             
   183:               !-------------------------------------------------------------------
   184:             
   185:               subroutine PhyImplLUDecomp3( &
   186:                 & jna_LUMtx, &            ! (inout)
   187:                 & JDim, NDim &            ! (in)
   188:                 & )
   189:                 !
   190:                 ! 3 重対角行列の LU 分解を行います. 
   191:                 !
   192:                 ! LU decomposition of triple diagonal matrix.
   193:                 !
   194:             
   195:                 ! 宣言文 ; Declaration statements
   196:                 !
   197:                 implicit none
   198:                 integer, intent(in):: JDim
   199:                 integer, intent(in):: NDim
   200:                 real(DP), intent(inout):: jna_LUMtx(JDim, NDim, -1:1)
   201:                                           ! LU 行列. 
   202:                                           ! LU matrix
   203:             
   204:                 ! 作業変数
   205:                 ! Work variables
   206:                 ! 
   207:                 integer:: j, n            ! DO ループ用作業変数
   208:                                           ! Work variables for DO loop
   209:             
   210:                 ! 実行文 ; Executable statement
   211:                 !
   212:             
   213:                 ! LU 分解
   214:                 ! LU decomposition
   215:                 !
   216: V------>        do j = 1, JDim
   217: |       A         jna_LUMtx(j,1,1) = jna_LUMtx(j,1,1) / jna_LUMtx(j,1,0)
   218: V------         end do
   219:             
   220: +------>        do n = 2, NDim-1
   221: |V----->          do j = 1, JDim
   222: ||      A           jna_LUMtx(j,n,0)  =   jna_LUMtx(j,n,0) &
   223: ||                    &                 - jna_LUMtx(j,n,-1) * jna_LUMtx(j,n-1,1)
   224: ||          
   225: ||      A           jna_LUMtx(j,n,1)  =   jna_LUMtx(j,n,1) / jna_LUMtx(j,n,0)
   226: |V-----           end do
   227: +------         end do
   228:             
   229: V------>        do j = 1, JDim
   230: |       A         jna_LUMtx(j,NDim,0) =   jna_LUMtx(j,NDim, 0) &
   231: |                   &                   - jna_LUMtx(j,NDim,-1) * jna_LUMtx(j,NDim-1,1)
   232: V------         end do
   233:             
   234:               end subroutine PhyImplLUDecomp3
   235:             
   236:               !-------------------------------------------------------------------
   237:             
   238:               subroutine PhyImplLUSolve3( &
   239:                 & ijn_Vector, &       ! (inout)
   240:                 & jna_LUMtx, &        ! (in)
   241:                 & IDim, JDim, NDim &  ! (in)
   242:                 & )
   243:                 !
   244:                 ! LU 分解による解の計算 (3重対角行列用) を行います.
   245:                 !
   246:                 ! Solve with LU decomposition (For triple diagonal matrix). 
   247:                 !
   248:             
   249:                 ! 宣言文 ; Declaration statements
   250:                 !
   251:                 implicit none
   252:                 integer, intent(in):: IDim
   253:                 integer, intent(in):: JDim
   254:                 integer, intent(in):: NDim
   255:                 real(DP), intent(in):: jna_LUMtx(JDim, NDim, -1:1)
   256:                                           ! LU 行列. 
   257:                                           ! LU matrix
   258:                 real(DP), intent(inout):: ijn_Vector(IDim, JDim, NDim)
   259:                                           ! 右辺ベクトル / 解. 
   260:                                           ! Right-hand side vector / solution
   261:             
   262:                 ! 作業変数
   263:                 ! Work variables
   264:                 ! 
   265:                 integer:: i, j, n         ! DO ループ用作業変数
   266:                                           ! Work variables for DO loop
   267:             
   268:                 ! 実行文 ; Executable statement
   269:                 !
   270:             
   271:                 ! 前進代入
   272:                 ! Forward substitution
   273:                 !
   274: +------>        do i = 1, IDim
   275: |V----->A         do j = 1, JDim
   276: ||      A           ijn_Vector(i,j,1) = ijn_Vector(i,j,1) / jna_LUMtx(j,1,0)
   277: |V-----           end do
   278: +------         end do
   279:             
   280: +------>        do n = 2, NDim
   281: |+----->          do i = 1, IDim
   282: ||V---->A           do j = 1, JDim
   283: |||     A             ijn_Vector(i,j,n) = (   ijn_Vector(i,j,n) &
   284: |||                     &                   - ijn_Vector(i,j,n-1) * jna_LUMtx(j,n,-1) &
   285: |||                     &                  ) / jna_LUMtx(j,n,0)
   286: ||V----             end do
   287: |+-----           end do
   288: +------         end do
   289:             
   290:                 ! 後退代入
   291:                 ! Backward substitution
   292:                 !
   293: +------>        do n = NDim-1, 1, -1
   294: |+----->          do i = 1, IDim
   295: ||V---->A           do j = 1, JDim
   296: |||     A             ijn_Vector(i,j,n) =   ijn_Vector(i,j,n) &
   297: |||                     &                 - ijn_Vector(i,j,n+1) * jna_LUMtx(j,n,1)
   298: ||V----             end do
   299: |+-----           end do
   300: +------         end do
   301:             
   302:               end subroutine PhyImplLUSolve3
   303:             
   304:               !-------------------------------------------------------------------
   305:             
   306:               subroutine PhyImplUtilsInit
   307:                 !
   308:                 ! phy_implicit_utils モジュールの初期化を行います. 
   309:                 ! NAMELIST#phy_implicit_nml の読み込みはこの手続きで行われます. 
   310:                 !
   311:                 ! "phy_implicit_utils" module is initialized. 
   312:                 ! "NAMELIST#phy_implicit_utils_nml" is loaded in this procedure. 
   313:                 !
   314:             
   315:                 ! モジュール引用 ; USE statements
   316:                 !
   317:             
   318:                 ! NAMELIST ファイル入力に関するユーティリティ
   319:                 ! Utilities for NAMELIST file input
   320:                 !
   321:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   322:             
   323:                 ! ファイル入出力補助
   324:                 ! File I/O support
   325:                 !
   326:                 use dc_iounit, only: FileOpen
   327:             
   328:                 ! 種別型パラメタ
   329:                 ! Kind type parameter
   330:                 !
   331:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   332:             
   333:                 ! 文字列操作
   334:                 ! Character handling
   335:                 !
   336:                 use dc_string, only: StoA
   337:             
   338:                 ! ヒストリデータ出力
   339:                 ! History data output
   340:                 !
   341:                 use gtool_historyauto, only: HistoryAutoAddVariable
   342:             
   343:                 ! 宣言文 ; Declaration statements
   344:                 !
   345:                 implicit none
   346:             
   347:                 ! 作業変数
   348:                 ! Work variables
   349:                 !
   350:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   351:             !!$                              ! Unit number for NAMELIST file open
   352:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   353:             !!$                              ! IOSTAT of NAMELIST read
   354:             
   355:                 ! NAMELIST 変数群
   356:                 ! NAMELIST group name
   357:                 !
   358:             !!$    namelist /phy_implicit_nml/
   359:             !!$          !
   360:             !!$          ! デフォルト値については初期化手続 "phy_implicit#PhyImplInit" 
   361:             !!$          ! のソースコードを参照のこと. 
   362:             !!$          !
   363:             !!$          ! Refer to source codes in the initialization procedure
   364:             !!$          ! "phy_implicit#PhyImplInit" for the default values. 
   365:             !!$          !
   366:             
   367:                 ! 実行文 ; Executable statement
   368:                 !
   369:             
   370:                 if ( phy_implicit_utils_inited ) return
   371:             
   372:                 ! デフォルト値の設定
   373:                 ! Default values settings
   374:                 !
   375:             
   376:                 ! NAMELIST の読み込み
   377:                 ! NAMELIST is input
   378:                 !
   379:             !!$    if ( trim(namelist_filename) /= '' ) then
   380:             !!$      call FileOpen( unit_nml, &          ! (out)
   381:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   382:             !!$
   383:             !!$      rewind( unit_nml )
   384:             !!$      read( unit_nml, &           ! (in)
   385:             !!$        & nml = phy_implicit_nml, &  ! (out)
   386:             !!$        & iostat = iostat_nml )   ! (out)
   387:             !!$      close( unit_nml )
   388:             !!$
   389:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   390:             !!$    end if
   391:             
   392:                 ! 印字 ; Print
   393:                 !
   394:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   395:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   396:             
   397:                 phy_implicit_utils_inited = .true.
   398:             
   399:               end subroutine PhyImplUtilsInit
   400:             
   401:               !-------------------------------------------------------------------
   402:             
   403:             end module phy_implicit_utils
