Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:19 2016
FILE NAME: sosi_utils.f90
PROGRAM NAME: sosi_utils
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   166  vec  (   3): Unvectorized loop.
   169  opt  (1017): Subroutine call prevents optimization.
   169  vec  (   9): Vectorization obstructive statement.
   169  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   173  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   248  vec  (   1): Vectorized loop.
   248  vec  (  29): ADB is used for array.: r_sidepth
   251  vec  (  26): Macro operation Search.
   252  opt  (1084): Branch out of the loop inhibits optimization.
   261  vec  (   1): Vectorized loop.
   261  vec  (  29): ADB is used for array.: xyr_sosilocaldepth
   261  vec  (  29): ADB is used for array.: r_sidepth
   266  vec  (   1): Vectorized loop.
   266  vec  (  29): ADB is used for array.: xyr_sosilocaldepth
   270  vec  (   1): Vectorized loop.
   270  vec  (  29): ADB is used for array.: xyz_sosilocaldepth
   270  vec  (  29): ADB is used for array.: xyr_sosilocaldepth
   274  vec  (   1): Vectorized loop.
   274  vec  (  29): ADB is used for array.: xyz_sosilocaldepth
   351  opt  (1593): Loop nest collapsed into one loop.
   351  vec  (   4): Vectorized array expression.
   351  vec  (  29): ADB is used for array.: xy_seaicethickness
   351  vec  (  29): ADB is used for array.: xy_soseaicemass
   371  vec  (   1): Vectorized loop.
   371  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   378  warn (  82): Name "xy_seaicethicknessa" is not used.
   378  warn (  82): Name "xyr_sosilocaldeptha" is not used.
   378  warn (  82): Name "xy_sosilocalkmaxa" is not used.
   378  warn (  82): Name "xyz_sosilocaldeptha" is not used.
   479  opt  (  11): Fused array assignments. :line 479 - 483
   479  opt  (1593): Loop nest collapsed into one loop.
   479  vec  (   4): Vectorized array expression.
   479  vec  (  29): ADB is used for array.: xy_dsoseaicemassdtphytop
   479  vec  (  29): ADB is used for array.: xy_dsoseaicemassdtphybot
   479  vec  (  29): ADB is used for array.: xy_soseaicemass
   490  opt  (1593): Loop nest collapsed into one loop.
   490  vec  (   4): Vectorized array expression.
   490  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdtphy
   490  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   501  opt  (1593): Loop nest collapsed into one loop.
   501  vec  (   4): Vectorized array expression.
   501  vec  (  29): ADB is used for array.: xy_seaicethickness
   501  vec  (  29): ADB is used for array.: xy_soseaicemass
   513  opt  (1593): Loop nest collapsed into one loop.
   513  vec  (   4): Vectorized array expression.
   513  vec  (  29): ADB is used for array.: xy_seaicethicknesstent1
   529  vec  (   1): Vectorized loop.
   529  vec  (  29): ADB is used for array.: xyz_soseaicetemptent1
   536  vec  (   1): Vectorized loop.
   536  vec  (  29): ADB is used for array.: xyz_soseaicetemptent1
   554  opt  (1593): Loop nest collapsed into one loop.
   554  vec  (   4): Vectorized array expression.
   554  vec  (  29): ADB is used for array.: xy_seaicethicknesstent2
   568  vec  (   1): Vectorized loop.
   568  vec  (  29): ADB is used for array.: xyr_sosilocaldeptht2maptot1
   572  vec  (   1): Vectorized loop.
   572  vec  (  29): ADB is used for array.: xyr_sosilocaldeptht2maptot1
   572  vec  (  29): ADB is used for array.: xyr_sosilocaldepthtent2
   577  vec  (   1): Vectorized loop.
   577  vec  (  29): ADB is used for array.: xyr_sosilocaldeptht2maptot1
   588  vec  (   1): Vectorized loop.
   588  vec  (  29): ADB is used for array.: xyz_soseaicetemptent2
   595  vec  (   1): Vectorized loop.
   595  vec  (  29): ADB is used for array.: xyr_sosilocaldepthtent1
   596  opt  (1084): Branch out of the loop inhibits optimization.
   596  vec  (  26): Macro operation Search.
   600  vec  (   1): Vectorized loop.
   600  vec  (  29): ADB is used for array.: xyr_sosilocaldepthtent1
   601  opt  (1084): Branch out of the loop inhibits optimization.
   601  vec  (  26): Macro operation Search.
   619  vec  (   1): Vectorized loop.
   619  vec  (  29): ADB is used for array.: xyr_sosilocaldepthtent1
   619  vec  (  29): ADB is used for array.: xyz_soseaicetemptent1
   620  vec  (  26): Macro operation Sum/InnerProd.
   637  vec  (   1): Vectorized loop.
   637  vec  (  29): ADB is used for array.: xyz_soseaicetemptent2
   649  opt  (1593): Loop nest collapsed into one loop.
   649  vec  (   4): Vectorized array expression.
   649  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   653  opt  (1593): Loop nest collapsed into one loop.
   653  vec  (   4): Vectorized array expression.
   653  vec  (  29): ADB is used for array.: xy_soseaicemass
   659  vec  (   3): Unvectorized loop.
   662  opt  (1017): Subroutine call prevents optimization.
   662  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   674  opt  (1593): Loop nest collapsed into one loop.
   674  vec  (   4): Vectorized array expression.
   674  vec  (  29): ADB is used for array.: xy_seaicethickness
   674  vec  (  29): ADB is used for array.: xy_soseaicemass
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:19 2016
FILE NAME: sosi_utils.f90
PROGRAM NAME: sosi_utils
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Slab ocean sea ice utility module
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: phy_implicit_sdh_V3.f90,v 1.1 2015/01/29 12:05:01 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module sosi_utils
    13    !
    14    !=
    15    !
    16    != Slab ocean sea ice utility module
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22  !!$  ! PhyImplSDHTendency              :: 時間変化率の計算
    23  !!$  ! PhyImplSDHSetMethodFromMatthews :: SurfType から計算法インデクスの作成
    24  !!$  ! PhyImplSDHInit                  :: 初期化
    25  !!$  ! ------------------------------- :: ------------
    26  !!$  ! PhyImplSDHTendency              :: Calculate tendency
    27  !!$  ! PhyImplSDHSetMethodFromMatthews :: Set index for calculation method
    28  !!$  ! PhyImplSDHInit                  :: Initialization
    29    !
    30    !--
    31    !== NAMELIST
    32    !
    33    ! NAMELIST#sosi_utils_nml
    34    !++
    35  
    36    ! モジュール引用 ; USE statements
    37    !
    38  
    39    ! 格子点設定
    40    ! Grid points settings
    41    !
    42    use gridset, only:   imax, & ! 経度格子点数.
    43                                 ! Number of grid points in longitude
    44      &                  jmax, & ! 緯度格子点数.
    45                                 ! Number of grid points in latitude
    46      &                  kmax, & ! 鉛直層数.
    47                                 ! Number of vertical level
    48      &                  kslmax, & ! 地下の鉛直層数.
    49                                 ! Number of subsurface vertical level
    50      &                  ksimax  ! 海氷の鉛直層数.
    51                                 ! Number of sea ice vertical level
    52  
    53    ! 種別型パラメタ
    54    ! Kind type parameter
    55    !
    56    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    57      &                 STRING     ! 文字列.       Strings.
    58  
    59    ! メッセージ出力
    60    ! Message output
    61    !
    62    use dc_message, only: MessageNotify
    63  
    64    ! 宣言文 ; Declaration statements
    65    !
    66    implicit none
    67    private
    68  
    69    real(DP), parameter :: SIDepthMergin = 1.0e-3_DP
    70                                 ! Mergin for sea ice depth
    71                                 ! This is used to avoid very thin sea ice layer.
    72  
    73    ! 公開手続き
    74    ! Public procedure
    75    !
    76    public :: SOSIUtilsChkSOSeaIce
    77    public :: SOSIUtilsSetSOSeaIceLevels
    78    public :: SOSIUtilsSetMissingValue
    79    public :: SOSIUtilsAddPhysics
    80    public :: SOSIUtilsInit
    81  
    82  
    83    ! 公開変数
    84    ! Public variables
    85    !
    86    real(DP), parameter, public :: SOSeaIceTempMissingValue = -99999.0_DP
    87  
    88  
    89    real(DP), save, public :: SOSeaIceMassNegativeThreshold
    90  
    91  
    92    logical, save :: sosi_utils_inited = .false.
    93                                ! 初期設定フラグ.
    94                                ! Initialization flag
    95  
    96    character(*), parameter:: module_name = 'sosi_utils'
    97                                ! モジュールの名称.
    98                                ! Module name
    99    character(*), parameter:: version = &
   100      & '$Name:  $' // &
   101      & '$Id: phy_implicit_sdh_V3.f90,v 1.1 2015/01/29 12:05:01 yot Exp $'
   102                                ! モジュールのバージョン
   103                                ! Module version
   104  
   105  contains
   106  
   107    !--------------------------------------------------------------------------------------
   108  
   109    subroutine SOSIUtilsChkSOSeaIce(          &
   110      & xy_SeaIceThickness, xyz_SOSeaIceTemp, & ! (in)
   111      & ParentRoutine                         & ! (in)
   112      & )
   113      !
   114      !
   115      !
   116      ! Set index for calculation method from Matthews' index
   117      !
   118  
   119      ! モジュール引用 ; USE statements
   120      !
   121  
   122      ! 宣言文 ; Declaration statements
   123      !
   124      real(DP), intent(in ) :: xy_SeaIceThickness(0:imax-1, 1:jmax)
   125  !!!! Modified by M.Ishiwatari (2016-12-10)
   126  !!!!    real(DP), intent(in ) :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 1:ksimax)
   127      real(DP), intent(in ) :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 0:ksimax)
   128      character(*), intent(in ), optional :: ParentRoutine
   129  
   130  
   131      ! 作業変数
   132      ! Work variables
   133      !
   134      integer  :: xy_SOSILocalKMax(0:imax-1, 1:jmax)
   135      real(DP) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   136  !!!! Modified by M.Ishiwatari (2016-12-10)
   137  !!!!    real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   138      real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   139  
   140      integer:: i               ! 経度方向に回る DO ループ用作業変数
   141                                ! Work variables for DO loop in longitude
   142      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   143                                ! Work variables for DO loop in latitude
   144      integer:: k
   145  
   146  
   147      ! 実行文 ; Executable statement
   148      !
   149  
   150      ! 初期化確認
   151      ! Initialization check
   152      !
   153      if ( .not. sosi_utils_inited ) then
   154        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   155      end if
   156  
   157  
   158      call SOSIUtilsSetSOSeaIceLevels(                     &
   159      & xy_SeaIceThickness,                                       & ! (in   )
   160      & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   161      & )
   162  
   163  
   164      do i = 0, imax-1
   165        do j = 1, jmax
   166          do k = 1, xy_SOSILocalKMax(i,j)
   167            if ( xyz_SOSeaIceTemp(i,j,k) < 0.0_DP ) then
   168              if ( present( ParentRoutine ) ) then
   169                call MessageNotify( 'M', module_name, &
   170                  & 'Called from %c:', &
   171                  & c1 = trim( ParentRoutine ) )
   172              end if
   173              call MessageNotify( 'M', module_name, &
   174                & 'xyz_SOSeaIceTemp(%d,%d,%d) = %f.', &
   175                & i = (/i,j,k/), d = (/xyz_SOSeaIceTemp(i,j,k)/) )
   176            end if
   177          end do
   178        end do
   179      end do
   180  
   181  
   182    end subroutine SOSIUtilsChkSOSeaIce
   183  
   184    !--------------------------------------------------------------------------------------
   185  
   186    subroutine SOSIUtilsSetSOSeaIceLevels(                     &
   187      & xy_SeaIceThickness,                                       & ! (in   )
   188      & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   189      & )
   190      !
   191      !
   192      !
   193      ! Set index for calculation method from Matthews' index
   194      !
   195  
   196      ! モジュール引用 ; USE statements
   197      !
   198  
   199      ! 座標データ設定
   200      ! Axes data settings
   201      !
   202      use axesset, only: &
   203        & r_SIDepth         ! sea ice grid on interface of layer
   204  
   205  
   206      ! 宣言文 ; Declaration statements
   207      !
   208      real(DP), intent(in ) :: xy_SeaIceThickness(0:imax-1, 1:jmax)
   209                                !
   210                                ! Sea ice thickness
   211      integer , intent(out) :: xy_SOSILocalKMax  (0:imax-1, 1:jmax)
   212      real(DP), intent(out) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   213  !!!! Modified by M.Ishiwatari (2016-12-10)
   214  !!!!    real(DP), intent(out) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   215      real(DP), intent(out) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   216  
   217  
   218      ! 作業変数
   219      ! Work variables
   220      !
   221  
   222      integer:: i               ! 経度方向に回る DO ループ用作業変数
   223                                ! Work variables for DO loop in longitude
   224      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   225                                ! Work variables for DO loop in latitude
   226      integer:: k
   227  
   228  
   229      ! 実行文 ; Executable statement
   230      !
   231  
   232      ! 初期化確認
   233      ! Initialization check
   234      !
   235      if ( .not. sosi_utils_inited ) then
   236        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   237      end if
   238  
   239  
   240      do i = 0, imax-1
   241        do j = 1, jmax
   242          if ( xy_SeaIceThickness(i,j) == 0.0_DP ) then
   243            xy_SOSILocalKMax(i,j) = 0
   244          else if ( - xy_SeaIceThickness(i,j) < r_SIDepth(ksimax) ) then
   245            xy_SOSILocalKMax(i,j) = ksimax
   246          else
   247            xy_SOSILocalKMax(i,j) = 0
   248            search_ksimax : do k = 0+1, ksimax
   249  !!$            if ( - xy_SeaIceThickness(i,j) >= r_SIDepth(k) ) then
   250              ! This SIDepthMergin avoids very thin lowest layer.
   251              if ( - xy_SeaIceThickness(i,j) >= r_SIDepth(k)-SIDepthMergin ) then
   252                  xy_SOSILocalKMax(i,j) = k
   253                exit search_ksimax
   254              end if
   255            end do search_ksimax
   256          end if
   257        end do
   258      end do
   259      do j = 1, jmax
   260        do i = 0, imax-1
   261          do k = 0, xy_SOSILocalKMax(i,j)-1
     .  !cdir nodep                                                             
     .  !cdir on_adb(r_sidepth)                                                 
     .        do k = 0, xy_sosilocalkmax(i,j) - 1                               
   262            xyr_SOSILocalDepth(i,j,k) = r_SIDepth(k)
   263          end do
   264          k = xy_SOSILocalKMax(i,j)
   265          xyr_SOSILocalDepth(i,j,k) = - xy_SeaIceThickness(i,j)
   266          do k = xy_SOSILocalKMax(i,j)+1, ksimax
   267            xyr_SOSILocalDepth(i,j,k) = -1.0e100_DP
   268          end do
     .           xy_sosilocalkmax1 = xy_sosilocalkmax(i,j)                      
     .  !cdir nodep                                                             
     .        do k = 1, ksimax - xy_sosilocalkmax(i,j)                          
     .           xyr_sosilocaldepth(i,j,xy_sosilocalkmax1+k) =                  
     .       1      -1.00000000000000e+100                                      
     .        enddo                                                             
   269          !
   270          do k = 1, xy_SOSILocalKMax(i,j)
   271            xyz_SOSILocalDepth(i,j,k) = &
   272              & ( xyr_SOSILocalDepth(i,j,k-1) + xyr_SOSILocalDepth(i,j,k) ) / 2.0_DP
   273          end do
     .        d1 = 1.D0/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .        do k = 1, xy_sosilocalkmax(i,j)                                   
     .           xyz_sosilocaldepth(i,j,k) = (xyr_sosilocaldepth(i,j,k-1)+      
     .       1      xyr_sosilocaldepth(i,j,k))*d1                               
     .        enddo                                                             
   274          do k = xy_SOSILocalKMax(i,j)+1, ksimax
   275            xyz_SOSILocalDepth(i,j,k) = -1.0e100_DP
   276          end do
     .        xy_sosilocalkmax2 = xy_sosilocalkmax(i,j)                         
     .  !cdir nodep                                                             
     .        do k = 1, ksimax - xy_sosilocalkmax(i,j)                          
     .           xyz_sosilocaldepth(i,j,xy_sosilocalkmax2+k) =                  
     .       1      -1.00000000000000e+100                                      
     .        enddo                                                             
   277        end do
   278      end do
   279  
   280  
   281    end subroutine SOSIUtilsSetSOSeaIceLevels
   282  
   283    !--------------------------------------------------------------------------------------
   284  
   285    subroutine SOSIUtilsSetMissingValue( &
   286      & xy_SOSeaIceMass,                 & !(in )
   287      & xyz_SOSeaIceTemp,                & !(inout)
   288      & SOSeaIceValue                    & !(in ) optional
   289      & )
   290      !
   291      ! Set missing values
   292  
   293      ! 雪と海氷の定数の設定
   294      ! Setting constants of snow and sea ice
   295      !
   296      use constants_snowseaice, only: &
   297        & TempBelowSeaIce, &
   298        & SeaIceDen
   299  
   300  
   301      ! 宣言文 ; Declaration statements
   302      !
   303      real(DP), intent(in ) :: xy_SOSeaIceMass    (0:imax-1, 1:jmax)
   304                                ! $ M_si $ . 海氷質量 (kg m-2)
   305                                ! Slab ocean sea ice mass (kg m-2)
   306  !!!! Modified by M.Ishiwatari (2016-12-10)
   307  !!!!    real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
   308      real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 0:ksimax)
   309      real(DP), intent(in   ), optional :: SOSeaIceValue
   310  
   311  
   312      ! 作業変数
   313      ! Work variables
   314      !
   315      real(DP) :: xy_SeaIceThickness(0:imax-1, 1:jmax)
   316                   !
   317                   ! Sea ice thickness
   318      integer  :: xy_SOSILocalKMax  (0:imax-1, 1:jmax)
   319      real(DP) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   320  !!!! Modified by M.Ishiwatari(2016-12-10)
   321  !!!!    real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   322      real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   323  
   324      real(DP) :: xy_SeaIceThicknessA(0:imax-1, 1:jmax)
   325                   !
   326                   ! Sea ice thickness
   327      integer  :: xy_SOSILocalKMaxA  (0:imax-1, 1:jmax)
   328      real(DP) :: xyr_SOSILocalDepthA(0:imax-1, 1:jmax, 0:ksimax)
   329  !!!! Modified by M.Ishiwatari (2016-12-10)
   330  !!!!    real(DP) :: xyz_SOSILocalDepthA(0:imax-1, 1:jmax, 1:ksimax)
   331      real(DP) :: xyz_SOSILocalDepthA(0:imax-1, 1:jmax, 0:ksimax)
   332  
   333      real(DP) :: SetValue
   334  
   335      integer:: i               ! 東西方向に回る DO ループ用作業変数
   336                                ! Work variables for DO loop in zonal direction
   337      integer:: j               ! 南北方向に回る DO ループ用作業変数
   338                                ! Work variables for DO loop in meridional direction
   339      integer:: k
   340  
   341  
   342      if ( .not. sosi_utils_inited ) then
   343        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   344      end if
   345  
   346  
   347  
   348      !
   349      ! Calcuate sea ice thickness
   350      !
   351      xy_SeaIceThickness = xy_SOSeaIceMass / SeaIceDen
     .        d1 = 1.D0/seaiceden                                               
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t180 = 1, jmax*imax                                            
     .           xy_seaicethickness(t180-1,1) = xy_soseaicemass(t180-1,1)*d1    
     .        enddo                                                             
   352      !
   353      ! Set slab ocean sea ice levels
   354      !
   355      call SOSIUtilsSetSOSeaIceLevels(                              &
   356        & xy_SeaIceThickness,                                       & ! (in   )
   357        & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   358        & )
   359  
   360  
   361      if ( present ( SOSeaIceValue ) ) then
   362        SetValue = SOSeaIceValue
   363      else
   364        SetValue = SOSeaIceTempMissingValue
   365      end if
   366      !
   367      ! Set missing values
   368      !
   369      do j = 1, jmax
   370        do i = 0, imax-1
   371          do k = xy_SOSILocalKMax(i,j)+1, ksimax
   372            xyz_SOSeaIceTemp(i,j,k) = SetValue
   373          end do
     .        xy_sosilocalkmax1 = xy_sosilocalkmax(i,j)                         
     .  !cdir nodep                                                             
     .        do k = 1, ksimax - xy_sosilocalkmax(i,j)                          
     .           xyz_soseaicetemp(i,j,xy_sosilocalkmax1+k) = setvalue           
     .        enddo                                                             
   374        end do
   375      end do
   376  
   377  
   378    end subroutine SOSIUtilsSetMissingValue
   379  
   380    !--------------------------------------------------------------------------------------
   381  
   382    subroutine SOSIUtilsAddPhysics(                         &
   383      & xy_SOSeaIceMass, xyz_SOSeaIceTemp,                  & !(inout)
   384      & xy_DSOSeaIceMassDtPhyTop, xy_DSOSeaIceMassDtPhyBot, & !(in   )
   385      & xyz_DSOSeaIceTempDtPhy                              & !(in   )
   386      & )
   387      !
   388      ! Calculates slab sea ice horizontal transports by diffusion
   389  
   390      ! ヒストリデータ出力
   391      ! History data output
   392      !
   393      use gtool_historyauto, only: HistoryAutoPut
   394  
   395      use timeset    , only : &
   396        & TimeN, &
   397        & DelTime
   398                                ! $\Delta t$
   399  
   400      ! 雪と海氷の定数の設定
   401      ! Setting constants of snow and sea ice
   402      !
   403      use constants_snowseaice, only: &
   404        & TempBelowSeaIce, &
   405        & SeaIceDen
   406  
   407  
   408      ! 宣言文 ; Declaration statements
   409      !
   410      real(DP), intent(inout) :: xy_SOSeaIceMass    (0:imax-1, 1:jmax)
   411                                ! $ M_si $ . 海氷質量 (kg m-2)
   412                                ! Slab ocean sea ice mass (kg m-2)
   413  !!!! Modified by M.Ishiwatari (2016-12-10)
   414  !!!!    real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
   415      real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 0:ksimax)
   416      real(DP), intent(in   ) :: xy_DSOSeaIceMassDtPhyTop(0:imax-1, 1:jmax)
   417      real(DP), intent(in   ) :: xy_DSOSeaIceMassDtPhyBot(0:imax-1, 1:jmax)
   418  
   419  !!!! Modified by M.Ishiwatari (2016-12-10)
   420  !!!!    real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 1:ksimax)
   421      real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 0:ksimax)
   422  
   423  
   424      ! 作業変数
   425      ! Work variables
   426      !
   427      real(DP) :: xy_SeaIceThickness(0:imax-1, 1:jmax)
   428      integer  :: xy_SOSILocalKMax  (0:imax-1, 1:jmax)
   429      real(DP) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   430  !!!! Modified by M.Ishiwatari (2016-12-10)
   431  !!!!    real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   432      real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   433  
   434      real(DP) :: xy_SOSeaIceMassTent1   (0:imax-1, 1:jmax)
   435      real(DP) :: xy_SeaIceThicknessTent1(0:imax-1, 1:jmax)
   436      integer  :: xy_SOSILocalKMaxTent1  (0:imax-1, 1:jmax)
   437      real(DP) :: xyr_SOSILocalDepthTent1(0:imax-1, 1:jmax, 0:ksimax)
   438  !!!! Modified by M.Ishiwatari (2016-12-10)
   439  !!!!    real(DP) :: xyz_SOSILocalDepthTent1(0:imax-1, 1:jmax, 1:ksimax)
   440      real(DP) :: xyz_SOSILocalDepthTent1(0:imax-1, 1:jmax, 0:ksimax)
   441  
   442      real(DP) :: xy_SOSeaIceMassTent2   (0:imax-1, 1:jmax)
   443      real(DP) :: xy_SeaIceThicknessTent2(0:imax-1, 1:jmax)
   444      integer  :: xy_SOSILocalKMaxTent2  (0:imax-1, 1:jmax)
   445      real(DP) :: xyr_SOSILocalDepthTent2(0:imax-1, 1:jmax, 0:ksimax)
   446  !!!! Modified by M.Ishiwatari (2016-12-10)
   447  !!!!    real(DP) :: xyz_SOSILocalDepthTent2(0:imax-1, 1:jmax, 1:ksimax)
   448      real(DP) :: xyz_SOSILocalDepthTent2(0:imax-1, 1:jmax, 0:ksimax)
   449  
   450      real(DP) :: xyr_SOSILocalDepthT2MapToT1(0:imax-1, 1:jmax, 0:ksimax)
   451  
   452  !!!! Modifiedy by M.Ishiwatari (2016-12-10)
   453  !!!!    real(DP) :: xyz_SOSeaIceTempTent1(0:imax-1, 1:jmax, 1:ksimax)
   454  !!!!    real(DP) :: xyz_SOSeaIceTempTent2(0:imax-1, 1:jmax, 1:ksimax)
   455      real(DP) :: xyz_SOSeaIceTempTent1(0:imax-1, 1:jmax, 0:ksimax)
   456      real(DP) :: xyz_SOSeaIceTempTent2(0:imax-1, 1:jmax, 0:ksimax)
   457  !!$
   458  !!$    real(DP) :: xyz_DSOSeaIceTempDtPhyUpdt(0:imax-1, 1:jmax, 1:ksimax)
   459  
   460      integer:: i               ! 東西方向に回る DO ループ用作業変数
   461                                ! Work variables for DO loop in zonal direction
   462      integer:: j               ! 南北方向に回る DO ループ用作業変数
   463                                ! Work variables for DO loop in meridional direction
   464      integer:: k
   465      integer:: kk
   466      integer:: kTop
   467      integer:: kBot
   468  
   469  
   470      if ( .not. sosi_utils_inited ) then
   471        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   472      end if
   473  
   474  
   475      ! Calculate sea ice mass at next time step
   476      !
   477  
   478      !   Add sea ice mass change at the bottom of sea ice
   479      xy_SOSeaIceMassTent1 = xy_SOSeaIceMass &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t780 = 1, jmax*imax                                            
     .           xy_soseaicemasstent1(t780-1,1) = xy_soseaicemass(t780-1,1) +   
     .       1      xy_dsoseaicemassdtphybot(t780-1,1)*deltime                  
     .           xy_soseaicemasstent2(t780-1,1) = xy_soseaicemasstent1(t780-1,1)
     .       1       + xy_dsoseaicemassdtphytop(t780-1,1)*deltime               
     .        enddo                                                             
   480        & + xy_DSOSeaIceMassDtPhyBot * DelTime
   481  
   482      !   Add sea ice mass change at the top of sea ice
   483      xy_SOSeaIceMassTent2 = xy_SOSeaIceMassTent1 &
   484        & + xy_DSOSeaIceMassDtPhyTop * DelTime
   485  
   486  
   487      ! 海氷温度時間積分
   488      ! Time integration of sea ice temperature
   489      !
   490      xyz_SOSeaIceTempTent1 = xyz_SOSeaIceTemp &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t796 = 1, jmax*(ksimax*imax + imax)                            
     .           xyz_soseaicetemptent1(t796-1,1,0) = xyz_soseaicetemp(t796-1,1,0
     .       1      ) + xyz_dsoseaicetempdtphy(t796-1,1,0)*deltime              
     .        enddo                                                             
   491        & + xyz_DSOSeaIceTempDtPhy * DelTime
   492  
   493  
   494      !
   495      ! Adjust temperature
   496      !
   497  
   498      !
   499      !   Calcuate sea ice thickness
   500      !
   501      xy_SeaIceThickness = xy_SOSeaIceMass / SeaIceDen
     .        d1 = 1.D0/seaiceden                                               
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t811 = 1, jmax*imax                                            
     .           xy_seaicethickness(t811-1,1) = xy_soseaicemass(t811-1,1)*d1    
     .        enddo                                                             
   502      !
   503      !   Set slab ocean sea ice levels
   504      !
   505      call SOSIUtilsSetSOSeaIceLevels(                              &
   506        & xy_SeaIceThickness,                                       & ! (in )
   507        & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   508        & )
   509  
   510      !
   511      !   Calcuate sea ice thickness
   512      !
   513      xy_SeaIceThicknessTent1 = xy_SOSeaIceMassTent1 / SeaIceDen
     .        d2 = 1.D0/seaiceden                                               
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t819 = 1, xy_soseaicemasstent1.DSC.U2*                         
     .       1   xy_soseaicemasstent1.DSC.U1 + xy_soseaicemasstent1.DSC.U2      
     .           xy_seaicethicknesstent1(t819-1,1) = xy_soseaicemasstent1(t819-1
     .       1      ,1)*d2                                                      
     .        enddo                                                             
   514      !
   515      !   Set slab ocean sea ice levels
   516      !
   517      call SOSIUtilsSetSOSeaIceLevels(                     &
   518        & xy_SeaIceThicknessTent1,                                       & ! (in   )
   519        & xy_SOSILocalKMaxTent1, xyr_SOSILocalDepthTent1, xyz_SOSILocalDepthTent1  & ! (out)
   520        & )
   521  
   522      !   Adjust levels
   523      !
   524      do j = 1, jmax
   525        do i = 0, imax-1
   526          if ( xy_SOSILocalKMaxTent1(i,j) > xy_SOSILocalKMax(i,j) ) then
   527            ! sea ice thickness increases
   528            if ( xy_SOSILocalKMax(i,j) == 0 ) then
   529              do k = 1, xy_SOSILocalKMaxTent1(i,j)
   530                xyz_SOSeaIceTempTent1(i,j,k) = TempBelowSeaIce
   531              end do
   532            else
   533  !!$            do k = 1, xy_SOSILocalKMaxB(i,j)
   534  !!$              ! Do nothing
   535  !!$            end do
   536              do k = xy_SOSILocalKMax(i,j)+1, xy_SOSILocalKMaxTent1(i,j)
     .  !cdir    nodep                                                          
     .        do %00015a = 1, 1 + xy_sosilocalkmaxtent1(i,j) - xy_sosilocalkmax(
     .       1   i,j) - min0(1,xy_sosilocalkmaxtent1(i,j)-xy_sosilocalkmax(i,j))
   537                kk = xy_SOSILocalKMax(i,j)
   538                xyz_SOSeaIceTempTent1(i,j,k) = xyz_SOSeaIceTempTent1(i,j,kk)
   539              end do
   540            end if
   541          else if ( xy_SOSILocalKMaxTent1(i,j) < xy_SOSILocalKMax(i,j) ) then
   542            ! sea ice thickness decreases
   543            !   Do nothing
   544            !   Melted sea ice had freezing temperature
   545          end if
   546        end do
   547      end do
   548  
   549  
   550  
   551      !
   552      !   Calcuate sea ice thickness
   553      !
   554      xy_SeaIceThicknessTent2 = xy_SOSeaIceMassTent2 / SeaIceDen
     .           d3 = 1.D0/seaiceden                                            
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t827 = 1, xy_soseaicemasstent2.DSC.U2*                         
     .       1   xy_soseaicemasstent2.DSC.U1 + xy_soseaicemasstent2.DSC.U2      
     .           xy_seaicethicknesstent2(t827-1,1) = xy_soseaicemasstent2(t827-1
     .       1      ,1)*d3                                                      
     .        enddo                                                             
   555      !
   556      !   Set slab ocean sea ice levels
   557      !
   558      call SOSIUtilsSetSOSeaIceLevels(                     &
   559        & xy_SeaIceThicknessTent2,                                       & ! (in   )
   560        & xy_SOSILocalKMaxTent2, xyr_SOSILocalDepthTent2, xyz_SOSILocalDepthTent2  & ! (out)
   561        & )
   562  
   563      !   Adjust levels
   564      !
   565      do j = 1, jmax
   566        do i = 0, imax-1
   567          if ( xy_SOSILocalKMaxTent2(i,j) == 0 ) then
   568            do k = 0, ksimax
   569              xyr_SOSILocalDepthT2MapToT1(i,j,k) = 0.0_DP
   570            end do
   571          else
   572            do k = 0, xy_SOSILocalKMaxTent2(i,j)
   573              xyr_SOSILocalDepthT2MapToT1(i,j,k) = &
   574                &   xyr_SOSILocalDepthTent2(i,j,k) &
   575                & - ( xy_SeaIceThicknessTent1(i,j) - xy_SeaIceThicknessTent2(i,j) )
   576            end do
   577            do k = xy_SOSILocalKMaxTent2(i,j)+1, ksimax
   578              xyr_SOSILocalDepthT2MapToT1(i,j,k) = 0.0_DP
   579            end do
     .           xy_sosilocalkmaxtent21 = xy_sosilocalkmaxtent2(i,j)            
     .  !cdir nodep                                                             
     .        do k = 1, ksimax - xy_sosilocalkmaxtent2(i,j)                     
     .           xyr_sosilocaldeptht2maptot1(i,j,xy_sosilocalkmaxtent21+k) =    
     .       1      0.0000000000000000e+000                                     
     .        enddo                                                             
   580          end if
   581        end do
   582      end do
   583      !
   584      do j = 1, jmax
   585        do i = 0, imax-1
   586  
   587          if ( xy_SOSILocalKMaxTent2(i,j) == 0 ) then
   588            do k = 1, ksimax
   589              xyz_SOSeaIceTempTent2(i,j,k) = SOSeaIceTempMissingValue
   590            end do
   591          else
   592  
   593            do k = 1, xy_SOSILocalKMaxTent2(i,j)
   594  
   595              search_kTop : do kTop = 1, xy_SOSILocalKMaxTent1(i,j)
   596                if ( xyr_SOSILocalDepthT2MapToT1(i,j,k-1) >= xyr_SOSILocalDepthTent1(i,j,kTop) ) then
   597                  exit search_kTop
   598                end if
   599              end do search_kTop
   600              search_kBot : do kBot = kTop, xy_SOSILocalKMaxTent1(i,j)
   601                if ( xyr_SOSILocalDepthT2MapToT1(i,j,k  ) >= xyr_SOSILocalDepthTent1(i,j,kBot) ) then
   602                  exit search_kBot
   603                end if
   604              end do search_kBot
   605  
   606              if ( kTop == kBot ) then
   607                kk = kTop
   608                xyz_SOSeaIceTempTent2(i,j,k) = &
   609                  & + xyz_SOSeaIceTempTent1(i,j,kk)                &
   610                  &     * (   xyr_SOSILocalDepthT2MapToT1(i,j,k-1) &
   611                  &         - xyr_SOSILocalDepthT2MapToT1(i,j,k  ) )
   612              else
   613                xyz_SOSeaIceTempTent2(i,j,k) = 0.0_DP
   614                kk = kTop
   615                xyz_SOSeaIceTempTent2(i,j,k) = xyz_SOSeaIceTempTent2(i,j,k) &
   616                  & + xyz_SOSeaIceTempTent1(i,j,kk)                      &
   617                  &     * (   xyr_SOSILocalDepthT2MapToT1(i,j,k-1) &
   618                  &         - xyr_SOSILocalDepthTent1(i,j,kk) )
   619                do kk = kTop+1, kBot-1
   620                  xyz_SOSeaIceTempTent2(i,j,k) = xyz_SOSeaIceTempTent2(i,j,k) &
   621                    & + xyz_SOSeaIceTempTent1(i,j,kk)                      &
   622                    &     * (   xyr_SOSILocalDepthTent1(i,j,kk-1)          &
   623                    &         - xyr_SOSILocalDepthTent1(i,j,kk  ) )
   624                end do
     .           if (kbot - ktop - 1 .gt. 0) then                               
     .           xyz_soseaicetemptent24 = xyz_soseaicetemptent2(i,j,k)          
     .  !cdir    nodep                                                          
     .           do kk = 1, kbot - ktop - 1                                     
     .              xyz_soseaicetemptent24 = xyz_soseaicetemptent24 +           
     .       1         xyz_soseaicetemptent1(i,j,ktop+kk)*(                     
     .       2         xyr_sosilocaldepthtent1(i,j,ktop+kk-1)-                  
     .       3         xyr_sosilocaldepthtent1(i,j,ktop+kk))                    
     .           enddo                                                          
     .           xyz_soseaicetemptent2(i,j,k) = xyz_soseaicetemptent24          
     .        endif                                                             
   625                kk = kBot
   626                xyz_SOSeaIceTempTent2(i,j,k) = xyz_SOSeaIceTempTent2(i,j,k) &
   627                  & + xyz_SOSeaIceTempTent1(i,j,kk)                      &
   628                  &     * (   xyr_SOSILocalDepthTent1(i,j,kk-1)          &
   629                  &         - xyr_SOSILocalDepthT2MapToT1(i,j,k) )
   630              end if
   631              !
   632              xyz_SOSeaIceTempTent2(i,j,k) = &
   633                & xyz_SOSeaIceTempTent2(i,j,k) &
   634                & / ( xyr_SOSILocalDepthTent2(i,j,k-1) - xyr_SOSILocalDepthTent2(i,j,k) )
   635  
   636            end do
   637            do k = xy_SOSILocalKMaxTent2(i,j)+1, ksimax
   638              xyz_SOSeaIceTempTent2(i,j,k) = SOSeaIceTempMissingValue
   639            end do
     .        xy_sosilocalkmaxtent22 = xy_sosilocalkmaxtent2(i,j)               
     .  !cdir nodep                                                             
     .        do k = 1, ksimax - xy_sosilocalkmaxtent2(i,j)                     
     .           xyz_soseaicetemptent2(i,j,xy_sosilocalkmaxtent22+k) =          
     .       1      -9.99990000000000e+004                                      
     .        enddo                                                             
   640  
   641          end if
   642  
   643        end do
   644      end do
   645  
   646  
   647      ! Update sea ice temperature
   648      !
   649      xyz_SOSeaIceTemp = xyz_SOSeaIceTempTent2
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t835 = 1, jmax*(ksimax*imax + imax)                            
     .           xyz_soseaicetemp(t835-1,1,0)=xyz_soseaicetemptent2(t835-1,1,0) 
     .        enddo                                                             
   650  
   651      ! Update sea ice mass
   652      !
   653      xy_SOSeaIceMass = xy_SOSeaIceMassTent2
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t847 = 1, jmax*imax                                            
     .           xy_soseaicemass(t847-1,1) = xy_soseaicemasstent2(t847-1,1)     
     .        enddo                                                             
   654  
   655  
   656      ! Check sea ice mass
   657      !
   658      do j = 1, jmax
   659        do i = 0, imax-1
   660          if ( xy_SOSeaIceMass(i,j) < 0 ) then
   661            if ( xy_SOSeaIceMass(i,j) < SOSeaIceMassNegativeThreshold ) then
   662              call MessageNotify( 'M', module_name, &
   663                & '  Slab sea ice mass is negative after physics, %f, and this is set to zero.', &
   664                & d = (/ xy_SOSeaIceMass(i,j) /) )
   665            end if
   666            xy_SOSeaIceMass(i,j) = 0.0_DP
   667          end if
   668        end do
   669      end do
   670  
   671  
   672      ! Check
   673      !
   674      xy_SeaIceThickness = xy_SOSeaIceMass / SeaIceDen
     .        d5 = 1.D0/seaiceden                                               
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t855 = 1, jmax*imax                                            
     .           xy_seaicethickness(t855-1,1) = xy_soseaicemass(t855-1,1)*d5    
     .        enddo                                                             
   675      !
   676      call SOSIUtilsChkSOSeaIce(          &
   677        & xy_SeaIceThickness, xyz_SOSeaIceTemp, & ! (in)
   678        & "SOSIUtilsAddPhysics"               & ! (in)
   679        & )
   680  
   681  
   682    end subroutine SOSIUtilsAddPhysics
   683  
   684    !--------------------------------------------------------------------------------------
   685  
   686  !!$  subroutine BK_SOSIUtilsAddPhysics(                         &
   687  !!$    & xy_SOSeaIceMassB,                                   & !(in )
   688  !!$    & xy_DSOSeaIceMassDtPhyTop, xy_DSOSeaIceMassDtPhyBot, & !(in )
   689  !!$    & xy_SOSeaIceMassA,                                   & !(out)
   690  !!$    & xyz_SOSeaIceTemp,                                   & !(inout)
   691  !!$    & xyz_DSOSeaIceTempDtPhy                              & !(in   )
   692  !!$    & )
   693  !!$    !
   694  !!$    ! Calculates slab sea ice horizontal transports by diffusion
   695  !!$
   696  !!$    ! ヒストリデータ出力
   697  !!$    ! History data output
   698  !!$    !
   699  !!$    use gtool_historyauto, only: HistoryAutoPut
   700  !!$
   701  !!$    use timeset    , only : &
   702  !!$      & TimeN, &
   703  !!$      & DelTime
   704  !!$                              ! $\Delta t$
   705  !!$
   706  !!$    ! 雪と海氷の定数の設定
   707  !!$    ! Setting constants of snow and sea ice
   708  !!$    !
   709  !!$    use constants_snowseaice, only: &
   710  !!$      & TempBelowSeaIce, &
   711  !!$      & SeaIceDen
   712  !!$
   713  !!$
   714  !!$    ! 宣言文 ; Declaration statements
   715  !!$    !
   716  !!$    real(DP), intent(in ) :: xy_SOSeaIceMassB    (0:imax-1, 1:jmax)
   717  !!$                              ! $ M_si (t-1) $ . 海氷質量 (kg m-2)
   718  !!$                              ! Slab ocean sea ice mass (kg m-2)
   719  !!$    real(DP), intent(in ) :: xy_DSOSeaIceMassDtPhyTop(0:imax-1, 1:jmax)
   720  !!$    real(DP), intent(in ) :: xy_DSOSeaIceMassDtPhyBot(0:imax-1, 1:jmax)
   721  !!$
   722  !!$    real(DP), intent(out) :: xy_SOSeaIceMassA(0:imax-1, 1:jmax)
   723  !!$                              !
   724  !!$                              ! Slab sea ice mass at next time step
   725  !!$    real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
   726  !!$    real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 1:ksimax)
   727  !!$
   728  !!$
   729  !!$    ! 作業変数
   730  !!$    ! Work variables
   731  !!$    !
   732  !!$    real(DP) :: xy_SeaIceThicknessB(0:imax-1, 1:jmax)
   733  !!$    integer  :: xy_SOSILocalKMaxB  (0:imax-1, 1:jmax)
   734  !!$    real(DP) :: xyr_SOSILocalDepthB(0:imax-1, 1:jmax, 0:ksimax)
   735  !!$    real(DP) :: xyz_SOSILocalDepthB(0:imax-1, 1:jmax, 1:ksimax)
   736  !!$
   737  !!$    real(DP) :: xy_SOSeaIceMassA1(0:imax-1, 1:jmax)
   738  !!$    real(DP) :: xy_SeaIceThicknessA1(0:imax-1, 1:jmax)
   739  !!$    integer  :: xy_SOSILocalKMaxA1  (0:imax-1, 1:jmax)
   740  !!$    real(DP) :: xyr_SOSILocalDepthA1(0:imax-1, 1:jmax, 0:ksimax)
   741  !!$    real(DP) :: xyz_SOSILocalDepthA1(0:imax-1, 1:jmax, 1:ksimax)
   742  !!$
   743  !!$    real(DP) :: xy_SOSeaIceMassA2(0:imax-1, 1:jmax)
   744  !!$    real(DP) :: xy_SeaIceThicknessA2(0:imax-1, 1:jmax)
   745  !!$    integer  :: xy_SOSILocalKMaxA2  (0:imax-1, 1:jmax)
   746  !!$    real(DP) :: xyr_SOSILocalDepthA2(0:imax-1, 1:jmax, 0:ksimax)
   747  !!$    real(DP) :: xyz_SOSILocalDepthA2(0:imax-1, 1:jmax, 1:ksimax)
   748  !!$
   749  !!$    real(DP) :: xyr_SOSILocalDepthA2MappedToA1(0:imax-1, 1:jmax, 0:ksimax)
   750  !!$
   751  !!$    real(DP) :: xyz_SOSeaIceTempA1(0:imax-1, 1:jmax, 1:ksimax)
   752  !!$    real(DP) :: xyz_SOSeaIceTempA2(0:imax-1, 1:jmax, 1:ksimax)
   753  !!$
   754  !!$    real(DP) :: xyz_DSOSeaIceTempDtPhyUpdt(0:imax-1, 1:jmax, 1:ksimax)
   755  !!$
   756  !!$    integer:: i               ! 東西方向に回る DO ループ用作業変数
   757  !!$                              ! Work variables for DO loop in zonal direction
   758  !!$    integer:: j               ! 南北方向に回る DO ループ用作業変数
   759  !!$                              ! Work variables for DO loop in meridional direction
   760  !!$    integer:: k
   761  !!$    integer:: kk
   762  !!$    integer:: kTop
   763  !!$    integer:: kBot
   764  !!$
   765  !!$
   766  !!$    if ( .not. sosi_utils_inited ) then
   767  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   768  !!$    end if
   769  !!$
   770  !!$
   771  !!$    ! Calculate sea ice mass at next time step
   772  !!$    !
   773  !!$
   774  !!$    !   Add sea ice mass change at the bottom of sea ice
   775  !!$    xy_SOSeaIceMassA1 = xy_SOSeaIceMassB &
   776  !!$      & + xy_DSOSeaIceMassDtPhyBot * ( 2.0_DP * DelTime )
   777  !!$
   778  !!$    !   Add sea ice mass change at the top of sea ice
   779  !!$    xy_SOSeaIceMassA2 = xy_SOSeaIceMassA1 &
   780  !!$      & + xy_DSOSeaIceMassDtPhyTop * ( 2.0_DP * DelTime )
   781  !!$
   782  !!$    !   Update sea ice mass
   783  !!$    xy_SOSeaIceMassA = xy_SOSeaIceMassA2
   784  !!$
   785  !!$
   786  !!$    ! Check sea ice mass
   787  !!$    !
   788  !!$    do j = 1, jmax
   789  !!$      do i = 0, imax-1
   790  !!$        if ( xy_SOSeaIceMassA(i,j) < 0 ) then
   791  !!$          if ( xy_SOSeaIceMassA(i,j) < SOSeaIceMassNegativeThreshold ) then
   792  !!$            call MessageNotify( 'M', module_name, &
   793  !!$              & '  Slab sea ice mass is negative after physics, %f, and this is set to zero.', &
   794  !!$              & d = (/ xy_SOSeaIceMassA(i,j) /) )
   795  !!$          end if
   796  !!$          xy_SOSeaIceMassA(i,j) = 0.0_DP
   797  !!$        end if
   798  !!$      end do
   799  !!$    end do
   800  !!$
   801  !!$
   802  !!$    ! 海氷温度時間積分
   803  !!$    ! Time integration of sea ice temperature
   804  !!$    !
   805  !!$    xyz_SOSeaIceTemp = xyz_SOSeaIceTemp &
   806  !!$      & + xyz_DSOSeaIceTempDtPhy * DelTime
   807  !!$
   808  !!$    !
   809  !!$    ! Calcuate sea ice thickness
   810  !!$    !
   811  !!$
   812  !!$    !
   813  !!$    !   Calcuate sea ice thickness
   814  !!$    !
   815  !!$    xy_SeaIceThicknessB = xy_SOSeaIceMassB / SeaIceDen
   816  !!$    !
   817  !!$    !   Set slab ocean sea ice levels
   818  !!$    !
   819  !!$    call SOSIUtilsSetSOSeaIceLevels(                                 &
   820  !!$      & xy_SeaIceThicknessB,                                         & ! (in )
   821  !!$      & xy_SOSILocalKMaxB, xyr_SOSILocalDepthB, xyz_SOSILocalDepthB  & ! (out)
   822  !!$      & )
   823  !!$
   824  !!$    !
   825  !!$    !   Calcuate sea ice thickness
   826  !!$    !
   827  !!$    xy_SeaIceThicknessA1 = xy_SOSeaIceMassA1 / SeaIceDen
   828  !!$    !
   829  !!$    !   Set slab ocean sea ice levels
   830  !!$    !
   831  !!$    call SOSIUtilsSetSOSeaIceLevels(                     &
   832  !!$      & xy_SeaIceThicknessA1,                                       & ! (in   )
   833  !!$      & xy_SOSILocalKMaxA1, xyr_SOSILocalDepthA1, xyz_SOSILocalDepthA1  & ! (out)
   834  !!$      & )
   835  !!$
   836  !!$    !   Adjust levels
   837  !!$    !
   838  !!$    do j = 1, jmax
   839  !!$      do i = 0, imax-1
   840  !!$        if ( xy_SOSILocalKMaxA1(i,j) > xy_SOSILocalKMaxB(i,j) ) then
   841  !!$          ! sea ice thickness increases
   842  !!$          if ( xy_SOSILocalKMaxB(i,j) == 0 ) then
   843  !!$            do k = 1, xy_SOSILocalKMaxA1(i,j)
   844  !!$              xyz_SOSeaIceTempA1(i,j,k) = TempBelowSeaIce
   845  !!$            end do
   846  !!$          else
   847  !!$!            do k = 1, xy_SOSILocalKMaxB(i,j)
   848  !!$!              ! Do nothing
   849  !!$!            end do
   850  !!$            do k = xy_SOSILocalKMaxB(i,j)+1, xy_SOSILocalKMaxA1(i,j)
   851  !!$              kk = xy_SOSILocalKMaxB(i,j)
   852  !!$              xyz_SOSeaIceTempA1(i,j,k) = xyz_SOSeaIceTempA1(i,j,kk)
   853  !!$            end do
   854  !!$          end if
   855  !!$        else if ( xy_SOSILocalKMaxA1(i,j) < xy_SOSILocalKMaxB(i,j) ) then
   856  !!$          ! sea ice thickness decreases
   857  !!$          !   Do nothing
   858  !!$          !   Melted sea ice had freezing temperature
   859  !!$        end if
   860  !!$      end do
   861  !!$    end do
   862  !!$
   863  !!$
   864  !!$
   865  !!$    !
   866  !!$    !   Calcuate sea ice thickness
   867  !!$    !
   868  !!$    xy_SeaIceThicknessA2 = xy_SOSeaIceMassA2 / SeaIceDen
   869  !!$    !
   870  !!$    !   Set slab ocean sea ice levels
   871  !!$    !
   872  !!$    call SOSIUtilsSetSOSeaIceLevels(                     &
   873  !!$      & xy_SeaIceThicknessA2,                                       & ! (in   )
   874  !!$      & xy_SOSILocalKMaxA2, xyr_SOSILocalDepthA2, xyz_SOSILocalDepthA2  & ! (out)
   875  !!$      & )
   876  !!$
   877  !!$    !   Adjust levels
   878  !!$    !
   879  !!$    do j = 1, jmax
   880  !!$      do i = 0, imax-1
   881  !!$        if ( xy_SOSILocalKMaxA2(i,j) == 0 ) then
   882  !!$          do k = 0, ksimax
   883  !!$            xyr_SOSILocalDepthA2MappedToA1(i,j,k) = 0.0_DP
   884  !!$          end do
   885  !!$        else
   886  !!$          do k = 0, xy_SOSILocalKMaxA2(i,j)
   887  !!$            xyr_SOSILocalDepthA2MappedToA1(i,j,k) = &
   888  !!$              &   xyr_SOSILocalDepthA2(i,j,k) &
   889  !!$              & - ( xy_SeaIceThicknessA1(i,j) - xy_SeaIceThicknessA2(i,j) )
   890  !!$          end do
   891  !!$          do k = xy_SOSILocalKMaxA2(i,j)+1, ksimax
   892  !!$            xyr_SOSILocalDepthA2MappedToA1(i,j,k) = 0.0_DP
   893  !!$          end do
   894  !!$        end if
   895  !!$      end do
   896  !!$    end do
   897  !!$    !
   898  !!$    do j = 1, jmax
   899  !!$      do i = 0, imax-1
   900  !!$
   901  !!$        if ( xy_SOSILocalKMaxA2(i,j) == 0 ) then
   902  !!$          do k = 1, ksimax
   903  !!$            xyz_SOSeaIceTempA2(i,j,k) = SOSeaIceTempMissingValue
   904  !!$          end do
   905  !!$        else
   906  !!$
   907  !!$          do k = 1, xy_SOSILocalKMaxA2(i,j)
   908  !!$
   909  !!$            search_kTop : do kTop = 1, xy_SOSILocalKMaxA1(i,j)
   910  !!$              if ( xyr_SOSILocalDepthA2MappedToA1(i,j,k-1) >= xyr_SOSILocalDepthA1(i,j,kTop) ) then
   911  !!$                exit search_kTop
   912  !!$              end if
   913  !!$            end do search_kTop
   914  !!$            search_kBot : do kBot = kTop, xy_SOSILocalKMaxA1(i,j)
   915  !!$              if ( xyr_SOSILocalDepthA2MappedToA1(i,j,k  ) >= xyr_SOSILocalDepthA1(i,j,kBot) ) then
   916  !!$                exit search_kBot
   917  !!$              end if
   918  !!$            end do search_kBot
   919  !!$
   920  !!$            if ( kTop == kBot ) then
   921  !!$              kk = kTop
   922  !!$              xyz_SOSeaIceTempA2(i,j,k) = &
   923  !!$                & + xyz_SOSeaIceTempA1(i,j,kk)                      &
   924  !!$                &     * (   xyr_SOSILocalDepthA2MappedToA1(i,j,k-1) &
   925  !!$                &         - xyr_SOSILocalDepthA2MappedToA1(i,j,k  ) )
   926  !!$            else
   927  !!$              xyz_SOSeaIceTempA2(i,j,k) = 0.0_DP
   928  !!$              kk = kTop
   929  !!$              xyz_SOSeaIceTempA2(i,j,k) = xyz_SOSeaIceTempA2(i,j,k) &
   930  !!$                & + xyz_SOSeaIceTempA1(i,j,kk)                      &
   931  !!$                &     * (   xyr_SOSILocalDepthA2MappedToA1(i,j,k-1) &
   932  !!$                &         - xyr_SOSILocalDepthA1(i,j,kk) )
   933  !!$              do kk = kTop+1, kBot-1
   934  !!$                xyz_SOSeaIceTempA2(i,j,k) = xyz_SOSeaIceTempA2(i,j,k) &
   935  !!$                  & + xyz_SOSeaIceTempA1(i,j,kk)                      &
   936  !!$                  &     * (   xyr_SOSILocalDepthA1(i,j,kk-1)          &
   937  !!$                  &         - xyr_SOSILocalDepthA1(i,j,kk  ) )
   938  !!$              end do
   939  !!$              kk = kBot
   940  !!$              xyz_SOSeaIceTempA2(i,j,k) = xyz_SOSeaIceTempA2(i,j,k) &
   941  !!$                & + xyz_SOSeaIceTempA1(i,j,kk)                      &
   942  !!$                &     * (   xyr_SOSILocalDepthA1(i,j,kk-1)          &
   943  !!$                &         - xyr_SOSILocalDepthA2MappedToA1(i,j,k) )
   944  !!$            end if
   945  !!$            !
   946  !!$            xyz_SOSeaIceTempA2(i,j,k) = &
   947  !!$              & xyz_SOSeaIceTempA2(i,j,k) &
   948  !!$              & / ( xyr_SOSILocalDepthA2(i,j,k-1) - xyr_SOSILocalDepthA2(i,j,k) )
   949  !!$
   950  !!$          end do
   951  !!$          do k = xy_SOSILocalKMaxA2(i,j)+1, ksimax
   952  !!$            xyz_SOSeaIceTempA2(i,j,k) = SOSeaIceTempMissingValue
   953  !!$          end do
   954  !!$
   955  !!$        end if
   956  !!$
   957  !!$      end do
   958  !!$    end do
   959  !!$
   960  !!$
   961  !!$    !   Calculation of updated tendency
   962  !!$    !
   963  !!$!    do j = 1, jmax
   964  !!$!      do i = 0, imax-1
   965  !!$!    xyz_DSOSeaIceTempDtPhyUpdt = &
   966  !!$!      & ( xyz_SOSeaIceTempA2 - xyz_SOSeaIceTemp ) / ( 2.0_DP * DelTime )
   967  !!$
   968  !!$
   969  !!$    ! Update sea ice temperature
   970  !!$    !
   971  !!$    xyz_SOSeaIceTemp = xyz_SOSeaIceTemp + xyz_DSOSeaIceTempDtPhyUpdt * DelTime
   972  !!$
   973  !!$
   974  !!$
   975  !!$  end subroutine BK_SOSIUtilsAddPhysics
   976  
   977    !--------------------------------------------------------------------------------------
   978  
   979    subroutine SOSIUtilsInit
   980  
   981      !
   982      ! sosi_utils モジュールの初期化を行います.
   983      ! NAMELIST#sosi_utils_nml の読み込みはこの手続きで行われます.
   984      !
   985      ! "sosi_utils" module is initialized.
   986      ! "NAMELIST#sosi_utils_nml" is loaded in this procedure.
   987      !
   988  
   989      ! モジュール引用 ; USE statements
   990      !
   991  
   992      ! NAMELIST ファイル入力に関するユーティリティ
   993      ! Utilities for NAMELIST file input
   994      !
   995      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   996  
   997      ! ファイル入出力補助
   998      ! File I/O support
   999      !
  1000      use dc_iounit, only: FileOpen
  1001  
  1002      ! 種別型パラメタ
  1003      ! Kind type parameter
  1004      !
  1005      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1006  
  1007      ! 文字列操作
  1008      ! Character handling
  1009      !
  1010      use dc_string, only: StoA
  1011  
  1012  
  1013      ! 宣言文 ; Declaration statements
  1014      !
  1015  
  1016  
  1017  
  1018      ! 作業変数
  1019      ! Work variables
  1020      !
  1021      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1022                                ! Unit number for NAMELIST file open
  1023      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1024                                ! IOSTAT of NAMELIST read
  1025  
  1026      ! NAMELIST 変数群
  1027      ! NAMELIST group name
  1028      !
  1029      namelist /sosi_utils_nml/ &
  1030        & SOSeaIceMassNegativeThreshold
  1031  !!$      & SOMass,         &          ! Slab ocean heat capacity (J m-2 K-1)
  1032  !!$      & NumMaxItr,      &          ! Number of interation
  1033  !!$      & TempItrCrit,    &
  1034  !!$      & FlagSublimation
  1035            !
  1036            ! デフォルト値については初期化手続 "sosi_utils#SOSOUtilsInit"
  1037            ! のソースコードを参照のこと.
  1038            !
  1039            ! Refer to source codes in the initialization procedure
  1040            ! "sosi_utils#SOSIUtilsInit" for the default values.
  1041            !
  1042  
  1043      ! 実行文 ; Executable statement
  1044      !
  1045  
  1046      if ( sosi_utils_inited ) return
  1047  
  1048  
  1049      ! デフォルト値の設定
  1050      ! Default values settings
  1051      !
  1052      SOSeaIceMassNegativeThreshold = -1.0e-10_DP
  1053  
  1054  
  1055      ! NAMELIST の読み込み
  1056      ! NAMELIST is input
  1057      !
  1058      if ( trim(namelist_filename) /= '' ) then
  1059        call FileOpen( unit_nml, &          ! (out)
  1060          & namelist_filename, mode = 'r' ) ! (in)
  1061  
  1062        rewind( unit_nml )
  1063        read( unit_nml,                    &  ! (in)
  1064          & nml = sosi_utils_nml,          &  ! (out)
  1065          & iostat = iostat_nml )             ! (out)
  1066        close( unit_nml )
  1067  
  1068        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1069      end if
  1070  
  1071  
  1072  
  1073      ! Initialization of modules used in this model
  1074      !
  1075  
  1076  
  1077      ! 印字 ; Print
  1078      !
  1079      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1080      call MessageNotify( 'M', module_name, '  SOSeaIceMassNegativeThreshold = %f', &
  1081        & d = (/ SOSeaIceMassNegativeThreshold /) )
  1082  !!$    call MessageNotify( 'M', module_name, '  SOMass          = %f', d = (/ SOMass /) )
  1083  !!$    call MessageNotify( 'M', module_name, '  SOHeatCapacity  = %f', d = (/ SOHeatCapacity /) )
  1084  !!$    call MessageNotify( 'M', module_name, '  NumMaxItr       = %d', i = (/ NumMaxItr /) )
  1085  !!$    call MessageNotify( 'M', module_name, '  TempItrCrit     = %f', d = (/ TempItrCrit /) )
  1086  !!$    call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
  1087      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1088  
  1089  
  1090      sosi_utils_inited = .true.
  1091  
  1092    end subroutine SOSIUtilsInit
  1093  
  1094    !--------------------------------------------------------------------------------------
  1095  
  1096  end module sosi_utils
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:19 2016
FILE NAME: sosi_utils.f90
PROGRAM NAME: sosi_utils
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Slab ocean sea ice utility module
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: phy_implicit_sdh_V3.f90,v 1.1 2015/01/29 12:05:01 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module sosi_utils
    13:               !
    14:               != 
    15:               !
    16:               != Slab ocean sea ice utility module
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               !
    22:             !!$  ! PhyImplSDHTendency              :: 時間変化率の計算
    23:             !!$  ! PhyImplSDHSetMethodFromMatthews :: SurfType から計算法インデクスの作成
    24:             !!$  ! PhyImplSDHInit                  :: 初期化
    25:             !!$  ! ------------------------------- :: ------------
    26:             !!$  ! PhyImplSDHTendency              :: Calculate tendency
    27:             !!$  ! PhyImplSDHSetMethodFromMatthews :: Set index for calculation method
    28:             !!$  ! PhyImplSDHInit                  :: Initialization
    29:               !
    30:               !--
    31:               !== NAMELIST
    32:               !
    33:               ! NAMELIST#sosi_utils_nml
    34:               !++
    35:             
    36:               ! モジュール引用 ; USE statements
    37:               !
    38:             
    39:               ! 格子点設定
    40:               ! Grid points settings
    41:               !
    42:               use gridset, only:   imax, & ! 経度格子点数. 
    43:                                            ! Number of grid points in longitude
    44:                 &                  jmax, & ! 緯度格子点数. 
    45:                                            ! Number of grid points in latitude
    46:                 &                  kmax, & ! 鉛直層数. 
    47:                                            ! Number of vertical level
    48:                 &                  kslmax, & ! 地下の鉛直層数. 
    49:                                            ! Number of subsurface vertical level
    50:                 &                  ksimax  ! 海氷の鉛直層数. 
    51:                                            ! Number of sea ice vertical level
    52:             
    53:               ! 種別型パラメタ
    54:               ! Kind type parameter
    55:               !
    56:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    57:                 &                 STRING     ! 文字列.       Strings. 
    58:             
    59:               ! メッセージ出力
    60:               ! Message output
    61:               !
    62:               use dc_message, only: MessageNotify
    63:             
    64:               ! 宣言文 ; Declaration statements
    65:               !
    66:               implicit none
    67:               private
    68:             
    69:               real(DP), parameter :: SIDepthMergin = 1.0e-3_DP
    70:                                            ! Mergin for sea ice depth
    71:                                            ! This is used to avoid very thin sea ice layer.
    72:             
    73:               ! 公開手続き
    74:               ! Public procedure
    75:               !
    76:               public :: SOSIUtilsChkSOSeaIce
    77:               public :: SOSIUtilsSetSOSeaIceLevels
    78:               public :: SOSIUtilsSetMissingValue
    79:               public :: SOSIUtilsAddPhysics
    80:               public :: SOSIUtilsInit
    81:             
    82:             
    83:               ! 公開変数
    84:               ! Public variables
    85:               !
    86:               real(DP), parameter, public :: SOSeaIceTempMissingValue = -99999.0_DP
    87:             
    88:             
    89:               real(DP), save, public :: SOSeaIceMassNegativeThreshold
    90:             
    91:             
    92:               logical, save :: sosi_utils_inited = .false.
    93:                                           ! 初期設定フラグ. 
    94:                                           ! Initialization flag
    95:             
    96:               character(*), parameter:: module_name = 'sosi_utils'
    97:                                           ! モジュールの名称. 
    98:                                           ! Module name
    99:               character(*), parameter:: version = &
   100:                 & '$Name:  $' // &
   101:                 & '$Id: phy_implicit_sdh_V3.f90,v 1.1 2015/01/29 12:05:01 yot Exp $'
   102:                                           ! モジュールのバージョン
   103:                                           ! Module version
   104:             
   105:             contains
   106:             
   107:               !--------------------------------------------------------------------------------------
   108:             
   109:               subroutine SOSIUtilsChkSOSeaIce(          &
   110:                 & xy_SeaIceThickness, xyz_SOSeaIceTemp, & ! (in)
   111:                 & ParentRoutine                         & ! (in)
   112:                 & )
   113:                 !
   114:                 !
   115:                 !
   116:                 ! Set index for calculation method from Matthews' index
   117:                 !
   118:             
   119:                 ! モジュール引用 ; USE statements
   120:                 !
   121:             
   122:                 ! 宣言文 ; Declaration statements
   123:                 !
   124:                 real(DP), intent(in ) :: xy_SeaIceThickness(0:imax-1, 1:jmax)
   125:             !!!! Modified by M.Ishiwatari (2016-12-10)
   126:             !!!!    real(DP), intent(in ) :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 1:ksimax)
   127:                 real(DP), intent(in ) :: xyz_SOSeaIceTemp  (0:imax-1, 1:jmax, 0:ksimax)
   128:                 character(*), intent(in ), optional :: ParentRoutine
   129:             
   130:             
   131:                 ! 作業変数
   132:                 ! Work variables
   133:                 !
   134:                 integer  :: xy_SOSILocalKMax(0:imax-1, 1:jmax)
   135:                 real(DP) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   136:             !!!! Modified by M.Ishiwatari (2016-12-10)
   137:             !!!!    real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   138:                 real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   139:             
   140:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   141:                                           ! Work variables for DO loop in longitude
   142:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   143:                                           ! Work variables for DO loop in latitude
   144:                 integer:: k
   145:             
   146:             
   147:                 ! 実行文 ; Executable statement
   148:                 !
   149:             
   150:                 ! 初期化確認
   151:                 ! Initialization check
   152:                 !
   153:                 if ( .not. sosi_utils_inited ) then
   154:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   155:                 end if
   156:             
   157:             
   158:                 call SOSIUtilsSetSOSeaIceLevels(                     &
   159:                 & xy_SeaIceThickness,                                       & ! (in   )
   160:                 & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   161:                 & )
   162:             
   163:             
   164: +------>        do i = 0, imax-1
   165: |+----->          do j = 1, jmax
   166: ||+---->            do k = 1, xy_SOSILocalKMax(i,j)
   167: |||                   if ( xyz_SOSeaIceTemp(i,j,k) < 0.0_DP ) then
   168: |||                     if ( present( ParentRoutine ) ) then
   169: |||                       call MessageNotify( 'M', module_name, &
   170: |||                         & 'Called from %c:', &
   171: |||                         & c1 = trim( ParentRoutine ) )
   172: |||                     end if
   173: |||                     call MessageNotify( 'M', module_name, &
   174: |||                       & 'xyz_SOSeaIceTemp(%d,%d,%d) = %f.', &
   175: |||                       & i = (/i,j,k/), d = (/xyz_SOSeaIceTemp(i,j,k)/) )
   176: |||                   end if
   177: ||+----             end do
   178: |+-----           end do
   179: +------         end do
   180:             
   181:             
   182:               end subroutine SOSIUtilsChkSOSeaIce
   183:             
   184:               !--------------------------------------------------------------------------------------
   185:             
   186:               subroutine SOSIUtilsSetSOSeaIceLevels(                     &
   187:                 & xy_SeaIceThickness,                                       & ! (in   )
   188:                 & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   189:                 & )
   190:                 !
   191:                 !
   192:                 !
   193:                 ! Set index for calculation method from Matthews' index
   194:                 !
   195:             
   196:                 ! モジュール引用 ; USE statements
   197:                 !
   198:             
   199:                 ! 座標データ設定
   200:                 ! Axes data settings
   201:                 !
   202:                 use axesset, only: &
   203:                   & r_SIDepth         ! sea ice grid on interface of layer
   204:             
   205:             
   206:                 ! 宣言文 ; Declaration statements
   207:                 !
   208:                 real(DP), intent(in ) :: xy_SeaIceThickness(0:imax-1, 1:jmax)
   209:                                           !
   210:                                           ! Sea ice thickness
   211:                 integer , intent(out) :: xy_SOSILocalKMax  (0:imax-1, 1:jmax)
   212:                 real(DP), intent(out) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   213:             !!!! Modified by M.Ishiwatari (2016-12-10)
   214:             !!!!    real(DP), intent(out) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   215:                 real(DP), intent(out) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   216:             
   217:             
   218:                 ! 作業変数
   219:                 ! Work variables
   220:                 !
   221:             
   222:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   223:                                           ! Work variables for DO loop in longitude
   224:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   225:                                           ! Work variables for DO loop in latitude
   226:                 integer:: k
   227:             
   228:             
   229:                 ! 実行文 ; Executable statement
   230:                 !
   231:             
   232:                 ! 初期化確認
   233:                 ! Initialization check
   234:                 !
   235:                 if ( .not. sosi_utils_inited ) then
   236:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   237:                 end if
   238:             
   239:             
   240: +------>        do i = 0, imax-1
   241: |+----->          do j = 1, jmax
   242: ||                  if ( xy_SeaIceThickness(i,j) == 0.0_DP ) then
   243: ||                    xy_SOSILocalKMax(i,j) = 0
   244: ||                  else if ( - xy_SeaIceThickness(i,j) < r_SIDepth(ksimax) ) then
   245: ||                    xy_SOSILocalKMax(i,j) = ksimax
   246: ||                  else
   247: ||                    xy_SOSILocalKMax(i,j) = 0
   248: ||V---->              search_ksimax : do k = 0+1, ksimax
   249: |||         !!$            if ( - xy_SeaIceThickness(i,j) >= r_SIDepth(k) ) then
   250: |||                     ! This SIDepthMergin avoids very thin lowest layer.
   251: |||     A               if ( - xy_SeaIceThickness(i,j) >= r_SIDepth(k)-SIDepthMergin ) then
   252: |||                         xy_SOSILocalKMax(i,j) = k
   253: |||                       exit search_ksimax
   254: |||                     end if
   255: ||V----               end do search_ksimax
   256: ||                  end if
   257: |+-----           end do
   258: +------         end do
   259: +------>        do j = 1, jmax
   260: |+----->          do i = 0, imax-1
   261: ||V---->            do k = 0, xy_SOSILocalKMax(i,j)-1
   262: |||     A             xyr_SOSILocalDepth(i,j,k) = r_SIDepth(k)
   263: ||V----             end do
   264: ||                  k = xy_SOSILocalKMax(i,j)
   265: ||                  xyr_SOSILocalDepth(i,j,k) = - xy_SeaIceThickness(i,j)
   266: ||V---->            do k = xy_SOSILocalKMax(i,j)+1, ksimax
   267: |||     A             xyr_SOSILocalDepth(i,j,k) = -1.0e100_DP
   268: ||V----             end do
   269: ||                  !
   270: ||V---->            do k = 1, xy_SOSILocalKMax(i,j)
   271: |||     A             xyz_SOSILocalDepth(i,j,k) = &
   272: |||                     & ( xyr_SOSILocalDepth(i,j,k-1) + xyr_SOSILocalDepth(i,j,k) ) / 2.0_DP
   273: ||V----             end do
   274: ||V---->            do k = xy_SOSILocalKMax(i,j)+1, ksimax
   275: |||     A             xyz_SOSILocalDepth(i,j,k) = -1.0e100_DP
   276: ||V----             end do
   277: |+-----           end do
   278: +------         end do
   279:             
   280:             
   281:               end subroutine SOSIUtilsSetSOSeaIceLevels
   282:             
   283:               !--------------------------------------------------------------------------------------
   284:             
   285:               subroutine SOSIUtilsSetMissingValue( &
   286:                 & xy_SOSeaIceMass,                 & !(in )
   287:                 & xyz_SOSeaIceTemp,                & !(inout)
   288:                 & SOSeaIceValue                    & !(in ) optional
   289:                 & )
   290:                 ! 
   291:                 ! Set missing values
   292:             
   293:                 ! 雪と海氷の定数の設定
   294:                 ! Setting constants of snow and sea ice
   295:                 !
   296:                 use constants_snowseaice, only: &
   297:                   & TempBelowSeaIce, &
   298:                   & SeaIceDen
   299:             
   300:             
   301:                 ! 宣言文 ; Declaration statements
   302:                 !
   303:                 real(DP), intent(in ) :: xy_SOSeaIceMass    (0:imax-1, 1:jmax)
   304:                                           ! $ M_si $ . 海氷質量 (kg m-2)
   305:                                           ! Slab ocean sea ice mass (kg m-2)
   306:             !!!! Modified by M.Ishiwatari (2016-12-10)
   307:             !!!!    real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
   308:                 real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 0:ksimax)
   309:                 real(DP), intent(in   ), optional :: SOSeaIceValue
   310:             
   311:             
   312:                 ! 作業変数
   313:                 ! Work variables
   314:                 !
   315:                 real(DP) :: xy_SeaIceThickness(0:imax-1, 1:jmax)
   316:                              !
   317:                              ! Sea ice thickness
   318:                 integer  :: xy_SOSILocalKMax  (0:imax-1, 1:jmax)
   319:                 real(DP) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   320:             !!!! Modified by M.Ishiwatari(2016-12-10)
   321:             !!!!    real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   322:                 real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   323:             
   324:                 real(DP) :: xy_SeaIceThicknessA(0:imax-1, 1:jmax)
   325:                              !
   326:                              ! Sea ice thickness
   327:                 integer  :: xy_SOSILocalKMaxA  (0:imax-1, 1:jmax)
   328:                 real(DP) :: xyr_SOSILocalDepthA(0:imax-1, 1:jmax, 0:ksimax)
   329:             !!!! Modified by M.Ishiwatari (2016-12-10)
   330:             !!!!    real(DP) :: xyz_SOSILocalDepthA(0:imax-1, 1:jmax, 1:ksimax)
   331:                 real(DP) :: xyz_SOSILocalDepthA(0:imax-1, 1:jmax, 0:ksimax)
   332:             
   333:                 real(DP) :: SetValue
   334:             
   335:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   336:                                           ! Work variables for DO loop in zonal direction
   337:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   338:                                           ! Work variables for DO loop in meridional direction
   339:                 integer:: k
   340:             
   341:             
   342:                 if ( .not. sosi_utils_inited ) then
   343:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   344:                 end if
   345:             
   346:             
   347:             
   348:                 !
   349:                 ! Calcuate sea ice thickness
   350:                 !
   351: W*===== A       xy_SeaIceThickness = xy_SOSeaIceMass / SeaIceDen
   352:                 !
   353:                 ! Set slab ocean sea ice levels
   354:                 !
   355:                 call SOSIUtilsSetSOSeaIceLevels(                              &
   356:                   & xy_SeaIceThickness,                                       & ! (in   )
   357:                   & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   358:                   & )
   359:             
   360:             
   361:                 if ( present ( SOSeaIceValue ) ) then
   362:                   SetValue = SOSeaIceValue
   363:                 else
   364:                   SetValue = SOSeaIceTempMissingValue
   365:                 end if
   366:                 ! 
   367:                 ! Set missing values
   368:                 !
   369: +------>        do j = 1, jmax
   370: |+----->          do i = 0, imax-1
   371: ||V---->            do k = xy_SOSILocalKMax(i,j)+1, ksimax
   372: |||     A             xyz_SOSeaIceTemp(i,j,k) = SetValue
   373: ||V----             end do
   374: |+-----           end do
   375: +------         end do
   376:             
   377:             
   378:               end subroutine SOSIUtilsSetMissingValue
   379:             
   380:               !--------------------------------------------------------------------------------------
   381:             
   382:               subroutine SOSIUtilsAddPhysics(                         &
   383:                 & xy_SOSeaIceMass, xyz_SOSeaIceTemp,                  & !(inout)
   384:                 & xy_DSOSeaIceMassDtPhyTop, xy_DSOSeaIceMassDtPhyBot, & !(in   )
   385:                 & xyz_DSOSeaIceTempDtPhy                              & !(in   )
   386:                 & )
   387:                 ! 
   388:                 ! Calculates slab sea ice horizontal transports by diffusion
   389:             
   390:                 ! ヒストリデータ出力
   391:                 ! History data output
   392:                 !
   393:                 use gtool_historyauto, only: HistoryAutoPut
   394:             
   395:                 use timeset    , only : &
   396:                   & TimeN, &
   397:                   & DelTime
   398:                                           ! $\Delta t$
   399:             
   400:                 ! 雪と海氷の定数の設定
   401:                 ! Setting constants of snow and sea ice
   402:                 !
   403:                 use constants_snowseaice, only: &
   404:                   & TempBelowSeaIce, &
   405:                   & SeaIceDen
   406:             
   407:             
   408:                 ! 宣言文 ; Declaration statements
   409:                 !
   410:                 real(DP), intent(inout) :: xy_SOSeaIceMass    (0:imax-1, 1:jmax)
   411:                                           ! $ M_si $ . 海氷質量 (kg m-2)
   412:                                           ! Slab ocean sea ice mass (kg m-2)
   413:             !!!! Modified by M.Ishiwatari (2016-12-10)
   414:             !!!!    real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
   415:                 real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 0:ksimax)
   416:                 real(DP), intent(in   ) :: xy_DSOSeaIceMassDtPhyTop(0:imax-1, 1:jmax)
   417:                 real(DP), intent(in   ) :: xy_DSOSeaIceMassDtPhyBot(0:imax-1, 1:jmax)
   418:             
   419:             !!!! Modified by M.Ishiwatari (2016-12-10)
   420:             !!!!    real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 1:ksimax)
   421:                 real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 0:ksimax)
   422:             
   423:             
   424:                 ! 作業変数
   425:                 ! Work variables
   426:                 !
   427:                 real(DP) :: xy_SeaIceThickness(0:imax-1, 1:jmax)
   428:                 integer  :: xy_SOSILocalKMax  (0:imax-1, 1:jmax)
   429:                 real(DP) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   430:             !!!! Modified by M.Ishiwatari (2016-12-10)
   431:             !!!!    real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   432:                 real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   433:             
   434:                 real(DP) :: xy_SOSeaIceMassTent1   (0:imax-1, 1:jmax)
   435:                 real(DP) :: xy_SeaIceThicknessTent1(0:imax-1, 1:jmax)
   436:                 integer  :: xy_SOSILocalKMaxTent1  (0:imax-1, 1:jmax)
   437:                 real(DP) :: xyr_SOSILocalDepthTent1(0:imax-1, 1:jmax, 0:ksimax)
   438:             !!!! Modified by M.Ishiwatari (2016-12-10)
   439:             !!!!    real(DP) :: xyz_SOSILocalDepthTent1(0:imax-1, 1:jmax, 1:ksimax)
   440:                 real(DP) :: xyz_SOSILocalDepthTent1(0:imax-1, 1:jmax, 0:ksimax)
   441:             
   442:                 real(DP) :: xy_SOSeaIceMassTent2   (0:imax-1, 1:jmax)
   443:                 real(DP) :: xy_SeaIceThicknessTent2(0:imax-1, 1:jmax)
   444:                 integer  :: xy_SOSILocalKMaxTent2  (0:imax-1, 1:jmax)
   445:                 real(DP) :: xyr_SOSILocalDepthTent2(0:imax-1, 1:jmax, 0:ksimax)
   446:             !!!! Modified by M.Ishiwatari (2016-12-10)
   447:             !!!!    real(DP) :: xyz_SOSILocalDepthTent2(0:imax-1, 1:jmax, 1:ksimax)
   448:                 real(DP) :: xyz_SOSILocalDepthTent2(0:imax-1, 1:jmax, 0:ksimax)
   449:             
   450:                 real(DP) :: xyr_SOSILocalDepthT2MapToT1(0:imax-1, 1:jmax, 0:ksimax)
   451:             
   452:             !!!! Modifiedy by M.Ishiwatari (2016-12-10)
   453:             !!!!    real(DP) :: xyz_SOSeaIceTempTent1(0:imax-1, 1:jmax, 1:ksimax)
   454:             !!!!    real(DP) :: xyz_SOSeaIceTempTent2(0:imax-1, 1:jmax, 1:ksimax)
   455:                 real(DP) :: xyz_SOSeaIceTempTent1(0:imax-1, 1:jmax, 0:ksimax)
   456:                 real(DP) :: xyz_SOSeaIceTempTent2(0:imax-1, 1:jmax, 0:ksimax)
   457:             !!$
   458:             !!$    real(DP) :: xyz_DSOSeaIceTempDtPhyUpdt(0:imax-1, 1:jmax, 1:ksimax)
   459:             
   460:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   461:                                           ! Work variables for DO loop in zonal direction
   462:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   463:                                           ! Work variables for DO loop in meridional direction
   464:                 integer:: k
   465:                 integer:: kk
   466:                 integer:: kTop
   467:                 integer:: kBot
   468:             
   469:             
   470:                 if ( .not. sosi_utils_inited ) then
   471:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   472:                 end if
   473:             
   474:             
   475:                 ! Calculate sea ice mass at next time step
   476:                 !
   477:             
   478:                 !   Add sea ice mass change at the bottom of sea ice
   479: *W----->A       xy_SOSeaIceMassTent1 = xy_SOSeaIceMass &
   480: ||                & + xy_DSOSeaIceMassDtPhyBot * DelTime
   481: ||          
   482: ||              !   Add sea ice mass change at the top of sea ice
   483: *W----- A       xy_SOSeaIceMassTent2 = xy_SOSeaIceMassTent1 &
   484:                   & + xy_DSOSeaIceMassDtPhyTop * DelTime
   485:             
   486:             
   487:                 ! 海氷温度時間積分
   488:                 ! Time integration of sea ice temperature
   489:                 !
   490: W**==== A       xyz_SOSeaIceTempTent1 = xyz_SOSeaIceTemp &
   491:                   & + xyz_DSOSeaIceTempDtPhy * DelTime
   492:             
   493:             
   494:                 !
   495:                 ! Adjust temperature
   496:                 !
   497:             
   498:                 !
   499:                 !   Calcuate sea ice thickness
   500:                 !
   501: W*===== A       xy_SeaIceThickness = xy_SOSeaIceMass / SeaIceDen
   502:                 !
   503:                 !   Set slab ocean sea ice levels
   504:                 !
   505:                 call SOSIUtilsSetSOSeaIceLevels(                              &
   506:                   & xy_SeaIceThickness,                                       & ! (in )
   507:                   & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   508:                   & )
   509:             
   510:                 !
   511:                 !   Calcuate sea ice thickness
   512:                 !
   513: W*===== A       xy_SeaIceThicknessTent1 = xy_SOSeaIceMassTent1 / SeaIceDen
   514:                 !
   515:                 !   Set slab ocean sea ice levels
   516:                 !
   517:                 call SOSIUtilsSetSOSeaIceLevels(                     &
   518:                   & xy_SeaIceThicknessTent1,                                       & ! (in   )
   519:                   & xy_SOSILocalKMaxTent1, xyr_SOSILocalDepthTent1, xyz_SOSILocalDepthTent1  & ! (out)
   520:                   & )
   521:             
   522:                 !   Adjust levels
   523:                 !
   524: +------>        do j = 1, jmax
   525: |+----->          do i = 0, imax-1
   526: ||                  if ( xy_SOSILocalKMaxTent1(i,j) > xy_SOSILocalKMax(i,j) ) then
   527: ||                    ! sea ice thickness increases
   528: ||                    if ( xy_SOSILocalKMax(i,j) == 0 ) then
   529: ||V---->                do k = 1, xy_SOSILocalKMaxTent1(i,j)
   530: |||     A                 xyz_SOSeaIceTempTent1(i,j,k) = TempBelowSeaIce
   531: ||V----                 end do
   532: ||                    else
   533: ||          !!$            do k = 1, xy_SOSILocalKMaxB(i,j)
   534: ||          !!$              ! Do nothing
   535: ||          !!$            end do
   536: ||V---->                do k = xy_SOSILocalKMax(i,j)+1, xy_SOSILocalKMaxTent1(i,j)
   537: |||                       kk = xy_SOSILocalKMax(i,j)
   538: |||     A                 xyz_SOSeaIceTempTent1(i,j,k) = xyz_SOSeaIceTempTent1(i,j,kk)
   539: ||V----                 end do
   540: ||                    end if
   541: ||                  else if ( xy_SOSILocalKMaxTent1(i,j) < xy_SOSILocalKMax(i,j) ) then
   542: ||                    ! sea ice thickness decreases
   543: ||                    !   Do nothing
   544: ||                    !   Melted sea ice had freezing temperature
   545: ||                  end if
   546: |+-----           end do
   547: +------         end do
   548:             
   549:             
   550:             
   551:                 !
   552:                 !   Calcuate sea ice thickness
   553:                 !
   554: W*===== A       xy_SeaIceThicknessTent2 = xy_SOSeaIceMassTent2 / SeaIceDen
   555:                 !
   556:                 !   Set slab ocean sea ice levels
   557:                 !
   558:                 call SOSIUtilsSetSOSeaIceLevels(                     &
   559:                   & xy_SeaIceThicknessTent2,                                       & ! (in   )
   560:                   & xy_SOSILocalKMaxTent2, xyr_SOSILocalDepthTent2, xyz_SOSILocalDepthTent2  & ! (out)
   561:                   & )
   562:             
   563:                 !   Adjust levels
   564:                 !
   565: +------>        do j = 1, jmax
   566: |+----->          do i = 0, imax-1
   567: ||                  if ( xy_SOSILocalKMaxTent2(i,j) == 0 ) then
   568: ||V---->              do k = 0, ksimax
   569: |||     A               xyr_SOSILocalDepthT2MapToT1(i,j,k) = 0.0_DP
   570: ||V----               end do
   571: ||                  else
   572: ||V---->              do k = 0, xy_SOSILocalKMaxTent2(i,j)
   573: |||     A               xyr_SOSILocalDepthT2MapToT1(i,j,k) = &
   574: |||                       &   xyr_SOSILocalDepthTent2(i,j,k) &
   575: |||                       & - ( xy_SeaIceThicknessTent1(i,j) - xy_SeaIceThicknessTent2(i,j) )
   576: ||V----               end do
   577: ||V---->              do k = xy_SOSILocalKMaxTent2(i,j)+1, ksimax
   578: |||     A               xyr_SOSILocalDepthT2MapToT1(i,j,k) = 0.0_DP
   579: ||V----               end do
   580: ||                  end if
   581: |+-----           end do
   582: +------         end do
   583:                 !
   584: +------>        do j = 1, jmax
   585: |+----->          do i = 0, imax-1
   586: ||          
   587: ||                  if ( xy_SOSILocalKMaxTent2(i,j) == 0 ) then
   588: ||V---->              do k = 1, ksimax
   589: |||     A               xyz_SOSeaIceTempTent2(i,j,k) = SOSeaIceTempMissingValue
   590: ||V----               end do
   591: ||                  else
   592: ||          
   593: ||+---->              do k = 1, xy_SOSILocalKMaxTent2(i,j)
   594: |||         
   595: |||V--->                search_kTop : do kTop = 1, xy_SOSILocalKMaxTent1(i,j)
   596: ||||    A                 if ( xyr_SOSILocalDepthT2MapToT1(i,j,k-1) >= xyr_SOSILocalDepthTent1(i,j,kTop) ) then
   597: ||||                        exit search_kTop
   598: ||||                      end if
   599: |||V---                 end do search_kTop
   600: |||V--->                search_kBot : do kBot = kTop, xy_SOSILocalKMaxTent1(i,j)
   601: ||||    A                 if ( xyr_SOSILocalDepthT2MapToT1(i,j,k  ) >= xyr_SOSILocalDepthTent1(i,j,kBot) ) then
   602: ||||                        exit search_kBot
   603: ||||                      end if
   604: |||V---                 end do search_kBot
   605: |||         
   606: |||                     if ( kTop == kBot ) then
   607: |||                       kk = kTop
   608: |||                       xyz_SOSeaIceTempTent2(i,j,k) = &
   609: |||                         & + xyz_SOSeaIceTempTent1(i,j,kk)                &
   610: |||                         &     * (   xyr_SOSILocalDepthT2MapToT1(i,j,k-1) &
   611: |||                         &         - xyr_SOSILocalDepthT2MapToT1(i,j,k  ) )
   612: |||                     else
   613: |||                       xyz_SOSeaIceTempTent2(i,j,k) = 0.0_DP
   614: |||                       kk = kTop
   615: |||                       xyz_SOSeaIceTempTent2(i,j,k) = xyz_SOSeaIceTempTent2(i,j,k) &
   616: |||                         & + xyz_SOSeaIceTempTent1(i,j,kk)                      &
   617: |||                         &     * (   xyr_SOSILocalDepthT2MapToT1(i,j,k-1) &
   618: |||                         &         - xyr_SOSILocalDepthTent1(i,j,kk) )
   619: |||V--->                  do kk = kTop+1, kBot-1
   620: ||||    A                   xyz_SOSeaIceTempTent2(i,j,k) = xyz_SOSeaIceTempTent2(i,j,k) &
   621: ||||                          & + xyz_SOSeaIceTempTent1(i,j,kk)                      &
   622: ||||                          &     * (   xyr_SOSILocalDepthTent1(i,j,kk-1)          &
   623: ||||                          &         - xyr_SOSILocalDepthTent1(i,j,kk  ) )
   624: |||V---                   end do
   625: |||                       kk = kBot
   626: |||                       xyz_SOSeaIceTempTent2(i,j,k) = xyz_SOSeaIceTempTent2(i,j,k) &
   627: |||                         & + xyz_SOSeaIceTempTent1(i,j,kk)                      &
   628: |||                         &     * (   xyr_SOSILocalDepthTent1(i,j,kk-1)          &
   629: |||                         &         - xyr_SOSILocalDepthT2MapToT1(i,j,k) )
   630: |||                     end if
   631: |||                     !
   632: |||                     xyz_SOSeaIceTempTent2(i,j,k) = &
   633: |||                       & xyz_SOSeaIceTempTent2(i,j,k) &
   634: |||                       & / ( xyr_SOSILocalDepthTent2(i,j,k-1) - xyr_SOSILocalDepthTent2(i,j,k) )
   635: |||         
   636: ||+----               end do
   637: ||V---->              do k = xy_SOSILocalKMaxTent2(i,j)+1, ksimax
   638: |||     A               xyz_SOSeaIceTempTent2(i,j,k) = SOSeaIceTempMissingValue
   639: ||V----               end do
   640: ||          
   641: ||                  end if
   642: ||          
   643: |+-----           end do
   644: +------         end do
   645:             
   646:             
   647:                 ! Update sea ice temperature
   648:                 !
   649: W**==== A       xyz_SOSeaIceTemp = xyz_SOSeaIceTempTent2
   650:             
   651:                 ! Update sea ice mass
   652:                 !
   653: W*===== A       xy_SOSeaIceMass = xy_SOSeaIceMassTent2
   654:             
   655:             
   656:                 ! Check sea ice mass
   657:                 !
   658: +------>        do j = 1, jmax
   659: |+----->          do i = 0, imax-1
   660: ||                  if ( xy_SOSeaIceMass(i,j) < 0 ) then
   661: ||                    if ( xy_SOSeaIceMass(i,j) < SOSeaIceMassNegativeThreshold ) then
   662: ||                      call MessageNotify( 'M', module_name, &
   663: ||                        & '  Slab sea ice mass is negative after physics, %f, and this is set to zero.', &
   664: ||                        & d = (/ xy_SOSeaIceMass(i,j) /) )
   665: ||                    end if
   666: ||                    xy_SOSeaIceMass(i,j) = 0.0_DP
   667: ||                  end if
   668: |+-----           end do
   669: +------         end do
   670:             
   671:             
   672:                 ! Check
   673:                 !
   674: W*===== A       xy_SeaIceThickness = xy_SOSeaIceMass / SeaIceDen
   675:                 !
   676:                 call SOSIUtilsChkSOSeaIce(          &
   677:                   & xy_SeaIceThickness, xyz_SOSeaIceTemp, & ! (in)
   678:                   & "SOSIUtilsAddPhysics"               & ! (in)
   679:                   & )
   680:             
   681:             
   682:               end subroutine SOSIUtilsAddPhysics
   683:             
   684:               !--------------------------------------------------------------------------------------
   685:             
   686:             !!$  subroutine BK_SOSIUtilsAddPhysics(                         &
   687:             !!$    & xy_SOSeaIceMassB,                                   & !(in )
   688:             !!$    & xy_DSOSeaIceMassDtPhyTop, xy_DSOSeaIceMassDtPhyBot, & !(in )
   689:             !!$    & xy_SOSeaIceMassA,                                   & !(out)
   690:             !!$    & xyz_SOSeaIceTemp,                                   & !(inout)
   691:             !!$    & xyz_DSOSeaIceTempDtPhy                              & !(in   )
   692:             !!$    & )
   693:             !!$    ! 
   694:             !!$    ! Calculates slab sea ice horizontal transports by diffusion
   695:             !!$
   696:             !!$    ! ヒストリデータ出力
   697:             !!$    ! History data output
   698:             !!$    !
   699:             !!$    use gtool_historyauto, only: HistoryAutoPut
   700:             !!$
   701:             !!$    use timeset    , only : &
   702:             !!$      & TimeN, &
   703:             !!$      & DelTime
   704:             !!$                              ! $\Delta t$
   705:             !!$
   706:             !!$    ! 雪と海氷の定数の設定
   707:             !!$    ! Setting constants of snow and sea ice
   708:             !!$    !
   709:             !!$    use constants_snowseaice, only: &
   710:             !!$      & TempBelowSeaIce, &
   711:             !!$      & SeaIceDen
   712:             !!$
   713:             !!$
   714:             !!$    ! 宣言文 ; Declaration statements
   715:             !!$    !
   716:             !!$    real(DP), intent(in ) :: xy_SOSeaIceMassB    (0:imax-1, 1:jmax)
   717:             !!$                              ! $ M_si (t-1) $ . 海氷質量 (kg m-2)
   718:             !!$                              ! Slab ocean sea ice mass (kg m-2)
   719:             !!$    real(DP), intent(in ) :: xy_DSOSeaIceMassDtPhyTop(0:imax-1, 1:jmax)
   720:             !!$    real(DP), intent(in ) :: xy_DSOSeaIceMassDtPhyBot(0:imax-1, 1:jmax)
   721:             !!$
   722:             !!$    real(DP), intent(out) :: xy_SOSeaIceMassA(0:imax-1, 1:jmax)
   723:             !!$                              !
   724:             !!$                              ! Slab sea ice mass at next time step
   725:             !!$    real(DP), intent(inout) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
   726:             !!$    real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 1:ksimax)
   727:             !!$
   728:             !!$
   729:             !!$    ! 作業変数
   730:             !!$    ! Work variables
   731:             !!$    !
   732:             !!$    real(DP) :: xy_SeaIceThicknessB(0:imax-1, 1:jmax)
   733:             !!$    integer  :: xy_SOSILocalKMaxB  (0:imax-1, 1:jmax)
   734:             !!$    real(DP) :: xyr_SOSILocalDepthB(0:imax-1, 1:jmax, 0:ksimax)
   735:             !!$    real(DP) :: xyz_SOSILocalDepthB(0:imax-1, 1:jmax, 1:ksimax)
   736:             !!$
   737:             !!$    real(DP) :: xy_SOSeaIceMassA1(0:imax-1, 1:jmax)
   738:             !!$    real(DP) :: xy_SeaIceThicknessA1(0:imax-1, 1:jmax)
   739:             !!$    integer  :: xy_SOSILocalKMaxA1  (0:imax-1, 1:jmax)
   740:             !!$    real(DP) :: xyr_SOSILocalDepthA1(0:imax-1, 1:jmax, 0:ksimax)
   741:             !!$    real(DP) :: xyz_SOSILocalDepthA1(0:imax-1, 1:jmax, 1:ksimax)
   742:             !!$
   743:             !!$    real(DP) :: xy_SOSeaIceMassA2(0:imax-1, 1:jmax)
   744:             !!$    real(DP) :: xy_SeaIceThicknessA2(0:imax-1, 1:jmax)
   745:             !!$    integer  :: xy_SOSILocalKMaxA2  (0:imax-1, 1:jmax)
   746:             !!$    real(DP) :: xyr_SOSILocalDepthA2(0:imax-1, 1:jmax, 0:ksimax)
   747:             !!$    real(DP) :: xyz_SOSILocalDepthA2(0:imax-1, 1:jmax, 1:ksimax)
   748:             !!$
   749:             !!$    real(DP) :: xyr_SOSILocalDepthA2MappedToA1(0:imax-1, 1:jmax, 0:ksimax)
   750:             !!$
   751:             !!$    real(DP) :: xyz_SOSeaIceTempA1(0:imax-1, 1:jmax, 1:ksimax)
   752:             !!$    real(DP) :: xyz_SOSeaIceTempA2(0:imax-1, 1:jmax, 1:ksimax)
   753:             !!$
   754:             !!$    real(DP) :: xyz_DSOSeaIceTempDtPhyUpdt(0:imax-1, 1:jmax, 1:ksimax)
   755:             !!$
   756:             !!$    integer:: i               ! 東西方向に回る DO ループ用作業変数
   757:             !!$                              ! Work variables for DO loop in zonal direction
   758:             !!$    integer:: j               ! 南北方向に回る DO ループ用作業変数
   759:             !!$                              ! Work variables for DO loop in meridional direction
   760:             !!$    integer:: k
   761:             !!$    integer:: kk
   762:             !!$    integer:: kTop
   763:             !!$    integer:: kBot
   764:             !!$
   765:             !!$
   766:             !!$    if ( .not. sosi_utils_inited ) then
   767:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   768:             !!$    end if
   769:             !!$
   770:             !!$
   771:             !!$    ! Calculate sea ice mass at next time step
   772:             !!$    !
   773:             !!$
   774:             !!$    !   Add sea ice mass change at the bottom of sea ice
   775:             !!$    xy_SOSeaIceMassA1 = xy_SOSeaIceMassB &
   776:             !!$      & + xy_DSOSeaIceMassDtPhyBot * ( 2.0_DP * DelTime )
   777:             !!$
   778:             !!$    !   Add sea ice mass change at the top of sea ice
   779:             !!$    xy_SOSeaIceMassA2 = xy_SOSeaIceMassA1 &
   780:             !!$      & + xy_DSOSeaIceMassDtPhyTop * ( 2.0_DP * DelTime )
   781:             !!$
   782:             !!$    !   Update sea ice mass
   783:             !!$    xy_SOSeaIceMassA = xy_SOSeaIceMassA2
   784:             !!$
   785:             !!$
   786:             !!$    ! Check sea ice mass
   787:             !!$    !
   788:             !!$    do j = 1, jmax
   789:             !!$      do i = 0, imax-1
   790:             !!$        if ( xy_SOSeaIceMassA(i,j) < 0 ) then
   791:             !!$          if ( xy_SOSeaIceMassA(i,j) < SOSeaIceMassNegativeThreshold ) then
   792:             !!$            call MessageNotify( 'M', module_name, &
   793:             !!$              & '  Slab sea ice mass is negative after physics, %f, and this is set to zero.', &
   794:             !!$              & d = (/ xy_SOSeaIceMassA(i,j) /) )
   795:             !!$          end if
   796:             !!$          xy_SOSeaIceMassA(i,j) = 0.0_DP
   797:             !!$        end if
   798:             !!$      end do
   799:             !!$    end do
   800:             !!$
   801:             !!$
   802:             !!$    ! 海氷温度時間積分
   803:             !!$    ! Time integration of sea ice temperature
   804:             !!$    !
   805:             !!$    xyz_SOSeaIceTemp = xyz_SOSeaIceTemp &
   806:             !!$      & + xyz_DSOSeaIceTempDtPhy * DelTime
   807:             !!$
   808:             !!$    !
   809:             !!$    ! Calcuate sea ice thickness
   810:             !!$    !
   811:             !!$
   812:             !!$    !
   813:             !!$    !   Calcuate sea ice thickness
   814:             !!$    !
   815:             !!$    xy_SeaIceThicknessB = xy_SOSeaIceMassB / SeaIceDen
   816:             !!$    !
   817:             !!$    !   Set slab ocean sea ice levels
   818:             !!$    !
   819:             !!$    call SOSIUtilsSetSOSeaIceLevels(                                 &
   820:             !!$      & xy_SeaIceThicknessB,                                         & ! (in )
   821:             !!$      & xy_SOSILocalKMaxB, xyr_SOSILocalDepthB, xyz_SOSILocalDepthB  & ! (out)
   822:             !!$      & )
   823:             !!$
   824:             !!$    !
   825:             !!$    !   Calcuate sea ice thickness
   826:             !!$    !
   827:             !!$    xy_SeaIceThicknessA1 = xy_SOSeaIceMassA1 / SeaIceDen
   828:             !!$    !
   829:             !!$    !   Set slab ocean sea ice levels
   830:             !!$    !
   831:             !!$    call SOSIUtilsSetSOSeaIceLevels(                     &
   832:             !!$      & xy_SeaIceThicknessA1,                                       & ! (in   )
   833:             !!$      & xy_SOSILocalKMaxA1, xyr_SOSILocalDepthA1, xyz_SOSILocalDepthA1  & ! (out)
   834:             !!$      & )
   835:             !!$
   836:             !!$    !   Adjust levels
   837:             !!$    !
   838:             !!$    do j = 1, jmax
   839:             !!$      do i = 0, imax-1
   840:             !!$        if ( xy_SOSILocalKMaxA1(i,j) > xy_SOSILocalKMaxB(i,j) ) then
   841:             !!$          ! sea ice thickness increases
   842:             !!$          if ( xy_SOSILocalKMaxB(i,j) == 0 ) then
   843:             !!$            do k = 1, xy_SOSILocalKMaxA1(i,j)
   844:             !!$              xyz_SOSeaIceTempA1(i,j,k) = TempBelowSeaIce
   845:             !!$            end do
   846:             !!$          else
   847:             !!$!            do k = 1, xy_SOSILocalKMaxB(i,j)
   848:             !!$!              ! Do nothing
   849:             !!$!            end do
   850:             !!$            do k = xy_SOSILocalKMaxB(i,j)+1, xy_SOSILocalKMaxA1(i,j)
   851:             !!$              kk = xy_SOSILocalKMaxB(i,j)
   852:             !!$              xyz_SOSeaIceTempA1(i,j,k) = xyz_SOSeaIceTempA1(i,j,kk)
   853:             !!$            end do
   854:             !!$          end if
   855:             !!$        else if ( xy_SOSILocalKMaxA1(i,j) < xy_SOSILocalKMaxB(i,j) ) then
   856:             !!$          ! sea ice thickness decreases
   857:             !!$          !   Do nothing
   858:             !!$          !   Melted sea ice had freezing temperature
   859:             !!$        end if
   860:             !!$      end do
   861:             !!$    end do
   862:             !!$
   863:             !!$
   864:             !!$
   865:             !!$    !
   866:             !!$    !   Calcuate sea ice thickness
   867:             !!$    !
   868:             !!$    xy_SeaIceThicknessA2 = xy_SOSeaIceMassA2 / SeaIceDen
   869:             !!$    !
   870:             !!$    !   Set slab ocean sea ice levels
   871:             !!$    !
   872:             !!$    call SOSIUtilsSetSOSeaIceLevels(                     &
   873:             !!$      & xy_SeaIceThicknessA2,                                       & ! (in   )
   874:             !!$      & xy_SOSILocalKMaxA2, xyr_SOSILocalDepthA2, xyz_SOSILocalDepthA2  & ! (out)
   875:             !!$      & )
   876:             !!$
   877:             !!$    !   Adjust levels
   878:             !!$    !
   879:             !!$    do j = 1, jmax
   880:             !!$      do i = 0, imax-1
   881:             !!$        if ( xy_SOSILocalKMaxA2(i,j) == 0 ) then
   882:             !!$          do k = 0, ksimax
   883:             !!$            xyr_SOSILocalDepthA2MappedToA1(i,j,k) = 0.0_DP
   884:             !!$          end do
   885:             !!$        else
   886:             !!$          do k = 0, xy_SOSILocalKMaxA2(i,j)
   887:             !!$            xyr_SOSILocalDepthA2MappedToA1(i,j,k) = &
   888:             !!$              &   xyr_SOSILocalDepthA2(i,j,k) &
   889:             !!$              & - ( xy_SeaIceThicknessA1(i,j) - xy_SeaIceThicknessA2(i,j) )
   890:             !!$          end do
   891:             !!$          do k = xy_SOSILocalKMaxA2(i,j)+1, ksimax
   892:             !!$            xyr_SOSILocalDepthA2MappedToA1(i,j,k) = 0.0_DP
   893:             !!$          end do
   894:             !!$        end if
   895:             !!$      end do
   896:             !!$    end do
   897:             !!$    !
   898:             !!$    do j = 1, jmax
   899:             !!$      do i = 0, imax-1
   900:             !!$
   901:             !!$        if ( xy_SOSILocalKMaxA2(i,j) == 0 ) then
   902:             !!$          do k = 1, ksimax
   903:             !!$            xyz_SOSeaIceTempA2(i,j,k) = SOSeaIceTempMissingValue
   904:             !!$          end do
   905:             !!$        else
   906:             !!$
   907:             !!$          do k = 1, xy_SOSILocalKMaxA2(i,j)
   908:             !!$
   909:             !!$            search_kTop : do kTop = 1, xy_SOSILocalKMaxA1(i,j)
   910:             !!$              if ( xyr_SOSILocalDepthA2MappedToA1(i,j,k-1) >= xyr_SOSILocalDepthA1(i,j,kTop) ) then
   911:             !!$                exit search_kTop
   912:             !!$              end if
   913:             !!$            end do search_kTop
   914:             !!$            search_kBot : do kBot = kTop, xy_SOSILocalKMaxA1(i,j)
   915:             !!$              if ( xyr_SOSILocalDepthA2MappedToA1(i,j,k  ) >= xyr_SOSILocalDepthA1(i,j,kBot) ) then
   916:             !!$                exit search_kBot
   917:             !!$              end if
   918:             !!$            end do search_kBot
   919:             !!$
   920:             !!$            if ( kTop == kBot ) then
   921:             !!$              kk = kTop
   922:             !!$              xyz_SOSeaIceTempA2(i,j,k) = &
   923:             !!$                & + xyz_SOSeaIceTempA1(i,j,kk)                      &
   924:             !!$                &     * (   xyr_SOSILocalDepthA2MappedToA1(i,j,k-1) &
   925:             !!$                &         - xyr_SOSILocalDepthA2MappedToA1(i,j,k  ) )
   926:             !!$            else
   927:             !!$              xyz_SOSeaIceTempA2(i,j,k) = 0.0_DP
   928:             !!$              kk = kTop
   929:             !!$              xyz_SOSeaIceTempA2(i,j,k) = xyz_SOSeaIceTempA2(i,j,k) &
   930:             !!$                & + xyz_SOSeaIceTempA1(i,j,kk)                      &
   931:             !!$                &     * (   xyr_SOSILocalDepthA2MappedToA1(i,j,k-1) &
   932:             !!$                &         - xyr_SOSILocalDepthA1(i,j,kk) )
   933:             !!$              do kk = kTop+1, kBot-1
   934:             !!$                xyz_SOSeaIceTempA2(i,j,k) = xyz_SOSeaIceTempA2(i,j,k) &
   935:             !!$                  & + xyz_SOSeaIceTempA1(i,j,kk)                      &
   936:             !!$                  &     * (   xyr_SOSILocalDepthA1(i,j,kk-1)          &
   937:             !!$                  &         - xyr_SOSILocalDepthA1(i,j,kk  ) )
   938:             !!$              end do
   939:             !!$              kk = kBot
   940:             !!$              xyz_SOSeaIceTempA2(i,j,k) = xyz_SOSeaIceTempA2(i,j,k) &
   941:             !!$                & + xyz_SOSeaIceTempA1(i,j,kk)                      &
   942:             !!$                &     * (   xyr_SOSILocalDepthA1(i,j,kk-1)          &
   943:             !!$                &         - xyr_SOSILocalDepthA2MappedToA1(i,j,k) )
   944:             !!$            end if
   945:             !!$            !
   946:             !!$            xyz_SOSeaIceTempA2(i,j,k) = &
   947:             !!$              & xyz_SOSeaIceTempA2(i,j,k) &
   948:             !!$              & / ( xyr_SOSILocalDepthA2(i,j,k-1) - xyr_SOSILocalDepthA2(i,j,k) )
   949:             !!$
   950:             !!$          end do
   951:             !!$          do k = xy_SOSILocalKMaxA2(i,j)+1, ksimax
   952:             !!$            xyz_SOSeaIceTempA2(i,j,k) = SOSeaIceTempMissingValue
   953:             !!$          end do
   954:             !!$
   955:             !!$        end if
   956:             !!$
   957:             !!$      end do
   958:             !!$    end do
   959:             !!$
   960:             !!$
   961:             !!$    !   Calculation of updated tendency
   962:             !!$    !
   963:             !!$!    do j = 1, jmax
   964:             !!$!      do i = 0, imax-1
   965:             !!$!    xyz_DSOSeaIceTempDtPhyUpdt = &
   966:             !!$!      & ( xyz_SOSeaIceTempA2 - xyz_SOSeaIceTemp ) / ( 2.0_DP * DelTime )
   967:             !!$
   968:             !!$
   969:             !!$    ! Update sea ice temperature
   970:             !!$    !
   971:             !!$    xyz_SOSeaIceTemp = xyz_SOSeaIceTemp + xyz_DSOSeaIceTempDtPhyUpdt * DelTime
   972:             !!$
   973:             !!$
   974:             !!$
   975:             !!$  end subroutine BK_SOSIUtilsAddPhysics
   976:             
   977:               !--------------------------------------------------------------------------------------
   978:             
   979:               subroutine SOSIUtilsInit
   980:             
   981:                 !
   982:                 ! sosi_utils モジュールの初期化を行います. 
   983:                 ! NAMELIST#sosi_utils_nml の読み込みはこの手続きで行われます. 
   984:                 !
   985:                 ! "sosi_utils" module is initialized. 
   986:                 ! "NAMELIST#sosi_utils_nml" is loaded in this procedure. 
   987:                 !
   988:             
   989:                 ! モジュール引用 ; USE statements
   990:                 !
   991:             
   992:                 ! NAMELIST ファイル入力に関するユーティリティ
   993:                 ! Utilities for NAMELIST file input
   994:                 !
   995:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   996:             
   997:                 ! ファイル入出力補助
   998:                 ! File I/O support
   999:                 !
  1000:                 use dc_iounit, only: FileOpen
  1001:             
  1002:                 ! 種別型パラメタ
  1003:                 ! Kind type parameter
  1004:                 !
  1005:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1006:             
  1007:                 ! 文字列操作
  1008:                 ! Character handling
  1009:                 !
  1010:                 use dc_string, only: StoA
  1011:             
  1012:             
  1013:                 ! 宣言文 ; Declaration statements
  1014:                 !
  1015:             
  1016:             
  1017:             
  1018:                 ! 作業変数
  1019:                 ! Work variables
  1020:                 !
  1021:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1022:                                           ! Unit number for NAMELIST file open
  1023:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1024:                                           ! IOSTAT of NAMELIST read
  1025:             
  1026:                 ! NAMELIST 変数群
  1027:                 ! NAMELIST group name
  1028:                 !
  1029:                 namelist /sosi_utils_nml/ &
  1030:                   & SOSeaIceMassNegativeThreshold
  1031:             !!$      & SOMass,         &          ! Slab ocean heat capacity (J m-2 K-1)
  1032:             !!$      & NumMaxItr,      &          ! Number of interation
  1033:             !!$      & TempItrCrit,    &
  1034:             !!$      & FlagSublimation
  1035:                       !
  1036:                       ! デフォルト値については初期化手続 "sosi_utils#SOSOUtilsInit" 
  1037:                       ! のソースコードを参照のこと. 
  1038:                       !
  1039:                       ! Refer to source codes in the initialization procedure
  1040:                       ! "sosi_utils#SOSIUtilsInit" for the default values. 
  1041:                       !
  1042:             
  1043:                 ! 実行文 ; Executable statement
  1044:                 !
  1045:             
  1046:                 if ( sosi_utils_inited ) return
  1047:             
  1048:             
  1049:                 ! デフォルト値の設定
  1050:                 ! Default values settings
  1051:                 !
  1052:                 SOSeaIceMassNegativeThreshold = -1.0e-10_DP
  1053:             
  1054:             
  1055:                 ! NAMELIST の読み込み
  1056:                 ! NAMELIST is input
  1057:                 !
  1058:                 if ( trim(namelist_filename) /= '' ) then
  1059:                   call FileOpen( unit_nml, &          ! (out)
  1060:                     & namelist_filename, mode = 'r' ) ! (in)
  1061:             
  1062:                   rewind( unit_nml )
  1063:                   read( unit_nml,                    &  ! (in)
  1064:                     & nml = sosi_utils_nml,          &  ! (out)
  1065:                     & iostat = iostat_nml )             ! (out)
  1066:                   close( unit_nml )
  1067:             
  1068:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1069:                 end if
  1070:             
  1071:             
  1072:             
  1073:                 ! Initialization of modules used in this model
  1074:                 !
  1075:             
  1076:             
  1077:                 ! 印字 ; Print
  1078:                 !
  1079:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1080:                 call MessageNotify( 'M', module_name, '  SOSeaIceMassNegativeThreshold = %f', &
  1081:                   & d = (/ SOSeaIceMassNegativeThreshold /) )
  1082:             !!$    call MessageNotify( 'M', module_name, '  SOMass          = %f', d = (/ SOMass /) )
  1083:             !!$    call MessageNotify( 'M', module_name, '  SOHeatCapacity  = %f', d = (/ SOHeatCapacity /) )
  1084:             !!$    call MessageNotify( 'M', module_name, '  NumMaxItr       = %d', i = (/ NumMaxItr /) )
  1085:             !!$    call MessageNotify( 'M', module_name, '  TempItrCrit     = %f', d = (/ TempItrCrit /) )
  1086:             !!$    call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
  1087:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1088:             
  1089:             
  1090:                 sosi_utils_inited = .true.
  1091:             
  1092:               end subroutine SOSIUtilsInit
  1093:             
  1094:               !--------------------------------------------------------------------------------------
  1095:             
  1096:             end module sosi_utils
