Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:06 2016
FILE NAME: surface_flux_util.f90
PROGRAM NAME: surface_flux_util
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   203  opt  (1593): Loop nest collapsed into one loop.
   203  vec  (   1): Vectorized loop.
   203  vec  (  29): ADB is used for array.: xyr_press
   210  opt  (1593): Loop nest collapsed into one loop.
   210  vec  (   4): Vectorized array expression.
   211  vec  (   3): Unvectorized loop.
   211  vec  (  13): Overhead of loop division is too large.
   212  opt  (1593): Loop nest collapsed into one loop.
   212  vec  (   4): Vectorized array expression.
   212  vec  (  29): ADB is used for array.: xy_consmass
   212  vec  (  29): ADB is used for array.: xyzf_qmix
   216  opt  (1593): Loop nest collapsed into one loop.
   216  vec  (   4): Vectorized array expression.
   216  vec  (  29): ADB is used for array.: xy_surfh2ovapflux
   221  opt  (1593): Loop nest collapsed into one loop.
   221  vec  (   1): Vectorized loop.
   221  vec  (  29): ADB is used for array.: xy_consmass
   231  opt  (1593): Loop nest collapsed into one loop.
   231  vec  (   4): Vectorized array expression.
   231  vec  (  29): ADB is used for array.: xy_surfh2ovapflux
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:06 2016
FILE NAME: surface_flux_util.f90
PROGRAM NAME: surface_flux_util
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地表面フラックスユーティリティ
     2  !
     3  != Surface flux utility routines
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: surface_flux_util.f90,v 1.1 2013/10/06 13:44:15 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module surface_flux_util
    13    !
    14    != 地表面フラックスユーティリティ
    15    !
    16    != Surface flux utility routines
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 地表面フラックスを計算.
    21    !
    22    ! Surface fluxes are calculated.
    23    !
    24    !== References
    25    !
    26  !!$  ! Louis, J-F., M. Tiedtke, and J-F. Geleyn,
    27  !!$  ! A short history of the PBL parameterization at ECMWF,
    28  !!$  ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K.,
    29  !!$  ! 1982.
    30    !
    31    !== Procedures List
    32    !
    33  !!$  ! SurfaceFlux       :: 地表面フラックスの計算
    34  !!$  ! ------------      :: ------------
    35  !!$  ! SurfaceFlux       :: Calculate surface fluxes
    36    !
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#surface_flux_util_nml
    40    !
    41  
    42    ! モジュール引用 ; USE statements
    43    !
    44  
    45    ! 格子点設定
    46    ! Grid points settings
    47    !
    48    use gridset, only: imax, & ! 経度格子点数.
    49                               ! Number of grid points in longitude
    50      &                jmax, & ! 緯度格子点数.
    51                               ! Number of grid points in latitude
    52      &                kmax    ! 鉛直層数.
    53                               ! Number of vertical level
    54  
    55    ! 組成に関わる配列の設定
    56    ! Settings of array for atmospheric composition
    57    !
    58    use composition, only: &
    59      & ncmax, &
    60      & IndexH2OVap
    61  
    62    ! 種別型パラメタ
    63    ! Kind type parameter
    64    !
    65    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    66      &                 STRING     ! 文字列.       Strings.
    67  
    68    ! メッセージ出力
    69    ! Message output
    70    !
    71    use dc_message, only: MessageNotify
    72  
    73    ! 宣言文 ; Declaration statements
    74    !
    75    implicit none
    76    private
    77  
    78    ! 公開手続き
    79    ! Public procedure
    80    !
    81    public :: SurfaceFluxUtilLimitFlux
    82    public :: SurfaceFluxUtilInit
    83  
    84    ! 公開変数
    85    ! Public variables
    86    !
    87  
    88    ! 非公開変数
    89    ! Private variables
    90    !
    91    logical, save :: surface_flux_util_inited = .false.
    92                                ! 初期設定フラグ.
    93                                ! Initialization flag
    94  
    95    character(*), parameter:: module_name = 'surface_flux_util'
    96                                ! モジュールの名称.
    97                                ! Module name
    98    character(*), parameter:: version = &
    99      & '$Name:  $' // &
   100      & '$Id: surface_flux_util.f90,v 1.1 2013/10/06 13:44:15 yot Exp $'
   101                                ! モジュールのバージョン
   102                                ! Module version
   103  
   104  
   105  contains
   106  
   107    !--------------------------------------------------------------------------------------
   108  
   109    subroutine SurfaceFluxUtilLimitFlux( &
   110      & DelTime,                         & ! (in)
   111      & xyzf_QMix, xyr_Press,            & ! (in)
   112      & xy_SurfH2OVapFlux &!, xyf_QMixFlux  & ! (inout)
   113      & )
   114      !
   115      !
   116      !
   117      ! Restrict surface flux
   118      ! Now, only the H2O vapor flux is restricted.
   119      !
   120  
   121      ! モジュール引用 ; USE statements
   122      !
   123  
   124      ! ヒストリデータ出力
   125      ! History data output
   126      !
   127      use gtool_historyauto, only: HistoryAutoPut
   128  
   129      ! 物理定数設定
   130      ! Physical constants settings
   131      !
   132      use constants, only: &
   133        & Grav                  ! $ g $ [m s-2].
   134                                ! 重力加速度.
   135                                ! Gravitational acceleration
   136  
   137      ! 時刻管理
   138      ! Time control
   139      !
   140      use timeset, only: &
   141        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   142        & TimesetClockStart, TimesetClockStop
   143  
   144      ! デバッグ用ユーティリティ
   145      ! Utilities for debug
   146      !
   147      use dc_trace, only: DbgMessage, BeginSub, EndSub
   148  
   149      ! 宣言文 ; Declaration statements
   150      !
   151      implicit none
   152  
   153      real(DP), intent(in):: DelTime
   154                                ! Time step
   155      real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   156                                ! $ q $ .     比湿. Specific humidity
   157      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   158                                ! $ p_s $ . 地表面気圧 (半整数レベル).
   159                                ! Surface pressure (half level)
   160      real(DP), intent(inout):: xy_SurfH2OVapFlux(0:imax-1, 1:jmax)
   161                                ! 惑星表面水蒸気フラックス.
   162                                ! Water vapor flux at the surface
   163  !!$    real(DP), intent(inout):: xyf_QMixFlux(0:imax-1, 1:jmax, 1:ncmax)
   164  !!$                              ! 惑星表面比湿フラックス.
   165  !!$                              ! Specific humidity flux at surface
   166  
   167      ! 作業変数
   168      ! Work variables
   169      !
   170      real(DP):: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
   171                                !
   172                                ! Mass in each layer
   173      real(DP):: xy_ConsMass(0:imax-1, 1:jmax)
   174                                !
   175                                ! Constituent mass in each column
   176      real(DP):: xy_SurfFlux(0:imax-1, 1:jmax)
   177  
   178      integer:: i               ! 経度方向に回る DO ループ用作業変数
   179                                ! Work variables for DO loop in longitude
   180      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   181                                ! Work variables for DO loop in latitude
   182      integer:: k               ! 高度方向に回る DO ループ用作業変数
   183                                ! Work variables for DO loop in altitude
   184      integer:: n               ! 組成方向に回る DO ループ用作業変数
   185                                ! Work variables for DO loop in dimension of constituents
   186  
   187      ! 実行文 ; Executable statement
   188      !
   189  
   190      ! 初期化確認
   191      ! Initialization check
   192      !
   193      if ( .not. surface_flux_util_inited ) then
   194        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   195      end if
   196  
   197  
   198      ! 計算時間計測開始
   199      ! Start measurement of computation time
   200      !
   201      call TimesetClockStart( module_name )
   202  
   203      do k = 1, kmax
   204        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   205      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
   206  
   207  !!$    do n = 1, ncmax
   208      do n = IndexH2OVap, IndexH2OVap
   209  
   210        xy_ConsMass = 0.0_DP
   211        do k = kmax, 1, -1
   212          xy_ConsMass = xy_ConsMass + xyz_DelMass(:,:,k) * xyzf_QMix(:,:,k,n)
   213        end do
   214  
   215        if ( n == IndexH2OVap ) then
   216          xy_SurfFlux = xy_SurfH2OVapFlux
   217        else
   218  !!$        xy_SurfFlux = xyf_QMixFlux(:,:,n)
   219        end if
   220  
   221        do j = 1, jmax
   222          do i = 0, imax-1
   223            if ( - xy_SurfFlux(i,j) * DelTime > xy_ConsMass(i,j) ) then
   224              xy_SurfFlux(i,j) = - xy_ConsMass(i,j) / DelTime !&
   225  !!$              & * ( 1.0_DP - 1.0d-15 )
   226            end if
   227          end do
   228        end do
   229  
   230        if ( n == IndexH2OVap ) then
   231          xy_SurfH2OVapFlux = xy_SurfFlux
   232        else
   233  !!$        xyf_QMixFlux(:,:,n) = xy_SurfFlux
   234        end if
   235  
   236      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t206 = 1, xy_consmass.DSC.U2*xy_consmass.DSC.U1 +              
     .       1   xy_consmass.DSC.U2                                             
     .           xy_consmass(t206-1,1) = 0.0000000000000000e+000                
     .        enddo                                                             
     .        do k = kmax, 1, -1                                                
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_consmass)                                            
     .           do t212 = 1, xy_consmass.DSC.U2*xy_consmass.DSC.U1 +           
     .       1      xy_consmass.DSC.U2                                          
     .              xy_consmass(t212-1,1) = xy_consmass(t212-1,1) + xyz_delmass(
     .       1         t212-1,1,k)*xyzf_qmix(t212-1,1,k,indexh2ovap)            
     .           enddo                                                          
     .        enddo                                                             
     .        if (indexh2ovap .ne. indexh2ovap) goto 31051                      
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t232 = 1, xy_surfflux.DSC.U2*xy_surfflux.DSC.U1 +              
     .       1   xy_surfflux.DSC.U2                                             
     .           xy_surfflux(t232-1,1) = xy_surfh2ovapflux(t232-1,1)            
     .        enddo                                                             
     .  31051 continue                                                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_consmass)                                               
     .        do j = 1, jmax*imax                                               
     .           if ((-xy_surfflux(j-1,1)*deltime) .gt. xy_consmass(j-1,1)) then
     .              xy_surfflux(j-1,1) = -xy_consmass(j-1,1)/deltime            
     .           endif                                                          
     .        enddo                                                             
     .        if (indexh2ovap .ne. indexh2ovap) goto 31052                      
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t224 = 1, jmax*imax                                            
     .           xy_surfh2ovapflux(t224-1,1) = xy_surfflux(t224-1,1)            
     .        enddo                                                             
     .  31052 continue                                                          
   237  
   238  
   239      ! 計算時間計測一時停止
   240      ! Pause measurement of computation time
   241      !
   242      call TimesetClockStop( module_name )
   243  
   244    end subroutine SurfaceFluxUtilLimitFlux
   245  
   246    !--------------------------------------------------------------------------------------
   247  
   248    subroutine SurfaceFluxUtilInit
   249      !
   250      ! surface_flux_util モジュールの初期化を行います.
   251      ! NAMELIST#surface_flux_util_nml の読み込みはこの手続きで行われます.
   252      !
   253      ! "surface_flux_util" module is initialized.
   254      ! "NAMELIST#surface_flux_util_nml" is loaded in this procedure.
   255      !
   256  
   257      ! モジュール引用 ; USE statements
   258      !
   259  
   260      ! NAMELIST ファイル入力に関するユーティリティ
   261      ! Utilities for NAMELIST file input
   262      !
   263      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   264  
   265      ! ファイル入出力補助
   266      ! File I/O support
   267      !
   268      use dc_iounit, only: FileOpen
   269  
   270      ! 種別型パラメタ
   271      ! Kind type parameter
   272      !
   273      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   274  
   275      ! 文字列操作
   276      ! Character handling
   277      !
   278      use dc_string, only: StoA
   279  
   280      ! ヒストリデータ出力
   281      ! History data output
   282      !
   283      use gtool_historyauto, only: HistoryAutoAddVariable
   284  
   285      ! 座標データ設定
   286      ! Axes data settings
   287      !
   288      use axesset, only: &
   289        & AxnameX, &
   290        & AxnameY, &
   291        & AxnameZ, &
   292        & AxnameR, &
   293        & AxnameT
   294  
   295      ! 宣言文 ; Declaration statements
   296      !
   297      implicit none
   298  
   299  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   300  !!$                              ! Unit number for NAMELIST file open
   301  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   302  !!$                              ! IOSTAT of NAMELIST read
   303  
   304      ! NAMELIST 変数群
   305      ! NAMELIST group name
   306      !
   307  !!$    namelist /surface_flux_util_nml/                                  &
   308  !!$      & FlagConstBulkCoef
   309            !
   310            ! デフォルト値については初期化手続 "surface_flux_util#SurfaceFluxUtilInit"
   311            ! のソースコードを参照のこと.
   312            !
   313            ! Refer to source codes in the initialization procedure
   314            ! "surface_flux_bulk#SurfaceFluxInit" for the default values.
   315            !
   316  
   317      ! 実行文 ; Executable statement
   318      !
   319  
   320      if ( surface_flux_util_inited ) return
   321  
   322  
   323      ! デフォルト値の設定
   324      ! Default values settings
   325      !
   326  
   327      ! NAMELIST の読み込み
   328      ! NAMELIST is input
   329      !
   330  !!$    if ( trim(namelist_filename) /= '' ) then
   331  !!$      call FileOpen( unit_nml, &          ! (out)
   332  !!$        & namelist_filename, mode = 'r' ) ! (in)
   333  !!$
   334  !!$      rewind( unit_nml )
   335  !!$      read( unit_nml, &                ! (in)
   336  !!$        & nml = surface_flux_util_nml, &  ! (out)
   337  !!$        & iostat = iostat_nml )        ! (out)
   338  !!$      close( unit_nml )
   339  !!$
   340  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   341  !!$    end if
   342  
   343  
   344      ! 印字 ; Print
   345      !
   346      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   347  
   348  !!$    call MessageNotify( 'M', module_name, '  VelMinForRi       = %f', d = (/ VelMinForRi   /) )
   349      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   350  
   351      surface_flux_util_inited = .true.
   352  
   353    end subroutine SurfaceFluxUtilInit
   354  
   355    !--------------------------------------------------------------------------------------
   356  
   357  end module surface_flux_util
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:06 2016
FILE NAME: surface_flux_util.f90
PROGRAM NAME: surface_flux_util
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地表面フラックスユーティリティ
     2:             !
     3:             != Surface flux utility routines
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: surface_flux_util.f90,v 1.1 2013/10/06 13:44:15 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module surface_flux_util
    13:               !
    14:               != 地表面フラックスユーティリティ
    15:               !
    16:               != Surface flux utility routines
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 地表面フラックスを計算. 
    21:               !
    22:               ! Surface fluxes are calculated.
    23:               !
    24:               !== References
    25:               !
    26:             !!$  ! Louis, J-F., M. Tiedtke, and J-F. Geleyn, 
    27:             !!$  ! A short history of the PBL parameterization at ECMWF, 
    28:             !!$  ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K., 
    29:             !!$  ! 1982.
    30:               !
    31:               !== Procedures List
    32:               !
    33:             !!$  ! SurfaceFlux       :: 地表面フラックスの計算
    34:             !!$  ! ------------      :: ------------
    35:             !!$  ! SurfaceFlux       :: Calculate surface fluxes
    36:               !
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#surface_flux_util_nml
    40:               !
    41:             
    42:               ! モジュール引用 ; USE statements
    43:               !
    44:             
    45:               ! 格子点設定
    46:               ! Grid points settings
    47:               !
    48:               use gridset, only: imax, & ! 経度格子点数. 
    49:                                          ! Number of grid points in longitude
    50:                 &                jmax, & ! 緯度格子点数. 
    51:                                          ! Number of grid points in latitude
    52:                 &                kmax    ! 鉛直層数. 
    53:                                          ! Number of vertical level
    54:             
    55:               ! 組成に関わる配列の設定
    56:               ! Settings of array for atmospheric composition
    57:               !
    58:               use composition, only: &
    59:                 & ncmax, &
    60:                 & IndexH2OVap
    61:             
    62:               ! 種別型パラメタ
    63:               ! Kind type parameter
    64:               !
    65:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    66:                 &                 STRING     ! 文字列.       Strings. 
    67:             
    68:               ! メッセージ出力
    69:               ! Message output
    70:               !
    71:               use dc_message, only: MessageNotify
    72:             
    73:               ! 宣言文 ; Declaration statements
    74:               !
    75:               implicit none
    76:               private
    77:             
    78:               ! 公開手続き
    79:               ! Public procedure
    80:               !
    81:               public :: SurfaceFluxUtilLimitFlux
    82:               public :: SurfaceFluxUtilInit
    83:             
    84:               ! 公開変数
    85:               ! Public variables
    86:               !
    87:             
    88:               ! 非公開変数
    89:               ! Private variables
    90:               !
    91:               logical, save :: surface_flux_util_inited = .false.
    92:                                           ! 初期設定フラグ. 
    93:                                           ! Initialization flag
    94:             
    95:               character(*), parameter:: module_name = 'surface_flux_util'
    96:                                           ! モジュールの名称. 
    97:                                           ! Module name
    98:               character(*), parameter:: version = &
    99:                 & '$Name:  $' // &
   100:                 & '$Id: surface_flux_util.f90,v 1.1 2013/10/06 13:44:15 yot Exp $'
   101:                                           ! モジュールのバージョン
   102:                                           ! Module version
   103:             
   104:             
   105:             contains
   106:             
   107:               !--------------------------------------------------------------------------------------
   108:             
   109:               subroutine SurfaceFluxUtilLimitFlux( &
   110:                 & DelTime,                         & ! (in)
   111:                 & xyzf_QMix, xyr_Press,            & ! (in)
   112:                 & xy_SurfH2OVapFlux &!, xyf_QMixFlux  & ! (inout)
   113:                 & )
   114:                 !
   115:                 ! 
   116:                 !
   117:                 ! Restrict surface flux 
   118:                 ! Now, only the H2O vapor flux is restricted.
   119:                 !
   120:             
   121:                 ! モジュール引用 ; USE statements
   122:                 !
   123:             
   124:                 ! ヒストリデータ出力
   125:                 ! History data output
   126:                 !
   127:                 use gtool_historyauto, only: HistoryAutoPut
   128:             
   129:                 ! 物理定数設定
   130:                 ! Physical constants settings
   131:                 !
   132:                 use constants, only: &
   133:                   & Grav                  ! $ g $ [m s-2].
   134:                                           ! 重力加速度.
   135:                                           ! Gravitational acceleration
   136:             
   137:                 ! 時刻管理
   138:                 ! Time control
   139:                 !
   140:                 use timeset, only: &
   141:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   142:                   & TimesetClockStart, TimesetClockStop
   143:             
   144:                 ! デバッグ用ユーティリティ
   145:                 ! Utilities for debug
   146:                 !
   147:                 use dc_trace, only: DbgMessage, BeginSub, EndSub
   148:             
   149:                 ! 宣言文 ; Declaration statements
   150:                 !
   151:                 implicit none
   152:             
   153:                 real(DP), intent(in):: DelTime
   154:                                           ! Time step
   155:                 real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   156:                                           ! $ q $ .     比湿. Specific humidity
   157:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   158:                                           ! $ p_s $ . 地表面気圧 (半整数レベル). 
   159:                                           ! Surface pressure (half level)
   160:                 real(DP), intent(inout):: xy_SurfH2OVapFlux(0:imax-1, 1:jmax)
   161:                                           ! 惑星表面水蒸気フラックス.
   162:                                           ! Water vapor flux at the surface
   163:             !!$    real(DP), intent(inout):: xyf_QMixFlux(0:imax-1, 1:jmax, 1:ncmax)
   164:             !!$                              ! 惑星表面比湿フラックス. 
   165:             !!$                              ! Specific humidity flux at surface
   166:             
   167:                 ! 作業変数
   168:                 ! Work variables
   169:                 !
   170:                 real(DP):: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
   171:                                           ! 
   172:                                           ! Mass in each layer
   173:                 real(DP):: xy_ConsMass(0:imax-1, 1:jmax)
   174:                                           ! 
   175:                                           ! Constituent mass in each column
   176:                 real(DP):: xy_SurfFlux(0:imax-1, 1:jmax)
   177:             
   178:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   179:                                           ! Work variables for DO loop in longitude
   180:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   181:                                           ! Work variables for DO loop in latitude
   182:                 integer:: k               ! 高度方向に回る DO ループ用作業変数
   183:                                           ! Work variables for DO loop in altitude
   184:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   185:                                           ! Work variables for DO loop in dimension of constituents
   186:             
   187:                 ! 実行文 ; Executable statement
   188:                 !
   189:             
   190:                 ! 初期化確認
   191:                 ! Initialization check
   192:                 !
   193:                 if ( .not. surface_flux_util_inited ) then
   194:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   195:                 end if
   196:             
   197:             
   198:                 ! 計算時間計測開始
   199:                 ! Start measurement of computation time
   200:                 !
   201:                 call TimesetClockStart( module_name )
   202:             
   203: W------>        do k = 1, kmax
   204: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   205: W------         end do
   206:             
   207:             !!$    do n = 1, ncmax
   208: *------>        do n = IndexH2OVap, IndexH2OVap
   209: |           
   210: |W*====           xy_ConsMass = 0.0_DP
   211: |+----->          do k = kmax, 1, -1
   212: ||W*=== A           xy_ConsMass = xy_ConsMass + xyz_DelMass(:,:,k) * xyzf_QMix(:,:,k,n)
   213: |+-----           end do
   214: |           
   215: |                 if ( n == IndexH2OVap ) then
   216: |W*==== A           xy_SurfFlux = xy_SurfH2OVapFlux
   217: |                 else
   218: |           !!$        xy_SurfFlux = xyf_QMixFlux(:,:,n)
   219: |                 end if
   220: |           
   221: |W----->          do j = 1, jmax
   222: ||*---->            do i = 0, imax-1
   223: |||     A             if ( - xy_SurfFlux(i,j) * DelTime > xy_ConsMass(i,j) ) then
   224: |||                     xy_SurfFlux(i,j) = - xy_ConsMass(i,j) / DelTime !&
   225: |||         !!$              & * ( 1.0_DP - 1.0d-15 )
   226: |||                   end if
   227: ||*----             end do
   228: |W-----           end do
   229: |           
   230: |                 if ( n == IndexH2OVap ) then
   231: |W*==== A           xy_SurfH2OVapFlux = xy_SurfFlux
   232: |                 else
   233: |           !!$        xyf_QMixFlux(:,:,n) = xy_SurfFlux
   234: |                 end if
   235: |           
   236: *------         end do
   237:             
   238:             
   239:                 ! 計算時間計測一時停止
   240:                 ! Pause measurement of computation time
   241:                 !
   242:                 call TimesetClockStop( module_name )
   243:             
   244:               end subroutine SurfaceFluxUtilLimitFlux
   245:             
   246:               !--------------------------------------------------------------------------------------
   247:             
   248:               subroutine SurfaceFluxUtilInit
   249:                 !
   250:                 ! surface_flux_util モジュールの初期化を行います. 
   251:                 ! NAMELIST#surface_flux_util_nml の読み込みはこの手続きで行われます. 
   252:                 !
   253:                 ! "surface_flux_util" module is initialized. 
   254:                 ! "NAMELIST#surface_flux_util_nml" is loaded in this procedure. 
   255:                 !
   256:             
   257:                 ! モジュール引用 ; USE statements
   258:                 !
   259:             
   260:                 ! NAMELIST ファイル入力に関するユーティリティ
   261:                 ! Utilities for NAMELIST file input
   262:                 !
   263:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   264:             
   265:                 ! ファイル入出力補助
   266:                 ! File I/O support
   267:                 !
   268:                 use dc_iounit, only: FileOpen
   269:             
   270:                 ! 種別型パラメタ
   271:                 ! Kind type parameter
   272:                 !
   273:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   274:             
   275:                 ! 文字列操作
   276:                 ! Character handling
   277:                 !
   278:                 use dc_string, only: StoA
   279:             
   280:                 ! ヒストリデータ出力
   281:                 ! History data output
   282:                 !
   283:                 use gtool_historyauto, only: HistoryAutoAddVariable
   284:             
   285:                 ! 座標データ設定
   286:                 ! Axes data settings
   287:                 !
   288:                 use axesset, only: &
   289:                   & AxnameX, &
   290:                   & AxnameY, &
   291:                   & AxnameZ, &
   292:                   & AxnameR, &
   293:                   & AxnameT
   294:             
   295:                 ! 宣言文 ; Declaration statements
   296:                 !
   297:                 implicit none
   298:             
   299:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   300:             !!$                              ! Unit number for NAMELIST file open
   301:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   302:             !!$                              ! IOSTAT of NAMELIST read
   303:             
   304:                 ! NAMELIST 変数群
   305:                 ! NAMELIST group name
   306:                 !
   307:             !!$    namelist /surface_flux_util_nml/                                  &
   308:             !!$      & FlagConstBulkCoef
   309:                       !
   310:                       ! デフォルト値については初期化手続 "surface_flux_util#SurfaceFluxUtilInit" 
   311:                       ! のソースコードを参照のこと. 
   312:                       !
   313:                       ! Refer to source codes in the initialization procedure
   314:                       ! "surface_flux_bulk#SurfaceFluxInit" for the default values. 
   315:                       !
   316:             
   317:                 ! 実行文 ; Executable statement
   318:                 !
   319:             
   320:                 if ( surface_flux_util_inited ) return
   321:             
   322:             
   323:                 ! デフォルト値の設定
   324:                 ! Default values settings
   325:                 !
   326:             
   327:                 ! NAMELIST の読み込み
   328:                 ! NAMELIST is input
   329:                 !
   330:             !!$    if ( trim(namelist_filename) /= '' ) then
   331:             !!$      call FileOpen( unit_nml, &          ! (out)
   332:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   333:             !!$
   334:             !!$      rewind( unit_nml )
   335:             !!$      read( unit_nml, &                ! (in)
   336:             !!$        & nml = surface_flux_util_nml, &  ! (out)
   337:             !!$        & iostat = iostat_nml )        ! (out)
   338:             !!$      close( unit_nml )
   339:             !!$
   340:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   341:             !!$    end if
   342:             
   343:             
   344:                 ! 印字 ; Print
   345:                 !
   346:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   347:             
   348:             !!$    call MessageNotify( 'M', module_name, '  VelMinForRi       = %f', d = (/ VelMinForRi   /) )
   349:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   350:             
   351:                 surface_flux_util_inited = .true.
   352:             
   353:               end subroutine SurfaceFluxUtilInit
   354:             
   355:               !--------------------------------------------------------------------------------------
   356:             
   357:             end module surface_flux_util
