Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: adv_test.f90
PROGRAM NAME: adv_test
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   175  opt  (1592): Outer loop unrolled inside inner loop.
   176  opt  (1590): Inner loop moved outside outer loop(s).
   177  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   177  vec  (   1): Vectorized loop.
   177  vec  (  29): ADB is used for array.: xyz_vn
   177  vec  (  29): ADB is used for array.: xyz_un
   177  vec  (  29): ADB is used for array.: x_lon
   177  vec  (   1): Vectorized loop.
   177  vec  (  29): ADB is used for array.: xyz_vn
   177  vec  (  29): ADB is used for array.: xyz_un
   177  vec  (  29): ADB is used for array.: x_lon
   188  vec  (   1): Vectorized loop.
   188  vec  (  29): ADB is used for array.: xyz_vn
   188  vec  (  29): ADB is used for array.: xyz_un
   327  opt  (1593): Loop nest collapsed into one loop.
   327  vec  (   1): Vectorized loop.
   327  vec  (  29): ADB is used for array.: xyr_sigdotn
   335  opt  (1592): Outer loop unrolled inside inner loop.
   335  vec  (   4): Vectorized array expression.
   335  vec  (  29): ADB is used for array.: xyr_streamfunc
   335  vec  (   4): Vectorized array expression.
   335  vec  (  29): ADB is used for array.: xyr_streamfunc
   342  vec  (   1): Vectorized loop.
   342  vec  (  29): ADB is used for array.: xyr_streamfunc
   342  vec  (  29): ADB is used for array.: xyr_sigdotn
   424  opt  (  11): Fused array assignments. :line 424 - 425
   424  opt  (1592): Outer loop unrolled inside inner loop.
   424  vec  (   4): Vectorized array expression.
   424  vec  (  29): ADB is used for array.: xyr_sigdotn
   424  vec  (   4): Vectorized array expression.
   424  vec  (  29): ADB is used for array.: xyr_sigdotn
   431  opt  (1593): Loop nest collapsed into one loop.
   431  vec  (   4): Vectorized array expression.
   431  vec  (  29): ADB is used for array.: xyr_streamfunc
   518  opt  (1593): Loop nest collapsed into one loop.
   518  vec  (   4): Vectorized array expression.
   518  vec  (  29): ADB is used for array.: xyz_qvap
   519  opt  (1593): Loop nest collapsed into one loop.
   519  vec  (   4): Vectorized array expression.
   519  vec  (  29): ADB is used for array.: xy_surfheight
   551  opt  (1592): Outer loop unrolled inside inner loop.
   552  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   552  vec  (   1): Vectorized loop.
   552  vec  (  29): ADB is used for array.: d3
   552  vec  (  29): ADB is used for array.: x_lon
   552  vec  (   1): Vectorized loop.
   552  vec  (  29): ADB is used for array.: d3
   552  vec  (   1): Vectorized loop.
   552  vec  (  29): ADB is used for array.: d3
   560  opt  (1593): Loop nest collapsed into one loop.
   560  vec  (   4): Vectorized array expression.
   560  vec  (  29): ADB is used for array.: xyz_height
   563  opt  (1593): Loop nest collapsed into one loop.
   563  vec  (   1): Vectorized loop.
   563  vec  (  29): ADB is used for array.: xyzf_qmix
   563  vec  (   1): Vectorized loop.
   563  vec  (  29): ADB is used for array.: xyzf_qmix
   563  vec  (  29): ADB is used for array.: xyz_verdist
   563  vec  (  29): ADB is used for array.: xyz_hordist
   565  vec  (   1): Vectorized loop.
   565  vec  (  29): ADB is used for array.: xyzf_qmix
   565  vec  (  29): ADB is used for array.: xyz_height
   565  vec  (  29): ADB is used for array.: xyz_verdist
   565  vec  (  29): ADB is used for array.: xyz_hordist
   598  opt  (1593): Loop nest collapsed into one loop.
   598  vec  (   4): Vectorized array expression.
   598  vec  (  29): ADB is used for array.: xyz_height
   601  opt  (1593): Loop nest collapsed into one loop.
   601  vec  (   1): Vectorized loop.
   601  vec  (  29): ADB is used for array.: xyzf_qmix
   601  vec  (  29): ADB is used for array.: xyz_verdist
   601  vec  (  29): ADB is used for array.: xyz_height
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: adv_test.f90
PROGRAM NAME: adv_test
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Utility module for advection test
     4  !
     5  ! Authors::   Hiroki Kashimura, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module adv_test
    13    !
    14    !=
    15    !
    16    != Utility module for advection test
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20  
    21    !== References
    22    !
    23  !!$  !  Chou, M.-D.,
    24  !!$  !    Atmospheric solar heating rate in the water vapor bands,
    25  !!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
    26    !
    27    !== Procedures List
    28    !
    29  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    30  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    31  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    32  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    33  !!$  ! ------------            :: ------------
    34  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    35  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    36  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    37  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    38    !
    39    !== NAMELIST
    40    !
    41    ! NAMELIST#set_1d_profile_nml
    42    !
    43  
    44    ! USE statements
    45    !
    46  
    47    !
    48    ! Kind type parameter
    49    !
    50    use dc_types, only: DP, &      ! Double precision.
    51      &                 STRING, &  ! Strings.
    52      &                 TOKEN      ! Keywords.
    53  
    54    ! 格子点設定
    55    ! Grid points settings
    56    !
    57    use gridset, only: imax, & ! 経度格子点数.
    58                               ! Number of grid points in longitude
    59      &                jmax, & ! 緯度格子点数.
    60                               ! Number of grid points in latitude
    61      &                kmax    ! 鉛直層数.
    62                               ! Number of vertical level
    63  
    64    ! 組成に関わる配列の設定
    65    ! Settings of array for atmospheric composition
    66    !
    67    use composition, only:                              &
    68      &                    ncmax
    69                                 ! 成分の数
    70                                 ! Number of composition
    71  
    72    ! メッセージ出力
    73    ! Message output
    74    !
    75    use dc_message, only: MessageNotify
    76  
    77    use constants0, only : PI
    78  
    79    implicit none
    80  
    81    private
    82  
    83    ! 公開変数
    84    ! Public variables
    85    !
    86    logical, save, public:: adv_test_inited = .false.
    87                                ! 初期設定フラグ.
    88                                ! Initialization flag
    89  
    90    integer, save      :: IDVelDist
    91    integer, parameter :: IDVelDistNCARASPSummerCol = 1
    92    integer, parameter :: IDVelDistSymHadley        = 2
    93    integer, parameter :: IDVelDistAsymHadley       = 3
    94  
    95    real(DP), save :: Alpha
    96    real(DP), save :: Tau
    97    real(DP), save :: Press0
    98    real(DP), save :: Omega0
    99    real(DP), save :: HCSigmaTop
   100    integer , save :: HCNumCell    ! Number of Hadley cell in each hemisphere
   101    real(DP), save :: HCV0
   102  
   103  
   104    public :: AdvTestSetHorVels
   105    public :: AdvTestSetVerVel
   106    public :: AdvTestSetICs
   107    public :: AdvTestInit
   108  
   109  
   110    character(*), parameter:: module_name = 'adv_test'
   111                                ! モジュールの名称.
   112                                ! Module name
   113    character(*), parameter:: version = &
   114      & '$Name:  $' // &
   115      & '$Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $'
   116                                ! モジュールのバージョン
   117                                ! Module version
   118  
   119  
   120    !--------------------------------------------------------------------------------------
   121  
   122  contains
   123  
   124    !--------------------------------------------------------------------------------------
   125  
   126    subroutine AdvTestSetHorVels(   &
   127      & xyz_UN, xyz_VN              & ! (out)
   128      & )
   129      !-------セミラグのテスト用の流速分布を与える--------
   130      !Gives a velocity for Test. Only used for debug.
   131  
   132      use timeset, only: &
   133        & DelTime, &            ! $ \Delta t $ [s]
   134        & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $.
   135      use axesset   , only : x_Lon, y_Lat, z_Sigma, r_Sigma
   136      use constants , only: RPlanet, &
   137                                ! $ a $ [m].
   138                                ! 惑星半径.
   139                                ! Radius of planet
   140        &                   Grav
   141  
   142      real(DP), intent(out) :: xyz_UN     (0:imax-1, 1:jmax, 1:kmax)
   143                                ! 東西風速
   144                                ! Zonal Wind
   145      real(DP), intent(out) :: xyz_VN     (0:imax-1, 1:jmax, 1:kmax)
   146                                ! 南北風速
   147                                ! Meridional Wind
   148  
   149      ! 作業変数
   150      ! Work variables
   151      !
   152      real(DP) :: U0
   153      real(DP) :: Time
   154      real(DP) :: StreamFunc
   155  
   156      integer:: i               ! 東西方向に回る DO ループ用作業変数
   157                                ! Work variables for DO loop in zonal direction
   158      integer:: j               ! 南北方向に回る DO ループ用作業変数
   159                                ! Work variables for DO loop in meridional direction
   160      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   161                                ! Work variables for DO loop in vertical direction
   162  
   163      ! 初期化確認
   164      ! Initialization check
   165      !
   166      if ( .not. adv_test_inited ) then
   167        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   168      end if
   169  
   170  
   171      select case ( IDVelDist )
   172      case ( IDVelDistNCARASPSummerCol )
   173        ! 水平流速分布を与える
   174        U0 = 2.0_DP * PI * RPlanet / ( 86400.0_DP * 12.0_DP )
   175        do k = 1, kmax
   176          do j = 1, jmax
   177            do i = 0, imax-1
   178              xyz_UN(i,j,k) = &
   179                &   U0 * ( cos( y_Lat(j) ) * cos( Alpha ) + cos( x_Lon(i) ) * sin( y_Lat(j) ) * sin( Alpha ) )
   180              xyz_VN(i,j,k) = &
   181                & - U0 * ( sin( x_Lon(i) ) * sin( Alpha ) )
   182            end do
   183          end do
   184        end do
     .  !cdir noassume                                                          
     .        do i1 = 0, imax - 1, maxvl()                                      
     .           i2 = min0(imax - i1,maxvl())                                   
     .           do j = 1, jmax                                                 
     .              if (kmax .gt. 0) then                                       
     .                 j3 = and(kmax,3)                                         
     .                 do k = 1, j3                                             
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(x_lon)                                         
     .                    do i = 1, i2                                          
     .                       xyz_un(i1+i-1,j,k) = u0*(dcos(y_lat(j))*dcos(alpha)
     .       1                  +dcos(x_lon(i1+i-1))*dsin(y_lat(j))*(dsin(alpha)
     .       2                  ))                                              
     .                       xyz_vn(i1+i-1,j,k) = -u0*dsin(x_lon(i1+i-1))*(dsin(
     .       1                  alpha))                                         
     .                    enddo                                                 
     .                 enddo                                                    
     .                 do k = j3 + 1, kmax, 4                                   
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(x_lon)                                         
     .                    do i = 1, i2                                          
     .                       d2 = x_lon(i1+i-1)                                 
     .                       d1 = y_lat(j)                                      
     .                       xyz_un(i1+i-1,j,k) = (u0*(((dcos(d1))*(dcos(alpha))
     .       1                  ) + (((dcos(d2))*(dsin(d1)))*(dsin(alpha)))))   
     .                       xyz_un(i1+i-1,j,k+1) = (u0*(((dcos(d1))*(dcos(alpha
     .       1                  ))) + (((dcos(d2))*(dsin(d1)))*(dsin(alpha))))) 
     .                       xyz_un(i1+i-1,j,k+2) = (u0*(((dcos(d1))*(dcos(alpha
     .       1                  ))) + (((dcos(d2))*(dsin(d1)))*(dsin(alpha))))) 
     .                       xyz_un(i1+i-1,j,k+3) = (u0*(((dcos(d1))*(dcos(alpha
     .       1                  ))) + (((dcos(d2))*(dsin(d1)))*(dsin(alpha))))) 
     .                       xyz_vn(i1+i-1,j,k) = -(u0*((dsin(d2))*(dsin(alpha))
     .       1                  ))                                              
     .                       xyz_vn(i1+i-1,j,k+1) = -(u0*((dsin(d2))*(dsin(alpha
     .       1                  ))))                                            
     .                       xyz_vn(i1+i-1,j,k+2) = -(u0*((dsin(d2))*(dsin(alpha
     .       1                  ))))                                            
     .                       xyz_vn(i1+i-1,j,k+3) = -(u0*((dsin(d2))*(dsin(alpha
     .       1                  ))))                                            
     .                    enddo                                                 
     .                 enddo                                                    
     .              endif                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        goto 10004                                                        
   185      case ( IDVelDistSymHadley )
   186        do k = 1, kmax
   187          do j = 1, jmax
   188            do i = 0, imax-1
   189  
   190              if ( z_Sigma(k) < HCSigmaTop ) then
   191                StreamFunc = 0.0_DP
   192  
   193                xyz_UN(i,j,k) = 0.0_DP
   194                xyz_VN(i,j,k) = 0.0_DP
   195              else
   196  
   197  !!$                StreamFunc = &
   198  !!$                  & StreamFunc0 &
   199  !!$                  & * sin( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   200  !!$                  & * sin( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   201  !!$
   202  !!$                xyz_UN(i,j,k) = 0.0_DP
   203  !!$                xyz_VN(i,j,k) =                                                 &
   204  !!$                  & StreamFunc0 * Grav / Press0                                 &
   205  !!$                  & * sin( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   206  !!$                  & * PI/(r_Sigma(0)-HCSigmaTop)                                &
   207  !!$                  & * cos( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   208  
   209                Time = TimeN
   210  
   211  !!$                StreamFunc = &
   212  !!$                  & StreamFunc0 &
   213  !!$                  & * sin( HCNumCell * y_Lat(j) ) &
   214  !!$                  & * sin( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   215  !!$
   216  !!$                xyz_UN(i,j,k) = 0.0_DP
   217  !!$                xyz_VN(i,j,k) =                                               &
   218  !!$                  & StreamFunc0 * Grav / Press0                               &
   219  !!$                  & * sin( HCNumCell * y_Lat(j) )                             &
   220  !!$                  & * PI/(r_Sigma(0)-HCSigmaTop)                              &
   221  !!$                  & * cos( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   222  !!$                  & * cos( PI * Time / Tau )
   223  
   224  !!$              StreamFunc = &
   225  !!$                &   PI * RPlanet**2 * Press0 / Grav * SigDot0         &
   226  !!$                &   * (   sin( dble( 2 * HCNumCell + 1 ) * y_Lat(j) ) &
   227  !!$                &           / dble( 2 * HCNumCell + 1 )               &
   228  !!$                &       + sin( dble( 2 * HCNumCell - 1 ) * y_Lat(j) ) &
   229  !!$                &           / dble( 2 * HCNumCell - 1 ) )             &
   230  !!$                &   * sin( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   231  !!$                &   * cos( PI * Time / Tau )
   232  !!$
   233  !!$              xyz_UN(i,j,k) = 0.0_DP
   234  !!$              xyz_VN(i,j,k) =                                              &
   235  !!$                & - RPlanet / ( 2.0_DP * cos( y_Lat(j) ) ) * SigDot0       &
   236  !!$                &   * PI/(r_Sigma(0)-HCSigmaTop)                           &
   237  !!$                &   * (   sin( dble( 2 * HCNumCell + 1 ) * y_Lat(j) ) &
   238  !!$                &           / dble( 2 * HCNumCell + 1 )               &
   239  !!$                &       + sin( dble( 2 * HCNumCell - 1 ) * y_Lat(j) ) &
   240  !!$                &           / dble( 2 * HCNumCell - 1 ) )             &
   241  !!$                & * cos( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   242  !!$                & * cos( PI * Time / Tau )
   243  
   244                StreamFunc =                                            &
   245                  & - 2.0_DP * PI * RPlanet                             &
   246                  &   * (r_Sigma(0)-HCSigmaTop) / PI                    &
   247                  &   * Press0 / Grav * HCV0                            &
   248                  &   * sin( dble( 2 * HCNumCell ) * y_Lat(j) )         &
   249                  &   * cos( y_Lat(j) )**2                              &
   250                  &   * sin( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   251                  &   * cos( PI * Time / Tau )
   252  
   253                xyz_UN(i,j,k) = 0.0_DP
   254                xyz_VN(i,j,k) =                                              &
   255                  &   HCV0                                                   &
   256                  &   * sin( dble( 2 * HCNumCell ) * y_Lat(j) )              &
   257                  &   * cos( y_Lat(j) )                                      &
   258                  &   * cos( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   259                  &   * cos( PI * Time / Tau )
   260  
   261              end if
   262  
   263            end do
     .  !cdir nodep                                                             
     .        do i = 1, imax                                                    
     .           if (z_sigma(k) .lt. hcsigmatop) then                           
     .              streamfunc = 0.0000000000000000e+000                        
     .              xyz_un(i-1,j,k) = 0.0000000000000000e+000                   
     .              xyz_vn(i-1,j,k) = 0.0000000000000000e+000                   
     .           else                                                           
     .              time = timen                                                
     .              streamfunc = -6.28318530717958e+000*rplanet*(r_sigma(0)-    
     .       1         hcsigmatop)/3.14159265358979e+000*press0/grav*hcv0*(dsin(
     .       2         ((dfloat((2*hcnumcell)))*y_lat(j))))*(dcos(y_lat(j)))**2*
     .       3         dsin((((z_sigma(k)-hcsigmatop)/(r_sigma(0)-hcsigmatop))* 
     .       4         3.14159265358979e+000))*(dcos(((3.14159265358979e+000*   
     .       5         time)/tau)))                                             
     .              xyz_un(i-1,j,k) = 0.0000000000000000e+000                   
     .              xyz_vn(i-1,j,k) = hcv0*(dsin(((dfloat((2*hcnumcell)))*y_lat(
     .       1         j))))*(dcos(y_lat(j)))*dcos((((z_sigma(k)-hcsigmatop)/(  
     .       2         r_sigma(0)-hcsigmatop))*3.14159265358979e+000))*(dcos((( 
     .       3         3.14159265358979e+000*time)/tau)))                       
     .           endif                                                          
     .        enddo                                                             
   264          end do
   265        end do
   266      case ( IDVelDistAsymHadley )
   267      end select
   268  
   269  
   270    end subroutine AdvTestSetHorVels
   271  
   272    !--------------------------------------------------------------------------------------
   273  
   274    subroutine AdvTestSetVerVel( &
   275      & xyr_SigDotN,             & ! (out)
   276      & xyr_StreamFunc           & ! (out) optional
   277      & )
   278      !-------セミラグのテスト用の流速分布を与える--------
   279      !Gives a velocity for Test. Only used for debug.
   280  
   281      use axesset, only : y_Lat, r_Sigma
   282  
   283      use timeset, only: &
   284        & DelTime, &            ! $ \Delta t $ [s]
   285        & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $.
   286  
   287      use constants , only: RPlanet, &
   288                                ! $ a $ [m].
   289                                ! 惑星半径.
   290                                ! Radius of planet
   291        &                   Grav
   292  
   293      real(DP), intent(out) :: xyr_SigDotN(0:imax-1, 1:jmax, 0:kmax)
   294                                ! 鉛直流速（SigmaDot）
   295      real(DP), intent(out), optional :: xyr_StreamFunc(0:imax-1, 1:jmax, 0:kmax)
   296  
   297      ! 作業変数
   298      ! Work variables
   299      !
   300      real(DP) :: Time
   301      real(DP) :: Shape
   302      real(DP) :: StreamFunc
   303  
   304      integer:: i               ! 東西方向に回る DO ループ用作業変数
   305                                ! Work variables for DO loop in zonal direction
   306      integer:: j               ! 南北方向に回る DO ループ用作業変数
   307                                ! Work variables for DO loop in meridional direction
   308      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   309                                ! Work variables for DO loop in vertical direction
   310  
   311      ! 初期化確認
   312      ! Initialization check
   313      !
   314      if ( .not. adv_test_inited ) then
   315        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   316      end if
   317  
   318  
   319      select case ( IDVelDist )
   320      case ( IDVelDistNCARASPSummerCol )
   321        !鉛直流速分布を与える
   322        Time = TimeN
   323        do k = 0, kmax
   324          Shape = min( 1.0_DP, &
   325            &          2.0_DP * sqrt( sin( (r_Sigma(k)-r_Sigma(kmax))/(r_Sigma(0)-r_Sigma(kmax)) * PI ) ) &
   326            &        )
   327          do j = 1, jmax
   328            do i = 0, imax-1
   329              xyr_SigDotN(i,j,k) = Omega0 / Press0 * cos( 2.0_DP*PI/Tau*Time )*sin( Shape*PI/2.0_DP )
   330            end do
   331          end do
     .        d1 = 1.D0/press0                                                  
     .        d2 = 1.D0/tau                                                     
     .        d3 = shape/2.00000000000000e+000                                  
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_sigdotn(j-1,1,k) = omega0*d1*dcos(6.28318530717958e+000*d2*
     .       1      time)*dsin(3.14159265358979e+000*d3)                        
     .        enddo                                                             
   332        end do
   333  
   334        if ( present( xyr_StreamFunc ) ) then
   335          xyr_StreamFunc = -999.0_DP
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j1 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t291 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t293 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_streamfunc(t293-1,t291,t289) = -9.99000000000000e+002
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t291 = j1 + 1, 1 + jmax - min0(1,jmax), 4                   
     .  !cdir       nodep                                                       
     .              do t293 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_streamfunc(t293-1,t291,t289) = -9.99000000000000e+002
     .                 xyr_streamfunc(t293-1,t291+1,t289) =                     
     .       1            -9.99000000000000e+002                                
     .                 xyr_streamfunc(t293-1,t291+2,t289) =                     
     .       1            -9.99000000000000e+002                                
     .                 xyr_streamfunc(t293-1,t291+3,t289) =                     
     .       1            -9.99000000000000e+002                                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   336        end if
   337  
   338      case ( IDVelDistSymHadley )
   339  
   340        do k = 0, kmax
   341          do j = 1, jmax
   342            do i = 0, imax-1
   343              if ( r_Sigma(k) < HCSigmaTop ) then
   344                StreamFunc = 0.0_DP
   345  
   346                xyr_SigDotN(i,j,k) = 0.0_DP
   347              else
   348  
   349  !!$                StreamFunc = &
   350  !!$                  & StreamFunc0 &
   351  !!$                  & * sin( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   352  !!$                  & * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   353  !!$
   354  !!$                xyr_SigDotN(i,j,k) = &
   355  !!$                  & - StreamFunc0 * Grav / Press0 / ( RPlanet * cos( y_Lat(j) ) )     &
   356  !!$                  & * (   PI / ( HCLatMax - 0.0_DP ) &
   357  !!$                  &       * cos( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   358  !!$                  &       * cos( y_Lat(j) )   &
   359  !!$                  &     -   sin( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   360  !!$                  &       * sin( y_Lat(j) ) ) &
   361  !!$                  & * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   362  
   363                Time = TimeN
   364  
   365  !!$              StreamFunc = &
   366  !!$                & StreamFunc0 &
   367  !!$                & * sin( HCNumCell * y_Lat(j) ) &
   368  !!$                & * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   369  !!$
   370  !!$              xyr_SigDotN(i,j,k) = &
   371  !!$                & - StreamFunc0 * Grav / Press0 / ( RPlanet * cos( y_Lat(j) ) ) &
   372  !!$                & * (   HCNumCell &
   373  !!$                &       * cos( HCNumCell * y_Lat(j) ) * cos( y_Lat(j) )   &
   374  !!$                &     -   sin( HCNumCell * y_Lat(j) ) * sin( y_Lat(j) ) ) &
   375  !!$                & * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   376  !!$                & * cos( PI * Time / Tau )
   377  
   378  !!$              StreamFunc = &
   379  !!$                &   PI * RPlanet**2 * Press0 / Grav * SigDot0         &
   380  !!$                &   * (   sin( dble( 2 * HCNumCell + 1 ) * y_Lat(j) ) &
   381  !!$                &           / dble( 2 * HCNumCell + 1 )               &
   382  !!$                &       + sin( dble( 2 * HCNumCell - 1 ) * y_Lat(j) ) &
   383  !!$                &           / dble( 2 * HCNumCell - 1 ) )             &
   384  !!$                &   * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   385  !!$                &   * cos( PI * Time / Tau )
   386  !!$
   387  !!$              xyr_SigDotN(i,j,k) = &
   388  !!$                &   SigDot0                                                       &
   389  !!$                &   * cos( dble( 2 * HCNumCell ) * y_Lat(j) )                     &
   390  !!$                &   * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   391  !!$                &   * cos( PI * Time / Tau )
   392  
   393                StreamFunc =                                            &
   394                  & - 2.0_DP * PI * RPlanet                             &
   395                  &   * (r_Sigma(0)-HCSigmaTop) / PI                    &
   396                  &   * Press0 / Grav * HCV0                            &
   397                  &   * sin( dble( 2 * HCNumCell ) * y_Lat(j) )         &
   398                  &   * cos( y_Lat(j) )**2                              &
   399                  &   * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   400                  &   * cos( PI * Time / Tau )
   401  
   402                xyr_SigDotN(i,j,k) = &
   403                  & - (r_Sigma(0)-HCSigmaTop) / ( PI * RPlanet )             &
   404                  &   * HCV0                                                 &
   405                  &   * (   dble( 2 * HCNumCell )                            &
   406                  &         * cos( dble( 2 * HCNumCell ) * y_Lat(j) )        &
   407                  &         * cos( y_Lat(j) )                                &
   408                  &       - 2.0_DP &
   409                  &         * sin( dble( 2 * HCNumCell ) * y_Lat(j) )        &
   410                  &         * sin( y_Lat(j) ) )                              &
   411                  &   * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   412                  &   * cos( PI * Time / Tau )
   413  
   414              end if
   415  
   416              if ( present( xyr_StreamFunc ) ) then
   417                xyr_StreamFunc(i,j,k) = StreamFunc
   418              end if
   419  
   420            end do
     .  !cdir nodep                                                             
     .        do i = 1, imax                                                    
     .           if (r_sigma(k) .lt. hcsigmatop) then                           
     .              streamfunc = 0.0000000000000000e+000                        
     .              xyr_sigdotn(i-1,j,k) = 0.0000000000000000e+000              
     .           else                                                           
     .              time = timen                                                
     .              streamfunc = -6.28318530717958e+000*rplanet*(r_sigma(0)-    
     .       1         hcsigmatop)/3.14159265358979e+000*press0/grav*hcv0*(dsin(
     .       2         ((dfloat((2*hcnumcell)))*y_lat(j))))*(dcos(y_lat(j)))**2*
     .       3         (dsin((((r_sigma(k)-hcsigmatop)/(r_sigma(0)-hcsigmatop))*
     .       4         3.14159265358979e+000)))*(dcos(((3.14159265358979e+000*  
     .       5         time)/tau)))                                             
     .              xyr_sigdotn(i-1,j,k) = -(r_sigma(0)-hcsigmatop)/(           
     .       1         3.14159265358979e+000*rplanet)*hcv0*((dfloat((2*hcnumcell
     .       2         )))*dcos(((dfloat((2*hcnumcell)))*y_lat(j)))*(dcos(y_lat(
     .       3         j)))-2.00000000000000e+000*(dsin(((dfloat((2*hcnumcell)))
     .       4         *y_lat(j))))*dsin(y_lat(j)))*(dsin((((r_sigma(k)-        
     .       5         hcsigmatop)/(r_sigma(0)-hcsigmatop))*                    
     .       6         3.14159265358979e+000)))*(dcos(((3.14159265358979e+000*  
     .       7         time)/tau)))                                             
     .           endif                                                          
     .           t239 = cvmgt(0,1,loc(xyr_streamfunc).eq.1)                     
     .           if (t239 .ne. 0) then                                          
     .              xyr_streamfunc(i-1,j,k) = streamfunc                        
     .           endif                                                          
     .        enddo                                                             
   421          end do
   422        end do
   423  
   424        xyr_SigDotN(:,:,0   ) = 0.0_DP
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t281 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t283 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_sigdotn(t283-1,t281,0) = 0.0000000000000000e+000     
     .                 xyr_sigdotn(t283-1,t281,kmax) = 0.0000000000000000e+000  
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t281 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t283 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_sigdotn(t283-1,t281,0) = 0.0000000000000000e+000     
     .                 xyr_sigdotn(t283-1,t281+1,0) = 0.0000000000000000e+000   
     .                 xyr_sigdotn(t283-1,t281+2,0) = 0.0000000000000000e+000   
     .                 xyr_sigdotn(t283-1,t281+3,0) = 0.0000000000000000e+000   
     .                 xyr_sigdotn(t283-1,t281,kmax) = 0.0000000000000000e+000  
     .                 xyr_sigdotn(t283-1,t281+1,kmax) = 0.0000000000000000e+000
     .                 xyr_sigdotn(t283-1,t281+2,kmax) = 0.0000000000000000e+000
     .                 xyr_sigdotn(t283-1,t281+3,kmax) = 0.0000000000000000e+000
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10004                                                        
   425        xyr_SigDotN(:,:,kmax) = 0.0_DP
   426  
   427  
   428      case ( IDVelDistAsymHadley )
   429  
   430        if ( present( xyr_StreamFunc ) ) then
   431          xyr_StreamFunc = -999.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t272 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_streamfunc(t272-1,1,0) = -9.99000000000000e+002            
     .        enddo                                                             
   432        end if
   433  
   434      end select
   435  
   436  
   437    end subroutine AdvTestSetVerVel
   438  
   439    !--------------------------------------------------------------------------------------
   440  
   441    subroutine AdvTestSetICs(     &
   442      & xy_Ps, xyz_Temp,          & ! (in)
   443      & xyz_U, xyz_V, xyzf_QMix   & ! (out)
   444      & )
   445      !-------セミラグのテスト用の流速分布を与える--------
   446      !Gives a velocity for Test. Only used for debug.
   447  
   448      use axesset   , only : x_Lon, y_Lat, z_Sigma, r_Sigma
   449      use constants , only: RPlanet
   450                                ! $ a $ [m].
   451                                ! 惑星半径.
   452                                ! Radius of planet
   453      use timeset, only: &
   454        & DelTime, &            ! $ \Delta t $ [s]
   455        & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $.
   456  
   457      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   458      ! Interpolate temperature on half sigma level,
   459      ! and calculate pressure and height
   460      !
   461      use auxiliary, only: AuxVars
   462  
   463  
   464      real(DP), intent(in ) :: xy_Ps    (0:imax-1, 1:jmax)
   465                                ! 東西風速
   466                                ! Zonal Wind
   467      real(DP), intent(in ) :: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   468                                ! 温度
   469                                ! Temperature
   470      real(DP), intent(out) :: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   471                                ! 東西風速
   472                                ! Zonal Wind
   473      real(DP), intent(out) :: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   474                                ! 南北風速
   475                                ! Meridional Wind
   476      real(DP), intent(out) :: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   477                                !
   478                                ! Mass mixing ratio
   479  
   480      ! 作業変数
   481      ! Work variables
   482      !
   483      real(DP) :: Lon0
   484      real(DP) :: Lat0
   485      real(DP) :: Height0
   486      real(DP) :: Height1
   487      real(DP) :: Height2
   488      real(DP) :: RScale
   489      real(DP) :: ZScale
   490  
   491      real(DP) :: xyz_QVap     (0:imax-1, 1:jmax, 1:kmax)
   492      real(DP) :: xy_SurfHeight(0:imax-1, 1:jmax)
   493      real(DP) :: xyz_Height   (0:imax-1, 1:jmax, 1:kmax)
   494  
   495      real(DP) :: xyz_HorDist(0:imax-1, 1:jmax, 1:kmax)
   496      real(DP) :: xyz_VerDist(0:imax-1, 1:jmax, 1:kmax)
   497  
   498      real(DP) :: D1
   499      real(DP) :: D2
   500  
   501      integer:: i               ! 東西方向に回る DO ループ用作業変数
   502                                ! Work variables for DO loop in zonal direction
   503      integer:: j               ! 南北方向に回る DO ループ用作業変数
   504                                ! Work variables for DO loop in meridional direction
   505      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   506                                ! Work variables for DO loop in vertical direction
   507      integer:: n
   508  
   509  
   510      ! 初期化確認
   511      ! Initialization check
   512      !
   513      if ( .not. adv_test_inited ) then
   514        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   515      end if
   516  
   517  
   518      xyz_QVap      = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t433 = 1, xyz_qvap.DSC.U3*(xyz_qvap.DSC.U2*xyz_qvap.DSC.U1 +   
     .       1   xyz_qvap.DSC.U2)                                               
     .           xyz_qvap(t433-1,1,1) = 0.0000000000000000e+000                 
     .        enddo                                                             
   519      xy_SurfHeight = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t442 = 1, xy_surfheight.DSC.U2*xy_surfheight.DSC.U1 +          
     .       1   xy_surfheight.DSC.U2                                           
     .           xy_surfheight(t442-1,1) = 0.0000000000000000e+000              
     .        enddo                                                             
   520  
   521      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   522      ! Interpolate temperature on half sigma level,
   523      ! and calculate pressure and height
   524      !
   525      call AuxVars( &
   526        & xy_Ps, xyz_Temp, xyz_QVap,     & ! (in )
   527        & xy_SurfHeight = xy_SurfHeight, & ! (in ) optional
   528        & xyz_Height    = xyz_Height     & ! (out) optional
   529        & )
   530  
   531  
   532      !
   533      ! Utility module for advection test
   534      !
   535      call AdvTestSetHorVels(   &
   536        & xyz_U, xyz_V          & ! (out)
   537        & )
   538  
   539      select case ( IDVelDist )
   540      case ( IDVelDistNCARASPSummerCol )
   541  
   542        Lon0    = 3.0_DP * PI / 2.0_DP
   543        Lat0    = 0.0_DP
   544  
   545        Height0 = 4.5e3_DP
   546  
   547        RScale = RPlanet / 3.0_DP
   548        ZScale = 1.0e3_DP
   549  
   550        do k = 1, kmax
   551          do j = 1, jmax
   552            do i = 0, imax-1
   553              xyz_HorDist(i,j,k) = &
   554                &   RPlanet &
   555                & * acos(   sin( Lat0 ) * sin( y_Lat(j) ) &
   556                &         + cos( Lat0 ) * cos( y_Lat(j) ) * cos( x_Lon(i) - Lon0 ) )
   557            end do
   558          end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(d3,x_lon)                                                  
     .        do i = 1, imax                                                    
     .           d3(i) = dcos(x_lon(i-1)-lon0)                                  
     .        enddo                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(d3)                                                        
     .        do i1 = 0, imax - 1, maxvl()                                      
     .           i2 = min0(imax - i1,maxvl())                                   
     .           if (jmax .gt. 0) then                                          
     .              j3 = and(jmax,3)                                            
     .              do j = 1, j3                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(d3,x_lon)                                         
     .                 do i = 1, i2                                             
     .                    xyz_hordist(i1+i-1,j,k) = rplanet*dacos(dsin(lat0)*   
     .       1               dsin(y_lat(j))+dcos(lat0)*dcos(y_lat(j))*d3(i1+i)) 
     .                 enddo                                                    
     .              enddo                                                       
     .              do j = j3 + 1, jmax, 4                                      
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(d3,x_lon)                                         
     .                 do i = 1, i2                                             
     .                    d4 = d3(i1+i)                                         
     .                    xyz_hordist(i1+i-1,j,k) = rplanet*dacos((dsin(lat0))* 
     .       1               dsin(y_lat(j))+(dcos(lat0))*dcos(y_lat(j))*d4)     
     .                    xyz_hordist(i1+i-1,j+1,k) = rplanet*dacos((dsin(lat0))
     .       1               *dsin(y_lat(j+1))+(dcos(lat0))*dcos(y_lat(j+1))*d4)
     .                    xyz_hordist(i1+i-1,j+2,k) = rplanet*dacos((dsin(lat0))
     .       1               *dsin(y_lat(j+2))+(dcos(lat0))*dcos(y_lat(j+2))*d4)
     .                    xyz_hordist(i1+i-1,j+3,k) = rplanet*dacos((dsin(lat0))
     .       1               *dsin(y_lat(j+3))+(dcos(lat0))*dcos(y_lat(j+3))*d4)
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   559        end do
   560        xyz_VerDist = xyz_Height - Height0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t460 = 1, xyz_height.DSC.U3*(xyz_height.DSC.U2*                
     .       1   xyz_height.DSC.U1 + xyz_height.DSC.U2)                         
     .           xyz_verdist(t460-1,1,1) = xyz_height(t460-1,1,1) - height0     
     .        enddo                                                             
   561  
   562        do n = 1, ncmax
   563          do k = 1, kmax
   564            do j = 1, jmax
   565              do i = 0, imax-1
   566                D2 =   ( xyz_HorDist(i,j,k) / RScale )**2 &
   567                  &  + ( xyz_VerDist(i,j,k) / ZScale )**2
   568                D1 = min( 1.0_DP, D2 )
   569                if ( mod(n,2) == 1 ) then
   570                  ! q5
   571                  xyzf_QMix(i,j,k,n) = 1.0_DP / 2.0_DP * ( 1.0_DP + cos( PI * D1 ) )
   572                else if ( mod(n,2) == 0 ) then
   573                  ! q6
   574                  if ( D2 <= 1.0_DP ) then
   575                    xyzf_QMix(i,j,k,n) = 1.0_DP
   576                  else
   577                    xyzf_QMix(i,j,k,n) = 0.0_DP
   578                  end if
   579                  if ( ( xyz_Height(i,j,k) > Height0 ) .and. &
   580                    &  ( ( Lat0 - 1.0_DP / 8.0_DP < y_Lat(j) ) .and. &
   581                    &    ( y_Lat(j) < Lat0 + 1.0_DP / 8.0_DP ) ) ) then
   582                    xyzf_QMix(i,j,k,n) = 0.0_DP
   583                  end if
   584                else
   585                  xyzf_QMix(i,j,k,n) = 0.0_DP
   586                end if
   587              end do
   588            end do
   589          end do
     .        if (mod(n,2) .eq. 1) then                                         
     .           d5 = 1.D0/rscale                                               
     .           d6 = 1.D0/zscale                                               
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xyz_hordist,xyz_verdist)                                
     .           do k = 1, kmax*jmax*imax                                       
     .              d2 = (xyz_hordist(k-1,1,1)*d5)**2 + (xyz_verdist(k-1,1,1)*d6
     .       1         )**2                                                     
     .              xyzf_qmix(k-1,1,1,n) = 5.00000000000000e-001*(              
     .       1         1.00000000000000e+000 + dcos(3.14159265358979e+000*min(  
     .       2         1.00000000000000e+000,d2)))                              
     .           enddo                                                          
     .        else                                                              
     .           if (mod(n,2) .eq. 0) then                                      
     .              do k = 1, kmax                                              
     .                 do j = 1, jmax                                           
     .                    d7 = 1.D0/rscale                                      
     .                    d8 = 1.D0/zscale                                      
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xyz_hordist,xyz_verdist,xyz_height)            
     .                    do i = 1, imax                                        
     .                       d2 = (xyz_hordist(i-1,j,k)*d7)**2 + (xyz_verdist(i-
     .       1                  1,j,k)*d8)**2                                   
     .                       if (d2 .le. 1.00000000000000e+000) then            
     .                          xyzf_qmix7 = 1.00000000000000e+000              
     .                       else                                               
     .                          xyzf_qmix7 = 0.0000000000000000e+000            
     .                       endif                                              
     .                       xyzf_qmix(i-1,j,k,n) = xyzf_qmix7                  
     .                       if (xyz_height(i-1,j,k).gt.height0 .and. lat0-     
     .       1                  1.25000000000000e-001.lt.y_lat(j) .and. y_lat(j)
     .       2                  .lt.lat0+1.25000000000000e-001) then            
     .                          xyzf_qmix(i-1,j,k,n) = 0.0000000000000000e+000  
     .                       endif                                              
     .                    enddo                                                 
     .                 enddo                                                    
     .              enddo                                                       
     .           else                                                           
     .              d9 = 1.D0/rscale                                            
     .              d10 = 1.D0/zscale                                           
     .  !cdir       nodep                                                       
     .  !cdir       noassume                                                    
     .  !cdir       on_adb(xyz_hordist,xyz_verdist)                             
     .              do k = 1, kmax*jmax*imax                                    
     .                 d2 = (xyz_hordist(k-1,1,1)*d9)**2 + (xyz_verdist(k-1,1,1)
     .       1            *d10)**2                                              
     .                 xyzf_qmix(k-1,1,1,n) = 0.0000000000000000e+000           
     .              enddo                                                       
     .           endif                                                          
     .        endif                                                             
   590        end do
   591  
   592      case ( IDVelDistSymHadley )
   593  
   594        Height1 = 2.0e3_DP
   595        Height2 = 5.0e3_DP
   596        Height0 = ( Height1 + Height2 ) / 2.0_DP
   597  
   598        xyz_VerDist = xyz_Height - Height0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t448 = 1, xyz_height.DSC.U3*(xyz_height.DSC.U2*                
     .       1   xyz_height.DSC.U1 + xyz_height.DSC.U2)                         
     .           xyz_verdist(t448-1,1,1) = xyz_height(t448-1,1,1) - height0     
     .        enddo                                                             
   599  
   600        do n = 1, ncmax
   601          do k = 1, kmax
   602            do j = 1, jmax
   603              do i = 0, imax-1
   604                if ( ( Height1 < xyz_Height(i,j,k) ) .and. &
   605                  &  ( xyz_Height(i,j,k) < Height2 ) ) then
   606                  xyzf_QMix(i,j,k,n) = &
   607                    & ( 1.0_DP + cos( 2.0_DP * PI * xyz_VerDist(i,j,k) / ( Height2 - Height1 ) ) ) / 2.0_DP
   608                else
   609                  xyzf_QMix(i,j,k,n) = 0.0_DP
   610                end if
   611              end do
   612            end do
   613          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_height,xyz_verdist)                                    
     .        do k = 1, kmax*jmax*imax                                          
     .           if (height1.lt.xyz_height(k-1,1,1) .and. xyz_height(k-1,1,1)   
     .       1      .lt.height2) then                                           
     .              xyzf_qmix10 = (1.00000000000000e+000 + dcos(                
     .       1         6.28318530717958e+000*xyz_verdist(k-1,1,1)/(height2-     
     .       2         height1)))/2.00000000000000e+000                         
     .           else                                                           
     .              xyzf_qmix10 = 0.0000000000000000e+000                       
     .           endif                                                          
     .           xyzf_qmix(k-1,1,1,n) = xyzf_qmix10                             
     .        enddo                                                             
   614        end do
   615  
   616      case ( IDVelDistAsymHadley )
   617      end select
   618  
   619  
   620  
   621    end subroutine AdvTestSetICs
   622  
   623    !--------------------------------------------------------------------------------------
   624  
   625    subroutine AdvTestInit
   626  
   627      ! ヒストリデータ出力
   628      ! History data output
   629      !
   630      use gtool_historyauto, only: HistoryAutoAddVariable
   631  
   632      ! 文字列操作
   633      ! Character handling
   634      !
   635      use dc_string, only: toChar
   636  
   637      ! NAMELIST ファイル入力に関するユーティリティ
   638      ! Utilities for NAMELIST file input
   639      !
   640      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   641  
   642      ! ファイル入出力補助
   643      ! File I/O support
   644      !
   645      use dc_iounit, only: FileOpen
   646  
   647      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   648      ! Interpolate temperature on half sigma level,
   649      ! and calculate pressure and height
   650      !
   651      use auxiliary, only: AuxVarsInit
   652  
   653      use constants , only: &
   654        & RPlanet, &
   655                                ! $ a $ [m].
   656                                ! 惑星半径.
   657                                ! Radius of planet
   658        & Grav, &               ! $ g $ [m s-2].
   659                                ! 重力加速度.
   660                                ! Gravitational acceleration
   661        & GasRDry
   662                                ! $ R $ [J kg-1 K-1].
   663                                ! 乾燥大気の気体定数.
   664                                ! Gas constant of air
   665  
   666      ! 宣言文 ; Declaration statements
   667      !
   668      character(STRING) :: VelDist
   669      real(DP) :: AlphaInDeg
   670  !!$    real(DP) :: HCW0
   671  !!$    real(DP) :: Temp0
   672  
   673      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   674                                ! Unit number for NAMELIST file open
   675      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   676                                ! IOSTAT of NAMELIST read
   677  
   678  
   679      ! NAMELIST 変数群
   680      ! NAMELIST group name
   681      !
   682      namelist /adv_test_nml/ &
   683        & VelDist,       &
   684        & AlphaInDeg,    &
   685        & Tau,           &
   686        & Press0,        &
   687        & Omega0,        &
   688        & HCSigmaTop,    &
   689        & HCNumCell,     &
   690        & HCV0
   691            !
   692            ! デフォルト値については初期化手続 "set_GATE_profile#SetGATEProfileInit"
   693            ! のソースコードを参照のこと.
   694            !
   695            ! Refer to source codes in the initialization procedure
   696            ! "set_GATE_profile#SetGATEProfileInit" for the default values.
   697            !
   698  
   699      ! デフォルト値の設定
   700      ! Default values settings
   701      !
   702      VelDist       = "NCARASPSummerCol"
   703      AlphaInDeg    = 0.0_DP
   704      Tau           = 345600.0_DP
   705      Press0        = 1000.0e2_DP
   706      Omega0        = PI * 4.0e4_DP / Tau
   707      HCSigmaTop    = 0.1_DP
   708      HCNumCell     = 3
   709      HCV0          = 10.0_DP
   710  
   711  
   712      ! NAMELIST の読み込み
   713      ! NAMELIST is input
   714      !
   715      if ( trim(namelist_filename) /= '' ) then
   716        call FileOpen( unit_nml, &          ! (out)
   717          & namelist_filename, mode = 'r' ) ! (in)
   718  
   719        rewind( unit_nml )
   720        read( unit_nml,                     & ! (in)
   721          & nml = adv_test_nml,             & ! (out)
   722          & iostat = iostat_nml )             ! (out)
   723        close( unit_nml )
   724  
   725        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   726      end if
   727  
   728  
   729      select case ( VelDist )
   730      case ( "NCARASPSummerCol" )
   731        IDVelDist = IDVelDistNCARASPSummerCol
   732      case ( "SymHadley" )
   733        IDVelDist = IDVelDistSymHadley
   734      case ( "AsymHadley" )
   735        IDVelDist = IDVelDistAsymHadley
   736      case default
   737        call MessageNotify( 'E', module_name, 'VelDist of %c is not supported.', c1 = trim( VelDist ) )
   738      end select
   739  
   740      Alpha    = AlphaInDeg * PI / 180.0_DP
   741  
   742  
   743      ! 補助的な変数を計算するサブルーチン・関数群
   744      ! Subroutines and functions for calculating auxiliary variables
   745      !
   746      call AuxVarsInit
   747  
   748  
   749      ! 印字 ; Print
   750      !
   751      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   752      call MessageNotify( 'M', module_name, 'VelDist       = %c', c1 = trim( VelDist ) )
   753      call MessageNotify( 'M', module_name, 'Alpha         = %f', d = (/ Alpha /) )
   754      call MessageNotify( 'M', module_name, 'Tau           = %f', d = (/ Tau /) )
   755      call MessageNotify( 'M', module_name, 'Press0        = %f', d = (/ Press0 /) )
   756      call MessageNotify( 'M', module_name, 'Omega0        = %f', d = (/ Omega0 /) )
   757      call MessageNotify( 'M', module_name, 'HCSigmaTop    = %f', d = (/ HCSigmaTop /) )
   758      call MessageNotify( 'M', module_name, 'HCNumCell     = %d', i = (/ HCNumCell /) )
   759  !!$    call MessageNotify( 'M', module_name, 'InFileNameForcing  = %c', c1 = trim(InFileNameForcing ) )
   760      call MessageNotify( 'M', module_name, 'HCV0          = %f', d = (/ HCV0 /) )
   761      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   762  
   763  
   764      adv_test_inited = .true.
   765  
   766  
   767    end subroutine AdvTestInit
   768  
   769    !--------------------------------------------------------------------------------------
   770  
   771  end module adv_test
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: adv_test.f90
PROGRAM NAME: adv_test
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Utility module for advection test
     4:             !
     5:             ! Authors::   Hiroki Kashimura, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module adv_test
    13:               !
    14:               != 
    15:               !
    16:               != Utility module for advection test
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:             
    21:               !== References
    22:               !
    23:             !!$  !  Chou, M.-D.,
    24:             !!$  !    Atmospheric solar heating rate in the water vapor bands,
    25:             !!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
    26:               !
    27:               !== Procedures List
    28:               !
    29:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    30:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    31:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    32:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    33:             !!$  ! ------------            :: ------------
    34:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    35:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    36:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    37:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    38:               !
    39:               !== NAMELIST
    40:               !
    41:               ! NAMELIST#set_1d_profile_nml
    42:               !
    43:             
    44:               ! USE statements
    45:               !
    46:             
    47:               !
    48:               ! Kind type parameter
    49:               !
    50:               use dc_types, only: DP, &      ! Double precision.
    51:                 &                 STRING, &  ! Strings.
    52:                 &                 TOKEN      ! Keywords.
    53:             
    54:               ! 格子点設定
    55:               ! Grid points settings
    56:               !
    57:               use gridset, only: imax, & ! 経度格子点数.
    58:                                          ! Number of grid points in longitude
    59:                 &                jmax, & ! 緯度格子点数.
    60:                                          ! Number of grid points in latitude
    61:                 &                kmax    ! 鉛直層数.
    62:                                          ! Number of vertical level
    63:             
    64:               ! 組成に関わる配列の設定
    65:               ! Settings of array for atmospheric composition
    66:               !
    67:               use composition, only:                              &
    68:                 &                    ncmax
    69:                                            ! 成分の数
    70:                                            ! Number of composition
    71:             
    72:               ! メッセージ出力
    73:               ! Message output
    74:               !
    75:               use dc_message, only: MessageNotify
    76:             
    77:               use constants0, only : PI
    78:             
    79:               implicit none
    80:             
    81:               private
    82:             
    83:               ! 公開変数
    84:               ! Public variables
    85:               !
    86:               logical, save, public:: adv_test_inited = .false.
    87:                                           ! 初期設定フラグ.
    88:                                           ! Initialization flag
    89:             
    90:               integer, save      :: IDVelDist
    91:               integer, parameter :: IDVelDistNCARASPSummerCol = 1
    92:               integer, parameter :: IDVelDistSymHadley        = 2
    93:               integer, parameter :: IDVelDistAsymHadley       = 3
    94:             
    95:               real(DP), save :: Alpha
    96:               real(DP), save :: Tau
    97:               real(DP), save :: Press0
    98:               real(DP), save :: Omega0
    99:               real(DP), save :: HCSigmaTop
   100:               integer , save :: HCNumCell    ! Number of Hadley cell in each hemisphere
   101:               real(DP), save :: HCV0
   102:             
   103:             
   104:               public :: AdvTestSetHorVels
   105:               public :: AdvTestSetVerVel
   106:               public :: AdvTestSetICs
   107:               public :: AdvTestInit
   108:             
   109:             
   110:               character(*), parameter:: module_name = 'adv_test'
   111:                                           ! モジュールの名称.
   112:                                           ! Module name
   113:               character(*), parameter:: version = &
   114:                 & '$Name:  $' // &
   115:                 & '$Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $'
   116:                                           ! モジュールのバージョン
   117:                                           ! Module version
   118:             
   119:             
   120:               !--------------------------------------------------------------------------------------
   121:             
   122:             contains
   123:             
   124:               !--------------------------------------------------------------------------------------
   125:             
   126:               subroutine AdvTestSetHorVels(   &
   127:                 & xyz_UN, xyz_VN              & ! (out)
   128:                 & )
   129:                 !-------セミラグのテスト用の流速分布を与える--------
   130:                 !Gives a velocity for Test. Only used for debug.
   131:             
   132:                 use timeset, only: &
   133:                   & DelTime, &            ! $ \Delta t $ [s]
   134:                   & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $. 
   135:                 use axesset   , only : x_Lon, y_Lat, z_Sigma, r_Sigma
   136:                 use constants , only: RPlanet, &
   137:                                           ! $ a $ [m]. 
   138:                                           ! 惑星半径. 
   139:                                           ! Radius of planet
   140:                   &                   Grav
   141:             
   142:                 real(DP), intent(out) :: xyz_UN     (0:imax-1, 1:jmax, 1:kmax)
   143:                                           ! 東西風速
   144:                                           ! Zonal Wind    
   145:                 real(DP), intent(out) :: xyz_VN     (0:imax-1, 1:jmax, 1:kmax)
   146:                                           ! 南北風速
   147:                                           ! Meridional Wind    
   148:             
   149:                 ! 作業変数
   150:                 ! Work variables
   151:                 !
   152:                 real(DP) :: U0
   153:                 real(DP) :: Time
   154:                 real(DP) :: StreamFunc
   155:             
   156:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   157:                                           ! Work variables for DO loop in zonal direction
   158:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   159:                                           ! Work variables for DO loop in meridional direction
   160:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   161:                                           ! Work variables for DO loop in vertical direction
   162:             
   163:                 ! 初期化確認
   164:                 ! Initialization check
   165:                 !
   166:                 if ( .not. adv_test_inited ) then
   167:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   168:                 end if
   169:             
   170:             
   171:                 select case ( IDVelDist )
   172:                 case ( IDVelDistNCARASPSummerCol )
   173:                   ! 水平流速分布を与える
   174:                   U0 = 2.0_DP * PI * RPlanet / ( 86400.0_DP * 12.0_DP )
   175: +------>          do k = 1, kmax
   176: |+----->            do j = 1, jmax
   177: ||V---->A             do i = 0, imax-1
   178: |||     A               xyz_UN(i,j,k) = &
   179: |||                       &   U0 * ( cos( y_Lat(j) ) * cos( Alpha ) + cos( x_Lon(i) ) * sin( y_Lat(j) ) * sin( Alpha ) )
   180: |||     A               xyz_VN(i,j,k) = &
   181: |||                       & - U0 * ( sin( x_Lon(i) ) * sin( Alpha ) )
   182: ||V----               end do
   183: |+-----             end do
   184: +------           end do
   185:                 case ( IDVelDistSymHadley )
   186: +------>          do k = 1, kmax
   187: |+----->            do j = 1, jmax
   188: ||V---->              do i = 0, imax-1
   189: |||         
   190: |||                     if ( z_Sigma(k) < HCSigmaTop ) then
   191: |||                       StreamFunc = 0.0_DP
   192: |||         
   193: |||     A                 xyz_UN(i,j,k) = 0.0_DP
   194: |||     A                 xyz_VN(i,j,k) = 0.0_DP
   195: |||                     else
   196: |||         
   197: |||         !!$                StreamFunc = &
   198: |||         !!$                  & StreamFunc0 &
   199: |||         !!$                  & * sin( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   200: |||         !!$                  & * sin( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   201: |||         !!$
   202: |||         !!$                xyz_UN(i,j,k) = 0.0_DP
   203: |||         !!$                xyz_VN(i,j,k) =                                                 &
   204: |||         !!$                  & StreamFunc0 * Grav / Press0                                 &
   205: |||         !!$                  & * sin( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   206: |||         !!$                  & * PI/(r_Sigma(0)-HCSigmaTop)                                &
   207: |||         !!$                  & * cos( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   208: |||         
   209: |||                       Time = TimeN
   210: |||         
   211: |||         !!$                StreamFunc = &
   212: |||         !!$                  & StreamFunc0 &
   213: |||         !!$                  & * sin( HCNumCell * y_Lat(j) ) &
   214: |||         !!$                  & * sin( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   215: |||         !!$
   216: |||         !!$                xyz_UN(i,j,k) = 0.0_DP
   217: |||         !!$                xyz_VN(i,j,k) =                                               &
   218: |||         !!$                  & StreamFunc0 * Grav / Press0                               &
   219: |||         !!$                  & * sin( HCNumCell * y_Lat(j) )                             &
   220: |||         !!$                  & * PI/(r_Sigma(0)-HCSigmaTop)                              &
   221: |||         !!$                  & * cos( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   222: |||         !!$                  & * cos( PI * Time / Tau )
   223: |||         
   224: |||         !!$              StreamFunc = &
   225: |||         !!$                &   PI * RPlanet**2 * Press0 / Grav * SigDot0         &
   226: |||         !!$                &   * (   sin( dble( 2 * HCNumCell + 1 ) * y_Lat(j) ) &
   227: |||         !!$                &           / dble( 2 * HCNumCell + 1 )               &
   228: |||         !!$                &       + sin( dble( 2 * HCNumCell - 1 ) * y_Lat(j) ) &
   229: |||         !!$                &           / dble( 2 * HCNumCell - 1 ) )             &
   230: |||         !!$                &   * sin( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   231: |||         !!$                &   * cos( PI * Time / Tau )
   232: |||         !!$
   233: |||         !!$              xyz_UN(i,j,k) = 0.0_DP
   234: |||         !!$              xyz_VN(i,j,k) =                                              &
   235: |||         !!$                & - RPlanet / ( 2.0_DP * cos( y_Lat(j) ) ) * SigDot0       &
   236: |||         !!$                &   * PI/(r_Sigma(0)-HCSigmaTop)                           &
   237: |||         !!$                &   * (   sin( dble( 2 * HCNumCell + 1 ) * y_Lat(j) ) &
   238: |||         !!$                &           / dble( 2 * HCNumCell + 1 )               &
   239: |||         !!$                &       + sin( dble( 2 * HCNumCell - 1 ) * y_Lat(j) ) &
   240: |||         !!$                &           / dble( 2 * HCNumCell - 1 ) )             &
   241: |||         !!$                & * cos( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   242: |||         !!$                & * cos( PI * Time / Tau )
   243: |||         
   244: |||                       StreamFunc =                                            &
   245: |||                         & - 2.0_DP * PI * RPlanet                             &
   246: |||                         &   * (r_Sigma(0)-HCSigmaTop) / PI                    &
   247: |||                         &   * Press0 / Grav * HCV0                            &
   248: |||                         &   * sin( dble( 2 * HCNumCell ) * y_Lat(j) )         &
   249: |||                         &   * cos( y_Lat(j) )**2                              &
   250: |||                         &   * sin( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   251: |||                         &   * cos( PI * Time / Tau )
   252: |||         
   253: |||     A                 xyz_UN(i,j,k) = 0.0_DP
   254: |||     A                 xyz_VN(i,j,k) =                                              &
   255: |||                         &   HCV0                                                   &
   256: |||                         &   * sin( dble( 2 * HCNumCell ) * y_Lat(j) )              &
   257: |||                         &   * cos( y_Lat(j) )                                      &
   258: |||                         &   * cos( (z_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   259: |||                         &   * cos( PI * Time / Tau )
   260: |||         
   261: |||                     end if
   262: |||         
   263: ||V----               end do
   264: |+-----             end do
   265: +------           end do
   266:                 case ( IDVelDistAsymHadley )
   267:                 end select
   268:             
   269:             
   270:               end subroutine AdvTestSetHorVels
   271:             
   272:               !--------------------------------------------------------------------------------------
   273:             
   274:               subroutine AdvTestSetVerVel( &
   275:                 & xyr_SigDotN,             & ! (out)
   276:                 & xyr_StreamFunc           & ! (out) optional
   277:                 & )
   278:                 !-------セミラグのテスト用の流速分布を与える--------
   279:                 !Gives a velocity for Test. Only used for debug.
   280:             
   281:                 use axesset, only : y_Lat, r_Sigma
   282:             
   283:                 use timeset, only: &
   284:                   & DelTime, &            ! $ \Delta t $ [s]
   285:                   & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $. 
   286:             
   287:                 use constants , only: RPlanet, &
   288:                                           ! $ a $ [m]. 
   289:                                           ! 惑星半径. 
   290:                                           ! Radius of planet
   291:                   &                   Grav
   292:             
   293:                 real(DP), intent(out) :: xyr_SigDotN(0:imax-1, 1:jmax, 0:kmax)
   294:                                           ! 鉛直流速（SigmaDot）
   295:                 real(DP), intent(out), optional :: xyr_StreamFunc(0:imax-1, 1:jmax, 0:kmax)
   296:             
   297:                 ! 作業変数
   298:                 ! Work variables
   299:                 !
   300:                 real(DP) :: Time
   301:                 real(DP) :: Shape
   302:                 real(DP) :: StreamFunc
   303:             
   304:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   305:                                           ! Work variables for DO loop in zonal direction
   306:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   307:                                           ! Work variables for DO loop in meridional direction
   308:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   309:                                           ! Work variables for DO loop in vertical direction
   310:             
   311:                 ! 初期化確認
   312:                 ! Initialization check
   313:                 !
   314:                 if ( .not. adv_test_inited ) then
   315:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   316:                 end if
   317:             
   318:             
   319:                 select case ( IDVelDist )
   320:                 case ( IDVelDistNCARASPSummerCol )
   321:                   !鉛直流速分布を与える
   322:                   Time = TimeN
   323: +------>          do k = 0, kmax
   324: |                   Shape = min( 1.0_DP, &
   325: |                     &          2.0_DP * sqrt( sin( (r_Sigma(k)-r_Sigma(kmax))/(r_Sigma(0)-r_Sigma(kmax)) * PI ) ) &
   326: |                     &        )
   327: |W----->            do j = 1, jmax
   328: ||*---->              do i = 0, imax-1
   329: |||     A               xyr_SigDotN(i,j,k) = Omega0 / Press0 * cos( 2.0_DP*PI/Tau*Time )*sin( Shape*PI/2.0_DP )
   330: ||*----               end do
   331: |W-----             end do
   332: +------           end do
   333:             
   334:                   if ( present( xyr_StreamFunc ) ) then
   335: ++V==== A           xyr_StreamFunc = -999.0_DP
   336:                   end if
   337:             
   338:                 case ( IDVelDistSymHadley )
   339:             
   340: +------>          do k = 0, kmax
   341: |+----->            do j = 1, jmax
   342: ||V---->              do i = 0, imax-1
   343: |||                     if ( r_Sigma(k) < HCSigmaTop ) then
   344: |||                       StreamFunc = 0.0_DP
   345: |||         
   346: |||     A                 xyr_SigDotN(i,j,k) = 0.0_DP
   347: |||                     else
   348: |||         
   349: |||         !!$                StreamFunc = &
   350: |||         !!$                  & StreamFunc0 &
   351: |||         !!$                  & * sin( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   352: |||         !!$                  & * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   353: |||         !!$
   354: |||         !!$                xyr_SigDotN(i,j,k) = &
   355: |||         !!$                  & - StreamFunc0 * Grav / Press0 / ( RPlanet * cos( y_Lat(j) ) )     &
   356: |||         !!$                  & * (   PI / ( HCLatMax - 0.0_DP ) &
   357: |||         !!$                  &       * cos( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   358: |||         !!$                  &       * cos( y_Lat(j) )   &
   359: |||         !!$                  &     -   sin( ( y_Lat(j) - 0.0_DP ) / ( HCLatMax - 0.0_DP ) * PI ) &
   360: |||         !!$                  &       * sin( y_Lat(j) ) ) &
   361: |||         !!$                  & * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   362: |||         
   363: |||                       Time = TimeN
   364: |||         
   365: |||         !!$              StreamFunc = &
   366: |||         !!$                & StreamFunc0 &
   367: |||         !!$                & * sin( HCNumCell * y_Lat(j) ) &
   368: |||         !!$                & * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI )
   369: |||         !!$
   370: |||         !!$              xyr_SigDotN(i,j,k) = &
   371: |||         !!$                & - StreamFunc0 * Grav / Press0 / ( RPlanet * cos( y_Lat(j) ) ) &
   372: |||         !!$                & * (   HCNumCell &
   373: |||         !!$                &       * cos( HCNumCell * y_Lat(j) ) * cos( y_Lat(j) )   &
   374: |||         !!$                &     -   sin( HCNumCell * y_Lat(j) ) * sin( y_Lat(j) ) ) &
   375: |||         !!$                & * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   376: |||         !!$                & * cos( PI * Time / Tau )
   377: |||         
   378: |||         !!$              StreamFunc = &
   379: |||         !!$                &   PI * RPlanet**2 * Press0 / Grav * SigDot0         &
   380: |||         !!$                &   * (   sin( dble( 2 * HCNumCell + 1 ) * y_Lat(j) ) &
   381: |||         !!$                &           / dble( 2 * HCNumCell + 1 )               &
   382: |||         !!$                &       + sin( dble( 2 * HCNumCell - 1 ) * y_Lat(j) ) &
   383: |||         !!$                &           / dble( 2 * HCNumCell - 1 ) )             &
   384: |||         !!$                &   * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   385: |||         !!$                &   * cos( PI * Time / Tau )
   386: |||         !!$
   387: |||         !!$              xyr_SigDotN(i,j,k) = &
   388: |||         !!$                &   SigDot0                                                       &
   389: |||         !!$                &   * cos( dble( 2 * HCNumCell ) * y_Lat(j) )                     &
   390: |||         !!$                &   * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   391: |||         !!$                &   * cos( PI * Time / Tau )
   392: |||         
   393: |||                       StreamFunc =                                            &
   394: |||                         & - 2.0_DP * PI * RPlanet                             &
   395: |||                         &   * (r_Sigma(0)-HCSigmaTop) / PI                    &
   396: |||                         &   * Press0 / Grav * HCV0                            &
   397: |||                         &   * sin( dble( 2 * HCNumCell ) * y_Lat(j) )         &
   398: |||                         &   * cos( y_Lat(j) )**2                              &
   399: |||                         &   * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   400: |||                         &   * cos( PI * Time / Tau )
   401: |||         
   402: |||     A                 xyr_SigDotN(i,j,k) = &
   403: |||                         & - (r_Sigma(0)-HCSigmaTop) / ( PI * RPlanet )             &
   404: |||                         &   * HCV0                                                 &
   405: |||                         &   * (   dble( 2 * HCNumCell )                            &
   406: |||                         &         * cos( dble( 2 * HCNumCell ) * y_Lat(j) )        &
   407: |||                         &         * cos( y_Lat(j) )                                &
   408: |||                         &       - 2.0_DP &
   409: |||                         &         * sin( dble( 2 * HCNumCell ) * y_Lat(j) )        &
   410: |||                         &         * sin( y_Lat(j) ) )                              &
   411: |||                         &   * sin( (r_Sigma(k)-HCSigmaTop)/(r_Sigma(0)-HCSigmaTop) * PI ) &
   412: |||                         &   * cos( PI * Time / Tau )
   413: |||         
   414: |||                     end if
   415: |||         
   416: |||                     if ( present( xyr_StreamFunc ) ) then
   417: |||     A                 xyr_StreamFunc(i,j,k) = StreamFunc
   418: |||                     end if
   419: |||         
   420: ||V----               end do
   421: |+-----             end do
   422: +------           end do
   423:             
   424: *V----->A         xyr_SigDotN(:,:,0   ) = 0.0_DP
   425: *V----- A         xyr_SigDotN(:,:,kmax) = 0.0_DP
   426:             
   427:             
   428:                 case ( IDVelDistAsymHadley )
   429:             
   430:                   if ( present( xyr_StreamFunc ) ) then
   431: W**==== A           xyr_StreamFunc = -999.0_DP
   432:                   end if
   433:             
   434:                 end select
   435:             
   436:             
   437:               end subroutine AdvTestSetVerVel
   438:             
   439:               !--------------------------------------------------------------------------------------
   440:             
   441:               subroutine AdvTestSetICs(     &
   442:                 & xy_Ps, xyz_Temp,          & ! (in)
   443:                 & xyz_U, xyz_V, xyzf_QMix   & ! (out)
   444:                 & )
   445:                 !-------セミラグのテスト用の流速分布を与える--------
   446:                 !Gives a velocity for Test. Only used for debug.
   447:             
   448:                 use axesset   , only : x_Lon, y_Lat, z_Sigma, r_Sigma
   449:                 use constants , only: RPlanet 
   450:                                           ! $ a $ [m]. 
   451:                                           ! 惑星半径. 
   452:                                           ! Radius of planet
   453:                 use timeset, only: &
   454:                   & DelTime, &            ! $ \Delta t $ [s]
   455:                   & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $. 
   456:             
   457:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   458:                 ! Interpolate temperature on half sigma level,
   459:                 ! and calculate pressure and height
   460:                 !
   461:                 use auxiliary, only: AuxVars
   462:             
   463:             
   464:                 real(DP), intent(in ) :: xy_Ps    (0:imax-1, 1:jmax)
   465:                                           ! 東西風速
   466:                                           ! Zonal Wind
   467:                 real(DP), intent(in ) :: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   468:                                           ! 温度
   469:                                           ! Temperature
   470:                 real(DP), intent(out) :: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   471:                                           ! 東西風速
   472:                                           ! Zonal Wind
   473:                 real(DP), intent(out) :: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   474:                                           ! 南北風速
   475:                                           ! Meridional Wind
   476:                 real(DP), intent(out) :: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   477:                                           ! 
   478:                                           ! Mass mixing ratio
   479:             
   480:                 ! 作業変数
   481:                 ! Work variables
   482:                 !
   483:                 real(DP) :: Lon0
   484:                 real(DP) :: Lat0
   485:                 real(DP) :: Height0
   486:                 real(DP) :: Height1
   487:                 real(DP) :: Height2
   488:                 real(DP) :: RScale
   489:                 real(DP) :: ZScale
   490:             
   491:                 real(DP) :: xyz_QVap     (0:imax-1, 1:jmax, 1:kmax)
   492:                 real(DP) :: xy_SurfHeight(0:imax-1, 1:jmax)
   493:                 real(DP) :: xyz_Height   (0:imax-1, 1:jmax, 1:kmax)
   494:             
   495:                 real(DP) :: xyz_HorDist(0:imax-1, 1:jmax, 1:kmax)
   496:                 real(DP) :: xyz_VerDist(0:imax-1, 1:jmax, 1:kmax)
   497:             
   498:                 real(DP) :: D1
   499:                 real(DP) :: D2
   500:             
   501:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   502:                                           ! Work variables for DO loop in zonal direction
   503:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   504:                                           ! Work variables for DO loop in meridional direction
   505:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   506:                                           ! Work variables for DO loop in vertical direction
   507:                 integer:: n
   508:             
   509:             
   510:                 ! 初期化確認
   511:                 ! Initialization check
   512:                 !
   513:                 if ( .not. adv_test_inited ) then
   514:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   515:                 end if
   516:             
   517:             
   518: W**==== A       xyz_QVap      = 0.0_DP
   519: W*===== A       xy_SurfHeight = 0.0_DP
   520:             
   521:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   522:                 ! Interpolate temperature on half sigma level,
   523:                 ! and calculate pressure and height
   524:                 !
   525:                 call AuxVars( &
   526:                   & xy_Ps, xyz_Temp, xyz_QVap,     & ! (in )
   527:                   & xy_SurfHeight = xy_SurfHeight, & ! (in ) optional
   528:                   & xyz_Height    = xyz_Height     & ! (out) optional
   529:                   & )
   530:             
   531:             
   532:                 !
   533:                 ! Utility module for advection test
   534:                 !
   535:                 call AdvTestSetHorVels(   &
   536:                   & xyz_U, xyz_V          & ! (out)
   537:                   & )
   538:             
   539:                 select case ( IDVelDist )
   540:                 case ( IDVelDistNCARASPSummerCol )
   541:             
   542:                   Lon0    = 3.0_DP * PI / 2.0_DP
   543:                   Lat0    = 0.0_DP
   544:             
   545:                   Height0 = 4.5e3_DP
   546:             
   547:                   RScale = RPlanet / 3.0_DP
   548:                   ZScale = 1.0e3_DP
   549:             
   550: +------>          do k = 1, kmax
   551: |+----->A           do j = 1, jmax
   552: ||V---->A             do i = 0, imax-1
   553: |||     A               xyz_HorDist(i,j,k) = &
   554: |||                       &   RPlanet &
   555: |||                       & * acos(   sin( Lat0 ) * sin( y_Lat(j) ) &
   556: |||                       &         + cos( Lat0 ) * cos( y_Lat(j) ) * cos( x_Lon(i) - Lon0 ) )
   557: ||V----               end do
   558: |+-----             end do
   559: +------           end do
   560: W**==== A         xyz_VerDist = xyz_Height - Height0
   561:             
   562: +------>          do n = 1, ncmax
   563: |W----->            do k = 1, kmax
   564: ||+---->              do j = 1, jmax
   565: |||V--->                do i = 0, imax-1
   566: ||||    A                 D2 =   ( xyz_HorDist(i,j,k) / RScale )**2 &
   567: ||||                        &  + ( xyz_VerDist(i,j,k) / ZScale )**2
   568: ||||                      D1 = min( 1.0_DP, D2 )
   569: ||||                      if ( mod(n,2) == 1 ) then
   570: ||||                        ! q5
   571: ||||    A                   xyzf_QMix(i,j,k,n) = 1.0_DP / 2.0_DP * ( 1.0_DP + cos( PI * D1 ) )
   572: ||||                      else if ( mod(n,2) == 0 ) then
   573: ||||                        ! q6
   574: ||||                        if ( D2 <= 1.0_DP ) then
   575: ||||                          xyzf_QMix(i,j,k,n) = 1.0_DP
   576: ||||                        else
   577: ||||                          xyzf_QMix(i,j,k,n) = 0.0_DP
   578: ||||                        end if
   579: ||||    A                   if ( ( xyz_Height(i,j,k) > Height0 ) .and. &
   580: ||||                          &  ( ( Lat0 - 1.0_DP / 8.0_DP < y_Lat(j) ) .and. &
   581: ||||                          &    ( y_Lat(j) < Lat0 + 1.0_DP / 8.0_DP ) ) ) then
   582: ||||    A                     xyzf_QMix(i,j,k,n) = 0.0_DP
   583: ||||                        end if
   584: ||||                      else
   585: ||||    A                   xyzf_QMix(i,j,k,n) = 0.0_DP
   586: ||||                      end if
   587: |||V---                 end do
   588: ||+----               end do
   589: |W-----             end do
   590: +------           end do
   591:             
   592:                 case ( IDVelDistSymHadley )
   593:             
   594:                   Height1 = 2.0e3_DP
   595:                   Height2 = 5.0e3_DP
   596:                   Height0 = ( Height1 + Height2 ) / 2.0_DP
   597:             
   598: W**==== A         xyz_VerDist = xyz_Height - Height0
   599:             
   600: +------>          do n = 1, ncmax
   601: |W----->            do k = 1, kmax
   602: ||*---->              do j = 1, jmax
   603: |||*--->                do i = 0, imax-1
   604: ||||    A                 if ( ( Height1 < xyz_Height(i,j,k) ) .and. &
   605: ||||                        &  ( xyz_Height(i,j,k) < Height2 ) ) then
   606: ||||    A                   xyzf_QMix(i,j,k,n) = &
   607: ||||                          & ( 1.0_DP + cos( 2.0_DP * PI * xyz_VerDist(i,j,k) / ( Height2 - Height1 ) ) ) / 2.0_DP
   608: ||||                      else
   609: ||||                        xyzf_QMix(i,j,k,n) = 0.0_DP
   610: ||||                      end if
   611: |||*--- A               end do
   612: ||*----               end do
   613: |W-----             end do
   614: +------           end do
   615:             
   616:                 case ( IDVelDistAsymHadley )
   617:                 end select
   618:             
   619:             
   620:             
   621:               end subroutine AdvTestSetICs
   622:             
   623:               !--------------------------------------------------------------------------------------
   624:             
   625:               subroutine AdvTestInit
   626:             
   627:                 ! ヒストリデータ出力
   628:                 ! History data output
   629:                 !
   630:                 use gtool_historyauto, only: HistoryAutoAddVariable
   631:             
   632:                 ! 文字列操作
   633:                 ! Character handling
   634:                 !
   635:                 use dc_string, only: toChar
   636:             
   637:                 ! NAMELIST ファイル入力に関するユーティリティ
   638:                 ! Utilities for NAMELIST file input
   639:                 !
   640:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   641:             
   642:                 ! ファイル入出力補助
   643:                 ! File I/O support
   644:                 !
   645:                 use dc_iounit, only: FileOpen
   646:             
   647:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   648:                 ! Interpolate temperature on half sigma level,
   649:                 ! and calculate pressure and height
   650:                 !
   651:                 use auxiliary, only: AuxVarsInit
   652:             
   653:                 use constants , only: &
   654:                   & RPlanet, &
   655:                                           ! $ a $ [m]. 
   656:                                           ! 惑星半径. 
   657:                                           ! Radius of planet
   658:                   & Grav, &               ! $ g $ [m s-2].
   659:                                           ! 重力加速度.
   660:                                           ! Gravitational acceleration
   661:                   & GasRDry
   662:                                           ! $ R $ [J kg-1 K-1].
   663:                                           ! 乾燥大気の気体定数.
   664:                                           ! Gas constant of air
   665:             
   666:                 ! 宣言文 ; Declaration statements
   667:                 !
   668:                 character(STRING) :: VelDist
   669:                 real(DP) :: AlphaInDeg
   670:             !!$    real(DP) :: HCW0
   671:             !!$    real(DP) :: Temp0
   672:             
   673:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   674:                                           ! Unit number for NAMELIST file open
   675:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   676:                                           ! IOSTAT of NAMELIST read
   677:             
   678:             
   679:                 ! NAMELIST 変数群
   680:                 ! NAMELIST group name
   681:                 !
   682:                 namelist /adv_test_nml/ &
   683:                   & VelDist,       &
   684:                   & AlphaInDeg,    &
   685:                   & Tau,           &
   686:                   & Press0,        &
   687:                   & Omega0,        &
   688:                   & HCSigmaTop,    &
   689:                   & HCNumCell,     &
   690:                   & HCV0
   691:                       !
   692:                       ! デフォルト値については初期化手続 "set_GATE_profile#SetGATEProfileInit"
   693:                       ! のソースコードを参照のこと.
   694:                       !
   695:                       ! Refer to source codes in the initialization procedure
   696:                       ! "set_GATE_profile#SetGATEProfileInit" for the default values.
   697:                       !
   698:             
   699:                 ! デフォルト値の設定
   700:                 ! Default values settings
   701:                 !
   702:                 VelDist       = "NCARASPSummerCol"
   703:                 AlphaInDeg    = 0.0_DP
   704:                 Tau           = 345600.0_DP
   705:                 Press0        = 1000.0e2_DP
   706:                 Omega0        = PI * 4.0e4_DP / Tau
   707:                 HCSigmaTop    = 0.1_DP
   708:                 HCNumCell     = 3
   709:                 HCV0          = 10.0_DP
   710:             
   711:             
   712:                 ! NAMELIST の読み込み
   713:                 ! NAMELIST is input
   714:                 !
   715:                 if ( trim(namelist_filename) /= '' ) then
   716:                   call FileOpen( unit_nml, &          ! (out)
   717:                     & namelist_filename, mode = 'r' ) ! (in)
   718:             
   719:                   rewind( unit_nml )
   720:                   read( unit_nml,                     & ! (in)
   721:                     & nml = adv_test_nml,             & ! (out)
   722:                     & iostat = iostat_nml )             ! (out)
   723:                   close( unit_nml )
   724:             
   725:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   726:                 end if
   727:             
   728:             
   729:                 select case ( VelDist )
   730:                 case ( "NCARASPSummerCol" )
   731:                   IDVelDist = IDVelDistNCARASPSummerCol
   732:                 case ( "SymHadley" )
   733:                   IDVelDist = IDVelDistSymHadley
   734:                 case ( "AsymHadley" )
   735:                   IDVelDist = IDVelDistAsymHadley
   736:                 case default
   737:                   call MessageNotify( 'E', module_name, 'VelDist of %c is not supported.', c1 = trim( VelDist ) )
   738:                 end select
   739:             
   740:                 Alpha    = AlphaInDeg * PI / 180.0_DP
   741:             
   742:             
   743:                 ! 補助的な変数を計算するサブルーチン・関数群
   744:                 ! Subroutines and functions for calculating auxiliary variables
   745:                 !
   746:                 call AuxVarsInit
   747:             
   748:             
   749:                 ! 印字 ; Print
   750:                 !
   751:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   752:                 call MessageNotify( 'M', module_name, 'VelDist       = %c', c1 = trim( VelDist ) )
   753:                 call MessageNotify( 'M', module_name, 'Alpha         = %f', d = (/ Alpha /) )
   754:                 call MessageNotify( 'M', module_name, 'Tau           = %f', d = (/ Tau /) )
   755:                 call MessageNotify( 'M', module_name, 'Press0        = %f', d = (/ Press0 /) )
   756:                 call MessageNotify( 'M', module_name, 'Omega0        = %f', d = (/ Omega0 /) )
   757:                 call MessageNotify( 'M', module_name, 'HCSigmaTop    = %f', d = (/ HCSigmaTop /) )
   758:                 call MessageNotify( 'M', module_name, 'HCNumCell     = %d', i = (/ HCNumCell /) )
   759:             !!$    call MessageNotify( 'M', module_name, 'InFileNameForcing  = %c', c1 = trim(InFileNameForcing ) )
   760:                 call MessageNotify( 'M', module_name, 'HCV0          = %f', d = (/ HCV0 /) )
   761:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   762:             
   763:             
   764:                 adv_test_inited = .true.
   765:             
   766:             
   767:               end subroutine AdvTestInit
   768:             
   769:               !--------------------------------------------------------------------------------------
   770:             
   771:             end module adv_test
