Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: gauss_quad.f90
PROGRAM NAME: gauss_quad
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

    93  opt  (  11): Fused array assignments. :line 93 - 97
    93  vec  (   4): Vectorized array expression.
    93  vec  (  29): ADB is used for array.: a_x
    93  vec  (  29): ADB is used for array.: a_w
   140  vec  (   3): Unvectorized loop.
   140  vec  (  13): Overhead of loop division is too large.
   141  opt  (1019): Feedback of scalar value from one loop pass to another.
   141  vec  (  21): Unvectorizable dependency.
   148  vec  (   3): Unvectorized loop.
   148  vec  (   8): Unvectorizable loop structure.
   161  vec  (   3): Unvectorized loop.
   161  vec  (  13): Overhead of loop division is too large.
   162  opt  (1019): Feedback of scalar value from one loop pass to another.
   162  opt  (1019): Feedback of scalar value from one loop pass to another.
   162  vec  (  21): Unvectorizable dependency.
   163  vec  (  21): Unvectorizable dependency.
   171  opt  (1082): Backward transfers inhibit loop optimization.
   171  opt  (1036): Potential feedback - use directive if OK.
   175  opt  (1036): Potential feedback - use directive if OK.
   186  vec  (   3): Unvectorized loop.
   186  vec  (  13): Overhead of loop division is too large.
   187  opt  (1019): Feedback of scalar value from one loop pass to another.
   187  opt  (1019): Feedback of scalar value from one loop pass to another.
   187  vec  (  21): Unvectorizable dependency.
   188  vec  (  21): Unvectorizable dependency.
   196  opt  (1082): Backward transfers inhibit loop optimization.
   196  opt  (1036): Potential feedback - use directive if OK.
   200  opt  (1036): Potential feedback - use directive if OK.
   205  vec  (   1): Vectorized loop.
   206  opt  (1019): Feedback of scalar value from one loop pass to another.
   206  vec  (  26): Macro operation Product.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: gauss_quad.f90
PROGRAM NAME: gauss_quad
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != ガウス重み, 分点の計算
     2  !
     3  != Calculate Gauss node and Gaussian weight
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: gauss_quad.f90,v 1.3 2011-06-19 11:05:23 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module gauss_quad
    13    !
    14    != ガウス重み, 分点の計算
    15    !
    16    != Calculate Gauss node and Gaussian weight
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== References
    25    !
    26    !== Procedures List
    27    !
    28  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    29  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    30  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    31  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    32  !!$  ! ------------            :: ------------
    33  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    34  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    35  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    36  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    37    !
    38    !== NAMELIST
    39    !
    40  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    41    !
    42  
    43    ! USE statements
    44    !
    45  
    46    !
    47    ! Kind type parameter
    48    !
    49    use dc_types, only: DP      ! Double precision.
    50  
    51    ! 物理・数学定数設定
    52    ! Physical and mathematical constants settings
    53    !
    54    use constants0, only: &
    55      & PI                    ! $ \pi $ .
    56                              ! Circular constant
    57  
    58    ! Declaration statements
    59    !
    60    implicit none
    61    private
    62  
    63    !
    64    ! Public procedure
    65    !
    66    public:: GauLeg
    67  
    68  
    69    character(*), parameter:: module_name = 'gauss_quad'
    70                                ! モジュールの名称.
    71                                ! Module name
    72    character(*), parameter:: version = &
    73      & '$Name:  $' // &
    74      & '$Id: gauss_quad.f90,v 1.3 2011-06-19 11:05:23 yot Exp $'
    75                                ! モジュールのバージョン
    76                                ! Module version
    77  
    78  contains
    79  
    80    !--------------------------------------------------------------------------------------
    81  
    82    subroutine GauLeg( x1, x2, n, a_x, a_w )
    83  
    84      real(DP), intent(in ) :: x1,x2
    85      integer , intent(in ) :: n
    86      real(DP), intent(out) :: a_x(n)
    87      real(DP), intent(out) :: a_w(n)
    88  
    89  
    90  
    91      call GAUSS( n, a_x, a_w )
    92  
    93      a_w = a_w * 2.0_DP
     .  !cdir nodep                                                             
     .        do t31 = 1, t6                                                    
     .           a_w(t31) = a_w(t31)*2.00000000000000e+000                      
     .           a_x(t31) = (x2 - x1)*5.00000000000000e-001*a_x(t31) + (x1 + x2)
     .       1      *5.00000000000000e-001                                      
     .           a_w(t31) = a_w(t31)*(x2 - x1)*5.00000000000000e-001            
     .        enddo                                                             
    94  
    95      ! Change integration domain from [-1,1] to [x1,x2]
    96      a_x = ( x2 - x1 ) * 0.5_DP * a_x + ( x1 + x2 ) * 0.5_DP
    97      a_w = a_w * ( x2 - x1 ) * 0.5_DP
    98  
    99  
   100    end subroutine GauLeg
   101  
   102    !--------------------------------------------------------------------------------------
   103  
   104    ! Subroutine below is provided by Ishioka-san.
   105  
   106    !**********************************************************************
   107    !     CALCULATE GAUSSIAN LATITUDES AND WEIGHTS
   108    !**********************************************************************
   109    !     X(J): sin(\phi_j)
   110    !     W(J): w_j/2
   111    !**********************************************************************
   112  
   113    SUBROUTINE GAUSS(JM,X,W)
   114  
   115  !!$    IMPLICIT REAL*8(A-H,O-Z)
   116  !!$    PARAMETER(PI=3.1415926535897932385D0)
   117      integer, parameter :: NB=64
   118      integer, intent(in ) :: JM
   119  !!$    DIMENSION X(JM),W(JM),E(NB)
   120      real(DP), intent(out) :: X(JM)
   121      real(DP), intent(out) :: W(JM)
   122  
   123      real(DP) :: E(NB)
   124      real(DP) :: EPS
   125      real(DP) :: Z
   126      real(DP) :: P0
   127      real(DP) :: P1
   128      real(DP) :: DPTMP
   129      real(DP) :: DZ
   130      integer  :: JH
   131      integer  :: IFLAG
   132      integer  :: I
   133      integer  :: J
   134      integer  :: N
   135  
   136  
   137      JH=JM/2
   138  
   139      EPS=1
   140      DO I=1,NB
   141        EPS=EPS/2
   142        E(I)=EPS+1
   143      END DO
   144  
   145      I=0
   146      EPS=1
   147  10  CONTINUE
   148      I=I+1
   149      EPS=EPS/2
   150      IF(E(I).GT.1) GOTO 10
   151  
   152      EPS=EPS*16
   153  
   154      IF(MOD(JM,2).EQ.0) THEN
   155        DO J=1,JH
   156          Z=SIN(PI*(2*J-1)/(2*JM+1))
   157          IFLAG=0
   158  20      CONTINUE
   159          P0=0
   160          P1=1
   161          DO N=1,JM-1,2
   162            P0=((2*N-1)*Z*P1-(N-1)*P0)/N
   163            P1=((2*N+1)*Z*P0-N*P1)/(N+1)
   164          END DO
   165          DPTMP=JM*(P0-Z*P1)/(1-Z*Z)
   166          DZ=P1/DPTMP
   167          Z=Z-DZ
   168          IF(IFLAG.EQ.0) THEN
   169            IF(ABS(DZ/Z).LE.EPS) THEN
   170              IFLAG=1
   171              X(JM-JH+J)=Z
   172            END IF
   173            GOTO 20
   174          END IF
   175          W(JM-JH+J)=1/(DPTMP*DPTMP)/(1-X(JM-JH+J)*X(JM-JH+J))
   176          W(JH+1-J)=W(JM-JH+J)
   177          X(JH+1-J)=-X(JM-JH+J)
   178        END DO
   179      ELSE
   180        DO J=1,JH
   181          Z=SIN(PI*2*J/(2*JM+1))
   182          IFLAG=0
   183  30      CONTINUE
   184          P0=1
   185          P1=Z
   186          DO N=2,JM-1,2
   187            P0=((2*N-1)*Z*P1-(N-1)*P0)/N
   188            P1=((2*N+1)*Z*P0-N*P1)/(N+1)
   189          END DO
   190          DPTMP=JM*(P0-Z*P1)/(1-Z*Z)
   191          DZ=P1/DPTMP
   192          Z=Z-DZ
   193          IF(IFLAG.EQ.0) THEN
   194            IF(ABS(DZ/Z).LE.EPS) THEN
   195              IFLAG=1
   196              X(JM-JH+J)=Z
   197            END IF
   198            GOTO 30
   199          END IF
   200          W(JM-JH+J)=1/(DPTMP*DPTMP)/(1-X(JM-JH+J)*X(JM-JH+J))
   201          W(JH+1-J)=W(JM-JH+J)
   202          X(JH+1-J)=-X(JM-JH+J)
   203        END DO
   204        P0=1
   205        DO N=2,JM-1,2
   206          P0=-(N-1)*P0/N
   207        END DO
   208        DPTMP=JM*P0
   209        W(JH+1)=1/(DPTMP*DPTMP)
   210        X(JH+1)=0
   211      END IF
   212  
   213    END SUBROUTINE GAUSS
   214  
   215    !--------------------------------------------------------------------------------------
   216  
   217  end module gauss_quad
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: gauss_quad.f90
PROGRAM NAME: gauss_quad
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != ガウス重み, 分点の計算
     2:             !
     3:             != Calculate Gauss node and Gaussian weight
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: gauss_quad.f90,v 1.3 2011-06-19 11:05:23 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module gauss_quad
    13:               !
    14:               != ガウス重み, 分点の計算
    15:               !
    16:               != Calculate Gauss node and Gaussian weight
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! 
    23:               !
    24:               !== References
    25:               !
    26:               !== Procedures List
    27:               !
    28:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    29:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    30:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    31:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    32:             !!$  ! ------------            :: ------------
    33:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    34:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    35:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    36:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    37:               !
    38:               !== NAMELIST
    39:               !
    40:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    41:               !
    42:             
    43:               ! USE statements
    44:               !
    45:             
    46:               ! 
    47:               ! Kind type parameter
    48:               !
    49:               use dc_types, only: DP      ! Double precision.
    50:             
    51:               ! 物理・数学定数設定
    52:               ! Physical and mathematical constants settings
    53:               !
    54:               use constants0, only: &
    55:                 & PI                    ! $ \pi $ .
    56:                                         ! Circular constant
    57:             
    58:               ! Declaration statements
    59:               !
    60:               implicit none
    61:               private
    62:             
    63:               ! 
    64:               ! Public procedure
    65:               !
    66:               public:: GauLeg
    67:             
    68:             
    69:               character(*), parameter:: module_name = 'gauss_quad'
    70:                                           ! モジュールの名称.
    71:                                           ! Module name
    72:               character(*), parameter:: version = &
    73:                 & '$Name:  $' // &
    74:                 & '$Id: gauss_quad.f90,v 1.3 2011-06-19 11:05:23 yot Exp $'
    75:                                           ! モジュールのバージョン
    76:                                           ! Module version
    77:             
    78:             contains
    79:             
    80:               !--------------------------------------------------------------------------------------
    81:             
    82:               subroutine GauLeg( x1, x2, n, a_x, a_w )
    83:             
    84:                 real(DP), intent(in ) :: x1,x2
    85:                 integer , intent(in ) :: n
    86:                 real(DP), intent(out) :: a_x(n)
    87:                 real(DP), intent(out) :: a_w(n)
    88:             
    89:             
    90:             
    91:                 call GAUSS( n, a_x, a_w )
    92:             
    93: V------>A       a_w = a_w * 2.0_DP
    94: |           
    95: |               ! Change integration domain from [-1,1] to [x1,x2]
    96: |       A       a_x = ( x2 - x1 ) * 0.5_DP * a_x + ( x1 + x2 ) * 0.5_DP
    97: V------ A       a_w = a_w * ( x2 - x1 ) * 0.5_DP
    98:             
    99:             
   100:               end subroutine GauLeg
   101:             
   102:               !--------------------------------------------------------------------------------------
   103:             
   104:               ! Subroutine below is provided by Ishioka-san.
   105:             
   106:               !**********************************************************************
   107:               !     CALCULATE GAUSSIAN LATITUDES AND WEIGHTS               
   108:               !**********************************************************************
   109:               !     X(J): sin(\phi_j)
   110:               !     W(J): w_j/2
   111:               !**********************************************************************
   112:             
   113:               SUBROUTINE GAUSS(JM,X,W)
   114:             
   115:             !!$    IMPLICIT REAL*8(A-H,O-Z)
   116:             !!$    PARAMETER(PI=3.1415926535897932385D0)
   117:                 integer, parameter :: NB=64
   118:                 integer, intent(in ) :: JM
   119:             !!$    DIMENSION X(JM),W(JM),E(NB)
   120:                 real(DP), intent(out) :: X(JM)
   121:                 real(DP), intent(out) :: W(JM)
   122:             
   123:                 real(DP) :: E(NB)
   124:                 real(DP) :: EPS
   125:                 real(DP) :: Z
   126:                 real(DP) :: P0
   127:                 real(DP) :: P1
   128:                 real(DP) :: DPTMP
   129:                 real(DP) :: DZ
   130:                 integer  :: JH
   131:                 integer  :: IFLAG
   132:                 integer  :: I
   133:                 integer  :: J
   134:                 integer  :: N
   135:             
   136:             
   137:                 JH=JM/2
   138:             
   139:                 EPS=1
   140: +------>        DO I=1,NB
   141: |                 EPS=EPS/2
   142: |                 E(I)=EPS+1
   143: +------         END DO
   144:             
   145:                 I=0
   146:                 EPS=1
   147:             10  CONTINUE
   148:                 I=I+1
   149:                 EPS=EPS/2
   150:                 IF(E(I).GT.1) GOTO 10
   151:             
   152:                 EPS=EPS*16
   153:             
   154:                 IF(MOD(JM,2).EQ.0) THEN
   155: +------>          DO J=1,JH
   156: |                   Z=SIN(PI*(2*J-1)/(2*JM+1))
   157: |                   IFLAG=0
   158: |           20      CONTINUE
   159: |                   P0=0
   160: |                   P1=1
   161: |+----->            DO N=1,JM-1,2
   162: ||                    P0=((2*N-1)*Z*P1-(N-1)*P0)/N
   163: ||                    P1=((2*N+1)*Z*P0-N*P1)/(N+1)
   164: |+-----             END DO
   165: |                   DPTMP=JM*(P0-Z*P1)/(1-Z*Z)
   166: |                   DZ=P1/DPTMP
   167: |                   Z=Z-DZ
   168: |                   IF(IFLAG.EQ.0) THEN
   169: |                     IF(ABS(DZ/Z).LE.EPS) THEN
   170: |                       IFLAG=1
   171: |                       X(JM-JH+J)=Z
   172: |                     END IF
   173: |                     GOTO 20
   174: |                   END IF
   175: |                   W(JM-JH+J)=1/(DPTMP*DPTMP)/(1-X(JM-JH+J)*X(JM-JH+J))
   176: |                   W(JH+1-J)=W(JM-JH+J)
   177: |                   X(JH+1-J)=-X(JM-JH+J)
   178: +------           END DO
   179:                 ELSE
   180: +------>          DO J=1,JH
   181: |                   Z=SIN(PI*2*J/(2*JM+1))
   182: |                   IFLAG=0
   183: |           30      CONTINUE
   184: |                   P0=1
   185: |                   P1=Z
   186: |+----->            DO N=2,JM-1,2
   187: ||                    P0=((2*N-1)*Z*P1-(N-1)*P0)/N
   188: ||                    P1=((2*N+1)*Z*P0-N*P1)/(N+1)
   189: |+-----             END DO
   190: |                   DPTMP=JM*(P0-Z*P1)/(1-Z*Z)
   191: |                   DZ=P1/DPTMP
   192: |                   Z=Z-DZ
   193: |                   IF(IFLAG.EQ.0) THEN
   194: |                     IF(ABS(DZ/Z).LE.EPS) THEN
   195: |                       IFLAG=1
   196: |                       X(JM-JH+J)=Z
   197: |                     END IF
   198: |                     GOTO 30
   199: |                   END IF
   200: |                   W(JM-JH+J)=1/(DPTMP*DPTMP)/(1-X(JM-JH+J)*X(JM-JH+J))
   201: |                   W(JH+1-J)=W(JM-JH+J)
   202: |                   X(JH+1-J)=-X(JM-JH+J)
   203: +------           END DO
   204:                   P0=1
   205: V------>          DO N=2,JM-1,2
   206: |                   P0=-(N-1)*P0/N
   207: V------           END DO
   208:                   DPTMP=JM*P0
   209:                   W(JH+1)=1/(DPTMP*DPTMP)
   210:                   X(JH+1)=0
   211:                 END IF
   212:             
   213:               END SUBROUTINE GAUSS
   214:             
   215:               !--------------------------------------------------------------------------------------
   216:             
   217:             end module gauss_quad
