Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: i.netcdf_wrapper.F90
PROGRAM NAME: netcdf_wrapper
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != NetCDF のラッパープログラム
     2  !
     3  != NetCDF wrapper
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: netcdf_wrapper.F90,v 1.4 2015/01/29 12:02:28 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module netcdf_wrapper
    13    !
    14    != NetCDF のラッパープログラム
    15    !
    16    != NetCDF wrapper
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! gtool で扱わない部分をカバーする NetCDF のラッパープログラム.
    21    !
    22    ! The wrapper routines in this module treat NetCDF input/output that are not
    23    ! covered by gtool.
    24    !
    25    !== Procedures List
    26    !
    27    ! NWInqDimLen :: 軸の長さを問い合わせる
    28    ! ----------- :: ------------
    29    ! NWInqDimLen :: Inquire length of a dimension
    30    !
    31    !== NAMELIST
    32    !
    33    ! NAMELIST#radiation_DennouAGCM_nml
    34    !
    35  
    36    ! モジュール引用 ; USE statements
    37    !
    38  
    39    ! 種別型パラメタ
    40    ! Kind type parameter
    41    !
    42    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    43      &                 STRING     ! 文字列.       Strings.
    44  
    45    ! メッセージ出力
    46    ! Message output
    47    !
    48    use dc_message, only: MessageNotify
    49  
    50    ! NetCDF
    51    !
    52    use netcdf
    53  
    54    implicit none
    55  
    56    private
    57  
    58  
    59    public :: NWChkDim
    60    public :: NWInqDimLen
    61    public :: NWGetAtt
    62    public :: NWPresentAVarInFile
    63  
    64  
    65    interface NWGetAtt
    66      module procedure NWGetAttChar, NWGetAttInteger
    67    end interface
    68  
    69  
    70    character(*), parameter:: module_name = 'netcdf_wrapper'
    71                                ! モジュールの名称.
    72                                ! Module name
    73    character(*), parameter:: version = &
    74      & '$Name:  $' // &
    75      & '$Id: netcdf_wrapper.F90,v 1.4 2015/01/29 12:02:28 yot Exp $'
    76                                ! モジュールのバージョン
    77                                ! Module version
    78  
    79    !--------------------------------------------------------------------------
    80  
    81  contains
    82  
    83    !--------------------------------------------------------------------------
    84  
    85    function NWChkDim( &
    86      & ncfn,    & ! (in )
    87      & dimname  & ! (in )
    88      & ) result( FlagExist )
    89      !
    90      ! 軸の長さを問い合わせます.
    91      !
    92      ! Inquire length of a dimension.
    93      !
    94  
    95      character(*), intent(in ) :: ncfn
    96                                    ! NetCDF filename
    97      character(*), intent(in ) :: dimname
    98                                    ! Dimension name
    99      logical :: FlagExist
   100  
   101      !
   102      ! Local variables
   103      !
   104      character(STRING) :: mode
   105      integer           :: ncid
   106      integer           :: dimid
   107      integer           :: status
   108      character(STRING) :: err_mes
   109  
   110  
   111      err_mes = "In NWChkDim: " // trim( dimname ) // " in " // trim( ncfn )
   112  
   113      mode = "read"
   114      call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   115  
   116      status = NF90_inq_dimid( ncid, dimname, dimid )
   117  
   118      if ( status == NF90_EBADDIM ) then
   119        FlagExist = .false.
   120      else
   121        FlagExist = .true.
   122      end if
   123  
   124      call NWClose( ncid )
   125  
   126  
   127    end function NWChkDim
   128  
   129    !--------------------------------------------------------------------------
   130  
   131    subroutine NWInqDimLen( &
   132      & ncfn,    & ! (in )
   133      & dimname, & ! (in )
   134      & len      & ! (out)
   135      & )
   136      !
   137      ! 軸の長さを問い合わせます.
   138      !
   139      ! Inquire length of a dimension.
   140      !
   141  
   142      character(*), intent(in ) :: ncfn
   143                                    ! NetCDF filename
   144      character(*), intent(in ) :: dimname
   145                                    ! Dimension name
   146      integer     , intent(out) :: len
   147                                    ! Length of a dimension
   148  
   149  
   150      !
   151      ! Local variables
   152      !
   153      character(STRING) :: mode
   154      integer           :: ncid
   155      integer           :: dimid
   156      integer           :: status
   157      character(STRING) :: err_mes
   158  
   159  
   160      err_mes = "In NWInqDimLen: " // trim( dimname ) // " in " // trim( ncfn )
   161  
   162      mode = "read"
   163      call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   164  
   165      status = NF90_inq_dimid( ncid, dimname, dimid )
   166      call NWHandleErr( status, err_mes )
   167  
   168      status = NF90_Inquire_Dimension( ncid, dimid, len = len )
   169      call NWHandleErr( status, err_mes )
   170  
   171      call NWClose( ncid )
   172  
   173  
   174    end subroutine NWInqDimLen
   175  
   176    !--------------------------------------------------------------------------
   177  
   178    subroutine NWGetAttChar( ncfn, varname, attname, att )
   179  
   180      character(*), intent(in ) :: ncfn
   181                                    ! NetCDF filename
   182      character(*), intent(in ) :: varname
   183                                    ! Variable name
   184      character(*), intent(in ) :: attname
   185                                    ! Attribute name
   186      character(*), intent(out) :: att
   187                                    ! Attribute
   188  
   189  
   190      ! Local variables
   191      !
   192      character(STRING) :: mode
   193      integer           :: ncid
   194      integer           :: varid
   195      integer           :: status
   196      character(STRING) :: err_mes
   197  
   198  
   199      err_mes = "In NWGetAttChar"
   200      err_mes = trim( err_mes ) &
   201        // ', Var: ' // trim( varname ) // ', Att: ' // trim( attname )
   202  
   203      mode = "read"
   204      call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   205  
   206      if ( ( varname == 'global' ) .or. ( varname == 'GLOBAL' ) ) then
   207        varid = NF90_GLOBAL
   208      else
   209        status = nf90_inq_varid( ncid, varname, varid )
   210        call NWHandleErr( status, err_mes )
   211      end if
   212  
   213      status = nf90_get_att( ncid, varid, attname, att )
   214      call NWHandleErr( status, err_mes )
   215  
   216      call NWClose( ncid )
   217  
   218    end subroutine NWGetAttChar
   219  
   220    !--------------------------------------------------------------------------
   221  
   222    subroutine NWGetAttInteger( ncfn, varname, attname, att )
   223  
   224      character(*), intent(in ) :: ncfn
   225                                    ! NetCDF filename
   226      character(*), intent(in ) :: varname
   227                                    ! Variable name
   228      character(*), intent(in ) :: attname
   229                                    ! Attribute name
   230      integer     , intent(out) :: att
   231                                    ! Attribute
   232  
   233  
   234      ! Local variables
   235      !
   236      character(STRING) :: mode
   237      integer           :: ncid
   238      integer           :: varid
   239      integer           :: status
   240      character(STRING) :: err_mes
   241  
   242  
   243      err_mes = "In NWGetAttInteger"
   244      err_mes = trim( err_mes ) &
   245        // ', Var: ' // trim( varname ) // ', Att: ' // trim( attname )
   246  
   247      mode = "read"
   248      call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   249  
   250      if ( ( varname == 'global' ) .or. ( varname == 'GLOBAL' ) ) then
   251        varid = NF90_GLOBAL
   252      else
   253        status = nf90_inq_varid( ncid, varname, varid )
   254        call NWHandleErr( status, err_mes )
   255      end if
   256  
   257      status = nf90_get_att( ncid, varid, attname, att )
   258      call NWHandleErr( status, err_mes )
   259  
   260      call NWClose( ncid )
   261  
   262    end subroutine NWGetAttInteger
   263  
   264    !--------------------------------------------------------------------------
   265  
   266    function NWPresentAVarInFile( ncfn, varname ) result( Flag )
   267  
   268      character(*), intent(in ) :: ncfn
   269                                    ! NetCDF filename
   270      character(*), intent(in ) :: varname
   271                                    ! Variable name
   272  
   273      logical                   :: Flag
   274  
   275      ! Local variables
   276      !
   277      character(STRING) :: mode
   278      integer           :: ncid
   279      integer           :: varid
   280      integer           :: status
   281      character(STRING) :: err_mes
   282  
   283  
   284      err_mes = "In NWChkAVarInFile"
   285      err_mes = trim( err_mes ) // ', Var: ' // trim( varname )
   286  
   287      mode = "read"
   288      call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   289  
   290      status = nf90_inq_varid( ncid, varname, varid )
   291      if( status == nf90_noerr ) then
   292        Flag = .true.
   293      else
   294        Flag = .false.
   295        call MessageNotify( 'M', module_name, &
   296          & 'Variable, %c, cannot be found in file, %c.', &
   297          & c1 = trim(varname), c2 = trim(NWMkNCFN(ncfn)) &
   298          & )
   299      end if
   300  
   301      call NWClose( ncid )
   302  
   303    end function NWPresentAVarInFile
   304  
   305    !--------------------------------------------------------------------------
   306    ! Routines below are internal ones.
   307    !--------------------------------------------------------------------------
   308  
   309    character(STRING) function NWMkNCFN( ncfn_in ) result( ncfn_out )
   310  
   311      ! MPI wrapper
   312      !
   313      use mpi_wrapper, only : myrank
   314  
   315      character(*), intent(in ) :: ncfn_in
   316                                    ! NetCDF filename
   317  
   318  
   319  
   320      if ( ncfn_in(len_trim(ncfn_in)-2:len_trim(ncfn_in)) /= '.nc' ) then
   321        write( 6, * ) trim(ncfn_in), ' is inappropriate.'
   322        stop
   323      end if
   324      write( ncfn_out, '(a,a,i6.6,a)' ) ncfn_in(1:len_trim(ncfn_in)-3), '_rank', myrank, '.nc'
   325  
   326  
   327    end function NWMkNCFN
   328  
   329    !--------------------------------------------------------------------------
   330  
   331    subroutine NWHandleErr( &
   332      & status, &
   333      & err_mes &
   334      & )
   335  
   336      integer     , intent(in)           :: status
   337      character(*), intent(in), optional :: err_mes
   338  
   339  
   340      if( status .ne. nf90_noerr ) then
   341        if( present( err_mes ) ) print *, trim( err_mes )
   342        print *, trim( nf90_strerror( status ) )
   343        stop "STOP"
   344      end if
   345  
   346  
   347    end subroutine NWHandleErr
   348  
   349    !--------------------------------------------------------------------------
   350  
   351    subroutine NWOpen( &
   352      & path, &
   353      & mode, &
   354      & ncid &
   355      & )
   356  
   357      character(*), intent(in ) :: path
   358      character(*), intent(in ) :: mode
   359      integer     , intent(out) :: ncid
   360  
   361  
   362      ! Local variables
   363      !
   364      integer           :: cmode, omode
   365      integer           :: status
   366      character(STRING) :: err_mes
   367  
   368  
   369      err_mes = "In NWOpen"
   370      err_mes = trim( err_mes ) // ', path: ' // trim( path ) &
   371        // ', mode: ' // trim( mode )
   372  
   373  
   374      if( ( mode .eq. "new" ) .or. ( mode .eq. "NEW" ) ) then
   375  
   376        cmode = NF90_CLOBBER
   377        status = nf90_create( path, cmode, ncid )
   378        call NWHandleErr( status, err_mes )
   379  
   380      else
   381  
   382        if( ( mode .eq. "read" ) .or. ( mode .eq. "READ" ) ) then
   383          omode = NF90_NOWRITE
   384        else if( ( mode .eq. "write" ) .or. ( mode .eq. "WRITE" ) ) then
   385          omode = NF90_WRITE
   386        else
   387          write( 6, * ) "Inproper argument, mode"
   388          write( 6, * ) "Argument mode should be either of words below."
   389          write( 6, * ) " 'new', 'NEW', 'read', 'READ', 'write', or 'WRITE'"
   390          stop
   391        end if
   392  
   393        status = nf90_open( path, omode, ncid )
   394        call NWHandleErr( status, err_mes )
   395  
   396      end if
   397  
   398  
   399    end subroutine NWOpen
   400  
   401    !--------------------------------------------------------------------------
   402  
   403    subroutine NWClose( &
   404      & ncid &
   405      & )
   406  
   407      integer, intent(in) :: ncid
   408  
   409  
   410      ! Local variables
   411      !
   412      integer           :: status
   413      character(STRING) :: err_mes
   414  
   415  
   416      err_mes = "In NWClose"
   417  
   418  
   419      status = nf90_close( ncid )
   420      call NWHandleErr( status, err_mes )
   421  
   422    end subroutine NWClose
   423  
   424    !--------------------------------------------------------------------------
   425  
   426    subroutine NWReDef( &
   427      & ncid &
   428      & )
   429  
   430      integer, intent(in) :: ncid
   431  
   432  
   433      ! Local variables
   434      !
   435      integer           :: status
   436      character(STRING) :: err_mes
   437  
   438  
   439      err_mes = "In NWReDef"
   440  
   441  
   442      status = nf90_redef( ncid )
   443      if( ( status .ne. nf90_noerr ) .and. ( status .ne. nf90_eindefine ) ) &
   444        call NWHandleErr( status, err_mes )
   445  
   446  
   447    end subroutine NWReDef
   448  
   449    !--------------------------------------------------------------------------
   450  
   451    subroutine NWEndDef( &
   452      & ncid &
   453      & )
   454  
   455      integer, intent(in) :: ncid
   456  
   457  
   458      ! Local variables
   459      !
   460      integer           :: status
   461      character(STRING) :: err_mes
   462  
   463  
   464      err_mes = "In NWEndDef"
   465  
   466  
   467      status = nf90_enddef( ncid )
   468      if( ( status .ne. nf90_noerr ) .and. ( status .ne. nf90_enotindefine ) ) &
   469        call NWHandleErr( status, err_mes )
   470  
   471  
   472    end subroutine NWEndDef
   473  
   474    !--------------------------------------------------------------------------
   475  
   476  end module netcdf_wrapper
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: i.netcdf_wrapper.F90
PROGRAM NAME: netcdf_wrapper
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != NetCDF のラッパープログラム
     2:             !
     3:             != NetCDF wrapper
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: netcdf_wrapper.F90,v 1.4 2015/01/29 12:02:28 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module netcdf_wrapper
    13:               !
    14:               != NetCDF のラッパープログラム
    15:               !
    16:               != NetCDF wrapper
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! gtool で扱わない部分をカバーする NetCDF のラッパープログラム. 
    21:               !
    22:               ! The wrapper routines in this module treat NetCDF input/output that are not 
    23:               ! covered by gtool.
    24:               !
    25:               !== Procedures List
    26:               !
    27:               ! NWInqDimLen :: 軸の長さを問い合わせる
    28:               ! ----------- :: ------------
    29:               ! NWInqDimLen :: Inquire length of a dimension
    30:               !
    31:               !== NAMELIST
    32:               !
    33:               ! NAMELIST#radiation_DennouAGCM_nml
    34:               !
    35:             
    36:               ! モジュール引用 ; USE statements
    37:               !
    38:             
    39:               ! 種別型パラメタ
    40:               ! Kind type parameter
    41:               !
    42:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    43:                 &                 STRING     ! 文字列.       Strings.
    44:             
    45:               ! メッセージ出力
    46:               ! Message output
    47:               !
    48:               use dc_message, only: MessageNotify
    49:             
    50:               ! NetCDF
    51:               !
    52:               use netcdf
    53:             
    54:               implicit none
    55:             
    56:               private
    57:             
    58:             
    59:               public :: NWChkDim
    60:               public :: NWInqDimLen
    61:               public :: NWGetAtt
    62:               public :: NWPresentAVarInFile
    63:             
    64:             
    65:               interface NWGetAtt
    66:                 module procedure NWGetAttChar, NWGetAttInteger
    67:               end interface
    68:             
    69:             
    70:               character(*), parameter:: module_name = 'netcdf_wrapper'
    71:                                           ! モジュールの名称. 
    72:                                           ! Module name
    73:               character(*), parameter:: version = &
    74:                 & '$Name:  $' // &
    75:                 & '$Id: netcdf_wrapper.F90,v 1.4 2015/01/29 12:02:28 yot Exp $'
    76:                                           ! モジュールのバージョン
    77:                                           ! Module version
    78:             
    79:               !--------------------------------------------------------------------------
    80:             
    81:             contains
    82:             
    83:               !--------------------------------------------------------------------------
    84:             
    85:               function NWChkDim( &
    86:                 & ncfn,    & ! (in )
    87:                 & dimname  & ! (in )
    88:                 & ) result( FlagExist )
    89:                 !
    90:                 ! 軸の長さを問い合わせます. 
    91:                 !
    92:                 ! Inquire length of a dimension. 
    93:                 !
    94:             
    95:                 character(*), intent(in ) :: ncfn
    96:                                               ! NetCDF filename
    97:                 character(*), intent(in ) :: dimname
    98:                                               ! Dimension name
    99:                 logical :: FlagExist
   100:             
   101:                 !
   102:                 ! Local variables
   103:                 !
   104:                 character(STRING) :: mode
   105:                 integer           :: ncid
   106:                 integer           :: dimid
   107:                 integer           :: status
   108:                 character(STRING) :: err_mes
   109:             
   110:             
   111:                 err_mes = "In NWChkDim: " // trim( dimname ) // " in " // trim( ncfn )
   112:             
   113:                 mode = "read"
   114:                 call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   115:             
   116:                 status = NF90_inq_dimid( ncid, dimname, dimid )
   117:             
   118:                 if ( status == NF90_EBADDIM ) then
   119:                   FlagExist = .false.
   120:                 else
   121:                   FlagExist = .true.
   122:                 end if
   123:             
   124:                 call NWClose( ncid )
   125:             
   126:             
   127:               end function NWChkDim
   128:             
   129:               !--------------------------------------------------------------------------
   130:             
   131:               subroutine NWInqDimLen( &
   132:                 & ncfn,    & ! (in )
   133:                 & dimname, & ! (in )
   134:                 & len      & ! (out)
   135:                 & )
   136:                 !
   137:                 ! 軸の長さを問い合わせます. 
   138:                 !
   139:                 ! Inquire length of a dimension. 
   140:                 !
   141:             
   142:                 character(*), intent(in ) :: ncfn
   143:                                               ! NetCDF filename
   144:                 character(*), intent(in ) :: dimname
   145:                                               ! Dimension name
   146:                 integer     , intent(out) :: len
   147:                                               ! Length of a dimension
   148:             
   149:             
   150:                 !
   151:                 ! Local variables
   152:                 !
   153:                 character(STRING) :: mode
   154:                 integer           :: ncid
   155:                 integer           :: dimid
   156:                 integer           :: status
   157:                 character(STRING) :: err_mes
   158:             
   159:             
   160:                 err_mes = "In NWInqDimLen: " // trim( dimname ) // " in " // trim( ncfn )
   161:             
   162:                 mode = "read"
   163:                 call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   164:             
   165:                 status = NF90_inq_dimid( ncid, dimname, dimid )
   166:                 call NWHandleErr( status, err_mes )
   167:             
   168:                 status = NF90_Inquire_Dimension( ncid, dimid, len = len )
   169:                 call NWHandleErr( status, err_mes )
   170:             
   171:                 call NWClose( ncid )
   172:             
   173:             
   174:               end subroutine NWInqDimLen
   175:             
   176:               !--------------------------------------------------------------------------
   177:             
   178:               subroutine NWGetAttChar( ncfn, varname, attname, att )
   179:             
   180:                 character(*), intent(in ) :: ncfn
   181:                                               ! NetCDF filename
   182:                 character(*), intent(in ) :: varname
   183:                                               ! Variable name
   184:                 character(*), intent(in ) :: attname
   185:                                               ! Attribute name
   186:                 character(*), intent(out) :: att
   187:                                               ! Attribute
   188:             
   189:             
   190:                 ! Local variables
   191:                 !
   192:                 character(STRING) :: mode
   193:                 integer           :: ncid
   194:                 integer           :: varid
   195:                 integer           :: status
   196:                 character(STRING) :: err_mes
   197:             
   198:             
   199:                 err_mes = "In NWGetAttChar"
   200:                 err_mes = trim( err_mes ) &
   201:                   // ', Var: ' // trim( varname ) // ', Att: ' // trim( attname )
   202:             
   203:                 mode = "read"
   204:                 call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   205:             
   206:                 if ( ( varname == 'global' ) .or. ( varname == 'GLOBAL' ) ) then
   207:                   varid = NF90_GLOBAL
   208:                 else
   209:                   status = nf90_inq_varid( ncid, varname, varid )
   210:                   call NWHandleErr( status, err_mes )
   211:                 end if
   212:             
   213:                 status = nf90_get_att( ncid, varid, attname, att )
   214:                 call NWHandleErr( status, err_mes )
   215:             
   216:                 call NWClose( ncid )
   217:             
   218:               end subroutine NWGetAttChar
   219:             
   220:               !--------------------------------------------------------------------------
   221:             
   222:               subroutine NWGetAttInteger( ncfn, varname, attname, att )
   223:             
   224:                 character(*), intent(in ) :: ncfn
   225:                                               ! NetCDF filename
   226:                 character(*), intent(in ) :: varname
   227:                                               ! Variable name
   228:                 character(*), intent(in ) :: attname
   229:                                               ! Attribute name
   230:                 integer     , intent(out) :: att
   231:                                               ! Attribute
   232:             
   233:             
   234:                 ! Local variables
   235:                 !
   236:                 character(STRING) :: mode
   237:                 integer           :: ncid
   238:                 integer           :: varid
   239:                 integer           :: status
   240:                 character(STRING) :: err_mes
   241:             
   242:             
   243:                 err_mes = "In NWGetAttInteger"
   244:                 err_mes = trim( err_mes ) &
   245:                   // ', Var: ' // trim( varname ) // ', Att: ' // trim( attname )
   246:             
   247:                 mode = "read"
   248:                 call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   249:             
   250:                 if ( ( varname == 'global' ) .or. ( varname == 'GLOBAL' ) ) then
   251:                   varid = NF90_GLOBAL
   252:                 else
   253:                   status = nf90_inq_varid( ncid, varname, varid )
   254:                   call NWHandleErr( status, err_mes )
   255:                 end if
   256:             
   257:                 status = nf90_get_att( ncid, varid, attname, att )
   258:                 call NWHandleErr( status, err_mes )
   259:             
   260:                 call NWClose( ncid )
   261:             
   262:               end subroutine NWGetAttInteger
   263:             
   264:               !--------------------------------------------------------------------------
   265:             
   266:               function NWPresentAVarInFile( ncfn, varname ) result( Flag )
   267:             
   268:                 character(*), intent(in ) :: ncfn
   269:                                               ! NetCDF filename
   270:                 character(*), intent(in ) :: varname
   271:                                               ! Variable name
   272:             
   273:                 logical                   :: Flag
   274:             
   275:                 ! Local variables
   276:                 !
   277:                 character(STRING) :: mode
   278:                 integer           :: ncid
   279:                 integer           :: varid
   280:                 integer           :: status
   281:                 character(STRING) :: err_mes
   282:             
   283:             
   284:                 err_mes = "In NWChkAVarInFile"
   285:                 err_mes = trim( err_mes ) // ', Var: ' // trim( varname )
   286:             
   287:                 mode = "read"
   288:                 call NWOpen( NWMkNCFN(ncfn), mode, ncid )
   289:             
   290:                 status = nf90_inq_varid( ncid, varname, varid )
   291:                 if( status == nf90_noerr ) then
   292:                   Flag = .true.
   293:                 else
   294:                   Flag = .false.
   295:                   call MessageNotify( 'M', module_name, &
   296:                     & 'Variable, %c, cannot be found in file, %c.', &
   297:                     & c1 = trim(varname), c2 = trim(NWMkNCFN(ncfn)) &
   298:                     & )
   299:                 end if
   300:             
   301:                 call NWClose( ncid )
   302:             
   303:               end function NWPresentAVarInFile
   304:             
   305:               !--------------------------------------------------------------------------
   306:               ! Routines below are internal ones.
   307:               !--------------------------------------------------------------------------
   308:             
   309:               character(STRING) function NWMkNCFN( ncfn_in ) result( ncfn_out )
   310:             
   311:                 ! MPI wrapper
   312:                 !
   313:                 use mpi_wrapper, only : myrank
   314:             
   315:                 character(*), intent(in ) :: ncfn_in
   316:                                               ! NetCDF filename
   317:             
   318:             
   319:             
   320:                 if ( ncfn_in(len_trim(ncfn_in)-2:len_trim(ncfn_in)) /= '.nc' ) then
   321:                   write( 6, * ) trim(ncfn_in), ' is inappropriate.'
   322:                   stop
   323:                 end if
   324:                 write( ncfn_out, '(a,a,i6.6,a)' ) ncfn_in(1:len_trim(ncfn_in)-3), '_rank', myrank, '.nc'
   325:             
   326:             
   327:               end function NWMkNCFN
   328:             
   329:               !--------------------------------------------------------------------------
   330:             
   331:               subroutine NWHandleErr( &
   332:                 & status, &
   333:                 & err_mes &
   334:                 & )
   335:             
   336:                 integer     , intent(in)           :: status
   337:                 character(*), intent(in), optional :: err_mes
   338:             
   339:             
   340:                 if( status .ne. nf90_noerr ) then
   341:                   if( present( err_mes ) ) print *, trim( err_mes )
   342:                   print *, trim( nf90_strerror( status ) )
   343:                   stop "STOP"
   344:                 end if
   345:             
   346:             
   347:               end subroutine NWHandleErr
   348:             
   349:               !--------------------------------------------------------------------------
   350:             
   351:               subroutine NWOpen( &
   352:                 & path, &
   353:                 & mode, &
   354:                 & ncid &
   355:                 & )
   356:             
   357:                 character(*), intent(in ) :: path
   358:                 character(*), intent(in ) :: mode
   359:                 integer     , intent(out) :: ncid
   360:             
   361:             
   362:                 ! Local variables
   363:                 !
   364:                 integer           :: cmode, omode
   365:                 integer           :: status
   366:                 character(STRING) :: err_mes
   367:             
   368:             
   369:                 err_mes = "In NWOpen"
   370:                 err_mes = trim( err_mes ) // ', path: ' // trim( path ) &
   371:                   // ', mode: ' // trim( mode )
   372:             
   373:             
   374:                 if( ( mode .eq. "new" ) .or. ( mode .eq. "NEW" ) ) then
   375:             
   376:                   cmode = NF90_CLOBBER
   377:                   status = nf90_create( path, cmode, ncid )
   378:                   call NWHandleErr( status, err_mes )
   379:             
   380:                 else
   381:             
   382:                   if( ( mode .eq. "read" ) .or. ( mode .eq. "READ" ) ) then
   383:                     omode = NF90_NOWRITE
   384:                   else if( ( mode .eq. "write" ) .or. ( mode .eq. "WRITE" ) ) then
   385:                     omode = NF90_WRITE
   386:                   else
   387:                     write( 6, * ) "Inproper argument, mode"
   388:                     write( 6, * ) "Argument mode should be either of words below."
   389:                     write( 6, * ) " 'new', 'NEW', 'read', 'READ', 'write', or 'WRITE'"
   390:                     stop
   391:                   end if
   392:             
   393:                   status = nf90_open( path, omode, ncid )
   394:                   call NWHandleErr( status, err_mes )
   395:             
   396:                 end if
   397:             
   398:             
   399:               end subroutine NWOpen
   400:             
   401:               !--------------------------------------------------------------------------
   402:             
   403:               subroutine NWClose( &
   404:                 & ncid &
   405:                 & )
   406:             
   407:                 integer, intent(in) :: ncid
   408:             
   409:             
   410:                 ! Local variables
   411:                 !
   412:                 integer           :: status
   413:                 character(STRING) :: err_mes
   414:             
   415:             
   416:                 err_mes = "In NWClose"
   417:             
   418:             
   419:                 status = nf90_close( ncid )
   420:                 call NWHandleErr( status, err_mes )
   421:             
   422:               end subroutine NWClose
   423:             
   424:               !--------------------------------------------------------------------------
   425:             
   426:               subroutine NWReDef( &
   427:                 & ncid &
   428:                 & )
   429:             
   430:                 integer, intent(in) :: ncid
   431:             
   432:             
   433:                 ! Local variables
   434:                 !
   435:                 integer           :: status
   436:                 character(STRING) :: err_mes
   437:             
   438:             
   439:                 err_mes = "In NWReDef"
   440:             
   441:             
   442:                 status = nf90_redef( ncid )
   443:                 if( ( status .ne. nf90_noerr ) .and. ( status .ne. nf90_eindefine ) ) &
   444:                   call NWHandleErr( status, err_mes )
   445:             
   446:             
   447:               end subroutine NWReDef
   448:             
   449:               !--------------------------------------------------------------------------
   450:             
   451:               subroutine NWEndDef( &
   452:                 & ncid &
   453:                 & )
   454:             
   455:                 integer, intent(in) :: ncid
   456:             
   457:             
   458:                 ! Local variables
   459:                 !
   460:                 integer           :: status
   461:                 character(STRING) :: err_mes
   462:             
   463:             
   464:                 err_mes = "In NWEndDef"
   465:             
   466:             
   467:                 status = nf90_enddef( ncid )
   468:                 if( ( status .ne. nf90_noerr ) .and. ( status .ne. nf90_enotindefine ) ) &
   469:                   call NWHandleErr( status, err_mes )
   470:             
   471:             
   472:               end subroutine NWEndDef
   473:             
   474:               !--------------------------------------------------------------------------
   475:             
   476:             end module netcdf_wrapper
