Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:30 2016
FILE NAME: initial_data.f90
PROGRAM NAME: initial_data
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   272  opt  (  11): Fused array assignments. :line 272 - 274
   272  opt  (1593): Loop nest collapsed into one loop.
   272  vec  (   4): Vectorized array expression.
   272  vec  (  29): ADB is used for array.: xyz_temp
   272  vec  (  29): ADB is used for array.: xyz_v
   272  vec  (  29): ADB is used for array.: xyz_u
   275  opt  (1593): Loop nest collapsed into one loop.
   275  vec  (   4): Vectorized array expression.
   275  vec  (  29): ADB is used for array.: xy_ps
   277  opt  (1593): Loop nest collapsed into one loop.
   277  vec  (   4): Vectorized array expression.
   277  vec  (  29): ADB is used for array.: xyzf_qmix
   278  vec  (   3): Unvectorized loop.
   278  vec  (  13): Overhead of loop division is too large.
   280  opt  (1593): Loop nest collapsed into one loop.
   280  vec  (   4): Vectorized array expression.
   280  vec  (  29): ADB is used for array.: xyzf_qmix
   283  vec  (   3): Unvectorized loop.
   283  vec  (  13): Overhead of loop division is too large.
   284  vec  (  18): Unvectorizable data type.
   285  opt  (1593): Loop nest collapsed into one loop.
   285  vec  (   4): Vectorized array expression.
   285  vec  (  29): ADB is used for array.: xyzf_qmix
   294  opt  (1592): Outer loop unrolled inside inner loop.
   295  opt  (1590): Inner loop moved outside outer loop(s).
   296  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   296  vec  (   1): Vectorized loop.
   296  vec  (  29): ADB is used for array.: xyz_temp
   296  vec  (  29): ADB is used for array.: x_lon
   296  vec  (   1): Vectorized loop.
   296  vec  (  29): ADB is used for array.: xyz_temp
   296  vec  (  29): ADB is used for array.: x_lon
   308  vec  (   3): Unvectorized loop.
   308  vec  (  13): Overhead of loop division is too large.
   309  opt  (1592): Outer loop unrolled inside inner loop.
   309  vec  (   4): Vectorized array expression.
   309  vec  (  29): ADB is used for array.: xyz_u
   309  vec  (   4): Vectorized array expression.
   309  vec  (  29): ADB is used for array.: xyz_u
   318  opt  (  11): Fused array assignments. :line 318 - 320
   318  opt  (1593): Loop nest collapsed into one loop.
   318  vec  (   4): Vectorized array expression.
   318  vec  (  29): ADB is used for array.: xyz_temp
   318  vec  (  29): ADB is used for array.: xyz_v
   318  vec  (  29): ADB is used for array.: xyz_u
   321  opt  (1593): Loop nest collapsed into one loop.
   321  vec  (   4): Vectorized array expression.
   321  vec  (  29): ADB is used for array.: xy_ps
   323  opt  (1593): Loop nest collapsed into one loop.
   323  vec  (   4): Vectorized array expression.
   323  vec  (  29): ADB is used for array.: xyzf_qmix
   324  vec  (   3): Unvectorized loop.
   324  vec  (  13): Overhead of loop division is too large.
   326  opt  (1593): Loop nest collapsed into one loop.
   326  vec  (   4): Vectorized array expression.
   326  vec  (  29): ADB is used for array.: xyzf_qmix
   334  opt  (1592): Outer loop unrolled inside inner loop.
   335  vec  (   1): Vectorized loop.
   335  vec  (  29): ADB is used for array.: xyz_temp
   335  vec  (   1): Vectorized loop.
   335  vec  (  29): ADB is used for array.: xyz_temp
   353  vec  (   3): Unvectorized loop.
   353  vec  (  13): Overhead of loop division is too large.
   354  opt  (1592): Outer loop unrolled inside inner loop.
   354  vec  (   4): Vectorized array expression.
   354  vec  (  29): ADB is used for array.: xyz_u
   354  vec  (   4): Vectorized array expression.
   354  vec  (  29): ADB is used for array.: xyz_u
   365  vec  (   3): Unvectorized loop.
   365  vec  (  13): Overhead of loop division is too large.
   367  opt  (1593): Loop nest collapsed into one loop.
   367  vec  (   4): Vectorized array expression.
   367  vec  (  29): ADB is used for array.: xyzf_qmix
   382  vec  (   3): Unvectorized loop.
   382  vec  (  13): Overhead of loop division is too large.
   384  opt  (1592): Outer loop unrolled inside inner loop.
   384  vec  (   4): Vectorized array expression.
   384  vec  (  29): ADB is used for array.: xyzf_qmix
   384  vec  (   4): Vectorized array expression.
   384  vec  (  29): ADB is used for array.: xyzf_qmix
   386  opt  (1592): Outer loop unrolled inside inner loop.
   386  vec  (   4): Vectorized array expression.
   386  vec  (  29): ADB is used for array.: xyzf_qmix
   386  vec  (   4): Vectorized array expression.
   386  vec  (  29): ADB is used for array.: xyzf_qmix
   397  vec  (   3): Unvectorized loop.
   397  vec  (  13): Overhead of loop division is too large.
   399  opt  (1593): Loop nest collapsed into one loop.
   399  vec  (   4): Vectorized array expression.
   399  vec  (  29): ADB is used for array.: xyzf_qmix
   405  opt  (  11): Fused array assignments. :line 405 - 406
   405  opt  (1593): Loop nest collapsed into one loop.
   405  vec  (   4): Vectorized array expression.
   405  vec  (  29): ADB is used for array.: xyz_v
   405  vec  (  29): ADB is used for array.: xyz_u
   412  vec  (   3): Unvectorized loop.
   412  vec  (  13): Overhead of loop division is too large.
   413  opt  (1593): Loop nest collapsed into one loop.
   413  vec  (   4): Vectorized array expression.
   413  vec  (  29): ADB is used for array.: xyz_press
   413  vec  (  29): ADB is used for array.: xy_ps
   419  vec  (   3): Unvectorized loop.
   419  vec  (  13): Overhead of loop division is too large.
   421  opt  (1593): Loop nest collapsed into one loop.
   421  vec  (   4): Vectorized array expression.
   421  vec  (  29): ADB is used for array.: xyzf_qmix
   441  opt  (1593): Loop nest collapsed into one loop.
   441  vec  (   4): Vectorized array expression.
   441  vec  (  29): ADB is used for array.: xyz_temp
   442  opt  (1593): Loop nest collapsed into one loop.
   442  vec  (   4): Vectorized array expression.
   442  vec  (  29): ADB is used for array.: xy_ps
   545  opt  (  11): Fused array assignments. :line 545 - 547
   545  opt  (1593): Loop nest collapsed into one loop.
   545  vec  (   4): Vectorized array expression.
   545  vec  (  29): ADB is used for array.: xyz_temp
   545  vec  (  29): ADB is used for array.: xyz_v
   545  vec  (  29): ADB is used for array.: xyz_u
   548  opt  (1593): Loop nest collapsed into one loop.
   548  vec  (   4): Vectorized array expression.
   548  vec  (  29): ADB is used for array.: xy_ps
   549  opt  (  11): Fused array assignments. :line 549 - 554
   549  opt  (1593): Loop nest collapsed into one loop.
   549  vec  (   4): Vectorized array expression.
   549  vec  (  29): ADB is used for array.: xyz_qvap
   555  opt  (1593): Loop nest collapsed into one loop.
   555  vec  (   4): Vectorized array expression.
   557  vec  (   3): Unvectorized loop.
   557  vec  (  13): Overhead of loop division is too large.
   558  opt  (1593): Loop nest collapsed into one loop.
   558  vec  (   4): Vectorized array expression.
   558  vec  (  29): ADB is used for array.: xyz_temp
   562  opt  (1592): Outer loop unrolled inside inner loop.
   562  vec  (   4): Vectorized array expression.
   562  vec  (  29): ADB is used for array.: xyz_temp
   562  vec  (  29): ADB is used for array.: xy_tempmin
   562  vec  (   4): Vectorized array expression.
   562  vec  (  29): ADB is used for array.: xyz_temp
   562  vec  (  29): ADB is used for array.: xy_tempmin
   564  opt  (1057): Complicated use of variable inhibits loop optimization.
   564  opt  (1593): Loop nest collapsed into one loop.
   564  vec  (   4): Vectorized array expression.
   564  vec  (  29): ADB is used for array.: xy_tempmin
   564  vec  (  29): ADB is used for array.: xyz_temp
   572  opt  (1592): Outer loop unrolled inside inner loop.
   573  vec  (   1): Vectorized loop.
   573  vec  (  29): ADB is used for array.: xyz_temp
   573  vec  (   1): Vectorized loop.
   573  vec  (  29): ADB is used for array.: xyz_temp
   591  vec  (   3): Unvectorized loop.
   591  vec  (  13): Overhead of loop division is too large.
   592  opt  (1593): Loop nest collapsed into one loop.
   592  vec  (   4): Vectorized array expression.
   592  vec  (  29): ADB is used for array.: xyz_press
   592  vec  (  29): ADB is used for array.: xy_ps
   600  opt  (  11): Fused array assignments. :line 600 - 602
   600  opt  (1592): Outer loop unrolled inside inner loop.
   600  vec  (   4): Vectorized array expression.
   600  vec  (  29): ADB is used for array.: xyz_qvap
   600  vec  (  29): ADB is used for array.: xyz_qvapsat
   600  vec  (   4): Vectorized array expression.
   600  vec  (  29): ADB is used for array.: xyz_qvap
   600  vec  (  29): ADB is used for array.: xyz_qvapsat
   754  vec  (   3): Unvectorized loop.
   754  vec  (  13): Overhead of loop division is too large.
   755  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   755  vec  (   4): Vectorized array expression.
   755  vec  (  29): ADB is used for array.: d1
   755  vec  (  29): ADB is used for array.: z_sigma
   755  vec  (   4): Vectorized array expression.
   755  vec  (  29): ADB is used for array.: d1
   758  vec  (   1): Vectorized loop.
   758  vec  (  29): ADB is used for array.: z_height
   778  opt  (  11): Fused array assignments. :line 778 - 781
   778  vec  (   4): Vectorized array expression.
   778  vec  (  29): ADB is used for array.: z_height
   791  opt  (  11): Fused array assignments. :line 791 - 793
   791  opt  (1593): Loop nest collapsed into one loop.
   791  vec  (   4): Vectorized array expression.
   791  vec  (  29): ADB is used for array.: xyz_temp
   791  vec  (  29): ADB is used for array.: xyz_v
   791  vec  (  29): ADB is used for array.: xyz_u
   794  opt  (1593): Loop nest collapsed into one loop.
   794  vec  (   4): Vectorized array expression.
   794  vec  (  29): ADB is used for array.: xy_ps
   795  opt  (1593): Loop nest collapsed into one loop.
   795  vec  (   4): Vectorized array expression.
   795  vec  (  29): ADB is used for array.: xyz_qvap
   802  vec  (   3): Unvectorized loop.
   802  vec  (  13): Overhead of loop division is too large.
   804  vec  (   4): Vectorized array expression.
   804  vec  (  29): ADB is used for array.: xyz_u
   806  vec  (   4): Vectorized array expression.
   806  vec  (  29): ADB is used for array.: xyz_u
   817  opt  (1017): Subroutine call prevents optimization.
   819  opt  (1772): Loop nest fused with following nest(s).
   820  vec  (   1): Vectorized loop.
   820  vec  (  29): ADB is used for array.: a_gauquadlat
   844  opt  (1592): Outer loop unrolled inside inner loop.
   844  vec  (   3): Unvectorized loop.
   844  vec  (  13): Overhead of loop division is too large.
   844  vec  (   3): Unvectorized loop.
   844  vec  (  13): Overhead of loop division is too large.
   845  vec  (   4): Vectorized array expression.
   845  vec  (  29): ADB is used for array.: xyz_temp
   845  vec  (   4): Vectorized array expression.
   845  vec  (  29): ADB is used for array.: xyz_temp
   847  vec  (  13): Overhead of loop division is too large.
   848  opt  (1592): Outer loop unrolled inside inner loop.
   848  vec  (  16): Unvectorizable procedure reference.:maxvl
   848  vec  (   3): Unvectorized loop.
   848  vec  (  13): Overhead of loop division is too large.
   849  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   849  vec  (  16): Unvectorizable procedure reference.:maxvl
   849  vec  (   4): Vectorized array expression.
   849  vec  (  29): ADB is used for array.: xyz_temp
   857  opt  (1592): Outer loop unrolled inside inner loop.
   859  vec  (   1): Vectorized loop.
   859  vec  (  29): ADB is used for array.: y_lat_weight
   859  vec  (  29): ADB is used for array.: xyz_temp
   859  vec  (   1): Vectorized loop.
   859  vec  (  29): ADB is used for array.: xyz_temp
   859  vec  (  29): ADB is used for array.: y_lat_weight
   860  vec  (  26): Macro operation Sum/InnerProd.
   860  vec  (  26): Macro operation Sum/InnerProd.
   863  vec  (   4): Vectorized array expression.
   867  vec  (   3): Unvectorized loop.
   867  vec  (  13): Overhead of loop division is too large.
   868  opt  (1593): Loop nest collapsed into one loop.
   868  vec  (   4): Vectorized array expression.
   868  vec  (  29): ADB is used for array.: xyz_temp
   890  opt  (1592): Outer loop unrolled inside inner loop.
   891  opt  (1590): Inner loop moved outside outer loop(s).
   892  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   892  vec  (   1): Vectorized loop.
   892  vec  (  29): ADB is used for array.: xyz_temp
   892  vec  (  29): ADB is used for array.: x_lon
   892  vec  (   1): Vectorized loop.
   892  vec  (  29): ADB is used for array.: xyz_temp
   892  vec  (  29): ADB is used for array.: x_lon
  1010  opt  (1593): Loop nest collapsed into one loop.
  1010  vec  (   4): Vectorized array expression.
  1014  opt  (1593): Loop nest collapsed into one loop.
  1014  vec  (   4): Vectorized array expression.
  1014  vec  (  29): ADB is used for array.: xyz_temp
  1019  opt  (1593): Loop nest collapsed into one loop.
  1019  vec  (   4): Vectorized array expression.
  1019  vec  (  29): ADB is used for array.: xyr_temp
  1019  vec  (  29): ADB is used for array.: xyz_temp
  1020  opt  (1593): Loop nest collapsed into one loop.
  1020  vec  (   1): Vectorized loop.
  1020  vec  (  29): ADB is used for array.: xyr_temp
  1020  vec  (  29): ADB is used for array.: xyz_temp
  1023  opt  (  11): Fused array assignments. :line 1023 - 1026
  1023  opt  (1593): Loop nest collapsed into one loop.
  1023  vec  (   4): Vectorized array expression.
  1023  vec  (  29): ADB is used for array.: xyz_height
  1023  vec  (  29): ADB is used for array.: xy_surfheight
  1023  vec  (  29): ADB is used for array.: xyr_temp
  1023  vec  (  29): ADB is used for array.: xyz_temp
  1029  vec  (   3): Unvectorized loop.
  1029  vec  (  13): Overhead of loop division is too large.
  1030  opt  (1037): Feedback of array elements.
  1030  opt  (1593): Loop nest collapsed into one loop.
  1030  vec  (   4): Vectorized array expression.
  1030  vec  (  29): ADB is used for array.: xyz_height
  1030  vec  (  29): ADB is used for array.: xyr_temp
  1036  opt  (1057): Complicated use of variable inhibits loop optimization.
  1036  opt  (1593): Loop nest collapsed into one loop.
  1036  vec  (   4): Vectorized array expression.
  1036  vec  (  29): ADB is used for array.: xyz_temp
  1036  vec  (  29): ADB is used for array.: xyz_height
  1037  vec  (   3): Unvectorized loop.
  1037  vec  (  13): Overhead of loop division is too large.
  1038  opt  (  11): Fused array assignments. :line 1038 - 1041
  1038  opt  (1593): Loop nest collapsed into one loop.
  1038  vec  (   4): Vectorized array expression.
  1038  vec  (  29): ADB is used for array.: xyz_temp
  1038  vec  (  29): ADB is used for array.: xyz_height
  1053  opt  (1592): Outer loop unrolled inside inner loop.
  1053  vec  (   3): Unvectorized loop.
  1053  vec  (  13): Overhead of loop division is too large.
  1053  vec  (   3): Unvectorized loop.
  1053  vec  (  13): Overhead of loop division is too large.
  1054  vec  (   4): Vectorized array expression.
  1054  vec  (  29): ADB is used for array.: xyz_u
  1054  vec  (   4): Vectorized array expression.
  1054  vec  (  29): ADB is used for array.: xyz_u
  1057  opt  (  11): Fused array assignments. :line 1057 - 1058
  1057  opt  (1593): Loop nest collapsed into one loop.
  1057  vec  (   4): Vectorized array expression.
  1057  vec  (  29): ADB is used for array.: xyz_qvap
  1057  vec  (  29): ADB is used for array.: xyz_v
  1059  opt  (1593): Loop nest collapsed into one loop.
  1059  vec  (   4): Vectorized array expression.
  1059  vec  (  29): ADB is used for array.: xy_ps
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:30 2016
FILE NAME: initial_data.f90
PROGRAM NAME: initial_data
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 初期値データ提供
     2  !
     3  != Prepare initial data
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. TAKAHASHI (code by Taro KITANO is included)
     6  ! Version::   $Id: initial_data.f90,v 1.16 2015/02/17 23:50:42 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module initial_data
    13    !
    14    != 初期値データ提供
    15    !
    16    != Prepare initial data
    17    !
    18    ! 初期値データのサンプルを提供します.
    19    !
    20    ! 現在は以下のデータを提供します.
    21    !
    22    ! * Small Disturbance of Temperature
    23    !   * 風速: 0 [m/s], 地表面気圧: 1.0e+5 [Pa], 比湿: 1.0e-10 [kg kg-1]
    24    !   * 温度: 250 [K] に微小擾乱を加えたもの
    25    !
    26    ! * [AGCM 5.3]{http://www.gfd-dennou.org/library/agcm5} Default
    27    !   * 風速: 0 [m/s], 地表面気圧: 1.0e+5 [Pa], 比湿: 1.0e-10 [kg kg-1]
    28    !   * 温度: 250 [K] に微小擾乱を加えたもの
    29    !
    30    ! * Sugiyama et al. (2008)
    31    !   * 木星大気を想定した, Sugiyama et al. (2008) で用いられていた
    32    !     初期値を模倣する.
    33    !   * 風速: 0 [m/s], 地表面気圧: 3.0e+6 [Pa]
    34    !   * 温度: $ \sigma = 1 $ で 490 [K] とし, 気圧 1.0e+4 となる高度まで,
    35    !     温位一定で (乾燥断熱線に沿って) 高度に伴い温度を減少させる.
    36    !     気圧 1.0e+4 以下の高度では温度一定とする.
    37    !   * 比湿: $ \sigma = 1 $ で 6.11641e-3 [kg kg-1] とし,
    38    !     比湿が飽和比湿の 75 % となる高度までは一定とする.
    39    !     その高度以上では, 比湿を飽和比湿の 75 % とする.
    40    !
    41    ! Prepare sample data of initial data (restart data)
    42    !
    43    ! Now, following data are provided.
    44    !
    45    ! * Small Disturbance of Temperature
    46    !   * Velocity: 0 [m/s], Surface pressure: 1.0e+5 [Pa],
    47    !     Specific humidity: 1.0e-10 [kg kg-1]
    48    !   * Temperature: 250 [K] and perturbation
    49    !
    50    ! * [AGCM 5.3]{http://www.gfd-dennou.org/library/agcm5} Default
    51    !   * Velocity: 0 [m/s], Surface pressure: 1.0e+5 [Pa],
    52    !     Specific humidity: 1.0e-10 [kg kg-1]
    53    !   * Temperature: 250 [K] and perturbation
    54    !
    55    ! * Sugiyama et al. (2008)
    56    !   * Initial data like a Jovian atmosphere
    57    !     that is used in Sugiyama et al. (2008) is imitated.
    58    !   * Velocity: 0 [m/s], Surface pressure: 3.0e+6 [Pa]
    59    !   * Temperature: 490 [K] at $ \sigma = 1 $ .
    60    !     And it is declined with constant potential temperature
    61    !     (along dry adiabat line)
    62    !     below where air pressure is 1.0e+4.
    63    !     It is constant above where air pressure is 1.0e+4.
    64    !   * Specific humidity: 6.11641e-3 [kg kg-1] at $ \sigma = 1 $ .
    65    !     And it is constant below where it is same as 75 % of
    66    !     saturation specific humidity.
    67    !     Above that, specific humidity is 75 % of saturation specific humidity.
    68    !
    69    !== Procedures List
    70    !
    71    ! SetInitData   :: 初期値データ取得
    72    ! ------------  :: ------------
    73    ! SetInitData   :: Get initial data
    74    !
    75    !== NAMELIST
    76    !
    77    ! NAMELIST#initial_data_nml
    78    !
    79  
    80    ! モジュール引用 ; USE statements
    81    !
    82  
    83    ! 格子点設定
    84    ! Grid points settings
    85    !
    86    use gridset, only: imax, & ! 経度格子点数.
    87                               ! Number of grid points in longitude
    88      &                jmax, & ! 緯度格子点数.
    89                               ! Number of grid points in latitude
    90      &                kmax    ! 鉛直層数.
    91                               ! Number of vertical level
    92  
    93    ! 組成に関わる配列の設定
    94    ! Settings of array for atmospheric composition
    95    !
    96    use composition, only: &
    97      &                    ncmax, &
    98                                ! 成分の数
    99                                ! Number of composition
   100      &                    IndexH2OVap
   101  
   102    ! 種別型パラメタ
   103    ! Kind type parameter
   104    !
   105    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   106      &                 STRING     ! 文字列.       Strings.
   107  
   108    ! 種別型パラメタ
   109    ! Kind type parameter
   110    !
   111    use dc_types, only: DP     ! 倍精度実数型. Double precision.
   112  
   113    ! メッセージ出力
   114    ! Message output
   115    !
   116    use dc_message, only: MessageNotify
   117  
   118    ! 宣言文 ; Declaration statements
   119    !
   120    implicit none
   121    private
   122  
   123    ! 公開手続き
   124    ! Public procedure
   125    !
   126    public:: SetInitData
   127    public:: InitDataInit
   128  
   129    ! 公開変数
   130    ! Public variables
   131    !
   132    logical, save, public:: initial_data_inited = .false.
   133                                ! 初期設定フラグ.
   134                                ! Initialization flag
   135  
   136    character(STRING), save, public:: Pattern
   137                                ! 初期値データのパターン.
   138                                ! 以下のパターンを選択可能.
   139                                !
   140                                ! Initial data pattern
   141                                ! Available patterns are as follows.
   142                                !
   143                                ! * "Small Disturbance of Temperature" (default value)
   144                                ! * "AGCM 5.3 Default"
   145                                ! * "Sugiyama et al. (2008)"
   146                                !
   147    real(DP), save, public:: TempAvr
   148                                ! $ \bar{T} $ .     温度平均値. Mean temperature
   149    real(DP), save, public:: PsAvr
   150                                ! $ \bar{p_s} $ .   地表面気圧平均値. Mean surface pressure
   151    real(DP), save, public:: QVapAvr
   152                                ! $ \bar{q} $ .     比湿平均値. Mean specific humidity
   153    real(DP), save, public:: Ueq
   154                                ! $ u_{eq} $ .      赤道上の東西風速. Eastward wind on the equator
   155    real(DP), save, public:: UGeos
   156                                ! $ u_{g} $ .       Eastward geostrophic wind
   157    real(DP), save, public:: VGeos
   158                                ! $ v_{g} $ .       Northward geostrophic wind
   159  
   160    ! 非公開変数
   161    ! Private variables
   162    !
   163  
   164    character(*), parameter:: module_name = 'initial_data'
   165                                ! モジュールの名称.
   166                                ! Module name
   167    character(*), parameter:: version = &
   168      & '$Name:  $' // &
   169      & '$Id: initial_data.f90,v 1.16 2015/02/17 23:50:42 yot Exp $'
   170                                ! モジュールのバージョン
   171                                ! Module version
   172  
   173  contains
   174  
   175    !--------------------------------------------------------------------------------------
   176  
   177    subroutine SetInitData( &
   178      & xyz_U, xyz_V, xyz_Temp, xyzf_QMix, xy_Ps &   ! (out)
   179      & )
   180      !
   181      ! 初期値データのサンプルを提供します.
   182      !
   183      ! Prepare sample data of initial data
   184      !
   185  
   186      ! モジュール引用 ; USE statements
   187      !
   188  
   189      ! 座標データ設定
   190      ! Axes data settings
   191      !
   192      use axesset, only: &
   193        & x_Lon, &
   194                                ! $ \lambda $ [rad.] . 経度. Longitude
   195        & y_Lat, &
   196                                ! $ \varphi $ [rad.] . 緯度. Latitude
   197        & z_Sigma
   198                                ! $ \sigma $ レベル (整数).
   199                                ! Full $ \sigma $ level
   200  
   201      ! 文字列操作
   202      ! Character handling
   203      !
   204      use dc_string, only: LChar
   205  
   206      ! ファイルから 1 次元プロファイルを読んで設定する.
   207      ! read 1-D profile from a file and set it
   208      !
   209      use set_1d_profile, only : Set1DProfilePs, Set1DProfileAtm
   210  
   211      ! 物理・数学定数設定
   212      ! Physical and mathematical constants settings
   213      !
   214      use constants0, only: &
   215        & PI                    ! $ \pi $.
   216                                ! 円周率. Circular constant
   217  
   218      ! 組成に関わる配列の設定
   219      ! Settings of array for atmospheric composition
   220      !
   221      use composition, only: &
   222        &                    a_QMixName, &
   223        &                    CompositionInqIndex
   224  
   225      !
   226      ! Utility module for advection test
   227      !
   228      use adv_test, only: AdvTestSetICs
   229  
   230  
   231      ! 宣言文 ; Declaration statements
   232      !
   233      implicit none
   234      real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
   235                                ! $ u $ .   東西風速. Eastward wind
   236      real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
   237                                ! $ v $ .   南北風速. Northward wind
   238      real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   239                                ! $ T $ .   温度. Temperature
   240      real(DP), intent(out):: xyzf_QMix  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   241                                ! $ q $ .   比湿. Specific humidity
   242      real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
   243                                ! $ p_s $ . 地表面気圧. Surface pressure
   244  
   245      ! 作業変数
   246      ! Work variables
   247      !
   248      real(DP) :: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   249  
   250      integer:: i               ! 経度方向に回る DO ループ用作業変数
   251                                ! Work variables for DO loop in longitude
   252      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   253                                ! Work variables for DO loop in latitude
   254      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   255                                ! Work variables for DO loop in vertical direction
   256      integer:: n
   257  
   258      ! 実行文 ; Executable statement
   259  
   260      if ( .not. initial_data_inited ) then
   261        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   262      end if
   263  
   264  
   265      select case ( LChar( trim(Pattern) ) )
   266      case ( 'small disturbance of temperature' )
   267        !
   268        ! 微小な温度擾乱のある静止場
   269        ! Stationary field with small disturbance of temperature
   270        !
   271  
   272        xyz_U    = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t607 = 1, kmax*jmax*imax                                       
     .           xyz_u(t607-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_v(t607-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_temp(t607-1,1,1) = tempavr                                 
     .        enddo                                                             
   273        xyz_V    = 0.0_DP
   274        xyz_Temp = TempAvr
   275        xy_Ps    = PsAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t622 = 1, jmax*imax                                            
     .           xy_ps(t622-1,1) = psavr                                        
     .        enddo                                                             
   276        n = IndexH2OVap
   277        xyzf_QMix(:,:,:,n) = QVapAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t628 = 1, kmax*jmax*imax                                       
     .           xyzf_qmix(t628-1,1,1,n) = qvapavr                              
     .        enddo                                                             
   278        do n = 1, ncmax
   279          if ( n /= IndexH2OVap ) then
   280            xyzf_QMix(:,:,:,n) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t652 = 1, kmax*jmax*imax                                       
     .           xyzf_qmix(t652-1,1,1,n) = 0.0000000000000000e+000              
     .        enddo                                                             
   281          end if
   282        end do
   283        do n = 1, ncmax
   284          if ( a_QMixName(n) == 'QAr' ) then
   285            xyzf_QMix(:,:,:,n) = 0.016_DP * 40.0_DP / 44.0_DP ! Assuming Ar
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t643 = 1, kmax*jmax*imax                                       
     .           xyzf_qmix(t643-1,1,1,n) = 1.45454545454545e-002                
     .        enddo                                                             
   286          end if
   287        end do
   288  !!$      n = CompositionInqIndex( '' )
   289  !!$      xyzf_QMix(:,:,:,n) = 0.0_DP
   290  
   291        ! 温度に擾乱を与える
   292        ! Add perturbation to temperature
   293        !
   294        do k = 1, kmax
   295          do j = 1, jmax
   296            do i = 0, imax - 1
   297              xyz_Temp(i,j,k) = &
   298                &    xyz_Temp(i,j,k) &
   299                &  + 0.1_DP * sin ( x_Lon(i) * y_Lat(j) ) &
   300                &  - 0.1_DP * ( 1.0_DP - z_Sigma(k) )
   301            end do
   302          end do
   303        end do
     .  !cdir noassume                                                          
     .        do i1 = 0, imax - 1, maxvl()                                      
     .           i2 = min0(imax - i1,maxvl())                                   
     .           do j = 1, jmax                                                 
     .              if (kmax .gt. 0) then                                       
     .                 j3 = and(kmax,3)                                         
     .                 do k = 1, j3                                             
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(x_lon)                                         
     .                    do i = 1, i2                                          
     .                       xyz_temp(i1+i-1,j,k) = xyz_temp(i1+i-1,j,k) +      
     .       1                  1.00000000000000e-001*dsin(x_lon(i1+i-1)*y_lat(j
     .       2                  )) - 1.00000000000000e-001*(                    
     .       3                  1.00000000000000e+000 - z_sigma(k))             
     .                    enddo                                                 
     .                 enddo                                                    
     .                 do k = j3 + 1, kmax, 4                                   
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(x_lon)                                         
     .                    do i = 1, i2                                          
     .                       d2 = y_lat(j)                                      
     .                       d1 = x_lon(i1+i-1)                                 
     .                       xyz_temp(i1+i-1,j,k) = xyz_temp(i1+i-1,j,k) + (    
     .       1                  1.00000000000000e-001*(dsin((d1*d2)))) -        
     .       2                  1.00000000000000e-001*(1.00000000000000e+000 -  
     .       3                  z_sigma(k))                                     
     .                       xyz_temp(i1+i-1,j,k+1) = xyz_temp(i1+i-1,j,k+1) + (
     .       1                  1.00000000000000e-001*(dsin((d1*d2)))) -        
     .       2                  1.00000000000000e-001*(1.00000000000000e+000 -  
     .       3                  z_sigma(k+1))                                   
     .                       xyz_temp(i1+i-1,j,k+2) = xyz_temp(i1+i-1,j,k+2) + (
     .       1                  1.00000000000000e-001*(dsin((d1*d2)))) -        
     .       2                  1.00000000000000e-001*(1.00000000000000e+000 -  
     .       3                  z_sigma(k+2))                                   
     .                       xyz_temp(i1+i-1,j,k+3) = xyz_temp(i1+i-1,j,k+3) + (
     .       1                  1.00000000000000e-001*(dsin((d1*d2)))) -        
     .       2                  1.00000000000000e-001*(1.00000000000000e+000 -  
     .       3                  z_sigma(k+3))                                   
     .                    enddo                                                 
     .                 enddo                                                    
     .              endif                                                       
     .           enddo                                                          
     .        enddo                                                             
   304  
   305        ! 東西風速を与える
   306        ! Add eastward wind
   307        !
   308        do j = 1, jmax
   309          xyz_U(:,j,:) = Ueq * cos(y_Lat(j))
     .        if (kmax .gt. 0) then                                             
     .           j4 = and(kmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t637 = 1, j4                                                
     .  !cdir       nodep                                                       
     .              do t639 = 1, imax                                           
     .                 xyz_u(t639-1,j,t637) = ueq*dcos(y_lat(j))                
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t637 = j4 + 1, kmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t639 = 1, imax                                           
     .                 d3 = y_lat(j)                                            
     .                 xyz_u(t639-1,j,t637) = (ueq*(dcos(d3)))                  
     .                 xyz_u(t639-1,j,t637+1) = (ueq*(dcos(d3)))                
     .                 xyz_u(t639-1,j,t637+2) = (ueq*(dcos(d3)))                
     .                 xyz_u(t639-1,j,t637+3) = (ueq*(dcos(d3)))                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   310        end do
   311  
   312      case ( 'agcm 5.3 default' )
   313        !
   314        ! AGCM5.3 のデフォルト初期値
   315        ! AGCM5.3 default initial values
   316        !
   317  
   318        xyz_U    = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t562 = 1, kmax*jmax*imax                                       
     .           xyz_u(t562-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_v(t562-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_temp(t562-1,1,1) = tempavr                                 
     .        enddo                                                             
   319        xyz_V    = 0.0_DP
   320        xyz_Temp = TempAvr
   321        xy_Ps    = PsAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t577 = 1, jmax*imax                                            
     .           xy_ps(t577-1,1) = psavr                                        
     .        enddo                                                             
   322        n = IndexH2OVap
   323        xyzf_QMix(:,:,:,n) = QVapAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t583 = 1, kmax*jmax*imax                                       
     .           xyzf_qmix(t583-1,1,1,n) = qvapavr                              
     .        enddo                                                             
   324        do n = 1, ncmax
   325          if ( n /= IndexH2OVap ) then
   326            xyzf_QMix(:,:,:,n) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t598 = 1, kmax*jmax*imax                                       
     .           xyzf_qmix(t598-1,1,1,n) = 0.0000000000000000e+000              
     .        enddo                                                             
   327          end if
   328        end do
   329  
   330        ! 温度に擾乱を与える
   331        ! Add perturbation to temperature
   332        !
   333        do k = 1, kmax
   334          do j = 1, jmax
   335            do i = 0, imax - 1
   336              xyz_Temp(i,j,k) = &
   337                &    xyz_Temp(i,j,k) &
   338                &  + 0.1_DP &
   339                &    * sin ( real( ( i + 1 ) &
   340                &                  * ( jmax - j + 1 ) &
   341                &                  * ( kmax - k ), DP ) &
   342                &            / real( imax &
   343                &                    * jmax &
   344                &                    * kmax, DP ) * 10.0_DP &
   345                &                 )
   346            end do
   347          end do
     .        if (jmax .gt. 0) then                                             
     .           j5 = and(jmax,3)                                               
     .           do j = 1, j5                                                   
     .              d4 = 1.D0/dfloat(imax*jmax*kmax)                            
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyz_temp(i-1,j,k) = xyz_temp(i-1,j,k) +                  
     .       1            1.00000000000000e-001*dsin(dfloat(i*(jmax - j + 1)*(  
     .       2            kmax - k))*d4*1.00000000000000e+001)                  
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j5 + 1, jmax, 4                                         
     .              d5 = 1.D0/(dfloat(((imax*jmax)*kmax)))                      
     .              d6 = 1.D0/(dfloat(((imax*jmax)*kmax)))                      
     .              d7 = 1.D0/(dfloat(((imax*jmax)*kmax)))                      
     .              d8 = 1.D0/(dfloat(((imax*jmax)*kmax)))                      
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyz_temp(i-1,j,k) = xyz_temp(i-1,j,k) +                  
     .       1            1.00000000000000e-001*dsin(dfloat((jmax - (j - 1))*(((
     .       2            i - 1)*(kmax - k)) + (kmax - k)))*d5*                 
     .       3            1.00000000000000e+001)                                
     .                 xyz_temp(i-1,j+1,k) = xyz_temp(i-1,j+1,k) +              
     .       1            1.00000000000000e-001*dsin(dfloat(i*(jmax - j)*(kmax  
     .       2             - k))*d6*1.00000000000000e+001)                      
     .                 xyz_temp(i-1,j+2,k) = xyz_temp(i-1,j+2,k) +              
     .       1            1.00000000000000e-001*dsin(dfloat((jmax - 2 - (j - 1))
     .       2            *(((i - 1)*(kmax - k)) + (kmax - k)))*d7*             
     .       3            1.00000000000000e+001)                                
     .                 xyz_temp(i-1,j+3,k) = xyz_temp(i-1,j+3,k) +              
     .       1            1.00000000000000e-001*dsin(dfloat((jmax - 3 - (j - 1))
     .       2            *(((i - 1)*(kmax - k)) + (kmax - k)))*d8*             
     .       3            1.00000000000000e+001)                                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   348        end do
   349  
   350        ! 東西風速を与える
   351        ! Add eastward wind
   352        !
   353        do j = 1, jmax
   354          xyz_U(:,j,:) = Ueq * cos(y_Lat(j))
     .        if (kmax .gt. 0) then                                             
     .           j6 = and(kmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t592 = 1, j6                                                
     .  !cdir       nodep                                                       
     .              do t594 = 1, imax                                           
     .                 xyz_u(t594-1,j,t592) = ueq*dcos(y_lat(j))                
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t592 = j6 + 1, kmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t594 = 1, imax                                           
     .                 d9 = y_lat(j)                                            
     .                 xyz_u(t594-1,j,t592) = (ueq*(dcos(d9)))                  
     .                 xyz_u(t594-1,j,t592+1) = (ueq*(dcos(d9)))                
     .                 xyz_u(t594-1,j,t592+2) = (ueq*(dcos(d9)))                
     .                 xyz_u(t594-1,j,t592+3) = (ueq*(dcos(d9)))                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   355        end do
   356  
   357      case ( 'sugiyama et al. (2008)' )
   358        !
   359        ! Sugiyama et al. (2008) の初期値
   360        ! Initial values of Sugiyama et al. (2008)
   361        !
   362        call Sugiyamaetal2008InitData( &
   363          & xyz_U, xyz_V, xyz_Temp, xyzf_QMix(:,:,:,IndexH2OVap), xy_Ps &   ! (out)
   364          & )
   365        do n = 1, ncmax
   366          if ( n /= IndexH2OVap ) then
   367            xyzf_QMix(:,:,:,n) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t553 = 1, kmax*jmax*imax                                       
     .           xyzf_qmix(t553-1,1,1,n) = 0.0000000000000000e+000              
     .        enddo                                                             
   368          end if
   369        end do
   370  
   371      case ( 'polvani et al. (2004)' )
   372        !
   373        ! Polvani et al. (2004) の初期値
   374        ! Initial values of Polvani et al. (2004)
   375        !
   376        n = IndexH2OVap
   377        call Polvanietal2004InitData( &
   378          & xyz_U, xyz_V, xyz_Temp, xyzf_QMix(:,:,:,n), xy_Ps &   ! (out)
   379          & )
   380        do n = 1, ncmax
   381          if ( n /= IndexH2OVap ) then
   382            do j = 1, jmax
   383              if ( y_Lat(j) * 180.0_DP / PI > 45.0_DP ) then
   384                xyzf_QMix(:,j,:,n) = 0.5_DP
     .        if (kmax .gt. 0) then                                             
     .           j7 = and(kmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t547 = 1, j7                                                
     .  !cdir       nodep                                                       
     .              do t549 = 1, 1 + imax - min0(1,imax)                        
     .                 xyzf_qmix(t549-1,j,t547,n) = 5.00000000000000e-001       
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t547 = j7 + 1, kmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t549 = 1, 1 + imax - min0(1,imax)                        
     .                 xyzf_qmix(t549-1,j,t547,n) = 5.00000000000000e-001       
     .                 xyzf_qmix(t549-1,j,t547+1,n) = 5.00000000000000e-001     
     .                 xyzf_qmix(t549-1,j,t547+2,n) = 5.00000000000000e-001     
     .                 xyzf_qmix(t549-1,j,t547+3,n) = 5.00000000000000e-001     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10082                                                        
   385              else
   386                xyzf_QMix(:,j,:,n) = 1.0_DP
     .        if (kmax .gt. 0) then                                             
     .           j8 = and(kmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t541 = 1, j8                                                
     .  !cdir       nodep                                                       
     .              do t543 = 1, imax                                           
     .                 xyzf_qmix(t543-1,j,t541,n) = 1.00000000000000e+000       
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t541 = j8 + 1, kmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t543 = 1, imax                                           
     .                 xyzf_qmix(t543-1,j,t541,n) = 1.00000000000000e+000       
     .                 xyzf_qmix(t543-1,j,t541+1,n) = 1.00000000000000e+000     
     .                 xyzf_qmix(t543-1,j,t541+2,n) = 1.00000000000000e+000     
     .                 xyzf_qmix(t543-1,j,t541+3,n) = 1.00000000000000e+000     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   387              end if
   388            end do
   389          end if
   390        end do
   391  
   392      case ( 'venus' )
   393  
   394        call VenusInitData( &
   395          & xyz_U, xyz_V, xyz_Temp, xyzf_QMix(:,:,:,n), xy_Ps & ! (out)
   396          & )
   397        do n = 1, ncmax
   398          if ( n /= IndexH2OVap ) then
   399            xyzf_QMix(:,:,:,n) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t532 = 1, kmax*jmax*imax                                       
     .           xyzf_qmix(t532-1,1,1,n) = 0.0000000000000000e+000              
     .        enddo                                                             
   400          end if
   401        end do
   402  
   403      case ( '1-d profile' )
   404  
   405        xyz_U = UGeos
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t503 = 1, kmax*jmax*imax                                       
     .           xyz_u(t503-1,1,1) = ugeos                                      
     .           xyz_v(t503-1,1,1) = vgeos                                      
     .        enddo                                                             
   406        xyz_V = VGeos
   407  
   408        call Set1DProfilePs( &
   409          & xy_Ps &
   410          & )
   411  
   412        do k = 1, kmax
   413          xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_ps)                                                     
     .        do t515 = 1, jmax*imax                                            
     .           xyz_press(t515-1,1,k) = xy_ps(t515-1,1)*z_sigma(k)             
     .        enddo                                                             
   414        end do
   415        call Set1DProfileAtm(      &
   416          & xyz_Press,                   &
   417          & xyz_Temp, xyzf_QMix(:,:,:,IndexH2OVap)   &
   418          & )
   419        do n = 1, ncmax
   420          if ( n /= IndexH2OVap ) then
   421            xyzf_QMix(:,:,:,n) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t523 = 1, kmax*jmax*imax                                       
     .           xyzf_qmix(t523-1,1,1,n) = 0.0000000000000000e+000              
     .        enddo                                                             
   422          end if
   423        end do
   424  
   425      case ( 'advection test' )
   426  
   427  !!$    ! セミラグ移流テスト用初期値作成
   428  !!$    ! Preparation of initial condition for SLTT advection
   429  !!$    !
   430  !!$    use sltt_debug, only : SLTTDebugSetUV, SLTTDebugSetQ
   431  !!$      call SLTTDebugSetUV( &
   432  !!$        & Ueq,             & ! (in)
   433  !!$        & xyz_U, xyz_V     & ! (out)
   434  !!$        & )
   435  !!$      xyz_Temp = TempAvr
   436  !!$      xy_Ps    = PsAvr
   437  !!$      call SLTTDebugSetQ( &
   438  !!$        & xyz_QVap        & ! (out)
   439  !!$        & )
   440  
   441        xyz_Temp = TempAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t488 = 1, kmax*jmax*imax                                       
     .           xyz_temp(t488-1,1,1) = tempavr                                 
     .        enddo                                                             
   442        xy_Ps    = PsAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t497 = 1, jmax*imax                                            
     .           xy_ps(t497-1,1) = psavr                                        
     .        enddo                                                             
   443  
   444        !
   445        ! Utility module for advection test
   446        !
   447        call AdvTestSetICs(           &
   448          & xy_Ps, xyz_Temp,          & ! (in)
   449          & xyz_U, xyz_V, xyzf_QMix   & ! (out)
   450          & )
   451  
   452      end select
   453  
   454    end subroutine SetInitData
   455  
   456    !--------------------------------------------------------------------------------------
   457  
   458    subroutine Sugiyamaetal2008InitData( &
   459      & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
   460      & )
   461      !
   462      ! Sugiyama et al. (2008) の初期値
   463      ! Initial values of Sugiyama et al. (2008)
   464      !
   465  
   466      ! モジュール引用 ; USE statements
   467      !
   468  
   469      ! 座標データ設定
   470      ! Axes data settings
   471      !
   472      use axesset, only: &
   473        & x_Lon, &
   474                                ! $ \lambda $ [rad.] . 経度. Longitude
   475        & y_Lat, &
   476                                ! $ \varphi $ [rad.] . 緯度. Latitude
   477        & z_Sigma
   478                                ! $ \sigma $ レベル (整数).
   479                                ! Full $ \sigma $ level
   480  
   481      ! 物理定数設定
   482      ! Physical constants settings
   483      !
   484      use constants, only: &
   485        & CpDry, &              ! $ C_p $ [J kg-1 K-1].
   486                                ! 乾燥大気の定圧比熱.
   487                                ! Specific heat of air at constant pressure
   488        & GasRDry               ! $ R $ [J kg-1 K-1].
   489                                ! 乾燥大気の気体定数.
   490                                ! Gas constant of air
   491  
   492      ! 飽和比湿の算出
   493      ! Evaluate saturation specific humidity
   494      !
   495      use saturate, only: xyz_CalcQVapSat
   496  
   497      ! 文字列操作
   498      ! Character handling
   499      !
   500      use dc_string, only: LChar
   501  
   502      ! 宣言文 ; Declaration statements
   503      !
   504      implicit none
   505      real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
   506                                ! $ u $ .   東西風速. Eastward wind
   507      real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
   508                                ! $ v $ .   南北風速. Northward wind
   509      real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   510                                ! $ T $ .   温度. Temperature
   511      real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
   512                                ! $ q $ .   比湿. Specific humidity
   513      real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
   514                                ! $ p_s $ . 地表面気圧. Surface pressure
   515  
   516      ! Sugiyama et al. (2008) 用作業変数
   517      ! Work variables for Sugiyama et al. (2008)
   518      !
   519      real(DP):: xyz_PotTemp (0:imax-1, 1:jmax, 1:kmax)
   520                                ! 温位. Potential temperature
   521      real(DP):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   522                                ! 気圧. Air pressure
   523      real(DP):: xy_TempMin (0:imax-1, 1:jmax)
   524                                ! 温度の最小値. Minimum value of temperature
   525      real(DP):: xyz_QVapSat (0:imax-1, 1:jmax, 1:kmax)
   526                                ! 飽和比湿. Saturation specific humidity
   527  
   528      ! 作業変数
   529      ! Work variables
   530      !
   531      integer:: i               ! 経度方向に回る DO ループ用作業変数
   532                                ! Work variables for DO loop in longitude
   533      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   534                                ! Work variables for DO loop in latitude
   535      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   536                                ! Work variables for DO loop in vertical direction
   537  
   538      ! 実行文 ; Executable statement
   539  
   540      if ( .not. initial_data_inited ) then
   541        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   542      end if
   543  
   544  
   545      xyz_U    = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t302 = 1, kmax*jmax*imax                                       
     .           xyz_u(t302-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_v(t302-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_temp(t302-1,1,1) = tempavr                                 
     .        enddo                                                             
   546      xyz_V    = 0.0_DP
   547      xyz_Temp = TempAvr
   548      xy_Ps    = PsAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t317 = 1, jmax*imax                                            
     .           xy_ps(t317-1,1) = psavr                                        
     .        enddo                                                             
   549      xyz_QVap = QVapAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t323 = 1, kmax*jmax*imax                                       
     .           xyz_qvap(t323-1,1,1) = qvapavr                                 
     .           xyz_pottemp(t323-1,1,1) = tempavr                              
     .        enddo                                                             
   550  
   551      ! 温度の計算
   552      ! Calculate temperature
   553      !
   554      xyz_PotTemp = TempAvr
   555      xy_TempMin  = TempAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t335 = 1, xy_tempmin.DSC.U2*xy_tempmin.DSC.U1 +                
     .       1   xy_tempmin.DSC.U2                                              
     .           xy_tempmin(t335-1,1) = tempavr                                 
     .        enddo                                                             
   556  
   557      do k = 1, kmax
   558        xyz_Temp(:,:,k) = xyz_PotTemp(:,:,k) &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t341 = 1, xyz_pottemp.DSC.U2*xyz_pottemp.DSC.U1 +              
     .       1   xyz_pottemp.DSC.U2                                             
     .           xyz_temp(t341-1,1,k) = xyz_pottemp(t341-1,1,k)*z_sigma(k)**(   
     .       1      gasrdry/cpdry)                                              
     .        enddo                                                             
   559          &                  * ( z_Sigma(k) )**( GasRDry / CpDry )
   560  
   561        if ( PsAvr * z_Sigma(k) < 1.0e+4_DP ) then
   562          xyz_Temp(:,:,k) = xy_TempMin
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j1 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t383 = 1, j1                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_tempmin)                                          
     .              do t385=1,xyz_temp.DSC.U1+2-min0(1,xyz_temp.DSC.U1+1)       
     .                 xyz_temp(t385-1,t383,k) = xy_tempmin(t385-1,t383)        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t383 = j1 + 1, xyz_temp.DSC.U2, 4                           
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_tempmin)                                          
     .              do t385=1,xyz_temp.DSC.U1+2-min0(1,xyz_temp.DSC.U1+1)       
     .                 xyz_temp(t385-1,t383,k) = xy_tempmin(t385-1,t383)        
     .                 xyz_temp(t385-1,t383+1,k) = xy_tempmin(t385-1,t383+1)    
     .                 xyz_temp(t385-1,t383+2,k) = xy_tempmin(t385-1,t383+2)    
     .                 xyz_temp(t385-1,t383+3,k) = xy_tempmin(t385-1,t383+3)    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10045                                                        
   563        else
   564          xy_TempMin = xyz_Temp(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_tempmin)                                                
     .        do t349 = 1, xy_tempmin.DSC.U2*xy_tempmin.DSC.U1 +                
     .       1   xy_tempmin.DSC.U2                                              
     .           xy_tempmin(t349-1,1) = xyz_temp(t349-1,1,k)                    
     .        enddo                                                             
   565        end if
   566      end do
   567  
   568      ! 温度に擾乱を与える
   569      ! Add perturbation to temperature
   570      !
   571      do k = 1, kmax
   572        do j = 1, jmax
   573          do i = 0, imax - 1
   574            xyz_Temp(i,j,k) = &
   575              &    xyz_Temp(i,j,k) &
   576              &  + 0.1_DP &
   577              &    * sin ( real( ( i + 1 ) &
   578              &                  * ( jmax - j + 1 ) &
   579              &                  * ( kmax - k ), DP ) &
   580              &            / real( imax &
   581              &                    * jmax &
   582              &                    * kmax, DP ) * 10.0_DP &
   583              &                 )
   584          end do
   585        end do
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           do j = 1, j2                                                   
     .              d1 = 1.D0/dfloat(imax*jmax*kmax)                            
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyz_temp(i-1,j,k) = xyz_temp(i-1,j,k) +                  
     .       1            1.00000000000000e-001*dsin(dfloat(i*(jmax - j + 1)*(  
     .       2            kmax - k))*d1*1.00000000000000e+001)                  
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j2 + 1, jmax, 4                                         
     .              d2 = 1.D0/(dfloat(((imax*jmax)*kmax)))                      
     .              d3 = 1.D0/(dfloat(((imax*jmax)*kmax)))                      
     .              d4 = 1.D0/(dfloat(((imax*jmax)*kmax)))                      
     .              d5 = 1.D0/(dfloat(((imax*jmax)*kmax)))                      
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyz_temp(i-1,j,k) = xyz_temp(i-1,j,k) +                  
     .       1            1.00000000000000e-001*dsin(dfloat((jmax - (j - 1))*(((
     .       2            i - 1)*(kmax - k)) + (kmax - k)))*d2*                 
     .       3            1.00000000000000e+001)                                
     .                 xyz_temp(i-1,j+1,k) = xyz_temp(i-1,j+1,k) +              
     .       1            1.00000000000000e-001*dsin(dfloat(i*(jmax - j)*(kmax  
     .       2             - k))*d3*1.00000000000000e+001)                      
     .                 xyz_temp(i-1,j+2,k) = xyz_temp(i-1,j+2,k) +              
     .       1            1.00000000000000e-001*dsin(dfloat((jmax - 2 - (j - 1))
     .       2            *(((i - 1)*(kmax - k)) + (kmax - k)))*d4*             
     .       3            1.00000000000000e+001)                                
     .                 xyz_temp(i-1,j+3,k) = xyz_temp(i-1,j+3,k) +              
     .       1            1.00000000000000e-001*dsin(dfloat((jmax - 3 - (j - 1))
     .       2            *(((i - 1)*(kmax - k)) + (kmax - k)))*d5*             
     .       3            1.00000000000000e+001)                                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   586      end do
   587  
   588      ! 飽和比湿計算
   589      ! Calculate saturation specific humidity
   590      !
   591      do k = 1, kmax
   592        xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_ps)                                                     
     .        do t357 = 1, jmax*imax                                            
     .           xyz_press(t357-1,1,k) = xy_ps(t357-1,1)*z_sigma(k)             
     .        enddo                                                             
   593      end do
   594  
   595      xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   596  
   597      ! 比湿の計算
   598      ! Calculate specific humidity
   599      !
   600      where ( xyz_QVap > xyz_QVapSat * 0.75_DP )
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t367 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t369 = 1, imax                                           
     .                 if (xyz_qvap(t369-1,t367,t365+1) .gt. (xyz_qvapsat(t369-1
     .       1            ,t367,t365+1)*7.50000000000000e-001)) then            
     .                    xyz_qvap(t369-1,t367,t365+1) = (xyz_qvapsat(t369-1,   
     .       1               t367,t365+1)*7.50000000000000e-001)                
     .                 endif                                                    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t367 = j3 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t369 = 1, imax                                           
     .                 if (xyz_qvap(t369-1,t367,t365+1) .gt. (xyz_qvapsat(t369-1
     .       1            ,t367,t365+1)*7.50000000000000e-001)) then            
     .                    xyz_qvap(t369-1,t367,t365+1) = (xyz_qvapsat(t369-1,   
     .       1               t367,t365+1)*7.50000000000000e-001)                
     .                 endif                                                    
     .                 if (xyz_qvap(t369-1,t367+1,t365+1) .gt. (xyz_qvapsat(t369
     .       1            -1,t367+1,t365+1)*7.50000000000000e-001)) then        
     .                    xyz_qvap(t369-1,t367+1,t365+1) = (xyz_qvapsat(t369-1, 
     .       1               t367+1,t365+1)*7.50000000000000e-001)              
     .                 endif                                                    
     .                 if (xyz_qvap(t369-1,t367+2,t365+1) .gt. (xyz_qvapsat(t369
     .       1            -1,t367+2,t365+1)*7.50000000000000e-001)) then        
     .                    xyz_qvap(t369-1,t367+2,t365+1) = (xyz_qvapsat(t369-1, 
     .       1               t367+2,t365+1)*7.50000000000000e-001)              
     .                 endif                                                    
     .                 if (xyz_qvap(t369-1,t367+3,t365+1) .gt. (xyz_qvapsat(t369
     .       1            -1,t367+3,t365+1)*7.50000000000000e-001)) then        
     .                    xyz_qvap(t369-1,t367+3,t365+1) = (xyz_qvapsat(t369-1, 
     .       1               t367+3,t365+1)*7.50000000000000e-001)              
     .                 endif                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   601        xyz_QVap = xyz_QVapSat * 0.75_DP
   602      end where
   603  
   604  
   605    end subroutine Sugiyamaetal2008InitData
   606  
   607    !--------------------------------------------------------------------------------------
   608  
   609    subroutine Polvanietal2004InitData( &
   610      & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
   611      & )
   612      !
   613      ! Polvani et al. (2004) の初期値
   614      !
   615      ! initial data by Polvani et al. (2004)
   616      !
   617  
   618      ! モジュール引用 ; USE statements
   619      !
   620  
   621      ! MPI 関連ルーチン
   622      ! MPI related routines
   623      !
   624      use mpi_wrapper, only : NProcs
   625  
   626      ! 物理・数学定数設定
   627      ! Physical and mathematical constants settings
   628      !
   629      use constants0, only: &
   630        & PI                    ! $ \pi $.
   631                                ! 円周率. Circular constant
   632  
   633      ! 物理定数設定
   634      ! Physical constants settings
   635      !
   636      use constants, only: &
   637        & RPlanet, &            ! $ a $ [m].
   638                                ! 惑星半径.
   639                                ! Radius of planet
   640        & Omega, &              ! $ \Omega $ [s-1].
   641                                ! 回転角速度.
   642                                ! Angular velocity
   643        & GasRDry               ! $ R $ [J kg-1 K-1].
   644                                ! 乾燥大気の気体定数.
   645                                ! Gas constant of air
   646  
   647      ! 座標データ設定
   648      ! Axes data settings
   649      !
   650      use axesset, only: &
   651        & x_Lon, &
   652                                ! $ \lambda $ [rad.] . 経度. Longitude
   653        & y_Lat, &
   654                                ! $ \varphi $ [rad.] . 緯度. Latitude
   655        & z_Sigma, &
   656                                ! $ \sigma $ レベル (整数).
   657                                ! Full $ \sigma $ level
   658        & y_Lat_Weight
   659                                ! $ \Delta \varphi $ [rad.] .
   660                                ! 緯度座標重み.
   661                                ! Weight of latitude
   662  
   663      ! 文字列操作
   664      ! Character handling
   665      !
   666      use dc_string, only: LChar
   667  
   668      ! ガウス重み, 分点の計算
   669      ! Calculate Gauss node and Gaussian weight
   670      !
   671      use gauss_quad, only : GauLeg
   672  
   673  
   674      ! 宣言文 ; Declaration statements
   675      !
   676      implicit none
   677      real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
   678                                ! $ u $ .   東西風速. Eastward wind
   679      real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
   680                                ! $ v $ .   南北風速. Northward wind
   681      real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   682                                ! $ T $ .   温度. Temperature
   683      real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
   684                                ! $ q $ .   比湿. Specific humidity
   685      real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
   686                                ! $ p_s $ . 地表面気圧. Surface pressure
   687  
   688  
   689      ! 作業変数
   690      ! Work variables
   691      !
   692  
   693      ! パラメタ設定
   694      !
   695      !
   696      !
   697      real(DP), parameter:: dz0 = 5.0e3_DP
   698                                ! dz_0 [m].
   699      real(DP), parameter:: z0  = 22.0e3_DP
   700                                ! z_0 [m]
   701      real(DP), parameter:: z1  = 30.0e3_DP
   702                                ! z_1 [m]
   703      real(DP), parameter:: U0  = 50.0_DP
   704                                ! u_0 [m s^-1]
   705  
   706      real(DP), parameter:: ScaleHeight = 7.34e3_DP
   707                                ! ScaleHeight [m]
   708  
   709      real(DP):: z_Height (1:kmax)
   710                                ! height [m]
   711      real(DP):: z_F (1:kmax)
   712                                ! function used to calculate zonal wind and temperature
   713      real(DP):: z_DFDZ (1:kmax)
   714                                ! z derivative of z_F
   715      real(DP):: z_TempUSStd(1:kmax)
   716                                ! Temperature by US Standard atmosphere [K]
   717  
   718  
   719      integer, parameter :: NGauQuad = 100
   720      real(DP)           :: a_GauQuadLat( 1:NGauQuad )
   721      real(DP)           :: a_GauWeight ( 1:NGauQuad )
   722      real(DP)           :: az_U        ( 1:NGauQuad, 1:kmax )
   723      real(DP)           :: az_DUDZ     ( 1:NGauQuad, 1:kmax )
   724      real(DP)           :: az_DTempDPhi( 1:NGauQuad, 1:kmax )
   725      real(DP)           :: z_Temp0     (1:kmax)
   726  
   727  
   728      integer:: i               ! 経度方向に回る DO ループ用作業変数
   729                                ! Work variables for DO loop in longitude
   730      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   731                                ! Work variables for DO loop in latitude
   732      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   733                                ! Work variables for DO loop in vertical direction
   734      integer:: l               ! 緯度方向に回る DO ループ用作業変数
   735                                ! Work variables for DO loop in latitude
   736  
   737  
   738      ! 実行文 ; Executable statement
   739  
   740      if ( .not. initial_data_inited ) then
   741        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   742      end if
   743  
   744  
   745      if ( NProcs > 1 ) then
   746        call MessageNotify( 'E', module_name, &
   747          & 'Number of process has to be one, when you use an initial condition for Polvani (2004) experiment.' )
   748      end if
   749  
   750      ! 高度の計算
   751      ! Calculate height
   752      !
   753  
   754      do k = 1, kmax
   755        z_Height = - ScaleHeight * log( z_Sigma )
   756      end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(d1,z_sigma,z_height)                                       
     .        do t634 = 1, z_sigma.DSC.U1 + 1 - z_sigma.DSC.L1                  
     .           d1(t634) = dlog(z_sigma(z_sigma.DSC.L1+t634-1))                
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(d1)                                                        
     .        do t6341 = 0, z_sigma.DSC.U1 - z_sigma.DSC.L1, maxvl()            
     .           t6342=min0(z_sigma.DSC.U1+1-z_sigma.DSC.L1-t6341,maxvl())      
     .           do k = 1, kmax                                                 
     .  !cdir       shortloop                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d1,z_sigma)                                          
     .              do t634 = 1, t6342                                          
     .                 z_height(t6341+t634) = -7.34000000000000e+003*d1(t6341+  
     .       1            t634)                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
   757  
   758      do k = 1, kmax
   759        if      ( z_Height(k) * 1.0e-3_DP < 11.0_DP ) then
   760          z_TempUSStd(k) = 288.15_DP - 6.5_DP * z_Height(k) * 1.0e-3_DP
   761        else if ( z_Height(k) * 1.0e-3_DP < 20.0_DP ) then
   762          z_TempUSStd(k) = 216.65_DP
   763        else if ( z_Height(k) * 1.0e-3_DP < 32.0_DP ) then
   764          z_TempUSStd(k) = 216.65_DP + 1.0_DP * ( z_Height(k) * 1.0e-3_DP - 20.0_DP )
   765        else if ( z_Height(k) * 1.0e-3_DP < 47.0_DP ) then
   766          z_TempUSStd(k) = 228.65_DP + 2.8_DP * ( z_Height(k) * 1.0e-3_DP - 32.0_DP )
   767        else if ( z_Height(k) * 1.0e-3_DP < 51.0_DP ) then
   768          z_TempUSStd(k) = 270.65_DP
   769        else if ( z_Height(k) * 1.0e-3_DP < 71.0_DP ) then
   770          z_TempUSStd(k) = 270.65_DP - 2.8_DP * ( z_Height(k) * 1.0e-3_DP - 51.0_DP )
   771        else if ( z_Height(k) * 1.0e-3_DP < 80.0_DP ) then
   772          z_TempUSStd(k) = 214.65_DP - 2.0_DP * ( z_Height(k) * 1.0e-3_DP - 71.0_DP )
   773        else
   774          z_TempUSStd(k) = 196.65_DP
   775        end if
   776      end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(z_height)                                                  
     .        do k = 1, kmax                                                    
     .           if ((z_height(k)*1.00000000000000e-003) .lt.                   
     .       1      1.10000000000000e+001) then                                 
     .              z_tempusstd2 = 2.88149999999999e+002 - (z_height(k)*        
     .       1         1.00000000000000e-003)*6.50000000000000e+000             
     .           else                                                           
     .              if ((z_height(k)*1.00000000000000e-003) .lt.                
     .       1         2.00000000000000e+001) then                              
     .                 z_tempusstd2 = 2.16650000000000e+002                     
     .              else                                                        
     .                 if ((z_height(k)*1.00000000000000e-003) .lt.             
     .       1            3.20000000000000e+001) then                           
     .                    z_tempusstd2 = 2.16650000000000e+002 +                
     .       1               1.00000000000000e+000*((z_height(k)*               
     .       2               1.00000000000000e-003)-2.00000000000000e+001)      
     .                 else                                                     
     .                    if ((z_height(k)*1.00000000000000e-003) .lt.          
     .       1               4.70000000000000e+001) then                        
     .                       z_tempusstd2 = 2.28650000000000e+002 +             
     .       1                  2.79999999999999e+000*((z_height(k)*            
     .       2                  1.00000000000000e-003)-3.20000000000000e+001)   
     .                    else                                                  
     .                       if ((z_height(k)*1.00000000000000e-003) .lt.       
     .       1                  5.10000000000000e+001) then                     
     .                          z_tempusstd2 = 2.70649999999999e+002            
     .                       else                                               
     .                          if ((z_height(k)*1.00000000000000e-003) .lt.    
     .       1                     7.10000000000000e+001) then                  
     .                             z_tempusstd2 = 2.70649999999999e+002 -       
     .       1                        2.79999999999999e+000*((z_height(k)*      
     .       2                        1.00000000000000e-003)-                   
     .       3                        5.10000000000000e+001)                    
     .                          else                                            
     .                             if ((z_height(k)*1.00000000000000e-003) .lt. 
     .       1                        8.00000000000000e+001) then               
     .                                z_tempusstd2 = 2.14650000000000e+002 -    
     .       1                           2.00000000000000e+000*((z_height(k)*   
     .       2                           1.00000000000000e-003)-                
     .       3                           7.10000000000000e+001)                 
     .                             else                                         
     .                                z_tempusstd2 = 1.96650000000000e+002      
     .                             endif                                        
     .                          endif                                           
     .                       endif                                              
     .                    endif                                                 
     .                 endif                                                    
     .              endif                                                       
     .           endif                                                          
     .           z_tempusstd(k) = z_tempusstd2                                  
     .        enddo                                                             
   777  
   778      z_F =                                                        &
     .        d3 = 1.D0/5.00000000000000e+003                                   
     .        d4 = 1.D0/3.00000000000000e+004                                   
     .        d5 = 1.D0/5.00000000000000e+003                                   
     .        d6 = 3.14159265358979e+000/3.00000000000000e+004                  
     .        d7 = 1.D0/3.00000000000000e+004                                   
     .        d8 = 1.D0/5.00000000000000e+003                                   
     .        d9 = 1.D0/5.00000000000000e+003                                   
     .        d10 = 1.D0/3.00000000000000e+004                                  
     .  !cdir nodep                                                             
     .  !cdir on_adb(z_height)                                                  
     .        do t638 = 1, z_height.DSC.U1                                      
     .           z_f(t638) = (5.00000000000000e-001*(1.00000000000000e+000 - (( 
     .       1      dtanh(((z_height(t638)-2.20000000000000e+004)*d3)))**3)))*( 
     .       2      dsin(((3.14159265358979e+000*z_height(t638))*d4)))          
     .           z_dfdz(t638) = (5.00000000000000e-001*(1.00000000000000e+000 - 
     .       1      ((dtanh(((z_height(t638)-2.20000000000000e+004)*d5)))**3)))*
     .       2      d6*dcos(((3.14159265358979e+000*z_height(t638))*d7)) -      
     .       3      2.99999999999999e-004*(dtanh(((z_height(t638)-              
     .       4      2.20000000000000e+004)*d8)))**2/dcosh(((z_height(t638)-     
     .       5      2.20000000000000e+004)*d9))**2*(dsin(((3.14159265358979e+000
     .       6      *z_height(t638))*d10)))                                     
     .        enddo                                                             
   779        &   0.5_DP * ( 1.0_DP - tanh( ( z_Height - z0 ) / dz0 )**3 ) &
   780        & * sin( PI * z_Height / z1 )
   781      z_DFDZ =                                                                         &
   782        & - 1.5_DP / dz0                                                               &
   783        &   * tanh( ( z_Height - z0 ) / dz0 )**2 / cosh( ( z_Height - z0 ) / dz0 )**2  &
   784        &   * sin( PI * z_Height / z1 )                                                &
   785        & + 0.5_DP                                                                     &
   786        &   * ( 1.0_DP - tanh( ( z_Height - z0 ) / dz0 )**3 )                          &
   787        &   * PI / z1 * cos( PI * z_Height / z1 )
   788  
   789  
   790  
   791      xyz_U    = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t649 = 1, kmax*jmax*imax                                       
     .           xyz_u(t649-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_v(t649-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_temp(t649-1,1,1) = 0.0000000000000000e+000                 
     .        enddo                                                             
   792      xyz_V    = 0.0_DP
   793      xyz_Temp = 0.0_DP
   794      xy_Ps    = PsAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t664 = 1, jmax*imax                                            
     .           xy_ps(t664-1,1) = psavr                                        
     .        enddo                                                             
   795      xyz_QVap = QVapAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t670 = 1, kmax*jmax*imax                                       
     .           xyz_qvap(t670-1,1,1) = qvapavr                                 
     .        enddo                                                             
   796  
   797  
   798      ! 東西風速の計算
   799      ! Calculate eastward wind
   800      !
   801      do k = 1, kmax
   802        do j = 1, jmax
   803          if ( y_Lat(j) > 0.0_DP ) then
   804            xyz_U(:,j,k) = U0 * sin( PI * sin( y_Lat(j) )**2 )**3 * z_F(k)
   805          else
   806            xyz_U(:,j,k) =0.0_DP
   807          end if
   808        end do
   809      end do
   810  
   811  
   812      ! 温度の計算
   813      ! Calculate temperature
   814      !
   815      do j = 1, jmax
   816  
   817        call GauLeg( -PI/2.0_DP, y_Lat(j), NGauQuad, a_GauQuadLat, a_GauWeight )
   818  
   819        do k = 1, kmax
   820          do l = 1, NGauQuad
   821            if ( a_GauQuadLat(l) > 0.0_DP ) then
   822              az_U   (l,k) = U0 * sin( PI * sin( a_GauQuadLat(l) )**2 )**3 * z_F(k)
   823              az_DUDZ(l,k) = U0 * sin( PI * sin( a_GauQuadLat(l) )**2 )**3 * z_DFDZ(k)
   824            else
   825              az_U   (l,k) =0.0_DP
   826              az_DUDZ(l,k) =0.0_DP
   827            end if
   828          end do
   829        end do
   830  
   831        do k = 1, kmax
   832          do l = 1, NGauQuad
   833            if ( a_GauQuadLat(l) > 0.0_DP ) then
   834              az_DTempDPhi(l,k) = - ScaleHeight / GasRDry                  &
   835                & * (  2.0_DP * RPlanet * Omega * sin( a_GauQuadLat(l) )   &
   836                &    + 2.0_DP * az_U(l,k) * tan( a_GauQuadLat(l) ) )       &
   837                & * az_DUDZ(l,k)
   838            else
   839              az_DTempDPhi(l,k) = 0.0_DP
   840            end if
   841          end do
   842        end do
     .           do k = 1, kmax                                                 
     .  !cdir    nodep                                                          
     .  !cdir    on_adb(a_gauquadlat)                                           
     .           do l = 1, 100                                                  
     .              if ((a_gauquadlat(l).gt.0.0000000000000000e+000)) then      
     .                 az_u11 = (5.00000000000000e+001*((dsin((                 
     .       1            3.14159265358979e+000*((dsin(a_gauquadlat(l)))**2)))) 
     .       2            **3))*z_f(k)                                          
     .                 az_dudz12 = (5.00000000000000e+001*((dsin((              
     .       1            3.14159265358979e+000*((dsin(a_gauquadlat(l)))**2)))) 
     .       2            **3))*z_dfdz(k)                                       
     .              else                                                        
     .                 az_u11 = 0.0000000000000000e+000                         
     .                 az_dudz12 = 0.0000000000000000e+000                      
     .              endif                                                       
     .              az_dudz(l,k) = az_dudz12                                    
     .              az_u(l,k) = az_u11                                          
     .              if ((a_gauquadlat(l).gt.0.0000000000000000e+000)) then      
     .                 az_dtempdphi13 = -7.34000000000000e+003/gasrdry*(        
     .       1            2.00000000000000e+000*rplanet*omega*dsin(a_gauquadlat(
     .       2            l))+2.00000000000000e+000*az_u(l,k)*dtan(a_gauquadlat(
     .       3            l)))*az_dudz(l,k)                                     
     .              else                                                        
     .                 az_dtempdphi13 = 0.0000000000000000e+000                 
     .              endif                                                       
     .              az_dtempdphi(l,k) = az_dtempdphi13                          
     .           enddo                                                          
     .        enddo                                                             
   843  
   844        do k = 1, kmax
   845          xyz_Temp(:,j,k) = 0.0_DP
   846        end do
     .        if (kmax .gt. 0) then                                             
     .           j1 = and(kmax,3)                                               
     .           do k = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do t682 = 1, imax                                           
     .                 xyz_temp(t682-1,j,k) = 0.0000000000000000e+000           
     .              enddo                                                       
     .           enddo                                                          
     .           do k = j1 + 1, kmax, 4                                         
     .  !cdir       nodep                                                       
     .              do t682 = 1, imax                                           
     .                 xyz_temp(t682-1,j,k) = 0.0000000000000000e+000           
     .                 xyz_temp(t682-1,j,k+1) = 0.0000000000000000e+000         
     .                 xyz_temp(t682-1,j,k+2) = 0.0000000000000000e+000         
     .                 xyz_temp(t682-1,j,k+3) = 0.0000000000000000e+000         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   847        do k = 1, kmax
   848          do l = 1, NGauQuad
   849            xyz_Temp(:,j,k) = xyz_Temp(:,j,k) + az_DTempDPhi(l,k) * a_GauWeight(l)
   850          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t6851 = 0, imax - 1, maxvl()                                   
     .           t6852 = min0(imax - t6851,maxvl())                             
     .           do l = 1, 100, 4                                               
     .  !cdir       shortloop                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_temp)                                            
     .              do t685 = 1, t6852                                          
     .                 xyz_temp(t6851+t685-1,j,k) = xyz_temp(t6851+t685-1,j,k)  
     .       1             + az_dtempdphi(l,k)*a_gauweight(l) + az_dtempdphi(l+1
     .       2            ,k)*a_gauweight(l+1) + az_dtempdphi(l+2,k)*a_gauweight
     .       3            (l+2) + az_dtempdphi(l+3,k)*a_gauweight(l+3)          
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
   851        end do
   852  
   853      end do
   854  
   855      !  Calculate T0
   856      !
   857      do k = 1, kmax
   858        z_Temp0(k) = 0.0_DP
   859        do j = 1, jmax
   860          z_Temp0(k) = z_Temp0(k) + xyz_Temp(0,j,k) * y_Lat_weight(j)
   861        end do
   862      end do
     .        if (kmax .gt. 0) then                                             
     .           j2 = and(kmax,3)                                               
     .           do k = 1, j2                                                   
     .              z_temp0(k) = 0.0000000000000000e+000                        
     .              if (jmax .gt. 0) then                                       
     .                 z_temp015 = z_temp0(k)                                   
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(y_lat_weight)                                     
     .                 do j = 1, jmax                                           
     .                    z_temp015=z_temp015+xyz_temp(0,j,k)*y_lat_weight(j)   
     .                 enddo                                                    
     .                 z_temp0(k) = z_temp015                                   
     .              endif                                                       
     .           enddo                                                          
     .           do k = j2 + 1, kmax, 4                                         
     .              z_temp0(k) = 0.0000000000000000e+000                        
     .              z_temp0(k+1) = 0.0000000000000000e+000                      
     .              z_temp0(k+2) = 0.0000000000000000e+000                      
     .              z_temp0(k+3) = 0.0000000000000000e+000                      
     .              if (jmax .gt. 0) then                                       
     .                 z_temp016 = z_temp0(k)                                   
     .                 z_temp017 = z_temp0(k+1)                                 
     .                 z_temp018 = z_temp0(k+2)                                 
     .                 z_temp019 = z_temp0(k+3)                                 
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(y_lat_weight)                                     
     .                 do j = 1, jmax                                           
     .                    d14 = y_lat_weight(j)                                 
     .                    z_temp016 = z_temp016 + xyz_temp(0,j,k)*d14           
     .                    z_temp017 = z_temp017 + xyz_temp(0,j,k+1)*d14         
     .                    z_temp018 = z_temp018 + xyz_temp(0,j,k+2)*d14         
     .                    z_temp019 = z_temp019 + xyz_temp(0,j,k+3)*d14         
     .                 enddo                                                    
     .                 z_temp0(k+3) = z_temp019                                 
     .                 z_temp0(k+2) = z_temp018                                 
     .                 z_temp0(k+1) = z_temp017                                 
     .                 z_temp0(k) = z_temp016                                   
     .              endif                                                       
     .           enddo                                                          
     .        endif                                                             
   863      z_Temp0 = z_Temp0 / 2.0_DP
     .        d20 = 1.D0/2.00000000000000e+000                                  
     .  !cdir nodep                                                             
     .        do t689 = 1, z_temp0.DSC.U1                                       
     .           z_temp0(t689) = z_temp0(t689)*d20                              
     .        enddo                                                             
   864      !
   865      !  add T0
   866      !
   867      do k = 1, kmax
   868        xyz_Temp(:,:,k) = xyz_Temp(:,:,k) - z_Temp0(k) + z_TempUSStd(k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_temp)                                                  
     .        do t693 = 1, jmax*imax                                            
     .           xyz_temp(t693-1,1,k) = xyz_temp(t693-1,1,k) - z_temp0(k) +     
     .       1      z_tempusstd(k)                                              
     .        enddo                                                             
   869      end do
   870  
   871  
   872      ! Code for debug
   873  !!$    do k = 1, kmax
   874  !!$      z_Temp0(k) = 0.0_DP
   875  !!$      do j = 1, jmax
   876  !!$        z_Temp0(k) = z_Temp0(k) + xyz_Temp(0,j,k) * y_Lat_weight(j)
   877  !!$      end do
   878  !!$    end do
   879  !!$    z_Temp0 = z_Temp0 / 2.0_DP
   880  !!$    do k = 1, kmax
   881  !!$      write( 6, * ) k, z_Temp0(k), z_TempUSStd(k), z_Temp0(k)-z_TempUSStd(k)
   882  !!$    end do
   883  !!$    stop
   884  
   885  
   886  
   887      ! 温度に擾乱を与える
   888      ! Add perturbation to temperature
   889      !
   890      do k = 1, kmax
   891        do j = 1, jmax
   892          do i = 0, imax-1
   893            if ( ( x_Lon(i) >= 0 ) .and. ( x_Lon(i) < PI ) ) then
   894              xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                             &
   895                & + 1.0_DP / cosh( 3.0_DP * ( x_Lon(i)               ) )**2 &
   896                & * 1.0_DP / cosh( 6.0_DP * ( y_Lat(j) - PI / 4.0_DP ) )**2
   897            else if ( ( x_Lon(i) >= PI ) .and. ( x_Lon(i) < 2.0_DP * PI ) ) then
   898              xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                             &
   899                & + 1.0_DP / cosh( 3.0_DP * ( x_Lon(i) - 2.0_DP * PI ) )**2 &
   900                & * 1.0_DP / cosh( 6.0_DP * ( y_Lat(j) - PI / 4.0_DP ) )**2
   901            end if
   902          end do
   903        end do
   904      end do
     .  !cdir noassume                                                          
     .        do i1 = 0, imax - 1, maxvl()                                      
     .           i2 = min0(imax - i1,maxvl())                                   
     .           do j = 1, jmax                                                 
     .              if (kmax .gt. 0) then                                       
     .                 j5 = and(kmax,3)                                         
     .                 do k = 1, j5                                             
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(x_lon)                                         
     .                    do i = 1, i2                                          
     .                       if (x_lon(i1+i-1).ge.0.0000000000000000e+000 .and. 
     .       1                  x_lon(i1+i-1).lt.3.14159265358979e+000) then    
     .                          xyz_temp(i1+i-1,j,k) = xyz_temp(i1+i-1,j,k) +   
     .       1                     1.00000000000000e+000/dcosh(                 
     .       2                     3.00000000000000e+000*x_lon(i1+i-1))**2*     
     .       3                     1.00000000000000e+000/dcosh(                 
     .       4                     6.00000000000000e+000*(y_lat(j)-             
     .       5                     7.85398163397448e-001))**2                   
     .                       else                                               
     .                          if (x_lon(i1+i-1).ge.3.14159265358979e+000 .and.
     .       1                      x_lon(i1+i-1).lt.6.28318530717958e+000) then
     .                             xyz_temp(i1+i-1,j,k) = xyz_temp(i1+i-1,j,k)  
     .       1                         + 1.00000000000000e+000/dcosh(           
     .       2                        3.00000000000000e+000*(x_lon(i1+i-1)-     
     .       3                        6.28318530717958e+000))**2*               
     .       4                        1.00000000000000e+000/dcosh(              
     .       5                        6.00000000000000e+000*(y_lat(j)-          
     .       6                        7.85398163397448e-001))**2                
     .                          endif                                           
     .                       endif                                              
     .                    enddo                                                 
     .                 enddo                                                    
     .                 do k = j5 + 1, kmax, 4                                   
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(x_lon)                                         
     .                    do i = 1, i2                                          
     .                       if (x_lon(i1+i-1).ge.0.0000000000000000e+000 .and. 
     .       1                  x_lon(i1+i-1).lt.3.14159265358979e+000) then    
     .                          xyz_temp(i1+i-1,j,k) = xyz_temp(i1+i-1,j,k) + ((
     .       1                     (1.00000000000000e+000/((dcosh((             
     .       2                     3.00000000000000e+000*x_lon(i1+i-1))))**2))* 
     .       3                     1.00000000000000e+000)/((dcosh((             
     .       4                     6.00000000000000e+000*(y_lat(j)-             
     .       5                     7.85398163397448e-001))))**2))               
     .                          xyz_temp(i1+i-1,j,k+1) = xyz_temp(i1+i-1,j,k+1) 
     .       1                      + (((1.00000000000000e+000/((dcosh((        
     .       2                     3.00000000000000e+000*x_lon(i1+i-1))))**2))* 
     .       3                     1.00000000000000e+000)/((dcosh((             
     .       4                     6.00000000000000e+000*(y_lat(j)-             
     .       5                     7.85398163397448e-001))))**2))               
     .                          xyz_temp(i1+i-1,j,k+2) = xyz_temp(i1+i-1,j,k+2) 
     .       1                      + (((1.00000000000000e+000/((dcosh((        
     .       2                     3.00000000000000e+000*x_lon(i1+i-1))))**2))* 
     .       3                     1.00000000000000e+000)/((dcosh((             
     .       4                     6.00000000000000e+000*(y_lat(j)-             
     .       5                     7.85398163397448e-001))))**2))               
     .                          xyz_temp(i1+i-1,j,k+3) = xyz_temp(i1+i-1,j,k+3) 
     .       1                      + (((1.00000000000000e+000/((dcosh((        
     .       2                     3.00000000000000e+000*x_lon(i1+i-1))))**2))* 
     .       3                     1.00000000000000e+000)/((dcosh((             
     .       4                     6.00000000000000e+000*(y_lat(j)-             
     .       5                     7.85398163397448e-001))))**2))               
     .                       else                                               
     .                          if (x_lon(i1+i-1).ge.3.14159265358979e+000 .and.
     .       1                      x_lon(i1+i-1).lt.6.28318530717958e+000) then
     .                             xyz_temp(i1+i-1,j,k) = xyz_temp(i1+i-1,j,k)  
     .       1                         + (((1.00000000000000e+000/((dcosh((     
     .       2                        3.00000000000000e+000*(x_lon(i1+i-1)-     
     .       3                        6.28318530717958e+000))))**2))*           
     .       4                        1.00000000000000e+000)/((dcosh((          
     .       5                        6.00000000000000e+000*(y_lat(j)-          
     .       6                        7.85398163397448e-001))))**2))            
     .                             xyz_temp(i1+i-1,j,k+1) = xyz_temp(i1+i-1,j,k+
     .       1                        1) + (((1.00000000000000e+000/((dcosh((   
     .       2                        3.00000000000000e+000*(x_lon(i1+i-1)-     
     .       3                        6.28318530717958e+000))))**2))*           
     .       4                        1.00000000000000e+000)/((dcosh((          
     .       5                        6.00000000000000e+000*(y_lat(j)-          
     .       6                        7.85398163397448e-001))))**2))            
     .                             xyz_temp(i1+i-1,j,k+2) = xyz_temp(i1+i-1,j,k+
     .       1                        2) + (((1.00000000000000e+000/((dcosh((   
     .       2                        3.00000000000000e+000*(x_lon(i1+i-1)-     
     .       3                        6.28318530717958e+000))))**2))*           
     .       4                        1.00000000000000e+000)/((dcosh((          
     .       5                        6.00000000000000e+000*(y_lat(j)-          
     .       6                        7.85398163397448e-001))))**2))            
     .                             xyz_temp(i1+i-1,j,k+3) = xyz_temp(i1+i-1,j,k+
     .       1                        3) + (((1.00000000000000e+000/((dcosh((   
     .       2                        3.00000000000000e+000*(x_lon(i1+i-1)-     
     .       3                        6.28318530717958e+000))))**2))*           
     .       4                        1.00000000000000e+000)/((dcosh((          
     .       5                        6.00000000000000e+000*(y_lat(j)-          
     .       6                        7.85398163397448e-001))))**2))            
     .                          endif                                           
     .                       endif                                              
     .                    enddo                                                 
     .                 enddo                                                    
     .              endif                                                       
     .           enddo                                                          
     .        enddo                                                             
   905  
   906  
   907    end subroutine Polvanietal2004InitData
   908  
   909    !--------------------------------------------------------------------------------------
   910  
   911    subroutine VenusInitData( &
   912      & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps & ! (out)
   913      & )
   914  
   915      ! 種別型パラメタ
   916      ! Kind type parameter
   917      !
   918      use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   919        &                 STRING     ! 文字列.       Strings.
   920  
   921  
   922      ! 格子点設定
   923      ! Grid points settings
   924      !
   925      use gridset, only: imax, & ! 経度格子点数.
   926                                 ! Number of grid points in longitude
   927        &                jmax, & ! 緯度格子点数.
   928                                 ! Number of grid points in latitude
   929        &                kmax    ! 鉛直層数.
   930                                 ! Number of vertical level
   931  
   932      ! 物理定数設定
   933      ! Physical constants settings
   934      !
   935      use constants, only: &
   936        & Grav, &               ! $ g $ [m s-2].
   937                                ! 重力加速度.
   938                                ! Gravitational acceleration
   939        & CpDry, &
   940                                ! $ C_p $ [J kg-1 K-1].
   941                                ! 乾燥大気の定圧比熱.
   942                                ! Specific heat of air at constant pressure
   943        & GasRDry               ! $ R $ [J kg-1 K-1].
   944                                ! 乾燥大気の気体定数.
   945                                ! Gas constant of air
   946  
   947      use axesset, only: &
   948        & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   949        & z_Sigma, &            ! $ \sigma $ レベル (整数).
   950                                ! Full $ \sigma $ level
   951        & r_Sigma, &            ! $ \sigma $ レベル (半整数).
   952                                ! Half $ \sigma $ level
   953        & r_DelSigma            ! $ \Delta \sigma $ (半整数).
   954                                ! $ \Delta \sigma $ (half)
   955  
   956      real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
   957                                ! $ u $ .   東西風速. Eastward wind
   958      real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
   959                                ! $ v $ .   南北風速. Northward wind
   960      real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   961                                ! $ T $ .   温度. Temperature
   962      real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
   963                                ! $ q $ .   比湿. Specific humidity
   964      real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
   965                                ! $ p_s $ . 地表面気圧. Surface pressure
   966  
   967  
   968      !
   969      ! local variables
   970      !
   971      real(DP) :: SurfTemp
   972      real(DP) :: xyr_Temp     (0:imax-1,1:jmax,0:kmax)
   973      real(DP) :: xy_SurfHeight(0:imax-1,1:jmax)
   974      real(DP) :: xyz_Height   (0:imax-1,1:jmax,1:kmax)
   975      real(DP) :: z( 5 ), a( 6 ), ah( 5 ), d( 5 )
   976      integer  :: j
   977      integer  :: k
   978      integer  :: l
   979      integer  :: m
   980  
   981  
   982      ! Coefficients for thermal structure by Hou and Farrel (1987)
   983      !
   984      z ( 1 ) =   0.0e3_DP
   985      z ( 2 ) =  10.0e3_DP
   986      z ( 3 ) =  25.0e3_DP
   987      z ( 4 ) =  55.0e3_DP
   988      z ( 5 ) = 100.0e3_DP
   989  
   990      ah( 1 ) =  -1.0e-3_DP
   991      ah( 2 ) =  -1.0e-3_DP
   992      ah( 3 ) =  -3.1e-3_DP
   993      ah( 4 ) =  -6.75e-3_DP
   994      ah( 5 ) =  10.0e-3_DP
   995  
   996      d ( 1 ) =  10.0e3_DP
   997      d ( 2 ) =  10.0e3_DP
   998      d ( 3 ) =   8.0e3_DP
   999      d ( 4 ) =   5.0e3_DP
  1000      d ( 5 ) =  70.0e3_DP
  1001  
  1002  
  1003      a ( 1 ) =   0.0_DP
  1004      do l = 2, 6
  1005        a( l ) = 2.0_DP * ah( l-1 ) * d( l-1 ) + a( l-1 )
  1006      end do
     .        a(2) = 2.00000000000000e+000*ah(1)*d(1) + a(1)                    
     .        a(3) = 2.00000000000000e+000*ah(2)*d(2) + a(2)                    
     .        a(4) = 2.00000000000000e+000*ah(3)*d(3) + a(3)                    
     .        a(5) = 2.00000000000000e+000*ah(4)*d(4) + a(4)                    
     .        a(6) = 2.00000000000000e+000*ah(5)*d(5) + a(5)                    
  1007  
  1008  
  1009      SurfTemp      = 750.0_DP
  1010      xy_SurfHeight =   0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t362 = 1, xy_surfheight.DSC.U2*xy_surfheight.DSC.U1 +          
     .       1   xy_surfheight.DSC.U2                                           
     .           xy_surfheight(t362-1,1) = 0.0000000000000000e+000              
     .        enddo                                                             
  1011  
  1012  
  1013      ! Initialization
  1014      xyz_Temp = 200.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t368 = 1, kmax*jmax*imax                                       
     .           xyz_temp(t368-1,1,1) = 2.00000000000000e+002                   
     .        enddo                                                             
  1015  
  1016      ! Iteration
  1017      do m = 1, 10
  1018  
  1019        xyr_Temp(:,:,0) = xyz_Temp(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_temp,xyr_temp)                                         
     .        do t377 = 1, xyr_temp.DSC.U2*xyr_temp.DSC.U1 + xyr_temp.DSC.U2    
     .           xyr_temp(t377-1,1,0) = xyz_temp(t377-1,1,1)                    
     .        enddo                                                             
  1020        do k = 1, kmax-1
  1021          xyr_Temp(:,:,k) = ( xyz_Temp(:,:,k) + xyz_Temp(:,:,k+1) ) / 2.0_DP
  1022        end do
     .        d1 = 1.D0/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_temp,xyr_temp)                                         
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyr_temp(k-1,1,1) = (xyz_temp(k-1,1,1)+xyz_temp(k-1,1,2))*d1   
     .        enddo                                                             
  1023        xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_temp,xyr_temp,xy_surfheight,xyz_height)                
     .        do t395 = 1, xyr_temp.DSC.U2*xyr_temp.DSC.U1 + xyr_temp.DSC.U2    
     .           xyr_temp(t395-1,1,kmax) = xyz_temp(t395-1,1,kmax)              
     .           xyz_height(t395-1,1,1) = xy_surfheight(t395-1,1) + gasrdry/grav
     .       1      *xyz_temp(t395-1,1,1)*(1.00000000000000e+000 - z_sigma(1))  
     .        enddo                                                             
  1024  
  1025  
  1026        xyz_Height(:,:,1) = &
  1027          &   xy_SurfHeight &
  1028          & + GasRDry / Grav * xyz_Temp(:,:,1) * ( 1. - z_Sigma(1) )
  1029        do k = 2, kmax
  1030          xyz_Height(:,:,k) = &
     .        d2 = r_delsigma(k-1)/r_sigma(k-1)                                 
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_temp,xyz_height)                                       
     .        do t409 = 1, xyz_height.DSC.U2*xyz_height.DSC.U1 +                
     .       1   xyz_height.DSC.U2                                              
     .           xyz_height(t409-1,1,k) = xyz_height(t409-1,1,k-1) + gasrdry/   
     .       1      grav*xyr_temp(t409-1,1,k-1)*d2                              
     .        enddo                                                             
  1031            &   xyz_Height(:,:,k-1) &
  1032            & + GasRDry / Grav * xyr_Temp(:,:,k-1) &
  1033            &   * r_DelSigma(k-1) / r_Sigma(k-1)
  1034        end do
  1035  
  1036        xyz_Temp = SurfTemp - Grav / CpDry * xyz_Height
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_height,xyz_temp)                                       
     .        do t419 = 1, xyz_height.DSC.U3*(xyz_height.DSC.U2*                
     .       1   xyz_height.DSC.U1 + xyz_height.DSC.U2)                         
     .           xyz_temp(t419-1,1,1) = surftemp - grav/cpdry*xyz_height(t419-1,
     .       1      1,1)                                                        
     .        enddo                                                             
  1037        do l = 1, 5
  1038          xyz_Temp = xyz_Temp &
     .        d3 = 1.D0/d(l)                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_temp,xyz_height)                                       
     .        do t431 = 1, kmax*jmax*imax                                       
     .           xyz_temp(t431-1,1,1) = xyz_temp(t431-1,1,1) - ((a(l+1)-a(l))*  
     .       1      5.00000000000000e-001)*(1.00000000000000e+000 + dtanh((     
     .       2      0.0000000000000000e+000 - z(l))/d(l)))                      
     .           xyz_temp(t431-1,1,1) = xyz_temp(t431-1,1,1) + ((a(l+1)-a(l))*  
     .       1      5.00000000000000e-001)*(1.00000000000000e+000 + dtanh((     
     .       2      xyz_height(t431-1,1,1)-z(l))*d3))                           
     .        enddo                                                             
  1039            & - ( a(l+1) - a(l) ) * 0.5_DP &
  1040            &   * ( 1.0_DP + tanh( ( 0.0_DP      - z(l) ) / d(l) ) )
  1041          xyz_Temp = xyz_Temp &
  1042            & + ( a(l+1) - a(l) ) * 0.5_DP &
  1043            &   * ( 1.0_DP + tanh( ( xyz_Height - z(l) ) / d(l) ) )
  1044        end do
  1045  
  1046      end do
  1047  
  1048      ! add perturbation
  1049      xyz_Temp(0,1,1) = xyz_Temp(0,1,1) + 1.0_DP
  1050  
  1051  
  1052      do k = 1, kmax
  1053        do j = 1, jmax
  1054          xyz_U(:,j,k) = Ueq * cos(y_Lat(j))
  1055        end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do t452 = 1, imax                                           
     .                 xyz_u(t452-1,j,k) = ueq*dcos(y_lat(j))                   
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do t452 = 1, imax                                           
     .                 xyz_u(t452-1,j,k) = ueq*dcos(y_lat(j))                   
     .                 xyz_u(t452-1,j+1,k) = ueq*dcos(y_lat(j+1))               
     .                 xyz_u(t452-1,j+2,k) = ueq*dcos(y_lat(j+2))               
     .                 xyz_u(t452-1,j+3,k) = ueq*dcos(y_lat(j+3))               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1056      end do
  1057      xyz_V    = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t455 = 1, kmax*jmax*imax                                       
     .           xyz_v(t455-1,1,1) = 0.0000000000000000e+000                    
     .           xyz_qvap(t455-1,1,1) = qvapavr                                 
     .        enddo                                                             
  1058      xyz_QVap = QVapAvr
  1059      xy_Ps    = PsAvr
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t467 = 1, jmax*imax                                            
     .           xy_ps(t467-1,1) = psavr                                        
     .        enddo                                                             
  1060  
  1061  
  1062    end subroutine VenusInitData
  1063  
  1064    !--------------------------------------------------------------------------------------
  1065  
  1066    subroutine InitDataInit
  1067  
  1068      ! モジュール引用 ; USE statements
  1069      !
  1070  
  1071      ! NAMELIST ファイル入力に関するユーティリティ
  1072      ! Utilities for NAMELIST file input
  1073      !
  1074      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1075  
  1076      ! ファイル入出力補助
  1077      ! File I/O support
  1078      !
  1079      use dc_iounit, only: FileOpen
  1080  
  1081      ! 文字列操作
  1082      ! Character handling
  1083      !
  1084      use dc_string, only: LChar
  1085  
  1086      ! 飽和比湿の算出
  1087      ! Evaluate saturation specific humidity
  1088      !
  1089      use saturate, only: SaturateInit
  1090  
  1091      ! ファイルから 1 次元プロファイルを読んで設定する.
  1092      ! read 1-D profile from a file and set it
  1093      !
  1094      use set_1d_profile, only : Set1DProfileInit
  1095  
  1096      !
  1097      ! Utility module for advection test
  1098      !
  1099      use adv_test, only: AdvTestInit
  1100  
  1101  
  1102      ! 宣言文 ; Declaration statements
  1103      !
  1104      implicit none
  1105  
  1106      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1107                                ! Unit number for NAMELIST file open
  1108      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1109                                ! IOSTAT of NAMELIST read
  1110  
  1111      ! NAMELIST 変数群
  1112      ! NAMELIST group name
  1113      !
  1114      namelist /initial_data_nml/ Pattern, &
  1115        & TempAvr, PsAvr, QVapAvr, Ueq, UGeos, VGeos
  1116            !
  1117            ! デフォルト値については初期化手続 "initial_data#InitDataInit"
  1118            ! のソースコードを参照のこと.
  1119            !
  1120            ! Refer to source codes in the initialization procedure
  1121            ! "initial_data#InitDataInit" for the default values.
  1122            !
  1123  
  1124  
  1125      ! 実行文 ; Executable statement
  1126  
  1127      if ( initial_data_inited ) return
  1128  
  1129  
  1130      ! デフォルト値の設定 (まずは Pattern のみ)
  1131      ! Default values settings (At first, "Pattern" only)
  1132      !
  1133      Pattern = 'Small Disturbance of Temperature'
  1134      !Pattern = 'AGCM 5.3 Default'
  1135  
  1136      ! NAMELIST の読み込み (まずは Pattern のみ)
  1137      ! NAMELIST is input (At first, "Pattern" only)
  1138      !
  1139      if ( trim(namelist_filename) /= '' ) then
  1140        call FileOpen( unit_nml, &          ! (out)
  1141          & namelist_filename, mode = 'r' ) ! (in)
  1142  
  1143        rewind( unit_nml )
  1144        read( unit_nml, &             ! (in)
  1145          & nml = initial_data_nml, & ! (out)
  1146          & iostat = iostat_nml )     ! (out)
  1147        close( unit_nml )
  1148  
  1149        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1150      end if
  1151  
  1152      ! デフォルト値の設定
  1153      ! Default values settings
  1154      !
  1155      select case ( LChar( trim(Pattern) ) )
  1156      case ( 'small disturbance of temperature' )
  1157        TempAvr = 250.0_DP
  1158        PsAvr   = 1.0e+5_DP
  1159  !!$      QVapAvr = 1.0e-10_DP
  1160        QVapAvr = 0.0e0_DP
  1161        Ueq     = 0.0_DP
  1162        UGeos   = 0.0_DP
  1163        VGeos   = 0.0_DP
  1164      case ( 'agcm 5.3 default' )
  1165        TempAvr = 250.0_DP
  1166        PsAvr   = 1.0e+5_DP
  1167        QVapAvr = 1.0e-10_DP
  1168        Ueq     = 0.0_DP
  1169        UGeos   = 0.0_DP
  1170        VGeos   = 0.0_DP
  1171      case ( 'sugiyama et al. (2008)' )
  1172        TempAvr = 490.0_DP
  1173        PsAvr   = 3.0e+6_DP
  1174        QVapAvr = 6.11641e-3_DP
  1175        Ueq     = 0.0_DP
  1176        UGeos   = 0.0_DP
  1177        VGeos   = 0.0_DP
  1178      case ( 'polvani et al. (2004)' )
  1179        TempAvr = 0.0_DP
  1180        PsAvr   = 1.0e+5_DP
  1181        QVapAvr = 0.0_DP
  1182        Ueq     = 0.0_DP
  1183        UGeos   = 0.0_DP
  1184        VGeos   = 0.0_DP
  1185      case ( 'venus' )
  1186        TempAvr = 0.0_DP
  1187        PsAvr   = 90.0e+5_DP
  1188        QVapAvr = 0.0_DP
  1189        Ueq     = 0.0_DP
  1190        UGeos   = 0.0_DP
  1191        VGeos   = 0.0_DP
  1192      case ( '1-d profile' )
  1193        TempAvr = 1.0e+100_DP
  1194        PsAvr   = 1.0e+100_DP
  1195        QVapAvr = 0.0_DP
  1196        Ueq     = 0.0_DP
  1197        UGeos   = 0.0_DP
  1198        VGeos   = 0.0_DP
  1199      case ( 'advection test' )
  1200        TempAvr = 300.0_DP
  1201        PsAvr   =   1.0e+5_DP
  1202        QVapAvr =   0.0e0_DP
  1203        Ueq     =   0.0_DP
  1204        UGeos   =   0.0_DP
  1205        VGeos   =   0.0_DP
  1206      case default
  1207        call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
  1208          & c1 = trim(Pattern) )
  1209      end select
  1210  
  1211      ! NAMELIST の読み込み
  1212      ! NAMELIST is input
  1213      !
  1214      if ( trim(namelist_filename) /= '' ) then
  1215        call FileOpen( unit_nml, &          ! (out)
  1216          & namelist_filename, mode = 'r' ) ! (in)
  1217  
  1218        rewind( unit_nml )
  1219        read( unit_nml, &             ! (in)
  1220          & nml = initial_data_nml, & ! (out)
  1221          & iostat = iostat_nml )     ! (out)
  1222        close( unit_nml )
  1223  
  1224        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1225      end if
  1226  
  1227  
  1228      ! Initialization of modules used in this module
  1229      !
  1230      ! 飽和比湿の算出
  1231      ! Evaluate saturation specific humidity
  1232      !
  1233      call SaturateInit
  1234  
  1235      ! ファイルから 1 次元プロファイルを読んで設定する.
  1236      ! read 1-D profile from a file and set it
  1237      !
  1238      call Set1DProfileInit
  1239  
  1240      !
  1241      ! Utility module for advection test
  1242      !
  1243      call AdvTestInit
  1244  
  1245  
  1246      ! 印字 ; Print
  1247      !
  1248      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1249      call MessageNotify( 'M', module_name, '  Pattern = %c', c1 = trim(Pattern) )
  1250      call MessageNotify( 'M', module_name, '  TempAvr = %f', d = (/ TempAvr  /) )
  1251      call MessageNotify( 'M', module_name, '  PsAvr   = %f', d = (/ PsAvr  /) )
  1252      call MessageNotify( 'M', module_name, '  QVapAvr = %f', d = (/ QVapAvr  /) )
  1253      call MessageNotify( 'M', module_name, '  Ueq     = %f', d = (/ Ueq  /) )
  1254      call MessageNotify( 'M', module_name, '  UGeos   = %f', d = (/ UGeos /) )
  1255      call MessageNotify( 'M', module_name, '  VGeos   = %f', d = (/ VGeos /) )
  1256      call MessageNotify( 'M', module_name, '' )
  1257      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1258  
  1259      initial_data_inited = .true.
  1260  
  1261    end subroutine InitDataInit
  1262  
  1263    !--------------------------------------------------------------------------------------
  1264  
  1265  end module initial_data
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:30 2016
FILE NAME: initial_data.f90
PROGRAM NAME: initial_data
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 初期値データ提供
     2:             !
     3:             != Prepare initial data
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. TAKAHASHI (code by Taro KITANO is included)
     6:             ! Version::   $Id: initial_data.f90,v 1.16 2015/02/17 23:50:42 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module initial_data
    13:               !
    14:               != 初期値データ提供
    15:               !
    16:               != Prepare initial data
    17:               !
    18:               ! 初期値データのサンプルを提供します. 
    19:               ! 
    20:               ! 現在は以下のデータを提供します. 
    21:               ! 
    22:               ! * Small Disturbance of Temperature
    23:               !   * 風速: 0 [m/s], 地表面気圧: 1.0e+5 [Pa], 比湿: 1.0e-10 [kg kg-1]
    24:               !   * 温度: 250 [K] に微小擾乱を加えたもの
    25:               !
    26:               ! * [AGCM 5.3]{http://www.gfd-dennou.org/library/agcm5} Default
    27:               !   * 風速: 0 [m/s], 地表面気圧: 1.0e+5 [Pa], 比湿: 1.0e-10 [kg kg-1]
    28:               !   * 温度: 250 [K] に微小擾乱を加えたもの
    29:               ! 
    30:               ! * Sugiyama et al. (2008)
    31:               !   * 木星大気を想定した, Sugiyama et al. (2008) で用いられていた
    32:               !     初期値を模倣する. 
    33:               !   * 風速: 0 [m/s], 地表面気圧: 3.0e+6 [Pa]
    34:               !   * 温度: $ \sigma = 1 $ で 490 [K] とし, 気圧 1.0e+4 となる高度まで, 
    35:               !     温位一定で (乾燥断熱線に沿って) 高度に伴い温度を減少させる. 
    36:               !     気圧 1.0e+4 以下の高度では温度一定とする. 
    37:               !   * 比湿: $ \sigma = 1 $ で 6.11641e-3 [kg kg-1] とし, 
    38:               !     比湿が飽和比湿の 75 % となる高度までは一定とする. 
    39:               !     その高度以上では, 比湿を飽和比湿の 75 % とする. 
    40:               !
    41:               ! Prepare sample data of initial data (restart data)
    42:               !
    43:               ! Now, following data are provided. 
    44:               ! 
    45:               ! * Small Disturbance of Temperature
    46:               !   * Velocity: 0 [m/s], Surface pressure: 1.0e+5 [Pa], 
    47:               !     Specific humidity: 1.0e-10 [kg kg-1]
    48:               !   * Temperature: 250 [K] and perturbation
    49:               !
    50:               ! * [AGCM 5.3]{http://www.gfd-dennou.org/library/agcm5} Default
    51:               !   * Velocity: 0 [m/s], Surface pressure: 1.0e+5 [Pa], 
    52:               !     Specific humidity: 1.0e-10 [kg kg-1]
    53:               !   * Temperature: 250 [K] and perturbation
    54:               ! 
    55:               ! * Sugiyama et al. (2008)
    56:               !   * Initial data like a Jovian atmosphere  
    57:               !     that is used in Sugiyama et al. (2008) is imitated. 
    58:               !   * Velocity: 0 [m/s], Surface pressure: 3.0e+6 [Pa]
    59:               !   * Temperature: 490 [K] at $ \sigma = 1 $ . 
    60:               !     And it is declined with constant potential temperature
    61:               !     (along dry adiabat line) 
    62:               !     below where air pressure is 1.0e+4. 
    63:               !     It is constant above where air pressure is 1.0e+4. 
    64:               !   * Specific humidity: 6.11641e-3 [kg kg-1] at $ \sigma = 1 $ .
    65:               !     And it is constant below where it is same as 75 % of 
    66:               !     saturation specific humidity. 
    67:               !     Above that, specific humidity is 75 % of saturation specific humidity. 
    68:               !
    69:               !== Procedures List
    70:               !
    71:               ! SetInitData   :: 初期値データ取得
    72:               ! ------------  :: ------------
    73:               ! SetInitData   :: Get initial data
    74:               !
    75:               !== NAMELIST
    76:               !
    77:               ! NAMELIST#initial_data_nml
    78:               !
    79:             
    80:               ! モジュール引用 ; USE statements
    81:               !
    82:             
    83:               ! 格子点設定
    84:               ! Grid points settings
    85:               !
    86:               use gridset, only: imax, & ! 経度格子点数. 
    87:                                          ! Number of grid points in longitude
    88:                 &                jmax, & ! 緯度格子点数. 
    89:                                          ! Number of grid points in latitude
    90:                 &                kmax    ! 鉛直層数. 
    91:                                          ! Number of vertical level
    92:             
    93:               ! 組成に関わる配列の設定
    94:               ! Settings of array for atmospheric composition
    95:               !
    96:               use composition, only: &
    97:                 &                    ncmax, &
    98:                                           ! 成分の数
    99:                                           ! Number of composition
   100:                 &                    IndexH2OVap
   101:             
   102:               ! 種別型パラメタ
   103:               ! Kind type parameter
   104:               !
   105:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
   106:                 &                 STRING     ! 文字列.       Strings. 
   107:             
   108:               ! 種別型パラメタ
   109:               ! Kind type parameter
   110:               !
   111:               use dc_types, only: DP     ! 倍精度実数型. Double precision. 
   112:             
   113:               ! メッセージ出力
   114:               ! Message output
   115:               !
   116:               use dc_message, only: MessageNotify
   117:             
   118:               ! 宣言文 ; Declaration statements
   119:               !
   120:               implicit none
   121:               private
   122:             
   123:               ! 公開手続き
   124:               ! Public procedure
   125:               !
   126:               public:: SetInitData
   127:               public:: InitDataInit
   128:             
   129:               ! 公開変数
   130:               ! Public variables
   131:               !
   132:               logical, save, public:: initial_data_inited = .false.
   133:                                           ! 初期設定フラグ. 
   134:                                           ! Initialization flag
   135:             
   136:               character(STRING), save, public:: Pattern
   137:                                           ! 初期値データのパターン. 
   138:                                           ! 以下のパターンを選択可能. 
   139:                                           ! 
   140:                                           ! Initial data pattern
   141:                                           ! Available patterns are as follows.
   142:                                           ! 
   143:                                           ! * "Small Disturbance of Temperature" (default value)
   144:                                           ! * "AGCM 5.3 Default"
   145:                                           ! * "Sugiyama et al. (2008)"
   146:                                           ! 
   147:               real(DP), save, public:: TempAvr
   148:                                           ! $ \bar{T} $ .     温度平均値. Mean temperature
   149:               real(DP), save, public:: PsAvr
   150:                                           ! $ \bar{p_s} $ .   地表面気圧平均値. Mean surface pressure
   151:               real(DP), save, public:: QVapAvr
   152:                                           ! $ \bar{q} $ .     比湿平均値. Mean specific humidity
   153:               real(DP), save, public:: Ueq
   154:                                           ! $ u_{eq} $ .      赤道上の東西風速. Eastward wind on the equator
   155:               real(DP), save, public:: UGeos
   156:                                           ! $ u_{g} $ .       Eastward geostrophic wind
   157:               real(DP), save, public:: VGeos
   158:                                           ! $ v_{g} $ .       Northward geostrophic wind
   159:             
   160:               ! 非公開変数
   161:               ! Private variables
   162:               !
   163:             
   164:               character(*), parameter:: module_name = 'initial_data'
   165:                                           ! モジュールの名称. 
   166:                                           ! Module name
   167:               character(*), parameter:: version = &
   168:                 & '$Name:  $' // &
   169:                 & '$Id: initial_data.f90,v 1.16 2015/02/17 23:50:42 yot Exp $'
   170:                                           ! モジュールのバージョン
   171:                                           ! Module version
   172:             
   173:             contains
   174:             
   175:               !--------------------------------------------------------------------------------------
   176:             
   177:               subroutine SetInitData( &
   178:                 & xyz_U, xyz_V, xyz_Temp, xyzf_QMix, xy_Ps &   ! (out)
   179:                 & )
   180:                 !
   181:                 ! 初期値データのサンプルを提供します. 
   182:                 ! 
   183:                 ! Prepare sample data of initial data
   184:                 !
   185:             
   186:                 ! モジュール引用 ; USE statements
   187:                 !
   188:             
   189:                 ! 座標データ設定
   190:                 ! Axes data settings
   191:                 !
   192:                 use axesset, only: &
   193:                   & x_Lon, &
   194:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   195:                   & y_Lat, &
   196:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   197:                   & z_Sigma
   198:                                           ! $ \sigma $ レベル (整数). 
   199:                                           ! Full $ \sigma $ level
   200:             
   201:                 ! 文字列操作
   202:                 ! Character handling
   203:                 !
   204:                 use dc_string, only: LChar
   205:             
   206:                 ! ファイルから 1 次元プロファイルを読んで設定する. 
   207:                 ! read 1-D profile from a file and set it 
   208:                 !
   209:                 use set_1d_profile, only : Set1DProfilePs, Set1DProfileAtm
   210:             
   211:                 ! 物理・数学定数設定
   212:                 ! Physical and mathematical constants settings
   213:                 !
   214:                 use constants0, only: &
   215:                   & PI                    ! $ \pi $.
   216:                                           ! 円周率. Circular constant
   217:             
   218:                 ! 組成に関わる配列の設定
   219:                 ! Settings of array for atmospheric composition
   220:                 !
   221:                 use composition, only: &
   222:                   &                    a_QMixName, &
   223:                   &                    CompositionInqIndex
   224:             
   225:                 !
   226:                 ! Utility module for advection test
   227:                 !
   228:                 use adv_test, only: AdvTestSetICs
   229:             
   230:             
   231:                 ! 宣言文 ; Declaration statements
   232:                 !
   233:                 implicit none
   234:                 real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
   235:                                           ! $ u $ .   東西風速. Eastward wind
   236:                 real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
   237:                                           ! $ v $ .   南北風速. Northward wind
   238:                 real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   239:                                           ! $ T $ .   温度. Temperature
   240:                 real(DP), intent(out):: xyzf_QMix  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   241:                                           ! $ q $ .   比湿. Specific humidity
   242:                 real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
   243:                                           ! $ p_s $ . 地表面気圧. Surface pressure
   244:             
   245:                 ! 作業変数
   246:                 ! Work variables
   247:                 !
   248:                 real(DP) :: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   249:             
   250:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   251:                                           ! Work variables for DO loop in longitude
   252:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   253:                                           ! Work variables for DO loop in latitude
   254:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   255:                                           ! Work variables for DO loop in vertical direction
   256:                 integer:: n
   257:             
   258:                 ! 実行文 ; Executable statement
   259:             
   260:                 if ( .not. initial_data_inited ) then
   261:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   262:                 end if
   263:             
   264:             
   265:                 select case ( LChar( trim(Pattern) ) )
   266:                 case ( 'small disturbance of temperature' )
   267:                   !
   268:                   ! 微小な温度擾乱のある静止場
   269:                   ! Stationary field with small disturbance of temperature
   270:                   !
   271:             
   272: **W---->A         xyz_U    = 0.0_DP
   273: |||     A         xyz_V    = 0.0_DP
   274: **W---- A         xyz_Temp = TempAvr
   275: W*===== A         xy_Ps    = PsAvr
   276:                   n = IndexH2OVap
   277: W**==== A         xyzf_QMix(:,:,:,n) = QVapAvr
   278: +------>          do n = 1, ncmax
   279: |                   if ( n /= IndexH2OVap ) then
   280: |W**=== A             xyzf_QMix(:,:,:,n) = 0.0_DP
   281: |                   end if
   282: +------           end do
   283: +------>          do n = 1, ncmax
   284: |                   if ( a_QMixName(n) == 'QAr' ) then
   285: |W**=== A             xyzf_QMix(:,:,:,n) = 0.016_DP * 40.0_DP / 44.0_DP ! Assuming Ar
   286: |                   end if
   287: +------           end do
   288:             !!$      n = CompositionInqIndex( '' )
   289:             !!$      xyzf_QMix(:,:,:,n) = 0.0_DP
   290:             
   291:                   ! 温度に擾乱を与える
   292:                   ! Add perturbation to temperature
   293:                   !
   294: +------>          do k = 1, kmax
   295: |+----->            do j = 1, jmax
   296: ||V---->A             do i = 0, imax - 1
   297: |||     A               xyz_Temp(i,j,k) = &
   298: |||                       &    xyz_Temp(i,j,k) &
   299: |||                       &  + 0.1_DP * sin ( x_Lon(i) * y_Lat(j) ) &
   300: |||                       &  - 0.1_DP * ( 1.0_DP - z_Sigma(k) )
   301: ||V----               end do
   302: |+-----             end do
   303: +------           end do
   304:             
   305:                   ! 東西風速を与える
   306:                   ! Add eastward wind
   307:                   !
   308: +------>          do j = 1, jmax
   309: |+V==== A           xyz_U(:,j,:) = Ueq * cos(y_Lat(j))
   310: +------           end do
   311:             
   312:                 case ( 'agcm 5.3 default' )
   313:                   !
   314:                   ! AGCM5.3 のデフォルト初期値
   315:                   ! AGCM5.3 default initial values
   316:                   !
   317:             
   318: **W---->A         xyz_U    = 0.0_DP
   319: |||     A         xyz_V    = 0.0_DP
   320: **W---- A         xyz_Temp = TempAvr
   321: W*===== A         xy_Ps    = PsAvr
   322:                   n = IndexH2OVap
   323: W**==== A         xyzf_QMix(:,:,:,n) = QVapAvr
   324: +------>          do n = 1, ncmax
   325: |                   if ( n /= IndexH2OVap ) then
   326: |W**=== A             xyzf_QMix(:,:,:,n) = 0.0_DP
   327: |                   end if
   328: +------           end do
   329:             
   330:                   ! 温度に擾乱を与える
   331:                   ! Add perturbation to temperature
   332:                   !
   333: +------>          do k = 1, kmax
   334: |+----->            do j = 1, jmax
   335: ||V---->              do i = 0, imax - 1
   336: |||     A               xyz_Temp(i,j,k) = &
   337: |||                       &    xyz_Temp(i,j,k) &
   338: |||                       &  + 0.1_DP &
   339: |||                       &    * sin ( real( ( i + 1 ) &
   340: |||                       &                  * ( jmax - j + 1 ) &
   341: |||                       &                  * ( kmax - k ), DP ) &
   342: |||                       &            / real( imax &
   343: |||                       &                    * jmax &
   344: |||                       &                    * kmax, DP ) * 10.0_DP &
   345: |||                       &                 )
   346: ||V----               end do
   347: |+-----             end do
   348: +------           end do
   349:             
   350:                   ! 東西風速を与える
   351:                   ! Add eastward wind
   352:                   !
   353: +------>          do j = 1, jmax
   354: |+V==== A           xyz_U(:,j,:) = Ueq * cos(y_Lat(j))
   355: +------           end do
   356:             
   357:                 case ( 'sugiyama et al. (2008)' )
   358:                   !
   359:                   ! Sugiyama et al. (2008) の初期値
   360:                   ! Initial values of Sugiyama et al. (2008)
   361:                   !
   362:                   call Sugiyamaetal2008InitData( &
   363:                     & xyz_U, xyz_V, xyz_Temp, xyzf_QMix(:,:,:,IndexH2OVap), xy_Ps &   ! (out)
   364:                     & )
   365: +------>          do n = 1, ncmax
   366: |                   if ( n /= IndexH2OVap ) then
   367: |W**=== A             xyzf_QMix(:,:,:,n) = 0.0_DP
   368: |                   end if
   369: +------           end do
   370:             
   371:                 case ( 'polvani et al. (2004)' )
   372:                   !
   373:                   ! Polvani et al. (2004) の初期値
   374:                   ! Initial values of Polvani et al. (2004)
   375:                   !
   376:                   n = IndexH2OVap
   377:                   call Polvanietal2004InitData( &
   378:                     & xyz_U, xyz_V, xyz_Temp, xyzf_QMix(:,:,:,n), xy_Ps &   ! (out)
   379:                     & )
   380: +------>          do n = 1, ncmax
   381: |                   if ( n /= IndexH2OVap ) then
   382: |+----->              do j = 1, jmax
   383: ||                      if ( y_Lat(j) * 180.0_DP / PI > 45.0_DP ) then
   384: ||+V=== A                 xyzf_QMix(:,j,:,n) = 0.5_DP
   385: ||                      else
   386: ||+V=== A                 xyzf_QMix(:,j,:,n) = 1.0_DP
   387: ||                      end if
   388: |+-----               end do
   389: |                   end if
   390: +------           end do
   391:             
   392:                 case ( 'venus' )
   393:             
   394:                   call VenusInitData( &
   395:                     & xyz_U, xyz_V, xyz_Temp, xyzf_QMix(:,:,:,n), xy_Ps & ! (out)
   396:                     & )
   397: +------>          do n = 1, ncmax
   398: |                   if ( n /= IndexH2OVap ) then
   399: |W**=== A             xyzf_QMix(:,:,:,n) = 0.0_DP
   400: |                   end if
   401: +------           end do
   402:             
   403:                 case ( '1-d profile' )
   404:             
   405: **W---->A         xyz_U = UGeos
   406: **W---- A         xyz_V = VGeos
   407:             
   408:                   call Set1DProfilePs( &
   409:                     & xy_Ps &
   410:                     & )
   411:             
   412: +------>          do k = 1, kmax
   413: |W*==== A           xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
   414: +------           end do
   415:                   call Set1DProfileAtm(      &
   416:                     & xyz_Press,                   &
   417:                     & xyz_Temp, xyzf_QMix(:,:,:,IndexH2OVap)   &
   418:                     & )
   419: +------>          do n = 1, ncmax
   420: |                   if ( n /= IndexH2OVap ) then
   421: |W**=== A             xyzf_QMix(:,:,:,n) = 0.0_DP
   422: |                   end if
   423: +------           end do
   424:             
   425:                 case ( 'advection test' )
   426:             
   427:             !!$    ! セミラグ移流テスト用初期値作成
   428:             !!$    ! Preparation of initial condition for SLTT advection
   429:             !!$    !
   430:             !!$    use sltt_debug, only : SLTTDebugSetUV, SLTTDebugSetQ
   431:             !!$      call SLTTDebugSetUV( &
   432:             !!$        & Ueq,             & ! (in)
   433:             !!$        & xyz_U, xyz_V     & ! (out)
   434:             !!$        & )
   435:             !!$      xyz_Temp = TempAvr
   436:             !!$      xy_Ps    = PsAvr
   437:             !!$      call SLTTDebugSetQ( &
   438:             !!$        & xyz_QVap        & ! (out)
   439:             !!$        & )
   440:             
   441: W**==== A         xyz_Temp = TempAvr
   442: W*===== A         xy_Ps    = PsAvr
   443:             
   444:                   !
   445:                   ! Utility module for advection test
   446:                   !
   447:                   call AdvTestSetICs(           &
   448:                     & xy_Ps, xyz_Temp,          & ! (in)
   449:                     & xyz_U, xyz_V, xyzf_QMix   & ! (out)
   450:                     & )
   451:             
   452:                 end select
   453:             
   454:               end subroutine SetInitData
   455:             
   456:               !--------------------------------------------------------------------------------------
   457:             
   458:               subroutine Sugiyamaetal2008InitData( &
   459:                 & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
   460:                 & )
   461:                 !
   462:                 ! Sugiyama et al. (2008) の初期値
   463:                 ! Initial values of Sugiyama et al. (2008)
   464:                 !
   465:             
   466:                 ! モジュール引用 ; USE statements
   467:                 !
   468:             
   469:                 ! 座標データ設定
   470:                 ! Axes data settings
   471:                 !
   472:                 use axesset, only: &
   473:                   & x_Lon, &
   474:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   475:                   & y_Lat, &
   476:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   477:                   & z_Sigma
   478:                                           ! $ \sigma $ レベル (整数). 
   479:                                           ! Full $ \sigma $ level
   480:             
   481:                 ! 物理定数設定
   482:                 ! Physical constants settings
   483:                 !
   484:                 use constants, only: &
   485:                   & CpDry, &              ! $ C_p $ [J kg-1 K-1]. 
   486:                                           ! 乾燥大気の定圧比熱. 
   487:                                           ! Specific heat of air at constant pressure
   488:                   & GasRDry               ! $ R $ [J kg-1 K-1]. 
   489:                                           ! 乾燥大気の気体定数. 
   490:                                           ! Gas constant of air
   491:             
   492:                 ! 飽和比湿の算出
   493:                 ! Evaluate saturation specific humidity
   494:                 !
   495:                 use saturate, only: xyz_CalcQVapSat
   496:             
   497:                 ! 文字列操作
   498:                 ! Character handling
   499:                 !
   500:                 use dc_string, only: LChar
   501:             
   502:                 ! 宣言文 ; Declaration statements
   503:                 !
   504:                 implicit none
   505:                 real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
   506:                                           ! $ u $ .   東西風速. Eastward wind
   507:                 real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
   508:                                           ! $ v $ .   南北風速. Northward wind
   509:                 real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   510:                                           ! $ T $ .   温度. Temperature
   511:                 real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
   512:                                           ! $ q $ .   比湿. Specific humidity
   513:                 real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
   514:                                           ! $ p_s $ . 地表面気圧. Surface pressure
   515:             
   516:                 ! Sugiyama et al. (2008) 用作業変数
   517:                 ! Work variables for Sugiyama et al. (2008)
   518:                 !
   519:                 real(DP):: xyz_PotTemp (0:imax-1, 1:jmax, 1:kmax)
   520:                                           ! 温位. Potential temperature
   521:                 real(DP):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   522:                                           ! 気圧. Air pressure
   523:                 real(DP):: xy_TempMin (0:imax-1, 1:jmax)
   524:                                           ! 温度の最小値. Minimum value of temperature
   525:                 real(DP):: xyz_QVapSat (0:imax-1, 1:jmax, 1:kmax)
   526:                                           ! 飽和比湿. Saturation specific humidity
   527:             
   528:                 ! 作業変数
   529:                 ! Work variables
   530:                 !
   531:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   532:                                           ! Work variables for DO loop in longitude
   533:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   534:                                           ! Work variables for DO loop in latitude
   535:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   536:                                           ! Work variables for DO loop in vertical direction
   537:             
   538:                 ! 実行文 ; Executable statement
   539:             
   540:                 if ( .not. initial_data_inited ) then
   541:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   542:                 end if
   543:             
   544:             
   545: **W---->A       xyz_U    = 0.0_DP
   546: |||     A       xyz_V    = 0.0_DP
   547: **W---- A       xyz_Temp = TempAvr
   548: W*===== A       xy_Ps    = PsAvr
   549: **W---->A       xyz_QVap = QVapAvr
   550: |||         
   551: |||             ! 温度の計算
   552: |||             ! Calculate temperature
   553: |||             !
   554: **W----         xyz_PotTemp = TempAvr
   555: W*=====         xy_TempMin  = TempAvr
   556:             
   557: +------>        do k = 1, kmax
   558: |W*==== A         xyz_Temp(:,:,k) = xyz_PotTemp(:,:,k) &
   559: |                   &                  * ( z_Sigma(k) )**( GasRDry / CpDry )
   560: |           
   561: |                 if ( PsAvr * z_Sigma(k) < 1.0e+4_DP ) then
   562: |+V==== A           xyz_Temp(:,:,k) = xy_TempMin
   563: |                 else
   564: |W*==== A           xy_TempMin = xyz_Temp(:,:,k)
   565: |                 end if
   566: +------         end do
   567:             
   568:                 ! 温度に擾乱を与える
   569:                 ! Add perturbation to temperature
   570:                 !
   571: +------>        do k = 1, kmax
   572: |+----->          do j = 1, jmax
   573: ||V---->            do i = 0, imax - 1
   574: |||     A             xyz_Temp(i,j,k) = &
   575: |||                     &    xyz_Temp(i,j,k) &
   576: |||                     &  + 0.1_DP &
   577: |||                     &    * sin ( real( ( i + 1 ) &
   578: |||                     &                  * ( jmax - j + 1 ) &
   579: |||                     &                  * ( kmax - k ), DP ) &
   580: |||                     &            / real( imax &
   581: |||                     &                    * jmax &
   582: |||                     &                    * kmax, DP ) * 10.0_DP &
   583: |||                     &                 )
   584: ||V----             end do
   585: |+-----           end do
   586: +------         end do
   587:             
   588:                 ! 飽和比湿計算
   589:                 ! Calculate saturation specific humidity
   590:                 !
   591: +------>        do k = 1, kmax
   592: |W*==== A         xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
   593: +------         end do
   594:             
   595:                 xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   596:             
   597:                 ! 比湿の計算
   598:                 ! Calculate specific humidity
   599:                 !
   600: **V---->A       where ( xyz_QVap > xyz_QVapSat * 0.75_DP )
   601: **V---- A         xyz_QVap = xyz_QVapSat * 0.75_DP
   602:                 end where
   603:             
   604:             
   605:               end subroutine Sugiyamaetal2008InitData
   606:             
   607:               !--------------------------------------------------------------------------------------
   608:             
   609:               subroutine Polvanietal2004InitData( &
   610:                 & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
   611:                 & )
   612:                 !
   613:                 ! Polvani et al. (2004) の初期値
   614:                 !
   615:                 ! initial data by Polvani et al. (2004)
   616:                 !
   617:             
   618:                 ! モジュール引用 ; USE statements
   619:                 !
   620:             
   621:                 ! MPI 関連ルーチン
   622:                 ! MPI related routines
   623:                 !
   624:                 use mpi_wrapper, only : NProcs
   625:             
   626:                 ! 物理・数学定数設定
   627:                 ! Physical and mathematical constants settings
   628:                 !
   629:                 use constants0, only: &
   630:                   & PI                    ! $ \pi $.
   631:                                           ! 円周率. Circular constant
   632:             
   633:                 ! 物理定数設定
   634:                 ! Physical constants settings
   635:                 !
   636:                 use constants, only: &
   637:                   & RPlanet, &            ! $ a $ [m].
   638:                                           ! 惑星半径.
   639:                                           ! Radius of planet
   640:                   & Omega, &              ! $ \Omega $ [s-1].
   641:                                           ! 回転角速度.
   642:                                           ! Angular velocity
   643:                   & GasRDry               ! $ R $ [J kg-1 K-1]. 
   644:                                           ! 乾燥大気の気体定数. 
   645:                                           ! Gas constant of air
   646:             
   647:                 ! 座標データ設定
   648:                 ! Axes data settings
   649:                 !
   650:                 use axesset, only: &
   651:                   & x_Lon, &
   652:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   653:                   & y_Lat, &
   654:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   655:                   & z_Sigma, &
   656:                                           ! $ \sigma $ レベル (整数). 
   657:                                           ! Full $ \sigma $ level
   658:                   & y_Lat_Weight
   659:                                           ! $ \Delta \varphi $ [rad.] .
   660:                                           ! 緯度座標重み.
   661:                                           ! Weight of latitude
   662:             
   663:                 ! 文字列操作
   664:                 ! Character handling
   665:                 !
   666:                 use dc_string, only: LChar
   667:             
   668:                 ! ガウス重み, 分点の計算
   669:                 ! Calculate Gauss node and Gaussian weight
   670:                 !
   671:                 use gauss_quad, only : GauLeg
   672:             
   673:             
   674:                 ! 宣言文 ; Declaration statements
   675:                 !
   676:                 implicit none
   677:                 real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
   678:                                           ! $ u $ .   東西風速. Eastward wind
   679:                 real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
   680:                                           ! $ v $ .   南北風速. Northward wind
   681:                 real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   682:                                           ! $ T $ .   温度. Temperature
   683:                 real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
   684:                                           ! $ q $ .   比湿. Specific humidity
   685:                 real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
   686:                                           ! $ p_s $ . 地表面気圧. Surface pressure
   687:             
   688:             
   689:                 ! 作業変数
   690:                 ! Work variables
   691:                 !
   692:             
   693:                 ! パラメタ設定
   694:                 ! 
   695:                 !
   696:                 !
   697:                 real(DP), parameter:: dz0 = 5.0e3_DP
   698:                                           ! dz_0 [m].
   699:                 real(DP), parameter:: z0  = 22.0e3_DP
   700:                                           ! z_0 [m]
   701:                 real(DP), parameter:: z1  = 30.0e3_DP
   702:                                           ! z_1 [m]
   703:                 real(DP), parameter:: U0  = 50.0_DP
   704:                                           ! u_0 [m s^-1]
   705:             
   706:                 real(DP), parameter:: ScaleHeight = 7.34e3_DP
   707:                                           ! ScaleHeight [m]
   708:             
   709:                 real(DP):: z_Height (1:kmax)
   710:                                           ! height [m]
   711:                 real(DP):: z_F (1:kmax)
   712:                                           ! function used to calculate zonal wind and temperature
   713:                 real(DP):: z_DFDZ (1:kmax)
   714:                                           ! z derivative of z_F
   715:                 real(DP):: z_TempUSStd(1:kmax)
   716:                                           ! Temperature by US Standard atmosphere [K]
   717:             
   718:             
   719:                 integer, parameter :: NGauQuad = 100
   720:                 real(DP)           :: a_GauQuadLat( 1:NGauQuad )
   721:                 real(DP)           :: a_GauWeight ( 1:NGauQuad )
   722:                 real(DP)           :: az_U        ( 1:NGauQuad, 1:kmax )
   723:                 real(DP)           :: az_DUDZ     ( 1:NGauQuad, 1:kmax )
   724:                 real(DP)           :: az_DTempDPhi( 1:NGauQuad, 1:kmax )
   725:                 real(DP)           :: z_Temp0     (1:kmax)
   726:             
   727:             
   728:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   729:                                           ! Work variables for DO loop in longitude
   730:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   731:                                           ! Work variables for DO loop in latitude
   732:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   733:                                           ! Work variables for DO loop in vertical direction
   734:                 integer:: l               ! 緯度方向に回る DO ループ用作業変数
   735:                                           ! Work variables for DO loop in latitude
   736:             
   737:             
   738:                 ! 実行文 ; Executable statement
   739:             
   740:                 if ( .not. initial_data_inited ) then
   741:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   742:                 end if
   743:             
   744:             
   745:                 if ( NProcs > 1 ) then
   746:                   call MessageNotify( 'E', module_name, &
   747:                     & 'Number of process has to be one, when you use an initial condition for Polvani (2004) experiment.' )
   748:                 end if
   749:             
   750:                 ! 高度の計算
   751:                 ! Calculate height
   752:                 !
   753:             
   754: +------>A       do k = 1, kmax
   755: |V===== A         z_Height = - ScaleHeight * log( z_Sigma )
   756: +------         end do
   757:             
   758: V------>        do k = 1, kmax
   759: |       A         if      ( z_Height(k) * 1.0e-3_DP < 11.0_DP ) then
   760: |       A           z_TempUSStd(k) = 288.15_DP - 6.5_DP * z_Height(k) * 1.0e-3_DP
   761: |                 else if ( z_Height(k) * 1.0e-3_DP < 20.0_DP ) then
   762: |                   z_TempUSStd(k) = 216.65_DP
   763: |                 else if ( z_Height(k) * 1.0e-3_DP < 32.0_DP ) then
   764: |       A           z_TempUSStd(k) = 216.65_DP + 1.0_DP * ( z_Height(k) * 1.0e-3_DP - 20.0_DP )
   765: |                 else if ( z_Height(k) * 1.0e-3_DP < 47.0_DP ) then
   766: |       A           z_TempUSStd(k) = 228.65_DP + 2.8_DP * ( z_Height(k) * 1.0e-3_DP - 32.0_DP )
   767: |                 else if ( z_Height(k) * 1.0e-3_DP < 51.0_DP ) then
   768: |                   z_TempUSStd(k) = 270.65_DP
   769: |                 else if ( z_Height(k) * 1.0e-3_DP < 71.0_DP ) then
   770: |       A           z_TempUSStd(k) = 270.65_DP - 2.8_DP * ( z_Height(k) * 1.0e-3_DP - 51.0_DP )
   771: |                 else if ( z_Height(k) * 1.0e-3_DP < 80.0_DP ) then
   772: |       A           z_TempUSStd(k) = 214.65_DP - 2.0_DP * ( z_Height(k) * 1.0e-3_DP - 71.0_DP )
   773: |                 else
   774: |                   z_TempUSStd(k) = 196.65_DP
   775: |                 end if
   776: V------         end do
   777:             
   778: V------>A       z_F =                                                        &
   779: |                 &   0.5_DP * ( 1.0_DP - tanh( ( z_Height - z0 ) / dz0 )**3 ) &
   780: |                 & * sin( PI * z_Height / z1 )
   781: V------         z_DFDZ =                                                                         &
   782:                   & - 1.5_DP / dz0                                                               &
   783:                   &   * tanh( ( z_Height - z0 ) / dz0 )**2 / cosh( ( z_Height - z0 ) / dz0 )**2  &
   784:                   &   * sin( PI * z_Height / z1 )                                                &
   785:                   & + 0.5_DP                                                                     &
   786:                   &   * ( 1.0_DP - tanh( ( z_Height - z0 ) / dz0 )**3 )                          &
   787:                   &   * PI / z1 * cos( PI * z_Height / z1 )
   788:             
   789:             
   790:             
   791: **W---->A       xyz_U    = 0.0_DP
   792: |||     A       xyz_V    = 0.0_DP
   793: **W---- A       xyz_Temp = 0.0_DP
   794: W*===== A       xy_Ps    = PsAvr
   795: W**==== A       xyz_QVap = QVapAvr
   796:             
   797:             
   798:                 ! 東西風速の計算
   799:                 ! Calculate eastward wind
   800:                 !
   801: +------>        do k = 1, kmax
   802: |+----->          do j = 1, jmax
   803: ||                  if ( y_Lat(j) > 0.0_DP ) then
   804: ||V==== A             xyz_U(:,j,k) = U0 * sin( PI * sin( y_Lat(j) )**2 )**3 * z_F(k)
   805: ||                  else
   806: ||V==== A             xyz_U(:,j,k) =0.0_DP
   807: ||                  end if
   808: |+-----           end do
   809: +------         end do
   810:             
   811:             
   812:                 ! 温度の計算
   813:                 ! Calculate temperature
   814:                 !
   815: +------>        do j = 1, jmax
   816: |           
   817: |                 call GauLeg( -PI/2.0_DP, y_Lat(j), NGauQuad, a_GauQuadLat, a_GauWeight )
   818: |           
   819: |+----->          do k = 1, kmax
   820: ||V---->            do l = 1, NGauQuad
   821: |||     A             if ( a_GauQuadLat(l) > 0.0_DP ) then
   822: |||     A               az_U   (l,k) = U0 * sin( PI * sin( a_GauQuadLat(l) )**2 )**3 * z_F(k)
   823: |||                     az_DUDZ(l,k) = U0 * sin( PI * sin( a_GauQuadLat(l) )**2 )**3 * z_DFDZ(k)
   824: |||                   else
   825: |||                     az_U   (l,k) =0.0_DP
   826: |||                     az_DUDZ(l,k) =0.0_DP
   827: |||                   end if
   828: |||                 end do
   829: |||               end do
   830: |||         
   831: |||               do k = 1, kmax
   832: |||                 do l = 1, NGauQuad
   833: |||                   if ( a_GauQuadLat(l) > 0.0_DP ) then
   834: |||                     az_DTempDPhi(l,k) = - ScaleHeight / GasRDry                  &
   835: |||                       & * (  2.0_DP * RPlanet * Omega * sin( a_GauQuadLat(l) )   &
   836: |||                       &    + 2.0_DP * az_U(l,k) * tan( a_GauQuadLat(l) ) )       &
   837: |||                       & * az_DUDZ(l,k)
   838: |||                   else
   839: |||                     az_DTempDPhi(l,k) = 0.0_DP
   840: |||                   end if
   841: ||V----             end do
   842: |+-----           end do
   843: |           
   844: |+----->          do k = 1, kmax
   845: ||V==== A           xyz_Temp(:,j,k) = 0.0_DP
   846: |+-----           end do
   847: |+----->          do k = 1, kmax
   848: ||+---->            do l = 1, NGauQuad
   849: |||V=== A             xyz_Temp(:,j,k) = xyz_Temp(:,j,k) + az_DTempDPhi(l,k) * a_GauWeight(l)
   850: ||+----             end do
   851: |+-----           end do
   852: |           
   853: +------         end do
   854:             
   855:                 !  Calculate T0
   856:                 !
   857: +------>        do k = 1, kmax
   858: |                 z_Temp0(k) = 0.0_DP
   859: |V----->A         do j = 1, jmax
   860: ||      A           z_Temp0(k) = z_Temp0(k) + xyz_Temp(0,j,k) * y_Lat_weight(j)
   861: |V-----           end do
   862: +------         end do
   863: V======         z_Temp0 = z_Temp0 / 2.0_DP
   864:                 !
   865:                 !  add T0
   866:                 !
   867: +------>        do k = 1, kmax
   868: |W*==== A         xyz_Temp(:,:,k) = xyz_Temp(:,:,k) - z_Temp0(k) + z_TempUSStd(k)
   869: +------         end do
   870:             
   871:             
   872:                 ! Code for debug
   873:             !!$    do k = 1, kmax
   874:             !!$      z_Temp0(k) = 0.0_DP
   875:             !!$      do j = 1, jmax
   876:             !!$        z_Temp0(k) = z_Temp0(k) + xyz_Temp(0,j,k) * y_Lat_weight(j)
   877:             !!$      end do
   878:             !!$    end do
   879:             !!$    z_Temp0 = z_Temp0 / 2.0_DP
   880:             !!$    do k = 1, kmax
   881:             !!$      write( 6, * ) k, z_Temp0(k), z_TempUSStd(k), z_Temp0(k)-z_TempUSStd(k)
   882:             !!$    end do
   883:             !!$    stop
   884:             
   885:             
   886:             
   887:                 ! 温度に擾乱を与える
   888:                 ! Add perturbation to temperature
   889:                 !
   890: +------>        do k = 1, kmax
   891: |+----->          do j = 1, jmax
   892: ||V---->            do i = 0, imax-1
   893: |||     A             if ( ( x_Lon(i) >= 0 ) .and. ( x_Lon(i) < PI ) ) then
   894: |||     A               xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                             &
   895: |||                       & + 1.0_DP / cosh( 3.0_DP * ( x_Lon(i)               ) )**2 &
   896: |||                       & * 1.0_DP / cosh( 6.0_DP * ( y_Lat(j) - PI / 4.0_DP ) )**2
   897: |||                   else if ( ( x_Lon(i) >= PI ) .and. ( x_Lon(i) < 2.0_DP * PI ) ) then
   898: |||     A               xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                             &
   899: |||                       & + 1.0_DP / cosh( 3.0_DP * ( x_Lon(i) - 2.0_DP * PI ) )**2 &
   900: |||                       & * 1.0_DP / cosh( 6.0_DP * ( y_Lat(j) - PI / 4.0_DP ) )**2
   901: |||                   end if
   902: ||V----             end do
   903: |+-----           end do
   904: +------         end do
   905:             
   906:             
   907:               end subroutine Polvanietal2004InitData
   908:             
   909:               !--------------------------------------------------------------------------------------
   910:             
   911:               subroutine VenusInitData( &
   912:                 & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps & ! (out)
   913:                 & )
   914:             
   915:                 ! 種別型パラメタ
   916:                 ! Kind type parameter
   917:                 !
   918:                 use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   919:                   &                 STRING     ! 文字列.       Strings.
   920:             
   921:             
   922:                 ! 格子点設定
   923:                 ! Grid points settings
   924:                 !
   925:                 use gridset, only: imax, & ! 経度格子点数.
   926:                                            ! Number of grid points in longitude
   927:                   &                jmax, & ! 緯度格子点数.
   928:                                            ! Number of grid points in latitude
   929:                   &                kmax    ! 鉛直層数.
   930:                                            ! Number of vertical level
   931:             
   932:                 ! 物理定数設定
   933:                 ! Physical constants settings
   934:                 !
   935:                 use constants, only: &
   936:                   & Grav, &               ! $ g $ [m s-2].
   937:                                           ! 重力加速度.
   938:                                           ! Gravitational acceleration
   939:                   & CpDry, &
   940:                                           ! $ C_p $ [J kg-1 K-1].
   941:                                           ! 乾燥大気の定圧比熱.
   942:                                           ! Specific heat of air at constant pressure
   943:                   & GasRDry               ! $ R $ [J kg-1 K-1]. 
   944:                                           ! 乾燥大気の気体定数. 
   945:                                           ! Gas constant of air
   946:             
   947:                 use axesset, only: &
   948:                   & y_Lat, &              ! $ \varphi $ [rad.] . 緯度. Latitude
   949:                   & z_Sigma, &            ! $ \sigma $ レベル (整数).
   950:                                           ! Full $ \sigma $ level
   951:                   & r_Sigma, &            ! $ \sigma $ レベル (半整数).
   952:                                           ! Half $ \sigma $ level
   953:                   & r_DelSigma            ! $ \Delta \sigma $ (半整数).
   954:                                           ! $ \Delta \sigma $ (half)
   955:             
   956:                 real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
   957:                                           ! $ u $ .   東西風速. Eastward wind
   958:                 real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
   959:                                           ! $ v $ .   南北風速. Northward wind
   960:                 real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   961:                                           ! $ T $ .   温度. Temperature
   962:                 real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
   963:                                           ! $ q $ .   比湿. Specific humidity
   964:                 real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
   965:                                           ! $ p_s $ . 地表面気圧. Surface pressure
   966:             
   967:             
   968:                 !
   969:                 ! local variables
   970:                 !
   971:                 real(DP) :: SurfTemp
   972:                 real(DP) :: xyr_Temp     (0:imax-1,1:jmax,0:kmax)
   973:                 real(DP) :: xy_SurfHeight(0:imax-1,1:jmax)
   974:                 real(DP) :: xyz_Height   (0:imax-1,1:jmax,1:kmax)
   975:                 real(DP) :: z( 5 ), a( 6 ), ah( 5 ), d( 5 )
   976:                 integer  :: j
   977:                 integer  :: k
   978:                 integer  :: l
   979:                 integer  :: m
   980:             
   981:             
   982:                 ! Coefficients for thermal structure by Hou and Farrel (1987)
   983:                 !
   984:                 z ( 1 ) =   0.0e3_DP
   985:                 z ( 2 ) =  10.0e3_DP
   986:                 z ( 3 ) =  25.0e3_DP
   987:                 z ( 4 ) =  55.0e3_DP
   988:                 z ( 5 ) = 100.0e3_DP
   989:             
   990:                 ah( 1 ) =  -1.0e-3_DP
   991:                 ah( 2 ) =  -1.0e-3_DP
   992:                 ah( 3 ) =  -3.1e-3_DP
   993:                 ah( 4 ) =  -6.75e-3_DP
   994:                 ah( 5 ) =  10.0e-3_DP
   995:             
   996:                 d ( 1 ) =  10.0e3_DP
   997:                 d ( 2 ) =  10.0e3_DP
   998:                 d ( 3 ) =   8.0e3_DP
   999:                 d ( 4 ) =   5.0e3_DP
  1000:                 d ( 5 ) =  70.0e3_DP
  1001:             
  1002:             
  1003:                 a ( 1 ) =   0.0_DP
  1004: *------>        do l = 2, 6
  1005: |                 a( l ) = 2.0_DP * ah( l-1 ) * d( l-1 ) + a( l-1 )
  1006: *------         end do
  1007:             
  1008:             
  1009:                 SurfTemp      = 750.0_DP
  1010: W*=====         xy_SurfHeight =   0.0_DP
  1011:             
  1012:             
  1013:                 ! Initialization
  1014: W**==== A       xyz_Temp = 200.0_DP
  1015:             
  1016:                 ! Iteration
  1017: +------>        do m = 1, 10
  1018: |           
  1019: |W*==== A         xyr_Temp(:,:,0) = xyz_Temp(:,:,1)
  1020: |W----->          do k = 1, kmax-1
  1021: ||**=== A           xyr_Temp(:,:,k) = ( xyz_Temp(:,:,k) + xyz_Temp(:,:,k+1) ) / 2.0_DP
  1022: |W-----           end do
  1023: |*W---->A         xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax)
  1024: |||         
  1025: |||         
  1026: |*W---- A         xyz_Height(:,:,1) = &
  1027: |                   &   xy_SurfHeight &
  1028: |                   & + GasRDry / Grav * xyz_Temp(:,:,1) * ( 1. - z_Sigma(1) )
  1029: |+----->          do k = 2, kmax
  1030: ||W*=== A           xyz_Height(:,:,k) = &
  1031: ||                    &   xyz_Height(:,:,k-1) &
  1032: ||                    & + GasRDry / Grav * xyr_Temp(:,:,k-1) &
  1033: ||                    &   * r_DelSigma(k-1) / r_Sigma(k-1)
  1034: |+-----           end do
  1035: |           
  1036: |W**=== A         xyz_Temp = SurfTemp - Grav / CpDry * xyz_Height
  1037: |+----->          do l = 1, 5
  1038: ||**W-->A           xyz_Temp = xyz_Temp &
  1039: |||||                 & - ( a(l+1) - a(l) ) * 0.5_DP &
  1040: |||||                 &   * ( 1.0_DP + tanh( ( 0.0_DP      - z(l) ) / d(l) ) )
  1041: ||**W-- A           xyz_Temp = xyz_Temp &
  1042: ||                    & + ( a(l+1) - a(l) ) * 0.5_DP &
  1043: ||                    &   * ( 1.0_DP + tanh( ( xyz_Height - z(l) ) / d(l) ) )
  1044: |+-----           end do
  1045: |           
  1046: +------         end do
  1047:             
  1048:                 ! add perturbation
  1049:                 xyz_Temp(0,1,1) = xyz_Temp(0,1,1) + 1.0_DP
  1050:             
  1051:             
  1052: +------>        do k = 1, kmax
  1053: |+----->          do j = 1, jmax
  1054: ||V==== A           xyz_U(:,j,k) = Ueq * cos(y_Lat(j))
  1055: |+-----           end do
  1056: +------         end do
  1057: **W---->A       xyz_V    = 0.0_DP
  1058: **W---- A       xyz_QVap = QVapAvr
  1059: W*===== A       xy_Ps    = PsAvr
  1060:             
  1061:             
  1062:               end subroutine VenusInitData
  1063:             
  1064:               !--------------------------------------------------------------------------------------
  1065:             
  1066:               subroutine InitDataInit
  1067:             
  1068:                 ! モジュール引用 ; USE statements
  1069:                 !
  1070:             
  1071:                 ! NAMELIST ファイル入力に関するユーティリティ
  1072:                 ! Utilities for NAMELIST file input
  1073:                 !
  1074:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1075:             
  1076:                 ! ファイル入出力補助
  1077:                 ! File I/O support
  1078:                 !
  1079:                 use dc_iounit, only: FileOpen
  1080:             
  1081:                 ! 文字列操作
  1082:                 ! Character handling
  1083:                 !
  1084:                 use dc_string, only: LChar
  1085:             
  1086:                 ! 飽和比湿の算出
  1087:                 ! Evaluate saturation specific humidity
  1088:                 !
  1089:                 use saturate, only: SaturateInit
  1090:             
  1091:                 ! ファイルから 1 次元プロファイルを読んで設定する.
  1092:                 ! read 1-D profile from a file and set it
  1093:                 !
  1094:                 use set_1d_profile, only : Set1DProfileInit
  1095:             
  1096:                 !
  1097:                 ! Utility module for advection test
  1098:                 !
  1099:                 use adv_test, only: AdvTestInit
  1100:             
  1101:             
  1102:                 ! 宣言文 ; Declaration statements
  1103:                 !
  1104:                 implicit none
  1105:             
  1106:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1107:                                           ! Unit number for NAMELIST file open
  1108:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1109:                                           ! IOSTAT of NAMELIST read
  1110:             
  1111:                 ! NAMELIST 変数群
  1112:                 ! NAMELIST group name
  1113:                 !
  1114:                 namelist /initial_data_nml/ Pattern, &
  1115:                   & TempAvr, PsAvr, QVapAvr, Ueq, UGeos, VGeos
  1116:                       !
  1117:                       ! デフォルト値については初期化手続 "initial_data#InitDataInit" 
  1118:                       ! のソースコードを参照のこと. 
  1119:                       !
  1120:                       ! Refer to source codes in the initialization procedure
  1121:                       ! "initial_data#InitDataInit" for the default values. 
  1122:                       !
  1123:             
  1124:             
  1125:                 ! 実行文 ; Executable statement
  1126:             
  1127:                 if ( initial_data_inited ) return
  1128:             
  1129:             
  1130:                 ! デフォルト値の設定 (まずは Pattern のみ)
  1131:                 ! Default values settings (At first, "Pattern" only)
  1132:                 !
  1133:                 Pattern = 'Small Disturbance of Temperature'
  1134:                 !Pattern = 'AGCM 5.3 Default'
  1135:             
  1136:                 ! NAMELIST の読み込み (まずは Pattern のみ)
  1137:                 ! NAMELIST is input (At first, "Pattern" only)
  1138:                 !
  1139:                 if ( trim(namelist_filename) /= '' ) then
  1140:                   call FileOpen( unit_nml, &          ! (out)
  1141:                     & namelist_filename, mode = 'r' ) ! (in)
  1142:             
  1143:                   rewind( unit_nml )
  1144:                   read( unit_nml, &             ! (in)
  1145:                     & nml = initial_data_nml, & ! (out)
  1146:                     & iostat = iostat_nml )     ! (out)
  1147:                   close( unit_nml )
  1148:             
  1149:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1150:                 end if
  1151:             
  1152:                 ! デフォルト値の設定
  1153:                 ! Default values settings
  1154:                 !
  1155:                 select case ( LChar( trim(Pattern) ) )
  1156:                 case ( 'small disturbance of temperature' )
  1157:                   TempAvr = 250.0_DP
  1158:                   PsAvr   = 1.0e+5_DP
  1159:             !!$      QVapAvr = 1.0e-10_DP
  1160:                   QVapAvr = 0.0e0_DP
  1161:                   Ueq     = 0.0_DP
  1162:                   UGeos   = 0.0_DP
  1163:                   VGeos   = 0.0_DP
  1164:                 case ( 'agcm 5.3 default' )
  1165:                   TempAvr = 250.0_DP
  1166:                   PsAvr   = 1.0e+5_DP
  1167:                   QVapAvr = 1.0e-10_DP
  1168:                   Ueq     = 0.0_DP
  1169:                   UGeos   = 0.0_DP
  1170:                   VGeos   = 0.0_DP
  1171:                 case ( 'sugiyama et al. (2008)' )
  1172:                   TempAvr = 490.0_DP
  1173:                   PsAvr   = 3.0e+6_DP
  1174:                   QVapAvr = 6.11641e-3_DP
  1175:                   Ueq     = 0.0_DP
  1176:                   UGeos   = 0.0_DP
  1177:                   VGeos   = 0.0_DP
  1178:                 case ( 'polvani et al. (2004)' )
  1179:                   TempAvr = 0.0_DP
  1180:                   PsAvr   = 1.0e+5_DP
  1181:                   QVapAvr = 0.0_DP
  1182:                   Ueq     = 0.0_DP
  1183:                   UGeos   = 0.0_DP
  1184:                   VGeos   = 0.0_DP
  1185:                 case ( 'venus' )
  1186:                   TempAvr = 0.0_DP
  1187:                   PsAvr   = 90.0e+5_DP
  1188:                   QVapAvr = 0.0_DP
  1189:                   Ueq     = 0.0_DP
  1190:                   UGeos   = 0.0_DP
  1191:                   VGeos   = 0.0_DP
  1192:                 case ( '1-d profile' )
  1193:                   TempAvr = 1.0e+100_DP
  1194:                   PsAvr   = 1.0e+100_DP
  1195:                   QVapAvr = 0.0_DP
  1196:                   Ueq     = 0.0_DP
  1197:                   UGeos   = 0.0_DP
  1198:                   VGeos   = 0.0_DP
  1199:                 case ( 'advection test' )
  1200:                   TempAvr = 300.0_DP
  1201:                   PsAvr   =   1.0e+5_DP
  1202:                   QVapAvr =   0.0e0_DP
  1203:                   Ueq     =   0.0_DP
  1204:                   UGeos   =   0.0_DP
  1205:                   VGeos   =   0.0_DP
  1206:                 case default
  1207:                   call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
  1208:                     & c1 = trim(Pattern) )
  1209:                 end select
  1210:             
  1211:                 ! NAMELIST の読み込み
  1212:                 ! NAMELIST is input
  1213:                 !
  1214:                 if ( trim(namelist_filename) /= '' ) then
  1215:                   call FileOpen( unit_nml, &          ! (out)
  1216:                     & namelist_filename, mode = 'r' ) ! (in)
  1217:             
  1218:                   rewind( unit_nml )
  1219:                   read( unit_nml, &             ! (in)
  1220:                     & nml = initial_data_nml, & ! (out)
  1221:                     & iostat = iostat_nml )     ! (out)
  1222:                   close( unit_nml )
  1223:             
  1224:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1225:                 end if
  1226:             
  1227:             
  1228:                 ! Initialization of modules used in this module
  1229:                 !
  1230:                 ! 飽和比湿の算出
  1231:                 ! Evaluate saturation specific humidity
  1232:                 !
  1233:                 call SaturateInit
  1234:             
  1235:                 ! ファイルから 1 次元プロファイルを読んで設定する.
  1236:                 ! read 1-D profile from a file and set it
  1237:                 !
  1238:                 call Set1DProfileInit
  1239:             
  1240:                 !
  1241:                 ! Utility module for advection test
  1242:                 !
  1243:                 call AdvTestInit
  1244:             
  1245:             
  1246:                 ! 印字 ; Print
  1247:                 !
  1248:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1249:                 call MessageNotify( 'M', module_name, '  Pattern = %c', c1 = trim(Pattern) )
  1250:                 call MessageNotify( 'M', module_name, '  TempAvr = %f', d = (/ TempAvr  /) )
  1251:                 call MessageNotify( 'M', module_name, '  PsAvr   = %f', d = (/ PsAvr  /) )
  1252:                 call MessageNotify( 'M', module_name, '  QVapAvr = %f', d = (/ QVapAvr  /) )
  1253:                 call MessageNotify( 'M', module_name, '  Ueq     = %f', d = (/ Ueq  /) )
  1254:                 call MessageNotify( 'M', module_name, '  UGeos   = %f', d = (/ UGeos /) )
  1255:                 call MessageNotify( 'M', module_name, '  VGeos   = %f', d = (/ VGeos /) )
  1256:                 call MessageNotify( 'M', module_name, '' )
  1257:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1258:             
  1259:                 initial_data_inited = .true.
  1260:             
  1261:               end subroutine InitDataInit
  1262:             
  1263:               !--------------------------------------------------------------------------------------
  1264:             
  1265:             end module initial_data
