Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:30 2016
FILE NAME: initial_surface_data.f90
PROGRAM NAME: initial_surface_data
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   180  opt  (1593): Loop nest collapsed into one loop.
   180  vec  (   1): Vectorized loop.
   180  vec  (  29): ADB is used for array.: xy_surfsnow
   180  vec  (  29): ADB is used for array.: xy_soilmoist
   180  vec  (  29): ADB is used for array.: xy_surfmajcompice
   184  opt  (  11): Fused array assignments. :line 184 - 196
   200  opt  (1593): Loop nest collapsed into one loop.
   200  vec  (   4): Vectorized array expression.
   200  vec  (  29): ADB is used for array.: xy_soseaicemass
   203  warn (  82): Name "i" is not used.
   203  warn (  82): Name "k" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:30 2016
FILE NAME: initial_surface_data.f90
PROGRAM NAME: initial_surface_data
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Prepare initial surface data
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: initial_surface_data.f90,v 1.2 2015/01/29 12:05:42 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module initial_surface_data
    13    !
    14    !=
    15    !
    16    != Prepare initial surface data
    17    !
    18    ! 初期値データのサンプルを提供します.
    19    !
    20    ! Prepare sample data of initial surface data (restart data)
    21    !
    22    !== Procedures List
    23    !
    24    ! SetInitSurfaceData :: 初期値データ取得
    25    ! ------------------ :: ------------
    26    ! SetInitSurfaceData :: Get initial surface data
    27    !
    28    !== NAMELIST
    29    !
    30    ! NAMELIST#initial_surface_data_nml
    31    !
    32  
    33    ! モジュール引用 ; USE statements
    34    !
    35  
    36    ! 格子点設定
    37    ! Grid points settings
    38    !
    39    use gridset, only: imax, & ! 経度格子点数.
    40                               ! Number of grid points in longitude
    41      &                jmax, & ! 緯度格子点数.
    42                               ! Number of grid points in latitude
    43      &                kmax    ! 鉛直層数.
    44                               ! Number of vertical level
    45  
    46    ! 種別型パラメタ
    47    ! Kind type parameter
    48    !
    49    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    50      &                 STRING     ! 文字列.       Strings.
    51  
    52    ! 種別型パラメタ
    53    ! Kind type parameter
    54    !
    55    use dc_types, only: DP     ! 倍精度実数型. Double precision.
    56  
    57    ! メッセージ出力
    58    ! Message output
    59    !
    60    use dc_message, only: MessageNotify
    61  
    62    ! 宣言文 ; Declaration statements
    63    !
    64    implicit none
    65    private
    66  
    67    ! 公開手続き
    68    ! Public procedure
    69    !
    70    public:: SetInitSurfaceData
    71    public:: InitSurfaceDataInit
    72  
    73    ! 公開変数
    74    ! Public variables
    75    !
    76    logical, save, public:: initial_surface_data_inited = .false.
    77                                ! 初期設定フラグ.
    78                                ! Initialization flag
    79  
    80    real(DP), save       :: SoilMoist
    81                                ! soil moisture (kg m-2)
    82    real(DP), save       :: SurfSnow
    83                                ! surface snow (kg m-2)
    84    real(DP), save       :: SOSeaIceMass
    85                                ! slab sea ice mass (kg m-2)
    86    real(DP), save       :: SurfMajCompIce
    87                                ! surface major component ice (kg m-2)
    88  
    89    ! 非公開変数
    90    ! Private variables
    91    !
    92  
    93    character(*), parameter:: module_name = 'initial_surface_data'
    94                                ! モジュールの名称.
    95                                ! Module name
    96    character(*), parameter:: version = &
    97      & '$Name:  $' // &
    98      & '$Id: initial_surface_data.f90,v 1.2 2015/01/29 12:05:42 yot Exp $'
    99                                ! モジュールのバージョン
   100                                ! Module version
   101  
   102  contains
   103  
   104    !--------------------------------------------------------------------------------------
   105  
   106    subroutine SetInitSurfaceData(                                    &
   107      & xy_SurfMajCompIce, xy_SoilMoist, xy_SurfSnow, xy_SOSeaIceMass & ! (out)
   108      & )
   109      !
   110      ! 初期値データのサンプルを提供します.
   111      !
   112      ! Prepare sample data of initial data
   113      !
   114  
   115      ! モジュール引用 ; USE statements
   116      !
   117  
   118      ! 物理・数学定数設定
   119      ! Physical and mathematical constants settings
   120      !
   121      use constants0, only: &
   122        & PI                    ! $ \pi $.
   123                                ! 円周率. Circular constant
   124  
   125      ! 座標データ設定
   126      ! Axes data settings
   127      !
   128      use axesset, only: &
   129        & x_Lon, &
   130                                ! $ \lambda $ [rad.] . 経度. Longitude
   131        & y_Lat, &
   132                                ! $ \varphi $ [rad.] . 緯度. Latitude
   133        & z_Sigma
   134                                ! $ \sigma $ レベル (整数).
   135                                ! Full $ \sigma $ level
   136  
   137      ! 文字列操作
   138      ! Character handling
   139      !
   140      use dc_string, only: LChar
   141  
   142      ! ファイルから 1 次元プロファイルを読んで設定する.
   143      ! read 1-D profile from a file and set it
   144      !
   145      use set_1d_profile, only : Set1DProfilePs, Set1DProfileAtm
   146  
   147  
   148      ! 宣言文 ; Declaration statements
   149      !
   150      implicit none
   151  
   152      real(DP), intent(out):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   153                              !
   154                              ! surface major component ice
   155      real(DP), intent(out):: xy_SoilMoist(0:imax-1, 1:jmax)
   156                              !
   157                              ! soil moisture
   158      real(DP), intent(out):: xy_SurfSnow(0:imax-1, 1:jmax)
   159                              !
   160                              ! surface snow amount
   161      real(DP), intent(out):: xy_SOSeaIceMass(0:imax-1, 1:jmax)
   162                              !
   163                              ! slab sea ice mass
   164  
   165      ! 作業変数
   166      ! Work variables
   167      !
   168  
   169      integer:: i               ! 経度方向に回る DO ループ用作業変数
   170                                ! Work variables for DO loop in longitude
   171      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   172                                ! Work variables for DO loop in latitude
   173      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   174                                ! Work variables for DO loop in vertical direction
   175  
   176      ! 実行文 ; Executable statement
   177  
   178      if ( .not. initial_surface_data_inited ) call InitSurfaceDataInit
   179  
   180      do j = 1, jmax
   181  !!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
   182  !!$        xy_SurfMajCompIce(:,j) = 0.0_DP
   183  !!$      else
   184          xy_SurfMajCompIce(:,j) = SurfMajCompIce
   185  !!$      end if
   186          !
   187  !!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
   188  !!$        xy_SoilMoist(:,j) = 0.0_DP
   189  !!$      else
   190          xy_SoilMoist(:,j) = SoilMoist
   191  !!$      end if
   192          !
   193  !!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
   194  !!$        xy_SurfSnow(:,j) = 0.0_DP
   195  !!$      else
   196          xy_SurfSnow(:,j) = SurfSnow
   197  !!$      end if
   198      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xy_surfmajcompice(j-1,1) = surfmajcompice                      
     .           xy_soilmoist(j-1,1) = soilmoist                                
     .           xy_surfsnow(j-1,1) = surfsnow                                  
     .        enddo                                                             
   199  
   200      xy_SOSeaIceMass = SOSeaIceMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t65 = 1, jmax*imax                                             
     .           xy_soseaicemass(t65-1,1) = soseaicemass                        
     .        enddo                                                             
   201  
   202  
   203    end subroutine SetInitSurfaceData
   204  
   205    !--------------------------------------------------------------------------------------
   206  
   207    subroutine InitSurfaceDataInit
   208  
   209      ! モジュール引用 ; USE statements
   210      !
   211  
   212      ! NAMELIST ファイル入力に関するユーティリティ
   213      ! Utilities for NAMELIST file input
   214      !
   215      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   216  
   217      ! ファイル入出力補助
   218      ! File I/O support
   219      !
   220      use dc_iounit, only: FileOpen
   221  
   222      ! 文字列操作
   223      ! Character handling
   224      !
   225      use dc_string, only: LChar
   226  
   227      ! 宣言文 ; Declaration statements
   228      !
   229      implicit none
   230  
   231      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   232                                ! Unit number for NAMELIST file open
   233      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   234                                ! IOSTAT of NAMELIST read
   235  
   236      ! NAMELIST 変数群
   237      ! NAMELIST group name
   238      !
   239      namelist /initial_surface_data_nml/ &
   240        & SoilMoist, SurfSnow, SOSeaIceMass, SurfMajCompIce
   241            !
   242            ! デフォルト値については初期化手続 "initial_surface_data#InitSurfaceDataInit"
   243            ! のソースコードを参照のこと.
   244            !
   245            ! Refer to source codes in the initialization procedure
   246            ! "initial_surface_data#InitSurfaceDataInit" for the default values.
   247            !
   248  
   249  
   250      ! 実行文 ; Executable statement
   251  
   252      if ( initial_surface_data_inited ) return
   253  
   254  
   255      ! デフォルト値の設定
   256      ! Default values settings
   257      !
   258      SoilMoist      = 0.0_DP
   259      SurfSnow       = 0.0_DP
   260      SOSeaIceMass   = 0.0_DP
   261      SurfMajCompIce = 0.0_DP
   262  
   263      ! NAMELIST の読み込み
   264      ! NAMELIST is input
   265      !
   266      if ( trim(namelist_filename) /= '' ) then
   267        call FileOpen( unit_nml, &          ! (out)
   268          & namelist_filename, mode = 'r' ) ! (in)
   269  
   270        rewind( unit_nml )
   271        read( unit_nml, &                     ! (in)
   272          & nml = initial_surface_data_nml, & ! (out)
   273          & iostat = iostat_nml )             ! (out)
   274        close( unit_nml )
   275  
   276        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   277      end if
   278  
   279  
   280      ! 印字 ; Print
   281      !
   282      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   283      call MessageNotify( 'M', module_name, '  SoilMoist      = %f', d = (/ SoilMoist /) )
   284      call MessageNotify( 'M', module_name, '  SurfSnow       = %f', d = (/ SurfSnow /) )
   285      call MessageNotify( 'M', module_name, '  SOSeaIceMass   = %f', d = (/ SOSeaIceMass   /) )
   286      call MessageNotify( 'M', module_name, '  SurfMajCompIce = %f', d = (/ SurfMajCompIce /) )
   287      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   288  
   289      initial_surface_data_inited = .true.
   290  
   291    end subroutine InitSurfaceDataInit
   292  
   293    !--------------------------------------------------------------------------------------
   294  
   295  end module initial_surface_data
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:30 2016
FILE NAME: initial_surface_data.f90
PROGRAM NAME: initial_surface_data
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Prepare initial surface data
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: initial_surface_data.f90,v 1.2 2015/01/29 12:05:42 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module initial_surface_data
    13:               !
    14:               != 
    15:               !
    16:               != Prepare initial surface data
    17:               !
    18:               ! 初期値データのサンプルを提供します. 
    19:               !
    20:               ! Prepare sample data of initial surface data (restart data)
    21:               !
    22:               !== Procedures List
    23:               !
    24:               ! SetInitSurfaceData :: 初期値データ取得
    25:               ! ------------------ :: ------------
    26:               ! SetInitSurfaceData :: Get initial surface data
    27:               !
    28:               !== NAMELIST
    29:               !
    30:               ! NAMELIST#initial_surface_data_nml
    31:               !
    32:             
    33:               ! モジュール引用 ; USE statements
    34:               !
    35:             
    36:               ! 格子点設定
    37:               ! Grid points settings
    38:               !
    39:               use gridset, only: imax, & ! 経度格子点数. 
    40:                                          ! Number of grid points in longitude
    41:                 &                jmax, & ! 緯度格子点数. 
    42:                                          ! Number of grid points in latitude
    43:                 &                kmax    ! 鉛直層数. 
    44:                                          ! Number of vertical level
    45:             
    46:               ! 種別型パラメタ
    47:               ! Kind type parameter
    48:               !
    49:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    50:                 &                 STRING     ! 文字列.       Strings. 
    51:             
    52:               ! 種別型パラメタ
    53:               ! Kind type parameter
    54:               !
    55:               use dc_types, only: DP     ! 倍精度実数型. Double precision. 
    56:             
    57:               ! メッセージ出力
    58:               ! Message output
    59:               !
    60:               use dc_message, only: MessageNotify
    61:             
    62:               ! 宣言文 ; Declaration statements
    63:               !
    64:               implicit none
    65:               private
    66:             
    67:               ! 公開手続き
    68:               ! Public procedure
    69:               !
    70:               public:: SetInitSurfaceData
    71:               public:: InitSurfaceDataInit
    72:             
    73:               ! 公開変数
    74:               ! Public variables
    75:               !
    76:               logical, save, public:: initial_surface_data_inited = .false.
    77:                                           ! 初期設定フラグ. 
    78:                                           ! Initialization flag
    79:             
    80:               real(DP), save       :: SoilMoist
    81:                                           ! soil moisture (kg m-2)
    82:               real(DP), save       :: SurfSnow
    83:                                           ! surface snow (kg m-2)
    84:               real(DP), save       :: SOSeaIceMass
    85:                                           ! slab sea ice mass (kg m-2)
    86:               real(DP), save       :: SurfMajCompIce
    87:                                           ! surface major component ice (kg m-2)
    88:             
    89:               ! 非公開変数
    90:               ! Private variables
    91:               !
    92:             
    93:               character(*), parameter:: module_name = 'initial_surface_data'
    94:                                           ! モジュールの名称. 
    95:                                           ! Module name
    96:               character(*), parameter:: version = &
    97:                 & '$Name:  $' // &
    98:                 & '$Id: initial_surface_data.f90,v 1.2 2015/01/29 12:05:42 yot Exp $'
    99:                                           ! モジュールのバージョン
   100:                                           ! Module version
   101:             
   102:             contains
   103:             
   104:               !--------------------------------------------------------------------------------------
   105:             
   106:               subroutine SetInitSurfaceData(                                    &
   107:                 & xy_SurfMajCompIce, xy_SoilMoist, xy_SurfSnow, xy_SOSeaIceMass & ! (out)
   108:                 & )
   109:                 !
   110:                 ! 初期値データのサンプルを提供します. 
   111:                 ! 
   112:                 ! Prepare sample data of initial data
   113:                 !
   114:             
   115:                 ! モジュール引用 ; USE statements
   116:                 !
   117:             
   118:                 ! 物理・数学定数設定
   119:                 ! Physical and mathematical constants settings
   120:                 !
   121:                 use constants0, only: &
   122:                   & PI                    ! $ \pi $.
   123:                                           ! 円周率. Circular constant
   124:             
   125:                 ! 座標データ設定
   126:                 ! Axes data settings
   127:                 !
   128:                 use axesset, only: &
   129:                   & x_Lon, &
   130:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   131:                   & y_Lat, &
   132:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   133:                   & z_Sigma
   134:                                           ! $ \sigma $ レベル (整数). 
   135:                                           ! Full $ \sigma $ level
   136:             
   137:                 ! 文字列操作
   138:                 ! Character handling
   139:                 !
   140:                 use dc_string, only: LChar
   141:             
   142:                 ! ファイルから 1 次元プロファイルを読んで設定する. 
   143:                 ! read 1-D profile from a file and set it 
   144:                 !
   145:                 use set_1d_profile, only : Set1DProfilePs, Set1DProfileAtm
   146:             
   147:             
   148:                 ! 宣言文 ; Declaration statements
   149:                 !
   150:                 implicit none
   151:             
   152:                 real(DP), intent(out):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   153:                                         ! 
   154:                                         ! surface major component ice
   155:                 real(DP), intent(out):: xy_SoilMoist(0:imax-1, 1:jmax)
   156:                                         ! 
   157:                                         ! soil moisture
   158:                 real(DP), intent(out):: xy_SurfSnow(0:imax-1, 1:jmax)
   159:                                         ! 
   160:                                         ! surface snow amount
   161:                 real(DP), intent(out):: xy_SOSeaIceMass(0:imax-1, 1:jmax)
   162:                                         ! 
   163:                                         ! slab sea ice mass
   164:             
   165:                 ! 作業変数
   166:                 ! Work variables
   167:                 !
   168:             
   169:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   170:                                           ! Work variables for DO loop in longitude
   171:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   172:                                           ! Work variables for DO loop in latitude
   173:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   174:                                           ! Work variables for DO loop in vertical direction
   175:             
   176:                 ! 実行文 ; Executable statement
   177:             
   178:                 if ( .not. initial_surface_data_inited ) call InitSurfaceDataInit
   179:             
   180: W------>        do j = 1, jmax
   181: |           !!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
   182: |           !!$        xy_SurfMajCompIce(:,j) = 0.0_DP
   183: |           !!$      else
   184: |*----->A           xy_SurfMajCompIce(:,j) = SurfMajCompIce
   185: ||          !!$      end if
   186: ||                  !
   187: ||          !!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
   188: ||          !!$        xy_SoilMoist(:,j) = 0.0_DP
   189: ||          !!$      else
   190: ||      A           xy_SoilMoist(:,j) = SoilMoist
   191: ||          !!$      end if
   192: ||                  !
   193: ||          !!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
   194: ||          !!$        xy_SurfSnow(:,j) = 0.0_DP
   195: ||          !!$      else
   196: |*----- A           xy_SurfSnow(:,j) = SurfSnow
   197: |           !!$      end if
   198: W------         end do
   199:             
   200: W*===== A       xy_SOSeaIceMass = SOSeaIceMass
   201:             
   202:             
   203:               end subroutine SetInitSurfaceData
   204:             
   205:               !--------------------------------------------------------------------------------------
   206:             
   207:               subroutine InitSurfaceDataInit
   208:             
   209:                 ! モジュール引用 ; USE statements
   210:                 !
   211:             
   212:                 ! NAMELIST ファイル入力に関するユーティリティ
   213:                 ! Utilities for NAMELIST file input
   214:                 !
   215:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   216:             
   217:                 ! ファイル入出力補助
   218:                 ! File I/O support
   219:                 !
   220:                 use dc_iounit, only: FileOpen
   221:             
   222:                 ! 文字列操作
   223:                 ! Character handling
   224:                 !
   225:                 use dc_string, only: LChar
   226:             
   227:                 ! 宣言文 ; Declaration statements
   228:                 !
   229:                 implicit none
   230:             
   231:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   232:                                           ! Unit number for NAMELIST file open
   233:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   234:                                           ! IOSTAT of NAMELIST read
   235:             
   236:                 ! NAMELIST 変数群
   237:                 ! NAMELIST group name
   238:                 !
   239:                 namelist /initial_surface_data_nml/ &
   240:                   & SoilMoist, SurfSnow, SOSeaIceMass, SurfMajCompIce
   241:                       !
   242:                       ! デフォルト値については初期化手続 "initial_surface_data#InitSurfaceDataInit" 
   243:                       ! のソースコードを参照のこと. 
   244:                       !
   245:                       ! Refer to source codes in the initialization procedure
   246:                       ! "initial_surface_data#InitSurfaceDataInit" for the default values. 
   247:                       !
   248:             
   249:             
   250:                 ! 実行文 ; Executable statement
   251:             
   252:                 if ( initial_surface_data_inited ) return
   253:             
   254:             
   255:                 ! デフォルト値の設定
   256:                 ! Default values settings
   257:                 !
   258:                 SoilMoist      = 0.0_DP
   259:                 SurfSnow       = 0.0_DP
   260:                 SOSeaIceMass   = 0.0_DP
   261:                 SurfMajCompIce = 0.0_DP
   262:             
   263:                 ! NAMELIST の読み込み
   264:                 ! NAMELIST is input
   265:                 !
   266:                 if ( trim(namelist_filename) /= '' ) then
   267:                   call FileOpen( unit_nml, &          ! (out)
   268:                     & namelist_filename, mode = 'r' ) ! (in)
   269:             
   270:                   rewind( unit_nml )
   271:                   read( unit_nml, &                     ! (in)
   272:                     & nml = initial_surface_data_nml, & ! (out)
   273:                     & iostat = iostat_nml )             ! (out)
   274:                   close( unit_nml )
   275:             
   276:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   277:                 end if
   278:             
   279:             
   280:                 ! 印字 ; Print
   281:                 !
   282:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   283:                 call MessageNotify( 'M', module_name, '  SoilMoist      = %f', d = (/ SoilMoist /) )
   284:                 call MessageNotify( 'M', module_name, '  SurfSnow       = %f', d = (/ SurfSnow /) )
   285:                 call MessageNotify( 'M', module_name, '  SOSeaIceMass   = %f', d = (/ SOSeaIceMass   /) )
   286:                 call MessageNotify( 'M', module_name, '  SurfMajCompIce = %f', d = (/ SurfMajCompIce /) )
   287:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   288:             
   289:                 initial_surface_data_inited = .true.
   290:             
   291:               end subroutine InitSurfaceDataInit
   292:             
   293:               !--------------------------------------------------------------------------------------
   294:             
   295:             end module initial_surface_data
