Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: set_1d_profile.f90
PROGRAM NAME: set_1d_profile
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   148  opt  (1084): Branch out of the loop inhibits optimization.
   148  vec  (   4): Vectorized array expression.
   148  vec  (  29): ADB is used for array.: a_inqh2o
   148  vec  (   4): Vectorized array expression.
   148  vec  (  26): Macro operation Search.
   152  vec  (   4): Vectorized array expression.
   152  vec  (  29): ADB is used for array.: a_inlogqh2o
   152  vec  (  29): ADB is used for array.: a_inqh2o
   159  opt  (1593): Loop nest collapsed into one loop.
   159  vec  (   4): Vectorized array expression.
   159  vec  (  29): ADB is used for array.: xyz_qvap
   188  opt  (1593): Loop nest collapsed into one loop.
   188  vec  (   4): Vectorized array expression.
   188  vec  (  29): ADB is used for array.: xy_ps
   214  opt  (1593): Loop nest collapsed into one loop.
   214  vec  (   4): Vectorized array expression.
   214  vec  (  29): ADB is used for array.: xy_surftemp
   244  opt  (1084): Branch out of the loop inhibits optimization.
   244  vec  (   4): Vectorized array expression.
   244  vec  (  29): ADB is used for array.: a_inqo3
   244  vec  (   4): Vectorized array expression.
   244  vec  (  26): Macro operation Search.
   248  vec  (   4): Vectorized array expression.
   248  vec  (  29): ADB is used for array.: a_inlogqo3
   248  vec  (  29): ADB is used for array.: a_inqo3
   256  opt  (1593): Loop nest collapsed into one loop.
   256  vec  (   4): Vectorized array expression.
   256  vec  (  29): ADB is used for array.: xyz_qo3
   327  vec  (   1): Vectorized loop.
   327  vec  (  29): ADB is used for array.: a_press
   328  opt  (1084): Branch out of the loop inhibits optimization.
   328  vec  (  26): Macro operation Search.
   482  vec  (   4): Vectorized array expression.
   482  vec  (  29): ADB is used for array.: a_intemp
   501  vec  (   4): Vectorized array expression.
   501  vec  (  29): ADB is used for array.: a_inqh2o
   520  vec  (   4): Vectorized array expression.
   520  vec  (  29): ADB is used for array.: a_inqo3
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: set_1d_profile.f90
PROGRAM NAME: set_1d_profile
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != ファイルから 1 次元プロファイルを読んで設定する.
     2  !
     3  != read 1-D profile from a file and set it
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: set_1d_profile.f90,v 1.6 2015/01/29 12:05:42 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module set_1d_profile
    13  
    14    !
    15    != ファイルから 1 次元プロファイルを読んで設定する.
    16    !
    17    != read 1-D profile from a file and set it
    18    !
    19    ! <b>Note that Japanese and English are described in parallel.</b>
    20    !
    21  
    22    !== References
    23    !
    24  !!$  !  Chou, M.-D.,
    25  !!$  !    Atmospheric solar heating rate in the water vapor bands,
    26  !!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
    27    !
    28    !== Procedures List
    29    !
    30  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    31  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    32  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    33  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    34  !!$  ! ------------            :: ------------
    35  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    36  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    37  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    38  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    39    !
    40    !== NAMELIST
    41    !
    42    ! NAMELIST#set_1d_profile_nml
    43    !
    44  
    45    ! USE statements
    46    !
    47  
    48    !
    49    ! Kind type parameter
    50    !
    51    use dc_types, only: DP, &      ! Double precision.
    52      &                 STRING, &  ! Strings.
    53      &                 TOKEN      ! Keywords.
    54  
    55    ! メッセージ出力
    56    ! Message output
    57    !
    58    use dc_message, only: MessageNotify
    59  
    60    ! 格子点設定
    61    ! Grid points settings
    62    !
    63    use gridset, only: imax, & ! 経度格子点数.
    64                               ! Number of grid points in longitude
    65      &                jmax, & ! 緯度格子点数.
    66                               ! Number of grid points in latitude
    67      &                kmax    ! 鉛直層数.
    68                               ! Number of vertical level
    69  
    70    implicit none
    71  
    72    private
    73  
    74  
    75    character(len=STRING), save :: InFileName
    76    character(len=STRING), save :: PressName
    77    character(len=STRING), save :: TempName
    78    character(len=STRING), save :: H2OVapName
    79    character(len=STRING), save :: O3Name
    80  
    81    integer              , save :: Inkmax
    82    real(DP), allocatable, save :: a_InPress(:)
    83    real(DP), allocatable, save :: a_InTemp (:)
    84    real(DP), allocatable, save :: a_InQH2O (:)
    85    real(DP), allocatable, save :: a_InQO3  (:)
    86  
    87  
    88    ! 公開変数
    89    ! Public variables
    90    !
    91    logical, save :: set_1d_profile_inited = .false.
    92                                ! 初期設定フラグ.
    93                                ! Initialization flag
    94  
    95    public :: Set1DProfileAtm
    96    public :: Set1DProfilePs
    97    public :: Set1DProfileSurfTemp
    98    public :: Set1DProfileO3
    99    public :: Set1DProfileInit
   100  
   101    character(*), parameter:: module_name = 'set_1d_profile'
   102                                ! モジュールの名称.
   103                                ! Module name
   104    character(*), parameter:: version = &
   105      & '$Name:  $' // &
   106      & '$Id: set_1d_profile.f90,v 1.6 2015/01/29 12:05:42 yot Exp $'
   107                                ! モジュールのバージョン
   108                                ! Module version
   109  
   110  
   111    !--------------------------------------------------------------------------------------
   112  
   113  contains
   114  
   115    !--------------------------------------------------------------------------------------
   116  
   117    subroutine Set1DProfileAtm(      &
   118      & xyz_Press,                   &
   119      & xyz_Temp, xyz_QVap           &
   120      & )
   121  
   122      real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   123      real(DP), intent(out) :: xyz_Temp (0:imax-1,1:jmax,1:kmax)
   124      real(DP), intent(out) :: xyz_QVap (0:imax-1,1:jmax,1:kmax)
   125  
   126  
   127      !
   128      ! local variables
   129      !
   130      real(DP), allocatable :: a_InLogQH2O(:)
   131  
   132  
   133      ! 初期化確認
   134      ! Initialization check
   135      !
   136      if ( .not. set_1d_profile_inited ) then
   137        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   138      end if
   139  
   140  
   141      call Set1DProfileInterpolate(       &
   142        & Inkmax, a_InPress, a_InTemp,    &
   143        & xyz_Press,                      &
   144        & xyz_Temp                        &
   145        & )
   146  
   147  
   148      if ( any( a_InQH2O <= 0.0_DP ) ) then
   149        call MessageNotify( 'E', module_name, 'QH2O contains values <= 0.' )
   150      end if
   151      allocate( a_InLogQH2O( Inkmax ) )
   152      a_InLogQH2O = log( a_InQH2O )
   153  
   154      call Set1DProfileInterpolate(       &
   155        & Inkmax, a_InPress, a_InLogQH2O, &
   156        & xyz_Press,                      &
   157        & xyz_QVap                        &
   158        & )
   159      xyz_QVap(:,:,:) = exp( xyz_QVap(:,:,:) )
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t124 = 1, kmax*jmax*imax                                       
     .           xyz_qvap(t124-1,1,1) = dexp(xyz_qvap(t124-1,1,1))              
     .        enddo                                                             
   160  
   161      deallocate( a_InLogQH2O )
   162  
   163  
   164  
   165    end subroutine Set1DProfileAtm
   166  
   167    !--------------------------------------------------------------------------------------
   168  
   169    subroutine Set1DProfilePs( &
   170      & xy_Ps &
   171      & )
   172  
   173      real(DP), intent(out) :: xy_Ps(0:imax-1,1:jmax)
   174  
   175  
   176      !
   177      ! local variables
   178      !
   179  
   180      ! 初期化確認
   181      ! Initialization check
   182      !
   183      if ( .not. set_1d_profile_inited ) then
   184        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   185      end if
   186  
   187  
   188      xy_Ps = a_InPress(1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t27 = 1, jmax*imax                                             
     .           xy_ps(t27-1,1) = a_inpress(1)                                  
     .        enddo                                                             
   189  
   190  
   191    end subroutine Set1DProfilePs
   192  
   193    !--------------------------------------------------------------------------------------
   194  
   195    subroutine Set1DProfileSurfTemp( &
   196      & xy_SurfTemp &
   197      & )
   198  
   199      real(DP), intent(out) :: xy_SurfTemp(0:imax-1,1:jmax)
   200  
   201  
   202      !
   203      ! local variables
   204      !
   205  
   206      ! 初期化確認
   207      ! Initialization check
   208      !
   209      if ( .not. set_1d_profile_inited ) then
   210        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   211      end if
   212  
   213  
   214      xy_SurfTemp = a_InTemp(1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t27 = 1, jmax*imax                                             
     .           xy_surftemp(t27-1,1) = a_intemp(1)                             
     .        enddo                                                             
   215  
   216  
   217    end subroutine Set1DProfileSurfTemp
   218  
   219    !--------------------------------------------------------------------------------------
   220  
   221    subroutine Set1DProfileO3( &
   222      & xyz_Press,             & ! (in )
   223      & xyz_QO3                & ! (out)
   224      & )
   225  
   226      real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   227      real(DP), intent(out) :: xyz_QO3  (0:imax-1,1:jmax,1:kmax)
   228  
   229  
   230      !
   231      ! local variables
   232      !
   233      real(DP), allocatable :: a_InLogQO3(:)
   234  
   235  
   236      ! 初期化確認
   237      ! Initialization check
   238      !
   239      if ( .not. set_1d_profile_inited ) then
   240        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   241      end if
   242  
   243  
   244      if ( any( a_InQO3 <= 0.0_DP ) ) then
   245        call MessageNotify( 'E', module_name, 'QO3 contains values <= 0.' )
   246      end if
   247      allocate( a_InLogQO3( Inkmax ) )
   248      a_InLogQO3 = log( a_InQO3 )
   249  
   250      call Set1DProfileInterpolate(       &
   251        & Inkmax, a_InPress, a_InLogQO3,  &
   252        & xyz_Press,                      &
   253        & xyz_QO3                         &
   254        & )
   255  
   256      xyz_QO3(:,:,:) = exp( xyz_QO3(:,:,:) )
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t101 = 1, kmax*jmax*imax                                       
     .           xyz_qo3(t101-1,1,1) = dexp(xyz_qo3(t101-1,1,1))                
     .        enddo                                                             
   257  
   258      deallocate( a_InLogQO3 )
   259  
   260  
   261    end subroutine Set1DProfileO3
   262  
   263    !--------------------------------------------------------------------------------------
   264  
   265    subroutine Set1DProfileInterpolate( &
   266      & NLev, a_Press, a_Array,         &
   267      & xyz_Press,                      &
   268      & xyz_Array                       &
   269      & )
   270  
   271      integer , intent(in ) :: NLev
   272      real(DP), intent(in ) :: a_Press  (1:NLev)
   273      real(DP), intent(in ) :: a_Array  (1:NLev)
   274      real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   275      real(DP), intent(out) :: xyz_Array(0:imax-1,1:jmax,1:kmax)
   276  
   277  
   278      !
   279      ! local variables
   280      !
   281      integer :: i
   282      integer :: j
   283      integer :: k
   284      integer :: kk
   285  
   286  
   287      ! 初期化確認
   288      ! Initialization check
   289      !
   290      if ( .not. set_1d_profile_inited ) then
   291        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   292      end if
   293  
   294  
   295      ! Old code to be deleted
   296  
   297  !!$    do k = 1, kmax
   298  !!$      if( xyz_Press(0,1,k) <= a_Press(NLev) ) then
   299  !!$        xyz_Array(0,1,k) = a_Array(NLev)
   300  !!$      else
   301  !!$        search_loop : do kk = 2, Inkmax
   302  !!$          if( a_Press( kk ) < xyz_Press(0,1,k) ) exit search_loop
   303  !!$        end do search_loop
   304  !!$        if( kk > NLev ) &
   305  !!$          stop 'Unexpected error in setting temperature profile'
   306  !!$        xyz_Array(0,1,k) =                                  &
   307  !!$          &   ( a_Array( kk ) - a_Array( kk-1 ) )           &
   308  !!$          & / ( log( a_Press( kk )    / a_Press( kk-1 ) ) ) &
   309  !!$          & * ( log( xyz_Press(0,1,k) / a_Press( kk-1 ) ) ) &
   310  !!$          & + a_Array( kk-1 )
   311  !!$      end if
   312  !!$    end do
   313  !!$
   314  !!$    do k = 1, kmax
   315  !!$      xyz_Array(:,:,k) = xyz_Array(0,1,k)
   316  !!$    end do
   317  
   318  
   319  
   320      do k = 1, kmax
   321        do j = 1, jmax
   322          do i = 0, imax-1
   323  
   324            if( xyz_Press(i,j,k) <= a_Press(NLev) ) then
   325              xyz_Array(i,j,k) = a_Array(NLev)
   326            else
   327              search_loop : do kk = 2, Inkmax
   328                if( a_Press( kk ) < xyz_Press(i,j,k) ) exit search_loop
   329              end do search_loop
   330              if( kk > NLev ) &
   331                stop 'Unexpected error in setting temperature profile'
   332              xyz_Array(i,j,k) =                                  &
   333                &   ( a_Array( kk ) - a_Array( kk-1 ) )           &
   334                & / ( log( a_Press( kk )    / a_Press( kk-1 ) ) ) &
   335                & * ( log( xyz_Press(i,j,k) / a_Press( kk-1 ) ) ) &
   336                & + a_Array( kk-1 )
   337            end if
   338  
   339          end do
   340        end do
   341      end do
   342  
   343  
   344    end subroutine Set1DProfileInterpolate
   345  
   346    !--------------------------------------------------------------------------------------
   347  
   348    subroutine Set1DProfileInit
   349  
   350      ! 文字列操作
   351      ! Character handling
   352      !
   353      use dc_string, only: toChar
   354  
   355      ! ファイル入出力補助
   356      ! File I/O support
   357      !
   358      use dc_iounit, only: FileOpen
   359  
   360      ! gtool データ入力
   361      ! Gtool data input
   362      !
   363      use gtool_history, only: HistoryGet, HistoryGetAttr
   364  
   365      ! NetCDF のラッパープログラム
   366      ! NetCDF wrapper
   367      !
   368      use netcdf_wrapper, only : NWInqDimLen
   369  
   370      ! NAMELIST ファイル入力に関するユーティリティ
   371      ! Utilities for NAMELIST file input
   372      !
   373      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   374  
   375  
   376      ! 宣言文 ; Declaration statements
   377      !
   378      integer :: TimeIndex
   379  
   380      logical :: flag_mpi_init
   381  
   382      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   383                                ! Unit number for NAMELIST file open
   384      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   385                                ! IOSTAT of NAMELIST read
   386  
   387      ! NAMELIST 変数群
   388      ! NAMELIST group name
   389      !
   390      namelist /set_1d_profile_nml/ &
   391        & InFileName,               &
   392        & PressName, TempName, H2OVapName, O3Name, &
   393        & TimeIndex
   394            !
   395            ! デフォルト値については初期化手続 "set_1d_profile#Set1DProfileInit"
   396            ! のソースコードを参照のこと.
   397            !
   398            ! Refer to source codes in the initialization procedure
   399            ! "set_1d_profile#Set1DProfileInit" for the default values.
   400            !
   401  
   402      if ( set_1d_profile_inited ) return
   403  
   404  
   405      ! デフォルト値の設定
   406      ! Default values settings
   407      !
   408  !!$    InFileName = 'data.nc'
   409      InFileName = ''
   410      PressName  = 'plev'
   411      TempName   = 'Temp'
   412      H2OVapName = 'H2OVap'
   413      O3Name     = ''
   414  
   415      TimeIndex  = -1
   416  
   417  
   418      ! NAMELIST の読み込み
   419      ! NAMELIST is input
   420      !
   421      if ( trim(namelist_filename) /= '' ) then
   422        call FileOpen( unit_nml, &          ! (out)
   423          & namelist_filename, mode = 'r' ) ! (in)
   424  
   425        rewind( unit_nml )
   426        read( unit_nml,                     & ! (in)
   427          & nml = set_1d_profile_nml,       & ! (out)
   428          & iostat = iostat_nml )             ! (out)
   429        close( unit_nml )
   430  
   431        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   432      end if
   433  
   434  
   435      if ( InFileName /= '' ) then
   436  
   437        call NWInqDimLen( &
   438          & InFileName,    & ! (in )
   439          & PressName,     & ! (in )
   440          & Inkmax         & ! (out)
   441          & )
   442  
   443        allocate( a_InPress( Inkmax ) )
   444        allocate( a_InTemp ( Inkmax ) )
   445        allocate( a_InQH2O ( Inkmax ) )
   446        allocate( a_InQO3  ( Inkmax ) )
   447  
   448  
   449        flag_mpi_init = .true.
   450  
   451        if ( TimeIndex <= 0 ) then
   452          call HistoryGet(                   &
   453            & InFileName, PressName,         & ! (in)
   454            & a_InPress,                     & ! (out)
   455            & flag_mpi_split = flag_mpi_init & ! (in) optional
   456            & )
   457        else
   458          call HistoryGet(                         &
   459            & InFileName, PressName,               & ! (in)
   460            & a_InPress,                           & ! (out)
   461            & range = 'time=^'//toChar(TimeIndex), & ! (in)
   462            & flag_mpi_split = flag_mpi_init       & ! (in) optional
   463            & )
   464        end if
   465  
   466        if ( TempName /= '' ) then
   467          if ( TimeIndex <= 0 ) then
   468            call HistoryGet(                   &
   469              & InFileName, TempName,          & ! (in)
   470              & a_InTemp,                      & ! (out)
   471              & flag_mpi_split = flag_mpi_init & ! (in) optional
   472              & )
   473          else
   474            call HistoryGet(                         &
   475              & InFileName, TempName,                & ! (in)
   476              & a_InTemp,                            & ! (out)
   477              & range = 'time=^'//toChar(TimeIndex), & ! (in)
   478              & flag_mpi_split = flag_mpi_init       & ! (in) optional
   479              & )
   480          end if
   481        else
   482          a_InTemp = 0.0_DP
   483        end if
   484  
   485        if ( H2OVapName /= '' ) then
   486          if ( TimeIndex <= 0 ) then
   487            call HistoryGet(                   &
   488              & InFileName, H2OVapName,        & ! (in)
   489              & a_InQH2O,                      & ! (out)
   490              & flag_mpi_split = flag_mpi_init & ! (in) optional
   491              & )
   492          else
   493            call HistoryGet(                         &
   494              & InFileName, H2OVapName,              & ! (in)
   495              & a_InQH2O,                            & ! (out)
   496              & range = 'time=^'//toChar(TimeIndex), & ! (in)
   497              & flag_mpi_split = flag_mpi_init       & ! (in) optional
   498              & )
   499          end if
   500        else
   501          a_InQH2O = 0.0_DP
   502        end if
   503  
   504        if ( O3Name /= '' ) then
   505          if ( TimeIndex <= 0 ) then
   506            call HistoryGet(                   &
   507              & InFileName, O3Name,            & ! (in)
   508              & a_InQO3,                       & ! (out)
   509              & flag_mpi_split = flag_mpi_init & ! (in) optional
   510              & )
   511          else
   512            call HistoryGet(                         &
   513              & InFileName, O3Name,                  & ! (in)
   514              & a_InQO3,                             & ! (out)
   515              & range = 'time=^'//toChar(TimeIndex), & ! (in)
   516              & flag_mpi_split = flag_mpi_init       & ! (in) optional
   517              & )
   518          end if
   519        else
   520          a_InQO3 = 0.0_DP
   521        end if
   522  
   523      end if
   524  
   525  
   526      ! 印字 ; Print
   527      !
   528      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   529      call MessageNotify( 'M', module_name, 'InFileName = %c', c1 = trim(InFileName) )
   530      call MessageNotify( 'M', module_name, 'PressName  = %c', c1 = trim(PressName) )
   531      call MessageNotify( 'M', module_name, 'TempName   = %c', c1 = trim(TempName) )
   532      call MessageNotify( 'M', module_name, 'H2OVapName = %c', c1 = trim(H2OVapName) )
   533      call MessageNotify( 'M', module_name, 'O3Name     = %c', c1 = trim(O3Name) )
   534      call MessageNotify( 'M', module_name, 'TimeIndex  = %d', i = (/TimeIndex/) )
   535      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   536  
   537      set_1d_profile_inited = .true.
   538  
   539  
   540    end subroutine Set1DProfileInit
   541  
   542    !--------------------------------------------------------------------------------------
   543  
   544  end module set_1d_profile
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: set_1d_profile.f90
PROGRAM NAME: set_1d_profile
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != ファイルから 1 次元プロファイルを読んで設定する. 
     2:             !
     3:             != read 1-D profile from a file and set it 
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: set_1d_profile.f90,v 1.6 2015/01/29 12:05:42 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module set_1d_profile
    13:             
    14:               !
    15:               != ファイルから 1 次元プロファイルを読んで設定する. 
    16:               !
    17:               != read 1-D profile from a file and set it 
    18:               !
    19:               ! <b>Note that Japanese and English are described in parallel.</b>
    20:               !
    21:             
    22:               !== References
    23:               !
    24:             !!$  !  Chou, M.-D.,
    25:             !!$  !    Atmospheric solar heating rate in the water vapor bands,
    26:             !!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
    27:               !
    28:               !== Procedures List
    29:               !
    30:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    31:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    32:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    33:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    34:             !!$  ! ------------            :: ------------
    35:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    36:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    37:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    38:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    39:               !
    40:               !== NAMELIST
    41:               !
    42:               ! NAMELIST#set_1d_profile_nml
    43:               !
    44:             
    45:               ! USE statements
    46:               !
    47:             
    48:               !
    49:               ! Kind type parameter
    50:               !
    51:               use dc_types, only: DP, &      ! Double precision.
    52:                 &                 STRING, &  ! Strings.
    53:                 &                 TOKEN      ! Keywords.
    54:             
    55:               ! メッセージ出力
    56:               ! Message output
    57:               !
    58:               use dc_message, only: MessageNotify
    59:             
    60:               ! 格子点設定
    61:               ! Grid points settings
    62:               !
    63:               use gridset, only: imax, & ! 経度格子点数.
    64:                                          ! Number of grid points in longitude
    65:                 &                jmax, & ! 緯度格子点数.
    66:                                          ! Number of grid points in latitude
    67:                 &                kmax    ! 鉛直層数.
    68:                                          ! Number of vertical level
    69:             
    70:               implicit none
    71:             
    72:               private
    73:             
    74:             
    75:               character(len=STRING), save :: InFileName
    76:               character(len=STRING), save :: PressName
    77:               character(len=STRING), save :: TempName
    78:               character(len=STRING), save :: H2OVapName
    79:               character(len=STRING), save :: O3Name
    80:             
    81:               integer              , save :: Inkmax
    82:               real(DP), allocatable, save :: a_InPress(:)
    83:               real(DP), allocatable, save :: a_InTemp (:)
    84:               real(DP), allocatable, save :: a_InQH2O (:)
    85:               real(DP), allocatable, save :: a_InQO3  (:)
    86:             
    87:             
    88:               ! 公開変数
    89:               ! Public variables
    90:               !
    91:               logical, save :: set_1d_profile_inited = .false.
    92:                                           ! 初期設定フラグ.
    93:                                           ! Initialization flag
    94:             
    95:               public :: Set1DProfileAtm
    96:               public :: Set1DProfilePs
    97:               public :: Set1DProfileSurfTemp
    98:               public :: Set1DProfileO3
    99:               public :: Set1DProfileInit
   100:             
   101:               character(*), parameter:: module_name = 'set_1d_profile'
   102:                                           ! モジュールの名称.
   103:                                           ! Module name
   104:               character(*), parameter:: version = &
   105:                 & '$Name:  $' // &
   106:                 & '$Id: set_1d_profile.f90,v 1.6 2015/01/29 12:05:42 yot Exp $'
   107:                                           ! モジュールのバージョン
   108:                                           ! Module version
   109:             
   110:             
   111:               !--------------------------------------------------------------------------------------
   112:             
   113:             contains
   114:             
   115:               !--------------------------------------------------------------------------------------
   116:             
   117:               subroutine Set1DProfileAtm(      &
   118:                 & xyz_Press,                   &
   119:                 & xyz_Temp, xyz_QVap           &
   120:                 & )
   121:             
   122:                 real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   123:                 real(DP), intent(out) :: xyz_Temp (0:imax-1,1:jmax,1:kmax)
   124:                 real(DP), intent(out) :: xyz_QVap (0:imax-1,1:jmax,1:kmax)
   125:             
   126:             
   127:                 !
   128:                 ! local variables
   129:                 !
   130:                 real(DP), allocatable :: a_InLogQH2O(:)
   131:             
   132:             
   133:                 ! 初期化確認
   134:                 ! Initialization check
   135:                 !
   136:                 if ( .not. set_1d_profile_inited ) then
   137:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   138:                 end if
   139:             
   140:             
   141:                 call Set1DProfileInterpolate(       &
   142:                   & Inkmax, a_InPress, a_InTemp,    &
   143:                   & xyz_Press,                      &
   144:                   & xyz_Temp                        &
   145:                   & )
   146:             
   147:             
   148: V====== A       if ( any( a_InQH2O <= 0.0_DP ) ) then
   149:                   call MessageNotify( 'E', module_name, 'QH2O contains values <= 0.' )
   150:                 end if
   151:                 allocate( a_InLogQH2O( Inkmax ) )
   152: V====== A       a_InLogQH2O = log( a_InQH2O )
   153:             
   154:                 call Set1DProfileInterpolate(       &
   155:                   & Inkmax, a_InPress, a_InLogQH2O, &
   156:                   & xyz_Press,                      &
   157:                   & xyz_QVap                        &
   158:                   & )
   159: W**==== A       xyz_QVap(:,:,:) = exp( xyz_QVap(:,:,:) )
   160:             
   161:                 deallocate( a_InLogQH2O )
   162:             
   163:             
   164:             
   165:               end subroutine Set1DProfileAtm
   166:             
   167:               !--------------------------------------------------------------------------------------
   168:             
   169:               subroutine Set1DProfilePs( &
   170:                 & xy_Ps &
   171:                 & )
   172:             
   173:                 real(DP), intent(out) :: xy_Ps(0:imax-1,1:jmax)
   174:             
   175:             
   176:                 !
   177:                 ! local variables
   178:                 !
   179:             
   180:                 ! 初期化確認
   181:                 ! Initialization check
   182:                 !
   183:                 if ( .not. set_1d_profile_inited ) then
   184:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   185:                 end if
   186:             
   187:             
   188: W*===== A       xy_Ps = a_InPress(1)
   189:             
   190:             
   191:               end subroutine Set1DProfilePs
   192:             
   193:               !--------------------------------------------------------------------------------------
   194:             
   195:               subroutine Set1DProfileSurfTemp( &
   196:                 & xy_SurfTemp &
   197:                 & )
   198:             
   199:                 real(DP), intent(out) :: xy_SurfTemp(0:imax-1,1:jmax)
   200:             
   201:             
   202:                 !
   203:                 ! local variables
   204:                 !
   205:             
   206:                 ! 初期化確認
   207:                 ! Initialization check
   208:                 !
   209:                 if ( .not. set_1d_profile_inited ) then
   210:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   211:                 end if
   212:             
   213:             
   214: W*===== A       xy_SurfTemp = a_InTemp(1)
   215:             
   216:             
   217:               end subroutine Set1DProfileSurfTemp
   218:             
   219:               !--------------------------------------------------------------------------------------
   220:             
   221:               subroutine Set1DProfileO3( &
   222:                 & xyz_Press,             & ! (in )
   223:                 & xyz_QO3                & ! (out)
   224:                 & )
   225:             
   226:                 real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   227:                 real(DP), intent(out) :: xyz_QO3  (0:imax-1,1:jmax,1:kmax)
   228:             
   229:             
   230:                 !
   231:                 ! local variables
   232:                 !
   233:                 real(DP), allocatable :: a_InLogQO3(:)
   234:             
   235:             
   236:                 ! 初期化確認
   237:                 ! Initialization check
   238:                 !
   239:                 if ( .not. set_1d_profile_inited ) then
   240:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   241:                 end if
   242:             
   243:             
   244: V====== A       if ( any( a_InQO3 <= 0.0_DP ) ) then
   245:                   call MessageNotify( 'E', module_name, 'QO3 contains values <= 0.' )
   246:                 end if
   247:                 allocate( a_InLogQO3( Inkmax ) )
   248: V====== A       a_InLogQO3 = log( a_InQO3 )
   249:             
   250:                 call Set1DProfileInterpolate(       &
   251:                   & Inkmax, a_InPress, a_InLogQO3,  &
   252:                   & xyz_Press,                      &
   253:                   & xyz_QO3                         &
   254:                   & )
   255:             
   256: W**==== A       xyz_QO3(:,:,:) = exp( xyz_QO3(:,:,:) )
   257:             
   258:                 deallocate( a_InLogQO3 )
   259:             
   260:             
   261:               end subroutine Set1DProfileO3
   262:             
   263:               !--------------------------------------------------------------------------------------
   264:             
   265:               subroutine Set1DProfileInterpolate( &
   266:                 & NLev, a_Press, a_Array,         &
   267:                 & xyz_Press,                      &
   268:                 & xyz_Array                       &
   269:                 & )
   270:             
   271:                 integer , intent(in ) :: NLev
   272:                 real(DP), intent(in ) :: a_Press  (1:NLev)
   273:                 real(DP), intent(in ) :: a_Array  (1:NLev)
   274:                 real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
   275:                 real(DP), intent(out) :: xyz_Array(0:imax-1,1:jmax,1:kmax)
   276:             
   277:             
   278:                 !
   279:                 ! local variables
   280:                 !
   281:                 integer :: i
   282:                 integer :: j
   283:                 integer :: k
   284:                 integer :: kk
   285:             
   286:             
   287:                 ! 初期化確認
   288:                 ! Initialization check
   289:                 !
   290:                 if ( .not. set_1d_profile_inited ) then
   291:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   292:                 end if
   293:             
   294:             
   295:                 ! Old code to be deleted
   296:             
   297:             !!$    do k = 1, kmax
   298:             !!$      if( xyz_Press(0,1,k) <= a_Press(NLev) ) then
   299:             !!$        xyz_Array(0,1,k) = a_Array(NLev)
   300:             !!$      else
   301:             !!$        search_loop : do kk = 2, Inkmax
   302:             !!$          if( a_Press( kk ) < xyz_Press(0,1,k) ) exit search_loop
   303:             !!$        end do search_loop
   304:             !!$        if( kk > NLev ) &
   305:             !!$          stop 'Unexpected error in setting temperature profile'
   306:             !!$        xyz_Array(0,1,k) =                                  &
   307:             !!$          &   ( a_Array( kk ) - a_Array( kk-1 ) )           &
   308:             !!$          & / ( log( a_Press( kk )    / a_Press( kk-1 ) ) ) &
   309:             !!$          & * ( log( xyz_Press(0,1,k) / a_Press( kk-1 ) ) ) &
   310:             !!$          & + a_Array( kk-1 )
   311:             !!$      end if
   312:             !!$    end do
   313:             !!$
   314:             !!$    do k = 1, kmax
   315:             !!$      xyz_Array(:,:,k) = xyz_Array(0,1,k)
   316:             !!$    end do
   317:             
   318:             
   319:             
   320: +------>        do k = 1, kmax
   321: |+----->          do j = 1, jmax
   322: ||+---->            do i = 0, imax-1
   323: |||         
   324: |||                   if( xyz_Press(i,j,k) <= a_Press(NLev) ) then
   325: |||                     xyz_Array(i,j,k) = a_Array(NLev)
   326: |||                   else
   327: |||V--->                search_loop : do kk = 2, Inkmax
   328: ||||    A                 if( a_Press( kk ) < xyz_Press(i,j,k) ) exit search_loop
   329: |||V---                 end do search_loop
   330: |||                     if( kk > NLev ) &
   331: |||                       stop 'Unexpected error in setting temperature profile'
   332: |||                     xyz_Array(i,j,k) =                                  &
   333: |||                       &   ( a_Array( kk ) - a_Array( kk-1 ) )           &
   334: |||                       & / ( log( a_Press( kk )    / a_Press( kk-1 ) ) ) &
   335: |||                       & * ( log( xyz_Press(i,j,k) / a_Press( kk-1 ) ) ) &
   336: |||                       & + a_Array( kk-1 )
   337: |||                   end if
   338: |||         
   339: ||+----             end do
   340: |+-----           end do
   341: +------         end do
   342:             
   343:             
   344:               end subroutine Set1DProfileInterpolate
   345:             
   346:               !--------------------------------------------------------------------------------------
   347:             
   348:               subroutine Set1DProfileInit
   349:             
   350:                 ! 文字列操作
   351:                 ! Character handling
   352:                 !
   353:                 use dc_string, only: toChar
   354:             
   355:                 ! ファイル入出力補助
   356:                 ! File I/O support
   357:                 !
   358:                 use dc_iounit, only: FileOpen
   359:             
   360:                 ! gtool データ入力
   361:                 ! Gtool data input
   362:                 !
   363:                 use gtool_history, only: HistoryGet, HistoryGetAttr
   364:             
   365:                 ! NetCDF のラッパープログラム
   366:                 ! NetCDF wrapper
   367:                 !
   368:                 use netcdf_wrapper, only : NWInqDimLen
   369:             
   370:                 ! NAMELIST ファイル入力に関するユーティリティ
   371:                 ! Utilities for NAMELIST file input
   372:                 !
   373:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   374:             
   375:             
   376:                 ! 宣言文 ; Declaration statements
   377:                 !
   378:                 integer :: TimeIndex
   379:             
   380:                 logical :: flag_mpi_init
   381:             
   382:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   383:                                           ! Unit number for NAMELIST file open
   384:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   385:                                           ! IOSTAT of NAMELIST read
   386:             
   387:                 ! NAMELIST 変数群
   388:                 ! NAMELIST group name
   389:                 !
   390:                 namelist /set_1d_profile_nml/ &
   391:                   & InFileName,               &
   392:                   & PressName, TempName, H2OVapName, O3Name, &
   393:                   & TimeIndex
   394:                       !
   395:                       ! デフォルト値については初期化手続 "set_1d_profile#Set1DProfileInit"
   396:                       ! のソースコードを参照のこと.
   397:                       !
   398:                       ! Refer to source codes in the initialization procedure
   399:                       ! "set_1d_profile#Set1DProfileInit" for the default values.
   400:                       !
   401:             
   402:                 if ( set_1d_profile_inited ) return
   403:             
   404:             
   405:                 ! デフォルト値の設定
   406:                 ! Default values settings
   407:                 !
   408:             !!$    InFileName = 'data.nc'
   409:                 InFileName = ''
   410:                 PressName  = 'plev'
   411:                 TempName   = 'Temp'
   412:                 H2OVapName = 'H2OVap'
   413:                 O3Name     = ''
   414:             
   415:                 TimeIndex  = -1
   416:             
   417:             
   418:                 ! NAMELIST の読み込み
   419:                 ! NAMELIST is input
   420:                 !
   421:                 if ( trim(namelist_filename) /= '' ) then
   422:                   call FileOpen( unit_nml, &          ! (out)
   423:                     & namelist_filename, mode = 'r' ) ! (in)
   424:             
   425:                   rewind( unit_nml )
   426:                   read( unit_nml,                     & ! (in)
   427:                     & nml = set_1d_profile_nml,       & ! (out)
   428:                     & iostat = iostat_nml )             ! (out)
   429:                   close( unit_nml )
   430:             
   431:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   432:                 end if
   433:             
   434:             
   435:                 if ( InFileName /= '' ) then
   436:             
   437:                   call NWInqDimLen( &
   438:                     & InFileName,    & ! (in )
   439:                     & PressName,     & ! (in )
   440:                     & Inkmax         & ! (out)
   441:                     & )
   442:             
   443:                   allocate( a_InPress( Inkmax ) )
   444:                   allocate( a_InTemp ( Inkmax ) )
   445:                   allocate( a_InQH2O ( Inkmax ) )
   446:                   allocate( a_InQO3  ( Inkmax ) )
   447:             
   448:             
   449:                   flag_mpi_init = .true.
   450:             
   451:                   if ( TimeIndex <= 0 ) then
   452:                     call HistoryGet(                   &
   453:                       & InFileName, PressName,         & ! (in)
   454:                       & a_InPress,                     & ! (out)
   455:                       & flag_mpi_split = flag_mpi_init & ! (in) optional
   456:                       & )
   457:                   else
   458:                     call HistoryGet(                         &
   459:                       & InFileName, PressName,               & ! (in)
   460:                       & a_InPress,                           & ! (out)
   461:                       & range = 'time=^'//toChar(TimeIndex), & ! (in)
   462:                       & flag_mpi_split = flag_mpi_init       & ! (in) optional
   463:                       & )
   464:                   end if
   465:             
   466:                   if ( TempName /= '' ) then
   467:                     if ( TimeIndex <= 0 ) then
   468:                       call HistoryGet(                   &
   469:                         & InFileName, TempName,          & ! (in)
   470:                         & a_InTemp,                      & ! (out)
   471:                         & flag_mpi_split = flag_mpi_init & ! (in) optional
   472:                         & )
   473:                     else
   474:                       call HistoryGet(                         &
   475:                         & InFileName, TempName,                & ! (in)
   476:                         & a_InTemp,                            & ! (out)
   477:                         & range = 'time=^'//toChar(TimeIndex), & ! (in)
   478:                         & flag_mpi_split = flag_mpi_init       & ! (in) optional
   479:                         & )
   480:                     end if
   481:                   else
   482: V====== A           a_InTemp = 0.0_DP
   483:                   end if
   484:             
   485:                   if ( H2OVapName /= '' ) then
   486:                     if ( TimeIndex <= 0 ) then
   487:                       call HistoryGet(                   &
   488:                         & InFileName, H2OVapName,        & ! (in)
   489:                         & a_InQH2O,                      & ! (out)
   490:                         & flag_mpi_split = flag_mpi_init & ! (in) optional
   491:                         & )
   492:                     else
   493:                       call HistoryGet(                         &
   494:                         & InFileName, H2OVapName,              & ! (in)
   495:                         & a_InQH2O,                            & ! (out)
   496:                         & range = 'time=^'//toChar(TimeIndex), & ! (in)
   497:                         & flag_mpi_split = flag_mpi_init       & ! (in) optional
   498:                         & )
   499:                     end if
   500:                   else
   501: V====== A           a_InQH2O = 0.0_DP
   502:                   end if
   503:             
   504:                   if ( O3Name /= '' ) then
   505:                     if ( TimeIndex <= 0 ) then
   506:                       call HistoryGet(                   &
   507:                         & InFileName, O3Name,            & ! (in)
   508:                         & a_InQO3,                       & ! (out)
   509:                         & flag_mpi_split = flag_mpi_init & ! (in) optional
   510:                         & )
   511:                     else
   512:                       call HistoryGet(                         &
   513:                         & InFileName, O3Name,                  & ! (in)
   514:                         & a_InQO3,                             & ! (out)
   515:                         & range = 'time=^'//toChar(TimeIndex), & ! (in)
   516:                         & flag_mpi_split = flag_mpi_init       & ! (in) optional
   517:                         & )
   518:                     end if
   519:                   else
   520: V====== A           a_InQO3 = 0.0_DP
   521:                   end if
   522:             
   523:                 end if
   524:             
   525:             
   526:                 ! 印字 ; Print
   527:                 !
   528:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   529:                 call MessageNotify( 'M', module_name, 'InFileName = %c', c1 = trim(InFileName) )
   530:                 call MessageNotify( 'M', module_name, 'PressName  = %c', c1 = trim(PressName) )
   531:                 call MessageNotify( 'M', module_name, 'TempName   = %c', c1 = trim(TempName) )
   532:                 call MessageNotify( 'M', module_name, 'H2OVapName = %c', c1 = trim(H2OVapName) )
   533:                 call MessageNotify( 'M', module_name, 'O3Name     = %c', c1 = trim(O3Name) )
   534:                 call MessageNotify( 'M', module_name, 'TimeIndex  = %d', i = (/TimeIndex/) )
   535:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   536:             
   537:                 set_1d_profile_inited = .true.
   538:             
   539:             
   540:               end subroutine Set1DProfileInit
   541:             
   542:               !--------------------------------------------------------------------------------------
   543:             
   544:             end module set_1d_profile
