Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:31 2016
FILE NAME: surface_data.f90
PROGRAM NAME: surface_data
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   258  opt  (1592): Outer loop unrolled inside inner loop.
   258  vec  (   4): Vectorized array expression.
   258  vec  (  29): ADB is used for array.: xy_surftemp
   258  vec  (   4): Vectorized array expression.
   258  vec  (  29): ADB is used for array.: xy_surftemp
   371  opt  (1593): Loop nest collapsed into one loop.
   371  vec  (   4): Vectorized array expression.
   371  vec  (  29): ADB is used for array.: xy_surfalbedo
   372  opt  (1593): Loop nest collapsed into one loop.
   372  vec  (   4): Vectorized array expression.
   372  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   373  opt  (1593): Loop nest collapsed into one loop.
   373  vec  (   4): Vectorized array expression.
   373  vec  (  29): ADB is used for array.: xy_surfroughlength
   374  opt  (1593): Loop nest collapsed into one loop.
   374  vec  (   4): Vectorized array expression.
   374  vec  (  29): ADB is used for array.: xy_surfheatcapacity
   375  opt  (1593): Loop nest collapsed into one loop.
   375  vec  (   4): Vectorized array expression.
   375  vec  (  29): ADB is used for array.: xy_deepsubsurfheatflux
   376  opt  (1593): Loop nest collapsed into one loop.
   376  vec  (   4): Vectorized array expression.
   376  vec  (  29): ADB is used for array.: xy_surftype
   377  opt  (1593): Loop nest collapsed into one loop.
   377  vec  (   4): Vectorized array expression.
   377  vec  (  29): ADB is used for array.: xy_surfcond
   378  opt  (1593): Loop nest collapsed into one loop.
   378  vec  (   4): Vectorized array expression.
   378  vec  (  29): ADB is used for array.: xy_seaiceconc
   379  opt  (1593): Loop nest collapsed into one loop.
   379  vec  (   4): Vectorized array expression.
   379  vec  (  29): ADB is used for array.: xy_soilheatcap
   380  opt  (1593): Loop nest collapsed into one loop.
   380  vec  (   4): Vectorized array expression.
   380  vec  (  29): ADB is used for array.: xy_soilheatdiffcoef
   381  opt  (1593): Loop nest collapsed into one loop.
   381  vec  (   4): Vectorized array expression.
   381  vec  (  29): ADB is used for array.: xy_surfheightstd
   384  warn (  82): Name "j" is not used.
   480  opt  (1592): Outer loop unrolled inside inner loop.
   480  vec  (   3): Unvectorized loop.
   480  vec  (  13): Overhead of loop division is too large.
   480  vec  (   3): Unvectorized loop.
   480  vec  (  13): Overhead of loop division is too large.
   482  vec  (   4): Vectorized array expression.
   482  vec  (  29): ADB is used for array.: d1
   482  vec  (   4): Vectorized array expression.
   482  vec  (  29): ADB is used for array.: xy_surftemp
   482  vec  (  29): ADB is used for array.: d1
   482  vec  (   4): Vectorized array expression.
   482  vec  (  29): ADB is used for array.: xy_surftemp
   482  vec  (  29): ADB is used for array.: d1
   500  vec  (   1): Vectorized loop.
   500  vec  (  29): ADB is used for array.: y_lat
   518  opt  (1593): Loop nest collapsed into one loop.
   518  vec  (   4): Vectorized array expression.
   518  vec  (  29): ADB is used for array.: xy_surftemp
   596  vec  (   3): Unvectorized loop.
   596  vec  (  13): Overhead of loop division is too large.
   598  vec  (   4): Vectorized array expression.
   598  vec  (  29): ADB is used for array.: xy_surftemp
   600  vec  (   4): Vectorized array expression.
   600  vec  (  29): ADB is used for array.: xy_surftemp
   603  opt  (1592): Outer loop unrolled inside inner loop.
   603  vec  (   4): Vectorized array expression.
   603  vec  (  29): ADB is used for array.: xy_surftemp
   603  vec  (   4): Vectorized array expression.
   603  vec  (  29): ADB is used for array.: xy_surftemp
   611  vec  (   3): Unvectorized loop.
   611  vec  (  13): Overhead of loop division is too large.
   613  vec  (   4): Vectorized array expression.
   613  vec  (  29): ADB is used for array.: xy_surftemp
   615  vec  (   4): Vectorized array expression.
   615  vec  (  29): ADB is used for array.: xy_surftemp
   618  opt  (1592): Outer loop unrolled inside inner loop.
   618  vec  (   4): Vectorized array expression.
   618  vec  (  29): ADB is used for array.: xy_surftemp
   618  vec  (   4): Vectorized array expression.
   618  vec  (  29): ADB is used for array.: xy_surftemp
   625  vec  (   3): Unvectorized loop.
   625  vec  (  13): Overhead of loop division is too large.
   627  vec  (   4): Vectorized array expression.
   627  vec  (  29): ADB is used for array.: xy_surftemp
   629  vec  (   4): Vectorized array expression.
   629  vec  (  29): ADB is used for array.: xy_surftemp
   632  opt  (1592): Outer loop unrolled inside inner loop.
   632  vec  (   4): Vectorized array expression.
   632  vec  (  29): ADB is used for array.: xy_surftemp
   632  vec  (   4): Vectorized array expression.
   632  vec  (  29): ADB is used for array.: xy_surftemp
   639  vec  (   3): Unvectorized loop.
   639  vec  (  13): Overhead of loop division is too large.
   641  vec  (   4): Vectorized array expression.
   641  vec  (  29): ADB is used for array.: xy_surftemp
   643  vec  (   4): Vectorized array expression.
   643  vec  (  29): ADB is used for array.: xy_surftemp
   646  vec  (   4): Vectorized array expression.
   646  vec  (  29): ADB is used for array.: xy_surftemp
   649  vec  (   4): Vectorized array expression.
   649  vec  (  29): ADB is used for array.: xy_surftemp
   652  opt  (1592): Outer loop unrolled inside inner loop.
   652  vec  (   4): Vectorized array expression.
   652  vec  (  29): ADB is used for array.: xy_surftemp
   652  vec  (   4): Vectorized array expression.
   652  vec  (  29): ADB is used for array.: xy_surftemp
   667  opt  (1592): Outer loop unrolled inside inner loop.
   667  vec  (   4): Vectorized array expression.
   667  vec  (  29): ADB is used for array.: xy_surftemp
   667  vec  (  29): ADB is used for array.: xy_surftemptmp2
   667  vec  (  29): ADB is used for array.: xy_surftemptmp1
   667  vec  (   4): Vectorized array expression.
   667  vec  (  29): ADB is used for array.: xy_surftemp
   667  vec  (  29): ADB is used for array.: xy_surftemptmp2
   667  vec  (  29): ADB is used for array.: xy_surftemptmp1
   683  opt  (1592): Outer loop unrolled inside inner loop.
   684  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   684  vec  (   1): Vectorized loop.
   684  vec  (  29): ADB is used for array.: xy_surftemp
   684  vec  (  29): ADB is used for array.: x_lon
   684  vec  (   1): Vectorized loop.
   684  vec  (  29): ADB is used for array.: xy_surftemp
   684  vec  (  29): ADB is used for array.: x_lon
   708  opt  (1592): Outer loop unrolled inside inner loop.
   709  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   709  vec  (   1): Vectorized loop.
   709  vec  (  29): ADB is used for array.: xy_surftemp
   709  vec  (  29): ADB is used for array.: x_lon
   709  vec  (   1): Vectorized loop.
   709  vec  (  29): ADB is used for array.: xy_surftemp
   709  vec  (  29): ADB is used for array.: x_lon
   733  vec  (   1): Vectorized loop.
   733  vec  (  29): ADB is used for array.: xy_surftemp
   733  vec  (  29): ADB is used for array.: x_lon
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:31 2016
FILE NAME: surface_data.f90
PROGRAM NAME: surface_data
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地表面データ提供
     2  !
     3  != Prepare surface data
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6  ! Version::   $Id: surface_data.f90,v 1.17 2015/02/14 07:26:43 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module surface_data
    13    !
    14    != 地表面データ提供
    15    !
    16    != Prepare surface data
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! GCM で用いる地表面データを生成します.
    21    ! 現在は暫定的に Hosaka et al. (1998) の SST 分布を与えます.
    22    !
    23    ! Surface data for GCM is generated.
    24    ! Now, SST profile in Hosaka et al. (1998) is provided tentatively.
    25    !
    26    !== Procedures List
    27    !
    28    ! SetSurfData   :: 地表面データの取得
    29    ! ------------  :: ------------
    30    ! SetSurfData   :: Set surface data
    31    !
    32    !== NAMELIST
    33    !
    34    ! NAMELIST#surface_data_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39  
    40    ! 格子点設定
    41    ! Grid points settings
    42    !
    43    use gridset, only: imax, & ! 経度格子点数.
    44                               ! Number of grid points in longitude
    45      &                jmax, & ! 緯度格子点数.
    46                               ! Number of grid points in latitude
    47      &                kmax    ! 鉛直層数.
    48                               ! Number of vertical level
    49  
    50    ! 種別型パラメタ
    51    ! Kind type parameter
    52    !
    53    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    54      &                 STRING     ! 文字列.       Strings.
    55  
    56    ! 種別型パラメタ
    57    ! Kind type parameter
    58    !
    59    use dc_types, only: DP     ! 倍精度実数型. Double precision.
    60  
    61    ! メッセージ出力
    62    ! Message output
    63    !
    64    use dc_message, only: MessageNotify
    65  
    66    ! 宣言文 ; Declaration statements
    67    !
    68    implicit none
    69    private
    70  
    71    ! 公開手続き
    72    ! Public procedure
    73    !
    74    public:: SetSurfData
    75    public:: SurfDataInit
    76  
    77    ! 公開変数
    78    ! Public variables
    79    !
    80    logical, save :: surface_data_inited = .false.
    81                                ! 初期設定フラグ.
    82                                ! Initialization flag
    83  
    84    ! 非公開変数
    85    ! Private variables
    86    !
    87    character(STRING), save:: Pattern
    88                                ! 地表面データのパターン.
    89                                ! 以下のパターンを選択可能.
    90                                !
    91                                ! Surface data pattern.
    92                                ! Available patterns are as follows.
    93                                !
    94                                ! * "Hosaka et al. (1998)"
    95                                ! * "Homogeneous"
    96                                !
    97    real(DP), save:: SurfTemp
    98                                ! 地表面温度の基準値.
    99                                ! Standard value of surface temperature
   100    real(DP), save:: Albedo
   101                                ! 地表アルベド.
   102                                ! Surface albedo
   103    real(DP), save:: HumidCoef
   104                                ! 地表湿潤度.
   105                                ! Surface humidity coefficient
   106    real(DP), save:: RoughLength
   107                                ! 地表粗度長.
   108                                ! Surface rough length
   109    real(DP), save:: HeatCapacity
   110                                ! 地表熱容量.
   111                                ! Surface heat capacity
   112    real(DP), save:: TempFlux
   113                                ! 地中熱フラックス.
   114                                ! Ground temperature flux
   115    integer, save:: SurfType
   116                                ! 土地利用.
   117                                ! Surface index
   118    integer, save:: SurfCond
   119                                ! 地表状態 (0: 固定, 1: 可変).
   120                                ! Surface condition (0: fixed, 1: variable)
   121    real(DP), save:: SeaIceConc
   122                                ! 海氷面密度
   123                                ! Sea ice concentration
   124    real(DP), save:: SoilHeatCap
   125                                ! 土壌熱容量 (J K-1 m-3)
   126                                ! Specific heat of soil (J K-1 m-3)
   127    real(DP), save:: SoilHeatDiffCoef
   128                                ! 土壌熱伝導係数 (W m-1 K-1)
   129                                ! Heat conduction coefficient of soil (W m-1 K-1)
   130    real(DP), save:: SurfHeightStd
   131                                !
   132                                ! Standard deviation of surface height
   133  
   134    character(*), parameter:: module_name = 'surface_data'
   135                                ! モジュールの名称.
   136                                ! Module name
   137    character(*), parameter:: version = &
   138      & '$Name:  $' // &
   139      & '$Id: surface_data.f90,v 1.17 2015/02/14 07:26:43 yot Exp $'
   140                                ! モジュールのバージョン
   141                                ! Module version
   142  
   143  
   144  contains
   145  
   146    !--------------------------------------------------------------------------------------
   147  
   148    subroutine SetSurfData( &
   149      & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoef, & ! (out)
   150      & xy_SurfRoughLength, xy_SurfHeatCapacity,      & ! (out)
   151      & xy_DeepSubSurfHeatFlux,                       & ! (out)
   152      & xy_SurfType, xy_SurfCond,                     & ! (out)
   153      & xy_SeaIceConc,                                & ! (out)
   154      & xy_SoilHeatCap, xy_SoilHeatDiffCoef,          & ! (out)
   155      & xy_SurfHeightStd                              & ! (out)
   156      & )
   157      !
   158      ! GCM 用の地表面データを返します.
   159      !
   160      ! Return surface data for GCM.
   161      !
   162  
   163      ! モジュール引用 ; USE statements
   164      !
   165  
   166      ! 文字列操作
   167      ! Character handling
   168      !
   169      use dc_string, only: LChar
   170  
   171      ! 物理・数学定数設定
   172      ! Physical and mathematical constants settings
   173      !
   174      use constants0, only: &
   175        & PI                    ! $ \pi $.
   176                                ! 円周率. Circular constant
   177  
   178      ! 座標データ設定
   179      ! Axes data settings
   180      !
   181      use axesset, only: &
   182        & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   183  
   184      ! ファイルから 1 次元プロファイルを読んで設定する.
   185      ! read 1-D profile from a file and set it
   186      !
   187      use set_1d_profile, only : Set1DProfileSurfTemp
   188  
   189  
   190      ! 宣言文 ; Declaration statements
   191      !
   192      implicit none
   193      real(DP), intent(out), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
   194                                ! 地表面温度.
   195                                ! Surface temperature
   196      real(DP), intent(out), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
   197                                ! 地表アルベド.
   198                                ! Surface albedo
   199      real(DP), intent(out), optional:: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   200                                ! 地表湿潤度.
   201                                ! Surface humidity coefficient
   202      real(DP), intent(out), optional:: xy_SurfRoughLength (0:imax-1, 1:jmax)
   203                                ! 地表粗度長.
   204                                ! Surface rough length
   205      real(DP), intent(out), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
   206                                ! 地表熱容量.
   207                                ! Surface heat capacity
   208      real(DP), intent(out), optional:: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
   209                                ! 地中熱フラックス.
   210                                ! "Deep subsurface heat flux"
   211                                ! Heat flux at the bottom of surface/soil layer.
   212      integer , intent(out), optional:: xy_SurfType (0:imax-1, 1:jmax)
   213                                ! 土地利用
   214                                ! Surface index
   215      integer , intent(out), optional:: xy_SurfCond (0:imax-1, 1:jmax)
   216                                ! 地表状態 (0: 固定, 1: 可変) .
   217                                ! Surface condition (0: fixed, 1: variable)
   218      real(DP), intent(out), optional:: xy_SeaIceConc(0:imax-1, 1:jmax)
   219                                ! 海氷面密度
   220                                ! Sea ice concentration
   221      real(DP), intent(out), optional:: xy_SoilHeatCap(0:imax-1,1:jmax)
   222                                ! 土壌熱容量 (J K-1 kg-1)
   223                                ! Specific heat of soil (J K-1 kg-1)
   224      real(DP), intent(out), optional:: xy_SoilHeatDiffCoef(0:imax-1,1:jmax)
   225                                ! 土壌熱伝導係数 (J m-3 K-1)
   226                                ! Heat conduction coefficient of soil (J m-3 K-1)
   227      real(DP), intent(out), optional:: xy_SurfHeightStd(0:imax-1, 1:jmax)
   228                                !
   229                                ! Standard deviation of surface height (m)
   230  
   231      ! 作業変数
   232      ! Work variables
   233      !
   234  !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   235  !!$                              ! Work variables for DO loop in longitude
   236      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   237                                ! Work variables for DO loop in latitude
   238  !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   239  !!$                              ! Work variables for DO loop in vertical direction
   240  
   241      ! 実行文 ; Executable statement
   242  
   243  
   244      ! 初期化確認
   245      ! Initialization check
   246      !
   247      if ( .not. surface_data_inited ) then
   248        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   249      end if
   250  
   251  
   252      select case ( LChar( trim(Pattern) ) )
   253  
   254      case ( 'homogeneous' )
   255        ! SST 一様
   256        ! SST is homogeneous
   257        !
   258        if ( present(xy_SurfTemp) ) xy_SurfTemp = SurfTemp
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t320 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t322 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t322-1,t320) = surftemp                      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t320 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t322 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t322-1,t320) = surftemp                      
     .                 xy_surftemp(t322-1,t320+1) = surftemp                    
     .                 xy_surftemp(t322-1,t320+2) = surftemp                    
     .                 xy_surftemp(t322-1,t320+3) = surftemp                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10015                                                        
   259  
   260      case ( 'hosaka et al. (1998)' )
   261        ! Hosaka et al. (1998) において用いられた SST
   262        ! SST used in Hosaka et al. (1998)
   263        !
   264        if ( present( xy_SurfTemp ) ) then
   265          call Hosakaetal98SST( &
   266            & xy_SurfTemp  & ! (out)
   267            & )
   268        end if
   269  
   270      case ( 'nh00_control' )
   271        ! Neale and Hoskins (2000) の control experiment において用いられた SST
   272        ! SST used for Control experiment by Neale and Hoskins (2000)
   273        !
   274        if ( present( xy_SurfTemp ) ) then
   275          call NH00SST( &
   276            & 'control',     & ! (in   )
   277            & xy_SurfTemp  & ! (inout)
   278            & )
   279        end if
   280  
   281      case ( 'nh00_peaked' )
   282        ! Neale and Hoskins (2000) の peaked experiment において用いられた SST
   283        ! SST used for Control experiment by Neale and Hoskins (2000)
   284        !
   285        if ( present( xy_SurfTemp ) ) then
   286          call NH00SST( &
   287            & 'peaked',    & ! (in   )
   288            & xy_SurfTemp  & ! (inout)
   289            & )
   290        end if
   291  
   292      case ( 'nh00_flat' )
   293        ! Neale and Hoskins (2000) の flat experiment において用いられた SST
   294        ! SST used for Control experiment by Neale and Hoskins (2000)
   295        !
   296        if ( present( xy_SurfTemp ) ) then
   297          call NH00SST( &
   298            & 'flat',      & ! (in   )
   299            & xy_SurfTemp  & ! (inout)
   300            & )
   301        end if
   302  
   303      case ( 'nh00_control-5n' )
   304        ! Neale and Hoskins (2000) の control-5n experiment において用いられた SST
   305        ! SST used for Control experiment by Neale and Hoskins (2000)
   306        !
   307        if ( present( xy_SurfTemp ) ) then
   308          call NH00SST( &
   309            & 'control-5n',& ! (in   )
   310            & xy_SurfTemp  & ! (inout)
   311            & )
   312        end if
   313  
   314      case ( 'nh00_qobs' )
   315        ! Neale and Hoskins (2000) の qobs experiment において用いられた SST
   316        ! SST used for Control experiment by Neale and Hoskins (2000)
   317        !
   318        if ( present( xy_SurfTemp ) ) then
   319          call NH00SST( &
   320            & 'qobs',      & ! (in   )
   321            & xy_SurfTemp  & ! (inout)
   322            & )
   323        end if
   324  
   325      case ( 'nh00_1keq' )
   326        ! Neale and Hoskins (2000) の 1keq experiment において用いられた SST
   327        ! SST used for Control experiment by Neale and Hoskins (2000)
   328        !
   329        if ( present( xy_SurfTemp ) ) then
   330          call NH00SST( &
   331            & '1keq',      & ! (in   )
   332            & xy_SurfTemp  & ! (inout)
   333            & )
   334        end if
   335  
   336      case ( 'nh00_3keq' )
   337        ! Neale and Hoskins (2000) の 3keq experiment において用いられた SST
   338        ! SST used for Control experiment by Neale and Hoskins (2000)
   339        !
   340        if ( present( xy_SurfTemp ) ) then
   341          call NH00SST( &
   342            & '3keq',      & ! (in   )
   343            & xy_SurfTemp  & ! (inout)
   344            & )
   345        end if
   346  
   347      case ( 'nh00_3kw1' )
   348        ! Neale and Hoskins (2000) の 3kw1 experiment において用いられた SST
   349        ! SST used for Control experiment by Neale and Hoskins (2000)
   350        !
   351        if ( present( xy_SurfTemp ) ) then
   352          call NH00SST( &
   353            & '3kw1',      & ! (in   )
   354            & xy_SurfTemp  & ! (inout)
   355            & )
   356        end if
   357  
   358      case ( '1-d profile' )
   359  
   360        if ( present( xy_SurfTemp ) ) then
   361          call Set1DProfileSurfTemp( &
   362            & xy_SurfTemp &
   363            & )
   364        end if
   365  
   366      case default
   367        call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
   368          & c1 = trim(Pattern) )
   369      end select
   370  
   371      if ( present(xy_SurfAlbedo          ) ) xy_SurfAlbedo          = Albedo
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t314 = 1, jmax*imax                                            
     .           xy_surfalbedo(t314-1,1) = albedo                               
     .        enddo                                                             
   372      if ( present(xy_SurfHumidCoef       ) ) xy_SurfHumidCoef       = HumidCoef
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t308 = 1, jmax*imax                                            
     .           xy_surfhumidcoef(t308-1,1) = humidcoef                         
     .        enddo                                                             
   373      if ( present(xy_SurfRoughLength     ) ) xy_SurfRoughLength     = RoughLength
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t302 = 1, jmax*imax                                            
     .           xy_surfroughlength(t302-1,1) = roughlength                     
     .        enddo                                                             
   374      if ( present(xy_SurfHeatCapacity    ) ) xy_SurfHeatCapacity    = HeatCapacity
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t296 = 1, jmax*imax                                            
     .           xy_surfheatcapacity(t296-1,1) = heatcapacity                   
     .        enddo                                                             
   375      if ( present(xy_DeepSubSurfHeatFlux ) ) xy_DeepSubSurfHeatFlux = TempFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t290 = 1, jmax*imax                                            
     .           xy_deepsubsurfheatflux(t290-1,1) = tempflux                    
     .        enddo                                                             
   376      if ( present(xy_SurfType            ) ) xy_SurfType            = SurfType
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t284 = 1, jmax*imax                                            
     .           xy_surftype(t284-1,1) = surftype                               
     .        enddo                                                             
   377      if ( present(xy_SurfCond            ) ) xy_SurfCond            = SurfCond
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t278 = 1, jmax*imax                                            
     .           xy_surfcond(t278-1,1) = surfcond                               
     .        enddo                                                             
   378      if ( present(xy_SeaIceConc          ) ) xy_SeaIceConc          = SeaIceConc
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t272 = 1, jmax*imax                                            
     .           xy_seaiceconc(t272-1,1) = seaiceconc                           
     .        enddo                                                             
   379      if ( present(xy_SoilHeatCap         ) ) xy_SoilHeatCap         = SoilHeatCap
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t266 = 1, jmax*imax                                            
     .           xy_soilheatcap(t266-1,1) = soilheatcap                         
     .        enddo                                                             
   380      if ( present(xy_SoilHeatDiffCoef    ) ) xy_SoilHeatDiffCoef    = SoilHeatDiffCoef
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t260 = 1, jmax*imax                                            
     .           xy_soilheatdiffcoef(t260-1,1) = soilheatdiffcoef               
     .        enddo                                                             
   381      if ( present(xy_SurfHeightStd       ) ) xy_SurfHeightStd       = SurfHeightStd
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t254 = 1, jmax*imax                                            
     .           xy_surfheightstd(t254-1,1) = surfheightstd                     
     .        enddo                                                             
   382  
   383  
   384    end subroutine SetSurfData
   385  
   386    !--------------------------------------------------------------------------------------
   387  
   388    subroutine Hosakaetal98SST( &
   389      & xy_SurfTemp  & ! (out)
   390      & )
   391      !
   392      ! GCM 用の地表面データを返します.
   393      !
   394      ! Return surface data for GCM.
   395      !
   396  
   397      ! モジュール引用 ; USE statements
   398      !
   399  
   400      ! 座標データ設定
   401      ! Axes data settings
   402      !
   403      use axesset, only: &
   404        & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   405  
   406      ! 物理・数学定数設定
   407      ! Physical and mathematical constants settings
   408      !
   409      use constants0, only: &
   410        & PI                    ! $ \pi $.
   411                                ! 円周率. Circular constant
   412  
   413      ! 文字列操作
   414      ! Character handling
   415      !
   416      use dc_string, only: LChar
   417  
   418      ! 宣言文 ; Declaration statements
   419      !
   420      implicit none
   421      real(DP), intent(out) :: xy_SurfTemp (0:imax-1, 1:jmax)
   422                                ! 地表面温度.
   423                                ! Surface temperature
   424  
   425      ! 作業変数 (Hosaka et al. (1998))
   426      ! Work variables (Hosaka et al. (1998))
   427      !
   428      real(DP):: TempEq         ! 赤道上 (正確には LatCenter 上) での温度.
   429                                ! Temperature on the equator
   430                                ! (on LatCenter, to be exact)
   431      real(DP):: LatCenter      ! 温度最高の緯度.
   432                                ! Latitude on which temperature is maximum.
   433      real(DP):: LatFlatWidth   ! 温度が平坦化される緯度幅.
   434                                ! Latitude width in which temperature is flattened
   435      integer:: jp
   436      integer:: jm
   437  
   438      real(DP):: LatA, Alpha, Beta, Gamma
   439  
   440      real(DP):: Phi1, AlphaBeta4, Phi, LatAPlus, LatAMinus
   441      real(DP):: SurfTempMx
   442  
   443      ! 作業変数
   444      ! Work variables
   445      !
   446  !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   447  !!$                              ! Work variables for DO loop in longitude
   448      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   449                                ! Work variables for DO loop in latitude
   450  !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   451  !!$                              ! Work variables for DO loop in vertical direction
   452  
   453      ! 実行文 ; Executable statement
   454  
   455      ! 初期化確認
   456      ! Initialization check
   457      !
   458      if ( .not. surface_data_inited ) then
   459        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   460      end if
   461  
   462  
   463      ! Hosaka et al. (1998) において用いられた SST
   464      ! SST used in Hosaka et al. (1998)
   465      !
   466  
   467  !!$    TempEq       = SurfTemp
   468      TempEq       = 302.0_DP
   469      LatCenter    =   0.0_DP
   470      LatFlatWidth =   7.0_DP
   471  
   472      LatA         =  30.0_DP
   473      Alpha        =  60.0_DP
   474      Beta         =  32.0_DP
   475      Gamma        =   0.0_DP
   476  
   477      Phi1 = abs( LatA * PI / 180.0_DP )
   478      AlphaBeta4  = 2.0_DP *( Phi1**3 ) * ( Beta / Alpha )
   479  
   480      do j = 1, jmax
   481        Phi = abs( y_Lat(j) - LatCenter * PI / 180.0_DP )
   482        xy_SurfTemp (:,j) = &
   483          & TempEq &
   484          & - Alpha / 2.0_DP &
   485          &   * ( Phi - max( sqrt( Phi1**2 + AlphaBeta4 ) - sqrt( ( Phi - Phi1 )**2 + AlphaBeta4 ), 0.0_DP ) ) &
   486          & + Gamma * ( Phi**3 )
   487      end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(d1)                                                        
     .        do t159 = 1, imax                                                 
     .           d1(t159) = dsqrt(phi1**2 + alphabeta4)                         
     .        enddo                                                             
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .              phi = abs(y_lat(j)-latcenter*3.14159265358979e+000/         
     .       1         1.80000000000000e+002)                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d1)                                                  
     .              do t159 = 1, imax                                           
     .                 xy_surftemp(t159-1,j) = tempeq - alpha/                  
     .       1            2.00000000000000e+000*(phi - max(d1(t159)-dsqrt((phi- 
     .       2            phi1)**2+alphabeta4),0.0000000000000000e+000)) + gamma
     .       3            *phi**3                                               
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .              phi2 = abs(y_lat(j)-latcenter*3.14159265358979e+000/        
     .       1         1.80000000000000e+002)                                   
     .              phi3 = abs(y_lat(j+1)-latcenter*3.14159265358979e+000/      
     .       1         1.80000000000000e+002)                                   
     .              phi4 = abs(y_lat(j+2)-latcenter*3.14159265358979e+000/      
     .       1         1.80000000000000e+002)                                   
     .              phi5 = abs(y_lat(j+3)-latcenter*3.14159265358979e+000/      
     .       1         1.80000000000000e+002)                                   
     .              d7 = 1.D0/2.00000000000000e+000                             
     .              d8 = 1.D0/2.00000000000000e+000                             
     .              d9 = 1.D0/2.00000000000000e+000                             
     .              d10 = 1.D0/2.00000000000000e+000                            
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d1)                                                  
     .              do t159 = 1, imax                                           
     .                 d2 = d1(t159)                                            
     .                 xy_surftemp(t159-1,j) = tempeq - (alpha*d7)*(phi2 - max( 
     .       1            d2 - dsqrt((phi2 - phi1)**2 + alphabeta4),            
     .       2            0.0000000000000000e+000)) + gamma*phi2**3             
     .                 xy_surftemp(t159-1,j+1) = tempeq - (alpha*d8)*(phi3 - max
     .       1            (d2 - dsqrt((phi3 - phi1)**2 + alphabeta4),           
     .       2            0.0000000000000000e+000)) + gamma*phi3**3             
     .                 xy_surftemp(t159-1,j+2) = tempeq - (alpha*d9)*(phi4 - max
     .       1            (d2 - dsqrt((phi4 - phi1)**2 + alphabeta4),           
     .       2            0.0000000000000000e+000)) + gamma*phi4**3             
     .                 xy_surftemp(t159-1,j+3) = tempeq - (alpha*d10)*(phi5 -   
     .       1            max(d2 - dsqrt((phi5 - phi1)**2 + alphabeta4),        
     .       2            0.0000000000000000e+000)) + gamma*phi5**3             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   488  
   489      ! 中心 LatCenter +/- LatFlatWidth の間を平坦に
   490      ! Flatten between LatCenter +/- LatFlatWidth
   491      !
   492      if ( LatFlatWidth < 0.0_DP ) then
   493        LatFlatWidth = - LatFlatWidth
   494      end if
   495      LatAPlus = ( LatCenter + LatFlatWidth ) * PI / 180.0_DP
   496      LatAMinus = ( LatCenter - LatFlatWidth ) * PI / 180.0_DP
   497  
   498      jp = 1
   499      jm = jmax
   500      do j = 1, jmax
   501        if ( y_Lat(j) <= LatAPlus ) then
   502          jp = j
   503          if ( j == jmax ) jp = jp - 1
   504        end if
   505        if ( y_Lat(j) < LatAMinus ) then
   506          jm = j
   507          if ( j == jmax ) jm = jm - 1
   508        end if
   509      end do
     .  !cdir nodep                                                             
     .        do j = 1, jmax                                                    
     .           if (y_lat(j) .le. lataplus) then                               
     .              jp = (j)                                                    
     .              if ((j) .eq. jmax) then                                     
     .                 jp = jp - 1                                              
     .              endif                                                       
     .           endif                                                          
     .           if (y_lat(j) .lt. lataminus) then                              
     .              jm = (j)                                                    
     .              if ((j) .eq. jmax) then                                     
     .                 jm = jm - 1                                              
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   510  
   511      if ( jmax /= 1 ) then
   512        SurfTempMx = &
   513          & (   xy_SurfTemp(0,jm) * ( y_Lat(jm+1) - LatAMinus ) &
   514          &   + xy_SurfTemp(0,jm+1) * ( LatAMinus - y_Lat(jm) ) &
   515          & ) &
   516          & / ( y_Lat(jm+1) - y_Lat(jm) )
   517  
   518        xy_SurfTemp(:,jm+1:jp) = SurfTempMx
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t162 = 1, (jp - jm)*imax                                       
     .           xy_surftemp(t162-1,1+jm) = surftempmx                          
     .        enddo                                                             
   519      end if
   520  
   521  
   522    end subroutine Hosakaetal98SST
   523  
   524    !--------------------------------------------------------------------------------------
   525  
   526    recursive subroutine NH00SST( &
   527      & SSTType,     & ! (in   )
   528      & xy_SurfTemp  & ! (inout)
   529      & )
   530      !
   531      ! Set SST described by Neale and Hoskins (2000)
   532      !
   533  
   534      ! モジュール引用 ; USE statements
   535      !
   536  
   537      ! 座標データ設定
   538      ! Axes data settings
   539      !
   540      use axesset, only: &
   541        & x_Lon,         &      ! $ \lambda $ [rad.] . 経度. Longitude
   542        & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   543  
   544      ! 物理・数学定数設定
   545      ! Physical and mathematical constants settings
   546      !
   547      use constants0, only: &
   548        & PI                    ! $ \pi $.
   549                                ! 円周率. Circular constant
   550  
   551      ! 文字列操作
   552      ! Character handling
   553      !
   554      use dc_string, only: LChar
   555  
   556      ! 宣言文 ; Declaration statements
   557      !
   558      implicit none
   559      character(len=*), intent(in   ) :: SSTType
   560      real(DP)        , intent(inout) :: xy_SurfTemp (0:imax-1, 1:jmax)
   561                                ! 地表面温度.
   562                                ! Surface temperature
   563  
   564      ! 作業変数
   565      ! Work variables
   566      !
   567      real(DP) :: Temp0         ! Zero degree Celsius
   568                                ! Latitude width in which temperature is flattened
   569      real(DP) :: xy_SurfTempTmp1 (0:imax-1, 1:jmax)
   570      real(DP) :: xy_SurfTempTmp2 (0:imax-1, 1:jmax)
   571  
   572      real(DP) :: TAmp
   573      real(DP) :: LonCen
   574      real(DP) :: LonWid
   575      real(DP) :: LatWid
   576  
   577      ! 作業変数
   578      ! Work variables
   579      !
   580      integer:: i               ! 経度方向に回る DO ループ用作業変数
   581                                ! Work variables for DO loop in longitude
   582      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   583                                ! Work variables for DO loop in latitude
   584  !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   585  !!$                              ! Work variables for DO loop in vertical direction
   586  
   587      ! 実行文 ; Executable statement
   588  
   589      Temp0 = 273.15_DP
   590  
   591      if ( SSTType == 'control' ) then
   592        ! Neale and Hoskins (2000) の control experiment において用いられた SST
   593        ! SST used for control experiment by Neale and Hoskins (2000)
   594        !
   595  
   596        do j = 1, jmax
   597          if ( abs( y_Lat(j) ) < PI / 3.0_DP ) then
   598            xy_SurfTemp(:,j) = 27.0_DP * ( 1.0_DP - sin( 3.0_DP * y_Lat(j) / 2.0_DP )**2 )
     .        d1 = 3.00000000000000e+000/2.00000000000000e+000                  
     .  !cdir nodep                                                             
     .        do t472 = 1, imax                                                 
     .           xy_surftemp(t472-1,j) = 2.70000000000000e+001*(                
     .       1      1.00000000000000e+000 - dsin(y_lat(j)*d1)**2)               
     .        enddo                                                             
     .        goto 10098                                                        
   599          else
   600            xy_SurfTemp(:,j) = 0.0_DP
   601          end if
   602        end do
   603        xy_SurfTemp = xy_SurfTemp + Temp0
     .           if (jmax .gt. 0) then                                          
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t464 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t466 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t466-1,t464) = xy_surftemp(t466-1,t464) +    
     .       1            temp0                                                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t464 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t466 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t466-1,t464) = xy_surftemp(t466-1,t464) +    
     .       1            temp0                                                 
     .                 xy_surftemp(t466-1,t464+1) = xy_surftemp(t466-1,t464+1)  
     .       1             + temp0                                              
     .                 xy_surftemp(t466-1,t464+2) = xy_surftemp(t466-1,t464+2)  
     .       1             + temp0                                              
     .                 xy_surftemp(t466-1,t464+3) = xy_surftemp(t466-1,t464+3)  
     .       1             + temp0                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10010                                                        
   604  
   605  
   606      else if ( SSTType == 'peaked' ) then
   607        ! Neale and Hoskins (2000) の Peaked experiment において用いられた SST
   608        ! SST used for Peaked experiment by Neale and Hoskins (2000)
   609        !
   610  
   611        do j = 1, jmax
   612          if ( abs( y_Lat(j) ) < PI / 3.0_DP ) then
   613            xy_SurfTemp(:,j) = 27.0_DP * ( 1.0_DP - 3.0_DP * abs( y_Lat(j) ) / PI )
     .        d2 = 3.00000000000000e+000/3.14159265358979e+000                  
     .  !cdir nodep                                                             
     .        do t458 = 1, imax                                                 
     .           xy_surftemp(t458-1,j) = 2.70000000000000e+001*(                
     .       1      1.00000000000000e+000 - abs(y_lat(j))*d2)                   
     .        enddo                                                             
     .        goto 10083                                                        
   614          else
   615            xy_SurfTemp(:,j) = 0.0_DP
   616          end if
   617        end do
   618        xy_SurfTemp = xy_SurfTemp + Temp0
     .           if (jmax .gt. 0) then                                          
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t450 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t452 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t452-1,t450) = xy_surftemp(t452-1,t450) +    
     .       1            temp0                                                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t450 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t452 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t452-1,t450) = xy_surftemp(t452-1,t450) +    
     .       1            temp0                                                 
     .                 xy_surftemp(t452-1,t450+1) = xy_surftemp(t452-1,t450+1)  
     .       1             + temp0                                              
     .                 xy_surftemp(t452-1,t450+2) = xy_surftemp(t452-1,t450+2)  
     .       1             + temp0                                              
     .                 xy_surftemp(t452-1,t450+3) = xy_surftemp(t452-1,t450+3)  
     .       1             + temp0                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10010                                                        
   619  
   620      else if ( SSTType == 'flat' ) then
   621        ! Neale and Hoskins (2000) の Flat experiment において用いられた SST
   622        ! SST used for Flat experiment by Neale and Hoskins (2000)
   623        !
   624  
   625        do j = 1, jmax
   626          if ( abs( y_Lat(j) ) < PI / 3.0_DP ) then
   627            xy_SurfTemp(:,j) = 27.0_DP * ( 1.0_DP - sin( 3.0_DP * y_Lat(j) / 2.0_DP )**4 )
     .        d3 = 3.00000000000000e+000/2.00000000000000e+000                  
     .  !cdir nodep                                                             
     .        do t444 = 1, imax                                                 
     .           xy_surftemp(t444-1,j) = 2.70000000000000e+001*(                
     .       1      1.00000000000000e+000 - dsin(y_lat(j)*d3)**4)               
     .        enddo                                                             
     .        goto 10068                                                        
   628          else
   629            xy_SurfTemp(:,j) = 0.0_DP
   630          end if
   631        end do
   632        xy_SurfTemp = xy_SurfTemp + Temp0
     .           if (jmax .gt. 0) then                                          
     .           j3 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t436 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t438 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t438-1,t436) = xy_surftemp(t438-1,t436) +    
     .       1            temp0                                                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t436 = j3 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t438 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t438-1,t436) = xy_surftemp(t438-1,t436) +    
     .       1            temp0                                                 
     .                 xy_surftemp(t438-1,t436+1) = xy_surftemp(t438-1,t436+1)  
     .       1             + temp0                                              
     .                 xy_surftemp(t438-1,t436+2) = xy_surftemp(t438-1,t436+2)  
     .       1             + temp0                                              
     .                 xy_surftemp(t438-1,t436+3) = xy_surftemp(t438-1,t436+3)  
     .       1             + temp0                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10010                                                        
   633  
   634      else if ( SSTType == 'control-5n' ) then
   635        ! Neale and Hoskins (2000) の Control-5N experiment において用いられた SST
   636        ! SST used for Control-5N experiment by Neale and Hoskins (2000)
   637        !
   638  
   639        do j = 1, jmax
   640          if ( y_Lat(j) < - PI / 3.0_DP ) then
   641            xy_SurfTemp(:,j) = 0.0_DP
   642          else if ( y_Lat(j) < PI / 36.0_DP ) then
   643            xy_SurfTemp(:,j) = 27.0_DP                                          &
   644              & * ( 1.0_DP - sin( 90.0_DP/65.0_DP * ( y_Lat(j) - PI/36.0_DP ) )**2 )
   645          else if ( y_Lat(j) < PI / 3.0_DP ) then
   646            xy_SurfTemp(:,j) = 27.0_DP                                           &
   647              & * ( 1.0_DP - sin( 90.0_DP/55.0_DP * ( y_Lat(j) - PI/36.0_DP ) )**2 )
   648          else
   649            xy_SurfTemp(:,j) = 0.0_DP
   650          end if
   651        end do
   652        xy_SurfTemp = xy_SurfTemp + Temp0
     .           if (jmax .gt. 0) then                                          
     .           j4 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t416 = 1, j4                                                
     .  !cdir       nodep                                                       
     .              do t418 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t418-1,t416) = xy_surftemp(t418-1,t416) +    
     .       1            temp0                                                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t416 = j4 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t418 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t418-1,t416) = xy_surftemp(t418-1,t416) +    
     .       1            temp0                                                 
     .                 xy_surftemp(t418-1,t416+1) = xy_surftemp(t418-1,t416+1)  
     .       1             + temp0                                              
     .                 xy_surftemp(t418-1,t416+2) = xy_surftemp(t418-1,t416+2)  
     .       1             + temp0                                              
     .                 xy_surftemp(t418-1,t416+3) = xy_surftemp(t418-1,t416+3)  
     .       1             + temp0                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10010                                                        
   653  
   654      else if ( SSTType == 'qobs' ) then
   655        ! Neale and Hoskins (2000) の Qobs experiment において用いられた SST
   656        ! SST used for Qobs experiment by Neale and Hoskins (2000)
   657        !
   658  
   659        call NH00SST( &
   660          & 'control',     & ! (in   )
   661          & xy_SurfTempTmp1  & ! (inout)
   662          & )
   663        call NH00SST( &
   664          & 'flat',     & ! (in   )
   665          & xy_SurfTempTmp2  & ! (inout)
   666          & )
   667        xy_SurfTemp = ( xy_SurfTempTmp1 + xy_SurfTempTmp2 ) * 0.5_DP
     .        if (xy_surftemptmp1.DSC.U2 .gt. 0) then                           
     .           j5 = and(xy_surftemptmp1.DSC.U2,3)                             
     .  !cdir    nodep                                                          
     .           do t403 = 1, j5                                                
     .  !cdir       nodep                                                       
     .              do t405 = 1, xy_surftemptmp1.DSC.U1 + 2 - min0(1,           
     .       1         xy_surftemptmp1.DSC.U1 + 1)                              
     .                 xy_surftemp(t405-1,t403) = (xy_surftemptmp1(t405-1,t403)+
     .       1            xy_surftemptmp2(t405-1,t403))*5.00000000000000e-001   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t403 = j5 + 1, xy_surftemptmp1.DSC.U2, 4                    
     .  !cdir       nodep                                                       
     .              do t405 = 1, xy_surftemptmp1.DSC.U1 + 2 - min0(1,           
     .       1         xy_surftemptmp1.DSC.U1 + 1)                              
     .                 xy_surftemp(t405-1,t403) = (xy_surftemptmp1(t405-1,t403)+
     .       1            xy_surftemptmp2(t405-1,t403))*5.00000000000000e-001   
     .                 xy_surftemp(t405-1,t403+1) = (xy_surftemptmp1(t405-1,t403
     .       1            +1)+xy_surftemptmp2(t405-1,t403+1))*                  
     .       2            5.00000000000000e-001                                 
     .                 xy_surftemp(t405-1,t403+2) = (xy_surftemptmp1(t405-1,t403
     .       1            +2)+xy_surftemptmp2(t405-1,t403+2))*                  
     .       2            5.00000000000000e-001                                 
     .                 xy_surftemp(t405-1,t403+3) = (xy_surftemptmp1(t405-1,t403
     .       1            +3)+xy_surftemptmp2(t405-1,t403+3))*                  
     .       2            5.00000000000000e-001                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10010                                                        
   668  
   669      else if ( SSTType == '1keq' ) then
   670        ! Neale and Hoskins (2000) の 1KEQ experiment において用いられた SST
   671        ! SST used for 1KEQ experiment by Neale and Hoskins (2000)
   672        !
   673  
   674        call NH00SST( &
   675          & 'control',     & ! (in   )
   676          & xy_SurfTemp  & ! (inout)
   677          & )
   678  
   679        TAmp   =   1.0_DP
   680        LonCen = 180.0_DP * PI / 180.0_DP
   681        LonWid =  30.0_DP * PI / 180.0_DP
   682        LatWid =  15.0_DP * PI / 180.0_DP
   683        do j = 1, jmax
   684          do i = 0, imax-1
   685            if ( ( abs( x_Lon(i) - LonCen ) < LonWid ) .and. &
   686              &  ( abs( y_Lat(j)          ) < LatWid ) ) then
   687              xy_SurfTemp(i,j) = xy_SurfTemp(i,j)                              &
   688                & + TAmp * cos( PI/2.0_DP * ( x_Lon(i) - LonCen ) / LonWid )**2 &
   689                &        * cos( PI/2.0_DP * y_Lat(j)              / LatWid )**2
   690            end if
   691          end do
   692        end do
     .  !cdir noassume                                                          
     .        do i1 = 0, imax - 1, maxvl()                                      
     .           i2 = min0(imax - i1,maxvl())                                   
     .           if (jmax .gt. 0) then                                          
     .              j8 = and(jmax,3)                                            
     .              do j = 1, j8                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .                 do i = 1, i2                                             
     .                    if (abs((x_lon(i1+i-1)-loncen)).lt.lonwid .and. abs(  
     .       1               y_lat(j)).lt.latwid) then                          
     .                       xy_surftemp(i1+i-1,j) = xy_surftemp(i1+i-1,j) +    
     .       1                  tamp*dcos(1.57079632679489e+000*(x_lon(i1+i-1)- 
     .       2                  loncen)/lonwid)**2*dcos(1.57079632679489e+000*  
     .       3                  y_lat(j)/latwid)**2                             
     .                    endif                                                 
     .                 enddo                                                    
     .              enddo                                                       
     .              do j = j8 + 1, jmax, 4                                      
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .                 do i = 1, i2                                             
     .                    if (((abs((x_lon(i1+i-1)-loncen))).lt.lonwid) .and.   
     .       1               abs(y_lat(j)).lt.latwid) then                      
     .                       xy_surftemp(i1+i-1,j) = xy_surftemp(i1+i-1,j) +    
     .       1                  tamp*dcos(1.57079632679489e+000*(x_lon(i1+i-1)- 
     .       2                  loncen)/lonwid)**2*dcos(1.57079632679489e+000*  
     .       3                  y_lat(j)/latwid)**2                             
     .                    endif                                                 
     .                    if (((abs((x_lon(i1+i-1)-loncen))).lt.lonwid) .and.   
     .       1               abs(y_lat(j+1)).lt.latwid) then                    
     .                       xy_surftemp(i1+i-1,j+1) = xy_surftemp(i1+i-1,j+1)  
     .       1                   + tamp*dcos(1.57079632679489e+000*(x_lon(i1+i-1
     .       2                  )-loncen)/lonwid)**2*dcos(1.57079632679489e+000*
     .       3                  y_lat(j+1)/latwid)**2                           
     .                    endif                                                 
     .                    if (((abs((x_lon(i1+i-1)-loncen))).lt.lonwid) .and.   
     .       1               abs(y_lat(j+2)).lt.latwid) then                    
     .                       xy_surftemp(i1+i-1,j+2) = xy_surftemp(i1+i-1,j+2)  
     .       1                   + tamp*dcos(1.57079632679489e+000*(x_lon(i1+i-1
     .       2                  )-loncen)/lonwid)**2*dcos(1.57079632679489e+000*
     .       3                  y_lat(j+2)/latwid)**2                           
     .                    endif                                                 
     .                    if (((abs((x_lon(i1+i-1)-loncen))).lt.lonwid) .and.   
     .       1               abs(y_lat(j+3)).lt.latwid) then                    
     .                       xy_surftemp(i1+i-1,j+3) = xy_surftemp(i1+i-1,j+3)  
     .       1                   + tamp*dcos(1.57079632679489e+000*(x_lon(i1+i-1
     .       2                  )-loncen)/lonwid)**2*dcos(1.57079632679489e+000*
     .       3                  y_lat(j+3)/latwid)**2                           
     .                    endif                                                 
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .        goto 10010                                                        
   693  
   694      else if ( SSTType == '3keq' ) then
   695        ! Neale and Hoskins (2000) の 3KEQ experiment において用いられた SST
   696        ! SST used for 1KEQ experiment by Neale and Hoskins (2000)
   697        !
   698  
   699        call NH00SST( &
   700          & 'control',     & ! (in   )
   701          & xy_SurfTemp  & ! (inout)
   702          & )
   703  
   704        TAmp   =   3.0_DP
   705        LonCen = 180.0_DP * PI / 180.0_DP
   706        LonWid =  30.0_DP * PI / 180.0_DP
   707        LatWid =  15.0_DP * PI / 180.0_DP
   708        do j = 1, jmax
   709          do i = 0, imax-1
   710            if ( ( abs( x_Lon(i) - LonCen ) < LonWid ) .and. &
   711              &  ( abs( y_Lat(j)          ) < LatWid ) ) then
   712              xy_SurfTemp(i,j) = xy_SurfTemp(i,j)                              &
   713                & + TAmp * cos( PI/2.0_DP * ( x_Lon(i) - LonCen ) / LonWid )**2 &
   714                &        * cos( PI/2.0_DP * y_Lat(j)              / LatWid )**2
   715            end if
   716          end do
   717        end do
     .  !cdir noassume                                                          
     .        do i3 = 0, imax - 1, maxvl()                                      
     .           i4 = min0(imax - i3,maxvl())                                   
     .           if (jmax .gt. 0) then                                          
     .              j11 = and(jmax,3)                                           
     .              do j = 1, j11                                               
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .                 do i = 1, i4                                             
     .                    if (abs((x_lon(i3+i-1)-loncen)).lt.lonwid .and. abs(  
     .       1               y_lat(j)).lt.latwid) then                          
     .                       xy_surftemp(i3+i-1,j) = xy_surftemp(i3+i-1,j) +    
     .       1                  tamp*dcos(1.57079632679489e+000*(x_lon(i3+i-1)- 
     .       2                  loncen)/lonwid)**2*dcos(1.57079632679489e+000*  
     .       3                  y_lat(j)/latwid)**2                             
     .                    endif                                                 
     .                 enddo                                                    
     .              enddo                                                       
     .              do j = j11 + 1, jmax, 4                                     
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .                 do i = 1, i4                                             
     .                    if (((abs((x_lon(i3+i-1)-loncen))).lt.lonwid) .and.   
     .       1               abs(y_lat(j)).lt.latwid) then                      
     .                       xy_surftemp(i3+i-1,j) = xy_surftemp(i3+i-1,j) +    
     .       1                  tamp*dcos(1.57079632679489e+000*(x_lon(i3+i-1)- 
     .       2                  loncen)/lonwid)**2*dcos(1.57079632679489e+000*  
     .       3                  y_lat(j)/latwid)**2                             
     .                    endif                                                 
     .                    if (((abs((x_lon(i3+i-1)-loncen))).lt.lonwid) .and.   
     .       1               abs(y_lat(j+1)).lt.latwid) then                    
     .                       xy_surftemp(i3+i-1,j+1) = xy_surftemp(i3+i-1,j+1)  
     .       1                   + tamp*dcos(1.57079632679489e+000*(x_lon(i3+i-1
     .       2                  )-loncen)/lonwid)**2*dcos(1.57079632679489e+000*
     .       3                  y_lat(j+1)/latwid)**2                           
     .                    endif                                                 
     .                    if (((abs((x_lon(i3+i-1)-loncen))).lt.lonwid) .and.   
     .       1               abs(y_lat(j+2)).lt.latwid) then                    
     .                       xy_surftemp(i3+i-1,j+2) = xy_surftemp(i3+i-1,j+2)  
     .       1                   + tamp*dcos(1.57079632679489e+000*(x_lon(i3+i-1
     .       2                  )-loncen)/lonwid)**2*dcos(1.57079632679489e+000*
     .       3                  y_lat(j+2)/latwid)**2                           
     .                    endif                                                 
     .                    if (((abs((x_lon(i3+i-1)-loncen))).lt.lonwid) .and.   
     .       1               abs(y_lat(j+3)).lt.latwid) then                    
     .                       xy_surftemp(i3+i-1,j+3) = xy_surftemp(i3+i-1,j+3)  
     .       1                   + tamp*dcos(1.57079632679489e+000*(x_lon(i3+i-1
     .       2                  )-loncen)/lonwid)**2*dcos(1.57079632679489e+000*
     .       3                  y_lat(j+3)/latwid)**2                           
     .                    endif                                                 
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .        goto 10010                                                        
   718  
   719      else if ( SSTType == '3kw1' ) then
   720        ! Neale and Hoskins (2000) の 3KW1 experiment において用いられた SST
   721        ! SST used for 1KEQ experiment by Neale and Hoskins (2000)
   722        !
   723  
   724        call NH00SST( &
   725          & 'control',     & ! (in   )
   726          & xy_SurfTemp  & ! (inout)
   727          & )
   728  
   729        TAmp   =   3.0_DP
   730        LonCen = 180.0_DP * PI / 180.0_DP
   731        LatWid =  30.0_DP * PI / 180.0_DP
   732        do j = 1, jmax
   733          do i = 0, imax-1
   734            if ( abs( y_Lat(j) ) < LatWid ) then
   735              xy_SurfTemp(i,j) = xy_SurfTemp(i,j)                  &
   736                & + TAmp * cos( x_Lon(i) - LonCen )                &
   737                &        * cos( PI/2.0_DP * y_Lat(j) / LatWid )**2
   738            end if
   739          end do
     .        if (abs(y_lat(j)) .lt. latwid) then                               
     .  !cdir    nodep                                                          
     .  !cdir    on_adb(x_lon)                                                  
     .           do i = 1, imax                                                 
     .              xy_surftemp(i-1,j) = xy_surftemp(i-1,j) + tamp*dcos(x_lon(i-
     .       1         1)-loncen)*dcos(1.57079632679489e+000*y_lat(j)/latwid)**2
     .           enddo                                                          
     .        endif                                                             
   740        end do
   741  
   742      else
   743        call MessageNotify( 'E', module_name, 'SSTType=<%c> is invalid.', &
   744          & c1 = trim(SSTType) )
   745      end if
   746  
   747  
   748    end subroutine NH00SST
   749  
   750    !--------------------------------------------------------------------------------------
   751  
   752    subroutine SurfDataInit
   753  
   754      ! モジュール引用 ; USE statements
   755      !
   756  
   757      ! NAMELIST ファイル入力に関するユーティリティ
   758      ! Utilities for NAMELIST file input
   759      !
   760      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   761  
   762      ! ファイル入出力補助
   763      ! File I/O support
   764      !
   765      use dc_iounit, only: FileOpen
   766  
   767      ! 文字列操作
   768      ! Character handling
   769      !
   770      use dc_string, only: LChar
   771  
   772      ! ファイルから 1 次元プロファイルを読んで設定する.
   773      ! read 1-D profile from a file and set it
   774      !
   775      use set_1d_profile, only : Set1DProfileInit
   776  
   777  
   778      ! 宣言文 ; Declaration statements
   779      !
   780      implicit none
   781  
   782      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   783                                ! Unit number for NAMELIST file open
   784      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   785                                ! IOSTAT of NAMELIST read
   786  
   787      ! NAMELIST 変数群
   788      ! NAMELIST group name
   789      !
   790      namelist /surface_data_nml/ Pattern,            &
   791        & SurfTemp, Albedo, HumidCoef, RoughLength,   &
   792        & HeatCapacity, TempFlux, SurfType, SurfCond, &
   793        & SeaIceConc,                                 &
   794        & SoilHeatCap, SoilHeatDiffCoef,              &
   795        & SurfHeightStd
   796            !
   797            ! デフォルト値については初期化手続 "surface_data#SurfDataInit"
   798            ! のソースコードを参照のこと.
   799            !
   800            ! Refer to source codes in the initialization procedure
   801            ! "surface_data#SurfDataInit" for the default values.
   802            !
   803  
   804  
   805      ! 実行文 ; Executable statement
   806  
   807      if ( surface_data_inited ) return
   808  
   809  
   810      ! デフォルト値の設定 (まずは Pattern のみ)
   811      ! Default values settings (At first, "Pattern" only)
   812      !
   813  !!$    Pattern      = 'Hosaka et al. (1998)'
   814      Pattern      = 'homogeneous'
   815      SurfTemp     = 273.15_DP
   816      Albedo       = 0.15_DP
   817      HumidCoef    = 1.0_DP
   818      RoughLength  = 1.0e-4_DP
   819      HeatCapacity = 0.0_DP
   820      TempFlux     = 0.0_DP
   821      SurfType     = 0
   822      SurfCond     = 0
   823      SeaIceConc   = 0.0_DP
   824  
   825      SoilHeatCap      = 2.1e6_DP
   826      !   volumetric heat capacity (J m-3 K-1)
   827      !   Value of Clay for porosity f=0.4, volumetric wetness theta=0.2 in Table 12.3 by
   828      !   Hillel (2004).
   829      !   Note that the unit of Table 12.3 of Hillel (2004) would be wrong. Although the
   830      !   unit in the Table is wrong, the volumetric heat capacity of 2.1d6 J m-3 K-1 is
   831      !   within the range of typical value of it.
   832  
   833      SoilHeatDiffCoef = 1.2e0_DP
   834      !   thermal conductivity (W m-1 K-1)
   835      !   Value of Clay for porosity f=0.4, volumetric wetness theta=0.2 in Table 12.3 by
   836      !   Hillel (2004).
   837  
   838      !   Reference
   839      !
   840      !   Hillet, D.,
   841      !     Introduction to Environmental Soil Physics,
   842      !     Elsevier Academic Press, pp494, 2004.
   843  
   844  
   845      !   Sample values for Mars
   846      !     These values were obtained from Kiefer (1976) and Kieffer et al. (1977).
   847      !   Reference
   848      !     Kieffer, Science, 194, 1344-1346, 1976.
   849      !     Kieffer et al., JGR, 82, 4249-4291, 1977.
   850      !
   851      !   Standard model: see Kieffer et al. (1977) p. 4286,
   852      !   albedo,                 A   = 0.25
   853      !     (Kieffer et al., 1977)
   854      !   thermal inertia,        I   = 6.5e-3 cal cm-2 s-1/2 K-1 = 272 J m-2 s-1/2 K-1
   855      !     (Kieffer et al., 1977)
   856      !   density,                rho = 1.65 g cm-3 = 1650 kg m-3
   857      !     (Kieffer, 1976)
   858      !   specific heat,          cp  = 0.14 cal g-1 K-1 = 586 J kg-1 K-1
   859      !     (Kieffer, 1976)
   860      !
   861      !   heat capacity,          cp*rho = 0.97e6 J m-3 K-1
   862      !   conduction coefficient, k = I**2 / (cp*rho) = 7.6e-2   J m-1 s-1 K-1
   863      !
   864  !!$    SoilHeatCap      = 0.97d6
   865  !!$    SoilHeatDiffCoef = 0.076d0
   866  
   867      ! NOTE:
   868      !   Values by Kieffer (1976) and Kieffer et al. (1977) would be appropriate for GCM
   869      !   experiment.
   870  
   871  
   872      !   Sample values for Mars
   873      !     These values were obtained from Savijarvi (1995).
   874      !   Reference
   875      !     Savijarvi, H., Mars boundary layer modeling: Diurnal moisture cycle and soil
   876      !       properties at the Viking lander 1 site, Icarus, 117, 120-127, 1995.
   877      !
   878  !!$    SoilHeatCap      = 0.8d6
   879  !!$    SoilHeatDiffCoef = 0.18d0
   880  
   881  
   882      SurfHeightStd = 0.0_DP
   883  
   884  
   885      ! NAMELIST の読み込み (まずは Pattern のみ)
   886      ! NAMELIST is input (At first, "Pattern" only)
   887      !
   888      if ( trim(namelist_filename) /= '' ) then
   889        call FileOpen( unit_nml, &          ! (out)
   890          & namelist_filename, mode = 'r' ) ! (in)
   891  
   892        rewind( unit_nml )
   893        read( unit_nml, &             ! (in)
   894          & nml = surface_data_nml, & ! (out)
   895          & iostat = iostat_nml )     ! (out)
   896        close( unit_nml )
   897  
   898        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   899      end if
   900  
   901  
   902      ! NAMELIST の読み込み
   903      ! NAMELIST is input
   904      !
   905      if ( trim(namelist_filename) /= '' ) then
   906        call FileOpen( unit_nml, &          ! (out)
   907          & namelist_filename, mode = 'r' ) ! (in)
   908  
   909        rewind( unit_nml )
   910        read( unit_nml, &             ! (in)
   911          & nml = surface_data_nml, & ! (out)
   912          & iostat = iostat_nml )     ! (out)
   913        close( unit_nml )
   914  
   915        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   916      end if
   917  
   918  
   919      ! ファイルから 1 次元プロファイルを読んで設定する.
   920      ! read 1-D profile from a file and set it
   921      !
   922      call Set1DProfileInit
   923  
   924  
   925      ! 印字 ; Print
   926      !
   927      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   928      call MessageNotify( 'M', module_name, '  Pattern          = %c', c1 = trim(Pattern) )
   929      call MessageNotify( 'M', module_name, '  SurfTemp         = %f', d = (/ SurfTemp         /) )
   930      call MessageNotify( 'M', module_name, '  Albedo           = %f', d = (/ Albedo           /) )
   931      call MessageNotify( 'M', module_name, '  HumidCoef        = %f', d = (/ HumidCoef        /) )
   932      call MessageNotify( 'M', module_name, '  RoughLength      = %f', d = (/ RoughLength      /) )
   933      call MessageNotify( 'M', module_name, '  HeatCapacity     = %f', d = (/ HeatCapacity     /) )
   934      call MessageNotify( 'M', module_name, '  TempFlux         = %f', d = (/ TempFlux         /) )
   935      call MessageNotify( 'M', module_name, '  SurfType         = %d', i = (/ SurfType         /) )
   936      call MessageNotify( 'M', module_name, '  SurfCond         = %d', i = (/ SurfCond         /) )
   937      call MessageNotify( 'M', module_name, '  SeaIceConc       = %f', d = (/ SeaIceConc       /) )
   938      call MessageNotify( 'M', module_name, '  SoilHeatCap      = %f', d = (/ SoilHeatCap      /) )
   939      call MessageNotify( 'M', module_name, '  SoilHeatDiffCoef = %f', d = (/ SoilHeatDiffCoef /) )
   940      call MessageNotify( 'M', module_name, '  SurfHeightStd    = %f', d = (/ SurfHeightStd /) )
   941      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   942  
   943      surface_data_inited = .true.
   944  
   945    end subroutine SurfDataInit
   946  
   947    !--------------------------------------------------------------------------------------
   948  
   949  end module surface_data
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:31 2016
FILE NAME: surface_data.f90
PROGRAM NAME: surface_data
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地表面データ提供
     2:             !
     3:             != Prepare surface data
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6:             ! Version::   $Id: surface_data.f90,v 1.17 2015/02/14 07:26:43 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module surface_data
    13:               !
    14:               != 地表面データ提供
    15:               !
    16:               != Prepare surface data
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! GCM で用いる地表面データを生成します.
    21:               ! 現在は暫定的に Hosaka et al. (1998) の SST 分布を与えます.
    22:               !
    23:               ! Surface data for GCM is generated.
    24:               ! Now, SST profile in Hosaka et al. (1998) is provided tentatively.
    25:               !
    26:               !== Procedures List
    27:               !
    28:               ! SetSurfData   :: 地表面データの取得
    29:               ! ------------  :: ------------
    30:               ! SetSurfData   :: Set surface data
    31:               !
    32:               !== NAMELIST
    33:               !
    34:               ! NAMELIST#surface_data_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:             
    40:               ! 格子点設定
    41:               ! Grid points settings
    42:               !
    43:               use gridset, only: imax, & ! 経度格子点数. 
    44:                                          ! Number of grid points in longitude
    45:                 &                jmax, & ! 緯度格子点数. 
    46:                                          ! Number of grid points in latitude
    47:                 &                kmax    ! 鉛直層数. 
    48:                                          ! Number of vertical level
    49:             
    50:               ! 種別型パラメタ
    51:               ! Kind type parameter
    52:               !
    53:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    54:                 &                 STRING     ! 文字列.       Strings. 
    55:             
    56:               ! 種別型パラメタ
    57:               ! Kind type parameter
    58:               !
    59:               use dc_types, only: DP     ! 倍精度実数型. Double precision. 
    60:             
    61:               ! メッセージ出力
    62:               ! Message output
    63:               !
    64:               use dc_message, only: MessageNotify
    65:             
    66:               ! 宣言文 ; Declaration statements
    67:               !
    68:               implicit none
    69:               private
    70:             
    71:               ! 公開手続き
    72:               ! Public procedure
    73:               !
    74:               public:: SetSurfData
    75:               public:: SurfDataInit
    76:             
    77:               ! 公開変数
    78:               ! Public variables
    79:               !
    80:               logical, save :: surface_data_inited = .false.
    81:                                           ! 初期設定フラグ. 
    82:                                           ! Initialization flag
    83:             
    84:               ! 非公開変数
    85:               ! Private variables
    86:               !
    87:               character(STRING), save:: Pattern
    88:                                           ! 地表面データのパターン. 
    89:                                           ! 以下のパターンを選択可能. 
    90:                                           ! 
    91:                                           ! Surface data pattern. 
    92:                                           ! Available patterns are as follows.
    93:                                           ! 
    94:                                           ! * "Hosaka et al. (1998)"
    95:                                           ! * "Homogeneous"
    96:                                           ! 
    97:               real(DP), save:: SurfTemp
    98:                                           ! 地表面温度の基準値. 
    99:                                           ! Standard value of surface temperature
   100:               real(DP), save:: Albedo
   101:                                           ! 地表アルベド. 
   102:                                           ! Surface albedo
   103:               real(DP), save:: HumidCoef
   104:                                           ! 地表湿潤度. 
   105:                                           ! Surface humidity coefficient
   106:               real(DP), save:: RoughLength
   107:                                           ! 地表粗度長. 
   108:                                           ! Surface rough length
   109:               real(DP), save:: HeatCapacity
   110:                                           ! 地表熱容量. 
   111:                                           ! Surface heat capacity
   112:               real(DP), save:: TempFlux
   113:                                           ! 地中熱フラックス. 
   114:                                           ! Ground temperature flux
   115:               integer, save:: SurfType
   116:                                           ! 土地利用.
   117:                                           ! Surface index
   118:               integer, save:: SurfCond
   119:                                           ! 地表状態 (0: 固定, 1: 可変). 
   120:                                           ! Surface condition (0: fixed, 1: variable)
   121:               real(DP), save:: SeaIceConc
   122:                                           ! 海氷面密度
   123:                                           ! Sea ice concentration
   124:               real(DP), save:: SoilHeatCap
   125:                                           ! 土壌熱容量 (J K-1 m-3)
   126:                                           ! Specific heat of soil (J K-1 m-3)
   127:               real(DP), save:: SoilHeatDiffCoef
   128:                                           ! 土壌熱伝導係数 (W m-1 K-1)
   129:                                           ! Heat conduction coefficient of soil (W m-1 K-1)
   130:               real(DP), save:: SurfHeightStd
   131:                                           ! 
   132:                                           ! Standard deviation of surface height
   133:             
   134:               character(*), parameter:: module_name = 'surface_data'
   135:                                           ! モジュールの名称. 
   136:                                           ! Module name
   137:               character(*), parameter:: version = &
   138:                 & '$Name:  $' // &
   139:                 & '$Id: surface_data.f90,v 1.17 2015/02/14 07:26:43 yot Exp $'
   140:                                           ! モジュールのバージョン
   141:                                           ! Module version
   142:             
   143:             
   144:             contains
   145:             
   146:               !--------------------------------------------------------------------------------------
   147:             
   148:               subroutine SetSurfData( &
   149:                 & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoef, & ! (out)
   150:                 & xy_SurfRoughLength, xy_SurfHeatCapacity,      & ! (out)
   151:                 & xy_DeepSubSurfHeatFlux,                       & ! (out)
   152:                 & xy_SurfType, xy_SurfCond,                     & ! (out)
   153:                 & xy_SeaIceConc,                                & ! (out)
   154:                 & xy_SoilHeatCap, xy_SoilHeatDiffCoef,          & ! (out)
   155:                 & xy_SurfHeightStd                              & ! (out)
   156:                 & )
   157:                 !
   158:                 ! GCM 用の地表面データを返します.
   159:                 !
   160:                 ! Return surface data for GCM.
   161:                 !
   162:             
   163:                 ! モジュール引用 ; USE statements
   164:                 !
   165:             
   166:                 ! 文字列操作
   167:                 ! Character handling
   168:                 !
   169:                 use dc_string, only: LChar
   170:             
   171:                 ! 物理・数学定数設定
   172:                 ! Physical and mathematical constants settings
   173:                 !
   174:                 use constants0, only: &
   175:                   & PI                    ! $ \pi $.
   176:                                           ! 円周率. Circular constant
   177:             
   178:                 ! 座標データ設定
   179:                 ! Axes data settings
   180:                 !
   181:                 use axesset, only: &
   182:                   & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   183:             
   184:                 ! ファイルから 1 次元プロファイルを読んで設定する. 
   185:                 ! read 1-D profile from a file and set it 
   186:                 !
   187:                 use set_1d_profile, only : Set1DProfileSurfTemp
   188:             
   189:             
   190:                 ! 宣言文 ; Declaration statements
   191:                 !
   192:                 implicit none
   193:                 real(DP), intent(out), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
   194:                                           ! 地表面温度. 
   195:                                           ! Surface temperature
   196:                 real(DP), intent(out), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
   197:                                           ! 地表アルベド. 
   198:                                           ! Surface albedo
   199:                 real(DP), intent(out), optional:: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   200:                                           ! 地表湿潤度. 
   201:                                           ! Surface humidity coefficient
   202:                 real(DP), intent(out), optional:: xy_SurfRoughLength (0:imax-1, 1:jmax)
   203:                                           ! 地表粗度長. 
   204:                                           ! Surface rough length
   205:                 real(DP), intent(out), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
   206:                                           ! 地表熱容量. 
   207:                                           ! Surface heat capacity
   208:                 real(DP), intent(out), optional:: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
   209:                                           ! 地中熱フラックス. 
   210:                                           ! "Deep subsurface heat flux"
   211:                                           ! Heat flux at the bottom of surface/soil layer.
   212:                 integer , intent(out), optional:: xy_SurfType (0:imax-1, 1:jmax)
   213:                                           ! 土地利用
   214:                                           ! Surface index
   215:                 integer , intent(out), optional:: xy_SurfCond (0:imax-1, 1:jmax)
   216:                                           ! 地表状態 (0: 固定, 1: 可変) . 
   217:                                           ! Surface condition (0: fixed, 1: variable)
   218:                 real(DP), intent(out), optional:: xy_SeaIceConc(0:imax-1, 1:jmax)
   219:                                           ! 海氷面密度
   220:                                           ! Sea ice concentration
   221:                 real(DP), intent(out), optional:: xy_SoilHeatCap(0:imax-1,1:jmax)
   222:                                           ! 土壌熱容量 (J K-1 kg-1)
   223:                                           ! Specific heat of soil (J K-1 kg-1)
   224:                 real(DP), intent(out), optional:: xy_SoilHeatDiffCoef(0:imax-1,1:jmax)
   225:                                           ! 土壌熱伝導係数 (J m-3 K-1)
   226:                                           ! Heat conduction coefficient of soil (J m-3 K-1)
   227:                 real(DP), intent(out), optional:: xy_SurfHeightStd(0:imax-1, 1:jmax)
   228:                                           ! 
   229:                                           ! Standard deviation of surface height (m)
   230:             
   231:                 ! 作業変数
   232:                 ! Work variables
   233:                 !
   234:             !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   235:             !!$                              ! Work variables for DO loop in longitude
   236:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   237:                                           ! Work variables for DO loop in latitude
   238:             !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   239:             !!$                              ! Work variables for DO loop in vertical direction
   240:             
   241:                 ! 実行文 ; Executable statement
   242:             
   243:             
   244:                 ! 初期化確認
   245:                 ! Initialization check
   246:                 !
   247:                 if ( .not. surface_data_inited ) then
   248:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   249:                 end if
   250:             
   251:             
   252:                 select case ( LChar( trim(Pattern) ) )
   253:             
   254:                 case ( 'homogeneous' )
   255:                   ! SST 一様
   256:                   ! SST is homogeneous
   257:                   !
   258: +V===== A         if ( present(xy_SurfTemp) ) xy_SurfTemp = SurfTemp
   259:             
   260:                 case ( 'hosaka et al. (1998)' )
   261:                   ! Hosaka et al. (1998) において用いられた SST
   262:                   ! SST used in Hosaka et al. (1998)
   263:                   !
   264:                   if ( present( xy_SurfTemp ) ) then
   265:                     call Hosakaetal98SST( &
   266:                       & xy_SurfTemp  & ! (out)
   267:                       & )
   268:                   end if
   269:             
   270:                 case ( 'nh00_control' )
   271:                   ! Neale and Hoskins (2000) の control experiment において用いられた SST
   272:                   ! SST used for Control experiment by Neale and Hoskins (2000)
   273:                   !
   274:                   if ( present( xy_SurfTemp ) ) then
   275:                     call NH00SST( &
   276:                       & 'control',     & ! (in   )
   277:                       & xy_SurfTemp  & ! (inout)
   278:                       & )
   279:                   end if
   280:             
   281:                 case ( 'nh00_peaked' )
   282:                   ! Neale and Hoskins (2000) の peaked experiment において用いられた SST
   283:                   ! SST used for Control experiment by Neale and Hoskins (2000)
   284:                   !
   285:                   if ( present( xy_SurfTemp ) ) then
   286:                     call NH00SST( &
   287:                       & 'peaked',    & ! (in   )
   288:                       & xy_SurfTemp  & ! (inout)
   289:                       & )
   290:                   end if
   291:             
   292:                 case ( 'nh00_flat' )
   293:                   ! Neale and Hoskins (2000) の flat experiment において用いられた SST
   294:                   ! SST used for Control experiment by Neale and Hoskins (2000)
   295:                   !
   296:                   if ( present( xy_SurfTemp ) ) then
   297:                     call NH00SST( &
   298:                       & 'flat',      & ! (in   )
   299:                       & xy_SurfTemp  & ! (inout)
   300:                       & )
   301:                   end if
   302:             
   303:                 case ( 'nh00_control-5n' )
   304:                   ! Neale and Hoskins (2000) の control-5n experiment において用いられた SST
   305:                   ! SST used for Control experiment by Neale and Hoskins (2000)
   306:                   !
   307:                   if ( present( xy_SurfTemp ) ) then
   308:                     call NH00SST( &
   309:                       & 'control-5n',& ! (in   )
   310:                       & xy_SurfTemp  & ! (inout)
   311:                       & )
   312:                   end if
   313:             
   314:                 case ( 'nh00_qobs' )
   315:                   ! Neale and Hoskins (2000) の qobs experiment において用いられた SST
   316:                   ! SST used for Control experiment by Neale and Hoskins (2000)
   317:                   !
   318:                   if ( present( xy_SurfTemp ) ) then
   319:                     call NH00SST( &
   320:                       & 'qobs',      & ! (in   )
   321:                       & xy_SurfTemp  & ! (inout)
   322:                       & )
   323:                   end if
   324:             
   325:                 case ( 'nh00_1keq' )
   326:                   ! Neale and Hoskins (2000) の 1keq experiment において用いられた SST
   327:                   ! SST used for Control experiment by Neale and Hoskins (2000)
   328:                   !
   329:                   if ( present( xy_SurfTemp ) ) then
   330:                     call NH00SST( &
   331:                       & '1keq',      & ! (in   )
   332:                       & xy_SurfTemp  & ! (inout)
   333:                       & )
   334:                   end if
   335:             
   336:                 case ( 'nh00_3keq' )
   337:                   ! Neale and Hoskins (2000) の 3keq experiment において用いられた SST
   338:                   ! SST used for Control experiment by Neale and Hoskins (2000)
   339:                   !
   340:                   if ( present( xy_SurfTemp ) ) then
   341:                     call NH00SST( &
   342:                       & '3keq',      & ! (in   )
   343:                       & xy_SurfTemp  & ! (inout)
   344:                       & )
   345:                   end if
   346:             
   347:                 case ( 'nh00_3kw1' )
   348:                   ! Neale and Hoskins (2000) の 3kw1 experiment において用いられた SST
   349:                   ! SST used for Control experiment by Neale and Hoskins (2000)
   350:                   !
   351:                   if ( present( xy_SurfTemp ) ) then
   352:                     call NH00SST( &
   353:                       & '3kw1',      & ! (in   )
   354:                       & xy_SurfTemp  & ! (inout)
   355:                       & )
   356:                   end if
   357:             
   358:                 case ( '1-d profile' )
   359:             
   360:                   if ( present( xy_SurfTemp ) ) then
   361:                     call Set1DProfileSurfTemp( &
   362:                       & xy_SurfTemp &
   363:                       & )
   364:                   end if
   365:             
   366:                 case default
   367:                   call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
   368:                     & c1 = trim(Pattern) )
   369:                 end select
   370:             
   371: W*===== A       if ( present(xy_SurfAlbedo          ) ) xy_SurfAlbedo          = Albedo
   372: W*===== A       if ( present(xy_SurfHumidCoef       ) ) xy_SurfHumidCoef       = HumidCoef
   373: W*===== A       if ( present(xy_SurfRoughLength     ) ) xy_SurfRoughLength     = RoughLength
   374: W*===== A       if ( present(xy_SurfHeatCapacity    ) ) xy_SurfHeatCapacity    = HeatCapacity
   375: W*===== A       if ( present(xy_DeepSubSurfHeatFlux ) ) xy_DeepSubSurfHeatFlux = TempFlux
   376: W*===== A       if ( present(xy_SurfType            ) ) xy_SurfType            = SurfType
   377: W*===== A       if ( present(xy_SurfCond            ) ) xy_SurfCond            = SurfCond
   378: W*===== A       if ( present(xy_SeaIceConc          ) ) xy_SeaIceConc          = SeaIceConc
   379: W*===== A       if ( present(xy_SoilHeatCap         ) ) xy_SoilHeatCap         = SoilHeatCap
   380: W*===== A       if ( present(xy_SoilHeatDiffCoef    ) ) xy_SoilHeatDiffCoef    = SoilHeatDiffCoef
   381: W*===== A       if ( present(xy_SurfHeightStd       ) ) xy_SurfHeightStd       = SurfHeightStd
   382:             
   383:             
   384:               end subroutine SetSurfData
   385:             
   386:               !--------------------------------------------------------------------------------------
   387:             
   388:               subroutine Hosakaetal98SST( &
   389:                 & xy_SurfTemp  & ! (out)
   390:                 & )
   391:                 !
   392:                 ! GCM 用の地表面データを返します.
   393:                 !
   394:                 ! Return surface data for GCM.
   395:                 !
   396:             
   397:                 ! モジュール引用 ; USE statements
   398:                 !
   399:             
   400:                 ! 座標データ設定
   401:                 ! Axes data settings
   402:                 !
   403:                 use axesset, only: &
   404:                   & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   405:             
   406:                 ! 物理・数学定数設定
   407:                 ! Physical and mathematical constants settings
   408:                 !
   409:                 use constants0, only: &
   410:                   & PI                    ! $ \pi $.
   411:                                           ! 円周率. Circular constant
   412:             
   413:                 ! 文字列操作
   414:                 ! Character handling
   415:                 !
   416:                 use dc_string, only: LChar
   417:             
   418:                 ! 宣言文 ; Declaration statements
   419:                 !
   420:                 implicit none
   421:                 real(DP), intent(out) :: xy_SurfTemp (0:imax-1, 1:jmax)
   422:                                           ! 地表面温度. 
   423:                                           ! Surface temperature
   424:             
   425:                 ! 作業変数 (Hosaka et al. (1998))
   426:                 ! Work variables (Hosaka et al. (1998))
   427:                 !
   428:                 real(DP):: TempEq         ! 赤道上 (正確には LatCenter 上) での温度.
   429:                                           ! Temperature on the equator 
   430:                                           ! (on LatCenter, to be exact)
   431:                 real(DP):: LatCenter      ! 温度最高の緯度. 
   432:                                           ! Latitude on which temperature is maximum.
   433:                 real(DP):: LatFlatWidth   ! 温度が平坦化される緯度幅. 
   434:                                           ! Latitude width in which temperature is flattened
   435:                 integer:: jp
   436:                 integer:: jm
   437:             
   438:                 real(DP):: LatA, Alpha, Beta, Gamma
   439:             
   440:                 real(DP):: Phi1, AlphaBeta4, Phi, LatAPlus, LatAMinus
   441:                 real(DP):: SurfTempMx
   442:             
   443:                 ! 作業変数
   444:                 ! Work variables
   445:                 !
   446:             !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   447:             !!$                              ! Work variables for DO loop in longitude
   448:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   449:                                           ! Work variables for DO loop in latitude
   450:             !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   451:             !!$                              ! Work variables for DO loop in vertical direction
   452:             
   453:                 ! 実行文 ; Executable statement
   454:             
   455:                 ! 初期化確認
   456:                 ! Initialization check
   457:                 !
   458:                 if ( .not. surface_data_inited ) then
   459:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   460:                 end if
   461:             
   462:             
   463:                 ! Hosaka et al. (1998) において用いられた SST
   464:                 ! SST used in Hosaka et al. (1998)
   465:                 !
   466:             
   467:             !!$    TempEq       = SurfTemp
   468:                 TempEq       = 302.0_DP
   469:                 LatCenter    =   0.0_DP
   470:                 LatFlatWidth =   7.0_DP
   471:             
   472:                 LatA         =  30.0_DP
   473:                 Alpha        =  60.0_DP
   474:                 Beta         =  32.0_DP
   475:                 Gamma        =   0.0_DP
   476:             
   477:                 Phi1 = abs( LatA * PI / 180.0_DP )
   478:                 AlphaBeta4  = 2.0_DP *( Phi1**3 ) * ( Beta / Alpha )
   479:             
   480: +------>A       do j = 1, jmax
   481: |                 Phi = abs( y_Lat(j) - LatCenter * PI / 180.0_DP )
   482: |V===== A         xy_SurfTemp (:,j) = &
   483: |                   & TempEq &
   484: |                   & - Alpha / 2.0_DP &
   485: |                   &   * ( Phi - max( sqrt( Phi1**2 + AlphaBeta4 ) - sqrt( ( Phi - Phi1 )**2 + AlphaBeta4 ), 0.0_DP ) ) &
   486: |                   & + Gamma * ( Phi**3 )
   487: +------         end do
   488:             
   489:                 ! 中心 LatCenter +/- LatFlatWidth の間を平坦に
   490:                 ! Flatten between LatCenter +/- LatFlatWidth
   491:                 !
   492:                 if ( LatFlatWidth < 0.0_DP ) then
   493:                   LatFlatWidth = - LatFlatWidth
   494:                 end if
   495:                 LatAPlus = ( LatCenter + LatFlatWidth ) * PI / 180.0_DP
   496:                 LatAMinus = ( LatCenter - LatFlatWidth ) * PI / 180.0_DP
   497:             
   498:                 jp = 1
   499:                 jm = jmax
   500: V------>        do j = 1, jmax
   501: |       A         if ( y_Lat(j) <= LatAPlus ) then
   502: |                   jp = j
   503: |                   if ( j == jmax ) jp = jp - 1
   504: |                 end if
   505: |       A         if ( y_Lat(j) < LatAMinus ) then
   506: |                   jm = j
   507: |                   if ( j == jmax ) jm = jm - 1
   508: |                 end if
   509: V------         end do
   510:             
   511:                 if ( jmax /= 1 ) then
   512:                   SurfTempMx = &
   513:                     & (   xy_SurfTemp(0,jm) * ( y_Lat(jm+1) - LatAMinus ) &
   514:                     &   + xy_SurfTemp(0,jm+1) * ( LatAMinus - y_Lat(jm) ) &
   515:                     & ) &
   516:                     & / ( y_Lat(jm+1) - y_Lat(jm) )
   517:             
   518: W*===== A         xy_SurfTemp(:,jm+1:jp) = SurfTempMx
   519:                 end if
   520:             
   521:             
   522:               end subroutine Hosakaetal98SST
   523:             
   524:               !--------------------------------------------------------------------------------------
   525:             
   526:               recursive subroutine NH00SST( &
   527:                 & SSTType,     & ! (in   )
   528:                 & xy_SurfTemp  & ! (inout)
   529:                 & )
   530:                 !
   531:                 ! Set SST described by Neale and Hoskins (2000)
   532:                 !
   533:             
   534:                 ! モジュール引用 ; USE statements
   535:                 !
   536:             
   537:                 ! 座標データ設定
   538:                 ! Axes data settings
   539:                 !
   540:                 use axesset, only: &
   541:                   & x_Lon,         &      ! $ \lambda $ [rad.] . 経度. Longitude
   542:                   & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   543:             
   544:                 ! 物理・数学定数設定
   545:                 ! Physical and mathematical constants settings
   546:                 !
   547:                 use constants0, only: &
   548:                   & PI                    ! $ \pi $.
   549:                                           ! 円周率. Circular constant
   550:             
   551:                 ! 文字列操作
   552:                 ! Character handling
   553:                 !
   554:                 use dc_string, only: LChar
   555:             
   556:                 ! 宣言文 ; Declaration statements
   557:                 !
   558:                 implicit none
   559:                 character(len=*), intent(in   ) :: SSTType
   560:                 real(DP)        , intent(inout) :: xy_SurfTemp (0:imax-1, 1:jmax)
   561:                                           ! 地表面温度.
   562:                                           ! Surface temperature
   563:             
   564:                 ! 作業変数
   565:                 ! Work variables
   566:                 !
   567:                 real(DP) :: Temp0         ! Zero degree Celsius
   568:                                           ! Latitude width in which temperature is flattened
   569:                 real(DP) :: xy_SurfTempTmp1 (0:imax-1, 1:jmax)
   570:                 real(DP) :: xy_SurfTempTmp2 (0:imax-1, 1:jmax)
   571:             
   572:                 real(DP) :: TAmp
   573:                 real(DP) :: LonCen
   574:                 real(DP) :: LonWid
   575:                 real(DP) :: LatWid
   576:             
   577:                 ! 作業変数
   578:                 ! Work variables
   579:                 !
   580:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   581:                                           ! Work variables for DO loop in longitude
   582:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   583:                                           ! Work variables for DO loop in latitude
   584:             !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   585:             !!$                              ! Work variables for DO loop in vertical direction
   586:             
   587:                 ! 実行文 ; Executable statement
   588:             
   589:                 Temp0 = 273.15_DP
   590:             
   591:                 if ( SSTType == 'control' ) then
   592:                   ! Neale and Hoskins (2000) の control experiment において用いられた SST
   593:                   ! SST used for control experiment by Neale and Hoskins (2000)
   594:                   !
   595:             
   596: +------>          do j = 1, jmax
   597: |                   if ( abs( y_Lat(j) ) < PI / 3.0_DP ) then
   598: |V===== A             xy_SurfTemp(:,j) = 27.0_DP * ( 1.0_DP - sin( 3.0_DP * y_Lat(j) / 2.0_DP )**2 )
   599: |                   else
   600: |V===== A             xy_SurfTemp(:,j) = 0.0_DP
   601: |                   end if
   602: +------           end do
   603: +V===== A         xy_SurfTemp = xy_SurfTemp + Temp0
   604:             
   605:             
   606:                 else if ( SSTType == 'peaked' ) then
   607:                   ! Neale and Hoskins (2000) の Peaked experiment において用いられた SST
   608:                   ! SST used for Peaked experiment by Neale and Hoskins (2000)
   609:                   !
   610:             
   611: +------>          do j = 1, jmax
   612: |                   if ( abs( y_Lat(j) ) < PI / 3.0_DP ) then
   613: |V===== A             xy_SurfTemp(:,j) = 27.0_DP * ( 1.0_DP - 3.0_DP * abs( y_Lat(j) ) / PI )
   614: |                   else
   615: |V===== A             xy_SurfTemp(:,j) = 0.0_DP
   616: |                   end if
   617: +------           end do
   618: +V===== A         xy_SurfTemp = xy_SurfTemp + Temp0
   619:             
   620:                 else if ( SSTType == 'flat' ) then
   621:                   ! Neale and Hoskins (2000) の Flat experiment において用いられた SST
   622:                   ! SST used for Flat experiment by Neale and Hoskins (2000)
   623:                   !
   624:             
   625: +------>          do j = 1, jmax
   626: |                   if ( abs( y_Lat(j) ) < PI / 3.0_DP ) then
   627: |V===== A             xy_SurfTemp(:,j) = 27.0_DP * ( 1.0_DP - sin( 3.0_DP * y_Lat(j) / 2.0_DP )**4 )
   628: |                   else
   629: |V===== A             xy_SurfTemp(:,j) = 0.0_DP
   630: |                   end if
   631: +------           end do
   632: +V===== A         xy_SurfTemp = xy_SurfTemp + Temp0
   633:             
   634:                 else if ( SSTType == 'control-5n' ) then
   635:                   ! Neale and Hoskins (2000) の Control-5N experiment において用いられた SST
   636:                   ! SST used for Control-5N experiment by Neale and Hoskins (2000)
   637:                   !
   638:             
   639: +------>          do j = 1, jmax
   640: |                   if ( y_Lat(j) < - PI / 3.0_DP ) then
   641: |V===== A             xy_SurfTemp(:,j) = 0.0_DP
   642: |                   else if ( y_Lat(j) < PI / 36.0_DP ) then
   643: |V===== A             xy_SurfTemp(:,j) = 27.0_DP                                          &
   644: |                       & * ( 1.0_DP - sin( 90.0_DP/65.0_DP * ( y_Lat(j) - PI/36.0_DP ) )**2 )
   645: |                   else if ( y_Lat(j) < PI / 3.0_DP ) then
   646: |V===== A             xy_SurfTemp(:,j) = 27.0_DP                                           &
   647: |                       & * ( 1.0_DP - sin( 90.0_DP/55.0_DP * ( y_Lat(j) - PI/36.0_DP ) )**2 )
   648: |                   else
   649: |V===== A             xy_SurfTemp(:,j) = 0.0_DP
   650: |                   end if
   651: +------           end do
   652: +V===== A         xy_SurfTemp = xy_SurfTemp + Temp0
   653:             
   654:                 else if ( SSTType == 'qobs' ) then
   655:                   ! Neale and Hoskins (2000) の Qobs experiment において用いられた SST
   656:                   ! SST used for Qobs experiment by Neale and Hoskins (2000)
   657:                   !
   658:             
   659:                   call NH00SST( &
   660:                     & 'control',     & ! (in   )
   661:                     & xy_SurfTempTmp1  & ! (inout)
   662:                     & )
   663:                   call NH00SST( &
   664:                     & 'flat',     & ! (in   )
   665:                     & xy_SurfTempTmp2  & ! (inout)
   666:                     & )
   667: +V===== A         xy_SurfTemp = ( xy_SurfTempTmp1 + xy_SurfTempTmp2 ) * 0.5_DP
   668:             
   669:                 else if ( SSTType == '1keq' ) then
   670:                   ! Neale and Hoskins (2000) の 1KEQ experiment において用いられた SST
   671:                   ! SST used for 1KEQ experiment by Neale and Hoskins (2000)
   672:                   !
   673:             
   674:                   call NH00SST( &
   675:                     & 'control',     & ! (in   )
   676:                     & xy_SurfTemp  & ! (inout)
   677:                     & )
   678:             
   679:                   TAmp   =   1.0_DP
   680:                   LonCen = 180.0_DP * PI / 180.0_DP
   681:                   LonWid =  30.0_DP * PI / 180.0_DP
   682:                   LatWid =  15.0_DP * PI / 180.0_DP
   683: +------>          do j = 1, jmax
   684: |V----->            do i = 0, imax-1
   685: ||      A             if ( ( abs( x_Lon(i) - LonCen ) < LonWid ) .and. &
   686: ||                      &  ( abs( y_Lat(j)          ) < LatWid ) ) then
   687: ||      A               xy_SurfTemp(i,j) = xy_SurfTemp(i,j)                              &
   688: ||                        & + TAmp * cos( PI/2.0_DP * ( x_Lon(i) - LonCen ) / LonWid )**2 &
   689: ||                        &        * cos( PI/2.0_DP * y_Lat(j)              / LatWid )**2
   690: ||                    end if
   691: |V----- A           end do
   692: +------           end do
   693:             
   694:                 else if ( SSTType == '3keq' ) then
   695:                   ! Neale and Hoskins (2000) の 3KEQ experiment において用いられた SST
   696:                   ! SST used for 1KEQ experiment by Neale and Hoskins (2000)
   697:                   !
   698:             
   699:                   call NH00SST( &
   700:                     & 'control',     & ! (in   )
   701:                     & xy_SurfTemp  & ! (inout)
   702:                     & )
   703:             
   704:                   TAmp   =   3.0_DP
   705:                   LonCen = 180.0_DP * PI / 180.0_DP
   706:                   LonWid =  30.0_DP * PI / 180.0_DP
   707:                   LatWid =  15.0_DP * PI / 180.0_DP
   708: +------>          do j = 1, jmax
   709: |V----->            do i = 0, imax-1
   710: ||      A             if ( ( abs( x_Lon(i) - LonCen ) < LonWid ) .and. &
   711: ||                      &  ( abs( y_Lat(j)          ) < LatWid ) ) then
   712: ||      A               xy_SurfTemp(i,j) = xy_SurfTemp(i,j)                              &
   713: ||                        & + TAmp * cos( PI/2.0_DP * ( x_Lon(i) - LonCen ) / LonWid )**2 &
   714: ||                        &        * cos( PI/2.0_DP * y_Lat(j)              / LatWid )**2
   715: ||                    end if
   716: |V----- A           end do
   717: +------           end do
   718:             
   719:                 else if ( SSTType == '3kw1' ) then
   720:                   ! Neale and Hoskins (2000) の 3KW1 experiment において用いられた SST
   721:                   ! SST used for 1KEQ experiment by Neale and Hoskins (2000)
   722:                   !
   723:             
   724:                   call NH00SST( &
   725:                     & 'control',     & ! (in   )
   726:                     & xy_SurfTemp  & ! (inout)
   727:                     & )
   728:             
   729:                   TAmp   =   3.0_DP
   730:                   LonCen = 180.0_DP * PI / 180.0_DP
   731:                   LatWid =  30.0_DP * PI / 180.0_DP
   732: +------>          do j = 1, jmax
   733: |V----->            do i = 0, imax-1
   734: ||                    if ( abs( y_Lat(j) ) < LatWid ) then
   735: ||      A               xy_SurfTemp(i,j) = xy_SurfTemp(i,j)                  &
   736: ||                        & + TAmp * cos( x_Lon(i) - LonCen )                &
   737: ||                        &        * cos( PI/2.0_DP * y_Lat(j) / LatWid )**2
   738: ||                    end if
   739: |V-----             end do
   740: +------           end do
   741:             
   742:                 else
   743:                   call MessageNotify( 'E', module_name, 'SSTType=<%c> is invalid.', &
   744:                     & c1 = trim(SSTType) )
   745:                 end if
   746:             
   747:             
   748:               end subroutine NH00SST
   749:             
   750:               !--------------------------------------------------------------------------------------
   751:             
   752:               subroutine SurfDataInit
   753:             
   754:                 ! モジュール引用 ; USE statements
   755:                 !
   756:             
   757:                 ! NAMELIST ファイル入力に関するユーティリティ
   758:                 ! Utilities for NAMELIST file input
   759:                 !
   760:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   761:             
   762:                 ! ファイル入出力補助
   763:                 ! File I/O support
   764:                 !
   765:                 use dc_iounit, only: FileOpen
   766:             
   767:                 ! 文字列操作
   768:                 ! Character handling
   769:                 !
   770:                 use dc_string, only: LChar
   771:             
   772:                 ! ファイルから 1 次元プロファイルを読んで設定する.
   773:                 ! read 1-D profile from a file and set it
   774:                 !
   775:                 use set_1d_profile, only : Set1DProfileInit
   776:             
   777:             
   778:                 ! 宣言文 ; Declaration statements
   779:                 !
   780:                 implicit none
   781:             
   782:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   783:                                           ! Unit number for NAMELIST file open
   784:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   785:                                           ! IOSTAT of NAMELIST read
   786:             
   787:                 ! NAMELIST 変数群
   788:                 ! NAMELIST group name
   789:                 !
   790:                 namelist /surface_data_nml/ Pattern,            &
   791:                   & SurfTemp, Albedo, HumidCoef, RoughLength,   &
   792:                   & HeatCapacity, TempFlux, SurfType, SurfCond, &
   793:                   & SeaIceConc,                                 &
   794:                   & SoilHeatCap, SoilHeatDiffCoef,              &
   795:                   & SurfHeightStd
   796:                       !
   797:                       ! デフォルト値については初期化手続 "surface_data#SurfDataInit" 
   798:                       ! のソースコードを参照のこと. 
   799:                       !
   800:                       ! Refer to source codes in the initialization procedure
   801:                       ! "surface_data#SurfDataInit" for the default values. 
   802:                       !
   803:             
   804:             
   805:                 ! 実行文 ; Executable statement
   806:             
   807:                 if ( surface_data_inited ) return
   808:             
   809:             
   810:                 ! デフォルト値の設定 (まずは Pattern のみ)
   811:                 ! Default values settings (At first, "Pattern" only)
   812:                 !
   813:             !!$    Pattern      = 'Hosaka et al. (1998)'
   814:                 Pattern      = 'homogeneous'
   815:                 SurfTemp     = 273.15_DP
   816:                 Albedo       = 0.15_DP
   817:                 HumidCoef    = 1.0_DP
   818:                 RoughLength  = 1.0e-4_DP
   819:                 HeatCapacity = 0.0_DP
   820:                 TempFlux     = 0.0_DP
   821:                 SurfType     = 0
   822:                 SurfCond     = 0
   823:                 SeaIceConc   = 0.0_DP
   824:             
   825:                 SoilHeatCap      = 2.1e6_DP
   826:                 !   volumetric heat capacity (J m-3 K-1)
   827:                 !   Value of Clay for porosity f=0.4, volumetric wetness theta=0.2 in Table 12.3 by
   828:                 !   Hillel (2004).
   829:                 !   Note that the unit of Table 12.3 of Hillel (2004) would be wrong. Although the
   830:                 !   unit in the Table is wrong, the volumetric heat capacity of 2.1d6 J m-3 K-1 is
   831:                 !   within the range of typical value of it.
   832:             
   833:                 SoilHeatDiffCoef = 1.2e0_DP
   834:                 !   thermal conductivity (W m-1 K-1)
   835:                 !   Value of Clay for porosity f=0.4, volumetric wetness theta=0.2 in Table 12.3 by
   836:                 !   Hillel (2004).
   837:             
   838:                 !   Reference
   839:                 !
   840:                 !   Hillet, D.,
   841:                 !     Introduction to Environmental Soil Physics,
   842:                 !     Elsevier Academic Press, pp494, 2004.
   843:             
   844:             
   845:                 !   Sample values for Mars
   846:                 !     These values were obtained from Kiefer (1976) and Kieffer et al. (1977).
   847:                 !   Reference
   848:                 !     Kieffer, Science, 194, 1344-1346, 1976.
   849:                 !     Kieffer et al., JGR, 82, 4249-4291, 1977.
   850:                 !
   851:                 !   Standard model: see Kieffer et al. (1977) p. 4286,
   852:                 !   albedo,                 A   = 0.25
   853:                 !     (Kieffer et al., 1977)
   854:                 !   thermal inertia,        I   = 6.5e-3 cal cm-2 s-1/2 K-1 = 272 J m-2 s-1/2 K-1
   855:                 !     (Kieffer et al., 1977)
   856:                 !   density,                rho = 1.65 g cm-3 = 1650 kg m-3
   857:                 !     (Kieffer, 1976)
   858:                 !   specific heat,          cp  = 0.14 cal g-1 K-1 = 586 J kg-1 K-1
   859:                 !     (Kieffer, 1976)
   860:                 !
   861:                 !   heat capacity,          cp*rho = 0.97e6 J m-3 K-1
   862:                 !   conduction coefficient, k = I**2 / (cp*rho) = 7.6e-2   J m-1 s-1 K-1
   863:                 !
   864:             !!$    SoilHeatCap      = 0.97d6
   865:             !!$    SoilHeatDiffCoef = 0.076d0
   866:             
   867:                 ! NOTE:
   868:                 !   Values by Kieffer (1976) and Kieffer et al. (1977) would be appropriate for GCM
   869:                 !   experiment.
   870:             
   871:             
   872:                 !   Sample values for Mars
   873:                 !     These values were obtained from Savijarvi (1995).
   874:                 !   Reference
   875:                 !     Savijarvi, H., Mars boundary layer modeling: Diurnal moisture cycle and soil
   876:                 !       properties at the Viking lander 1 site, Icarus, 117, 120-127, 1995.
   877:                 !
   878:             !!$    SoilHeatCap      = 0.8d6
   879:             !!$    SoilHeatDiffCoef = 0.18d0
   880:             
   881:             
   882:                 SurfHeightStd = 0.0_DP
   883:             
   884:             
   885:                 ! NAMELIST の読み込み (まずは Pattern のみ)
   886:                 ! NAMELIST is input (At first, "Pattern" only)
   887:                 !
   888:                 if ( trim(namelist_filename) /= '' ) then
   889:                   call FileOpen( unit_nml, &          ! (out)
   890:                     & namelist_filename, mode = 'r' ) ! (in)
   891:             
   892:                   rewind( unit_nml )
   893:                   read( unit_nml, &             ! (in)
   894:                     & nml = surface_data_nml, & ! (out)
   895:                     & iostat = iostat_nml )     ! (out)
   896:                   close( unit_nml )
   897:             
   898:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   899:                 end if
   900:             
   901:             
   902:                 ! NAMELIST の読み込み
   903:                 ! NAMELIST is input
   904:                 !
   905:                 if ( trim(namelist_filename) /= '' ) then
   906:                   call FileOpen( unit_nml, &          ! (out)
   907:                     & namelist_filename, mode = 'r' ) ! (in)
   908:             
   909:                   rewind( unit_nml )
   910:                   read( unit_nml, &             ! (in)
   911:                     & nml = surface_data_nml, & ! (out)
   912:                     & iostat = iostat_nml )     ! (out)
   913:                   close( unit_nml )
   914:             
   915:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   916:                 end if
   917:             
   918:             
   919:                 ! ファイルから 1 次元プロファイルを読んで設定する.
   920:                 ! read 1-D profile from a file and set it
   921:                 !
   922:                 call Set1DProfileInit
   923:             
   924:             
   925:                 ! 印字 ; Print
   926:                 !
   927:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   928:                 call MessageNotify( 'M', module_name, '  Pattern          = %c', c1 = trim(Pattern) )
   929:                 call MessageNotify( 'M', module_name, '  SurfTemp         = %f', d = (/ SurfTemp         /) )
   930:                 call MessageNotify( 'M', module_name, '  Albedo           = %f', d = (/ Albedo           /) )
   931:                 call MessageNotify( 'M', module_name, '  HumidCoef        = %f', d = (/ HumidCoef        /) )
   932:                 call MessageNotify( 'M', module_name, '  RoughLength      = %f', d = (/ RoughLength      /) )
   933:                 call MessageNotify( 'M', module_name, '  HeatCapacity     = %f', d = (/ HeatCapacity     /) )
   934:                 call MessageNotify( 'M', module_name, '  TempFlux         = %f', d = (/ TempFlux         /) )
   935:                 call MessageNotify( 'M', module_name, '  SurfType         = %d', i = (/ SurfType         /) )
   936:                 call MessageNotify( 'M', module_name, '  SurfCond         = %d', i = (/ SurfCond         /) )
   937:                 call MessageNotify( 'M', module_name, '  SeaIceConc       = %f', d = (/ SeaIceConc       /) )
   938:                 call MessageNotify( 'M', module_name, '  SoilHeatCap      = %f', d = (/ SoilHeatCap      /) )
   939:                 call MessageNotify( 'M', module_name, '  SoilHeatDiffCoef = %f', d = (/ SoilHeatDiffCoef /) )
   940:                 call MessageNotify( 'M', module_name, '  SurfHeightStd    = %f', d = (/ SurfHeightStd /) )
   941:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   942:             
   943:                 surface_data_inited = .true.
   944:             
   945:               end subroutine SurfDataInit
   946:             
   947:               !--------------------------------------------------------------------------------------
   948:             
   949:             end module surface_data
