Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:58 2016
FILE NAME: ckd_module.f90
PROGRAM NAME: ckd_module
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   188  vec  (   3): Unvectorized loop.
   188  vec  (  13): Overhead of loop division is too large.
   189  opt  (1017): Subroutine call prevents optimization.
   189  vec  (  17): Unvectorizable statement.
   190  vec  (  22): Dependency unknown. Unvectorizable dependency is assumed.:ig
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:58 2016
FILE NAME: ckd_module.f90
PROGRAM NAME: ckd_module
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  module ckd_module
     2  
     3    ! 種別型パラメタ
     4    ! Kind type parameter
     5    !
     6    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
     7      &                 STRING, &  ! 文字列.       Strings.
     8      &                 TOKEN      ! キーワード.   Keywords.
     9  
    10  
    11    ! 宣言文 ; Declaration statements
    12    !
    13    implicit none
    14    private
    15  
    16  
    17    ! 公開手続き
    18    ! Public procedure
    19    !
    20    public:: ckd_input
    21  
    22    ! 公開変数
    23    ! Public variables
    24    !
    25  
    26    ! The structure of bandparam structure may be inappropriate, for this cannot be used
    27    ! for multiple radiatively active species.
    28    ! Maybe,
    29    !   * imol has to be 1D array,
    30    !   * lnac has to be 4D array.
    31    ! (yot, 2010/09/12)
    32    !
    33    type bandparam
    34      integer           :: imol
    35      integer           :: ng, nlnp, nt
    36      real(DP)          :: wnbnds( 2 )
    37      real(DP), pointer :: weight( : )
    38      real(DP), pointer :: lnac  ( :, :, : )
    39      real(DP), pointer :: pfr   ( :, :, : )
    40      real(DP), pointer :: g( : ), lnp( : ), t( : )
    41      real(DP), pointer :: g_ll( : ), g_ul( : )
    42    end type bandparam
    43  
    44    integer                     , save :: nband
    45    type(bandparam), allocatable, save :: ckdp( : )
    46  
    47  
    48    public :: bandparam, nband, ckdp
    49  
    50  
    51    !--------------------------------------------------------------------------------------
    52  
    53  contains
    54  
    55    !--------------------------------------------------------------------------------------
    56  
    57    subroutine ckd_input( &
    58      & ncfn & ! (in)
    59      & )
    60  
    61      use netcdf_wrapper, only : &
    62        & NWInqDimLen, &
    63        & NWGetAtt
    64  
    65      ! gtool データ入力
    66      ! Gtool data input
    67      !
    68      use gtool_history, only: HistoryGet
    69  
    70  
    71      character(*), intent(in) :: ncfn
    72  
    73      !
    74      ! local variables
    75      !
    76      character(STRING) :: comment
    77      character(STRING) :: name_weight
    78      character(STRING) :: name_g
    79      character(STRING) :: name_lnac
    80      character(STRING) :: name_pfr
    81      character(STRING) :: name_bnds
    82  
    83      integer           :: iband, ig
    84  
    85      logical           :: flag_mpi_init = .false.
    86  
    87  
    88      write( 6, * ) 'Read ', trim( ncfn )
    89  
    90      call NWGetAtt( ncfn, 'global', 'comment', comment )
    91  
    92      call NWGetAtt( ncfn, 'global', 'nband'  , nband   )
    93  
    94  
    95      allocate( ckdp( nband ) )
    96  
    97      do iband = 1, nband
    98        write( 6, * ) 'band ', iband
    99  
   100        call NWGetAtt( ncfn, 'global', 'imol', ckdp(iband)%imol )
   101  
   102        write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
   103        write( name_weight, '(a,i4.4)' ) "weight_", iband
   104        write( name_g     , '(a,i4.4)' ) "g_"     , iband
   105        write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
   106        write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
   107  
   108        call NWInqDimLen(        &
   109          & ncfn,                & ! (in )
   110          & name_g,              & ! (in )
   111          & ckdp( iband ) % ng   & ! (out)
   112          & )
   113        call NWInqDimLen(        &
   114          & ncfn,                & ! (in )
   115          & 't',                 & ! (in )
   116          & ckdp( iband ) % nt   & ! (out)
   117          & )
   118        call NWInqDimLen(        &
   119          & ncfn,                & ! (in )
   120          & 'lnp',               & ! (in )
   121          & ckdp( iband ) % nlnp & ! (out)
   122          & )
   123  
   124  
   125        allocate( &
   126          & ckdp( iband ) % weight( ckdp( iband ) % ng   ), &
   127          & ckdp( iband ) % g     ( ckdp( iband ) % ng   ), &
   128          & ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
   129          & ckdp( iband ) % t     ( ckdp( iband ) % nt   )  &
   130          & )
   131  
   132        allocate( &
   133          & ckdp( iband ) % lnac( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
   134          & )
   135        allocate( &
   136          & ckdp( iband ) % pfr ( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
   137          & )
   138  
   139  
   140        call HistoryGet(                      &
   141          & ncfn,                             &
   142          & name_weight,                      &
   143          & ckdp(iband)%weight,               &
   144          & flag_mpi_split = flag_mpi_init    &
   145          & )
   146        call HistoryGet(                      &
   147          & ncfn,                             &
   148          & name_g,                           &
   149          & ckdp(iband)%g,                    &
   150          & flag_mpi_split = flag_mpi_init    &
   151          & )
   152        call HistoryGet(                      &
   153          & ncfn,                             &
   154          & 'lnp',                            &
   155          & ckdp(iband)%lnp,                  &
   156          & flag_mpi_split = flag_mpi_init    &
   157          & )
   158        call HistoryGet(                      &
   159          & ncfn,                             &
   160          & 't',                              &
   161          & ckdp(iband)%t,                    &
   162          & flag_mpi_split = flag_mpi_init    &
   163          & )
   164        call HistoryGet(                      &
   165          & ncfn,                             &
   166          & name_bnds,                        &
   167          & ckdp(iband)%wnbnds,               &
   168          & flag_mpi_split = flag_mpi_init    &
   169          & )
   170        call HistoryGet(                      &
   171          & ncfn,                             &
   172          & name_lnac,                        &
   173          & ckdp(iband)%lnac,                 &
   174          & flag_mpi_split = flag_mpi_init    &
   175          & )
   176        call HistoryGet(                      &
   177          & ncfn,                             &
   178          & name_pfr,                         &
   179          & ckdp(iband)%pfr,                  &
   180          & flag_mpi_split = flag_mpi_init    &
   181          & )
   182  
   183  
   184        write( 6, * ) 'band ', iband
   185        write( 6, * ) '  wns  = ', ckdp(iband)%wnbnds(1)
   186        write( 6, * ) '  wne  = ', ckdp(iband)%wnbnds(2)
   187        write( 6, * ) '  ng   = ', ckdp(iband)%ng
   188        do ig = 1, ckdp(iband)%ng
   189          write( 6, * ) '     g(', ig, ') = ', ckdp(iband)%g(ig)
   190        end do
   191        write( 6, * ) '  nlnp = ', ckdp(iband)%nlnp
   192        write( 6, * ) '  nt   = ', ckdp(iband)%nt
   193      end do
   194  
   195  
   196    end subroutine ckd_input
   197  
   198  !!$#ifdef ZZZZZZZZZ
   199  !!$    !**************************************************************************
   200  !!$#ifndef NOUSE_NETCDF
   201  !!$    !**************************************************************************
   202  !!$
   203  !!$    subroutine ckd_mktbl_init
   204  !!$
   205  !!$      use fi_module
   206  !!$      use ni3_module
   207  !!$
   208  !!$      !
   209  !!$      ! local variables
   210  !!$      !
   211  !!$      integer(i4b)              :: k, incf, iband, iwn, iras
   212  !!$      real(dp)    , allocatable :: l_wn( : ), l_plev( : ), l_imol( : ), l_t( : )
   213  !!$      real(dp)                  :: wns, wne
   214  !!$      integer(i4b)              :: ng
   215  !!$      real(dp)    , allocatable :: wnbnds_s( : ), wnbnds_e( : ), ngdiv( : )
   216  !!$      character(len=extstr)     :: fn
   217  !!$      integer(i4b)              :: ctlfu, ios
   218  !!$
   219  !!$
   220  !!$      namelist /input_ac/    fn
   221  !!$      namelist /bandnum/  nband
   222  !!$      namelist /bandinfo/ wns, wne, ng
   223  !!$
   224  !!$
   225  !!$      call fi_open( ctlfn, "read", ctlfu )
   226  !!$      nncfile = 0
   227  !!$      do
   228  !!$         read( ctlfu, input_ac, iostat = ios )
   229  !!$         if( ios .ne. 0 ) exit
   230  !!$         nncfile = nncfile + 1
   231  !!$      end do
   232  !!$      allocate( ncfn( nncfile ), ncid( nncfile ) )
   233  !!$      rewind( ctlfu )
   234  !!$      do incf = 1, nncfile
   235  !!$         read( ctlfu, input_ac )
   236  !!$         ncfn( incf ) = fn
   237  !!$         write( 6, * ) 'Input file ', incf, ' : ', trim( ncfn( incf ) )
   238  !!$      end do
   239  !!$      !
   240  !!$      rewind( ctlfu )
   241  !!$      read( ctlfu, bandnum )
   242  !!$      allocate( wnbnds_s( nband ), wnbnds_e( nband ), ngdiv( nband ) )
   243  !!$      rewind( ctlfu )
   244  !!$      do iband = 1, nband
   245  !!$         read( ctlfu, bandinfo )
   246  !!$         write( 6, * ) 'Band range       : ', wns, wne
   247  !!$         write( 6, * ) 'Band subinterval : ', ng
   248  !!$         wnbnds_s( iband ) = wns
   249  !!$         wnbnds_e( iband ) = wne
   250  !!$         ngdiv   ( iband ) = ng
   251  !!$         if( iband .ge. 2 ) then
   252  !!$            if( wnbnds_s( iband ) .ne. wnbnds_e( iband-1 ) ) then
   253  !!$               write( 6, * ) 'Band range is inappropriate.'
   254  !!$               write( 6, * ) iband, wnbnds_s( iband ), wnbnds_e( iband-1 )
   255  !!$               stop
   256  !!$            end if
   257  !!$         end if
   258  !!$      end do
   259  !!$      close( ctlfu )
   260  !!$
   261  !!$
   262  !!$      tm = nncfile
   263  !!$      allocate( temp( tm ) )
   264  !!$
   265  !!$      do incf = 1, nncfile
   266  !!$         call ni3_open( ncfn( incf ), "read", ncid( incf ) )
   267  !!$
   268  !!$         if( incf .eq. 1 ) then
   269  !!$            call ni3_inq_dimlen( ncid( incf ), "wn"  , nwn  )
   270  !!$            call ni3_inq_dimlen( ncid( incf ), "plev", km   )
   271  !!$            call ni3_inq_dimlen( ncid( incf ), "imol", nras )
   272  !!$            allocate( wn( nwn ), plev( km ), imol( nras ) )
   273  !!$            call ni3_get_var( ncid( incf ), "wn"  , wn   )
   274  !!$            call ni3_get_var( ncid( incf ), "plev", plev )
   275  !!$            call ni3_get_var( ncid( incf ), "imol", imol )
   276  !!$
   277  !!$            !
   278  !!$            ! quality check
   279  !!$            !
   280  !!$            if(  ( wn(1  )-(wn(2)-wn(1))*0.5d0 .ne. wnbnds_s( 1     ) ) .or. &
   281  !!$                 ( wn(nwn)+(wn(2)-wn(1))*0.5d0 .ne. wnbnds_e( nband ) ) ) then
   282  !!$               write( 6, * ) 'Unexpectected wavenumber range'
   283  !!$               write( 6, * ) wn( 1   ), wnbnds_s( 1     )
   284  !!$               write( 6, * ) wn( nwn ), wnbnds_e( nband )
   285  !!$               stop
   286  !!$            end if
   287  !!$            do k = 1, km
   288  !!$               if( plev( k ) .le. 0.0d0 ) then
   289  !!$                  write( 6, * ) 'Unexpected zero or negative pressure.'
   290  !!$                  write( 6, * ) k, plev( k )
   291  !!$                  stop
   292  !!$               end if
   293  !!$            end do
   294  !!$
   295  !!$            allocate( l_wn( nwn ), l_plev( km ), l_imol( nras ), l_t( km ) )
   296  !!$         end if
   297  !!$
   298  !!$         call ni3_get_var( ncid( incf ), "wn", l_wn )
   299  !!$         do iwn = 1, nwn
   300  !!$            if( wn( iwn ) .ne. l_wn( iwn ) ) then
   301  !!$               write( 6, * ) 'wavenumber is not identical.'
   302  !!$               write( 6, * ) iwn, wn( iwn ), l_wn( iwn )
   303  !!$               stop
   304  !!$            end if
   305  !!$         end do
   306  !!$
   307  !!$
   308  !!$         !
   309  !!$         ! quality check
   310  !!$         !
   311  !!$         call ni3_get_var( ncid( incf ), "plev", l_plev )
   312  !!$         do k = 1, km
   313  !!$            if( plev( k ) .le. 0.0d0 ) then
   314  !!$               write( 6, * ) 'Unexpected zero or negative pressure.'
   315  !!$               write( 6, * ) k, plev( k )
   316  !!$               stop
   317  !!$            end if
   318  !!$            if( plev( k ) .ne. l_plev( k ) ) then
   319  !!$               write( 6, * ) 'pressure level is not identical.'
   320  !!$               write( 6, * ) k, plev( k ), l_plev( k )
   321  !!$               stop
   322  !!$            end if
   323  !!$         end do
   324  !!$
   325  !!$         call ni3_get_var( ncid( incf ), "imol", l_imol )
   326  !!$         do iras = 1, nras
   327  !!$            if( imol( iras ) .ne. l_imol( iras ) ) then
   328  !!$               write( 6, * ) 'molecular number is not identical.'
   329  !!$               write( 6, * ) iras, imol( iras ), l_imol( iras )
   330  !!$               stop
   331  !!$            end if
   332  !!$         end do
   333  !!$
   334  !!$         call ni3_get_var( ncid( incf ), "t", l_t )
   335  !!$         do k = 1+1, km
   336  !!$            if( l_t( k ) .ne. l_t( 1 ) ) then
   337  !!$               write( 6, * ) 'temperature is not isothermal.'
   338  !!$               write( 6, * ) k, l_t( k ), l_t( 1 )
   339  !!$               stop
   340  !!$            end if
   341  !!$         end do
   342  !!$         temp( incf ) = l_t( 1 )
   343  !!$         if( incf .ge. 2 ) then
   344  !!$            if( temp( incf ) .le. temp( incf-1 ) ) then
   345  !!$               write( 6, * ) 'Order of files is inappropriate.'
   346  !!$               write( 6, * ) incf, temp( incf-1 ), temp( incf )
   347  !!$               stop
   348  !!$            end if
   349  !!$         end if
   350  !!$
   351  !!$      end do
   352  !!$
   353  !!$      deallocate( l_wn, l_plev, l_t )
   354  !!$
   355  !!$
   356  !!$      allocate( ckdp( nband ) )
   357  !!$
   358  !!$
   359  !!$      iras = 1
   360  !!$
   361  !!$
   362  !!$      do iband = 1, nband
   363  !!$
   364  !!$         ckdp( iband ) % imol        = imol( iras )
   365  !!$
   366  !!$         ckdp( iband ) % wnbnds( 1 ) = wnbnds_s( iband )
   367  !!$         ckdp( iband ) % wnbnds( 2 ) = wnbnds_e( iband )
   368  !!$
   369  !!$
   370  !!$         ckdp( iband ) % ng   = ngdiv( iband )
   371  !!$         ckdp( iband ) % nlnp = km
   372  !!$         ckdp( iband ) % nt   = tm
   373  !!$
   374  !!$         allocate( &
   375  !!$              ckdp( iband ) % weight( ckdp( iband ) % ng   ), &
   376  !!$              ckdp( iband ) % g     ( ckdp( iband ) % ng   ), &
   377  !!$              ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
   378  !!$              ckdp( iband ) % t     ( ckdp( iband ) % nt   )  &
   379  !!$              )
   380  !!$
   381  !!$         allocate( &
   382  !!$              ckdp( iband ) % g_ll  ( ckdp( iband ) % ng   ), &
   383  !!$              ckdp( iband ) % g_ul  ( ckdp( iband ) % ng   )  &
   384  !!$              )
   385  !!$
   386  !!$         allocate( &
   387  !!$              ckdp( iband ) % lnac( ckdp(iband)%ng  ,  &
   388  !!$                                    ckdp(iband)%nlnp,  &
   389  !!$                                    ckdp(iband)%nt   ) &
   390  !!$              )
   391  !!$         allocate( &
   392  !!$              ckdp( iband ) % pfr ( ckdp(iband)%ng  ,  &
   393  !!$                                    ckdp(iband)%nlnp,  &
   394  !!$                                    ckdp(iband)%nt   ) &
   395  !!$              )
   396  !!$
   397  !!$
   398  !!$         ckdp( iband ) % lnp( : ) = log( plev( : ) )
   399  !!$         ckdp( iband ) % t  ( : ) = temp( : )
   400  !!$
   401  !!$      end do
   402  !!$
   403  !!$
   404  !!$      deallocate( wnbnds_s, wnbnds_e, ngdiv )
   405  !!$
   406  !!$
   407  !!$    end subroutine ckd_mktbl_init
   408  !!$
   409  !!$    !**************************************************************************
   410  !!$
   411  !!$    subroutine ckd_mktbl_end
   412  !!$
   413  !!$      use ni3_module
   414  !!$
   415  !!$      !
   416  !!$      ! local variables
   417  !!$      !
   418  !!$      integer(i4b) :: incf, iband
   419  !!$
   420  !!$
   421  !!$      do incf = 1, nncfile
   422  !!$         call ni3_close( ncid( incf ) )
   423  !!$      end do
   424  !!$
   425  !!$
   426  !!$      deallocate( ncfn, ncid )
   427  !!$      deallocate( temp )
   428  !!$      deallocate( wn, plev, imol )
   429  !!$
   430  !!$
   431  !!$      call ckd_deallocate_type
   432  !!$
   433  !!$
   434  !!$    end subroutine ckd_mktbl_end
   435  !!$
   436  !!$    !**************************************************************************
   437  !!$
   438  !!$    subroutine ckd_deallocate_type
   439  !!$
   440  !!$
   441  !!$      !
   442  !!$      ! local variables
   443  !!$      !
   444  !!$      integer(i4b) :: iband
   445  !!$
   446  !!$
   447  !!$      do iband = 1, nband
   448  !!$         deallocate( ckdp( iband ) % weight, &
   449  !!$                     ckdp( iband ) % g     , &
   450  !!$                     ckdp( iband ) % lnp   , &
   451  !!$                     ckdp( iband ) % t     )
   452  !!$         deallocate( ckdp( iband ) % lnac )
   453  !!$         deallocate( ckdp( iband ) % pfr  )
   454  !!$      end do
   455  !!$
   456  !!$      deallocate( ckdp )
   457  !!$
   458  !!$
   459  !!$      nband = -1
   460  !!$
   461  !!$
   462  !!$    end subroutine ckd_deallocate_type
   463  !!$
   464  !!$    !**************************************************************************
   465  !!$
   466  !!$    subroutine ckd_mktbl
   467  !!$
   468  !!$      use ni3_module
   469  !!$      use pf_module
   470  !!$      use sort_module
   471  !!$
   472  !!$
   473  !!$      !
   474  !!$      ! local varialbles
   475  !!$      !
   476  !!$
   477  !!$      real(dp)             , allocatable :: ac_1d( : ), pf_1d( : )
   478  !!$
   479  !!$      real(dp)                           :: wns, wne
   480  !!$
   481  !!$      real(dp)             , allocatable :: ac_i( : )
   482  !!$      real(dp)             , allocatable :: pfrat( : )
   483  !!$
   484  !!$
   485  !!$      integer(i4b)                       :: k, incf, iband, iras, ig
   486  !!$      integer(i4b)                       :: iwn
   487  !!$      integer(i4b)                       :: iwns, iwne
   488  !!$
   489  !!$
   490  !!$
   491  !!$      iras = 1
   492  !!$
   493  !!$      do iband = 1, nband
   494  !!$         wns = ckdp( iband ) % wnbnds( 1 )
   495  !!$         wne = ckdp( iband ) % wnbnds( 2 )
   496  !!$
   497  !!$
   498  !!$         call search_wnindices( nwn, wn, wns, wne, iwns, iwne )
   499  !!$         write( 6, *             ) &
   500  !!$              'band ', iband, ' : wns = ', wns, ', wne = ', wne
   501  !!$         write( 6, '(a,i10,a,f)' ) '  wn( ', iwns, ') = ', wn( iwns )
   502  !!$         write( 6, '(a,i10,a,f)' ) '  wn( ', iwne, ') = ', wn( iwne )
   503  !!$
   504  !!$
   505  !!$         allocate( ac_1d( iwne - iwns + 1 ) )
   506  !!$         allocate( pf_1d( iwne - iwns + 1 ) )
   507  !!$         allocate( ac_i ( ckdp( iband ) % ng ) )
   508  !!$         allocate( pfrat( ckdp( iband ) % ng ) )
   509  !!$
   510  !!$
   511  !!$
   512  !!$
   513  !!$!         do ig = 1, ckdp( iband ) % ng
   514  !!$!#if defined CONST_WEIGHT || defined THROUGH
   515  !!$!            ckdp( iband ) % g     ( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
   516  !!$!                 * ( dble( ig - 1 ) + 0.5d0 )
   517  !!$!            ckdp( iband ) % weight( ig ) = 1.0d0 / dble( ckdp( iband ) % ng )
   518  !!$!#else
   519  !!$!            call gauleg( 0.0d0, 1.0d0, &
   520  !!$!                 ckdp(iband)%ng, ckdp(iband)%g, ckdp(iband)%weight )
   521  !!$!#endif
   522  !!$!         end do
   523  !!$
   524  !!$         call set_g( iband, iwns, iwne, iras )
   525  !!$
   526  !!$
   527  !!$
   528  !!$
   529  !!$         do incf = 1, nncfile
   530  !!$
   531  !!$            do k = 1, km
   532  !!$
   533  !!$               call readac( ncid( incf ), iwne-iwns+1, ac_1d, iras, k, iwns, iwne )
   534  !!$
   535  !!$               do iwn = 1, iwne-iwns+1
   536  !!$                  pf_1d( iwn ) = pf( wn( iwn+iwns-1 ), temp( incf ) )
   537  !!$               end do
   538  !!$
   539  !!$
   540  !!$!            if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
   541  !!$!               do iwn = 1, iwne-iwns+1
   542  !!$!                  write( 60, * ) wn( iwns-1+iwn ) * 1.0d-2, &
   543  !!$!                       ac_1d( iwn ), pf_1d( iwn )
   544  !!$!               end do
   545  !!$!            end if
   546  !!$
   547  !!$
   548  !!$#ifdef THROUGH
   549  !!$#ifdef THROUGH_SORT
   550  !!$               call sort_quick( iwne-iwns+1, ac_1d, pf_1d )
   551  !!$#endif
   552  !!$#else
   553  !!$               call sort_quick( iwne-iwns+1, ac_1d, pf_1d )
   554  !!$#endif
   555  !!$
   556  !!$
   557  !!$!            if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
   558  !!$!               do iwn = 1, iwne-iwns+1
   559  !!$!                  write( 61, * ) dble( iwn-1+0.5d0 ) / ( iwne-iwns+1 ), &
   560  !!$!                       ac_1d( iwn ), pf_1d( iwn )
   561  !!$!               end do
   562  !!$!            end if
   563  !!$
   564  !!$
   565  !!$#ifdef THROUGH
   566  !!$
   567  !!$               if( ckdp( iband ) % ng .ne. iwne-iwns+1 ) then
   568  !!$                  write( 6, * ) 'ng is equal to iwne-iwns+1.'
   569  !!$                  write( 6, * ) ckdp( iband ) % ng, iwne-iwns+1
   570  !!$                  stop
   571  !!$               end if
   572  !!$               do ig = 1, ckdp( iband ) % ng
   573  !!$                  iwn = ig
   574  !!$                  ckdp( iband ) % lnac( ig, k, incf ) = ac_1d( iwn )
   575  !!$                  ckdp( iband ) % pfr ( ig, k, incf ) = pf_1d( iwn ) &
   576  !!$                       / pfint( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
   577  !!$                                5, ckdp(iband)%t(incf) ) &
   578  !!$                       * ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
   579  !!$               end do
   580  !!$
   581  !!$#else
   582  !!$
   583  !!$               call calcpfratio( iwne-iwns+1, pf_1d, &
   584  !!$                    ckdp( iband ) % ng, ckdp( iband ) % weight, pfrat )
   585  !!$
   586  !!$
   587  !!$               do ig = 1, ckdp( iband ) % ng
   588  !!$                  iwn = ckdp( iband ) % g( ig ) * ( iwne-iwns+1 )
   589  !!$                  iwn = max( iwn, 1 )
   590  !!$
   591  !!$                  if( ( iwn .le. 0 ) .or. ( iwn .ge. iwne-iwns+1 ) )then
   592  !!$                     write( 6, * ) 'iwn is inappropriate.'
   593  !!$                     write( 6, * ) iwn, iwne-iwns+1
   594  !!$                     stop
   595  !!$                  else
   596  !!$                     if(  ( ac_1d( iwn   ) .ne. 0.0d0 ) .and. &
   597  !!$                          ( ac_1d( iwn+1 ) .ne. 0.0d0 ) ) then
   598  !!$                        ac_i( ig ) = log( ac_1d( iwn+1 ) / ac_1d( iwn ) ) &
   599  !!$                             / ( 1.0d0 / dble( iwne-iwns+1 ) ) &
   600  !!$                             * ( ckdp( iband ) % g( ig ) &
   601  !!$                               - dble( iwn-1+0.5d0 ) / dble( iwne-iwns+1 ) ) &
   602  !!$                             + log( ac_1d( iwn ) )
   603  !!$                        ac_i( ig ) = exp( ac_i( ig ) )
   604  !!$                     else
   605  !!$                        ac_i( ig ) = 0.0d0
   606  !!$                     end if
   607  !!$                  end if
   608  !!$
   609  !!$
   610  !!$                  ckdp( iband ) % lnac( ig, k, incf ) = ac_i ( ig )
   611  !!$                  ckdp( iband ) % pfr ( ig, k, incf ) = pfrat( ig )
   612  !!$
   613  !!$!               if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
   614  !!$!                  write( 62, * ) actbl_g( ig ), ac_i( ig ), pfrat( ig )
   615  !!$!               end if
   616  !!$
   617  !!$               end do
   618  !!$
   619  !!$#endif
   620  !!$
   621  !!$
   622  !!$            end do
   623  !!$
   624  !!$         end do
   625  !!$
   626  !!$         deallocate( ac_1d )
   627  !!$         deallocate( pf_1d )
   628  !!$         deallocate( ac_i  )
   629  !!$         deallocate( pfrat )
   630  !!$
   631  !!$         do incf = 1, nncfile
   632  !!$            do k = 1, km
   633  !!$               do ig = 1, ckdp( iband ) % ng
   634  !!$                  if( ckdp( iband ) % lnac( ig, k, incf ) .gt. 0.0d0 ) then
   635  !!$                     ckdp( iband ) % lnac( ig, k, incf ) &
   636  !!$                          = log( ckdp( iband ) % lnac( ig, k, incf ) )
   637  !!$                  else
   638  !!$                     ckdp( iband ) % lnac( ig, k, incf ) = 0.0d0
   639  !!$                  end if
   640  !!$               end do
   641  !!$            end do
   642  !!$         end do
   643  !!$
   644  !!$      end do
   645  !!$
   646  !!$      !************************************************************************
   647  !!$
   648  !!$    contains
   649  !!$
   650  !!$      !************************************************************************
   651  !!$
   652  !!$      subroutine set_g( iband, iwns, iwne, iras )
   653  !!$
   654  !!$
   655  !!$        integer(i4b), intent(in ) :: iband, iwns, iwne, iras
   656  !!$
   657  !!$
   658  !!$
   659  !!$        !
   660  !!$        ! local variables
   661  !!$        !
   662  !!$        real(dp)     :: ac_1d( iwne-iwns+1 ), ac_min, ac_max, lnac_ul, ac_ul
   663  !!$#ifdef G_RRTM
   664  !!$        real(dp)     :: rrtm_ul( 16 )
   665  !!$        data rrtm_ul &
   666  !!$             /0.15275d0, 0.30192d0, 0.44402d0, 0.57571d0, 0.69390d0, &
   667  !!$              0.79583d0, 0.87911d0, 0.94178d0, 0.98427d0, 0.98890d0, &
   668  !!$              0.99273d0, 0.99576d0, 0.99798d0, 0.99939d0, 0.99993d0, &
   669  !!$              1.00000d0/
   670  !!$#endif
   671  !!$
   672  !!$        integer(i4b) :: k, ig, incf
   673  !!$
   674  !!$
   675  !!$
   676  !!$#if defined CONST_WEIGHT || defined THROUGH
   677  !!$
   678  !!$!         do ig = 1, ckdp( iband ) % ng
   679  !!$!            ckdp( iband ) % g     ( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
   680  !!$!                 * ( dble( ig - 1 ) + 0.5d0 )
   681  !!$!            ckdp( iband ) % weight( ig ) = 1.0d0 / dble( ckdp( iband ) % ng )
   682  !!$!         end do
   683  !!$
   684  !!$         do ig = 1, ckdp( iband ) % ng - 1
   685  !!$            ckdp( iband ) % g_ul( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
   686  !!$                 * dble( ig )
   687  !!$         end do
   688  !!$         ig = ckdp( iband ) % ng
   689  !!$         ckdp( iband ) % g_ul( ig ) = 1.0d0
   690  !!$         ig = 1
   691  !!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
   692  !!$         do ig = 1+1, ckdp( iband ) % ng
   693  !!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
   694  !!$         end do
   695  !!$         do ig = 1, ckdp( iband ) % ng
   696  !!$            ckdp( iband ) % g     ( ig ) &
   697  !!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
   698  !!$                 * 0.5d0
   699  !!$            ckdp( iband ) % weight( ig ) &
   700  !!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
   701  !!$         end do
   702  !!$
   703  !!$#else
   704  !!$#ifdef G_CONST_LNAC
   705  !!$
   706  !!$         incf = 1
   707  !!$         k    = 1
   708  !!$         write( 6, * ) 'Temperature in reference layer : ', temp( incf )
   709  !!$         write( 6, * ) 'Pressure    in reference layer : ', &
   710  !!$              exp( ckdp( iband ) % lnp( k ) )
   711  !!$
   712  !!$         call readac( ncid( incf ), iwne-iwns+1, ac_1d, iras, k, iwns, iwne )
   713  !!$
   714  !!$         call sort_quick( iwne-iwns+1, ac_1d )
   715  !!$
   716  !!$         do iwn = 1, iwne-iwns+1
   717  !!$            if( ac_1d( iwn ) .ne. 0.0d0 ) exit
   718  !!$         end do
   719  !!$
   720  !!$         ac_min = ac_1d( iwn         )
   721  !!$         ac_max = ac_1d( iwne-iwns+1 )
   722  !!$         do ig = 1, ckdp( iband ) % ng - 1
   723  !!$            lnac_ul = log( ac_max / ac_min ) / ckdp( iband ) % ng * ig &
   724  !!$                 + log( ac_min )
   725  !!$            ac_ul = exp( lnac_ul )
   726  !!$            do iwn = 1+1, iwne-iwns+1
   727  !!$               if( ac_1d( iwn ) .gt. ac_ul ) exit
   728  !!$            end do
   729  !!$            iwn = iwn - 1
   730  !!$
   731  !!$!            iwn = min( iwn, iwne-iwns+1 - ( ckdp( iband ) % ng - ig ) )
   732  !!$!            ckdp( iband ) % g_ul( ig ) = dble( iwn ) / dble( iwne-iwns+1 )
   733  !!$
   734  !!$            iwn = min( iwn, iwne-iwns+1-1 )
   735  !!$            ckdp( iband ) % g_ul( ig )                  &
   736  !!$                 = 1.0d0 / dble( iwne-iwns+1 )          &
   737  !!$                 / log( ac_1d( iwn+1 ) / ac_1d( iwn ) ) &
   738  !!$                 * ( lnac_ul - log( ac_1d( iwn ) ) )    &
   739  !!$                 + dble( iwn ) / dble( iwne-iwns+1 )
   740  !!$         end do
   741  !!$         ig = ckdp( iband ) % ng
   742  !!$         ckdp( iband ) % g_ul( ig ) = 1.0d0
   743  !!$         ig = 1
   744  !!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
   745  !!$         do ig = 1+1, ckdp( iband ) % ng
   746  !!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
   747  !!$         end do
   748  !!$         do ig = 1, ckdp( iband ) % ng
   749  !!$            ckdp( iband ) % g     ( ig ) &
   750  !!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
   751  !!$                 * 0.5d0
   752  !!$            ckdp( iband ) % weight( ig ) &
   753  !!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
   754  !!$         end do
   755  !!$
   756  !!$
   757  !!$#else
   758  !!$#ifdef G_RRTM
   759  !!$
   760  !!$         if( ckdp( iband ) % ng .ne. 16 ) then
   761  !!$            write( 6, * ) 'ng is not equal to 16'
   762  !!$            write( 6, * ) iband, ckdp( iband ) % ng
   763  !!$            stop
   764  !!$         end if
   765  !!$
   766  !!$         do ig = 1, ckdp( iband ) % ng
   767  !!$            ckdp( iband ) % g_ul( ig ) = rrtm_ul( ig )
   768  !!$         end do
   769  !!$         ig = 1
   770  !!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
   771  !!$         do ig = 1+1, ckdp( iband ) % ng
   772  !!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
   773  !!$         end do
   774  !!$         do ig = 1, ckdp( iband ) % ng
   775  !!$            ckdp( iband ) % g     ( ig ) &
   776  !!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
   777  !!$                 * 0.5d0
   778  !!$            ckdp( iband ) % weight( ig ) &
   779  !!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
   780  !!$         end do
   781  !!$
   782  !!$#else
   783  !!$         do ig = 1, ckdp( iband ) % ng
   784  !!$            call gauleg( 0.0d0, 1.0d0, &
   785  !!$                 ckdp(iband)%ng, ckdp(iband)%g, ckdp(iband)%weight )
   786  !!$         end do
   787  !!$
   788  !!$         ig = 1
   789  !!$         ckdp( iband ) % g_ul( ig ) = ckdp( iband ) % weight( ig )
   790  !!$         do ig = 1+1, ckdp( iband ) % ng
   791  !!$            ckdp( iband ) % g_ul( ig ) = ckdp( iband ) % g_ul( ig-1 ) &
   792  !!$                 + ckdp( iband ) % weight( ig )
   793  !!$         end do
   794  !!$         ig = 1
   795  !!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
   796  !!$         do ig = 1+1, ckdp( iband ) % ng
   797  !!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
   798  !!$         end do
   799  !!$
   800  !!$#endif     !#ifdef G_RRTM
   801  !!$#endif     !#ifdef G_CONST_LNAC
   802  !!$#endif     !#if defined CONST_WEIGHT || defined THROUGH
   803  !!$
   804  !!$
   805  !!$         !
   806  !!$         ! check
   807  !!$         !
   808  !!$         do ig = 1, ckdp( iband ) % ng
   809  !!$            if( ckdp( iband ) % weight( ig ) .eq. 0.0d0 ) then
   810  !!$               write( 6, * ) 'weight is zero'
   811  !!$               write( 6, * ) iband, ig, ckdp( iband ) % weight( ig )
   812  !!$               stop
   813  !!$            end if
   814  !!$         end do
   815  !!$
   816  !!$
   817  !!$!         do ig = 1, ckdp( iband ) % ng
   818  !!$!            write( 21, * ) ig, &
   819  !!$!                 ckdp( iband ) % g_ll( ig ), ckdp( iband ) % g_ul( ig ), &
   820  !!$!                 ckdp( iband ) % g   ( ig ), ckdp( iband ) % weight( ig )
   821  !!$!         end do
   822  !!$!         stop
   823  !!$
   824  !!$
   825  !!$       end subroutine set_g
   826  !!$
   827  !!$      !************************************************************************
   828  !!$
   829  !!$      subroutine search_wnindices( nwn, wn, wns, wne, iwns, iwne )
   830  !!$
   831  !!$        integer(i4b), intent(in ) :: nwn
   832  !!$        real(dp)    , intent(in ) :: wn( nwn ), wns, wne
   833  !!$        integer(i4b), intent(out) :: iwns, iwne
   834  !!$
   835  !!$
   836  !!$        !
   837  !!$        ! local variables
   838  !!$        !
   839  !!$        integer(i4b) :: iwn
   840  !!$
   841  !!$
   842  !!$        iwns = 0
   843  !!$        iwne = 1
   844  !!$        do iwn = 1, nwn
   845  !!$           if( wn( iwn ) .lt. wns ) iwns = iwn
   846  !!$           if( wn( iwn ) .le. wne ) iwne = iwn
   847  !!$        end do
   848  !!$        iwns = iwns + 1
   849  !!$
   850  !!$
   851  !!$        if( iwns .gt. iwne ) then
   852  !!$           write( 6, * ) 'iwns is greater than iwne.'
   853  !!$           write( 6, * ) iwns, wn( iwns )
   854  !!$           write( 6, * ) iwne, wn( iwne )
   855  !!$           stop
   856  !!$        end if
   857  !!$
   858  !!$
   859  !!$      end subroutine search_wnindices
   860  !!$
   861  !!$      !************************************************************************
   862  !!$
   863  !!$      subroutine readac( ncid, nwn, ac_1d, iras, k, iwns, iwne )
   864  !!$
   865  !!$        use netcdf
   866  !!$
   867  !!$        integer(i4b), intent(in ) :: ncid, nwn
   868  !!$        real(dp)    , intent(out) :: ac_1d( nwn )
   869  !!$        integer(i4b), intent(in ) :: iras, k, iwns, iwne
   870  !!$
   871  !!$
   872  !!$        !
   873  !!$        ! local variables
   874  !!$        !
   875  !!$        real(dp)              :: l_ac( nwn, 1, 1 )
   876  !!$        integer(i4b)          :: varid
   877  !!$        integer(i4b)          :: istatus
   878  !!$        character(len=extstr) :: err_mes = "in readac"
   879  !!$        integer(i4b)          :: st( 3 ), co( 3 )
   880  !!$
   881  !!$
   882  !!$        call ni3_inq_var( ncid, "ac", varid )
   883  !!$        call ni3_enddef( ncid )
   884  !!$
   885  !!$
   886  !!$        st( 1 ) = iwns
   887  !!$        st( 2 ) = k
   888  !!$        st( 3 ) = iras
   889  !!$        co( 1 ) = iwne - iwns + 1
   890  !!$        co( 2 ) = 1
   891  !!$        co( 3 ) = 1
   892  !!$        istatus = nf90_get_var( ncid, varid, l_ac, start = st, count = co )
   893  !!$        call ni3_handle_err( istatus, err_mes )
   894  !!$
   895  !!$
   896  !!$        ac_1d( : ) = l_ac( :, 1, 1 )
   897  !!$
   898  !!$
   899  !!$      end subroutine readac
   900  !!$
   901  !!$      !************************************************************************
   902  !!$
   903  !!$      subroutine calcpfratio( nwn, pf_1d, ncp, weight, pfrat )
   904  !!$
   905  !!$        integer(i4b), intent(in ) :: nwn
   906  !!$        real(dp)    , intent(in ) :: pf_1d( nwn )
   907  !!$        integer(i4b), intent(in ) :: ncp
   908  !!$        real(dp)    , intent(in ) :: weight( ncp )
   909  !!$        real(dp)    , intent(out) :: pfrat( ncp )
   910  !!$
   911  !!$
   912  !!$        !
   913  !!$        ! local variables
   914  !!$        !
   915  !!$        real(dp)     :: weight_sum, weight_sum_p, x1, x2, dg, pf_sum
   916  !!$        integer(i4b) :: n, iwn, iwns, iwne, iwn1, iwn2
   917  !!$
   918  !!$
   919  !!$        weight_sum_p  = 0.0d0
   920  !!$        weight_sum    = 0.0d0
   921  !!$        pfrat( : ) = 0.0d0
   922  !!$        iwne       = 1-1
   923  !!$        do n = 1, ncp
   924  !!$           weight_sum = weight_sum + weight( n )
   925  !!$           if( n .eq. ncp ) weight_sum = 1.0d0
   926  !!$           if( weight_sum .gt. 1.0d0 ) then
   927  !!$              write( 6, * ) 'weight_sum is greater than 1.'
   928  !!$              write( 6, * ) weight_sum
   929  !!$              stop
   930  !!$           end if
   931  !!$
   932  !!$           iwns = iwne + 1
   933  !!$           iwne = weight_sum * dble( nwn )
   934  !!$           iwn1 = max( iwns-1, 1   )
   935  !!$           iwn2 = min( iwne+1, nwn )
   936  !!$           do iwn = iwn1, iwn2
   937  !!$              x1 = max( dble( iwn-1 ) / dble( nwn ), weight_sum_p )
   938  !!$              x2 = min( dble( iwn   ) / dble( nwn ), weight_sum   )
   939  !!$              dg = max( x2 - x1, 0.0d0 )
   940  !!$              pfrat( n ) = pfrat( n ) + pf_1d( iwn ) * dg
   941  !!$           end do
   942  !!$           weight_sum_p = weight_sum
   943  !!$        end do
   944  !!$
   945  !!$        pf_sum = 0.0d0
   946  !!$        do n = 1, ncp
   947  !!$           pf_sum = pf_sum + pfrat( n )
   948  !!$        end do
   949  !!$
   950  !!$        pfrat( : ) = pfrat( : ) / pf_sum / weight( : )
   951  !!$
   952  !!$
   953  !!$      end subroutine calcpfratio
   954  !!$
   955  !!$      !************************************************************************
   956  !!$
   957  !!$    end subroutine ckd_mktbl
   958  !!$
   959  !!$    !**************************************************************************
   960  !!$
   961  !!$    subroutine ckd_output
   962  !!$
   963  !!$      use fi_module
   964  !!$      use ni3_module
   965  !!$      use netcdf
   966  !!$
   967  !!$
   968  !!$      !
   969  !!$      ! local variables
   970  !!$      !
   971  !!$      integer(i4b)                       :: ctlfu
   972  !!$      character(len=extstr)              :: ncfn_out
   973  !!$      integer(i4b)                       :: ncid_out
   974  !!$      character(len=extstr)              :: comment
   975  !!$      integer(i4b)                       :: ndims
   976  !!$      character(len=extstr), allocatable :: dimnames( : )
   977  !!$      character(len=extstr)              :: name_bnds, name_weight, &
   978  !!$           name_g, name_lnac, name_pfr
   979  !!$
   980  !!$      integer(i4b)                       :: istatus
   981  !!$      integer(i4b)                       :: iband
   982  !!$
   983  !!$
   984  !!$      namelist /output_nc/ ncfn_out, comment
   985  !!$
   986  !!$
   987  !!$      call fi_open( ctlfn, "read", ctlfu )
   988  !!$      ncfn_out = "out.nc"
   989  !!$      comment  = "comment"
   990  !!$      read( ctlfu, output_nc )
   991  !!$      close( ctlfu )
   992  !!$
   993  !!$
   994  !!$      call ni3_open( ncfn_out, "new", ncid_out )
   995  !!$
   996  !!$      comment = "comment"
   997  !!$      istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "comment", comment )
   998  !!$      call ni3_handle_err( istatus )
   999  !!$
  1000  !!$      istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "nband", nband )
  1001  !!$      call ni3_handle_err( istatus )
  1002  !!$
  1003  !!$      call ni3_set_dim( ncid_out, "lnp" , NF90_DOUBLE, ckdp( 1 ) % lnp )
  1004  !!$      call ni3_set_dim( ncid_out, "t"   , NF90_DOUBLE, ckdp( 1 ) % t   )
  1005  !!$
  1006  !!$      call ni3_def_dim( ncid_out, "bnds", NF90_DOUBLE, 2 )
  1007  !!$
  1008  !!$      do iband = 1, nband
  1009  !!$         istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "imol", ckdp(iband)%imol )
  1010  !!$         call ni3_handle_err( istatus )
  1011  !!$
  1012  !!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
  1013  !!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
  1014  !!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
  1015  !!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
  1016  !!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
  1017  !!$
  1018  !!$         call ni3_set_dim( ncid_out, name_g, NF90_DOUBLE, ckdp(iband)%g   )
  1019  !!$
  1020  !!$         ndims = 1
  1021  !!$         allocate( dimnames( ndims ) )
  1022  !!$         dimnames( 1 ) = name_g
  1023  !!$         call ni3_def_var( ncid_out, name_weight, NF90_DOUBLE, ndims, dimnames )
  1024  !!$         deallocate( dimnames )
  1025  !!$
  1026  !!$         ndims = 1
  1027  !!$         allocate( dimnames( ndims ) )
  1028  !!$         dimnames( 1 ) = "bnds"
  1029  !!$         call ni3_def_var( ncid_out, name_bnds, NF90_DOUBLE, ndims, dimnames )
  1030  !!$         deallocate( dimnames )
  1031  !!$
  1032  !!$         ndims = 3
  1033  !!$         allocate( dimnames( ndims ) )
  1034  !!$         dimnames( 1 ) = name_g
  1035  !!$         dimnames( 2 ) = "lnp"
  1036  !!$         dimnames( 3 ) = "t"
  1037  !!$         call ni3_def_var( ncid_out, name_lnac, NF90_DOUBLE, ndims, dimnames )
  1038  !!$         call ni3_def_var( ncid_out, name_pfr , NF90_DOUBLE, ndims, dimnames )
  1039  !!$         deallocate( dimnames )
  1040  !!$
  1041  !!$         call ni3_put_var( ncid_out, name_weight, ckdp(iband)%weight )
  1042  !!$
  1043  !!$         call ni3_put_var( ncid_out, name_bnds  , ckdp(iband)%wnbnds )
  1044  !!$
  1045  !!$         call ni3_put_var( ncid_out, name_lnac  , ckdp(iband)%lnac   )
  1046  !!$         call ni3_put_var( ncid_out, name_pfr   , ckdp(iband)%pfr    )
  1047  !!$      end do
  1048  !!$
  1049  !!$      call ni3_close( ncid_out )
  1050  !!$
  1051  !!$
  1052  !!$    end subroutine ckd_output
  1053  !!$
  1054  !!$    !**************************************************************************
  1055  !!$
  1056  !!$#endif
  1057  !!$    !**************************************************************************
  1058  !!$
  1059  !!$    subroutine ckd_output_ascii
  1060  !!$
  1061  !!$      use fi_module
  1062  !!$
  1063  !!$
  1064  !!$      !
  1065  !!$      ! local variables
  1066  !!$      !
  1067  !!$      integer(i4b)                       :: ctlfu
  1068  !!$      character(len=extstr)              :: fn_out
  1069  !!$      integer(i4b)                       :: fu_out
  1070  !!$      character(len=extstr)              :: comment
  1071  !!$      character(len=extstr)              :: name_bnds, name_weight, &
  1072  !!$           name_g, name_lnac, name_pfr
  1073  !!$
  1074  !!$      integer(i4b)                       :: iband
  1075  !!$
  1076  !!$      namelist /output_ascii/ fn_out, comment
  1077  !!$
  1078  !!$
  1079  !!$      call fi_open( ctlfn, "read", ctlfu )
  1080  !!$      fn_out  = "out.txt"
  1081  !!$      comment = "comment"
  1082  !!$      read( ctlfu, output_ascii )
  1083  !!$      close( ctlfu )
  1084  !!$
  1085  !!$
  1086  !!$      call fi_open( fn_out, "write", fu_out )
  1087  !!$
  1088  !!$      write( fu_out, * ) comment
  1089  !!$      write( 6, * ) 'Comment         : ', trim( comment )
  1090  !!$
  1091  !!$      write( fu_out, * ) nband
  1092  !!$      write( 6, * ) 'Number of bands : ', nband
  1093  !!$
  1094  !!$      write( fu_out, * ) ckdp( 1 ) % nlnp
  1095  !!$      write( fu_out, * ) ckdp( 1 ) % lnp
  1096  !!$
  1097  !!$      write( fu_out, * ) ckdp( 1 ) % nt
  1098  !!$      write( fu_out, * ) ckdp( 1 ) % t
  1099  !!$
  1100  !!$      do iband = 1, nband
  1101  !!$         write( fu_out, * ) ckdp( iband ) % imol
  1102  !!$
  1103  !!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
  1104  !!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
  1105  !!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
  1106  !!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
  1107  !!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
  1108  !!$
  1109  !!$         write( fu_out, * ) trim( name_g      )
  1110  !!$         write( fu_out, * ) ckdp( iband ) % ng
  1111  !!$         write( fu_out, * ) ckdp( iband ) % g
  1112  !!$
  1113  !!$         write( fu_out, * ) trim( name_weight )
  1114  !!$         write( fu_out, * ) ckdp( iband ) % weight
  1115  !!$
  1116  !!$         write( fu_out, * ) trim( name_bnds   )
  1117  !!$         write( fu_out, * ) ckdp( iband ) % wnbnds
  1118  !!$
  1119  !!$         write( fu_out, * ) trim( name_lnac   )
  1120  !!$         write( fu_out, * ) ckdp( iband ) % lnac
  1121  !!$
  1122  !!$         write( fu_out, * ) trim( name_pfr    )
  1123  !!$         write( fu_out, * ) ckdp( iband ) % pfr
  1124  !!$      end do
  1125  !!$
  1126  !!$      close( fu_out )
  1127  !!$
  1128  !!$
  1129  !!$    end subroutine ckd_output_ascii
  1130  !!$
  1131  !!$    !**************************************************************************
  1132  !!$
  1133  !!$    subroutine ckd_input_ascii( fn_in )
  1134  !!$
  1135  !!$      use fi_module
  1136  !!$
  1137  !!$      character(len=*), intent(in) :: fn_in
  1138  !!$
  1139  !!$      !
  1140  !!$      ! local variables
  1141  !!$      !
  1142  !!$!      integer(i4b)              :: ctlfu
  1143  !!$
  1144  !!$!      character(len=extstr)              :: fn_in
  1145  !!$      integer(i4b)                       :: fu_in
  1146  !!$      character(len=extstr)              :: comment
  1147  !!$
  1148  !!$      character(len=extstr)              :: name_bnds, name_weight, &
  1149  !!$           name_g, name_lnac, name_pfr
  1150  !!$
  1151  !!$      character(len=extstr)              :: line
  1152  !!$      integer(i4b)                       :: iband, ig
  1153  !!$
  1154  !!$!      namelist /input_ascii/ fn_in
  1155  !!$!
  1156  !!$!
  1157  !!$!      call fi_open( ctlfn, "read", ctlfu )
  1158  !!$!      fn_in = "out.txt"
  1159  !!$!      read( ctlfu, input_ascii )
  1160  !!$!      close( ctlfu )
  1161  !!$
  1162  !!$
  1163  !!$      call fi_open( fn_in, "read", fu_in )
  1164  !!$
  1165  !!$      read( fu_in, * ) comment
  1166  !!$      write( 6, * ) 'Comment         : ', trim( comment )
  1167  !!$
  1168  !!$      read( fu_in, * ) nband
  1169  !!$      write( 6, * ) 'Number of bands : ', nband
  1170  !!$
  1171  !!$      allocate( ckdp( nband ) )
  1172  !!$
  1173  !!$      read( fu_in, * ) ckdp( 1 ) % nlnp
  1174  !!$      allocate( ckdp( 1 ) % lnp   ( ckdp( 1 ) % nlnp ) )
  1175  !!$      read( fu_in, * ) ckdp( 1 ) % lnp
  1176  !!$
  1177  !!$      read( fu_in, * ) ckdp( 1 ) % nt
  1178  !!$      allocate( ckdp( 1 ) % t     ( ckdp( 1 ) % nt   ) )
  1179  !!$      read( fu_in, * ) ckdp( 1 ) % t
  1180  !!$
  1181  !!$      do iband = 1+1, nband
  1182  !!$         ckdp( iband ) % nlnp = ckdp( 1 ) % nlnp
  1183  !!$         ckdp( iband ) % nt   = ckdp( 1 ) % nt
  1184  !!$         allocate( ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
  1185  !!$                   ckdp( iband ) % t     ( ckdp( iband ) % nt   )  )
  1186  !!$         ckdp( iband ) % lnp( : ) = ckdp( 1 ) % lnp( : )
  1187  !!$         ckdp( iband ) % t  ( : ) = ckdp( 1 ) % t  ( : )
  1188  !!$      end do
  1189  !!$
  1190  !!$      do iband = 1, nband
  1191  !!$         write( 6, * ) 'band ', iband
  1192  !!$
  1193  !!$         read( fu_in, * ) ckdp( iband ) % imol
  1194  !!$
  1195  !!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
  1196  !!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
  1197  !!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
  1198  !!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
  1199  !!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
  1200  !!$
  1201  !!$
  1202  !!$         read( fu_in, * ) line
  1203  !!$         if( name_g      .ne. line ) then
  1204  !!$            write( 6, * ) 'Input file is invalid.'
  1205  !!$            write( 6, * ) trim( name_g )
  1206  !!$            write( 6, * ) trim( line   )
  1207  !!$            stop
  1208  !!$         end if
  1209  !!$         read( fu_in, * ) ckdp( iband ) % ng
  1210  !!$         allocate( ckdp( iband ) % g     ( ckdp( iband ) % ng   )  )
  1211  !!$         read( fu_in, * ) ckdp( iband ) % g
  1212  !!$
  1213  !!$         allocate( ckdp( iband ) % weight( ckdp( iband ) % ng   ) )
  1214  !!$
  1215  !!$         allocate( &
  1216  !!$              ckdp( iband ) % lnac( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
  1217  !!$              )
  1218  !!$         allocate( &
  1219  !!$              ckdp( iband ) % pfr ( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
  1220  !!$              )
  1221  !!$
  1222  !!$         read( fu_in, * ) line
  1223  !!$         if( name_weight .ne. line ) then
  1224  !!$            write( 6, * ) 'Input file is invalid.'
  1225  !!$            write( 6, * ) trim( name_weight )
  1226  !!$            write( 6, * ) trim( line        )
  1227  !!$            stop
  1228  !!$         end if
  1229  !!$         read( fu_in, * ) ckdp( iband ) % weight
  1230  !!$
  1231  !!$         read( fu_in, * ) line
  1232  !!$         if( name_bnds   .ne. line ) then
  1233  !!$            write( 6, * ) 'Input file is invalid.'
  1234  !!$            write( 6, * ) trim( name_bnds   )
  1235  !!$            write( 6, * ) trim( line        )
  1236  !!$            stop
  1237  !!$         end if
  1238  !!$         read( fu_in, * ) ckdp( iband ) % wnbnds
  1239  !!$
  1240  !!$         read( fu_in, * ) line
  1241  !!$         if( name_lnac   .ne. line ) then
  1242  !!$            write( 6, * ) 'Input file is invalid.'
  1243  !!$            write( 6, * ) trim( name_lnac   )
  1244  !!$            write( 6, * ) trim( line        )
  1245  !!$            stop
  1246  !!$         end if
  1247  !!$         read( fu_in, * ) ckdp( iband ) % lnac
  1248  !!$
  1249  !!$         read( fu_in, * ) line
  1250  !!$         if( name_pfr    .ne. line ) then
  1251  !!$            write( 6, * ) 'Input file is invalid.'
  1252  !!$            write( 6, * ) trim( name_pfr    )
  1253  !!$            write( 6, * ) trim( line        )
  1254  !!$            stop
  1255  !!$         end if
  1256  !!$         read( fu_in, * ) ckdp( iband ) % pfr
  1257  !!$
  1258  !!$
  1259  !!$         write( 6, * ) 'band ', iband
  1260  !!$         write( 6, * ) '  wns  = ', ckdp(iband)%wnbnds(1)
  1261  !!$         write( 6, * ) '  wne  = ', ckdp(iband)%wnbnds(2)
  1262  !!$         write( 6, * ) '  ng   = ', ckdp(iband)%ng
  1263  !!$         do ig = 1, ckdp(iband)%ng
  1264  !!$            write( 6, * ) '     g(', ig, ') = ', ckdp(iband)%g(ig)
  1265  !!$         end do
  1266  !!$         write( 6, * ) '  nlnp = ', ckdp(iband)%nlnp
  1267  !!$         write( 6, * ) '  nt   = ', ckdp(iband)%nt
  1268  !!$
  1269  !!$      end do
  1270  !!$
  1271  !!$      close( fu_in )
  1272  !!$
  1273  !!$
  1274  !!$    end subroutine ckd_input_ascii
  1275  !!$
  1276  !!$    !**************************************************************************
  1277  !!$
  1278  !!$#endif
  1279  
  1280    end module ckd_module
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:58 2016
FILE NAME: ckd_module.f90
PROGRAM NAME: ckd_module
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             module ckd_module
     2:             
     3:               ! 種別型パラメタ
     4:               ! Kind type parameter
     5:               !
     6:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
     7:                 &                 STRING, &  ! 文字列.       Strings.
     8:                 &                 TOKEN      ! キーワード.   Keywords.
     9:             
    10:             
    11:               ! 宣言文 ; Declaration statements
    12:               !
    13:               implicit none
    14:               private
    15:             
    16:             
    17:               ! 公開手続き
    18:               ! Public procedure
    19:               !
    20:               public:: ckd_input
    21:             
    22:               ! 公開変数
    23:               ! Public variables
    24:               !
    25:             
    26:               ! The structure of bandparam structure may be inappropriate, for this cannot be used 
    27:               ! for multiple radiatively active species. 
    28:               ! Maybe, 
    29:               !   * imol has to be 1D array,
    30:               !   * lnac has to be 4D array.
    31:               ! (yot, 2010/09/12)
    32:               !
    33:               type bandparam
    34:                 integer           :: imol
    35:                 integer           :: ng, nlnp, nt
    36:                 real(DP)          :: wnbnds( 2 )
    37:                 real(DP), pointer :: weight( : )
    38:                 real(DP), pointer :: lnac  ( :, :, : )
    39:                 real(DP), pointer :: pfr   ( :, :, : )
    40:                 real(DP), pointer :: g( : ), lnp( : ), t( : )
    41:                 real(DP), pointer :: g_ll( : ), g_ul( : )
    42:               end type bandparam
    43:             
    44:               integer                     , save :: nband
    45:               type(bandparam), allocatable, save :: ckdp( : )
    46:             
    47:             
    48:               public :: bandparam, nband, ckdp
    49:             
    50:             
    51:               !--------------------------------------------------------------------------------------
    52:             
    53:             contains
    54:             
    55:               !--------------------------------------------------------------------------------------
    56:             
    57:               subroutine ckd_input( &
    58:                 & ncfn & ! (in)
    59:                 & )
    60:             
    61:                 use netcdf_wrapper, only : &
    62:                   & NWInqDimLen, &
    63:                   & NWGetAtt
    64:             
    65:                 ! gtool データ入力
    66:                 ! Gtool data input
    67:                 !
    68:                 use gtool_history, only: HistoryGet
    69:             
    70:             
    71:                 character(*), intent(in) :: ncfn
    72:             
    73:                 !
    74:                 ! local variables
    75:                 !
    76:                 character(STRING) :: comment
    77:                 character(STRING) :: name_weight
    78:                 character(STRING) :: name_g
    79:                 character(STRING) :: name_lnac
    80:                 character(STRING) :: name_pfr
    81:                 character(STRING) :: name_bnds
    82:             
    83:                 integer           :: iband, ig
    84:             
    85:                 logical           :: flag_mpi_init = .false.
    86:             
    87:             
    88:                 write( 6, * ) 'Read ', trim( ncfn )
    89:             
    90:                 call NWGetAtt( ncfn, 'global', 'comment', comment )
    91:             
    92:                 call NWGetAtt( ncfn, 'global', 'nband'  , nband   )
    93:             
    94:             
    95:                 allocate( ckdp( nband ) )
    96:             
    97: +------>        do iband = 1, nband
    98: |                 write( 6, * ) 'band ', iband 
    99: |           
   100: |                 call NWGetAtt( ncfn, 'global', 'imol', ckdp(iband)%imol )
   101: |           
   102: |                 write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
   103: |                 write( name_weight, '(a,i4.4)' ) "weight_", iband
   104: |                 write( name_g     , '(a,i4.4)' ) "g_"     , iband
   105: |                 write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
   106: |                 write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
   107: |           
   108: |                 call NWInqDimLen(        &
   109: |                   & ncfn,                & ! (in )
   110: |                   & name_g,              & ! (in )
   111: |                   & ckdp( iband ) % ng   & ! (out)
   112: |                   & )
   113: |                 call NWInqDimLen(        &
   114: |                   & ncfn,                & ! (in )
   115: |                   & 't',                 & ! (in )
   116: |                   & ckdp( iband ) % nt   & ! (out)
   117: |                   & )
   118: |                 call NWInqDimLen(        &
   119: |                   & ncfn,                & ! (in )
   120: |                   & 'lnp',               & ! (in )
   121: |                   & ckdp( iband ) % nlnp & ! (out)
   122: |                   & )
   123: |           
   124: |           
   125: |                 allocate( &
   126: |                   & ckdp( iband ) % weight( ckdp( iband ) % ng   ), &
   127: |                   & ckdp( iband ) % g     ( ckdp( iband ) % ng   ), &
   128: |                   & ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
   129: |                   & ckdp( iband ) % t     ( ckdp( iband ) % nt   )  &
   130: |                   & )
   131: |           
   132: |                 allocate( &
   133: |                   & ckdp( iband ) % lnac( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
   134: |                   & )
   135: |                 allocate( &
   136: |                   & ckdp( iband ) % pfr ( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
   137: |                   & )
   138: |           
   139: |           
   140: |                 call HistoryGet(                      &
   141: |                   & ncfn,                             &
   142: |                   & name_weight,                      &
   143: |                   & ckdp(iband)%weight,               &
   144: |                   & flag_mpi_split = flag_mpi_init    &
   145: |                   & )
   146: |                 call HistoryGet(                      &
   147: |                   & ncfn,                             &
   148: |                   & name_g,                           &
   149: |                   & ckdp(iband)%g,                    &
   150: |                   & flag_mpi_split = flag_mpi_init    &
   151: |                   & )
   152: |                 call HistoryGet(                      &
   153: |                   & ncfn,                             &
   154: |                   & 'lnp',                            &
   155: |                   & ckdp(iband)%lnp,                  &
   156: |                   & flag_mpi_split = flag_mpi_init    &
   157: |                   & )
   158: |                 call HistoryGet(                      &
   159: |                   & ncfn,                             &
   160: |                   & 't',                              &
   161: |                   & ckdp(iband)%t,                    &
   162: |                   & flag_mpi_split = flag_mpi_init    &
   163: |                   & )
   164: |                 call HistoryGet(                      &
   165: |                   & ncfn,                             &
   166: |                   & name_bnds,                        &
   167: |                   & ckdp(iband)%wnbnds,               &
   168: |                   & flag_mpi_split = flag_mpi_init    &
   169: |                   & )
   170: |                 call HistoryGet(                      &
   171: |                   & ncfn,                             &
   172: |                   & name_lnac,                        &
   173: |                   & ckdp(iband)%lnac,                 &
   174: |                   & flag_mpi_split = flag_mpi_init    &
   175: |                   & )
   176: |                 call HistoryGet(                      &
   177: |                   & ncfn,                             &
   178: |                   & name_pfr,                         &
   179: |                   & ckdp(iband)%pfr,                  &
   180: |                   & flag_mpi_split = flag_mpi_init    &
   181: |                   & )
   182: |           
   183: |           
   184: |                 write( 6, * ) 'band ', iband 
   185: |                 write( 6, * ) '  wns  = ', ckdp(iband)%wnbnds(1)
   186: |                 write( 6, * ) '  wne  = ', ckdp(iband)%wnbnds(2)
   187: |                 write( 6, * ) '  ng   = ', ckdp(iband)%ng
   188: |+----->          do ig = 1, ckdp(iband)%ng
   189: ||                  write( 6, * ) '     g(', ig, ') = ', ckdp(iband)%g(ig)
   190: |+-----           end do
   191: |                 write( 6, * ) '  nlnp = ', ckdp(iband)%nlnp
   192: |                 write( 6, * ) '  nt   = ', ckdp(iband)%nt
   193: +------         end do
   194:             
   195:             
   196:               end subroutine ckd_input
   197:             
   198:             !!$#ifdef ZZZZZZZZZ
   199:             !!$    !**************************************************************************
   200:             !!$#ifndef NOUSE_NETCDF
   201:             !!$    !**************************************************************************
   202:             !!$
   203:             !!$    subroutine ckd_mktbl_init
   204:             !!$
   205:             !!$      use fi_module
   206:             !!$      use ni3_module
   207:             !!$
   208:             !!$      !
   209:             !!$      ! local variables
   210:             !!$      !
   211:             !!$      integer(i4b)              :: k, incf, iband, iwn, iras
   212:             !!$      real(dp)    , allocatable :: l_wn( : ), l_plev( : ), l_imol( : ), l_t( : )
   213:             !!$      real(dp)                  :: wns, wne
   214:             !!$      integer(i4b)              :: ng
   215:             !!$      real(dp)    , allocatable :: wnbnds_s( : ), wnbnds_e( : ), ngdiv( : )
   216:             !!$      character(len=extstr)     :: fn
   217:             !!$      integer(i4b)              :: ctlfu, ios
   218:             !!$
   219:             !!$
   220:             !!$      namelist /input_ac/    fn
   221:             !!$      namelist /bandnum/  nband
   222:             !!$      namelist /bandinfo/ wns, wne, ng
   223:             !!$
   224:             !!$
   225:             !!$      call fi_open( ctlfn, "read", ctlfu )
   226:             !!$      nncfile = 0
   227:             !!$      do
   228:             !!$         read( ctlfu, input_ac, iostat = ios )
   229:             !!$         if( ios .ne. 0 ) exit
   230:             !!$         nncfile = nncfile + 1
   231:             !!$      end do
   232:             !!$      allocate( ncfn( nncfile ), ncid( nncfile ) )
   233:             !!$      rewind( ctlfu )
   234:             !!$      do incf = 1, nncfile
   235:             !!$         read( ctlfu, input_ac )
   236:             !!$         ncfn( incf ) = fn
   237:             !!$         write( 6, * ) 'Input file ', incf, ' : ', trim( ncfn( incf ) )
   238:             !!$      end do
   239:             !!$      !
   240:             !!$      rewind( ctlfu )
   241:             !!$      read( ctlfu, bandnum )
   242:             !!$      allocate( wnbnds_s( nband ), wnbnds_e( nband ), ngdiv( nband ) )
   243:             !!$      rewind( ctlfu )
   244:             !!$      do iband = 1, nband
   245:             !!$         read( ctlfu, bandinfo )
   246:             !!$         write( 6, * ) 'Band range       : ', wns, wne
   247:             !!$         write( 6, * ) 'Band subinterval : ', ng
   248:             !!$         wnbnds_s( iband ) = wns
   249:             !!$         wnbnds_e( iband ) = wne
   250:             !!$         ngdiv   ( iband ) = ng
   251:             !!$         if( iband .ge. 2 ) then
   252:             !!$            if( wnbnds_s( iband ) .ne. wnbnds_e( iband-1 ) ) then
   253:             !!$               write( 6, * ) 'Band range is inappropriate.'
   254:             !!$               write( 6, * ) iband, wnbnds_s( iband ), wnbnds_e( iband-1 )
   255:             !!$               stop
   256:             !!$            end if
   257:             !!$         end if
   258:             !!$      end do
   259:             !!$      close( ctlfu )
   260:             !!$
   261:             !!$
   262:             !!$      tm = nncfile
   263:             !!$      allocate( temp( tm ) )
   264:             !!$
   265:             !!$      do incf = 1, nncfile
   266:             !!$         call ni3_open( ncfn( incf ), "read", ncid( incf ) )
   267:             !!$
   268:             !!$         if( incf .eq. 1 ) then
   269:             !!$            call ni3_inq_dimlen( ncid( incf ), "wn"  , nwn  )
   270:             !!$            call ni3_inq_dimlen( ncid( incf ), "plev", km   )
   271:             !!$            call ni3_inq_dimlen( ncid( incf ), "imol", nras )
   272:             !!$            allocate( wn( nwn ), plev( km ), imol( nras ) )
   273:             !!$            call ni3_get_var( ncid( incf ), "wn"  , wn   )
   274:             !!$            call ni3_get_var( ncid( incf ), "plev", plev )
   275:             !!$            call ni3_get_var( ncid( incf ), "imol", imol )
   276:             !!$
   277:             !!$            !
   278:             !!$            ! quality check
   279:             !!$            !
   280:             !!$            if(  ( wn(1  )-(wn(2)-wn(1))*0.5d0 .ne. wnbnds_s( 1     ) ) .or. &
   281:             !!$                 ( wn(nwn)+(wn(2)-wn(1))*0.5d0 .ne. wnbnds_e( nband ) ) ) then
   282:             !!$               write( 6, * ) 'Unexpectected wavenumber range'
   283:             !!$               write( 6, * ) wn( 1   ), wnbnds_s( 1     )
   284:             !!$               write( 6, * ) wn( nwn ), wnbnds_e( nband )
   285:             !!$               stop
   286:             !!$            end if
   287:             !!$            do k = 1, km
   288:             !!$               if( plev( k ) .le. 0.0d0 ) then
   289:             !!$                  write( 6, * ) 'Unexpected zero or negative pressure.'
   290:             !!$                  write( 6, * ) k, plev( k )
   291:             !!$                  stop
   292:             !!$               end if
   293:             !!$            end do
   294:             !!$
   295:             !!$            allocate( l_wn( nwn ), l_plev( km ), l_imol( nras ), l_t( km ) )
   296:             !!$         end if
   297:             !!$
   298:             !!$         call ni3_get_var( ncid( incf ), "wn", l_wn )
   299:             !!$         do iwn = 1, nwn
   300:             !!$            if( wn( iwn ) .ne. l_wn( iwn ) ) then
   301:             !!$               write( 6, * ) 'wavenumber is not identical.'
   302:             !!$               write( 6, * ) iwn, wn( iwn ), l_wn( iwn )
   303:             !!$               stop
   304:             !!$            end if
   305:             !!$         end do
   306:             !!$
   307:             !!$
   308:             !!$         !
   309:             !!$         ! quality check
   310:             !!$         !
   311:             !!$         call ni3_get_var( ncid( incf ), "plev", l_plev )
   312:             !!$         do k = 1, km
   313:             !!$            if( plev( k ) .le. 0.0d0 ) then
   314:             !!$               write( 6, * ) 'Unexpected zero or negative pressure.'
   315:             !!$               write( 6, * ) k, plev( k )
   316:             !!$               stop
   317:             !!$            end if
   318:             !!$            if( plev( k ) .ne. l_plev( k ) ) then
   319:             !!$               write( 6, * ) 'pressure level is not identical.'
   320:             !!$               write( 6, * ) k, plev( k ), l_plev( k )
   321:             !!$               stop
   322:             !!$            end if
   323:             !!$         end do
   324:             !!$
   325:             !!$         call ni3_get_var( ncid( incf ), "imol", l_imol )
   326:             !!$         do iras = 1, nras
   327:             !!$            if( imol( iras ) .ne. l_imol( iras ) ) then
   328:             !!$               write( 6, * ) 'molecular number is not identical.'
   329:             !!$               write( 6, * ) iras, imol( iras ), l_imol( iras )
   330:             !!$               stop
   331:             !!$            end if
   332:             !!$         end do
   333:             !!$
   334:             !!$         call ni3_get_var( ncid( incf ), "t", l_t )
   335:             !!$         do k = 1+1, km
   336:             !!$            if( l_t( k ) .ne. l_t( 1 ) ) then
   337:             !!$               write( 6, * ) 'temperature is not isothermal.'
   338:             !!$               write( 6, * ) k, l_t( k ), l_t( 1 )
   339:             !!$               stop
   340:             !!$            end if
   341:             !!$         end do
   342:             !!$         temp( incf ) = l_t( 1 )
   343:             !!$         if( incf .ge. 2 ) then
   344:             !!$            if( temp( incf ) .le. temp( incf-1 ) ) then
   345:             !!$               write( 6, * ) 'Order of files is inappropriate.'
   346:             !!$               write( 6, * ) incf, temp( incf-1 ), temp( incf )
   347:             !!$               stop
   348:             !!$            end if
   349:             !!$         end if
   350:             !!$
   351:             !!$      end do
   352:             !!$
   353:             !!$      deallocate( l_wn, l_plev, l_t )
   354:             !!$
   355:             !!$
   356:             !!$      allocate( ckdp( nband ) )
   357:             !!$
   358:             !!$
   359:             !!$      iras = 1
   360:             !!$
   361:             !!$
   362:             !!$      do iband = 1, nband
   363:             !!$
   364:             !!$         ckdp( iband ) % imol        = imol( iras )
   365:             !!$
   366:             !!$         ckdp( iband ) % wnbnds( 1 ) = wnbnds_s( iband )
   367:             !!$         ckdp( iband ) % wnbnds( 2 ) = wnbnds_e( iband )
   368:             !!$
   369:             !!$
   370:             !!$         ckdp( iband ) % ng   = ngdiv( iband )
   371:             !!$         ckdp( iband ) % nlnp = km
   372:             !!$         ckdp( iband ) % nt   = tm
   373:             !!$
   374:             !!$         allocate( &
   375:             !!$              ckdp( iband ) % weight( ckdp( iband ) % ng   ), &
   376:             !!$              ckdp( iband ) % g     ( ckdp( iband ) % ng   ), &
   377:             !!$              ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
   378:             !!$              ckdp( iband ) % t     ( ckdp( iband ) % nt   )  &
   379:             !!$              )
   380:             !!$
   381:             !!$         allocate( &
   382:             !!$              ckdp( iband ) % g_ll  ( ckdp( iband ) % ng   ), &
   383:             !!$              ckdp( iband ) % g_ul  ( ckdp( iband ) % ng   )  &
   384:             !!$              )
   385:             !!$
   386:             !!$         allocate( &
   387:             !!$              ckdp( iband ) % lnac( ckdp(iband)%ng  ,  &
   388:             !!$                                    ckdp(iband)%nlnp,  &
   389:             !!$                                    ckdp(iband)%nt   ) &
   390:             !!$              )
   391:             !!$         allocate( &
   392:             !!$              ckdp( iband ) % pfr ( ckdp(iband)%ng  ,  &
   393:             !!$                                    ckdp(iband)%nlnp,  &
   394:             !!$                                    ckdp(iband)%nt   ) &
   395:             !!$              )
   396:             !!$
   397:             !!$
   398:             !!$         ckdp( iband ) % lnp( : ) = log( plev( : ) )
   399:             !!$         ckdp( iband ) % t  ( : ) = temp( : )
   400:             !!$
   401:             !!$      end do
   402:             !!$
   403:             !!$
   404:             !!$      deallocate( wnbnds_s, wnbnds_e, ngdiv )
   405:             !!$
   406:             !!$
   407:             !!$    end subroutine ckd_mktbl_init
   408:             !!$
   409:             !!$    !**************************************************************************
   410:             !!$
   411:             !!$    subroutine ckd_mktbl_end
   412:             !!$
   413:             !!$      use ni3_module
   414:             !!$
   415:             !!$      !
   416:             !!$      ! local variables
   417:             !!$      !
   418:             !!$      integer(i4b) :: incf, iband
   419:             !!$
   420:             !!$
   421:             !!$      do incf = 1, nncfile
   422:             !!$         call ni3_close( ncid( incf ) )
   423:             !!$      end do
   424:             !!$
   425:             !!$
   426:             !!$      deallocate( ncfn, ncid )
   427:             !!$      deallocate( temp )
   428:             !!$      deallocate( wn, plev, imol )
   429:             !!$
   430:             !!$
   431:             !!$      call ckd_deallocate_type
   432:             !!$
   433:             !!$
   434:             !!$    end subroutine ckd_mktbl_end
   435:             !!$
   436:             !!$    !**************************************************************************
   437:             !!$
   438:             !!$    subroutine ckd_deallocate_type
   439:             !!$
   440:             !!$
   441:             !!$      !
   442:             !!$      ! local variables
   443:             !!$      !
   444:             !!$      integer(i4b) :: iband
   445:             !!$
   446:             !!$
   447:             !!$      do iband = 1, nband
   448:             !!$         deallocate( ckdp( iband ) % weight, &
   449:             !!$                     ckdp( iband ) % g     , &
   450:             !!$                     ckdp( iband ) % lnp   , &
   451:             !!$                     ckdp( iband ) % t     )
   452:             !!$         deallocate( ckdp( iband ) % lnac )
   453:             !!$         deallocate( ckdp( iband ) % pfr  )
   454:             !!$      end do
   455:             !!$
   456:             !!$      deallocate( ckdp )
   457:             !!$
   458:             !!$
   459:             !!$      nband = -1
   460:             !!$
   461:             !!$
   462:             !!$    end subroutine ckd_deallocate_type
   463:             !!$
   464:             !!$    !**************************************************************************
   465:             !!$
   466:             !!$    subroutine ckd_mktbl
   467:             !!$
   468:             !!$      use ni3_module
   469:             !!$      use pf_module
   470:             !!$      use sort_module
   471:             !!$
   472:             !!$
   473:             !!$      !
   474:             !!$      ! local varialbles
   475:             !!$      !
   476:             !!$
   477:             !!$      real(dp)             , allocatable :: ac_1d( : ), pf_1d( : )
   478:             !!$
   479:             !!$      real(dp)                           :: wns, wne
   480:             !!$
   481:             !!$      real(dp)             , allocatable :: ac_i( : )
   482:             !!$      real(dp)             , allocatable :: pfrat( : )
   483:             !!$
   484:             !!$
   485:             !!$      integer(i4b)                       :: k, incf, iband, iras, ig
   486:             !!$      integer(i4b)                       :: iwn
   487:             !!$      integer(i4b)                       :: iwns, iwne
   488:             !!$
   489:             !!$
   490:             !!$
   491:             !!$      iras = 1
   492:             !!$
   493:             !!$      do iband = 1, nband
   494:             !!$         wns = ckdp( iband ) % wnbnds( 1 )
   495:             !!$         wne = ckdp( iband ) % wnbnds( 2 )
   496:             !!$
   497:             !!$
   498:             !!$         call search_wnindices( nwn, wn, wns, wne, iwns, iwne )
   499:             !!$         write( 6, *             ) &
   500:             !!$              'band ', iband, ' : wns = ', wns, ', wne = ', wne
   501:             !!$         write( 6, '(a,i10,a,f)' ) '  wn( ', iwns, ') = ', wn( iwns )
   502:             !!$         write( 6, '(a,i10,a,f)' ) '  wn( ', iwne, ') = ', wn( iwne )
   503:             !!$
   504:             !!$
   505:             !!$         allocate( ac_1d( iwne - iwns + 1 ) )
   506:             !!$         allocate( pf_1d( iwne - iwns + 1 ) )
   507:             !!$         allocate( ac_i ( ckdp( iband ) % ng ) )
   508:             !!$         allocate( pfrat( ckdp( iband ) % ng ) )
   509:             !!$
   510:             !!$
   511:             !!$
   512:             !!$
   513:             !!$!         do ig = 1, ckdp( iband ) % ng
   514:             !!$!#if defined CONST_WEIGHT || defined THROUGH
   515:             !!$!            ckdp( iband ) % g     ( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
   516:             !!$!                 * ( dble( ig - 1 ) + 0.5d0 )
   517:             !!$!            ckdp( iband ) % weight( ig ) = 1.0d0 / dble( ckdp( iband ) % ng )
   518:             !!$!#else
   519:             !!$!            call gauleg( 0.0d0, 1.0d0, &
   520:             !!$!                 ckdp(iband)%ng, ckdp(iband)%g, ckdp(iband)%weight )
   521:             !!$!#endif
   522:             !!$!         end do
   523:             !!$
   524:             !!$         call set_g( iband, iwns, iwne, iras )
   525:             !!$
   526:             !!$
   527:             !!$
   528:             !!$
   529:             !!$         do incf = 1, nncfile
   530:             !!$
   531:             !!$            do k = 1, km
   532:             !!$
   533:             !!$               call readac( ncid( incf ), iwne-iwns+1, ac_1d, iras, k, iwns, iwne )
   534:             !!$
   535:             !!$               do iwn = 1, iwne-iwns+1
   536:             !!$                  pf_1d( iwn ) = pf( wn( iwn+iwns-1 ), temp( incf ) )
   537:             !!$               end do
   538:             !!$
   539:             !!$
   540:             !!$!            if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
   541:             !!$!               do iwn = 1, iwne-iwns+1
   542:             !!$!                  write( 60, * ) wn( iwns-1+iwn ) * 1.0d-2, &
   543:             !!$!                       ac_1d( iwn ), pf_1d( iwn )
   544:             !!$!               end do
   545:             !!$!            end if
   546:             !!$
   547:             !!$
   548:             !!$#ifdef THROUGH
   549:             !!$#ifdef THROUGH_SORT
   550:             !!$               call sort_quick( iwne-iwns+1, ac_1d, pf_1d )
   551:             !!$#endif
   552:             !!$#else
   553:             !!$               call sort_quick( iwne-iwns+1, ac_1d, pf_1d )
   554:             !!$#endif
   555:             !!$
   556:             !!$
   557:             !!$!            if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
   558:             !!$!               do iwn = 1, iwne-iwns+1
   559:             !!$!                  write( 61, * ) dble( iwn-1+0.5d0 ) / ( iwne-iwns+1 ), &
   560:             !!$!                       ac_1d( iwn ), pf_1d( iwn )
   561:             !!$!               end do
   562:             !!$!            end if
   563:             !!$
   564:             !!$
   565:             !!$#ifdef THROUGH
   566:             !!$
   567:             !!$               if( ckdp( iband ) % ng .ne. iwne-iwns+1 ) then
   568:             !!$                  write( 6, * ) 'ng is equal to iwne-iwns+1.'
   569:             !!$                  write( 6, * ) ckdp( iband ) % ng, iwne-iwns+1
   570:             !!$                  stop
   571:             !!$               end if
   572:             !!$               do ig = 1, ckdp( iband ) % ng
   573:             !!$                  iwn = ig
   574:             !!$                  ckdp( iband ) % lnac( ig, k, incf ) = ac_1d( iwn )
   575:             !!$                  ckdp( iband ) % pfr ( ig, k, incf ) = pf_1d( iwn ) &
   576:             !!$                       / pfint( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
   577:             !!$                                5, ckdp(iband)%t(incf) ) &
   578:             !!$                       * ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
   579:             !!$               end do
   580:             !!$
   581:             !!$#else
   582:             !!$
   583:             !!$               call calcpfratio( iwne-iwns+1, pf_1d, &
   584:             !!$                    ckdp( iband ) % ng, ckdp( iband ) % weight, pfrat )
   585:             !!$
   586:             !!$
   587:             !!$               do ig = 1, ckdp( iband ) % ng
   588:             !!$                  iwn = ckdp( iband ) % g( ig ) * ( iwne-iwns+1 )
   589:             !!$                  iwn = max( iwn, 1 )
   590:             !!$
   591:             !!$                  if( ( iwn .le. 0 ) .or. ( iwn .ge. iwne-iwns+1 ) )then
   592:             !!$                     write( 6, * ) 'iwn is inappropriate.'
   593:             !!$                     write( 6, * ) iwn, iwne-iwns+1
   594:             !!$                     stop
   595:             !!$                  else
   596:             !!$                     if(  ( ac_1d( iwn   ) .ne. 0.0d0 ) .and. &
   597:             !!$                          ( ac_1d( iwn+1 ) .ne. 0.0d0 ) ) then
   598:             !!$                        ac_i( ig ) = log( ac_1d( iwn+1 ) / ac_1d( iwn ) ) &
   599:             !!$                             / ( 1.0d0 / dble( iwne-iwns+1 ) ) &
   600:             !!$                             * ( ckdp( iband ) % g( ig ) &
   601:             !!$                               - dble( iwn-1+0.5d0 ) / dble( iwne-iwns+1 ) ) &
   602:             !!$                             + log( ac_1d( iwn ) )
   603:             !!$                        ac_i( ig ) = exp( ac_i( ig ) )
   604:             !!$                     else
   605:             !!$                        ac_i( ig ) = 0.0d0
   606:             !!$                     end if
   607:             !!$                  end if
   608:             !!$
   609:             !!$
   610:             !!$                  ckdp( iband ) % lnac( ig, k, incf ) = ac_i ( ig )
   611:             !!$                  ckdp( iband ) % pfr ( ig, k, incf ) = pfrat( ig )
   612:             !!$
   613:             !!$!               if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
   614:             !!$!                  write( 62, * ) actbl_g( ig ), ac_i( ig ), pfrat( ig )
   615:             !!$!               end if
   616:             !!$
   617:             !!$               end do
   618:             !!$
   619:             !!$#endif
   620:             !!$
   621:             !!$
   622:             !!$            end do
   623:             !!$
   624:             !!$         end do
   625:             !!$
   626:             !!$         deallocate( ac_1d )
   627:             !!$         deallocate( pf_1d )
   628:             !!$         deallocate( ac_i  )
   629:             !!$         deallocate( pfrat )
   630:             !!$
   631:             !!$         do incf = 1, nncfile
   632:             !!$            do k = 1, km
   633:             !!$               do ig = 1, ckdp( iband ) % ng
   634:             !!$                  if( ckdp( iband ) % lnac( ig, k, incf ) .gt. 0.0d0 ) then
   635:             !!$                     ckdp( iband ) % lnac( ig, k, incf ) &
   636:             !!$                          = log( ckdp( iband ) % lnac( ig, k, incf ) )
   637:             !!$                  else
   638:             !!$                     ckdp( iband ) % lnac( ig, k, incf ) = 0.0d0
   639:             !!$                  end if
   640:             !!$               end do
   641:             !!$            end do
   642:             !!$         end do
   643:             !!$
   644:             !!$      end do
   645:             !!$
   646:             !!$      !************************************************************************
   647:             !!$
   648:             !!$    contains
   649:             !!$
   650:             !!$      !************************************************************************
   651:             !!$
   652:             !!$      subroutine set_g( iband, iwns, iwne, iras )
   653:             !!$
   654:             !!$
   655:             !!$        integer(i4b), intent(in ) :: iband, iwns, iwne, iras
   656:             !!$
   657:             !!$
   658:             !!$
   659:             !!$        !
   660:             !!$        ! local variables
   661:             !!$        !
   662:             !!$        real(dp)     :: ac_1d( iwne-iwns+1 ), ac_min, ac_max, lnac_ul, ac_ul
   663:             !!$#ifdef G_RRTM
   664:             !!$        real(dp)     :: rrtm_ul( 16 )
   665:             !!$        data rrtm_ul &
   666:             !!$             /0.15275d0, 0.30192d0, 0.44402d0, 0.57571d0, 0.69390d0, &
   667:             !!$              0.79583d0, 0.87911d0, 0.94178d0, 0.98427d0, 0.98890d0, &
   668:             !!$              0.99273d0, 0.99576d0, 0.99798d0, 0.99939d0, 0.99993d0, &
   669:             !!$              1.00000d0/
   670:             !!$#endif
   671:             !!$
   672:             !!$        integer(i4b) :: k, ig, incf
   673:             !!$
   674:             !!$
   675:             !!$
   676:             !!$#if defined CONST_WEIGHT || defined THROUGH
   677:             !!$
   678:             !!$!         do ig = 1, ckdp( iband ) % ng
   679:             !!$!            ckdp( iband ) % g     ( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
   680:             !!$!                 * ( dble( ig - 1 ) + 0.5d0 )
   681:             !!$!            ckdp( iband ) % weight( ig ) = 1.0d0 / dble( ckdp( iband ) % ng )
   682:             !!$!         end do
   683:             !!$
   684:             !!$         do ig = 1, ckdp( iband ) % ng - 1
   685:             !!$            ckdp( iband ) % g_ul( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
   686:             !!$                 * dble( ig )
   687:             !!$         end do
   688:             !!$         ig = ckdp( iband ) % ng
   689:             !!$         ckdp( iband ) % g_ul( ig ) = 1.0d0
   690:             !!$         ig = 1
   691:             !!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
   692:             !!$         do ig = 1+1, ckdp( iband ) % ng
   693:             !!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
   694:             !!$         end do
   695:             !!$         do ig = 1, ckdp( iband ) % ng
   696:             !!$            ckdp( iband ) % g     ( ig ) &
   697:             !!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
   698:             !!$                 * 0.5d0
   699:             !!$            ckdp( iband ) % weight( ig ) &
   700:             !!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
   701:             !!$         end do
   702:             !!$
   703:             !!$#else
   704:             !!$#ifdef G_CONST_LNAC
   705:             !!$
   706:             !!$         incf = 1
   707:             !!$         k    = 1
   708:             !!$         write( 6, * ) 'Temperature in reference layer : ', temp( incf )
   709:             !!$         write( 6, * ) 'Pressure    in reference layer : ', &
   710:             !!$              exp( ckdp( iband ) % lnp( k ) )
   711:             !!$
   712:             !!$         call readac( ncid( incf ), iwne-iwns+1, ac_1d, iras, k, iwns, iwne )
   713:             !!$
   714:             !!$         call sort_quick( iwne-iwns+1, ac_1d )
   715:             !!$
   716:             !!$         do iwn = 1, iwne-iwns+1
   717:             !!$            if( ac_1d( iwn ) .ne. 0.0d0 ) exit
   718:             !!$         end do
   719:             !!$
   720:             !!$         ac_min = ac_1d( iwn         )
   721:             !!$         ac_max = ac_1d( iwne-iwns+1 )
   722:             !!$         do ig = 1, ckdp( iband ) % ng - 1
   723:             !!$            lnac_ul = log( ac_max / ac_min ) / ckdp( iband ) % ng * ig &
   724:             !!$                 + log( ac_min )
   725:             !!$            ac_ul = exp( lnac_ul )
   726:             !!$            do iwn = 1+1, iwne-iwns+1
   727:             !!$               if( ac_1d( iwn ) .gt. ac_ul ) exit
   728:             !!$            end do
   729:             !!$            iwn = iwn - 1
   730:             !!$
   731:             !!$!            iwn = min( iwn, iwne-iwns+1 - ( ckdp( iband ) % ng - ig ) )
   732:             !!$!            ckdp( iband ) % g_ul( ig ) = dble( iwn ) / dble( iwne-iwns+1 )
   733:             !!$
   734:             !!$            iwn = min( iwn, iwne-iwns+1-1 )
   735:             !!$            ckdp( iband ) % g_ul( ig )                  &
   736:             !!$                 = 1.0d0 / dble( iwne-iwns+1 )          &
   737:             !!$                 / log( ac_1d( iwn+1 ) / ac_1d( iwn ) ) &
   738:             !!$                 * ( lnac_ul - log( ac_1d( iwn ) ) )    &
   739:             !!$                 + dble( iwn ) / dble( iwne-iwns+1 )
   740:             !!$         end do
   741:             !!$         ig = ckdp( iband ) % ng
   742:             !!$         ckdp( iband ) % g_ul( ig ) = 1.0d0
   743:             !!$         ig = 1
   744:             !!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
   745:             !!$         do ig = 1+1, ckdp( iband ) % ng
   746:             !!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
   747:             !!$         end do
   748:             !!$         do ig = 1, ckdp( iband ) % ng
   749:             !!$            ckdp( iband ) % g     ( ig ) &
   750:             !!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
   751:             !!$                 * 0.5d0
   752:             !!$            ckdp( iband ) % weight( ig ) &
   753:             !!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
   754:             !!$         end do
   755:             !!$
   756:             !!$
   757:             !!$#else
   758:             !!$#ifdef G_RRTM
   759:             !!$
   760:             !!$         if( ckdp( iband ) % ng .ne. 16 ) then
   761:             !!$            write( 6, * ) 'ng is not equal to 16'
   762:             !!$            write( 6, * ) iband, ckdp( iband ) % ng
   763:             !!$            stop
   764:             !!$         end if
   765:             !!$
   766:             !!$         do ig = 1, ckdp( iband ) % ng
   767:             !!$            ckdp( iband ) % g_ul( ig ) = rrtm_ul( ig )
   768:             !!$         end do
   769:             !!$         ig = 1
   770:             !!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
   771:             !!$         do ig = 1+1, ckdp( iband ) % ng
   772:             !!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
   773:             !!$         end do
   774:             !!$         do ig = 1, ckdp( iband ) % ng
   775:             !!$            ckdp( iband ) % g     ( ig ) &
   776:             !!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
   777:             !!$                 * 0.5d0
   778:             !!$            ckdp( iband ) % weight( ig ) &
   779:             !!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
   780:             !!$         end do
   781:             !!$
   782:             !!$#else
   783:             !!$         do ig = 1, ckdp( iband ) % ng
   784:             !!$            call gauleg( 0.0d0, 1.0d0, &
   785:             !!$                 ckdp(iband)%ng, ckdp(iband)%g, ckdp(iband)%weight )
   786:             !!$         end do
   787:             !!$
   788:             !!$         ig = 1
   789:             !!$         ckdp( iband ) % g_ul( ig ) = ckdp( iband ) % weight( ig )
   790:             !!$         do ig = 1+1, ckdp( iband ) % ng
   791:             !!$            ckdp( iband ) % g_ul( ig ) = ckdp( iband ) % g_ul( ig-1 ) &
   792:             !!$                 + ckdp( iband ) % weight( ig )
   793:             !!$         end do
   794:             !!$         ig = 1
   795:             !!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
   796:             !!$         do ig = 1+1, ckdp( iband ) % ng
   797:             !!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
   798:             !!$         end do
   799:             !!$
   800:             !!$#endif     !#ifdef G_RRTM
   801:             !!$#endif     !#ifdef G_CONST_LNAC
   802:             !!$#endif     !#if defined CONST_WEIGHT || defined THROUGH
   803:             !!$
   804:             !!$
   805:             !!$         !
   806:             !!$         ! check
   807:             !!$         !
   808:             !!$         do ig = 1, ckdp( iband ) % ng
   809:             !!$            if( ckdp( iband ) % weight( ig ) .eq. 0.0d0 ) then
   810:             !!$               write( 6, * ) 'weight is zero'
   811:             !!$               write( 6, * ) iband, ig, ckdp( iband ) % weight( ig )
   812:             !!$               stop
   813:             !!$            end if
   814:             !!$         end do
   815:             !!$
   816:             !!$
   817:             !!$!         do ig = 1, ckdp( iband ) % ng
   818:             !!$!            write( 21, * ) ig, &
   819:             !!$!                 ckdp( iband ) % g_ll( ig ), ckdp( iband ) % g_ul( ig ), &
   820:             !!$!                 ckdp( iband ) % g   ( ig ), ckdp( iband ) % weight( ig )
   821:             !!$!         end do
   822:             !!$!         stop
   823:             !!$
   824:             !!$
   825:             !!$       end subroutine set_g
   826:             !!$
   827:             !!$      !************************************************************************
   828:             !!$
   829:             !!$      subroutine search_wnindices( nwn, wn, wns, wne, iwns, iwne )
   830:             !!$
   831:             !!$        integer(i4b), intent(in ) :: nwn
   832:             !!$        real(dp)    , intent(in ) :: wn( nwn ), wns, wne
   833:             !!$        integer(i4b), intent(out) :: iwns, iwne
   834:             !!$
   835:             !!$
   836:             !!$        !
   837:             !!$        ! local variables
   838:             !!$        !
   839:             !!$        integer(i4b) :: iwn
   840:             !!$
   841:             !!$
   842:             !!$        iwns = 0
   843:             !!$        iwne = 1
   844:             !!$        do iwn = 1, nwn
   845:             !!$           if( wn( iwn ) .lt. wns ) iwns = iwn
   846:             !!$           if( wn( iwn ) .le. wne ) iwne = iwn
   847:             !!$        end do
   848:             !!$        iwns = iwns + 1
   849:             !!$
   850:             !!$
   851:             !!$        if( iwns .gt. iwne ) then
   852:             !!$           write( 6, * ) 'iwns is greater than iwne.'
   853:             !!$           write( 6, * ) iwns, wn( iwns )
   854:             !!$           write( 6, * ) iwne, wn( iwne )
   855:             !!$           stop
   856:             !!$        end if
   857:             !!$
   858:             !!$
   859:             !!$      end subroutine search_wnindices
   860:             !!$
   861:             !!$      !************************************************************************
   862:             !!$
   863:             !!$      subroutine readac( ncid, nwn, ac_1d, iras, k, iwns, iwne )
   864:             !!$
   865:             !!$        use netcdf
   866:             !!$
   867:             !!$        integer(i4b), intent(in ) :: ncid, nwn
   868:             !!$        real(dp)    , intent(out) :: ac_1d( nwn )
   869:             !!$        integer(i4b), intent(in ) :: iras, k, iwns, iwne
   870:             !!$
   871:             !!$
   872:             !!$        !
   873:             !!$        ! local variables
   874:             !!$        !
   875:             !!$        real(dp)              :: l_ac( nwn, 1, 1 )
   876:             !!$        integer(i4b)          :: varid
   877:             !!$        integer(i4b)          :: istatus
   878:             !!$        character(len=extstr) :: err_mes = "in readac"
   879:             !!$        integer(i4b)          :: st( 3 ), co( 3 )
   880:             !!$
   881:             !!$
   882:             !!$        call ni3_inq_var( ncid, "ac", varid )
   883:             !!$        call ni3_enddef( ncid )
   884:             !!$
   885:             !!$
   886:             !!$        st( 1 ) = iwns
   887:             !!$        st( 2 ) = k
   888:             !!$        st( 3 ) = iras
   889:             !!$        co( 1 ) = iwne - iwns + 1
   890:             !!$        co( 2 ) = 1
   891:             !!$        co( 3 ) = 1
   892:             !!$        istatus = nf90_get_var( ncid, varid, l_ac, start = st, count = co )
   893:             !!$        call ni3_handle_err( istatus, err_mes )
   894:             !!$
   895:             !!$
   896:             !!$        ac_1d( : ) = l_ac( :, 1, 1 )
   897:             !!$
   898:             !!$
   899:             !!$      end subroutine readac
   900:             !!$
   901:             !!$      !************************************************************************
   902:             !!$
   903:             !!$      subroutine calcpfratio( nwn, pf_1d, ncp, weight, pfrat )
   904:             !!$
   905:             !!$        integer(i4b), intent(in ) :: nwn
   906:             !!$        real(dp)    , intent(in ) :: pf_1d( nwn )
   907:             !!$        integer(i4b), intent(in ) :: ncp
   908:             !!$        real(dp)    , intent(in ) :: weight( ncp )
   909:             !!$        real(dp)    , intent(out) :: pfrat( ncp )
   910:             !!$
   911:             !!$
   912:             !!$        !
   913:             !!$        ! local variables
   914:             !!$        !
   915:             !!$        real(dp)     :: weight_sum, weight_sum_p, x1, x2, dg, pf_sum
   916:             !!$        integer(i4b) :: n, iwn, iwns, iwne, iwn1, iwn2
   917:             !!$
   918:             !!$
   919:             !!$        weight_sum_p  = 0.0d0
   920:             !!$        weight_sum    = 0.0d0
   921:             !!$        pfrat( : ) = 0.0d0
   922:             !!$        iwne       = 1-1
   923:             !!$        do n = 1, ncp
   924:             !!$           weight_sum = weight_sum + weight( n )
   925:             !!$           if( n .eq. ncp ) weight_sum = 1.0d0
   926:             !!$           if( weight_sum .gt. 1.0d0 ) then
   927:             !!$              write( 6, * ) 'weight_sum is greater than 1.'
   928:             !!$              write( 6, * ) weight_sum
   929:             !!$              stop
   930:             !!$           end if
   931:             !!$
   932:             !!$           iwns = iwne + 1
   933:             !!$           iwne = weight_sum * dble( nwn )
   934:             !!$           iwn1 = max( iwns-1, 1   )
   935:             !!$           iwn2 = min( iwne+1, nwn )
   936:             !!$           do iwn = iwn1, iwn2
   937:             !!$              x1 = max( dble( iwn-1 ) / dble( nwn ), weight_sum_p )
   938:             !!$              x2 = min( dble( iwn   ) / dble( nwn ), weight_sum   )
   939:             !!$              dg = max( x2 - x1, 0.0d0 )
   940:             !!$              pfrat( n ) = pfrat( n ) + pf_1d( iwn ) * dg
   941:             !!$           end do
   942:             !!$           weight_sum_p = weight_sum
   943:             !!$        end do
   944:             !!$
   945:             !!$        pf_sum = 0.0d0
   946:             !!$        do n = 1, ncp
   947:             !!$           pf_sum = pf_sum + pfrat( n )
   948:             !!$        end do
   949:             !!$
   950:             !!$        pfrat( : ) = pfrat( : ) / pf_sum / weight( : )
   951:             !!$
   952:             !!$
   953:             !!$      end subroutine calcpfratio
   954:             !!$
   955:             !!$      !************************************************************************
   956:             !!$
   957:             !!$    end subroutine ckd_mktbl
   958:             !!$
   959:             !!$    !**************************************************************************
   960:             !!$
   961:             !!$    subroutine ckd_output
   962:             !!$
   963:             !!$      use fi_module
   964:             !!$      use ni3_module
   965:             !!$      use netcdf
   966:             !!$
   967:             !!$
   968:             !!$      !
   969:             !!$      ! local variables
   970:             !!$      !
   971:             !!$      integer(i4b)                       :: ctlfu
   972:             !!$      character(len=extstr)              :: ncfn_out
   973:             !!$      integer(i4b)                       :: ncid_out
   974:             !!$      character(len=extstr)              :: comment
   975:             !!$      integer(i4b)                       :: ndims
   976:             !!$      character(len=extstr), allocatable :: dimnames( : )
   977:             !!$      character(len=extstr)              :: name_bnds, name_weight, &
   978:             !!$           name_g, name_lnac, name_pfr
   979:             !!$
   980:             !!$      integer(i4b)                       :: istatus
   981:             !!$      integer(i4b)                       :: iband
   982:             !!$
   983:             !!$
   984:             !!$      namelist /output_nc/ ncfn_out, comment
   985:             !!$
   986:             !!$
   987:             !!$      call fi_open( ctlfn, "read", ctlfu )
   988:             !!$      ncfn_out = "out.nc"
   989:             !!$      comment  = "comment"
   990:             !!$      read( ctlfu, output_nc )
   991:             !!$      close( ctlfu )
   992:             !!$
   993:             !!$
   994:             !!$      call ni3_open( ncfn_out, "new", ncid_out )
   995:             !!$
   996:             !!$      comment = "comment"
   997:             !!$      istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "comment", comment )
   998:             !!$      call ni3_handle_err( istatus )
   999:             !!$
  1000:             !!$      istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "nband", nband )
  1001:             !!$      call ni3_handle_err( istatus )
  1002:             !!$
  1003:             !!$      call ni3_set_dim( ncid_out, "lnp" , NF90_DOUBLE, ckdp( 1 ) % lnp )
  1004:             !!$      call ni3_set_dim( ncid_out, "t"   , NF90_DOUBLE, ckdp( 1 ) % t   )
  1005:             !!$
  1006:             !!$      call ni3_def_dim( ncid_out, "bnds", NF90_DOUBLE, 2 )
  1007:             !!$
  1008:             !!$      do iband = 1, nband
  1009:             !!$         istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "imol", ckdp(iband)%imol )
  1010:             !!$         call ni3_handle_err( istatus )
  1011:             !!$
  1012:             !!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
  1013:             !!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
  1014:             !!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
  1015:             !!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
  1016:             !!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
  1017:             !!$
  1018:             !!$         call ni3_set_dim( ncid_out, name_g, NF90_DOUBLE, ckdp(iband)%g   )
  1019:             !!$
  1020:             !!$         ndims = 1
  1021:             !!$         allocate( dimnames( ndims ) )
  1022:             !!$         dimnames( 1 ) = name_g
  1023:             !!$         call ni3_def_var( ncid_out, name_weight, NF90_DOUBLE, ndims, dimnames )
  1024:             !!$         deallocate( dimnames )
  1025:             !!$
  1026:             !!$         ndims = 1
  1027:             !!$         allocate( dimnames( ndims ) )
  1028:             !!$         dimnames( 1 ) = "bnds"
  1029:             !!$         call ni3_def_var( ncid_out, name_bnds, NF90_DOUBLE, ndims, dimnames )
  1030:             !!$         deallocate( dimnames )
  1031:             !!$
  1032:             !!$         ndims = 3
  1033:             !!$         allocate( dimnames( ndims ) )
  1034:             !!$         dimnames( 1 ) = name_g
  1035:             !!$         dimnames( 2 ) = "lnp"
  1036:             !!$         dimnames( 3 ) = "t"
  1037:             !!$         call ni3_def_var( ncid_out, name_lnac, NF90_DOUBLE, ndims, dimnames )
  1038:             !!$         call ni3_def_var( ncid_out, name_pfr , NF90_DOUBLE, ndims, dimnames )
  1039:             !!$         deallocate( dimnames )
  1040:             !!$
  1041:             !!$         call ni3_put_var( ncid_out, name_weight, ckdp(iband)%weight )
  1042:             !!$
  1043:             !!$         call ni3_put_var( ncid_out, name_bnds  , ckdp(iband)%wnbnds )
  1044:             !!$
  1045:             !!$         call ni3_put_var( ncid_out, name_lnac  , ckdp(iband)%lnac   )
  1046:             !!$         call ni3_put_var( ncid_out, name_pfr   , ckdp(iband)%pfr    )
  1047:             !!$      end do
  1048:             !!$
  1049:             !!$      call ni3_close( ncid_out )
  1050:             !!$
  1051:             !!$
  1052:             !!$    end subroutine ckd_output
  1053:             !!$
  1054:             !!$    !**************************************************************************
  1055:             !!$
  1056:             !!$#endif
  1057:             !!$    !**************************************************************************
  1058:             !!$
  1059:             !!$    subroutine ckd_output_ascii
  1060:             !!$
  1061:             !!$      use fi_module
  1062:             !!$
  1063:             !!$
  1064:             !!$      !
  1065:             !!$      ! local variables
  1066:             !!$      !
  1067:             !!$      integer(i4b)                       :: ctlfu
  1068:             !!$      character(len=extstr)              :: fn_out
  1069:             !!$      integer(i4b)                       :: fu_out
  1070:             !!$      character(len=extstr)              :: comment
  1071:             !!$      character(len=extstr)              :: name_bnds, name_weight, &
  1072:             !!$           name_g, name_lnac, name_pfr
  1073:             !!$
  1074:             !!$      integer(i4b)                       :: iband
  1075:             !!$
  1076:             !!$      namelist /output_ascii/ fn_out, comment
  1077:             !!$
  1078:             !!$
  1079:             !!$      call fi_open( ctlfn, "read", ctlfu )
  1080:             !!$      fn_out  = "out.txt"
  1081:             !!$      comment = "comment"
  1082:             !!$      read( ctlfu, output_ascii )
  1083:             !!$      close( ctlfu )
  1084:             !!$
  1085:             !!$
  1086:             !!$      call fi_open( fn_out, "write", fu_out )
  1087:             !!$
  1088:             !!$      write( fu_out, * ) comment
  1089:             !!$      write( 6, * ) 'Comment         : ', trim( comment )
  1090:             !!$
  1091:             !!$      write( fu_out, * ) nband
  1092:             !!$      write( 6, * ) 'Number of bands : ', nband
  1093:             !!$
  1094:             !!$      write( fu_out, * ) ckdp( 1 ) % nlnp
  1095:             !!$      write( fu_out, * ) ckdp( 1 ) % lnp
  1096:             !!$
  1097:             !!$      write( fu_out, * ) ckdp( 1 ) % nt
  1098:             !!$      write( fu_out, * ) ckdp( 1 ) % t
  1099:             !!$
  1100:             !!$      do iband = 1, nband
  1101:             !!$         write( fu_out, * ) ckdp( iband ) % imol
  1102:             !!$
  1103:             !!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
  1104:             !!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
  1105:             !!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
  1106:             !!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
  1107:             !!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
  1108:             !!$
  1109:             !!$         write( fu_out, * ) trim( name_g      )
  1110:             !!$         write( fu_out, * ) ckdp( iband ) % ng
  1111:             !!$         write( fu_out, * ) ckdp( iband ) % g
  1112:             !!$
  1113:             !!$         write( fu_out, * ) trim( name_weight )
  1114:             !!$         write( fu_out, * ) ckdp( iband ) % weight
  1115:             !!$
  1116:             !!$         write( fu_out, * ) trim( name_bnds   )
  1117:             !!$         write( fu_out, * ) ckdp( iband ) % wnbnds
  1118:             !!$
  1119:             !!$         write( fu_out, * ) trim( name_lnac   )
  1120:             !!$         write( fu_out, * ) ckdp( iband ) % lnac
  1121:             !!$
  1122:             !!$         write( fu_out, * ) trim( name_pfr    )
  1123:             !!$         write( fu_out, * ) ckdp( iband ) % pfr
  1124:             !!$      end do
  1125:             !!$
  1126:             !!$      close( fu_out )
  1127:             !!$
  1128:             !!$
  1129:             !!$    end subroutine ckd_output_ascii
  1130:             !!$
  1131:             !!$    !**************************************************************************
  1132:             !!$
  1133:             !!$    subroutine ckd_input_ascii( fn_in )
  1134:             !!$
  1135:             !!$      use fi_module
  1136:             !!$
  1137:             !!$      character(len=*), intent(in) :: fn_in
  1138:             !!$
  1139:             !!$      !
  1140:             !!$      ! local variables
  1141:             !!$      !
  1142:             !!$!      integer(i4b)              :: ctlfu
  1143:             !!$
  1144:             !!$!      character(len=extstr)              :: fn_in
  1145:             !!$      integer(i4b)                       :: fu_in
  1146:             !!$      character(len=extstr)              :: comment
  1147:             !!$
  1148:             !!$      character(len=extstr)              :: name_bnds, name_weight, &
  1149:             !!$           name_g, name_lnac, name_pfr
  1150:             !!$
  1151:             !!$      character(len=extstr)              :: line
  1152:             !!$      integer(i4b)                       :: iband, ig
  1153:             !!$
  1154:             !!$!      namelist /input_ascii/ fn_in
  1155:             !!$!
  1156:             !!$!
  1157:             !!$!      call fi_open( ctlfn, "read", ctlfu )
  1158:             !!$!      fn_in = "out.txt"
  1159:             !!$!      read( ctlfu, input_ascii )
  1160:             !!$!      close( ctlfu )
  1161:             !!$
  1162:             !!$
  1163:             !!$      call fi_open( fn_in, "read", fu_in )
  1164:             !!$
  1165:             !!$      read( fu_in, * ) comment
  1166:             !!$      write( 6, * ) 'Comment         : ', trim( comment )
  1167:             !!$
  1168:             !!$      read( fu_in, * ) nband
  1169:             !!$      write( 6, * ) 'Number of bands : ', nband
  1170:             !!$
  1171:             !!$      allocate( ckdp( nband ) )
  1172:             !!$
  1173:             !!$      read( fu_in, * ) ckdp( 1 ) % nlnp
  1174:             !!$      allocate( ckdp( 1 ) % lnp   ( ckdp( 1 ) % nlnp ) )
  1175:             !!$      read( fu_in, * ) ckdp( 1 ) % lnp
  1176:             !!$
  1177:             !!$      read( fu_in, * ) ckdp( 1 ) % nt
  1178:             !!$      allocate( ckdp( 1 ) % t     ( ckdp( 1 ) % nt   ) )
  1179:             !!$      read( fu_in, * ) ckdp( 1 ) % t
  1180:             !!$
  1181:             !!$      do iband = 1+1, nband
  1182:             !!$         ckdp( iband ) % nlnp = ckdp( 1 ) % nlnp
  1183:             !!$         ckdp( iband ) % nt   = ckdp( 1 ) % nt
  1184:             !!$         allocate( ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
  1185:             !!$                   ckdp( iband ) % t     ( ckdp( iband ) % nt   )  )
  1186:             !!$         ckdp( iband ) % lnp( : ) = ckdp( 1 ) % lnp( : )
  1187:             !!$         ckdp( iband ) % t  ( : ) = ckdp( 1 ) % t  ( : )
  1188:             !!$      end do
  1189:             !!$
  1190:             !!$      do iband = 1, nband
  1191:             !!$         write( 6, * ) 'band ', iband 
  1192:             !!$
  1193:             !!$         read( fu_in, * ) ckdp( iband ) % imol
  1194:             !!$
  1195:             !!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
  1196:             !!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
  1197:             !!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
  1198:             !!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
  1199:             !!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
  1200:             !!$
  1201:             !!$
  1202:             !!$         read( fu_in, * ) line
  1203:             !!$         if( name_g      .ne. line ) then
  1204:             !!$            write( 6, * ) 'Input file is invalid.'
  1205:             !!$            write( 6, * ) trim( name_g )
  1206:             !!$            write( 6, * ) trim( line   )
  1207:             !!$            stop
  1208:             !!$         end if
  1209:             !!$         read( fu_in, * ) ckdp( iband ) % ng
  1210:             !!$         allocate( ckdp( iband ) % g     ( ckdp( iband ) % ng   )  )
  1211:             !!$         read( fu_in, * ) ckdp( iband ) % g
  1212:             !!$
  1213:             !!$         allocate( ckdp( iband ) % weight( ckdp( iband ) % ng   ) )
  1214:             !!$
  1215:             !!$         allocate( &
  1216:             !!$              ckdp( iband ) % lnac( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
  1217:             !!$              )
  1218:             !!$         allocate( &
  1219:             !!$              ckdp( iband ) % pfr ( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
  1220:             !!$              )
  1221:             !!$
  1222:             !!$         read( fu_in, * ) line
  1223:             !!$         if( name_weight .ne. line ) then
  1224:             !!$            write( 6, * ) 'Input file is invalid.'
  1225:             !!$            write( 6, * ) trim( name_weight )
  1226:             !!$            write( 6, * ) trim( line        )
  1227:             !!$            stop
  1228:             !!$         end if
  1229:             !!$         read( fu_in, * ) ckdp( iband ) % weight
  1230:             !!$
  1231:             !!$         read( fu_in, * ) line
  1232:             !!$         if( name_bnds   .ne. line ) then
  1233:             !!$            write( 6, * ) 'Input file is invalid.'
  1234:             !!$            write( 6, * ) trim( name_bnds   )
  1235:             !!$            write( 6, * ) trim( line        )
  1236:             !!$            stop
  1237:             !!$         end if
  1238:             !!$         read( fu_in, * ) ckdp( iband ) % wnbnds
  1239:             !!$
  1240:             !!$         read( fu_in, * ) line
  1241:             !!$         if( name_lnac   .ne. line ) then
  1242:             !!$            write( 6, * ) 'Input file is invalid.'
  1243:             !!$            write( 6, * ) trim( name_lnac   )
  1244:             !!$            write( 6, * ) trim( line        )
  1245:             !!$            stop
  1246:             !!$         end if
  1247:             !!$         read( fu_in, * ) ckdp( iband ) % lnac
  1248:             !!$
  1249:             !!$         read( fu_in, * ) line
  1250:             !!$         if( name_pfr    .ne. line ) then
  1251:             !!$            write( 6, * ) 'Input file is invalid.'
  1252:             !!$            write( 6, * ) trim( name_pfr    )
  1253:             !!$            write( 6, * ) trim( line        )
  1254:             !!$            stop
  1255:             !!$         end if
  1256:             !!$         read( fu_in, * ) ckdp( iband ) % pfr
  1257:             !!$
  1258:             !!$
  1259:             !!$         write( 6, * ) 'band ', iband 
  1260:             !!$         write( 6, * ) '  wns  = ', ckdp(iband)%wnbnds(1)
  1261:             !!$         write( 6, * ) '  wne  = ', ckdp(iband)%wnbnds(2)
  1262:             !!$         write( 6, * ) '  ng   = ', ckdp(iband)%ng
  1263:             !!$         do ig = 1, ckdp(iband)%ng
  1264:             !!$            write( 6, * ) '     g(', ig, ') = ', ckdp(iband)%g(ig)
  1265:             !!$         end do
  1266:             !!$         write( 6, * ) '  nlnp = ', ckdp(iband)%nlnp
  1267:             !!$         write( 6, * ) '  nt   = ', ckdp(iband)%nt
  1268:             !!$
  1269:             !!$      end do
  1270:             !!$
  1271:             !!$      close( fu_in )
  1272:             !!$
  1273:             !!$
  1274:             !!$    end subroutine ckd_input_ascii
  1275:             !!$
  1276:             !!$    !**************************************************************************
  1277:             !!$
  1278:             !!$#endif
  1279:             
  1280:               end module ckd_module
