Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:58 2016
FILE NAME: cloud_T1993base.f90
PROGRAM NAME: cloud_t1993base
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   340  opt  (  11): Fused array assignments. :line 340 - 345
   340  opt  (1592): Outer loop unrolled inside inner loop.
   340  vec  (   4): Vectorized array expression.
   340  vec  (  29): ADB is used for array.: xyz_qcloudwater
   340  vec  (  29): ADB is used for array.: xyz_virtemp
   340  vec  (  29): ADB is used for array.: xyz_press
   340  vec  (   4): Vectorized array expression.
   340  vec  (  29): ADB is used for array.: xyz_qcloudwater
   340  vec  (  29): ADB is used for array.: xyz_virtemp
   340  vec  (  29): ADB is used for array.: xyz_press
   351  opt  (  11): Fused array assignments. :line 351 - 355
   351  vec  (   4): Vectorized array expression.
   351  vec  (  29): ADB is used for array.: xyz_dtempdtphy
   351  vec  (  29): ADB is used for array.: xyz_dqh2ovapsatdtemp
   351  vec  (  29): ADB is used for array.: xyz_moistconvsubsidmassflux
   351  vec  (  29): ADB is used for array.: xyz_omg
   351  vec  (  29): ADB is used for array.: xyz_cloudcover
   351  vec  (  29): ADB is used for array.: xyz_temp
   351  vec  (  29): ADB is used for array.: xyz_virtemp
   351  vec  (  29): ADB is used for array.: xyz_press
   351  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   363  vec  (   3): Unvectorized loop.
   363  vec  (  13): Overhead of loop division is too large.
   364  opt  (1592): Outer loop unrolled inside inner loop.
   364  vec  (   4): Vectorized array expression.
   364  vec  (  29): ADB is used for array.: xyr_press
   364  vec  (  29): ADB is used for array.: xyz_press
   364  vec  (   4): Vectorized array expression.
   364  vec  (  29): ADB is used for array.: xyr_press
   364  vec  (  29): ADB is used for array.: xyz_press
   366  opt  (1592): Outer loop unrolled inside inner loop.
   366  vec  (   4): Vectorized array expression.
   366  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   366  vec  (  29): ADB is used for array.: xyz_qh2ovap
   366  vec  (   4): Vectorized array expression.
   366  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   366  vec  (  29): ADB is used for array.: xyz_qh2ovap
   373  vec  (   1): Vectorized loop.
   373  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   373  vec  (  29): ADB is used for array.: xyz_qh2ovap
   391  opt  (  11): Fused array assignments. :line 391 - 393
   391  opt  (1593): Loop nest collapsed into one loop.
   391  vec  (   4): Vectorized array expression.
   391  vec  (  29): ADB is used for array.: xy_rain
   400  opt  (1592): Outer loop unrolled inside inner loop.
   400  vec  (   4): Vectorized array expression.
   400  vec  (   4): Vectorized array expression.
   402  opt  (1593): Loop nest collapsed into one loop.
   402  vec  (   1): Vectorized loop.
   402  vec  (  29): ADB is used for array.: xyz_cloudcover
   412  opt  (  11): Fused array assignments. :line 412 - 416
   412  opt  (1592): Outer loop unrolled inside inner loop.
   412  vec  (   4): Vectorized array expression.
   412  vec  (  29): ADB is used for array.: xyz_qh2ovap
   412  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   412  vec  (  29): ADB is used for array.: xyz_cloudcover
   412  vec  (  29): ADB is used for array.: xy_rain
   412  vec  (   4): Vectorized array expression.
   412  vec  (  29): ADB is used for array.: xyz_qh2ovap
   412  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   412  vec  (  29): ADB is used for array.: xyz_cloudcover
   412  vec  (  29): ADB is used for array.: xy_rain
   420  opt  (1593): Loop nest collapsed into one loop.
   420  vec  (   1): Vectorized loop.
   420  vec  (  29): ADB is used for array.: xyz_temp
   420  vec  (  29): ADB is used for array.: xyz_qh2ovap
   420  vec  (  29): ADB is used for array.: xyr_press
   420  vec  (  29): ADB is used for array.: xy_rain
   459  opt  (1593): Loop nest collapsed into one loop.
   459  vec  (   4): Vectorized array expression.
   459  vec  (  29): ADB is used for array.: xyz_moistconvdettend
   460  opt  (1592): Outer loop unrolled inside inner loop.
   461  vec  (   1): Vectorized loop.
   461  vec  (  29): ADB is used for array.: xyz_qh2ovap
   461  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   461  vec  (  29): ADB is used for array.: xyz_cloudcover
   461  vec  (   1): Vectorized loop.
   461  vec  (  29): ADB is used for array.: xyz_qh2ovap
   461  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   461  vec  (  29): ADB is used for array.: xyz_cloudcover
   473  opt  (1593): Loop nest collapsed into one loop.
   473  vec  (   4): Vectorized array expression.
   474  opt  (1772): Loop nest fused with following nest(s).
   475  vec  (   1): Vectorized loop.
   475  vec  (  29): ADB is used for array.: xyz_qcloudwater
   475  vec  (  29): ADB is used for array.: xyz_qh2ovap
   475  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   475  vec  (  29): ADB is used for array.: xyz_cloudcover
   512  opt  (  11): Fused array assignments. :line 512 - 530
   512  vec  (   4): Vectorized array expression.
   512  vec  (  29): ADB is used for array.: xyz_qh2ovap
   512  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   512  vec  (  29): ADB is used for array.: xyz_dqcloudwaterdtcum
   512  vec  (  29): ADB is used for array.: xyz_cloudcover
   541  opt  (1593): Loop nest collapsed into one loop.
   541  vec  (   1): Vectorized loop.
   541  vec  (  29): ADB is used for array.: xyz_qh2ovap
   549  opt  (1593): Loop nest collapsed into one loop.
   549  vec  (   4): Vectorized array expression.
   553  opt  (  11): Fused array assignments. :line 553 - 568
   553  opt  (1593): Loop nest collapsed into one loop.
   553  vec  (   4): Vectorized array expression.
   553  vec  (  29): ADB is used for array.: xy_rain
   573  opt  (  11): Fused array assignments. :line 573 - 585
   573  opt  (1593): Loop nest collapsed into one loop.
   573  vec  (   4): Vectorized array expression.
   573  vec  (  29): ADB is used for array.: xyz_cloudcover
   573  vec  (  29): ADB is used for array.: xyz_qcloudwater
   587  opt  (1593): Loop nest collapsed into one loop.
   587  vec  (   1): Vectorized loop.
   598  opt  (1593): Loop nest collapsed into one loop.
   598  vec  (   4): Vectorized array expression.
   598  vec  (  29): ADB is used for array.: xyz_qcloudwater
   605  opt  (1593): Loop nest collapsed into one loop.
   605  vec  (   1): Vectorized loop.
   605  vec  (  29): ADB is used for array.: xyz_qcloudwater
   616  opt  (  11): Fused array assignments. :line 616 - 645
   616  opt  (1593): Loop nest collapsed into one loop.
   616  vec  (   4): Vectorized array expression.
   616  vec  (  29): ADB is used for array.: xy_rain
   616  vec  (  29): ADB is used for array.: xyr_press
   616  vec  (  29): ADB is used for array.: xyz_temp
   616  vec  (  29): ADB is used for array.: xyz_qh2ovap
   616  vec  (  29): ADB is used for array.: xyz_cloudcover
   651  opt  (1772): Loop nest fused with following nest(s).
   651  opt  (1593): Loop nest collapsed into one loop.
   651  vec  (   1): Vectorized loop.
   651  vec  (  29): ADB is used for array.: xyz_cloudcover
   651  vec  (  29): ADB is used for array.: xyz_qcloudwater
   673  vec  (   3): Unvectorized loop.
   673  vec  (  13): Overhead of loop division is too large.
   675  opt  (1017): Subroutine call prevents optimization.
   675  vec  (  17): Unvectorizable statement.
   679  vec  (  17): Unvectorizable statement.
   682  vec  (  22): Dependency unknown. Unvectorizable dependency is assumed.:i
   688  opt  (  11): Fused array assignments. :line 688 - 689
   688  opt  (1593): Loop nest collapsed into one loop.
   688  vec  (   4): Vectorized array expression.
   700  opt  (1593): Loop nest collapsed into one loop.
   700  vec  (   4): Vectorized array expression.
   701  vec  (   3): Unvectorized loop.
   701  vec  (  13): Overhead of loop division is too large.
   702  opt  (1593): Loop nest collapsed into one loop.
   702  vec  (   4): Vectorized array expression.
   702  vec  (  29): ADB is used for array.: xy_rainlsc
   702  vec  (  29): ADB is used for array.: xyr_press
   702  vec  (  29): ADB is used for array.: xyz_rainlsc
   708  opt  (1593): Loop nest collapsed into one loop.
   708  vec  (   4): Vectorized array expression.
   708  vec  (  29): ADB is used for array.: xy_rain
   708  vec  (  29): ADB is used for array.: xy_rainlsc
   961  opt  (  11): Fused array assignments. :line 961 - 964
   961  opt  (1593): Loop nest collapsed into one loop.
   961  vec  (   4): Vectorized array expression.
   961  vec  (  29): ADB is used for array.: xyz_qcloudiceb
   961  vec  (  29): ADB is used for array.: xyz_qcloudice
   961  vec  (  29): ADB is used for array.: xyz_qcloudwatb
   961  vec  (  29): ADB is used for array.: xyz_qcloudwat
   961  vec  (  29): ADB is used for array.: xyz_qh2ovapb
   961  vec  (  29): ADB is used for array.: xyz_qh2ovap
   961  vec  (  29): ADB is used for array.: xyz_tempb
   961  vec  (  29): ADB is used for array.: xyz_temp
   971  opt  (1593): Loop nest collapsed into one loop.
   971  vec  (   1): Vectorized loop.
   971  vec  (  29): ADB is used for array.: xyr_press
   985  opt  (1592): Outer loop unrolled inside inner loop.
   985  vec  (   4): Vectorized array expression.
   985  vec  (  29): ADB is used for array.: xyz_virtemp
   985  vec  (  29): ADB is used for array.: xyz_press
   994  opt  (  11): Fused array assignments. :line 994 - 997
   994  vec  (   4): Vectorized array expression.
   994  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
   994  vec  (  29): ADB is used for array.: xyz_watfrac
  1005  opt  (  11): Fused array assignments. :line 1005 - 1016
  1005  opt  (1592): Outer loop unrolled inside inner loop.
  1005  vec  (   4): Vectorized array expression.
  1005  vec  (  29): ADB is used for array.: xyz_dtempdtphy
  1005  vec  (  29): ADB is used for array.: xyz_moistconvsubsidmassflux
  1005  vec  (  29): ADB is used for array.: xyz_omg
  1005  vec  (  29): ADB is used for array.: xyz_press
  1005  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
  1005  vec  (  29): ADB is used for array.: xyz_virtemp
  1005  vec  (  29): ADB is used for array.: xyz_dqh2ovapsatdtemp
  1005  vec  (  29): ADB is used for array.: xyz_watfrac
  1005  vec  (  29): ADB is used for array.: xyz_cloudcover
  1005  vec  (   4): Vectorized array expression.
  1005  vec  (  29): ADB is used for array.: xyz_dtempdtphy
  1005  vec  (  29): ADB is used for array.: xyz_moistconvsubsidmassflux
  1005  vec  (  29): ADB is used for array.: xyz_omg
  1005  vec  (  29): ADB is used for array.: xyz_press
  1005  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
  1005  vec  (  29): ADB is used for array.: xyz_virtemp
  1005  vec  (  29): ADB is used for array.: xyz_dqh2ovapsatdtemp
  1005  vec  (  29): ADB is used for array.: xyz_watfrac
  1005  vec  (  29): ADB is used for array.: xyz_cloudcover
  1024  vec  (   3): Unvectorized loop.
  1024  vec  (  13): Overhead of loop division is too large.
  1025  opt  (1592): Outer loop unrolled inside inner loop.
  1025  vec  (   4): Vectorized array expression.
  1025  vec  (  29): ADB is used for array.: xyr_press
  1025  vec  (  29): ADB is used for array.: xyz_press
  1025  vec  (   4): Vectorized array expression.
  1025  vec  (  29): ADB is used for array.: xyr_press
  1025  vec  (  29): ADB is used for array.: xyz_press
  1027  opt  (1593): Loop nest collapsed into one loop.
  1027  vec  (   4): Vectorized array expression.
  1027  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
  1027  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1032  opt  (1593): Loop nest collapsed into one loop.
  1032  vec  (   1): Vectorized loop.
  1032  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
  1032  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1052  opt  (  11): Fused array assignments. :line 1052 - 1056
  1052  opt  (1593): Loop nest collapsed into one loop.
  1052  vec  (   4): Vectorized array expression.
  1052  vec  (  29): ADB is used for array.: xy_snow
  1052  vec  (  29): ADB is used for array.: xy_rain
  1064  vec  (   3): Unvectorized loop.
  1065  opt  (1017): Subroutine call prevents optimization.
  1065  vec  (  10): Vectorization obstructive procedure reference.:cloudutilsprcpsteppc1grid
  1073  vec  (   3): Unvectorized loop.
  1074  opt  (1017): Subroutine call prevents optimization.
  1074  vec  (  10): Vectorization obstructive procedure reference.:cloudutilsprcpevap1grid
  1084  opt  (1593): Loop nest collapsed into one loop.
  1084  vec  (   4): Vectorized array expression.
  1084  vec  (  29): ADB is used for array.: xyz_moistconvdettend
  1085  opt  (1593): Loop nest collapsed into one loop.
  1085  vec  (   1): Vectorized loop.
  1085  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1085  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
  1085  vec  (  29): ADB is used for array.: xyz_cloudcover
  1098  opt  (1593): Loop nest collapsed into one loop.
  1098  vec  (   4): Vectorized array expression.
  1099  opt  (1772): Loop nest fused with following nest(s).
  1099  opt  (1593): Loop nest collapsed into one loop.
  1099  vec  (   1): Vectorized loop.
  1099  vec  (  29): ADB is used for array.: xyz_qcloudwat
  1099  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1099  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
  1099  vec  (  29): ADB is used for array.: xyz_cloudcover
  1137  opt  (  11): Fused array assignments. :line 1137 - 1162
  1137  opt  (1593): Loop nest collapsed into one loop.
  1137  vec  (   4): Vectorized array expression.
  1137  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1137  vec  (  29): ADB is used for array.: xyz_qh2ovapsat
  1137  vec  (  29): ADB is used for array.: xyz_dqcloudicedtcum
  1137  vec  (  29): ADB is used for array.: xyz_dqcloudwatdtcum
  1137  vec  (  29): ADB is used for array.: xyz_cloudcover
  1174  opt  (1593): Loop nest collapsed into one loop.
  1174  vec  (   1): Vectorized loop.
  1174  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1183  opt  (  11): Fused array assignments. :line 1183 - 1188
  1183  opt  (1593): Loop nest collapsed into one loop.
  1183  vec  (   4): Vectorized array expression.
  1183  vec  (  29): ADB is used for array.: xyz_watfrac
  1193  opt  (  11): Fused array assignments. :line 1193 - 1224
  1193  opt  (1593): Loop nest collapsed into one loop.
  1193  vec  (   4): Vectorized array expression.
  1193  vec  (  29): ADB is used for array.: xyz_cloudcover
  1193  vec  (  29): ADB is used for array.: xyz_qcloudwat
  1193  vec  (  29): ADB is used for array.: xy_snow
  1193  vec  (  29): ADB is used for array.: xy_rain
  1229  opt  (  11): Fused array assignments. :line 1229 - 1250
  1229  vec  (   4): Vectorized array expression.
  1229  vec  (  29): ADB is used for array.: xyz_cloudcover
  1229  vec  (  29): ADB is used for array.: xyz_qcloudice
  1229  vec  (  29): ADB is used for array.: xyz_temp
  1258  opt  (1772): Loop nest fused with following nest(s).
  1258  opt  (1593): Loop nest collapsed into one loop.
  1258  vec  (   1): Vectorized loop.
  1258  vec  (  29): ADB is used for array.: xyz_qcloudice
  1258  vec  (  29): ADB is used for array.: xyz_qcloudiceb
  1258  vec  (  29): ADB is used for array.: xyz_qcloudwat
  1258  vec  (  29): ADB is used for array.: xyz_qcloudwatb
  1336  opt  (  11): Fused array assignments. :line 1336 - 1358
  1336  opt  (1593): Loop nest collapsed into one loop.
  1336  vec  (   4): Vectorized array expression.
  1336  vec  (  29): ADB is used for array.: xyz_temp
  1336  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1336  vec  (  29): ADB is used for array.: xyz_cloudcover
  1366  opt  (1772): Loop nest fused with following nest(s).
  1366  opt  (1593): Loop nest collapsed into one loop.
  1366  vec  (   1): Vectorized loop.
  1366  vec  (  29): ADB is used for array.: xyz_qcloudice
  1366  vec  (  29): ADB is used for array.: xyz_qcloudiceb
  1366  vec  (  29): ADB is used for array.: xyz_qcloudwat
  1366  vec  (  29): ADB is used for array.: xyz_qcloudwatb
  1411  opt  (  11): Fused array assignments. :line 1411 - 1413
  1411  opt  (1593): Loop nest collapsed into one loop.
  1411  vec  (   4): Vectorized array expression.
  1411  vec  (  29): ADB is used for array.: xy_snow
  1411  vec  (  29): ADB is used for array.: xy_rain
  1418  vec  (   3): Unvectorized loop.
  1421  opt  (1017): Subroutine call prevents optimization.
  1421  vec  (  10): Vectorization obstructive procedure reference.:lscalecond1grid
  1450  opt  (  11): Fused array assignments. :line 1450 - 1451
  1450  opt  (1593): Loop nest collapsed into one loop.
  1450  vec  (   4): Vectorized array expression.
  1450  vec  (  29): ADB is used for array.: xy_snow
  1450  vec  (  29): ADB is used for array.: xyz_dqh2osoldtlsc
  1450  vec  (  29): ADB is used for array.: xy_rain
  1450  vec  (  29): ADB is used for array.: xyz_dqh2oliqdtlsc
  1456  opt  (1593): Loop nest collapsed into one loop.
  1456  vec  (   1): Vectorized loop.
  1456  vec  (  29): ADB is used for array.: xyz_cloudcover
  1456  vec  (  29): ADB is used for array.: xyz_qcloudice
  1456  vec  (  29): ADB is used for array.: xyz_qcloudwat
  1466  opt  (1593): Loop nest collapsed into one loop.
  1466  vec  (   4): Vectorized array expression.
  1466  vec  (  29): ADB is used for array.: xyz_cloudcover
  1470  vec  (   3): Unvectorized loop.
  1470  vec  (  13): Overhead of loop division is too large.
  1472  opt  (1017): Subroutine call prevents optimization.
  1472  vec  (  17): Unvectorizable statement.
  1476  vec  (  17): Unvectorizable statement.
  1480  vec  (  17): Unvectorizable statement.
  1483  vec  (  22): Dependency unknown. Unvectorizable dependency is assumed.:i
  1507  opt  (  11): Fused array assignments. :line 1507 - 1508
  1507  opt  (1593): Loop nest collapsed into one loop.
  1507  vec  (   4): Vectorized array expression.
  1507  vec  (  29): ADB is used for array.: xy_surfsnowflux
  1507  vec  (  29): ADB is used for array.: xy_snow
  1507  vec  (  29): ADB is used for array.: xy_surfrainflux
  1507  vec  (  29): ADB is used for array.: xy_rain
  1522  warn (  82): Name "xy_rainevaparea" is not used.
  1522  warn (  82): Name "aaa_qh2ovapsat" is not used.
  1522  warn (  82): Name "l" is not used.
  1522  warn (  82): Name "xy_densrain" is not used.
  1522  warn (  82): Name "qh2ovapsat" is not used.
  1522  warn (  82): Name "xyz_rainevaprate" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:58 2016
FILE NAME: cloud_T1993base.f90
PROGRAM NAME: cloud_t1993base
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Tiedtke (1993) に基づく雲モデル
     2  !
     3  != Cloud model based on Tiedtke (1993)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: cloud_T1993base.f90,v 1.6 2015/01/29 12:20:40 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module cloud_T1993base
    13    !
    14    != Tiedtke (1993) に基づく雲モデル
    15    !
    16    != Cloud model based on Tiedtke (1993)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 簡単雲モデルによる雲の計算.
    21    !
    22    ! In this module, the amount of cloud is calculated by use of a simple
    23    ! cloud model.
    24    !
    25    !== Procedures List
    26    !
    27  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    28  !!$  ! ------------            :: ------------
    29  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30    !
    31    !== NAMELIST
    32    !
    33    ! NAMELIST#cloud_T1993base_nml
    34    !
    35  
    36    ! モジュール引用 ; USE statements
    37  
    38    !
    39    ! Kind type parameter
    40    !
    41    use dc_types, only: DP, &      ! Double precision.
    42      &                 STRING, &  ! Strings.
    43      &                 TOKEN      ! Keywords.
    44  
    45    ! メッセージ出力
    46    ! Message output
    47    !
    48    use dc_message, only: MessageNotify
    49  
    50    ! 格子点設定
    51    ! Grid points settings
    52    !
    53    use gridset, only: imax, & ! 経度格子点数.
    54                               ! Number of grid points in longitude
    55      &                jmax, & ! 緯度格子点数.
    56                               ! Number of grid points in latitude
    57      &                kmax    ! 鉛直層数.
    58                               ! Number of vertical level
    59  
    60    implicit none
    61  
    62    private
    63  
    64  
    65    ! 公開手続き
    66    ! Public procedure
    67    !
    68    public :: CloudT1993base
    69    public :: CloudT1993baseWithIce
    70    public :: CloudT1993baseInit
    71  
    72  
    73    ! 公開変数
    74    ! Public variables
    75    !
    76  
    77  
    78    ! 非公開変数
    79    ! Private variables
    80    !
    81    logical , save        :: FlagSnow
    82                             ! A flag for snow
    83  
    84    real(DP), save        :: RHThresholdCrtl
    85    real(DP), save        :: RHThresholdSigmaMin
    86    real(DP), save        :: RHThresholdOrd
    87  
    88    real(DP), save        :: CloudLifeTime0
    89  
    90    real(DP), save        :: CloudWatLifeTime0
    91    real(DP), save        :: CloudIceLifeTime0
    92  
    93    real(DP), save        :: QCloudWatEffConv0
    94    real(DP), save        :: QCloudIceEffConv0
    95  
    96    real(DP), save        :: TempBFEffectSat
    97                             ! Temperature at which Bergeron-Findeisen effect
    98                             ! saturates.
    99  
   100  
   101    real(DP), save :: FactBlsThreshold = 1.0e-10_DP
   102  
   103    real(DP), save :: PRCPArea
   104      !                           a_p
   105    real(DP), save :: PRCPEvapArea
   106      !                           A = max( a_p - a, 0 )
   107  
   108    real(DP), save :: PRCPColFactor
   109    !                             This is C1 in Sundqvist et al. (1989)
   110  
   111  
   112    logical, save :: cloud_T1993base_inited = .false.
   113                                ! 初期設定フラグ.
   114                                ! Initialization flag
   115  
   116    character(*), parameter:: module_name = 'cloud_T1993base'
   117                                ! モジュールの名称.
   118                                ! Module name
   119    character(*), parameter:: version = &
   120      & '$Name:  $' // &
   121      & '$Id: cloud_T1993base.f90,v 1.6 2015/01/29 12:20:40 yot Exp $'
   122                                ! モジュールのバージョン
   123                                ! Module version
   124  
   125    !--------------------------------------------------------------------------------------
   126  
   127  contains
   128  
   129    !----------------------------------------------------------------------------
   130    ! This subroutine, SetCloudCloudWaterAdjustWithCloudCoverV4, is
   131    ! created at 2012/08/13.
   132  
   133  !!$  call CloudT1993base(                                        &
   134  !!$    & xyz_Press, xyr_Press, xyz_VirTemp,                      & ! (in)
   135  !!$    & xyz_DQH2OLiqDtCum,                                      & ! (in)
   136  !!$    & xyz_MoistConvDetTend,                                   & ! (in)
   137  !!$    & xyz_OMG, xyz_MoistConvSubsidMassFlux, xyz_DTempDt,      & ! (in)
   138  !!$    & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),               & ! (inout)
   139  !!$    & xyzf_QMixA(:,:,:,CompositionInqIndex('H2OLiq')),        & ! (inout)
   140  !!$    & xyzf_QMixA(:,:,:,CompositionInqIndex('CloudCoverTMP')), & ! (inout)
   141  !!$    & xy_Rain, xy_Snow                                        & ! (out)
   142  !!$    & )
   143  
   144  
   145    subroutine CloudT1993base(                                    &
   146      & xyz_Press, xyr_Press, xyz_VirTemp,                        & ! (in)
   147      & xyz_DQCloudWaterDtCum,                                    & ! (in)
   148      & xyz_MoistConvDetTend,                                     & ! (in)
   149      & xyz_OMG, xyz_MoistConvSubsidMassFlux, xyz_DTempDtPhy,     & ! (in)
   150      & xyz_Temp, xyz_QH2OVap,                                    & ! (inout)
   151      & xyz_QCloudWater,                                          & ! (inout)
   152      & xyz_CloudCover,                                           & ! (inout)
   153      & xy_SurfRainFlux, xy_SurfSnowFlux                          & ! (out)
   154      & )
   155  
   156      ! USE statements
   157      !
   158  
   159      ! 時刻管理
   160      ! Time control
   161      !
   162      use timeset, only: &
   163        & DelTime            ! $ \Delta t $ [s]
   164  
   165      ! 物理・数学定数設定
   166      ! Physical and mathematical constants settings
   167      !
   168      use constants0, only: &
   169        & PI                    ! $ \pi $ .
   170                                ! 円周率.  Circular constant
   171  
   172      ! 物理定数設定
   173      ! Physical constants settings
   174      !
   175      use constants, only: &
   176        & Grav, &
   177                                ! $ g $ [m s-2].
   178                                ! 重力加速度.
   179                                ! Gravitational acceleration
   180        & CpDry, &
   181                                ! $ C_p $ [J kg-1 K-1].
   182                                ! 乾燥大気の定圧比熱.
   183                                ! Specific heat of air at constant pressure
   184        & GasRDry, &
   185                                ! $ R $ [J kg-1 K-1].
   186                                ! 乾燥大気の気体定数.
   187                                ! Gas constant of air
   188        & GasRWet, &
   189                                ! $ R_v $ [J kg-1 K-1].
   190                                ! 凝結成分の気体定数.
   191                                ! Gas constant of condensible elements
   192        & LatentHeat
   193                                ! $ L $ [J kg-1] .
   194                                ! 凝結の潜熱.
   195                                ! Latent heat of condensation
   196  
   197      ! 飽和比湿の算出
   198      ! Evaluate saturation specific humidity
   199      !
   200      use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp
   201  
   202      ! 大規模凝結 (非対流性凝結)
   203      ! Large scale condensation
   204      !
   205      use lscond, only: LScaleCond
   206  
   207      ! 簡単雲モデル
   208      ! Simple cloud model
   209      !
   210      use cloud_simple, only : CloudSimpleCalcPRCPKeyLLTemp
   211  
   212  
   213      real(DP), intent(in   ) :: xyz_Press                  (0:imax-1, 1:jmax, 1:kmax)
   214      real(DP), intent(in   ) :: xyr_Press                  (0:imax-1, 1:jmax, 0:kmax)
   215      real(DP), intent(in   ) :: xyz_VirTemp                (0:imax-1, 1:jmax, 1:kmax)
   216      real(DP), intent(in   ) :: xyz_DQCloudWaterDtCum      (0:imax-1, 1:jmax, 1:kmax)
   217      real(DP), intent(in   ) :: xyz_MoistConvDetTend       (0:imax-1, 1:jmax, 1:kmax)
   218      real(DP), intent(in   ) :: xyz_OMG                    (0:imax-1, 1:jmax, 1:kmax)
   219      real(DP), intent(in   ) :: xyz_MoistConvSubsidMassFlux(0:imax-1, 1:jmax, 1:kmax)
   220      real(DP), intent(in   ) :: xyz_DTempDtPhy             (0:imax-1, 1:jmax, 1:kmax)
   221      real(DP), intent(inout) :: xyz_Temp                   (0:imax-1, 1:jmax, 1:kmax)
   222      real(DP), intent(inout) :: xyz_QH2OVap                (0:imax-1, 1:jmax, 1:kmax)
   223      real(DP), intent(inout) :: xyz_QCloudWater            (0:imax-1, 1:jmax, 1:kmax)
   224      real(DP), intent(inout) :: xyz_CloudCover             (0:imax-1, 1:jmax, 1:kmax)
   225      real(DP), intent(out)   :: xy_SurfRainFlux            (0:imax-1, 1:jmax)
   226      real(DP), intent(out)   :: xy_SurfSnowFlux            (0:imax-1, 1:jmax)
   227  
   228  
   229      real(DP) :: xyz_QCloudWaterB     (0:imax-1, 1:jmax, 1:kmax)
   230  
   231      real(DP) :: xyz_QH2OVapSat       (0:imax-1, 1:jmax, 1:kmax)
   232      real(DP) :: xyz_DQH2OVapSatDPress(0:imax-1, 1:jmax, 1:kmax)
   233      real(DP) :: xyz_DQH2OVapSatDTemp (0:imax-1, 1:jmax, 1:kmax)
   234      real(DP) :: xyz_DQH2OVapSatDt    (0:imax-1, 1:jmax, 1:kmax)
   235  
   236      real(DP) :: xyz_ZeroOneCloudProd(0:imax-1, 1:jmax, 1:kmax)
   237      real(DP) :: xyz_ZeroOneCloudLoss(0:imax-1, 1:jmax, 1:kmax)
   238      real(DP) :: xyz_DelCloudCoverStr(0:imax-1, 1:jmax, 1:kmax)
   239      real(DP) :: xyz_FactA           (0:imax-1, 1:jmax, 1:kmax)
   240      real(DP) :: xyz_FactA1          (0:imax-1, 1:jmax, 1:kmax)
   241      real(DP) :: xyz_FactA2          (0:imax-1, 1:jmax, 1:kmax)
   242      real(DP) :: xyz_FactB           (0:imax-1, 1:jmax, 1:kmax)
   243      real(DP) :: xyz_FactC           (0:imax-1, 1:jmax, 1:kmax)
   244      real(DP) :: xyz_FactC1          (0:imax-1, 1:jmax, 1:kmax)
   245      real(DP) :: xyz_FactC2          (0:imax-1, 1:jmax, 1:kmax)
   246      real(DP) :: xyz_FactD           (0:imax-1, 1:jmax, 1:kmax)
   247      real(DP) :: xyz_FactE           (0:imax-1, 1:jmax, 1:kmax)
   248      real(DP) :: xyz_FactE1          (0:imax-1, 1:jmax, 1:kmax)
   249      real(DP) :: xyz_FactE2          (0:imax-1, 1:jmax, 1:kmax)
   250  
   251      real(DP) :: xy_Rain                  (0:imax-1, 1:jmax)
   252      real(DP) :: xyz_Rain                 (0:imax-1, 1:jmax, 1:kmax)
   253      real(DP) :: xy_RainConvFactor        (0:imax-1, 1:jmax)
   254      real(DP) :: xy_FactCo                (0:imax-1, 1:jmax)
   255      real(DP) :: xy_FactBF                (0:imax-1, 1:jmax)
   256      real(DP) :: xy_QCloudWatConvThreshold(0:imax-1, 1:jmax)
   257  
   258      real(DP) :: xyz_DTempDtLSC             (0:imax-1, 1:jmax, 1:kmax)
   259      real(DP) :: xyz_DQVapDtLSC             (0:imax-1, 1:jmax, 1:kmax)
   260      real(DP) :: xyz_RainLSC                (0:imax-1, 1:jmax, 1:kmax)
   261      real(DP) :: xy_RainLSC                 (0:imax-1, 1:jmax)
   262  
   263  
   264      real(DP), parameter :: MixCoef                  = 1.0d-6
   265      real(DP), parameter :: QCloudWaterEvapThreshold = 1.0d-10
   266  !!$    real(DP), parameter :: RHThreshold              = 0.999_DP
   267      real(DP), parameter :: RHThreshold              = 1.0_DP - 1.0d-10
   268      ! Values below are obtained from Sundqvist et al. (1989), but some of
   269      ! those are arbitrarily selected.
   270      real(DP)            :: RainConvFactor0
   271      real(DP), parameter :: C1                       = 300.0_DP
   272      real(DP), parameter :: C2                       = 0.5_DP
   273  
   274  
   275      ! Parameters for evaporation of rain
   276      real(DP), parameter :: DensWater            = 1.0d3
   277      !                            rho_w
   278      !   Values below are from Kessler (1969)
   279      real(DP), parameter :: RainFallVelFactor         = 130.0d0
   280      !                            K
   281      real(DP), parameter :: MedianDiameterFactor      = 3.67d0
   282      !                            C'
   283      real(DP), parameter :: RainDistFactor            = 1.0d7
   284      !                            N0
   285      real(DP), parameter :: RainEvapRatUnitDiamFactor = 2.24d3
   286      !                            C
   287      real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
   288      !                            Kd
   289  
   290      real(DP) :: Dens0
   291      !                            rho_0
   292      real(DP) :: V00
   293      !                            V_{00}
   294      real(DP) :: RainEvapFactor
   295  
   296      real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   297      !                           rho
   298      real(DP) :: xy_DensRain     (0:imax-1, 1:jmax)
   299      !                           (rho q_r)
   300      real(DP) :: xy_RainArea     (0:imax-1, 1:jmax)
   301      !                           a_p
   302      real(DP) :: xy_RainEvapArea (0:imax-1, 1:jmax)
   303      !                           A = max( a_p - a, 0 )
   304      real(DP) :: xyz_RainEvapRate(0:imax-1, 1:jmax, 1:kmax)
   305  
   306      real(DP) :: xy_DelRain      (0:imax-1, 1:jmax)
   307      real(DP) :: DelQH2OVap
   308  
   309      real(DP) :: RainFallVel
   310  
   311      real(DP) :: xyz_Sigma               (0:imax-1, 1:jmax, 1:kmax)
   312      real(DP) :: xyz_CloudProdRHThreshold(0:imax-1, 1:jmax, 1:kmax)
   313  
   314      integer :: i
   315      integer :: j
   316      integer :: k
   317  
   318  
   319      ! 実行文 ; Executable statement
   320      !
   321  
   322      ! 初期化確認
   323      ! Initialization check
   324      !
   325      if ( .not. cloud_T1993base_inited ) then
   326        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   327      end if
   328  
   329  
   330      ! Parameters for evaporation of rain
   331      Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
   332      V00 = RainFallVelFactor * sqrt( MedianDiameterFactor ) &
   333        & / ( PI * DensWater * RainDistFactor )**(1.0d0/8.0d0)
   334      RainEvapFactor =                                      &
   335  !      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
   336        & RainEvapRatUnitDiamFactor * 1.429624558860304d0   &
   337        & * H2OVapDiffCoef * RainDistFactor**(7.0d0/20.0d0) &
   338        & / ( PI * DensWater )**(13.0d0/20.0d0)
   339      ! Values for evaporation of rain
   340      xyz_Dens = xyz_Press / ( GasRDry * xyz_VirTemp )
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j1 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t1960 = 1, j1                                               
     .  !cdir       nodep                                                       
     .              do t1962 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyz_dens(t1962-1,t1960,t1958+1) = xyz_press(t1962-1,t1960
     .       1            ,t1958+1)/(gasrdry*xyz_virtemp(t1962-1,t1960,t1958+1))
     .                 xyz_qcloudwaterb(t1962-1,t1960,t1958+1) = xyz_qcloudwater
     .       1            (t1962-1,t1960,t1958+1)                               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1960 = j1 + 1, xyz_press.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .              do t1962 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyz_dens(t1962-1,t1960,t1958+1) = xyz_press(t1962-1,t1960
     .       1            ,t1958+1)/(gasrdry*xyz_virtemp(t1962-1,t1960,t1958+1))
     .                 xyz_dens(t1962-1,t1960+1,t1958+1) = xyz_press(t1962-1,   
     .       1            t1960+1,t1958+1)/(gasrdry*xyz_virtemp(t1962-1,t1960+1,
     .       2            t1958+1))                                             
     .                 xyz_dens(t1962-1,t1960+2,t1958+1) = xyz_press(t1962-1,   
     .       1            t1960+2,t1958+1)/(gasrdry*xyz_virtemp(t1962-1,t1960+2,
     .       2            t1958+1))                                             
     .                 xyz_dens(t1962-1,t1960+3,t1958+1) = xyz_press(t1962-1,   
     .       1            t1960+3,t1958+1)/(gasrdry*xyz_virtemp(t1962-1,t1960+3,
     .       2            t1958+1))                                             
     .                 xyz_qcloudwaterb(t1962-1,t1960,t1958+1) = xyz_qcloudwater
     .       1            (t1962-1,t1960,t1958+1)                               
     .                 xyz_qcloudwaterb(t1962-1,t1960+1,t1958+1) =              
     .       1            xyz_qcloudwater(t1962-1,t1960+1,t1958+1)              
     .                 xyz_qcloudwaterb(t1962-1,t1960+2,t1958+1) =              
     .       1            xyz_qcloudwater(t1962-1,t1960+2,t1958+1)              
     .                 xyz_qcloudwaterb(t1962-1,t1960+3,t1958+1) =              
     .       1            xyz_qcloudwater(t1962-1,t1960+3,t1958+1)              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   341  
   342  
   343      ! Save cloud water amount
   344      !
   345      xyz_QCloudWaterB = xyz_QCloudWater
   346  
   347  
   348      xyz_QH2OVapSat       = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   349      xyz_DQH2OVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QH2OVapSat )
   350  
   351      xyz_DQH2OVapSatDPress = xyz_QH2OVapSat / xyz_Press                           &
     .        d2 = latentheat/cpdry                                             
     .  !cdir nodep                                                             
     .        do t1983 = 1, t225 + 1                                            
     .           xyz_dqh2ovapsatdpress1 = xyz_qh2ovapsat(t1983-1,t1981+1,t1979+1
     .       1      )/xyz_press(t1983-1,t1981+1,t1979+1)*(latentheat*gasrdry*   
     .       2      xyz_virtemp(t1983-1,t1981+1,t1979+1)-((cpdry*gasrwet)*(     
     .       3      xyz_temp(t1983-1,t1981+1,t1979+1)**2)))/(xyz_cloudcover(    
     .       4      t1983-1,t1981+1,t1979+1)*latentheat**2*xyz_qh2ovapsat(t1983-
     .       5      1,t1981+1,t1979+1)+((cpdry*gasrwet)*(xyz_temp(t1983-1,t1981+
     .       6      1,t1979+1)**2)))                                            
     .           xyz_dqh2ovapsatdt(t1983-1,t1981+1,t1979+1) =                   
     .       1      xyz_dqh2ovapsatdpress1*(xyz_omg(t1983-1,t1981+1,t1979+1)+   
     .       2      grav*xyz_moistconvsubsidmassflux(t1983-1,t1981+1,t1979+1))  
     .       3       + xyz_dqh2ovapsatdtemp(t1983-1,t1981+1,t1979+1)/(          
     .       4      1.00000000000000e+000 + xyz_cloudcover(t1983-1,t1981+1,t1979
     .       5      +1)*d2*xyz_dqh2ovapsatdtemp(t1983-1,t1981+1,t1979+1))*      
     .       6      xyz_dtempdtphy(t1983-1,t1981+1,t1979+1)                     
     .        enddo                                                             
   352        & * ( LatentHeat * GasRDry * xyz_VirTemp - CpDry * GasRWet * xyz_Temp**2 ) &
   353        & / ( xyz_CloudCover * LatentHeat**2 * xyz_QH2OVapSat + CpDry * GasRWet * xyz_Temp**2 )
   354  
   355      xyz_DQH2OVapSatDt =                                                            &
   356        &   xyz_DQH2OVapSatDPress * ( xyz_OMG + Grav * xyz_MoistConvSubsidMassFlux ) &
   357        & + xyz_DQH2OVapSatDTemp                                                      &
   358        &   / ( 1.0_DP + xyz_CloudCover * LatentHeat / CpDry * xyz_DQH2OVapSatDTemp ) &
   359        &   * xyz_DTempDtPhy
   360  
   361  
   362      ! set zero-one flag
   363      do k = 1, kmax
   364        xyz_Sigma(:,:,k) = xyz_Press(:,:,k) / xyr_Press(:,:,0)
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j2 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t2033 = 1, j2                                               
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_press)                                           
     .              do t2035 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyz_sigma(t2035-1,t2033,k) = xyz_press(t2035-1,t2033,k)/ 
     .       1            xyr_press(t2035-1,t2033,0)                            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2033 = j2 + 1, xyz_press.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_press)                                           
     .              do t2035 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyz_sigma(t2035-1,t2033,k) = xyz_press(t2035-1,t2033,k)/ 
     .       1            xyr_press(t2035-1,t2033,0)                            
     .                 xyz_sigma(t2035-1,t2033+1,k) = xyz_press(t2035-1,t2033+1,
     .       1            k)/xyr_press(t2035-1,t2033+1,0)                       
     .                 xyz_sigma(t2035-1,t2033+2,k) = xyz_press(t2035-1,t2033+2,
     .       1            k)/xyr_press(t2035-1,t2033+2,0)                       
     .                 xyz_sigma(t2035-1,t2033+3,k) = xyz_press(t2035-1,t2033+3,
     .       1            k)/xyr_press(t2035-1,t2033+3,0)                       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   365      end do
   366      xyz_CloudProdRHThreshold =                                     &
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t2045 = 1, j3                                               
     .  !cdir       nodep                                                       
     .              do t2047 = 1, imax                                          
     .                 xyz_cloudprodrhthreshold(t2047-1,t2045,t2043+1) =        
     .       1            rhthresholdcrtl + (1.00000000000000e+000 - xyz_qh2ovap
     .       2            (t2047-1,t2045,t2043+1)/xyz_qh2ovapsat(t2047-1,t2045, 
     .       3            t2043+1))*(max((xyz_sigma(t2047-1,t2045,t2043+1)-     
     .       4            rhthresholdsigmamin),0.0000000000000000e+000)/(       
     .       5            xyz_sigma(t2047-1,t2045,t2043+1)-rhthresholdsigmamin))
     .       6            **rhthresholdord                                      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2045 = j3 + 1, jmax, 4                                     
     .  !cdir       nodep                                                       
     .              do t2047 = 1, imax                                          
     .                 xyz_cloudprodrhthreshold(t2047-1,t2045,t2043+1) =        
     .       1            rhthresholdcrtl + (1.00000000000000e+000 - xyz_qh2ovap
     .       2            (t2047-1,t2045,t2043+1)/xyz_qh2ovapsat(t2047-1,t2045, 
     .       3            t2043+1))*(max((xyz_sigma(t2047-1,t2045,t2043+1)-     
     .       4            rhthresholdsigmamin),0.0000000000000000e+000)/(       
     .       5            xyz_sigma(t2047-1,t2045,t2043+1)-rhthresholdsigmamin))
     .       6            **rhthresholdord                                      
     .                 xyz_cloudprodrhthreshold(t2047-1,t2045+1,t2043+1) =      
     .       1            rhthresholdcrtl + (1.00000000000000e+000 - xyz_qh2ovap
     .       2            (t2047-1,t2045+1,t2043+1)/xyz_qh2ovapsat(t2047-1,t2045
     .       3            +1,t2043+1))*(max((xyz_sigma(t2047-1,t2045+1,t2043+1)-
     .       4            rhthresholdsigmamin),0.0000000000000000e+000)/(       
     .       5            xyz_sigma(t2047-1,t2045+1,t2043+1)-rhthresholdsigmamin
     .       6            ))**rhthresholdord                                    
     .                 xyz_cloudprodrhthreshold(t2047-1,t2045+2,t2043+1) =      
     .       1            rhthresholdcrtl + (1.00000000000000e+000 - xyz_qh2ovap
     .       2            (t2047-1,t2045+2,t2043+1)/xyz_qh2ovapsat(t2047-1,t2045
     .       3            +2,t2043+1))*(max((xyz_sigma(t2047-1,t2045+2,t2043+1)-
     .       4            rhthresholdsigmamin),0.0000000000000000e+000)/(       
     .       5            xyz_sigma(t2047-1,t2045+2,t2043+1)-rhthresholdsigmamin
     .       6            ))**rhthresholdord                                    
     .                 xyz_cloudprodrhthreshold(t2047-1,t2045+3,t2043+1) =      
     .       1            rhthresholdcrtl + (1.00000000000000e+000 - xyz_qh2ovap
     .       2            (t2047-1,t2045+3,t2043+1)/xyz_qh2ovapsat(t2047-1,t2045
     .       3            +3,t2043+1))*(max((xyz_sigma(t2047-1,t2045+3,t2043+1)-
     .       4            rhthresholdsigmamin),0.0000000000000000e+000)/(       
     .       5            xyz_sigma(t2047-1,t2045+3,t2043+1)-rhthresholdsigmamin
     .       6            ))**rhthresholdord                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   367        &   RHThresholdCrtl                                          &
   368        & + ( 1.0_DP - xyz_QH2OVap / xyz_QH2OVapSat )                &
   369        &   * (   max( ( xyz_Sigma - RHThresholdSigmaMin ), 0.0_DP ) &
   370        &       / ( xyz_Sigma - RHThresholdSigmaMin )                )**RHThresholdOrd
   371      do k = 1, kmax
   372        do j = 1, jmax
   373          do i = 0, imax-1
   374            if ( xyz_DQH2OVapSatDt(i,j,k) < 0.0_DP ) then
   375              if ( xyz_QH2OVap(i,j,k) >= xyz_CloudProdRHThreshold(i,j,k) * xyz_QH2OVapSat(i,j,k) ) then
   376                xyz_ZeroOneCloudProd(i,j,k) = 1.0_DP
   377              else
   378                xyz_ZeroOneCloudProd(i,j,k) = 0.0_DP
   379              end if
   380              xyz_ZeroOneCloudLoss(i,j,k) = 1.0_DP
   381            else
   382              xyz_ZeroOneCloudProd(i,j,k) = 0.0_DP
   383              xyz_ZeroOneCloudLoss(i,j,k) = 0.0_DP
   384            end if
   385          end do
     .  !cdir nodep                                                             
     .        do i = 1, imax                                                    
     .           if (xyz_dqh2ovapsatdt(i-1,j,k) .lt. 0.0000000000000000e+000)   
     .       1      then                                                        
     .              if (xyz_qh2ovap(i-1,j,k) .ge. xyz_cloudprodrhthreshold(i-1,j
     .       1         ,k)*xyz_qh2ovapsat(i-1,j,k)) then                        
     .                 xyz_zeroonecloudprod3 = 1.00000000000000e+000            
     .              else                                                        
     .                 xyz_zeroonecloudprod3 = 0.0000000000000000e+000          
     .              endif                                                       
     .              xyz_zeroonecloudloss4 = 1.00000000000000e+000               
     .           else                                                           
     .              xyz_zeroonecloudprod3 = 0.0000000000000000e+000             
     .              xyz_zeroonecloudloss4 = 0.0000000000000000e+000             
     .           endif                                                          
     .           xyz_zeroonecloudloss(i-1,j,k) = xyz_zeroonecloudloss4          
     .           xyz_zeroonecloudprod(i-1,j,k) = xyz_zeroonecloudprod3          
     .        enddo                                                             
   386        end do
   387      end do
   388  
   389  
   390      ! Rain at the surface
   391      xy_Rain     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2064 = 1, xy_rain.DSC.U2*xy_rain.DSC.U1 + xy_rain.DSC.U2      
     .           xy_rain(t2064-1,1) = 0.0000000000000000e+000                   
     .           xy_rainarea(t2064-1,1) = 0.0000000000000000e+000               
     .        enddo                                                             
   392      ! Rain area
   393      xy_RainArea = 0.0_DP
   394  
   395      k_loop : do k = kmax, 1, -1
   396  
   397        ! Evaporation of rain
   398        !
   399        if ( k == kmax ) then
   400          xy_RainArea = 0.0_DP
     .        if (xy_rainarea.DSC.U2 .gt. 0) then                               
     .           j4 = and(xy_rainarea.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t2360 = 1, j4                                               
     .  !cdir       nodep                                                       
     .              do t2362 = 1, xy_rainarea.DSC.U1 + 2 - min0(1,              
     .       1         xy_rainarea.DSC.U1 + 1)                                  
     .                 xy_rainarea(t2362-1,t2360) = 0.0000000000000000e+000     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2360 = j4 + 1, xy_rainarea.DSC.U2, 4                       
     .  !cdir       nodep                                                       
     .              do t2362 = 1, xy_rainarea.DSC.U1 + 2 - min0(1,              
     .       1         xy_rainarea.DSC.U1 + 1)                                  
     .                 xy_rainarea(t2362-1,t2360) = 0.0000000000000000e+000     
     .                 xy_rainarea(t2362-1,t2360+1) = 0.0000000000000000e+000   
     .                 xy_rainarea(t2362-1,t2360+2) = 0.0000000000000000e+000   
     .                 xy_rainarea(t2362-1,t2360+3) = 0.0000000000000000e+000   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10059                                                        
   401        else
   402          do j = 1, jmax
   403            do i = 0, imax-1
   404              if ( xyz_Rain(i,j,k+1) > 0.0_DP ) then
   405                if ( xyz_CloudCover(i,j,k+1) > xy_RainArea(i,j) ) then
   406                  xy_RainArea(i,j) = xyz_CloudCover(i,j,k+1)
   407                end if
   408              end if
   409            end do
   410          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyz_rain(j-1,1,k+1) .gt. 0.0000000000000000e+000) then     
     .              if (xyz_cloudcover(j-1,1,k+1) .gt. xy_rainarea(j-1,1)) then 
     .                 xy_rainarea(j-1,1) = xyz_cloudcover(j-1,1,k+1)           
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   411        end if
   412        xy_DensRain =                                                      &
     .        if (xy_rain.DSC.U2 .gt. 0) then                                   
     .           j5 = and(xy_rain.DSC.U2,3)                                     
     .  !cdir    nodep                                                          
     .           do t2072 = 1, j5                                               
     .  !cdir       nodep                                                       
     .              do t2074 = 1, xy_rain.DSC.U1 + 1                            
     .                 xy_densrain(t2074-1,t2072) = (xy_rain(t2074-1,t2072)/((  
     .       1            xy_rainarea(t2074-1,t2072)+1.00000000000000e-010)*v00*
     .       2            dsqrt(dens0/xyz_dens(t2074-1,t2072,k))))**            
     .       3            8.88888888888888e-001                                 
     .                 xy_rainevaparea1 = max(xy_rainarea(t2074-1,t2072)-       
     .       1            xyz_cloudcover(t2074-1,t2072,k),                      
     .       2            0.0000000000000000e+000)                              
     .                 xyz_rainevaprate(t2074-1,t2072,k) = xyz_dens(t2074-1,    
     .       1            t2072,k)*xy_rainevaparea1*rainevapfactor*max(         
     .       2            xyz_qh2ovapsat(t2074-1,t2072,k)-xyz_qh2ovap(t2074-1,  
     .       3            t2072,k),0.0000000000000000e+000)*xy_densrain(t2074-1,
     .       4            t2072)**6.50000000000000e-001                         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2072 = j5 + 1, xy_rain.DSC.U2, 4                           
     .  !cdir       nodep                                                       
     .              do t2074 = 1, xy_rain.DSC.U1 + 1                            
     .                 xy_densrain(t2074-1,t2072) = (xy_rain(t2074-1,t2072)/((  
     .       1            xy_rainarea(t2074-1,t2072)+1.00000000000000e-010)*v00*
     .       2            dsqrt(dens0/xyz_dens(t2074-1,t2072,k))))**            
     .       3            8.88888888888888e-001                                 
     .                 xy_densrain(t2074-1,t2072+1) = (xy_rain(t2074-1,t2072+1)/
     .       1            ((xy_rainarea(t2074-1,t2072+1)+1.00000000000000e-010)*
     .       2            v00*dsqrt(dens0/xyz_dens(t2074-1,t2072+1,k))))**      
     .       3            8.88888888888888e-001                                 
     .                 xy_densrain(t2074-1,t2072+2) = (xy_rain(t2074-1,t2072+2)/
     .       1            ((xy_rainarea(t2074-1,t2072+2)+1.00000000000000e-010)*
     .       2            v00*dsqrt(dens0/xyz_dens(t2074-1,t2072+2,k))))**      
     .       3            8.88888888888888e-001                                 
     .                 xy_densrain(t2074-1,t2072+3) = (xy_rain(t2074-1,t2072+3)/
     .       1            ((xy_rainarea(t2074-1,t2072+3)+1.00000000000000e-010)*
     .       2            v00*dsqrt(dens0/xyz_dens(t2074-1,t2072+3,k))))**      
     .       3            8.88888888888888e-001                                 
     .                 xy_rainevaparea(t2074-1,t2072) = max(xy_rainarea(t2074-1,
     .       1            t2072)-xyz_cloudcover(t2074-1,t2072,k),               
     .       2            0.0000000000000000e+000)                              
     .                 xy_rainevaparea(t2074-1,t2072+1) = max(xy_rainarea(t2074-
     .       1            1,t2072+1)-xyz_cloudcover(t2074-1,t2072+1,k),         
     .       2            0.0000000000000000e+000)                              
     .                 xy_rainevaparea(t2074-1,t2072+2) = max(xy_rainarea(t2074-
     .       1            1,t2072+2)-xyz_cloudcover(t2074-1,t2072+2,k),         
     .       2            0.0000000000000000e+000)                              
     .                 xy_rainevaparea(t2074-1,t2072+3) = max(xy_rainarea(t2074-
     .       1            1,t2072+3)-xyz_cloudcover(t2074-1,t2072+3,k),         
     .       2            0.0000000000000000e+000)                              
     .                 xyz_rainevaprate(t2074-1,t2072,k) = xyz_dens(t2074-1,    
     .       1            t2072,k)*xy_rainevaparea(t2074-1,t2072)*rainevapfactor
     .       2            *max(xyz_qh2ovapsat(t2074-1,t2072,k)-xyz_qh2ovap(t2074
     .       3            -1,t2072,k),0.0000000000000000e+000)*xy_densrain(t2074
     .       4            -1,t2072)**6.50000000000000e-001                      
     .                 xyz_rainevaprate(t2074-1,t2072+1,k) = xyz_dens(t2074-1,  
     .       1            t2072+1,k)*xy_rainevaparea(t2074-1,t2072+1)*          
     .       2            rainevapfactor*max(xyz_qh2ovapsat(t2074-1,t2072+1,k)- 
     .       3            xyz_qh2ovap(t2074-1,t2072+1,k),0.0000000000000000e+000
     .       4            )*xy_densrain(t2074-1,t2072+1)**6.50000000000000e-001 
     .                 xyz_rainevaprate(t2074-1,t2072+2,k) = xyz_dens(t2074-1,  
     .       1            t2072+2,k)*xy_rainevaparea(t2074-1,t2072+2)*          
     .       2            rainevapfactor*max(xyz_qh2ovapsat(t2074-1,t2072+2,k)- 
     .       3            xyz_qh2ovap(t2074-1,t2072+2,k),0.0000000000000000e+000
     .       4            )*xy_densrain(t2074-1,t2072+2)**6.50000000000000e-001 
     .                 xyz_rainevaprate(t2074-1,t2072+3,k) = xyz_dens(t2074-1,  
     .       1            t2072+3,k)*xy_rainevaparea(t2074-1,t2072+3)*          
     .       2            rainevapfactor*max(xyz_qh2ovapsat(t2074-1,t2072+3,k)- 
     .       3            xyz_qh2ovap(t2074-1,t2072+3,k),0.0000000000000000e+000
     .       4            )*xy_densrain(t2074-1,t2072+3)**6.50000000000000e-001 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   413          & ( xy_Rain / ( xy_RainArea + 1.0d-10 )                          &
   414          &   / ( V00 * sqrt( Dens0 / xyz_Dens(:,:,k) ) ) )**(8.0d0/9.0d0)
   415        xy_RainEvapArea = max( xy_RainArea - xyz_CloudCover(:,:,k), 0.0_DP )
   416        xyz_RainEvapRate(:,:,k) =                                         &
   417          & xyz_Dens(:,:,k) * xy_RainEvapArea * RainEvapFactor            &
   418          &   * max( xyz_QH2OVapSat(:,:,k) - xyz_QH2OVap(:,:,k), 0.0_DP ) &
   419          &   * xy_DensRain**(13.0d0/20.0d0)
   420        do j = 1, jmax
   421          do i = 0, imax-1
   422            RainFallVel =                             &
   423              & V00 * sqrt( Dens0 / xyz_Dens(i,j,k) ) &
   424              &   * xy_DensRain(i,j)**(1.0d0/8.0d0)
   425            if ( xy_RainArea(i,j) * RainFallVel * xyz_RainEvapRate(i,j,k) &
   426              &    * 2.0_DP * DelTime                                     &
   427              &      > xy_Rain(i,j) ) then
   428              xyz_RainEvapRate(i,j,k) =                              &
   429                & xy_Rain(i,j)                                       &
   430                &   / ( ( xy_RainArea(i,j) + 1.0d-10 ) * RainFallVel &
   431                &       * 2.0_DP * DelTime )
   432              xy_DelRain(i,j) = - xy_Rain(i,j)
   433            else
   434              xy_DelRain(i,j) =                                    &
   435                & - xy_RainArea(i,j) * RainFallVel                 &
   436                & * xyz_RainEvapRate(i,j,k) * ( 2.0_DP * DelTime )
   437            end if
   438            xy_Rain(i,j) = xy_Rain(i,j) + xy_DelRain(i,j)
   439  !!$            xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k)              &
   440  !!$              & + xyz_RainEvapRate(i,j,k) * ( 2.0_DP * DelTime ) &
   441  !!$              &     / xyz_Dens(i,j,k)
   442  !!$            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                    &
   443  !!$              & - xyz_RainEvapRate(i,j,k) * ( 2.0_DP * DelTime ) &
   444  !!$              &     / xyz_Dens(i,j,k)                            &
   445  !!$              &     * LatentHeat / CpDry
   446            ! DelRain = DelQH2OVap * DelPress / Grav / ( 2.0_DP * DelTime )
   447            DelQH2OVap =                                             &
   448              & - xy_DelRain(i,j)                                    &
   449              & * Grav / ( xyr_Press(i,j,k-1) - xyr_Press(i,j,k) )
   450            xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k)                  &
   451              & + DelQH2OVap
   452            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                        &
   453              & - DelQH2OVap                                         &
   454              &   * LatentHeat / CpDry
   455          end do
   456        end do
     .        d6 = latentheat/cpdry                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_press)                                                 
     .        do j = 1, jmax*imax                                               
     .           rainfallvel = v00*dsqrt(dens0/xyz_dens(j-1,1,k))*xy_densrain(j-
     .       1      1,1)**1.25000000000000e-001                                 
     .           if ((2.00000000000000e+000*deltime)*(xy_rainarea(j-1,1)*       
     .       1      rainfallvel)*xyz_rainevaprate(j-1,1,k) .gt. xy_rain(j-1,1)) 
     .       2      then                                                        
     .              xyz_rainevaprate(j-1,1,k) = xy_rain(j-1,1)/((xy_rainarea(j-1
     .       1         ,1)+1.00000000000000e-010)*rainfallvel*                  
     .       2         2.00000000000000e+000*deltime)                           
     .              xy_delrain7 = -xy_rain(j-1,1)                               
     .           else                                                           
     .              xy_delrain7 = -(xy_rainarea(j-1,1)*rainfallvel)*            
     .       1         xyz_rainevaprate(j-1,1,k)*(2.00000000000000e+000*deltime)
     .           endif                                                          
     .           xy_delrain(j-1,1) = xy_delrain7                                
     .           xy_rain(j-1,1) = xy_rain(j-1,1) + xy_delrain(j-1,1)            
     .           delqh2ovap = -xy_delrain(j-1,1)*grav/(xyr_press(j-1,1,k-1)-    
     .       1      xyr_press(j-1,1,k))                                         
     .           xyz_qh2ovap(j-1,1,k) = xyz_qh2ovap(j-1,1,k) + delqh2ovap       
     .           xyz_temp(j-1,1,k) = xyz_temp(j-1,1,k) - delqh2ovap*d6          
     .        enddo                                                             
   457  
   458  
   459        xyz_FactC1(:,:,k) = xyz_MoistConvDetTend(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2102 = 1, xyz_factc1.DSC.U2*xyz_factc1.DSC.U1 +               
     .       1   xyz_factc1.DSC.U2                                              
     .           xyz_factc1(t2102-1,1,k) = xyz_moistconvdettend(t2102-1,1,k)    
     .        enddo                                                             
   460        do j = 1, jmax
   461          do i = 0, imax-1
   462            if ( xyz_QH2OVap(i,j,k) < RHThreshold * xyz_QH2OVapSat(i,j,k) ) then
   463              xyz_FactC2(i,j,k) =                                         &
   464                & - ( 1.0_DP - xyz_CloudCover(i,j,k) )                    &
   465                &   / ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )      &
   466                &   * xyz_DQH2OVapSatDt(i,j,k) * xyz_ZeroOneCloudProd(i,j,k)
   467            else
   468  !!$              xyz_FactC2(i,j,k) = 0.0_DP
   469              xyz_FactC2(i,j,k) = 1.0_DP / ( 2.0_DP * DelTime )
   470            end if
   471          end do
   472        end do
     .        if (jmax .gt. 0) then                                             
     .           j6 = and(jmax,3)                                               
     .           do j = 1, j6                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_qh2ovap(i-1,j,k) .lt. 9.99999999899999e-001*     
     .       1            xyz_qh2ovapsat(i-1,j,k)) then                         
     .                    xyz_factc28 = -(1.00000000000000e+000 - xyz_cloudcover
     .       1               (i-1,j,k))/(xyz_qh2ovapsat(i-1,j,k)-xyz_qh2ovap(i-1
     .       2               ,j,k))*xyz_dqh2ovapsatdt(i-1,j,k)*                 
     .       3               xyz_zeroonecloudprod(i-1,j,k)                      
     .                 else                                                     
     .                    xyz_factc28 = 1.00000000000000e+000/(                 
     .       1               2.00000000000000e+000*deltime)                     
     .                 endif                                                    
     .                 xyz_factc2(i-1,j,k) = xyz_factc28                        
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j6 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_qh2ovap(i-1,j,k) .lt. 9.99999999899999e-001*     
     .       1            xyz_qh2ovapsat(i-1,j,k)) then                         
     .                    xyz_factc29 = -(1.00000000000000e+000 - xyz_cloudcover
     .       1               (i-1,j,k))/(xyz_qh2ovapsat(i-1,j,k)-xyz_qh2ovap(i-1
     .       2               ,j,k))*xyz_dqh2ovapsatdt(i-1,j,k)*                 
     .       3               xyz_zeroonecloudprod(i-1,j,k)                      
     .                 else                                                     
     .                    xyz_factc29 = 1.00000000000000e+000/(                 
     .       1               2.00000000000000e+000*deltime)                     
     .                 endif                                                    
     .                 xyz_factc2(i-1,j,k) = xyz_factc29                        
     .                 if (xyz_qh2ovap(i-1,j+1,k) .lt. 9.99999999899999e-001*   
     .       1            xyz_qh2ovapsat(i-1,j+1,k)) then                       
     .                    xyz_factc210 = -(1.00000000000000e+000 -              
     .       1               xyz_cloudcover(i-1,j+1,k))/(xyz_qh2ovapsat(i-1,j+1,
     .       2               k)-xyz_qh2ovap(i-1,j+1,k))*xyz_dqh2ovapsatdt(i-1,j+
     .       3               1,k)*xyz_zeroonecloudprod(i-1,j+1,k)               
     .                 else                                                     
     .                    xyz_factc210 = 1.00000000000000e+000/(                
     .       1               2.00000000000000e+000*deltime)                     
     .                 endif                                                    
     .                 xyz_factc2(i-1,j+1,k) = xyz_factc210                     
     .                 if (xyz_qh2ovap(i-1,j+2,k) .lt. 9.99999999899999e-001*   
     .       1            xyz_qh2ovapsat(i-1,j+2,k)) then                       
     .                    xyz_factc211 = -(1.00000000000000e+000 -              
     .       1               xyz_cloudcover(i-1,j+2,k))/(xyz_qh2ovapsat(i-1,j+2,
     .       2               k)-xyz_qh2ovap(i-1,j+2,k))*xyz_dqh2ovapsatdt(i-1,j+
     .       3               2,k)*xyz_zeroonecloudprod(i-1,j+2,k)               
     .                 else                                                     
     .                    xyz_factc211 = 1.00000000000000e+000/(                
     .       1               2.00000000000000e+000*deltime)                     
     .                 endif                                                    
     .                 xyz_factc2(i-1,j+2,k) = xyz_factc211                     
     .                 if (xyz_qh2ovap(i-1,j+3,k) .lt. 9.99999999899999e-001*   
     .       1            xyz_qh2ovapsat(i-1,j+3,k)) then                       
     .                    xyz_factc212 = -(1.00000000000000e+000 -              
     .       1               xyz_cloudcover(i-1,j+3,k))/(xyz_qh2ovapsat(i-1,j+3,
     .       2               k)-xyz_qh2ovap(i-1,j+3,k))*xyz_dqh2ovapsatdt(i-1,j+
     .       3               3,k)*xyz_zeroonecloudprod(i-1,j+3,k)               
     .                 else                                                     
     .                    xyz_factc212 = 1.00000000000000e+000/(                
     .       1               2.00000000000000e+000*deltime)                     
     .                 endif                                                    
     .                 xyz_factc2(i-1,j+3,k) = xyz_factc212                     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   473        xyz_FactC(:,:,k) = xyz_FactC1(:,:,k) + xyz_FactC2(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2110 = 1, xyz_factc1.DSC.U2*xyz_factc1.DSC.U1 +               
     .       1   xyz_factc1.DSC.U2                                              
     .           xyz_factc(t2110-1,1,k) = xyz_factc1(t2110-1,1,k) + xyz_factc2( 
     .       1      t2110-1,1,k)                                                
     .        enddo                                                             
   474        do j = 1, jmax
   475          do i = 0, imax-1
   476            if ( xyz_QH2OVapSat(i,j,k) > xyz_QH2OVap(i,j,k) ) then
   477              xyz_FactD(i,j,k) =                                      &
   478                & 2.0_DP * xyz_CloudCover(i,j,k) * MixCoef            &
   479                & * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )    &
   480                & / ( xyz_QCloudWater(i,j,k) + 1.0d-100 )
   481            else
   482              xyz_FactD(i,j,k) = 0.0_DP
   483            end if
   484          end do
   485        end do
   486        !
   487        do j = 1, jmax
   488          do i = 0, imax-1
   489            if ( xyz_QH2OVap(i,j,k) < RHThreshold * xyz_QH2OVapSat(i,j,k) ) then
   490              xyz_FactE1(i,j,k) =                                             &
   491                &   ( 1.0_DP - xyz_CloudCover(i,j,k) )**2                     &
   492                & / ( 2.0_DP                                                  &
   493                &       * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) ) )    &
   494                & * xyz_DQH2OVapSatDt(i,j,k) * xyz_ZeroOneCloudProd(i,j,k)
   495            else
   496              xyz_FactE1(i,j,k) = 0.0_DP
   497            end if
   498          end do
   499        end do
   500        do j = 1, jmax
   501          do i = 0, imax-1
   502            if ( xyz_QH2OVapSat(i,j,k) > xyz_QH2OVap(i,j,k) ) then
   503              xyz_FactE2(i,j,k) =                                     &
   504                & + xyz_CloudCover(i,j,k)**2 * MixCoef                &
   505                & * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )    &
   506                & / ( xyz_QCloudWater(i,j,k) + 1.0d-100 )
   507            else
   508              xyz_FactE2(i,j,k) = 0.0_DP
   509            end if
   510          end do
   511        end do
     .        do j = 1, jmax                                                    
     .  !cdir    nodep                                                          
     .           do i = 1, imax                                                 
     .              if ((xyz_qh2ovapsat(i-1,j,k).gt.xyz_qh2ovap(i-1,j,k))) then 
     .                 xyz_factd13 = 2.00000000000000e+000*xyz_cloudcover(i-1,j,
     .       1            k)*9.99999999999999e-007*(xyz_qh2ovapsat(i-1,j,k)-    
     .       2            xyz_qh2ovap(i-1,j,k))/(xyz_qcloudwater(i-1,j,k)+      
     .       3            1.00000000000000e-100)                                
     .              else                                                        
     .                 xyz_factd13 = 0.0000000000000000e+000                    
     .              endif                                                       
     .              xyz_factd(i-1,j,k) = xyz_factd13                            
     .              if (xyz_qh2ovap(i-1,j,k) .lt. 9.99999999899999e-001*        
     .       1         xyz_qh2ovapsat(i-1,j,k)) then                            
     .                 xyz_facte114 = (1.00000000000000e+000 - xyz_cloudcover(i-
     .       1            1,j,k))**2/(2.00000000000000e+000*(xyz_qh2ovapsat(i-1,
     .       2            j,k)-xyz_qh2ovap(i-1,j,k)))*xyz_dqh2ovapsatdt(i-1,j,k)
     .       3            *xyz_zeroonecloudprod(i-1,j,k)                        
     .              else                                                        
     .                 xyz_facte114 = 0.0000000000000000e+000                   
     .              endif                                                       
     .              xyz_facte1(i-1,j,k) = xyz_facte114                          
     .              if ((xyz_qh2ovapsat(i-1,j,k).gt.xyz_qh2ovap(i-1,j,k))) then 
     .                 xyz_facte215 = xyz_cloudcover(i-1,j,k)**2*               
     .       1            9.99999999999999e-007*(xyz_qh2ovapsat(i-1,j,k)-       
     .       2            xyz_qh2ovap(i-1,j,k))/(xyz_qcloudwater(i-1,j,k)+      
     .       3            1.00000000000000e-100)                                
     .              else                                                        
     .                 xyz_facte215 = 0.0000000000000000e+000                   
     .              endif                                                       
     .              xyz_facte2(i-1,j,k) = xyz_facte215                          
     .           enddo                                                          
     .        enddo                                                             
   512        xyz_FactE(:,:,k) = xyz_FactE1(:,:,k) + xyz_FactE2(:,:,k)
     .        d17 = 1.D0/2.00000000000000e+000                                  
     .  !cdir nodep                                                             
     .        do t2122 = 1, xyz_facte1.DSC.U1 + 1                               
     .           xyz_facte(t2122-1,t2120+1,k) = xyz_facte1(t2122-1,t2120+1,k) + 
     .       1      xyz_facte2(t2122-1,t2120+1,k)                               
     .           xyz_delcloudcoverstr1 = (2.00000000000000e+000*deltime)*       
     .       1      xyz_factc2(t2122-1,t2120+1,k) - xyz_factc2(t2122-1,t2120+1,k
     .       2      )/((xyz_factc(t2122-1,t2120+1,k)+xyz_factd(t2122-1,t2120+1,k
     .       3      ))+1.00000000000000e-100)*((2.00000000000000e+000*deltime)* 
     .       4      xyz_factc(t2122-1,t2120+1,k)+(xyz_cloudcover(t2122-1,t2120+1
     .       5      ,k)-xyz_factc(t2122-1,t2120+1,k)/((xyz_factc(t2122-1,t2120+1
     .       6      ,k)+xyz_factd(t2122-1,t2120+1,k))+1.00000000000000e-100))*( 
     .       7      1.00000000000000e+000-dexp((-(xyz_factc(t2122-1,t2120+1,k)+ 
     .       8      xyz_factd(t2122-1,t2120+1,k))*2.00000000000000e+000*deltime)
     .       9      ))) + (2.00000000000000e+000*deltime)*xyz_facte1(t2122-1,   
     .       .      t2120+1,k)                                                  
     .           xyz_facta1(t2122-1,t2120+1,k) = xyz_dqcloudwaterdtcum(t2122-1, 
     .       1      t2120+1,k)                                                  
     .           xyz_facta2(t2122-1,t2120+1,k) = (-(xyz_cloudcover(t2122-1,t2120
     .       1      +1,k)*xyz_dqh2ovapsatdt(t2122-1,t2120+1,k))*                
     .       2      xyz_zeroonecloudprod(t2122-1,t2120+1,k)) -                  
     .       3      xyz_delcloudcoverstr1*xyz_dqh2ovapsatdt(t2122-1,t2120+1,k)* 
     .       4      xyz_zeroonecloudprod(t2122-1,t2120+1,k)*d17 - (             
     .       5      xyz_cloudcover(t2122-1,t2120+1,k)*xyz_dqh2ovapsatdt(t2122-1,
     .       6      t2120+1,k))*(1.00000000000000e+000 - xyz_zeroonecloudloss(  
     .       7      t2122-1,t2120+1,k)) - xyz_cloudcover(t2122-1,t2120+1,k)*    
     .       8      9.99999999999999e-007*(xyz_qh2ovapsat(t2122-1,t2120+1,k)-   
     .       9      xyz_qh2ovap(t2122-1,t2120+1,k))                             
     .        enddo                                                             
   513        !
   514        xyz_DelCloudCoverStr(:,:,k) =                                         &
   515          &   xyz_FactC2(:,:,k) * 2.0_DP * DelTime                            &
   516          & - xyz_FactC2(:,:,k)                                               &
   517          &  / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 )             &
   518          &   * (                                                             &
   519          &         xyz_FactC(:,:,k) * 2.0_DP * DelTime                       &
   520          &       + ( xyz_CloudCover(:,:,k)                                   &
   521          &             - xyz_FactC(:,:,k)                                    &
   522          &             / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 ) )&
   523          &         * ( 1.0_DP                                                &
   524          &               - exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) )    &
   525          &                   * 2.0_DP * DelTime ) )                          &
   526          &     )                                                             &
   527          & + xyz_FactE1(:,:,k) * 2.0_DP * DelTime
   528        !
   529        xyz_FactA1(:,:,k) = xyz_DQCloudWaterDtCum(:,:,k)
   530        xyz_FactA2(:,:,k) =                                                   &
   531          & - xyz_CloudCover(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)                &
   532          &     * xyz_ZeroOneCloudProd(:,:,k)                                 &
   533          & - xyz_DelCloudCoverStr(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)          &
   534          &     * xyz_ZeroOneCloudProd(:,:,k)                                 &
   535          &     / 2.0_DP                                                      &
   536          & - xyz_CloudCover(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)                &
   537          &     * ( 1.0_DP - xyz_ZeroOneCloudLoss(:,:,k) )                    &
   538          & - xyz_CloudCover(:,:,k) * MixCoef                                 &
   539          &     * ( xyz_QH2OVapSat(:,:,k) - xyz_QH2OVap(:,:,k) )
   540        !    The value of xyz_FactA2 is checked, and is updated.
   541        do j = 1, jmax
   542          do i = 0, imax-1
   543            if ( xyz_FactA2(i,j,k) * 2.0_DP * DelTime > xyz_QH2OVap(i,j,k) ) then
   544              xyz_FactA2(i,j,k) = xyz_QH2OVap(i,j,k) / ( 2.0_DP * DelTime ) &
   545                & * ( 1.0_DP - 1.0d-14 )
   546            end if
   547          end do
   548        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if ((2.00000000000000e+000*deltime)*xyz_facta2(j-1,1,k) .gt.   
     .       1      xyz_qh2ovap(j-1,1,k)) then                                  
     .              xyz_facta2(j-1,1,k) = xyz_qh2ovap(j-1,1,k)/(                
     .       1         2.00000000000000e+000*deltime)*9.99999999999990e-001     
     .           endif                                                          
     .        enddo                                                             
   549        xyz_FactA(:,:,k) = xyz_FactA1(:,:,k) + xyz_FactA2(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2186 = 1, xyz_facta1.DSC.U2*xyz_facta1.DSC.U1 +               
     .       1   xyz_facta1.DSC.U2                                              
     .           xyz_facta(t2186-1,1,k) = xyz_facta1(t2186-1,1,k) + xyz_facta2( 
     .       1      t2186-1,1,k)                                                
     .        enddo                                                             
   550  
   551  !!$        xy_RainConvFactor = 1.0_DP / ( CloudLifeTime0 + 1.0d-100 )
   552        !
   553        xy_FactCo = 1.0_DP &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2196 = 1, xy_rain.DSC.U2*xy_rain.DSC.U1 + xy_rain.DSC.U2      
     .           xy_factco(t2196-1,1) = 1.00000000000000e+000 +                 
     .       1      3.00000000000000e+002*dsqrt(xy_rain(t2196-1,1))             
     .           xy_factbf(t2196-1,1) = 1.00000000000000e+000                   
     .        enddo                                                             
   554          & + C1 * sqrt( xy_Rain )
   555        ! Factor for Bergeron-Findeisen effect
   556        !   Sundqvist et al. (1989)
   557  !!$      xy_FactBF = 1.0_DP &
   558  !!$        & + C2 * sqrt( max( 268.0_DP - xyz_Temp(:,:,k), 0.0_DP ) )
   559        !   An original equation following that by IFS CY38r1
   560        !   (p.82 of http://www.ecmwf.int/research/ifsdocs/CY38r1/IFSPart4.pdf)
   561  !!$      xy_FactBF = 1.0_DP                                               &
   562  !!$        & + C2 * sqrt( min(                                            &
   563  !!$        &                   max( 268.0_DP - xyz_Temp(:,:,k), 0.0_DP ), &
   564  !!$        &                   max( 268.0_DP - TempBFEffectSat, 0.0_DP )  &
   565  !!$        &                  )                                           &
   566  !!$        &            )
   567        !   Constant (no effect)
   568        xy_FactBF = 1.0_DP
   569        !
   570        RainConvFactor0 = 1.0_DP / ( CloudLifeTime0 + 1.0d-100 )
   571  !!$      xy_QCloudWatConvThreshold = &
   572  !!$        & QCloudWatEffConv0 / ( xy_FactCo * xy_FactBF )
   573        xy_QCloudWatConvThreshold = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2206 = 1, xy_factco.DSC.U2*xy_factco.DSC.U1 + xy_factco.DSC.U2
     .           xy_qcloudwatconvthreshold1 = (qcloudwateffconv0 +              
     .       1      1.00000000000000e-100)/(xy_factco(t2206-1,1)*xy_factbf(t2206
     .       2      -1,1))                                                      
     .           xy_rainconvfactor1 = (xy_factco(t2206-1,1)*xy_factbf(t2206-1,1)
     .       1      )*rainconvfactor0*(1.00000000000000e+000 - dexp((-(         
     .       2      xyz_qcloudwater(t2206-1,1,k)/((xyz_cloudcover(t2206-1,1,k)+ 
     .       3      1.00000000000000e-100)*xy_qcloudwatconvthreshold1))**2)))   
     .           xyz_factb(t2206-1,1,k) = xy_rainconvfactor1                    
     .        enddo                                                             
   574          & ( QCloudWatEffConv0 + 1.0e-100_DP ) / ( xy_FactCo * xy_FactBF )
   575        xy_RainConvFactor = RainConvFactor0 * xy_FactCo * xy_FactBF &
   576          & * (                                                     &
   577          &       1.0_DP                                            &
   578          &     - exp(                                              &
   579          &            - ( xyz_QCloudWater(:,:,k)                   &
   580          &                / ( ( xyz_CloudCover(:,:,k) + 1.0d-100 ) &
   581          &                    * xy_QCloudWatConvThreshold )   )**2 &
   582          &          )                                              &
   583          &   )
   584        !
   585        xyz_FactB(:,:,k) = xy_RainConvFactor
   586        !
   587        do j = 1, jmax
   588          do i = 0, imax-1
   589            if ( xyz_FactB(i,j,k) < 1.0_DP / 1.0d10 ) then
   590              xyz_FactB(i,j,k) = 1.0_DP / 1.0d10
   591            end if
   592          end do
   593        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyz_factb(j-1,1,k) .lt. 1.00000000000000e-010) then        
     .              xyz_factb(j-1,1,k) = 1.00000000000000e-010                  
     .           endif                                                          
     .        enddo                                                             
   594  
   595  
   596        ! Values at next time step are calculated.
   597        !
   598        xyz_QCloudWater(:,:,k) =                                             &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2232 = 1, xyz_factb.DSC.U2*xyz_factb.DSC.U1 + xyz_factb.DSC.U2
     .           xyz_qcloudwater(t2232-1,1,k) = xyz_qcloudwater(t2232-1,1,k)*(  
     .       1      dexp((-((xyz_factb(t2232-1,1,k)*2.00000000000000e+000)*     
     .       2      deltime)))) + xyz_facta(t2232-1,1,k)/xyz_factb(t2232-1,1,k)*
     .       3      (1.00000000000000e+000 - (dexp((-((xyz_factb(t2232-1,1,k)*  
     .       4      2.00000000000000e+000)*deltime)))))                         
     .        enddo                                                             
   599          &   xyz_QCloudWater(:,:,k)                                         &
   600          &     * exp( - xyz_FactB(:,:,k) * 2.0_DP * DelTime )               &
   601          & + xyz_FactA(:,:,k) / xyz_FactB(:,:,k)                            &
   602          &     * ( 1.0_DP - exp( - xyz_FactB(:,:,k) * 2.0_DP * DelTime ) )
   603        !   The value of cloud water amount is checked, and xyz_FactA
   604        !   is updated.
   605        do j = 1, jmax
   606          do i = 0, imax-1
   607            if ( xyz_QCloudWater(i,j,k) < 0.0_DP ) then
   608              xyz_FactA2(i,j,k) = - xyz_FactA1(i,j,k)                         &
   609                & - xyz_FactB(i,j,k) * xyz_QCloudWaterB(i,j,k)                &
   610                & * exp( - xyz_FactB(i,j,k) * 2.0_DP * DelTime )              &
   611                & / ( 1.0_DP - exp( - xyz_FactB(i,j,k) * 2.0_DP * DelTime ) )
   612              xyz_QCloudWater(i,j,k) = 0.0_DP
   613            end if
   614          end do
   615        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyz_qcloudwater(j-1,1,k) .lt. 0.0000000000000000e+000) then
     .              xyz_facta2(j-1,1,k) = (-xyz_facta1(j-1,1,k)) - xyz_factb(j-1
     .       1         ,1,k)*xyz_qcloudwaterb(j-1,1,k)*(dexp((-((xyz_factb(j-1,1
     .       2         ,k)*2.00000000000000e+000)*deltime))))/(                 
     .       3         1.00000000000000e+000 - (dexp((-((xyz_factb(j-1,1,k)*    
     .       4         2.00000000000000e+000)*deltime)))))                      
     .              xyz_qcloudwater(j-1,1,k) = 0.0000000000000000e+000          
     .           endif                                                          
     .        enddo                                                             
   616        xyz_FactA(:,:,k) = xyz_FactA1(:,:,k) + xyz_FactA2(:,:,k)
     .        d21 = latentheat/cpdry                                            
     .        d22 = 1.D0/(2.00000000000000e+000*deltime)                        
     .        d23 = 1.D0/grav                                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_press)                                                 
     .        do t2248 = 1, xyz_facta1.DSC.U2*xyz_facta1.DSC.U1 +               
     .       1   xyz_facta1.DSC.U2                                              
     .           xyz_facta(t2248-1,1,k) = xyz_facta1(t2248-1,1,k) + xyz_facta2( 
     .       1      t2248-1,1,k)                                                
     .           xyz_cloudcover(t2248-1,1,k) = xyz_cloudcover(t2248-1,1,k)*(dexp
     .       1      ((-(((xyz_factc(t2248-1,1,k)+xyz_factd(t2248-1,1,k))*       
     .       2      2.00000000000000e+000)*deltime)))) + (xyz_factc(t2248-1,1,k)
     .       3      +xyz_facte(t2248-1,1,k))/((xyz_factc(t2248-1,1,k)+xyz_factd(
     .       4      t2248-1,1,k))+1.00000000000000e-100)*(1.00000000000000e+000 
     .       5       - (dexp((-(((xyz_factc(t2248-1,1,k)+xyz_factd(t2248-1,1,k))
     .       6      *2.00000000000000e+000)*deltime)))))                        
     .           xyz_qh2ovap(t2248-1,1,k) = xyz_qh2ovap(t2248-1,1,k) - ((       
     .       1      xyz_facta2(t2248-1,1,k)*2.00000000000000e+000)*deltime)     
     .           xyz_temp(t2248-1,1,k) = xyz_temp(t2248-1,1,k) + ((xyz_facta2(  
     .       1      t2248-1,1,k)*2.00000000000000e+000)*deltime)*d21            
     .           xyz_rain1 = (2.00000000000000e+000*deltime)*xyz_facta(t2248-1,1
     .       1      ,k) + xyz_qcloudwaterb(t2248-1,1,k)*(1.00000000000000e+000  
     .       2       - (dexp((-((xyz_factb(t2248-1,1,k)*2.00000000000000e+000)* 
     .       3      deltime))))) - xyz_facta(t2248-1,1,k)/xyz_factb(t2248-1,1,k)
     .       4      *(1.00000000000000e+000 - (dexp((-((xyz_factb(t2248-1,1,k)* 
     .       5      2.00000000000000e+000)*deltime)))))                         
     .           xyz_rain1 = xyz_rain1*d22                                      
     .           xy_rain(t2248-1,1) = xy_rain(t2248-1,1) + xyz_rain1*(xyr_press(
     .       1      t2248-1,1,k-1)-xyr_press(t2248-1,1,k))*d23                  
     .           xyz_rain(t2248-1,1,k) = xyz_rain1                              
     .        enddo                                                             
   617        !
   618        xyz_CloudCover(:,:,k) =                                            &
   619          &   xyz_CloudCover(:,:,k)                                        &
   620          &    * exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) )            &
   621          &               * 2.0_DP * DelTime )                             &
   622          & + ( xyz_FactC(:,:,k) + xyz_FactE(:,:,k) )                      &
   623          &    / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 )        &
   624          &    * ( 1.0_DP - exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) ) &
   625          &                          * 2.0_DP * DelTime ) )
   626        !
   627        xyz_QH2OVap(:,:,k) = xyz_QH2OVap(:,:,k) &
   628          & - xyz_FactA2(:,:,k) * 2.0_DP * DelTime
   629        !
   630        xyz_Temp(:,:,k) = xyz_Temp(:,:,k) &
   631          & + xyz_FactA2(:,:,k) * 2.0_DP * DelTime * LatentHeat / CpDry
   632  
   633  
   634        ! Rain
   635        !
   636        xyz_Rain(:,:,k) =                                                    &
   637          &   xyz_FactA(:,:,k) * 2.0_DP * DelTime                            &
   638          & + xyz_QCloudWaterB(:,:,k)                                        &
   639          &    * ( 1.0_DP - exp( - xyz_FactB(:,:,k) * 2.0_DP * DelTime ) )   &
   640          & - xyz_FactA(:,:,k) / xyz_FactB(:,:,k)                            &
   641          &    * ( 1.0_DP - exp( - xyz_FactB(:,:,k) * 2.0_DP * DelTime ) )
   642        xyz_Rain(:,:,k) = xyz_Rain(:,:,k) / ( 2.0_DP * DelTime )
   643  
   644        ! Rain at the surface
   645        xy_Rain = xy_Rain     &
   646          & + xyz_Rain(:,:,k) &
   647          &    * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   648  
   649        ! Evaporation
   650        !
   651        do j = 1, jmax
   652          do i = 0, imax-1
   653            if ( xyz_QCloudWater(i,j,k) < QCloudWaterEvapThreshold ) then
   654              xyz_CloudCover(i,j,k) = 0.0_DP
   655            end if
   656          end do
   657        end do
   658  
   659        ! Cloud cover is restricted.
   660        do j = 1, jmax
   661          do i = 0, imax-1
   662            if ( xyz_CloudCover(i,j,k) > 1.0_DP ) then
   663              xyz_CloudCover(i,j,k) = 1.0_DP
   664            else if ( xyz_CloudCover(i,j,k) < 0.0_DP ) then
   665              xyz_CloudCover(i,j,k) = 0.0_DP
   666            end if
   667          end do
   668        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyz_qcloudwater(j-1,1,k) .lt. 1.00000000000000e-010) then  
     .              xyz_cloudcover(j-1,1,k) = 0.0000000000000000e+000           
     .           endif                                                          
     .           if (xyz_cloudcover(j-1,1,k) .gt. 1.00000000000000e+000) then   
     .              xyz_cloudcover(j-1,1,k) = 1.00000000000000e+000             
     .           else                                                           
     .              if (xyz_cloudcover(j-1,1,k) .lt. 0.0000000000000000e+000)   
     .       1         then                                                     
     .                 xyz_cloudcover(j-1,1,k) = 0.0000000000000000e+000        
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   669  
   670  
   671        ! Check values
   672        do j = 1, jmax
   673          do i = 0, imax-1
   674            if ( xyz_QH2OVap(i,j,k) < 0.0_DP ) then
   675              write( 6, * ) 'QH2OVap is negative', &
   676                & i, j, k, xyz_QH2OVap(i,j,k)
   677            end if
   678            if ( xyz_QCloudWater(i,j,k) < 0.0_DP ) then
   679              write( 6, * ) 'QCloudWater is negative', &
   680                & i, j, k, xyz_QCloudWater(i,j,k)
   681            end if
   682          end do
   683        end do
   684  
   685      end do k_loop
   686  
   687  
   688      xyz_DTempDtLSC = 0.0_DP
   689      xyz_DQVapDtLSC = 0.0_DP
   690  
   691      ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
   692      ! Large scale condensation (non-convective condensation) (Manabe, 1965)
   693      !
   694      call LScaleCond(                        &
   695        & xyz_Temp, xyz_QH2OVap,              & ! (inout)
   696        & xyz_Press, xyr_Press,               & ! (in)
   697        & xyz_RainLSC                         & ! (out)
   698        & )
   699  
   700      xy_RainLSC = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2330 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +               
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t2330-1,1) = 0.0000000000000000e+000                
     .        enddo                                                             
   701      do k = kmax, 1, -1
   702        xy_RainLSC = xy_RainLSC     &
     .        d24 = 1.D0/grav                                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_press,xy_rainlsc)                                      
     .        do t2336 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +               
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t2336-1,1) = xy_rainlsc(t2336-1,1) + xyz_rainlsc(   
     .       1      t2336-1,1,k)*(xyr_press(t2336-1,1,k-1)-xyr_press(t2336-1,1,k
     .       2      ))*d24                                                      
     .        enddo                                                             
   703          & + xyz_RainLSC(:,:,k)    &
   704          &    * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   705      end do
   706  
   707  
   708      xy_Rain = xy_Rain + xy_RainLSC
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_rainlsc)                                                
     .        do t2350 = 1, xy_rain.DSC.U2*xy_rain.DSC.U1 + xy_rain.DSC.U2      
     .           xy_rain(t2350-1,1) = xy_rain(t2350-1,1) + xy_rainlsc(t2350-1,1)
     .        enddo                                                             
   709  
   710  
   711      call CloudSimpleCalcPRCPKeyLLTemp(     &
   712        & xyz_Temp, xy_Rain,                 &  ! (in )
   713        & xy_SurfRainFlux, xy_SurfSnowFlux   &  ! (out)
   714        & )
   715  
   716  
   717    end subroutine CloudT1993base
   718  
   719    !----------------------------------------------------------------------------
   720  
   721    subroutine CloudT1993baseWithIce(                             &
   722      & xyz_Press, xyr_Press, xyz_VirTemp,                        & ! (in)
   723      & xyz_DQCloudWatDtCum, xyz_DQCloudIceDtCum,                 & ! (in)
   724      & xyz_MoistConvDetTend,                                     & ! (in)
   725      & xyz_OMG, xyz_MoistConvSubsidMassFlux, xyz_DTempDtPhy,     & ! (in)
   726      & xyz_Temp, xyz_QH2OVap,                                    & ! (inout)
   727      & xyz_QCloudWat, xyz_QCloudIce,                             & ! (inout)
   728      & xyz_CloudCover,                                           & ! (inout)
   729      & xy_SurfRainFlux, xy_SurfSnowFlux                          & ! (out)
   730      & )
   731  
   732      ! USE statements
   733      !
   734  
   735      ! 時刻管理
   736      ! Time control
   737      !
   738      use timeset, only: &
   739        & DelTime            ! $ \Delta t $ [s]
   740  
   741      ! 物理・数学定数設定
   742      ! Physical and mathematical constants settings
   743      !
   744      use constants0, only: &
   745        & PI                    ! $ \pi $ .
   746                                ! 円周率.  Circular constant
   747  
   748      ! 物理定数設定
   749      ! Physical constants settings
   750      !
   751      use constants, only: &
   752        & Grav, &
   753                                ! $ g $ [m s-2].
   754                                ! 重力加速度.
   755                                ! Gravitational acceleration
   756        & CpDry, &
   757                                ! $ C_p $ [J kg-1 K-1].
   758                                ! 乾燥大気の定圧比熱.
   759                                ! Specific heat of air at constant pressure
   760        & GasRDry, &
   761                                ! $ R $ [J kg-1 K-1].
   762                                ! 乾燥大気の気体定数.
   763                                ! Gas constant of air
   764        & GasRWet, &
   765                                ! $ R_v $ [J kg-1 K-1].
   766                                ! 凝結成分の気体定数.
   767                                ! Gas constant of condensible elements
   768        & LatentHeat, &
   769                                ! $ L $ [J kg-1] .
   770                                ! 凝結の潜熱.
   771                                ! Latent heat of condensation
   772        & LatentHeatFusion, &
   773                                ! $ L $ [J kg-1] .
   774                                ! 融解の潜熱.
   775                                ! Latent heat of fusion
   776        & EpsV
   777                                ! $ \epsilon_v $ .
   778                                ! 水蒸気分子量比.
   779                                ! Molecular weight of water vapor
   780  
   781      ! 飽和比湿の算出
   782      ! Evaluate saturation specific humidity
   783      !
   784      use saturate, only: &
   785        & xyz_CalcQVapSat     , xyz_CalcDQVapSatDTemp
   786  !!$      & xyz_CalcQVapSatOnLiq, xyz_CalcDQVapSatOnLiqDTemp, &
   787  !!$      & xyz_CalcQVapSatOnSol, xyz_CalcDQVapSatOnSolDTemp
   788  
   789      ! 飽和比湿の算出
   790      ! Evaluate saturation specific humidity
   791      !
   792      use saturate, only : SaturateWatFraction
   793  
   794      ! 大規模凝結 (非対流性凝結)
   795      ! Large scale condensation
   796      !
   797      use lscond, only: &
   798  !!$      & LScaleCond1D3DWrapper, &
   799        & LScaleCond1Grid
   800  
   801      ! 雲関系ルーチン
   802      ! Cloud-related routines
   803      !
   804      use cloud_utils, only : &
   805        & CloudUtilsPRCPStepPC1Grid, &
   806        & CloudUtilsPRCPEvap1Grid, &
   807        & CloudUtilConsChk
   808  
   809  
   810      real(DP), intent(in   ) :: xyz_Press                  (0:imax-1, 1:jmax, 1:kmax)
   811      real(DP), intent(in   ) :: xyr_Press                  (0:imax-1, 1:jmax, 0:kmax)
   812      real(DP), intent(in   ) :: xyz_VirTemp                (0:imax-1, 1:jmax, 1:kmax)
   813      real(DP), intent(in   ) :: xyz_DQCloudWatDtCum        (0:imax-1, 1:jmax, 1:kmax)
   814      real(DP), intent(in   ) :: xyz_DQCloudIceDtCum        (0:imax-1, 1:jmax, 1:kmax)
   815      real(DP), intent(in   ) :: xyz_MoistConvDetTend       (0:imax-1, 1:jmax, 1:kmax)
   816      real(DP), intent(in   ) :: xyz_OMG                    (0:imax-1, 1:jmax, 1:kmax)
   817      real(DP), intent(in   ) :: xyz_MoistConvSubsidMassFlux(0:imax-1, 1:jmax, 1:kmax)
   818      real(DP), intent(in   ) :: xyz_DTempDtPhy             (0:imax-1, 1:jmax, 1:kmax)
   819      real(DP), intent(inout) :: xyz_Temp                   (0:imax-1, 1:jmax, 1:kmax)
   820      real(DP), intent(inout) :: xyz_QH2OVap                (0:imax-1, 1:jmax, 1:kmax)
   821      real(DP), intent(inout) :: xyz_QCloudWat              (0:imax-1, 1:jmax, 1:kmax)
   822      real(DP), intent(inout) :: xyz_QCloudIce              (0:imax-1, 1:jmax, 1:kmax)
   823      real(DP), intent(inout) :: xyz_CloudCover             (0:imax-1, 1:jmax, 1:kmax)
   824      real(DP), intent(out)   :: xy_SurfRainFlux            (0:imax-1, 1:jmax)
   825      real(DP), intent(out)   :: xy_SurfSnowFlux            (0:imax-1, 1:jmax)
   826  
   827  
   828      ! Local variables
   829      !
   830      real(DP) :: xyz_TempB            (0:imax-1, 1:jmax, 1:kmax)
   831      real(DP) :: xyz_QH2OVapB         (0:imax-1, 1:jmax, 1:kmax)
   832      real(DP) :: xyz_QCloudWatB       (0:imax-1, 1:jmax, 1:kmax)
   833      real(DP) :: xyz_QCloudIceB       (0:imax-1, 1:jmax, 1:kmax)
   834  
   835      real(DP) :: LatentHeatSubl
   836  
   837      real(DP) :: xyz_WatFrac          (0:imax-1, 1:jmax, 1:kmax)
   838      real(DP) :: xyz_IceFrac          (0:imax-1, 1:jmax, 1:kmax)
   839  
   840      real(DP) :: xyz_QH2OVapSat       (0:imax-1, 1:jmax, 1:kmax)
   841      real(DP) :: xyz_DQH2OVapSatDTemp (0:imax-1, 1:jmax, 1:kmax)
   842  
   843  !!$    real(DP) :: xyz_QH2OVapSatOnLiq  (0:imax-1, 1:jmax, 1:kmax)
   844  !!$    real(DP) :: xyz_QH2OVapSatOnIce  (0:imax-1, 1:jmax, 1:kmax)
   845  
   846      real(DP) :: xyz_DQH2OVapSatDPressDenom(0:imax-1, 1:jmax, 1:kmax)
   847  
   848      real(DP) :: xyz_DQH2OVapSatDPress(0:imax-1, 1:jmax, 1:kmax)
   849      real(DP) :: xyz_DQH2OVapSatDt    (0:imax-1, 1:jmax, 1:kmax)
   850  
   851      real(DP) :: xyz_ZOCloudProd   (0:imax-1, 1:jmax, 1:kmax)
   852      real(DP) :: xyz_ZOCloudLoss   (0:imax-1, 1:jmax, 1:kmax)
   853      real(DP) :: xyz_DelCloudCoverStr(0:imax-1, 1:jmax, 1:kmax)
   854      real(DP) :: xyz_FactAl          (0:imax-1, 1:jmax, 1:kmax)
   855      real(DP) :: xyz_FactAs          (0:imax-1, 1:jmax, 1:kmax)
   856      real(DP) :: xyz_FactAl1         (0:imax-1, 1:jmax, 1:kmax)
   857      real(DP) :: xyz_FactAs1         (0:imax-1, 1:jmax, 1:kmax)
   858      real(DP) :: xyz_FactA20         (0:imax-1, 1:jmax, 1:kmax)
   859      real(DP) :: xyz_FactAl2         (0:imax-1, 1:jmax, 1:kmax)
   860      real(DP) :: xyz_FactAs2         (0:imax-1, 1:jmax, 1:kmax)
   861      real(DP) :: xyz_FactBl          (0:imax-1, 1:jmax, 1:kmax)
   862      real(DP) :: xyz_FactBs          (0:imax-1, 1:jmax, 1:kmax)
   863      real(DP) :: xyz_FactC           (0:imax-1, 1:jmax, 1:kmax)
   864      real(DP) :: xyz_FactC1          (0:imax-1, 1:jmax, 1:kmax)
   865      real(DP) :: xyz_FactC2          (0:imax-1, 1:jmax, 1:kmax)
   866      real(DP) :: xyz_FactD           (0:imax-1, 1:jmax, 1:kmax)
   867      real(DP) :: xyz_FactE           (0:imax-1, 1:jmax, 1:kmax)
   868      real(DP) :: xyz_FactE1          (0:imax-1, 1:jmax, 1:kmax)
   869      real(DP) :: xyz_FactE2          (0:imax-1, 1:jmax, 1:kmax)
   870  
   871      real(DP) :: xy_Rain                    (0:imax-1, 1:jmax)
   872      real(DP) :: xyz_Rain                   (0:imax-1, 1:jmax, 1:kmax)
   873      real(DP) :: xy_Snow                    (0:imax-1, 1:jmax)
   874      real(DP) :: xyz_Snow                   (0:imax-1, 1:jmax, 1:kmax)
   875  
   876      real(DP) :: xy_FactCo                (0:imax-1, 1:jmax)
   877      real(DP) :: xy_FactBF                (0:imax-1, 1:jmax)
   878      real(DP) :: xy_QCloudWatConvThreshold(0:imax-1, 1:jmax)
   879      real(DP) :: xy_QCloudIceConvThreshold(0:imax-1, 1:jmax)
   880      real(DP) :: xy_FactIceTempDep        (0:imax-1, 1:jmax)
   881      real(DP) :: xy_FactConvThreshold     (0:imax-1, 1:jmax)
   882  
   883      real(DP) :: xy_RainConvFactor          (0:imax-1, 1:jmax)
   884      real(DP) :: xy_SnowConvFactor          (0:imax-1, 1:jmax)
   885  
   886      real(DP) :: xyz_DQH2OLiqDtLSC      (0:imax-1, 1:jmax, 1:kmax)
   887      real(DP) :: xyz_DQH2OSolDtLSC      (0:imax-1, 1:jmax, 1:kmax)
   888  
   889  
   890      real(DP), parameter :: MixCoef                  = 1.0d-6
   891      real(DP), parameter :: QCloudWaterEvapThreshold = 1.0d-10
   892  !!$    real(DP), parameter :: RHThreshold              = 0.999_DP
   893      real(DP), parameter :: RHThreshold              = 1.0_DP - 1.0d-10
   894      ! Values below are obtained from Sundqvist et al. (1989), but some of
   895      ! those are arbitrarily selected.
   896      real(DP)            :: RainConvFactor0
   897      real(DP)            :: SnowConvFactor0
   898      real(DP), parameter :: C2                       = 0.5_DP
   899  
   900  
   901      ! Parameters for evaporation of rain
   902      real(DP), parameter :: DensWater            = 1.0d3
   903      !                            rho_w
   904      !   Values below are from Kessler (1969)
   905      real(DP), parameter :: RainFallVelFactor         = 130.0d0
   906      !                            K
   907      real(DP), parameter :: MedianDiameterFactor      = 3.67d0
   908      !                            C'
   909      real(DP), parameter :: RainDistFactor            = 1.0d7
   910      !                            N0
   911      real(DP), parameter :: RainEvapRatUnitDiamFactor = 2.24d3
   912      !                            C
   913      real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
   914      !                            Kd
   915  
   916      real(DP) :: Dens0
   917      !                            rho_0
   918      real(DP) :: V00
   919      !                            V_{00}
   920      real(DP) :: RainEvapFactor
   921  
   922      real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   923      !                           rho
   924      real(DP) :: xy_DensRain     (0:imax-1, 1:jmax)
   925      !                           (rho q_r)
   926      real(DP) :: xy_RainArea     (0:imax-1, 1:jmax)
   927      !                           a_p
   928      real(DP) :: xy_RainEvapArea (0:imax-1, 1:jmax)
   929      !                           A = max( a_p - a, 0 )
   930      real(DP) :: xyz_RainEvapRate(0:imax-1, 1:jmax, 1:kmax)
   931  
   932      real(DP) :: xyz_DelMass( 0:imax-1, 1:jmax, 1:kmax )
   933      real(DP) :: aaa_QH2OVapSat(1,1,1)
   934      real(DP) :: QH2OVapSat
   935  
   936      real(DP) :: QCloudWatTentative
   937      real(DP) :: QCloudIceTentative
   938  
   939      real(DP) :: xyz_Sigma               (0:imax-1, 1:jmax, 1:kmax)
   940      real(DP) :: xyz_CloudProdRHThreshold(0:imax-1, 1:jmax, 1:kmax)
   941  
   942      integer :: i
   943      integer :: j
   944      integer :: k
   945      integer :: l
   946  
   947  
   948      ! 実行文 ; Executable statement
   949      !
   950  
   951      ! 初期化確認
   952      ! Initialization check
   953      !
   954      if ( .not. cloud_T1993base_inited ) then
   955        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   956      end if
   957  
   958  
   959      ! Save current values
   960      !
   961      xyz_TempB      = xyz_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2500 = 1, xyz_tempb.DSC.U3*(xyz_tempb.DSC.U2*xyz_tempb.DSC.U1 
     .       1    + xyz_tempb.DSC.U2)                                           
     .           xyz_tempb(t2500-1,1,1) = xyz_temp(t2500-1,1,1)                 
     .           xyz_qh2ovapb(t2500-1,1,1) = xyz_qh2ovap(t2500-1,1,1)           
     .           xyz_qcloudwatb(t2500-1,1,1) = xyz_qcloudwat(t2500-1,1,1)       
     .           xyz_qcloudiceb(t2500-1,1,1) = xyz_qcloudice(t2500-1,1,1)       
     .        enddo                                                             
   962      xyz_QH2OVapB   = xyz_QH2OVap
   963      xyz_QCloudWatB = xyz_QCloudWat
   964      xyz_QCloudIceB = xyz_QCloudIce
   965  
   966  
   967      ! Latent heat for sublimation (sum of evaporation and fusion)
   968      LatentHeatSubl = LatentHeat + LatentHeatFusion
   969  
   970  
   971      do k = 1, kmax
   972        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   973      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
   974  
   975      ! Parameters for evaporation of rain
   976      Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
   977      V00 = RainFallVelFactor * sqrt( MedianDiameterFactor ) &
   978        & / ( PI * DensWater * RainDistFactor )**(1.0d0/8.0d0)
   979      RainEvapFactor =                                      &
   980  !      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
   981        & RainEvapRatUnitDiamFactor * 1.429624558860304d0   &
   982        & * H2OVapDiffCoef * RainDistFactor**(7.0d0/20.0d0) &
   983        & / ( PI * DensWater )**(13.0d0/20.0d0)
   984      ! Values for evaporation of rain
   985      xyz_Dens = xyz_Press / ( GasRDry * xyz_VirTemp )
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j1 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t2542 = j1 + 1, xyz_press.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .              do t2544 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyz_dens(t2544-1,t2542,t2540+1) = xyz_press(t2544-1,t2542
     .       1            ,t2540+1)/(gasrdry*xyz_virtemp(t2544-1,t2542,t2540+1))
     .                 xyz_dens(t2544-1,t2542+1,t2540+1) = xyz_press(t2544-1,   
     .       1            t2542+1,t2540+1)/(gasrdry*xyz_virtemp(t2544-1,t2542+1,
     .       2            t2540+1))                                             
     .                 xyz_dens(t2544-1,t2542+2,t2540+1) = xyz_press(t2544-1,   
     .       1            t2542+2,t2540+1)/(gasrdry*xyz_virtemp(t2544-1,t2542+2,
     .       2            t2540+1))                                             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   986  
   987  
   988      ! Calculate liquid water fraction and ice fraction
   989      !
   990      call SaturateWatFraction( &
   991        & xyz_Temp,             & ! (in )
   992        & xyz_WatFrac           & ! (out)
   993        & )
   994      xyz_IceFrac = 1.0_DP - xyz_WatFrac
   995  
   996  
   997      xyz_QH2OVapSat       = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   998      xyz_DQH2OVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QH2OVapSat )
   999  
  1000  !!$    xyz_QH2OVapSatOnLiq       = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
  1001  !!$    xyz_DQH2OVapSatOnLiqDTemp = xyz_CalcDQVapSatOnLiqDTemp( xyz_Temp, xyz_QH2OVapSatOnLiq )
  1002  !!$    xyz_QH2OVapSatOnIce       = xyz_CalcQVapSatOnIce( xyz_Temp, xyz_Press )
  1003  !!$    xyz_DQH2OVapSatOnIceDTemp = xyz_CalcDQVapSatOnIceDTemp( xyz_Temp, xyz_QH2OVapSatOnIce )
  1004  
  1005      xyz_DQH2OVapSatDPressDenom =                                        &
     .           if (jmax .gt. 0) then                                          
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t2575 = 1, j2                                               
     .              d4 = 1.D0/cpdry                                             
     .              d5 = gasrdry/cpdry                                          
     .  !cdir       nodep                                                       
     .              do t2577 = 1, imax                                          
     .                 xyz_dqh2ovapsatdpressdenom1 = 1.00000000000000e+000 +    
     .       1            xyz_cloudcover(t2577-1,t2575,t2573+1)*d4*(xyz_watfrac(
     .       2            t2577-1,t2575,t2573+1)*latentheat+xyz_icefrac(t2577-1,
     .       3            t2575,t2573+1)*latentheatsubl)*xyz_dqh2ovapsatdtemp(  
     .       4            t2577-1,t2575,t2573+1)                                
     .                 xyz_dqh2ovapsatdpress1 = (xyz_virtemp(t2577-1,t2575,t2573
     .       1            +1)*d5*xyz_dqh2ovapsatdtemp(t2577-1,t2575,t2573+1)-   
     .       2            xyz_qh2ovapsat(t2577-1,t2575,t2573+1))/(xyz_press(    
     .       3            t2577-1,t2575,t2573+1)*xyz_dqh2ovapsatdpressdenom1)   
     .                 xyz_dqh2ovapsatdt(t2577-1,t2575,t2573+1) =               
     .       1            xyz_dqh2ovapsatdpress1*(xyz_omg(t2577-1,t2575,t2573+1)
     .       2            +grav*xyz_moistconvsubsidmassflux(t2577-1,t2575,t2573+
     .       3            1)) + xyz_dqh2ovapsatdtemp(t2577-1,t2575,t2573+1)/    
     .       4            xyz_dqh2ovapsatdpressdenom1*xyz_dtempdtphy(t2577-1,   
     .       5            t2575,t2573+1)                                        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2575 = j2 + 1, jmax, 4                                     
     .              d6 = 1.D0/cpdry                                             
     .              d7 = 1.D0/cpdry                                             
     .              d8 = 1.D0/cpdry                                             
     .              d9 = 1.D0/cpdry                                             
     .              d10 = gasrdry/cpdry                                         
     .              d11 = gasrdry/cpdry                                         
     .              d12 = gasrdry/cpdry                                         
     .              d13 = gasrdry/cpdry                                         
     .  !cdir       nodep                                                       
     .              do t2577 = 1, imax                                          
     .                 xyz_dqh2ovapsatdpressdenom(t2577-1,t2575,t2573+1) =      
     .       1            1.00000000000000e+000 + xyz_cloudcover(t2577-1,t2575, 
     .       2            t2573+1)*d6*(xyz_watfrac(t2577-1,t2575,t2573+1)*      
     .       3            latentheat+xyz_icefrac(t2577-1,t2575,t2573+1)*        
     .       4            latentheatsubl)*xyz_dqh2ovapsatdtemp(t2577-1,t2575,   
     .       5            t2573+1)                                              
     .                 xyz_dqh2ovapsatdpressdenom(t2577-1,t2575+1,t2573+1) =    
     .       1            1.00000000000000e+000 + xyz_cloudcover(t2577-1,t2575+1
     .       2            ,t2573+1)*d7*(xyz_watfrac(t2577-1,t2575+1,t2573+1)*   
     .       3            latentheat+xyz_icefrac(t2577-1,t2575+1,t2573+1)*      
     .       4            latentheatsubl)*xyz_dqh2ovapsatdtemp(t2577-1,t2575+1, 
     .       5            t2573+1)                                              
     .                 xyz_dqh2ovapsatdpressdenom(t2577-1,t2575+2,t2573+1) =    
     .       1            1.00000000000000e+000 + xyz_cloudcover(t2577-1,t2575+2
     .       2            ,t2573+1)*d8*(xyz_watfrac(t2577-1,t2575+2,t2573+1)*   
     .       3            latentheat+xyz_icefrac(t2577-1,t2575+2,t2573+1)*      
     .       4            latentheatsubl)*xyz_dqh2ovapsatdtemp(t2577-1,t2575+2, 
     .       5            t2573+1)                                              
     .                 xyz_dqh2ovapsatdpressdenom(t2577-1,t2575+3,t2573+1) =    
     .       1            1.00000000000000e+000 + xyz_cloudcover(t2577-1,t2575+3
     .       2            ,t2573+1)*d9*(xyz_watfrac(t2577-1,t2575+3,t2573+1)*   
     .       3            latentheat+xyz_icefrac(t2577-1,t2575+3,t2573+1)*      
     .       4            latentheatsubl)*xyz_dqh2ovapsatdtemp(t2577-1,t2575+3, 
     .       5            t2573+1)                                              
     .                 xyz_dqh2ovapsatdpress(t2577-1,t2575,t2573+1) = (         
     .       1            xyz_virtemp(t2577-1,t2575,t2573+1)*d10*               
     .       2            xyz_dqh2ovapsatdtemp(t2577-1,t2575,t2573+1)-          
     .       3            xyz_qh2ovapsat(t2577-1,t2575,t2573+1))/(xyz_press(    
     .       4            t2577-1,t2575,t2573+1)*xyz_dqh2ovapsatdpressdenom(    
     .       5            t2577-1,t2575,t2573+1))                               
     .                 xyz_dqh2ovapsatdpress(t2577-1,t2575+1,t2573+1) = (       
     .       1            xyz_virtemp(t2577-1,t2575+1,t2573+1)*d11*             
     .       2            xyz_dqh2ovapsatdtemp(t2577-1,t2575+1,t2573+1)-        
     .       3            xyz_qh2ovapsat(t2577-1,t2575+1,t2573+1))/(xyz_press(  
     .       4            t2577-1,t2575+1,t2573+1)*xyz_dqh2ovapsatdpressdenom(  
     .       5            t2577-1,t2575+1,t2573+1))                             
     .                 xyz_dqh2ovapsatdpress(t2577-1,t2575+2,t2573+1) = (       
     .       1            xyz_virtemp(t2577-1,t2575+2,t2573+1)*d12*             
     .       2            xyz_dqh2ovapsatdtemp(t2577-1,t2575+2,t2573+1)-        
     .       3            xyz_qh2ovapsat(t2577-1,t2575+2,t2573+1))/(xyz_press(  
     .       4            t2577-1,t2575+2,t2573+1)*xyz_dqh2ovapsatdpressdenom(  
     .       5            t2577-1,t2575+2,t2573+1))                             
     .                 xyz_dqh2ovapsatdpress(t2577-1,t2575+3,t2573+1) = (       
     .       1            xyz_virtemp(t2577-1,t2575+3,t2573+1)*d13*             
     .       2            xyz_dqh2ovapsatdtemp(t2577-1,t2575+3,t2573+1)-        
     .       3            xyz_qh2ovapsat(t2577-1,t2575+3,t2573+1))/(xyz_press(  
     .       4            t2577-1,t2575+3,t2573+1)*xyz_dqh2ovapsatdpressdenom(  
     .       5            t2577-1,t2575+3,t2573+1))                             
     .                 xyz_dqh2ovapsatdt(t2577-1,t2575,t2573+1) =               
     .       1            xyz_dqh2ovapsatdpress(t2577-1,t2575,t2573+1)*(xyz_omg(
     .       2            t2577-1,t2575,t2573+1)+grav*                          
     .       3            xyz_moistconvsubsidmassflux(t2577-1,t2575,t2573+1)) + 
     .       4            xyz_dqh2ovapsatdtemp(t2577-1,t2575,t2573+1)/          
     .       5            xyz_dqh2ovapsatdpressdenom(t2577-1,t2575,t2573+1)*    
     .       6            xyz_dtempdtphy(t2577-1,t2575,t2573+1)                 
     .                 xyz_dqh2ovapsatdt(t2577-1,t2575+1,t2573+1) =             
     .       1            xyz_dqh2ovapsatdpress(t2577-1,t2575+1,t2573+1)*(      
     .       2            xyz_omg(t2577-1,t2575+1,t2573+1)+grav*                
     .       3            xyz_moistconvsubsidmassflux(t2577-1,t2575+1,t2573+1)) 
     .       4             + xyz_dqh2ovapsatdtemp(t2577-1,t2575+1,t2573+1)/     
     .       5            xyz_dqh2ovapsatdpressdenom(t2577-1,t2575+1,t2573+1)*  
     .       6            xyz_dtempdtphy(t2577-1,t2575+1,t2573+1)               
     .                 xyz_dqh2ovapsatdt(t2577-1,t2575+2,t2573+1) =             
     .       1            xyz_dqh2ovapsatdpress(t2577-1,t2575+2,t2573+1)*(      
     .       2            xyz_omg(t2577-1,t2575+2,t2573+1)+grav*                
     .       3            xyz_moistconvsubsidmassflux(t2577-1,t2575+2,t2573+1)) 
     .       4             + xyz_dqh2ovapsatdtemp(t2577-1,t2575+2,t2573+1)/     
     .       5            xyz_dqh2ovapsatdpressdenom(t2577-1,t2575+2,t2573+1)*  
     .       6            xyz_dtempdtphy(t2577-1,t2575+2,t2573+1)               
     .                 xyz_dqh2ovapsatdt(t2577-1,t2575+3,t2573+1) =             
     .       1            xyz_dqh2ovapsatdpress(t2577-1,t2575+3,t2573+1)*(      
     .       2            xyz_omg(t2577-1,t2575+3,t2573+1)+grav*                
     .       3            xyz_moistconvsubsidmassflux(t2577-1,t2575+3,t2573+1)) 
     .       4             + xyz_dqh2ovapsatdtemp(t2577-1,t2575+3,t2573+1)/     
     .       5            xyz_dqh2ovapsatdpressdenom(t2577-1,t2575+3,t2573+1)*  
     .       6            xyz_dtempdtphy(t2577-1,t2575+3,t2573+1)               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1006        &   1.0_DP                                                        &
  1007        & + xyz_CloudCover / CpDry                                        &
  1008        &   * ( xyz_WatFrac * LatentHeat + xyz_IceFrac * LatentHeatSubl ) &
  1009        &   * xyz_DQH2OVapSatDTemp
  1010  
  1011      xyz_DQH2OVapSatDPress =                                            &
  1012        &   ( - xyz_QH2OVapSat                                           &
  1013        &     + GasRDry * xyz_VirTemp / CpDry * xyz_DQH2OVapSatDTemp )   &
  1014        & / ( xyz_Press * xyz_DQH2OVapSatDPressDenom )
  1015  
  1016      xyz_DQH2OVapSatDt =                                              &
  1017        &   xyz_DQH2OVapSatDPress                                      &
  1018        &   * ( xyz_OMG + Grav * xyz_MoistConvSubsidMassFlux )         &
  1019        & + xyz_DQH2OVapSatDTemp / xyz_DQH2OVapSatDPressDenom          &
  1020        &   * xyz_DTempDtPhy
  1021  
  1022  
  1023      ! set zero-one flag
  1024      do k = 1, kmax
  1025        xyz_Sigma(:,:,k) = xyz_Press(:,:,k) / xyr_Press(:,:,0)
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j3 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t2633 = 1, j3                                               
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_press)                                           
     .              do t2635 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyz_sigma(t2635-1,t2633,k) = xyz_press(t2635-1,t2633,k)/ 
     .       1            xyr_press(t2635-1,t2633,0)                            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t2633 = j3 + 1, xyz_press.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_press)                                           
     .              do t2635 = 1, xyz_press.DSC.U1 + 1                          
     .                 xyz_sigma(t2635-1,t2633,k) = xyz_press(t2635-1,t2633,k)/ 
     .       1            xyr_press(t2635-1,t2633,0)                            
     .                 xyz_sigma(t2635-1,t2633+1,k) = xyz_press(t2635-1,t2633+1,
     .       1            k)/xyr_press(t2635-1,t2633+1,0)                       
     .                 xyz_sigma(t2635-1,t2633+2,k) = xyz_press(t2635-1,t2633+2,
     .       1            k)/xyr_press(t2635-1,t2633+2,0)                       
     .                 xyz_sigma(t2635-1,t2633+3,k) = xyz_press(t2635-1,t2633+3,
     .       1            k)/xyr_press(t2635-1,t2633+3,0)                       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1026      end do
  1027      xyz_CloudProdRHThreshold =                                     &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2643 = 1, kmax*jmax*imax                                      
     .           xyz_cloudprodrhthreshold(t2643-1,1,1) = rhthresholdcrtl + (    
     .       1      1.00000000000000e+000 - xyz_qh2ovap(t2643-1,1,1)/           
     .       2      xyz_qh2ovapsat(t2643-1,1,1))*(max((xyz_sigma(t2643-1,1,1)-  
     .       3      rhthresholdsigmamin),0.0000000000000000e+000)/(xyz_sigma(   
     .       4      t2643-1,1,1)-rhthresholdsigmamin))**rhthresholdord          
     .        enddo                                                             
  1028        &   RHThresholdCrtl                                          &
  1029        & + ( 1.0_DP - xyz_QH2OVap / xyz_QH2OVapSat )                &
  1030        &   * (   max( ( xyz_Sigma - RHThresholdSigmaMin ), 0.0_DP ) &
  1031        &       / ( xyz_Sigma - RHThresholdSigmaMin )                )**RHThresholdOrd
  1032      do k = 1, kmax
  1033        do j = 1, jmax
  1034          do i = 0, imax-1
  1035            if ( xyz_DQH2OVapSatDt(i,j,k) < 0.0_DP ) then
  1036              if ( xyz_QH2OVap(i,j,k) >= xyz_CloudProdRHThreshold(i,j,k) * xyz_QH2OVapSat(i,j,k) ) then
  1037                xyz_ZOCloudProd(i,j,k) = 1.0_DP
  1038              else
  1039                xyz_ZOCloudProd(i,j,k) = 0.0_DP
  1040              end if
  1041              xyz_ZOCloudLoss(i,j,k) = 1.0_DP
  1042            else
  1043              xyz_ZOCloudProd(i,j,k) = 0.0_DP
  1044              xyz_ZOCloudLoss(i,j,k) = 0.0_DP
  1045            end if
  1046          end do
  1047        end do
  1048      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_dqh2ovapsatdt(k-1,1,1) .lt. 0.0000000000000000e+000)   
     .       1      then                                                        
     .              if (xyz_qh2ovap(k-1,1,1) .ge. xyz_cloudprodrhthreshold(k-1,1
     .       1         ,1)*xyz_qh2ovapsat(k-1,1,1)) then                        
     .                 xyz_zocloudprod14 = 1.00000000000000e+000                
     .              else                                                        
     .                 xyz_zocloudprod14 = 0.0000000000000000e+000              
     .              endif                                                       
     .              xyz_zocloudloss15 = 1.00000000000000e+000                   
     .           else                                                           
     .              xyz_zocloudprod14 = 0.0000000000000000e+000                 
     .              xyz_zocloudloss15 = 0.0000000000000000e+000                 
     .           endif                                                          
     .           xyz_zocloudloss(k-1,1,1) = xyz_zocloudloss15                   
     .           xyz_zocloudprod(k-1,1,1) = xyz_zocloudprod14                   
     .        enddo                                                             
  1049  
  1050  
  1051      ! Rain and snow at the surface
  1052      xy_Rain     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2664 = 1, xy_rain.DSC.U2*xy_rain.DSC.U1 + xy_rain.DSC.U2      
     .           xy_rain(t2664-1,1) = 0.0000000000000000e+000                   
     .           xy_snow(t2664-1,1) = 0.0000000000000000e+000                   
     .        enddo                                                             
  1053      xy_Snow     = 0.0_DP
  1054  
  1055      ! Rain area
  1056      xy_RainArea = 0.0_DP
  1057  
  1058      k_loop : do k = kmax, 1, -1
  1059  
  1060  
  1061        ! Freezing/melting and evaporation of precipitation
  1062        !
  1063        do j = 1, jmax
  1064          do i = 0, imax-1
  1065            call CloudUtilsPRCPStepPC1Grid(  &
  1066              & xyr_Press(i,j,k-1), xyr_Press(i,j,k),       & ! (in   )
  1067              & xyz_Temp(i,j,k),                            & ! (inout)
  1068              & xy_Rain(i,j), xy_Snow(i,j)                  & ! (inout)
  1069              & )
  1070          end do
  1071        end do
  1072        do j = 1, jmax
  1073          do i = 0, imax-1
  1074            call CloudUtilsPRCPEvap1Grid(           &
  1075              & xyz_Press(i,j,k), xyr_Press(i,j,k-1), xyr_Press(i,j,k), & ! (in)
  1076              & PRCPArea, PRCPEvapArea,                                 & ! (in)
  1077              & xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k),                    & ! (inout)
  1078              & xy_Rain(i,j), xy_Snow(i,j)                              & ! (inout)
  1079              & )
  1080          end do
  1081        end do
  1082  
  1083  
  1084        xyz_FactC1(:,:,k) = xyz_MoistConvDetTend(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2674 = 1, xyz_factc1.DSC.U2*xyz_factc1.DSC.U1 +               
     .       1   xyz_factc1.DSC.U2                                              
     .           xyz_factc1(t2674-1,1,k) = xyz_moistconvdettend(t2674-1,1,k)    
     .        enddo                                                             
  1085        do j = 1, jmax
  1086          do i = 0, imax-1
  1087            if ( xyz_QH2OVap(i,j,k) < RHThreshold * xyz_QH2OVapSat(i,j,k) ) then
  1088              xyz_FactC2(i,j,k) =                                         &
  1089                & - ( 1.0_DP - xyz_CloudCover(i,j,k) )                    &
  1090                &   / ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )      &
  1091                &   * xyz_DQH2OVapSatDt(i,j,k) * xyz_ZOCloudProd(i,j,k)
  1092            else
  1093  !!$              xyz_FactC2(i,j,k) = 0.0_DP
  1094              xyz_FactC2(i,j,k) = 1.0_DP / ( 2.0_DP * DelTime )
  1095            end if
  1096          end do
  1097        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyz_qh2ovap(j-1,1,k) .lt. 9.99999999899999e-001*           
     .       1      xyz_qh2ovapsat(j-1,1,k)) then                               
     .              xyz_factc216 = -(1.00000000000000e+000 - xyz_cloudcover(j-1,
     .       1         1,k))/(xyz_qh2ovapsat(j-1,1,k)-xyz_qh2ovap(j-1,1,k))*    
     .       2         xyz_dqh2ovapsatdt(j-1,1,k)*xyz_zocloudprod(j-1,1,k)      
     .           else                                                           
     .              xyz_factc216 = 1.00000000000000e+000/(2.00000000000000e+000*
     .       1         deltime)                                                 
     .           endif                                                          
     .           xyz_factc2(j-1,1,k) = xyz_factc216                             
     .        enddo                                                             
  1098        xyz_FactC(:,:,k) = xyz_FactC1(:,:,k) + xyz_FactC2(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2682 = 1, xyz_factc1.DSC.U2*xyz_factc1.DSC.U1 +               
     .       1   xyz_factc1.DSC.U2                                              
     .           xyz_factc(t2682-1,1,k) = xyz_factc1(t2682-1,1,k) + xyz_factc2( 
     .       1      t2682-1,1,k)                                                
     .        enddo                                                             
  1099        do j = 1, jmax
  1100          do i = 0, imax-1
  1101            if ( xyz_QH2OVapSat(i,j,k) > xyz_QH2OVap(i,j,k) ) then
  1102              xyz_FactD(i,j,k) =                                      &
  1103                & 2.0_DP * xyz_CloudCover(i,j,k) * MixCoef            &
  1104                & * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )    &
  1105                & / ( xyz_QCloudWat(i,j,k) + 1.0d-100 )
  1106            else
  1107              xyz_FactD(i,j,k) = 0.0_DP
  1108            end if
  1109          end do
  1110        end do
  1111        !
  1112        do j = 1, jmax
  1113          do i = 0, imax-1
  1114            if ( xyz_QH2OVap(i,j,k) < RHThreshold * xyz_QH2OVapSat(i,j,k) ) then
  1115              xyz_FactE1(i,j,k) =                                             &
  1116                &   ( 1.0_DP - xyz_CloudCover(i,j,k) )**2                     &
  1117                & / ( 2.0_DP                                                  &
  1118                &       * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) ) )    &
  1119                & * xyz_DQH2OVapSatDt(i,j,k) * xyz_ZOCloudProd(i,j,k)
  1120            else
  1121              xyz_FactE1(i,j,k) = 0.0_DP
  1122            end if
  1123          end do
  1124        end do
  1125        do j = 1, jmax
  1126          do i = 0, imax-1
  1127            if ( xyz_QH2OVapSat(i,j,k) > xyz_QH2OVap(i,j,k) ) then
  1128              xyz_FactE2(i,j,k) =                                     &
  1129                & + xyz_CloudCover(i,j,k)**2 * MixCoef                &
  1130                & * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )    &
  1131                & / ( xyz_QCloudWat(i,j,k) + 1.0d-100 )
  1132            else
  1133              xyz_FactE2(i,j,k) = 0.0_DP
  1134            end if
  1135          end do
  1136        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if ((xyz_qh2ovapsat(j-1,1,k).gt.xyz_qh2ovap(j-1,1,k))) then    
     .              xyz_factd17 = 2.00000000000000e+000*xyz_cloudcover(j-1,1,k)*
     .       1         9.99999999999999e-007*(xyz_qh2ovapsat(j-1,1,k)-          
     .       2         xyz_qh2ovap(j-1,1,k))/(xyz_qcloudwat(j-1,1,k)+           
     .       3         1.00000000000000e-100)                                   
     .           else                                                           
     .              xyz_factd17 = 0.0000000000000000e+000                       
     .           endif                                                          
     .           xyz_factd(j-1,1,k) = xyz_factd17                               
     .           if (xyz_qh2ovap(j-1,1,k) .lt. 9.99999999899999e-001*           
     .       1      xyz_qh2ovapsat(j-1,1,k)) then                               
     .              xyz_facte118 = (1.00000000000000e+000 - xyz_cloudcover(j-1,1
     .       1         ,k))**2/(2.00000000000000e+000*(xyz_qh2ovapsat(j-1,1,k)- 
     .       2         xyz_qh2ovap(j-1,1,k)))*xyz_dqh2ovapsatdt(j-1,1,k)*       
     .       3         xyz_zocloudprod(j-1,1,k)                                 
     .           else                                                           
     .              xyz_facte118 = 0.0000000000000000e+000                      
     .           endif                                                          
     .           xyz_facte1(j-1,1,k) = xyz_facte118                             
     .           if ((xyz_qh2ovapsat(j-1,1,k).gt.xyz_qh2ovap(j-1,1,k))) then    
     .              xyz_facte219 = xyz_cloudcover(j-1,1,k)**2*                  
     .       1         9.99999999999999e-007*(xyz_qh2ovapsat(j-1,1,k)-          
     .       2         xyz_qh2ovap(j-1,1,k))/(xyz_qcloudwat(j-1,1,k)+           
     .       3         1.00000000000000e-100)                                   
     .           else                                                           
     .              xyz_facte219 = 0.0000000000000000e+000                      
     .           endif                                                          
     .           xyz_facte2(j-1,1,k) = xyz_facte219                             
     .        enddo                                                             
  1137        xyz_FactE(:,:,k) = xyz_FactE1(:,:,k) + xyz_FactE2(:,:,k)
     .        d21 = 1.D0/2.00000000000000e+000                                  
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2692 = 1, xyz_facte1.DSC.U2*xyz_facte1.DSC.U1 +               
     .       1   xyz_facte1.DSC.U2                                              
     .           xyz_facte(t2692-1,1,k) = xyz_facte1(t2692-1,1,k) + xyz_facte2( 
     .       1      t2692-1,1,k)                                                
     .           xyz_delcloudcoverstr1 = (2.00000000000000e+000*deltime)*       
     .       1      xyz_factc2(t2692-1,1,k) - xyz_factc2(t2692-1,1,k)/((        
     .       2      xyz_factc(t2692-1,1,k)+xyz_factd(t2692-1,1,k))+             
     .       3      1.00000000000000e-100)*((2.00000000000000e+000*deltime)*    
     .       4      xyz_factc(t2692-1,1,k)+(xyz_cloudcover(t2692-1,1,k)-        
     .       5      xyz_factc(t2692-1,1,k)/((xyz_factc(t2692-1,1,k)+xyz_factd(  
     .       6      t2692-1,1,k))+1.00000000000000e-100))*(1.00000000000000e+000
     .       7      -dexp((-(xyz_factc(t2692-1,1,k)+xyz_factd(t2692-1,1,k))*    
     .       8      2.00000000000000e+000*deltime)))) + (2.00000000000000e+000* 
     .       9      deltime)*xyz_facte1(t2692-1,1,k)                            
     .           xyz_factal1(t2692-1,1,k) = xyz_dqcloudwatdtcum(t2692-1,1,k)    
     .           xyz_factas1(t2692-1,1,k) = xyz_dqcloudicedtcum(t2692-1,1,k)    
     .           xyz_facta20(t2692-1,1,k) = (-(xyz_cloudcover(t2692-1,1,k)*     
     .       1      xyz_dqh2ovapsatdt(t2692-1,1,k))*xyz_zocloudprod(t2692-1,1,k)
     .       2      ) - xyz_delcloudcoverstr1*xyz_dqh2ovapsatdt(t2692-1,1,k)*   
     .       3      xyz_zocloudprod(t2692-1,1,k)*d21 - (xyz_cloudcover(t2692-1,1
     .       4      ,k)*xyz_dqh2ovapsatdt(t2692-1,1,k))*(1.00000000000000e+000  
     .       5       - xyz_zocloudloss(t2692-1,1,k)) - xyz_cloudcover(t2692-1,1,
     .       6      k)*9.99999999999999e-007*(xyz_qh2ovapsat(t2692-1,1,k)-      
     .       7      xyz_qh2ovap(t2692-1,1,k))                                   
     .        enddo                                                             
  1138        !
  1139        xyz_DelCloudCoverStr(:,:,k) =                                         &
  1140          &   xyz_FactC2(:,:,k) * 2.0_DP * DelTime                            &
  1141          & - xyz_FactC2(:,:,k)                                               &
  1142          &  / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 )             &
  1143          &   * (                                                             &
  1144          &         xyz_FactC(:,:,k) * 2.0_DP * DelTime                       &
  1145          &       + ( xyz_CloudCover(:,:,k)                                   &
  1146          &             - xyz_FactC(:,:,k)                                    &
  1147          &             / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 ) )&
  1148          &         * ( 1.0_DP                                                &
  1149          &               - exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) )    &
  1150          &                   * 2.0_DP * DelTime ) )                          &
  1151          &     )                                                             &
  1152          & + xyz_FactE1(:,:,k) * 2.0_DP * DelTime
  1153        !
  1154        !
  1155        !
  1156        !
  1157        xyz_FactAl1(:,:,k) = xyz_DQCloudWatDtCum(:,:,k)
  1158        xyz_FactAs1(:,:,k) = xyz_DQCloudIceDtCum(:,:,k)
  1159        !
  1160        !
  1161        !
  1162        xyz_FactA20(:,:,k) =                                                  &
  1163          & - xyz_CloudCover(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)                &
  1164          &     * xyz_ZOCloudProd(:,:,k)                                      &
  1165          & - xyz_DelCloudCoverStr(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)          &
  1166          &     * xyz_ZOCloudProd(:,:,k)                                      &
  1167          &     / 2.0_DP                                                      &
  1168          & - xyz_CloudCover(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)                &
  1169          &     * ( 1.0_DP - xyz_ZOCloudLoss(:,:,k) )                         &
  1170          & - xyz_CloudCover(:,:,k) * MixCoef                                 &
  1171          &     * ( xyz_QH2OVapSat(:,:,k) - xyz_QH2OVap(:,:,k) )
  1172        !
  1173        !    The value of xyz_FactA2 is checked, and is updated.
  1174        do j = 1, jmax
  1175          do i = 0, imax-1
  1176            if ( xyz_FactA20(i,j,k) * 2.0_DP * DelTime > xyz_QH2OVap(i,j,k) ) then
  1177              xyz_FactA20(i,j,k) = &
  1178                &   xyz_QH2OVap(i,j,k) / ( 2.0_DP * DelTime ) &
  1179                & * ( 1.0_DP - 1.0e-14_DP )
  1180            end if
  1181          end do
  1182        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if ((2.00000000000000e+000*deltime)*xyz_facta20(j-1,1,k) .gt.  
     .       1      xyz_qh2ovap(j-1,1,k)) then                                  
     .              xyz_facta20(j-1,1,k) = xyz_qh2ovap(j-1,1,k)/(               
     .       1         2.00000000000000e+000*deltime)*9.99999999999990e-001     
     .           endif                                                          
     .        enddo                                                             
  1183        xyz_FactAl2(:,:,k) = xyz_WatFrac(:,:,k) * xyz_FactA20(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2762 = 1, xyz_watfrac.DSC.U2*xyz_watfrac.DSC.U1 +             
     .       1   xyz_watfrac.DSC.U2                                             
     .           xyz_factal2(t2762-1,1,k) = xyz_watfrac(t2762-1,1,k)*xyz_facta20
     .       1      (t2762-1,1,k)                                               
     .           xyz_factas2(t2762-1,1,k) = xyz_icefrac(t2762-1,1,k)*xyz_facta20
     .       1      (t2762-1,1,k)                                               
     .           xyz_factal(t2762-1,1,k) = xyz_factal1(t2762-1,1,k) +           
     .       1      xyz_factal2(t2762-1,1,k)                                    
     .           xyz_factas(t2762-1,1,k) = xyz_factas1(t2762-1,1,k) +           
     .       1      xyz_factas2(t2762-1,1,k)                                    
     .        enddo                                                             
  1184        xyz_FactAs2(:,:,k) = xyz_IceFrac(:,:,k) * xyz_FactA20(:,:,k)
  1185  
  1186  
  1187        xyz_FactAl(:,:,k) = xyz_FactAl1(:,:,k) + xyz_FactAl2(:,:,k)
  1188        xyz_FactAs(:,:,k) = xyz_FactAs1(:,:,k) + xyz_FactAs2(:,:,k)
  1189  
  1190  
  1191        RainConvFactor0 = 1.0_DP / ( CloudWatLifeTime0 + 1.0d-100 )
  1192        ! Factor for collection
  1193        xy_FactCo = 1.0_DP + PRCPColFactor * sqrt( xy_Rain + xy_Snow )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2790 = 1, xy_rain.DSC.U2*xy_rain.DSC.U1 + xy_rain.DSC.U2      
     .           xy_factco1 = 1.00000000000000e+000 + prcpcolfactor*dsqrt(      
     .       1      xy_rain(t2790-1,1)+xy_snow(t2790-1,1))                      
     .           xy_factbf1 = 1.00000000000000e+000                             
     .           xy_qcloudwatconvthreshold1 = (qcloudwateffconv0 +              
     .       1      1.00000000000000e-100)/(xy_factco1*xy_factbf1)              
     .           xy_factconvthreshold(t2790-1,1) = 1.00000000000000e+000 - dexp(
     .       1      (-(xyz_qcloudwat(t2790-1,1,k)/((xyz_cloudcover(t2790-1,1,k)+
     .       2      1.00000000000000e-010)*xy_qcloudwatconvthreshold1))**2))    
     .           xy_rainconvfactor(t2790-1,1) = (xy_factco1*xy_factbf1)*        
     .       1      rainconvfactor0*xy_factconvthreshold(t2790-1,1)             
     .        enddo                                                             
  1194        ! Factor for Bergeron-Findeisen effect
  1195        !   Sundqvist et al. (1989)
  1196  !!$      xy_FactBF = 1.0_DP &
  1197  !!$        & + C2 * sqrt( max( 268.0_DP - xyz_Temp(:,:,k), 0.0_DP ) )
  1198        !   An original equation following that by IFS CY38r1
  1199        !   (p.82 of http://www.ecmwf.int/research/ifsdocs/CY38r1/IFSPart4.pdf)
  1200  !!$      xy_FactBF = 1.0_DP                                               &
  1201  !!$        & + C2 * sqrt( min(                                            &
  1202  !!$        &                   max( 268.0_DP - xyz_Temp(:,:,k), 0.0_DP ), &
  1203  !!$        &                   max( 268.0_DP - TempBFEffectSat, 0.0_DP )  &
  1204  !!$        &                  )                                           &
  1205  !!$        &            )
  1206        !   Constant (no effect)
  1207        xy_FactBF = 1.0_DP
  1208        !
  1209  !!$      xy_QCloudWatConvThreshold = &
  1210  !!$        & QCloudWatEffConv0 / ( xy_FactCo * xy_FactBF )
  1211        xy_QCloudWatConvThreshold = &
  1212          & ( QCloudWatEffConv0 + 1.0e-100_DP ) / ( xy_FactCo * xy_FactBF )
  1213  !!$      xy_QCloudWatConvThreshold = &
  1214  !!$        & QCloudWatEffConv0 / xy_FactCo
  1215        xy_FactConvThreshold = &
  1216          &   1.0_DP                                                   &
  1217          & - exp( &
  1218          &        - ( xyz_QCloudWat(:,:,k)                          &
  1219          &            / ( xyz_CloudCover(:,:,k) + 1.0e-10_DP )      &
  1220          &            / xy_QCloudWatConvThreshold              )**2 &
  1221          &      )
  1222        !
  1223  !!$      xy_RainConvFactor = RainConvFactor0 * xy_FactCo * xy_FactBF
  1224        xy_RainConvFactor = RainConvFactor0 * xy_FactCo * xy_FactBF &
  1225          & * xy_FactConvThreshold
  1226  
  1227  
  1228        SnowConvFactor0 = 1.0_DP / ( CloudIceLifeTime0 + 1.0d-100 )
  1229        xy_FactIceTempDep = exp( 0.025_DP * ( xyz_Temp(:,:,k) - 273.15_DP ) )
     .  !cdir nodep                                                             
     .        do t2826 = 1, xyz_temp.DSC.U1 + 1                                 
     .           xy_facticetempdep1 = dexp(2.50000000000000e-002*(xyz_temp(t2826
     .       1      -1,t2824+1,k)-2.73149999999999e+002))                       
     .           xy_qcloudiceconvthreshold1 = qcloudiceeffconv0 +               
     .       1      1.00000000000000e-100                                       
     .           xy_factconvthreshold(t2826-1,t2824+1) = 1.00000000000000e+000  
     .       1       - dexp((-(xyz_qcloudice(t2826-1,t2824+1,k)/((xyz_cloudcover
     .       2      (t2826-1,t2824+1,k)+1.00000000000000e-010)*                 
     .       3      xy_qcloudiceconvthreshold1))**2))                           
     .           xy_snowconvfactor1 = snowconvfactor0*xy_facticetempdep1*       
     .       1      xy_factconvthreshold(t2826-1,t2824+1)                       
     .           xyz_factbl(t2826-1,t2824+1,k) = xy_rainconvfactor(t2826-1,t2824
     .       1      +1)                                                         
     .           xyz_factbs(t2826-1,t2824+1,k) = xy_snowconvfactor1             
     .        enddo                                                             
  1230  !!$      xy_QCloudIceConvThreshold = QCloudIceEffConv0
  1231        xy_QCloudIceConvThreshold = QCloudIceEffConv0 + 1.0e-100_DP
  1232        xy_FactConvThreshold = &
  1233          &   1.0_DP                                                   &
  1234          & - exp( &
  1235          &        - ( xyz_QCloudIce(:,:,k)                          &
  1236          &            / ( xyz_CloudCover(:,:,k) + 1.0e-10_DP )      &
  1237          &            / xy_QCloudIceConvThreshold              )**2 &
  1238          &      )
  1239  !!$      xy_SnowConvFactor = SnowConvFactor0 * xy_FactIceTempDep
  1240        xy_SnowConvFactor = SnowConvFactor0 * xy_FactIceTempDep &
  1241          & * xy_FactConvThreshold
  1242  
  1243        !
  1244        !
  1245        !
  1246  !!$      xyz_FactBl(:,:,k) = 1.0_DP / ( CloudWatLifeTime0 + 1.0d-100 )
  1247        xyz_FactBl(:,:,k) = xy_RainConvFactor
  1248        !
  1249  !!$      xyz_FactBs(:,:,k) = 1.0_DP / ( CloudIceLifeTime0 + 1.0d-100 )
  1250        xyz_FactBs(:,:,k) = xy_SnowConvFactor
  1251        !
  1252        !
  1253        !
  1254  
  1255  
  1256        ! Values at next time step are calculated.
  1257        !
  1258        do j = 1, jmax
  1259          do i = 0, imax-1
  1260            if ( xyz_FactBl(i,j,k) >= FactBlsThreshold ) then
  1261              xyz_QCloudWat(i,j,k) =                                            &
  1262                &   xyz_QCloudWat(i,j,k)                                        &
  1263                &     * exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime )           &
  1264                & + xyz_FactAl(i,j,k) / xyz_FactBl(i,j,k)                       &
  1265                &     * ( 1.0_DP - exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime ) )
  1266            else
  1267              xyz_QCloudWat(i,j,k) =                                            &
  1268                &   xyz_QCloudWat(i,j,k)                                        &
  1269                & + xyz_FactAl(i,j,k) * ( 2.0_DP * DelTime )
  1270            end if
  1271          end do
  1272        end do
  1273        !   The value of cloud water amount is checked, and xyz_FactA is updated.
  1274        do j = 1, jmax
  1275          do i = 0, imax-1
  1276            if ( xyz_QCloudWat(i,j,k) < 0.0_DP ) then
  1277              if ( xyz_FactBl(i,j,k) >= FactBlsThreshold ) then
  1278                xyz_FactAl2(i,j,k) = - xyz_FactAl1(i,j,k)                       &
  1279                  & - xyz_FactBl(i,j,k) * xyz_QCloudWatB(i,j,k)                 &
  1280                  & * exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime )             &
  1281                  & / ( 1.0_DP - exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime ) )
  1282              else
  1283  !!$              xyz_FactAl2(i,j,k) = - xyz_FactAl1(i,j,k)
  1284                xyz_FactAl2(i,j,k) = &
  1285                  & - (   xyz_QCloudWatB(i,j,k)                       &
  1286                  &     + xyz_FactAl1(i,j,k) * ( 2.0_DP * DelTime ) ) &
  1287                  &   / ( 2.0_DP * DelTime )
  1288  
  1289  !!$              call MessageNotify( 'E', module_name, 'Unexpected negative QCloudWat.' )
  1290              end if
  1291              xyz_QCloudWat(i,j,k) = 0.0_DP
  1292            end if
  1293          end do
  1294        end do
  1295        !
  1296        do j = 1, jmax
  1297          do i = 0, imax-1
  1298            if ( xyz_FactBs(i,j,k) >= FactBlsThreshold ) then
  1299              xyz_QCloudIce(i,j,k) =                                            &
  1300                &   xyz_QCloudIce(i,j,k)                                        &
  1301                &     * exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime )           &
  1302                & + xyz_FactAs(i,j,k) / xyz_FactBs(i,j,k)                       &
  1303                &     * ( 1.0_DP - exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime ) )
  1304            else
  1305              xyz_QCloudIce(i,j,k) =                                            &
  1306                &   xyz_QCloudIce(i,j,k)                                        &
  1307                & + xyz_FactAs(i,j,k) * ( 2.0_DP * DelTime )
  1308            end if
  1309          end do
  1310        end do
  1311        !   The value of cloud water amount is checked, and xyz_FactA is updated.
  1312        do j = 1, jmax
  1313          do i = 0, imax-1
  1314            if ( xyz_QCloudIce(i,j,k) < 0.0_DP ) then
  1315              if ( xyz_FactBs(i,j,k) >= FactBlsThreshold ) then
  1316                xyz_FactAs2(i,j,k) = - xyz_FactAs1(i,j,k)                       &
  1317                  & - xyz_FactBs(i,j,k) * xyz_QCloudIceB(i,j,k)                 &
  1318                  & * exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime )             &
  1319                  & / ( 1.0_DP - exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime ) )
  1320              else
  1321  !!$              xyz_FactAs2(i,j,k) = - xyz_FactAs1(i,j,k)
  1322                xyz_FactAs2(i,j,k) =                                  &
  1323                  & - (   xyz_QCloudIceB(i,j,k)                       &
  1324                  &     + xyz_FactAs1(i,j,k) * ( 2.0_DP * DelTime ) ) &
  1325                  &   / ( 2.0_DP * DelTime )
  1326  
  1327  !!$              call MessageNotify( 'E', module_name, 'Unexpected negative QCloudIce.' )
  1328              end if
  1329              xyz_QCloudIce(i,j,k) = 0.0_DP
  1330            end if
  1331          end do
  1332        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if ((xyz_factbl(j-1,1,k).ge.factblsthreshold)) then            
     .              xyz_qcloudwat28 = xyz_qcloudwat(j-1,1,k)*(dexp((-((         
     .       1         xyz_factbl(j-1,1,k)*2.00000000000000e+000)*deltime)))) + 
     .       2         xyz_factal(j-1,1,k)/xyz_factbl(j-1,1,k)*(                
     .       3         1.00000000000000e+000 - (dexp((-((xyz_factbl(j-1,1,k)*   
     .       4         2.00000000000000e+000)*deltime)))))                      
     .           else                                                           
     .              xyz_qcloudwat28 = xyz_qcloudwat(j-1,1,k) + xyz_factal(j-1,1,
     .       1         k)*2.00000000000000e+000*deltime                         
     .           endif                                                          
     .           xyz_qcloudwat(j-1,1,k) = xyz_qcloudwat28                       
     .           if (xyz_qcloudwat(j-1,1,k) .lt. 0.0000000000000000e+000) then  
     .              if ((xyz_factbl(j-1,1,k).ge.factblsthreshold)) then         
     .                 xyz_factal2(j-1,1,k) = (-xyz_factal1(j-1,1,k)) -         
     .       1            xyz_factbl(j-1,1,k)*xyz_qcloudwatb(j-1,1,k)*(dexp((-((
     .       2            xyz_factbl(j-1,1,k)*2.00000000000000e+000)*deltime))))
     .       3            /(1.00000000000000e+000 - (dexp((-((xyz_factbl(j-1,1,k
     .       4            )*2.00000000000000e+000)*deltime)))))                 
     .              else                                                        
     .                 xyz_factal2(j-1,1,k) = -(xyz_qcloudwatb(j-1,1,k)+        
     .       1            xyz_factal1(j-1,1,k)*(2.00000000000000e+000*deltime))/
     .       2            (2.00000000000000e+000*deltime)                       
     .              endif                                                       
     .              xyz_qcloudwat(j-1,1,k) = 0.0000000000000000e+000            
     .           endif                                                          
     .           if ((xyz_factbs(j-1,1,k).ge.factblsthreshold)) then            
     .              xyz_qcloudice29 = xyz_qcloudice(j-1,1,k)*(dexp((-((         
     .       1         xyz_factbs(j-1,1,k)*2.00000000000000e+000)*deltime)))) + 
     .       2         xyz_factas(j-1,1,k)/xyz_factbs(j-1,1,k)*(                
     .       3         1.00000000000000e+000 - (dexp((-((xyz_factbs(j-1,1,k)*   
     .       4         2.00000000000000e+000)*deltime)))))                      
     .           else                                                           
     .              xyz_qcloudice29 = xyz_qcloudice(j-1,1,k) + xyz_factas(j-1,1,
     .       1         k)*2.00000000000000e+000*deltime                         
     .           endif                                                          
     .           xyz_qcloudice(j-1,1,k) = xyz_qcloudice29                       
     .           if (xyz_qcloudice(j-1,1,k) .lt. 0.0000000000000000e+000) then  
     .              if ((xyz_factbs(j-1,1,k).ge.factblsthreshold)) then         
     .                 xyz_factas2(j-1,1,k) = (-xyz_factas1(j-1,1,k)) -         
     .       1            xyz_factbs(j-1,1,k)*xyz_qcloudiceb(j-1,1,k)*(dexp((-((
     .       2            xyz_factbs(j-1,1,k)*2.00000000000000e+000)*deltime))))
     .       3            /(1.00000000000000e+000 - (dexp((-((xyz_factbs(j-1,1,k
     .       4            )*2.00000000000000e+000)*deltime)))))                 
     .              else                                                        
     .                 xyz_factas2(j-1,1,k) = -(xyz_qcloudiceb(j-1,1,k)+        
     .       1            xyz_factas1(j-1,1,k)*(2.00000000000000e+000*deltime))/
     .       2            (2.00000000000000e+000*deltime)                       
     .              endif                                                       
     .              xyz_qcloudice(j-1,1,k) = 0.0000000000000000e+000            
     .           endif                                                          
     .        enddo                                                             
  1333  
  1334  
  1335        ! Al and As are updated because Al2 and As2 were updated above
  1336        xyz_FactAl(:,:,k) = xyz_FactAl1(:,:,k) + xyz_FactAl2(:,:,k)
     .        d30 = deltime/cpdry                                               
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2856 = 1, xyz_factal1.DSC.U2*xyz_factal1.DSC.U1 +             
     .       1   xyz_factal1.DSC.U2                                             
     .           xyz_factal(t2856-1,1,k) = xyz_factal1(t2856-1,1,k) +           
     .       1      xyz_factal2(t2856-1,1,k)                                    
     .           xyz_factas(t2856-1,1,k) = xyz_factas1(t2856-1,1,k) +           
     .       1      xyz_factas2(t2856-1,1,k)                                    
     .           xyz_cloudcover(t2856-1,1,k) = xyz_cloudcover(t2856-1,1,k)*(dexp
     .       1      ((-(((xyz_factc(t2856-1,1,k)+xyz_factd(t2856-1,1,k))*       
     .       2      2.00000000000000e+000)*deltime)))) + (xyz_factc(t2856-1,1,k)
     .       3      +xyz_facte(t2856-1,1,k))/((xyz_factc(t2856-1,1,k)+xyz_factd(
     .       4      t2856-1,1,k))+1.00000000000000e-100)*(1.00000000000000e+000 
     .       5       - (dexp((-(((xyz_factc(t2856-1,1,k)+xyz_factd(t2856-1,1,k))
     .       6      *2.00000000000000e+000)*deltime)))))                        
     .           xyz_qh2ovap(t2856-1,1,k) = xyz_qh2ovap(t2856-1,1,k) - (        
     .       1      xyz_factal2(t2856-1,1,k)+xyz_factas2(t2856-1,1,k))*         
     .       2      2.00000000000000e+000*deltime                               
     .           xyz_temp(t2856-1,1,k) = xyz_temp(t2856-1,1,k) + (xyz_factal2(  
     .       1      t2856-1,1,k)*latentheat+xyz_factas2(t2856-1,1,k)*           
     .       2      latentheatsubl)*2.00000000000000e+000*d30                   
     .        enddo                                                             
  1337        xyz_FactAs(:,:,k) = xyz_FactAs1(:,:,k) + xyz_FactAs2(:,:,k)
  1338  
  1339  
  1340  
  1341        xyz_CloudCover(:,:,k) =                                            &
  1342          &   xyz_CloudCover(:,:,k)                                        &
  1343          &    * exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) )            &
  1344          &               * 2.0_DP * DelTime )                             &
  1345          & + ( xyz_FactC(:,:,k) + xyz_FactE(:,:,k) )                      &
  1346          &    / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 )        &
  1347          &    * ( 1.0_DP - exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) ) &
  1348          &                          * 2.0_DP * DelTime ) )
  1349  
  1350  
  1351  !!$      xyz_QH2OVap(:,:,k) = xyz_QH2OVap(:,:,k) &
  1352  !!$        & - xyz_FactA2(:,:,k) * 2.0_DP * DelTime
  1353        xyz_QH2OVap(:,:,k) = xyz_QH2OVap(:,:,k) &
  1354          & - ( xyz_FactAl2(:,:,k) + xyz_FactAs2(:,:,k) ) * 2.0_DP * DelTime
  1355        !
  1356  !!$      xyz_Temp(:,:,k) = xyz_Temp(:,:,k) &
  1357  !!$        & + xyz_FactA2(:,:,k) * 2.0_DP * DelTime * LatentHeat / CpDry
  1358        xyz_Temp(:,:,k) = xyz_Temp(:,:,k)               &
  1359          & + (   xyz_FactAl2(:,:,k) * LatentHeat       &
  1360          &     + xyz_FactAs2(:,:,k) * LatentHeatSubl ) &
  1361          & * 2.0_DP * DelTime / CpDry
  1362  
  1363  
  1364        ! Rain
  1365        !
  1366        do j = 1, jmax
  1367          do i = 0, imax-1
  1368  !!$          if ( xyz_FactBl(i,j,k) >= FactBlsThreshold ) then
  1369  !!$            xyz_Rain(i,j,k) =                                                 &
  1370  !!$              &   xyz_FactAl(i,j,k) * 2.0_DP * DelTime                        &
  1371  !!$              & + xyz_QCloudWatB(i,j,k)                                       &
  1372  !!$              &    * ( 1.0_DP - exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime ) )  &
  1373  !!$              & - xyz_FactAl(i,j,k) / xyz_FactBl(i,j,k)                       &
  1374  !!$              &    * ( 1.0_DP - exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime ) )
  1375  !!$            xyz_Rain(i,j,k) = xyz_Rain(i,j,k) / ( 2.0_DP * DelTime )
  1376  !!$          else
  1377  !!$            xyz_Rain(i,j,k) = 0.0_DP
  1378  !!$          end if
  1379            xyz_Rain(i,j,k) =                                                 &
  1380              &   xyz_QCloudWatB(i,j,k)                                       &
  1381              & + xyz_FactAl(i,j,k) * 2.0_DP * DelTime                        &
  1382              & - xyz_QCloudWat (i,j,k)
  1383            xyz_Rain(i,j,k) = xyz_Rain(i,j,k) / ( 2.0_DP * DelTime )
  1384          end do
  1385        end do
  1386  
  1387        ! Snow
  1388        !
  1389        do j = 1, jmax
  1390          do i = 0, imax-1
  1391  !!$          if ( xyz_FactBs(i,j,k) >= FactBlsThreshold ) then
  1392  !!$            xyz_Snow(i,j,k) =                                               &
  1393  !!$              &   xyz_FactAs(i,j,k) * 2.0_DP * DelTime                      &
  1394  !!$              & + xyz_QCloudIceB  (i,j,k)                                   &
  1395  !!$              &    * ( 1.0_DP - exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime ) )  &
  1396  !!$              & - xyz_FactAs(i,j,k) / xyz_FactBs(i,j,k)                     &
  1397  !!$              &    * ( 1.0_DP - exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime ) )
  1398  !!$            xyz_Snow(i,j,k) = xyz_Snow(i,j,k) / ( 2.0_DP * DelTime )
  1399  !!$          else
  1400  !!$            xyz_Snow(i,j,k) = 0.0_DP
  1401  !!$          end if
  1402            xyz_Snow(i,j,k) =                                               &
  1403              &   xyz_QCloudIceB  (i,j,k)                                   &
  1404              & + xyz_FactAs(i,j,k) * 2.0_DP * DelTime                      &
  1405              & - xyz_QCloudIce   (i,j,k)
  1406            xyz_Snow(i,j,k) = xyz_Snow(i,j,k) / ( 2.0_DP * DelTime )
  1407          end do
  1408        end do
     .        d33 = 1.D0/(2.00000000000000e+000*deltime)                        
     .        d34 = 1.D0/(2.00000000000000e+000*deltime)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyz_rain1 = xyz_qcloudwatb(j-1,1,k) + (2.00000000000000e+000*  
     .       1      deltime)*xyz_factal(j-1,1,k) - xyz_qcloudwat(j-1,1,k)       
     .           xyz_rain(j-1,1,k) = xyz_rain1*d33                              
     .           xyz_snow1 = xyz_qcloudiceb(j-1,1,k) + (2.00000000000000e+000*  
     .       1      deltime)*xyz_factas(j-1,1,k) - xyz_qcloudice(j-1,1,k)       
     .           xyz_snow(j-1,1,k) = xyz_snow1*d34                              
     .        enddo                                                             
  1409  
  1410        ! Rain at the surface
  1411        xy_Rain = xy_Rain + xyz_Rain(:,:,k) * xyz_DelMass(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2908 = 1, xy_rain.DSC.U2*xy_rain.DSC.U1 + xy_rain.DSC.U2      
     .           xy_rain(t2908-1,1) = xy_rain(t2908-1,1) + xyz_rain(t2908-1,1,k)
     .       1      *xyz_delmass(t2908-1,1,k)                                   
     .           xy_snow(t2908-1,1) = xy_snow(t2908-1,1) + xyz_snow(t2908-1,1,k)
     .       1      *xyz_delmass(t2908-1,1,k)                                   
     .        enddo                                                             
  1412        ! Snow at the surface
  1413        xy_Snow = xy_Snow + xyz_Snow(:,:,k) * xyz_DelMass(:,:,k)
  1414  
  1415  
  1416        ! Treatment of supersaturation
  1417        do j = 1, jmax
  1418          do i = 0, imax-1
  1419            QCloudWatTentative = xyz_QCloudWat(i,j,k)
  1420            QCloudIceTentative = xyz_QCloudIce(i,j,k)
  1421            call LScaleCond1Grid(  &
  1422              & xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), &  ! (inout)
  1423  !!$            & xyz_QCloudWat(i,j,k), xyz_QCloudIce(i,j,k),           & ! (inout)
  1424              & QCloudWatTentative, QCloudIceTentative,               & ! (inout)
  1425              & xyz_Press(i,j,k), xyr_Press(i,j,k-1), xyr_Press(i,j,k), & ! (in)
  1426              & xyz_DQH2OLiqDtLSC(i,j,k), xyz_DQH2OSolDtLSC(i,j,k)      & ! (out)
  1427              & )
  1428  
  1429  !!$          xy_Rain(i,j) = xy_Rain(i,j) &
  1430  !!$            & + ( xyz_QCloudWat(i,j,k) - QCloudWatTentative ) &
  1431  !!$            &     / ( 2.0_DP * DelTime ) &
  1432  !!$            &     * ( 2.0_DP * DelTime ) &
  1433  !!$            &     * xyz_DelMass(i,j,k)
  1434  !!$          xy_Snow(i,j) = xy_Snow(i,j) &
  1435  !!$            & + ( xyz_QCloudIce(i,j,k) - QCloudIceTentative ) &
  1436  !!$            &     / ( 2.0_DP * DelTime ) &
  1437  !!$            &     * ( 2.0_DP * DelTime ) &
  1438  !!$            &     * xyz_DelMass(i,j,k)
  1439  !!$          xyz_QCloudWat(i,j,k) = xyz_QCloudWat(i,j,k) &
  1440  !!$            & - ( xyz_QCloudWat(i,j,k) - QCloudWatTentative ) &
  1441  !!$            &     / ( 2.0_DP * DelTime ) &
  1442  !!$            &     * ( 2.0_DP * DelTime )
  1443  !!$          xyz_QCloudIce(i,j,k) = xyz_QCloudIce(i,j,k) &
  1444  !!$            & - ( xyz_QCloudIce(i,j,k) - QCloudIceTentative ) &
  1445  !!$            &     / ( 2.0_DP * DelTime ) &
  1446  !!$            &     * ( 2.0_DP * DelTime )
  1447          end do
  1448        end do
  1449  
  1450        xy_Rain = xy_Rain + xyz_DQH2OLiqDtLSC(:,:,k) * xyz_DelMass(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2928 = 1, xy_rain.DSC.U2*xy_rain.DSC.U1 + xy_rain.DSC.U2      
     .           xy_rain(t2928-1,1) = xy_rain(t2928-1,1) + xyz_dqh2oliqdtlsc(   
     .       1      t2928-1,1,k)*xyz_delmass(t2928-1,1,k)                       
     .           xy_snow(t2928-1,1) = xy_snow(t2928-1,1) + xyz_dqh2osoldtlsc(   
     .       1      t2928-1,1,k)*xyz_delmass(t2928-1,1,k)                       
     .        enddo                                                             
  1451        xy_Snow = xy_Snow + xyz_DQH2OSolDtLSC(:,:,k) * xyz_DelMass(:,:,k)
  1452  
  1453  
  1454        ! Evaporation
  1455        !
  1456        do j = 1, jmax
  1457          do i = 0, imax-1
  1458            if ( ( xyz_QCloudWat(i,j,k) < QCloudWaterEvapThreshold ) .and. &
  1459                 ( xyz_QCloudIce(i,j,k) < QCloudWaterEvapThreshold ) ) then
  1460              xyz_CloudCover(i,j,k) = 0.0_DP
  1461            end if
  1462          end do
  1463        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyz_qcloudwat(j-1,1,k).lt.1.00000000000000e-010 .and.      
     .       1      xyz_qcloudice(j-1,1,k).lt.1.00000000000000e-010) then       
     .              xyz_cloudcover(j-1,1,k) = 0.0000000000000000e+000           
     .           endif                                                          
     .        enddo                                                             
  1464  
  1465        ! Cloud cover is restricted.
  1466        xyz_CloudCover(:,:,k) = min( max( xyz_CloudCover(:,:,k), 0.0_DP ), 1.0_DP )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2948 = 1, jmax*imax                                           
     .           xyz_cloudcover(t2948-1,1,k) = min(max(xyz_cloudcover(t2948-1,1,
     .       1      k),0.0000000000000000e+000),1.00000000000000e+000)          
     .        enddo                                                             
  1467  
  1468        ! Check values
  1469        do j = 1, jmax
  1470          do i = 0, imax-1
  1471            if ( xyz_QH2OVap(i,j,k) < 0.0_DP ) then
  1472              write( 6, * ) 'QH2OVap is negative', &
  1473                & i, j, k, xyz_QH2OVap(i,j,k)
  1474            end if
  1475            if ( xyz_QCloudWat(i,j,k) < 0.0_DP ) then
  1476              write( 6, * ) 'QCloudWat is negative', &
  1477                & i, j, k, xyz_QCloudWat(i,j,k)
  1478            end if
  1479            if ( xyz_QCloudIce  (i,j,k) < 0.0_DP ) then
  1480              write( 6, * ) 'QCloudIce is negative', &
  1481                & i, j, k, xyz_QCloudIce  (i,j,k)
  1482            end if
  1483          end do
  1484        end do
  1485  
  1486      end do k_loop
  1487  
  1488  
  1489      ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
  1490      ! Large scale condensation (non-convective condensation)
  1491      ! (Manabe, 1965)
  1492      !
  1493      ! It should be noted that H2OLiq and H2OSol have updated in above
  1494      ! subroutine.
  1495      !
  1496      ! This routine is commented out, since this is done in an above k_loop.
  1497  
  1498  !!$    call LScaleCond1D3DWrapper(                            &
  1499  !!$      & xyz_Temp, xyz_QH2OVap,          & ! (inout)
  1500  !!$      & xyz_QCloudWat, & ! (inout)
  1501  !!$      & xyz_QCloudIce, & ! (inout)
  1502  !!$      & xyz_Press, xyr_Press,                              & ! (in)
  1503  !!$      & xyz_DQH2OLiqDtLSC, xyz_DQH2OSolDtLSC               & ! (out)
  1504  !!$      & )
  1505  
  1506  
  1507      xy_SurfRainFlux = xy_Rain
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t2956 = 1, jmax*imax                                           
     .           xy_surfrainflux(t2956-1,1) = xy_rain(t2956-1,1)                
     .           xy_surfsnowflux(t2956-1,1) = xy_snow(t2956-1,1)                
     .        enddo                                                             
  1508      xy_SurfSnowFlux = xy_Snow
  1509  
  1510  
  1511      call CloudUtilConsChk(                                       &
  1512        & "CloudT1993baseWithIce",                                 &
  1513  !!$      & FlagIncludeIcePhaseChange,                               &
  1514  !!$      & .true.,                                                  &
  1515        & xyr_Press,                                               &
  1516        & xyz_TempB, xyz_QH2OVapB, xyz_QCloudWatB, xyz_QCloudIceB, &
  1517        & xyz_Temp , xyz_QH2OVap , xyz_QCloudWat , xyz_QCloudIce , &
  1518        & xy_SurfRainFlux, xy_SurfSnowFlux                         &
  1519        & )
  1520  
  1521  
  1522    end subroutine CloudT1993baseWithIce
  1523  
  1524    !--------------------------------------------------------------------------------------
  1525  
  1526    subroutine CloudT1993baseInit( &
  1527      & ArgFlagSnow                &
  1528      & )
  1529  
  1530      ! ファイル入出力補助
  1531      ! File I/O support
  1532      !
  1533      use dc_iounit, only: FileOpen
  1534  
  1535      ! NAMELIST ファイル入力に関するユーティリティ
  1536      ! Utilities for NAMELIST file input
  1537      !
  1538      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1539  
  1540      ! ヒストリデータ出力
  1541      ! History data output
  1542      !
  1543      use gtool_historyauto, only: HistoryAutoAddVariable
  1544  
  1545      ! 飽和比湿の算出
  1546      ! Evaluate saturation specific humidity
  1547      !
  1548      use saturate, only: SaturateInit
  1549  
  1550      ! 大規模凝結 (非対流性凝結)
  1551      ! Large scale condensation (non-convective condensation)
  1552      !
  1553      use lscond, only : LScaleCondInit
  1554  
  1555  
  1556      ! 宣言文 ; Declaration statements
  1557      !
  1558  
  1559      logical, intent(in) :: ArgFlagSnow
  1560  
  1561  
  1562      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1563                                ! Unit number for NAMELIST file open
  1564      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1565                                ! IOSTAT of NAMELIST read
  1566  
  1567      ! NAMELIST 変数群
  1568      ! NAMELIST group name
  1569      !
  1570      namelist /cloud_T1993base_nml/ &
  1571        & RHThresholdCrtl,      &
  1572        & RHThresholdSigmaMin,  &
  1573        & RHThresholdOrd,       &
  1574        & CloudLifeTime0, &
  1575        & CloudWatLifeTime0, &
  1576        & CloudIceLifeTime0, &
  1577        & QCloudWatEffConv0, &
  1578        & QCloudIceEffConv0, &
  1579        & TempBFEffectSat,    &
  1580        & PRCPArea,           &
  1581        & PRCPEvapArea,       &
  1582        & PRCPColFactor
  1583            !
  1584            ! デフォルト値については初期化手続 "cloud_T1993base#CloudT1993baseInit"
  1585            ! のソースコードを参照のこと.
  1586            !
  1587            ! Refer to source codes in the initialization procedure
  1588            ! "cloud_T1993base#CloudT1993baseInit" for the default values.
  1589            !
  1590  
  1591      ! 実行文 ; Executable statement
  1592      !
  1593  
  1594      if ( cloud_T1993base_inited ) return
  1595  
  1596  
  1597      FlagSnow = ArgFlagSnow
  1598  
  1599  
  1600      ! デフォルト値の設定
  1601      ! Default values settings
  1602      !
  1603      RHThresholdCrtl      = 0.5_DP
  1604  !!$    RHThresholdCrtl      = 0.8_DP ! ECMWF IFS
  1605      RHThresholdSigmaMin  = 1.0_DP
  1606  !!$    RHThresholdSigmaMin  = 0.8_DP ! ECMWF IFS
  1607      RHThresholdOrd       = 2.0_DP ! ECMWF IFS
  1608      CloudLifeTime0       = 1000.0_DP
  1609      CloudWatLifeTime0    = 1000.0_DP
  1610      CloudIceLifeTime0    = 1000.0_DP
  1611      QCloudWatEffConv0    = 1.0e-4_DP
  1612      QCloudIceEffConv0    = 1.0e-3_DP
  1613      TempBFEffectSat      = 250.0_DP
  1614        !   This value follows that by IFS CY38r1
  1615        !   (p.82 of http://www.ecmwf.int/research/ifsdocs/CY38r1/IFSPart4.pdf)
  1616        !   Actually, IFS CY38r1 uses 250.16 K.
  1617      PRCPArea            = 1.0_DP
  1618  !!$    PRCPArea            = 0.5_DP
  1619      PRCPEvapArea        = 1.0_DP
  1620  
  1621      PRCPColFactor       = 300.0_DP
  1622                            ! This value comes from Sundqvist et al. (1989)
  1623                            ! IFS CY38r1 uses 100, but in addition ,
  1624                            ! precipitation area has to be considered.
  1625  
  1626      ! NAMELIST の読み込み
  1627      ! NAMELIST is input
  1628      !
  1629      if ( trim(namelist_filename) /= '' ) then
  1630        call FileOpen( unit_nml, &          ! (out)
  1631          & namelist_filename, mode = 'r' ) ! (in)
  1632  
  1633        rewind( unit_nml )
  1634        read( unit_nml,                     & ! (in)
  1635          & nml = cloud_T1993base_nml,      & ! (out)
  1636          & iostat = iostat_nml )             ! (out)
  1637        close( unit_nml )
  1638  
  1639        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1640      end if
  1641  
  1642  
  1643      ! Initialization of modules used in this module
  1644      !
  1645  
  1646      ! 飽和比湿の算出
  1647      ! Evaluate saturation specific humidity
  1648      !
  1649      call SaturateInit
  1650  
  1651      ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
  1652      ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
  1653      !
  1654      call LScaleCondInit( &
  1655        & FlagSnow &
  1656        & )
  1657  
  1658  
  1659      ! ヒストリデータ出力のためのへの変数登録
  1660      ! Register of variables for history data output
  1661      !
  1662  !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
  1663  !!$      & (/ 'lon ', 'lat ', 'time' /), &
  1664  !!$      & 'effective cloud cover', '1' )
  1665  
  1666  
  1667  
  1668      ! 印字 ; Print
  1669      !
  1670      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1671      call MessageNotify( 'M', module_name, 'RHThresholdCrtl      = %f', d = (/ RHThresholdCrtl /) )
  1672      call MessageNotify( 'M', module_name, 'RHThresholdSigmaMin  = %f', d = (/ RHThresholdSigmaMin /) )
  1673      call MessageNotify( 'M', module_name, 'RHThresholdOrd       = %f', d = (/ RHThresholdOrd /) )
  1674      call MessageNotify( 'M', module_name, 'CloudLifeTime0       = %f', d = (/ CloudLifeTime0 /) )
  1675      call MessageNotify( 'M', module_name, 'CloudIceLifeTime0    = %f', d = (/ CloudIceLifeTime0 /) )
  1676      call MessageNotify( 'M', module_name, 'CloudWatLifeTime0    = %f', d = (/ CloudWatLifeTime0 /) )
  1677      call MessageNotify( 'M', module_name, 'QCloudWatEffConv0    = %f', d = (/ QCloudWatEffConv0 /) )
  1678      call MessageNotify( 'M', module_name, 'QCloudIceEffConv0    = %f', d = (/ QCloudIceEffConv0 /) )
  1679      call MessageNotify( 'M', module_name, 'TempBFEffectSat      = %f', d = (/ TempBFEffectSat /) )
  1680      call MessageNotify( 'M', module_name, 'PRCPArea            = %f', d = (/ PRCPArea /) )
  1681      call MessageNotify( 'M', module_name, 'PRCPEvapArea        = %f', d = (/ PRCPEvapArea /) )
  1682      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1683  
  1684  
  1685      cloud_T1993base_inited = .true.
  1686  
  1687    end subroutine CloudT1993baseInit
  1688  
  1689    !--------------------------------------------------------------------------------------
  1690  
  1691  end module cloud_T1993base
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:58 2016
FILE NAME: cloud_T1993base.f90
PROGRAM NAME: cloud_t1993base
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Tiedtke (1993) に基づく雲モデル
     2:             !
     3:             != Cloud model based on Tiedtke (1993)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: cloud_T1993base.f90,v 1.6 2015/01/29 12:20:40 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module cloud_T1993base
    13:               !
    14:               != Tiedtke (1993) に基づく雲モデル
    15:               !
    16:               != Cloud model based on Tiedtke (1993)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 簡単雲モデルによる雲の計算.
    21:               !
    22:               ! In this module, the amount of cloud is calculated by use of a simple
    23:               ! cloud model.
    24:               !
    25:               !== Procedures List
    26:               !
    27:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    28:             !!$  ! ------------            :: ------------
    29:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30:               !
    31:               !== NAMELIST
    32:               !
    33:               ! NAMELIST#cloud_T1993base_nml
    34:               !
    35:             
    36:               ! モジュール引用 ; USE statements
    37:             
    38:               !
    39:               ! Kind type parameter
    40:               !
    41:               use dc_types, only: DP, &      ! Double precision.
    42:                 &                 STRING, &  ! Strings.
    43:                 &                 TOKEN      ! Keywords.
    44:             
    45:               ! メッセージ出力
    46:               ! Message output
    47:               !
    48:               use dc_message, only: MessageNotify
    49:             
    50:               ! 格子点設定
    51:               ! Grid points settings
    52:               !
    53:               use gridset, only: imax, & ! 経度格子点数.
    54:                                          ! Number of grid points in longitude
    55:                 &                jmax, & ! 緯度格子点数.
    56:                                          ! Number of grid points in latitude
    57:                 &                kmax    ! 鉛直層数.
    58:                                          ! Number of vertical level
    59:             
    60:               implicit none
    61:             
    62:               private
    63:             
    64:             
    65:               ! 公開手続き
    66:               ! Public procedure
    67:               !
    68:               public :: CloudT1993base
    69:               public :: CloudT1993baseWithIce
    70:               public :: CloudT1993baseInit
    71:             
    72:             
    73:               ! 公開変数
    74:               ! Public variables
    75:               !
    76:             
    77:             
    78:               ! 非公開変数
    79:               ! Private variables
    80:               !
    81:               logical , save        :: FlagSnow
    82:                                        ! A flag for snow
    83:             
    84:               real(DP), save        :: RHThresholdCrtl
    85:               real(DP), save        :: RHThresholdSigmaMin
    86:               real(DP), save        :: RHThresholdOrd
    87:             
    88:               real(DP), save        :: CloudLifeTime0
    89:             
    90:               real(DP), save        :: CloudWatLifeTime0
    91:               real(DP), save        :: CloudIceLifeTime0
    92:             
    93:               real(DP), save        :: QCloudWatEffConv0
    94:               real(DP), save        :: QCloudIceEffConv0
    95:             
    96:               real(DP), save        :: TempBFEffectSat
    97:                                        ! Temperature at which Bergeron-Findeisen effect 
    98:                                        ! saturates.
    99:             
   100:             
   101:               real(DP), save :: FactBlsThreshold = 1.0e-10_DP
   102:             
   103:               real(DP), save :: PRCPArea
   104:                 !                           a_p
   105:               real(DP), save :: PRCPEvapArea
   106:                 !                           A = max( a_p - a, 0 )
   107:             
   108:               real(DP), save :: PRCPColFactor
   109:               !                             This is C1 in Sundqvist et al. (1989)
   110:             
   111:             
   112:               logical, save :: cloud_T1993base_inited = .false.
   113:                                           ! 初期設定フラグ.
   114:                                           ! Initialization flag
   115:             
   116:               character(*), parameter:: module_name = 'cloud_T1993base'
   117:                                           ! モジュールの名称.
   118:                                           ! Module name
   119:               character(*), parameter:: version = &
   120:                 & '$Name:  $' // &
   121:                 & '$Id: cloud_T1993base.f90,v 1.6 2015/01/29 12:20:40 yot Exp $'
   122:                                           ! モジュールのバージョン
   123:                                           ! Module version
   124:             
   125:               !--------------------------------------------------------------------------------------
   126:             
   127:             contains
   128:             
   129:               !----------------------------------------------------------------------------
   130:               ! This subroutine, SetCloudCloudWaterAdjustWithCloudCoverV4, is 
   131:               ! created at 2012/08/13.
   132:             
   133:             !!$  call CloudT1993base(                                        &
   134:             !!$    & xyz_Press, xyr_Press, xyz_VirTemp,                      & ! (in)
   135:             !!$    & xyz_DQH2OLiqDtCum,                                      & ! (in)
   136:             !!$    & xyz_MoistConvDetTend,                                   & ! (in)
   137:             !!$    & xyz_OMG, xyz_MoistConvSubsidMassFlux, xyz_DTempDt,      & ! (in)
   138:             !!$    & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),               & ! (inout)
   139:             !!$    & xyzf_QMixA(:,:,:,CompositionInqIndex('H2OLiq')),        & ! (inout)
   140:             !!$    & xyzf_QMixA(:,:,:,CompositionInqIndex('CloudCoverTMP')), & ! (inout)
   141:             !!$    & xy_Rain, xy_Snow                                        & ! (out)
   142:             !!$    & )
   143:             
   144:             
   145:               subroutine CloudT1993base(                                    &
   146:                 & xyz_Press, xyr_Press, xyz_VirTemp,                        & ! (in)
   147:                 & xyz_DQCloudWaterDtCum,                                    & ! (in)
   148:                 & xyz_MoistConvDetTend,                                     & ! (in)
   149:                 & xyz_OMG, xyz_MoistConvSubsidMassFlux, xyz_DTempDtPhy,     & ! (in)
   150:                 & xyz_Temp, xyz_QH2OVap,                                    & ! (inout)
   151:                 & xyz_QCloudWater,                                          & ! (inout)
   152:                 & xyz_CloudCover,                                           & ! (inout)
   153:                 & xy_SurfRainFlux, xy_SurfSnowFlux                          & ! (out)
   154:                 & )
   155:             
   156:                 ! USE statements
   157:                 !
   158:             
   159:                 ! 時刻管理
   160:                 ! Time control
   161:                 !
   162:                 use timeset, only: &
   163:                   & DelTime            ! $ \Delta t $ [s]
   164:             
   165:                 ! 物理・数学定数設定
   166:                 ! Physical and mathematical constants settings
   167:                 !
   168:                 use constants0, only: &
   169:                   & PI                    ! $ \pi $ .
   170:                                           ! 円周率.  Circular constant
   171:             
   172:                 ! 物理定数設定
   173:                 ! Physical constants settings
   174:                 !
   175:                 use constants, only: &
   176:                   & Grav, &
   177:                                           ! $ g $ [m s-2].
   178:                                           ! 重力加速度.
   179:                                           ! Gravitational acceleration
   180:                   & CpDry, &
   181:                                           ! $ C_p $ [J kg-1 K-1].
   182:                                           ! 乾燥大気の定圧比熱.
   183:                                           ! Specific heat of air at constant pressure
   184:                   & GasRDry, &
   185:                                           ! $ R $ [J kg-1 K-1].
   186:                                           ! 乾燥大気の気体定数.
   187:                                           ! Gas constant of air
   188:                   & GasRWet, &
   189:                                           ! $ R_v $ [J kg-1 K-1].
   190:                                           ! 凝結成分の気体定数.
   191:                                           ! Gas constant of condensible elements
   192:                   & LatentHeat
   193:                                           ! $ L $ [J kg-1] .
   194:                                           ! 凝結の潜熱.
   195:                                           ! Latent heat of condensation
   196:             
   197:                 ! 飽和比湿の算出
   198:                 ! Evaluate saturation specific humidity
   199:                 !
   200:                 use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp
   201:             
   202:                 ! 大規模凝結 (非対流性凝結)
   203:                 ! Large scale condensation
   204:                 !
   205:                 use lscond, only: LScaleCond
   206:             
   207:                 ! 簡単雲モデル
   208:                 ! Simple cloud model
   209:                 !
   210:                 use cloud_simple, only : CloudSimpleCalcPRCPKeyLLTemp
   211:             
   212:             
   213:                 real(DP), intent(in   ) :: xyz_Press                  (0:imax-1, 1:jmax, 1:kmax)
   214:                 real(DP), intent(in   ) :: xyr_Press                  (0:imax-1, 1:jmax, 0:kmax)
   215:                 real(DP), intent(in   ) :: xyz_VirTemp                (0:imax-1, 1:jmax, 1:kmax)
   216:                 real(DP), intent(in   ) :: xyz_DQCloudWaterDtCum      (0:imax-1, 1:jmax, 1:kmax)
   217:                 real(DP), intent(in   ) :: xyz_MoistConvDetTend       (0:imax-1, 1:jmax, 1:kmax)
   218:                 real(DP), intent(in   ) :: xyz_OMG                    (0:imax-1, 1:jmax, 1:kmax)
   219:                 real(DP), intent(in   ) :: xyz_MoistConvSubsidMassFlux(0:imax-1, 1:jmax, 1:kmax)
   220:                 real(DP), intent(in   ) :: xyz_DTempDtPhy             (0:imax-1, 1:jmax, 1:kmax)
   221:                 real(DP), intent(inout) :: xyz_Temp                   (0:imax-1, 1:jmax, 1:kmax)
   222:                 real(DP), intent(inout) :: xyz_QH2OVap                (0:imax-1, 1:jmax, 1:kmax)
   223:                 real(DP), intent(inout) :: xyz_QCloudWater            (0:imax-1, 1:jmax, 1:kmax)
   224:                 real(DP), intent(inout) :: xyz_CloudCover             (0:imax-1, 1:jmax, 1:kmax)
   225:                 real(DP), intent(out)   :: xy_SurfRainFlux            (0:imax-1, 1:jmax)
   226:                 real(DP), intent(out)   :: xy_SurfSnowFlux            (0:imax-1, 1:jmax)
   227:             
   228:             
   229:                 real(DP) :: xyz_QCloudWaterB     (0:imax-1, 1:jmax, 1:kmax)
   230:             
   231:                 real(DP) :: xyz_QH2OVapSat       (0:imax-1, 1:jmax, 1:kmax)
   232:                 real(DP) :: xyz_DQH2OVapSatDPress(0:imax-1, 1:jmax, 1:kmax)
   233:                 real(DP) :: xyz_DQH2OVapSatDTemp (0:imax-1, 1:jmax, 1:kmax)
   234:                 real(DP) :: xyz_DQH2OVapSatDt    (0:imax-1, 1:jmax, 1:kmax)
   235:             
   236:                 real(DP) :: xyz_ZeroOneCloudProd(0:imax-1, 1:jmax, 1:kmax)
   237:                 real(DP) :: xyz_ZeroOneCloudLoss(0:imax-1, 1:jmax, 1:kmax)
   238:                 real(DP) :: xyz_DelCloudCoverStr(0:imax-1, 1:jmax, 1:kmax)
   239:                 real(DP) :: xyz_FactA           (0:imax-1, 1:jmax, 1:kmax)
   240:                 real(DP) :: xyz_FactA1          (0:imax-1, 1:jmax, 1:kmax)
   241:                 real(DP) :: xyz_FactA2          (0:imax-1, 1:jmax, 1:kmax)
   242:                 real(DP) :: xyz_FactB           (0:imax-1, 1:jmax, 1:kmax)
   243:                 real(DP) :: xyz_FactC           (0:imax-1, 1:jmax, 1:kmax)
   244:                 real(DP) :: xyz_FactC1          (0:imax-1, 1:jmax, 1:kmax)
   245:                 real(DP) :: xyz_FactC2          (0:imax-1, 1:jmax, 1:kmax)
   246:                 real(DP) :: xyz_FactD           (0:imax-1, 1:jmax, 1:kmax)
   247:                 real(DP) :: xyz_FactE           (0:imax-1, 1:jmax, 1:kmax)
   248:                 real(DP) :: xyz_FactE1          (0:imax-1, 1:jmax, 1:kmax)
   249:                 real(DP) :: xyz_FactE2          (0:imax-1, 1:jmax, 1:kmax)
   250:             
   251:                 real(DP) :: xy_Rain                  (0:imax-1, 1:jmax)
   252:                 real(DP) :: xyz_Rain                 (0:imax-1, 1:jmax, 1:kmax)
   253:                 real(DP) :: xy_RainConvFactor        (0:imax-1, 1:jmax)
   254:                 real(DP) :: xy_FactCo                (0:imax-1, 1:jmax)
   255:                 real(DP) :: xy_FactBF                (0:imax-1, 1:jmax)
   256:                 real(DP) :: xy_QCloudWatConvThreshold(0:imax-1, 1:jmax)
   257:             
   258:                 real(DP) :: xyz_DTempDtLSC             (0:imax-1, 1:jmax, 1:kmax)
   259:                 real(DP) :: xyz_DQVapDtLSC             (0:imax-1, 1:jmax, 1:kmax)
   260:                 real(DP) :: xyz_RainLSC                (0:imax-1, 1:jmax, 1:kmax)
   261:                 real(DP) :: xy_RainLSC                 (0:imax-1, 1:jmax)
   262:             
   263:             
   264:                 real(DP), parameter :: MixCoef                  = 1.0d-6
   265:                 real(DP), parameter :: QCloudWaterEvapThreshold = 1.0d-10
   266:             !!$    real(DP), parameter :: RHThreshold              = 0.999_DP
   267:                 real(DP), parameter :: RHThreshold              = 1.0_DP - 1.0d-10
   268:                 ! Values below are obtained from Sundqvist et al. (1989), but some of 
   269:                 ! those are arbitrarily selected.
   270:                 real(DP)            :: RainConvFactor0
   271:                 real(DP), parameter :: C1                       = 300.0_DP
   272:                 real(DP), parameter :: C2                       = 0.5_DP
   273:             
   274:             
   275:                 ! Parameters for evaporation of rain
   276:                 real(DP), parameter :: DensWater            = 1.0d3
   277:                 !                            rho_w
   278:                 !   Values below are from Kessler (1969)
   279:                 real(DP), parameter :: RainFallVelFactor         = 130.0d0
   280:                 !                            K
   281:                 real(DP), parameter :: MedianDiameterFactor      = 3.67d0
   282:                 !                            C'
   283:                 real(DP), parameter :: RainDistFactor            = 1.0d7
   284:                 !                            N0
   285:                 real(DP), parameter :: RainEvapRatUnitDiamFactor = 2.24d3
   286:                 !                            C
   287:                 real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
   288:                 !                            Kd
   289:             
   290:                 real(DP) :: Dens0
   291:                 !                            rho_0
   292:                 real(DP) :: V00
   293:                 !                            V_{00}
   294:                 real(DP) :: RainEvapFactor
   295:             
   296:                 real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   297:                 !                           rho
   298:                 real(DP) :: xy_DensRain     (0:imax-1, 1:jmax)
   299:                 !                           (rho q_r)
   300:                 real(DP) :: xy_RainArea     (0:imax-1, 1:jmax)
   301:                 !                           a_p
   302:                 real(DP) :: xy_RainEvapArea (0:imax-1, 1:jmax)
   303:                 !                           A = max( a_p - a, 0 )
   304:                 real(DP) :: xyz_RainEvapRate(0:imax-1, 1:jmax, 1:kmax)
   305:             
   306:                 real(DP) :: xy_DelRain      (0:imax-1, 1:jmax)
   307:                 real(DP) :: DelQH2OVap
   308:             
   309:                 real(DP) :: RainFallVel
   310:             
   311:                 real(DP) :: xyz_Sigma               (0:imax-1, 1:jmax, 1:kmax)
   312:                 real(DP) :: xyz_CloudProdRHThreshold(0:imax-1, 1:jmax, 1:kmax)
   313:             
   314:                 integer :: i
   315:                 integer :: j
   316:                 integer :: k
   317:             
   318:             
   319:                 ! 実行文 ; Executable statement
   320:                 !
   321:             
   322:                 ! 初期化確認
   323:                 ! Initialization check
   324:                 !
   325:                 if ( .not. cloud_T1993base_inited ) then
   326:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   327:                 end if
   328:             
   329:             
   330:                 ! Parameters for evaporation of rain
   331:                 Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
   332:                 V00 = RainFallVelFactor * sqrt( MedianDiameterFactor ) &
   333:                   & / ( PI * DensWater * RainDistFactor )**(1.0d0/8.0d0)
   334:                 RainEvapFactor =                                      &
   335:             !      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
   336:                   & RainEvapRatUnitDiamFactor * 1.429624558860304d0   &
   337:                   & * H2OVapDiffCoef * RainDistFactor**(7.0d0/20.0d0) &
   338:                   & / ( PI * DensWater )**(13.0d0/20.0d0)
   339:                 ! Values for evaporation of rain
   340: **V---->A       xyz_Dens = xyz_Press / ( GasRDry * xyz_VirTemp )
   341: |||         
   342: |||         
   343: |||             ! Save cloud water amount
   344: |||             !
   345: **V---- A       xyz_QCloudWaterB = xyz_QCloudWater
   346:             
   347:             
   348:                 xyz_QH2OVapSat       = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   349:                 xyz_DQH2OVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QH2OVapSat )
   350:             
   351: **V---->A       xyz_DQH2OVapSatDPress = xyz_QH2OVapSat / xyz_Press                           &
   352: |||               & * ( LatentHeat * GasRDry * xyz_VirTemp - CpDry * GasRWet * xyz_Temp**2 ) &
   353: |||               & / ( xyz_CloudCover * LatentHeat**2 * xyz_QH2OVapSat + CpDry * GasRWet * xyz_Temp**2 )
   354: |||         
   355: **V---- A       xyz_DQH2OVapSatDt =                                                            &
   356:                   &   xyz_DQH2OVapSatDPress * ( xyz_OMG + Grav * xyz_MoistConvSubsidMassFlux ) &
   357:                   & + xyz_DQH2OVapSatDTemp                                                      &
   358:                   &   / ( 1.0_DP + xyz_CloudCover * LatentHeat / CpDry * xyz_DQH2OVapSatDTemp ) &
   359:                   &   * xyz_DTempDtPhy
   360:             
   361:             
   362:                 ! set zero-one flag
   363: +------>        do k = 1, kmax
   364: |+V==== A         xyz_Sigma(:,:,k) = xyz_Press(:,:,k) / xyr_Press(:,:,0)
   365: +------         end do
   366: ++V==== A       xyz_CloudProdRHThreshold =                                     &
   367:                   &   RHThresholdCrtl                                          &
   368:                   & + ( 1.0_DP - xyz_QH2OVap / xyz_QH2OVapSat )                &
   369:                   &   * (   max( ( xyz_Sigma - RHThresholdSigmaMin ), 0.0_DP ) &
   370:                   &       / ( xyz_Sigma - RHThresholdSigmaMin )                )**RHThresholdOrd
   371: +------>        do k = 1, kmax
   372: |+----->          do j = 1, jmax
   373: ||V---->            do i = 0, imax-1
   374: |||                   if ( xyz_DQH2OVapSatDt(i,j,k) < 0.0_DP ) then
   375: |||     A               if ( xyz_QH2OVap(i,j,k) >= xyz_CloudProdRHThreshold(i,j,k) * xyz_QH2OVapSat(i,j,k) ) then
   376: |||                       xyz_ZeroOneCloudProd(i,j,k) = 1.0_DP
   377: |||                     else
   378: |||                       xyz_ZeroOneCloudProd(i,j,k) = 0.0_DP
   379: |||                     end if
   380: |||                     xyz_ZeroOneCloudLoss(i,j,k) = 1.0_DP
   381: |||                   else
   382: |||                     xyz_ZeroOneCloudProd(i,j,k) = 0.0_DP
   383: |||                     xyz_ZeroOneCloudLoss(i,j,k) = 0.0_DP
   384: |||                   end if
   385: ||V----             end do
   386: |+-----           end do
   387: +------         end do
   388:             
   389:             
   390:                 ! Rain at the surface
   391: *W----->A       xy_Rain     = 0.0_DP
   392: ||              ! Rain area
   393: *W-----         xy_RainArea = 0.0_DP
   394:             
   395: +------>        k_loop : do k = kmax, 1, -1
   396: |           
   397: |                 ! Evaporation of rain
   398: |                 !
   399: |                 if ( k == kmax ) then
   400: |+V====             xy_RainArea = 0.0_DP
   401: |                 else
   402: |W----->            do j = 1, jmax
   403: ||*---->              do i = 0, imax-1
   404: |||                     if ( xyz_Rain(i,j,k+1) > 0.0_DP ) then
   405: |||     A                 if ( xyz_CloudCover(i,j,k+1) > xy_RainArea(i,j) ) then
   406: |||                         xy_RainArea(i,j) = xyz_CloudCover(i,j,k+1)
   407: |||                       end if
   408: |||                     end if
   409: ||*----               end do
   410: |W-----             end do
   411: |                 end if
   412: |*V---->A         xy_DensRain =                                                      &
   413: |||                 & ( xy_Rain / ( xy_RainArea + 1.0d-10 )                          &
   414: |||                 &   / ( V00 * sqrt( Dens0 / xyz_Dens(:,:,k) ) ) )**(8.0d0/9.0d0)
   415: |||     A         xy_RainEvapArea = max( xy_RainArea - xyz_CloudCover(:,:,k), 0.0_DP )
   416: |*V---- A         xyz_RainEvapRate(:,:,k) =                                         &
   417: |                   & xyz_Dens(:,:,k) * xy_RainEvapArea * RainEvapFactor            &
   418: |                   &   * max( xyz_QH2OVapSat(:,:,k) - xyz_QH2OVap(:,:,k), 0.0_DP ) &
   419: |                   &   * xy_DensRain**(13.0d0/20.0d0)
   420: |W----->          do j = 1, jmax
   421: ||*---->            do i = 0, imax-1
   422: |||                   RainFallVel =                             &
   423: |||                     & V00 * sqrt( Dens0 / xyz_Dens(i,j,k) ) &
   424: |||                     &   * xy_DensRain(i,j)**(1.0d0/8.0d0)
   425: |||     A             if ( xy_RainArea(i,j) * RainFallVel * xyz_RainEvapRate(i,j,k) &
   426: |||                     &    * 2.0_DP * DelTime                                     &
   427: |||                     &      > xy_Rain(i,j) ) then
   428: |||     A               xyz_RainEvapRate(i,j,k) =                              &
   429: |||                       & xy_Rain(i,j)                                       &
   430: |||                       &   / ( ( xy_RainArea(i,j) + 1.0d-10 ) * RainFallVel &
   431: |||                       &       * 2.0_DP * DelTime )
   432: |||                     xy_DelRain(i,j) = - xy_Rain(i,j)
   433: |||                   else
   434: |||                     xy_DelRain(i,j) =                                    &
   435: |||                       & - xy_RainArea(i,j) * RainFallVel                 &
   436: |||                       & * xyz_RainEvapRate(i,j,k) * ( 2.0_DP * DelTime )
   437: |||                   end if
   438: |||     A             xy_Rain(i,j) = xy_Rain(i,j) + xy_DelRain(i,j)
   439: |||         !!$            xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k)              &
   440: |||         !!$              & + xyz_RainEvapRate(i,j,k) * ( 2.0_DP * DelTime ) &
   441: |||         !!$              &     / xyz_Dens(i,j,k)
   442: |||         !!$            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                    &
   443: |||         !!$              & - xyz_RainEvapRate(i,j,k) * ( 2.0_DP * DelTime ) &
   444: |||         !!$              &     / xyz_Dens(i,j,k)                            &
   445: |||         !!$              &     * LatentHeat / CpDry
   446: |||                   ! DelRain = DelQH2OVap * DelPress / Grav / ( 2.0_DP * DelTime )
   447: |||     A             DelQH2OVap =                                             &
   448: |||                     & - xy_DelRain(i,j)                                    &
   449: |||                     & * Grav / ( xyr_Press(i,j,k-1) - xyr_Press(i,j,k) )
   450: |||     A             xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k)                  &
   451: |||                     & + DelQH2OVap
   452: |||     A             xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                        &
   453: |||                     & - DelQH2OVap                                         &
   454: |||                     &   * LatentHeat / CpDry
   455: ||*----             end do
   456: |W-----           end do
   457: |           
   458: |           
   459: |W*==== A         xyz_FactC1(:,:,k) = xyz_MoistConvDetTend(:,:,k)
   460: |+----->          do j = 1, jmax
   461: ||V---->            do i = 0, imax-1
   462: |||     A             if ( xyz_QH2OVap(i,j,k) < RHThreshold * xyz_QH2OVapSat(i,j,k) ) then
   463: |||     A               xyz_FactC2(i,j,k) =                                         &
   464: |||                       & - ( 1.0_DP - xyz_CloudCover(i,j,k) )                    &
   465: |||                       &   / ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )      &
   466: |||                       &   * xyz_DQH2OVapSatDt(i,j,k) * xyz_ZeroOneCloudProd(i,j,k)
   467: |||                   else
   468: |||         !!$              xyz_FactC2(i,j,k) = 0.0_DP
   469: |||                     xyz_FactC2(i,j,k) = 1.0_DP / ( 2.0_DP * DelTime )
   470: |||                   end if
   471: ||V---- A           end do
   472: |+-----           end do
   473: |W*====           xyz_FactC(:,:,k) = xyz_FactC1(:,:,k) + xyz_FactC2(:,:,k)
   474: |+----->          do j = 1, jmax
   475: ||V---->            do i = 0, imax-1
   476: |||     A             if ( xyz_QH2OVapSat(i,j,k) > xyz_QH2OVap(i,j,k) ) then
   477: |||     A               xyz_FactD(i,j,k) =                                      &
   478: |||                       & 2.0_DP * xyz_CloudCover(i,j,k) * MixCoef            &
   479: |||                       & * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )    &
   480: |||                       & / ( xyz_QCloudWater(i,j,k) + 1.0d-100 )
   481: |||                   else
   482: |||                     xyz_FactD(i,j,k) = 0.0_DP
   483: |||                   end if
   484: |||                 end do
   485: |||               end do
   486: |||               !
   487: |||               do j = 1, jmax
   488: |||                 do i = 0, imax-1
   489: |||                   if ( xyz_QH2OVap(i,j,k) < RHThreshold * xyz_QH2OVapSat(i,j,k) ) then
   490: |||                     xyz_FactE1(i,j,k) =                                             &
   491: |||                       &   ( 1.0_DP - xyz_CloudCover(i,j,k) )**2                     &
   492: |||                       & / ( 2.0_DP                                                  &
   493: |||                       &       * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) ) )    &
   494: |||                       & * xyz_DQH2OVapSatDt(i,j,k) * xyz_ZeroOneCloudProd(i,j,k)
   495: |||                   else
   496: |||                     xyz_FactE1(i,j,k) = 0.0_DP
   497: |||                   end if
   498: |||                 end do
   499: |||               end do
   500: |||               do j = 1, jmax
   501: |||                 do i = 0, imax-1
   502: |||                   if ( xyz_QH2OVapSat(i,j,k) > xyz_QH2OVap(i,j,k) ) then
   503: |||                     xyz_FactE2(i,j,k) =                                     &
   504: |||                       & + xyz_CloudCover(i,j,k)**2 * MixCoef                &
   505: |||                       & * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )    &
   506: |||                       & / ( xyz_QCloudWater(i,j,k) + 1.0d-100 )
   507: |||                   else
   508: |||                     xyz_FactE2(i,j,k) = 0.0_DP
   509: |||                   end if
   510: ||V----             end do
   511: |+-----           end do
   512: |*V---->          xyz_FactE(:,:,k) = xyz_FactE1(:,:,k) + xyz_FactE2(:,:,k)
   513: |||               !
   514: |||     A         xyz_DelCloudCoverStr(:,:,k) =                                         &
   515: |||                 &   xyz_FactC2(:,:,k) * 2.0_DP * DelTime                            &
   516: |||                 & - xyz_FactC2(:,:,k)                                               &
   517: |||                 &  / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 )             &
   518: |||                 &   * (                                                             &
   519: |||                 &         xyz_FactC(:,:,k) * 2.0_DP * DelTime                       &
   520: |||                 &       + ( xyz_CloudCover(:,:,k)                                   &
   521: |||                 &             - xyz_FactC(:,:,k)                                    &
   522: |||                 &             / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 ) )&
   523: |||                 &         * ( 1.0_DP                                                &
   524: |||                 &               - exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) )    &
   525: |||                 &                   * 2.0_DP * DelTime ) )                          &
   526: |||                 &     )                                                             &
   527: |||                 & + xyz_FactE1(:,:,k) * 2.0_DP * DelTime
   528: |||               !
   529: |||     A         xyz_FactA1(:,:,k) = xyz_DQCloudWaterDtCum(:,:,k)
   530: |*V---- A         xyz_FactA2(:,:,k) =                                                   &
   531: |                   & - xyz_CloudCover(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)                &
   532: |                   &     * xyz_ZeroOneCloudProd(:,:,k)                                 &
   533: |                   & - xyz_DelCloudCoverStr(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)          &
   534: |                   &     * xyz_ZeroOneCloudProd(:,:,k)                                 &
   535: |                   &     / 2.0_DP                                                      &
   536: |                   & - xyz_CloudCover(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)                &
   537: |                   &     * ( 1.0_DP - xyz_ZeroOneCloudLoss(:,:,k) )                    &
   538: |                   & - xyz_CloudCover(:,:,k) * MixCoef                                 &
   539: |                   &     * ( xyz_QH2OVapSat(:,:,k) - xyz_QH2OVap(:,:,k) )
   540: |                 !    The value of xyz_FactA2 is checked, and is updated.
   541: |W----->          do j = 1, jmax
   542: ||*---->            do i = 0, imax-1
   543: |||     A             if ( xyz_FactA2(i,j,k) * 2.0_DP * DelTime > xyz_QH2OVap(i,j,k) ) then
   544: |||                     xyz_FactA2(i,j,k) = xyz_QH2OVap(i,j,k) / ( 2.0_DP * DelTime ) &
   545: |||                       & * ( 1.0_DP - 1.0d-14 )
   546: |||                   end if
   547: ||*----             end do
   548: |W-----           end do
   549: |W*====           xyz_FactA(:,:,k) = xyz_FactA1(:,:,k) + xyz_FactA2(:,:,k)
   550: |           
   551: |           !!$        xy_RainConvFactor = 1.0_DP / ( CloudLifeTime0 + 1.0d-100 )
   552: |                 !
   553: |*W---->A         xy_FactCo = 1.0_DP &
   554: |||                 & + C1 * sqrt( xy_Rain )
   555: |||               ! Factor for Bergeron-Findeisen effect
   556: |||               !   Sundqvist et al. (1989)
   557: |||         !!$      xy_FactBF = 1.0_DP &
   558: |||         !!$        & + C2 * sqrt( max( 268.0_DP - xyz_Temp(:,:,k), 0.0_DP ) )
   559: |||               !   An original equation following that by IFS CY38r1
   560: |||               !   (p.82 of http://www.ecmwf.int/research/ifsdocs/CY38r1/IFSPart4.pdf)
   561: |||         !!$      xy_FactBF = 1.0_DP                                               &
   562: |||         !!$        & + C2 * sqrt( min(                                            &
   563: |||         !!$        &                   max( 268.0_DP - xyz_Temp(:,:,k), 0.0_DP ), &
   564: |||         !!$        &                   max( 268.0_DP - TempBFEffectSat, 0.0_DP )  &
   565: |||         !!$        &                  )                                           &
   566: |||         !!$        &            )
   567: |||               !   Constant (no effect)
   568: |*W----           xy_FactBF = 1.0_DP
   569: |                 !
   570: |                 RainConvFactor0 = 1.0_DP / ( CloudLifeTime0 + 1.0d-100 )
   571: |           !!$      xy_QCloudWatConvThreshold = &
   572: |           !!$        & QCloudWatEffConv0 / ( xy_FactCo * xy_FactBF )
   573: |*W---->          xy_QCloudWatConvThreshold = &
   574: |||                 & ( QCloudWatEffConv0 + 1.0e-100_DP ) / ( xy_FactCo * xy_FactBF )
   575: |||     A         xy_RainConvFactor = RainConvFactor0 * xy_FactCo * xy_FactBF &
   576: |||                 & * (                                                     &
   577: |||                 &       1.0_DP                                            &
   578: |||                 &     - exp(                                              &
   579: |||                 &            - ( xyz_QCloudWater(:,:,k)                   &
   580: |||                 &                / ( ( xyz_CloudCover(:,:,k) + 1.0d-100 ) &
   581: |||                 &                    * xy_QCloudWatConvThreshold )   )**2 &
   582: |||                 &          )                                              &
   583: |||                 &   )
   584: |||               !
   585: |*W----           xyz_FactB(:,:,k) = xy_RainConvFactor
   586: |                 !
   587: |W----->          do j = 1, jmax
   588: ||*---->            do i = 0, imax-1
   589: |||                   if ( xyz_FactB(i,j,k) < 1.0_DP / 1.0d10 ) then
   590: |||                     xyz_FactB(i,j,k) = 1.0_DP / 1.0d10
   591: |||                   end if
   592: ||*----             end do
   593: |W-----           end do
   594: |           
   595: |           
   596: |                 ! Values at next time step are calculated.
   597: |                 !
   598: |W*==== A         xyz_QCloudWater(:,:,k) =                                             &
   599: |                   &   xyz_QCloudWater(:,:,k)                                         &
   600: |                   &     * exp( - xyz_FactB(:,:,k) * 2.0_DP * DelTime )               &
   601: |                   & + xyz_FactA(:,:,k) / xyz_FactB(:,:,k)                            &
   602: |                   &     * ( 1.0_DP - exp( - xyz_FactB(:,:,k) * 2.0_DP * DelTime ) )
   603: |                 !   The value of cloud water amount is checked, and xyz_FactA 
   604: |                 !   is updated.
   605: |W----->          do j = 1, jmax
   606: ||*---->            do i = 0, imax-1
   607: |||     A             if ( xyz_QCloudWater(i,j,k) < 0.0_DP ) then
   608: |||                     xyz_FactA2(i,j,k) = - xyz_FactA1(i,j,k)                         &
   609: |||                       & - xyz_FactB(i,j,k) * xyz_QCloudWaterB(i,j,k)                &
   610: |||                       & * exp( - xyz_FactB(i,j,k) * 2.0_DP * DelTime )              &
   611: |||                       & / ( 1.0_DP - exp( - xyz_FactB(i,j,k) * 2.0_DP * DelTime ) )
   612: |||     A               xyz_QCloudWater(i,j,k) = 0.0_DP
   613: |||                   end if
   614: ||*----             end do
   615: |W-----           end do
   616: |*W---->          xyz_FactA(:,:,k) = xyz_FactA1(:,:,k) + xyz_FactA2(:,:,k)
   617: |||               !
   618: |||     A         xyz_CloudCover(:,:,k) =                                            &
   619: |||                 &   xyz_CloudCover(:,:,k)                                        &
   620: |||                 &    * exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) )            &
   621: |||                 &               * 2.0_DP * DelTime )                             &
   622: |||                 & + ( xyz_FactC(:,:,k) + xyz_FactE(:,:,k) )                      &
   623: |||                 &    / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 )        &
   624: |||                 &    * ( 1.0_DP - exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) ) &
   625: |||                 &                          * 2.0_DP * DelTime ) )
   626: |||               !
   627: |||     A         xyz_QH2OVap(:,:,k) = xyz_QH2OVap(:,:,k) &
   628: |||                 & - xyz_FactA2(:,:,k) * 2.0_DP * DelTime
   629: |||               !
   630: |||     A         xyz_Temp(:,:,k) = xyz_Temp(:,:,k) &
   631: |||                 & + xyz_FactA2(:,:,k) * 2.0_DP * DelTime * LatentHeat / CpDry
   632: |||         
   633: |||         
   634: |||               ! Rain
   635: |||               !
   636: |||               xyz_Rain(:,:,k) =                                                    &
   637: |||                 &   xyz_FactA(:,:,k) * 2.0_DP * DelTime                            &
   638: |||                 & + xyz_QCloudWaterB(:,:,k)                                        &
   639: |||                 &    * ( 1.0_DP - exp( - xyz_FactB(:,:,k) * 2.0_DP * DelTime ) )   &
   640: |||                 & - xyz_FactA(:,:,k) / xyz_FactB(:,:,k)                            &
   641: |||                 &    * ( 1.0_DP - exp( - xyz_FactB(:,:,k) * 2.0_DP * DelTime ) )
   642: |||               xyz_Rain(:,:,k) = xyz_Rain(:,:,k) / ( 2.0_DP * DelTime )
   643: |||         
   644: |||               ! Rain at the surface
   645: |*W---- A         xy_Rain = xy_Rain     &
   646: |                   & + xyz_Rain(:,:,k) &
   647: |                   &    * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   648: |           
   649: |                 ! Evaporation
   650: |                 !
   651: |W----->          do j = 1, jmax
   652: ||*---->            do i = 0, imax-1
   653: |||     A             if ( xyz_QCloudWater(i,j,k) < QCloudWaterEvapThreshold ) then
   654: |||     A               xyz_CloudCover(i,j,k) = 0.0_DP
   655: |||                   end if
   656: |||                 end do
   657: |||               end do
   658: |||         
   659: |||               ! Cloud cover is restricted.
   660: |||               do j = 1, jmax
   661: |||                 do i = 0, imax-1
   662: |||                   if ( xyz_CloudCover(i,j,k) > 1.0_DP ) then
   663: |||                     xyz_CloudCover(i,j,k) = 1.0_DP
   664: |||                   else if ( xyz_CloudCover(i,j,k) < 0.0_DP ) then
   665: |||                     xyz_CloudCover(i,j,k) = 0.0_DP
   666: |||                   end if
   667: ||*----             end do
   668: |W-----           end do
   669: |           
   670: |           
   671: |                 ! Check values
   672: |+----->          do j = 1, jmax
   673: ||+---->            do i = 0, imax-1
   674: |||                   if ( xyz_QH2OVap(i,j,k) < 0.0_DP ) then
   675: |||                     write( 6, * ) 'QH2OVap is negative', &
   676: |||                       & i, j, k, xyz_QH2OVap(i,j,k)
   677: |||                   end if
   678: |||                   if ( xyz_QCloudWater(i,j,k) < 0.0_DP ) then
   679: |||                     write( 6, * ) 'QCloudWater is negative', &
   680: |||                       & i, j, k, xyz_QCloudWater(i,j,k)
   681: |||                   end if
   682: ||+----             end do
   683: |+-----           end do
   684: |           
   685: +------         end do k_loop
   686:             
   687:             
   688: **V---->        xyz_DTempDtLSC = 0.0_DP
   689: **V----         xyz_DQVapDtLSC = 0.0_DP
   690:             
   691:                 ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
   692:                 ! Large scale condensation (non-convective condensation) (Manabe, 1965)
   693:                 !
   694:                 call LScaleCond(                        &
   695:                   & xyz_Temp, xyz_QH2OVap,              & ! (inout)
   696:                   & xyz_Press, xyr_Press,               & ! (in)
   697:                   & xyz_RainLSC                         & ! (out)
   698:                   & )
   699:             
   700: W*=====         xy_RainLSC = 0.0_DP
   701: +------>        do k = kmax, 1, -1
   702: |W*==== A         xy_RainLSC = xy_RainLSC     &
   703: |                   & + xyz_RainLSC(:,:,k)    &
   704: |                   &    * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   705: +------         end do
   706:             
   707:             
   708: W*===== A       xy_Rain = xy_Rain + xy_RainLSC
   709:             
   710:             
   711:                 call CloudSimpleCalcPRCPKeyLLTemp(     &
   712:                   & xyz_Temp, xy_Rain,                 &  ! (in )
   713:                   & xy_SurfRainFlux, xy_SurfSnowFlux   &  ! (out)
   714:                   & )
   715:             
   716:             
   717:               end subroutine CloudT1993base
   718:             
   719:               !----------------------------------------------------------------------------
   720:             
   721:               subroutine CloudT1993baseWithIce(                             &
   722:                 & xyz_Press, xyr_Press, xyz_VirTemp,                        & ! (in)
   723:                 & xyz_DQCloudWatDtCum, xyz_DQCloudIceDtCum,                 & ! (in)
   724:                 & xyz_MoistConvDetTend,                                     & ! (in)
   725:                 & xyz_OMG, xyz_MoistConvSubsidMassFlux, xyz_DTempDtPhy,     & ! (in)
   726:                 & xyz_Temp, xyz_QH2OVap,                                    & ! (inout)
   727:                 & xyz_QCloudWat, xyz_QCloudIce,                             & ! (inout)
   728:                 & xyz_CloudCover,                                           & ! (inout)
   729:                 & xy_SurfRainFlux, xy_SurfSnowFlux                          & ! (out)
   730:                 & )
   731:             
   732:                 ! USE statements
   733:                 !
   734:             
   735:                 ! 時刻管理
   736:                 ! Time control
   737:                 !
   738:                 use timeset, only: &
   739:                   & DelTime            ! $ \Delta t $ [s]
   740:             
   741:                 ! 物理・数学定数設定
   742:                 ! Physical and mathematical constants settings
   743:                 !
   744:                 use constants0, only: &
   745:                   & PI                    ! $ \pi $ .
   746:                                           ! 円周率.  Circular constant
   747:             
   748:                 ! 物理定数設定
   749:                 ! Physical constants settings
   750:                 !
   751:                 use constants, only: &
   752:                   & Grav, &
   753:                                           ! $ g $ [m s-2].
   754:                                           ! 重力加速度.
   755:                                           ! Gravitational acceleration
   756:                   & CpDry, &
   757:                                           ! $ C_p $ [J kg-1 K-1].
   758:                                           ! 乾燥大気の定圧比熱.
   759:                                           ! Specific heat of air at constant pressure
   760:                   & GasRDry, &
   761:                                           ! $ R $ [J kg-1 K-1].
   762:                                           ! 乾燥大気の気体定数.
   763:                                           ! Gas constant of air
   764:                   & GasRWet, &
   765:                                           ! $ R_v $ [J kg-1 K-1].
   766:                                           ! 凝結成分の気体定数.
   767:                                           ! Gas constant of condensible elements
   768:                   & LatentHeat, &
   769:                                           ! $ L $ [J kg-1] .
   770:                                           ! 凝結の潜熱.
   771:                                           ! Latent heat of condensation
   772:                   & LatentHeatFusion, &
   773:                                           ! $ L $ [J kg-1] .
   774:                                           ! 融解の潜熱.
   775:                                           ! Latent heat of fusion
   776:                   & EpsV
   777:                                           ! $ \epsilon_v $ .
   778:                                           ! 水蒸気分子量比.
   779:                                           ! Molecular weight of water vapor
   780:             
   781:                 ! 飽和比湿の算出
   782:                 ! Evaluate saturation specific humidity
   783:                 !
   784:                 use saturate, only: &
   785:                   & xyz_CalcQVapSat     , xyz_CalcDQVapSatDTemp
   786:             !!$      & xyz_CalcQVapSatOnLiq, xyz_CalcDQVapSatOnLiqDTemp, &
   787:             !!$      & xyz_CalcQVapSatOnSol, xyz_CalcDQVapSatOnSolDTemp
   788:             
   789:                 ! 飽和比湿の算出
   790:                 ! Evaluate saturation specific humidity
   791:                 !
   792:                 use saturate, only : SaturateWatFraction
   793:             
   794:                 ! 大規模凝結 (非対流性凝結)
   795:                 ! Large scale condensation
   796:                 !
   797:                 use lscond, only: &
   798:             !!$      & LScaleCond1D3DWrapper, &
   799:                   & LScaleCond1Grid
   800:             
   801:                 ! 雲関系ルーチン
   802:                 ! Cloud-related routines
   803:                 !
   804:                 use cloud_utils, only : &
   805:                   & CloudUtilsPRCPStepPC1Grid, &
   806:                   & CloudUtilsPRCPEvap1Grid, &
   807:                   & CloudUtilConsChk
   808:             
   809:             
   810:                 real(DP), intent(in   ) :: xyz_Press                  (0:imax-1, 1:jmax, 1:kmax)
   811:                 real(DP), intent(in   ) :: xyr_Press                  (0:imax-1, 1:jmax, 0:kmax)
   812:                 real(DP), intent(in   ) :: xyz_VirTemp                (0:imax-1, 1:jmax, 1:kmax)
   813:                 real(DP), intent(in   ) :: xyz_DQCloudWatDtCum        (0:imax-1, 1:jmax, 1:kmax)
   814:                 real(DP), intent(in   ) :: xyz_DQCloudIceDtCum        (0:imax-1, 1:jmax, 1:kmax)
   815:                 real(DP), intent(in   ) :: xyz_MoistConvDetTend       (0:imax-1, 1:jmax, 1:kmax)
   816:                 real(DP), intent(in   ) :: xyz_OMG                    (0:imax-1, 1:jmax, 1:kmax)
   817:                 real(DP), intent(in   ) :: xyz_MoistConvSubsidMassFlux(0:imax-1, 1:jmax, 1:kmax)
   818:                 real(DP), intent(in   ) :: xyz_DTempDtPhy             (0:imax-1, 1:jmax, 1:kmax)
   819:                 real(DP), intent(inout) :: xyz_Temp                   (0:imax-1, 1:jmax, 1:kmax)
   820:                 real(DP), intent(inout) :: xyz_QH2OVap                (0:imax-1, 1:jmax, 1:kmax)
   821:                 real(DP), intent(inout) :: xyz_QCloudWat              (0:imax-1, 1:jmax, 1:kmax)
   822:                 real(DP), intent(inout) :: xyz_QCloudIce              (0:imax-1, 1:jmax, 1:kmax)
   823:                 real(DP), intent(inout) :: xyz_CloudCover             (0:imax-1, 1:jmax, 1:kmax)
   824:                 real(DP), intent(out)   :: xy_SurfRainFlux            (0:imax-1, 1:jmax)
   825:                 real(DP), intent(out)   :: xy_SurfSnowFlux            (0:imax-1, 1:jmax)
   826:             
   827:             
   828:                 ! Local variables
   829:                 !
   830:                 real(DP) :: xyz_TempB            (0:imax-1, 1:jmax, 1:kmax)
   831:                 real(DP) :: xyz_QH2OVapB         (0:imax-1, 1:jmax, 1:kmax)
   832:                 real(DP) :: xyz_QCloudWatB       (0:imax-1, 1:jmax, 1:kmax)
   833:                 real(DP) :: xyz_QCloudIceB       (0:imax-1, 1:jmax, 1:kmax)
   834:             
   835:                 real(DP) :: LatentHeatSubl
   836:             
   837:                 real(DP) :: xyz_WatFrac          (0:imax-1, 1:jmax, 1:kmax)
   838:                 real(DP) :: xyz_IceFrac          (0:imax-1, 1:jmax, 1:kmax)
   839:             
   840:                 real(DP) :: xyz_QH2OVapSat       (0:imax-1, 1:jmax, 1:kmax)
   841:                 real(DP) :: xyz_DQH2OVapSatDTemp (0:imax-1, 1:jmax, 1:kmax)
   842:             
   843:             !!$    real(DP) :: xyz_QH2OVapSatOnLiq  (0:imax-1, 1:jmax, 1:kmax)
   844:             !!$    real(DP) :: xyz_QH2OVapSatOnIce  (0:imax-1, 1:jmax, 1:kmax)
   845:             
   846:                 real(DP) :: xyz_DQH2OVapSatDPressDenom(0:imax-1, 1:jmax, 1:kmax)
   847:             
   848:                 real(DP) :: xyz_DQH2OVapSatDPress(0:imax-1, 1:jmax, 1:kmax)
   849:                 real(DP) :: xyz_DQH2OVapSatDt    (0:imax-1, 1:jmax, 1:kmax)
   850:             
   851:                 real(DP) :: xyz_ZOCloudProd   (0:imax-1, 1:jmax, 1:kmax)
   852:                 real(DP) :: xyz_ZOCloudLoss   (0:imax-1, 1:jmax, 1:kmax)
   853:                 real(DP) :: xyz_DelCloudCoverStr(0:imax-1, 1:jmax, 1:kmax)
   854:                 real(DP) :: xyz_FactAl          (0:imax-1, 1:jmax, 1:kmax)
   855:                 real(DP) :: xyz_FactAs          (0:imax-1, 1:jmax, 1:kmax)
   856:                 real(DP) :: xyz_FactAl1         (0:imax-1, 1:jmax, 1:kmax)
   857:                 real(DP) :: xyz_FactAs1         (0:imax-1, 1:jmax, 1:kmax)
   858:                 real(DP) :: xyz_FactA20         (0:imax-1, 1:jmax, 1:kmax)
   859:                 real(DP) :: xyz_FactAl2         (0:imax-1, 1:jmax, 1:kmax)
   860:                 real(DP) :: xyz_FactAs2         (0:imax-1, 1:jmax, 1:kmax)
   861:                 real(DP) :: xyz_FactBl          (0:imax-1, 1:jmax, 1:kmax)
   862:                 real(DP) :: xyz_FactBs          (0:imax-1, 1:jmax, 1:kmax)
   863:                 real(DP) :: xyz_FactC           (0:imax-1, 1:jmax, 1:kmax)
   864:                 real(DP) :: xyz_FactC1          (0:imax-1, 1:jmax, 1:kmax)
   865:                 real(DP) :: xyz_FactC2          (0:imax-1, 1:jmax, 1:kmax)
   866:                 real(DP) :: xyz_FactD           (0:imax-1, 1:jmax, 1:kmax)
   867:                 real(DP) :: xyz_FactE           (0:imax-1, 1:jmax, 1:kmax)
   868:                 real(DP) :: xyz_FactE1          (0:imax-1, 1:jmax, 1:kmax)
   869:                 real(DP) :: xyz_FactE2          (0:imax-1, 1:jmax, 1:kmax)
   870:             
   871:                 real(DP) :: xy_Rain                    (0:imax-1, 1:jmax)
   872:                 real(DP) :: xyz_Rain                   (0:imax-1, 1:jmax, 1:kmax)
   873:                 real(DP) :: xy_Snow                    (0:imax-1, 1:jmax)
   874:                 real(DP) :: xyz_Snow                   (0:imax-1, 1:jmax, 1:kmax)
   875:             
   876:                 real(DP) :: xy_FactCo                (0:imax-1, 1:jmax)
   877:                 real(DP) :: xy_FactBF                (0:imax-1, 1:jmax)
   878:                 real(DP) :: xy_QCloudWatConvThreshold(0:imax-1, 1:jmax)
   879:                 real(DP) :: xy_QCloudIceConvThreshold(0:imax-1, 1:jmax)
   880:                 real(DP) :: xy_FactIceTempDep        (0:imax-1, 1:jmax)
   881:                 real(DP) :: xy_FactConvThreshold     (0:imax-1, 1:jmax)
   882:             
   883:                 real(DP) :: xy_RainConvFactor          (0:imax-1, 1:jmax)
   884:                 real(DP) :: xy_SnowConvFactor          (0:imax-1, 1:jmax)
   885:             
   886:                 real(DP) :: xyz_DQH2OLiqDtLSC      (0:imax-1, 1:jmax, 1:kmax)
   887:                 real(DP) :: xyz_DQH2OSolDtLSC      (0:imax-1, 1:jmax, 1:kmax)
   888:             
   889:             
   890:                 real(DP), parameter :: MixCoef                  = 1.0d-6
   891:                 real(DP), parameter :: QCloudWaterEvapThreshold = 1.0d-10
   892:             !!$    real(DP), parameter :: RHThreshold              = 0.999_DP
   893:                 real(DP), parameter :: RHThreshold              = 1.0_DP - 1.0d-10
   894:                 ! Values below are obtained from Sundqvist et al. (1989), but some of 
   895:                 ! those are arbitrarily selected.
   896:                 real(DP)            :: RainConvFactor0
   897:                 real(DP)            :: SnowConvFactor0
   898:                 real(DP), parameter :: C2                       = 0.5_DP
   899:             
   900:             
   901:                 ! Parameters for evaporation of rain
   902:                 real(DP), parameter :: DensWater            = 1.0d3
   903:                 !                            rho_w
   904:                 !   Values below are from Kessler (1969)
   905:                 real(DP), parameter :: RainFallVelFactor         = 130.0d0
   906:                 !                            K
   907:                 real(DP), parameter :: MedianDiameterFactor      = 3.67d0
   908:                 !                            C'
   909:                 real(DP), parameter :: RainDistFactor            = 1.0d7
   910:                 !                            N0
   911:                 real(DP), parameter :: RainEvapRatUnitDiamFactor = 2.24d3
   912:                 !                            C
   913:                 real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
   914:                 !                            Kd
   915:             
   916:                 real(DP) :: Dens0
   917:                 !                            rho_0
   918:                 real(DP) :: V00
   919:                 !                            V_{00}
   920:                 real(DP) :: RainEvapFactor
   921:             
   922:                 real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   923:                 !                           rho
   924:                 real(DP) :: xy_DensRain     (0:imax-1, 1:jmax)
   925:                 !                           (rho q_r)
   926:                 real(DP) :: xy_RainArea     (0:imax-1, 1:jmax)
   927:                 !                           a_p
   928:                 real(DP) :: xy_RainEvapArea (0:imax-1, 1:jmax)
   929:                 !                           A = max( a_p - a, 0 )
   930:                 real(DP) :: xyz_RainEvapRate(0:imax-1, 1:jmax, 1:kmax)
   931:             
   932:                 real(DP) :: xyz_DelMass( 0:imax-1, 1:jmax, 1:kmax )
   933:                 real(DP) :: aaa_QH2OVapSat(1,1,1)
   934:                 real(DP) :: QH2OVapSat
   935:             
   936:                 real(DP) :: QCloudWatTentative
   937:                 real(DP) :: QCloudIceTentative
   938:             
   939:                 real(DP) :: xyz_Sigma               (0:imax-1, 1:jmax, 1:kmax)
   940:                 real(DP) :: xyz_CloudProdRHThreshold(0:imax-1, 1:jmax, 1:kmax)
   941:             
   942:                 integer :: i
   943:                 integer :: j
   944:                 integer :: k
   945:                 integer :: l
   946:             
   947:             
   948:                 ! 実行文 ; Executable statement
   949:                 !
   950:             
   951:                 ! 初期化確認
   952:                 ! Initialization check
   953:                 !
   954:                 if ( .not. cloud_T1993base_inited ) then
   955:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   956:                 end if
   957:             
   958:             
   959:                 ! Save current values
   960:                 !
   961: **W---->A       xyz_TempB      = xyz_Temp
   962: |||     A       xyz_QH2OVapB   = xyz_QH2OVap
   963: |||     A       xyz_QCloudWatB = xyz_QCloudWat
   964: **W---- A       xyz_QCloudIceB = xyz_QCloudIce
   965:             
   966:             
   967:                 ! Latent heat for sublimation (sum of evaporation and fusion)
   968:                 LatentHeatSubl = LatentHeat + LatentHeatFusion
   969:             
   970:             
   971: W------>        do k = 1, kmax
   972: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   973: W------         end do
   974:             
   975:                 ! Parameters for evaporation of rain
   976:                 Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
   977:                 V00 = RainFallVelFactor * sqrt( MedianDiameterFactor ) &
   978:                   & / ( PI * DensWater * RainDistFactor )**(1.0d0/8.0d0)
   979:                 RainEvapFactor =                                      &
   980:             !      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
   981:                   & RainEvapRatUnitDiamFactor * 1.429624558860304d0   &
   982:                   & * H2OVapDiffCoef * RainDistFactor**(7.0d0/20.0d0) &
   983:                   & / ( PI * DensWater )**(13.0d0/20.0d0)
   984:                 ! Values for evaporation of rain
   985: ++V==== A       xyz_Dens = xyz_Press / ( GasRDry * xyz_VirTemp )
   986:             
   987:             
   988:                 ! Calculate liquid water fraction and ice fraction
   989:                 !
   990:                 call SaturateWatFraction( &
   991:                   & xyz_Temp,             & ! (in )
   992:                   & xyz_WatFrac           & ! (out)
   993:                   & )
   994: **V---->A       xyz_IceFrac = 1.0_DP - xyz_WatFrac
   995: |||         
   996: |||         
   997: **V---- A       xyz_QH2OVapSat       = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   998:                 xyz_DQH2OVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QH2OVapSat )
   999:             
  1000:             !!$    xyz_QH2OVapSatOnLiq       = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
  1001:             !!$    xyz_DQH2OVapSatOnLiqDTemp = xyz_CalcDQVapSatOnLiqDTemp( xyz_Temp, xyz_QH2OVapSatOnLiq )
  1002:             !!$    xyz_QH2OVapSatOnIce       = xyz_CalcQVapSatOnIce( xyz_Temp, xyz_Press )
  1003:             !!$    xyz_DQH2OVapSatOnIceDTemp = xyz_CalcDQVapSatOnIceDTemp( xyz_Temp, xyz_QH2OVapSatOnIce )
  1004:             
  1005: **V---->A       xyz_DQH2OVapSatDPressDenom =                                        &
  1006: |||               &   1.0_DP                                                        &
  1007: |||               & + xyz_CloudCover / CpDry                                        &
  1008: |||               &   * ( xyz_WatFrac * LatentHeat + xyz_IceFrac * LatentHeatSubl ) &
  1009: |||               &   * xyz_DQH2OVapSatDTemp
  1010: |||         
  1011: |||     A       xyz_DQH2OVapSatDPress =                                            &
  1012: |||               &   ( - xyz_QH2OVapSat                                           &
  1013: |||               &     + GasRDry * xyz_VirTemp / CpDry * xyz_DQH2OVapSatDTemp )   &
  1014: |||               & / ( xyz_Press * xyz_DQH2OVapSatDPressDenom )
  1015: |||         
  1016: **V---- A       xyz_DQH2OVapSatDt =                                              &
  1017:                   &   xyz_DQH2OVapSatDPress                                      &
  1018:                   &   * ( xyz_OMG + Grav * xyz_MoistConvSubsidMassFlux )         &
  1019:                   & + xyz_DQH2OVapSatDTemp / xyz_DQH2OVapSatDPressDenom          &
  1020:                   &   * xyz_DTempDtPhy
  1021:             
  1022:             
  1023:                 ! set zero-one flag
  1024: +------>        do k = 1, kmax
  1025: |+V==== A         xyz_Sigma(:,:,k) = xyz_Press(:,:,k) / xyr_Press(:,:,0)
  1026: +------         end do
  1027: W**==== A       xyz_CloudProdRHThreshold =                                     &
  1028:                   &   RHThresholdCrtl                                          &
  1029:                   & + ( 1.0_DP - xyz_QH2OVap / xyz_QH2OVapSat )                &
  1030:                   &   * (   max( ( xyz_Sigma - RHThresholdSigmaMin ), 0.0_DP ) &
  1031:                   &       / ( xyz_Sigma - RHThresholdSigmaMin )                )**RHThresholdOrd
  1032: W------>        do k = 1, kmax
  1033: |*----->          do j = 1, jmax
  1034: ||*---->            do i = 0, imax-1
  1035: |||                   if ( xyz_DQH2OVapSatDt(i,j,k) < 0.0_DP ) then
  1036: |||     A               if ( xyz_QH2OVap(i,j,k) >= xyz_CloudProdRHThreshold(i,j,k) * xyz_QH2OVapSat(i,j,k) ) then
  1037: |||                       xyz_ZOCloudProd(i,j,k) = 1.0_DP
  1038: |||                     else
  1039: |||                       xyz_ZOCloudProd(i,j,k) = 0.0_DP
  1040: |||                     end if
  1041: |||                     xyz_ZOCloudLoss(i,j,k) = 1.0_DP
  1042: |||                   else
  1043: |||                     xyz_ZOCloudProd(i,j,k) = 0.0_DP
  1044: |||                     xyz_ZOCloudLoss(i,j,k) = 0.0_DP
  1045: |||                   end if
  1046: ||*----             end do
  1047: |*-----           end do
  1048: W------         end do
  1049:             
  1050:             
  1051:                 ! Rain and snow at the surface
  1052: *W----->A       xy_Rain     = 0.0_DP
  1053: ||      A       xy_Snow     = 0.0_DP
  1054: ||          
  1055: ||              ! Rain area
  1056: *W-----         xy_RainArea = 0.0_DP
  1057:             
  1058: +------>        k_loop : do k = kmax, 1, -1
  1059: |           
  1060: |           
  1061: |                 ! Freezing/melting and evaporation of precipitation
  1062: |                 !
  1063: |+----->          do j = 1, jmax
  1064: ||+---->            do i = 0, imax-1
  1065: |||                   call CloudUtilsPRCPStepPC1Grid(  &
  1066: |||                     & xyr_Press(i,j,k-1), xyr_Press(i,j,k),       & ! (in   )
  1067: |||                     & xyz_Temp(i,j,k),                            & ! (inout)
  1068: |||                     & xy_Rain(i,j), xy_Snow(i,j)                  & ! (inout)
  1069: |||                     & )
  1070: ||+----             end do
  1071: |+-----           end do
  1072: |+----->          do j = 1, jmax
  1073: ||+---->            do i = 0, imax-1
  1074: |||                   call CloudUtilsPRCPEvap1Grid(           &
  1075: |||                     & xyz_Press(i,j,k), xyr_Press(i,j,k-1), xyr_Press(i,j,k), & ! (in)
  1076: |||                     & PRCPArea, PRCPEvapArea,                                 & ! (in)
  1077: |||                     & xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k),                    & ! (inout)
  1078: |||                     & xy_Rain(i,j), xy_Snow(i,j)                              & ! (inout)
  1079: |||                     & )
  1080: ||+----             end do
  1081: |+-----           end do
  1082: |           
  1083: |           
  1084: |W*==== A         xyz_FactC1(:,:,k) = xyz_MoistConvDetTend(:,:,k)
  1085: |W----->          do j = 1, jmax
  1086: ||*---->            do i = 0, imax-1
  1087: |||     A             if ( xyz_QH2OVap(i,j,k) < RHThreshold * xyz_QH2OVapSat(i,j,k) ) then
  1088: |||     A               xyz_FactC2(i,j,k) =                                         &
  1089: |||                       & - ( 1.0_DP - xyz_CloudCover(i,j,k) )                    &
  1090: |||                       &   / ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )      &
  1091: |||                       &   * xyz_DQH2OVapSatDt(i,j,k) * xyz_ZOCloudProd(i,j,k)
  1092: |||                   else
  1093: |||         !!$              xyz_FactC2(i,j,k) = 0.0_DP
  1094: |||                     xyz_FactC2(i,j,k) = 1.0_DP / ( 2.0_DP * DelTime )
  1095: |||                   end if
  1096: ||*----             end do
  1097: |W-----           end do
  1098: |W*====           xyz_FactC(:,:,k) = xyz_FactC1(:,:,k) + xyz_FactC2(:,:,k)
  1099: |W----->          do j = 1, jmax
  1100: ||*---->            do i = 0, imax-1
  1101: |||     A             if ( xyz_QH2OVapSat(i,j,k) > xyz_QH2OVap(i,j,k) ) then
  1102: |||     A               xyz_FactD(i,j,k) =                                      &
  1103: |||                       & 2.0_DP * xyz_CloudCover(i,j,k) * MixCoef            &
  1104: |||                       & * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )    &
  1105: |||                       & / ( xyz_QCloudWat(i,j,k) + 1.0d-100 )
  1106: |||                   else
  1107: |||                     xyz_FactD(i,j,k) = 0.0_DP
  1108: |||                   end if
  1109: |||                 end do
  1110: |||               end do
  1111: |||               !
  1112: |||               do j = 1, jmax
  1113: |||                 do i = 0, imax-1
  1114: |||                   if ( xyz_QH2OVap(i,j,k) < RHThreshold * xyz_QH2OVapSat(i,j,k) ) then
  1115: |||                     xyz_FactE1(i,j,k) =                                             &
  1116: |||                       &   ( 1.0_DP - xyz_CloudCover(i,j,k) )**2                     &
  1117: |||                       & / ( 2.0_DP                                                  &
  1118: |||                       &       * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) ) )    &
  1119: |||                       & * xyz_DQH2OVapSatDt(i,j,k) * xyz_ZOCloudProd(i,j,k)
  1120: |||                   else
  1121: |||                     xyz_FactE1(i,j,k) = 0.0_DP
  1122: |||                   end if
  1123: |||                 end do
  1124: |||               end do
  1125: |||               do j = 1, jmax
  1126: |||                 do i = 0, imax-1
  1127: |||                   if ( xyz_QH2OVapSat(i,j,k) > xyz_QH2OVap(i,j,k) ) then
  1128: |||                     xyz_FactE2(i,j,k) =                                     &
  1129: |||                       & + xyz_CloudCover(i,j,k)**2 * MixCoef                &
  1130: |||                       & * ( xyz_QH2OVapSat(i,j,k) - xyz_QH2OVap(i,j,k) )    &
  1131: |||                       & / ( xyz_QCloudWat(i,j,k) + 1.0d-100 )
  1132: |||                   else
  1133: |||                     xyz_FactE2(i,j,k) = 0.0_DP
  1134: |||                   end if
  1135: ||*----             end do
  1136: |W-----           end do
  1137: |*W---->          xyz_FactE(:,:,k) = xyz_FactE1(:,:,k) + xyz_FactE2(:,:,k)
  1138: |||               !
  1139: |||     A         xyz_DelCloudCoverStr(:,:,k) =                                         &
  1140: |||                 &   xyz_FactC2(:,:,k) * 2.0_DP * DelTime                            &
  1141: |||                 & - xyz_FactC2(:,:,k)                                               &
  1142: |||                 &  / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 )             &
  1143: |||                 &   * (                                                             &
  1144: |||                 &         xyz_FactC(:,:,k) * 2.0_DP * DelTime                       &
  1145: |||                 &       + ( xyz_CloudCover(:,:,k)                                   &
  1146: |||                 &             - xyz_FactC(:,:,k)                                    &
  1147: |||                 &             / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 ) )&
  1148: |||                 &         * ( 1.0_DP                                                &
  1149: |||                 &               - exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) )    &
  1150: |||                 &                   * 2.0_DP * DelTime ) )                          &
  1151: |||                 &     )                                                             &
  1152: |||                 & + xyz_FactE1(:,:,k) * 2.0_DP * DelTime
  1153: |||               !
  1154: |||               !
  1155: |||               !
  1156: |||               !
  1157: |||     A         xyz_FactAl1(:,:,k) = xyz_DQCloudWatDtCum(:,:,k)
  1158: |||     A         xyz_FactAs1(:,:,k) = xyz_DQCloudIceDtCum(:,:,k)
  1159: |||               !
  1160: |||               !
  1161: |||               !
  1162: |*W---- A         xyz_FactA20(:,:,k) =                                                  &
  1163: |                   & - xyz_CloudCover(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)                &
  1164: |                   &     * xyz_ZOCloudProd(:,:,k)                                      &
  1165: |                   & - xyz_DelCloudCoverStr(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)          &
  1166: |                   &     * xyz_ZOCloudProd(:,:,k)                                      &
  1167: |                   &     / 2.0_DP                                                      &
  1168: |                   & - xyz_CloudCover(:,:,k) * xyz_DQH2OVapSatDt(:,:,k)                &
  1169: |                   &     * ( 1.0_DP - xyz_ZOCloudLoss(:,:,k) )                         &
  1170: |                   & - xyz_CloudCover(:,:,k) * MixCoef                                 &
  1171: |                   &     * ( xyz_QH2OVapSat(:,:,k) - xyz_QH2OVap(:,:,k) )
  1172: |                 !
  1173: |                 !    The value of xyz_FactA2 is checked, and is updated.
  1174: |W----->          do j = 1, jmax
  1175: ||*---->            do i = 0, imax-1
  1176: |||     A             if ( xyz_FactA20(i,j,k) * 2.0_DP * DelTime > xyz_QH2OVap(i,j,k) ) then
  1177: |||                     xyz_FactA20(i,j,k) = &
  1178: |||                       &   xyz_QH2OVap(i,j,k) / ( 2.0_DP * DelTime ) &
  1179: |||                       & * ( 1.0_DP - 1.0e-14_DP )
  1180: |||                   end if
  1181: ||*----             end do
  1182: |W-----           end do
  1183: |*W---->A         xyz_FactAl2(:,:,k) = xyz_WatFrac(:,:,k) * xyz_FactA20(:,:,k)
  1184: |||               xyz_FactAs2(:,:,k) = xyz_IceFrac(:,:,k) * xyz_FactA20(:,:,k)
  1185: |||         
  1186: |||         
  1187: |||               xyz_FactAl(:,:,k) = xyz_FactAl1(:,:,k) + xyz_FactAl2(:,:,k)
  1188: |*W----           xyz_FactAs(:,:,k) = xyz_FactAs1(:,:,k) + xyz_FactAs2(:,:,k)
  1189: |           
  1190: |           
  1191: |                 RainConvFactor0 = 1.0_DP / ( CloudWatLifeTime0 + 1.0d-100 )
  1192: |                 ! Factor for collection
  1193: |*W---->A         xy_FactCo = 1.0_DP + PRCPColFactor * sqrt( xy_Rain + xy_Snow )
  1194: |||               ! Factor for Bergeron-Findeisen effect
  1195: |||               !   Sundqvist et al. (1989)
  1196: |||         !!$      xy_FactBF = 1.0_DP &
  1197: |||         !!$        & + C2 * sqrt( max( 268.0_DP - xyz_Temp(:,:,k), 0.0_DP ) )
  1198: |||               !   An original equation following that by IFS CY38r1
  1199: |||               !   (p.82 of http://www.ecmwf.int/research/ifsdocs/CY38r1/IFSPart4.pdf)
  1200: |||         !!$      xy_FactBF = 1.0_DP                                               &
  1201: |||         !!$        & + C2 * sqrt( min(                                            &
  1202: |||         !!$        &                   max( 268.0_DP - xyz_Temp(:,:,k), 0.0_DP ), &
  1203: |||         !!$        &                   max( 268.0_DP - TempBFEffectSat, 0.0_DP )  &
  1204: |||         !!$        &                  )                                           &
  1205: |||         !!$        &            )
  1206: |||               !   Constant (no effect)
  1207: |||               xy_FactBF = 1.0_DP
  1208: |||               !
  1209: |||         !!$      xy_QCloudWatConvThreshold = &
  1210: |||         !!$        & QCloudWatEffConv0 / ( xy_FactCo * xy_FactBF )
  1211: |||               xy_QCloudWatConvThreshold = &
  1212: |||                 & ( QCloudWatEffConv0 + 1.0e-100_DP ) / ( xy_FactCo * xy_FactBF )
  1213: |||         !!$      xy_QCloudWatConvThreshold = &
  1214: |||         !!$        & QCloudWatEffConv0 / xy_FactCo
  1215: |||     A         xy_FactConvThreshold = &
  1216: |||                 &   1.0_DP                                                   &
  1217: |||                 & - exp( &
  1218: |||                 &        - ( xyz_QCloudWat(:,:,k)                          &
  1219: |||                 &            / ( xyz_CloudCover(:,:,k) + 1.0e-10_DP )      &
  1220: |||                 &            / xy_QCloudWatConvThreshold              )**2 &
  1221: |||                 &      )
  1222: |||               !
  1223: |||         !!$      xy_RainConvFactor = RainConvFactor0 * xy_FactCo * xy_FactBF
  1224: |*W----           xy_RainConvFactor = RainConvFactor0 * xy_FactCo * xy_FactBF &
  1225: |                   & * xy_FactConvThreshold
  1226: |           
  1227: |           
  1228: |                 SnowConvFactor0 = 1.0_DP / ( CloudIceLifeTime0 + 1.0d-100 )
  1229: |*V---->A         xy_FactIceTempDep = exp( 0.025_DP * ( xyz_Temp(:,:,k) - 273.15_DP ) )
  1230: |||         !!$      xy_QCloudIceConvThreshold = QCloudIceEffConv0
  1231: |||               xy_QCloudIceConvThreshold = QCloudIceEffConv0 + 1.0e-100_DP
  1232: |||     A         xy_FactConvThreshold = &
  1233: |||                 &   1.0_DP                                                   &
  1234: |||                 & - exp( &
  1235: |||                 &        - ( xyz_QCloudIce(:,:,k)                          &
  1236: |||                 &            / ( xyz_CloudCover(:,:,k) + 1.0e-10_DP )      &
  1237: |||                 &            / xy_QCloudIceConvThreshold              )**2 &
  1238: |||                 &      )
  1239: |||         !!$      xy_SnowConvFactor = SnowConvFactor0 * xy_FactIceTempDep
  1240: |||               xy_SnowConvFactor = SnowConvFactor0 * xy_FactIceTempDep &
  1241: |||                 & * xy_FactConvThreshold
  1242: |||         
  1243: |||               !
  1244: |||               !
  1245: |||               !
  1246: |||         !!$      xyz_FactBl(:,:,k) = 1.0_DP / ( CloudWatLifeTime0 + 1.0d-100 )
  1247: |||               xyz_FactBl(:,:,k) = xy_RainConvFactor
  1248: |||               !
  1249: |||         !!$      xyz_FactBs(:,:,k) = 1.0_DP / ( CloudIceLifeTime0 + 1.0d-100 )
  1250: |*V----           xyz_FactBs(:,:,k) = xy_SnowConvFactor
  1251: |                 !
  1252: |                 !
  1253: |                 !
  1254: |           
  1255: |           
  1256: |                 ! Values at next time step are calculated.
  1257: |                 !
  1258: |W----->          do j = 1, jmax
  1259: ||*---->            do i = 0, imax-1
  1260: |||                   if ( xyz_FactBl(i,j,k) >= FactBlsThreshold ) then
  1261: |||     A               xyz_QCloudWat(i,j,k) =                                            &
  1262: |||                       &   xyz_QCloudWat(i,j,k)                                        &
  1263: |||                       &     * exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime )           &
  1264: |||                       & + xyz_FactAl(i,j,k) / xyz_FactBl(i,j,k)                       &
  1265: |||                       &     * ( 1.0_DP - exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime ) )
  1266: |||                   else
  1267: |||     A               xyz_QCloudWat(i,j,k) =                                            &
  1268: |||                       &   xyz_QCloudWat(i,j,k)                                        &
  1269: |||                       & + xyz_FactAl(i,j,k) * ( 2.0_DP * DelTime )
  1270: |||                   end if
  1271: |||     A           end do
  1272: |||               end do
  1273: |||               !   The value of cloud water amount is checked, and xyz_FactA is updated.
  1274: |||               do j = 1, jmax
  1275: |||                 do i = 0, imax-1
  1276: |||                   if ( xyz_QCloudWat(i,j,k) < 0.0_DP ) then
  1277: |||                     if ( xyz_FactBl(i,j,k) >= FactBlsThreshold ) then
  1278: |||                       xyz_FactAl2(i,j,k) = - xyz_FactAl1(i,j,k)                       &
  1279: |||                         & - xyz_FactBl(i,j,k) * xyz_QCloudWatB(i,j,k)                 &
  1280: |||                         & * exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime )             &
  1281: |||                         & / ( 1.0_DP - exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime ) )
  1282: |||                     else
  1283: |||         !!$              xyz_FactAl2(i,j,k) = - xyz_FactAl1(i,j,k)
  1284: |||                       xyz_FactAl2(i,j,k) = &
  1285: |||                         & - (   xyz_QCloudWatB(i,j,k)                       &
  1286: |||                         &     + xyz_FactAl1(i,j,k) * ( 2.0_DP * DelTime ) ) &
  1287: |||                         &   / ( 2.0_DP * DelTime )
  1288: |||         
  1289: |||         !!$              call MessageNotify( 'E', module_name, 'Unexpected negative QCloudWat.' )
  1290: |||                     end if
  1291: |||                     xyz_QCloudWat(i,j,k) = 0.0_DP
  1292: |||                   end if
  1293: |||                 end do
  1294: |||               end do
  1295: |||               !
  1296: |||               do j = 1, jmax
  1297: |||                 do i = 0, imax-1
  1298: |||                   if ( xyz_FactBs(i,j,k) >= FactBlsThreshold ) then
  1299: |||                     xyz_QCloudIce(i,j,k) =                                            &
  1300: |||                       &   xyz_QCloudIce(i,j,k)                                        &
  1301: |||                       &     * exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime )           &
  1302: |||                       & + xyz_FactAs(i,j,k) / xyz_FactBs(i,j,k)                       &
  1303: |||                       &     * ( 1.0_DP - exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime ) )
  1304: |||                   else
  1305: |||                     xyz_QCloudIce(i,j,k) =                                            &
  1306: |||                       &   xyz_QCloudIce(i,j,k)                                        &
  1307: |||                       & + xyz_FactAs(i,j,k) * ( 2.0_DP * DelTime )
  1308: |||                   end if
  1309: |||                 end do
  1310: |||               end do
  1311: |||               !   The value of cloud water amount is checked, and xyz_FactA is updated.
  1312: |||               do j = 1, jmax
  1313: |||                 do i = 0, imax-1
  1314: |||                   if ( xyz_QCloudIce(i,j,k) < 0.0_DP ) then
  1315: |||                     if ( xyz_FactBs(i,j,k) >= FactBlsThreshold ) then
  1316: |||                       xyz_FactAs2(i,j,k) = - xyz_FactAs1(i,j,k)                       &
  1317: |||                         & - xyz_FactBs(i,j,k) * xyz_QCloudIceB(i,j,k)                 &
  1318: |||                         & * exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime )             &
  1319: |||                         & / ( 1.0_DP - exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime ) )
  1320: |||                     else
  1321: |||         !!$              xyz_FactAs2(i,j,k) = - xyz_FactAs1(i,j,k)
  1322: |||                       xyz_FactAs2(i,j,k) =                                  &
  1323: |||                         & - (   xyz_QCloudIceB(i,j,k)                       &
  1324: |||                         &     + xyz_FactAs1(i,j,k) * ( 2.0_DP * DelTime ) ) &
  1325: |||                         &   / ( 2.0_DP * DelTime )
  1326: |||         
  1327: |||         !!$              call MessageNotify( 'E', module_name, 'Unexpected negative QCloudIce.' )
  1328: |||                     end if
  1329: |||                     xyz_QCloudIce(i,j,k) = 0.0_DP
  1330: |||                   end if
  1331: ||*----             end do
  1332: |W-----           end do
  1333: |           
  1334: |           
  1335: |                 ! Al and As are updated because Al2 and As2 were updated above
  1336: |*W---->          xyz_FactAl(:,:,k) = xyz_FactAl1(:,:,k) + xyz_FactAl2(:,:,k)
  1337: |||               xyz_FactAs(:,:,k) = xyz_FactAs1(:,:,k) + xyz_FactAs2(:,:,k)
  1338: |||         
  1339: |||         
  1340: |||         
  1341: |||     A         xyz_CloudCover(:,:,k) =                                            &
  1342: |||                 &   xyz_CloudCover(:,:,k)                                        &
  1343: |||                 &    * exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) )            &
  1344: |||                 &               * 2.0_DP * DelTime )                             &
  1345: |||                 & + ( xyz_FactC(:,:,k) + xyz_FactE(:,:,k) )                      &
  1346: |||                 &    / ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) + 1.0d-100 )        &
  1347: |||                 &    * ( 1.0_DP - exp( - ( xyz_FactC(:,:,k) + xyz_FactD(:,:,k) ) &
  1348: |||                 &                          * 2.0_DP * DelTime ) )
  1349: |||         
  1350: |||         
  1351: |||         !!$      xyz_QH2OVap(:,:,k) = xyz_QH2OVap(:,:,k) &
  1352: |||         !!$        & - xyz_FactA2(:,:,k) * 2.0_DP * DelTime
  1353: |||     A         xyz_QH2OVap(:,:,k) = xyz_QH2OVap(:,:,k) &
  1354: |||                 & - ( xyz_FactAl2(:,:,k) + xyz_FactAs2(:,:,k) ) * 2.0_DP * DelTime
  1355: |||               !
  1356: |||         !!$      xyz_Temp(:,:,k) = xyz_Temp(:,:,k) &
  1357: |||         !!$        & + xyz_FactA2(:,:,k) * 2.0_DP * DelTime * LatentHeat / CpDry
  1358: |*W---- A         xyz_Temp(:,:,k) = xyz_Temp(:,:,k)               &
  1359: |                   & + (   xyz_FactAl2(:,:,k) * LatentHeat       &
  1360: |                   &     + xyz_FactAs2(:,:,k) * LatentHeatSubl ) &
  1361: |                   & * 2.0_DP * DelTime / CpDry
  1362: |           
  1363: |           
  1364: |                 ! Rain
  1365: |                 !
  1366: |W----->          do j = 1, jmax
  1367: ||*---->            do i = 0, imax-1
  1368: |||         !!$          if ( xyz_FactBl(i,j,k) >= FactBlsThreshold ) then
  1369: |||         !!$            xyz_Rain(i,j,k) =                                                 &
  1370: |||         !!$              &   xyz_FactAl(i,j,k) * 2.0_DP * DelTime                        &
  1371: |||         !!$              & + xyz_QCloudWatB(i,j,k)                                       &
  1372: |||         !!$              &    * ( 1.0_DP - exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime ) )  &
  1373: |||         !!$              & - xyz_FactAl(i,j,k) / xyz_FactBl(i,j,k)                       &
  1374: |||         !!$              &    * ( 1.0_DP - exp( - xyz_FactBl(i,j,k) * 2.0_DP * DelTime ) )
  1375: |||         !!$            xyz_Rain(i,j,k) = xyz_Rain(i,j,k) / ( 2.0_DP * DelTime )
  1376: |||         !!$          else
  1377: |||         !!$            xyz_Rain(i,j,k) = 0.0_DP
  1378: |||         !!$          end if
  1379: |||     A             xyz_Rain(i,j,k) =                                                 &
  1380: |||                     &   xyz_QCloudWatB(i,j,k)                                       &
  1381: |||                     & + xyz_FactAl(i,j,k) * 2.0_DP * DelTime                        &
  1382: |||                     & - xyz_QCloudWat (i,j,k)
  1383: |||                   xyz_Rain(i,j,k) = xyz_Rain(i,j,k) / ( 2.0_DP * DelTime )
  1384: |||                 end do
  1385: |||               end do
  1386: |||         
  1387: |||               ! Snow
  1388: |||               !
  1389: |||               do j = 1, jmax
  1390: |||                 do i = 0, imax-1
  1391: |||         !!$          if ( xyz_FactBs(i,j,k) >= FactBlsThreshold ) then
  1392: |||         !!$            xyz_Snow(i,j,k) =                                               &
  1393: |||         !!$              &   xyz_FactAs(i,j,k) * 2.0_DP * DelTime                      &
  1394: |||         !!$              & + xyz_QCloudIceB  (i,j,k)                                   &
  1395: |||         !!$              &    * ( 1.0_DP - exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime ) )  &
  1396: |||         !!$              & - xyz_FactAs(i,j,k) / xyz_FactBs(i,j,k)                     &
  1397: |||         !!$              &    * ( 1.0_DP - exp( - xyz_FactBs(i,j,k) * 2.0_DP * DelTime ) )
  1398: |||         !!$            xyz_Snow(i,j,k) = xyz_Snow(i,j,k) / ( 2.0_DP * DelTime )
  1399: |||         !!$          else
  1400: |||         !!$            xyz_Snow(i,j,k) = 0.0_DP
  1401: |||         !!$          end if
  1402: |||                   xyz_Snow(i,j,k) =                                               &
  1403: |||                     &   xyz_QCloudIceB  (i,j,k)                                   &
  1404: |||                     & + xyz_FactAs(i,j,k) * 2.0_DP * DelTime                      &
  1405: |||                     & - xyz_QCloudIce   (i,j,k)
  1406: |||                   xyz_Snow(i,j,k) = xyz_Snow(i,j,k) / ( 2.0_DP * DelTime )
  1407: ||*----             end do
  1408: |W-----           end do
  1409: |           
  1410: |                 ! Rain at the surface
  1411: |*W---->A         xy_Rain = xy_Rain + xyz_Rain(:,:,k) * xyz_DelMass(:,:,k)
  1412: |||               ! Snow at the surface
  1413: |*W---- A         xy_Snow = xy_Snow + xyz_Snow(:,:,k) * xyz_DelMass(:,:,k)
  1414: |           
  1415: |           
  1416: |                 ! Treatment of supersaturation
  1417: |+----->          do j = 1, jmax
  1418: ||+---->            do i = 0, imax-1
  1419: |||                   QCloudWatTentative = xyz_QCloudWat(i,j,k)
  1420: |||                   QCloudIceTentative = xyz_QCloudIce(i,j,k)
  1421: |||                   call LScaleCond1Grid(  &
  1422: |||                     & xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), &  ! (inout)
  1423: |||         !!$            & xyz_QCloudWat(i,j,k), xyz_QCloudIce(i,j,k),           & ! (inout)
  1424: |||                     & QCloudWatTentative, QCloudIceTentative,               & ! (inout)
  1425: |||                     & xyz_Press(i,j,k), xyr_Press(i,j,k-1), xyr_Press(i,j,k), & ! (in)
  1426: |||                     & xyz_DQH2OLiqDtLSC(i,j,k), xyz_DQH2OSolDtLSC(i,j,k)      & ! (out)
  1427: |||                     & )
  1428: |||         
  1429: |||         !!$          xy_Rain(i,j) = xy_Rain(i,j) &
  1430: |||         !!$            & + ( xyz_QCloudWat(i,j,k) - QCloudWatTentative ) &
  1431: |||         !!$            &     / ( 2.0_DP * DelTime ) &
  1432: |||         !!$            &     * ( 2.0_DP * DelTime ) &
  1433: |||         !!$            &     * xyz_DelMass(i,j,k)
  1434: |||         !!$          xy_Snow(i,j) = xy_Snow(i,j) &
  1435: |||         !!$            & + ( xyz_QCloudIce(i,j,k) - QCloudIceTentative ) &
  1436: |||         !!$            &     / ( 2.0_DP * DelTime ) &
  1437: |||         !!$            &     * ( 2.0_DP * DelTime ) &
  1438: |||         !!$            &     * xyz_DelMass(i,j,k)
  1439: |||         !!$          xyz_QCloudWat(i,j,k) = xyz_QCloudWat(i,j,k) &
  1440: |||         !!$            & - ( xyz_QCloudWat(i,j,k) - QCloudWatTentative ) &
  1441: |||         !!$            &     / ( 2.0_DP * DelTime ) &
  1442: |||         !!$            &     * ( 2.0_DP * DelTime )
  1443: |||         !!$          xyz_QCloudIce(i,j,k) = xyz_QCloudIce(i,j,k) &
  1444: |||         !!$            & - ( xyz_QCloudIce(i,j,k) - QCloudIceTentative ) &
  1445: |||         !!$            &     / ( 2.0_DP * DelTime ) &
  1446: |||         !!$            &     * ( 2.0_DP * DelTime )
  1447: ||+----             end do
  1448: |+-----           end do
  1449: |           
  1450: |*W---->A         xy_Rain = xy_Rain + xyz_DQH2OLiqDtLSC(:,:,k) * xyz_DelMass(:,:,k)
  1451: |*W---- A         xy_Snow = xy_Snow + xyz_DQH2OSolDtLSC(:,:,k) * xyz_DelMass(:,:,k)
  1452: |           
  1453: |           
  1454: |                 ! Evaporation
  1455: |                 !
  1456: |W----->          do j = 1, jmax
  1457: ||*---->            do i = 0, imax-1
  1458: |||     A             if ( ( xyz_QCloudWat(i,j,k) < QCloudWaterEvapThreshold ) .and. &
  1459: |||                        ( xyz_QCloudIce(i,j,k) < QCloudWaterEvapThreshold ) ) then
  1460: |||     A               xyz_CloudCover(i,j,k) = 0.0_DP
  1461: |||                   end if
  1462: ||*----             end do
  1463: |W-----           end do
  1464: |           
  1465: |                 ! Cloud cover is restricted.
  1466: |W*==== A         xyz_CloudCover(:,:,k) = min( max( xyz_CloudCover(:,:,k), 0.0_DP ), 1.0_DP )
  1467: |           
  1468: |                 ! Check values
  1469: |+----->          do j = 1, jmax
  1470: ||+---->            do i = 0, imax-1
  1471: |||                   if ( xyz_QH2OVap(i,j,k) < 0.0_DP ) then
  1472: |||                     write( 6, * ) 'QH2OVap is negative', &
  1473: |||                       & i, j, k, xyz_QH2OVap(i,j,k)
  1474: |||                   end if
  1475: |||                   if ( xyz_QCloudWat(i,j,k) < 0.0_DP ) then
  1476: |||                     write( 6, * ) 'QCloudWat is negative', &
  1477: |||                       & i, j, k, xyz_QCloudWat(i,j,k)
  1478: |||                   end if
  1479: |||                   if ( xyz_QCloudIce  (i,j,k) < 0.0_DP ) then
  1480: |||                     write( 6, * ) 'QCloudIce is negative', &
  1481: |||                       & i, j, k, xyz_QCloudIce  (i,j,k)
  1482: |||                   end if
  1483: ||+----             end do
  1484: |+-----           end do
  1485: |           
  1486: +------         end do k_loop
  1487:             
  1488:             
  1489:                 ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
  1490:                 ! Large scale condensation (non-convective condensation)
  1491:                 ! (Manabe, 1965)
  1492:                 !
  1493:                 ! It should be noted that H2OLiq and H2OSol have updated in above
  1494:                 ! subroutine.
  1495:                 !
  1496:                 ! This routine is commented out, since this is done in an above k_loop.
  1497:             
  1498:             !!$    call LScaleCond1D3DWrapper(                            &
  1499:             !!$      & xyz_Temp, xyz_QH2OVap,          & ! (inout)
  1500:             !!$      & xyz_QCloudWat, & ! (inout)
  1501:             !!$      & xyz_QCloudIce, & ! (inout)
  1502:             !!$      & xyz_Press, xyr_Press,                              & ! (in)
  1503:             !!$      & xyz_DQH2OLiqDtLSC, xyz_DQH2OSolDtLSC               & ! (out)
  1504:             !!$      & )
  1505:             
  1506:             
  1507: *W----->A       xy_SurfRainFlux = xy_Rain
  1508: *W----- A       xy_SurfSnowFlux = xy_Snow
  1509:             
  1510:             
  1511:                 call CloudUtilConsChk(                                       &
  1512:                   & "CloudT1993baseWithIce",                                 &
  1513:             !!$      & FlagIncludeIcePhaseChange,                               &
  1514:             !!$      & .true.,                                                  &
  1515:                   & xyr_Press,                                               &
  1516:                   & xyz_TempB, xyz_QH2OVapB, xyz_QCloudWatB, xyz_QCloudIceB, &
  1517:                   & xyz_Temp , xyz_QH2OVap , xyz_QCloudWat , xyz_QCloudIce , &
  1518:                   & xy_SurfRainFlux, xy_SurfSnowFlux                         &
  1519:                   & )
  1520:             
  1521:             
  1522:               end subroutine CloudT1993baseWithIce
  1523:             
  1524:               !--------------------------------------------------------------------------------------
  1525:             
  1526:               subroutine CloudT1993baseInit( &
  1527:                 & ArgFlagSnow                &
  1528:                 & )
  1529:             
  1530:                 ! ファイル入出力補助
  1531:                 ! File I/O support
  1532:                 !
  1533:                 use dc_iounit, only: FileOpen
  1534:             
  1535:                 ! NAMELIST ファイル入力に関するユーティリティ
  1536:                 ! Utilities for NAMELIST file input
  1537:                 !
  1538:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1539:             
  1540:                 ! ヒストリデータ出力
  1541:                 ! History data output
  1542:                 !
  1543:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1544:             
  1545:                 ! 飽和比湿の算出
  1546:                 ! Evaluate saturation specific humidity
  1547:                 !
  1548:                 use saturate, only: SaturateInit
  1549:             
  1550:                 ! 大規模凝結 (非対流性凝結)
  1551:                 ! Large scale condensation (non-convective condensation)
  1552:                 !
  1553:                 use lscond, only : LScaleCondInit
  1554:             
  1555:             
  1556:                 ! 宣言文 ; Declaration statements
  1557:                 !
  1558:             
  1559:                 logical, intent(in) :: ArgFlagSnow
  1560:             
  1561:             
  1562:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1563:                                           ! Unit number for NAMELIST file open
  1564:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1565:                                           ! IOSTAT of NAMELIST read
  1566:             
  1567:                 ! NAMELIST 変数群
  1568:                 ! NAMELIST group name
  1569:                 !
  1570:                 namelist /cloud_T1993base_nml/ &
  1571:                   & RHThresholdCrtl,      &
  1572:                   & RHThresholdSigmaMin,  &
  1573:                   & RHThresholdOrd,       &
  1574:                   & CloudLifeTime0, &
  1575:                   & CloudWatLifeTime0, &
  1576:                   & CloudIceLifeTime0, &
  1577:                   & QCloudWatEffConv0, &
  1578:                   & QCloudIceEffConv0, &
  1579:                   & TempBFEffectSat,    &
  1580:                   & PRCPArea,           &
  1581:                   & PRCPEvapArea,       &
  1582:                   & PRCPColFactor
  1583:                       !
  1584:                       ! デフォルト値については初期化手続 "cloud_T1993base#CloudT1993baseInit"
  1585:                       ! のソースコードを参照のこと.
  1586:                       !
  1587:                       ! Refer to source codes in the initialization procedure
  1588:                       ! "cloud_T1993base#CloudT1993baseInit" for the default values.
  1589:                       !
  1590:             
  1591:                 ! 実行文 ; Executable statement
  1592:                 !
  1593:             
  1594:                 if ( cloud_T1993base_inited ) return
  1595:             
  1596:             
  1597:                 FlagSnow = ArgFlagSnow
  1598:             
  1599:             
  1600:                 ! デフォルト値の設定
  1601:                 ! Default values settings
  1602:                 !
  1603:                 RHThresholdCrtl      = 0.5_DP
  1604:             !!$    RHThresholdCrtl      = 0.8_DP ! ECMWF IFS
  1605:                 RHThresholdSigmaMin  = 1.0_DP
  1606:             !!$    RHThresholdSigmaMin  = 0.8_DP ! ECMWF IFS
  1607:                 RHThresholdOrd       = 2.0_DP ! ECMWF IFS
  1608:                 CloudLifeTime0       = 1000.0_DP
  1609:                 CloudWatLifeTime0    = 1000.0_DP
  1610:                 CloudIceLifeTime0    = 1000.0_DP
  1611:                 QCloudWatEffConv0    = 1.0e-4_DP
  1612:                 QCloudIceEffConv0    = 1.0e-3_DP
  1613:                 TempBFEffectSat      = 250.0_DP
  1614:                   !   This value follows that by IFS CY38r1
  1615:                   !   (p.82 of http://www.ecmwf.int/research/ifsdocs/CY38r1/IFSPart4.pdf)
  1616:                   !   Actually, IFS CY38r1 uses 250.16 K.
  1617:                 PRCPArea            = 1.0_DP
  1618:             !!$    PRCPArea            = 0.5_DP
  1619:                 PRCPEvapArea        = 1.0_DP
  1620:             
  1621:                 PRCPColFactor       = 300.0_DP
  1622:                                       ! This value comes from Sundqvist et al. (1989)
  1623:                                       ! IFS CY38r1 uses 100, but in addition , 
  1624:                                       ! precipitation area has to be considered.
  1625:             
  1626:                 ! NAMELIST の読み込み
  1627:                 ! NAMELIST is input
  1628:                 !
  1629:                 if ( trim(namelist_filename) /= '' ) then
  1630:                   call FileOpen( unit_nml, &          ! (out)
  1631:                     & namelist_filename, mode = 'r' ) ! (in)
  1632:             
  1633:                   rewind( unit_nml )
  1634:                   read( unit_nml,                     & ! (in)
  1635:                     & nml = cloud_T1993base_nml,      & ! (out)
  1636:                     & iostat = iostat_nml )             ! (out)
  1637:                   close( unit_nml )
  1638:             
  1639:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1640:                 end if
  1641:             
  1642:             
  1643:                 ! Initialization of modules used in this module
  1644:                 !
  1645:             
  1646:                 ! 飽和比湿の算出
  1647:                 ! Evaluate saturation specific humidity
  1648:                 !
  1649:                 call SaturateInit
  1650:             
  1651:                 ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
  1652:                 ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
  1653:                 !
  1654:                 call LScaleCondInit( &
  1655:                   & FlagSnow &
  1656:                   & )
  1657:             
  1658:             
  1659:                 ! ヒストリデータ出力のためのへの変数登録
  1660:                 ! Register of variables for history data output
  1661:                 !
  1662:             !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
  1663:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
  1664:             !!$      & 'effective cloud cover', '1' )
  1665:             
  1666:             
  1667:             
  1668:                 ! 印字 ; Print
  1669:                 !
  1670:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1671:                 call MessageNotify( 'M', module_name, 'RHThresholdCrtl      = %f', d = (/ RHThresholdCrtl /) )
  1672:                 call MessageNotify( 'M', module_name, 'RHThresholdSigmaMin  = %f', d = (/ RHThresholdSigmaMin /) )
  1673:                 call MessageNotify( 'M', module_name, 'RHThresholdOrd       = %f', d = (/ RHThresholdOrd /) )
  1674:                 call MessageNotify( 'M', module_name, 'CloudLifeTime0       = %f', d = (/ CloudLifeTime0 /) )
  1675:                 call MessageNotify( 'M', module_name, 'CloudIceLifeTime0    = %f', d = (/ CloudIceLifeTime0 /) )
  1676:                 call MessageNotify( 'M', module_name, 'CloudWatLifeTime0    = %f', d = (/ CloudWatLifeTime0 /) )
  1677:                 call MessageNotify( 'M', module_name, 'QCloudWatEffConv0    = %f', d = (/ QCloudWatEffConv0 /) )
  1678:                 call MessageNotify( 'M', module_name, 'QCloudIceEffConv0    = %f', d = (/ QCloudIceEffConv0 /) )
  1679:                 call MessageNotify( 'M', module_name, 'TempBFEffectSat      = %f', d = (/ TempBFEffectSat /) )
  1680:                 call MessageNotify( 'M', module_name, 'PRCPArea            = %f', d = (/ PRCPArea /) )
  1681:                 call MessageNotify( 'M', module_name, 'PRCPEvapArea        = %f', d = (/ PRCPEvapArea /) )
  1682:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1683:             
  1684:             
  1685:                 cloud_T1993base_inited = .true.
  1686:             
  1687:               end subroutine CloudT1993baseInit
  1688:             
  1689:               !--------------------------------------------------------------------------------------
  1690:             
  1691:             end module cloud_T1993base
